/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java;

import java.awt.Image;
import javax.swing.ImageIcon;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerRenderer;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.swing.renderer.JavaNameRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.openide.util.ImageUtilities;

public class InstanceNodeRenderer
extends JavaNameRenderer
implements HeapViewerRenderer {
    private static final ImageIcon ICON_INSTANCE = Icons.getImageIcon((String)"LanguageIcons.Instance");
    private static final ImageIcon ICON_ARRAY = Icons.getImageIcon((String)"LanguageIcons.Array");
    private static final Image IMAGE_LOOP = Icons.getImage((String)"HeapWalkerIcons.Loop");

    public InstanceNodeRenderer(Heap heap) {
    }

    public void setValue(Object value, int row) {
        if (value == null) {
            super.setValue(null, row);
            return;
        }
        InstanceNode node = (InstanceNode)((Object)value);
        String name = node.getName();
        if (name != null && !"null".equals(name)) {
            super.setValue((Object)name, row);
        } else {
            super.setValue(null, row);
            super.setNormalValue("null");
        }
        String log = node.getLogicalValue();
        if (log != null && !log.isEmpty()) {
            this.setGrayValue(" : " + log);
        }
        ImageIcon icon = this.getIcon(node.getInstance(), node.isGCRoot());
        this.setIcon(icon);
        this.setIconTextGap(1);
        ((LabelRenderer)this.valueRenderers()[0]).setMargin(3, 0, 3, 0);
    }

    public void flagLoopTo() {
        ImageIcon icon = (ImageIcon)this.getIcon();
        icon = new ImageIcon(ImageUtilities.mergeImages((Image)icon.getImage(), (Image)IMAGE_LOOP, (int)0, (int)0));
        this.setIcon(icon);
        this.setIconTextGap(4);
        ((LabelRenderer)this.valueRenderers()[0]).setMargin(3, 1, 3, 0);
    }

    @Override
    public String getShortName() {
        return this.getBoldValue();
    }

    protected boolean supportsCustomGrayForeground() {
        return false;
    }

    protected ImageIcon getIcon(Instance instance, boolean isGCRoot) {
        return instance == null || !instance.getJavaClass().isArray() ? ICON_INSTANCE : ICON_ARRAY;
    }
}

