/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.jnlp.BasicService;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.config.BasicValueValidators;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.runtime.html.browser.LinkingBrowser;
import net.sourceforge.jnlp.util.StreamUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

class XBasicService
implements BasicService {
    protected XBasicService() {
    }

    @Override
    public URL getCodeBase() {
        ApplicationInstance app = JNLPRuntime.getApplication();
        if (app != null) {
            JNLPFile file = app.getJNLPFile();
            if (file.getCodeBase() != null) {
                return file.getCodeBase();
            }
            JARDesc mainJar = file.getResources().getMainJAR();
            if (mainJar != null) {
                return mainJar.getLocation();
            }
        }
        return null;
    }

    @Override
    public boolean isOffline() {
        URL url = this.findFirstURLFromJNLPFile();
        JNLPRuntime.detectOnline(url);
        return !JNLPRuntime.isOnline();
    }

    private URL findFirstURLFromJNLPFile() {
        URL arbitraryURL;
        ApplicationInstance app = JNLPRuntime.getApplication();
        if (app != null) {
            JNLPFile jnlpFile = app.getJNLPFile();
            URL sourceURL = jnlpFile.getSourceLocation();
            if (sourceURL != null) {
                return sourceURL;
            }
            URL codeBaseURL = jnlpFile.getCodeBase();
            if (codeBaseURL != null) {
                return codeBaseURL;
            }
            InformationDesc informationDesc = jnlpFile.getInformation();
            URL homePage = informationDesc.getHomepage();
            if (homePage != null) {
                return homePage;
            }
            int n = 0;
            JARDesc[] jarDescs = jnlpFile.getResources().getJARs();
            JARDesc[] jARDescArray = jarDescs;
            int n2 = jARDescArray.length;
            if (n < n2) {
                JARDesc jarDesc = jARDescArray[n];
                return jarDesc.getLocation();
            }
        }
        try {
            arbitraryURL = new URL("http://icedtea.classpath.org");
        }
        catch (MalformedURLException malformedURL) {
            throw new RuntimeException(malformedURL);
        }
        return arbitraryURL;
    }

    @Override
    public boolean isWebBrowserSupported() {
        return true;
    }

    @Override
    public boolean showDocument(URL url) {
        try {
            String urls = url.toExternalForm();
            OutputController.getLogger().log("showDocument for: " + urls);
            DeploymentConfiguration config = JNLPRuntime.getConfiguration();
            String command = config.getProperty("deployment.browser.path");
            if (command != null) {
                OutputController.getLogger().log("deployment.browser.path located. Using: " + command);
                return this.exec(command, urls);
            }
            if (System.getenv("BROWSER") != null) {
                command = System.getenv("BROWSER");
                OutputController.getLogger().log("variable BROWSER located. Using: " + command);
                return this.exec(command, urls);
            }
            if (JNLPRuntime.isHeadless() || !Desktop.isDesktopSupported()) {
                command = this.promptForCommand(urls, false);
                return this.exec(command, urls);
            }
            if (Desktop.isDesktopSupported()) {
                OutputController.getLogger().log("using default browser");
                Desktop.getDesktop().browse(url.toURI());
                return true;
            }
            OutputController.getLogger().log("dont know what to do");
            return false;
        }
        catch (Exception e) {
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, e.toString());
            OutputController.getLogger().log(e);
            return false;
        }
    }

    private boolean exec(String cmd, String url) {
        try {
            if (cmd == null || cmd.length() == 0) {
                return false;
            }
            if (url == null || url.length() == 0) {
                return false;
            }
            if (cmd.equals("ALWAYS-ASK")) {
                cmd = this.promptForCommand(url, true);
            }
            if (cmd.equals("INTERNAL-HTML")) {
                LinkingBrowser.createFrame(url, false, 2);
                return true;
            }
            StringTokenizer st = new StringTokenizer(cmd + " " + url);
            String[] cmdarray = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                cmdarray[i] = st.nextToken();
                ++i;
            }
            ProcessBuilder pb = new ProcessBuilder(cmdarray);
            pb.inheritIO();
            Process p = pb.start();
            StreamUtils.waitForSafely(p);
            return p.exitValue() == 0;
        }
        catch (Exception e) {
            OutputController.getLogger().log(e);
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, e.toString());
            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.VVPossibleBrowserValues());
            return false;
        }
    }

    private String promptForCommand(String targetUrl, boolean aa) throws IOException {
        String message = Translator.VVPossibleBrowserValues();
        String title = Translator.R("RBrowserLocationPromptTitle");
        if (JNLPRuntime.isHeadless()) {
            OutputController.getLogger().printOutLn(message);
            OutputController.getLogger().printOutLn("*** " + targetUrl + " ***");
            OutputController.getLogger().printOutLn(title);
            String entered = OutputController.getLogger().readLine();
            String verification = BasicValueValidators.verifyFileOrCommand(entered);
            if (verification == null) {
                OutputController.getLogger().printOutLn(Translator.R("VVBrowserVerificationFail"));
            } else {
                OutputController.getLogger().printOutLn(Translator.R("VVBrowserVerificationPass", verification));
            }
            return entered;
        }
        PromptUrl pu = new PromptUrl();
        pu.arrange(targetUrl, aa);
        pu.setVisible(true);
        return pu.getValue();
    }

    private static class PromptUrl
    extends JDialog {
        JTextField value = new JTextField("firefox");
        JLabel verification = new JLabel("?");
        private WindowListener cl = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                value.setText("");
            }
        };
        JCheckBox save = new JCheckBox(Translator.R("PESaveChanges"));
        private boolean ask;

        public PromptUrl() {
            super((Dialog)null, Translator.R("RBrowserLocationPromptTitle"), true);
        }

        public void arrange(String url, boolean ask) {
            this.ask = ask;
            JPanel top = new JPanel(new GridLayout(2, 1));
            JPanel bottom = new JPanel(new GridLayout(5, 1));
            this.setLayout(new BorderLayout());
            this.add((Component)top, "North");
            this.add((Component)bottom, "South");
            top.add(new JLabel("<html><b>" + Translator.R("RBrowserLocationPromptTitle")));
            JTextField urlField = new JTextField(url);
            urlField.setEditable(false);
            top.add(urlField);
            JTextArea ta = new JTextArea(Translator.VVPossibleBrowserValues());
            ta.setEditable(false);
            ta.setLineWrap(true);
            ta.setWrapStyleWord(false);
            JScrollPane scrollableTa = new JScrollPane(ta);
            scrollableTa.setHorizontalScrollBar(null);
            this.add(scrollableTa);
            bottom.add(this.value);
            bottom.add(this.verification);
            JButton ok = new JButton(Translator.R("ButOk"));
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (save.isSelected()) {
                        JNLPRuntime.getConfiguration().setProperty("deployment.browser.path", value.getText());
                        try {
                            JNLPRuntime.getConfiguration().save();
                        }
                        catch (IOException ex) {
                            OutputController.getLogger().log(ex);
                        }
                    }
                    this.dispose();
                }
            });
            JButton cancel = new JButton(Translator.R("ButCancel"));
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    cl.windowClosing(null);
                    this.dispose();
                }
            });
            bottom.add(this.save);
            bottom.add(ok);
            bottom.add(cancel);
            if (this.ask) {
                this.save.setSelected(false);
                this.save.setEnabled(false);
                this.save.setToolTipText(Translator.R("VVBrowserSaveNotAllowed", "ALWAYS-ASK", "deployment.browser.path"));
            } else {
                this.save.setEnabled(true);
                this.save.setToolTipText(Translator.R("VVBrowserSaveAllowed", "deployment.browser.path"));
            }
            this.addWindowListener(this.cl);
            this.value.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.check();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.check();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.check();
                }

                private void check() {
                    String result = BasicValueValidators.verifyFileOrCommand(value.getText());
                    if (result == null) {
                        verification.setForeground(Color.red);
                        verification.setText(Translator.R("VVBrowserVerificationFail"));
                        if (!ask) {
                            save.setSelected(false);
                        }
                    } else {
                        verification.setForeground(Color.green);
                        verification.setText(Translator.R("VVBrowserVerificationPass", result));
                        if (!ask) {
                            save.setSelected(true);
                        }
                    }
                }
            });
            this.pack();
            this.setSize(500, 400);
        }

        private String getValue() {
            if (this.value.getText().trim().isEmpty()) {
                return null;
            }
            return this.value.getText();
        }
    }
}

