/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.opengl;

import java.awt.Composite;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveMgr;
import sun.java2d.loops.SurfaceType;
import sun.java2d.opengl.OGLAnyCompositeBlit;
import sun.java2d.opengl.OGLBufImgOps;
import sun.java2d.opengl.OGLContext;
import sun.java2d.opengl.OGLGeneralBlit;
import sun.java2d.opengl.OGLGeneralTransformedBlit;
import sun.java2d.opengl.OGLGraphicsConfig;
import sun.java2d.opengl.OGLRTTSurfaceToSurfaceBlit;
import sun.java2d.opengl.OGLRTTSurfaceToSurfaceScale;
import sun.java2d.opengl.OGLRTTSurfaceToSurfaceTransform;
import sun.java2d.opengl.OGLRenderQueue;
import sun.java2d.opengl.OGLSurfaceData;
import sun.java2d.opengl.OGLSurfaceToSurfaceBlit;
import sun.java2d.opengl.OGLSurfaceToSurfaceScale;
import sun.java2d.opengl.OGLSurfaceToSurfaceTransform;
import sun.java2d.opengl.OGLSurfaceToSwBlit;
import sun.java2d.opengl.OGLSwToSurfaceBlit;
import sun.java2d.opengl.OGLSwToSurfaceScale;
import sun.java2d.opengl.OGLSwToSurfaceTransform;
import sun.java2d.opengl.OGLSwToTextureBlit;
import sun.java2d.opengl.OGLTextureToSurfaceBlit;
import sun.java2d.opengl.OGLTextureToSurfaceScale;
import sun.java2d.opengl.OGLTextureToSurfaceTransform;
import sun.java2d.pipe.Region;
import sun.java2d.pipe.RenderBuffer;
import sun.java2d.pipe.RenderQueue;

final class OGLBlitLoops {
    private static final int OFFSET_SRCTYPE = 16;
    private static final int OFFSET_HINT = 8;
    private static final int OFFSET_TEXTURE = 3;
    private static final int OFFSET_RTT = 2;
    private static final int OFFSET_XFORM = 1;
    private static final int OFFSET_ISOBLIT = 0;

    OGLBlitLoops() {
    }

    static void register() {
        OGLSwToSurfaceBlit blitIntArgbPreToSurface = new OGLSwToSurfaceBlit(SurfaceType.IntArgbPre, 1);
        OGLSwToTextureBlit blitIntArgbPreToTexture = new OGLSwToTextureBlit(SurfaceType.IntArgbPre, 1);
        OGLSwToSurfaceTransform transformBlitIntArgbPreToSurface = new OGLSwToSurfaceTransform(SurfaceType.IntArgbPre, 1);
        GraphicsPrimitive[] primitives = new GraphicsPrimitive[]{new OGLSurfaceToSurfaceBlit(), new OGLSurfaceToSurfaceScale(), new OGLSurfaceToSurfaceTransform(), new OGLRTTSurfaceToSurfaceBlit(), new OGLRTTSurfaceToSurfaceScale(), new OGLRTTSurfaceToSurfaceTransform(), new OGLSurfaceToSwBlit(SurfaceType.IntArgb, 0), new OGLSurfaceToSwBlit(SurfaceType.IntArgbPre, 1), blitIntArgbPreToSurface, new OGLSwToSurfaceBlit(SurfaceType.IntRgb, 2), new OGLSwToSurfaceBlit(SurfaceType.IntRgbx, 3), new OGLSwToSurfaceBlit(SurfaceType.IntBgr, 4), new OGLSwToSurfaceBlit(SurfaceType.IntBgrx, 5), new OGLSwToSurfaceBlit(SurfaceType.ThreeByteBgr, 11), new OGLSwToSurfaceBlit(SurfaceType.Ushort565Rgb, 6), new OGLSwToSurfaceBlit(SurfaceType.Ushort555Rgb, 7), new OGLSwToSurfaceBlit(SurfaceType.Ushort555Rgbx, 8), new OGLSwToSurfaceBlit(SurfaceType.ByteGray, 9), new OGLSwToSurfaceBlit(SurfaceType.UshortGray, 10), new OGLGeneralBlit(OGLSurfaceData.OpenGLSurface, CompositeType.AnyAlpha, blitIntArgbPreToSurface), new OGLAnyCompositeBlit(), new OGLSwToSurfaceScale(SurfaceType.IntRgb, 2), new OGLSwToSurfaceScale(SurfaceType.IntRgbx, 3), new OGLSwToSurfaceScale(SurfaceType.IntBgr, 4), new OGLSwToSurfaceScale(SurfaceType.IntBgrx, 5), new OGLSwToSurfaceScale(SurfaceType.ThreeByteBgr, 11), new OGLSwToSurfaceScale(SurfaceType.Ushort565Rgb, 6), new OGLSwToSurfaceScale(SurfaceType.Ushort555Rgb, 7), new OGLSwToSurfaceScale(SurfaceType.Ushort555Rgbx, 8), new OGLSwToSurfaceScale(SurfaceType.ByteGray, 9), new OGLSwToSurfaceScale(SurfaceType.UshortGray, 10), new OGLSwToSurfaceScale(SurfaceType.IntArgbPre, 1), new OGLSwToSurfaceTransform(SurfaceType.IntRgb, 2), new OGLSwToSurfaceTransform(SurfaceType.IntRgbx, 3), new OGLSwToSurfaceTransform(SurfaceType.IntBgr, 4), new OGLSwToSurfaceTransform(SurfaceType.IntBgrx, 5), new OGLSwToSurfaceTransform(SurfaceType.ThreeByteBgr, 11), new OGLSwToSurfaceTransform(SurfaceType.Ushort565Rgb, 6), new OGLSwToSurfaceTransform(SurfaceType.Ushort555Rgb, 7), new OGLSwToSurfaceTransform(SurfaceType.Ushort555Rgbx, 8), new OGLSwToSurfaceTransform(SurfaceType.ByteGray, 9), new OGLSwToSurfaceTransform(SurfaceType.UshortGray, 10), transformBlitIntArgbPreToSurface, new OGLGeneralTransformedBlit(transformBlitIntArgbPreToSurface), new OGLTextureToSurfaceBlit(), new OGLTextureToSurfaceScale(), new OGLTextureToSurfaceTransform(), blitIntArgbPreToTexture, new OGLSwToTextureBlit(SurfaceType.IntRgb, 2), new OGLSwToTextureBlit(SurfaceType.IntRgbx, 3), new OGLSwToTextureBlit(SurfaceType.IntBgr, 4), new OGLSwToTextureBlit(SurfaceType.IntBgrx, 5), new OGLSwToTextureBlit(SurfaceType.ThreeByteBgr, 11), new OGLSwToTextureBlit(SurfaceType.Ushort565Rgb, 6), new OGLSwToTextureBlit(SurfaceType.Ushort555Rgb, 7), new OGLSwToTextureBlit(SurfaceType.Ushort555Rgbx, 8), new OGLSwToTextureBlit(SurfaceType.ByteGray, 9), new OGLSwToTextureBlit(SurfaceType.UshortGray, 10), new OGLGeneralBlit(OGLSurfaceData.OpenGLTexture, CompositeType.SrcNoEa, blitIntArgbPreToTexture)};
        GraphicsPrimitiveMgr.register(primitives);
    }

    private static int createPackedParams(boolean isoblit, boolean texture, boolean rtt, boolean xform, int hint, int srctype) {
        return srctype << 16 | hint << 8 | (texture ? 1 : 0) << 3 | (rtt ? 1 : 0) << 2 | (xform ? 1 : 0) << 1 | (isoblit ? 1 : 0) << 0;
    }

    private static void enqueueBlit(RenderQueue rq, SurfaceData src, SurfaceData dst, int packedParams, int sx1, int sy1, int sx2, int sy2, double dx1, double dy1, double dx2, double dy2) {
        RenderBuffer buf = rq.getBuffer();
        rq.ensureCapacityAndAlignment(72, 24);
        buf.putInt(31);
        buf.putInt(packedParams);
        buf.putInt(sx1).putInt(sy1);
        buf.putInt(sx2).putInt(sy2);
        buf.putDouble(dx1).putDouble(dy1);
        buf.putDouble(dx2).putDouble(dy2);
        buf.putLong(src.getNativeOps());
        buf.putLong(dst.getNativeOps());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void Blit(SurfaceData srcData, SurfaceData dstData, Composite comp, Region clip, AffineTransform xform, int hint, int sx1, int sy1, int sx2, int sy2, double dx1, double dy1, double dx2, double dy2, int srctype, boolean texture) {
        int ctxflags = 0;
        if (srcData.getTransparency() == 1) {
            ctxflags |= 1;
        }
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            rq.addReference(srcData);
            OGLSurfaceData oglDst = (OGLSurfaceData)dstData;
            if (texture) {
                OGLGraphicsConfig gc = oglDst.getOGLGraphicsConfig();
                OGLContext.setScratchSurface(gc);
            } else {
                OGLContext.validateContext(oglDst, oglDst, clip, comp, xform, null, null, ctxflags);
            }
            int packedParams = OGLBlitLoops.createPackedParams(false, texture, false, xform != null, hint, srctype);
            OGLBlitLoops.enqueueBlit(rq, srcData, dstData, packedParams, sx1, sy1, sx2, sy2, dx1, dy1, dx2, dy2);
            rq.flushNow();
        }
        finally {
            rq.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void IsoBlit(SurfaceData srcData, SurfaceData dstData, BufferedImage srcImg, BufferedImageOp biop, Composite comp, Region clip, AffineTransform xform, int hint, int sx1, int sy1, int sx2, int sy2, double dx1, double dy1, double dx2, double dy2, boolean texture) {
        int ctxflags = 0;
        if (srcData.getTransparency() == 1) {
            ctxflags |= 1;
        }
        OGLRenderQueue rq = OGLRenderQueue.getInstance();
        rq.lock();
        try {
            OGLSurfaceData srcCtxData;
            boolean rtt;
            OGLSurfaceData oglSrc = (OGLSurfaceData)srcData;
            OGLSurfaceData oglDst = (OGLSurfaceData)dstData;
            int srctype = oglSrc.getType();
            if (srctype == 3) {
                rtt = false;
                srcCtxData = oglDst;
            } else {
                rtt = true;
                srcCtxData = srctype == 5 ? oglDst : oglSrc;
            }
            OGLContext.validateContext(srcCtxData, oglDst, clip, comp, xform, null, null, ctxflags);
            if (biop != null) {
                OGLBufImgOps.enableBufImgOp(rq, oglSrc, srcImg, biop);
            }
            int packedParams = OGLBlitLoops.createPackedParams(true, texture, rtt, xform != null, hint, 0);
            OGLBlitLoops.enqueueBlit(rq, srcData, dstData, packedParams, sx1, sy1, sx2, sy2, dx1, dy1, dx2, dy2);
            if (biop != null) {
                OGLBufImgOps.disableBufImgOp(rq, biop);
            }
            if (rtt && oglDst.isOnScreen()) {
                rq.flushNow();
            }
        }
        finally {
            rq.unlock();
        }
    }
}

