/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.misc.HexDumpEncoder;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.internal.ETypeInfo;
import sun.security.krb5.internal.ETypeInfo2;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class PAData {
    private int pADataType;
    private byte[] pADataValue = null;
    private static final byte TAG_PATYPE = 1;
    private static final byte TAG_PAVALUE = 2;

    private PAData() {
    }

    public PAData(int new_pADataType, byte[] new_pADataValue) {
        this.pADataType = new_pADataType;
        if (new_pADataValue != null) {
            this.pADataValue = (byte[])new_pADataValue.clone();
        }
    }

    public Object clone() {
        PAData new_pAData = new PAData();
        new_pAData.pADataType = this.pADataType;
        if (this.pADataValue != null) {
            new_pAData.pADataValue = new byte[this.pADataValue.length];
            System.arraycopy(this.pADataValue, 0, new_pAData.pADataValue, 0, this.pADataValue.length);
        }
        return new_pAData;
    }

    public PAData(DerValue encoding) throws Asn1Exception, IOException {
        DerValue der = null;
        if (encoding.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.pADataType = der.getData().getBigInteger().intValue();
        der = encoding.getData().getDerValue();
        if ((der.getTag() & 0x1F) == 2) {
            this.pADataValue = der.getData().getOctetString();
        }
        if (encoding.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(this.pADataType);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        temp = new DerOutputStream();
        temp.putOctetString(this.pADataValue);
        bytes.write(DerValue.createTag((byte)-128, true, (byte)2), temp);
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }

    public int getType() {
        return this.pADataType;
    }

    public byte[] getValue() {
        return this.pADataValue == null ? null : (byte[])this.pADataValue.clone();
    }

    public static int getPreferredEType(PAData[] pas, int defaultEType) throws IOException, Asn1Exception {
        DerValue value;
        if (pas == null) {
            return defaultEType;
        }
        DerValue d = null;
        DerValue d2 = null;
        block4: for (PAData p : pas) {
            if (p.getValue() == null) continue;
            switch (p.getType()) {
                case 11: {
                    d = new DerValue(p.getValue());
                    continue block4;
                }
                case 19: {
                    d2 = new DerValue(p.getValue());
                }
            }
        }
        if (d2 != null) {
            while (d2.data.available() > 0) {
                value = d2.data.getDerValue();
                ETypeInfo2 tmp = new ETypeInfo2(value);
                if (!EType.isNewer(tmp.getEType()) && tmp.getParams() != null) continue;
                return tmp.getEType();
            }
        }
        if (d != null && d.data.available() > 0) {
            value = d.data.getDerValue();
            ETypeInfo tmp = new ETypeInfo(value);
            return tmp.getEType();
        }
        return defaultEType;
    }

    public static SaltAndParams getSaltAndParams(int eType, PAData[] pas) throws Asn1Exception, IOException {
        DerValue value;
        if (pas == null) {
            return null;
        }
        DerValue d = null;
        DerValue d2 = null;
        String paPwSalt = null;
        block5: for (PAData p : pas) {
            if (p.getValue() == null) continue;
            switch (p.getType()) {
                case 3: {
                    paPwSalt = new String(p.getValue(), KerberosString.MSNAME ? "UTF8" : "8859_1");
                    continue block5;
                }
                case 11: {
                    d = new DerValue(p.getValue());
                    continue block5;
                }
                case 19: {
                    d2 = new DerValue(p.getValue());
                }
            }
        }
        if (d2 != null) {
            while (d2.data.available() > 0) {
                value = d2.data.getDerValue();
                ETypeInfo2 tmp = new ETypeInfo2(value);
                if (tmp.getEType() != eType || !EType.isNewer(eType) && tmp.getParams() != null) continue;
                return new SaltAndParams(tmp.getSalt(), tmp.getParams());
            }
        }
        if (d != null) {
            while (d.data.available() > 0) {
                value = d.data.getDerValue();
                ETypeInfo tmp = new ETypeInfo(value);
                if (tmp.getEType() != eType) continue;
                return new SaltAndParams(tmp.getSalt(), null);
            }
        }
        if (paPwSalt != null) {
            return new SaltAndParams(paPwSalt, null);
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(">>>Pre-Authentication Data:\n\t PA-DATA type = ").append(this.pADataType).append('\n');
        switch (this.pADataType) {
            case 2: {
                sb.append("\t PA-ENC-TIMESTAMP");
                break;
            }
            case 11: {
                if (this.pADataValue == null) break;
                try {
                    DerValue der = new DerValue(this.pADataValue);
                    while (der.data.available() > 0) {
                        DerValue value = der.data.getDerValue();
                        ETypeInfo info = new ETypeInfo(value);
                        sb.append("\t PA-ETYPE-INFO etype = ").append(info.getEType()).append(", salt = ").append(info.getSalt()).append('\n');
                    }
                    break;
                }
                catch (IOException | Asn1Exception e) {
                    sb.append("\t <Unparseable PA-ETYPE-INFO>\n");
                    break;
                }
            }
            case 19: {
                if (this.pADataValue == null) break;
                try {
                    DerValue der = new DerValue(this.pADataValue);
                    while (der.data.available() > 0) {
                        DerValue value = der.data.getDerValue();
                        ETypeInfo2 info2 = new ETypeInfo2(value);
                        sb.append("\t PA-ETYPE-INFO2 etype = ").append(info2.getEType()).append(", salt = ").append(info2.getSalt()).append(", s2kparams = ");
                        byte[] s2kparams = info2.getParams();
                        if (s2kparams == null) {
                            sb.append("null\n");
                            continue;
                        }
                        if (s2kparams.length == 0) {
                            sb.append("empty\n");
                            continue;
                        }
                        sb.append(new HexDumpEncoder().encodeBuffer(s2kparams));
                    }
                    break;
                }
                catch (IOException | Asn1Exception e) {
                    sb.append("\t <Unparseable PA-ETYPE-INFO>\n");
                    break;
                }
            }
        }
        return sb.toString();
    }

    public static class SaltAndParams {
        public final String salt;
        public final byte[] params;

        public SaltAndParams(String s, byte[] p) {
            if (s != null && s.isEmpty()) {
                s = null;
            }
            this.salt = s;
            this.params = p;
        }
    }
}

