/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_bs extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_tl = "tagalog";
        final String metaValue_chr = "\u010deroki";
        final Object[][] data = new Object[][] {
            { "ksh", "kelnski" },
            { "Ogam", "ogham pismo" },
            { "mwl", "mirande\u0161ki" },
            { "Zsym", "simboli" },
            { "cch", "atsam" },
            { "mwr", "marvari" },
            { "Tagb", "tagbanva pismo" },
            { "Zsye", "emoji sli\u010dice" },
            { "%%NJIVA", "Gnjiva/Njiva dijalekt" },
            { "ccp", "\u010dakma" },
            { "egy", "staroegipatski" },
            { "raj", "rajastani" },
            { "Phag", "phags-pa pismo" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Ostrvo Ascension" },
            { "rar", "rarotongan" },
            { "tet", "tetum" },
            { "AD", "Andora" },
            { "AE", "Ujedinjeni Arapski Emirati" },
            { "nl_BE", "flamanski" },
            { "AF", "Afganistan" },
            { "AG", "Antigva i Barbuda" },
            { "type.ca.ethiopic", "etiopski kalendar" },
            { "AI", "Angvila" },
            { "key.tz", "Vremenska zona" },
            { "AL", "Albanija" },
            { "AM", "Armenija" },
            { "Teng", "tengvar pismo" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentina" },
            { "Prti", "pisani partian" },
            { "AS", "Ameri\u010dka Samoa" },
            { "AT", "Austrija" },
            { "AU", "Australija" },
            { "AW", "Aruba" },
            { "AX", "Olandska ostrva" },
            { "mye", "mjene" },
            { "AZ", "Azerbejd\u017ean" },
            { "%%AREVELA", "Isto\u010dni jermenski" },
            { "BA", "Bosna i Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Banglade\u0161" },
            { "kum", "kumik" },
            { "BE", "Belgija" },
            { "gmh", "srednjovjekovni gornjonjema\u010dki" },
            { "BF", "Burkina Faso" },
            { "BG", "Bugarska" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sveti Bartolomej" },
            { "BM", "Bermuda" },
            { "kut", "kutenai" },
            { "myv", "erzija" },
            { "BN", "Brunej" },
            { "BO", "Bolivija" },
            { "BQ", "Karipska Holandija" },
            { "BR", "Brazil" },
            { "BS", "Bahami" },
            { "xog", "soga" },
            { "BT", "Butan" },
            { "BV", "Ostrvo Buve" },
            { "BW", "Bocvana" },
            { "BY", "Bjelorusija" },
            { "BZ", "Belize" },
            { "Visp", "vidljivi govor" },
            { "type.ca.persian", "perzijski kalendar" },
            { "type.nu.hebr", "hebrejski brojevi" },
            { "CA", "Kanada" },
            { "CC", "Kokosova (Keelingova) ostrva" },
            { "mzn", "mazanderanski" },
            { "CD", "Demokratska Republika Kongo" },
            { "CF", "Centralnoafri\u010dka Republika" },
            { "CG", "Kongo" },
            { "CH", "\u0160vicarska" },
            { "CI", "Obala Slonova\u010de" },
            { "CK", "Kukova ostrva" },
            { "CL", "\u010cile" },
            { "Kthi", "kai\u0107ansko pismo" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Kolumbija" },
            { "CP", "Ostrvo Clipperton" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Zelenortska Ostrva" },
            { "CW", "Kurasao" },
            { "CX", "Bo\u017ei\u0107no ostrvo" },
            { "CY", "Kipar" },
            { "CZ", "\u010ce\u0161ka" },
            { "eka", "ekajuk" },
            { "DE", "Njema\u010dka" },
            { "goh", "staronjema\u010dki" },
            { "ace", "a\u010dinski" },
            { "cgg", "\u010diga" },
            { "DG", "Dijego Garsija" },
            { "type.nu.deva", "brojevi pisma devanagari" },
            { "DJ", "D\u017eibuti" },
            { "DK", "Danska" },
            { "ach", "akoli" },
            { "gon", "gondi" },
            { "Brai", "brajevo pismo" },
            { "Brah", "bramansko pismo" },
            { "DM", "Dominika" },
            { "type.nu.armnlow", "mali armenski brojevi" },
            { "DO", "Dominikanska Republika" },
            { "gor", "gorontalo" },
            { "got", "gotski" },
            { "Mtei", "meitei majek pismo" },
            { "zun", "zuni" },
            { "tig", "tigre" },
            { "Takr", "takri pismo" },
            { "DZ", "Al\u017eir" },
            { "pag", "pangasinski" },
            { "type.d0.hwidth", "Uski" },
            { "pal", "pahlavi" },
            { "EA", "Seuta i Melilja" },
            { "chb", "\u010dib\u010da" },
            { "pam", "pampanga" },
            { "EC", "Ekvador" },
            { "pap", "papiamento" },
            { "ada", "adangmejski" },
            { "EE", "Estonija" },
            { "tiv", "tiv" },
            { "EG", "Egipat" },
            { "EH", "Zapadna Sahara" },
            { "chg", "\u010dagatai" },
            { "pau", "palauanski" },
            { "chk", "\u010dukeski" },
            { "chn", "\u010dinukski \u017eargon" },
            { "chm", "mari" },
            { "chp", "\u010dipvijanski" },
            { "cho", "\u010doktav" },
            { "chr", metaValue_chr },
            { "ER", "Eritreja" },
            { "ES", "\u0160panija" },
            { "ET", "Etiopija" },
            { "EU", "Evropska unija" },
            { "elx", "elamitski" },
            { "type.ca.gregorian", "gregorijanski kalendar" },
            { "EZ", "Eurozona" },
            { "chy", "\u010dejenski" },
            { "type.nu.gujr", "brojevi pisma gud\u017earati" },
            { "Inds", "indu\u0161ko ismo" },
            { "ady", "adigejski" },
            { "FI", "Finska" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Folklandska ostrva" },
            { "FM", "Mikronezija" },
            { "key.va", "Varijanta zemlje/jezika" },
            { "FO", "Farska ostrva" },
            { "Taml", "tamilsko pismo" },
            { "FR", "Francuska" },
            { "Kpel", "kpelle pismo" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "type.ca.indian", "Indijski nacionalni kalendar" },
            { "grc", "starogr\u010dki" },
            { "GA", "Gabon" },
            { "vot", "votski" },
            { "GB", "Ujedinjeno Kraljevstvo" },
            { "pcm", "nigerijski pid\u017ein" },
            { "GD", "Grenada" },
            { "GE", "Gruzija" },
            { "GF", "Francuska Gvajana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "Tale", "tai le pismo" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Grenland" },
            { "enm", "srednjovjekovni engleski" },
            { "GM", "Gambija" },
            { "GN", "Gvineja" },
            { "GP", "Gvadalupe" },
            { "GQ", "Ekvatorijalna Gvineja" },
            { "GR", "Gr\u010dka" },
            { "GS", "Ju\u017ena D\u017eord\u017eija i Ju\u017ena Sendvi\u010d ostrva" },
            { "GT", "Gvatemala" },
            { "GU", "Guam" },
            { "GW", "Gvineja-Bisao" },
            { "tli", "tlingit" },
            { "tlh", "klingonski" },
            { "Talu", "novo tai lue pismo" },
            { "GY", "Gvajana" },
            { "ckb", "centralnokurdski" },
            { "zxx", "bez lingvisti\u010dkog sadr\u017eaja" },
            { "Jurc", "jurchen pismo" },
            { "HK", "Hong Kong (SAR Kina)" },
            { "Vaii", "vai pismo" },
            { "HM", "Ostrvo Heard i arhipelag McDonald" },
            { "HN", "Honduras" },
            { "HR", "Hrvatska" },
            { "agq", "aghem" },
            { "gsw", "njema\u010dki (\u0160vicarska)" },
            { "HT", "Haiti" },
            { "HU", "Ma\u0111arska" },
            { "tmh", "tama\u0161ek" },
            { "IC", "Kanarska ostrva" },
            { "ID", "Indonezija" },
            { "peo", "staroperzijski" },
            { "IE", "Irska" },
            { "nap", "napolitanski" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "Tang", "tangut pismo" },
            { "IL", "Izrael" },
            { "Nbat", "nabatejsko pismo" },
            { "IM", "Ostrvo Man" },
            { "IN", "Indija" },
            { "IO", "Britanska Teritorija u Indijskom Okeanu" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italija" },
            { "Zmth", "matemati\u010dka notacija" },
            { "type.nu.thai", "tajlandski brojevi" },
            { "%%POSIX", "Kompjuter" },
            { "type.nu.beng", "bengalski brojevi" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "islamski kalendar" },
            { "JM", "Jamajka" },
            { "Beng", "bengalsko pismo" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "%%1606NICT", "Francuski iz kasnog srednjeg veka do 1606." },
            { "ain", "ainu" },
            { "Mend", "mende pismo" },
            { "guz", "gusi" },
            { "tog", "njasa tonga" },
            { "type.nu.knda", "brojevi pisma kanada" },
            { "Kali", "kajah li pismo" },
            { "de_CH", "visoki njema\u010dki (\u0160vicarska)" },
            { "type.ca.buddhist", "budisti\u010dki kalendar" },
            { "KE", "Kenija" },
            { "419", "Latinska Amerika" },
            { "KG", "Kirgistan" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komori" },
            { "KN", "Sveti Kits i Nevis" },
            { "Knda", "pismo kanada" },
            { "Zinh", "nasledno pismo" },
            { "KP", "Sjeverna Koreja" },
            { "KR", "Ju\u017ena Koreja" },
            { "Plrd", "polard fonetsko pismo" },
            { "KW", "Kuvajt" },
            { "tpi", "tok pisin" },
            { "KY", "Kajmanska ostrva" },
            { "KZ", "Kazahstan" },
            { "Cyrl", "\u0107irilica" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Sveta Lucija" },
            { "phn", "feni\u010danski" },
            { "Cyrs", "Staroslovenska crkvena \u0107irilica" },
            { "gwi", "gvi\u010din" },
            { "nds", "donjonjema\u010dki" },
            { "LI", "Lihten\u0161tajn" },
            { "LK", "\u0160ri Lanka" },
            { "akk", "akadijski" },
            { "cop", "koptski" },
            { "LR", "Liberija" },
            { "LS", "Lesoto" },
            { "Phlv", "pahlavi pismo" },
            { "LT", "Litvanija" },
            { "LU", "Luksemburg" },
            { "LV", "Latvija" },
            { "Kana", "pismo katakana" },
            { "Sora", "sora sompeng pismo" },
            { "LY", "Libija" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "lah", "landa" },
            { "lag", "langi" },
            { "Thaa", "pismo tana" },
            { "MA", "Maroko" },
            { "MC", "Monako" },
            { "MD", "Moldavija" },
            { "Nshu", "nushu pismo" },
            { "ME", "Crna Gora" },
            { "MF", "Sveti Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "MH", "Mar\u0161alova ostrva" },
            { "ale", "aleutski" },
            { "Thai", "tajlandsko pismo" },
            { "MK", "Sjeverna Makedonija" },
            { "ML", "Mali" },
            { "MM", "Mjanmar" },
            { "MN", "Mongolija" },
            { "new", "nevari" },
            { "MO", "Makao (SAR Kina)" },
            { "MP", "Sjeverna Marijanska ostrva" },
            { "MQ", "Martinik" },
            { "MR", "Mauritanija" },
            { "MS", "Monserat" },
            { "MT", "Malta" },
            { "type.m0.ungegn", "UN GEGN transliteracija" },
            { "MU", "Mauricijus" },
            { "alt", "ju\u017eni altai" },
            { "MV", "Maldivi" },
            { "MW", "Malavi" },
            { "MX", "Meksiko" },
            { "type.ca.japanese", "japanski kalendar" },
            { "MY", "Malezija" },
            { "MZ", "Mozambik" },
            { "Phli", "pisani pahlavi" },
            { "NA", "Namibija" },
            { "202", "Subsaharska Afrika" },
            { "type.ca.hebrew", "hebrejski kalendar" },
            { "NC", "Nova Kaledonija" },
            { "%%WADEGILE", "Vejd-\u017dajl romanizacija" },
            { "%%UCRCOR", "Ujedinjena revidirana ortografija" },
            { "NE", "Niger" },
            { "NF", "Ostrvo Norfolk" },
            { "NG", "Nigerija" },
            { "trv", "taroko" },
            { "Phlp", "psalter pahlavi" },
            { "NI", "Nikaragva" },
            { "Hmng", "pahawh hmong pismo" },
            { "NL", "Holandija" },
            { "NO", "Norve\u0161ka" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "Phnx", "feni\u010dansko pismo" },
            { "rof", "rombo" },
            { "tsi", "tsim\u0161ian" },
            { "NZ", "Novi Zeland" },
            { "Merc", "meroitski kurziv" },
            { "rom", "romani" },
            { "Mero", "meroitik pismo" },
            { "crh", "krimski turski" },
            { "ang", "staroengleski" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "crs", "seselva kreolski francuski" },
            { "Xpeo", "staropersijsko pismo" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Islamski civilni kalendar" },
            { "csb", "ka\u0161ubijanski" },
            { "PE", "Peru" },
            { "PF", "Francuska Polinezija" },
            { "PG", "Papua Nova Gvineja" },
            { "PH", "Filipini" },
            { "PK", "Pakistan" },
            { "PL", "Poljska" },
            { "ewo", "evondo" },
            { "PM", "Sveti Petar i Mikelon" },
            { "PN", "Pitkernska Ostrva" },
            { "PR", "Porto Riko" },
            { "PS", "Palestinska Teritorija" },
            { "Bali", "balijsko pismo" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "mali gr\u010dki brojevi" },
            { "PY", "Paragvaj" },
            { "tum", "tumbuka" },
            { "Hebr", "hebrejsko pismo" },
            { "QA", "Katar" },
            { "%%SCOTLAND", "\u0160kotski standardni engleski" },
            { "niu", "niue" },
            { "QO", "Vanjska Okeanija" },
            { "lez", "lezgijski" },
            { "%%FONUPA", "UPA fonetika" },
            { "tvl", "tuvalu" },
            { "Tavt", "tai viet pismo" },
            { "001", "Svijet" },
            { "002", "Afrika" },
            { "003", "Sjeverna Amerika" },
            { "RE", "Reunion" },
            { "005", "Ju\u017ena Amerika" },
            { "jbo", "lojban" },
            { "Rjng", "rejang pismo" },
            { "009", "Okeanija" },
            { "RO", "Rumunija" },
            { "RS", "Srbija" },
            { "Mroo", "mro pismo" },
            { "RU", "Rusija" },
            { "RW", "Ruanda" },
            { "%%METELKO", "Metel\u010dica" },
            { "Mani", "manihejsko pismo" },
            { "Ugar", "ugaritsko pismo" },
            { "Khar", "karo\u0161ti pismo" },
            { "SA", "Saudijska Arabija" },
            { "pon", "ponpejski" },
            { "Mand", "mandeansko pismo" },
            { "SB", "Solomonska Ostrva" },
            { "twq", "tasavak" },
            { "011", "Zapadna Afrika" },
            { "SC", "Sej\u0161eli" },
            { "SD", "Sudan" },
            { "013", "Srednja Amerika" },
            { "SE", "\u0160vedska" },
            { "014", "Isto\u010dna Afrika" },
            { "arc", "aramejski" },
            { "Loma", "loma pismo" },
            { "015", "Sjeverna Afrika" },
            { "SG", "Singapur" },
            { "SH", "Sveta Helena" },
            { "type.lb.strict", "Strogi stil prijeloma reda" },
            { "017", "Srednja Afrika" },
            { "SI", "Slovenija" },
            { "018", "Ju\u017ena Afrika" },
            { "SJ", "Svalbard i Jan Majen" },
            { "019", "Amerika" },
            { "SK", "Slova\u010dka" },
            { "Bamu", "bamum pismo" },
            { "Wole", "woleai pismo" },
            { "SL", "Sijera Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalija" },
            { "arn", "mapu\u0161ki" },
            { "arp", "arapaho" },
            { "type.nu.taml", "tradicionalni tamilski brojevi" },
            { "SR", "Surinam" },
            { "SS", "Ju\u017eni Sudan" },
            { "ST", "Sao Tome i Principe" },
            { "SV", "Salvador" },
            { "SX", "Sint Marten" },
            { "SY", "Sirija" },
            { "yao", "jao" },
            { "SZ", "Esvatini" },
            { "arw", "aravak" },
            { "yap", "jape\u0161ki" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "type.ms.ussystem", "ameri\u010dki mjerni sistem" },
            { "021", "Sjeverni dio Amerike" },
            { "TC", "Ostrva Turks i Kaikos" },
            { "yav", "jangben" },
            { "TD", "\u010cad" },
            { "TF", "Francuske Ju\u017ene Teritorije" },
            { "TG", "Togo" },
            { "TH", "Tajland" },
            { "TJ", "Tad\u017eikistan" },
            { "029", "Karibi" },
            { "TK", "Tokelau" },
            { "TL", "Isto\u010dni Timor" },
            { "ybb", "jemba" },
            { "type.co.searchjl", "Pretra\u017eivanje po po\u010detnom suglasniku hangula" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "Buntling" },
            { "TN", "Tunis" },
            { "TO", "Tonga" },
            { "%%NULIK", "Moderni volapuk" },
            { "TR", "Turska" },
            { "TT", "Trinidad i Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Tajvan" },
            { "ast", "asturijski" },
            { "Orkh", "orkhon pismo" },
            { "TZ", "Tanzanija" },
            { "nmg", "kvasio" },
            { "Zzzz", "nepoznato pismo" },
            { "Sind", "khudawadi pismo" },
            { "UA", "Ukrajina" },
            { "rup", "arumunski" },
            { "030", "Isto\u010dna Azija" },
            { "tyv", "tuvinijski" },
            { "034", "Ju\u017ena Azija" },
            { "hai", "haida" },
            { "035", "Jugoisto\u010dna Azija" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "Pinjin sortiranje" },
            { "039", "Ju\u017ena Evropa" },
            { "Sinh", "pismo sinhala" },
            { "UM", "Ameri\u010dka Vanjska Ostrva" },
            { "UN", "Ujedinjene Nacije" },
            { "US", "Sjedinjene Dr\u017eave" },
            { "haw", "havajski" },
            { "%%1959ACAD", "Akademski" },
            { "type.co.gb2312han", "Pojednostavljeno kinesko sortiranje" },
            { "UY", "Urugvaj" },
            { "prg", "pruski" },
            { "UZ", "Uzbekistan" },
            { "tzm", "centralnoatlaski tamazigt" },
            { "type.co.stroke", "Sortiranje po broju crta" },
            { "nnh", "ngiembon" },
            { "VA", "Vatikan" },
            { "pro", "staroprovansalski" },
            { "VC", "Sveti Vinsent i Grenadin" },
            { "VE", "Venecuela" },
            { "VG", "Britanska Djevi\u010danska ostrva" },
            { "VI", "Ameri\u010dka Djevi\u010danska ostrva" },
            { "VN", "Vijetnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rua" },
            { "non", "staronordijski" },
            { "053", "Australazija" },
            { "%%AREVMDA", "Zapadno-jermenski" },
            { "054", "Melanezija" },
            { "WF", "Ostrva Valis i Futuna" },
            { "type.co.traditional", "Tradicionalno sortiranje" },
            { "057", "Mikronezijska regija" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "wae", "valser" },
            { "WS", "Samoa" },
            { "Bass", "bassa vah pismo" },
            { "wal", "valamo" },
            { "was", "va\u0161o" },
            { "XA", "Pseudo naglasci" },
            { "war", "varej" },
            { "XB", "Pseudo bidi" },
            { "awa", "avadhi" },
            { "061", "Polinezija" },
            { "%%KSCOR", "Standardna ortografija" },
            { "XK", "Kosovo" },
            { "Gujr", "pismo gud\u017earati" },
            { "Zxxx", "nepisani jezik" },
            { "Olck", "ol \u010diki pismo" },
            { "wbp", "varlpiri" },
            { "Batk", "batak pismo" },
            { "Blis", "blisimboli\u010dno pismo" },
            { "YE", "Jemen" },
            { "nqo", "nko" },
            { "type.co.standard", "standardno sortiranje" },
            { "fan", "fang" },
            { "%%ROZAJ", "Rezijan" },
            { "fat", "fanti" },
            { "Sgnw", "znakovno pismo" },
            { "YT", "Majote" },
            { "ZA", "Ju\u017enoafri\u010dka Republika" },
            { "type.lb.loose", "Slobodni stil prijeloma reda" },
            { "Deva", "pismo devanagari" },
            { "type.nu.geor", "gruzijski brojevi" },
            { "Hira", "pismo hiragana" },
            { "ZM", "Zambija" },
            { "%%PINYIN", "Pinjinska romanizacija" },
            { "ZW", "Zimbabve" },
            { "ZZ", "Nepoznata oblast" },
            { "Runr", "runsko pismo" },
            { "type.ms.metric", "metri\u010dki sistem" },
            { "type.ca.iso8601", "kalendar ISO-8601" },
            { "lol", "mongo" },
            { "nso", "sjeverni soto" },
            { "type.nu.telu", "brojevi pisma telugu" },
            { "loz", "lozi" },
            { "Nkgb", "naxi geba pismo" },
            { "jmc", "makame" },
            { "type.nu.hansfin", "pojednostavljeni kineski finansijski brojevi" },
            { "hil", "hiligajnon" },
            { "type.nu.arabext", "pro\u0161ireni arapsko-indijski brojevi" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "\u0161iroki brojevi" },
            { "hit", "hitite" },
            { "dar", "dargva" },
            { "dav", "taita" },
            { "Maya", "majanski hijeroglifi" },
            { "lrc", "sjeverni luri" },
            { "Copt", "kopti\u010dko pismo" },
            { "nwc", "klasi\u010dni nevari" },
            { "udm", "udmurt" },
            { "Khmr", "kmersko pismo" },
            { "Limb", "limbu pismo" },
            { "sad", "sandave" },
            { "type.nu.roman", "rimski brojevi" },
            { "sah", "jakutski" },
            { "sam", "samaritanski aramejski" },
            { "%%SCOUSE", "Skauz" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinag pismo" },
            { "jpr", "judeo-perzijski" },
            { "type.d0.npinyin", "Numeri\u010dki" },
            { "sba", "ngambaj" },
            { "Guru", "pismo gurmuki" },
            { "%%ALUKU", "Aluku dijalekt" },
            { "lua", "luba-lulua" },
            { "type.d0.fwidth", "\u0160iroki" },
            { "sbp", "sangu" },
            { "lui", "luiseno" },
            { "nyn", "njankole" },
            { "nym", "njamvezi" },
            { "lun", "lunda" },
            { "nyo", "njoro" },
            { "luo", "luo" },
            { "fil", "filipino" },
            { "hmn", "hmong" },
            { "del", "delaver" },
            { "lus", "mizo" },
            { "bal", "balu\u010di" },
            { "den", "slave" },
            { "ban", "balinezijski" },
            { "uga", "ugaritski" },
            { "luy", "luhija" },
            { "bas", "basa" },
            { "bax", "bamunski" },
            { "jrb", "judeo-arapski" },
            { "nzi", "nzima" },
            { "sco", "\u0161kotski" },
            { "scn", "sicilijanski" },
            { "aa", "afarski" },
            { "ab", "abhaski" },
            { "ae", "avestanski" },
            { "af", "afrikans" },
            { "ak", "akan" },
            { "bbj", "gomala" },
            { "am", "amharski" },
            { "an", "aragonski" },
            { "Arab", "arapsko pismo" },
            { "%%SOLBA", "Stolvica/Solbica dijalekt" },
            { "Jpan", "japansko pismo" },
            { "ar", "arapski" },
            { "Hrkt", "katakana ili hiragana" },
            { "as", "asamski" },
            { "Lina", "linearno A pismo" },
            { "av", "avarski" },
            { "Linb", "linearno B pismo" },
            { "sdh", "ju\u017eni kurdski" },
            { "ay", "ajmara" },
            { "az", "azerbejd\u017eanski" },
            { "Khoj", "khojki pismo" },
            { "%%OSOJS", "Oseako/Osojane dijalekt" },
            { "ba", "ba\u0161kirski" },
            { "be", "bjeloruski" },
            { "bg", "bugarski" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengalski" },
            { "bo", "tibetanski" },
            { "dgr", "dogrib" },
            { "br", "bretonski" },
            { "bs", "bosanski" },
            { "see", "seneka" },
            { "Mymr", "mijanmarsko pismo" },
            { "type.nu.laoo", "laoski brojevi" },
            { "seh", "sena" },
            { "Nkoo", "n\u2019ko pismo" },
            { "sel", "selkup" },
            { "ca", "katalonski" },
            { "ses", "kojraboro seni" },
            { "ce", "\u010de\u010denski" },
            { "ch", "\u010damoro" },
            { "%%REVISED", "Revidirana ortigrafija" },
            { "co", "korzikanski" },
            { "Orya", "pismo orija" },
            { "cr", "kri" },
            { "cs", "\u010de\u0161ki" },
            { "cu", "staroslavenski" },
            { "cv", "\u010duva\u0161ki" },
            { "cy", "vel\u0161ki" },
            { "type.nu.ethi", "etiopski brojevi" },
            { "Yiii", "ji pismo" },
            { "da", "danski" },
            { "de", "njema\u010dki" },
            { "type.cf.standard", "standardni format valute" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "Bugi", "buginsko pismo" },
            { "bem", "bemba" },
            { "sga", "staroirski" },
            { "dv", "divehi" },
            { "dz", "d\u017eonga" },
            { "bez", "bena" },
            { "type.ca.chinese", "kineski kalendar" },
            { "Lisu", "fraser pismo" },
            { "dje", "zarma" },
            { "type.nu.grek", "gr\u010dki brojevi" },
            { "ee", "eve" },
            { "bfd", "bafut" },
            { "type.lb.normal", "Normalni stil prijeloma reda" },
            { "ro_MD", "moldavski" },
            { "el", "gr\u010dki" },
            { "en", "engleski" },
            { "eo", "esperanto" },
            { "type.co.big5han", "Tradicionalno kinesko sortiranje" },
            { "es", "\u0161panski" },
            { "et", "estonski" },
            { "Hanb", "pismo hanb" },
            { "eu", "baskijski" },
            { "Buhd", "buhidsko pismo" },
            { "Hang", "pismo hangul" },
            { "Samr", "samaritansko pismo" },
            { "shi", "tahelhit" },
            { "hsb", "gornjolu\u017ei\u010dkosrpski" },
            { "Hani", "pismo han" },
            { "shn", "\u0161an" },
            { "Hano", "hanuno pismo" },
            { "fa", "perzijski" },
            { "Hans", "pojednostavljeno" },
            { "type.nu.latn", "arapski brojevi" },
            { "Hant", "tradicionalno" },
            { "ff", "fulah" },
            { "shu", "\u010dadski arapski" },
            { "fi", "finski" },
            { "fj", "fid\u017eijski" },
            { "fon", "fon" },
            { "bgn", "zapadni belu\u010dki" },
            { "yue", "kantonski" },
            { "fo", "farski" },
            { "type.m0.bgn", "US BGN transliteracija" },
            { "umb", "umbundu" },
            { "fr", "francuski" },
            { "sid", "sidamo" },
            { "fy", "zapadni frizijski" },
            { "ga", "irski" },
            { "gd", "\u0161kotski galski" },
            { "gl", "galicijski" },
            { "gn", "gvarani" },
            { "bho", "bojpuri" },
            { "und", "nepoznati jezik" },
            { "type.ca.ethiopic-amete-alem", "Etiopski kalendar \"Amete Alem\"" },
            { "gu", "gud\u017earati" },
            { "gv", "manks" },
            { "ha", "hausa" },
            { "he", "hebrejski" },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "hrvatski" },
            { "ht", "hai\u0107anski kreolski" },
            { "hu", "ma\u0111arski" },
            { "hy", "armenski" },
            { "hz", "herero" },
            { "%%FONIPA", "IPA fonetika" },
            { "ia", "interlingva" },
            { "Jamo", "pismo jamo" },
            { "id", "indonezijski" },
            { "type.nu.tibt", "tibetanski brojevi" },
            { "ie", "interlingve" },
            { "ig", "igbo" },
            { "ii", "si\u010duan ji" },
            { "frm", "srednjovjekovni francuski" },
            { "ik", "inupiak" },
            { "fro", "starofrancuski" },
            { "io", "ido" },
            { "frs", "isto\u010dnofrizijski" },
            { "frr", "sjeverni frizijski" },
            { "is", "islandski" },
            { "it", "italijanski" },
            { "iu", "inuktitut" },
            { "ja", "japanski" },
            { "Mlym", "malajalamsko pismo" },
            { "Sarb", "staro ju\u017enoarapsko pismo" },
            { "Sara", "sarati pismo" },
            { "doi", "dogri" },
            { "bkm", "kom" },
            { "sma", "ju\u017eni sami" },
            { "jv", "javanski" },
            { "Shaw", "\u0161avian pismo" },
            { "mad", "madure\u0161ki" },
            { "smj", "lule sami" },
            { "mag", "magahi" },
            { "maf", "mafa" },
            { "mai", "maitili" },
            { "smn", "inari sami" },
            { "ka", "gruzijski" },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "sms", "skolt sami" },
            { "man", "mandingo" },
            { "kg", "kongo" },
            { "Goth", "gotika" },
            { "ki", "kikuju" },
            { "mas", "masai" },
            { "kj", "kuanjama" },
            { "kk", "kaza\u0161ki" },
            { "kl", "kalalisutski" },
            { "km", "kmerski" },
            { "kn", "kanada" },
            { "ko", "korejski" },
            { "kr", "kanuri" },
            { "ks", "ka\u0161mirski" },
            { "Cirt", "cirt pismo" },
            { "Lepc", "lep\u010da pismo" },
            { "Avst", "avestansko pismo" },
            { "ku", "kurdski" },
            { "kv", "komi" },
            { "kw", "kornski" },
            { "ky", "kirgi\u0161ki" },
            { "snk", "soninke" },
            { "la", "latinski" },
            { "lb", "luksembur\u0161ki" },
            { "type.nu.mlym", "malajalamski brojevi" },
            { "lg", "ganda" },
            { "Roro", "rongorongo pismo" },
            { "li", "limbur\u0161ki" },
            { "Tibt", "tibetansko pismo" },
            { "ln", "lingala" },
            { "fur", "friulijski" },
            { "lo", "laoski" },
            { "type.ms.uksystem", "britanski mjerni sistem" },
            { "lt", "litvanski" },
            { "lu", "luba-katanga" },
            { "lv", "latvijski" },
            { "sog", "sogdien" },
            { "mg", "malga\u0161ki" },
            { "mh", "mar\u0161alski" },
            { "type.co.ducet", "standardno Unicode sortiranje" },
            { "mi", "maorski" },
            { "mk", "makedonski" },
            { "ml", "malajalam" },
            { "mn", "mongolski" },
            { "mr", "marati" },
            { "ms", "malajski" },
            { "mt", "malte\u0161ki" },
            { "my", "burmanski" },
            { "Saur", "saura\u0161tra pismo" },
            { "Armn", "armensko pismo" },
            { "mdf", "mok\u0161a" },
            { "mde", "maba" },
            { "dsb", "donjolu\u017ei\u010dkosrpski" },
            { "Armi", "imperijsko aramejsko pismo" },
            { "na", "nauru" },
            { "type.co.search", "op\u0107enito pretra\u017eivanje" },
            { "nb", "norve\u0161ki (Bokmal)" },
            { "nd", "sjeverni ndebele" },
            { "ne", "nepalski" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "holandski" },
            { "nn", "norve\u0161ki (Nynorsk)" },
            { "no", "norve\u0161ki" },
            { "nr", "ju\u017eni ndebele" },
            { "nv", "navaho" },
            { "kaa", "kara-kalpak" },
            { "ny", "njanja" },
            { "kac", "ka\u010din" },
            { "kab", "kabile" },
            { "%%POLYTON", "Politonik" },
            { "oc", "oksitanski" },
            { "kaj", "kaju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "%%EMODENG", "Rani moderni engleski" },
            { "oj", "ojibva" },
            { "mer", "meru" },
            { "type.nu.armn", "armenski brojevi" },
            { "om", "oromo" },
            { "kaw", "kavi" },
            { "or", "odija" },
            { "os", "osetski" },
            { "kbd", "kabardijski" },
            { "mfe", "mauricijski kreolski" },
            { "srn", "srananski tongo" },
            { "pa", "pand\u017eapski" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "Lipovac dijalekt rezijanski" },
            { "kbl", "kanembu" },
            { "pi", "pali" },
            { "pl", "poljski" },
            { "dum", "srednjovjekovni holandski" },
            { "type.ca.dangi", "dangi kalendar" },
            { "ps", "pa\u0161tu" },
            { "pt", "portugalski" },
            { "mga", "srednjovjekovni irski" },
            { "key.co", "Sortiranje" },
            { "kcg", "tjap" },
            { "mgh", "makuva-meto" },
            { "key.cf", "Format valute" },
            { "bra", "braj" },
            { "key.ca", "Kalendar" },
            { "Laoo", "laosko pismo" },
            { "mgo", "meta" },
            { "type.hc.h23", "24-satni format (0-23)" },
            { "type.hc.h24", "24-satni format (1-24)" },
            { "ssy", "saho" },
            { "type.nu.mymr", "mijanmarski brojevi" },
            { "qu", "ke\u010dua" },
            { "zap", "zapote\u010dki" },
            { "brx", "bodo" },
            { "Lana", "lanna pismo" },
            { "kde", "makonde" },
            { "Ethi", "etiopsko pismo" },
            { "type.hc.h12", "12-satni format (1-12)" },
            { "type.hc.h11", "12-satni format (0-11)" },
            { "rm", "retoromanski" },
            { "rn", "rundi" },
            { "key.cu", "Valuta" },
            { "ro", "rumunski" },
            { "%%SAAHO", "Saho" },
            { "type.nu.orya", "orijski brojevi" },
            { "type.nu.hanidec", "kineski decimalni brojevi" },
            { "ru", "ruski" },
            { "bss", "akoski" },
            { "rw", "kinjaruanda" },
            { "zbl", "blis simboli" },
            { "kea", "zelenortski" },
            { "mic", "mikmak" },
            { "suk", "sukuma" },
            { "sa", "sanskrit" },
            { "%%UCCOR", "Ujedinjena ortografija" },
            { "sc", "sardinijski" },
            { "sus", "susu" },
            { "sd", "sindi" },
            { "se", "sjeverni sami" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "srpskohrvatski" },
            { "si", "sinhale\u0161ki" },
            { "sux", "sumerski" },
            { "sk", "slova\u010dki" },
            { "sl", "slovenski" },
            { "Gran", "grantha pismo" },
            { "sm", "samoanski" },
            { "sn", "\u0161ona" },
            { "so", "somalski" },
            { "type.nu.arab", "arapsko-indijski brojevi" },
            { "sq", "albanski" },
            { "sr", "srpski" },
            { "ss", "svati" },
            { "type.cf.account", "ra\u010dunovodstveni format valute" },
            { "st", "ju\u017eni soto" },
            { "Java", "javansko pismo" },
            { "su", "sundanski" },
            { "%%NEDIS", "Natison dijalekt" },
            { "sv", "\u0161vedski" },
            { "sw", "svahili" },
            { "type.nu.hantfin", "tradicionalni kineski finansijski brojevi" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", "tamilski" },
            { "142", "Azija" },
            { "bua", "buriat" },
            { "143", "Srednja Azija" },
            { "te", "telugu" },
            { "145", "Zapadna Azija" },
            { "tg", "tad\u017ei\u010dki" },
            { "th", "tajlandski" },
            { "ti", "tigrinja" },
            { "bug", "bugi\u0161ki" },
            { "kfo", "koro" },
            { "tk", "turkmenski" },
            { "tl", metaValue_tl },
            { "tn", "tsvana" },
            { "to", "tonganski" },
            { "bum", "bulu" },
            { "dyo", "jola-foni" },
            { "type.nu.jpan", "japanski brojevi" },
            { "tr", "turski" },
            { "ts", "tsonga" },
            { "swb", "komorski" },
            { "Cakm", "\u010dakmansko pismo" },
            { "tt", "tatarski" },
            { "dyu", "diula" },
            { "tw", "tvi" },
            { "ty", "tahi\u0107anski" },
            { "%%BISKE", "San \u0110or\u0111ijo/Bila dijalekt" },
            { "150", "Evropa" },
            { "151", "Isto\u010dna Evropa" },
            { "154", "Sjeverna Evropa" },
            { "dzg", "dazaga" },
            { "155", "Zapadna Evropa" },
            { "ug", "ujgurski" },
            { "Ital", "staro italsko pismo" },
            { "Kore", "korejsko pismo" },
            { "Zyyy", "zajedni\u010dko pismo" },
            { "uk", "ukrajinski" },
            { "type.ca.coptic", "Koptski kalendar" },
            { "ur", "urdu" },
            { "%%1994", "Standardizovana rezijanska ortografija" },
            { "xal", "kalmik" },
            { "zen", "zenaga" },
            { "uz", "uzbe\u010dki" },
            { "kha", "kasi" },
            { "%%1996", "Nema\u010dka ortografija 1996" },
            { "nds_NL", "donjosaksonski" },
            { "Sylo", "siloti nagri pismo" },
            { "ve", "venda" },
            { "Wara", "varang kshiti pismo" },
            { "type.ca.roc", "kalendar Republike Kine" },
            { "vi", "vijetnamski" },
            { "kho", "kotanizijski" },
            { "khq", "kojra \u010dini" },
            { "key.hc", "Format vremena (12 ili 24)" },
            { "%%TARASK", "Taraskijevica ortografija" },
            { "vo", "volapuk" },
            { "syc", "klasi\u010dni sirijski" },
            { "Osma", "osmanja pismo" },
            { "quc", "ki\u010de" },
            { "gaa", "ga" },
            { "wa", "valun" },
            { "gag", "gagau\u0161ki" },
            { "syr", "sirijski" },
            { "Grek", "gr\u010dko pismo" },
            { "Lydi", "lidijsko pismo" },
            { "Xsux", "sumersko-akadsko kuneiform pismo" },
            { "wo", "volof" },
            { "zgh", "standardni marokanski tamazigt" },
            { "ar_001", "moderni standardni arapski" },
            { "Cans", "Ujedinjeni kanadski aborid\u017einski silabici" },
            { "gay", "gajo" },
            { "Mong", "mongolsko pismo" },
            { "mnc", "man\u010du" },
            { "Latf", "latinica (fraktur varijanta)" },
            { "Hluw", "anatolijski hijeroglifi" },
            { "gba", "gbaja" },
            { "mni", "manipuri" },
            { "Latn", "latinica" },
            { "Latg", "galska latinica" },
            { "type.nu.hans", "pojednostavljeni kineski brojevi" },
            { "type.nu.hant", "tradicionalni kineski brojevi" },
            { "xh", "hosa" },
            { "type.nu.romanlow", "mali rimski brojevi" },
            { "byn", "blin" },
            { "%%PAMAKA", "Pamaka dijalekt" },
            { "Lyci", "lisijsko pismo" },
            { "osa", "osage" },
            { "byv", "medumba" },
            { "Moon", "mese\u010devo pismo" },
            { "moh", "mohavk" },
            { "kkj", "kako" },
            { "%%1694ACAD", "Rani moderni francuski" },
            { "yi", "jidi\u0161" },
            { "mos", "mosi" },
            { "Syrc", "sirijsko pismo" },
            { "Dsrt", "dezeret" },
            { "yo", "jorubanski" },
            { "type.nu.traditional", "Tradicionalni brojevi" },
            { "Syrj", "zapadnosirijsko pismo" },
            { "ota", "osmanski turski" },
            { "Syre", "sirijsko estrangelo pismo" },
            { "vai", "vai" },
            { "za", "zuang" },
            { "Cari", "karijsko pismo" },
            { "kln", "kalenjin" },
            { "zh", "kineski" },
            { "Afak", "afaka pismo" },
            { "Bopo", "pismo bopomofo" },
            { "Perm", "staro permiksko pismo" },
            { "key.lb", "Stil prijeloma reda" },
            { "zu", "zulu" },
            { "type.co.phonebook", "Sortiranje kao telefonski imenik" },
            { "%%MONOTON", "Monotonik" },
            { "Geor", "gruzijsko pismo" },
            { "Shrd", "sharada pismo" },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "japanski finansijski brojevi" },
            { "Cham", "\u010damsko pismo" },
            { "gez", "staroetiopski" },
            { "Syrn", "pismo isto\u010dne Sirije" },
            { "Narb", "staro sjevernoarapsko pismo" },
            { "Tglg", metaValue_tl },
            { "Egyd", "egipatsko narodno pismo" },
            { "Egyh", "egipatsko hijeratsko pismo" },
            { "Palm", "palmyrene pismo" },
            { "ebu", "embu" },
            { "Egyp", "egipatski hijeroglifi" },
            { "Geok", "gruzijsko khutsuri pismo" },
            { "zh_Hans", "kineski (pojednostavljeni)" },
            { "koi", "komi-permski" },
            { "Hung", "Staroma\u0111arsko pismo" },
            { "kok", "konkani" },
            { "%%1901", "Tradicionalna nema\u010dka ortografija" },
            { "kos", "kosrejski" },
            { "zh_Hant", "kineski (tradicionalni)" },
            { "kpe", "kpele" },
            { "type.nu.khmr", "kmerski brojevi" },
            { "Tirh", "tirhuta pismo" },
            { "ilo", "iloko" },
            { "%%VALENCIA", "Valencijski" },
            { "Cprt", "kiparsko pismo" },
            { "%%BAKU1926", "Ujedinjeni turski latini\u010dni alfabet" },
            { "mua", "mundang" },
            { "type.nu.guru", "brojevi pisma gurmuki" },
            { "mul", "vi\u0161e jezika" },
            { "cad", "kado" },
            { "key.ms", "Mjerni sistem" },
            { "mus", "kri\u0161ki" },
            { "Glag", "glagoljica" },
            { "gil", "gilbertski" },
            { "%%KKCOR", "Uobi\u010dajena ortografija" },
            { "Cher", metaValue_chr },
            { "car", "karipski" },
            { "cay", "kajuga" },
            { "type.nu.tamldec", "tamilski brojevi" },
            { "krc", "kara\u010daj-balkar" },
            { "inh", "ingu\u0161etski" },
            { "kri", "krio" },
            { "fa_AF", "dari" },
            { "krl", "karelijski" },
            { "efi", "efik" },
            { "key.nu", "Brojevi" },
            { "kru", "kuru\u0161ki" },
            { "ksb", "\u0161ambala" },
            { "Telu", "pismo telugu" },
            { "ksf", "bafia" },
        };
        return data;
    }
}
