/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.PrintWriter;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFactoryBase;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.group.interceptors.StaticMembershipInterceptor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class InterceptorSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog(InterceptorSF.class);

    @Override
    public void store(PrintWriter printWriter, int n, Object object) throws Exception {
        if (object instanceof StaticMembershipInterceptor) {
            StoreDescription storeDescription = this.getRegistry().findDescription(object.getClass());
            if (storeDescription != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("factory.storeTag", new Object[]{storeDescription.getTag(), object}));
                }
                this.getStoreAppender().printIndent(printWriter, n + 2);
                this.getStoreAppender().printOpenTag(printWriter, n + 2, object, storeDescription);
                this.storeChildren(printWriter, n + 2, object, storeDescription);
                this.getStoreAppender().printIndent(printWriter, n + 2);
                this.getStoreAppender().printCloseTag(printWriter, storeDescription);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{object.getClass()}));
            }
        } else {
            super.store(printWriter, n, object);
        }
    }

    @Override
    public void storeChildren(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription) throws Exception {
        if (object instanceof StaticMembershipInterceptor) {
            ChannelInterceptor channelInterceptor = (ChannelInterceptor)object;
            this.storeElementArray(printWriter, n + 2, channelInterceptor.getMembers());
        }
    }
}

