/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.security;

import java.security.Security;
import org.apache.catalina.startup.CatalinaProperties;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public final class SecurityConfig {
    private static final Object singletonLock = new Object();
    private static volatile SecurityConfig singleton = null;
    private static final Log log = LogFactory.getLog(SecurityConfig.class);
    private static final String PACKAGE_ACCESS = "sun.,org.apache.catalina.,org.apache.jasper.,org.apache.coyote.,org.apache.tomcat.";
    private static final String PACKAGE_DEFINITION = "java.,sun.,org.apache.catalina.,org.apache.coyote.,org.apache.tomcat.,org.apache.jasper.";
    private final String packageDefinition;
    private final String packageAccess;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecurityConfig() {
        String string = null;
        String string2 = null;
        try {
            string = CatalinaProperties.getProperty("package.definition");
            string2 = CatalinaProperties.getProperty("package.access");
        }
        catch (Exception exception) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unable to load properties using CatalinaProperties", (Throwable)exception);
            }
        }
        finally {
            this.packageDefinition = string;
            this.packageAccess = string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityConfig newInstance() {
        if (singleton == null) {
            Object object = singletonLock;
            synchronized (object) {
                if (singleton == null) {
                    singleton = new SecurityConfig();
                }
            }
        }
        return singleton;
    }

    public void setPackageAccess() {
        if (this.packageAccess == null) {
            this.setSecurityProperty("package.access", PACKAGE_ACCESS);
        } else {
            this.setSecurityProperty("package.access", this.packageAccess);
        }
    }

    public void setPackageDefinition() {
        if (this.packageDefinition == null) {
            this.setSecurityProperty("package.definition", PACKAGE_DEFINITION);
        } else {
            this.setSecurityProperty("package.definition", this.packageDefinition);
        }
    }

    private final void setSecurityProperty(String string, String string2) {
        if (System.getSecurityManager() != null) {
            String string3 = Security.getProperty(string);
            if (string3 != null && string3.length() > 0) {
                if (string2.length() > 0) {
                    string3 = string3 + ',' + string2;
                }
            } else {
                string3 = string2;
            }
            Security.setProperty(string, string3);
        }
    }
}

