#!/usr/bin/python
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
#############################################

"""
The module file for vyos_ospfv2
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type


DOCUMENTATION = """
module: vyos_ospfv2
short_description: OSPFv2 resource module
description: This resource module configures and manages attributes of OSPFv2 routes
  on VyOS network devices.
version_added: 1.0.0
notes:
- Tested against VyOS 1.1.8 (helium).
- This module works with connection C(ansible.netcommon.network_cli). See L(the VyOS OS Platform Options,../network/user_guide/platform_vyos.html).
author:
- Rohit Thakur (@rohitthakur2590)
options:
  config:
    description: A provided OSPFv2 route configuration.
    type: dict
    suboptions:
      areas:
        description: OSPFv2 area.
        type: list
        elements: dict
        suboptions:
          area_id:
            description: OSPFv2 area identity.
            type: str
          area_type:
            description: Area type.
            type: dict
            suboptions:
              normal:
                description: Normal OSPFv2 area.
                type: bool
              nssa:
                description: NSSA OSPFv2 area.
                type: dict
                suboptions:
                  set:
                    description: Enabling NSSA.
                    type: bool
                  default_cost:
                    description: Summary-default cost of NSSA area.
                    type: int
                  no_summary:
                    description: Do not inject inter-area routes into stub.
                    type: bool
                  translate:
                    description: NSSA-ABR.
                    type: str
                    choices: [always, candidate, never]
              stub:
                description: Stub OSPFv2 area.
                type: dict
                suboptions:
                  set:
                    description: Enabling stub.
                    type: bool
                  default_cost:
                    description: Summary-default cost of stub area.
                    type: int
                  no_summary:
                    description: Do not inject inter-area routes into stub.
                    type: bool
          authentication:
            description: OSPFv2 area authentication type.
            type: str
            choices: [plaintext-password, md5]
          network:
            description: OSPFv2 network.
            type: list
            elements: dict
            suboptions:
              address:
                required: true
                description: OSPFv2 IPv4 network address.
                type: str
          range:
            description: Summarize routes matching prefix (border routers only).
            type: list
            elements: dict
            suboptions:
              address:
                description: border router IPv4 address.
                type: str
              cost:
                description: Metric for this range.
                type: int
              not_advertise:
                description: Don't advertise this range.
                type: bool
              substitute:
                description: Announce area range (IPv4 address) as another prefix.
                type: str
          shortcut:
            description: Area's shortcut mode.
            type: str
            choices: [default, disable, enable]
          virtual_link:
            description: Virtual link address.
            type: list
            elements: dict
            suboptions:
              address:
                description: virtual link address.
                type: str
              authentication:
                description: OSPFv2 area authentication type.
                type: dict
                suboptions:
                  md5:
                    description: MD5 key id based authentication.
                    type: list
                    elements: dict
                    suboptions:
                      key_id:
                        description: MD5 key id.
                        type: int
                      md5_key:
                        description: MD5 key.
                        type: str
                  plaintext_password:
                    description: Plain text password.
                    type: str
              dead_interval:
                description: Interval after which a neighbor is declared dead.
                type: int
              hello_interval:
                description: Interval between hello packets.
                type: int
              retransmit_interval:
                description: Interval between retransmitting lost link state advertisements.
                type: int
              transmit_delay:
                description: Link state transmit delay.
                type: int
      log_adjacency_changes:
        description: Log changes in adjacency state.
        type: str
        choices: [detail]
      max_metric:
        description: OSPFv2 maximum/infinite-distance metric.
        type: dict
        suboptions:
          router_lsa:
            description: Advertise own Router-LSA with infinite distance (stub router).
            type: dict
            suboptions:
              administrative:
                description: Administratively apply, for an indefinite period.
                type: bool
              on_shutdown:
                description: Time to advertise self as stub-router.
                type: int
              on_startup:
                description: Time to advertise self as stub-router
                type: int
      auto_cost:
        description: Calculate OSPFv2 interface cost according to bandwidth.
        type: dict
        suboptions:
          reference_bandwidth:
            description: Reference bandwidth cost in Mbits/sec.
            type: int
      default_information:
        description: Control distribution of default information.
        type: dict
        suboptions:
          originate:
            description: Distribute a default route.
            type: dict
            suboptions:
              always:
                description: Always advertise default route.
                type: bool
              metric:
                description: OSPFv2 default metric.
                type: int
              metric_type:
                description: OSPFv2 Metric types for default routes.
                type: int
              route_map:
                description: Route map references.
                type: str
      default_metric:
        description: Metric of redistributed routes
        type: int
      distance:
        description: Administrative distance.
        type: dict
        suboptions:
          global:
            description: Global OSPFv2 administrative distance.
            type: int
          ospf:
            description: OSPFv2 administrative distance.
            type: dict
            suboptions:
              external:
                description: Distance for external routes.
                type: int
              inter_area:
                description: Distance for inter-area routes.
                type: int
              intra_area:
                description: Distance for intra-area routes.
                type: int
      mpls_te:
        description: MultiProtocol Label Switching-Traffic Engineering (MPLS-TE) parameters.
        type: dict
        suboptions:
          enabled:
            description: Enable MPLS-TE functionality.
            type: bool
          router_address:
            description: Stable IP address of the advertising router.
            type: str

      neighbor:
        description: Neighbor IP address.
        type: list
        elements: dict
        suboptions:
          neighbor_id:
            description: Identity (number/IP address) of neighbor.
            type: str
          poll_interval:
            description: Seconds between dead neighbor polling interval.
            type: int
          priority:
            description: Neighbor priority.
            type: int
      parameters:
        description: OSPFv2 specific parameters.
        type: dict
        suboptions:
          abr_type:
            description: OSPFv2 ABR Type.
            type: str
            choices: [cisco, ibm, shortcut, standard]
          opaque_lsa:
            description: Enable the Opaque-LSA capability (rfc2370).
            type: bool
          rfc1583_compatibility:
            description: Enable rfc1583 criteria for handling AS external routes.
            type: bool
          router_id:
            description: Override the default router identifier.
            type: str
      passive_interface:
        description: Suppress routing updates on an interface.
        type: list
        elements: str
      passive_interface_exclude:
        description: Interface to exclude when using passive-interface default.
        type: list
        elements: str
      redistribute:
        description: Redistribute information from another routing protocol.
        type: list
        elements: dict
        suboptions:
          route_type:
            description: Route type to redistribute.
            type: str
            choices: [bgp, connected, kernel, rip, static]
          metric:
            description: Metric for redistribution routes.
            type: int
          metric_type:
            description: OSPFv2 Metric types.
            type: int
          route_map:
            description: Route map references.
            type: str
      route_map:
        description: Filter routes installed in local route map.
        type: list
        elements: str
      timers:
        description: Adjust routing timers.
        type: dict
        suboptions:
          refresh:
            description: Adjust refresh parameters.
            type: dict
            suboptions:
              timers:
                description: refresh timer.
                type: int
          throttle:
            description: Throttling adaptive timers.
            type: dict
            suboptions:
              spf:
                description: OSPFv2 SPF timers.
                type: dict
                suboptions:
                  delay:
                    description: Delay (msec) from first change received till SPF
                      calculation.
                    type: int
                  initial_holdtime:
                    description: Initial hold time(msec) between consecutive SPF calculations.
                    type: int
                  max_holdtime:
                    description: maximum hold time (sec).
                    type: int
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the VyOS device
      by executing the command B(show configuration commands | grep ospf).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  state:
    description:
    - The state the configuration should be left in.
    type: str
    choices:
    - merged
    - replaced
    - deleted
    - parsed
    - gathered
    - rendered
    default: merged

"""
EXAMPLES = """
# Using merged
#
# Before state:
# -------------
#
# vyos@vyos# run show  configuration commands | grep ospf
#
#
- name: Merge the provided configuration with the existing running configuration
  vyos.vyos.vyos_ospfv2:
    config:
      log_adjacency_changes: detail
      max_metric:
        router_lsa:
          administrative: true
          on_shutdown: 10
          on_startup: 10
        default_information:
          originate:
            always: true
            metric: 10
            metric_type: 2
            route_map: ingress
        mpls_te:
          enabled: true
          router_address: 192.0.11.11
        auto_cost:
          reference_bandwidth: 2
        neighbor:
        - neighbor_id: 192.0.11.12
          poll_interval: 10
          priority: 2
        redistribute:
        - route_type: bgp
          metric: 10
          metric_type: 2
        passive_interface:
        - eth1
        - eth2
        parameters:
          router_id: 192.0.1.1
          opaque_lsa: true
          rfc1583_compatibility: true
          abr_type: cisco
        areas:
        - area_id: '2'
          area_type:
            normal: true
            authentication: plaintext-password
            shortcut: enable
        - area_id: '3'
          area_type:
            nssa:
              set: true
        - area_id: '4'
          area_type:
            stub:
              default_cost: 20
          network:
          - address: 192.0.2.0/24
          range:
          - address: 192.0.3.0/24
            cost: 10
          - address: 192.0.4.0/24
          cost: 12
    state: merged
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
# before": {}
#
#    "commands": [
#       "set protocols ospf mpls-te enable",
#       "set protocols ospf mpls-te router-address '192.0.11.11'",
#       "set protocols ospf redistribute bgp",
#       "set protocols ospf redistribute bgp metric-type 2",
#       "set protocols ospf redistribute bgp metric 10",
#       "set protocols ospf default-information originate metric-type 2",
#       "set protocols ospf default-information originate always",
#       "set protocols ospf default-information originate metric 10",
#       "set protocols ospf default-information originate route-map ingress",
#       "set protocols ospf auto-cost reference-bandwidth '2'",
#       "set protocols ospf parameters router-id '192.0.1.1'",
#       "set protocols ospf parameters opaque-lsa",
#       "set protocols ospf parameters abr-type 'cisco'",
#       "set protocols ospf parameters rfc1583-compatibility",
#       "set protocols ospf passive-interface eth1",
#       "set protocols ospf passive-interface eth2",
#       "set protocols ospf max-metric router-lsa on-shutdown 10",
#       "set protocols ospf max-metric router-lsa administrative",
#       "set protocols ospf max-metric router-lsa on-startup 10",
#       "set protocols ospf log-adjacency-changes 'detail'",
#       "set protocols ospf neighbor 192.0.11.12 priority 2",
#       "set protocols ospf neighbor 192.0.11.12 poll-interval 10",
#       "set protocols ospf neighbor 192.0.11.12",
#       "set protocols ospf area '2'",
#       "set protocols ospf area 2 authentication plaintext-password",
#       "set protocols ospf area 2 shortcut enable",
#       "set protocols ospf area 2 area-type normal",
#       "set protocols ospf area '3'",
#       "set protocols ospf area 3 area-type nssa",
#       "set protocols ospf area 4 range 192.0.3.0/24 cost 10",
#       "set protocols ospf area 4 range 192.0.3.0/24",
#       "set protocols ospf area 4 range 192.0.4.0/24 cost 12",
#       "set protocols ospf area 4 range 192.0.4.0/24",
#       "set protocols ospf area 4 area-type stub default-cost 20",
#       "set protocols ospf area '4'",
#       "set protocols ospf area 4 network 192.0.2.0/24"
#    ]
#
# "after": {
#        "areas": [
#            {
#                "area_id": "2",
#                "area_type": {
#                    "normal": true
#                },
#                "authentication": "plaintext-password",
#                "shortcut": "enable"
#            },
#            {
#                "area_id": "3",
#                "area_type": {
#                    "nssa": {
#                        "set": true
#                    }
#                }
#            },
#            {
#                "area_id": "4",
#                "area_type": {
#                    "stub": {
#                        "default_cost": 20,
#                        "set": true
#                    }
#                },
#                "network": [
#                    {
#                        "address": "192.0.2.0/24"
#                    }
#                ],
#                "range": [
#                    {
#                        "address": "192.0.3.0/24",
#                        "cost": 10
#                    },
#                    {
#                        "address": "192.0.4.0/24",
#                        "cost": 12
#                    }
#                ]
#            }
#        ],
#        "auto_cost": {
#            "reference_bandwidth": 2
#        },
#        "default_information": {
#            "originate": {
#                "always": true,
#                "metric": 10,
#                "metric_type": 2,
#                "route_map": "ingress"
#            }
#        },
#        "log_adjacency_changes": "detail",
#        "max_metric": {
#            "router_lsa": {
#                "administrative": true,
#                "on_shutdown": 10,
#                "on_startup": 10
#            }
#        },
#        "mpls_te": {
#            "enabled": true,
#            "router_address": "192.0.11.11"
#        },
#        "neighbor": [
#            {
#                "neighbor_id": "192.0.11.12",
#                "poll_interval": 10,
#                "priority": 2
#            }
#        ],
#        "parameters": {
#            "abr_type": "cisco",
#            "opaque_lsa": true,
#            "rfc1583_compatibility": true,
#            "router_id": "192.0.1.1"
#        },
#        "passive_interface": [
#            "eth2",
#            "eth1"
#        ],
#        "redistribute": [
#            {
#                "metric": 10,
#                "metric_type": 2,
#                "route_type": "bgp"
#            }
#        ]
#    }
#
# After state:
# -------------
#
# vyos@192# run show configuration commands | grep ospf
# set protocols ospf area 2 area-type 'normal'
# set protocols ospf area 2 authentication 'plaintext-password'
# set protocols ospf area 2 shortcut 'enable'
# set protocols ospf area 3 area-type 'nssa'
# set protocols ospf area 4 area-type stub default-cost '20'
# set protocols ospf area 4 network '192.0.2.0/24'
# set protocols ospf area 4 range 192.0.3.0/24 cost '10'
# set protocols ospf area 4 range 192.0.4.0/24 cost '12'
# set protocols ospf auto-cost reference-bandwidth '2'
# set protocols ospf default-information originate 'always'
# set protocols ospf default-information originate metric '10'
# set protocols ospf default-information originate metric-type '2'
# set protocols ospf default-information originate route-map 'ingress'
# set protocols ospf log-adjacency-changes 'detail'
# set protocols ospf max-metric router-lsa 'administrative'
# set protocols ospf max-metric router-lsa on-shutdown '10'
# set protocols ospf max-metric router-lsa on-startup '10'
# set protocols ospf mpls-te 'enable'
# set protocols ospf mpls-te router-address '192.0.11.11'
# set protocols ospf neighbor 192.0.11.12 poll-interval '10'
# set protocols ospf neighbor 192.0.11.12 priority '2'
# set protocols ospf parameters abr-type 'cisco'
# set protocols ospf parameters 'opaque-lsa'
# set protocols ospf parameters 'rfc1583-compatibility'
# set protocols ospf parameters router-id '192.0.1.1'
# set protocols ospf passive-interface 'eth1'
# set protocols ospf passive-interface 'eth2'
# set protocols ospf redistribute bgp metric '10'
# set protocols ospf redistribute bgp metric-type '2'


# Using merged
#
# Before state:
# -------------
#
# vyos@vyos# run show  configuration commands | grep ospf
#
#
- name: Merge the provided configuration to update existing running configuration
  vyos.vyos.vyos_ospfv2:
    config:
      areas:
      - area_id: '2'
        area_type:
          normal: true
        authentication: plaintext-password
        shortcut: enable
      - area_id: '3'
        area_type:
          nssa:
            set: false
      - area_id: '4'
        area_type:
          stub:
            default_cost: 20
        network:
        - address: 192.0.2.0/24
        - address: 192.0.22.0/24
        - address: 192.0.32.0/24
    state: merged
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
# "before": {
#        "areas": [
#            {
#                "area_id": "2",
#                "area_type": {
#                    "normal": true
#                },
#                "authentication": "plaintext-password",
#                "shortcut": "enable"
#            },
#            {
#                "area_id": "3",
#                "area_type": {
#                    "nssa": {
#                        "set": true
#                    }
#                }
#            },
#            {
#                "area_id": "4",
#                "area_type": {
#                    "stub": {
#                        "default_cost": 20,
#                        "set": true
#                    }
#                },
#                "network": [
#                    {
#                        "address": "192.0.2.0/24"
#                    }
#                ],
#                "range": [
#                    {
#                        "address": "192.0.3.0/24",
#                        "cost": 10
#                    },
#                    {
#                        "address": "192.0.4.0/24",
#                        "cost": 12
#                    }
#                ]
#            }
#        ],
#        "auto_cost": {
#            "reference_bandwidth": 2
#        },
#        "default_information": {
#            "originate": {
#                "always": true,
#                "metric": 10,
#                "metric_type": 2,
#                "route_map": "ingress"
#            }
#        },
#        "log_adjacency_changes": "detail",
#        "max_metric": {
#            "router_lsa": {
#                "administrative": true,
#                "on_shutdown": 10,
#                "on_startup": 10
#            }
#        },
#        "mpls_te": {
#            "enabled": true,
#            "router_address": "192.0.11.11"
#        },
#        "neighbor": [
#            {
#                "neighbor_id": "192.0.11.12",
#                "poll_interval": 10,
#                "priority": 2
#            }
#        ],
#        "parameters": {
#            "abr_type": "cisco",
#            "opaque_lsa": true,
#            "rfc1583_compatibility": true,
#            "router_id": "192.0.1.1"
#        },
#        "passive_interface": [
#            "eth2",
#            "eth1"
#        ],
#        "redistribute": [
#            {
#                "metric": 10,
#                "metric_type": 2,
#                "route_type": "bgp"
#            }
#        ]
#    }
#
#    "commands": [
#       "delete protocols ospf area 4 area-type stub",
#       "set protocols ospf area 4 network 192.0.22.0/24"
#       "set protocols ospf area 4 network 192.0.32.0/24"
#    ]
#
# "after": {
#        "areas": [
#            {
#                "area_id": "2",
#                "area_type": {
#                    "normal": true
#                },
#                "authentication": "plaintext-password",
#                "shortcut": "enable"
#            },
#            {
#                "area_id": "3",
#                "area_type": {
#                    "nssa": {
#                        "set": true
#                    }
#                }
#            },
#            {
#                "area_id": "4",
#                },
#                "network": [
#                    {
#                        "address": "192.0.2.0/24"
#                    },
#                    {
#                        "address": "192.0.22.0/24"
#                    },
#                    {
#                        "address": "192.0.32.0/24"
#                    }
#                ],
#                "range": [
#                    {
#                        "address": "192.0.3.0/24",
#                        "cost": 10
#                    },
#                    {
#                        "address": "192.0.4.0/24",
#                        "cost": 12
#                    }
#                ]
#            }
#        ],
#        "auto_cost": {
#            "reference_bandwidth": 2
#        },
#        "default_information": {
#            "originate": {
#                "always": true,
#                "metric": 10,
#                "metric_type": 2,
#                "route_map": "ingress"
#            }
#        },
#        "log_adjacency_changes": "detail",
#        "max_metric": {
#            "router_lsa": {
#                "administrative": true,
#                "on_shutdown": 10,
#                "on_startup": 10
#            }
#        },
#        "mpls_te": {
#            "enabled": true,
#            "router_address": "192.0.11.11"
#        },
#        "neighbor": [
#            {
#                "neighbor_id": "192.0.11.12",
#                "poll_interval": 10,
#                "priority": 2
#            }
#        ],
#        "parameters": {
#            "abr_type": "cisco",
#            "opaque_lsa": true,
#            "rfc1583_compatibility": true,
#            "router_id": "192.0.1.1"
#        },
#        "passive_interface": [
#            "eth2",
#            "eth1"
#        ],
#        "redistribute": [
#            {
#                "metric": 10,
#                "metric_type": 2,
#                "route_type": "bgp"
#            }
#        ]
#    }
#
# After state:
# -------------
#
# vyos@192# run show configuration commands | grep ospf
# set protocols ospf area 2 area-type 'normal'
# set protocols ospf area 2 authentication 'plaintext-password'
# set protocols ospf area 2 shortcut 'enable'
# set protocols ospf area 3 area-type 'nssa'
# set protocols ospf area 4 network '192.0.2.0/24'
# set protocols ospf area 4 network '192.0.22.0/24'
# set protocols ospf area 4 network '192.0.32.0/24'
# set protocols ospf area 4 range 192.0.3.0/24 cost '10'
# set protocols ospf area 4 range 192.0.4.0/24 cost '12'
# set protocols ospf auto-cost reference-bandwidth '2'
# set protocols ospf default-information originate 'always'
# set protocols ospf default-information originate metric '10'
# set protocols ospf default-information originate metric-type '2'
# set protocols ospf default-information originate route-map 'ingress'
# set protocols ospf log-adjacency-changes 'detail'
# set protocols ospf max-metric router-lsa 'administrative'
# set protocols ospf max-metric router-lsa on-shutdown '10'
# set protocols ospf max-metric router-lsa on-startup '10'
# set protocols ospf mpls-te 'enable'
# set protocols ospf mpls-te router-address '192.0.11.11'
# set protocols ospf neighbor 192.0.11.12 poll-interval '10'
# set protocols ospf neighbor 192.0.11.12 priority '2'
# set protocols ospf parameters abr-type 'cisco'
# set protocols ospf parameters 'opaque-lsa'
# set protocols ospf parameters 'rfc1583-compatibility'
# set protocols ospf parameters router-id '192.0.1.1'
# set protocols ospf passive-interface 'eth1'
# set protocols ospf passive-interface 'eth2'
# set protocols ospf redistribute bgp metric '10'
# set protocols ospf redistribute bgp metric-type '2'


# Using replaced
#
# Before state:
# -------------
#
# vyos@192# run show configuration commands | grep ospf
# set protocols ospf area 2 area-type 'normal'
# set protocols ospf area 2 authentication 'plaintext-password'
# set protocols ospf area 2 shortcut 'enable'
# set protocols ospf area 3 area-type 'nssa'
# set protocols ospf area 4 area-type stub default-cost '20'
# set protocols ospf area 4 network '192.0.2.0/24'
# set protocols ospf area 4 range 192.0.3.0/24 cost '10'
# set protocols ospf area 4 range 192.0.4.0/24 cost '12'
# set protocols ospf auto-cost reference-bandwidth '2'
# set protocols ospf default-information originate 'always'
# set protocols ospf default-information originate metric '10'
# set protocols ospf default-information originate metric-type '2'
# set protocols ospf default-information originate route-map 'ingress'
# set protocols ospf log-adjacency-changes 'detail'
# set protocols ospf max-metric router-lsa 'administrative'
# set protocols ospf max-metric router-lsa on-shutdown '10'
# set protocols ospf max-metric router-lsa on-startup '10'
# set protocols ospf mpls-te 'enable'
# set protocols ospf mpls-te router-address '192.0.11.11'
# set protocols ospf neighbor 192.0.11.12 poll-interval '10'
# set protocols ospf neighbor 192.0.11.12 priority '2'
# set protocols ospf parameters abr-type 'cisco'
# set protocols ospf parameters 'opaque-lsa'
# set protocols ospf parameters 'rfc1583-compatibility'
# set protocols ospf parameters router-id '192.0.1.1'
# set protocols ospf passive-interface 'eth1'
# set protocols ospf passive-interface 'eth2'
# set protocols ospf redistribute bgp metric '10'
# set protocols ospf redistribute bgp metric-type '2'
#
- name: Replace ospfv2 routes attributes configuration.
  vyos.vyos.vyos_ospfv2:
    config:
      log_adjacency_changes: detail
      max_metric:
        router_lsa:
          administrative: true
          on_shutdown: 10
          on_startup: 10
        default_information:
          originate:
            always: true
            metric: 10
            metric_type: 2
            route_map: ingress
        mpls_te:
          enabled: true
          router_address: 192.0.22.22
        auto_cost:
          reference_bandwidth: 2
        neighbor:
        - neighbor_id: 192.0.11.12
          poll_interval: 10
          priority: 2
        redistribute:
        - route_type: bgp
          metric: 10
          metric_type: 2
        passive_interface:
        - eth1
        parameters:
          router_id: 192.0.1.1
          opaque_lsa: true
          rfc1583_compatibility: true
          abr_type: cisco
        areas:
        - area_id: '2'
          area_type:
            normal: true
          authentication: plaintext-password
          shortcut: enable
        - area_id: '4'
          area_type:
            stub:
              default_cost: 20
          network:
          - address: 192.0.2.0/24
          - address: 192.0.12.0/24
          - address: 192.0.22.0/24
          - address: 192.0.32.0/24
          range:
          - address: 192.0.42.0/24
            cost: 10
    state: replaced
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#    "before": {
#        "areas": [
#            {
#                "area_id": "2",
#                "area_type": {
#                    "normal": true
#                },
#                "authentication": "plaintext-password",
#                "shortcut": "enable"
#            },
#            {
#                "area_id": "3",
#                "area_type": {
#                    "nssa": {
#                        "set": true
#                    }
#                }
#            },
#            {
#                "area_id": "4",
#                "area_type": {
#                    "stub": {
#                        "default_cost": 20,
#                        "set": true
#                    }
#                },
#                "network": [
#                    {
#                        "address": "192.0.2.0/24"
#                    }
#                ],
#                "range": [
#                    {
#                        "address": "192.0.3.0/24",
#                        "cost": 10
#                    },
#                    {
#                        "address": "192.0.4.0/24",
#                        "cost": 12
#                    }
#                ]
#            }
#        ],
#        "auto_cost": {
#            "reference_bandwidth": 2
#        },
#        "default_information": {
#            "originate": {
#                "always": true,
#                "metric": 10,
#                "metric_type": 2,
#                "route_map": "ingress"
#            }
#        },
#        "log_adjacency_changes": "detail",
#        "max_metric": {
#            "router_lsa": {
#                "administrative": true,
#                "on_shutdown": 10,
#                "on_startup": 10
#            }
#        },
#        "mpls_te": {
#            "enabled": true,
#            "router_address": "192.0.11.11"
#        },
#        "neighbor": [
#            {
#                "neighbor_id": "192.0.11.12",
#                "poll_interval": 10,
#                "priority": 2
#            }
#        ],
#        "parameters": {
#            "abr_type": "cisco",
#            "opaque_lsa": true,
#            "rfc1583_compatibility": true,
#            "router_id": "192.0.1.1"
#        },
#        "passive_interface": [
#            "eth2",
#            "eth1"
#        ],
#        "redistribute": [
#            {
#                "metric": 10,
#                "metric_type": 2,
#                "route_type": "bgp"
#            }
#        ]
#    }
#
# "commands": [
#     "delete protocols ospf passive-interface eth2",
#     "delete protocols ospf area 3",
#     "delete protocols ospf area 4 range 192.0.3.0/24 cost",
#     "delete protocols ospf area 4 range 192.0.3.0/24",
#     "delete protocols ospf area 4 range 192.0.4.0/24 cost",
#     "delete protocols ospf area 4 range 192.0.4.0/24",
#     "set protocols ospf mpls-te router-address '192.0.22.22'",
#     "set protocols ospf area 4 range 192.0.42.0/24 cost 10",
#     "set protocols ospf area 4 range 192.0.42.0/24",
#     "set protocols ospf area 4 network 192.0.12.0/24",
#     "set protocols ospf area 4 network 192.0.22.0/24",
#     "set protocols ospf area 4 network 192.0.32.0/24"
#    ]
#
#    "after": {
#        "areas": [
#            {
#                "area_id": "2",
#                "area_type": {
#                    "normal": true
#                },
#                "authentication": "plaintext-password",
#                "shortcut": "enable"
#            },
#            {
#                "area_id": "4",
#                "area_type": {
#                    "stub": {
#                        "default_cost": 20,
#                        "set": true
#                    }
#                },
#                "network": [
#                    {
#                        "address": "192.0.12.0/24"
#                    },
#                    {
#                        "address": "192.0.2.0/24"
#                    },
#                    {
#                        "address": "192.0.22.0/24"
#                    },
#                    {
#                        "address": "192.0.32.0/24"
#                    }
#                ],
#                "range": [
#                    {
#                        "address": "192.0.42.0/24",
#                        "cost": 10
#                    }
#                ]
#            }
#        ],
#        "auto_cost": {
#            "reference_bandwidth": 2
#        },
#        "default_information": {
#            "originate": {
#                "always": true,
#                "metric": 10,
#                "metric_type": 2,
#                "route_map": "ingress"
#            }
#        },
#        "log_adjacency_changes": "detail",
#        "max_metric": {
#            "router_lsa": {
#                "administrative": true,
#                "on_shutdown": 10,
#                "on_startup": 10
#            }
#        },
#        "mpls_te": {
#            "enabled": true,
#            "router_address": "192.0.22.22"
#        },
#        "neighbor": [
#            {
#                "neighbor_id": "192.0.11.12",
#                "poll_interval": 10,
#                "priority": 2
#            }
#        ],
#        "parameters": {
#            "abr_type": "cisco",
#            "opaque_lsa": true,
#            "rfc1583_compatibility": true,
#            "router_id": "192.0.1.1"
#        },
#        "passive_interface": [
#            "eth1"
#        ],
#        "redistribute": [
#            {
#                "metric": 10,
#                "metric_type": 2,
#                "route_type": "bgp"
#            }
#        ]
#    }
#
# After state:
# -------------
#
# vyos@192# run show configuration commands | grep ospf
# set protocols ospf area 2 area-type 'normal'
# set protocols ospf area 2 authentication 'plaintext-password'
# set protocols ospf area 2 shortcut 'enable'
# set protocols ospf area 4 area-type stub default-cost '20'
# set protocols ospf area 4 network '192.0.2.0/24'
# set protocols ospf area 4 network '192.0.12.0/24'
# set protocols ospf area 4 network '192.0.22.0/24'
# set protocols ospf area 4 network '192.0.32.0/24'
# set protocols ospf area 4 range 192.0.42.0/24 cost '10'
# set protocols ospf auto-cost reference-bandwidth '2'
# set protocols ospf default-information originate 'always'
# set protocols ospf default-information originate metric '10'
# set protocols ospf default-information originate metric-type '2'
# set protocols ospf default-information originate route-map 'ingress'
# set protocols ospf log-adjacency-changes 'detail'
# set protocols ospf max-metric router-lsa 'administrative'
# set protocols ospf max-metric router-lsa on-shutdown '10'
# set protocols ospf max-metric router-lsa on-startup '10'
# set protocols ospf mpls-te 'enable'
# set protocols ospf mpls-te router-address '192.0.22.22'
# set protocols ospf neighbor 192.0.11.12 poll-interval '10'
# set protocols ospf neighbor 192.0.11.12 priority '2'
# set protocols ospf parameters abr-type 'cisco'
# set protocols ospf parameters 'opaque-lsa'
# set protocols ospf parameters 'rfc1583-compatibility'
# set protocols ospf parameters router-id '192.0.1.1'
# set protocols ospf passive-interface 'eth1'
# set protocols ospf redistribute bgp metric '10'
# set protocols ospf redistribute bgp metric-type '2'


# Using rendered
#
#
- name: Render the commands for provided  configuration
  vyos.vyos.vyos_ospfv2:
    config:
      log_adjacency_changes: detail
      max_metric:
        router_lsa:
          administrative: true
          on_shutdown: 10
          on_startup: 10
        default_information:
          originate:
            always: true
            metric: 10
            metric_type: 2
            route_map: ingress
        mpls_te:
          enabled: true
          router_address: 192.0.11.11
        auto_cost:
          reference_bandwidth: 2
        neighbor:
        - neighbor_id: 192.0.11.12
          poll_interval: 10
          priority: 2
        redistribute:
        - route_type: bgp
          metric: 10
          metric_type: 2
        passive_interface:
        - eth1
        - eth2
        parameters:
          router_id: 192.0.1.1
          opaque_lsa: true
          rfc1583_compatibility: true
          abr_type: cisco
        areas:
        - area_id: '2'
          area_type:
            normal: true
          authentication: plaintext-password
          shortcut: enable
        - area_id: '3'
          area_type:
            nssa:
              set: true
        - area_id: '4'
          area_type:
            stub:
              default_cost: 20
          network:
          - address: 192.0.2.0/24
          range:
          - address: 192.0.3.0/24
            cost: 10
          - address: 192.0.4.0/24
            cost: 12
    state: rendered
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "rendered": [
#        [
#       "set protocols ospf mpls-te enable",
#       "set protocols ospf mpls-te router-address '192.0.11.11'",
#       "set protocols ospf redistribute bgp",
#       "set protocols ospf redistribute bgp metric-type 2",
#       "set protocols ospf redistribute bgp metric 10",
#       "set protocols ospf default-information originate metric-type 2",
#       "set protocols ospf default-information originate always",
#       "set protocols ospf default-information originate metric 10",
#       "set protocols ospf default-information originate route-map ingress",
#       "set protocols ospf auto-cost reference-bandwidth '2'",
#       "set protocols ospf parameters router-id '192.0.1.1'",
#       "set protocols ospf parameters opaque-lsa",
#       "set protocols ospf parameters abr-type 'cisco'",
#       "set protocols ospf parameters rfc1583-compatibility",
#       "set protocols ospf passive-interface eth1",
#       "set protocols ospf passive-interface eth2",
#       "set protocols ospf max-metric router-lsa on-shutdown 10",
#       "set protocols ospf max-metric router-lsa administrative",
#       "set protocols ospf max-metric router-lsa on-startup 10",
#       "set protocols ospf log-adjacency-changes 'detail'",
#       "set protocols ospf neighbor 192.0.11.12 priority 2",
#       "set protocols ospf neighbor 192.0.11.12 poll-interval 10",
#       "set protocols ospf neighbor 192.0.11.12",
#       "set protocols ospf area '2'",
#       "set protocols ospf area 2 authentication plaintext-password",
#       "set protocols ospf area 2 shortcut enable",
#       "set protocols ospf area 2 area-type normal",
#       "set protocols ospf area '3'",
#       "set protocols ospf area 3 area-type nssa",
#       "set protocols ospf area 4 range 192.0.3.0/24 cost 10",
#       "set protocols ospf area 4 range 192.0.3.0/24",
#       "set protocols ospf area 4 range 192.0.4.0/24 cost 12",
#       "set protocols ospf area 4 range 192.0.4.0/24",
#       "set protocols ospf area 4 area-type stub default-cost 20",
#       "set protocols ospf area '4'",
#       "set protocols ospf area 4 network 192.0.2.0/24"
#    ]


# Using parsed
#
#
- name: Parse the commands for provided  structured configuration
  vyos.vyos.vyos_ospfv2:
    running_config:
      "set protocols ospf area 2 area-type 'normal'
       set protocols ospf area 2 authentication 'plaintext-password'
       set protocols ospf area 2 shortcut 'enable'
       set protocols ospf area 3 area-type 'nssa'
       set protocols ospf area 4 area-type stub default-cost '20'
       set protocols ospf area 4 network '192.0.2.0/24'
       set protocols ospf area 4 range 192.0.3.0/24 cost '10'
       set protocols ospf area 4 range 192.0.4.0/24 cost '12'
       set protocols ospf auto-cost reference-bandwidth '2'
       set protocols ospf default-information originate 'always'
       set protocols ospf default-information originate metric '10'
       set protocols ospf default-information originate metric-type '2'
       set protocols ospf default-information originate route-map 'ingress'
       set protocols ospf log-adjacency-changes 'detail'
       set protocols ospf max-metric router-lsa 'administrative'
       set protocols ospf max-metric router-lsa on-shutdown '10'
       set protocols ospf max-metric router-lsa on-startup '10'
       set protocols ospf mpls-te 'enable'
       set protocols ospf mpls-te router-address '192.0.11.11'
       set protocols ospf neighbor 192.0.11.12 poll-interval '10'
       set protocols ospf neighbor 192.0.11.12 priority '2'
       set protocols ospf parameters abr-type 'cisco'
       set protocols ospf parameters 'opaque-lsa'
       set protocols ospf parameters 'rfc1583-compatibility'
       set protocols ospf parameters router-id '192.0.1.1'
       set protocols ospf passive-interface 'eth1'
       set protocols ospf passive-interface 'eth2'
       set protocols ospf redistribute bgp metric '10'
       set protocols ospf redistribute bgp metric-type '2'"
    state: parsed
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#
# "parsed": {
#        "areas": [
#            {
#                "area_id": "2",
#                "area_type": {
#                    "normal": true
#                },
#                "authentication": "plaintext-password",
#                "shortcut": "enable"
#            },
#            {
#                "area_id": "3",
#                "area_type": {
#                    "nssa": {
#                        "set": true
#                    }
#                }
#            },
#            {
#                "area_id": "4",
#                "area_type": {
#                    "stub": {
#                        "default_cost": 20,
#                        "set": true
#                    }
#                },
#                "network": [
#                    {
#                        "address": "192.0.2.0/24"
#                    }
#                ],
#                "range": [
#                    {
#                        "address": "192.0.3.0/24",
#                        "cost": 10
#                    },
#                    {
#                        "address": "192.0.4.0/24",
#                        "cost": 12
#                    }
#                ]
#            }
#        ],
#        "auto_cost": {
#            "reference_bandwidth": 2
#        },
#        "default_information": {
#            "originate": {
#                "always": true,
#                "metric": 10,
#                "metric_type": 2,
#                "route_map": "ingress"
#            }
#        },
#        "log_adjacency_changes": "detail",
#        "max_metric": {
#            "router_lsa": {
#                "administrative": true,
#                "on_shutdown": 10,
#                "on_startup": 10
#            }
#        },
#        "mpls_te": {
#            "enabled": true,
#            "router_address": "192.0.11.11"
#        },
#        "neighbor": [
#            {
#                "neighbor_id": "192.0.11.12",
#                "poll_interval": 10,
#                "priority": 2
#            }
#        ],
#        "parameters": {
#            "abr_type": "cisco",
#            "opaque_lsa": true,
#            "rfc1583_compatibility": true,
#            "router_id": "192.0.1.1"
#        },
#        "passive_interface": [
#            "eth2",
#            "eth1"
#        ],
#        "redistribute": [
#            {
#                "metric": 10,
#                "metric_type": 2,
#                "route_type": "bgp"
#            }
#        ]
#    }
# }


# Using gathered
#
# Before state:
# -------------
#
# vyos@192# run show configuration commands | grep ospf
# set protocols ospf area 2 area-type 'normal'
# set protocols ospf area 2 authentication 'plaintext-password'
# set protocols ospf area 2 shortcut 'enable'
# set protocols ospf area 3 area-type 'nssa'
# set protocols ospf area 4 area-type stub default-cost '20'
# set protocols ospf area 4 network '192.0.2.0/24'
# set protocols ospf area 4 range 192.0.3.0/24 cost '10'
# set protocols ospf area 4 range 192.0.4.0/24 cost '12'
# set protocols ospf auto-cost reference-bandwidth '2'
# set protocols ospf default-information originate 'always'
# set protocols ospf default-information originate metric '10'
# set protocols ospf default-information originate metric-type '2'
# set protocols ospf default-information originate route-map 'ingress'
# set protocols ospf log-adjacency-changes 'detail'
# set protocols ospf max-metric router-lsa 'administrative'
# set protocols ospf max-metric router-lsa on-shutdown '10'
# set protocols ospf max-metric router-lsa on-startup '10'
# set protocols ospf mpls-te 'enable'
# set protocols ospf mpls-te router-address '192.0.11.11'
# set protocols ospf neighbor 192.0.11.12 poll-interval '10'
# set protocols ospf neighbor 192.0.11.12 priority '2'
# set protocols ospf parameters abr-type 'cisco'
# set protocols ospf parameters 'opaque-lsa'
# set protocols ospf parameters 'rfc1583-compatibility'
# set protocols ospf parameters router-id '192.0.1.1'
# set protocols ospf passive-interface 'eth1'
# set protocols ospf passive-interface 'eth2'
# set protocols ospf redistribute bgp metric '10'
# set protocols ospf redistribute bgp metric-type '2'
#
- name: Gather ospfv2 routes config with provided configurations
  vyos.vyos.vyos_ospfv2:
    config:
    state: gathered
#
#
# -------------------------
# Module Execution Result
# -------------------------
#
#    "gathered": {
#        "areas": [
#            {
#                "area_id": "2",
#                "area_type": {
#                    "normal": true
#                },
#                "authentication": "plaintext-password",
#                "shortcut": "enable"
#            },
#            {
#                "area_id": "3",
#                "area_type": {
#                    "nssa": {
#                        "set": true
#                    }
#                }
#            },
#            {
#                "area_id": "4",
#                "area_type": {
#                    "stub": {
#                        "default_cost": 20,
#                        "set": true
#                    }
#                },
#                "network": [
#                    {
#                        "address": "192.0.2.0/24"
#                    }
#                ],
#                "range": [
#                    {
#                        "address": "192.0.3.0/24",
#                        "cost": 10
#                    },
#                    {
#                        "address": "192.0.4.0/24",
#                        "cost": 12
#                    }
#                ]
#            }
#        ],
#        "auto_cost": {
#            "reference_bandwidth": 2
#        },
#        "default_information": {
#            "originate": {
#                "always": true,
#                "metric": 10,
#                "metric_type": 2,
#                "route_map": "ingress"
#            }
#        },
#        "log_adjacency_changes": "detail",
#        "max_metric": {
#            "router_lsa": {
#                "administrative": true,
#                "on_shutdown": 10,
#                "on_startup": 10
#            }
#        },
#        "mpls_te": {
#            "enabled": true,
#            "router_address": "192.0.11.11"
#        },
#        "neighbor": [
#            {
#                "neighbor_id": "192.0.11.12",
#                "poll_interval": 10,
#                "priority": 2
#            }
#        ],
#        "parameters": {
#            "abr_type": "cisco",
#            "opaque_lsa": true,
#            "rfc1583_compatibility": true,
#            "router_id": "192.0.1.1"
#        },
#        "passive_interface": [
#            "eth2",
#            "eth1"
#        ],
#        "redistribute": [
#            {
#                "metric": 10,
#                "metric_type": 2,
#                "route_type": "bgp"
#            }
#        ]
#    }
#
# After state:
# -------------
#
# vyos@192# run show configuration commands | grep ospf
# set protocols ospf area 2 area-type 'normal'
# set protocols ospf area 2 authentication 'plaintext-password'
# set protocols ospf area 2 shortcut 'enable'
# set protocols ospf area 3 area-type 'nssa'
# set protocols ospf area 4 area-type stub default-cost '20'
# set protocols ospf area 4 network '192.0.2.0/24'
# set protocols ospf area 4 range 192.0.3.0/24 cost '10'
# set protocols ospf area 4 range 192.0.4.0/24 cost '12'
# set protocols ospf auto-cost reference-bandwidth '2'
# set protocols ospf default-information originate 'always'
# set protocols ospf default-information originate metric '10'
# set protocols ospf default-information originate metric-type '2'
# set protocols ospf default-information originate route-map 'ingress'
# set protocols ospf log-adjacency-changes 'detail'
# set protocols ospf max-metric router-lsa 'administrative'
# set protocols ospf max-metric router-lsa on-shutdown '10'
# set protocols ospf max-metric router-lsa on-startup '10'
# set protocols ospf mpls-te 'enable'
# set protocols ospf mpls-te router-address '192.0.11.11'
# set protocols ospf neighbor 192.0.11.12 poll-interval '10'
# set protocols ospf neighbor 192.0.11.12 priority '2'
# set protocols ospf parameters abr-type 'cisco'
# set protocols ospf parameters 'opaque-lsa'
# set protocols ospf parameters 'rfc1583-compatibility'
# set protocols ospf parameters router-id '192.0.1.1'
# set protocols ospf passive-interface 'eth1'
# set protocols ospf passive-interface 'eth2'
# set protocols ospf redistribute bgp metric '10'
# set protocols ospf redistribute bgp metric-type '2'


# Using deleted
#
# Before state
# -------------
#
# vyos@192# run show configuration commands | grep ospf
# set protocols ospf area 2 area-type 'normal'
# set protocols ospf area 2 authentication 'plaintext-password'
# set protocols ospf area 2 shortcut 'enable'
# set protocols ospf area 3 area-type 'nssa'
# set protocols ospf area 4 area-type stub default-cost '20'
# set protocols ospf area 4 network '192.0.2.0/24'
# set protocols ospf area 4 range 192.0.3.0/24 cost '10'
# set protocols ospf area 4 range 192.0.4.0/24 cost '12'
# set protocols ospf auto-cost reference-bandwidth '2'
# set protocols ospf default-information originate 'always'
# set protocols ospf default-information originate metric '10'
# set protocols ospf default-information originate metric-type '2'
# set protocols ospf default-information originate route-map 'ingress'
# set protocols ospf log-adjacency-changes 'detail'
# set protocols ospf max-metric router-lsa 'administrative'
# set protocols ospf max-metric router-lsa on-shutdown '10'
# set protocols ospf max-metric router-lsa on-startup '10'
# set protocols ospf mpls-te 'enable'
# set protocols ospf mpls-te router-address '192.0.11.11'
# set protocols ospf neighbor 192.0.11.12 poll-interval '10'
# set protocols ospf neighbor 192.0.11.12 priority '2'
# set protocols ospf parameters abr-type 'cisco'
# set protocols ospf parameters 'opaque-lsa'
# set protocols ospf parameters 'rfc1583-compatibility'
# set protocols ospf parameters router-id '192.0.1.1'
# set protocols ospf passive-interface 'eth1'
# set protocols ospf passive-interface 'eth2'
# set protocols ospf redistribute bgp metric '10'
# set protocols ospf redistribute bgp metric-type '2'
#
- name: Delete attributes of ospfv2 routes.
  vyos.vyos.vyos_ospfv2:
    config:
    state: deleted
#
#
# ------------------------
# Module Execution Results
# ------------------------
#
#    "before": {
#        "areas": [
#            {
#                "area_id": "2",
#                "area_type": {
#                    "normal": true
#                },
#                "authentication": "plaintext-password",
#                "shortcut": "enable"
#            },
#            {
#                "area_id": "3",
#                "area_type": {
#                    "nssa": {
#                        "set": true
#                    }
#                }
#            },
#            {
#                "area_id": "4",
#                "area_type": {
#                    "stub": {
#                        "default_cost": 20,
#                        "set": true
#                    }
#                },
#                "network": [
#                    {
#                        "address": "192.0.2.0/24"
#                    }
#                ],
#                "range": [
#                    {
#                        "address": "192.0.3.0/24",
#                        "cost": 10
#                    },
#                    {
#                        "address": "192.0.4.0/24",
#                        "cost": 12
#                    }
#                ]
#            }
#        ],
#        "auto_cost": {
#            "reference_bandwidth": 2
#        },
#        "default_information": {
#            "originate": {
#                "always": true,
#                "metric": 10,
#                "metric_type": 2,
#                "route_map": "ingress"
#            }
#        },
#        "log_adjacency_changes": "detail",
#        "max_metric": {
#            "router_lsa": {
#                "administrative": true,
#                "on_shutdown": 10,
#                "on_startup": 10
#            }
#        },
#        "mpls_te": {
#            "enabled": true,
#            "router_address": "192.0.11.11"
#        },
#        "neighbor": [
#            {
#                "neighbor_id": "192.0.11.12",
#                "poll_interval": 10,
#                "priority": 2
#            }
#        ],
#        "parameters": {
#            "abr_type": "cisco",
#            "opaque_lsa": true,
#            "rfc1583_compatibility": true,
#            "router_id": "192.0.1.1"
#        },
#        "passive_interface": [
#            "eth2",
#            "eth1"
#        ],
#        "redistribute": [
#            {
#                "metric": 10,
#                "metric_type": 2,
#                "route_type": "bgp"
#            }
#        ]
#    }
# "commands": [
#        "delete protocols ospf"
#    ]
#
# "after": {}
# After state
# ------------
# vyos@192# run show configuration commands | grep ospf
#

"""
RETURN = """
before:
  description: The configuration prior to the model invocation.
  returned: always
  type: dict
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
after:
  description: The resulting configuration model invocation.
  returned: when changed
  type: dict
  sample: >
    The configuration returned will always be in the same format
     of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample:
    - "set protocols ospf parameters router-id 192.0.1.1"
    - "set protocols ospf passive-interface 'eth1'"
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.vyos.vyos.plugins.module_utils.network.vyos.argspec.ospfv2.ospfv2 import (
    Ospfv2Args,
)
from ansible_collections.vyos.vyos.plugins.module_utils.network.vyos.config.ospfv2.ospfv2 import (
    Ospfv2,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """
    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    mutually_exclusive = [("config", "running_config")]
    module = AnsibleModule(
        argument_spec=Ospfv2Args.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
        mutually_exclusive=mutually_exclusive,
    )

    result = Ospfv2(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
