/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.ast.groovy.visitor;

import io.micronaut.ast.groovy.visitor.GroovyClassElement;
import io.micronaut.ast.groovy.visitor.GroovyVisitorContext;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.GenericPlaceholderElement;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.codehaus.groovy.ast.ClassNode;

@Internal
final class GroovyGenericPlaceholderElement
extends GroovyClassElement
implements GenericPlaceholderElement {
    GroovyGenericPlaceholderElement(GroovyVisitorContext visitorContext, ClassNode classNode, AnnotationMetadata annotationMetadata, int arrayDimensions) {
        super(visitorContext, classNode, annotationMetadata, null, arrayDimensions);
    }

    @NonNull
    public List<? extends ClassElement> getBounds() {
        ClassNode singleRedirect = this.classNode.asGenericsType().getUpperBounds()[0];
        return Collections.singletonList(this.toClassElement(singleRedirect));
    }

    @NonNull
    public String getVariableName() {
        return this.classNode.getUnresolvedName();
    }

    public Optional<Element> getDeclaringElement() {
        return Optional.empty();
    }

    @Override
    public ClassElement withArrayDimensions(int arrayDimensions) {
        return new GroovyGenericPlaceholderElement(this.visitorContext, this.classNode, this.getAnnotationMetadata(), arrayDimensions);
    }

    public ClassElement foldBoundGenericTypes(@NonNull Function<ClassElement, ClassElement> fold) {
        Objects.requireNonNull(fold, "Function argument cannot be null");
        return fold.apply((ClassElement)this);
    }
}

