/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public class PleaseWaitDialog
extends JDialog
implements PleaseWaitProgressMonitor.ProgressMonitorDialog {
    private final JProgressBar progressBar = new JProgressBar();
    private final JLabel currentAction = new JLabel("");
    private final JLabel customText = new JLabel("");
    private JButton btnCancel;
    private JButton btnInBackground;
    private final JosmTextArea taLog = new JosmTextArea(5, 50);
    private final JScrollPane spLog = new JScrollPane(this.taLog);

    public PleaseWaitDialog(Component parent) {
        super((Window)GuiHelper.getFrameForComponent(parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.initDialog();
    }

    private void initDialog() {
        this.setLayout(new GridBagLayout());
        JPanel pane = new JPanel(new GridBagLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        pane.add((Component)this.currentAction, GBC.eol().fill(2));
        pane.add((Component)this.customText, GBC.eol().fill(2));
        pane.add((Component)this.progressBar, GBC.eop().fill(2));
        JPanel buttons = new JPanel(new GridBagLayout());
        this.btnCancel = new JButton(I18n.tr("Cancel", new Object[0]));
        this.btnCancel.setIcon(ImageProvider.get("cancel"));
        this.btnCancel.setToolTipText(I18n.tr("Click to cancel the current operation", new Object[0]));
        buttons.add(this.btnCancel);
        this.btnInBackground = new JButton(I18n.tr("In background", new Object[0]));
        this.btnInBackground.setToolTipText(I18n.tr("Click to run job in background", new Object[0]));
        buttons.add((Component)this.btnInBackground, GBC.std().fill(3).insets(5, 0, 0, 0));
        pane.add((Component)buttons, GBC.eol().anchor(10));
        GBC gc = GBC.eol().fill(1);
        gc.weighty = 1.0;
        gc.weightx = 1.0;
        pane.add((Component)this.spLog, gc);
        this.spLog.setVisible(false);
        this.setContentPane(pane);
        this.setCustomText("");
        this.setLocationRelativeTo(this.getParent());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent ev) {
                int w = PleaseWaitDialog.this.getWidth();
                if (w > 200) {
                    Config.getPref().putInt("progressdialog.size", w);
                }
            }
        });
    }

    @Override
    public void setIndeterminate(boolean newValue) {
        UIManager.put("ProgressBar.cycleTime", UIManager.getInt("ProgressBar.repaintInterval") * 100);
        this.progressBar.setIndeterminate(newValue);
    }

    protected void adjustLayout() {
        this.invalidate();
        this.setDropTarget(null);
        this.pack();
        this.setSize(Config.getPref().getInt("progressdialog.size", 600), this.getSize().height);
    }

    @Override
    public void setCustomText(String text) {
        if (Utils.isBlank(text)) {
            this.customText.setVisible(false);
            this.adjustLayout();
            return;
        }
        this.customText.setText(text);
        if (!this.customText.isVisible()) {
            this.customText.setVisible(true);
            this.adjustLayout();
        }
    }

    @Override
    public void setCurrentAction(String text) {
        this.currentAction.setText(text);
    }

    @Override
    public void appendLogMessage(String message) {
        if (Utils.isBlank(message)) {
            return;
        }
        if (!this.spLog.isVisible()) {
            this.spLog.setVisible(true);
            this.taLog.setVisible(true);
            this.adjustLayout();
        }
        this.taLog.append(message);
        this.taLog.append("\n");
        this.spLog.getVerticalScrollBar().setValue(this.spLog.getVerticalScrollBar().getMaximum());
    }

    public void setCancelEnabled(boolean enabled) {
        this.btnCancel.setEnabled(enabled);
    }

    public void setInBackgroundPossible(boolean value) {
        this.btnInBackground.setVisible(value);
    }

    public void setCancelCallback(ActionListener callback) {
        if (callback == null) {
            ActionListener[] listeners;
            for (ActionListener l : listeners = this.btnCancel.getActionListeners()) {
                this.btnCancel.removeActionListener(l);
            }
        } else {
            this.btnCancel.addActionListener(callback);
        }
    }

    public void setInBackgroundCallback(ActionListener callback) {
        if (callback == null) {
            ActionListener[] listeners;
            for (ActionListener l : listeners = this.btnInBackground.getActionListeners()) {
                this.btnInBackground.removeActionListener(l);
            }
        } else {
            this.btnInBackground.addActionListener(callback);
        }
    }

    @Override
    public void updateProgress(int progress) {
        this.progressBar.setValue(progress);
        this.progressBar.repaint();
    }

    public void setMaximumProgress(int progressBarMax) {
        this.progressBar.setMaximum(progressBarMax);
    }
}

