// api-header.mustache

// licenseInfo.mustache

/**
 * Libre Graph API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1.0.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#ifndef OAI_OAIEducationUserApi_H
#define OAI_OAIEducationUserApi_H

#include "OAIHelpers.h"
#include "OAIHttpRequest.h"
#include "OAIServerConfiguration.h"
#include "OAIOauth.h"

#include "OAICollection_of_educationUser.h"
#include "OAIEducationUser.h"
#include "OAIOdata_error.h"
#include <QSet>
#include <QString>

#include <QObject>
#include <QByteArray>
#include <QStringList>
#include <QList>
#include <QNetworkAccessManager>

namespace OpenAPI {

class OAIEducationUserApi : public QObject {
    Q_OBJECT

public:
    OAIEducationUserApi(const int timeOut = 0);
    ~OAIEducationUserApi();

    void initializeServerConfigs();
    int setDefaultServerValue(int serverIndex,const QString &operation, const QString &variable,const QString &val);
    void setServerIndex(const QString &operation, int serverIndex);
    void setApiKey(const QString &apiKeyName, const QString &apiKey);
    void setBearerToken(const QString &token);
    void setUsername(const QString &username);
    void setPassword(const QString &password);
    void setTimeOut(const int timeOut);
    void setWorkingDirectory(const QString &path);
    void setNetworkAccessManager(QNetworkAccessManager* manager);
    int addServerConfiguration(const QString &operation, const QUrl &url, const QString &description = "", const QMap<QString, OAIServerVariable> &variables = QMap<QString, OAIServerVariable>());
    void setNewServerForAllOperations(const QUrl &url, const QString &description = "", const QMap<QString, OAIServerVariable> &variables =  QMap<QString, OAIServerVariable>());
    void setNewServer(const QString &operation, const QUrl &url, const QString &description = "", const QMap<QString, OAIServerVariable> &variables =  QMap<QString, OAIServerVariable>());
    void addHeaders(const QString &key, const QString &value);
    void enableRequestCompression();
    void enableResponseCompression();
    void abortRequests();
    QString getParamStylePrefix(const QString &style);
    QString getParamStyleSuffix(const QString &style);
    QString getParamStyleDelimiter(const QString &style, const QString &name, bool isExplode);

    /**
    * @param[in]  oai_education_user OAIEducationUser [required]
    */
    void createEducationUser(const OAIEducationUser &oai_education_user);

    /**
    * @param[in]  user_id QString [required]
    */
    void deleteEducationUser(const QString &user_id);

    /**
    * @param[in]  user_id QString [required]
    * @param[in]  expand QSet<QString> [optional]
    */
    void getEducationUser(const QString &user_id, const ::OpenAPI::OptionalParam<QSet<QString>> &expand = ::OpenAPI::OptionalParam<QSet<QString>>());

    /**
    * @param[in]  orderby QSet<QString> [optional]
    * @param[in]  expand QSet<QString> [optional]
    */
    void listEducationUsers(const ::OpenAPI::OptionalParam<QSet<QString>> &orderby = ::OpenAPI::OptionalParam<QSet<QString>>(), const ::OpenAPI::OptionalParam<QSet<QString>> &expand = ::OpenAPI::OptionalParam<QSet<QString>>());

    /**
    * @param[in]  user_id QString [required]
    * @param[in]  oai_education_user OAIEducationUser [required]
    */
    void updateEducationUser(const QString &user_id, const OAIEducationUser &oai_education_user);


private:
    QMap<QString,int> _serverIndices;
    QMap<QString,QList<OAIServerConfiguration>> _serverConfigs;
    QMap<QString, QString> _apiKeys;
    QString _bearerToken;
    QString _username;
    QString _password;
    int _timeOut;
    QString _workingDirectory;
    QNetworkAccessManager* _manager;
    QMap<QString, QString> _defaultHeaders;
    bool _isResponseCompressionEnabled;
    bool _isRequestCompressionEnabled;
    OAIHttpRequestInput _latestInput;
    OAIHttpRequestWorker *_latestWorker;
    QStringList _latestScope;
    OauthCode _authFlow;
    OauthImplicit _implicitFlow;
    OauthCredentials _credentialFlow;
    OauthPassword _passwordFlow;
    int _OauthMethod = 0;

    void createEducationUserCallback(OAIHttpRequestWorker *worker);
    void deleteEducationUserCallback(OAIHttpRequestWorker *worker);
    void getEducationUserCallback(OAIHttpRequestWorker *worker);
    void listEducationUsersCallback(OAIHttpRequestWorker *worker);
    void updateEducationUserCallback(OAIHttpRequestWorker *worker);

signals:

    void createEducationUserSignal(OAIEducationUser summary);
    void deleteEducationUserSignal();
    void getEducationUserSignal(OAIEducationUser summary);
    void listEducationUsersSignal(OAICollection_of_educationUser summary);
    void updateEducationUserSignal(OAIEducationUser summary);

    void createEducationUserSignalFull(OAIHttpRequestWorker *worker, OAIEducationUser summary);
    void deleteEducationUserSignalFull(OAIHttpRequestWorker *worker);
    void getEducationUserSignalFull(OAIHttpRequestWorker *worker, OAIEducationUser summary);
    void listEducationUsersSignalFull(OAIHttpRequestWorker *worker, OAICollection_of_educationUser summary);
    void updateEducationUserSignalFull(OAIHttpRequestWorker *worker, OAIEducationUser summary);

    void createEducationUserSignalE(OAIEducationUser summary, QNetworkReply::NetworkError error_type, QString error_str);
    void deleteEducationUserSignalE(QNetworkReply::NetworkError error_type, QString error_str);
    void getEducationUserSignalE(OAIEducationUser summary, QNetworkReply::NetworkError error_type, QString error_str);
    void listEducationUsersSignalE(OAICollection_of_educationUser summary, QNetworkReply::NetworkError error_type, QString error_str);
    void updateEducationUserSignalE(OAIEducationUser summary, QNetworkReply::NetworkError error_type, QString error_str);

    void createEducationUserSignalEFull(OAIHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);
    void deleteEducationUserSignalEFull(OAIHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);
    void getEducationUserSignalEFull(OAIHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);
    void listEducationUsersSignalEFull(OAIHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);
    void updateEducationUserSignalEFull(OAIHttpRequestWorker *worker, QNetworkReply::NetworkError error_type, QString error_str);

    void abortRequestsSignal();
    void allPendingRequestsCompleted();

public slots:
    void tokenAvailable();
    
};

} // namespace OpenAPI
#endif
