/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.action.OriginalIndices;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.common.Nullable;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.Countable;
import org.opensearch.common.util.PlainIterator;
import org.opensearch.index.shard.ShardId;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.internal.ShardSearchContextId;

public final class SearchShardIterator
implements Comparable<SearchShardIterator>,
Countable {
    private final OriginalIndices originalIndices;
    private final String clusterAlias;
    private final ShardId shardId;
    private boolean skip = false;
    private final ShardSearchContextId searchContextId;
    private final TimeValue searchContextKeepAlive;
    private final PlainIterator<String> targetNodesIterator;

    public SearchShardIterator(@Nullable String clusterAlias, ShardId shardId, List<ShardRouting> shards, OriginalIndices originalIndices) {
        this(clusterAlias, shardId, shards.stream().map(ShardRouting::currentNodeId).collect(Collectors.toList()), originalIndices, null, null);
    }

    public SearchShardIterator(@Nullable String clusterAlias, ShardId shardId, List<String> targetNodeIds, OriginalIndices originalIndices, ShardSearchContextId searchContextId, TimeValue searchContextKeepAlive) {
        this.shardId = shardId;
        this.targetNodesIterator = new PlainIterator<String>(targetNodeIds);
        this.originalIndices = originalIndices;
        this.clusterAlias = clusterAlias;
        this.searchContextId = searchContextId;
        this.searchContextKeepAlive = searchContextKeepAlive;
        assert (searchContextKeepAlive == null || searchContextId != null);
    }

    public OriginalIndices getOriginalIndices() {
        return this.originalIndices;
    }

    @Nullable
    public String getClusterAlias() {
        return this.clusterAlias;
    }

    public SearchShardTarget nextOrNull() {
        String nodeId = this.targetNodesIterator.nextOrNull();
        if (nodeId != null) {
            return new SearchShardTarget(nodeId, this.shardId, this.clusterAlias, this.originalIndices);
        }
        return null;
    }

    int remaining() {
        return this.targetNodesIterator.remaining();
    }

    ShardSearchContextId getSearchContextId() {
        return this.searchContextId;
    }

    TimeValue getSearchContextKeepAlive() {
        return this.searchContextKeepAlive;
    }

    List<String> getTargetNodeIds() {
        return this.targetNodesIterator.asList();
    }

    void resetAndSkip() {
        this.reset();
        this.skip = true;
    }

    void reset() {
        this.targetNodesIterator.reset();
    }

    boolean skip() {
        return this.skip;
    }

    @Override
    public int size() {
        return this.targetNodesIterator.size();
    }

    ShardId shardId() {
        return this.shardId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchShardIterator that = (SearchShardIterator)o;
        return this.shardId.equals(that.shardId) && Objects.equals(this.clusterAlias, that.clusterAlias);
    }

    public int hashCode() {
        return Objects.hash(this.clusterAlias, this.shardId);
    }

    @Override
    public int compareTo(SearchShardIterator o) {
        return Comparator.comparing(SearchShardIterator::shardId).thenComparing(SearchShardIterator::getClusterAlias, Comparator.nullsFirst(String::compareTo)).compare(this, o);
    }
}

