/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.translog.transfer;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.opensearch.common.collect.Tuple;
import org.opensearch.index.translog.TranslogReader;
import org.opensearch.index.translog.transfer.FileSnapshot;
import org.opensearch.index.translog.transfer.TransferSnapshot;
import org.opensearch.index.translog.transfer.TranslogTransferMetadata;

public class TranslogCheckpointTransferSnapshot
implements TransferSnapshot,
Closeable {
    private final Set<Tuple<FileSnapshot.TranslogFileSnapshot, FileSnapshot.CheckpointFileSnapshot>> translogCheckpointFileInfoTupleSet;
    private final int size;
    private final long generation;
    private final long primaryTerm;
    private long minTranslogGeneration;

    TranslogCheckpointTransferSnapshot(long primaryTerm, long generation, int size) {
        this.translogCheckpointFileInfoTupleSet = new HashSet<Tuple<FileSnapshot.TranslogFileSnapshot, FileSnapshot.CheckpointFileSnapshot>>(size);
        this.size = size;
        this.generation = generation;
        this.primaryTerm = primaryTerm;
    }

    private void add(FileSnapshot.TranslogFileSnapshot translogFileSnapshot, FileSnapshot.CheckpointFileSnapshot checkPointFileSnapshot) {
        this.translogCheckpointFileInfoTupleSet.add((Tuple<FileSnapshot.TranslogFileSnapshot, FileSnapshot.CheckpointFileSnapshot>)Tuple.tuple((Object)translogFileSnapshot, (Object)checkPointFileSnapshot));
        assert (translogFileSnapshot.getGeneration() == checkPointFileSnapshot.getGeneration());
    }

    private void setMinTranslogGeneration(long minTranslogGeneration) {
        this.minTranslogGeneration = minTranslogGeneration;
    }

    @Override
    public Set<FileSnapshot.TransferFileSnapshot> getTranslogFileSnapshots() {
        return this.translogCheckpointFileInfoTupleSet.stream().map(Tuple::v1).collect(Collectors.toSet());
    }

    @Override
    public TranslogTransferMetadata getTranslogTransferMetadata() {
        return new TranslogTransferMetadata(this.primaryTerm, this.generation, this.minTranslogGeneration, this.translogCheckpointFileInfoTupleSet.size() * 2);
    }

    @Override
    public Set<FileSnapshot.TransferFileSnapshot> getCheckpointFileSnapshots() {
        return this.translogCheckpointFileInfoTupleSet.stream().map(Tuple::v2).collect(Collectors.toSet());
    }

    @Override
    public void close() throws IOException {
        ArrayList<IOException> exceptionList = new ArrayList<IOException>();
        Set<FileSnapshot.TransferFileSnapshot> fileSnapshots = this.getTranslogFileSnapshots();
        fileSnapshots.addAll(this.getCheckpointFileSnapshots());
        for (FileSnapshot fileSnapshot : fileSnapshots) {
            try {
                fileSnapshot.close();
            }
            catch (IOException e) {
                exceptionList.add(e);
            }
        }
        if (!exceptionList.isEmpty()) {
            IOException ex = new IOException("IO Exception while closing file snapshots");
            exceptionList.forEach(ex::addSuppressed);
            throw ex;
        }
    }

    public String toString() {
        return "TranslogTransferSnapshot [" + " primary term = " + this.primaryTerm + ", generation = " + this.generation + " ]";
    }

    public static class Builder {
        private final long primaryTerm;
        private final long generation;
        private final List<TranslogReader> readers;
        private final Function<Long, String> checkpointGenFileNameMapper;
        private final Path location;

        public Builder(long primaryTerm, long generation, Path location, List<TranslogReader> readers, Function<Long, String> checkpointGenFileNameMapper) {
            this.primaryTerm = primaryTerm;
            this.generation = generation;
            this.readers = readers;
            this.checkpointGenFileNameMapper = checkpointGenFileNameMapper;
            this.location = location;
        }

        public TranslogCheckpointTransferSnapshot build() throws IOException {
            LinkedList<Long> generations = new LinkedList<Long>();
            long highestGeneration = Long.MIN_VALUE;
            long highestGenPrimaryTerm = Long.MIN_VALUE;
            long lowestGeneration = Long.MAX_VALUE;
            long highestGenMinTranslogGeneration = Long.MIN_VALUE;
            TranslogCheckpointTransferSnapshot translogTransferSnapshot = new TranslogCheckpointTransferSnapshot(this.primaryTerm, this.generation, this.readers.size());
            for (TranslogReader reader : this.readers) {
                long readerGeneration = reader.getGeneration();
                long readerPrimaryTerm = reader.getPrimaryTerm();
                long minTranslogGeneration = reader.getCheckpoint().getMinTranslogGeneration();
                long checkpointGeneration = reader.getCheckpoint().getGeneration();
                Path translogPath = reader.path();
                Path checkpointPath = this.location.resolve(this.checkpointGenFileNameMapper.apply(readerGeneration));
                generations.add(readerGeneration);
                translogTransferSnapshot.add(new FileSnapshot.TranslogFileSnapshot(readerPrimaryTerm, readerGeneration, translogPath), new FileSnapshot.CheckpointFileSnapshot(readerPrimaryTerm, checkpointGeneration, minTranslogGeneration, checkpointPath));
                if (readerGeneration > highestGeneration) {
                    highestGeneration = readerGeneration;
                    highestGenMinTranslogGeneration = minTranslogGeneration;
                    highestGenPrimaryTerm = readerPrimaryTerm;
                }
                lowestGeneration = Math.min(lowestGeneration, readerGeneration);
            }
            translogTransferSnapshot.setMinTranslogGeneration(highestGenMinTranslogGeneration);
            assert (this.primaryTerm == highestGenPrimaryTerm) : "inconsistent primary term";
            assert (this.generation == highestGeneration) : " inconsistent generation ";
            long finalHighestGeneration = highestGeneration;
            assert (LongStream.iterate(lowestGeneration, i -> i + 1L).limit(highestGeneration).filter(l -> l <= finalHighestGeneration).boxed().collect(Collectors.toList()).equals(generations.stream().sorted().collect(Collectors.toList()))) : "generation gaps found";
            return translogTransferSnapshot;
        }
    }
}

