"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsAstBuilder = void 0;

var _lodash = require("lodash");

var _AbstractParseTreeVisitor = require("antlr4ts/tree/AbstractParseTreeVisitor");

var _node = require("../node");

var _aggragations = require("../tree/aggragations");

var _expression = require("../expression");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class StatsAstBuilder extends _AbstractParseTreeVisitor.AbstractParseTreeVisitor {
  defaultResult() {
    return new _node.PPLNode('default', []);
  }

  visitRoot(ctx) {
    if (!ctx.pplStatement()) return this.defaultResult();
    return this.visitPplStatement(ctx.pplStatement());
  }

  visitPplStatement(ctx) {
    let statsTree = this.defaultResult();
    ctx.commands().map(pplCommandContext => {
      if ((0, _lodash.isFunction)(this.visitChildren(pplCommandContext).getName) && (0, _lodash.isEqual)(this.visitChildren(pplCommandContext).getName(), 'stats_command')) statsTree = this.visitChildren(pplCommandContext);
    });
    return statsTree;
  }

  visitCommands(ctx) {
    if (ctx.statsCommand()) {
      return this.visitStatsCommand(ctx.statsCommand());
    }

    return this.defaultResult();
  }
  /**
   * Stats command
   */


  visitStatsCommand(ctx) {
    var _ctx$PARTITIONS, _ctx$integerLiteral, _ctx$ALLNUM, _ctx$DELIM, _ctx$DEDUP_SPLITVALUE, _ctx$stop;

    return new _aggragations.Aggregations('stats_command', [], ctx.PARTITIONS() && ctx.integerLiteral() ? {
      keyword: (_ctx$PARTITIONS = ctx.PARTITIONS()) === null || _ctx$PARTITIONS === void 0 ? void 0 : _ctx$PARTITIONS.text,
      sign: '=',
      value: (_ctx$integerLiteral = ctx.integerLiteral()) === null || _ctx$integerLiteral === void 0 ? void 0 : _ctx$integerLiteral.text
    } : {}, // visit partitions partial
    ctx.ALLNUM() && ctx.booleanLiteral() ? {
      keyword: (_ctx$ALLNUM = ctx.ALLNUM()) === null || _ctx$ALLNUM === void 0 ? void 0 : _ctx$ALLNUM.text,
      sign: '=',
      value: this.visitBooleanLiteral(ctx.booleanLiteral()[0])
    } : {}, // visit allnum partial
    ctx.DELIM() && ctx.stringLiteral() ? {
      keyword: (_ctx$DELIM = ctx.DELIM()) === null || _ctx$DELIM === void 0 ? void 0 : _ctx$DELIM.text,
      sign: '=',
      value: this.visitStringLiteral(ctx.stringLiteral())
    } : '', // visit delim partial
    ctx.statsAggTerm().map(aggTermAlternative => this.visitStatsAggTerm(aggTermAlternative)), // visit statsAggTerm
    ctx.statsByClause() ? this.visitStatsByClause(ctx.statsByClause()) : {}, // visit group list
    ctx.DEDUP_SPLITVALUES() && ctx.booleanLiteral() ? {
      keyword: (_ctx$DEDUP_SPLITVALUE = ctx.DEDUP_SPLITVALUES()) === null || _ctx$DEDUP_SPLITVALUE === void 0 ? void 0 : _ctx$DEDUP_SPLITVALUE.text,
      sign: '=',
      value: this.visitBooleanLiteral(ctx.booleanLiteral()[1])
    } : '', // visit dedup split value
    {
      start: ctx.start.startIndex,
      end: (_ctx$stop = ctx.stop) === null || _ctx$stop === void 0 ? void 0 : _ctx$stop.stopIndex
    } // stats start/end indices in query for later query concatenation
    );
  }

  visitIntegerLiteral(ctx) {
    return ctx.text;
  }

  visitBooleanLiteral(ctx) {
    return ctx.text;
  }

  visitStringLiteral(ctx) {
    return ctx.text;
  }

  visitStatsAggTerm(ctx) {
    return new _expression.AggregateTerm('stats_agg_term', [], this.visitStatsFunction(ctx.statsFunction()), ctx.wcFieldExpression() ? this.visitWcFieldExpression(ctx.wcFieldExpression()) : '');
  }

  visitWcFieldExpression(ctx) {
    // return only text from here to all its chilren for now
    return ctx.wcQualifiedName().text;
  }

  visitStatsByClause(ctx) {
    return new _expression.GroupBy('stats_by_clause', [], ctx.fieldList() ? this.visitFieldList(ctx.fieldList()) : [], ctx.bySpanClause() ? this.visitBySpanClause(ctx.bySpanClause()) : this.defaultResult());
  }

  visitBySpanClause(ctx) {
    return new _expression.Span('span_clause', [], this.visitSpanClause(ctx.spanClause()), ctx.qualifiedName() ? this.visitQualifiedName(ctx.qualifiedName()) : '');
  }

  visitSpanClause(ctx) {
    return new _expression.SpanExpression('span_expression', [], this.visitFieldExpression(ctx.fieldExpression()), this.visitLiteralValue(ctx.literalValue()), ctx.timespanUnit() ? this.visitTimespanUnit(ctx.timespanUnit()) : '');
  }

  visitLiteralValue(ctx) {
    return ctx.text;
  }

  visitTimespanUnit(ctx) {
    return ctx.text;
  }

  visitStatsFunction(ctx) {
    let funcName = '';
    let valueExpr = '';

    if (typeof ctx.valueExpression === 'function') {
      valueExpr = this.visitValueExpression(ctx.valueExpression());

      if (typeof ctx.statsFunctionName === 'function') {
        funcName = this.visitStatsFunctionName(ctx.statsFunctionName());
      } else {
        funcName = ctx.DISTINCT_COUNT() ? ctx.DISTINCT_COUNT().text : ctx.DC().text;
      }
    } else if (typeof ctx.percentileAggFunction === 'function') {// for now just return plain text
    } else {
      funcName = ctx.COUNT().text;
    }

    return new _expression.AggregateFunction('stats_function', [], funcName, valueExpr, typeof ctx.percentileAggFunction === 'function' ? ctx.text : '');
  }

  visitValueExpression(ctx) {
    return ctx.text;
  }

  visitStatsFunctionName(ctx) {
    return ctx.text;
  }

  visitFieldList(ctx) {
    return ctx.fieldExpression().map(fieldExprAlternative => {
      return new _expression.Field('field_expression', [], this.visitFieldExpression(fieldExprAlternative));
    });
  }

  visitFieldExpression(ctx) {
    return this.visitQualifiedName(ctx.qualifiedName());
  }

  visitQualifiedName(ctx) {
    return ctx.text;
  }

}

exports.StatsAstBuilder = StatsAstBuilder;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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