/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;
import org.opensearch.ExceptionsHelper;
import org.opensearch.index.fielddata.ScriptDocValues;
import org.opensearch.knn.index.codec.util.KNNVectorSerializer;
import org.opensearch.knn.index.codec.util.KNNVectorSerializerFactory;

public final class KNNVectorScriptDocValues
extends ScriptDocValues<float[]> {
    private final BinaryDocValues binaryDocValues;
    private final String fieldName;
    private boolean docExists;

    public KNNVectorScriptDocValues(BinaryDocValues binaryDocValues, String fieldName) {
        this.binaryDocValues = binaryDocValues;
        this.fieldName = fieldName;
    }

    public void setNextDocId(int docId) throws IOException {
        if (this.binaryDocValues.advanceExact(docId)) {
            this.docExists = true;
            return;
        }
        this.docExists = false;
    }

    public float[] getValue() {
        if (!this.docExists) {
            String errorMessage = String.format("One of the document doesn't have a value for field '%s'. This can be avoided by checking if a document has a value for the field or not by doc['%s'].size() == 0 ? 0 : {your script}", this.fieldName, this.fieldName);
            throw new IllegalStateException(errorMessage);
        }
        try {
            BytesRef value = this.binaryDocValues.binaryValue();
            ByteArrayInputStream byteStream = new ByteArrayInputStream(value.bytes, value.offset, value.length);
            KNNVectorSerializer vectorSerializer = KNNVectorSerializerFactory.getSerializerByStreamContent(byteStream);
            float[] vector = vectorSerializer.byteToFloatArray(byteStream);
            return vector;
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToOpenSearchException((Exception)e);
        }
    }

    public int size() {
        return this.docExists ? 1 : 0;
    }

    public float[] get(int i) {
        throw new UnsupportedOperationException("knn vector does not support this operation");
    }
}

