/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.storage;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalPlanNodeVisitor;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.planner.logical.PrometheusLogicalPlanOptimizerFactory;
import org.opensearch.sql.prometheus.request.PrometheusQueryRequest;
import org.opensearch.sql.prometheus.request.system.PrometheusDescribeMetricRequest;
import org.opensearch.sql.prometheus.storage.PrometheusMetricDefaultSchema;
import org.opensearch.sql.prometheus.storage.PrometheusMetricScan;
import org.opensearch.sql.prometheus.storage.implementor.PrometheusDefaultImplementor;
import org.opensearch.sql.storage.Table;

public class PrometheusMetricTable
implements Table {
    private final PrometheusClient prometheusClient;
    private final String metricName;
    private final PrometheusQueryRequest prometheusQueryRequest;
    private Map<String, ExprType> cachedFieldTypes = null;

    public PrometheusMetricTable(PrometheusClient prometheusService, @Nonnull String metricName) {
        this.prometheusClient = prometheusService;
        this.metricName = metricName;
        this.prometheusQueryRequest = null;
    }

    public PrometheusMetricTable(PrometheusClient prometheusService, @Nonnull PrometheusQueryRequest prometheusQueryRequest) {
        this.prometheusClient = prometheusService;
        this.metricName = null;
        this.prometheusQueryRequest = prometheusQueryRequest;
    }

    public boolean exists() {
        throw new UnsupportedOperationException("Prometheus metric exists operation is not supported");
    }

    public void create(Map<String, ExprType> schema) {
        throw new UnsupportedOperationException("Prometheus metric create operation is not supported");
    }

    public Map<String, ExprType> getFieldTypes() {
        if (this.cachedFieldTypes == null) {
            if (this.metricName != null) {
                this.cachedFieldTypes = new PrometheusDescribeMetricRequest(this.prometheusClient, null, this.metricName).getFieldTypes();
            } else {
                this.cachedFieldTypes = new HashMap<String, ExprType>(PrometheusMetricDefaultSchema.DEFAULT_MAPPING.getMapping());
                this.cachedFieldTypes.put("@labels", (ExprType)ExprCoreType.STRING);
            }
        }
        return this.cachedFieldTypes;
    }

    public PhysicalPlan implement(LogicalPlan plan) {
        PrometheusMetricScan metricScan = new PrometheusMetricScan(this.prometheusClient);
        if (this.prometheusQueryRequest != null) {
            metricScan.setRequest(this.prometheusQueryRequest);
            metricScan.setIsQueryRangeFunctionScan(Boolean.TRUE);
        }
        return (PhysicalPlan)plan.accept((LogicalPlanNodeVisitor)new PrometheusDefaultImplementor(), (Object)metricScan);
    }

    public LogicalPlan optimize(LogicalPlan plan) {
        return PrometheusLogicalPlanOptimizerFactory.create().optimize(plan);
    }

    @Generated
    public String getMetricName() {
        return this.metricName;
    }

    @Generated
    public PrometheusQueryRequest getPrometheusQueryRequest() {
        return this.prometheusQueryRequest;
    }
}

