/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.esdomain;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.common.settings.Setting;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.sql.common.setting.Settings;
import org.opensearch.sql.legacy.esdomain.mapping.IndexMappings;
import org.opensearch.sql.opensearch.setting.OpenSearchSettings;

public class LocalClusterState {
    private static final Logger LOG = LogManager.getLogger();
    private static final Function<String, Predicate<String>> ALL_FIELDS = anyIndex -> anyField -> true;
    private static LocalClusterState INSTANCE;
    private ClusterService clusterService;
    private OpenSearchSettings pluginSettings;
    private IndexNameExpressionResolver resolver;
    private final Cache<List<String>, IndexMappings> cache;
    private final Map<String, Object> latestSettings = new ConcurrentHashMap<String, Object>();

    public static synchronized LocalClusterState state() {
        if (INSTANCE == null) {
            INSTANCE = new LocalClusterState();
        }
        return INSTANCE;
    }

    public static synchronized void state(LocalClusterState instance) {
        INSTANCE = instance;
    }

    public void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
        clusterService.addListener(event -> {
            if (event.metadataChanged()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Metadata in cluster state changed: {}", (Object)new IndexMappings(clusterService.state().metadata()));
                }
                this.cache.invalidateAll();
            }
        });
    }

    public void setPluginSettings(OpenSearchSettings settings) {
        this.pluginSettings = settings;
        for (Setting setting : settings.getSettings()) {
            this.clusterService.getClusterSettings().addSettingsUpdateConsumer(setting, newVal -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("The value of setting [{}] changed to [{}]", (Object)setting.getKey(), newVal);
                }
                this.latestSettings.put(setting.getKey(), newVal);
            });
        }
    }

    public void setResolver(IndexNameExpressionResolver resolver) {
        this.resolver = resolver;
    }

    private LocalClusterState() {
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build();
    }

    public <T> T getSettingValue(Settings.Key key) {
        Objects.requireNonNull(this.pluginSettings, "SQL plugin setting is null");
        return (T)this.latestSettings.getOrDefault(key.getKeyValue(), this.pluginSettings.getSettingValue(key));
    }

    public IndexMappings getFieldMappings(String[] indices) {
        return this.getFieldMappings(indices, ALL_FIELDS);
    }

    private IndexMappings getFieldMappings(String[] indices, Function<String, Predicate<String>> fieldFilter) {
        Objects.requireNonNull(this.clusterService, "Cluster service is null");
        Objects.requireNonNull(this.resolver, "Index name expression resolver is null");
        try {
            ClusterState state = this.clusterService.state();
            String[] concreteIndices = this.resolveIndexExpression(state, indices);
            IndexMappings mappings = fieldFilter == ALL_FIELDS ? this.findMappingsInCache(state, concreteIndices) : this.findMappings(state, concreteIndices, fieldFilter);
            LOG.debug("Found mappings: {}", (Object)mappings);
            return mappings;
        }
        catch (IndexNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to read mapping in cluster state for indices=" + Arrays.toString(indices), e);
        }
    }

    private String[] resolveIndexExpression(ClusterState state, String[] indices) {
        Object[] concreteIndices = this.resolver.concreteIndexNames(state, IndicesOptions.strictExpandOpen(), true, indices);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resolved index expression {} to concrete index names {}", (Object)Arrays.toString(indices), (Object)Arrays.toString(concreteIndices));
        }
        return concreteIndices;
    }

    private IndexMappings findMappings(ClusterState state, String[] indices, Function<String, Predicate<String>> fieldFilter) throws IOException {
        LOG.debug("Cache didn't help. Load and parse mapping in cluster state");
        return new IndexMappings((ImmutableOpenMap<String, MappingMetadata>)state.metadata().findMappings(indices, fieldFilter));
    }

    private IndexMappings findMappingsInCache(ClusterState state, String[] indices) throws ExecutionException {
        LOG.debug("Looking for mapping in cache: {}", (Object)this.cache.asMap());
        return (IndexMappings)this.cache.get(this.sortToList(indices), () -> this.findMappings(state, indices, ALL_FIELDS));
    }

    private <T> List<T> sortToList(T[] array) {
        Arrays.sort(array);
        return Arrays.asList(array);
    }
}

