/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.util.Arrays;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.AbstractIterator;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.BitmapIndexedSetNode;
import scala.collection.immutable.SetNode;
import scala.collection.mutable.AbstractSet;
import scala.collection.mutable.Growable;
import scala.collection.mutable.HashSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.hashing.MurmurHash3$;

public final class HashSet<A>
extends AbstractSet<A>
implements Serializable,
StrictOptimizedIterableOps<A, HashSet, HashSet<A>> {
    private final double loadFactor;
    public Node<A>[] scala$collection$mutable$HashSet$$table;
    private int threshold;
    private int contentSize;

    /*
     * WARNING - void declaration
     */
    @Override
    public final Tuple2<HashSet<A>, HashSet<A>> partition(Function1<A, Object> p) {
        void var1_1;
        return StrictOptimizedIterableOps.partition$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <A1, A2> Tuple2<HashSet<A1>, HashSet<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        void var1_1;
        return StrictOptimizedIterableOps.unzip$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object map(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.map$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object flatMap(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.flatMap$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object collect(PartialFunction pf) {
        void var1_1;
        return StrictOptimizedIterableOps.collect$(this, (PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object flatten(Function1 toIterableOnce) {
        void var1_1;
        return StrictOptimizedIterableOps.flatten$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object zip(IterableOnce that) {
        void var1_1;
        return StrictOptimizedIterableOps.zip$(this, (IterableOnce)var1_1);
    }

    @Override
    public final Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object filter(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filter$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object filterNot(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filterNot$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object filterImpl(Function1 pred, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return StrictOptimizedIterableOps.filterImpl$(this, (Function1)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object takeRight(int n) {
        void var1_1;
        return StrictOptimizedIterableOps.takeRight$(this, (int)var1_1);
    }

    @Override
    public final int size() {
        return this.contentSize;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(A elem) {
        Node<void> node;
        void var2_2;
        int findNode_scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash = Statics.anyHash(elem);
        int n = findNode_scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash ^ var2_2 >>> 16;
        Node<A> node2 = this.scala$collection$mutable$HashSet$$table[n & this.scala$collection$mutable$HashSet$$table.length - 1];
        if (node2 == null) {
            elem = null;
        } else {
            node = node2.findNode(node, n);
        }
        return node != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void sizeHint(int size) {
        int target = this.tableSizeFor((int)((double)(size + 1) / this.loadFactor));
        if (target > this.scala$collection$mutable$HashSet$$table.length) {
            void var1_1;
            this.growTable((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(A elem) {
        void var1_2;
        if (this.contentSize + 1 >= this.threshold) {
            HashSet hashSet = this;
            hashSet.growTable(hashSet.scala$collection$mutable$HashSet$$table.length << 1);
        }
        A a = elem;
        int scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash = Statics.anyHash(a);
        return this.addElem(a, scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash ^ var1_2 >>> 16);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> addAll(IterableOnce<A> xs) {
        HashSet hashSet;
        Object foreachWithHash_foreachWithHash_this;
        this.sizeHint(xs.knownSize());
        if (xs instanceof scala.collection.immutable.HashSet) {
            xs = xs;
            Function2<Object, Object, Object> & Serializable foreachWithHash_f = (Function2<Object, Object, Object> & Serializable)(k, h) -> {
                void var2_2;
                void var1_1;
                HashSet.$anonfun$addAll$1(this, var1_1, BoxesRunTime.unboxToInt(var2_2));
                return BoxedUnit.UNIT;
            };
            BitmapIndexedSetNode bitmapIndexedSetNode = xs.rootNode();
            if (bitmapIndexedSetNode == null) {
                throw null;
            }
            foreachWithHash_foreachWithHash_this = bitmapIndexedSetNode;
            int foreachWithHash_foreachWithHash_iN = bitmapIndexedSetNode.payloadArity();
            for (int foreachWithHash_foreachWithHash_i = 0; foreachWithHash_foreachWithHash_i < foreachWithHash_foreachWithHash_iN; ++foreachWithHash_foreachWithHash_i) {
                int n = ((BitmapIndexedSetNode)foreachWithHash_foreachWithHash_this).originalHashes()[foreachWithHash_foreachWithHash_i];
                Object object = ((BitmapIndexedSetNode)foreachWithHash_foreachWithHash_this).content()[foreachWithHash_foreachWithHash_i];
                HashSet.$anonfun$addAll$1(this, object, n);
            }
            int foreachWithHash_foreachWithHash_jN = ((BitmapIndexedSetNode)foreachWithHash_foreachWithHash_this).nodeArity();
            for (int foreachWithHash_foreachWithHash_j = 0; foreachWithHash_foreachWithHash_j < foreachWithHash_foreachWithHash_jN; ++foreachWithHash_foreachWithHash_j) {
                ((SetNode)((BitmapIndexedSetNode)foreachWithHash_foreachWithHash_this).getNode(foreachWithHash_foreachWithHash_j)).foreachWithHash(foreachWithHash_f);
            }
            foreachWithHash_foreachWithHash_this = this;
        } else if (foreachWithHash_foreachWithHash_this instanceof HashSet) {
            foreachWithHash_foreachWithHash_this = (HashSet)foreachWithHash_foreachWithHash_this;
            HashSetIterator iter = new HashSetIterator<Node<A>>((HashSet)foreachWithHash_foreachWithHash_this){

                public final Node<A> extract(Node<A> nd) {
                    return nd;
                }
                {
                    void var1_1;
                }
            };
            while (iter.hasNext()) {
                void var2_3;
                Node next = (Node)iter.next();
                this.addElem(next.key(), var2_3.hash());
            }
            hashSet = this;
        } else {
            hashSet = (HashSet)Growable.addAll$(this, hashSet);
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    private boolean addElem(A elem, int hash) {
        int n = hash & this.scala$collection$mutable$HashSet$$table.length - 1;
        Node<A> node = this.scala$collection$mutable$HashSet$$table[n];
        if (node == null) {
            this.scala$collection$mutable$HashSet$$table[n] = new Node<A>(elem, hash, null);
        } else {
            Node<A> prev = null;
            for (Node<A> n2 = node; n2 != null && n2.hash() <= hash; n2 = n2.next()) {
                if (n2.hash() == hash && BoxesRunTime.equals(elem, n2.key())) {
                    return false;
                }
                prev = n2;
            }
            if (prev == null) {
                this.scala$collection$mutable$HashSet$$table[n] = new Node<A>(elem, hash, node);
            } else {
                void var2_2;
                void var1_1;
                prev.next_$eq(new Node<void>(var1_1, (int)var2_2, prev.next()));
            }
        }
        ++this.contentSize;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean remove(A elem, int hash) {
        int n = hash & this.scala$collection$mutable$HashSet$$table.length - 1;
        Node<A> node = this.scala$collection$mutable$HashSet$$table[n];
        if (node == null) return false;
        if (node.hash() == hash && BoxesRunTime.equals(node.key(), elem)) {
            boolean bl;
            this.scala$collection$mutable$HashSet$$table[n] = node.next();
            --this.contentSize;
            return bl;
        }
        Node<A> prev = node;
        Node<A> next = node.next();
        while (next != null) {
            if (next.hash() > hash) return false;
            if (next.hash() == hash && BoxesRunTime.equals(next.key(), elem)) {
                prev.next_$eq(next.next());
                --this.contentSize;
                return true;
            }
            prev = next;
            next = next.next();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean remove(A elem) {
        void var1_2;
        A a = elem;
        int scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash = Statics.anyHash(a);
        return this.remove(a, scala$collection$mutable$HashSet$$computeHash_scala$collection$mutable$HashSet$$improveHash_originalHash ^ var1_2 >>> 16);
    }

    @Override
    public final Iterator<A> iterator() {
        return new HashSetIterator<A>(this){

            public final A extract(Node<A> nd) {
                return nd.key();
            }
            {
                void var1_1;
            }
        };
    }

    private void growTable(int newlen) {
        this.threshold = this.newThreshold(newlen);
        if (this.size() == 0) {
            this.scala$collection$mutable$HashSet$$table = new Node[newlen];
            return;
        }
        this.scala$collection$mutable$HashSet$$table = Arrays.copyOf(this.scala$collection$mutable$HashSet$$table, newlen);
        Node<Object> preLow = new Node<Object>(null, 0, null);
        Node<Object> preHigh = new Node<Object>(null, 0, null);
        for (int oldlen = this.scala$collection$mutable$HashSet$$table.length; oldlen < newlen; oldlen <<= 1) {
            for (int i = 0; i < oldlen; ++i) {
                Node<A> old = this.scala$collection$mutable$HashSet$$table[i];
                if (old == null) continue;
                preLow.next_$eq(null);
                preHigh.next_$eq(null);
                Node<Object> lastLow = preLow;
                Node<Object> lastHigh = preHigh;
                Node<A> n = old;
                while (n != null) {
                    Node<A> next = n.next();
                    if ((n.hash() & oldlen) == 0) {
                        lastLow.next_$eq(n);
                        lastLow = n;
                    } else {
                        lastHigh.next_$eq(n);
                        lastHigh = n;
                    }
                    n = next;
                }
                lastLow.next_$eq(null);
                if (old != preLow.next()) {
                    this.scala$collection$mutable$HashSet$$table[i] = preLow.next();
                }
                if (preHigh.next() == null) continue;
                this.scala$collection$mutable$HashSet$$table[i + oldlen] = preHigh.next();
                lastHigh.next_$eq(null);
            }
        }
    }

    private int tableSizeFor(int capacity) {
        int n;
        --n;
        n = Integer.highestOneBit(Math.max(n, 4)) << 1;
        return Math.min(n, 0x40000000);
    }

    private int newThreshold(int size) {
        return (int)((double)size * this.loadFactor);
    }

    @Override
    public final void clear() {
        Arrays.fill(this.scala$collection$mutable$HashSet$$table, null);
        this.contentSize = 0;
    }

    @Override
    public final IterableFactory<HashSet> iterableFactory() {
        return HashSet$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> addOne(A elem) {
        void var1_1;
        this.add(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final HashSet<A> subtractOne(A elem) {
        void var1_1;
        this.remove(var1_1);
        return this;
    }

    @Override
    public final int knownSize() {
        return this.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final <U> void foreach(Function1<A, U> f) {
        for (Node<A> n : this.scala$collection$mutable$HashSet$$table) {
            if (n == null) continue;
            n.foreach(f);
        }
    }

    @Override
    public final String className() {
        return "HashSet";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var1_1;
        HashSetIterator setIterator = new /* invalid duplicate definition of identical inner class */;
        HashSetIterator<Object> hashIterator = setIterator.isEmpty() ? setIterator : new HashSetIterator<Object>(this){
            private int hash;
            private final /* synthetic */ HashSet $outer;

            private int hash() {
                return this.hash;
            }

            /*
             * WARNING - void declaration
             */
            private void hash_$eq(int x$1) {
                void var1_1;
                this.hash = var1_1;
            }

            public final int hashCode() {
                return this.hash();
            }

            /*
             * WARNING - void declaration
             */
            public final Object extract(Node<A> nd2) {
                void var1_2;
                $anon$3 v0 = this;
                int nd2 = nd2.hash();
                if (v0.$outer == null) {
                    throw null;
                }
                void v1 = var1_2;
                v0.hash_$eq(v1 ^ v1 >>> 16);
                return this;
            }
            {
                void var1_1;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.hash = 0;
            }
        };
        return MurmurHash3$.MODULE$.unorderedHash((IterableOnce<Object>)var1_1, MurmurHash3$.MODULE$.setSeed());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$addAll$1(HashSet $this, Object k, int h) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        $this.addElem(var1_1, v0 ^ v0 >>> 16);
    }

    /*
     * WARNING - void declaration
     */
    public HashSet(int initialCapacity, double loadFactor) {
        void var1_1;
        void var2_2;
        this.loadFactor = var2_2;
        this.scala$collection$mutable$HashSet$$table = new Node[this.tableSizeFor((int)var1_1)];
        this.threshold = this.newThreshold(this.scala$collection$mutable$HashSet$$table.length);
        this.contentSize = 0;
    }

    public HashSet() {
        this(16, 0.75);
    }

    private abstract class HashSetIterator<B>
    extends AbstractIterator<B> {
        private int i;
        private Node<A> node;
        private final int len;

        public abstract B extract(Node<A> var1);

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasNext() {
            if (this.node != null) {
                return true;
            }
            while (this.i < this.len) {
                void var1_1;
                Node n = this.scala$collection$mutable$HashSet$HashSetIterator$$$outer().scala$collection$mutable$HashSet$$table[this.i];
                ++this.i;
                if (n == null) continue;
                this.node = var1_1;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public B next() {
            void var1_1;
            if (!this.hasNext()) {
                return (B)Iterator$.scala$collection$Iterator$$_empty.next();
            }
            HashSetIterator hashSetIterator = this;
            B r = hashSetIterator.extract(hashSetIterator.node);
            this.node = this.node.next();
            return var1_1;
        }

        public /* synthetic */ HashSet scala$collection$mutable$HashSet$HashSetIterator$$$outer() {
            return HashSet.this;
        }

        /*
         * WARNING - void declaration
         */
        public HashSetIterator() {
            void var1_1;
            if (HashSet.this == null) {
                throw null;
            }
            this.i = 0;
            this.node = null;
            this.len = var1_1.scala$collection$mutable$HashSet$$table.length;
        }
    }

    public static final class Node<K> {
        private final K _key;
        private final int _hash;
        private Node<K> _next;

        public final K key() {
            return this._key;
        }

        public final int hash() {
            return this._hash;
        }

        public final Node<K> next() {
            return this._next;
        }

        /*
         * WARNING - void declaration
         */
        public final void next_$eq(Node<K> n) {
            void var1_1;
            this._next = var1_1;
        }

        public final Node<K> findNode(K k, int h) {
            while (h != this_._hash || !BoxesRunTime.equals(k, this_._key)) {
                if (this_._next == null || this_._hash > h) {
                    return null;
                }
                Node<K> this_ = this_._next;
            }
            return this_;
        }

        public final <U> void foreach(Function1<K, U> f) {
            while (true) {
                f.apply(this_._key);
                if (this_._next == null) break;
                Node<K> this_ = this_._next;
            }
        }

        public final String toString() {
            return new StringBuilder(12).append("Node(").append(this.key()).append(", ").append(this.hash()).append(") -> ").append(this.next()).toString();
        }

        /*
         * WARNING - void declaration
         */
        public Node(K _key, int _hash, Node<K> _next) {
            void var3_3;
            void var2_2;
            void var1_1;
            this._key = var1_1;
            this._hash = var2_2;
            this._next = var3_3;
        }
    }
}

