// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from LPC176x5x_v0.2.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/NXP

//go:build nxp && lpc176x5x
// +build nxp,lpc176x5x

// LPC176x/LPC175x M3
//

package nxp

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "LPC176x5x"
	CPU          = "CM3"
	FPUPresent   = false
	NVICPrioBits = 5
)

// Interrupt numbers.
const (
	// Watchdog Timer (WDT)
	IRQ_WDT = 0

	// Timer0/1/2/3
	IRQ_TIMER0 = 1

	IRQ_TIMER1 = 2

	IRQ_TIMER2 = 3

	IRQ_TIMER3 = 4

	// UART0/2/3
	IRQ_UART0 = 5

	// UART1
	IRQ_UART1 = 6

	IRQ_UART2 = 7

	IRQ_UART3 = 8

	// Pulse Width Modulators (PWM1)
	IRQ_PWM1 = 9

	// I2C bus interface
	IRQ_I2C0 = 10

	IRQ_I2C1 = 11

	IRQ_I2C2 = 12

	// SPI
	IRQ_SPI = 13

	// SSP controller
	IRQ_SSP0 = 14

	// SSP1 controller
	IRQ_SSP1 = 15

	// System and clock control
	IRQ_PLL0 = 16

	// Real Time Clock (RTC)
	IRQ_RTC = 17

	// System and clock control
	IRQ_EINT0 = 18

	// System and clock control
	IRQ_EINT1 = 19

	// System and clock control
	IRQ_EINT2 = 20

	// System and clock control
	IRQ_EINT3 = 21

	// Analog-to-Digital Converter (ADC)
	IRQ_ADC = 22

	// System and clock control
	IRQ_BOD = 23

	// USB device/host/OTG controller
	IRQ_USB = 24

	// CAN1 controller
	IRQ_CAN = 25

	// General purpose DMA controller
	IRQ_DMA = 26

	// I2S interface
	IRQ_I2S = 27

	// Ethernet
	IRQ_ENET = 28

	// Repetitive Interrupt Timer (RIT)
	IRQ_RIT = 29

	// Motor Control PWM
	IRQ_MCPWM = 30

	// Quadrature Encoder Interface (QEI)
	IRQ_QEI = 31

	// System and clock control
	IRQ_PLL1 = 32

	// USB device/host/OTG controller
	IRQ_USBActivity = 33

	// Central CAN controller
	IRQ_CANActivity = 34

	// Highest interrupt number on this device.
	IRQ_max = 34
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export TIMER0_IRQHandler
func interruptTIMER0() {
	callHandlers(IRQ_TIMER0)
}

//export TIMER1_IRQHandler
func interruptTIMER1() {
	callHandlers(IRQ_TIMER1)
}

//export TIMER2_IRQHandler
func interruptTIMER2() {
	callHandlers(IRQ_TIMER2)
}

//export TIMER3_IRQHandler
func interruptTIMER3() {
	callHandlers(IRQ_TIMER3)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export UART2_IRQHandler
func interruptUART2() {
	callHandlers(IRQ_UART2)
}

//export UART3_IRQHandler
func interruptUART3() {
	callHandlers(IRQ_UART3)
}

//export PWM1_IRQHandler
func interruptPWM1() {
	callHandlers(IRQ_PWM1)
}

//export I2C0_IRQHandler
func interruptI2C0() {
	callHandlers(IRQ_I2C0)
}

//export I2C1_IRQHandler
func interruptI2C1() {
	callHandlers(IRQ_I2C1)
}

//export I2C2_IRQHandler
func interruptI2C2() {
	callHandlers(IRQ_I2C2)
}

//export SPI_IRQHandler
func interruptSPI() {
	callHandlers(IRQ_SPI)
}

//export SSP0_IRQHandler
func interruptSSP0() {
	callHandlers(IRQ_SSP0)
}

//export SSP1_IRQHandler
func interruptSSP1() {
	callHandlers(IRQ_SSP1)
}

//export PLL0_IRQHandler
func interruptPLL0() {
	callHandlers(IRQ_PLL0)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export EINT0_IRQHandler
func interruptEINT0() {
	callHandlers(IRQ_EINT0)
}

//export EINT1_IRQHandler
func interruptEINT1() {
	callHandlers(IRQ_EINT1)
}

//export EINT2_IRQHandler
func interruptEINT2() {
	callHandlers(IRQ_EINT2)
}

//export EINT3_IRQHandler
func interruptEINT3() {
	callHandlers(IRQ_EINT3)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export BOD_IRQHandler
func interruptBOD() {
	callHandlers(IRQ_BOD)
}

//export USB_IRQHandler
func interruptUSB() {
	callHandlers(IRQ_USB)
}

//export CAN_IRQHandler
func interruptCAN() {
	callHandlers(IRQ_CAN)
}

//export DMA_IRQHandler
func interruptDMA() {
	callHandlers(IRQ_DMA)
}

//export I2S_IRQHandler
func interruptI2S() {
	callHandlers(IRQ_I2S)
}

//export ENET_IRQHandler
func interruptENET() {
	callHandlers(IRQ_ENET)
}

//export RIT_IRQHandler
func interruptRIT() {
	callHandlers(IRQ_RIT)
}

//export MCPWM_IRQHandler
func interruptMCPWM() {
	callHandlers(IRQ_MCPWM)
}

//export QEI_IRQHandler
func interruptQEI() {
	callHandlers(IRQ_QEI)
}

//export PLL1_IRQHandler
func interruptPLL1() {
	callHandlers(IRQ_PLL1)
}

//export USBActivity_IRQHandler
func interruptUSBActivity() {
	callHandlers(IRQ_USBActivity)
}

//export CANActivity_IRQHandler
func interruptCANActivity() {
	callHandlers(IRQ_CANActivity)
}

// Peripherals.
var (
	// Watchdog Timer (WDT)
	WDT = (*WDT_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Timer0/1/2/3
	TIMER0 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Timer0/1/2/3
	TIMER1 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// UART0/2/3
	UART0 = (*UART0_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// UART1
	UART1 = (*UART1_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Pulse Width Modulators (PWM1)
	PWM1 = (*PWM_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// I2C bus interface
	I2C0 = (*I2C_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// SPI
	SPI = (*SPI_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Real Time Clock (RTC)
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// GPIO
	GPIOINT = (*GPIOINT_Type)(unsafe.Pointer(uintptr(0x40028080)))

	// Pin connect block
	PINCONNECT = (*PINCONNECT_Type)(unsafe.Pointer(uintptr(0x4002c000)))

	// SSP1 controller
	SSP1 = (*SSP1_Type)(unsafe.Pointer(uintptr(0x40030000)))

	// Analog-to-Digital Converter (ADC)
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40034000)))

	// CAN acceptance filter RAM
	CANAFRAM = (*CANAFRAM_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// CAN controller acceptance filter
	CANAF = (*CANAF_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// Central CAN controller
	CCAN = (*CCAN_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// CAN1 controller
	CAN1 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// SSP controller
	SSP0 = (*SSP1_Type)(unsafe.Pointer(uintptr(0x40088000)))

	// Digital-to-Analog Converter (DAC)
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x4008c000)))

	// Timer0/1/2/3
	TIMER2 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40090000)))

	// Timer0/1/2/3
	TIMER3 = (*TIMER0_Type)(unsafe.Pointer(uintptr(0x40094000)))

	// UART0/2/3
	UART2 = (*UART0_Type)(unsafe.Pointer(uintptr(0x40098000)))

	// UART0/2/3
	UART3 = (*UART0_Type)(unsafe.Pointer(uintptr(0x4009c000)))

	// I2S interface
	I2S = (*I2S_Type)(unsafe.Pointer(uintptr(0x400a8000)))

	// Repetitive Interrupt Timer (RIT)
	RITIMER = (*RIT_Type)(unsafe.Pointer(uintptr(0x400b0000)))

	// Motor Control PWM
	MCPWM = (*MCPWM_Type)(unsafe.Pointer(uintptr(0x400b8000)))

	// Quadrature Encoder Interface (QEI)
	QEI = (*QEI_Type)(unsafe.Pointer(uintptr(0x400bc000)))

	// System and clock control
	SYSCON = (*SYSCON_Type)(unsafe.Pointer(uintptr(0x400fc000)))

	// Ethernet
	EMAC = (*ETHERNET_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// General purpose DMA controller
	GPDMA = (*GPDMA_Type)(unsafe.Pointer(uintptr(0x50004000)))

	// USB device/host/OTG controller
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x50008000)))

	// General Purpose I/O
	GPIO = (*GPIO_Type)(unsafe.Pointer(uintptr(0x2009c000)))

	// CAN1 controller
	CAN2 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40048000)))

	// I2C bus interface
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// I2C bus interface
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x400a0000)))
)

// Watchdog Timer (WDT)
type WDT_Type struct {
	MOD    volatile.Register32 // 0x0
	TC     volatile.Register32 // 0x4
	FEED   volatile.Register32 // 0x8
	TV     volatile.Register32 // 0xC
	CLKSEL volatile.Register32 // 0x10
}

// WDT.MOD: Watchdog mode register. This register determines the basic mode and status of the Watchdog Timer.
func (o *WDT_Type) SetMOD_WDEN(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetMOD_WDEN() uint32 {
	return volatile.LoadUint32(&o.MOD.Reg) & 0x1
}
func (o *WDT_Type) SetMOD_WDRESET(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetMOD_WDRESET() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetMOD_WDTOF(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetMOD_WDTOF() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetMOD_WDINT(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetMOD_WDINT() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetMOD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0xfffffff0)|value<<4)
}
func (o *WDT_Type) GetMOD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0xfffffff0) >> 4
}

// WDT.TC: Watchdog timer constant register. The value in this register determines the time-out value.
func (o *WDT_Type) SetTC(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, value)
}
func (o *WDT_Type) GetTC() uint32 {
	return volatile.LoadUint32(&o.TC.Reg)
}

// WDT.FEED: Watchdog feed sequence register. Writing 0xAA followed by 0x55 to this register reloads the Watchdog timer with the value contained in WDTC.
func (o *WDT_Type) SetFEED_Feed(value uint32) {
	volatile.StoreUint32(&o.FEED.Reg, volatile.LoadUint32(&o.FEED.Reg)&^(0xff)|value)
}
func (o *WDT_Type) GetFEED_Feed() uint32 {
	return volatile.LoadUint32(&o.FEED.Reg) & 0xff
}

// WDT.TV: Watchdog timer value register. This register reads out the current value of the Watchdog timer.
func (o *WDT_Type) SetTV(value uint32) {
	volatile.StoreUint32(&o.TV.Reg, value)
}
func (o *WDT_Type) GetTV() uint32 {
	return volatile.LoadUint32(&o.TV.Reg)
}

// WDT.CLKSEL: Watchdog clock select register.
func (o *WDT_Type) SetCLKSEL(value uint32) {
	volatile.StoreUint32(&o.CLKSEL.Reg, volatile.LoadUint32(&o.CLKSEL.Reg)&^(0x3)|value)
}
func (o *WDT_Type) GetCLKSEL() uint32 {
	return volatile.LoadUint32(&o.CLKSEL.Reg) & 0x3
}
func (o *WDT_Type) SetCLKSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKSEL.Reg, volatile.LoadUint32(&o.CLKSEL.Reg)&^(0x7ffffffe)|value<<1)
}
func (o *WDT_Type) GetCLKSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKSEL.Reg) & 0x7ffffffe) >> 1
}
func (o *WDT_Type) SetCLKSEL_LOCK(value uint32) {
	volatile.StoreUint32(&o.CLKSEL.Reg, volatile.LoadUint32(&o.CLKSEL.Reg)&^(0x80000000)|value<<31)
}
func (o *WDT_Type) GetCLKSEL_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CLKSEL.Reg) & 0x80000000) >> 31
}

// Timer0/1/2/3
type TIMER0_Type struct {
	IR   volatile.Register32    // 0x0
	TCR  volatile.Register32    // 0x4
	TC   volatile.Register32    // 0x8
	PR   volatile.Register32    // 0xC
	PC   volatile.Register32    // 0x10
	MCR  volatile.Register32    // 0x14
	MR   [4]volatile.Register32 // 0x18
	CCR  volatile.Register32    // 0x28
	CR   [2]volatile.Register32 // 0x2C
	_    [8]byte
	EMR  volatile.Register32 // 0x3C
	_    [48]byte
	CTCR volatile.Register32 // 0x70
}

// TIMER0.IR: Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending.
func (o *TIMER0_Type) SetIR_MR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1)|value)
}
func (o *TIMER0_Type) GetIR_MR0INT() uint32 {
	return volatile.LoadUint32(&o.IR.Reg) & 0x1
}
func (o *TIMER0_Type) SetIR_MR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2)|value<<1)
}
func (o *TIMER0_Type) GetIR_MR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2) >> 1
}
func (o *TIMER0_Type) SetIR_MR2INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4)|value<<2)
}
func (o *TIMER0_Type) GetIR_MR2INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4) >> 2
}
func (o *TIMER0_Type) SetIR_MR3INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8)|value<<3)
}
func (o *TIMER0_Type) GetIR_MR3INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8) >> 3
}
func (o *TIMER0_Type) SetIR_CR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10)|value<<4)
}
func (o *TIMER0_Type) GetIR_CR0INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10) >> 4
}
func (o *TIMER0_Type) SetIR_CR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20)|value<<5)
}
func (o *TIMER0_Type) GetIR_CR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20) >> 5
}
func (o *TIMER0_Type) SetIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *TIMER0_Type) GetIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0xffffffc0) >> 6
}

// TIMER0.TCR: Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR.
func (o *TIMER0_Type) SetTCR_CEN(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x1)|value)
}
func (o *TIMER0_Type) GetTCR_CEN() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0x1
}
func (o *TIMER0_Type) SetTCR_CRST(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x2)|value<<1)
}
func (o *TIMER0_Type) GetTCR_CRST() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x2) >> 1
}
func (o *TIMER0_Type) SetTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *TIMER0_Type) GetTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xfffffffc) >> 2
}

// TIMER0.TC: Timer Counter. The 32 bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
func (o *TIMER0_Type) SetTC(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, value)
}
func (o *TIMER0_Type) GetTC() uint32 {
	return volatile.LoadUint32(&o.TC.Reg)
}

// TIMER0.PR: Prescale Register. When the Prescale Counter (PC) is equal to this value, the next clock increments the TC and clears the PC.
func (o *TIMER0_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, value)
}
func (o *TIMER0_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg)
}

// TIMER0.PC: Prescale Counter. The 32 bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface.
func (o *TIMER0_Type) SetPC(value uint32) {
	volatile.StoreUint32(&o.PC.Reg, value)
}
func (o *TIMER0_Type) GetPC() uint32 {
	return volatile.LoadUint32(&o.PC.Reg)
}

// TIMER0.MCR: Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs.
func (o *TIMER0_Type) SetMCR_MR0I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *TIMER0_Type) GetMCR_MR0I() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *TIMER0_Type) SetMCR_MR0R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *TIMER0_Type) GetMCR_MR0R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *TIMER0_Type) SetMCR_MR0S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *TIMER0_Type) GetMCR_MR0S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *TIMER0_Type) SetMCR_MR1I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *TIMER0_Type) GetMCR_MR1I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *TIMER0_Type) SetMCR_MR1R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *TIMER0_Type) GetMCR_MR1R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *TIMER0_Type) SetMCR_MR1S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *TIMER0_Type) GetMCR_MR1S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *TIMER0_Type) SetMCR_MR2I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *TIMER0_Type) GetMCR_MR2I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *TIMER0_Type) SetMCR_MR2R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *TIMER0_Type) GetMCR_MR2R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *TIMER0_Type) SetMCR_MR2S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x100)|value<<8)
}
func (o *TIMER0_Type) GetMCR_MR2S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x100) >> 8
}
func (o *TIMER0_Type) SetMCR_MR3I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x200)|value<<9)
}
func (o *TIMER0_Type) GetMCR_MR3I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x200) >> 9
}
func (o *TIMER0_Type) SetMCR_MR3R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x400)|value<<10)
}
func (o *TIMER0_Type) GetMCR_MR3R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x400) >> 10
}
func (o *TIMER0_Type) SetMCR_MR3S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x800)|value<<11)
}
func (o *TIMER0_Type) GetMCR_MR3S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x800) >> 11
}
func (o *TIMER0_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xfffff000)|value<<12)
}
func (o *TIMER0_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xfffff000) >> 12
}

// TIMER0.MR: Match Register 0. MR0 can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR0 matches the TC.
func (o *TIMER0_Type) SetMR(idx int, value uint32) {
	volatile.StoreUint32(&o.MR[idx].Reg, value)
}
func (o *TIMER0_Type) GetMR(idx int) uint32 {
	return volatile.LoadUint32(&o.MR[idx].Reg)
}

// TIMER0.CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place.
func (o *TIMER0_Type) SetCCR_CAP0RE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *TIMER0_Type) GetCCR_CAP0RE() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *TIMER0_Type) SetCCR_CAP0FE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *TIMER0_Type) GetCCR_CAP0FE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *TIMER0_Type) SetCCR_CAP0I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4)|value<<2)
}
func (o *TIMER0_Type) GetCCR_CAP0I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4) >> 2
}
func (o *TIMER0_Type) SetCCR_CAP1RE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *TIMER0_Type) GetCCR_CAP1RE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *TIMER0_Type) SetCCR_CAP1FE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *TIMER0_Type) GetCCR_CAP1FE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *TIMER0_Type) SetCCR_CAP1I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x20)|value<<5)
}
func (o *TIMER0_Type) GetCCR_CAP1I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x20) >> 5
}
func (o *TIMER0_Type) SetCCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *TIMER0_Type) GetCCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xffffffc0) >> 6
}

// TIMER0.CR: Capture Register 0. CR0 is loaded with the value of TC when there is an event on the CAPn.0 input.
func (o *TIMER0_Type) SetCR(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, value)
}
func (o *TIMER0_Type) GetCR(idx int) uint32 {
	return volatile.LoadUint32(&o.CR[idx].Reg)
}

// TIMER0.EMR: External Match Register. The EMR controls the external match pins.
func (o *TIMER0_Type) SetEMR_EM0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1)|value)
}
func (o *TIMER0_Type) GetEMR_EM0() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x1
}
func (o *TIMER0_Type) SetEMR_EM1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2)|value<<1)
}
func (o *TIMER0_Type) GetEMR_EM1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2) >> 1
}
func (o *TIMER0_Type) SetEMR_EM2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4)|value<<2)
}
func (o *TIMER0_Type) GetEMR_EM2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4) >> 2
}
func (o *TIMER0_Type) SetEMR_EM3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8)|value<<3)
}
func (o *TIMER0_Type) GetEMR_EM3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8) >> 3
}
func (o *TIMER0_Type) SetEMR_EMC0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x30)|value<<4)
}
func (o *TIMER0_Type) GetEMR_EMC0() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x30) >> 4
}
func (o *TIMER0_Type) SetEMR_EMC1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xc0)|value<<6)
}
func (o *TIMER0_Type) GetEMR_EMC1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xc0) >> 6
}
func (o *TIMER0_Type) SetEMR_EMC2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x300)|value<<8)
}
func (o *TIMER0_Type) GetEMR_EMC2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x300) >> 8
}
func (o *TIMER0_Type) SetEMR_EMC3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xc00)|value<<10)
}
func (o *TIMER0_Type) GetEMR_EMC3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xc00) >> 10
}
func (o *TIMER0_Type) SetEMR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xfffff000)|value<<12)
}
func (o *TIMER0_Type) GetEMR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xfffff000) >> 12
}

// TIMER0.CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
func (o *TIMER0_Type) SetCTCR_CTMODE(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0x3)|value)
}
func (o *TIMER0_Type) GetCTCR_CTMODE() uint32 {
	return volatile.LoadUint32(&o.CTCR.Reg) & 0x3
}
func (o *TIMER0_Type) SetCTCR_CINSEL(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xc)|value<<2)
}
func (o *TIMER0_Type) GetCTCR_CINSEL() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xc) >> 2
}
func (o *TIMER0_Type) SetCTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *TIMER0_Type) GetCTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xfffffff0) >> 4
}

// UART0/2/3
type UART0_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	_             [4]byte
	LSR           volatile.Register32 // 0x14
	_             [4]byte
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	_             [4]byte
	FDR           volatile.Register32 // 0x28
	_             [4]byte
	TER           volatile.Register32 // 0x30
	_             [24]byte
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
}

// UART0.RBR: Receiver Buffer Register. Contains the next received character to be read (DLAB =0).
func (o *UART0_Type) SetRBR(value uint32) {
	volatile.StoreUint32(&o.RBR.Reg, volatile.LoadUint32(&o.RBR.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetRBR() uint32 {
	return volatile.LoadUint32(&o.RBR.Reg) & 0xff
}
func (o *UART0_Type) SetRBR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RBR.Reg, volatile.LoadUint32(&o.RBR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetRBR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RBR.Reg) & 0xffffff00) >> 8
}

// UART0.DLM: Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider (DLAB =1).
func (o *UART0_Type) SetDLM_DLMSB(value uint32) {
	volatile.StoreUint32(&o.DLM.Reg, volatile.LoadUint32(&o.DLM.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetDLM_DLMSB() uint32 {
	return volatile.LoadUint32(&o.DLM.Reg) & 0xff
}
func (o *UART0_Type) SetDLM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DLM.Reg, volatile.LoadUint32(&o.DLM.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetDLM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DLM.Reg) & 0xffffff00) >> 8
}

// UART0.IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
func (o *UART0_Type) SetIIR_INTSTATUS(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetIIR_INTSTATUS() uint32 {
	return volatile.LoadUint32(&o.IIR.Reg) & 0x1
}
func (o *UART0_Type) SetIIR_INTID(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xe)|value<<1)
}
func (o *UART0_Type) GetIIR_INTID() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xe) >> 1
}
func (o *UART0_Type) SetIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x30)|value<<4)
}
func (o *UART0_Type) GetIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x30) >> 4
}
func (o *UART0_Type) SetIIR_FIFOENABLE(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xc0)|value<<6)
}
func (o *UART0_Type) GetIIR_FIFOENABLE() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xc0) >> 6
}
func (o *UART0_Type) SetIIR_ABEOINT(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x100)|value<<8)
}
func (o *UART0_Type) GetIIR_ABEOINT() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x100) >> 8
}
func (o *UART0_Type) SetIIR_ABTOINT(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x200)|value<<9)
}
func (o *UART0_Type) GetIIR_ABTOINT() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x200) >> 9
}
func (o *UART0_Type) SetIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *UART0_Type) GetIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xfffffc00) >> 10
}

// UART0.LCR: Line Control Register. Contains controls for frame formatting and break generation.
func (o *UART0_Type) SetLCR_WLS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x3)|value)
}
func (o *UART0_Type) GetLCR_WLS() uint32 {
	return volatile.LoadUint32(&o.LCR.Reg) & 0x3
}
func (o *UART0_Type) SetLCR_SBS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetLCR_SBS() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetLCR_PE(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetLCR_PE() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetLCR_PS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x30)|value<<4)
}
func (o *UART0_Type) GetLCR_PS() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x30) >> 4
}
func (o *UART0_Type) SetLCR_BC(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetLCR_BC() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetLCR_DLAB(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetLCR_DLAB() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x80) >> 7
}
func (o *UART0_Type) SetLCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetLCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0xffffff00) >> 8
}

// UART0.LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
func (o *UART0_Type) SetLSR_RDR(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetLSR_RDR() uint32 {
	return volatile.LoadUint32(&o.LSR.Reg) & 0x1
}
func (o *UART0_Type) SetLSR_OE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetLSR_OE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetLSR_PE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetLSR_PE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetLSR_FE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetLSR_FE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetLSR_BI(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetLSR_BI() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetLSR_THRE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetLSR_THRE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetLSR_TEMT(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40)|value<<6)
}
func (o *UART0_Type) GetLSR_TEMT() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40) >> 6
}
func (o *UART0_Type) SetLSR_RXFE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetLSR_RXFE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80) >> 7
}
func (o *UART0_Type) SetLSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetLSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0xffffff00) >> 8
}

// UART0.SCR: Scratch Pad Register. 8-bit temporary storage for software.
func (o *UART0_Type) SetSCR_PAD(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetSCR_PAD() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0xff
}
func (o *UART0_Type) SetSCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetSCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0xffffff00) >> 8
}

// UART0.ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
func (o *UART0_Type) SetACR_START(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetACR_START() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x1
}
func (o *UART0_Type) SetACR_MODE(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetACR_MODE() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetACR_AUTORESTART(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetACR_AUTORESTART() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetACR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xf8)|value<<3)
}
func (o *UART0_Type) GetACR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xf8) >> 3
}
func (o *UART0_Type) SetACR_ABEOINTCLR(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *UART0_Type) GetACR_ABEOINTCLR() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *UART0_Type) SetACR_ABTOINTCLR(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *UART0_Type) GetACR_ABTOINTCLR() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *UART0_Type) SetACR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *UART0_Type) GetACR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xfffffc00) >> 10
}

// UART0.FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
func (o *UART0_Type) SetFDR_DIVADDVAL(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xf)|value)
}
func (o *UART0_Type) GetFDR_DIVADDVAL() uint32 {
	return volatile.LoadUint32(&o.FDR.Reg) & 0xf
}
func (o *UART0_Type) SetFDR_MULVAL(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xf0)|value<<4)
}
func (o *UART0_Type) GetFDR_MULVAL() uint32 {
	return (volatile.LoadUint32(&o.FDR.Reg) & 0xf0) >> 4
}
func (o *UART0_Type) SetFDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetFDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FDR.Reg) & 0xffffff00) >> 8
}

// UART0.TER: Transmit Enable Register. Turns off UART transmitter for use with software flow control.
func (o *UART0_Type) SetTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0x7f)|value)
}
func (o *UART0_Type) GetTER_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TER.Reg) & 0x7f
}
func (o *UART0_Type) SetTER_TXEN(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0x80)|value<<7)
}
func (o *UART0_Type) GetTER_TXEN() uint32 {
	return (volatile.LoadUint32(&o.TER.Reg) & 0x80) >> 7
}
func (o *UART0_Type) SetTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetTER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TER.Reg) & 0xffffff00) >> 8
}

// UART0.RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
func (o *UART0_Type) SetRS485CTRL_NMMEN(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x1)|value)
}
func (o *UART0_Type) GetRS485CTRL_NMMEN() uint32 {
	return volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x1
}
func (o *UART0_Type) SetRS485CTRL_RXDIS(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x2)|value<<1)
}
func (o *UART0_Type) GetRS485CTRL_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x2) >> 1
}
func (o *UART0_Type) SetRS485CTRL_AADEN(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x4)|value<<2)
}
func (o *UART0_Type) GetRS485CTRL_AADEN() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x4) >> 2
}
func (o *UART0_Type) SetRS485CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x8)|value<<3)
}
func (o *UART0_Type) GetRS485CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x8) >> 3
}
func (o *UART0_Type) SetRS485CTRL_DCTRL(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x10)|value<<4)
}
func (o *UART0_Type) GetRS485CTRL_DCTRL() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x10) >> 4
}
func (o *UART0_Type) SetRS485CTRL_OINV(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x20)|value<<5)
}
func (o *UART0_Type) GetRS485CTRL_OINV() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x20) >> 5
}
func (o *UART0_Type) SetRS485CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0xffffffc0)|value<<6)
}
func (o *UART0_Type) GetRS485CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0xffffffc0) >> 6
}

// UART0.RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
func (o *UART0_Type) SetRS485ADRMATCH_ADRMATCH(value uint32) {
	volatile.StoreUint32(&o.RS485ADRMATCH.Reg, volatile.LoadUint32(&o.RS485ADRMATCH.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetRS485ADRMATCH_ADRMATCH() uint32 {
	return volatile.LoadUint32(&o.RS485ADRMATCH.Reg) & 0xff
}
func (o *UART0_Type) SetRS485ADRMATCH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485ADRMATCH.Reg, volatile.LoadUint32(&o.RS485ADRMATCH.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetRS485ADRMATCH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485ADRMATCH.Reg) & 0xffffff00) >> 8
}

// UART0.RS485DLY: RS-485/EIA-485 direction control delay.
func (o *UART0_Type) SetRS485DLY_DLY(value uint32) {
	volatile.StoreUint32(&o.RS485DLY.Reg, volatile.LoadUint32(&o.RS485DLY.Reg)&^(0xff)|value)
}
func (o *UART0_Type) GetRS485DLY_DLY() uint32 {
	return volatile.LoadUint32(&o.RS485DLY.Reg) & 0xff
}
func (o *UART0_Type) SetRS485DLY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485DLY.Reg, volatile.LoadUint32(&o.RS485DLY.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART0_Type) GetRS485DLY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485DLY.Reg) & 0xffffff00) >> 8
}

// UART1
type UART1_Type struct {
	RBR           volatile.Register32 // 0x0
	DLM           volatile.Register32 // 0x4
	IIR           volatile.Register32 // 0x8
	LCR           volatile.Register32 // 0xC
	MCR           volatile.Register32 // 0x10
	LSR           volatile.Register32 // 0x14
	MSR           volatile.Register32 // 0x18
	SCR           volatile.Register32 // 0x1C
	ACR           volatile.Register32 // 0x20
	_             [4]byte
	FDR           volatile.Register32 // 0x28
	_             [4]byte
	TER           volatile.Register32 // 0x30
	_             [24]byte
	RS485CTRL     volatile.Register32 // 0x4C
	RS485ADRMATCH volatile.Register32 // 0x50
	RS485DLY      volatile.Register32 // 0x54
}

// UART1.RBR: DLAB =0 Receiver Buffer Register. Contains the next received character to be read.
func (o *UART1_Type) SetRBR(value uint32) {
	volatile.StoreUint32(&o.RBR.Reg, volatile.LoadUint32(&o.RBR.Reg)&^(0xff)|value)
}
func (o *UART1_Type) GetRBR() uint32 {
	return volatile.LoadUint32(&o.RBR.Reg) & 0xff
}
func (o *UART1_Type) SetRBR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RBR.Reg, volatile.LoadUint32(&o.RBR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetRBR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RBR.Reg) & 0xffffff00) >> 8
}

// UART1.DLM: DLAB =1. Divisor Latch MSB. Most significant byte of the baud rate divisor value. The full divisor is used to generate a baud rate from the fractional rate divider.
func (o *UART1_Type) SetDLM_DLMSB(value uint32) {
	volatile.StoreUint32(&o.DLM.Reg, volatile.LoadUint32(&o.DLM.Reg)&^(0xff)|value)
}
func (o *UART1_Type) GetDLM_DLMSB() uint32 {
	return volatile.LoadUint32(&o.DLM.Reg) & 0xff
}
func (o *UART1_Type) SetDLM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DLM.Reg, volatile.LoadUint32(&o.DLM.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetDLM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DLM.Reg) & 0xffffff00) >> 8
}

// UART1.IIR: Interrupt ID Register. Identifies which interrupt(s) are pending.
func (o *UART1_Type) SetIIR_INTSTATUS(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x1)|value)
}
func (o *UART1_Type) GetIIR_INTSTATUS() uint32 {
	return volatile.LoadUint32(&o.IIR.Reg) & 0x1
}
func (o *UART1_Type) SetIIR_INTID(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xe)|value<<1)
}
func (o *UART1_Type) GetIIR_INTID() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xe) >> 1
}
func (o *UART1_Type) SetIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x30)|value<<4)
}
func (o *UART1_Type) GetIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x30) >> 4
}
func (o *UART1_Type) SetIIR_FIFOENABLE(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xc0)|value<<6)
}
func (o *UART1_Type) GetIIR_FIFOENABLE() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xc0) >> 6
}
func (o *UART1_Type) SetIIR_ABEOINT(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x100)|value<<8)
}
func (o *UART1_Type) GetIIR_ABEOINT() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x100) >> 8
}
func (o *UART1_Type) SetIIR_ABTOINT(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0x200)|value<<9)
}
func (o *UART1_Type) GetIIR_ABTOINT() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0x200) >> 9
}
func (o *UART1_Type) SetIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IIR.Reg, volatile.LoadUint32(&o.IIR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *UART1_Type) GetIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IIR.Reg) & 0xfffffc00) >> 10
}

// UART1.LCR: Line Control Register. Contains controls for frame formatting and break generation.
func (o *UART1_Type) SetLCR_WLS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x3)|value)
}
func (o *UART1_Type) GetLCR_WLS() uint32 {
	return volatile.LoadUint32(&o.LCR.Reg) & 0x3
}
func (o *UART1_Type) SetLCR_SBS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x4)|value<<2)
}
func (o *UART1_Type) GetLCR_SBS() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x4) >> 2
}
func (o *UART1_Type) SetLCR_PE(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x8)|value<<3)
}
func (o *UART1_Type) GetLCR_PE() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x8) >> 3
}
func (o *UART1_Type) SetLCR_PS(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x30)|value<<4)
}
func (o *UART1_Type) GetLCR_PS() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x30) >> 4
}
func (o *UART1_Type) SetLCR_BC(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x40)|value<<6)
}
func (o *UART1_Type) GetLCR_BC() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x40) >> 6
}
func (o *UART1_Type) SetLCR_DLAB(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0x80)|value<<7)
}
func (o *UART1_Type) GetLCR_DLAB() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0x80) >> 7
}
func (o *UART1_Type) SetLCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LCR.Reg, volatile.LoadUint32(&o.LCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetLCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LCR.Reg) & 0xffffff00) >> 8
}

// UART1.MCR: Modem Control Register. Contains controls for flow control handshaking and loopback mode.
func (o *UART1_Type) SetMCR_DTRCTRL(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *UART1_Type) GetMCR_DTRCTRL() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *UART1_Type) SetMCR_RTSCTRL(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *UART1_Type) GetMCR_RTSCTRL() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *UART1_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xc)|value<<2)
}
func (o *UART1_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xc) >> 2
}
func (o *UART1_Type) SetMCR_LMS(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *UART1_Type) GetMCR_LMS() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *UART1_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *UART1_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *UART1_Type) SetMCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *UART1_Type) GetMCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *UART1_Type) SetMCR_CTSEN(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *UART1_Type) GetMCR_CTSEN() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *UART1_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xffffff00) >> 8
}

// UART1.LSR: Line Status Register. Contains flags for transmit and receive status, including line errors.
func (o *UART1_Type) SetLSR_RDR(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1)|value)
}
func (o *UART1_Type) GetLSR_RDR() uint32 {
	return volatile.LoadUint32(&o.LSR.Reg) & 0x1
}
func (o *UART1_Type) SetLSR_OE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2)|value<<1)
}
func (o *UART1_Type) GetLSR_OE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2) >> 1
}
func (o *UART1_Type) SetLSR_PE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4)|value<<2)
}
func (o *UART1_Type) GetLSR_PE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4) >> 2
}
func (o *UART1_Type) SetLSR_FE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8)|value<<3)
}
func (o *UART1_Type) GetLSR_FE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8) >> 3
}
func (o *UART1_Type) SetLSR_BI(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10)|value<<4)
}
func (o *UART1_Type) GetLSR_BI() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10) >> 4
}
func (o *UART1_Type) SetLSR_THRE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20)|value<<5)
}
func (o *UART1_Type) GetLSR_THRE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20) >> 5
}
func (o *UART1_Type) SetLSR_TEMT(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40)|value<<6)
}
func (o *UART1_Type) GetLSR_TEMT() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40) >> 6
}
func (o *UART1_Type) SetLSR_RXFE(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80)|value<<7)
}
func (o *UART1_Type) GetLSR_RXFE() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80) >> 7
}
func (o *UART1_Type) SetLSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetLSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0xffffff00) >> 8
}

// UART1.MSR: Modem Status Register. Contains handshake signal status flags.
func (o *UART1_Type) SetMSR_DCTS(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x1)|value)
}
func (o *UART1_Type) GetMSR_DCTS() uint32 {
	return volatile.LoadUint32(&o.MSR.Reg) & 0x1
}
func (o *UART1_Type) SetMSR_DDSR(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x2)|value<<1)
}
func (o *UART1_Type) GetMSR_DDSR() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x2) >> 1
}
func (o *UART1_Type) SetMSR_TERI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x4)|value<<2)
}
func (o *UART1_Type) GetMSR_TERI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x4) >> 2
}
func (o *UART1_Type) SetMSR_DDCD(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x8)|value<<3)
}
func (o *UART1_Type) GetMSR_DDCD() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x8) >> 3
}
func (o *UART1_Type) SetMSR_CTS(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x10)|value<<4)
}
func (o *UART1_Type) GetMSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x10) >> 4
}
func (o *UART1_Type) SetMSR_DSR(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x20)|value<<5)
}
func (o *UART1_Type) GetMSR_DSR() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x20) >> 5
}
func (o *UART1_Type) SetMSR_RI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x40)|value<<6)
}
func (o *UART1_Type) GetMSR_RI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x40) >> 6
}
func (o *UART1_Type) SetMSR_DCD(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x80)|value<<7)
}
func (o *UART1_Type) GetMSR_DCD() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x80) >> 7
}
func (o *UART1_Type) SetMSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetMSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0xffffff00) >> 8
}

// UART1.SCR: Scratch Pad Register. 8-bit temporary storage for software.
func (o *UART1_Type) SetSCR_Pad(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xff)|value)
}
func (o *UART1_Type) GetSCR_Pad() uint32 {
	return volatile.LoadUint32(&o.SCR.Reg) & 0xff
}
func (o *UART1_Type) SetSCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetSCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0xffffff00) >> 8
}

// UART1.ACR: Auto-baud Control Register. Contains controls for the auto-baud feature.
func (o *UART1_Type) SetACR_START(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x1)|value)
}
func (o *UART1_Type) GetACR_START() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x1
}
func (o *UART1_Type) SetACR_MODE(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x2)|value<<1)
}
func (o *UART1_Type) GetACR_MODE() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x2) >> 1
}
func (o *UART1_Type) SetACR_AUTORESTART(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x4)|value<<2)
}
func (o *UART1_Type) GetACR_AUTORESTART() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x4) >> 2
}
func (o *UART1_Type) SetACR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xf8)|value<<3)
}
func (o *UART1_Type) GetACR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xf8) >> 3
}
func (o *UART1_Type) SetACR_ABEOINTCLR(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *UART1_Type) GetACR_ABEOINTCLR() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *UART1_Type) SetACR_ABTOINTCLR(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *UART1_Type) GetACR_ABTOINTCLR() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *UART1_Type) SetACR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *UART1_Type) GetACR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0xfffffc00) >> 10
}

// UART1.FDR: Fractional Divider Register. Generates a clock input for the baud rate divider.
func (o *UART1_Type) SetFDR_DIVADDVAL(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xf)|value)
}
func (o *UART1_Type) GetFDR_DIVADDVAL() uint32 {
	return volatile.LoadUint32(&o.FDR.Reg) & 0xf
}
func (o *UART1_Type) SetFDR_MULVAL(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xf0)|value<<4)
}
func (o *UART1_Type) GetFDR_MULVAL() uint32 {
	return (volatile.LoadUint32(&o.FDR.Reg) & 0xf0) >> 4
}
func (o *UART1_Type) SetFDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FDR.Reg, volatile.LoadUint32(&o.FDR.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetFDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FDR.Reg) & 0xffffff00) >> 8
}

// UART1.TER: Transmit Enable Register. Turns off UART transmitter for use with software flow control.
func (o *UART1_Type) SetTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0x7f)|value)
}
func (o *UART1_Type) GetTER_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TER.Reg) & 0x7f
}
func (o *UART1_Type) SetTER_TXEN(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0x80)|value<<7)
}
func (o *UART1_Type) GetTER_TXEN() uint32 {
	return (volatile.LoadUint32(&o.TER.Reg) & 0x80) >> 7
}
func (o *UART1_Type) SetTER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TER.Reg, volatile.LoadUint32(&o.TER.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetTER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TER.Reg) & 0xffffff00) >> 8
}

// UART1.RS485CTRL: RS-485/EIA-485 Control. Contains controls to configure various aspects of RS-485/EIA-485 modes.
func (o *UART1_Type) SetRS485CTRL_NMMEN(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x1)|value)
}
func (o *UART1_Type) GetRS485CTRL_NMMEN() uint32 {
	return volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x1
}
func (o *UART1_Type) SetRS485CTRL_RXDIS(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x2)|value<<1)
}
func (o *UART1_Type) GetRS485CTRL_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x2) >> 1
}
func (o *UART1_Type) SetRS485CTRL_AADEN(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x4)|value<<2)
}
func (o *UART1_Type) GetRS485CTRL_AADEN() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x4) >> 2
}
func (o *UART1_Type) SetRS485CTRL_SEL(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x8)|value<<3)
}
func (o *UART1_Type) GetRS485CTRL_SEL() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x8) >> 3
}
func (o *UART1_Type) SetRS485CTRL_DCTRL(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x10)|value<<4)
}
func (o *UART1_Type) GetRS485CTRL_DCTRL() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x10) >> 4
}
func (o *UART1_Type) SetRS485CTRL_OINV(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0x20)|value<<5)
}
func (o *UART1_Type) GetRS485CTRL_OINV() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0x20) >> 5
}
func (o *UART1_Type) SetRS485CTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485CTRL.Reg, volatile.LoadUint32(&o.RS485CTRL.Reg)&^(0xffffffc0)|value<<6)
}
func (o *UART1_Type) GetRS485CTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485CTRL.Reg) & 0xffffffc0) >> 6
}

// UART1.RS485ADRMATCH: RS-485/EIA-485 address match. Contains the address match value for RS-485/EIA-485 mode.
func (o *UART1_Type) SetRS485ADRMATCH_ADRMATCH(value uint32) {
	volatile.StoreUint32(&o.RS485ADRMATCH.Reg, volatile.LoadUint32(&o.RS485ADRMATCH.Reg)&^(0xff)|value)
}
func (o *UART1_Type) GetRS485ADRMATCH_ADRMATCH() uint32 {
	return volatile.LoadUint32(&o.RS485ADRMATCH.Reg) & 0xff
}
func (o *UART1_Type) SetRS485ADRMATCH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485ADRMATCH.Reg, volatile.LoadUint32(&o.RS485ADRMATCH.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetRS485ADRMATCH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485ADRMATCH.Reg) & 0xffffff00) >> 8
}

// UART1.RS485DLY: RS-485/EIA-485 direction control delay.
func (o *UART1_Type) SetRS485DLY_DLY(value uint32) {
	volatile.StoreUint32(&o.RS485DLY.Reg, volatile.LoadUint32(&o.RS485DLY.Reg)&^(0xff)|value)
}
func (o *UART1_Type) GetRS485DLY_DLY() uint32 {
	return volatile.LoadUint32(&o.RS485DLY.Reg) & 0xff
}
func (o *UART1_Type) SetRS485DLY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RS485DLY.Reg, volatile.LoadUint32(&o.RS485DLY.Reg)&^(0xffffff00)|value<<8)
}
func (o *UART1_Type) GetRS485DLY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RS485DLY.Reg) & 0xffffff00) >> 8
}

// Pulse Width Modulators (PWM1)
type PWM_Type struct {
	IR   volatile.Register32    // 0x0
	TCR  volatile.Register32    // 0x4
	TC   volatile.Register32    // 0x8
	PR   volatile.Register32    // 0xC
	PC   volatile.Register32    // 0x10
	MCR  volatile.Register32    // 0x14
	MR0  volatile.Register32    // 0x18
	MR1  volatile.Register32    // 0x1C
	MR2  volatile.Register32    // 0x20
	MR3  volatile.Register32    // 0x24
	CCR  volatile.Register32    // 0x28
	CR   [2]volatile.Register32 // 0x2C
	_    [12]byte
	MR4  volatile.Register32 // 0x40
	MR5  volatile.Register32 // 0x44
	MR6  volatile.Register32 // 0x48
	PCR  volatile.Register32 // 0x4C
	LER  volatile.Register32 // 0x50
	_    [28]byte
	CTCR volatile.Register32 // 0x70
}

// PWM.IR: Interrupt Register. The IR can be written to clear interrupts, or read to identify which PWM interrupt sources are pending.
func (o *PWM_Type) SetIR_PWMMR0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIR_PWMMR0INT() uint32 {
	return volatile.LoadUint32(&o.IR.Reg) & 0x1
}
func (o *PWM_Type) SetIR_PWMMR1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIR_PWMMR1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIR_PWMMR2INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIR_PWMMR2INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIR_PWMMR3INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIR_PWMMR3INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetIR_PWMCAP0INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetIR_PWMCAP0INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetIR_PWMCAP1INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetIR_PWMCAP1INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0xc0)|value<<6)
}
func (o *PWM_Type) GetIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0xc0) >> 6
}
func (o *PWM_Type) SetIR_PWMMR4INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetIR_PWMMR4INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetIR_PWMMR5INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetIR_PWMMR5INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetIR_PWMMR6INT(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetIR_PWMMR6INT() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IR.Reg, volatile.LoadUint32(&o.IR.Reg)&^(0xfffff800)|value<<11)
}
func (o *PWM_Type) GetIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IR.Reg) & 0xfffff800) >> 11
}

// PWM.TCR: Timer Control Register. The TCR is used to control the Timer Counter functions.
func (o *PWM_Type) SetTCR_CE(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetTCR_CE() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0x1
}
func (o *PWM_Type) SetTCR_CR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetTCR_CR() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetTCR_PWMEN(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetTCR_PWMEN() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetTCR_MDIS(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetTCR_MDIS() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *PWM_Type) GetTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TCR.Reg) & 0xffffffe0) >> 5
}

// PWM.TC: Timer Counter. The 32 bit TC is incremented every PR+1 cycles of PCLK. The TC is controlled through the TCR.
func (o *PWM_Type) SetTC(value uint32) {
	volatile.StoreUint32(&o.TC.Reg, value)
}
func (o *PWM_Type) GetTC() uint32 {
	return volatile.LoadUint32(&o.TC.Reg)
}

// PWM.PR: Prescale Register. Determines how often the PWM counter is incremented.
func (o *PWM_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, value)
}
func (o *PWM_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg)
}

// PWM.PC: Prescale Counter. Prescaler for the main PWM counter.
func (o *PWM_Type) SetPC(value uint32) {
	volatile.StoreUint32(&o.PC.Reg, value)
}
func (o *PWM_Type) GetPC() uint32 {
	return volatile.LoadUint32(&o.PC.Reg)
}

// PWM.MCR: Match Control Register. The MCR is used to control whether an interrupt is generated and if the PWM counter is reset when a Match occurs.
func (o *PWM_Type) SetMCR_PWMMR0I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetMCR_PWMMR0I() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}
func (o *PWM_Type) SetMCR_PWMMR0R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetMCR_PWMMR0R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetMCR_PWMMR0S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetMCR_PWMMR0S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetMCR_PWMMR1I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetMCR_PWMMR1I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetMCR_PWMMR1R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetMCR_PWMMR1R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetMCR_PWMMR1S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetMCR_PWMMR1S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetMCR_PWMMR2I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetMCR_PWMMR2I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetMCR_PWMMR2R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetMCR_PWMMR2R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *PWM_Type) SetMCR_PWMMR2S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetMCR_PWMMR2S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetMCR_PWMMR3I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetMCR_PWMMR3I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetMCR_PWMMR3R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetMCR_PWMMR3R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetMCR_PWMMR3S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetMCR_PWMMR3S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetMCR_PWMMR4I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetMCR_PWMMR4I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetMCR_PWMMR4R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetMCR_PWMMR4R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetMCR_PWMMR4S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetMCR_PWMMR4S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetMCR_PWMMR5I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000)|value<<15)
}
func (o *PWM_Type) GetMCR_PWMMR5I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000) >> 15
}
func (o *PWM_Type) SetMCR_PWMMR5R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10000)|value<<16)
}
func (o *PWM_Type) GetMCR_PWMMR5R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10000) >> 16
}
func (o *PWM_Type) SetMCR_PWMMR5S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20000)|value<<17)
}
func (o *PWM_Type) GetMCR_PWMMR5S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20000) >> 17
}
func (o *PWM_Type) SetMCR_PWMMR6I(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40000)|value<<18)
}
func (o *PWM_Type) GetMCR_PWMMR6I() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40000) >> 18
}
func (o *PWM_Type) SetMCR_PWMMR6R(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80000)|value<<19)
}
func (o *PWM_Type) GetMCR_PWMMR6R() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80000) >> 19
}
func (o *PWM_Type) SetMCR_PWMMR6S(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x100000)|value<<20)
}
func (o *PWM_Type) GetMCR_PWMMR6S() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x100000) >> 20
}
func (o *PWM_Type) SetMCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0xffe00000)|value<<21)
}
func (o *PWM_Type) GetMCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0xffe00000) >> 21
}

// PWM.MR0: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR0(value uint32) {
	volatile.StoreUint32(&o.MR0.Reg, value)
}
func (o *PWM_Type) GetMR0() uint32 {
	return volatile.LoadUint32(&o.MR0.Reg)
}

// PWM.MR1: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR1(value uint32) {
	volatile.StoreUint32(&o.MR1.Reg, value)
}
func (o *PWM_Type) GetMR1() uint32 {
	return volatile.LoadUint32(&o.MR1.Reg)
}

// PWM.MR2: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR2(value uint32) {
	volatile.StoreUint32(&o.MR2.Reg, value)
}
func (o *PWM_Type) GetMR2() uint32 {
	return volatile.LoadUint32(&o.MR2.Reg)
}

// PWM.MR3: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR3(value uint32) {
	volatile.StoreUint32(&o.MR3.Reg, value)
}
func (o *PWM_Type) GetMR3() uint32 {
	return volatile.LoadUint32(&o.MR3.Reg)
}

// PWM.CCR: Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated for a capture event.
func (o *PWM_Type) SetCCR_CAP0_R(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetCCR_CAP0_R() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *PWM_Type) SetCCR_CAP0_F(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetCCR_CAP0_F() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetCCR_CAP0_I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetCCR_CAP0_I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetCCR_CAP1_R(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetCCR_CAP1_R() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetCCR_CAP1_F(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetCCR_CAP1_F() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetCCR_CAP1_I(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetCCR_CAP1_I() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetCCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xffffffc0)|value<<6)
}
func (o *PWM_Type) GetCCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xffffffc0) >> 6
}

// PWM.CR: PWM Control Register. Enables PWM outputs and selects either single edge or double edge controlled PWM outputs.
func (o *PWM_Type) SetCR_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetCR_RESERVED(idx int) uint32 {
	return volatile.LoadUint32(&o.CR[idx].Reg) & 0x3
}
func (o *PWM_Type) SetCR_PWMSEL2(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetCR_PWMSEL2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetCR_PWMSEL3(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetCR_PWMSEL3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetCR_PWMSEL4(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetCR_PWMSEL4(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetCR_PWMSEL5(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetCR_PWMSEL5(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetCR_PWMSEL6(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetCR_PWMSEL6(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetCR_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x180)|value<<7)
}
func (o *PWM_Type) GetCR_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x180) >> 7
}
func (o *PWM_Type) SetCR_PWMENA1(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCR_PWMENA1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCR_PWMENA2(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCR_PWMENA2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetCR_PWMENA3(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetCR_PWMENA3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetCR_PWMENA4(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetCR_PWMENA4(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetCR_PWMENA5(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetCR_PWMENA5(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetCR_PWMENA6(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetCR_PWMENA6(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetCR_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.CR[idx].Reg, volatile.LoadUint32(&o.CR[idx].Reg)&^(0xffff8000)|value<<15)
}
func (o *PWM_Type) GetCR_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.CR[idx].Reg) & 0xffff8000) >> 15
}

// PWM.MR4: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR4(value uint32) {
	volatile.StoreUint32(&o.MR4.Reg, value)
}
func (o *PWM_Type) GetMR4() uint32 {
	return volatile.LoadUint32(&o.MR4.Reg)
}

// PWM.MR5: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR5(value uint32) {
	volatile.StoreUint32(&o.MR5.Reg, value)
}
func (o *PWM_Type) GetMR5() uint32 {
	return volatile.LoadUint32(&o.MR5.Reg)
}

// PWM.MR6: Match Register. Match registers are continuously compared to the PWM counter in order to control PWM output edges.
func (o *PWM_Type) SetMR6(value uint32) {
	volatile.StoreUint32(&o.MR6.Reg, value)
}
func (o *PWM_Type) GetMR6() uint32 {
	return volatile.LoadUint32(&o.MR6.Reg)
}

// PWM.PCR: PWM Control Register. Enables PWM outputs and selects either single edge or double edge controlled PWM outputs.
func (o *PWM_Type) SetPCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetPCR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PCR.Reg) & 0x3
}
func (o *PWM_Type) SetPCR_PWMSEL2(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetPCR_PWMSEL2() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetPCR_PWMSEL3(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetPCR_PWMSEL3() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetPCR_PWMSEL4(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetPCR_PWMSEL4() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetPCR_PWMSEL5(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetPCR_PWMSEL5() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetPCR_PWMSEL6(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetPCR_PWMSEL6() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetPCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x180)|value<<7)
}
func (o *PWM_Type) GetPCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x180) >> 7
}
func (o *PWM_Type) SetPCR_PWMENA1(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetPCR_PWMENA1() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetPCR_PWMENA2(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetPCR_PWMENA2() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x400) >> 10
}
func (o *PWM_Type) SetPCR_PWMENA3(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x800)|value<<11)
}
func (o *PWM_Type) GetPCR_PWMENA3() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x800) >> 11
}
func (o *PWM_Type) SetPCR_PWMENA4(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1000)|value<<12)
}
func (o *PWM_Type) GetPCR_PWMENA4() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1000) >> 12
}
func (o *PWM_Type) SetPCR_PWMENA5(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x2000)|value<<13)
}
func (o *PWM_Type) GetPCR_PWMENA5() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x2000) >> 13
}
func (o *PWM_Type) SetPCR_PWMENA6(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x4000)|value<<14)
}
func (o *PWM_Type) GetPCR_PWMENA6() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x4000) >> 14
}
func (o *PWM_Type) SetPCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0xffff8000)|value<<15)
}
func (o *PWM_Type) GetPCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0xffff8000) >> 15
}

// PWM.LER: Load Enable Register. Enables use of updated PWM match values.
func (o *PWM_Type) SetLER_MAT0LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetLER_MAT0LATCHEN() uint32 {
	return volatile.LoadUint32(&o.LER.Reg) & 0x1
}
func (o *PWM_Type) SetLER_MAT1LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetLER_MAT1LATCHEN() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetLER_MAT2LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetLER_MAT2LATCHEN() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetLER_MAT3LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetLER_MAT3LATCHEN() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetLER_MAT4LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetLER_MAT4LATCHEN() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetLER_MAT5LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetLER_MAT5LATCHEN() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetLER_MAT6LATCHEN(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetLER_MAT6LATCHEN() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetLER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LER.Reg, volatile.LoadUint32(&o.LER.Reg)&^(0xffffff80)|value<<7)
}
func (o *PWM_Type) GetLER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LER.Reg) & 0xffffff80) >> 7
}

// PWM.CTCR: Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting.
func (o *PWM_Type) SetCTCR_MOD(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetCTCR_MOD() uint32 {
	return volatile.LoadUint32(&o.CTCR.Reg) & 0x3
}
func (o *PWM_Type) SetCTCR_CIS(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xc)|value<<2)
}
func (o *PWM_Type) GetCTCR_CIS() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xc) >> 2
}
func (o *PWM_Type) SetCTCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTCR.Reg, volatile.LoadUint32(&o.CTCR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *PWM_Type) GetCTCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTCR.Reg) & 0xfffffff0) >> 4
}

// I2C bus interface
type I2C_Type struct {
	CONSET      volatile.Register32    // 0x0
	STAT        volatile.Register32    // 0x4
	DAT         volatile.Register32    // 0x8
	ADR0        volatile.Register32    // 0xC
	SCLH        volatile.Register32    // 0x10
	SCLL        volatile.Register32    // 0x14
	CONCLR      volatile.Register32    // 0x18
	MMCTRL      volatile.Register32    // 0x1C
	ADR1        volatile.Register32    // 0x20
	ADR2        volatile.Register32    // 0x24
	ADR3        volatile.Register32    // 0x28
	DATA_BUFFER volatile.Register32    // 0x2C
	MASK        [4]volatile.Register32 // 0x30
}

// I2C.CONSET: I2C Control Set Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is set. Writing a zero has no effect on the corresponding bit in the I2C control register.
func (o *I2C_Type) SetCONSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x3)|value)
}
func (o *I2C_Type) GetCONSET_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CONSET.Reg) & 0x3
}
func (o *I2C_Type) SetCONSET_AA(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCONSET_AA() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCONSET_SI(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCONSET_SI() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCONSET_STO(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCONSET_STO() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCONSET_STA(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCONSET_STA() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCONSET_I2EN(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCONSET_I2EN() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCONSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONSET.Reg, volatile.LoadUint32(&o.CONSET.Reg)&^(0xffffff80)|value<<7)
}
func (o *I2C_Type) GetCONSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONSET.Reg) & 0xffffff80) >> 7
}

// I2C.STAT: I2C Status Register. During I2C operation, this register provides detailed status codes that allow software to determine the next action needed.
func (o *I2C_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x7)|value)
}
func (o *I2C_Type) GetSTAT_RESERVED() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x7
}
func (o *I2C_Type) SetSTAT_Status(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xf8)|value<<3)
}
func (o *I2C_Type) GetSTAT_Status() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xf8) >> 3
}
func (o *I2C_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xffffff00) >> 8
}

// I2C.DAT: I2C Data Register. During master or slave transmit mode, data to be transmitted is written to this register. During master or slave receive mode, data that has been received may be read from this register.
func (o *I2C_Type) SetDAT_Data(value uint32) {
	volatile.StoreUint32(&o.DAT.Reg, volatile.LoadUint32(&o.DAT.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDAT_Data() uint32 {
	return volatile.LoadUint32(&o.DAT.Reg) & 0xff
}
func (o *I2C_Type) SetDAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DAT.Reg, volatile.LoadUint32(&o.DAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetDAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DAT.Reg) & 0xffffff00) >> 8
}

// I2C.ADR0: I2C Slave Address Register 0. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C_Type) SetADR0_GC(value uint32) {
	volatile.StoreUint32(&o.ADR0.Reg, volatile.LoadUint32(&o.ADR0.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetADR0_GC() uint32 {
	return volatile.LoadUint32(&o.ADR0.Reg) & 0x1
}
func (o *I2C_Type) SetADR0_Address(value uint32) {
	volatile.StoreUint32(&o.ADR0.Reg, volatile.LoadUint32(&o.ADR0.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetADR0_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR0.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetADR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR0.Reg, volatile.LoadUint32(&o.ADR0.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetADR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR0.Reg) & 0xffffff00) >> 8
}

// I2C.SCLH: SCH Duty Cycle Register High Half Word. Determines the high time of the I2C clock.
func (o *I2C_Type) SetSCLH(value uint32) {
	volatile.StoreUint32(&o.SCLH.Reg, volatile.LoadUint32(&o.SCLH.Reg)&^(0xffff)|value)
}
func (o *I2C_Type) GetSCLH() uint32 {
	return volatile.LoadUint32(&o.SCLH.Reg) & 0xffff
}
func (o *I2C_Type) SetSCLH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCLH.Reg, volatile.LoadUint32(&o.SCLH.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2C_Type) GetSCLH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCLH.Reg) & 0xffff0000) >> 16
}

// I2C.SCLL: SCL Duty Cycle Register Low Half Word. Determines the low time of the I2C clock. SCLL and SCLH together determine the clock frequency generated by an I2C master and certain times used in slave mode.
func (o *I2C_Type) SetSCLL(value uint32) {
	volatile.StoreUint32(&o.SCLL.Reg, volatile.LoadUint32(&o.SCLL.Reg)&^(0xffff)|value)
}
func (o *I2C_Type) GetSCLL() uint32 {
	return volatile.LoadUint32(&o.SCLL.Reg) & 0xffff
}
func (o *I2C_Type) SetSCLL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCLL.Reg, volatile.LoadUint32(&o.SCLL.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2C_Type) GetSCLL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCLL.Reg) & 0xffff0000) >> 16
}

// I2C.CONCLR: I2C Control Clear Register. When a one is written to a bit of this register, the corresponding bit in the I2C control register is cleared. Writing a zero has no effect on the corresponding bit in the I2C control register.
func (o *I2C_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x3)|value)
}
func (o *I2C_Type) GetCONCLR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CONCLR.Reg) & 0x3
}
func (o *I2C_Type) SetCONCLR_AAC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCONCLR_AAC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCONCLR_SIC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCONCLR_SIC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCONCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCONCLR_STAC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCONCLR_STAC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCONCLR_I2ENC(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCONCLR_I2ENC() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCONCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCONCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONCLR.Reg, volatile.LoadUint32(&o.CONCLR.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetCONCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONCLR.Reg) & 0xffffff00) >> 8
}

// I2C.MMCTRL: Monitor mode control register.
func (o *I2C_Type) SetMMCTRL_MM_ENA(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetMMCTRL_MM_ENA() uint32 {
	return volatile.LoadUint32(&o.MMCTRL.Reg) & 0x1
}
func (o *I2C_Type) SetMMCTRL_ENA_SCL(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetMMCTRL_ENA_SCL() uint32 {
	return (volatile.LoadUint32(&o.MMCTRL.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetMMCTRL_MATCH_ALL(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetMMCTRL_MATCH_ALL() uint32 {
	return (volatile.LoadUint32(&o.MMCTRL.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetMMCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MMCTRL.Reg, volatile.LoadUint32(&o.MMCTRL.Reg)&^(0xfffffff8)|value<<3)
}
func (o *I2C_Type) GetMMCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MMCTRL.Reg) & 0xfffffff8) >> 3
}

// I2C.ADR1: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C_Type) SetADR1_GC(value uint32) {
	volatile.StoreUint32(&o.ADR1.Reg, volatile.LoadUint32(&o.ADR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetADR1_GC() uint32 {
	return volatile.LoadUint32(&o.ADR1.Reg) & 0x1
}
func (o *I2C_Type) SetADR1_Address(value uint32) {
	volatile.StoreUint32(&o.ADR1.Reg, volatile.LoadUint32(&o.ADR1.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetADR1_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR1.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetADR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR1.Reg, volatile.LoadUint32(&o.ADR1.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetADR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR1.Reg) & 0xffffff00) >> 8
}

// I2C.ADR2: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C_Type) SetADR2_GC(value uint32) {
	volatile.StoreUint32(&o.ADR2.Reg, volatile.LoadUint32(&o.ADR2.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetADR2_GC() uint32 {
	return volatile.LoadUint32(&o.ADR2.Reg) & 0x1
}
func (o *I2C_Type) SetADR2_Address(value uint32) {
	volatile.StoreUint32(&o.ADR2.Reg, volatile.LoadUint32(&o.ADR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetADR2_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetADR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR2.Reg, volatile.LoadUint32(&o.ADR2.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetADR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR2.Reg) & 0xffffff00) >> 8
}

// I2C.ADR3: I2C Slave Address Register. Contains the 7-bit slave address for operation of the I2C interface in slave mode, and is not used in master mode. The least significant bit determines whether a slave responds to the General Call address.
func (o *I2C_Type) SetADR3_GC(value uint32) {
	volatile.StoreUint32(&o.ADR3.Reg, volatile.LoadUint32(&o.ADR3.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetADR3_GC() uint32 {
	return volatile.LoadUint32(&o.ADR3.Reg) & 0x1
}
func (o *I2C_Type) SetADR3_Address(value uint32) {
	volatile.StoreUint32(&o.ADR3.Reg, volatile.LoadUint32(&o.ADR3.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetADR3_Address() uint32 {
	return (volatile.LoadUint32(&o.ADR3.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetADR3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADR3.Reg, volatile.LoadUint32(&o.ADR3.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetADR3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADR3.Reg) & 0xffffff00) >> 8
}

// I2C.DATA_BUFFER: Data buffer register. The contents of the 8 MSBs of the DAT shift register will be transferred to the DATA_BUFFER automatically after every nine bits (8 bits of data plus ACK or NACK) has been received on the bus.
func (o *I2C_Type) SetDATA_BUFFER_Data(value uint32) {
	volatile.StoreUint32(&o.DATA_BUFFER.Reg, volatile.LoadUint32(&o.DATA_BUFFER.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetDATA_BUFFER_Data() uint32 {
	return volatile.LoadUint32(&o.DATA_BUFFER.Reg) & 0xff
}
func (o *I2C_Type) SetDATA_BUFFER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DATA_BUFFER.Reg, volatile.LoadUint32(&o.DATA_BUFFER.Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetDATA_BUFFER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DATA_BUFFER.Reg) & 0xffffff00) >> 8
}

// I2C.MASK: I2C Slave address mask register
func (o *I2C_Type) SetMASK_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetMASK_RESERVED(idx int) uint32 {
	return volatile.LoadUint32(&o.MASK[idx].Reg) & 0x1
}
func (o *I2C_Type) SetMASK(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetMASK(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetMASK_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, volatile.LoadUint32(&o.MASK[idx].Reg)&^(0xffffff00)|value<<8)
}
func (o *I2C_Type) GetMASK_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.MASK[idx].Reg) & 0xffffff00) >> 8
}

// SPI
type SPI_Type struct {
	CR  volatile.Register32 // 0x0
	SR  volatile.Register32 // 0x4
	DR  volatile.Register32 // 0x8
	CCR volatile.Register32 // 0xC
	_   [12]byte
	INT volatile.Register32 // 0x1C
}

// SPI.CR: SPI Control Register. This register controls the operation of the SPI.
func (o *SPI_Type) SetCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3)|value)
}
func (o *SPI_Type) GetCR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x3
}
func (o *SPI_Type) SetCR_BITENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR_BITENABLE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCR_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCR_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCR_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCR_MSTR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCR_MSTR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCR_LSBF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR_LSBF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR_SPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR_SPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR_BITS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCR_BITS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xfffff000)|value<<12)
}
func (o *SPI_Type) GetCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xfffff000) >> 12
}

// SPI.SR: SPI Status Register. This register shows the status of the SPI.
func (o *SPI_Type) SetSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7)|value)
}
func (o *SPI_Type) GetSR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x7
}
func (o *SPI_Type) SetSR_ABRT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_ABRT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_ROVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_ROVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_WCOL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_WCOL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_SPIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_SPIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SPI_Type) GetSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xffffff00) >> 8
}

// SPI.DR: SPI Data Register. This bi-directional register provides the transmit and receive data for the SPI. Transmit data is provided to the SPI0 by writing to this register. Data received by the SPI0 can be read from this register.
func (o *SPI_Type) SetDR_DATALOW(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetDR_DATALOW() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xff
}
func (o *SPI_Type) SetDR_DATAHIGH(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetDR_DATAHIGH() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xff00) >> 8
}
func (o *SPI_Type) SetDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SPI_Type) GetDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xffff0000) >> 16
}

// SPI.CCR: SPI Clock Counter Register. This register controls the frequency of a master's SCK0.
func (o *SPI_Type) SetCCR_COUNTER(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetCCR_COUNTER() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0xff
}
func (o *SPI_Type) SetCCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SPI_Type) GetCCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xffffff00) >> 8
}

// SPI.INT: SPI Interrupt Flag. This register contains the interrupt flag for the SPI interface.
func (o *SPI_Type) SetINT_SPIF(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetINT_SPIF() uint32 {
	return volatile.LoadUint32(&o.INT.Reg) & 0x1
}
func (o *SPI_Type) SetINT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0xfe)|value<<1)
}
func (o *SPI_Type) GetINT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0xfe) >> 1
}
func (o *SPI_Type) SetINT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INT.Reg, volatile.LoadUint32(&o.INT.Reg)&^(0xffffff00)|value<<8)
}
func (o *SPI_Type) GetINT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INT.Reg) & 0xffffff00) >> 8
}

// Real Time Clock (RTC)
type RTC_Type struct {
	ILR         volatile.Register32 // 0x0
	_           [4]byte
	CCR         volatile.Register32 // 0x8
	CIIR        volatile.Register32 // 0xC
	AMR         volatile.Register32 // 0x10
	CTIME0      volatile.Register32 // 0x14
	CTIME1      volatile.Register32 // 0x18
	CTIME2      volatile.Register32 // 0x1C
	SEC         volatile.Register32 // 0x20
	MIN         volatile.Register32 // 0x24
	HRS         volatile.Register32 // 0x28
	DOM         volatile.Register32 // 0x2C
	DOW         volatile.Register32 // 0x30
	DOY         volatile.Register32 // 0x34
	MONTH       volatile.Register32 // 0x38
	YEAR        volatile.Register32 // 0x3C
	CALIBRATION volatile.Register32 // 0x40
	GPREG0      volatile.Register32 // 0x44
	GPREG1      volatile.Register32 // 0x48
	GPREG2      volatile.Register32 // 0x4C
	GPREG3      volatile.Register32 // 0x50
	GPREG4      volatile.Register32 // 0x54
	RTC_AUXEN   volatile.Register32 // 0x58
	RTC_AUX     volatile.Register32 // 0x5C
	ASEC        volatile.Register32 // 0x60
	AMIN        volatile.Register32 // 0x64
	AHRS        volatile.Register32 // 0x68
	ADOM        volatile.Register32 // 0x6C
	ADOW        volatile.Register32 // 0x70
	ADOY        volatile.Register32 // 0x74
	AMON        volatile.Register32 // 0x78
	AYRS        volatile.Register32 // 0x7C
}

// RTC.ILR: Interrupt Location Register
func (o *RTC_Type) SetILR_RTCCIF(value uint32) {
	volatile.StoreUint32(&o.ILR.Reg, volatile.LoadUint32(&o.ILR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetILR_RTCCIF() uint32 {
	return volatile.LoadUint32(&o.ILR.Reg) & 0x1
}
func (o *RTC_Type) SetILR_RTCALF(value uint32) {
	volatile.StoreUint32(&o.ILR.Reg, volatile.LoadUint32(&o.ILR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetILR_RTCALF() uint32 {
	return (volatile.LoadUint32(&o.ILR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetILR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ILR.Reg, volatile.LoadUint32(&o.ILR.Reg)&^(0xffe00000)|value<<21)
}
func (o *RTC_Type) GetILR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ILR.Reg) & 0xffe00000) >> 21
}

// RTC.CCR: Clock Control Register
func (o *RTC_Type) SetCCR_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetCCR_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *RTC_Type) SetCCR_CTCRST(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetCCR_CTCRST() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetCCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc)|value<<2)
}
func (o *RTC_Type) GetCCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc) >> 2
}
func (o *RTC_Type) SetCCR_CCALEN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCCR_CCALEN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *RTC_Type) GetCCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xffffffe0) >> 5
}

// RTC.CIIR: Counter Increment Interrupt Register
func (o *RTC_Type) SetCIIR_IMSEC(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetCIIR_IMSEC() uint32 {
	return volatile.LoadUint32(&o.CIIR.Reg) & 0x1
}
func (o *RTC_Type) SetCIIR_IMMIN(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetCIIR_IMMIN() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetCIIR_IMHOUR(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetCIIR_IMHOUR() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetCIIR_IMDOM(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCIIR_IMDOM() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCIIR_IMDOW(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCIIR_IMDOW() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCIIR_IMDOY(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCIIR_IMDOY() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCIIR_IMMON(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCIIR_IMMON() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCIIR_IMYEAR(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetCIIR_IMYEAR() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetCIIR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CIIR.Reg, volatile.LoadUint32(&o.CIIR.Reg)&^(0xffffff00)|value<<8)
}
func (o *RTC_Type) GetCIIR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CIIR.Reg) & 0xffffff00) >> 8
}

// RTC.AMR: Alarm Mask Register
func (o *RTC_Type) SetAMR_AMRSEC(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetAMR_AMRSEC() uint32 {
	return volatile.LoadUint32(&o.AMR.Reg) & 0x1
}
func (o *RTC_Type) SetAMR_AMRMIN(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetAMR_AMRMIN() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetAMR_AMRHOUR(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetAMR_AMRHOUR() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetAMR_AMRDOM(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetAMR_AMRDOM() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetAMR_AMRDOW(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetAMR_AMRDOW() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetAMR_AMRDOY(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetAMR_AMRDOY() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetAMR_AMRMON(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetAMR_AMRMON() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetAMR_AMRYEAR(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetAMR_AMRYEAR() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetAMR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.AMR.Reg, volatile.LoadUint32(&o.AMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *RTC_Type) GetAMR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.AMR.Reg) & 0xffffff00) >> 8
}

// RTC.CTIME0: Consolidated Time Register 0
func (o *RTC_Type) SetCTIME0_SECONDS(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetCTIME0_SECONDS() uint32 {
	return volatile.LoadUint32(&o.CTIME0.Reg) & 0x3f
}
func (o *RTC_Type) SetCTIME0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0xc0)|value<<6)
}
func (o *RTC_Type) GetCTIME0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0xc0) >> 6
}
func (o *RTC_Type) SetCTIME0_MINUTES(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0x3f00)|value<<8)
}
func (o *RTC_Type) GetCTIME0_MINUTES() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0x3f00) >> 8
}
func (o *RTC_Type) SetCTIME0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0xc000)|value<<14)
}
func (o *RTC_Type) GetCTIME0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0xc000) >> 14
}
func (o *RTC_Type) SetCTIME0_HOURS(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0x1f0000)|value<<16)
}
func (o *RTC_Type) GetCTIME0_HOURS() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0x1f0000) >> 16
}
func (o *RTC_Type) SetCTIME0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0xe00000)|value<<21)
}
func (o *RTC_Type) GetCTIME0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0xe00000) >> 21
}
func (o *RTC_Type) SetCTIME0_DOW(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0x7000000)|value<<24)
}
func (o *RTC_Type) GetCTIME0_DOW() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0x7000000) >> 24
}
func (o *RTC_Type) SetCTIME0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME0.Reg, volatile.LoadUint32(&o.CTIME0.Reg)&^(0xf8000000)|value<<27)
}
func (o *RTC_Type) GetCTIME0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME0.Reg) & 0xf8000000) >> 27
}

// RTC.CTIME1: Consolidated Time Register 1
func (o *RTC_Type) SetCTIME1_DOM(value uint32) {
	volatile.StoreUint32(&o.CTIME1.Reg, volatile.LoadUint32(&o.CTIME1.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetCTIME1_DOM() uint32 {
	return volatile.LoadUint32(&o.CTIME1.Reg) & 0x1f
}
func (o *RTC_Type) SetCTIME1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME1.Reg, volatile.LoadUint32(&o.CTIME1.Reg)&^(0xe0)|value<<5)
}
func (o *RTC_Type) GetCTIME1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME1.Reg) & 0xe0) >> 5
}
func (o *RTC_Type) SetCTIME1_MONTH(value uint32) {
	volatile.StoreUint32(&o.CTIME1.Reg, volatile.LoadUint32(&o.CTIME1.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetCTIME1_MONTH() uint32 {
	return (volatile.LoadUint32(&o.CTIME1.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetCTIME1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME1.Reg, volatile.LoadUint32(&o.CTIME1.Reg)&^(0xf000)|value<<12)
}
func (o *RTC_Type) GetCTIME1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME1.Reg) & 0xf000) >> 12
}
func (o *RTC_Type) SetCTIME1_YEAR(value uint32) {
	volatile.StoreUint32(&o.CTIME1.Reg, volatile.LoadUint32(&o.CTIME1.Reg)&^(0xfff0000)|value<<16)
}
func (o *RTC_Type) GetCTIME1_YEAR() uint32 {
	return (volatile.LoadUint32(&o.CTIME1.Reg) & 0xfff0000) >> 16
}
func (o *RTC_Type) SetCTIME1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME1.Reg, volatile.LoadUint32(&o.CTIME1.Reg)&^(0xf0000000)|value<<28)
}
func (o *RTC_Type) GetCTIME1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME1.Reg) & 0xf0000000) >> 28
}

// RTC.CTIME2: Consolidated Time Register 2
func (o *RTC_Type) SetCTIME2_DOY(value uint32) {
	volatile.StoreUint32(&o.CTIME2.Reg, volatile.LoadUint32(&o.CTIME2.Reg)&^(0xfff)|value)
}
func (o *RTC_Type) GetCTIME2_DOY() uint32 {
	return volatile.LoadUint32(&o.CTIME2.Reg) & 0xfff
}
func (o *RTC_Type) SetCTIME2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTIME2.Reg, volatile.LoadUint32(&o.CTIME2.Reg)&^(0xfffff000)|value<<12)
}
func (o *RTC_Type) GetCTIME2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTIME2.Reg) & 0xfffff000) >> 12
}

// RTC.SEC: Seconds Counter
func (o *RTC_Type) SetSEC_SECONDS(value uint32) {
	volatile.StoreUint32(&o.SEC.Reg, volatile.LoadUint32(&o.SEC.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetSEC_SECONDS() uint32 {
	return volatile.LoadUint32(&o.SEC.Reg) & 0x3f
}
func (o *RTC_Type) SetSEC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SEC.Reg, volatile.LoadUint32(&o.SEC.Reg)&^(0xffffffc0)|value<<6)
}
func (o *RTC_Type) GetSEC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SEC.Reg) & 0xffffffc0) >> 6
}

// RTC.MIN: Minutes Register
func (o *RTC_Type) SetMIN_MINUTES(value uint32) {
	volatile.StoreUint32(&o.MIN.Reg, volatile.LoadUint32(&o.MIN.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetMIN_MINUTES() uint32 {
	return volatile.LoadUint32(&o.MIN.Reg) & 0x3f
}
func (o *RTC_Type) SetMIN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MIN.Reg, volatile.LoadUint32(&o.MIN.Reg)&^(0xffffffc0)|value<<6)
}
func (o *RTC_Type) GetMIN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MIN.Reg) & 0xffffffc0) >> 6
}

// RTC.HRS: Hours Register
func (o *RTC_Type) SetHRS_HOURS(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetHRS_HOURS() uint32 {
	return volatile.LoadUint32(&o.HRS.Reg) & 0x1f
}
func (o *RTC_Type) SetHRS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.HRS.Reg, volatile.LoadUint32(&o.HRS.Reg)&^(0xffffffe0)|value<<5)
}
func (o *RTC_Type) GetHRS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.HRS.Reg) & 0xffffffe0) >> 5
}

// RTC.DOM: Day of Month Register
func (o *RTC_Type) SetDOM(value uint32) {
	volatile.StoreUint32(&o.DOM.Reg, volatile.LoadUint32(&o.DOM.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetDOM() uint32 {
	return volatile.LoadUint32(&o.DOM.Reg) & 0x1f
}
func (o *RTC_Type) SetDOM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DOM.Reg, volatile.LoadUint32(&o.DOM.Reg)&^(0xffffffe0)|value<<5)
}
func (o *RTC_Type) GetDOM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DOM.Reg) & 0xffffffe0) >> 5
}

// RTC.DOW: Day of Week Register
func (o *RTC_Type) SetDOW(value uint32) {
	volatile.StoreUint32(&o.DOW.Reg, volatile.LoadUint32(&o.DOW.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetDOW() uint32 {
	return volatile.LoadUint32(&o.DOW.Reg) & 0x7
}
func (o *RTC_Type) SetDOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DOW.Reg, volatile.LoadUint32(&o.DOW.Reg)&^(0xfffffff8)|value<<3)
}
func (o *RTC_Type) GetDOW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DOW.Reg) & 0xfffffff8) >> 3
}

// RTC.DOY: Day of Year Register
func (o *RTC_Type) SetDOY(value uint32) {
	volatile.StoreUint32(&o.DOY.Reg, volatile.LoadUint32(&o.DOY.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetDOY() uint32 {
	return volatile.LoadUint32(&o.DOY.Reg) & 0x1ff
}
func (o *RTC_Type) SetDOY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DOY.Reg, volatile.LoadUint32(&o.DOY.Reg)&^(0xfffffe00)|value<<9)
}
func (o *RTC_Type) GetDOY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DOY.Reg) & 0xfffffe00) >> 9
}

// RTC.MONTH: Months Register
func (o *RTC_Type) SetMONTH(value uint32) {
	volatile.StoreUint32(&o.MONTH.Reg, volatile.LoadUint32(&o.MONTH.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetMONTH() uint32 {
	return volatile.LoadUint32(&o.MONTH.Reg) & 0xf
}
func (o *RTC_Type) SetMONTH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MONTH.Reg, volatile.LoadUint32(&o.MONTH.Reg)&^(0xfffffff0)|value<<4)
}
func (o *RTC_Type) GetMONTH_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MONTH.Reg) & 0xfffffff0) >> 4
}

// RTC.YEAR: Years Register
func (o *RTC_Type) SetYEAR(value uint32) {
	volatile.StoreUint32(&o.YEAR.Reg, volatile.LoadUint32(&o.YEAR.Reg)&^(0xfff)|value)
}
func (o *RTC_Type) GetYEAR() uint32 {
	return volatile.LoadUint32(&o.YEAR.Reg) & 0xfff
}
func (o *RTC_Type) SetYEAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.YEAR.Reg, volatile.LoadUint32(&o.YEAR.Reg)&^(0xfffff000)|value<<12)
}
func (o *RTC_Type) GetYEAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.YEAR.Reg) & 0xfffff000) >> 12
}

// RTC.CALIBRATION: Calibration Value Register
func (o *RTC_Type) SetCALIBRATION_CALVAL(value uint32) {
	volatile.StoreUint32(&o.CALIBRATION.Reg, volatile.LoadUint32(&o.CALIBRATION.Reg)&^(0x1ffff)|value)
}
func (o *RTC_Type) GetCALIBRATION_CALVAL() uint32 {
	return volatile.LoadUint32(&o.CALIBRATION.Reg) & 0x1ffff
}
func (o *RTC_Type) SetCALIBRATION_CALDIR(value uint32) {
	volatile.StoreUint32(&o.CALIBRATION.Reg, volatile.LoadUint32(&o.CALIBRATION.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCALIBRATION_CALDIR() uint32 {
	return (volatile.LoadUint32(&o.CALIBRATION.Reg) & 0x20000) >> 17
}

// RTC.GPREG0: General Purpose Register 0
func (o *RTC_Type) SetGPREG0(value uint32) {
	volatile.StoreUint32(&o.GPREG0.Reg, value)
}
func (o *RTC_Type) GetGPREG0() uint32 {
	return volatile.LoadUint32(&o.GPREG0.Reg)
}

// RTC.GPREG1: General Purpose Register 0
func (o *RTC_Type) SetGPREG1(value uint32) {
	volatile.StoreUint32(&o.GPREG1.Reg, value)
}
func (o *RTC_Type) GetGPREG1() uint32 {
	return volatile.LoadUint32(&o.GPREG1.Reg)
}

// RTC.GPREG2: General Purpose Register 0
func (o *RTC_Type) SetGPREG2(value uint32) {
	volatile.StoreUint32(&o.GPREG2.Reg, value)
}
func (o *RTC_Type) GetGPREG2() uint32 {
	return volatile.LoadUint32(&o.GPREG2.Reg)
}

// RTC.GPREG3: General Purpose Register 0
func (o *RTC_Type) SetGPREG3(value uint32) {
	volatile.StoreUint32(&o.GPREG3.Reg, value)
}
func (o *RTC_Type) GetGPREG3() uint32 {
	return volatile.LoadUint32(&o.GPREG3.Reg)
}

// RTC.GPREG4: General Purpose Register 0
func (o *RTC_Type) SetGPREG4(value uint32) {
	volatile.StoreUint32(&o.GPREG4.Reg, value)
}
func (o *RTC_Type) GetGPREG4() uint32 {
	return volatile.LoadUint32(&o.GPREG4.Reg)
}

// RTC.RTC_AUXEN: RTC Auxiliary Enable register
func (o *RTC_Type) SetRTC_AUXEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RTC_AUXEN.Reg, volatile.LoadUint32(&o.RTC_AUXEN.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetRTC_AUXEN_RESERVED() uint32 {
	return volatile.LoadUint32(&o.RTC_AUXEN.Reg) & 0xf
}
func (o *RTC_Type) SetRTC_AUXEN_RTC_OSCFEN(value uint32) {
	volatile.StoreUint32(&o.RTC_AUXEN.Reg, volatile.LoadUint32(&o.RTC_AUXEN.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetRTC_AUXEN_RTC_OSCFEN() uint32 {
	return (volatile.LoadUint32(&o.RTC_AUXEN.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetRTC_AUXEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RTC_AUXEN.Reg, volatile.LoadUint32(&o.RTC_AUXEN.Reg)&^(0xffffffe0)|value<<5)
}
func (o *RTC_Type) GetRTC_AUXEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RTC_AUXEN.Reg) & 0xffffffe0) >> 5
}

// RTC.RTC_AUX: RTC Auxiliary control register
func (o *RTC_Type) SetRTC_AUX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RTC_AUX.Reg, volatile.LoadUint32(&o.RTC_AUX.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetRTC_AUX_RESERVED() uint32 {
	return volatile.LoadUint32(&o.RTC_AUX.Reg) & 0xf
}
func (o *RTC_Type) SetRTC_AUX_RTC_OSCF(value uint32) {
	volatile.StoreUint32(&o.RTC_AUX.Reg, volatile.LoadUint32(&o.RTC_AUX.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetRTC_AUX_RTC_OSCF() uint32 {
	return (volatile.LoadUint32(&o.RTC_AUX.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetRTC_AUX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RTC_AUX.Reg, volatile.LoadUint32(&o.RTC_AUX.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetRTC_AUX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RTC_AUX.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetRTC_AUX_RTC_PDOUT(value uint32) {
	volatile.StoreUint32(&o.RTC_AUX.Reg, volatile.LoadUint32(&o.RTC_AUX.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetRTC_AUX_RTC_PDOUT() uint32 {
	return (volatile.LoadUint32(&o.RTC_AUX.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetRTC_AUX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RTC_AUX.Reg, volatile.LoadUint32(&o.RTC_AUX.Reg)&^(0xffffff80)|value<<7)
}
func (o *RTC_Type) GetRTC_AUX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RTC_AUX.Reg) & 0xffffff80) >> 7
}

// RTC.ASEC: Alarm value for Seconds
func (o *RTC_Type) SetASEC_SECONDS(value uint32) {
	volatile.StoreUint32(&o.ASEC.Reg, volatile.LoadUint32(&o.ASEC.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetASEC_SECONDS() uint32 {
	return volatile.LoadUint32(&o.ASEC.Reg) & 0x3f
}
func (o *RTC_Type) SetASEC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ASEC.Reg, volatile.LoadUint32(&o.ASEC.Reg)&^(0xffffffc0)|value<<6)
}
func (o *RTC_Type) GetASEC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ASEC.Reg) & 0xffffffc0) >> 6
}

// RTC.AMIN: Alarm value for Minutes
func (o *RTC_Type) SetAMIN_MINUTES(value uint32) {
	volatile.StoreUint32(&o.AMIN.Reg, volatile.LoadUint32(&o.AMIN.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetAMIN_MINUTES() uint32 {
	return volatile.LoadUint32(&o.AMIN.Reg) & 0x3f
}
func (o *RTC_Type) SetAMIN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.AMIN.Reg, volatile.LoadUint32(&o.AMIN.Reg)&^(0xffffffc0)|value<<6)
}
func (o *RTC_Type) GetAMIN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.AMIN.Reg) & 0xffffffc0) >> 6
}

// RTC.AHRS: Alarm value for Hours
func (o *RTC_Type) SetAHRS_HOURS(value uint32) {
	volatile.StoreUint32(&o.AHRS.Reg, volatile.LoadUint32(&o.AHRS.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetAHRS_HOURS() uint32 {
	return volatile.LoadUint32(&o.AHRS.Reg) & 0x1f
}
func (o *RTC_Type) SetAHRS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.AHRS.Reg, volatile.LoadUint32(&o.AHRS.Reg)&^(0xffffffe0)|value<<5)
}
func (o *RTC_Type) GetAHRS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.AHRS.Reg) & 0xffffffe0) >> 5
}

// RTC.ADOM: Alarm value for Day of Month
func (o *RTC_Type) SetADOM_DOM(value uint32) {
	volatile.StoreUint32(&o.ADOM.Reg, volatile.LoadUint32(&o.ADOM.Reg)&^(0x1f)|value)
}
func (o *RTC_Type) GetADOM_DOM() uint32 {
	return volatile.LoadUint32(&o.ADOM.Reg) & 0x1f
}
func (o *RTC_Type) SetADOM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADOM.Reg, volatile.LoadUint32(&o.ADOM.Reg)&^(0xffffffe0)|value<<5)
}
func (o *RTC_Type) GetADOM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADOM.Reg) & 0xffffffe0) >> 5
}

// RTC.ADOW: Alarm value for Day of Week
func (o *RTC_Type) SetADOW_DOW(value uint32) {
	volatile.StoreUint32(&o.ADOW.Reg, volatile.LoadUint32(&o.ADOW.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetADOW_DOW() uint32 {
	return volatile.LoadUint32(&o.ADOW.Reg) & 0x7
}
func (o *RTC_Type) SetADOW_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADOW.Reg, volatile.LoadUint32(&o.ADOW.Reg)&^(0xfffffff8)|value<<3)
}
func (o *RTC_Type) GetADOW_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADOW.Reg) & 0xfffffff8) >> 3
}

// RTC.ADOY: Alarm value for Day of Year
func (o *RTC_Type) SetADOY_DOY(value uint32) {
	volatile.StoreUint32(&o.ADOY.Reg, volatile.LoadUint32(&o.ADOY.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetADOY_DOY() uint32 {
	return volatile.LoadUint32(&o.ADOY.Reg) & 0x1ff
}
func (o *RTC_Type) SetADOY_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ADOY.Reg, volatile.LoadUint32(&o.ADOY.Reg)&^(0xfffffe00)|value<<9)
}
func (o *RTC_Type) GetADOY_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ADOY.Reg) & 0xfffffe00) >> 9
}

// RTC.AMON: Alarm value for Months
func (o *RTC_Type) SetAMON_MONTH(value uint32) {
	volatile.StoreUint32(&o.AMON.Reg, volatile.LoadUint32(&o.AMON.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetAMON_MONTH() uint32 {
	return volatile.LoadUint32(&o.AMON.Reg) & 0xf
}
func (o *RTC_Type) SetAMON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.AMON.Reg, volatile.LoadUint32(&o.AMON.Reg)&^(0xfffffff0)|value<<4)
}
func (o *RTC_Type) GetAMON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.AMON.Reg) & 0xfffffff0) >> 4
}

// RTC.AYRS: Alarm value for Year
func (o *RTC_Type) SetAYRS_YEAR(value uint32) {
	volatile.StoreUint32(&o.AYRS.Reg, volatile.LoadUint32(&o.AYRS.Reg)&^(0xfff)|value)
}
func (o *RTC_Type) GetAYRS_YEAR() uint32 {
	return volatile.LoadUint32(&o.AYRS.Reg) & 0xfff
}
func (o *RTC_Type) SetAYRS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.AYRS.Reg, volatile.LoadUint32(&o.AYRS.Reg)&^(0xfffff000)|value<<12)
}
func (o *RTC_Type) GetAYRS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.AYRS.Reg) & 0xfffff000) >> 12
}

// GPIO
type GPIOINT_Type struct {
	STATUS volatile.Register32 // 0x0
	STATR0 volatile.Register32 // 0x4
	STATF0 volatile.Register32 // 0x8
	CLR0   volatile.Register32 // 0xC
	ENR0   volatile.Register32 // 0x10
	ENF0   volatile.Register32 // 0x14
	_      [12]byte
	STATR2 volatile.Register32 // 0x24
	STATF2 volatile.Register32 // 0x28
	CLR2   volatile.Register32 // 0x2C
	ENR2   volatile.Register32 // 0x30
	ENF2   volatile.Register32 // 0x34
}

// GPIOINT.STATUS: GPIO overall Interrupt Status.
func (o *GPIOINT_Type) SetSTATUS_P0INT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetSTATUS_P0INT() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *GPIOINT_Type) SetSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetSTATUS_P2INT(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetSTATUS_P2INT() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPIOINT_Type) GetSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xfffffffc) >> 2
}

// GPIOINT.STATR0: GPIO Interrupt Status for Rising edge for Port 0.
func (o *GPIOINT_Type) SetSTATR0_P0_0REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetSTATR0_P0_0REI() uint32 {
	return volatile.LoadUint32(&o.STATR0.Reg) & 0x1
}
func (o *GPIOINT_Type) SetSTATR0_P0_1REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetSTATR0_P0_1REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetSTATR0_P0_2REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetSTATR0_P0_2REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetSTATR0_P0_3REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetSTATR0_P0_3REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetSTATR0_P0_4REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetSTATR0_P0_4REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetSTATR0_P0_5REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetSTATR0_P0_5REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetSTATR0_P0_6REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetSTATR0_P0_6REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetSTATR0_P0_7REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetSTATR0_P0_7REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetSTATR0_P0_8REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetSTATR0_P0_8REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetSTATR0_P0_9REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetSTATR0_P0_9REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetSTATR0_P0_10REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetSTATR0_P0_10REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetSTATR0_P0_11REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetSTATR0_P0_11REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetSTATR0_P0_12REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetSTATR0_P0_12REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetSTATR0_P0_13REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetSTATR0_P0_13REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetSTATR0_P0_14REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetSTATR0_P0_14REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetSTATR0_P0_15REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetSTATR0_P0_15REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetSTATR0_P0_16REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetSTATR0_P0_16REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetSTATR0_P0_17REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetSTATR0_P0_17REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetSTATR0_P0_18REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetSTATR0_P0_18REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetSTATR0_P0_19REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetSTATR0_P0_19REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetSTATR0_P0_20REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetSTATR0_P0_20REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetSTATR0_P0_21REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetSTATR0_P0_21REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetSTATR0_P0_22REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetSTATR0_P0_22REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetSTATR0_P0_23REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetSTATR0_P0_23REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetSTATR0_P0_24REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetSTATR0_P0_24REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetSTATR0_P0_25REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetSTATR0_P0_25REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetSTATR0_P0_26REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetSTATR0_P0_26REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetSTATR0_P0_27REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetSTATR0_P0_27REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetSTATR0_P0_28REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetSTATR0_P0_28REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetSTATR0_P0_29REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetSTATR0_P0_29REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetSTATR0_P0_30REI(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetSTATR0_P0_30REI() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetSTATR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATR0.Reg, volatile.LoadUint32(&o.STATR0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetSTATR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATR0.Reg) & 0x80000000) >> 31
}

// GPIOINT.STATF0: GPIO Interrupt Status for Falling edge for Port 0.
func (o *GPIOINT_Type) SetSTATF0_P0_0FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetSTATF0_P0_0FEI() uint32 {
	return volatile.LoadUint32(&o.STATF0.Reg) & 0x1
}
func (o *GPIOINT_Type) SetSTATF0_P0_1FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetSTATF0_P0_1FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetSTATF0_P0_2FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetSTATF0_P0_2FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetSTATF0_P0_3FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetSTATF0_P0_3FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetSTATF0_P0_4FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetSTATF0_P0_4FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetSTATF0_P0_5FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetSTATF0_P0_5FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetSTATF0_P0_6FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetSTATF0_P0_6FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetSTATF0_P0_7FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetSTATF0_P0_7FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetSTATF0_P0_8FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetSTATF0_P0_8FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetSTATF0_P0_9FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetSTATF0_P0_9FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetSTATF0_P0_10FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetSTATF0_P0_10FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetSTATF0_P0_11FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetSTATF0_P0_11FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetSTATF0_P0_12FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetSTATF0_P0_12FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetSTATF0_P0_13FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetSTATF0_P0_13FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetSTATF0_P0_14FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetSTATF0_P0_14FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetSTATF0_P0_15FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetSTATF0_P0_15FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetSTATF0_P0_16FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetSTATF0_P0_16FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetSTATF0_P0_17FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetSTATF0_P0_17FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetSTATF0_P0_18FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetSTATF0_P0_18FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetSTATF0_P0_19FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetSTATF0_P0_19FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetSTATF0_P0_20FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetSTATF0_P0_20FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetSTATF0_P0_21FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetSTATF0_P0_21FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetSTATF0_P0_22FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetSTATF0_P0_22FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetSTATF0_P0_23FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetSTATF0_P0_23FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetSTATF0_P0_24FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetSTATF0_P0_24FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetSTATF0_P0_25FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetSTATF0_P0_25FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetSTATF0_P0_26FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetSTATF0_P0_26FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetSTATF0_P0_27FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetSTATF0_P0_27FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetSTATF0_P0_28FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetSTATF0_P0_28FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetSTATF0_P0_29FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetSTATF0_P0_29FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetSTATF0_P0_30FEI(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetSTATF0_P0_30FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetSTATF0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATF0.Reg, volatile.LoadUint32(&o.STATF0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetSTATF0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATF0.Reg) & 0x80000000) >> 31
}

// GPIOINT.CLR0: GPIO Interrupt Clear.
func (o *GPIOINT_Type) SetCLR0_P0_0CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetCLR0_P0_0CI() uint32 {
	return volatile.LoadUint32(&o.CLR0.Reg) & 0x1
}
func (o *GPIOINT_Type) SetCLR0_P0_1CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetCLR0_P0_1CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetCLR0_P0_2CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetCLR0_P0_2CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetCLR0_P0_3CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetCLR0_P0_3CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetCLR0_P0_4CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetCLR0_P0_4CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetCLR0_P0_5CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetCLR0_P0_5CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetCLR0_P0_6CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetCLR0_P0_6CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetCLR0_P0_7CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetCLR0_P0_7CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetCLR0_P0_8CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetCLR0_P0_8CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetCLR0_P0_9CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetCLR0_P0_9CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetCLR0_P0_10CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetCLR0_P0_10CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetCLR0_P0_11CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetCLR0_P0_11CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetCLR0_P0_12CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetCLR0_P0_12CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetCLR0_P0_13CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetCLR0_P0_13CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetCLR0_P0_14CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetCLR0_P0_14CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetCLR0_P0_15CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetCLR0_P0_15CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetCLR0_P0_16CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetCLR0_P0_16CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetCLR0_P0_17CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetCLR0_P0_17CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetCLR0_P0_18CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetCLR0_P0_18CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetCLR0_P0_19CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetCLR0_P0_19CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetCLR0_P0_20CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetCLR0_P0_20CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetCLR0_P0_21CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetCLR0_P0_21CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetCLR0_P0_22CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetCLR0_P0_22CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetCLR0_P0_23CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetCLR0_P0_23CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetCLR0_P0_24CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetCLR0_P0_24CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetCLR0_P0_25CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetCLR0_P0_25CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetCLR0_P0_26CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetCLR0_P0_26CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetCLR0_P0_27CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetCLR0_P0_27CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetCLR0_P0_28CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetCLR0_P0_28CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetCLR0_P0_29CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetCLR0_P0_29CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetCLR0_P0_30CI(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetCLR0_P0_30CI() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetCLR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetCLR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80000000) >> 31
}

// GPIOINT.ENR0: GPIO Interrupt Enable for Rising edge for Port 0.
func (o *GPIOINT_Type) SetENR0_P0_0ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetENR0_P0_0ER() uint32 {
	return volatile.LoadUint32(&o.ENR0.Reg) & 0x1
}
func (o *GPIOINT_Type) SetENR0_P0_1ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetENR0_P0_1ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetENR0_P0_2ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetENR0_P0_2ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetENR0_P0_3ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetENR0_P0_3ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetENR0_P0_4ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetENR0_P0_4ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetENR0_P0_5ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetENR0_P0_5ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetENR0_P0_6ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetENR0_P0_6ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetENR0_P0_7ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetENR0_P0_7ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetENR0_P0_8ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetENR0_P0_8ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetENR0_P0_9ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetENR0_P0_9ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetENR0_P0_10ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetENR0_P0_10ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetENR0_P0_11ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetENR0_P0_11ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetENR0_P0_12ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetENR0_P0_12ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetENR0_P0_13ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetENR0_P0_13ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetENR0_P0_14ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetENR0_P0_14ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetENR0_P0_15ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetENR0_P0_15ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetENR0_P0_16ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetENR0_P0_16ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetENR0_P0_17ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetENR0_P0_17ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetENR0_P0_18ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetENR0_P0_18ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetENR0_P0_19ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetENR0_P0_19ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetENR0_P0_20ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetENR0_P0_20ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetENR0_P0_21ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetENR0_P0_21ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetENR0_P0_22ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetENR0_P0_22ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetENR0_P0_23ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetENR0_P0_23ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetENR0_P0_24ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetENR0_P0_24ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetENR0_P0_25ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetENR0_P0_25ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetENR0_P0_26ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetENR0_P0_26ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetENR0_P0_27ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetENR0_P0_27ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetENR0_P0_28ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetENR0_P0_28ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetENR0_P0_29ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetENR0_P0_29ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetENR0_P0_30ER(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetENR0_P0_30ER() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetENR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENR0.Reg, volatile.LoadUint32(&o.ENR0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetENR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENR0.Reg) & 0x80000000) >> 31
}

// GPIOINT.ENF0: GPIO Interrupt Enable for Falling edge for Port 0.
func (o *GPIOINT_Type) SetENF0_P0_0EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetENF0_P0_0EF() uint32 {
	return volatile.LoadUint32(&o.ENF0.Reg) & 0x1
}
func (o *GPIOINT_Type) SetENF0_P0_1EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetENF0_P0_1EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetENF0_P0_2EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetENF0_P0_2EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetENF0_P0_3EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetENF0_P0_3EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetENF0_P0_4EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetENF0_P0_4EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetENF0_P0_5EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetENF0_P0_5EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetENF0_P0_6EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetENF0_P0_6EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetENF0_P0_7EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetENF0_P0_7EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetENF0_P0_8EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetENF0_P0_8EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetENF0_P0_9EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetENF0_P0_9EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetENF0_P0_10EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetENF0_P0_10EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetENF0_P0_11EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetENF0_P0_11EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetENF0_P0_12EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetENF0_P0_12EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetENF0_P0_13EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetENF0_P0_13EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetENF0_P0_14EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIOINT_Type) GetENF0_P0_14EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x4000) >> 14
}
func (o *GPIOINT_Type) SetENF0_P0_15EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIOINT_Type) GetENF0_P0_15EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x8000) >> 15
}
func (o *GPIOINT_Type) SetENF0_P0_16EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIOINT_Type) GetENF0_P0_16EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x10000) >> 16
}
func (o *GPIOINT_Type) SetENF0_P0_17EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIOINT_Type) GetENF0_P0_17EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x20000) >> 17
}
func (o *GPIOINT_Type) SetENF0_P0_18EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIOINT_Type) GetENF0_P0_18EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x40000) >> 18
}
func (o *GPIOINT_Type) SetENF0_P0_19EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIOINT_Type) GetENF0_P0_19EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x80000) >> 19
}
func (o *GPIOINT_Type) SetENF0_P0_20EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIOINT_Type) GetENF0_P0_20EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x100000) >> 20
}
func (o *GPIOINT_Type) SetENF0_P0_21EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIOINT_Type) GetENF0_P0_21EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x200000) >> 21
}
func (o *GPIOINT_Type) SetENF0_P0_22EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIOINT_Type) GetENF0_P0_22EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x400000) >> 22
}
func (o *GPIOINT_Type) SetENF0_P0_23EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIOINT_Type) GetENF0_P0_23EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x800000) >> 23
}
func (o *GPIOINT_Type) SetENF0_P0_24EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIOINT_Type) GetENF0_P0_24EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x1000000) >> 24
}
func (o *GPIOINT_Type) SetENF0_P0_25EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIOINT_Type) GetENF0_P0_25EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x2000000) >> 25
}
func (o *GPIOINT_Type) SetENF0_P0_26EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIOINT_Type) GetENF0_P0_26EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x4000000) >> 26
}
func (o *GPIOINT_Type) SetENF0_P0_27EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIOINT_Type) GetENF0_P0_27EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x8000000) >> 27
}
func (o *GPIOINT_Type) SetENF0_P0_28EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIOINT_Type) GetENF0_P0_28EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x10000000) >> 28
}
func (o *GPIOINT_Type) SetENF0_P0_29EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIOINT_Type) GetENF0_P0_29EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x20000000) >> 29
}
func (o *GPIOINT_Type) SetENF0_P0_30EF(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIOINT_Type) GetENF0_P0_30EF() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x40000000) >> 30
}
func (o *GPIOINT_Type) SetENF0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENF0.Reg, volatile.LoadUint32(&o.ENF0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOINT_Type) GetENF0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENF0.Reg) & 0x80000000) >> 31
}

// GPIOINT.STATR2: GPIO Interrupt Status for Rising edge for Port 0.
func (o *GPIOINT_Type) SetSTATR2_P2_0REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetSTATR2_P2_0REI() uint32 {
	return volatile.LoadUint32(&o.STATR2.Reg) & 0x1
}
func (o *GPIOINT_Type) SetSTATR2_P2_1REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetSTATR2_P2_1REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetSTATR2_P2_2REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetSTATR2_P2_2REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetSTATR2_P2_3REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetSTATR2_P2_3REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetSTATR2_P2_4REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetSTATR2_P2_4REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetSTATR2_P2_5REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetSTATR2_P2_5REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetSTATR2_P2_6REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetSTATR2_P2_6REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetSTATR2_P2_7REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetSTATR2_P2_7REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetSTATR2_P2_8REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetSTATR2_P2_8REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetSTATR2_P2_9REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetSTATR2_P2_9REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetSTATR2_P2_10REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetSTATR2_P2_10REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetSTATR2_P2_11REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetSTATR2_P2_11REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetSTATR2_P2_12REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetSTATR2_P2_12REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetSTATR2_P2_13REI(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetSTATR2_P2_13REI() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetSTATR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATR2.Reg, volatile.LoadUint32(&o.STATR2.Reg)&^(0xffffc000)|value<<14)
}
func (o *GPIOINT_Type) GetSTATR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATR2.Reg) & 0xffffc000) >> 14
}

// GPIOINT.STATF2: GPIO Interrupt Status for Falling edge for Port 0.
func (o *GPIOINT_Type) SetSTATF2_P2_0FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetSTATF2_P2_0FEI() uint32 {
	return volatile.LoadUint32(&o.STATF2.Reg) & 0x1
}
func (o *GPIOINT_Type) SetSTATF2_P2_1FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetSTATF2_P2_1FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetSTATF2_P2_2FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetSTATF2_P2_2FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetSTATF2_P2_3FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetSTATF2_P2_3FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetSTATF2_P2_4FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetSTATF2_P2_4FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetSTATF2_P2_5FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetSTATF2_P2_5FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetSTATF2_P2_6FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetSTATF2_P2_6FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetSTATF2_P2_7FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetSTATF2_P2_7FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetSTATF2_P2_8FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetSTATF2_P2_8FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetSTATF2_P2_9FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetSTATF2_P2_9FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetSTATF2_P2_10FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetSTATF2_P2_10FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetSTATF2_P2_11FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetSTATF2_P2_11FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetSTATF2_P2_12FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetSTATF2_P2_12FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetSTATF2_P2_13FEI(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetSTATF2_P2_13FEI() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetSTATF2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATF2.Reg, volatile.LoadUint32(&o.STATF2.Reg)&^(0xffffc000)|value<<14)
}
func (o *GPIOINT_Type) GetSTATF2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATF2.Reg) & 0xffffc000) >> 14
}

// GPIOINT.CLR2: GPIO Interrupt Clear.
func (o *GPIOINT_Type) SetCLR2_P2_0CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetCLR2_P2_0CI() uint32 {
	return volatile.LoadUint32(&o.CLR2.Reg) & 0x1
}
func (o *GPIOINT_Type) SetCLR2_P2_1CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetCLR2_P2_1CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetCLR2_P2_2CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetCLR2_P2_2CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetCLR2_P2_3CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetCLR2_P2_3CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetCLR2_P2_4CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetCLR2_P2_4CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetCLR2_P2_5CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetCLR2_P2_5CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetCLR2_P2_6CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetCLR2_P2_6CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetCLR2_P2_7CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetCLR2_P2_7CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetCLR2_P2_8CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetCLR2_P2_8CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetCLR2_P2_9CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetCLR2_P2_9CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetCLR2_P2_10CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetCLR2_P2_10CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetCLR2_P2_11CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetCLR2_P2_11CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetCLR2_P2_12CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetCLR2_P2_12CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetCLR2_P2_13CI(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetCLR2_P2_13CI() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetCLR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLR2.Reg, volatile.LoadUint32(&o.CLR2.Reg)&^(0xffffc000)|value<<14)
}
func (o *GPIOINT_Type) GetCLR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLR2.Reg) & 0xffffc000) >> 14
}

// GPIOINT.ENR2: GPIO Interrupt Enable for Rising edge for Port 0.
func (o *GPIOINT_Type) SetENR2_P2_0ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetENR2_P2_0ER() uint32 {
	return volatile.LoadUint32(&o.ENR2.Reg) & 0x1
}
func (o *GPIOINT_Type) SetENR2_P2_1ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetENR2_P2_1ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetENR2_P2_2ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetENR2_P2_2ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetENR2_P2_3ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetENR2_P2_3ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetENR2_P2_4ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetENR2_P2_4ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetENR2_P2_5ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetENR2_P2_5ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetENR2_P2_6ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetENR2_P2_6ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetENR2_P2_7ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetENR2_P2_7ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetENR2_P2_8ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetENR2_P2_8ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetENR2_P2_9ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetENR2_P2_9ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetENR2_P2_10ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetENR2_P2_10ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetENR2_P2_11ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetENR2_P2_11ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetENR2_P2_12ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetENR2_P2_12ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetENR2_P2_13ER(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetENR2_P2_13ER() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetENR2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENR2.Reg, volatile.LoadUint32(&o.ENR2.Reg)&^(0xffffc000)|value<<14)
}
func (o *GPIOINT_Type) GetENR2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENR2.Reg) & 0xffffc000) >> 14
}

// GPIOINT.ENF2: GPIO Interrupt Enable for Falling edge for Port 0.
func (o *GPIOINT_Type) SetENF2_P2_0EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x1)|value)
}
func (o *GPIOINT_Type) GetENF2_P2_0EF() uint32 {
	return volatile.LoadUint32(&o.ENF2.Reg) & 0x1
}
func (o *GPIOINT_Type) SetENF2_P2_1EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x2)|value<<1)
}
func (o *GPIOINT_Type) GetENF2_P2_1EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x2) >> 1
}
func (o *GPIOINT_Type) SetENF2_P2_2EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x4)|value<<2)
}
func (o *GPIOINT_Type) GetENF2_P2_2EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x4) >> 2
}
func (o *GPIOINT_Type) SetENF2_P2_3EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x8)|value<<3)
}
func (o *GPIOINT_Type) GetENF2_P2_3EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x8) >> 3
}
func (o *GPIOINT_Type) SetENF2_P2_4EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x10)|value<<4)
}
func (o *GPIOINT_Type) GetENF2_P2_4EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x10) >> 4
}
func (o *GPIOINT_Type) SetENF2_P2_5EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x20)|value<<5)
}
func (o *GPIOINT_Type) GetENF2_P2_5EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x20) >> 5
}
func (o *GPIOINT_Type) SetENF2_P2_6EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x40)|value<<6)
}
func (o *GPIOINT_Type) GetENF2_P2_6EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x40) >> 6
}
func (o *GPIOINT_Type) SetENF2_P2_7EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x80)|value<<7)
}
func (o *GPIOINT_Type) GetENF2_P2_7EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x80) >> 7
}
func (o *GPIOINT_Type) SetENF2_P2_8EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x100)|value<<8)
}
func (o *GPIOINT_Type) GetENF2_P2_8EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x100) >> 8
}
func (o *GPIOINT_Type) SetENF2_P2_9EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x200)|value<<9)
}
func (o *GPIOINT_Type) GetENF2_P2_9EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x200) >> 9
}
func (o *GPIOINT_Type) SetENF2_P2_10EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x400)|value<<10)
}
func (o *GPIOINT_Type) GetENF2_P2_10EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x400) >> 10
}
func (o *GPIOINT_Type) SetENF2_P2_11EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x800)|value<<11)
}
func (o *GPIOINT_Type) GetENF2_P2_11EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x800) >> 11
}
func (o *GPIOINT_Type) SetENF2_P2_12EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x1000)|value<<12)
}
func (o *GPIOINT_Type) GetENF2_P2_12EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x1000) >> 12
}
func (o *GPIOINT_Type) SetENF2_P2_13EF(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0x2000)|value<<13)
}
func (o *GPIOINT_Type) GetENF2_P2_13EF() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0x2000) >> 13
}
func (o *GPIOINT_Type) SetENF2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENF2.Reg, volatile.LoadUint32(&o.ENF2.Reg)&^(0xffffc000)|value<<14)
}
func (o *GPIOINT_Type) GetENF2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENF2.Reg) & 0xffffc000) >> 14
}

// Pin connect block
type PINCONNECT_Type struct {
	PINSEL0     volatile.Register32 // 0x0
	PINSEL1     volatile.Register32 // 0x4
	PINSEL2     volatile.Register32 // 0x8
	PINSEL3     volatile.Register32 // 0xC
	PINSEL4     volatile.Register32 // 0x10
	_           [8]byte
	PINSEL7     volatile.Register32 // 0x1C
	_           [4]byte
	PINSEL9     volatile.Register32 // 0x24
	PINSEL10    volatile.Register32 // 0x28
	_           [20]byte
	PINMODE0    volatile.Register32 // 0x40
	PINMODE1    volatile.Register32 // 0x44
	PINMODE2    volatile.Register32 // 0x48
	PINMODE3    volatile.Register32 // 0x4C
	PINMODE4    volatile.Register32 // 0x50
	_           [8]byte
	PINMODE7    volatile.Register32 // 0x5C
	_           [4]byte
	PINMODE9    volatile.Register32 // 0x64
	PINMODE_OD0 volatile.Register32 // 0x68
	PINMODE_OD1 volatile.Register32 // 0x6C
	PINMODE_OD2 volatile.Register32 // 0x70
	PINMODE_OD3 volatile.Register32 // 0x74
	PINMODE_OD4 volatile.Register32 // 0x78
	I2CPADCFG   volatile.Register32 // 0x7C
}

// PINCONNECT.PINSEL0: Pin function select register 0.
func (o *PINCONNECT_Type) SetPINSEL0_P0_0(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0x3)|value)
}
func (o *PINCONNECT_Type) GetPINSEL0_P0_0() uint32 {
	return volatile.LoadUint32(&o.PINSEL0.Reg) & 0x3
}
func (o *PINCONNECT_Type) SetPINSEL0_P0_1(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0xc)|value<<2)
}
func (o *PINCONNECT_Type) GetPINSEL0_P0_1() uint32 {
	return (volatile.LoadUint32(&o.PINSEL0.Reg) & 0xc) >> 2
}
func (o *PINCONNECT_Type) SetPINSEL0_P0_2(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0x30)|value<<4)
}
func (o *PINCONNECT_Type) GetPINSEL0_P0_2() uint32 {
	return (volatile.LoadUint32(&o.PINSEL0.Reg) & 0x30) >> 4
}
func (o *PINCONNECT_Type) SetPINSEL0_P0_3(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0xc0)|value<<6)
}
func (o *PINCONNECT_Type) GetPINSEL0_P0_3() uint32 {
	return (volatile.LoadUint32(&o.PINSEL0.Reg) & 0xc0) >> 6
}
func (o *PINCONNECT_Type) SetPINSEL0_P0_4(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0x300)|value<<8)
}
func (o *PINCONNECT_Type) GetPINSEL0_P0_4() uint32 {
	return (volatile.LoadUint32(&o.PINSEL0.Reg) & 0x300) >> 8
}
func (o *PINCONNECT_Type) SetPINSEL0_P0_5(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0xc00)|value<<10)
}
func (o *PINCONNECT_Type) GetPINSEL0_P0_5() uint32 {
	return (volatile.LoadUint32(&o.PINSEL0.Reg) & 0xc00) >> 10
}
func (o *PINCONNECT_Type) SetPINSEL0_P0_6(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0x3000)|value<<12)
}
func (o *PINCONNECT_Type) GetPINSEL0_P0_6() uint32 {
	return (volatile.LoadUint32(&o.PINSEL0.Reg) & 0x3000) >> 12
}
func (o *PINCONNECT_Type) SetPINSEL0_P0_7(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0xc000)|value<<14)
}
func (o *PINCONNECT_Type) GetPINSEL0_P0_7() uint32 {
	return (volatile.LoadUint32(&o.PINSEL0.Reg) & 0xc000) >> 14
}
func (o *PINCONNECT_Type) SetPINSEL0_P0_8(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0x30000)|value<<16)
}
func (o *PINCONNECT_Type) GetPINSEL0_P0_8() uint32 {
	return (volatile.LoadUint32(&o.PINSEL0.Reg) & 0x30000) >> 16
}
func (o *PINCONNECT_Type) SetPINSEL0_P0_9(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0xc0000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINSEL0_P0_9() uint32 {
	return (volatile.LoadUint32(&o.PINSEL0.Reg) & 0xc0000) >> 18
}
func (o *PINCONNECT_Type) SetPINSEL0_P0_10(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0x300000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINSEL0_P0_10() uint32 {
	return (volatile.LoadUint32(&o.PINSEL0.Reg) & 0x300000) >> 20
}
func (o *PINCONNECT_Type) SetPINSEL0_P0_11(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0xc00000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINSEL0_P0_11() uint32 {
	return (volatile.LoadUint32(&o.PINSEL0.Reg) & 0xc00000) >> 22
}
func (o *PINCONNECT_Type) SetPINSEL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0x3f000000)|value<<24)
}
func (o *PINCONNECT_Type) GetPINSEL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINSEL0.Reg) & 0x3f000000) >> 24
}
func (o *PINCONNECT_Type) SetPINSEL0_P0_15(value uint32) {
	volatile.StoreUint32(&o.PINSEL0.Reg, volatile.LoadUint32(&o.PINSEL0.Reg)&^(0xc0000000)|value<<30)
}
func (o *PINCONNECT_Type) GetPINSEL0_P0_15() uint32 {
	return (volatile.LoadUint32(&o.PINSEL0.Reg) & 0xc0000000) >> 30
}

// PINCONNECT.PINSEL1: Pin function select register 1.
func (o *PINCONNECT_Type) SetPINSEL1_P0_16(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0x3)|value)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_16() uint32 {
	return volatile.LoadUint32(&o.PINSEL1.Reg) & 0x3
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_17(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0xc)|value<<2)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_17() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0xc) >> 2
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_18(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0x30)|value<<4)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_18() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0x30) >> 4
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_19(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0xc0)|value<<6)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_19() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0xc0) >> 6
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_20(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0x300)|value<<8)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_20() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0x300) >> 8
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_21(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0xc00)|value<<10)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_21() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0xc00) >> 10
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_22(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0x3000)|value<<12)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_22() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0x3000) >> 12
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_23(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0xc000)|value<<14)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_23() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0xc000) >> 14
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_24(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0x30000)|value<<16)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_24() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0x30000) >> 16
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_25(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0xc0000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_25() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0xc0000) >> 18
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_26(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0x300000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_26() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0x300000) >> 20
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_27(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0xc00000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_27() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0xc00000) >> 22
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_28(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0x3000000)|value<<24)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_28() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0x3000000) >> 24
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_29(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0xc000000)|value<<26)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_29() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0xc000000) >> 26
}
func (o *PINCONNECT_Type) SetPINSEL1_P0_30(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0x30000000)|value<<28)
}
func (o *PINCONNECT_Type) GetPINSEL1_P0_30() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0x30000000) >> 28
}
func (o *PINCONNECT_Type) SetPINSEL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINSEL1.Reg, volatile.LoadUint32(&o.PINSEL1.Reg)&^(0xc0000000)|value<<30)
}
func (o *PINCONNECT_Type) GetPINSEL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINSEL1.Reg) & 0xc0000000) >> 30
}

// PINCONNECT.PINSEL2: Pin function select register 2.
func (o *PINCONNECT_Type) SetPINSEL2_P1_0(value uint32) {
	volatile.StoreUint32(&o.PINSEL2.Reg, volatile.LoadUint32(&o.PINSEL2.Reg)&^(0x3)|value)
}
func (o *PINCONNECT_Type) GetPINSEL2_P1_0() uint32 {
	return volatile.LoadUint32(&o.PINSEL2.Reg) & 0x3
}
func (o *PINCONNECT_Type) SetPINSEL2_P1_1(value uint32) {
	volatile.StoreUint32(&o.PINSEL2.Reg, volatile.LoadUint32(&o.PINSEL2.Reg)&^(0xc)|value<<2)
}
func (o *PINCONNECT_Type) GetPINSEL2_P1_1() uint32 {
	return (volatile.LoadUint32(&o.PINSEL2.Reg) & 0xc) >> 2
}
func (o *PINCONNECT_Type) SetPINSEL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINSEL2.Reg, volatile.LoadUint32(&o.PINSEL2.Reg)&^(0xf0)|value<<4)
}
func (o *PINCONNECT_Type) GetPINSEL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINSEL2.Reg) & 0xf0) >> 4
}
func (o *PINCONNECT_Type) SetPINSEL2_P1_4(value uint32) {
	volatile.StoreUint32(&o.PINSEL2.Reg, volatile.LoadUint32(&o.PINSEL2.Reg)&^(0x300)|value<<8)
}
func (o *PINCONNECT_Type) GetPINSEL2_P1_4() uint32 {
	return (volatile.LoadUint32(&o.PINSEL2.Reg) & 0x300) >> 8
}
func (o *PINCONNECT_Type) SetPINSEL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINSEL2.Reg, volatile.LoadUint32(&o.PINSEL2.Reg)&^(0xfc00)|value<<10)
}
func (o *PINCONNECT_Type) GetPINSEL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINSEL2.Reg) & 0xfc00) >> 10
}
func (o *PINCONNECT_Type) SetPINSEL2_P1_8(value uint32) {
	volatile.StoreUint32(&o.PINSEL2.Reg, volatile.LoadUint32(&o.PINSEL2.Reg)&^(0x30000)|value<<16)
}
func (o *PINCONNECT_Type) GetPINSEL2_P1_8() uint32 {
	return (volatile.LoadUint32(&o.PINSEL2.Reg) & 0x30000) >> 16
}
func (o *PINCONNECT_Type) SetPINSEL2_P1_9(value uint32) {
	volatile.StoreUint32(&o.PINSEL2.Reg, volatile.LoadUint32(&o.PINSEL2.Reg)&^(0xc0000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINSEL2_P1_9() uint32 {
	return (volatile.LoadUint32(&o.PINSEL2.Reg) & 0xc0000) >> 18
}
func (o *PINCONNECT_Type) SetPINSEL2_P1_10(value uint32) {
	volatile.StoreUint32(&o.PINSEL2.Reg, volatile.LoadUint32(&o.PINSEL2.Reg)&^(0x300000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINSEL2_P1_10() uint32 {
	return (volatile.LoadUint32(&o.PINSEL2.Reg) & 0x300000) >> 20
}
func (o *PINCONNECT_Type) SetPINSEL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINSEL2.Reg, volatile.LoadUint32(&o.PINSEL2.Reg)&^(0x3f000000)|value<<24)
}
func (o *PINCONNECT_Type) GetPINSEL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINSEL2.Reg) & 0x3f000000) >> 24
}
func (o *PINCONNECT_Type) SetPINSEL2_P1_14(value uint32) {
	volatile.StoreUint32(&o.PINSEL2.Reg, volatile.LoadUint32(&o.PINSEL2.Reg)&^(0xc00000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINSEL2_P1_14() uint32 {
	return (volatile.LoadUint32(&o.PINSEL2.Reg) & 0xc00000) >> 22
}
func (o *PINCONNECT_Type) SetPINSEL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINSEL2.Reg, volatile.LoadUint32(&o.PINSEL2.Reg)&^(0x3f000000)|value<<24)
}
func (o *PINCONNECT_Type) GetPINSEL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINSEL2.Reg) & 0x3f000000) >> 24
}
func (o *PINCONNECT_Type) SetPINSEL2_P1_15(value uint32) {
	volatile.StoreUint32(&o.PINSEL2.Reg, volatile.LoadUint32(&o.PINSEL2.Reg)&^(0xc0000000)|value<<30)
}
func (o *PINCONNECT_Type) GetPINSEL2_P1_15() uint32 {
	return (volatile.LoadUint32(&o.PINSEL2.Reg) & 0xc0000000) >> 30
}

// PINCONNECT.PINSEL3: Pin function select register 3.
func (o *PINCONNECT_Type) SetPINSEL3_P1_16(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0x3)|value)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_16() uint32 {
	return volatile.LoadUint32(&o.PINSEL3.Reg) & 0x3
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_17(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0xc)|value<<2)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_17() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0xc) >> 2
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_18(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0x30)|value<<4)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_18() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0x30) >> 4
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_19(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0xc0)|value<<6)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_19() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0xc0) >> 6
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_20(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0x300)|value<<8)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_20() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0x300) >> 8
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_21(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0xc00)|value<<10)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_21() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0xc00) >> 10
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_22(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0x3000)|value<<12)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_22() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0x3000) >> 12
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_23(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0xc000)|value<<14)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_23() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0xc000) >> 14
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_24(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0x30000)|value<<16)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_24() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0x30000) >> 16
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_25(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0xc0000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_25() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0xc0000) >> 18
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_26(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0x300000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_26() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0x300000) >> 20
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_27(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0xc00000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_27() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0xc00000) >> 22
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_28(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0x3000000)|value<<24)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_28() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0x3000000) >> 24
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_29(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0xc000000)|value<<26)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_29() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0xc000000) >> 26
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_30(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0x30000000)|value<<28)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_30() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0x30000000) >> 28
}
func (o *PINCONNECT_Type) SetPINSEL3_P1_31(value uint32) {
	volatile.StoreUint32(&o.PINSEL3.Reg, volatile.LoadUint32(&o.PINSEL3.Reg)&^(0xc0000000)|value<<30)
}
func (o *PINCONNECT_Type) GetPINSEL3_P1_31() uint32 {
	return (volatile.LoadUint32(&o.PINSEL3.Reg) & 0xc0000000) >> 30
}

// PINCONNECT.PINSEL4: Pin function select register 4
func (o *PINCONNECT_Type) SetPINSEL4_P2_0(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0x3)|value)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_0() uint32 {
	return volatile.LoadUint32(&o.PINSEL4.Reg) & 0x3
}
func (o *PINCONNECT_Type) SetPINSEL4_P2_1(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0xc)|value<<2)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_1() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0xc) >> 2
}
func (o *PINCONNECT_Type) SetPINSEL4_P2_2(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0x30)|value<<4)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_2() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0x30) >> 4
}
func (o *PINCONNECT_Type) SetPINSEL4_P2_3(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0xc0)|value<<6)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_3() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0xc0) >> 6
}
func (o *PINCONNECT_Type) SetPINSEL4_P2_4(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0x300)|value<<8)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_4() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0x300) >> 8
}
func (o *PINCONNECT_Type) SetPINSEL4_P2_5(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0xc00)|value<<10)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_5() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0xc00) >> 10
}
func (o *PINCONNECT_Type) SetPINSEL4_P2_6(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0x3000)|value<<12)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_6() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0x3000) >> 12
}
func (o *PINCONNECT_Type) SetPINSEL4_P2_7(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0xc000)|value<<14)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_7() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0xc000) >> 14
}
func (o *PINCONNECT_Type) SetPINSEL4_P2_8(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0x30000)|value<<16)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_8() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0x30000) >> 16
}
func (o *PINCONNECT_Type) SetPINSEL4_P2_9(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0xc0000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_9() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0xc0000) >> 18
}
func (o *PINCONNECT_Type) SetPINSEL4_P2_10(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0x300000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_10() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0x300000) >> 20
}
func (o *PINCONNECT_Type) SetPINSEL4_P2_11(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0xc00000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_11() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0xc00000) >> 22
}
func (o *PINCONNECT_Type) SetPINSEL4_P2_12(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0x3000000)|value<<24)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_12() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0x3000000) >> 24
}
func (o *PINCONNECT_Type) SetPINSEL4_P2_13(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0xc000000)|value<<26)
}
func (o *PINCONNECT_Type) GetPINSEL4_P2_13() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0xc000000) >> 26
}
func (o *PINCONNECT_Type) SetPINSEL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINSEL4.Reg, volatile.LoadUint32(&o.PINSEL4.Reg)&^(0xf0000000)|value<<28)
}
func (o *PINCONNECT_Type) GetPINSEL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINSEL4.Reg) & 0xf0000000) >> 28
}

// PINCONNECT.PINSEL7: Pin function select register 7
func (o *PINCONNECT_Type) SetPINSEL7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINSEL7.Reg, volatile.LoadUint32(&o.PINSEL7.Reg)&^(0x3ffff)|value)
}
func (o *PINCONNECT_Type) GetPINSEL7_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PINSEL7.Reg) & 0x3ffff
}
func (o *PINCONNECT_Type) SetPINSEL7_P3_25(value uint32) {
	volatile.StoreUint32(&o.PINSEL7.Reg, volatile.LoadUint32(&o.PINSEL7.Reg)&^(0xc0000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINSEL7_P3_25() uint32 {
	return (volatile.LoadUint32(&o.PINSEL7.Reg) & 0xc0000) >> 18
}
func (o *PINCONNECT_Type) SetPINSEL7_P3_26(value uint32) {
	volatile.StoreUint32(&o.PINSEL7.Reg, volatile.LoadUint32(&o.PINSEL7.Reg)&^(0x300000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINSEL7_P3_26() uint32 {
	return (volatile.LoadUint32(&o.PINSEL7.Reg) & 0x300000) >> 20
}
func (o *PINCONNECT_Type) SetPINSEL7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINSEL7.Reg, volatile.LoadUint32(&o.PINSEL7.Reg)&^(0xffc00000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINSEL7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINSEL7.Reg) & 0xffc00000) >> 22
}

// PINCONNECT.PINSEL9: Pin function select register 9
func (o *PINCONNECT_Type) SetPINSEL9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINSEL9.Reg, volatile.LoadUint32(&o.PINSEL9.Reg)&^(0xffffff)|value)
}
func (o *PINCONNECT_Type) GetPINSEL9_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PINSEL9.Reg) & 0xffffff
}
func (o *PINCONNECT_Type) SetPINSEL9_P4_28(value uint32) {
	volatile.StoreUint32(&o.PINSEL9.Reg, volatile.LoadUint32(&o.PINSEL9.Reg)&^(0x3000000)|value<<24)
}
func (o *PINCONNECT_Type) GetPINSEL9_P4_28() uint32 {
	return (volatile.LoadUint32(&o.PINSEL9.Reg) & 0x3000000) >> 24
}
func (o *PINCONNECT_Type) SetPINSEL9_P4_29(value uint32) {
	volatile.StoreUint32(&o.PINSEL9.Reg, volatile.LoadUint32(&o.PINSEL9.Reg)&^(0xc000000)|value<<26)
}
func (o *PINCONNECT_Type) GetPINSEL9_P4_29() uint32 {
	return (volatile.LoadUint32(&o.PINSEL9.Reg) & 0xc000000) >> 26
}
func (o *PINCONNECT_Type) SetPINSEL9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINSEL9.Reg, volatile.LoadUint32(&o.PINSEL9.Reg)&^(0xf0000000)|value<<28)
}
func (o *PINCONNECT_Type) GetPINSEL9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINSEL9.Reg) & 0xf0000000) >> 28
}

// PINCONNECT.PINSEL10: Pin function select register 10
func (o *PINCONNECT_Type) SetPINSEL10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINSEL10.Reg, volatile.LoadUint32(&o.PINSEL10.Reg)&^(0x7)|value)
}
func (o *PINCONNECT_Type) GetPINSEL10_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PINSEL10.Reg) & 0x7
}
func (o *PINCONNECT_Type) SetPINSEL10_TPIUCTRL(value uint32) {
	volatile.StoreUint32(&o.PINSEL10.Reg, volatile.LoadUint32(&o.PINSEL10.Reg)&^(0x8)|value<<3)
}
func (o *PINCONNECT_Type) GetPINSEL10_TPIUCTRL() uint32 {
	return (volatile.LoadUint32(&o.PINSEL10.Reg) & 0x8) >> 3
}
func (o *PINCONNECT_Type) SetPINSEL10_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINSEL10.Reg, volatile.LoadUint32(&o.PINSEL10.Reg)&^(0xfffffff0)|value<<4)
}
func (o *PINCONNECT_Type) GetPINSEL10_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINSEL10.Reg) & 0xfffffff0) >> 4
}

// PINCONNECT.PINMODE0: Pin mode select register 0
func (o *PINCONNECT_Type) SetPINMODE0_P0_00MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0x3)|value)
}
func (o *PINCONNECT_Type) GetPINMODE0_P0_00MODE() uint32 {
	return volatile.LoadUint32(&o.PINMODE0.Reg) & 0x3
}
func (o *PINCONNECT_Type) SetPINMODE0_P0_01MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0xc)|value<<2)
}
func (o *PINCONNECT_Type) GetPINMODE0_P0_01MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE0.Reg) & 0xc) >> 2
}
func (o *PINCONNECT_Type) SetPINMODE0_P0_02MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0x30)|value<<4)
}
func (o *PINCONNECT_Type) GetPINMODE0_P0_02MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE0.Reg) & 0x30) >> 4
}
func (o *PINCONNECT_Type) SetPINMODE0_P0_03MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0xc0)|value<<6)
}
func (o *PINCONNECT_Type) GetPINMODE0_P0_03MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE0.Reg) & 0xc0) >> 6
}
func (o *PINCONNECT_Type) SetPINMODE0_P0_04MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0x300)|value<<8)
}
func (o *PINCONNECT_Type) GetPINMODE0_P0_04MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE0.Reg) & 0x300) >> 8
}
func (o *PINCONNECT_Type) SetPINMODE0_P0_05MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0xc00)|value<<10)
}
func (o *PINCONNECT_Type) GetPINMODE0_P0_05MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE0.Reg) & 0xc00) >> 10
}
func (o *PINCONNECT_Type) SetPINMODE0_P0_06MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0x3000)|value<<12)
}
func (o *PINCONNECT_Type) GetPINMODE0_P0_06MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE0.Reg) & 0x3000) >> 12
}
func (o *PINCONNECT_Type) SetPINMODE0_P0_07MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0xc000)|value<<14)
}
func (o *PINCONNECT_Type) GetPINMODE0_P0_07MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE0.Reg) & 0xc000) >> 14
}
func (o *PINCONNECT_Type) SetPINMODE0_P0_08MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0x30000)|value<<16)
}
func (o *PINCONNECT_Type) GetPINMODE0_P0_08MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE0.Reg) & 0x30000) >> 16
}
func (o *PINCONNECT_Type) SetPINMODE0_P0_09MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0xc0000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINMODE0_P0_09MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE0.Reg) & 0xc0000) >> 18
}
func (o *PINCONNECT_Type) SetPINMODE0_P0_10MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0x300000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINMODE0_P0_10MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE0.Reg) & 0x300000) >> 20
}
func (o *PINCONNECT_Type) SetPINMODE0_P0_11MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0xc00000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINMODE0_P0_11MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE0.Reg) & 0xc00000) >> 22
}
func (o *PINCONNECT_Type) SetPINMODE0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0x3f000000)|value<<24)
}
func (o *PINCONNECT_Type) GetPINMODE0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE0.Reg) & 0x3f000000) >> 24
}
func (o *PINCONNECT_Type) SetPINMODE0_P0_15MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE0.Reg, volatile.LoadUint32(&o.PINMODE0.Reg)&^(0xc0000000)|value<<30)
}
func (o *PINCONNECT_Type) GetPINMODE0_P0_15MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE0.Reg) & 0xc0000000) >> 30
}

// PINCONNECT.PINMODE1: Pin mode select register 1
func (o *PINCONNECT_Type) SetPINMODE1_P0_16MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE1.Reg, volatile.LoadUint32(&o.PINMODE1.Reg)&^(0x3)|value)
}
func (o *PINCONNECT_Type) GetPINMODE1_P0_16MODE() uint32 {
	return volatile.LoadUint32(&o.PINMODE1.Reg) & 0x3
}
func (o *PINCONNECT_Type) SetPINMODE1_P0_17MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE1.Reg, volatile.LoadUint32(&o.PINMODE1.Reg)&^(0xc)|value<<2)
}
func (o *PINCONNECT_Type) GetPINMODE1_P0_17MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE1.Reg) & 0xc) >> 2
}
func (o *PINCONNECT_Type) SetPINMODE1_P0_18MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE1.Reg, volatile.LoadUint32(&o.PINMODE1.Reg)&^(0x30)|value<<4)
}
func (o *PINCONNECT_Type) GetPINMODE1_P0_18MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE1.Reg) & 0x30) >> 4
}
func (o *PINCONNECT_Type) SetPINMODE1_P0_19MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE1.Reg, volatile.LoadUint32(&o.PINMODE1.Reg)&^(0xc0)|value<<6)
}
func (o *PINCONNECT_Type) GetPINMODE1_P0_19MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE1.Reg) & 0xc0) >> 6
}
func (o *PINCONNECT_Type) SetPINMODE1_P0_20MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE1.Reg, volatile.LoadUint32(&o.PINMODE1.Reg)&^(0x300)|value<<8)
}
func (o *PINCONNECT_Type) GetPINMODE1_P0_20MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE1.Reg) & 0x300) >> 8
}
func (o *PINCONNECT_Type) SetPINMODE1_P0_21MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE1.Reg, volatile.LoadUint32(&o.PINMODE1.Reg)&^(0xc00)|value<<10)
}
func (o *PINCONNECT_Type) GetPINMODE1_P0_21MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE1.Reg) & 0xc00) >> 10
}
func (o *PINCONNECT_Type) SetPINMODE1_P0_22MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE1.Reg, volatile.LoadUint32(&o.PINMODE1.Reg)&^(0x3000)|value<<12)
}
func (o *PINCONNECT_Type) GetPINMODE1_P0_22MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE1.Reg) & 0x3000) >> 12
}
func (o *PINCONNECT_Type) SetPINMODE1_P0_23MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE1.Reg, volatile.LoadUint32(&o.PINMODE1.Reg)&^(0xc000)|value<<14)
}
func (o *PINCONNECT_Type) GetPINMODE1_P0_23MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE1.Reg) & 0xc000) >> 14
}
func (o *PINCONNECT_Type) SetPINMODE1_P0_24MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE1.Reg, volatile.LoadUint32(&o.PINMODE1.Reg)&^(0x30000)|value<<16)
}
func (o *PINCONNECT_Type) GetPINMODE1_P0_24MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE1.Reg) & 0x30000) >> 16
}
func (o *PINCONNECT_Type) SetPINMODE1_P0_25MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE1.Reg, volatile.LoadUint32(&o.PINMODE1.Reg)&^(0xc0000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINMODE1_P0_25MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE1.Reg) & 0xc0000) >> 18
}
func (o *PINCONNECT_Type) SetPINMODE1_P0_26MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE1.Reg, volatile.LoadUint32(&o.PINMODE1.Reg)&^(0x300000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINMODE1_P0_26MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE1.Reg) & 0x300000) >> 20
}
func (o *PINCONNECT_Type) SetPINMODE1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE1.Reg, volatile.LoadUint32(&o.PINMODE1.Reg)&^(0x3fc00000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINMODE1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE1.Reg) & 0x3fc00000) >> 22
}
func (o *PINCONNECT_Type) SetPINMODE1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE1.Reg, volatile.LoadUint32(&o.PINMODE1.Reg)&^(0xc0000000)|value<<30)
}
func (o *PINCONNECT_Type) GetPINMODE1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE1.Reg) & 0xc0000000) >> 30
}

// PINCONNECT.PINMODE2: Pin mode select register 2
func (o *PINCONNECT_Type) SetPINMODE2_P1_00MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE2.Reg, volatile.LoadUint32(&o.PINMODE2.Reg)&^(0x3)|value)
}
func (o *PINCONNECT_Type) GetPINMODE2_P1_00MODE() uint32 {
	return volatile.LoadUint32(&o.PINMODE2.Reg) & 0x3
}
func (o *PINCONNECT_Type) SetPINMODE2_P1_01MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE2.Reg, volatile.LoadUint32(&o.PINMODE2.Reg)&^(0xc)|value<<2)
}
func (o *PINCONNECT_Type) GetPINMODE2_P1_01MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE2.Reg) & 0xc) >> 2
}
func (o *PINCONNECT_Type) SetPINMODE2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE2.Reg, volatile.LoadUint32(&o.PINMODE2.Reg)&^(0xf0)|value<<4)
}
func (o *PINCONNECT_Type) GetPINMODE2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE2.Reg) & 0xf0) >> 4
}
func (o *PINCONNECT_Type) SetPINMODE2_P1_04MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE2.Reg, volatile.LoadUint32(&o.PINMODE2.Reg)&^(0x300)|value<<8)
}
func (o *PINCONNECT_Type) GetPINMODE2_P1_04MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE2.Reg) & 0x300) >> 8
}
func (o *PINCONNECT_Type) SetPINMODE2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE2.Reg, volatile.LoadUint32(&o.PINMODE2.Reg)&^(0xfc00)|value<<10)
}
func (o *PINCONNECT_Type) GetPINMODE2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE2.Reg) & 0xfc00) >> 10
}
func (o *PINCONNECT_Type) SetPINMODE2_P1_08MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE2.Reg, volatile.LoadUint32(&o.PINMODE2.Reg)&^(0x30000)|value<<16)
}
func (o *PINCONNECT_Type) GetPINMODE2_P1_08MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE2.Reg) & 0x30000) >> 16
}
func (o *PINCONNECT_Type) SetPINMODE2_P1_09MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE2.Reg, volatile.LoadUint32(&o.PINMODE2.Reg)&^(0xc0000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINMODE2_P1_09MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE2.Reg) & 0xc0000) >> 18
}
func (o *PINCONNECT_Type) SetPINMODE2_P1_10MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE2.Reg, volatile.LoadUint32(&o.PINMODE2.Reg)&^(0x300000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINMODE2_P1_10MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE2.Reg) & 0x300000) >> 20
}
func (o *PINCONNECT_Type) SetPINMODE2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE2.Reg, volatile.LoadUint32(&o.PINMODE2.Reg)&^(0xfc00000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINMODE2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE2.Reg) & 0xfc00000) >> 22
}
func (o *PINCONNECT_Type) SetPINMODE2_P1_14MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE2.Reg, volatile.LoadUint32(&o.PINMODE2.Reg)&^(0x30000000)|value<<28)
}
func (o *PINCONNECT_Type) GetPINMODE2_P1_14MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE2.Reg) & 0x30000000) >> 28
}
func (o *PINCONNECT_Type) SetPINMODE2_P1_15MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE2.Reg, volatile.LoadUint32(&o.PINMODE2.Reg)&^(0xc0000000)|value<<30)
}
func (o *PINCONNECT_Type) GetPINMODE2_P1_15MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE2.Reg) & 0xc0000000) >> 30
}

// PINCONNECT.PINMODE3: Pin mode select register 3.
func (o *PINCONNECT_Type) SetPINMODE3_P1_16MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0x3)|value)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_16MODE() uint32 {
	return volatile.LoadUint32(&o.PINMODE3.Reg) & 0x3
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_17MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0xc)|value<<2)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_17MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0xc) >> 2
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_18MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0x30)|value<<4)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_18MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0x30) >> 4
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_19MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0xc0)|value<<6)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_19MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0xc0) >> 6
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_20MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0x300)|value<<8)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_20MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0x300) >> 8
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_21MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0xc00)|value<<10)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_21MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0xc00) >> 10
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_22MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0x3000)|value<<12)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_22MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0x3000) >> 12
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_23MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0xc000)|value<<14)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_23MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0xc000) >> 14
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_24MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0x30000)|value<<16)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_24MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0x30000) >> 16
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_25MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0xc0000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_25MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0xc0000) >> 18
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_26MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0x300000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_26MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0x300000) >> 20
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_27MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0xc00000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_27MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0xc00000) >> 22
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_28MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0x3000000)|value<<24)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_28MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0x3000000) >> 24
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_29MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0xc000000)|value<<26)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_29MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0xc000000) >> 26
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_30MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0x30000000)|value<<28)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_30MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0x30000000) >> 28
}
func (o *PINCONNECT_Type) SetPINMODE3_P1_31MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE3.Reg, volatile.LoadUint32(&o.PINMODE3.Reg)&^(0xc0000000)|value<<30)
}
func (o *PINCONNECT_Type) GetPINMODE3_P1_31MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE3.Reg) & 0xc0000000) >> 30
}

// PINCONNECT.PINMODE4: Pin mode select register 4
func (o *PINCONNECT_Type) SetPINMODE4_P2_00MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0x3)|value)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_00MODE() uint32 {
	return volatile.LoadUint32(&o.PINMODE4.Reg) & 0x3
}
func (o *PINCONNECT_Type) SetPINMODE4_P2_01MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0xc)|value<<2)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_01MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0xc) >> 2
}
func (o *PINCONNECT_Type) SetPINMODE4_P2_02MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0x30)|value<<4)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_02MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0x30) >> 4
}
func (o *PINCONNECT_Type) SetPINMODE4_P2_03MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0xc0)|value<<6)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_03MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0xc0) >> 6
}
func (o *PINCONNECT_Type) SetPINMODE4_P2_04MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0x300)|value<<8)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_04MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0x300) >> 8
}
func (o *PINCONNECT_Type) SetPINMODE4_P2_05MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0xc00)|value<<10)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_05MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0xc00) >> 10
}
func (o *PINCONNECT_Type) SetPINMODE4_P2_06MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0x3000)|value<<12)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_06MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0x3000) >> 12
}
func (o *PINCONNECT_Type) SetPINMODE4_P2_07MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0xc000)|value<<14)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_07MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0xc000) >> 14
}
func (o *PINCONNECT_Type) SetPINMODE4_P2_08MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0x30000)|value<<16)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_08MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0x30000) >> 16
}
func (o *PINCONNECT_Type) SetPINMODE4_P2_09MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0xc0000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_09MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0xc0000) >> 18
}
func (o *PINCONNECT_Type) SetPINMODE4_P2_10MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0x300000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_10MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0x300000) >> 20
}
func (o *PINCONNECT_Type) SetPINMODE4_P2_11MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0xc00000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_11MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0xc00000) >> 22
}
func (o *PINCONNECT_Type) SetPINMODE4_P2_12MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0x3000000)|value<<24)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_12MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0x3000000) >> 24
}
func (o *PINCONNECT_Type) SetPINMODE4_P2_13MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0xc000000)|value<<26)
}
func (o *PINCONNECT_Type) GetPINMODE4_P2_13MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0xc000000) >> 26
}
func (o *PINCONNECT_Type) SetPINMODE4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE4.Reg, volatile.LoadUint32(&o.PINMODE4.Reg)&^(0xf0000000)|value<<28)
}
func (o *PINCONNECT_Type) GetPINMODE4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE4.Reg) & 0xf0000000) >> 28
}

// PINCONNECT.PINMODE7: Pin mode select register 7
func (o *PINCONNECT_Type) SetPINMODE7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE7.Reg, volatile.LoadUint32(&o.PINMODE7.Reg)&^(0x3ffff)|value)
}
func (o *PINCONNECT_Type) GetPINMODE7_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PINMODE7.Reg) & 0x3ffff
}
func (o *PINCONNECT_Type) SetPINMODE7_P3_25MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE7.Reg, volatile.LoadUint32(&o.PINMODE7.Reg)&^(0xc0000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINMODE7_P3_25MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE7.Reg) & 0xc0000) >> 18
}
func (o *PINCONNECT_Type) SetPINMODE7_P3_26MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE7.Reg, volatile.LoadUint32(&o.PINMODE7.Reg)&^(0x300000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINMODE7_P3_26MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE7.Reg) & 0x300000) >> 20
}
func (o *PINCONNECT_Type) SetPINMODE7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE7.Reg, volatile.LoadUint32(&o.PINMODE7.Reg)&^(0xffc00000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINMODE7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE7.Reg) & 0xffc00000) >> 22
}

// PINCONNECT.PINMODE9: Pin mode select register 9
func (o *PINCONNECT_Type) SetPINMODE9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE9.Reg, volatile.LoadUint32(&o.PINMODE9.Reg)&^(0xffffff)|value)
}
func (o *PINCONNECT_Type) GetPINMODE9_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PINMODE9.Reg) & 0xffffff
}
func (o *PINCONNECT_Type) SetPINMODE9_P4_28MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE9.Reg, volatile.LoadUint32(&o.PINMODE9.Reg)&^(0x3000000)|value<<24)
}
func (o *PINCONNECT_Type) GetPINMODE9_P4_28MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE9.Reg) & 0x3000000) >> 24
}
func (o *PINCONNECT_Type) SetPINMODE9_P4_29MODE(value uint32) {
	volatile.StoreUint32(&o.PINMODE9.Reg, volatile.LoadUint32(&o.PINMODE9.Reg)&^(0xc000000)|value<<26)
}
func (o *PINCONNECT_Type) GetPINMODE9_P4_29MODE() uint32 {
	return (volatile.LoadUint32(&o.PINMODE9.Reg) & 0xc000000) >> 26
}
func (o *PINCONNECT_Type) SetPINMODE9_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE9.Reg, volatile.LoadUint32(&o.PINMODE9.Reg)&^(0xf0000000)|value<<28)
}
func (o *PINCONNECT_Type) GetPINMODE9_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE9.Reg) & 0xf0000000) >> 28
}

// PINCONNECT.PINMODE_OD0: Open drain mode control register 0
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_00OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x1)|value)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_00OD() uint32 {
	return volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x1
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_01OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x2)|value<<1)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_01OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x2) >> 1
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_02OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x4)|value<<2)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_02OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x4) >> 2
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_03OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x8)|value<<3)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_03OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x8) >> 3
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_04OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x10)|value<<4)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_04OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x10) >> 4
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_05OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x20)|value<<5)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_05OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x20) >> 5
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_06OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x40)|value<<6)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_06OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x40) >> 6
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_07OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x80)|value<<7)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_07OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x80) >> 7
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_08OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x100)|value<<8)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_08OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x100) >> 8
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_09OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x200)|value<<9)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_09OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x200) >> 9
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_10OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x400)|value<<10)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_10OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x400) >> 10
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_11OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x800)|value<<11)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_11OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x800) >> 11
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x7000)|value<<12)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x7000) >> 12
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_15OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x8000)|value<<15)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_15OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x8000) >> 15
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_16OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x10000)|value<<16)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_16OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x10000) >> 16
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_17OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x20000)|value<<17)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_17OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x20000) >> 17
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_18OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x40000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_18OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x40000) >> 18
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_19OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x80000)|value<<19)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_19OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x80000) >> 19
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_20OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x100000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_20OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x100000) >> 20
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_21OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x200000)|value<<21)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_21OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x200000) >> 21
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_22OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x400000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_22OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x400000) >> 22
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_23OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x800000)|value<<23)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_23OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x800000) >> 23
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_24OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x1000000)|value<<24)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_24OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x1000000) >> 24
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_25OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x2000000)|value<<25)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_25OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x2000000) >> 25
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_26OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x4000000)|value<<26)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_26OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x4000000) >> 26
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x18000000)|value<<27)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x18000000) >> 27
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_29OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x20000000)|value<<29)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_29OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x20000000) >> 29
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_P0_30OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x40000000)|value<<30)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_P0_30OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x40000000) >> 30
}
func (o *PINCONNECT_Type) SetPINMODE_OD0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD0.Reg, volatile.LoadUint32(&o.PINMODE_OD0.Reg)&^(0x80000000)|value<<31)
}
func (o *PINCONNECT_Type) GetPINMODE_OD0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD0.Reg) & 0x80000000) >> 31
}

// PINCONNECT.PINMODE_OD1: Open drain mode control register 1
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_00OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x1)|value)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_00OD() uint32 {
	return volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x1
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_01OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x2)|value<<1)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_01OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x2) >> 1
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0xc)|value<<2)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0xc) >> 2
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_04OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x10)|value<<4)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_04OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x10) >> 4
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0xe0)|value<<5)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0xe0) >> 5
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_08OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x100)|value<<8)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_08OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x100) >> 8
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_09OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x200)|value<<9)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_09OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x200) >> 9
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_10OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x400)|value<<10)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_10OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x400) >> 10
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x3800)|value<<11)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x3800) >> 11
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_14OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x4000)|value<<14)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_14OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x4000) >> 14
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_15OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x8000)|value<<15)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_15OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x8000) >> 15
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_16OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x10000)|value<<16)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_16OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x10000) >> 16
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_17OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x20000)|value<<17)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_17OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x20000) >> 17
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_18OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x40000)|value<<18)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_18OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x40000) >> 18
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_19OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x80000)|value<<19)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_19OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x80000) >> 19
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_20OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x100000)|value<<20)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_20OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x100000) >> 20
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_21OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x200000)|value<<21)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_21OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x200000) >> 21
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_22OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x400000)|value<<22)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_22OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x400000) >> 22
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_23OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x800000)|value<<23)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_23OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x800000) >> 23
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_24OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x1000000)|value<<24)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_24OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x1000000) >> 24
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_25OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x2000000)|value<<25)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_25OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x2000000) >> 25
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_26OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x4000000)|value<<26)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_26OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x4000000) >> 26
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_27OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x8000000)|value<<27)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_27OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x8000000) >> 27
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_28OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x10000000)|value<<28)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_28OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x10000000) >> 28
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_29OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x20000000)|value<<29)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_29OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x20000000) >> 29
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_30OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x40000000)|value<<30)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_30OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x40000000) >> 30
}
func (o *PINCONNECT_Type) SetPINMODE_OD1_P1_31OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD1.Reg, volatile.LoadUint32(&o.PINMODE_OD1.Reg)&^(0x80000000)|value<<31)
}
func (o *PINCONNECT_Type) GetPINMODE_OD1_P1_31OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD1.Reg) & 0x80000000) >> 31
}

// PINCONNECT.PINMODE_OD2: Open drain mode control register 2
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_00OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x1)|value)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_00OD() uint32 {
	return volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x1
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_01OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x2)|value<<1)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_01OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x2) >> 1
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_02OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x4)|value<<2)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_02OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x4) >> 2
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_03OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x8)|value<<3)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_03OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x8) >> 3
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_04OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x10)|value<<4)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_04OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x10) >> 4
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_05OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x20)|value<<5)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_05OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x20) >> 5
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_06OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x40)|value<<6)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_06OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x40) >> 6
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_07OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x80)|value<<7)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_07OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x80) >> 7
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_08OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x100)|value<<8)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_08OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x100) >> 8
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_09OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x200)|value<<9)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_09OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x200) >> 9
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_10OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x400)|value<<10)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_10OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x400) >> 10
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_11OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x800)|value<<11)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_11OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x800) >> 11
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_12OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x1000)|value<<12)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_12OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x1000) >> 12
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_P2_13OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0x2000)|value<<13)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_P2_13OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0x2000) >> 13
}
func (o *PINCONNECT_Type) SetPINMODE_OD2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD2.Reg, volatile.LoadUint32(&o.PINMODE_OD2.Reg)&^(0xffffc000)|value<<14)
}
func (o *PINCONNECT_Type) GetPINMODE_OD2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD2.Reg) & 0xffffc000) >> 14
}

// PINCONNECT.PINMODE_OD3: Open drain mode control register 3
func (o *PINCONNECT_Type) SetPINMODE_OD3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD3.Reg, volatile.LoadUint32(&o.PINMODE_OD3.Reg)&^(0x1ffffff)|value)
}
func (o *PINCONNECT_Type) GetPINMODE_OD3_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PINMODE_OD3.Reg) & 0x1ffffff
}
func (o *PINCONNECT_Type) SetPINMODE_OD3_P3_25OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD3.Reg, volatile.LoadUint32(&o.PINMODE_OD3.Reg)&^(0x2000000)|value<<25)
}
func (o *PINCONNECT_Type) GetPINMODE_OD3_P3_25OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD3.Reg) & 0x2000000) >> 25
}
func (o *PINCONNECT_Type) SetPINMODE_OD3_P3_26OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD3.Reg, volatile.LoadUint32(&o.PINMODE_OD3.Reg)&^(0x4000000)|value<<26)
}
func (o *PINCONNECT_Type) GetPINMODE_OD3_P3_26OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD3.Reg) & 0x4000000) >> 26
}
func (o *PINCONNECT_Type) SetPINMODE_OD3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD3.Reg, volatile.LoadUint32(&o.PINMODE_OD3.Reg)&^(0xf8000000)|value<<27)
}
func (o *PINCONNECT_Type) GetPINMODE_OD3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD3.Reg) & 0xf8000000) >> 27
}

// PINCONNECT.PINMODE_OD4: Open drain mode control register 4
func (o *PINCONNECT_Type) SetPINMODE_OD4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD4.Reg, volatile.LoadUint32(&o.PINMODE_OD4.Reg)&^(0xfffffff)|value)
}
func (o *PINCONNECT_Type) GetPINMODE_OD4_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PINMODE_OD4.Reg) & 0xfffffff
}
func (o *PINCONNECT_Type) SetPINMODE_OD4_P4_28OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD4.Reg, volatile.LoadUint32(&o.PINMODE_OD4.Reg)&^(0x10000000)|value<<28)
}
func (o *PINCONNECT_Type) GetPINMODE_OD4_P4_28OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD4.Reg) & 0x10000000) >> 28
}
func (o *PINCONNECT_Type) SetPINMODE_OD4_P4_29OD(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD4.Reg, volatile.LoadUint32(&o.PINMODE_OD4.Reg)&^(0x20000000)|value<<29)
}
func (o *PINCONNECT_Type) GetPINMODE_OD4_P4_29OD() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD4.Reg) & 0x20000000) >> 29
}
func (o *PINCONNECT_Type) SetPINMODE_OD4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PINMODE_OD4.Reg, volatile.LoadUint32(&o.PINMODE_OD4.Reg)&^(0xc0000000)|value<<30)
}
func (o *PINCONNECT_Type) GetPINMODE_OD4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PINMODE_OD4.Reg) & 0xc0000000) >> 30
}

// PINCONNECT.I2CPADCFG: I2C Pin Configuration register
func (o *PINCONNECT_Type) SetI2CPADCFG_SDADRV0(value uint32) {
	volatile.StoreUint32(&o.I2CPADCFG.Reg, volatile.LoadUint32(&o.I2CPADCFG.Reg)&^(0x1)|value)
}
func (o *PINCONNECT_Type) GetI2CPADCFG_SDADRV0() uint32 {
	return volatile.LoadUint32(&o.I2CPADCFG.Reg) & 0x1
}
func (o *PINCONNECT_Type) SetI2CPADCFG_SDAI2C0(value uint32) {
	volatile.StoreUint32(&o.I2CPADCFG.Reg, volatile.LoadUint32(&o.I2CPADCFG.Reg)&^(0x2)|value<<1)
}
func (o *PINCONNECT_Type) GetI2CPADCFG_SDAI2C0() uint32 {
	return (volatile.LoadUint32(&o.I2CPADCFG.Reg) & 0x2) >> 1
}
func (o *PINCONNECT_Type) SetI2CPADCFG_SCLDRV0(value uint32) {
	volatile.StoreUint32(&o.I2CPADCFG.Reg, volatile.LoadUint32(&o.I2CPADCFG.Reg)&^(0x4)|value<<2)
}
func (o *PINCONNECT_Type) GetI2CPADCFG_SCLDRV0() uint32 {
	return (volatile.LoadUint32(&o.I2CPADCFG.Reg) & 0x4) >> 2
}
func (o *PINCONNECT_Type) SetI2CPADCFG_SCLI2C0(value uint32) {
	volatile.StoreUint32(&o.I2CPADCFG.Reg, volatile.LoadUint32(&o.I2CPADCFG.Reg)&^(0x8)|value<<3)
}
func (o *PINCONNECT_Type) GetI2CPADCFG_SCLI2C0() uint32 {
	return (volatile.LoadUint32(&o.I2CPADCFG.Reg) & 0x8) >> 3
}
func (o *PINCONNECT_Type) SetI2CPADCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.I2CPADCFG.Reg, volatile.LoadUint32(&o.I2CPADCFG.Reg)&^(0xfffffff0)|value<<4)
}
func (o *PINCONNECT_Type) GetI2CPADCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.I2CPADCFG.Reg) & 0xfffffff0) >> 4
}

// SSP1 controller
type SSP1_Type struct {
	CR0   volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	DR    volatile.Register32 // 0x8
	SR    volatile.Register32 // 0xC
	CPSR  volatile.Register32 // 0x10
	IMSC  volatile.Register32 // 0x14
	RIS   volatile.Register32 // 0x18
	MIS   volatile.Register32 // 0x1C
	ICR   volatile.Register32 // 0x20
	DMACR volatile.Register32 // 0x24
}

// SSP1.CR0: Control Register 0. Selects the serial clock rate, bus type, and data size.
func (o *SSP1_Type) SetCR0_DSS(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0xf)|value)
}
func (o *SSP1_Type) GetCR0_DSS() uint32 {
	return volatile.LoadUint32(&o.CR0.Reg) & 0xf
}
func (o *SSP1_Type) SetCR0_FRF(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0x30)|value<<4)
}
func (o *SSP1_Type) GetCR0_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0x30) >> 4
}
func (o *SSP1_Type) SetCR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0x40)|value<<6)
}
func (o *SSP1_Type) GetCR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0x40) >> 6
}
func (o *SSP1_Type) SetCR0_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0x80)|value<<7)
}
func (o *SSP1_Type) GetCR0_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0x80) >> 7
}
func (o *SSP1_Type) SetCR0_SCR(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0xff00)|value<<8)
}
func (o *SSP1_Type) GetCR0_SCR() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0xff00) >> 8
}
func (o *SSP1_Type) SetCR0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR0.Reg, volatile.LoadUint32(&o.CR0.Reg)&^(0xffff0000)|value<<16)
}
func (o *SSP1_Type) GetCR0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR0.Reg) & 0xffff0000) >> 16
}

// SSP1.CR1: Control Register 1. Selects master/slave and other modes.
func (o *SSP1_Type) SetCR1_LBM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SSP1_Type) GetCR1_LBM() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *SSP1_Type) SetCR1_SSE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SSP1_Type) GetCR1_SSE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SSP1_Type) SetCR1_MS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SSP1_Type) GetCR1_MS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SSP1_Type) SetCR1_SOD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *SSP1_Type) GetCR1_SOD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *SSP1_Type) SetCR1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SSP1_Type) GetCR1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xfffffff0) >> 4
}

// SSP1.DR: Data Register. Writes fill the transmit FIFO, and reads empty the receive FIFO.
func (o *SSP1_Type) SetDR_DATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SSP1_Type) GetDR_DATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}
func (o *SSP1_Type) SetDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SSP1_Type) GetDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xffff0000) >> 16
}

// SSP1.SR: Status Register
func (o *SSP1_Type) SetSR_TFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SSP1_Type) GetSR_TFE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SSP1_Type) SetSR_TNF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SSP1_Type) GetSR_TNF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SSP1_Type) SetSR_RNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SSP1_Type) GetSR_RNE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SSP1_Type) SetSR_RFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SSP1_Type) GetSR_RFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SSP1_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SSP1_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SSP1_Type) SetSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *SSP1_Type) GetSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xffffffe0) >> 5
}

// SSP1.CPSR: Clock Prescale Register
func (o *SSP1_Type) SetCPSR_CPSDVSR(value uint32) {
	volatile.StoreUint32(&o.CPSR.Reg, volatile.LoadUint32(&o.CPSR.Reg)&^(0xff)|value)
}
func (o *SSP1_Type) GetCPSR_CPSDVSR() uint32 {
	return volatile.LoadUint32(&o.CPSR.Reg) & 0xff
}
func (o *SSP1_Type) SetCPSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CPSR.Reg, volatile.LoadUint32(&o.CPSR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SSP1_Type) GetCPSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CPSR.Reg) & 0xffffff00) >> 8
}

// SSP1.IMSC: Interrupt Mask Set and Clear Register
func (o *SSP1_Type) SetIMSC_RORIM(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0x1)|value)
}
func (o *SSP1_Type) GetIMSC_RORIM() uint32 {
	return volatile.LoadUint32(&o.IMSC.Reg) & 0x1
}
func (o *SSP1_Type) SetIMSC_RTIM(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0x2)|value<<1)
}
func (o *SSP1_Type) GetIMSC_RTIM() uint32 {
	return (volatile.LoadUint32(&o.IMSC.Reg) & 0x2) >> 1
}
func (o *SSP1_Type) SetIMSC_RXIM(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0x4)|value<<2)
}
func (o *SSP1_Type) GetIMSC_RXIM() uint32 {
	return (volatile.LoadUint32(&o.IMSC.Reg) & 0x4) >> 2
}
func (o *SSP1_Type) SetIMSC_TXIM(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0x8)|value<<3)
}
func (o *SSP1_Type) GetIMSC_TXIM() uint32 {
	return (volatile.LoadUint32(&o.IMSC.Reg) & 0x8) >> 3
}
func (o *SSP1_Type) SetIMSC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IMSC.Reg, volatile.LoadUint32(&o.IMSC.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SSP1_Type) GetIMSC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IMSC.Reg) & 0xfffffff0) >> 4
}

// SSP1.RIS: Raw Interrupt Status Register
func (o *SSP1_Type) SetRIS_RORRIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x1)|value)
}
func (o *SSP1_Type) GetRIS_RORRIS() uint32 {
	return volatile.LoadUint32(&o.RIS.Reg) & 0x1
}
func (o *SSP1_Type) SetRIS_RTRIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x2)|value<<1)
}
func (o *SSP1_Type) GetRIS_RTRIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x2) >> 1
}
func (o *SSP1_Type) SetRIS_RXRIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x4)|value<<2)
}
func (o *SSP1_Type) GetRIS_RXRIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x4) >> 2
}
func (o *SSP1_Type) SetRIS_TXRIS(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0x8)|value<<3)
}
func (o *SSP1_Type) GetRIS_TXRIS() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0x8) >> 3
}
func (o *SSP1_Type) SetRIS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RIS.Reg, volatile.LoadUint32(&o.RIS.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SSP1_Type) GetRIS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RIS.Reg) & 0xfffffff0) >> 4
}

// SSP1.MIS: Masked Interrupt Status Register
func (o *SSP1_Type) SetMIS_RORMIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x1)|value)
}
func (o *SSP1_Type) GetMIS_RORMIS() uint32 {
	return volatile.LoadUint32(&o.MIS.Reg) & 0x1
}
func (o *SSP1_Type) SetMIS_RTMIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x2)|value<<1)
}
func (o *SSP1_Type) GetMIS_RTMIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x2) >> 1
}
func (o *SSP1_Type) SetMIS_RXMIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x4)|value<<2)
}
func (o *SSP1_Type) GetMIS_RXMIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x4) >> 2
}
func (o *SSP1_Type) SetMIS_TXMIS(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0x8)|value<<3)
}
func (o *SSP1_Type) GetMIS_TXMIS() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0x8) >> 3
}
func (o *SSP1_Type) SetMIS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MIS.Reg, volatile.LoadUint32(&o.MIS.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SSP1_Type) GetMIS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MIS.Reg) & 0xfffffff0) >> 4
}

// SSP1.ICR: SSPICR Interrupt Clear Register
func (o *SSP1_Type) SetICR_RORIC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *SSP1_Type) GetICR_RORIC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *SSP1_Type) SetICR_RTIC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *SSP1_Type) GetICR_RTIC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *SSP1_Type) SetICR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SSP1_Type) GetICR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xfffffffc) >> 2
}

// SSP1.DMACR: SSP0 DMA control register
func (o *SSP1_Type) SetDMACR_RXDMAE(value uint32) {
	volatile.StoreUint32(&o.DMACR.Reg, volatile.LoadUint32(&o.DMACR.Reg)&^(0x1)|value)
}
func (o *SSP1_Type) GetDMACR_RXDMAE() uint32 {
	return volatile.LoadUint32(&o.DMACR.Reg) & 0x1
}
func (o *SSP1_Type) SetDMACR_TXDMAE(value uint32) {
	volatile.StoreUint32(&o.DMACR.Reg, volatile.LoadUint32(&o.DMACR.Reg)&^(0x2)|value<<1)
}
func (o *SSP1_Type) GetDMACR_TXDMAE() uint32 {
	return (volatile.LoadUint32(&o.DMACR.Reg) & 0x2) >> 1
}
func (o *SSP1_Type) SetDMACR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMACR.Reg, volatile.LoadUint32(&o.DMACR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SSP1_Type) GetDMACR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMACR.Reg) & 0xfffffffc) >> 2
}

// Analog-to-Digital Converter (ADC)
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	GDR   volatile.Register32 // 0x4
	_     [4]byte
	INTEN volatile.Register32    // 0xC
	DR    [8]volatile.Register32 // 0x10
	STAT  volatile.Register32    // 0x30
	TRM   volatile.Register32    // 0x34
}

// ADC.CR: A/D Control Register. The ADCR register must be written to select the operating mode before A/D conversion can occur.
func (o *ADC_Type) SetCR_SEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetCR_SEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0xff
}
func (o *ADC_Type) SetCR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff00)|value<<8)
}
func (o *ADC_Type) GetCR_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff00) >> 8
}
func (o *ADC_Type) SetCR_BURST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCR_BURST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1e0000)|value<<17)
}
func (o *ADC_Type) GetCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1e0000) >> 17
}
func (o *ADC_Type) SetCR_PDN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetCR_PDN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00000)|value<<22)
}
func (o *ADC_Type) GetCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00000) >> 22
}
func (o *ADC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetCR_EDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetCR_EDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf0000000) >> 28
}

// ADC.GDR: A/D Global Data Register. This register contains the ADC's DONE bit and the result of the most recent A/D conversion.
func (o *ADC_Type) SetGDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetGDR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.GDR.Reg) & 0xf
}
func (o *ADC_Type) SetGDR_RESULT(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetGDR_RESULT() uint32 {
	return (volatile.LoadUint32(&o.GDR.Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetGDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0xff0000)|value<<16)
}
func (o *ADC_Type) GetGDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.GDR.Reg) & 0xff0000) >> 16
}
func (o *ADC_Type) SetGDR_CHN(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetGDR_CHN() uint32 {
	return (volatile.LoadUint32(&o.GDR.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetGDR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0x38000000)|value<<27)
}
func (o *ADC_Type) GetGDR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.GDR.Reg) & 0x38000000) >> 27
}
func (o *ADC_Type) SetGDR_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetGDR_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.GDR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetGDR_DONE(value uint32) {
	volatile.StoreUint32(&o.GDR.Reg, volatile.LoadUint32(&o.GDR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetGDR_DONE() uint32 {
	return (volatile.LoadUint32(&o.GDR.Reg) & 0x80000000) >> 31
}

// ADC.INTEN: A/D Interrupt Enable Register. This register contains enable bits that allow the DONE flag of each A/D channel to be included or excluded from contributing to the generation of an A/D interrupt.
func (o *ADC_Type) SetINTEN_ADINTEN0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTEN_ADINTEN0() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *ADC_Type) SetINTEN_ADINTEN1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetINTEN_ADINTEN1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetINTEN_ADINTEN2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetINTEN_ADINTEN2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetINTEN_ADINTEN3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetINTEN_ADINTEN3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetINTEN_ADINTEN4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetINTEN_ADINTEN4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetINTEN_ADINTEN5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetINTEN_ADINTEN5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetINTEN_ADINTEN6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetINTEN_ADINTEN6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetINTEN_ADINTEN7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetINTEN_ADINTEN7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetINTEN_ADGINTEN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetINTEN_ADGINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0xfffffe00)|value<<9)
}
func (o *ADC_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0xfffffe00) >> 9
}

// ADC.DR: A/D Channel 0 Data Register. This register contains the result of the most recent conversion completed on channel 0.
func (o *ADC_Type) SetDR_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.DR[idx].Reg, volatile.LoadUint32(&o.DR[idx].Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetDR_RESERVED(idx int) uint32 {
	return volatile.LoadUint32(&o.DR[idx].Reg) & 0xf
}
func (o *ADC_Type) SetDR_RESULT(idx int, value uint32) {
	volatile.StoreUint32(&o.DR[idx].Reg, volatile.LoadUint32(&o.DR[idx].Reg)&^(0xfff0)|value<<4)
}
func (o *ADC_Type) GetDR_RESULT(idx int) uint32 {
	return (volatile.LoadUint32(&o.DR[idx].Reg) & 0xfff0) >> 4
}
func (o *ADC_Type) SetDR_RESERVED(idx int, value uint32) {
	volatile.StoreUint32(&o.DR[idx].Reg, volatile.LoadUint32(&o.DR[idx].Reg)&^(0x3fff0000)|value<<16)
}
func (o *ADC_Type) GetDR_RESERVED(idx int) uint32 {
	return (volatile.LoadUint32(&o.DR[idx].Reg) & 0x3fff0000) >> 16
}
func (o *ADC_Type) SetDR_OVERRUN(idx int, value uint32) {
	volatile.StoreUint32(&o.DR[idx].Reg, volatile.LoadUint32(&o.DR[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetDR_OVERRUN(idx int) uint32 {
	return (volatile.LoadUint32(&o.DR[idx].Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetDR_DONE(idx int, value uint32) {
	volatile.StoreUint32(&o.DR[idx].Reg, volatile.LoadUint32(&o.DR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetDR_DONE(idx int) uint32 {
	return (volatile.LoadUint32(&o.DR[idx].Reg) & 0x80000000) >> 31
}

// ADC.STAT: A/D Status Register. This register contains DONE and OVERRUN flags for all of the A/D channels, as well as the A/D interrupt/DMA flag.
func (o *ADC_Type) SetSTAT_DONE0(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetSTAT_DONE0() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x1
}
func (o *ADC_Type) SetSTAT_DONE1(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetSTAT_DONE1() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetSTAT_DONE2(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetSTAT_DONE2() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetSTAT_DONE3(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetSTAT_DONE3() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetSTAT_DONE4(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetSTAT_DONE4() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetSTAT_DONE5(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSTAT_DONE5() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSTAT_DONE6(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetSTAT_DONE6() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetSTAT_DONE7(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSTAT_DONE7() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetSTAT_OVERRUN0(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetSTAT_OVERRUN0() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetSTAT_OVERRUN1(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetSTAT_OVERRUN1() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetSTAT_OVERRUN2(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetSTAT_OVERRUN2() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetSTAT_OVERRUN3(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetSTAT_OVERRUN3() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetSTAT_OVERRUN4(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetSTAT_OVERRUN4() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetSTAT_OVERRUN5(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetSTAT_OVERRUN5() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetSTAT_OVERRUN6(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetSTAT_OVERRUN6() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetSTAT_OVERRUN7(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetSTAT_OVERRUN7() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetSTAT_ADINT(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetSTAT_ADINT() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xfffe0000)|value<<17)
}
func (o *ADC_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xfffe0000) >> 17
}

// ADC.TRM: ADC trim register.
func (o *ADC_Type) SetTRM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TRM.Reg, volatile.LoadUint32(&o.TRM.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetTRM_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TRM.Reg) & 0xf
}
func (o *ADC_Type) SetTRM_ADCOFFS(value uint32) {
	volatile.StoreUint32(&o.TRM.Reg, volatile.LoadUint32(&o.TRM.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetTRM_ADCOFFS() uint32 {
	return (volatile.LoadUint32(&o.TRM.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetTRM_TRIM(value uint32) {
	volatile.StoreUint32(&o.TRM.Reg, volatile.LoadUint32(&o.TRM.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetTRM_TRIM() uint32 {
	return (volatile.LoadUint32(&o.TRM.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetTRM_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TRM.Reg, volatile.LoadUint32(&o.TRM.Reg)&^(0xfffff000)|value<<12)
}
func (o *ADC_Type) GetTRM_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TRM.Reg) & 0xfffff000) >> 12
}

// CAN acceptance filter RAM
type CANAFRAM_Type struct {
	MASK [512]volatile.Register32 // 0x0
}

// CANAFRAM.MASK: CAN AF ram access register
func (o *CANAFRAM_Type) SetMASK(idx int, value uint32) {
	volatile.StoreUint32(&o.MASK[idx].Reg, value)
}
func (o *CANAFRAM_Type) GetMASK(idx int) uint32 {
	return volatile.LoadUint32(&o.MASK[idx].Reg)
}

// CAN controller acceptance filter
type CANAF_Type struct {
	AFMR       volatile.Register32 // 0x0
	SFF_SA     volatile.Register32 // 0x4
	SFF_GRP_SA volatile.Register32 // 0x8
	EFF_SA     volatile.Register32 // 0xC
	EFF_GRP_SA volatile.Register32 // 0x10
	ENDOFTABLE volatile.Register32 // 0x14
	LUTERRAD   volatile.Register32 // 0x18
	LUTERR     volatile.Register32 // 0x1C
	FCANIE     volatile.Register32 // 0x20
	FCANIC0    volatile.Register32 // 0x24
	FCANIC1    volatile.Register32 // 0x28
}

// CANAF.AFMR: Acceptance Filter Register
func (o *CANAF_Type) SetAFMR_ACCOFF(value uint32) {
	volatile.StoreUint32(&o.AFMR.Reg, volatile.LoadUint32(&o.AFMR.Reg)&^(0x1)|value)
}
func (o *CANAF_Type) GetAFMR_ACCOFF() uint32 {
	return volatile.LoadUint32(&o.AFMR.Reg) & 0x1
}
func (o *CANAF_Type) SetAFMR_ACCBP(value uint32) {
	volatile.StoreUint32(&o.AFMR.Reg, volatile.LoadUint32(&o.AFMR.Reg)&^(0x2)|value<<1)
}
func (o *CANAF_Type) GetAFMR_ACCBP() uint32 {
	return (volatile.LoadUint32(&o.AFMR.Reg) & 0x2) >> 1
}
func (o *CANAF_Type) SetAFMR_EFCAN(value uint32) {
	volatile.StoreUint32(&o.AFMR.Reg, volatile.LoadUint32(&o.AFMR.Reg)&^(0x4)|value<<2)
}
func (o *CANAF_Type) GetAFMR_EFCAN() uint32 {
	return (volatile.LoadUint32(&o.AFMR.Reg) & 0x4) >> 2
}
func (o *CANAF_Type) SetAFMR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.AFMR.Reg, volatile.LoadUint32(&o.AFMR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *CANAF_Type) GetAFMR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.AFMR.Reg) & 0xfffffff8) >> 3
}

// CANAF.SFF_SA: Standard Frame Individual Start Address Register
func (o *CANAF_Type) SetSFF_SA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SFF_SA.Reg, volatile.LoadUint32(&o.SFF_SA.Reg)&^(0x3)|value)
}
func (o *CANAF_Type) GetSFF_SA_RESERVED() uint32 {
	return volatile.LoadUint32(&o.SFF_SA.Reg) & 0x3
}
func (o *CANAF_Type) SetSFF_SA(value uint32) {
	volatile.StoreUint32(&o.SFF_SA.Reg, volatile.LoadUint32(&o.SFF_SA.Reg)&^(0x7fc)|value<<2)
}
func (o *CANAF_Type) GetSFF_SA() uint32 {
	return (volatile.LoadUint32(&o.SFF_SA.Reg) & 0x7fc) >> 2
}
func (o *CANAF_Type) SetSFF_SA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SFF_SA.Reg, volatile.LoadUint32(&o.SFF_SA.Reg)&^(0xfffff800)|value<<11)
}
func (o *CANAF_Type) GetSFF_SA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SFF_SA.Reg) & 0xfffff800) >> 11
}

// CANAF.SFF_GRP_SA: Standard Frame Group Start Address Register
func (o *CANAF_Type) SetSFF_GRP_SA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SFF_GRP_SA.Reg, volatile.LoadUint32(&o.SFF_GRP_SA.Reg)&^(0x3)|value)
}
func (o *CANAF_Type) GetSFF_GRP_SA_RESERVED() uint32 {
	return volatile.LoadUint32(&o.SFF_GRP_SA.Reg) & 0x3
}
func (o *CANAF_Type) SetSFF_GRP_SA(value uint32) {
	volatile.StoreUint32(&o.SFF_GRP_SA.Reg, volatile.LoadUint32(&o.SFF_GRP_SA.Reg)&^(0xffc)|value<<2)
}
func (o *CANAF_Type) GetSFF_GRP_SA() uint32 {
	return (volatile.LoadUint32(&o.SFF_GRP_SA.Reg) & 0xffc) >> 2
}
func (o *CANAF_Type) SetSFF_GRP_SA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SFF_GRP_SA.Reg, volatile.LoadUint32(&o.SFF_GRP_SA.Reg)&^(0xfffff000)|value<<12)
}
func (o *CANAF_Type) GetSFF_GRP_SA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SFF_GRP_SA.Reg) & 0xfffff000) >> 12
}

// CANAF.EFF_SA: Extended Frame Start Address Register
func (o *CANAF_Type) SetEFF_SA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EFF_SA.Reg, volatile.LoadUint32(&o.EFF_SA.Reg)&^(0x3)|value)
}
func (o *CANAF_Type) GetEFF_SA_RESERVED() uint32 {
	return volatile.LoadUint32(&o.EFF_SA.Reg) & 0x3
}
func (o *CANAF_Type) SetEFF_SA(value uint32) {
	volatile.StoreUint32(&o.EFF_SA.Reg, volatile.LoadUint32(&o.EFF_SA.Reg)&^(0x7fc)|value<<2)
}
func (o *CANAF_Type) GetEFF_SA() uint32 {
	return (volatile.LoadUint32(&o.EFF_SA.Reg) & 0x7fc) >> 2
}
func (o *CANAF_Type) SetEFF_SA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EFF_SA.Reg, volatile.LoadUint32(&o.EFF_SA.Reg)&^(0xfffff800)|value<<11)
}
func (o *CANAF_Type) GetEFF_SA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EFF_SA.Reg) & 0xfffff800) >> 11
}

// CANAF.EFF_GRP_SA: Extended Frame Group Start Address Register
func (o *CANAF_Type) SetEFF_GRP_SA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EFF_GRP_SA.Reg, volatile.LoadUint32(&o.EFF_GRP_SA.Reg)&^(0x3)|value)
}
func (o *CANAF_Type) GetEFF_GRP_SA_RESERVED() uint32 {
	return volatile.LoadUint32(&o.EFF_GRP_SA.Reg) & 0x3
}
func (o *CANAF_Type) SetEFF_GRP_SA(value uint32) {
	volatile.StoreUint32(&o.EFF_GRP_SA.Reg, volatile.LoadUint32(&o.EFF_GRP_SA.Reg)&^(0xffc)|value<<2)
}
func (o *CANAF_Type) GetEFF_GRP_SA() uint32 {
	return (volatile.LoadUint32(&o.EFF_GRP_SA.Reg) & 0xffc) >> 2
}
func (o *CANAF_Type) SetEFF_GRP_SA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EFF_GRP_SA.Reg, volatile.LoadUint32(&o.EFF_GRP_SA.Reg)&^(0xfffff000)|value<<12)
}
func (o *CANAF_Type) GetEFF_GRP_SA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EFF_GRP_SA.Reg) & 0xfffff000) >> 12
}

// CANAF.ENDOFTABLE: End of AF Tables register
func (o *CANAF_Type) SetENDOFTABLE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDOFTABLE.Reg, volatile.LoadUint32(&o.ENDOFTABLE.Reg)&^(0x3)|value)
}
func (o *CANAF_Type) GetENDOFTABLE_RESERVED() uint32 {
	return volatile.LoadUint32(&o.ENDOFTABLE.Reg) & 0x3
}
func (o *CANAF_Type) SetENDOFTABLE(value uint32) {
	volatile.StoreUint32(&o.ENDOFTABLE.Reg, volatile.LoadUint32(&o.ENDOFTABLE.Reg)&^(0xffc)|value<<2)
}
func (o *CANAF_Type) GetENDOFTABLE() uint32 {
	return (volatile.LoadUint32(&o.ENDOFTABLE.Reg) & 0xffc) >> 2
}
func (o *CANAF_Type) SetENDOFTABLE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENDOFTABLE.Reg, volatile.LoadUint32(&o.ENDOFTABLE.Reg)&^(0xfffff000)|value<<12)
}
func (o *CANAF_Type) GetENDOFTABLE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENDOFTABLE.Reg) & 0xfffff000) >> 12
}

// CANAF.LUTERRAD: LUT Error Address register
func (o *CANAF_Type) SetLUTERRAD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LUTERRAD.Reg, volatile.LoadUint32(&o.LUTERRAD.Reg)&^(0x3)|value)
}
func (o *CANAF_Type) GetLUTERRAD_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LUTERRAD.Reg) & 0x3
}
func (o *CANAF_Type) SetLUTERRAD(value uint32) {
	volatile.StoreUint32(&o.LUTERRAD.Reg, volatile.LoadUint32(&o.LUTERRAD.Reg)&^(0x7fc)|value<<2)
}
func (o *CANAF_Type) GetLUTERRAD() uint32 {
	return (volatile.LoadUint32(&o.LUTERRAD.Reg) & 0x7fc) >> 2
}
func (o *CANAF_Type) SetLUTERRAD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LUTERRAD.Reg, volatile.LoadUint32(&o.LUTERRAD.Reg)&^(0xfffff800)|value<<11)
}
func (o *CANAF_Type) GetLUTERRAD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LUTERRAD.Reg) & 0xfffff800) >> 11
}

// CANAF.LUTERR: LUT Error Register
func (o *CANAF_Type) SetLUTERR(value uint32) {
	volatile.StoreUint32(&o.LUTERR.Reg, volatile.LoadUint32(&o.LUTERR.Reg)&^(0x1)|value)
}
func (o *CANAF_Type) GetLUTERR() uint32 {
	return volatile.LoadUint32(&o.LUTERR.Reg) & 0x1
}
func (o *CANAF_Type) SetLUTERR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LUTERR.Reg, volatile.LoadUint32(&o.LUTERR.Reg)&^(0xfffffffe)|value<<1)
}
func (o *CANAF_Type) GetLUTERR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.LUTERR.Reg) & 0xfffffffe) >> 1
}

// CANAF.FCANIE: FullCAN interrupt enable register
func (o *CANAF_Type) SetFCANIE(value uint32) {
	volatile.StoreUint32(&o.FCANIE.Reg, volatile.LoadUint32(&o.FCANIE.Reg)&^(0x1)|value)
}
func (o *CANAF_Type) GetFCANIE() uint32 {
	return volatile.LoadUint32(&o.FCANIE.Reg) & 0x1
}
func (o *CANAF_Type) SetFCANIE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FCANIE.Reg, volatile.LoadUint32(&o.FCANIE.Reg)&^(0xfffffffe)|value<<1)
}
func (o *CANAF_Type) GetFCANIE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FCANIE.Reg) & 0xfffffffe) >> 1
}

// CANAF.FCANIC0: FullCAN interrupt and capture register0
func (o *CANAF_Type) SetFCANIC0(value uint32) {
	volatile.StoreUint32(&o.FCANIC0.Reg, value)
}
func (o *CANAF_Type) GetFCANIC0() uint32 {
	return volatile.LoadUint32(&o.FCANIC0.Reg)
}

// CANAF.FCANIC1: FullCAN interrupt and capture register1
func (o *CANAF_Type) SetFCANIC1(value uint32) {
	volatile.StoreUint32(&o.FCANIC1.Reg, value)
}
func (o *CANAF_Type) GetFCANIC1() uint32 {
	return volatile.LoadUint32(&o.FCANIC1.Reg)
}

// Central CAN controller
type CCAN_Type struct {
	TXSR volatile.Register32 // 0x0
	RXSR volatile.Register32 // 0x4
	MSR  volatile.Register32 // 0x8
}

// CCAN.TXSR: CAN Central Transmit Status Register
func (o *CCAN_Type) SetTXSR_TS1(value uint32) {
	volatile.StoreUint32(&o.TXSR.Reg, volatile.LoadUint32(&o.TXSR.Reg)&^(0x1)|value)
}
func (o *CCAN_Type) GetTXSR_TS1() uint32 {
	return volatile.LoadUint32(&o.TXSR.Reg) & 0x1
}
func (o *CCAN_Type) SetTXSR_TS2(value uint32) {
	volatile.StoreUint32(&o.TXSR.Reg, volatile.LoadUint32(&o.TXSR.Reg)&^(0x2)|value<<1)
}
func (o *CCAN_Type) GetTXSR_TS2() uint32 {
	return (volatile.LoadUint32(&o.TXSR.Reg) & 0x2) >> 1
}
func (o *CCAN_Type) SetTXSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXSR.Reg, volatile.LoadUint32(&o.TXSR.Reg)&^(0xfc)|value<<2)
}
func (o *CCAN_Type) GetTXSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXSR.Reg) & 0xfc) >> 2
}
func (o *CCAN_Type) SetTXSR_TBS1(value uint32) {
	volatile.StoreUint32(&o.TXSR.Reg, volatile.LoadUint32(&o.TXSR.Reg)&^(0x100)|value<<8)
}
func (o *CCAN_Type) GetTXSR_TBS1() uint32 {
	return (volatile.LoadUint32(&o.TXSR.Reg) & 0x100) >> 8
}
func (o *CCAN_Type) SetTXSR_TBS2(value uint32) {
	volatile.StoreUint32(&o.TXSR.Reg, volatile.LoadUint32(&o.TXSR.Reg)&^(0x200)|value<<9)
}
func (o *CCAN_Type) GetTXSR_TBS2() uint32 {
	return (volatile.LoadUint32(&o.TXSR.Reg) & 0x200) >> 9
}
func (o *CCAN_Type) SetTXSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXSR.Reg, volatile.LoadUint32(&o.TXSR.Reg)&^(0xfc00)|value<<10)
}
func (o *CCAN_Type) GetTXSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXSR.Reg) & 0xfc00) >> 10
}
func (o *CCAN_Type) SetTXSR_TCS1(value uint32) {
	volatile.StoreUint32(&o.TXSR.Reg, volatile.LoadUint32(&o.TXSR.Reg)&^(0x10000)|value<<16)
}
func (o *CCAN_Type) GetTXSR_TCS1() uint32 {
	return (volatile.LoadUint32(&o.TXSR.Reg) & 0x10000) >> 16
}
func (o *CCAN_Type) SetTXSR_TCS2(value uint32) {
	volatile.StoreUint32(&o.TXSR.Reg, volatile.LoadUint32(&o.TXSR.Reg)&^(0x20000)|value<<17)
}
func (o *CCAN_Type) GetTXSR_TCS2() uint32 {
	return (volatile.LoadUint32(&o.TXSR.Reg) & 0x20000) >> 17
}
func (o *CCAN_Type) SetTXSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXSR.Reg, volatile.LoadUint32(&o.TXSR.Reg)&^(0xfffc0000)|value<<18)
}
func (o *CCAN_Type) GetTXSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXSR.Reg) & 0xfffc0000) >> 18
}

// CCAN.RXSR: CAN Central Receive Status Register
func (o *CCAN_Type) SetRXSR_RS1(value uint32) {
	volatile.StoreUint32(&o.RXSR.Reg, volatile.LoadUint32(&o.RXSR.Reg)&^(0x1)|value)
}
func (o *CCAN_Type) GetRXSR_RS1() uint32 {
	return volatile.LoadUint32(&o.RXSR.Reg) & 0x1
}
func (o *CCAN_Type) SetRXSR_RS2(value uint32) {
	volatile.StoreUint32(&o.RXSR.Reg, volatile.LoadUint32(&o.RXSR.Reg)&^(0x2)|value<<1)
}
func (o *CCAN_Type) GetRXSR_RS2() uint32 {
	return (volatile.LoadUint32(&o.RXSR.Reg) & 0x2) >> 1
}
func (o *CCAN_Type) SetRXSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXSR.Reg, volatile.LoadUint32(&o.RXSR.Reg)&^(0xfc)|value<<2)
}
func (o *CCAN_Type) GetRXSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXSR.Reg) & 0xfc) >> 2
}
func (o *CCAN_Type) SetRXSR_RB1(value uint32) {
	volatile.StoreUint32(&o.RXSR.Reg, volatile.LoadUint32(&o.RXSR.Reg)&^(0x100)|value<<8)
}
func (o *CCAN_Type) GetRXSR_RB1() uint32 {
	return (volatile.LoadUint32(&o.RXSR.Reg) & 0x100) >> 8
}
func (o *CCAN_Type) SetRXSR_RB2(value uint32) {
	volatile.StoreUint32(&o.RXSR.Reg, volatile.LoadUint32(&o.RXSR.Reg)&^(0x200)|value<<9)
}
func (o *CCAN_Type) GetRXSR_RB2() uint32 {
	return (volatile.LoadUint32(&o.RXSR.Reg) & 0x200) >> 9
}
func (o *CCAN_Type) SetRXSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXSR.Reg, volatile.LoadUint32(&o.RXSR.Reg)&^(0xfc00)|value<<10)
}
func (o *CCAN_Type) GetRXSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXSR.Reg) & 0xfc00) >> 10
}
func (o *CCAN_Type) SetRXSR_DOS1(value uint32) {
	volatile.StoreUint32(&o.RXSR.Reg, volatile.LoadUint32(&o.RXSR.Reg)&^(0x10000)|value<<16)
}
func (o *CCAN_Type) GetRXSR_DOS1() uint32 {
	return (volatile.LoadUint32(&o.RXSR.Reg) & 0x10000) >> 16
}
func (o *CCAN_Type) SetRXSR_DOS2(value uint32) {
	volatile.StoreUint32(&o.RXSR.Reg, volatile.LoadUint32(&o.RXSR.Reg)&^(0x20000)|value<<17)
}
func (o *CCAN_Type) GetRXSR_DOS2() uint32 {
	return (volatile.LoadUint32(&o.RXSR.Reg) & 0x20000) >> 17
}
func (o *CCAN_Type) SetRXSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXSR.Reg, volatile.LoadUint32(&o.RXSR.Reg)&^(0xfffc0000)|value<<18)
}
func (o *CCAN_Type) GetRXSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXSR.Reg) & 0xfffc0000) >> 18
}

// CCAN.MSR: CAN Central Miscellaneous Register
func (o *CCAN_Type) SetMSR_E1(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x1)|value)
}
func (o *CCAN_Type) GetMSR_E1() uint32 {
	return volatile.LoadUint32(&o.MSR.Reg) & 0x1
}
func (o *CCAN_Type) SetMSR_E2(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x2)|value<<1)
}
func (o *CCAN_Type) GetMSR_E2() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x2) >> 1
}
func (o *CCAN_Type) SetMSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0xfc)|value<<2)
}
func (o *CCAN_Type) GetMSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0xfc) >> 2
}
func (o *CCAN_Type) SetMSR_BS1(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x100)|value<<8)
}
func (o *CCAN_Type) GetMSR_BS1() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x100) >> 8
}
func (o *CCAN_Type) SetMSR_BS2(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x200)|value<<9)
}
func (o *CCAN_Type) GetMSR_BS2() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x200) >> 9
}
func (o *CCAN_Type) SetMSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *CCAN_Type) GetMSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0xfffffc00) >> 10
}

// CAN1 controller
type CAN_Type struct {
	MOD  volatile.Register32 // 0x0
	CMR  volatile.Register32 // 0x4
	GSR  volatile.Register32 // 0x8
	ICR  volatile.Register32 // 0xC
	IER  volatile.Register32 // 0x10
	BTR  volatile.Register32 // 0x14
	EWL  volatile.Register32 // 0x18
	SR   volatile.Register32 // 0x1C
	RFS  volatile.Register32 // 0x20
	RID  volatile.Register32 // 0x24
	RDA  volatile.Register32 // 0x28
	RDB  volatile.Register32 // 0x2C
	TFI1 volatile.Register32 // 0x30
	TID1 volatile.Register32 // 0x34
	TDA1 volatile.Register32 // 0x38
	TDB1 volatile.Register32 // 0x3C
	TFI2 volatile.Register32 // 0x40
	TID2 volatile.Register32 // 0x44
	TDA2 volatile.Register32 // 0x48
	TDB2 volatile.Register32 // 0x4C
	TFI3 volatile.Register32 // 0x50
	TID3 volatile.Register32 // 0x54
	TDA3 volatile.Register32 // 0x58
	TDB3 volatile.Register32 // 0x5C
}

// CAN.MOD: Controls the operating mode of the CAN Controller.
func (o *CAN_Type) SetMOD_RM(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMOD_RM() uint32 {
	return volatile.LoadUint32(&o.MOD.Reg) & 0x1
}
func (o *CAN_Type) SetMOD_LOM(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMOD_LOM() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMOD_STM(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMOD_STM() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMOD_TPM(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMOD_TPM() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMOD_SM(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMOD_SM() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMOD_RPM(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetMOD_RPM() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetMOD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetMOD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetMOD_TM(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetMOD_TM() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetMOD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MOD.Reg, volatile.LoadUint32(&o.MOD.Reg)&^(0xffffff00)|value<<8)
}
func (o *CAN_Type) GetMOD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MOD.Reg) & 0xffffff00) >> 8
}

// CAN.CMR: Command bits that affect the state of the CAN Controller
func (o *CAN_Type) SetCMR_TR(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetCMR_TR() uint32 {
	return volatile.LoadUint32(&o.CMR.Reg) & 0x1
}
func (o *CAN_Type) SetCMR_AT(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetCMR_AT() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetCMR_RRB(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetCMR_RRB() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetCMR_CDO(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetCMR_CDO() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetCMR_SRR(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetCMR_SRR() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetCMR_STB1(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetCMR_STB1() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetCMR_STB2(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetCMR_STB2() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetCMR_STB3(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetCMR_STB3() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetCMR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMR.Reg, volatile.LoadUint32(&o.CMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *CAN_Type) GetCMR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMR.Reg) & 0xffffff00) >> 8
}

// CAN.GSR: Global Controller Status and Error Counters. The error counters can only be written when RM in CANMOD is 1.
func (o *CAN_Type) SetGSR_RBS(value uint32) {
	volatile.StoreUint32(&o.GSR.Reg, volatile.LoadUint32(&o.GSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetGSR_RBS() uint32 {
	return volatile.LoadUint32(&o.GSR.Reg) & 0x1
}
func (o *CAN_Type) SetGSR_DOS(value uint32) {
	volatile.StoreUint32(&o.GSR.Reg, volatile.LoadUint32(&o.GSR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetGSR_DOS() uint32 {
	return (volatile.LoadUint32(&o.GSR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetGSR_TBS(value uint32) {
	volatile.StoreUint32(&o.GSR.Reg, volatile.LoadUint32(&o.GSR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetGSR_TBS() uint32 {
	return (volatile.LoadUint32(&o.GSR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetGSR_TCS(value uint32) {
	volatile.StoreUint32(&o.GSR.Reg, volatile.LoadUint32(&o.GSR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetGSR_TCS() uint32 {
	return (volatile.LoadUint32(&o.GSR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetGSR_RS(value uint32) {
	volatile.StoreUint32(&o.GSR.Reg, volatile.LoadUint32(&o.GSR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetGSR_RS() uint32 {
	return (volatile.LoadUint32(&o.GSR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetGSR_TS(value uint32) {
	volatile.StoreUint32(&o.GSR.Reg, volatile.LoadUint32(&o.GSR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetGSR_TS() uint32 {
	return (volatile.LoadUint32(&o.GSR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetGSR_ES(value uint32) {
	volatile.StoreUint32(&o.GSR.Reg, volatile.LoadUint32(&o.GSR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetGSR_ES() uint32 {
	return (volatile.LoadUint32(&o.GSR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetGSR_BS(value uint32) {
	volatile.StoreUint32(&o.GSR.Reg, volatile.LoadUint32(&o.GSR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetGSR_BS() uint32 {
	return (volatile.LoadUint32(&o.GSR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetGSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.GSR.Reg, volatile.LoadUint32(&o.GSR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_Type) GetGSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.GSR.Reg) & 0xff00) >> 8
}
func (o *CAN_Type) SetGSR_RXERR(value uint32) {
	volatile.StoreUint32(&o.GSR.Reg, volatile.LoadUint32(&o.GSR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetGSR_RXERR() uint32 {
	return (volatile.LoadUint32(&o.GSR.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetGSR_TXERR(value uint32) {
	volatile.StoreUint32(&o.GSR.Reg, volatile.LoadUint32(&o.GSR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetGSR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.GSR.Reg) & 0xff000000) >> 24
}

// CAN.ICR: Interrupt status, Arbitration Lost Capture, Error Code Capture
func (o *CAN_Type) SetICR_RI(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetICR_RI() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *CAN_Type) SetICR_TI1(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetICR_TI1() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetICR_EI(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetICR_EI() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetICR_DOI(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetICR_DOI() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetICR_WUI(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetICR_WUI() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetICR_EPI(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetICR_EPI() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetICR_ALI(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetICR_ALI() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetICR_BEI(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetICR_BEI() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetICR_IDI(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetICR_IDI() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetICR_TI2(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetICR_TI2() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetICR_TI3(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetICR_TI3() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetICR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xf800)|value<<11)
}
func (o *CAN_Type) GetICR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xf800) >> 11
}
func (o *CAN_Type) SetICR_ERRBIT4_0(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1f0000)|value<<16)
}
func (o *CAN_Type) GetICR_ERRBIT4_0() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1f0000) >> 16
}
func (o *CAN_Type) SetICR_ERRDIR(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetICR_ERRDIR() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetICR_ERRC1_0(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xc00000)|value<<22)
}
func (o *CAN_Type) GetICR_ERRC1_0() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xc00000) >> 22
}
func (o *CAN_Type) SetICR_ALCBIT(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetICR_ALCBIT() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0xff000000) >> 24
}

// CAN.IER: Interrupt Enable
func (o *CAN_Type) SetIER_RIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetIER_RIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *CAN_Type) SetIER_TIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetIER_TIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetIER_EIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetIER_EIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetIER_DOIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetIER_DOIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetIER_WUIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetIER_WUIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetIER_EPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetIER_EPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetIER_ALIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetIER_ALIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetIER_BEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetIER_BEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetIER_IDIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetIER_IDIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetIER_TIE2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetIER_TIE2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetIER_TIE3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetIER_TIE3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetIER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0xfffff800)|value<<11)
}
func (o *CAN_Type) GetIER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0xfffff800) >> 11
}

// CAN.BTR: Bus Timing. Can only be written when RM in CANMOD is 1.
func (o *CAN_Type) SetBTR_BRP(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3ff)|value)
}
func (o *CAN_Type) GetBTR_BRP() uint32 {
	return volatile.LoadUint32(&o.BTR.Reg) & 0x3ff
}
func (o *CAN_Type) SetBTR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3c00)|value<<10)
}
func (o *CAN_Type) GetBTR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x3c00) >> 10
}
func (o *CAN_Type) SetBTR_SJW(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0xc000)|value<<14)
}
func (o *CAN_Type) GetBTR_SJW() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0xc000) >> 14
}
func (o *CAN_Type) SetBTR_TESG1(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetBTR_TESG1() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetBTR_TESG2(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x700000)|value<<20)
}
func (o *CAN_Type) GetBTR_TESG2() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x700000) >> 20
}
func (o *CAN_Type) SetBTR_SAM(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetBTR_SAM() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetBTR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetBTR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0xff000000) >> 24
}

// CAN.EWL: Error Warning Limit. Can only be written when RM in CANMOD is 1.
func (o *CAN_Type) SetEWL(value uint32) {
	volatile.StoreUint32(&o.EWL.Reg, volatile.LoadUint32(&o.EWL.Reg)&^(0xff)|value)
}
func (o *CAN_Type) GetEWL() uint32 {
	return volatile.LoadUint32(&o.EWL.Reg) & 0xff
}
func (o *CAN_Type) SetEWL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EWL.Reg, volatile.LoadUint32(&o.EWL.Reg)&^(0xffffff00)|value<<8)
}
func (o *CAN_Type) GetEWL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EWL.Reg) & 0xffffff00) >> 8
}

// CAN.SR: Status Register
func (o *CAN_Type) SetSR_RBS_1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetSR_RBS_1() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *CAN_Type) SetSR_DOS_1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetSR_DOS_1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetSR_TBS1_1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetSR_TBS1_1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetSR_TCS1_1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetSR_TCS1_1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetSR_RS_1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetSR_RS_1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetSR_TS1_1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetSR_TS1_1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetSR_ES_1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetSR_ES_1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetSR_BS_1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetSR_BS_1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetSR_RBS_2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetSR_RBS_2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetSR_DOS_2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetSR_DOS_2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetSR_TBS2_2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetSR_TBS2_2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetSR_TCS2_2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetSR_TCS2_2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetSR_RS_2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetSR_RS_2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetSR_TS2_2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetSR_TS2_2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetSR_ES_2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetSR_ES_2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetSR_BS_2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetSR_BS_2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetSR_RBS_3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetSR_RBS_3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetSR_DOS_3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetSR_DOS_3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetSR_TBS3_3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetSR_TBS3_3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetSR_TCS3_3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetSR_TCS3_3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetSR_RS_3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetSR_RS_3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetSR_TS3_3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetSR_TS3_3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetSR_ES_3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetSR_ES_3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetSR_BS_3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetSR_BS_3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetSR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetSR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0xff000000) >> 24
}

// CAN.RFS: Receive frame status. Can only be written when RM in CANMOD is 1.
func (o *CAN_Type) SetRFS_IDINDEX(value uint32) {
	volatile.StoreUint32(&o.RFS.Reg, volatile.LoadUint32(&o.RFS.Reg)&^(0x3ff)|value)
}
func (o *CAN_Type) GetRFS_IDINDEX() uint32 {
	return volatile.LoadUint32(&o.RFS.Reg) & 0x3ff
}
func (o *CAN_Type) SetRFS_BP(value uint32) {
	volatile.StoreUint32(&o.RFS.Reg, volatile.LoadUint32(&o.RFS.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetRFS_BP() uint32 {
	return (volatile.LoadUint32(&o.RFS.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetRFS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RFS.Reg, volatile.LoadUint32(&o.RFS.Reg)&^(0xf800)|value<<11)
}
func (o *CAN_Type) GetRFS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RFS.Reg) & 0xf800) >> 11
}
func (o *CAN_Type) SetRFS_DLC(value uint32) {
	volatile.StoreUint32(&o.RFS.Reg, volatile.LoadUint32(&o.RFS.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetRFS_DLC() uint32 {
	return (volatile.LoadUint32(&o.RFS.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetRFS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RFS.Reg, volatile.LoadUint32(&o.RFS.Reg)&^(0x3ff00000)|value<<20)
}
func (o *CAN_Type) GetRFS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RFS.Reg) & 0x3ff00000) >> 20
}
func (o *CAN_Type) SetRFS_RTR(value uint32) {
	volatile.StoreUint32(&o.RFS.Reg, volatile.LoadUint32(&o.RFS.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetRFS_RTR() uint32 {
	return (volatile.LoadUint32(&o.RFS.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetRFS_FF(value uint32) {
	volatile.StoreUint32(&o.RFS.Reg, volatile.LoadUint32(&o.RFS.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetRFS_FF() uint32 {
	return (volatile.LoadUint32(&o.RFS.Reg) & 0x80000000) >> 31
}

// CAN.RID: Received Identifier. Can only be written when RM in CANMOD is 1.
func (o *CAN_Type) SetRID_ID(value uint32) {
	volatile.StoreUint32(&o.RID.Reg, volatile.LoadUint32(&o.RID.Reg)&^(0x7ff)|value)
}
func (o *CAN_Type) GetRID_ID() uint32 {
	return volatile.LoadUint32(&o.RID.Reg) & 0x7ff
}
func (o *CAN_Type) SetRID_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RID.Reg, volatile.LoadUint32(&o.RID.Reg)&^(0xfffff800)|value<<11)
}
func (o *CAN_Type) GetRID_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RID.Reg) & 0xfffff800) >> 11
}

// CAN.RDA: Received data bytes 1-4. Can only be written when RM in CANMOD is 1.
func (o *CAN_Type) SetRDA_DATA1(value uint32) {
	volatile.StoreUint32(&o.RDA.Reg, volatile.LoadUint32(&o.RDA.Reg)&^(0xff)|value)
}
func (o *CAN_Type) GetRDA_DATA1() uint32 {
	return volatile.LoadUint32(&o.RDA.Reg) & 0xff
}
func (o *CAN_Type) SetRDA_DATA2(value uint32) {
	volatile.StoreUint32(&o.RDA.Reg, volatile.LoadUint32(&o.RDA.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_Type) GetRDA_DATA2() uint32 {
	return (volatile.LoadUint32(&o.RDA.Reg) & 0xff00) >> 8
}
func (o *CAN_Type) SetRDA_DATA3(value uint32) {
	volatile.StoreUint32(&o.RDA.Reg, volatile.LoadUint32(&o.RDA.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetRDA_DATA3() uint32 {
	return (volatile.LoadUint32(&o.RDA.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetRDA_DATA4(value uint32) {
	volatile.StoreUint32(&o.RDA.Reg, volatile.LoadUint32(&o.RDA.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetRDA_DATA4() uint32 {
	return (volatile.LoadUint32(&o.RDA.Reg) & 0xff000000) >> 24
}

// CAN.RDB: Received data bytes 5-8. Can only be written when RM in CANMOD is 1.
func (o *CAN_Type) SetRDB_DATA5(value uint32) {
	volatile.StoreUint32(&o.RDB.Reg, volatile.LoadUint32(&o.RDB.Reg)&^(0xff)|value)
}
func (o *CAN_Type) GetRDB_DATA5() uint32 {
	return volatile.LoadUint32(&o.RDB.Reg) & 0xff
}
func (o *CAN_Type) SetRDB_DATA6(value uint32) {
	volatile.StoreUint32(&o.RDB.Reg, volatile.LoadUint32(&o.RDB.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_Type) GetRDB_DATA6() uint32 {
	return (volatile.LoadUint32(&o.RDB.Reg) & 0xff00) >> 8
}
func (o *CAN_Type) SetRDB_DATA7(value uint32) {
	volatile.StoreUint32(&o.RDB.Reg, volatile.LoadUint32(&o.RDB.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetRDB_DATA7() uint32 {
	return (volatile.LoadUint32(&o.RDB.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetRDB_DATA8(value uint32) {
	volatile.StoreUint32(&o.RDB.Reg, volatile.LoadUint32(&o.RDB.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetRDB_DATA8() uint32 {
	return (volatile.LoadUint32(&o.RDB.Reg) & 0xff000000) >> 24
}

// CAN.TFI1: Transmit frame info (Tx Buffer )
func (o *CAN_Type) SetTFI1_PRIO(value uint32) {
	volatile.StoreUint32(&o.TFI1.Reg, volatile.LoadUint32(&o.TFI1.Reg)&^(0xff)|value)
}
func (o *CAN_Type) GetTFI1_PRIO() uint32 {
	return volatile.LoadUint32(&o.TFI1.Reg) & 0xff
}
func (o *CAN_Type) SetTFI1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TFI1.Reg, volatile.LoadUint32(&o.TFI1.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_Type) GetTFI1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TFI1.Reg) & 0xff00) >> 8
}
func (o *CAN_Type) SetTFI1_DLC(value uint32) {
	volatile.StoreUint32(&o.TFI1.Reg, volatile.LoadUint32(&o.TFI1.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetTFI1_DLC() uint32 {
	return (volatile.LoadUint32(&o.TFI1.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetTFI1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TFI1.Reg, volatile.LoadUint32(&o.TFI1.Reg)&^(0x3ff00000)|value<<20)
}
func (o *CAN_Type) GetTFI1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TFI1.Reg) & 0x3ff00000) >> 20
}
func (o *CAN_Type) SetTFI1_RTR(value uint32) {
	volatile.StoreUint32(&o.TFI1.Reg, volatile.LoadUint32(&o.TFI1.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetTFI1_RTR() uint32 {
	return (volatile.LoadUint32(&o.TFI1.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetTFI1_FF(value uint32) {
	volatile.StoreUint32(&o.TFI1.Reg, volatile.LoadUint32(&o.TFI1.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetTFI1_FF() uint32 {
	return (volatile.LoadUint32(&o.TFI1.Reg) & 0x80000000) >> 31
}

// CAN.TID1: Transmit Identifier (Tx Buffer)
func (o *CAN_Type) SetTID1_ID(value uint32) {
	volatile.StoreUint32(&o.TID1.Reg, volatile.LoadUint32(&o.TID1.Reg)&^(0x7ff)|value)
}
func (o *CAN_Type) GetTID1_ID() uint32 {
	return volatile.LoadUint32(&o.TID1.Reg) & 0x7ff
}
func (o *CAN_Type) SetTID1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TID1.Reg, volatile.LoadUint32(&o.TID1.Reg)&^(0xfffff800)|value<<11)
}
func (o *CAN_Type) GetTID1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TID1.Reg) & 0xfffff800) >> 11
}

// CAN.TDA1: Transmit data bytes 1-4 (Tx Buffer)
func (o *CAN_Type) SetTDA1_DATA1(value uint32) {
	volatile.StoreUint32(&o.TDA1.Reg, volatile.LoadUint32(&o.TDA1.Reg)&^(0xff)|value)
}
func (o *CAN_Type) GetTDA1_DATA1() uint32 {
	return volatile.LoadUint32(&o.TDA1.Reg) & 0xff
}
func (o *CAN_Type) SetTDA1_DATA2(value uint32) {
	volatile.StoreUint32(&o.TDA1.Reg, volatile.LoadUint32(&o.TDA1.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_Type) GetTDA1_DATA2() uint32 {
	return (volatile.LoadUint32(&o.TDA1.Reg) & 0xff00) >> 8
}
func (o *CAN_Type) SetTDA1_DATA3(value uint32) {
	volatile.StoreUint32(&o.TDA1.Reg, volatile.LoadUint32(&o.TDA1.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetTDA1_DATA3() uint32 {
	return (volatile.LoadUint32(&o.TDA1.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetTDA1_DATA4(value uint32) {
	volatile.StoreUint32(&o.TDA1.Reg, volatile.LoadUint32(&o.TDA1.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetTDA1_DATA4() uint32 {
	return (volatile.LoadUint32(&o.TDA1.Reg) & 0xff000000) >> 24
}

// CAN.TDB1: Transmit data bytes 5-8 (Tx Buffer )
func (o *CAN_Type) SetTDB1_DATA5(value uint32) {
	volatile.StoreUint32(&o.TDB1.Reg, volatile.LoadUint32(&o.TDB1.Reg)&^(0xff)|value)
}
func (o *CAN_Type) GetTDB1_DATA5() uint32 {
	return volatile.LoadUint32(&o.TDB1.Reg) & 0xff
}
func (o *CAN_Type) SetTDB1_DATA6(value uint32) {
	volatile.StoreUint32(&o.TDB1.Reg, volatile.LoadUint32(&o.TDB1.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_Type) GetTDB1_DATA6() uint32 {
	return (volatile.LoadUint32(&o.TDB1.Reg) & 0xff00) >> 8
}
func (o *CAN_Type) SetTDB1_DATA7(value uint32) {
	volatile.StoreUint32(&o.TDB1.Reg, volatile.LoadUint32(&o.TDB1.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetTDB1_DATA7() uint32 {
	return (volatile.LoadUint32(&o.TDB1.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetTDB1_DATA8(value uint32) {
	volatile.StoreUint32(&o.TDB1.Reg, volatile.LoadUint32(&o.TDB1.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetTDB1_DATA8() uint32 {
	return (volatile.LoadUint32(&o.TDB1.Reg) & 0xff000000) >> 24
}

// CAN.TFI2: Transmit frame info (Tx Buffer )
func (o *CAN_Type) SetTFI2_PRIO(value uint32) {
	volatile.StoreUint32(&o.TFI2.Reg, volatile.LoadUint32(&o.TFI2.Reg)&^(0xff)|value)
}
func (o *CAN_Type) GetTFI2_PRIO() uint32 {
	return volatile.LoadUint32(&o.TFI2.Reg) & 0xff
}
func (o *CAN_Type) SetTFI2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TFI2.Reg, volatile.LoadUint32(&o.TFI2.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_Type) GetTFI2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TFI2.Reg) & 0xff00) >> 8
}
func (o *CAN_Type) SetTFI2_DLC(value uint32) {
	volatile.StoreUint32(&o.TFI2.Reg, volatile.LoadUint32(&o.TFI2.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetTFI2_DLC() uint32 {
	return (volatile.LoadUint32(&o.TFI2.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetTFI2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TFI2.Reg, volatile.LoadUint32(&o.TFI2.Reg)&^(0x3ff00000)|value<<20)
}
func (o *CAN_Type) GetTFI2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TFI2.Reg) & 0x3ff00000) >> 20
}
func (o *CAN_Type) SetTFI2_RTR(value uint32) {
	volatile.StoreUint32(&o.TFI2.Reg, volatile.LoadUint32(&o.TFI2.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetTFI2_RTR() uint32 {
	return (volatile.LoadUint32(&o.TFI2.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetTFI2_FF(value uint32) {
	volatile.StoreUint32(&o.TFI2.Reg, volatile.LoadUint32(&o.TFI2.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetTFI2_FF() uint32 {
	return (volatile.LoadUint32(&o.TFI2.Reg) & 0x80000000) >> 31
}

// CAN.TID2: Transmit Identifier (Tx Buffer)
func (o *CAN_Type) SetTID2_ID(value uint32) {
	volatile.StoreUint32(&o.TID2.Reg, volatile.LoadUint32(&o.TID2.Reg)&^(0x7ff)|value)
}
func (o *CAN_Type) GetTID2_ID() uint32 {
	return volatile.LoadUint32(&o.TID2.Reg) & 0x7ff
}
func (o *CAN_Type) SetTID2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TID2.Reg, volatile.LoadUint32(&o.TID2.Reg)&^(0xfffff800)|value<<11)
}
func (o *CAN_Type) GetTID2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TID2.Reg) & 0xfffff800) >> 11
}

// CAN.TDA2: Transmit data bytes 1-4 (Tx Buffer)
func (o *CAN_Type) SetTDA2_DATA1(value uint32) {
	volatile.StoreUint32(&o.TDA2.Reg, volatile.LoadUint32(&o.TDA2.Reg)&^(0xff)|value)
}
func (o *CAN_Type) GetTDA2_DATA1() uint32 {
	return volatile.LoadUint32(&o.TDA2.Reg) & 0xff
}
func (o *CAN_Type) SetTDA2_DATA2(value uint32) {
	volatile.StoreUint32(&o.TDA2.Reg, volatile.LoadUint32(&o.TDA2.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_Type) GetTDA2_DATA2() uint32 {
	return (volatile.LoadUint32(&o.TDA2.Reg) & 0xff00) >> 8
}
func (o *CAN_Type) SetTDA2_DATA3(value uint32) {
	volatile.StoreUint32(&o.TDA2.Reg, volatile.LoadUint32(&o.TDA2.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetTDA2_DATA3() uint32 {
	return (volatile.LoadUint32(&o.TDA2.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetTDA2_DATA4(value uint32) {
	volatile.StoreUint32(&o.TDA2.Reg, volatile.LoadUint32(&o.TDA2.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetTDA2_DATA4() uint32 {
	return (volatile.LoadUint32(&o.TDA2.Reg) & 0xff000000) >> 24
}

// CAN.TDB2: Transmit data bytes 5-8 (Tx Buffer )
func (o *CAN_Type) SetTDB2_DATA5(value uint32) {
	volatile.StoreUint32(&o.TDB2.Reg, volatile.LoadUint32(&o.TDB2.Reg)&^(0xff)|value)
}
func (o *CAN_Type) GetTDB2_DATA5() uint32 {
	return volatile.LoadUint32(&o.TDB2.Reg) & 0xff
}
func (o *CAN_Type) SetTDB2_DATA6(value uint32) {
	volatile.StoreUint32(&o.TDB2.Reg, volatile.LoadUint32(&o.TDB2.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_Type) GetTDB2_DATA6() uint32 {
	return (volatile.LoadUint32(&o.TDB2.Reg) & 0xff00) >> 8
}
func (o *CAN_Type) SetTDB2_DATA7(value uint32) {
	volatile.StoreUint32(&o.TDB2.Reg, volatile.LoadUint32(&o.TDB2.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetTDB2_DATA7() uint32 {
	return (volatile.LoadUint32(&o.TDB2.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetTDB2_DATA8(value uint32) {
	volatile.StoreUint32(&o.TDB2.Reg, volatile.LoadUint32(&o.TDB2.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetTDB2_DATA8() uint32 {
	return (volatile.LoadUint32(&o.TDB2.Reg) & 0xff000000) >> 24
}

// CAN.TFI3: Transmit frame info (Tx Buffer )
func (o *CAN_Type) SetTFI3_PRIO(value uint32) {
	volatile.StoreUint32(&o.TFI3.Reg, volatile.LoadUint32(&o.TFI3.Reg)&^(0xff)|value)
}
func (o *CAN_Type) GetTFI3_PRIO() uint32 {
	return volatile.LoadUint32(&o.TFI3.Reg) & 0xff
}
func (o *CAN_Type) SetTFI3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TFI3.Reg, volatile.LoadUint32(&o.TFI3.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_Type) GetTFI3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TFI3.Reg) & 0xff00) >> 8
}
func (o *CAN_Type) SetTFI3_DLC(value uint32) {
	volatile.StoreUint32(&o.TFI3.Reg, volatile.LoadUint32(&o.TFI3.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetTFI3_DLC() uint32 {
	return (volatile.LoadUint32(&o.TFI3.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetTFI3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TFI3.Reg, volatile.LoadUint32(&o.TFI3.Reg)&^(0x3ff00000)|value<<20)
}
func (o *CAN_Type) GetTFI3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TFI3.Reg) & 0x3ff00000) >> 20
}
func (o *CAN_Type) SetTFI3_RTR(value uint32) {
	volatile.StoreUint32(&o.TFI3.Reg, volatile.LoadUint32(&o.TFI3.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetTFI3_RTR() uint32 {
	return (volatile.LoadUint32(&o.TFI3.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetTFI3_FF(value uint32) {
	volatile.StoreUint32(&o.TFI3.Reg, volatile.LoadUint32(&o.TFI3.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetTFI3_FF() uint32 {
	return (volatile.LoadUint32(&o.TFI3.Reg) & 0x80000000) >> 31
}

// CAN.TID3: Transmit Identifier (Tx Buffer)
func (o *CAN_Type) SetTID3_ID(value uint32) {
	volatile.StoreUint32(&o.TID3.Reg, volatile.LoadUint32(&o.TID3.Reg)&^(0x7ff)|value)
}
func (o *CAN_Type) GetTID3_ID() uint32 {
	return volatile.LoadUint32(&o.TID3.Reg) & 0x7ff
}
func (o *CAN_Type) SetTID3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TID3.Reg, volatile.LoadUint32(&o.TID3.Reg)&^(0xfffff800)|value<<11)
}
func (o *CAN_Type) GetTID3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TID3.Reg) & 0xfffff800) >> 11
}

// CAN.TDA3: Transmit data bytes 1-4 (Tx Buffer)
func (o *CAN_Type) SetTDA3_DATA1(value uint32) {
	volatile.StoreUint32(&o.TDA3.Reg, volatile.LoadUint32(&o.TDA3.Reg)&^(0xff)|value)
}
func (o *CAN_Type) GetTDA3_DATA1() uint32 {
	return volatile.LoadUint32(&o.TDA3.Reg) & 0xff
}
func (o *CAN_Type) SetTDA3_DATA2(value uint32) {
	volatile.StoreUint32(&o.TDA3.Reg, volatile.LoadUint32(&o.TDA3.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_Type) GetTDA3_DATA2() uint32 {
	return (volatile.LoadUint32(&o.TDA3.Reg) & 0xff00) >> 8
}
func (o *CAN_Type) SetTDA3_DATA3(value uint32) {
	volatile.StoreUint32(&o.TDA3.Reg, volatile.LoadUint32(&o.TDA3.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetTDA3_DATA3() uint32 {
	return (volatile.LoadUint32(&o.TDA3.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetTDA3_DATA4(value uint32) {
	volatile.StoreUint32(&o.TDA3.Reg, volatile.LoadUint32(&o.TDA3.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetTDA3_DATA4() uint32 {
	return (volatile.LoadUint32(&o.TDA3.Reg) & 0xff000000) >> 24
}

// CAN.TDB3: Transmit data bytes 5-8 (Tx Buffer )
func (o *CAN_Type) SetTDB3_DATA5(value uint32) {
	volatile.StoreUint32(&o.TDB3.Reg, volatile.LoadUint32(&o.TDB3.Reg)&^(0xff)|value)
}
func (o *CAN_Type) GetTDB3_DATA5() uint32 {
	return volatile.LoadUint32(&o.TDB3.Reg) & 0xff
}
func (o *CAN_Type) SetTDB3_DATA6(value uint32) {
	volatile.StoreUint32(&o.TDB3.Reg, volatile.LoadUint32(&o.TDB3.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_Type) GetTDB3_DATA6() uint32 {
	return (volatile.LoadUint32(&o.TDB3.Reg) & 0xff00) >> 8
}
func (o *CAN_Type) SetTDB3_DATA7(value uint32) {
	volatile.StoreUint32(&o.TDB3.Reg, volatile.LoadUint32(&o.TDB3.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetTDB3_DATA7() uint32 {
	return (volatile.LoadUint32(&o.TDB3.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetTDB3_DATA8(value uint32) {
	volatile.StoreUint32(&o.TDB3.Reg, volatile.LoadUint32(&o.TDB3.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetTDB3_DATA8() uint32 {
	return (volatile.LoadUint32(&o.TDB3.Reg) & 0xff000000) >> 24
}

// Digital-to-Analog Converter (DAC)
type DAC_Type struct {
	CR     volatile.Register32 // 0x0
	CTRL   volatile.Register32 // 0x4
	CNTVAL volatile.Register32 // 0x8
}

// DAC.CR: D/A Converter Register. This register contains the digital value to be converted to analog and a power control bit.
func (o *DAC_Type) SetCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3f)|value)
}
func (o *DAC_Type) GetCR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x3f
}
func (o *DAC_Type) SetCR_VALUE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xffc0)|value<<6)
}
func (o *DAC_Type) GetCR_VALUE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xffc0) >> 6
}
func (o *DAC_Type) SetCR_BIAS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetCR_BIAS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetCR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xfffe0000)|value<<17)
}
func (o *DAC_Type) GetCR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xfffe0000) >> 17
}

// DAC.CTRL: DAC Control register. This register controls DMA and timer operation.
func (o *DAC_Type) SetCTRL_INT_DMA_REQ(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCTRL_INT_DMA_REQ() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *DAC_Type) SetCTRL_DBLBUF_ENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCTRL_DBLBUF_ENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCTRL_CNT_ENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetCTRL_CNT_ENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *DAC_Type) SetCTRL_DMA_ENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *DAC_Type) GetCTRL_DMA_ENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *DAC_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffffff0)|value<<4)
}
func (o *DAC_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfffffff0) >> 4
}

// DAC.CNTVAL: DAC Counter Value register. This register contains the reload value for the DAC DMA/Interrupt timer.
func (o *DAC_Type) SetCNTVAL_VALUE(value uint32) {
	volatile.StoreUint32(&o.CNTVAL.Reg, volatile.LoadUint32(&o.CNTVAL.Reg)&^(0xffff)|value)
}
func (o *DAC_Type) GetCNTVAL_VALUE() uint32 {
	return volatile.LoadUint32(&o.CNTVAL.Reg) & 0xffff
}
func (o *DAC_Type) SetCNTVAL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CNTVAL.Reg, volatile.LoadUint32(&o.CNTVAL.Reg)&^(0xffff0000)|value<<16)
}
func (o *DAC_Type) GetCNTVAL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CNTVAL.Reg) & 0xffff0000) >> 16
}

// I2S interface
type I2S_Type struct {
	DAO       volatile.Register32 // 0x0
	DAI       volatile.Register32 // 0x4
	TXFIFO    volatile.Register32 // 0x8
	RXFIFO    volatile.Register32 // 0xC
	STATE     volatile.Register32 // 0x10
	DMA1      volatile.Register32 // 0x14
	DMA2      volatile.Register32 // 0x18
	IRQ       volatile.Register32 // 0x1C
	TXRATE    volatile.Register32 // 0x20
	RXRATE    volatile.Register32 // 0x24
	TXBITRATE volatile.Register32 // 0x28
	RXBITRATE volatile.Register32 // 0x2C
	TXMODE    volatile.Register32 // 0x30
	RXMODE    volatile.Register32 // 0x34
}

// I2S.DAO: I2S Digital Audio Output Register. Contains control bits for the I2S transmit channel.
func (o *I2S_Type) SetDAO_WORDWIDTH(value uint32) {
	volatile.StoreUint32(&o.DAO.Reg, volatile.LoadUint32(&o.DAO.Reg)&^(0x3)|value)
}
func (o *I2S_Type) GetDAO_WORDWIDTH() uint32 {
	return volatile.LoadUint32(&o.DAO.Reg) & 0x3
}
func (o *I2S_Type) SetDAO_MONO(value uint32) {
	volatile.StoreUint32(&o.DAO.Reg, volatile.LoadUint32(&o.DAO.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetDAO_MONO() uint32 {
	return (volatile.LoadUint32(&o.DAO.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetDAO_STOP(value uint32) {
	volatile.StoreUint32(&o.DAO.Reg, volatile.LoadUint32(&o.DAO.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetDAO_STOP() uint32 {
	return (volatile.LoadUint32(&o.DAO.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetDAO_RESET(value uint32) {
	volatile.StoreUint32(&o.DAO.Reg, volatile.LoadUint32(&o.DAO.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetDAO_RESET() uint32 {
	return (volatile.LoadUint32(&o.DAO.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetDAO_WS_SEL(value uint32) {
	volatile.StoreUint32(&o.DAO.Reg, volatile.LoadUint32(&o.DAO.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetDAO_WS_SEL() uint32 {
	return (volatile.LoadUint32(&o.DAO.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetDAO_WS_HALFPERIOD(value uint32) {
	volatile.StoreUint32(&o.DAO.Reg, volatile.LoadUint32(&o.DAO.Reg)&^(0x7fc0)|value<<6)
}
func (o *I2S_Type) GetDAO_WS_HALFPERIOD() uint32 {
	return (volatile.LoadUint32(&o.DAO.Reg) & 0x7fc0) >> 6
}
func (o *I2S_Type) SetDAO_MUTE(value uint32) {
	volatile.StoreUint32(&o.DAO.Reg, volatile.LoadUint32(&o.DAO.Reg)&^(0x8000)|value<<15)
}
func (o *I2S_Type) GetDAO_MUTE() uint32 {
	return (volatile.LoadUint32(&o.DAO.Reg) & 0x8000) >> 15
}
func (o *I2S_Type) SetDAO_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DAO.Reg, volatile.LoadUint32(&o.DAO.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2S_Type) GetDAO_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DAO.Reg) & 0xffff0000) >> 16
}

// I2S.DAI: I2S Digital Audio Input Register. Contains control bits for the I2S receive channel.
func (o *I2S_Type) SetDAI_WORDWIDTH(value uint32) {
	volatile.StoreUint32(&o.DAI.Reg, volatile.LoadUint32(&o.DAI.Reg)&^(0x3)|value)
}
func (o *I2S_Type) GetDAI_WORDWIDTH() uint32 {
	return volatile.LoadUint32(&o.DAI.Reg) & 0x3
}
func (o *I2S_Type) SetDAI_MONO(value uint32) {
	volatile.StoreUint32(&o.DAI.Reg, volatile.LoadUint32(&o.DAI.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetDAI_MONO() uint32 {
	return (volatile.LoadUint32(&o.DAI.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetDAI_STOP(value uint32) {
	volatile.StoreUint32(&o.DAI.Reg, volatile.LoadUint32(&o.DAI.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetDAI_STOP() uint32 {
	return (volatile.LoadUint32(&o.DAI.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetDAI_RESET(value uint32) {
	volatile.StoreUint32(&o.DAI.Reg, volatile.LoadUint32(&o.DAI.Reg)&^(0x10)|value<<4)
}
func (o *I2S_Type) GetDAI_RESET() uint32 {
	return (volatile.LoadUint32(&o.DAI.Reg) & 0x10) >> 4
}
func (o *I2S_Type) SetDAI_WS_SEL(value uint32) {
	volatile.StoreUint32(&o.DAI.Reg, volatile.LoadUint32(&o.DAI.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetDAI_WS_SEL() uint32 {
	return (volatile.LoadUint32(&o.DAI.Reg) & 0x20) >> 5
}
func (o *I2S_Type) SetDAI_WS_HALFPERIOD(value uint32) {
	volatile.StoreUint32(&o.DAI.Reg, volatile.LoadUint32(&o.DAI.Reg)&^(0x7fc0)|value<<6)
}
func (o *I2S_Type) GetDAI_WS_HALFPERIOD() uint32 {
	return (volatile.LoadUint32(&o.DAI.Reg) & 0x7fc0) >> 6
}
func (o *I2S_Type) SetDAI_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DAI.Reg, volatile.LoadUint32(&o.DAI.Reg)&^(0xffff8000)|value<<15)
}
func (o *I2S_Type) GetDAI_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DAI.Reg) & 0xffff8000) >> 15
}

// I2S.TXFIFO: I2S Transmit FIFO. Access register for the 8 x 32-bit transmitter FIFO.
func (o *I2S_Type) SetTXFIFO(value uint32) {
	volatile.StoreUint32(&o.TXFIFO.Reg, value)
}
func (o *I2S_Type) GetTXFIFO() uint32 {
	return volatile.LoadUint32(&o.TXFIFO.Reg)
}

// I2S.RXFIFO: I2S Receive FIFO. Access register for the 8 x 32-bit receiver FIFO.
func (o *I2S_Type) SetRXFIFO(value uint32) {
	volatile.StoreUint32(&o.RXFIFO.Reg, value)
}
func (o *I2S_Type) GetRXFIFO() uint32 {
	return volatile.LoadUint32(&o.RXFIFO.Reg)
}

// I2S.STATE: I2S Status Feedback Register. Contains status information about the I2S interface.
func (o *I2S_Type) SetSTATE_IRQ(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetSTATE_IRQ() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0x1
}
func (o *I2S_Type) SetSTATE_DMAREQ1(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetSTATE_DMAREQ1() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetSTATE_DMAREQ2(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetSTATE_DMAREQ2() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xf8)|value<<3)
}
func (o *I2S_Type) GetSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xf8) >> 3
}
func (o *I2S_Type) SetSTATE_RX_LEVEL(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xf00)|value<<8)
}
func (o *I2S_Type) GetSTATE_RX_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xf00) >> 8
}
func (o *I2S_Type) SetSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xf000)|value<<12)
}
func (o *I2S_Type) GetSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xf000) >> 12
}
func (o *I2S_Type) SetSTATE_TX_LEVEL(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S_Type) GetSTATE_TX_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xf0000) >> 16
}
func (o *I2S_Type) SetSTATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xfff00000)|value<<20)
}
func (o *I2S_Type) GetSTATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATE.Reg) & 0xfff00000) >> 20
}

// I2S.DMA1: I2S DMA Configuration Register 1. Contains control information for DMA request 1.
func (o *I2S_Type) SetDMA1_RX_DMA1_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DMA1.Reg, volatile.LoadUint32(&o.DMA1.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetDMA1_RX_DMA1_ENABLE() uint32 {
	return volatile.LoadUint32(&o.DMA1.Reg) & 0x1
}
func (o *I2S_Type) SetDMA1_TX_DMA1_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DMA1.Reg, volatile.LoadUint32(&o.DMA1.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetDMA1_TX_DMA1_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.DMA1.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetDMA1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA1.Reg, volatile.LoadUint32(&o.DMA1.Reg)&^(0xfc)|value<<2)
}
func (o *I2S_Type) GetDMA1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA1.Reg) & 0xfc) >> 2
}
func (o *I2S_Type) SetDMA1_RX_DEPTH_DMA1(value uint32) {
	volatile.StoreUint32(&o.DMA1.Reg, volatile.LoadUint32(&o.DMA1.Reg)&^(0xf00)|value<<8)
}
func (o *I2S_Type) GetDMA1_RX_DEPTH_DMA1() uint32 {
	return (volatile.LoadUint32(&o.DMA1.Reg) & 0xf00) >> 8
}
func (o *I2S_Type) SetDMA1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA1.Reg, volatile.LoadUint32(&o.DMA1.Reg)&^(0xf000)|value<<12)
}
func (o *I2S_Type) GetDMA1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA1.Reg) & 0xf000) >> 12
}
func (o *I2S_Type) SetDMA1_TX_DEPTH_DMA1(value uint32) {
	volatile.StoreUint32(&o.DMA1.Reg, volatile.LoadUint32(&o.DMA1.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S_Type) GetDMA1_TX_DEPTH_DMA1() uint32 {
	return (volatile.LoadUint32(&o.DMA1.Reg) & 0xf0000) >> 16
}
func (o *I2S_Type) SetDMA1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA1.Reg, volatile.LoadUint32(&o.DMA1.Reg)&^(0xfff00000)|value<<20)
}
func (o *I2S_Type) GetDMA1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA1.Reg) & 0xfff00000) >> 20
}

// I2S.DMA2: I2S DMA Configuration Register 2. Contains control information for DMA request 2.
func (o *I2S_Type) SetDMA2_RX_DMA2_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DMA2.Reg, volatile.LoadUint32(&o.DMA2.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetDMA2_RX_DMA2_ENABLE() uint32 {
	return volatile.LoadUint32(&o.DMA2.Reg) & 0x1
}
func (o *I2S_Type) SetDMA2_TX_DMA2_ENABLE(value uint32) {
	volatile.StoreUint32(&o.DMA2.Reg, volatile.LoadUint32(&o.DMA2.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetDMA2_TX_DMA2_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.DMA2.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetDMA2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA2.Reg, volatile.LoadUint32(&o.DMA2.Reg)&^(0xfc)|value<<2)
}
func (o *I2S_Type) GetDMA2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA2.Reg) & 0xfc) >> 2
}
func (o *I2S_Type) SetDMA2_RX_DEPTH_DMA2(value uint32) {
	volatile.StoreUint32(&o.DMA2.Reg, volatile.LoadUint32(&o.DMA2.Reg)&^(0xf00)|value<<8)
}
func (o *I2S_Type) GetDMA2_RX_DEPTH_DMA2() uint32 {
	return (volatile.LoadUint32(&o.DMA2.Reg) & 0xf00) >> 8
}
func (o *I2S_Type) SetDMA2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA2.Reg, volatile.LoadUint32(&o.DMA2.Reg)&^(0xf000)|value<<12)
}
func (o *I2S_Type) GetDMA2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA2.Reg) & 0xf000) >> 12
}
func (o *I2S_Type) SetDMA2_TX_DEPTH_DMA2(value uint32) {
	volatile.StoreUint32(&o.DMA2.Reg, volatile.LoadUint32(&o.DMA2.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S_Type) GetDMA2_TX_DEPTH_DMA2() uint32 {
	return (volatile.LoadUint32(&o.DMA2.Reg) & 0xf0000) >> 16
}
func (o *I2S_Type) SetDMA2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMA2.Reg, volatile.LoadUint32(&o.DMA2.Reg)&^(0xfff00000)|value<<20)
}
func (o *I2S_Type) GetDMA2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMA2.Reg) & 0xfff00000) >> 20
}

// I2S.IRQ: I2S Interrupt Request Control Register. Contains bits that control how the I2S interrupt request is generated.
func (o *I2S_Type) SetIRQ_RX_IRQ_ENABLE(value uint32) {
	volatile.StoreUint32(&o.IRQ.Reg, volatile.LoadUint32(&o.IRQ.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetIRQ_RX_IRQ_ENABLE() uint32 {
	return volatile.LoadUint32(&o.IRQ.Reg) & 0x1
}
func (o *I2S_Type) SetIRQ_TX_IRQ_ENABLE(value uint32) {
	volatile.StoreUint32(&o.IRQ.Reg, volatile.LoadUint32(&o.IRQ.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetIRQ_TX_IRQ_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.IRQ.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetIRQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IRQ.Reg, volatile.LoadUint32(&o.IRQ.Reg)&^(0xfc)|value<<2)
}
func (o *I2S_Type) GetIRQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IRQ.Reg) & 0xfc) >> 2
}
func (o *I2S_Type) SetIRQ_RX_DEPTH_IRQ(value uint32) {
	volatile.StoreUint32(&o.IRQ.Reg, volatile.LoadUint32(&o.IRQ.Reg)&^(0xf00)|value<<8)
}
func (o *I2S_Type) GetIRQ_RX_DEPTH_IRQ() uint32 {
	return (volatile.LoadUint32(&o.IRQ.Reg) & 0xf00) >> 8
}
func (o *I2S_Type) SetIRQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IRQ.Reg, volatile.LoadUint32(&o.IRQ.Reg)&^(0xf000)|value<<12)
}
func (o *I2S_Type) GetIRQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IRQ.Reg) & 0xf000) >> 12
}
func (o *I2S_Type) SetIRQ_TX_DEPTH_IRQ(value uint32) {
	volatile.StoreUint32(&o.IRQ.Reg, volatile.LoadUint32(&o.IRQ.Reg)&^(0xf0000)|value<<16)
}
func (o *I2S_Type) GetIRQ_TX_DEPTH_IRQ() uint32 {
	return (volatile.LoadUint32(&o.IRQ.Reg) & 0xf0000) >> 16
}
func (o *I2S_Type) SetIRQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IRQ.Reg, volatile.LoadUint32(&o.IRQ.Reg)&^(0xfff00000)|value<<20)
}
func (o *I2S_Type) GetIRQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IRQ.Reg) & 0xfff00000) >> 20
}

// I2S.TXRATE: I2S Transmit MCLK divider. This register determines the I2S TX MCLK rate by specifying the value to divide PCLK by in order to produce MCLK.
func (o *I2S_Type) SetTXRATE_Y_DIVIDER(value uint32) {
	volatile.StoreUint32(&o.TXRATE.Reg, volatile.LoadUint32(&o.TXRATE.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetTXRATE_Y_DIVIDER() uint32 {
	return volatile.LoadUint32(&o.TXRATE.Reg) & 0xff
}
func (o *I2S_Type) SetTXRATE_X_DIVIDER(value uint32) {
	volatile.StoreUint32(&o.TXRATE.Reg, volatile.LoadUint32(&o.TXRATE.Reg)&^(0xff00)|value<<8)
}
func (o *I2S_Type) GetTXRATE_X_DIVIDER() uint32 {
	return (volatile.LoadUint32(&o.TXRATE.Reg) & 0xff00) >> 8
}
func (o *I2S_Type) SetTXRATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXRATE.Reg, volatile.LoadUint32(&o.TXRATE.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2S_Type) GetTXRATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXRATE.Reg) & 0xffff0000) >> 16
}

// I2S.RXRATE: I2S Receive MCLK divider. This register determines the I2S RX MCLK rate by specifying the value to divide PCLK by in order to produce MCLK.
func (o *I2S_Type) SetRXRATE_Y_DIVIDER(value uint32) {
	volatile.StoreUint32(&o.RXRATE.Reg, volatile.LoadUint32(&o.RXRATE.Reg)&^(0xff)|value)
}
func (o *I2S_Type) GetRXRATE_Y_DIVIDER() uint32 {
	return volatile.LoadUint32(&o.RXRATE.Reg) & 0xff
}
func (o *I2S_Type) SetRXRATE_X_DIVIDER(value uint32) {
	volatile.StoreUint32(&o.RXRATE.Reg, volatile.LoadUint32(&o.RXRATE.Reg)&^(0xff00)|value<<8)
}
func (o *I2S_Type) GetRXRATE_X_DIVIDER() uint32 {
	return (volatile.LoadUint32(&o.RXRATE.Reg) & 0xff00) >> 8
}
func (o *I2S_Type) SetRXRATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXRATE.Reg, volatile.LoadUint32(&o.RXRATE.Reg)&^(0xffff0000)|value<<16)
}
func (o *I2S_Type) GetRXRATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXRATE.Reg) & 0xffff0000) >> 16
}

// I2S.TXBITRATE: I2S Transmit bit rate divider. This register determines the I2S transmit bit rate by specifying the value to divide TX_MCLK by in order to produce the transmit bit clock.
func (o *I2S_Type) SetTXBITRATE_TX_BITRATE(value uint32) {
	volatile.StoreUint32(&o.TXBITRATE.Reg, volatile.LoadUint32(&o.TXBITRATE.Reg)&^(0x3f)|value)
}
func (o *I2S_Type) GetTXBITRATE_TX_BITRATE() uint32 {
	return volatile.LoadUint32(&o.TXBITRATE.Reg) & 0x3f
}
func (o *I2S_Type) SetTXBITRATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXBITRATE.Reg, volatile.LoadUint32(&o.TXBITRATE.Reg)&^(0xffffffc0)|value<<6)
}
func (o *I2S_Type) GetTXBITRATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXBITRATE.Reg) & 0xffffffc0) >> 6
}

// I2S.RXBITRATE: I2S Receive bit rate divider. This register determines the I2S receive bit rate by specifying the value to divide RX_MCLK by in order to produce the receive bit clock.
func (o *I2S_Type) SetRXBITRATE_RX_BITRATE(value uint32) {
	volatile.StoreUint32(&o.RXBITRATE.Reg, volatile.LoadUint32(&o.RXBITRATE.Reg)&^(0x3f)|value)
}
func (o *I2S_Type) GetRXBITRATE_RX_BITRATE() uint32 {
	return volatile.LoadUint32(&o.RXBITRATE.Reg) & 0x3f
}
func (o *I2S_Type) SetRXBITRATE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXBITRATE.Reg, volatile.LoadUint32(&o.RXBITRATE.Reg)&^(0xffffffc0)|value<<6)
}
func (o *I2S_Type) GetRXBITRATE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXBITRATE.Reg) & 0xffffffc0) >> 6
}

// I2S.TXMODE: I2S Transmit mode control.
func (o *I2S_Type) SetTXMODE_TXCLKSEL(value uint32) {
	volatile.StoreUint32(&o.TXMODE.Reg, volatile.LoadUint32(&o.TXMODE.Reg)&^(0x3)|value)
}
func (o *I2S_Type) GetTXMODE_TXCLKSEL() uint32 {
	return volatile.LoadUint32(&o.TXMODE.Reg) & 0x3
}
func (o *I2S_Type) SetTXMODE_TX4PIN(value uint32) {
	volatile.StoreUint32(&o.TXMODE.Reg, volatile.LoadUint32(&o.TXMODE.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetTXMODE_TX4PIN() uint32 {
	return (volatile.LoadUint32(&o.TXMODE.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetTXMODE_TXMCENA(value uint32) {
	volatile.StoreUint32(&o.TXMODE.Reg, volatile.LoadUint32(&o.TXMODE.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetTXMODE_TXMCENA() uint32 {
	return (volatile.LoadUint32(&o.TXMODE.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetTXMODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXMODE.Reg, volatile.LoadUint32(&o.TXMODE.Reg)&^(0xfffffff0)|value<<4)
}
func (o *I2S_Type) GetTXMODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXMODE.Reg) & 0xfffffff0) >> 4
}

// I2S.RXMODE: I2S Receive mode control.
func (o *I2S_Type) SetRXMODE_RXCLKSEL(value uint32) {
	volatile.StoreUint32(&o.RXMODE.Reg, volatile.LoadUint32(&o.RXMODE.Reg)&^(0x3)|value)
}
func (o *I2S_Type) GetRXMODE_RXCLKSEL() uint32 {
	return volatile.LoadUint32(&o.RXMODE.Reg) & 0x3
}
func (o *I2S_Type) SetRXMODE_RX4PIN(value uint32) {
	volatile.StoreUint32(&o.RXMODE.Reg, volatile.LoadUint32(&o.RXMODE.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetRXMODE_RX4PIN() uint32 {
	return (volatile.LoadUint32(&o.RXMODE.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetRXMODE_RXMCENA(value uint32) {
	volatile.StoreUint32(&o.RXMODE.Reg, volatile.LoadUint32(&o.RXMODE.Reg)&^(0x8)|value<<3)
}
func (o *I2S_Type) GetRXMODE_RXMCENA() uint32 {
	return (volatile.LoadUint32(&o.RXMODE.Reg) & 0x8) >> 3
}
func (o *I2S_Type) SetRXMODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXMODE.Reg, volatile.LoadUint32(&o.RXMODE.Reg)&^(0xfffffff0)|value<<4)
}
func (o *I2S_Type) GetRXMODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXMODE.Reg) & 0xfffffff0) >> 4
}

// Repetitive Interrupt Timer (RIT)
type RIT_Type struct {
	COMPVAL volatile.Register32 // 0x0
	MASK    volatile.Register32 // 0x4
	CTRL    volatile.Register32 // 0x8
	COUNTER volatile.Register32 // 0xC
}

// RIT.COMPVAL: Compare register
func (o *RIT_Type) SetCOMPVAL(value uint32) {
	volatile.StoreUint32(&o.COMPVAL.Reg, value)
}
func (o *RIT_Type) GetCOMPVAL() uint32 {
	return volatile.LoadUint32(&o.COMPVAL.Reg)
}

// RIT.MASK: Mask register. This register holds the 32-bit mask value. A 1 written to any bit will force a compare on the corresponding bit of the counter and compare register.
func (o *RIT_Type) SetMASK(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, value)
}
func (o *RIT_Type) GetMASK() uint32 {
	return volatile.LoadUint32(&o.MASK.Reg)
}

// RIT.CTRL: Control register.
func (o *RIT_Type) SetCTRL_RITINT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *RIT_Type) GetCTRL_RITINT() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *RIT_Type) SetCTRL_RITENCLR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *RIT_Type) GetCTRL_RITENCLR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *RIT_Type) SetCTRL_RITENBR(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *RIT_Type) GetCTRL_RITENBR() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *RIT_Type) SetCTRL_RITEN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *RIT_Type) GetCTRL_RITEN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *RIT_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xfffffff0)|value<<4)
}
func (o *RIT_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xfffffff0) >> 4
}

// RIT.COUNTER: 32-bit counter
func (o *RIT_Type) SetCOUNTER(value uint32) {
	volatile.StoreUint32(&o.COUNTER.Reg, value)
}
func (o *RIT_Type) GetCOUNTER() uint32 {
	return volatile.LoadUint32(&o.COUNTER.Reg)
}

// Motor Control PWM
type MCPWM_Type struct {
	CON        volatile.Register32    // 0x0
	CON_SET    volatile.Register32    // 0x4
	CON_CLR    volatile.Register32    // 0x8
	CAPCON     volatile.Register32    // 0xC
	CAPCON_SET volatile.Register32    // 0x10
	CAPCON_CLR volatile.Register32    // 0x14
	TC         [3]volatile.Register32 // 0x18
	LIM        [3]volatile.Register32 // 0x24
	MAT        [3]volatile.Register32 // 0x30
	DT         volatile.Register32    // 0x3C
	CP         volatile.Register32    // 0x40
	CAP        [3]volatile.Register32 // 0x44
	INTEN      volatile.Register32    // 0x50
	INTEN_SET  volatile.Register32    // 0x54
	INTEN_CLR  volatile.Register32    // 0x58
	CNTCON     volatile.Register32    // 0x5C
	CNTCON_SET volatile.Register32    // 0x60
	CNTCON_CLR volatile.Register32    // 0x64
	INTF       volatile.Register32    // 0x68
	INTF_SET   volatile.Register32    // 0x6C
	INTF_CLR   volatile.Register32    // 0x70
	CAP_CLR    volatile.Register32    // 0x74
}

// MCPWM.CON: PWM Control read address
func (o *MCPWM_Type) SetCON_RUN0(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetCON_RUN0() uint32 {
	return volatile.LoadUint32(&o.CON.Reg) & 0x1
}
func (o *MCPWM_Type) SetCON_CENTER0(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetCON_CENTER0() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetCON_POLA0(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetCON_POLA0() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetCON_DTE0(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetCON_DTE0() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetCON_DISUP0(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetCON_DISUP0() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0xe0)|value<<5)
}
func (o *MCPWM_Type) GetCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0xe0) >> 5
}
func (o *MCPWM_Type) SetCON_RUN1(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetCON_RUN1() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetCON_CENTER1(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetCON_CENTER1() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetCON_POLA1(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetCON_POLA1() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetCON_DTE1(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x800)|value<<11)
}
func (o *MCPWM_Type) GetCON_DTE1() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x800) >> 11
}
func (o *MCPWM_Type) SetCON_DISUP1(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x1000)|value<<12)
}
func (o *MCPWM_Type) GetCON_DISUP1() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x1000) >> 12
}
func (o *MCPWM_Type) SetCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0xe000)|value<<13)
}
func (o *MCPWM_Type) GetCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0xe000) >> 13
}
func (o *MCPWM_Type) SetCON_RUN2(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x10000)|value<<16)
}
func (o *MCPWM_Type) GetCON_RUN2() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x10000) >> 16
}
func (o *MCPWM_Type) SetCON_CENTER2(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x20000)|value<<17)
}
func (o *MCPWM_Type) GetCON_CENTER2() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x20000) >> 17
}
func (o *MCPWM_Type) SetCON_POLA2(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x40000)|value<<18)
}
func (o *MCPWM_Type) GetCON_POLA2() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x40000) >> 18
}
func (o *MCPWM_Type) SetCON_DTE2(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x80000)|value<<19)
}
func (o *MCPWM_Type) GetCON_DTE2() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x80000) >> 19
}
func (o *MCPWM_Type) SetCON_DISUP2(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x100000)|value<<20)
}
func (o *MCPWM_Type) GetCON_DISUP2() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x100000) >> 20
}
func (o *MCPWM_Type) SetCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x1fe00000)|value<<21)
}
func (o *MCPWM_Type) GetCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x1fe00000) >> 21
}
func (o *MCPWM_Type) SetCON_INVBDC(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x20000000)|value<<29)
}
func (o *MCPWM_Type) GetCON_INVBDC() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x20000000) >> 29
}
func (o *MCPWM_Type) SetCON_ACMODE(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x40000000)|value<<30)
}
func (o *MCPWM_Type) GetCON_ACMODE() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x40000000) >> 30
}
func (o *MCPWM_Type) SetCON_DCMODE(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x80000000)|value<<31)
}
func (o *MCPWM_Type) GetCON_DCMODE() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x80000000) >> 31
}

// MCPWM.CON_SET: PWM Control set address
func (o *MCPWM_Type) SetCON_SET_RUN0_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetCON_SET_RUN0_SET() uint32 {
	return volatile.LoadUint32(&o.CON_SET.Reg) & 0x1
}
func (o *MCPWM_Type) SetCON_SET_CENTER0_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetCON_SET_CENTER0_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetCON_SET_POLA0_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetCON_SET_POLA0_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetCON_SET_DTE0_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetCON_SET_DTE0_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetCON_SET_DISUP0_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetCON_SET_DISUP0_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetCON_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0xe0)|value<<5)
}
func (o *MCPWM_Type) GetCON_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0xe0) >> 5
}
func (o *MCPWM_Type) SetCON_SET_RUN1_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetCON_SET_RUN1_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetCON_SET_CENTER1_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetCON_SET_CENTER1_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetCON_SET_POLA1_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetCON_SET_POLA1_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetCON_SET_DTE1_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x800)|value<<11)
}
func (o *MCPWM_Type) GetCON_SET_DTE1_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x800) >> 11
}
func (o *MCPWM_Type) SetCON_SET_DISUP1_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x1000)|value<<12)
}
func (o *MCPWM_Type) GetCON_SET_DISUP1_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x1000) >> 12
}
func (o *MCPWM_Type) SetCON_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0xe000)|value<<13)
}
func (o *MCPWM_Type) GetCON_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0xe000) >> 13
}
func (o *MCPWM_Type) SetCON_SET_RUN2_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x10000)|value<<16)
}
func (o *MCPWM_Type) GetCON_SET_RUN2_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x10000) >> 16
}
func (o *MCPWM_Type) SetCON_SET_CENTER2_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x20000)|value<<17)
}
func (o *MCPWM_Type) GetCON_SET_CENTER2_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x20000) >> 17
}
func (o *MCPWM_Type) SetCON_SET_POLA2_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x40000)|value<<18)
}
func (o *MCPWM_Type) GetCON_SET_POLA2_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x40000) >> 18
}
func (o *MCPWM_Type) SetCON_SET_DTE2_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x80000)|value<<19)
}
func (o *MCPWM_Type) GetCON_SET_DTE2_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x80000) >> 19
}
func (o *MCPWM_Type) SetCON_SET_DISUP2_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x100000)|value<<20)
}
func (o *MCPWM_Type) GetCON_SET_DISUP2_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x100000) >> 20
}
func (o *MCPWM_Type) SetCON_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x1fe00000)|value<<21)
}
func (o *MCPWM_Type) GetCON_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x1fe00000) >> 21
}
func (o *MCPWM_Type) SetCON_SET_INVBDC_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x20000000)|value<<29)
}
func (o *MCPWM_Type) GetCON_SET_INVBDC_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x20000000) >> 29
}
func (o *MCPWM_Type) SetCON_SET_ACMODE_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x40000000)|value<<30)
}
func (o *MCPWM_Type) GetCON_SET_ACMODE_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x40000000) >> 30
}
func (o *MCPWM_Type) SetCON_SET_DCMODE_SET(value uint32) {
	volatile.StoreUint32(&o.CON_SET.Reg, volatile.LoadUint32(&o.CON_SET.Reg)&^(0x80000000)|value<<31)
}
func (o *MCPWM_Type) GetCON_SET_DCMODE_SET() uint32 {
	return (volatile.LoadUint32(&o.CON_SET.Reg) & 0x80000000) >> 31
}

// MCPWM.CON_CLR: PWM Control clear address
func (o *MCPWM_Type) SetCON_CLR_RUN0_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetCON_CLR_RUN0_CLR() uint32 {
	return volatile.LoadUint32(&o.CON_CLR.Reg) & 0x1
}
func (o *MCPWM_Type) SetCON_CLR_CENTER0_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetCON_CLR_CENTER0_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetCON_CLR_POLA0_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetCON_CLR_POLA0_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetCON_CLR_DTE0_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetCON_CLR_DTE0_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetCON_CLR_DISUP0_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetCON_CLR_DISUP0_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetCON_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0xe0)|value<<5)
}
func (o *MCPWM_Type) GetCON_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0xe0) >> 5
}
func (o *MCPWM_Type) SetCON_CLR_RUN1_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetCON_CLR_RUN1_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetCON_CLR_CENTER1_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetCON_CLR_CENTER1_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetCON_CLR_POLA1_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetCON_CLR_POLA1_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetCON_CLR_DTE1_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x800)|value<<11)
}
func (o *MCPWM_Type) GetCON_CLR_DTE1_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x800) >> 11
}
func (o *MCPWM_Type) SetCON_CLR_DISUP1_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *MCPWM_Type) GetCON_CLR_DISUP1_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x1000) >> 12
}
func (o *MCPWM_Type) SetCON_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0xe000)|value<<13)
}
func (o *MCPWM_Type) GetCON_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0xe000) >> 13
}
func (o *MCPWM_Type) SetCON_CLR_RUN2_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x10000)|value<<16)
}
func (o *MCPWM_Type) GetCON_CLR_RUN2_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x10000) >> 16
}
func (o *MCPWM_Type) SetCON_CLR_CENTER2_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x20000)|value<<17)
}
func (o *MCPWM_Type) GetCON_CLR_CENTER2_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x20000) >> 17
}
func (o *MCPWM_Type) SetCON_CLR_POLA2_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x40000)|value<<18)
}
func (o *MCPWM_Type) GetCON_CLR_POLA2_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x40000) >> 18
}
func (o *MCPWM_Type) SetCON_CLR_DTE2_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x80000)|value<<19)
}
func (o *MCPWM_Type) GetCON_CLR_DTE2_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x80000) >> 19
}
func (o *MCPWM_Type) SetCON_CLR_DISUP2_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x100000)|value<<20)
}
func (o *MCPWM_Type) GetCON_CLR_DISUP2_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x100000) >> 20
}
func (o *MCPWM_Type) SetCON_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x1fe00000)|value<<21)
}
func (o *MCPWM_Type) GetCON_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x1fe00000) >> 21
}
func (o *MCPWM_Type) SetCON_CLR_INVBDC_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x20000000)|value<<29)
}
func (o *MCPWM_Type) GetCON_CLR_INVBDC_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x20000000) >> 29
}
func (o *MCPWM_Type) SetCON_CLR_ACMOD_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x40000000)|value<<30)
}
func (o *MCPWM_Type) GetCON_CLR_ACMOD_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x40000000) >> 30
}
func (o *MCPWM_Type) SetCON_CLR_DCMODE_CLR(value uint32) {
	volatile.StoreUint32(&o.CON_CLR.Reg, volatile.LoadUint32(&o.CON_CLR.Reg)&^(0x80000000)|value<<31)
}
func (o *MCPWM_Type) GetCON_CLR_DCMODE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CON_CLR.Reg) & 0x80000000) >> 31
}

// MCPWM.CAPCON: Capture Control read address
func (o *MCPWM_Type) SetCAPCON_CAP0MCI0_RE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetCAPCON_CAP0MCI0_RE() uint32 {
	return volatile.LoadUint32(&o.CAPCON.Reg) & 0x1
}
func (o *MCPWM_Type) SetCAPCON_CAP0MCI0_FE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetCAPCON_CAP0MCI0_FE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetCAPCON_CAP0MCI1_RE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetCAPCON_CAP0MCI1_RE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetCAPCON_CAP0MCI1_FE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetCAPCON_CAP0MCI1_FE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetCAPCON_CAP0MCI2_RE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetCAPCON_CAP0MCI2_RE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetCAPCON_CAP0MCI2_FE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x20)|value<<5)
}
func (o *MCPWM_Type) GetCAPCON_CAP0MCI2_FE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x20) >> 5
}
func (o *MCPWM_Type) SetCAPCON_CAP1MCI0_RE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x40)|value<<6)
}
func (o *MCPWM_Type) GetCAPCON_CAP1MCI0_RE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x40) >> 6
}
func (o *MCPWM_Type) SetCAPCON_CAP1MCI0_FE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x80)|value<<7)
}
func (o *MCPWM_Type) GetCAPCON_CAP1MCI0_FE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x80) >> 7
}
func (o *MCPWM_Type) SetCAPCON_CAP1MCI1_RE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetCAPCON_CAP1MCI1_RE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetCAPCON_CAP1MCI1_FE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetCAPCON_CAP1MCI1_FE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetCAPCON_CAP1MCI2_RE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetCAPCON_CAP1MCI2_RE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetCAPCON_CAP1MCI2_FE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x800)|value<<11)
}
func (o *MCPWM_Type) GetCAPCON_CAP1MCI2_FE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x800) >> 11
}
func (o *MCPWM_Type) SetCAPCON_CAP2MCI0_RE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x1000)|value<<12)
}
func (o *MCPWM_Type) GetCAPCON_CAP2MCI0_RE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x1000) >> 12
}
func (o *MCPWM_Type) SetCAPCON_CAP2MCI0_FE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x2000)|value<<13)
}
func (o *MCPWM_Type) GetCAPCON_CAP2MCI0_FE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x2000) >> 13
}
func (o *MCPWM_Type) SetCAPCON_CAP2MCI1_RE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x4000)|value<<14)
}
func (o *MCPWM_Type) GetCAPCON_CAP2MCI1_RE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x4000) >> 14
}
func (o *MCPWM_Type) SetCAPCON_CAP2MCI1_FE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x8000)|value<<15)
}
func (o *MCPWM_Type) GetCAPCON_CAP2MCI1_FE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x8000) >> 15
}
func (o *MCPWM_Type) SetCAPCON_CAP2MCI2_RE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x10000)|value<<16)
}
func (o *MCPWM_Type) GetCAPCON_CAP2MCI2_RE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x10000) >> 16
}
func (o *MCPWM_Type) SetCAPCON_CAP2MCI2_FE(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x20000)|value<<17)
}
func (o *MCPWM_Type) GetCAPCON_CAP2MCI2_FE() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x20000) >> 17
}
func (o *MCPWM_Type) SetCAPCON_RT0(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x40000)|value<<18)
}
func (o *MCPWM_Type) GetCAPCON_RT0() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x40000) >> 18
}
func (o *MCPWM_Type) SetCAPCON_RT1(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x80000)|value<<19)
}
func (o *MCPWM_Type) GetCAPCON_RT1() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x80000) >> 19
}
func (o *MCPWM_Type) SetCAPCON_RT2(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0x100000)|value<<20)
}
func (o *MCPWM_Type) GetCAPCON_RT2() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0x100000) >> 20
}
func (o *MCPWM_Type) SetCAPCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CAPCON.Reg, volatile.LoadUint32(&o.CAPCON.Reg)&^(0xffe00000)|value<<21)
}
func (o *MCPWM_Type) GetCAPCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CAPCON.Reg) & 0xffe00000) >> 21
}

// MCPWM.CAPCON_SET: Capture Control set address
func (o *MCPWM_Type) SetCAPCON_SET_CAP0MCI0_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP0MCI0_RE_SET() uint32 {
	return volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x1
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP0MCI0_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP0MCI0_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP0MCI1_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP0MCI1_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP0MCI1_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP0MCI1_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP0MCI2_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP0MCI2_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP0MCI2_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x20)|value<<5)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP0MCI2_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x20) >> 5
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP1MCI0_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x40)|value<<6)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP1MCI0_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x40) >> 6
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP1MCI0_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x80)|value<<7)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP1MCI0_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x80) >> 7
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP1MCI1_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP1MCI1_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP1MCI1_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP1MCI1_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP1MCI2_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP1MCI2_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP1MCI2_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x800)|value<<11)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP1MCI2_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x800) >> 11
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP2MCI0_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x1000)|value<<12)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP2MCI0_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x1000) >> 12
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP2MCI0_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x2000)|value<<13)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP2MCI0_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x2000) >> 13
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP2MCI1_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x4000)|value<<14)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP2MCI1_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x4000) >> 14
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP2MCI1_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x8000)|value<<15)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP2MCI1_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x8000) >> 15
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP2MCI2_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x10000)|value<<16)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP2MCI2_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x10000) >> 16
}
func (o *MCPWM_Type) SetCAPCON_SET_CAP2MCI2_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x20000)|value<<17)
}
func (o *MCPWM_Type) GetCAPCON_SET_CAP2MCI2_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x20000) >> 17
}
func (o *MCPWM_Type) SetCAPCON_SET_RT0_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x40000)|value<<18)
}
func (o *MCPWM_Type) GetCAPCON_SET_RT0_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x40000) >> 18
}
func (o *MCPWM_Type) SetCAPCON_SET_RT1_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x80000)|value<<19)
}
func (o *MCPWM_Type) GetCAPCON_SET_RT1_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x80000) >> 19
}
func (o *MCPWM_Type) SetCAPCON_SET_RT2_SET(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0x100000)|value<<20)
}
func (o *MCPWM_Type) GetCAPCON_SET_RT2_SET() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0x100000) >> 20
}
func (o *MCPWM_Type) SetCAPCON_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CAPCON_SET.Reg, volatile.LoadUint32(&o.CAPCON_SET.Reg)&^(0xffe00000)|value<<21)
}
func (o *MCPWM_Type) GetCAPCON_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_SET.Reg) & 0xffe00000) >> 21
}

// MCPWM.CAPCON_CLR: Event Control clear address
func (o *MCPWM_Type) SetCAPCON_CLR_CAP0MCI0_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP0MCI0_RE_CLR() uint32 {
	return volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x1
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP0MCI0_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP0MCI0_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP0MCI1_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP0MCI1_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP0MCI1_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP0MCI1_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP0MCI2_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP0MCI2_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP0MCI2_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x20)|value<<5)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP0MCI2_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x20) >> 5
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP1MCI0_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x40)|value<<6)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP1MCI0_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x40) >> 6
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP1MCI0_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x80)|value<<7)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP1MCI0_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x80) >> 7
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP1MCI1_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP1MCI1_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP1MCI1_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP1MCI1_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP1MCI2_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP1MCI2_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP1MCI2_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x800)|value<<11)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP1MCI2_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x800) >> 11
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP2MCI0_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP2MCI0_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x1000) >> 12
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP2MCI0_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP2MCI0_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x2000) >> 13
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP2MCI1_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP2MCI1_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x4000) >> 14
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP2MCI1_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP2MCI1_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x8000) >> 15
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP2MCI2_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x10000)|value<<16)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP2MCI2_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x10000) >> 16
}
func (o *MCPWM_Type) SetCAPCON_CLR_CAP2MCI2_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x20000)|value<<17)
}
func (o *MCPWM_Type) GetCAPCON_CLR_CAP2MCI2_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x20000) >> 17
}
func (o *MCPWM_Type) SetCAPCON_CLR_RT0_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x40000)|value<<18)
}
func (o *MCPWM_Type) GetCAPCON_CLR_RT0_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x40000) >> 18
}
func (o *MCPWM_Type) SetCAPCON_CLR_RT1_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x80000)|value<<19)
}
func (o *MCPWM_Type) GetCAPCON_CLR_RT1_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x80000) >> 19
}
func (o *MCPWM_Type) SetCAPCON_CLR_RT2_CLR(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0x100000)|value<<20)
}
func (o *MCPWM_Type) GetCAPCON_CLR_RT2_CLR() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0x100000) >> 20
}
func (o *MCPWM_Type) SetCAPCON_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CAPCON_CLR.Reg, volatile.LoadUint32(&o.CAPCON_CLR.Reg)&^(0xffe00000)|value<<21)
}
func (o *MCPWM_Type) GetCAPCON_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CAPCON_CLR.Reg) & 0xffe00000) >> 21
}

// MCPWM.TC: Timer Counter register
func (o *MCPWM_Type) SetTC(idx int, value uint32) {
	volatile.StoreUint32(&o.TC[idx].Reg, value)
}
func (o *MCPWM_Type) GetTC(idx int) uint32 {
	return volatile.LoadUint32(&o.TC[idx].Reg)
}

// MCPWM.LIM: Limit register
func (o *MCPWM_Type) SetLIM(idx int, value uint32) {
	volatile.StoreUint32(&o.LIM[idx].Reg, value)
}
func (o *MCPWM_Type) GetLIM(idx int) uint32 {
	return volatile.LoadUint32(&o.LIM[idx].Reg)
}

// MCPWM.MAT: Match register
func (o *MCPWM_Type) SetMAT(idx int, value uint32) {
	volatile.StoreUint32(&o.MAT[idx].Reg, value)
}
func (o *MCPWM_Type) GetMAT(idx int) uint32 {
	return volatile.LoadUint32(&o.MAT[idx].Reg)
}

// MCPWM.DT: Dead time register
func (o *MCPWM_Type) SetDT_DT0(value uint32) {
	volatile.StoreUint32(&o.DT.Reg, volatile.LoadUint32(&o.DT.Reg)&^(0x3ff)|value)
}
func (o *MCPWM_Type) GetDT_DT0() uint32 {
	return volatile.LoadUint32(&o.DT.Reg) & 0x3ff
}
func (o *MCPWM_Type) SetDT_DT1(value uint32) {
	volatile.StoreUint32(&o.DT.Reg, volatile.LoadUint32(&o.DT.Reg)&^(0xffc00)|value<<10)
}
func (o *MCPWM_Type) GetDT_DT1() uint32 {
	return (volatile.LoadUint32(&o.DT.Reg) & 0xffc00) >> 10
}
func (o *MCPWM_Type) SetDT_DT2(value uint32) {
	volatile.StoreUint32(&o.DT.Reg, volatile.LoadUint32(&o.DT.Reg)&^(0x3ff00000)|value<<20)
}
func (o *MCPWM_Type) GetDT_DT2() uint32 {
	return (volatile.LoadUint32(&o.DT.Reg) & 0x3ff00000) >> 20
}
func (o *MCPWM_Type) SetDT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DT.Reg, volatile.LoadUint32(&o.DT.Reg)&^(0xc0000000)|value<<30)
}
func (o *MCPWM_Type) GetDT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DT.Reg) & 0xc0000000) >> 30
}

// MCPWM.CP: Communication Pattern register
func (o *MCPWM_Type) SetCP_CCPA0(value uint32) {
	volatile.StoreUint32(&o.CP.Reg, volatile.LoadUint32(&o.CP.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetCP_CCPA0() uint32 {
	return volatile.LoadUint32(&o.CP.Reg) & 0x1
}
func (o *MCPWM_Type) SetCP_CCPB0(value uint32) {
	volatile.StoreUint32(&o.CP.Reg, volatile.LoadUint32(&o.CP.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetCP_CCPB0() uint32 {
	return (volatile.LoadUint32(&o.CP.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetCP_CCPA1(value uint32) {
	volatile.StoreUint32(&o.CP.Reg, volatile.LoadUint32(&o.CP.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetCP_CCPA1() uint32 {
	return (volatile.LoadUint32(&o.CP.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetCP_CCPB1(value uint32) {
	volatile.StoreUint32(&o.CP.Reg, volatile.LoadUint32(&o.CP.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetCP_CCPB1() uint32 {
	return (volatile.LoadUint32(&o.CP.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetCP_CCPA2(value uint32) {
	volatile.StoreUint32(&o.CP.Reg, volatile.LoadUint32(&o.CP.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetCP_CCPA2() uint32 {
	return (volatile.LoadUint32(&o.CP.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetCP_CCPB2(value uint32) {
	volatile.StoreUint32(&o.CP.Reg, volatile.LoadUint32(&o.CP.Reg)&^(0x20)|value<<5)
}
func (o *MCPWM_Type) GetCP_CCPB2() uint32 {
	return (volatile.LoadUint32(&o.CP.Reg) & 0x20) >> 5
}
func (o *MCPWM_Type) SetCP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CP.Reg, volatile.LoadUint32(&o.CP.Reg)&^(0xffffffc0)|value<<6)
}
func (o *MCPWM_Type) GetCP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CP.Reg) & 0xffffffc0) >> 6
}

// MCPWM.CAP: Capture register
func (o *MCPWM_Type) SetCAP(idx int, value uint32) {
	volatile.StoreUint32(&o.CAP[idx].Reg, value)
}
func (o *MCPWM_Type) GetCAP(idx int) uint32 {
	return volatile.LoadUint32(&o.CAP[idx].Reg)
}

// MCPWM.INTEN: Interrupt Enable read address
func (o *MCPWM_Type) SetINTEN_ILIM0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetINTEN_ILIM0() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *MCPWM_Type) SetINTEN_IMAT0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetINTEN_IMAT0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetINTEN_ICAP0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetINTEN_ICAP0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetINTEN_ILIM1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetINTEN_ILIM1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetINTEN_IMAT1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *MCPWM_Type) GetINTEN_IMAT1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *MCPWM_Type) SetINTEN_ICAP1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *MCPWM_Type) GetINTEN_ICAP1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *MCPWM_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *MCPWM_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *MCPWM_Type) SetINTEN_ILIM2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetINTEN_ILIM2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetINTEN_IMAT2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetINTEN_IMAT2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetINTEN_ICAP2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetINTEN_ICAP2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x7800)|value<<11)
}
func (o *MCPWM_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x7800) >> 11
}
func (o *MCPWM_Type) SetINTEN_ABORT(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000)|value<<15)
}
func (o *MCPWM_Type) GetINTEN_ABORT() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000) >> 15
}
func (o *MCPWM_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0xffff0000)|value<<16)
}
func (o *MCPWM_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0xffff0000) >> 16
}

// MCPWM.INTEN_SET: Interrupt Enable set address
func (o *MCPWM_Type) SetINTEN_SET_ILIM0_SET(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetINTEN_SET_ILIM0_SET() uint32 {
	return volatile.LoadUint32(&o.INTEN_SET.Reg) & 0x1
}
func (o *MCPWM_Type) SetINTEN_SET_IMAT0_SET(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetINTEN_SET_IMAT0_SET() uint32 {
	return (volatile.LoadUint32(&o.INTEN_SET.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetINTEN_SET_ICAP0_SET(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetINTEN_SET_ICAP0_SET() uint32 {
	return (volatile.LoadUint32(&o.INTEN_SET.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetINTEN_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetINTEN_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN_SET.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetINTEN_SET_ILIM1_SET(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetINTEN_SET_ILIM1_SET() uint32 {
	return (volatile.LoadUint32(&o.INTEN_SET.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetINTEN_SET_IMAT1_SET(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0x20)|value<<5)
}
func (o *MCPWM_Type) GetINTEN_SET_IMAT1_SET() uint32 {
	return (volatile.LoadUint32(&o.INTEN_SET.Reg) & 0x20) >> 5
}
func (o *MCPWM_Type) SetINTEN_SET_ICAP1_SET(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0x40)|value<<6)
}
func (o *MCPWM_Type) GetINTEN_SET_ICAP1_SET() uint32 {
	return (volatile.LoadUint32(&o.INTEN_SET.Reg) & 0x40) >> 6
}
func (o *MCPWM_Type) SetINTEN_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0x80)|value<<7)
}
func (o *MCPWM_Type) GetINTEN_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN_SET.Reg) & 0x80) >> 7
}
func (o *MCPWM_Type) SetINTEN_SET_ILIM2_SET(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetINTEN_SET_ILIM2_SET() uint32 {
	return (volatile.LoadUint32(&o.INTEN_SET.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetINTEN_SET_IMAT2_SET(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetINTEN_SET_IMAT2_SET() uint32 {
	return (volatile.LoadUint32(&o.INTEN_SET.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetINTEN_SET_ICAP2_SET(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0x800)|value<<11)
}
func (o *MCPWM_Type) GetINTEN_SET_ICAP2_SET() uint32 {
	return (volatile.LoadUint32(&o.INTEN_SET.Reg) & 0x800) >> 11
}
func (o *MCPWM_Type) SetINTEN_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0x7000)|value<<12)
}
func (o *MCPWM_Type) GetINTEN_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN_SET.Reg) & 0x7000) >> 12
}
func (o *MCPWM_Type) SetINTEN_SET_ABORT_SET(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0x8000)|value<<15)
}
func (o *MCPWM_Type) GetINTEN_SET_ABORT_SET() uint32 {
	return (volatile.LoadUint32(&o.INTEN_SET.Reg) & 0x8000) >> 15
}
func (o *MCPWM_Type) SetINTEN_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN_SET.Reg, volatile.LoadUint32(&o.INTEN_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *MCPWM_Type) GetINTEN_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN_SET.Reg) & 0xffff0000) >> 16
}

// MCPWM.INTEN_CLR: Interrupt Enable clear address
func (o *MCPWM_Type) SetINTEN_CLR_ILIM0_CLR(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetINTEN_CLR_ILIM0_CLR() uint32 {
	return volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0x1
}
func (o *MCPWM_Type) SetINTEN_CLR_IMAT0_CLR(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetINTEN_CLR_IMAT0_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetINTEN_CLR_ICAP0_CLR(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetINTEN_CLR_ICAP0_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetINTEN_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetINTEN_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetINTEN_CLR_ILIM1_CLR(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetINTEN_CLR_ILIM1_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetINTEN_CLR_IMAT1_CLR(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0x20)|value<<5)
}
func (o *MCPWM_Type) GetINTEN_CLR_IMAT1_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0x20) >> 5
}
func (o *MCPWM_Type) SetINTEN_CLR_ICAP1_CLR(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0x40)|value<<6)
}
func (o *MCPWM_Type) GetINTEN_CLR_ICAP1_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0x40) >> 6
}
func (o *MCPWM_Type) SetINTEN_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0x80)|value<<7)
}
func (o *MCPWM_Type) GetINTEN_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0x80) >> 7
}
func (o *MCPWM_Type) SetINTEN_CLR_ILIM2_CLR(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetINTEN_CLR_ILIM2_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetINTEN_CLR_IMAT2_CLR(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetINTEN_CLR_IMAT2_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetINTEN_CLR_ICAP2_CLR(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetINTEN_CLR_ICAP2_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetINTEN_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0x7800)|value<<11)
}
func (o *MCPWM_Type) GetINTEN_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0x7800) >> 11
}
func (o *MCPWM_Type) SetINTEN_CLR_ABORT_CLR(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *MCPWM_Type) GetINTEN_CLR_ABORT_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0x8000) >> 15
}
func (o *MCPWM_Type) SetINTEN_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN_CLR.Reg, volatile.LoadUint32(&o.INTEN_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *MCPWM_Type) GetINTEN_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN_CLR.Reg) & 0xffff0000) >> 16
}

// MCPWM.CNTCON: Count Control read address
func (o *MCPWM_Type) SetCNTCON_TC0MCI0_RE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetCNTCON_TC0MCI0_RE() uint32 {
	return volatile.LoadUint32(&o.CNTCON.Reg) & 0x1
}
func (o *MCPWM_Type) SetCNTCON_TC0MCI0_FE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetCNTCON_TC0MCI0_FE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetCNTCON_TC0MCI1_RE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetCNTCON_TC0MCI1_RE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetCNTCON_TC0MCI1_FE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetCNTCON_TC0MCI1_FE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetCNTCON_TC0MCI2_RE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetCNTCON_TC0MCI2_RE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetCNTCON_TC0MCI2_FE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x20)|value<<5)
}
func (o *MCPWM_Type) GetCNTCON_TC0MCI2_FE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x20) >> 5
}
func (o *MCPWM_Type) SetCNTCON_TC1MCI0_RE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x40)|value<<6)
}
func (o *MCPWM_Type) GetCNTCON_TC1MCI0_RE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x40) >> 6
}
func (o *MCPWM_Type) SetCNTCON_TC1MCI0_FE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x80)|value<<7)
}
func (o *MCPWM_Type) GetCNTCON_TC1MCI0_FE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x80) >> 7
}
func (o *MCPWM_Type) SetCNTCON_TC1MCI1_RE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetCNTCON_TC1MCI1_RE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetCNTCON_TC1MCI1_FE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetCNTCON_TC1MCI1_FE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetCNTCON_TC1MCI2_RE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetCNTCON_TC1MCI2_RE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetCNTCON_TC1MCI2_FE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x800)|value<<11)
}
func (o *MCPWM_Type) GetCNTCON_TC1MCI2_FE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x800) >> 11
}
func (o *MCPWM_Type) SetCNTCON_TC2MCI0_RE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x1000)|value<<12)
}
func (o *MCPWM_Type) GetCNTCON_TC2MCI0_RE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x1000) >> 12
}
func (o *MCPWM_Type) SetCNTCON_TC2MCI0_FE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x2000)|value<<13)
}
func (o *MCPWM_Type) GetCNTCON_TC2MCI0_FE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x2000) >> 13
}
func (o *MCPWM_Type) SetCNTCON_TC2MCI1_RE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x4000)|value<<14)
}
func (o *MCPWM_Type) GetCNTCON_TC2MCI1_RE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x4000) >> 14
}
func (o *MCPWM_Type) SetCNTCON_TC2MCI1_FE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x8000)|value<<15)
}
func (o *MCPWM_Type) GetCNTCON_TC2MCI1_FE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x8000) >> 15
}
func (o *MCPWM_Type) SetCNTCON_TC2MCI2_RE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x10000)|value<<16)
}
func (o *MCPWM_Type) GetCNTCON_TC2MCI2_RE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x10000) >> 16
}
func (o *MCPWM_Type) SetCNTCON_TC2MCI2_FE(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x20000)|value<<17)
}
func (o *MCPWM_Type) GetCNTCON_TC2MCI2_FE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x20000) >> 17
}
func (o *MCPWM_Type) SetCNTCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *MCPWM_Type) GetCNTCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x1ffc0000) >> 18
}
func (o *MCPWM_Type) SetCNTCON_CNTR0(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x20000000)|value<<29)
}
func (o *MCPWM_Type) GetCNTCON_CNTR0() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x20000000) >> 29
}
func (o *MCPWM_Type) SetCNTCON_CNTR1(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x40000000)|value<<30)
}
func (o *MCPWM_Type) GetCNTCON_CNTR1() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x40000000) >> 30
}
func (o *MCPWM_Type) SetCNTCON_CNTR2(value uint32) {
	volatile.StoreUint32(&o.CNTCON.Reg, volatile.LoadUint32(&o.CNTCON.Reg)&^(0x80000000)|value<<31)
}
func (o *MCPWM_Type) GetCNTCON_CNTR2() uint32 {
	return (volatile.LoadUint32(&o.CNTCON.Reg) & 0x80000000) >> 31
}

// MCPWM.CNTCON_SET: Count Control set address
func (o *MCPWM_Type) SetCNTCON_SET_TC0MCI0_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC0MCI0_RE_SET() uint32 {
	return volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x1
}
func (o *MCPWM_Type) SetCNTCON_SET_TC0MCI0_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC0MCI0_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetCNTCON_SET_TC0MCI1_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC0MCI1_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetCNTCON_SET_TC0MCI1_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC0MCI1_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetCNTCON_SET_TC0MCI2_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC0MCI2_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetCNTCON_SET_TC0MCI2_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x20)|value<<5)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC0MCI2_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x20) >> 5
}
func (o *MCPWM_Type) SetCNTCON_SET_TC1MCI0_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x40)|value<<6)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC1MCI0_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x40) >> 6
}
func (o *MCPWM_Type) SetCNTCON_SET_TC1MCI0_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x80)|value<<7)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC1MCI0_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x80) >> 7
}
func (o *MCPWM_Type) SetCNTCON_SET_TC1MCI1_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC1MCI1_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetCNTCON_SET_TC1MCI1_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC1MCI1_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetCNTCON_SET_TC1MCI2_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC1MCI2_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetCNTCON_SET_TC1MCI2_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x800)|value<<11)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC1MCI2_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x800) >> 11
}
func (o *MCPWM_Type) SetCNTCON_SET_TC2MCI0_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x1000)|value<<12)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC2MCI0_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x1000) >> 12
}
func (o *MCPWM_Type) SetCNTCON_SET_TC2MCI0_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x2000)|value<<13)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC2MCI0_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x2000) >> 13
}
func (o *MCPWM_Type) SetCNTCON_SET_TC2MCI1_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x4000)|value<<14)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC2MCI1_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x4000) >> 14
}
func (o *MCPWM_Type) SetCNTCON_SET_TC2MCI1_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x8000)|value<<15)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC2MCI1_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x8000) >> 15
}
func (o *MCPWM_Type) SetCNTCON_SET_TC2MCI2_RE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x10000)|value<<16)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC2MCI2_RE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x10000) >> 16
}
func (o *MCPWM_Type) SetCNTCON_SET_TC2MCI2_FE_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x20000)|value<<17)
}
func (o *MCPWM_Type) GetCNTCON_SET_TC2MCI2_FE_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x20000) >> 17
}
func (o *MCPWM_Type) SetCNTCON_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *MCPWM_Type) GetCNTCON_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x1ffc0000) >> 18
}
func (o *MCPWM_Type) SetCNTCON_SET_CNTR0_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x20000000)|value<<29)
}
func (o *MCPWM_Type) GetCNTCON_SET_CNTR0_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x20000000) >> 29
}
func (o *MCPWM_Type) SetCNTCON_SET_CNTR1_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x40000000)|value<<30)
}
func (o *MCPWM_Type) GetCNTCON_SET_CNTR1_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x40000000) >> 30
}
func (o *MCPWM_Type) SetCNTCON_SET_CNTR2_SET(value uint32) {
	volatile.StoreUint32(&o.CNTCON_SET.Reg, volatile.LoadUint32(&o.CNTCON_SET.Reg)&^(0x80000000)|value<<31)
}
func (o *MCPWM_Type) GetCNTCON_SET_CNTR2_SET() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_SET.Reg) & 0x80000000) >> 31
}

// MCPWM.CNTCON_CLR: Count Control clear address
func (o *MCPWM_Type) SetCNTCON_CLR_TC0MCI0_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC0MCI0_RE_CLR() uint32 {
	return volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x1
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC0MCI0_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC0MCI0_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC0MCI1_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC0MCI1_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC0MCI1_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC0MCI1_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC0MCI2_RE(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC0MCI2_RE() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC0MCI2_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x20)|value<<5)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC0MCI2_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x20) >> 5
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC1MCI0_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x40)|value<<6)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC1MCI0_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x40) >> 6
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC1MCI0_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x80)|value<<7)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC1MCI0_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x80) >> 7
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC1MCI1_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC1MCI1_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC1MCI1_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC1MCI1_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC1MCI2_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC1MCI2_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC1MCI2_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x800)|value<<11)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC1MCI2_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x800) >> 11
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC2MCI0_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x1000)|value<<12)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC2MCI0_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x1000) >> 12
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC2MCI0_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x2000)|value<<13)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC2MCI0_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x2000) >> 13
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC2MCI1_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x4000)|value<<14)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC2MCI1_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x4000) >> 14
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC2MCI1_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC2MCI1_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x8000) >> 15
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC2MCI2_RE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x10000)|value<<16)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC2MCI2_RE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x10000) >> 16
}
func (o *MCPWM_Type) SetCNTCON_CLR_TC2MCI2_FE_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x20000)|value<<17)
}
func (o *MCPWM_Type) GetCNTCON_CLR_TC2MCI2_FE_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x20000) >> 17
}
func (o *MCPWM_Type) SetCNTCON_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x1ffc0000)|value<<18)
}
func (o *MCPWM_Type) GetCNTCON_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x1ffc0000) >> 18
}
func (o *MCPWM_Type) SetCNTCON_CLR_CNTR0_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x20000000)|value<<29)
}
func (o *MCPWM_Type) GetCNTCON_CLR_CNTR0_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x20000000) >> 29
}
func (o *MCPWM_Type) SetCNTCON_CLR_CNTR1_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x40000000)|value<<30)
}
func (o *MCPWM_Type) GetCNTCON_CLR_CNTR1_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x40000000) >> 30
}
func (o *MCPWM_Type) SetCNTCON_CLR_CNTR2_CLR(value uint32) {
	volatile.StoreUint32(&o.CNTCON_CLR.Reg, volatile.LoadUint32(&o.CNTCON_CLR.Reg)&^(0x80000000)|value<<31)
}
func (o *MCPWM_Type) GetCNTCON_CLR_CNTR2_CLR() uint32 {
	return (volatile.LoadUint32(&o.CNTCON_CLR.Reg) & 0x80000000) >> 31
}

// MCPWM.INTF: Interrupt flags read address
func (o *MCPWM_Type) SetINTF_ILIM0_F(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetINTF_ILIM0_F() uint32 {
	return volatile.LoadUint32(&o.INTF.Reg) & 0x1
}
func (o *MCPWM_Type) SetINTF_IMAT0_F(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetINTF_IMAT0_F() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetINTF_ICAP0_F(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetINTF_ICAP0_F() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetINTF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetINTF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetINTF_ILIM1_F(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetINTF_ILIM1_F() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetINTF_IMAT1_F(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x20)|value<<5)
}
func (o *MCPWM_Type) GetINTF_IMAT1_F() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x20) >> 5
}
func (o *MCPWM_Type) SetINTF_ICAP1_F(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x40)|value<<6)
}
func (o *MCPWM_Type) GetINTF_ICAP1_F() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x40) >> 6
}
func (o *MCPWM_Type) SetINTF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x80)|value<<7)
}
func (o *MCPWM_Type) GetINTF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x80) >> 7
}
func (o *MCPWM_Type) SetINTF_ILIM2_F(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetINTF_ILIM2_F() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetINTF_IMAT2_F(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetINTF_IMAT2_F() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetINTF_ICAP2_F(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetINTF_ICAP2_F() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetINTF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x7800)|value<<11)
}
func (o *MCPWM_Type) GetINTF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x7800) >> 11
}
func (o *MCPWM_Type) SetINTF_ABORT_F(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0x8000)|value<<15)
}
func (o *MCPWM_Type) GetINTF_ABORT_F() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0x8000) >> 15
}
func (o *MCPWM_Type) SetINTF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTF.Reg, volatile.LoadUint32(&o.INTF.Reg)&^(0xffff0000)|value<<16)
}
func (o *MCPWM_Type) GetINTF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTF.Reg) & 0xffff0000) >> 16
}

// MCPWM.INTF_SET: Interrupt flags set address
func (o *MCPWM_Type) SetINTF_SET_ILIM0_F_SET(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetINTF_SET_ILIM0_F_SET() uint32 {
	return volatile.LoadUint32(&o.INTF_SET.Reg) & 0x1
}
func (o *MCPWM_Type) SetINTF_SET_IMAT0_F_SET(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetINTF_SET_IMAT0_F_SET() uint32 {
	return (volatile.LoadUint32(&o.INTF_SET.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetINTF_SET_ICAP0_F_SET(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetINTF_SET_ICAP0_F_SET() uint32 {
	return (volatile.LoadUint32(&o.INTF_SET.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetINTF_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetINTF_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTF_SET.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetINTF_SET_ILIM1_F_SET(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetINTF_SET_ILIM1_F_SET() uint32 {
	return (volatile.LoadUint32(&o.INTF_SET.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetINTF_SET_IMAT1_F_SET(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0x20)|value<<5)
}
func (o *MCPWM_Type) GetINTF_SET_IMAT1_F_SET() uint32 {
	return (volatile.LoadUint32(&o.INTF_SET.Reg) & 0x20) >> 5
}
func (o *MCPWM_Type) SetINTF_SET_ICAP1_F_SET(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0x40)|value<<6)
}
func (o *MCPWM_Type) GetINTF_SET_ICAP1_F_SET() uint32 {
	return (volatile.LoadUint32(&o.INTF_SET.Reg) & 0x40) >> 6
}
func (o *MCPWM_Type) SetINTF_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0x80)|value<<7)
}
func (o *MCPWM_Type) GetINTF_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTF_SET.Reg) & 0x80) >> 7
}
func (o *MCPWM_Type) SetINTF_SET_ILIM2_F_SET(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetINTF_SET_ILIM2_F_SET() uint32 {
	return (volatile.LoadUint32(&o.INTF_SET.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetINTF_SET_IMAT2_F_SET(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetINTF_SET_IMAT2_F_SET() uint32 {
	return (volatile.LoadUint32(&o.INTF_SET.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetINTF_SET_ICAP2_F_SET(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetINTF_SET_ICAP2_F_SET() uint32 {
	return (volatile.LoadUint32(&o.INTF_SET.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetINTF_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0x7800)|value<<11)
}
func (o *MCPWM_Type) GetINTF_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTF_SET.Reg) & 0x7800) >> 11
}
func (o *MCPWM_Type) SetINTF_SET_ABORT_F_SET(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0x8000)|value<<15)
}
func (o *MCPWM_Type) GetINTF_SET_ABORT_F_SET() uint32 {
	return (volatile.LoadUint32(&o.INTF_SET.Reg) & 0x8000) >> 15
}
func (o *MCPWM_Type) SetINTF_SET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTF_SET.Reg, volatile.LoadUint32(&o.INTF_SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *MCPWM_Type) GetINTF_SET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTF_SET.Reg) & 0xffff0000) >> 16
}

// MCPWM.INTF_CLR: Interrupt flags clear address
func (o *MCPWM_Type) SetINTF_CLR_ILIM0_F_CLR(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetINTF_CLR_ILIM0_F_CLR() uint32 {
	return volatile.LoadUint32(&o.INTF_CLR.Reg) & 0x1
}
func (o *MCPWM_Type) SetINTF_CLR_IMAT0_F_CLR(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetINTF_CLR_IMAT0_F_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTF_CLR.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetINTF_CLR_ICAP0_F_CLR(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetINTF_CLR_ICAP0_F_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTF_CLR.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetINTF_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0x8)|value<<3)
}
func (o *MCPWM_Type) GetINTF_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTF_CLR.Reg) & 0x8) >> 3
}
func (o *MCPWM_Type) SetINTF_CLR_ILIM1_F_CLR(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0x10)|value<<4)
}
func (o *MCPWM_Type) GetINTF_CLR_ILIM1_F_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTF_CLR.Reg) & 0x10) >> 4
}
func (o *MCPWM_Type) SetINTF_CLR_IMAT1_F_CLR(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0x20)|value<<5)
}
func (o *MCPWM_Type) GetINTF_CLR_IMAT1_F_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTF_CLR.Reg) & 0x20) >> 5
}
func (o *MCPWM_Type) SetINTF_CLR_ICAP1_F_CLR(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0x40)|value<<6)
}
func (o *MCPWM_Type) GetINTF_CLR_ICAP1_F_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTF_CLR.Reg) & 0x40) >> 6
}
func (o *MCPWM_Type) SetINTF_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0x80)|value<<7)
}
func (o *MCPWM_Type) GetINTF_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTF_CLR.Reg) & 0x80) >> 7
}
func (o *MCPWM_Type) SetINTF_CLR_ILIM2_F_CLR(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0x100)|value<<8)
}
func (o *MCPWM_Type) GetINTF_CLR_ILIM2_F_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTF_CLR.Reg) & 0x100) >> 8
}
func (o *MCPWM_Type) SetINTF_CLR_IMAT2_F_CLR(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0x200)|value<<9)
}
func (o *MCPWM_Type) GetINTF_CLR_IMAT2_F_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTF_CLR.Reg) & 0x200) >> 9
}
func (o *MCPWM_Type) SetINTF_CLR_ICAP2_F_CLR(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0x400)|value<<10)
}
func (o *MCPWM_Type) GetINTF_CLR_ICAP2_F_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTF_CLR.Reg) & 0x400) >> 10
}
func (o *MCPWM_Type) SetINTF_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0x7800)|value<<11)
}
func (o *MCPWM_Type) GetINTF_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTF_CLR.Reg) & 0x7800) >> 11
}
func (o *MCPWM_Type) SetINTF_CLR_ABORT_F_CLR(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0x8000)|value<<15)
}
func (o *MCPWM_Type) GetINTF_CLR_ABORT_F_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTF_CLR.Reg) & 0x8000) >> 15
}
func (o *MCPWM_Type) SetINTF_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTF_CLR.Reg, volatile.LoadUint32(&o.INTF_CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *MCPWM_Type) GetINTF_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTF_CLR.Reg) & 0xffff0000) >> 16
}

// MCPWM.CAP_CLR: Capture clear address
func (o *MCPWM_Type) SetCAP_CLR_CAP_CLR0(value uint32) {
	volatile.StoreUint32(&o.CAP_CLR.Reg, volatile.LoadUint32(&o.CAP_CLR.Reg)&^(0x1)|value)
}
func (o *MCPWM_Type) GetCAP_CLR_CAP_CLR0() uint32 {
	return volatile.LoadUint32(&o.CAP_CLR.Reg) & 0x1
}
func (o *MCPWM_Type) SetCAP_CLR_CAP_CLR1(value uint32) {
	volatile.StoreUint32(&o.CAP_CLR.Reg, volatile.LoadUint32(&o.CAP_CLR.Reg)&^(0x2)|value<<1)
}
func (o *MCPWM_Type) GetCAP_CLR_CAP_CLR1() uint32 {
	return (volatile.LoadUint32(&o.CAP_CLR.Reg) & 0x2) >> 1
}
func (o *MCPWM_Type) SetCAP_CLR_CAP_CLR2(value uint32) {
	volatile.StoreUint32(&o.CAP_CLR.Reg, volatile.LoadUint32(&o.CAP_CLR.Reg)&^(0x4)|value<<2)
}
func (o *MCPWM_Type) GetCAP_CLR_CAP_CLR2() uint32 {
	return (volatile.LoadUint32(&o.CAP_CLR.Reg) & 0x4) >> 2
}
func (o *MCPWM_Type) SetCAP_CLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CAP_CLR.Reg, volatile.LoadUint32(&o.CAP_CLR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MCPWM_Type) GetCAP_CLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CAP_CLR.Reg) & 0xfffffff8) >> 3
}

// Quadrature Encoder Interface (QEI)
type QEI_Type struct {
	CON     volatile.Register32 // 0x0
	STAT    volatile.Register32 // 0x4
	CONF    volatile.Register32 // 0x8
	POS     volatile.Register32 // 0xC
	MAXPOS  volatile.Register32 // 0x10
	CMPOS0  volatile.Register32 // 0x14
	CMPOS1  volatile.Register32 // 0x18
	CMPOS2  volatile.Register32 // 0x1C
	INXCNT  volatile.Register32 // 0x20
	INXCMP0 volatile.Register32 // 0x24
	LOAD    volatile.Register32 // 0x28
	TIME    volatile.Register32 // 0x2C
	VEL     volatile.Register32 // 0x30
	CAP     volatile.Register32 // 0x34
	VELCOMP volatile.Register32 // 0x38
	FILTER  volatile.Register32 // 0x3C
	_       [3992]byte
	IEC     volatile.Register32 // 0xFD8
	IES     volatile.Register32 // 0xFDC
	INTSTAT volatile.Register32 // 0xFE0
	IE      volatile.Register32 // 0xFE4
	CLR     volatile.Register32 // 0xFE8
	SET     volatile.Register32 // 0xFEC
}

// QEI.CON: Control register
func (o *QEI_Type) SetCON_RESP(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetCON_RESP() uint32 {
	return volatile.LoadUint32(&o.CON.Reg) & 0x1
}
func (o *QEI_Type) SetCON_RESPI(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetCON_RESPI() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetCON_RESV(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetCON_RESV() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetCON_RESI(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetCON_RESI() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CON.Reg, volatile.LoadUint32(&o.CON.Reg)&^(0xfffffff0)|value<<4)
}
func (o *QEI_Type) GetCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CON.Reg) & 0xfffffff0) >> 4
}

// QEI.STAT: Status register
func (o *QEI_Type) SetSTAT_DIR(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetSTAT_DIR() uint32 {
	return volatile.LoadUint32(&o.STAT.Reg) & 0x1
}
func (o *QEI_Type) SetSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STAT.Reg, volatile.LoadUint32(&o.STAT.Reg)&^(0xfffffffe)|value<<1)
}
func (o *QEI_Type) GetSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STAT.Reg) & 0xfffffffe) >> 1
}

// QEI.CONF: Configuration register
func (o *QEI_Type) SetCONF_DIRINV(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetCONF_DIRINV() uint32 {
	return volatile.LoadUint32(&o.CONF.Reg) & 0x1
}
func (o *QEI_Type) SetCONF_SIGMODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetCONF_SIGMODE() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetCONF_CAPMODE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetCONF_CAPMODE() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetCONF_INVINX(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetCONF_INVINX() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetCONF_CRESPI(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetCONF_CRESPI() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetCONF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xffe0)|value<<5)
}
func (o *QEI_Type) GetCONF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0xffe0) >> 5
}
func (o *QEI_Type) SetCONF_INXGATE(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xf0000)|value<<16)
}
func (o *QEI_Type) GetCONF_INXGATE() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0xf0000) >> 16
}
func (o *QEI_Type) SetCONF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONF.Reg, volatile.LoadUint32(&o.CONF.Reg)&^(0xfff00000)|value<<20)
}
func (o *QEI_Type) GetCONF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONF.Reg) & 0xfff00000) >> 20
}

// QEI.POS: Position register
func (o *QEI_Type) SetPOS(value uint32) {
	volatile.StoreUint32(&o.POS.Reg, value)
}
func (o *QEI_Type) GetPOS() uint32 {
	return volatile.LoadUint32(&o.POS.Reg)
}

// QEI.MAXPOS: Maximum position register
func (o *QEI_Type) SetMAXPOS(value uint32) {
	volatile.StoreUint32(&o.MAXPOS.Reg, value)
}
func (o *QEI_Type) GetMAXPOS() uint32 {
	return volatile.LoadUint32(&o.MAXPOS.Reg)
}

// QEI.CMPOS0: Position compare register 0
func (o *QEI_Type) SetCMPOS0(value uint32) {
	volatile.StoreUint32(&o.CMPOS0.Reg, value)
}
func (o *QEI_Type) GetCMPOS0() uint32 {
	return volatile.LoadUint32(&o.CMPOS0.Reg)
}

// QEI.CMPOS1: Position compare register 1
func (o *QEI_Type) SetCMPOS1(value uint32) {
	volatile.StoreUint32(&o.CMPOS1.Reg, value)
}
func (o *QEI_Type) GetCMPOS1() uint32 {
	return volatile.LoadUint32(&o.CMPOS1.Reg)
}

// QEI.CMPOS2: Position compare register 2
func (o *QEI_Type) SetCMPOS2(value uint32) {
	volatile.StoreUint32(&o.CMPOS2.Reg, value)
}
func (o *QEI_Type) GetCMPOS2() uint32 {
	return volatile.LoadUint32(&o.CMPOS2.Reg)
}

// QEI.INXCNT: Index count register 0
func (o *QEI_Type) SetINXCNT(value uint32) {
	volatile.StoreUint32(&o.INXCNT.Reg, value)
}
func (o *QEI_Type) GetINXCNT() uint32 {
	return volatile.LoadUint32(&o.INXCNT.Reg)
}

// QEI.INXCMP0: Index compare register 0
func (o *QEI_Type) SetINXCMP0(value uint32) {
	volatile.StoreUint32(&o.INXCMP0.Reg, value)
}
func (o *QEI_Type) GetINXCMP0() uint32 {
	return volatile.LoadUint32(&o.INXCMP0.Reg)
}

// QEI.LOAD: Velocity timer reload register
func (o *QEI_Type) SetLOAD(value uint32) {
	volatile.StoreUint32(&o.LOAD.Reg, value)
}
func (o *QEI_Type) GetLOAD() uint32 {
	return volatile.LoadUint32(&o.LOAD.Reg)
}

// QEI.TIME: Velocity timer register
func (o *QEI_Type) SetTIME(value uint32) {
	volatile.StoreUint32(&o.TIME.Reg, value)
}
func (o *QEI_Type) GetTIME() uint32 {
	return volatile.LoadUint32(&o.TIME.Reg)
}

// QEI.VEL: Velocity counter register
func (o *QEI_Type) SetVEL(value uint32) {
	volatile.StoreUint32(&o.VEL.Reg, value)
}
func (o *QEI_Type) GetVEL() uint32 {
	return volatile.LoadUint32(&o.VEL.Reg)
}

// QEI.CAP: Velocity capture register
func (o *QEI_Type) SetCAP(value uint32) {
	volatile.StoreUint32(&o.CAP.Reg, value)
}
func (o *QEI_Type) GetCAP() uint32 {
	return volatile.LoadUint32(&o.CAP.Reg)
}

// QEI.VELCOMP: Velocity compare register
func (o *QEI_Type) SetVELCOMP(value uint32) {
	volatile.StoreUint32(&o.VELCOMP.Reg, value)
}
func (o *QEI_Type) GetVELCOMP() uint32 {
	return volatile.LoadUint32(&o.VELCOMP.Reg)
}

// QEI.FILTER: Digital filter register
func (o *QEI_Type) SetFILTER(value uint32) {
	volatile.StoreUint32(&o.FILTER.Reg, value)
}
func (o *QEI_Type) GetFILTER() uint32 {
	return volatile.LoadUint32(&o.FILTER.Reg)
}

// QEI.IEC: Interrupt enable clear register
func (o *QEI_Type) SetIEC_INX_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetIEC_INX_INT() uint32 {
	return volatile.LoadUint32(&o.IEC.Reg) & 0x1
}
func (o *QEI_Type) SetIEC_TIM_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetIEC_TIM_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetIEC_VELC_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetIEC_VELC_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetIEC_DIR_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetIEC_DIR_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetIEC_ERR_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetIEC_ERR_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetIEC_ENCLK_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x20)|value<<5)
}
func (o *QEI_Type) GetIEC_ENCLK_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x20) >> 5
}
func (o *QEI_Type) SetIEC_POS0_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x40)|value<<6)
}
func (o *QEI_Type) GetIEC_POS0_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x40) >> 6
}
func (o *QEI_Type) SetIEC_POS1_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x80)|value<<7)
}
func (o *QEI_Type) GetIEC_POS1_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x80) >> 7
}
func (o *QEI_Type) SetIEC_POS2_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x100)|value<<8)
}
func (o *QEI_Type) GetIEC_POS2_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x100) >> 8
}
func (o *QEI_Type) SetIEC_REV0_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x200)|value<<9)
}
func (o *QEI_Type) GetIEC_REV0_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x200) >> 9
}
func (o *QEI_Type) SetIEC_POS0REV_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x400)|value<<10)
}
func (o *QEI_Type) GetIEC_POS0REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x400) >> 10
}
func (o *QEI_Type) SetIEC_POS1REV_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x800)|value<<11)
}
func (o *QEI_Type) GetIEC_POS1REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x800) >> 11
}
func (o *QEI_Type) SetIEC_POS2REV_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x1000)|value<<12)
}
func (o *QEI_Type) GetIEC_POS2REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x1000) >> 12
}
func (o *QEI_Type) SetIEC_REV1_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x2000)|value<<13)
}
func (o *QEI_Type) GetIEC_REV1_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x2000) >> 13
}
func (o *QEI_Type) SetIEC_REV2_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x4000)|value<<14)
}
func (o *QEI_Type) GetIEC_REV2_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x4000) >> 14
}
func (o *QEI_Type) SetIEC_MAXPOS_INT(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0x8000)|value<<15)
}
func (o *QEI_Type) GetIEC_MAXPOS_INT() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0x8000) >> 15
}
func (o *QEI_Type) SetIEC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IEC.Reg, volatile.LoadUint32(&o.IEC.Reg)&^(0xffff0000)|value<<16)
}
func (o *QEI_Type) GetIEC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IEC.Reg) & 0xffff0000) >> 16
}

// QEI.IES: Interrupt enable set register
func (o *QEI_Type) SetIES_INX_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetIES_INX_INT() uint32 {
	return volatile.LoadUint32(&o.IES.Reg) & 0x1
}
func (o *QEI_Type) SetIES_TIM_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetIES_TIM_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetIES_VELC_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetIES_VELC_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetIES_DIR_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetIES_DIR_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetIES_ERR_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetIES_ERR_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetIES_ENCLK_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x20)|value<<5)
}
func (o *QEI_Type) GetIES_ENCLK_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x20) >> 5
}
func (o *QEI_Type) SetIES_POS0_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x40)|value<<6)
}
func (o *QEI_Type) GetIES_POS0_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x40) >> 6
}
func (o *QEI_Type) SetIES_POS1_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x80)|value<<7)
}
func (o *QEI_Type) GetIES_POS1_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x80) >> 7
}
func (o *QEI_Type) SetIES_POS2_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x100)|value<<8)
}
func (o *QEI_Type) GetIES_POS2_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x100) >> 8
}
func (o *QEI_Type) SetIES_REV0_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x200)|value<<9)
}
func (o *QEI_Type) GetIES_REV0_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x200) >> 9
}
func (o *QEI_Type) SetIES_POS0REV_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x400)|value<<10)
}
func (o *QEI_Type) GetIES_POS0REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x400) >> 10
}
func (o *QEI_Type) SetIES_POS1REV_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x800)|value<<11)
}
func (o *QEI_Type) GetIES_POS1REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x800) >> 11
}
func (o *QEI_Type) SetIES_POS2REV_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x1000)|value<<12)
}
func (o *QEI_Type) GetIES_POS2REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x1000) >> 12
}
func (o *QEI_Type) SetIES_REV1_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x2000)|value<<13)
}
func (o *QEI_Type) GetIES_REV1_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x2000) >> 13
}
func (o *QEI_Type) SetIES_REV2_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x4000)|value<<14)
}
func (o *QEI_Type) GetIES_REV2_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x4000) >> 14
}
func (o *QEI_Type) SetIES_MAXPOS_INT(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0x8000)|value<<15)
}
func (o *QEI_Type) GetIES_MAXPOS_INT() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0x8000) >> 15
}
func (o *QEI_Type) SetIES_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IES.Reg, volatile.LoadUint32(&o.IES.Reg)&^(0xffff0000)|value<<16)
}
func (o *QEI_Type) GetIES_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IES.Reg) & 0xffff0000) >> 16
}

// QEI.INTSTAT: Interrupt status register
func (o *QEI_Type) SetINTSTAT_INX_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetINTSTAT_INX_INT() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *QEI_Type) SetINTSTAT_TIM_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetINTSTAT_TIM_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetINTSTAT_VELC_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetINTSTAT_VELC_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetINTSTAT_DIR_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetINTSTAT_DIR_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetINTSTAT_ERR_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetINTSTAT_ERR_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetINTSTAT_ENCLK_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *QEI_Type) GetINTSTAT_ENCLK_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20) >> 5
}
func (o *QEI_Type) SetINTSTAT_POS0_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40)|value<<6)
}
func (o *QEI_Type) GetINTSTAT_POS0_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40) >> 6
}
func (o *QEI_Type) SetINTSTAT_POS1_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80)|value<<7)
}
func (o *QEI_Type) GetINTSTAT_POS1_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80) >> 7
}
func (o *QEI_Type) SetINTSTAT_POS2_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x100)|value<<8)
}
func (o *QEI_Type) GetINTSTAT_POS2_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x100) >> 8
}
func (o *QEI_Type) SetINTSTAT_REV0_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x200)|value<<9)
}
func (o *QEI_Type) GetINTSTAT_REV0_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x200) >> 9
}
func (o *QEI_Type) SetINTSTAT_POS0REV_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x400)|value<<10)
}
func (o *QEI_Type) GetINTSTAT_POS0REV_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x400) >> 10
}
func (o *QEI_Type) SetINTSTAT_POS1REV_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x800)|value<<11)
}
func (o *QEI_Type) GetINTSTAT_POS1REV_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x800) >> 11
}
func (o *QEI_Type) SetINTSTAT_POS2REV_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1000)|value<<12)
}
func (o *QEI_Type) GetINTSTAT_POS2REV_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1000) >> 12
}
func (o *QEI_Type) SetINTSTAT_REV1_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2000)|value<<13)
}
func (o *QEI_Type) GetINTSTAT_REV1_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2000) >> 13
}
func (o *QEI_Type) SetINTSTAT_REV2_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4000)|value<<14)
}
func (o *QEI_Type) GetINTSTAT_REV2_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4000) >> 14
}
func (o *QEI_Type) SetINTSTAT_MAXPOS_INT(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8000)|value<<15)
}
func (o *QEI_Type) GetINTSTAT_MAXPOS_INT() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8000) >> 15
}
func (o *QEI_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xffff0000)|value<<16)
}
func (o *QEI_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xffff0000) >> 16
}

// QEI.IE: Interrupt enable register
func (o *QEI_Type) SetIE_INX_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetIE_INX_INT() uint32 {
	return volatile.LoadUint32(&o.IE.Reg) & 0x1
}
func (o *QEI_Type) SetIE_TIM_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetIE_TIM_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetIE_VELC_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetIE_VELC_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetIE_DIR_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetIE_DIR_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetIE_ERR_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetIE_ERR_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetIE_ENCLK_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x20)|value<<5)
}
func (o *QEI_Type) GetIE_ENCLK_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x20) >> 5
}
func (o *QEI_Type) SetIE_POS0_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x40)|value<<6)
}
func (o *QEI_Type) GetIE_POS0_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x40) >> 6
}
func (o *QEI_Type) SetIE_POS1_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x80)|value<<7)
}
func (o *QEI_Type) GetIE_POS1_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x80) >> 7
}
func (o *QEI_Type) SetIE_POS2_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x100)|value<<8)
}
func (o *QEI_Type) GetIE_POS2_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x100) >> 8
}
func (o *QEI_Type) SetIE_REV0_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x200)|value<<9)
}
func (o *QEI_Type) GetIE_REV0_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x200) >> 9
}
func (o *QEI_Type) SetIE_POS0REV_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x400)|value<<10)
}
func (o *QEI_Type) GetIE_POS0REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x400) >> 10
}
func (o *QEI_Type) SetIE_POS1REV_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x800)|value<<11)
}
func (o *QEI_Type) GetIE_POS1REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x800) >> 11
}
func (o *QEI_Type) SetIE_POS2REV_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x1000)|value<<12)
}
func (o *QEI_Type) GetIE_POS2REV_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x1000) >> 12
}
func (o *QEI_Type) SetIE_REV1_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x2000)|value<<13)
}
func (o *QEI_Type) GetIE_REV1_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x2000) >> 13
}
func (o *QEI_Type) SetIE_REV2_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x4000)|value<<14)
}
func (o *QEI_Type) GetIE_REV2_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x4000) >> 14
}
func (o *QEI_Type) SetIE_MAXPOS_INT(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0x8000)|value<<15)
}
func (o *QEI_Type) GetIE_MAXPOS_INT() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0x8000) >> 15
}
func (o *QEI_Type) SetIE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IE.Reg, volatile.LoadUint32(&o.IE.Reg)&^(0xffff0000)|value<<16)
}
func (o *QEI_Type) GetIE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IE.Reg) & 0xffff0000) >> 16
}

// QEI.CLR: Interrupt status clear register
func (o *QEI_Type) SetCLR_INX_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetCLR_INX_INT() uint32 {
	return volatile.LoadUint32(&o.CLR.Reg) & 0x1
}
func (o *QEI_Type) SetCLR_TIM_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetCLR_TIM_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetCLR_VELC_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetCLR_VELC_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetCLR_DIR_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetCLR_DIR_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetCLR_ERR_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetCLR_ERR_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetCLR_ENCLK_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x20)|value<<5)
}
func (o *QEI_Type) GetCLR_ENCLK_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x20) >> 5
}
func (o *QEI_Type) SetCLR_POS0_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x40)|value<<6)
}
func (o *QEI_Type) GetCLR_POS0_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x40) >> 6
}
func (o *QEI_Type) SetCLR_POS1_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x80)|value<<7)
}
func (o *QEI_Type) GetCLR_POS1_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x80) >> 7
}
func (o *QEI_Type) SetCLR_POS2_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x100)|value<<8)
}
func (o *QEI_Type) GetCLR_POS2_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x100) >> 8
}
func (o *QEI_Type) SetCLR_REV0_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x200)|value<<9)
}
func (o *QEI_Type) GetCLR_REV0_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x200) >> 9
}
func (o *QEI_Type) SetCLR_POS0REV_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x400)|value<<10)
}
func (o *QEI_Type) GetCLR_POS0REV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x400) >> 10
}
func (o *QEI_Type) SetCLR_POS1REV_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x800)|value<<11)
}
func (o *QEI_Type) GetCLR_POS1REV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x800) >> 11
}
func (o *QEI_Type) SetCLR_POS2REV_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x1000)|value<<12)
}
func (o *QEI_Type) GetCLR_POS2REV_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x1000) >> 12
}
func (o *QEI_Type) SetCLR_REV1_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x2000)|value<<13)
}
func (o *QEI_Type) GetCLR_REV1_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x2000) >> 13
}
func (o *QEI_Type) SetCLR_REV2_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x4000)|value<<14)
}
func (o *QEI_Type) GetCLR_REV2_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x4000) >> 14
}
func (o *QEI_Type) SetCLR_MAXPOS_INT(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0x8000)|value<<15)
}
func (o *QEI_Type) GetCLR_MAXPOS_INT() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0x8000) >> 15
}
func (o *QEI_Type) SetCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLR.Reg, volatile.LoadUint32(&o.CLR.Reg)&^(0xffff0000)|value<<16)
}
func (o *QEI_Type) GetCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLR.Reg) & 0xffff0000) >> 16
}

// QEI.SET: Interrupt status set register
func (o *QEI_Type) SetSET_INX_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x1)|value)
}
func (o *QEI_Type) GetSET_INX_INT() uint32 {
	return volatile.LoadUint32(&o.SET.Reg) & 0x1
}
func (o *QEI_Type) SetSET_TIM_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x2)|value<<1)
}
func (o *QEI_Type) GetSET_TIM_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x2) >> 1
}
func (o *QEI_Type) SetSET_VELC_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x4)|value<<2)
}
func (o *QEI_Type) GetSET_VELC_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x4) >> 2
}
func (o *QEI_Type) SetSET_DIR_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x8)|value<<3)
}
func (o *QEI_Type) GetSET_DIR_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x8) >> 3
}
func (o *QEI_Type) SetSET_ERR_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x10)|value<<4)
}
func (o *QEI_Type) GetSET_ERR_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x10) >> 4
}
func (o *QEI_Type) SetSET_ENCLK_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x20)|value<<5)
}
func (o *QEI_Type) GetSET_ENCLK_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x20) >> 5
}
func (o *QEI_Type) SetSET_POS0_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x40)|value<<6)
}
func (o *QEI_Type) GetSET_POS0_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x40) >> 6
}
func (o *QEI_Type) SetSET_POS1_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x80)|value<<7)
}
func (o *QEI_Type) GetSET_POS1_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x80) >> 7
}
func (o *QEI_Type) SetSET_POS2_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x100)|value<<8)
}
func (o *QEI_Type) GetSET_POS2_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x100) >> 8
}
func (o *QEI_Type) SetSET_REV0_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x200)|value<<9)
}
func (o *QEI_Type) GetSET_REV0_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x200) >> 9
}
func (o *QEI_Type) SetSET_POS0REV_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x400)|value<<10)
}
func (o *QEI_Type) GetSET_POS0REV_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x400) >> 10
}
func (o *QEI_Type) SetSET_POS1REV_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x800)|value<<11)
}
func (o *QEI_Type) GetSET_POS1REV_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x800) >> 11
}
func (o *QEI_Type) SetSET_POS2REV_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x1000)|value<<12)
}
func (o *QEI_Type) GetSET_POS2REV_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x1000) >> 12
}
func (o *QEI_Type) SetSET_REV1_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x2000)|value<<13)
}
func (o *QEI_Type) GetSET_REV1_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x2000) >> 13
}
func (o *QEI_Type) SetSET_REV2_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x4000)|value<<14)
}
func (o *QEI_Type) GetSET_REV2_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x4000) >> 14
}
func (o *QEI_Type) SetSET_MAXPOS_INT(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0x8000)|value<<15)
}
func (o *QEI_Type) GetSET_MAXPOS_INT() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0x8000) >> 15
}
func (o *QEI_Type) SetSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SET.Reg, volatile.LoadUint32(&o.SET.Reg)&^(0xffff0000)|value<<16)
}
func (o *QEI_Type) GetSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SET.Reg) & 0xffff0000) >> 16
}

// System and clock control
type SYSCON_Type struct {
	FLASHCFG     volatile.Register32 // 0x0
	_            [124]byte
	PLL0CON      volatile.Register32 // 0x80
	PLL0CFG      volatile.Register32 // 0x84
	PLL0STAT     volatile.Register32 // 0x88
	PLL0FEED     volatile.Register32 // 0x8C
	_            [16]byte
	PLL1CON      volatile.Register32 // 0xA0
	PLL1CFG      volatile.Register32 // 0xA4
	PLL1STAT     volatile.Register32 // 0xA8
	PLL1FEED     volatile.Register32 // 0xAC
	_            [16]byte
	PCON         volatile.Register32 // 0xC0
	PCONP        volatile.Register32 // 0xC4
	_            [60]byte
	CCLKCFG      volatile.Register32 // 0x104
	USBCLKCFG    volatile.Register32 // 0x108
	CLKSRCSEL    volatile.Register32 // 0x10C
	CANSLEEPCLR  volatile.Register32 // 0x110
	CANWAKEFLAGS volatile.Register32 // 0x114
	_            [40]byte
	EXTINT       volatile.Register32 // 0x140
	_            [4]byte
	EXTMODE      volatile.Register32 // 0x148
	EXTPOLAR     volatile.Register32 // 0x14C
	_            [48]byte
	RSID         volatile.Register32 // 0x180
	_            [28]byte
	SCS          volatile.Register32 // 0x1A0
	_            [4]byte
	PCLKSEL0     volatile.Register32 // 0x1A8
	PCLKSEL1     volatile.Register32 // 0x1AC
	_            [16]byte
	USBINTST     volatile.Register32 // 0x1C0
	DMACREQSEL   volatile.Register32 // 0x1C4
	CLKOUTCFG    volatile.Register32 // 0x1C8
}

// SYSCON.FLASHCFG: Flash Accelerator Configuration Register. Controls flash access timing.
func (o *SYSCON_Type) SetFLASHCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FLASHCFG.Reg, volatile.LoadUint32(&o.FLASHCFG.Reg)&^(0xfff)|value)
}
func (o *SYSCON_Type) GetFLASHCFG_RESERVED() uint32 {
	return volatile.LoadUint32(&o.FLASHCFG.Reg) & 0xfff
}
func (o *SYSCON_Type) SetFLASHCFG_FLASHTIM(value uint32) {
	volatile.StoreUint32(&o.FLASHCFG.Reg, volatile.LoadUint32(&o.FLASHCFG.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCON_Type) GetFLASHCFG_FLASHTIM() uint32 {
	return (volatile.LoadUint32(&o.FLASHCFG.Reg) & 0xf000) >> 12
}
func (o *SYSCON_Type) SetFLASHCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FLASHCFG.Reg, volatile.LoadUint32(&o.FLASHCFG.Reg)&^(0xffff0000)|value<<16)
}
func (o *SYSCON_Type) GetFLASHCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FLASHCFG.Reg) & 0xffff0000) >> 16
}

// SYSCON.PLL0CON: PLL0 Control Register
func (o *SYSCON_Type) SetPLL0CON_PLLE0(value uint32) {
	volatile.StoreUint32(&o.PLL0CON.Reg, volatile.LoadUint32(&o.PLL0CON.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetPLL0CON_PLLE0() uint32 {
	return volatile.LoadUint32(&o.PLL0CON.Reg) & 0x1
}
func (o *SYSCON_Type) SetPLL0CON_PLLC0(value uint32) {
	volatile.StoreUint32(&o.PLL0CON.Reg, volatile.LoadUint32(&o.PLL0CON.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetPLL0CON_PLLC0() uint32 {
	return (volatile.LoadUint32(&o.PLL0CON.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetPLL0CON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PLL0CON.Reg, volatile.LoadUint32(&o.PLL0CON.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetPLL0CON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PLL0CON.Reg) & 0xfffffffc) >> 2
}

// SYSCON.PLL0CFG: PLL0 Configuration Register
func (o *SYSCON_Type) SetPLL0CFG_MSEL0(value uint32) {
	volatile.StoreUint32(&o.PLL0CFG.Reg, volatile.LoadUint32(&o.PLL0CFG.Reg)&^(0x7fff)|value)
}
func (o *SYSCON_Type) GetPLL0CFG_MSEL0() uint32 {
	return volatile.LoadUint32(&o.PLL0CFG.Reg) & 0x7fff
}
func (o *SYSCON_Type) SetPLL0CFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PLL0CFG.Reg, volatile.LoadUint32(&o.PLL0CFG.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetPLL0CFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PLL0CFG.Reg) & 0x8000) >> 15
}
func (o *SYSCON_Type) SetPLL0CFG_NSEL0(value uint32) {
	volatile.StoreUint32(&o.PLL0CFG.Reg, volatile.LoadUint32(&o.PLL0CFG.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSCON_Type) GetPLL0CFG_NSEL0() uint32 {
	return (volatile.LoadUint32(&o.PLL0CFG.Reg) & 0xff0000) >> 16
}
func (o *SYSCON_Type) SetPLL0CFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PLL0CFG.Reg, volatile.LoadUint32(&o.PLL0CFG.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSCON_Type) GetPLL0CFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PLL0CFG.Reg) & 0xff000000) >> 24
}

// SYSCON.PLL0STAT: PLL0 Status Register
func (o *SYSCON_Type) SetPLL0STAT_MSEL0(value uint32) {
	volatile.StoreUint32(&o.PLL0STAT.Reg, volatile.LoadUint32(&o.PLL0STAT.Reg)&^(0x7fff)|value)
}
func (o *SYSCON_Type) GetPLL0STAT_MSEL0() uint32 {
	return volatile.LoadUint32(&o.PLL0STAT.Reg) & 0x7fff
}
func (o *SYSCON_Type) SetPLL0STAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PLL0STAT.Reg, volatile.LoadUint32(&o.PLL0STAT.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetPLL0STAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PLL0STAT.Reg) & 0x8000) >> 15
}
func (o *SYSCON_Type) SetPLL0STAT_NSEL0(value uint32) {
	volatile.StoreUint32(&o.PLL0STAT.Reg, volatile.LoadUint32(&o.PLL0STAT.Reg)&^(0xff0000)|value<<16)
}
func (o *SYSCON_Type) GetPLL0STAT_NSEL0() uint32 {
	return (volatile.LoadUint32(&o.PLL0STAT.Reg) & 0xff0000) >> 16
}
func (o *SYSCON_Type) SetPLL0STAT_PLLE0_STAT(value uint32) {
	volatile.StoreUint32(&o.PLL0STAT.Reg, volatile.LoadUint32(&o.PLL0STAT.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCON_Type) GetPLL0STAT_PLLE0_STAT() uint32 {
	return (volatile.LoadUint32(&o.PLL0STAT.Reg) & 0x1000000) >> 24
}
func (o *SYSCON_Type) SetPLL0STAT_PLLC0_STAT(value uint32) {
	volatile.StoreUint32(&o.PLL0STAT.Reg, volatile.LoadUint32(&o.PLL0STAT.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCON_Type) GetPLL0STAT_PLLC0_STAT() uint32 {
	return (volatile.LoadUint32(&o.PLL0STAT.Reg) & 0x2000000) >> 25
}
func (o *SYSCON_Type) SetPLL0STAT_PLOCK0(value uint32) {
	volatile.StoreUint32(&o.PLL0STAT.Reg, volatile.LoadUint32(&o.PLL0STAT.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCON_Type) GetPLL0STAT_PLOCK0() uint32 {
	return (volatile.LoadUint32(&o.PLL0STAT.Reg) & 0x4000000) >> 26
}
func (o *SYSCON_Type) SetPLL0STAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PLL0STAT.Reg, volatile.LoadUint32(&o.PLL0STAT.Reg)&^(0xf8000000)|value<<27)
}
func (o *SYSCON_Type) GetPLL0STAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PLL0STAT.Reg) & 0xf8000000) >> 27
}

// SYSCON.PLL0FEED: PLL0 Feed Register
func (o *SYSCON_Type) SetPLL0FEED(value uint32) {
	volatile.StoreUint32(&o.PLL0FEED.Reg, volatile.LoadUint32(&o.PLL0FEED.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetPLL0FEED() uint32 {
	return volatile.LoadUint32(&o.PLL0FEED.Reg) & 0xff
}
func (o *SYSCON_Type) SetPLL0FEED_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PLL0FEED.Reg, volatile.LoadUint32(&o.PLL0FEED.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetPLL0FEED_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PLL0FEED.Reg) & 0xffffff00) >> 8
}

// SYSCON.PLL1CON: PLL1 Control Register
func (o *SYSCON_Type) SetPLL1CON_PLLE1(value uint32) {
	volatile.StoreUint32(&o.PLL1CON.Reg, volatile.LoadUint32(&o.PLL1CON.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetPLL1CON_PLLE1() uint32 {
	return volatile.LoadUint32(&o.PLL1CON.Reg) & 0x1
}
func (o *SYSCON_Type) SetPLL1CON_PLLC1(value uint32) {
	volatile.StoreUint32(&o.PLL1CON.Reg, volatile.LoadUint32(&o.PLL1CON.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetPLL1CON_PLLC1() uint32 {
	return (volatile.LoadUint32(&o.PLL1CON.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetPLL1CON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PLL1CON.Reg, volatile.LoadUint32(&o.PLL1CON.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetPLL1CON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PLL1CON.Reg) & 0xfffffffc) >> 2
}

// SYSCON.PLL1CFG: PLL1 Configuration Register
func (o *SYSCON_Type) SetPLL1CFG_MSEL1(value uint32) {
	volatile.StoreUint32(&o.PLL1CFG.Reg, volatile.LoadUint32(&o.PLL1CFG.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetPLL1CFG_MSEL1() uint32 {
	return volatile.LoadUint32(&o.PLL1CFG.Reg) & 0x1f
}
func (o *SYSCON_Type) SetPLL1CFG_PSEL1(value uint32) {
	volatile.StoreUint32(&o.PLL1CFG.Reg, volatile.LoadUint32(&o.PLL1CFG.Reg)&^(0x60)|value<<5)
}
func (o *SYSCON_Type) GetPLL1CFG_PSEL1() uint32 {
	return (volatile.LoadUint32(&o.PLL1CFG.Reg) & 0x60) >> 5
}
func (o *SYSCON_Type) SetPLL1CFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PLL1CFG.Reg, volatile.LoadUint32(&o.PLL1CFG.Reg)&^(0xffffff80)|value<<7)
}
func (o *SYSCON_Type) GetPLL1CFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PLL1CFG.Reg) & 0xffffff80) >> 7
}

// SYSCON.PLL1STAT: PLL1 Status Register
func (o *SYSCON_Type) SetPLL1STAT_MSEL1(value uint32) {
	volatile.StoreUint32(&o.PLL1STAT.Reg, volatile.LoadUint32(&o.PLL1STAT.Reg)&^(0x1f)|value)
}
func (o *SYSCON_Type) GetPLL1STAT_MSEL1() uint32 {
	return volatile.LoadUint32(&o.PLL1STAT.Reg) & 0x1f
}
func (o *SYSCON_Type) SetPLL1STAT_PSEL1(value uint32) {
	volatile.StoreUint32(&o.PLL1STAT.Reg, volatile.LoadUint32(&o.PLL1STAT.Reg)&^(0x60)|value<<5)
}
func (o *SYSCON_Type) GetPLL1STAT_PSEL1() uint32 {
	return (volatile.LoadUint32(&o.PLL1STAT.Reg) & 0x60) >> 5
}
func (o *SYSCON_Type) SetPLL1STAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PLL1STAT.Reg, volatile.LoadUint32(&o.PLL1STAT.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPLL1STAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PLL1STAT.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPLL1STAT_PLLE1_STAT(value uint32) {
	volatile.StoreUint32(&o.PLL1STAT.Reg, volatile.LoadUint32(&o.PLL1STAT.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetPLL1STAT_PLLE1_STAT() uint32 {
	return (volatile.LoadUint32(&o.PLL1STAT.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetPLL1STAT_PLLC1_STAT(value uint32) {
	volatile.StoreUint32(&o.PLL1STAT.Reg, volatile.LoadUint32(&o.PLL1STAT.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetPLL1STAT_PLLC1_STAT() uint32 {
	return (volatile.LoadUint32(&o.PLL1STAT.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetPLL1STAT_PLOCK1(value uint32) {
	volatile.StoreUint32(&o.PLL1STAT.Reg, volatile.LoadUint32(&o.PLL1STAT.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetPLL1STAT_PLOCK1() uint32 {
	return (volatile.LoadUint32(&o.PLL1STAT.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetPLL1STAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PLL1STAT.Reg, volatile.LoadUint32(&o.PLL1STAT.Reg)&^(0xfffff800)|value<<11)
}
func (o *SYSCON_Type) GetPLL1STAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PLL1STAT.Reg) & 0xfffff800) >> 11
}

// SYSCON.PLL1FEED: PLL1 Feed Register
func (o *SYSCON_Type) SetPLL1FEED(value uint32) {
	volatile.StoreUint32(&o.PLL1FEED.Reg, volatile.LoadUint32(&o.PLL1FEED.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetPLL1FEED() uint32 {
	return volatile.LoadUint32(&o.PLL1FEED.Reg) & 0xff
}
func (o *SYSCON_Type) SetPLL1FEED_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PLL1FEED.Reg, volatile.LoadUint32(&o.PLL1FEED.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetPLL1FEED_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PLL1FEED.Reg) & 0xffffff00) >> 8
}

// SYSCON.PCON: Power Control Register
func (o *SYSCON_Type) SetPCON_PM0(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetPCON_PM0() uint32 {
	return volatile.LoadUint32(&o.PCON.Reg) & 0x1
}
func (o *SYSCON_Type) SetPCON_PM1(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetPCON_PM1() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetPCON_BODRPM(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetPCON_BODRPM() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetPCON_BOGD(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPCON_BOGD() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPCON_BORD(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetPCON_BORD() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetPCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0xf8)|value<<3)
}
func (o *SYSCON_Type) GetPCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0xf8) >> 3
}
func (o *SYSCON_Type) SetPCON_SMFLAG(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetPCON_SMFLAG() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetPCON_DSFLAG(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetPCON_DSFLAG() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetPCON_PDFLAG(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetPCON_PDFLAG() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetPCON_DPDFLAG(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetPCON_DPDFLAG() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetPCON_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCON.Reg, volatile.LoadUint32(&o.PCON.Reg)&^(0xfffff000)|value<<12)
}
func (o *SYSCON_Type) GetPCON_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCON.Reg) & 0xfffff000) >> 12
}

// SYSCON.PCONP: Power Control for Peripherals Register
func (o *SYSCON_Type) SetPCONP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetPCONP_RESERVED() uint32 {
	return volatile.LoadUint32(&o.PCONP.Reg) & 0x1
}
func (o *SYSCON_Type) SetPCONP_PCTIM0(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetPCONP_PCTIM0() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetPCONP_PCTIM1(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetPCONP_PCTIM1() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetPCONP_PCUART0(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetPCONP_PCUART0() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetPCONP_PCUART1(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetPCONP_PCUART1() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetPCONP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetPCONP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetPCONP_PCPWM1(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetPCONP_PCPWM1() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetPCONP_PCI2C0(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetPCONP_PCI2C0() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetPCONP_PCSPI(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetPCONP_PCSPI() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetPCONP_PCRTC(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetPCONP_PCRTC() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetPCONP_PCSSP1(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x400)|value<<10)
}
func (o *SYSCON_Type) GetPCONP_PCSSP1() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x400) >> 10
}
func (o *SYSCON_Type) SetPCONP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x800)|value<<11)
}
func (o *SYSCON_Type) GetPCONP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x800) >> 11
}
func (o *SYSCON_Type) SetPCONP_PCADC(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCON_Type) GetPCONP_PCADC() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x1000) >> 12
}
func (o *SYSCON_Type) SetPCONP_PCCAN1(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCON_Type) GetPCONP_PCCAN1() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x2000) >> 13
}
func (o *SYSCON_Type) SetPCONP_PCCAN2(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x4000)|value<<14)
}
func (o *SYSCON_Type) GetPCONP_PCCAN2() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x4000) >> 14
}
func (o *SYSCON_Type) SetPCONP_PCGPIO(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x8000)|value<<15)
}
func (o *SYSCON_Type) GetPCONP_PCGPIO() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x8000) >> 15
}
func (o *SYSCON_Type) SetPCONP_PCRIT(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCON_Type) GetPCONP_PCRIT() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x10000) >> 16
}
func (o *SYSCON_Type) SetPCONP_PCMCPWM(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCON_Type) GetPCONP_PCMCPWM() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x20000) >> 17
}
func (o *SYSCON_Type) SetPCONP_PCQEI(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCON_Type) GetPCONP_PCQEI() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x40000) >> 18
}
func (o *SYSCON_Type) SetPCONP_PCI2C1(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCON_Type) GetPCONP_PCI2C1() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x80000) >> 19
}
func (o *SYSCON_Type) SetPCONP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCON_Type) GetPCONP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x100000) >> 20
}
func (o *SYSCON_Type) SetPCONP_PCSSP0(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCON_Type) GetPCONP_PCSSP0() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x200000) >> 21
}
func (o *SYSCON_Type) SetPCONP_PCTIM2(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x400000)|value<<22)
}
func (o *SYSCON_Type) GetPCONP_PCTIM2() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x400000) >> 22
}
func (o *SYSCON_Type) SetPCONP_PCTIM3(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x800000)|value<<23)
}
func (o *SYSCON_Type) GetPCONP_PCTIM3() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x800000) >> 23
}
func (o *SYSCON_Type) SetPCONP_PCUART2(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCON_Type) GetPCONP_PCUART2() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x1000000) >> 24
}
func (o *SYSCON_Type) SetPCONP_PCUART3(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSCON_Type) GetPCONP_PCUART3() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x2000000) >> 25
}
func (o *SYSCON_Type) SetPCONP_PCI2C2(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCON_Type) GetPCONP_PCI2C2() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x4000000) >> 26
}
func (o *SYSCON_Type) SetPCONP_PCI2S(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCON_Type) GetPCONP_PCI2S() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x8000000) >> 27
}
func (o *SYSCON_Type) SetPCONP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSCON_Type) GetPCONP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x10000000) >> 28
}
func (o *SYSCON_Type) SetPCONP_PCGPDMA(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCON_Type) GetPCONP_PCGPDMA() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x20000000) >> 29
}
func (o *SYSCON_Type) SetPCONP_PCENET(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCON_Type) GetPCONP_PCENET() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x40000000) >> 30
}
func (o *SYSCON_Type) SetPCONP_PCUSB(value uint32) {
	volatile.StoreUint32(&o.PCONP.Reg, volatile.LoadUint32(&o.PCONP.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCON_Type) GetPCONP_PCUSB() uint32 {
	return (volatile.LoadUint32(&o.PCONP.Reg) & 0x80000000) >> 31
}

// SYSCON.CCLKCFG: CPU Clock Configuration Register
func (o *SYSCON_Type) SetCCLKCFG_CCLKSEL(value uint32) {
	volatile.StoreUint32(&o.CCLKCFG.Reg, volatile.LoadUint32(&o.CCLKCFG.Reg)&^(0xff)|value)
}
func (o *SYSCON_Type) GetCCLKCFG_CCLKSEL() uint32 {
	return volatile.LoadUint32(&o.CCLKCFG.Reg) & 0xff
}
func (o *SYSCON_Type) SetCCLKCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CCLKCFG.Reg, volatile.LoadUint32(&o.CCLKCFG.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetCCLKCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CCLKCFG.Reg) & 0xffffff00) >> 8
}

// SYSCON.USBCLKCFG: USB Clock Configuration Register
func (o *SYSCON_Type) SetUSBCLKCFG_USBSEL(value uint32) {
	volatile.StoreUint32(&o.USBCLKCFG.Reg, volatile.LoadUint32(&o.USBCLKCFG.Reg)&^(0xf)|value)
}
func (o *SYSCON_Type) GetUSBCLKCFG_USBSEL() uint32 {
	return volatile.LoadUint32(&o.USBCLKCFG.Reg) & 0xf
}
func (o *SYSCON_Type) SetUSBCLKCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCLKCFG.Reg, volatile.LoadUint32(&o.USBCLKCFG.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SYSCON_Type) GetUSBCLKCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCLKCFG.Reg) & 0xfffffff0) >> 4
}

// SYSCON.CLKSRCSEL: Clock Source Select Register
func (o *SYSCON_Type) SetCLKSRCSEL_CLKSRC(value uint32) {
	volatile.StoreUint32(&o.CLKSRCSEL.Reg, volatile.LoadUint32(&o.CLKSRCSEL.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetCLKSRCSEL_CLKSRC() uint32 {
	return volatile.LoadUint32(&o.CLKSRCSEL.Reg) & 0x3
}
func (o *SYSCON_Type) SetCLKSRCSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKSRCSEL.Reg, volatile.LoadUint32(&o.CLKSRCSEL.Reg)&^(0xfffffffc)|value<<2)
}
func (o *SYSCON_Type) GetCLKSRCSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKSRCSEL.Reg) & 0xfffffffc) >> 2
}

// SYSCON.CANSLEEPCLR: Allows clearing the current CAN channel sleep state as well as reading that state.
func (o *SYSCON_Type) SetCANSLEEPCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CANSLEEPCLR.Reg, volatile.LoadUint32(&o.CANSLEEPCLR.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetCANSLEEPCLR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CANSLEEPCLR.Reg) & 0x1
}
func (o *SYSCON_Type) SetCANSLEEPCLR_CAN1SLEEP(value uint32) {
	volatile.StoreUint32(&o.CANSLEEPCLR.Reg, volatile.LoadUint32(&o.CANSLEEPCLR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetCANSLEEPCLR_CAN1SLEEP() uint32 {
	return (volatile.LoadUint32(&o.CANSLEEPCLR.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetCANSLEEPCLR_CAN2SLEEP(value uint32) {
	volatile.StoreUint32(&o.CANSLEEPCLR.Reg, volatile.LoadUint32(&o.CANSLEEPCLR.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetCANSLEEPCLR_CAN2SLEEP() uint32 {
	return (volatile.LoadUint32(&o.CANSLEEPCLR.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetCANSLEEPCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CANSLEEPCLR.Reg, volatile.LoadUint32(&o.CANSLEEPCLR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *SYSCON_Type) GetCANSLEEPCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CANSLEEPCLR.Reg) & 0xfffffff8) >> 3
}

// SYSCON.CANWAKEFLAGS: Allows reading the wake-up state of the CAN channels.
func (o *SYSCON_Type) SetCANWAKEFLAGS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CANWAKEFLAGS.Reg, volatile.LoadUint32(&o.CANWAKEFLAGS.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetCANWAKEFLAGS_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CANWAKEFLAGS.Reg) & 0x1
}
func (o *SYSCON_Type) SetCANWAKEFLAGS_CAN1WAKE(value uint32) {
	volatile.StoreUint32(&o.CANWAKEFLAGS.Reg, volatile.LoadUint32(&o.CANWAKEFLAGS.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetCANWAKEFLAGS_CAN1WAKE() uint32 {
	return (volatile.LoadUint32(&o.CANWAKEFLAGS.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetCANWAKEFLAGS_CAN2WAKE(value uint32) {
	volatile.StoreUint32(&o.CANWAKEFLAGS.Reg, volatile.LoadUint32(&o.CANWAKEFLAGS.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetCANWAKEFLAGS_CAN2WAKE() uint32 {
	return (volatile.LoadUint32(&o.CANWAKEFLAGS.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetCANWAKEFLAGS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CANWAKEFLAGS.Reg, volatile.LoadUint32(&o.CANWAKEFLAGS.Reg)&^(0xfffffff8)|value<<3)
}
func (o *SYSCON_Type) GetCANWAKEFLAGS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CANWAKEFLAGS.Reg) & 0xfffffff8) >> 3
}

// SYSCON.EXTINT: External Interrupt Flag Register
func (o *SYSCON_Type) SetEXTINT_EINT0(value uint32) {
	volatile.StoreUint32(&o.EXTINT.Reg, volatile.LoadUint32(&o.EXTINT.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetEXTINT_EINT0() uint32 {
	return volatile.LoadUint32(&o.EXTINT.Reg) & 0x1
}
func (o *SYSCON_Type) SetEXTINT_EINT1(value uint32) {
	volatile.StoreUint32(&o.EXTINT.Reg, volatile.LoadUint32(&o.EXTINT.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetEXTINT_EINT1() uint32 {
	return (volatile.LoadUint32(&o.EXTINT.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetEXTINT_EINT2(value uint32) {
	volatile.StoreUint32(&o.EXTINT.Reg, volatile.LoadUint32(&o.EXTINT.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetEXTINT_EINT2() uint32 {
	return (volatile.LoadUint32(&o.EXTINT.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetEXTINT_EINT3(value uint32) {
	volatile.StoreUint32(&o.EXTINT.Reg, volatile.LoadUint32(&o.EXTINT.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetEXTINT_EINT3() uint32 {
	return (volatile.LoadUint32(&o.EXTINT.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetEXTINT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EXTINT.Reg, volatile.LoadUint32(&o.EXTINT.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SYSCON_Type) GetEXTINT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EXTINT.Reg) & 0xfffffff0) >> 4
}

// SYSCON.EXTMODE: External Interrupt Mode register
func (o *SYSCON_Type) SetEXTMODE_EXTMODE0(value uint32) {
	volatile.StoreUint32(&o.EXTMODE.Reg, volatile.LoadUint32(&o.EXTMODE.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetEXTMODE_EXTMODE0() uint32 {
	return volatile.LoadUint32(&o.EXTMODE.Reg) & 0x1
}
func (o *SYSCON_Type) SetEXTMODE_EXTMODE1(value uint32) {
	volatile.StoreUint32(&o.EXTMODE.Reg, volatile.LoadUint32(&o.EXTMODE.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetEXTMODE_EXTMODE1() uint32 {
	return (volatile.LoadUint32(&o.EXTMODE.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetEXTMODE_EXTMODE2(value uint32) {
	volatile.StoreUint32(&o.EXTMODE.Reg, volatile.LoadUint32(&o.EXTMODE.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetEXTMODE_EXTMODE2() uint32 {
	return (volatile.LoadUint32(&o.EXTMODE.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetEXTMODE_EXTMODE3(value uint32) {
	volatile.StoreUint32(&o.EXTMODE.Reg, volatile.LoadUint32(&o.EXTMODE.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetEXTMODE_EXTMODE3() uint32 {
	return (volatile.LoadUint32(&o.EXTMODE.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetEXTMODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EXTMODE.Reg, volatile.LoadUint32(&o.EXTMODE.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SYSCON_Type) GetEXTMODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EXTMODE.Reg) & 0xfffffff0) >> 4
}

// SYSCON.EXTPOLAR: External Interrupt Polarity Register
func (o *SYSCON_Type) SetEXTPOLAR_EXTPOLAR0(value uint32) {
	volatile.StoreUint32(&o.EXTPOLAR.Reg, volatile.LoadUint32(&o.EXTPOLAR.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetEXTPOLAR_EXTPOLAR0() uint32 {
	return volatile.LoadUint32(&o.EXTPOLAR.Reg) & 0x1
}
func (o *SYSCON_Type) SetEXTPOLAR_EXTPOLAR1(value uint32) {
	volatile.StoreUint32(&o.EXTPOLAR.Reg, volatile.LoadUint32(&o.EXTPOLAR.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetEXTPOLAR_EXTPOLAR1() uint32 {
	return (volatile.LoadUint32(&o.EXTPOLAR.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetEXTPOLAR_EXTPOLAR2(value uint32) {
	volatile.StoreUint32(&o.EXTPOLAR.Reg, volatile.LoadUint32(&o.EXTPOLAR.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetEXTPOLAR_EXTPOLAR2() uint32 {
	return (volatile.LoadUint32(&o.EXTPOLAR.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetEXTPOLAR_EXTPOLAR3(value uint32) {
	volatile.StoreUint32(&o.EXTPOLAR.Reg, volatile.LoadUint32(&o.EXTPOLAR.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetEXTPOLAR_EXTPOLAR3() uint32 {
	return (volatile.LoadUint32(&o.EXTPOLAR.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetEXTPOLAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EXTPOLAR.Reg, volatile.LoadUint32(&o.EXTPOLAR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SYSCON_Type) GetEXTPOLAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EXTPOLAR.Reg) & 0xfffffff0) >> 4
}

// SYSCON.RSID: Reset Source Identification Register
func (o *SYSCON_Type) SetRSID_POR(value uint32) {
	volatile.StoreUint32(&o.RSID.Reg, volatile.LoadUint32(&o.RSID.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetRSID_POR() uint32 {
	return volatile.LoadUint32(&o.RSID.Reg) & 0x1
}
func (o *SYSCON_Type) SetRSID_EXTR(value uint32) {
	volatile.StoreUint32(&o.RSID.Reg, volatile.LoadUint32(&o.RSID.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetRSID_EXTR() uint32 {
	return (volatile.LoadUint32(&o.RSID.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetRSID_WDTR(value uint32) {
	volatile.StoreUint32(&o.RSID.Reg, volatile.LoadUint32(&o.RSID.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetRSID_WDTR() uint32 {
	return (volatile.LoadUint32(&o.RSID.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetRSID_BODR(value uint32) {
	volatile.StoreUint32(&o.RSID.Reg, volatile.LoadUint32(&o.RSID.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetRSID_BODR() uint32 {
	return (volatile.LoadUint32(&o.RSID.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetRSID_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RSID.Reg, volatile.LoadUint32(&o.RSID.Reg)&^(0xfffffff0)|value<<4)
}
func (o *SYSCON_Type) GetRSID_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RSID.Reg) & 0xfffffff0) >> 4
}

// SYSCON.SCS: System control and status
func (o *SYSCON_Type) SetSCS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCS.Reg, volatile.LoadUint32(&o.SCS.Reg)&^(0xf)|value)
}
func (o *SYSCON_Type) GetSCS_RESERVED() uint32 {
	return volatile.LoadUint32(&o.SCS.Reg) & 0xf
}
func (o *SYSCON_Type) SetSCS_OSCRANGE(value uint32) {
	volatile.StoreUint32(&o.SCS.Reg, volatile.LoadUint32(&o.SCS.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetSCS_OSCRANGE() uint32 {
	return (volatile.LoadUint32(&o.SCS.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetSCS_OSCEN(value uint32) {
	volatile.StoreUint32(&o.SCS.Reg, volatile.LoadUint32(&o.SCS.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetSCS_OSCEN() uint32 {
	return (volatile.LoadUint32(&o.SCS.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetSCS_OSCSTAT(value uint32) {
	volatile.StoreUint32(&o.SCS.Reg, volatile.LoadUint32(&o.SCS.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetSCS_OSCSTAT() uint32 {
	return (volatile.LoadUint32(&o.SCS.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetSCS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SCS.Reg, volatile.LoadUint32(&o.SCS.Reg)&^(0xffffff80)|value<<7)
}
func (o *SYSCON_Type) GetSCS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SCS.Reg) & 0xffffff80) >> 7
}

// SYSCON.PCLKSEL0: Peripheral Clock Selection register 0.
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_WDT(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_WDT() uint32 {
	return volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0x3
}
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_TIMER0(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0xc)|value<<2)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_TIMER0() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0xc) >> 2
}
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_TIMER1(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0x30)|value<<4)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_TIMER1() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0x30) >> 4
}
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_UART0(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0xc0)|value<<6)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_UART0() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0xc0) >> 6
}
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_UART1(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0x300)|value<<8)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_UART1() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0x300) >> 8
}
func (o *SYSCON_Type) SetPCLKSEL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0xc00)|value<<10)
}
func (o *SYSCON_Type) GetPCLKSEL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0xc00) >> 10
}
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_PWM1(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0x3000)|value<<12)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_PWM1() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0x3000) >> 12
}
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_I2C0(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0xc000)|value<<14)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_I2C0() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0xc000) >> 14
}
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_SPI(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0x30000)|value<<16)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_SPI() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0x30000) >> 16
}
func (o *SYSCON_Type) SetPCLKSEL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0xc0000)|value<<18)
}
func (o *SYSCON_Type) GetPCLKSEL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0xc0000) >> 18
}
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_SSP1(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0x300000)|value<<20)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_SSP1() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0x300000) >> 20
}
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_DAC(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0xc00000)|value<<22)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_DAC() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0xc00000) >> 22
}
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_ADC(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0x3000000)|value<<24)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_ADC() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0x3000000) >> 24
}
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_CAN1(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0xc000000)|value<<26)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_CAN1() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0xc000000) >> 26
}
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_CAN2(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0x30000000)|value<<28)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_CAN2() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0x30000000) >> 28
}
func (o *SYSCON_Type) SetPCLKSEL0_PCLK_ACF(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL0.Reg, volatile.LoadUint32(&o.PCLKSEL0.Reg)&^(0xc0000000)|value<<30)
}
func (o *SYSCON_Type) GetPCLKSEL0_PCLK_ACF() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL0.Reg) & 0xc0000000) >> 30
}

// SYSCON.PCLKSEL1: Peripheral Clock Selection register 1.
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_QEI(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0x3)|value)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_QEI() uint32 {
	return volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0x3
}
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_GPIOINT(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0xc)|value<<2)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_GPIOINT() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0xc) >> 2
}
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_PCB(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0x30)|value<<4)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_PCB() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0x30) >> 4
}
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_I2C1(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0xc0)|value<<6)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_I2C1() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0xc0) >> 6
}
func (o *SYSCON_Type) SetPCLKSEL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0x300)|value<<8)
}
func (o *SYSCON_Type) GetPCLKSEL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0x300) >> 8
}
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_SSP0(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0xc00)|value<<10)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_SSP0() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0xc00) >> 10
}
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_TIMER2(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0x3000)|value<<12)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_TIMER2() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0x3000) >> 12
}
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_TIMER3(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0xc000)|value<<14)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_TIMER3() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0xc000) >> 14
}
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_UART2(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0x30000)|value<<16)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_UART2() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0x30000) >> 16
}
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_UART3(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0xc0000)|value<<18)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_UART3() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0xc0000) >> 18
}
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_I2C2(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0x300000)|value<<20)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_I2C2() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0x300000) >> 20
}
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_I2S(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0xc00000)|value<<22)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_I2S() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0xc00000) >> 22
}
func (o *SYSCON_Type) SetPCLKSEL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0x3000000)|value<<24)
}
func (o *SYSCON_Type) GetPCLKSEL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0x3000000) >> 24
}
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_RIT(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0xc000000)|value<<26)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_RIT() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0xc000000) >> 26
}
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_SYSCON(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0x30000000)|value<<28)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_SYSCON() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0x30000000) >> 28
}
func (o *SYSCON_Type) SetPCLKSEL1_PCLK_MC(value uint32) {
	volatile.StoreUint32(&o.PCLKSEL1.Reg, volatile.LoadUint32(&o.PCLKSEL1.Reg)&^(0xc0000000)|value<<30)
}
func (o *SYSCON_Type) GetPCLKSEL1_PCLK_MC() uint32 {
	return (volatile.LoadUint32(&o.PCLKSEL1.Reg) & 0xc0000000) >> 30
}

// SYSCON.USBINTST: USB Interrupt Status
func (o *SYSCON_Type) SetUSBINTST_USB_INT_REQ_LP(value uint32) {
	volatile.StoreUint32(&o.USBINTST.Reg, volatile.LoadUint32(&o.USBINTST.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetUSBINTST_USB_INT_REQ_LP() uint32 {
	return volatile.LoadUint32(&o.USBINTST.Reg) & 0x1
}
func (o *SYSCON_Type) SetUSBINTST_USB_INT_REQ_HP(value uint32) {
	volatile.StoreUint32(&o.USBINTST.Reg, volatile.LoadUint32(&o.USBINTST.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetUSBINTST_USB_INT_REQ_HP() uint32 {
	return (volatile.LoadUint32(&o.USBINTST.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetUSBINTST_USB_INT_REQ_DMA(value uint32) {
	volatile.StoreUint32(&o.USBINTST.Reg, volatile.LoadUint32(&o.USBINTST.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetUSBINTST_USB_INT_REQ_DMA() uint32 {
	return (volatile.LoadUint32(&o.USBINTST.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetUSBINTST_USB_HOST_INT(value uint32) {
	volatile.StoreUint32(&o.USBINTST.Reg, volatile.LoadUint32(&o.USBINTST.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetUSBINTST_USB_HOST_INT() uint32 {
	return (volatile.LoadUint32(&o.USBINTST.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetUSBINTST_USB_ATX_INT(value uint32) {
	volatile.StoreUint32(&o.USBINTST.Reg, volatile.LoadUint32(&o.USBINTST.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetUSBINTST_USB_ATX_INT() uint32 {
	return (volatile.LoadUint32(&o.USBINTST.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetUSBINTST_USB_OTG_INT(value uint32) {
	volatile.StoreUint32(&o.USBINTST.Reg, volatile.LoadUint32(&o.USBINTST.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetUSBINTST_USB_OTG_INT() uint32 {
	return (volatile.LoadUint32(&o.USBINTST.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetUSBINTST_USB_I2C_INT(value uint32) {
	volatile.StoreUint32(&o.USBINTST.Reg, volatile.LoadUint32(&o.USBINTST.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetUSBINTST_USB_I2C_INT() uint32 {
	return (volatile.LoadUint32(&o.USBINTST.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetUSBINTST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTST.Reg, volatile.LoadUint32(&o.USBINTST.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetUSBINTST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTST.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetUSBINTST_USB_NEED_CLK(value uint32) {
	volatile.StoreUint32(&o.USBINTST.Reg, volatile.LoadUint32(&o.USBINTST.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetUSBINTST_USB_NEED_CLK() uint32 {
	return (volatile.LoadUint32(&o.USBINTST.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetUSBINTST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBINTST.Reg, volatile.LoadUint32(&o.USBINTST.Reg)&^(0x7ffffe00)|value<<9)
}
func (o *SYSCON_Type) GetUSBINTST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBINTST.Reg) & 0x7ffffe00) >> 9
}
func (o *SYSCON_Type) SetUSBINTST_EN_USB_INTS(value uint32) {
	volatile.StoreUint32(&o.USBINTST.Reg, volatile.LoadUint32(&o.USBINTST.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCON_Type) GetUSBINTST_EN_USB_INTS() uint32 {
	return (volatile.LoadUint32(&o.USBINTST.Reg) & 0x80000000) >> 31
}

// SYSCON.DMACREQSEL: Selects between alternative requests on DMA channels 0 through 7 and 10 through 15
func (o *SYSCON_Type) SetDMACREQSEL_DMASEL08(value uint32) {
	volatile.StoreUint32(&o.DMACREQSEL.Reg, volatile.LoadUint32(&o.DMACREQSEL.Reg)&^(0x1)|value)
}
func (o *SYSCON_Type) GetDMACREQSEL_DMASEL08() uint32 {
	return volatile.LoadUint32(&o.DMACREQSEL.Reg) & 0x1
}
func (o *SYSCON_Type) SetDMACREQSEL_DMASEL09(value uint32) {
	volatile.StoreUint32(&o.DMACREQSEL.Reg, volatile.LoadUint32(&o.DMACREQSEL.Reg)&^(0x2)|value<<1)
}
func (o *SYSCON_Type) GetDMACREQSEL_DMASEL09() uint32 {
	return (volatile.LoadUint32(&o.DMACREQSEL.Reg) & 0x2) >> 1
}
func (o *SYSCON_Type) SetDMACREQSEL_DMASEL10(value uint32) {
	volatile.StoreUint32(&o.DMACREQSEL.Reg, volatile.LoadUint32(&o.DMACREQSEL.Reg)&^(0x4)|value<<2)
}
func (o *SYSCON_Type) GetDMACREQSEL_DMASEL10() uint32 {
	return (volatile.LoadUint32(&o.DMACREQSEL.Reg) & 0x4) >> 2
}
func (o *SYSCON_Type) SetDMACREQSEL_DMASEL11(value uint32) {
	volatile.StoreUint32(&o.DMACREQSEL.Reg, volatile.LoadUint32(&o.DMACREQSEL.Reg)&^(0x8)|value<<3)
}
func (o *SYSCON_Type) GetDMACREQSEL_DMASEL11() uint32 {
	return (volatile.LoadUint32(&o.DMACREQSEL.Reg) & 0x8) >> 3
}
func (o *SYSCON_Type) SetDMACREQSEL_DMASEL12(value uint32) {
	volatile.StoreUint32(&o.DMACREQSEL.Reg, volatile.LoadUint32(&o.DMACREQSEL.Reg)&^(0x10)|value<<4)
}
func (o *SYSCON_Type) GetDMACREQSEL_DMASEL12() uint32 {
	return (volatile.LoadUint32(&o.DMACREQSEL.Reg) & 0x10) >> 4
}
func (o *SYSCON_Type) SetDMACREQSEL_DMASEL13(value uint32) {
	volatile.StoreUint32(&o.DMACREQSEL.Reg, volatile.LoadUint32(&o.DMACREQSEL.Reg)&^(0x20)|value<<5)
}
func (o *SYSCON_Type) GetDMACREQSEL_DMASEL13() uint32 {
	return (volatile.LoadUint32(&o.DMACREQSEL.Reg) & 0x20) >> 5
}
func (o *SYSCON_Type) SetDMACREQSEL_DMASEL14(value uint32) {
	volatile.StoreUint32(&o.DMACREQSEL.Reg, volatile.LoadUint32(&o.DMACREQSEL.Reg)&^(0x40)|value<<6)
}
func (o *SYSCON_Type) GetDMACREQSEL_DMASEL14() uint32 {
	return (volatile.LoadUint32(&o.DMACREQSEL.Reg) & 0x40) >> 6
}
func (o *SYSCON_Type) SetDMACREQSEL_DMASEL15(value uint32) {
	volatile.StoreUint32(&o.DMACREQSEL.Reg, volatile.LoadUint32(&o.DMACREQSEL.Reg)&^(0x80)|value<<7)
}
func (o *SYSCON_Type) GetDMACREQSEL_DMASEL15() uint32 {
	return (volatile.LoadUint32(&o.DMACREQSEL.Reg) & 0x80) >> 7
}
func (o *SYSCON_Type) SetDMACREQSEL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMACREQSEL.Reg, volatile.LoadUint32(&o.DMACREQSEL.Reg)&^(0xffffff00)|value<<8)
}
func (o *SYSCON_Type) GetDMACREQSEL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMACREQSEL.Reg) & 0xffffff00) >> 8
}

// SYSCON.CLKOUTCFG: Clock Output Configuration Register
func (o *SYSCON_Type) SetCLKOUTCFG_CLKOUTSEL(value uint32) {
	volatile.StoreUint32(&o.CLKOUTCFG.Reg, volatile.LoadUint32(&o.CLKOUTCFG.Reg)&^(0xf)|value)
}
func (o *SYSCON_Type) GetCLKOUTCFG_CLKOUTSEL() uint32 {
	return volatile.LoadUint32(&o.CLKOUTCFG.Reg) & 0xf
}
func (o *SYSCON_Type) SetCLKOUTCFG_CLKOUTDIV(value uint32) {
	volatile.StoreUint32(&o.CLKOUTCFG.Reg, volatile.LoadUint32(&o.CLKOUTCFG.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCON_Type) GetCLKOUTCFG_CLKOUTDIV() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTCFG.Reg) & 0xf0) >> 4
}
func (o *SYSCON_Type) SetCLKOUTCFG_CLKOUT_EN(value uint32) {
	volatile.StoreUint32(&o.CLKOUTCFG.Reg, volatile.LoadUint32(&o.CLKOUTCFG.Reg)&^(0x100)|value<<8)
}
func (o *SYSCON_Type) GetCLKOUTCFG_CLKOUT_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTCFG.Reg) & 0x100) >> 8
}
func (o *SYSCON_Type) SetCLKOUTCFG_CLKOUT_ACT(value uint32) {
	volatile.StoreUint32(&o.CLKOUTCFG.Reg, volatile.LoadUint32(&o.CLKOUTCFG.Reg)&^(0x200)|value<<9)
}
func (o *SYSCON_Type) GetCLKOUTCFG_CLKOUT_ACT() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTCFG.Reg) & 0x200) >> 9
}
func (o *SYSCON_Type) SetCLKOUTCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLKOUTCFG.Reg, volatile.LoadUint32(&o.CLKOUTCFG.Reg)&^(0xfffffc00)|value<<10)
}
func (o *SYSCON_Type) GetCLKOUTCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLKOUTCFG.Reg) & 0xfffffc00) >> 10
}

// Ethernet
type ETHERNET_Type struct {
	MAC1               volatile.Register32 // 0x0
	MAC2               volatile.Register32 // 0x4
	IPGT               volatile.Register32 // 0x8
	IPGR               volatile.Register32 // 0xC
	CLRT               volatile.Register32 // 0x10
	MAXF               volatile.Register32 // 0x14
	SUPP               volatile.Register32 // 0x18
	TEST               volatile.Register32 // 0x1C
	MCFG               volatile.Register32 // 0x20
	MCMD               volatile.Register32 // 0x24
	MADR               volatile.Register32 // 0x28
	MWTD               volatile.Register32 // 0x2C
	MRDD               volatile.Register32 // 0x30
	MIND               volatile.Register32 // 0x34
	_                  [8]byte
	SA0                volatile.Register32 // 0x40
	SA1                volatile.Register32 // 0x44
	SA2                volatile.Register32 // 0x48
	_                  [180]byte
	COMMAND            volatile.Register32 // 0x100
	STATUS             volatile.Register32 // 0x104
	RXDESCRIPTOR       volatile.Register32 // 0x108
	RXSTATUS           volatile.Register32 // 0x10C
	RXDESCRIPTORNUMBER volatile.Register32 // 0x110
	RXPRODUCEINDEX     volatile.Register32 // 0x114
	RXCONSUMEINDEX     volatile.Register32 // 0x118
	TXDESCRIPTOR       volatile.Register32 // 0x11C
	TXSTATUS           volatile.Register32 // 0x120
	TXDESCRIPTORNUMBER volatile.Register32 // 0x124
	TXPRODUCEINDEX     volatile.Register32 // 0x128
	TXCONSUMEINDEX     volatile.Register32 // 0x12C
	_                  [40]byte
	TSV0               volatile.Register32 // 0x158
	TSV1               volatile.Register32 // 0x15C
	RSV                volatile.Register32 // 0x160
	_                  [12]byte
	FLOWCONTROLCOUNTER volatile.Register32 // 0x170
	FLOWCONTROLSTATUS  volatile.Register32 // 0x174
	_                  [136]byte
	RXFILTERCTRL       volatile.Register32 // 0x200
	RXFILTERWOLSTATUS  volatile.Register32 // 0x204
	RXFILTERWOLCLEAR   volatile.Register32 // 0x208
	_                  [4]byte
	HASHFILTERL        volatile.Register32 // 0x210
	HASHFILTERH        volatile.Register32 // 0x214
	_                  [3528]byte
	INTSTATUS          volatile.Register32 // 0xFE0
	INTENABLE          volatile.Register32 // 0xFE4
	INTCLEAR           volatile.Register32 // 0xFE8
	INTSET             volatile.Register32 // 0xFEC
	_                  [4]byte
	POWERDOWN          volatile.Register32 // 0xFF4
}

// ETHERNET.MAC1: MAC configuration register 1.
func (o *ETHERNET_Type) SetMAC1_RXENABLE(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMAC1_RXENABLE() uint32 {
	return volatile.LoadUint32(&o.MAC1.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMAC1_PARF(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMAC1_PARF() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMAC1_RXFLOWCTRL(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetMAC1_RXFLOWCTRL() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetMAC1_TXFLOWCTRL(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetMAC1_TXFLOWCTRL() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetMAC1_LOOPBACK(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetMAC1_LOOPBACK() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetMAC1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0xe0)|value<<5)
}
func (o *ETHERNET_Type) GetMAC1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0xe0) >> 5
}
func (o *ETHERNET_Type) SetMAC1_RESETTX(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetMAC1_RESETTX() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetMAC1_RESETMCSTX(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetMAC1_RESETMCSTX() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetMAC1_RESETRX(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x400)|value<<10)
}
func (o *ETHERNET_Type) GetMAC1_RESETRX() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x400) >> 10
}
func (o *ETHERNET_Type) SetMAC1_RESETMCSRX(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x800)|value<<11)
}
func (o *ETHERNET_Type) GetMAC1_RESETMCSRX() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x800) >> 11
}
func (o *ETHERNET_Type) SetMAC1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x3000)|value<<12)
}
func (o *ETHERNET_Type) GetMAC1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x3000) >> 12
}
func (o *ETHERNET_Type) SetMAC1_SIMRESET(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x4000)|value<<14)
}
func (o *ETHERNET_Type) GetMAC1_SIMRESET() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x4000) >> 14
}
func (o *ETHERNET_Type) SetMAC1_SOFTRESET(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0x8000)|value<<15)
}
func (o *ETHERNET_Type) GetMAC1_SOFTRESET() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0x8000) >> 15
}
func (o *ETHERNET_Type) SetMAC1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC1.Reg, volatile.LoadUint32(&o.MAC1.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMAC1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC1.Reg) & 0xffff0000) >> 16
}

// ETHERNET.MAC2: MAC configuration register 2.
func (o *ETHERNET_Type) SetMAC2_FULLDUPLEX(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMAC2_FULLDUPLEX() uint32 {
	return volatile.LoadUint32(&o.MAC2.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMAC2_FLC(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMAC2_FLC() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMAC2_HFEN(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetMAC2_HFEN() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetMAC2_DELAYEDCRC(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetMAC2_DELAYEDCRC() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetMAC2_CRCEN(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetMAC2_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetMAC2_PADCRCEN(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetMAC2_PADCRCEN() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetMAC2_VLANPADEN(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetMAC2_VLANPADEN() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetMAC2_AUTODETPADEN(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetMAC2_AUTODETPADEN() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetMAC2_PPENF(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetMAC2_PPENF() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetMAC2_LPENF(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetMAC2_LPENF() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetMAC2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0xc00)|value<<10)
}
func (o *ETHERNET_Type) GetMAC2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0xc00) >> 10
}
func (o *ETHERNET_Type) SetMAC2_NOBACKOFF(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetMAC2_NOBACKOFF() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetMAC2_BP_NOBACKOFF(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetMAC2_BP_NOBACKOFF() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetMAC2_EXCESSDEFER(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0x4000)|value<<14)
}
func (o *ETHERNET_Type) GetMAC2_EXCESSDEFER() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0x4000) >> 14
}
func (o *ETHERNET_Type) SetMAC2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAC2.Reg, volatile.LoadUint32(&o.MAC2.Reg)&^(0xffff8000)|value<<15)
}
func (o *ETHERNET_Type) GetMAC2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAC2.Reg) & 0xffff8000) >> 15
}

// ETHERNET.IPGT: Back-to-Back Inter-Packet-Gap register.
func (o *ETHERNET_Type) SetIPGT_BTOBINTEGAP(value uint32) {
	volatile.StoreUint32(&o.IPGT.Reg, volatile.LoadUint32(&o.IPGT.Reg)&^(0x7f)|value)
}
func (o *ETHERNET_Type) GetIPGT_BTOBINTEGAP() uint32 {
	return volatile.LoadUint32(&o.IPGT.Reg) & 0x7f
}
func (o *ETHERNET_Type) SetIPGT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IPGT.Reg, volatile.LoadUint32(&o.IPGT.Reg)&^(0xffffff80)|value<<7)
}
func (o *ETHERNET_Type) GetIPGT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IPGT.Reg) & 0xffffff80) >> 7
}

// ETHERNET.IPGR: Non Back-to-Back Inter-Packet-Gap register.
func (o *ETHERNET_Type) SetIPGR_NBTOBINTEGAP2(value uint32) {
	volatile.StoreUint32(&o.IPGR.Reg, volatile.LoadUint32(&o.IPGR.Reg)&^(0x7f)|value)
}
func (o *ETHERNET_Type) GetIPGR_NBTOBINTEGAP2() uint32 {
	return volatile.LoadUint32(&o.IPGR.Reg) & 0x7f
}
func (o *ETHERNET_Type) SetIPGR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IPGR.Reg, volatile.LoadUint32(&o.IPGR.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetIPGR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IPGR.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetIPGR_NBTOBINTEGAP1(value uint32) {
	volatile.StoreUint32(&o.IPGR.Reg, volatile.LoadUint32(&o.IPGR.Reg)&^(0x7f00)|value<<8)
}
func (o *ETHERNET_Type) GetIPGR_NBTOBINTEGAP1() uint32 {
	return (volatile.LoadUint32(&o.IPGR.Reg) & 0x7f00) >> 8
}
func (o *ETHERNET_Type) SetIPGR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.IPGR.Reg, volatile.LoadUint32(&o.IPGR.Reg)&^(0xffff8000)|value<<15)
}
func (o *ETHERNET_Type) GetIPGR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.IPGR.Reg) & 0xffff8000) >> 15
}

// ETHERNET.CLRT: Collision window / Retry register.
func (o *ETHERNET_Type) SetCLRT_RETRANSMAX(value uint32) {
	volatile.StoreUint32(&o.CLRT.Reg, volatile.LoadUint32(&o.CLRT.Reg)&^(0xf)|value)
}
func (o *ETHERNET_Type) GetCLRT_RETRANSMAX() uint32 {
	return volatile.LoadUint32(&o.CLRT.Reg) & 0xf
}
func (o *ETHERNET_Type) SetCLRT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLRT.Reg, volatile.LoadUint32(&o.CLRT.Reg)&^(0xf0)|value<<4)
}
func (o *ETHERNET_Type) GetCLRT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLRT.Reg) & 0xf0) >> 4
}
func (o *ETHERNET_Type) SetCLRT_COLLWIN(value uint32) {
	volatile.StoreUint32(&o.CLRT.Reg, volatile.LoadUint32(&o.CLRT.Reg)&^(0x3f00)|value<<8)
}
func (o *ETHERNET_Type) GetCLRT_COLLWIN() uint32 {
	return (volatile.LoadUint32(&o.CLRT.Reg) & 0x3f00) >> 8
}
func (o *ETHERNET_Type) SetCLRT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CLRT.Reg, volatile.LoadUint32(&o.CLRT.Reg)&^(0xffffc000)|value<<14)
}
func (o *ETHERNET_Type) GetCLRT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CLRT.Reg) & 0xffffc000) >> 14
}

// ETHERNET.MAXF: Maximum Frame register.
func (o *ETHERNET_Type) SetMAXF_MAXFLEN(value uint32) {
	volatile.StoreUint32(&o.MAXF.Reg, volatile.LoadUint32(&o.MAXF.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetMAXF_MAXFLEN() uint32 {
	return volatile.LoadUint32(&o.MAXF.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetMAXF_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAXF.Reg, volatile.LoadUint32(&o.MAXF.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMAXF_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAXF.Reg) & 0xffff0000) >> 16
}

// ETHERNET.SUPP: PHY Support register.
func (o *ETHERNET_Type) SetSUPP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SUPP.Reg, volatile.LoadUint32(&o.SUPP.Reg)&^(0xff)|value)
}
func (o *ETHERNET_Type) GetSUPP_RESERVED() uint32 {
	return volatile.LoadUint32(&o.SUPP.Reg) & 0xff
}
func (o *ETHERNET_Type) SetSUPP_SPEED(value uint32) {
	volatile.StoreUint32(&o.SUPP.Reg, volatile.LoadUint32(&o.SUPP.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetSUPP_SPEED() uint32 {
	return (volatile.LoadUint32(&o.SUPP.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetSUPP_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SUPP.Reg, volatile.LoadUint32(&o.SUPP.Reg)&^(0xfffffe00)|value<<9)
}
func (o *ETHERNET_Type) GetSUPP_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SUPP.Reg) & 0xfffffe00) >> 9
}

// ETHERNET.TEST: Test register.
func (o *ETHERNET_Type) SetTEST_SCPQ(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetTEST_SCPQ() uint32 {
	return volatile.LoadUint32(&o.TEST.Reg) & 0x1
}
func (o *ETHERNET_Type) SetTEST_TESTPAUSE(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetTEST_TESTPAUSE() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetTEST_TESTBP(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetTEST_TESTBP() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetTEST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TEST.Reg, volatile.LoadUint32(&o.TEST.Reg)&^(0xfffffff8)|value<<3)
}
func (o *ETHERNET_Type) GetTEST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TEST.Reg) & 0xfffffff8) >> 3
}

// ETHERNET.MCFG: MII Mgmt Configuration register.
func (o *ETHERNET_Type) SetMCFG_SCANINC(value uint32) {
	volatile.StoreUint32(&o.MCFG.Reg, volatile.LoadUint32(&o.MCFG.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMCFG_SCANINC() uint32 {
	return volatile.LoadUint32(&o.MCFG.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMCFG_SUPPPREAMBLE(value uint32) {
	volatile.StoreUint32(&o.MCFG.Reg, volatile.LoadUint32(&o.MCFG.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMCFG_SUPPPREAMBLE() uint32 {
	return (volatile.LoadUint32(&o.MCFG.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMCFG_CLOCKSEL(value uint32) {
	volatile.StoreUint32(&o.MCFG.Reg, volatile.LoadUint32(&o.MCFG.Reg)&^(0x3c)|value<<2)
}
func (o *ETHERNET_Type) GetMCFG_CLOCKSEL() uint32 {
	return (volatile.LoadUint32(&o.MCFG.Reg) & 0x3c) >> 2
}
func (o *ETHERNET_Type) SetMCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCFG.Reg, volatile.LoadUint32(&o.MCFG.Reg)&^(0x7fc0)|value<<6)
}
func (o *ETHERNET_Type) GetMCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCFG.Reg) & 0x7fc0) >> 6
}
func (o *ETHERNET_Type) SetMCFG_RESETMIIMGMT(value uint32) {
	volatile.StoreUint32(&o.MCFG.Reg, volatile.LoadUint32(&o.MCFG.Reg)&^(0x8000)|value<<15)
}
func (o *ETHERNET_Type) GetMCFG_RESETMIIMGMT() uint32 {
	return (volatile.LoadUint32(&o.MCFG.Reg) & 0x8000) >> 15
}
func (o *ETHERNET_Type) SetMCFG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCFG.Reg, volatile.LoadUint32(&o.MCFG.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMCFG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCFG.Reg) & 0xffff0000) >> 16
}

// ETHERNET.MCMD: MII Mgmt Command register.
func (o *ETHERNET_Type) SetMCMD_READ(value uint32) {
	volatile.StoreUint32(&o.MCMD.Reg, volatile.LoadUint32(&o.MCMD.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMCMD_READ() uint32 {
	return volatile.LoadUint32(&o.MCMD.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMCMD_SCAN(value uint32) {
	volatile.StoreUint32(&o.MCMD.Reg, volatile.LoadUint32(&o.MCMD.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMCMD_SCAN() uint32 {
	return (volatile.LoadUint32(&o.MCMD.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMCMD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MCMD.Reg, volatile.LoadUint32(&o.MCMD.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ETHERNET_Type) GetMCMD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MCMD.Reg) & 0xfffffffc) >> 2
}

// ETHERNET.MADR: MII Mgmt Address register.
func (o *ETHERNET_Type) SetMADR_REGADDR(value uint32) {
	volatile.StoreUint32(&o.MADR.Reg, volatile.LoadUint32(&o.MADR.Reg)&^(0x1f)|value)
}
func (o *ETHERNET_Type) GetMADR_REGADDR() uint32 {
	return volatile.LoadUint32(&o.MADR.Reg) & 0x1f
}
func (o *ETHERNET_Type) SetMADR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MADR.Reg, volatile.LoadUint32(&o.MADR.Reg)&^(0xe0)|value<<5)
}
func (o *ETHERNET_Type) GetMADR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MADR.Reg) & 0xe0) >> 5
}
func (o *ETHERNET_Type) SetMADR_PHYADDR(value uint32) {
	volatile.StoreUint32(&o.MADR.Reg, volatile.LoadUint32(&o.MADR.Reg)&^(0x1f00)|value<<8)
}
func (o *ETHERNET_Type) GetMADR_PHYADDR() uint32 {
	return (volatile.LoadUint32(&o.MADR.Reg) & 0x1f00) >> 8
}
func (o *ETHERNET_Type) SetMADR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MADR.Reg, volatile.LoadUint32(&o.MADR.Reg)&^(0xffffe000)|value<<13)
}
func (o *ETHERNET_Type) GetMADR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MADR.Reg) & 0xffffe000) >> 13
}

// ETHERNET.MWTD: MII Mgmt Write Data register.
func (o *ETHERNET_Type) SetMWTD_WRITEDATA(value uint32) {
	volatile.StoreUint32(&o.MWTD.Reg, volatile.LoadUint32(&o.MWTD.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetMWTD_WRITEDATA() uint32 {
	return volatile.LoadUint32(&o.MWTD.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetMWTD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MWTD.Reg, volatile.LoadUint32(&o.MWTD.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMWTD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MWTD.Reg) & 0xffff0000) >> 16
}

// ETHERNET.MRDD: MII Mgmt Read Data register.
func (o *ETHERNET_Type) SetMRDD_READDATA(value uint32) {
	volatile.StoreUint32(&o.MRDD.Reg, volatile.LoadUint32(&o.MRDD.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetMRDD_READDATA() uint32 {
	return volatile.LoadUint32(&o.MRDD.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetMRDD_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MRDD.Reg, volatile.LoadUint32(&o.MRDD.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetMRDD_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MRDD.Reg) & 0xffff0000) >> 16
}

// ETHERNET.MIND: MII Mgmt Indicators register.
func (o *ETHERNET_Type) SetMIND_BUSY(value uint32) {
	volatile.StoreUint32(&o.MIND.Reg, volatile.LoadUint32(&o.MIND.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetMIND_BUSY() uint32 {
	return volatile.LoadUint32(&o.MIND.Reg) & 0x1
}
func (o *ETHERNET_Type) SetMIND_SCANNING(value uint32) {
	volatile.StoreUint32(&o.MIND.Reg, volatile.LoadUint32(&o.MIND.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetMIND_SCANNING() uint32 {
	return (volatile.LoadUint32(&o.MIND.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetMIND_NOTVALID(value uint32) {
	volatile.StoreUint32(&o.MIND.Reg, volatile.LoadUint32(&o.MIND.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetMIND_NOTVALID() uint32 {
	return (volatile.LoadUint32(&o.MIND.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetMIND_MIILINKFAIL(value uint32) {
	volatile.StoreUint32(&o.MIND.Reg, volatile.LoadUint32(&o.MIND.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetMIND_MIILINKFAIL() uint32 {
	return (volatile.LoadUint32(&o.MIND.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetMIND_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MIND.Reg, volatile.LoadUint32(&o.MIND.Reg)&^(0xfffffff0)|value<<4)
}
func (o *ETHERNET_Type) GetMIND_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MIND.Reg) & 0xfffffff0) >> 4
}

// ETHERNET.SA0: Station Address 0 register.
func (o *ETHERNET_Type) SetSA0_SADDR2(value uint32) {
	volatile.StoreUint32(&o.SA0.Reg, volatile.LoadUint32(&o.SA0.Reg)&^(0xff)|value)
}
func (o *ETHERNET_Type) GetSA0_SADDR2() uint32 {
	return volatile.LoadUint32(&o.SA0.Reg) & 0xff
}
func (o *ETHERNET_Type) SetSA0_SADDR1(value uint32) {
	volatile.StoreUint32(&o.SA0.Reg, volatile.LoadUint32(&o.SA0.Reg)&^(0xff00)|value<<8)
}
func (o *ETHERNET_Type) GetSA0_SADDR1() uint32 {
	return (volatile.LoadUint32(&o.SA0.Reg) & 0xff00) >> 8
}
func (o *ETHERNET_Type) SetSA0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SA0.Reg, volatile.LoadUint32(&o.SA0.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetSA0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SA0.Reg) & 0xffff0000) >> 16
}

// ETHERNET.SA1: Station Address 1 register.
func (o *ETHERNET_Type) SetSA1_SADDR4(value uint32) {
	volatile.StoreUint32(&o.SA1.Reg, volatile.LoadUint32(&o.SA1.Reg)&^(0xff)|value)
}
func (o *ETHERNET_Type) GetSA1_SADDR4() uint32 {
	return volatile.LoadUint32(&o.SA1.Reg) & 0xff
}
func (o *ETHERNET_Type) SetSA1_SADDR3(value uint32) {
	volatile.StoreUint32(&o.SA1.Reg, volatile.LoadUint32(&o.SA1.Reg)&^(0xff00)|value<<8)
}
func (o *ETHERNET_Type) GetSA1_SADDR3() uint32 {
	return (volatile.LoadUint32(&o.SA1.Reg) & 0xff00) >> 8
}
func (o *ETHERNET_Type) SetSA1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SA1.Reg, volatile.LoadUint32(&o.SA1.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetSA1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SA1.Reg) & 0xffff0000) >> 16
}

// ETHERNET.SA2: Station Address 2 register.
func (o *ETHERNET_Type) SetSA2_SADDR6(value uint32) {
	volatile.StoreUint32(&o.SA2.Reg, volatile.LoadUint32(&o.SA2.Reg)&^(0xff)|value)
}
func (o *ETHERNET_Type) GetSA2_SADDR6() uint32 {
	return volatile.LoadUint32(&o.SA2.Reg) & 0xff
}
func (o *ETHERNET_Type) SetSA2_SADDR5(value uint32) {
	volatile.StoreUint32(&o.SA2.Reg, volatile.LoadUint32(&o.SA2.Reg)&^(0xff00)|value<<8)
}
func (o *ETHERNET_Type) GetSA2_SADDR5() uint32 {
	return (volatile.LoadUint32(&o.SA2.Reg) & 0xff00) >> 8
}
func (o *ETHERNET_Type) SetSA2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SA2.Reg, volatile.LoadUint32(&o.SA2.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetSA2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SA2.Reg) & 0xffff0000) >> 16
}

// ETHERNET.COMMAND: Command register.
func (o *ETHERNET_Type) SetCOMMAND_RXENABLE(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetCOMMAND_RXENABLE() uint32 {
	return volatile.LoadUint32(&o.COMMAND.Reg) & 0x1
}
func (o *ETHERNET_Type) SetCOMMAND_TXENABLE(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetCOMMAND_TXENABLE() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetCOMMAND_RESERVED(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetCOMMAND_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetCOMMAND_REGRESET(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetCOMMAND_REGRESET() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetCOMMAND_TXRESET(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetCOMMAND_TXRESET() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetCOMMAND_RXRESET(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetCOMMAND_RXRESET() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetCOMMAND_PASSRUNTFRAME(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetCOMMAND_PASSRUNTFRAME() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetCOMMAND_PASSRXFILTER(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetCOMMAND_PASSRXFILTER() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetCOMMAND_TXFLOWCONTROL(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetCOMMAND_TXFLOWCONTROL() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetCOMMAND_RMII(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetCOMMAND_RMII() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetCOMMAND_FULLDUPLEX(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0x400)|value<<10)
}
func (o *ETHERNET_Type) GetCOMMAND_FULLDUPLEX() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0x400) >> 10
}
func (o *ETHERNET_Type) SetCOMMAND_RESERVED(value uint32) {
	volatile.StoreUint32(&o.COMMAND.Reg, volatile.LoadUint32(&o.COMMAND.Reg)&^(0xfffff800)|value<<11)
}
func (o *ETHERNET_Type) GetCOMMAND_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.COMMAND.Reg) & 0xfffff800) >> 11
}

// ETHERNET.STATUS: Status register.
func (o *ETHERNET_Type) SetSTATUS_RXSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetSTATUS_RXSTATUS() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *ETHERNET_Type) SetSTATUS_TXSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetSTATUS_TXSTATUS() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ETHERNET_Type) GetSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0xfffffffc) >> 2
}

// ETHERNET.RXDESCRIPTOR: Receive descriptor base address register.
func (o *ETHERNET_Type) SetRXDESCRIPTOR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDESCRIPTOR.Reg, volatile.LoadUint32(&o.RXDESCRIPTOR.Reg)&^(0x3)|value)
}
func (o *ETHERNET_Type) GetRXDESCRIPTOR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.RXDESCRIPTOR.Reg) & 0x3
}
func (o *ETHERNET_Type) SetRXDESCRIPTOR(value uint32) {
	volatile.StoreUint32(&o.RXDESCRIPTOR.Reg, volatile.LoadUint32(&o.RXDESCRIPTOR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ETHERNET_Type) GetRXDESCRIPTOR() uint32 {
	return (volatile.LoadUint32(&o.RXDESCRIPTOR.Reg) & 0xfffffffc) >> 2
}

// ETHERNET.RXSTATUS: Receive status base address register.
func (o *ETHERNET_Type) SetRXSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXSTATUS.Reg, volatile.LoadUint32(&o.RXSTATUS.Reg)&^(0x7)|value)
}
func (o *ETHERNET_Type) GetRXSTATUS_RESERVED() uint32 {
	return volatile.LoadUint32(&o.RXSTATUS.Reg) & 0x7
}
func (o *ETHERNET_Type) SetRXSTATUS(value uint32) {
	volatile.StoreUint32(&o.RXSTATUS.Reg, volatile.LoadUint32(&o.RXSTATUS.Reg)&^(0xfffffff8)|value<<3)
}
func (o *ETHERNET_Type) GetRXSTATUS() uint32 {
	return (volatile.LoadUint32(&o.RXSTATUS.Reg) & 0xfffffff8) >> 3
}

// ETHERNET.RXDESCRIPTORNUMBER: Receive number of descriptors register.
func (o *ETHERNET_Type) SetRXDESCRIPTORNUMBER_RXDESCRIPTORN(value uint32) {
	volatile.StoreUint32(&o.RXDESCRIPTORNUMBER.Reg, volatile.LoadUint32(&o.RXDESCRIPTORNUMBER.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetRXDESCRIPTORNUMBER_RXDESCRIPTORN() uint32 {
	return volatile.LoadUint32(&o.RXDESCRIPTORNUMBER.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetRXDESCRIPTORNUMBER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXDESCRIPTORNUMBER.Reg, volatile.LoadUint32(&o.RXDESCRIPTORNUMBER.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetRXDESCRIPTORNUMBER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXDESCRIPTORNUMBER.Reg) & 0xffff0000) >> 16
}

// ETHERNET.RXPRODUCEINDEX: Receive produce index register.
func (o *ETHERNET_Type) SetRXPRODUCEINDEX_RXPRODUCEIX(value uint32) {
	volatile.StoreUint32(&o.RXPRODUCEINDEX.Reg, volatile.LoadUint32(&o.RXPRODUCEINDEX.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetRXPRODUCEINDEX_RXPRODUCEIX() uint32 {
	return volatile.LoadUint32(&o.RXPRODUCEINDEX.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetRXPRODUCEINDEX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXPRODUCEINDEX.Reg, volatile.LoadUint32(&o.RXPRODUCEINDEX.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetRXPRODUCEINDEX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXPRODUCEINDEX.Reg) & 0xffff0000) >> 16
}

// ETHERNET.RXCONSUMEINDEX: Receive consume index register.
func (o *ETHERNET_Type) SetRXCONSUMEINDEX_RXCONSUMEIX(value uint32) {
	volatile.StoreUint32(&o.RXCONSUMEINDEX.Reg, volatile.LoadUint32(&o.RXCONSUMEINDEX.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetRXCONSUMEINDEX_RXCONSUMEIX() uint32 {
	return volatile.LoadUint32(&o.RXCONSUMEINDEX.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetRXCONSUMEINDEX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXCONSUMEINDEX.Reg, volatile.LoadUint32(&o.RXCONSUMEINDEX.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetRXCONSUMEINDEX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXCONSUMEINDEX.Reg) & 0xffff0000) >> 16
}

// ETHERNET.TXDESCRIPTOR: Transmit descriptor base address register.
func (o *ETHERNET_Type) SetTXDESCRIPTOR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDESCRIPTOR.Reg, volatile.LoadUint32(&o.TXDESCRIPTOR.Reg)&^(0x3)|value)
}
func (o *ETHERNET_Type) GetTXDESCRIPTOR_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TXDESCRIPTOR.Reg) & 0x3
}
func (o *ETHERNET_Type) SetTXDESCRIPTOR_TXD(value uint32) {
	volatile.StoreUint32(&o.TXDESCRIPTOR.Reg, volatile.LoadUint32(&o.TXDESCRIPTOR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ETHERNET_Type) GetTXDESCRIPTOR_TXD() uint32 {
	return (volatile.LoadUint32(&o.TXDESCRIPTOR.Reg) & 0xfffffffc) >> 2
}

// ETHERNET.TXSTATUS: Transmit status base address register.
func (o *ETHERNET_Type) SetTXSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXSTATUS.Reg, volatile.LoadUint32(&o.TXSTATUS.Reg)&^(0x3)|value)
}
func (o *ETHERNET_Type) GetTXSTATUS_RESERVED() uint32 {
	return volatile.LoadUint32(&o.TXSTATUS.Reg) & 0x3
}
func (o *ETHERNET_Type) SetTXSTATUS_TXSTAT(value uint32) {
	volatile.StoreUint32(&o.TXSTATUS.Reg, volatile.LoadUint32(&o.TXSTATUS.Reg)&^(0xfffffffc)|value<<2)
}
func (o *ETHERNET_Type) GetTXSTATUS_TXSTAT() uint32 {
	return (volatile.LoadUint32(&o.TXSTATUS.Reg) & 0xfffffffc) >> 2
}

// ETHERNET.TXDESCRIPTORNUMBER: Transmit number of descriptors register.
func (o *ETHERNET_Type) SetTXDESCRIPTORNUMBER_TXDN(value uint32) {
	volatile.StoreUint32(&o.TXDESCRIPTORNUMBER.Reg, volatile.LoadUint32(&o.TXDESCRIPTORNUMBER.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetTXDESCRIPTORNUMBER_TXDN() uint32 {
	return volatile.LoadUint32(&o.TXDESCRIPTORNUMBER.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetTXDESCRIPTORNUMBER_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXDESCRIPTORNUMBER.Reg, volatile.LoadUint32(&o.TXDESCRIPTORNUMBER.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetTXDESCRIPTORNUMBER_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXDESCRIPTORNUMBER.Reg) & 0xffff0000) >> 16
}

// ETHERNET.TXPRODUCEINDEX: Transmit produce index register.
func (o *ETHERNET_Type) SetTXPRODUCEINDEX_TXPI(value uint32) {
	volatile.StoreUint32(&o.TXPRODUCEINDEX.Reg, volatile.LoadUint32(&o.TXPRODUCEINDEX.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetTXPRODUCEINDEX_TXPI() uint32 {
	return volatile.LoadUint32(&o.TXPRODUCEINDEX.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetTXPRODUCEINDEX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXPRODUCEINDEX.Reg, volatile.LoadUint32(&o.TXPRODUCEINDEX.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetTXPRODUCEINDEX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXPRODUCEINDEX.Reg) & 0xffff0000) >> 16
}

// ETHERNET.TXCONSUMEINDEX: Transmit consume index register.
func (o *ETHERNET_Type) SetTXCONSUMEINDEX_TXCI(value uint32) {
	volatile.StoreUint32(&o.TXCONSUMEINDEX.Reg, volatile.LoadUint32(&o.TXCONSUMEINDEX.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetTXCONSUMEINDEX_TXCI() uint32 {
	return volatile.LoadUint32(&o.TXCONSUMEINDEX.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetTXCONSUMEINDEX_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXCONSUMEINDEX.Reg, volatile.LoadUint32(&o.TXCONSUMEINDEX.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetTXCONSUMEINDEX_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXCONSUMEINDEX.Reg) & 0xffff0000) >> 16
}

// ETHERNET.TSV0: Transmit status vector 0 register.
func (o *ETHERNET_Type) SetTSV0_CRCERR(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetTSV0_CRCERR() uint32 {
	return volatile.LoadUint32(&o.TSV0.Reg) & 0x1
}
func (o *ETHERNET_Type) SetTSV0_LCE(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetTSV0_LCE() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetTSV0_LOR(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetTSV0_LOR() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetTSV0_DONE(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetTSV0_DONE() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetTSV0_MULTICAST(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetTSV0_MULTICAST() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetTSV0_BROADCAST(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetTSV0_BROADCAST() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetTSV0_PACKETDEFER(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetTSV0_PACKETDEFER() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetTSV0_EXDF(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetTSV0_EXDF() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetTSV0_EXCOL(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetTSV0_EXCOL() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetTSV0_LCOL(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x200)|value<<9)
}
func (o *ETHERNET_Type) GetTSV0_LCOL() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x200) >> 9
}
func (o *ETHERNET_Type) SetTSV0_GIANT(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x400)|value<<10)
}
func (o *ETHERNET_Type) GetTSV0_GIANT() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x400) >> 10
}
func (o *ETHERNET_Type) SetTSV0_UNDERRUN(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x800)|value<<11)
}
func (o *ETHERNET_Type) GetTSV0_UNDERRUN() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x800) >> 11
}
func (o *ETHERNET_Type) SetTSV0_TOTALBYTES(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0xffff000)|value<<12)
}
func (o *ETHERNET_Type) GetTSV0_TOTALBYTES() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0xffff000) >> 12
}
func (o *ETHERNET_Type) SetTSV0_CONTROLFRAME(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x10000000)|value<<28)
}
func (o *ETHERNET_Type) GetTSV0_CONTROLFRAME() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x10000000) >> 28
}
func (o *ETHERNET_Type) SetTSV0_PAUSE(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x20000000)|value<<29)
}
func (o *ETHERNET_Type) GetTSV0_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x20000000) >> 29
}
func (o *ETHERNET_Type) SetTSV0_BACKPRESSURE(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x40000000)|value<<30)
}
func (o *ETHERNET_Type) GetTSV0_BACKPRESSURE() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x40000000) >> 30
}
func (o *ETHERNET_Type) SetTSV0_VLAN(value uint32) {
	volatile.StoreUint32(&o.TSV0.Reg, volatile.LoadUint32(&o.TSV0.Reg)&^(0x80000000)|value<<31)
}
func (o *ETHERNET_Type) GetTSV0_VLAN() uint32 {
	return (volatile.LoadUint32(&o.TSV0.Reg) & 0x80000000) >> 31
}

// ETHERNET.TSV1: Transmit status vector 1 register.
func (o *ETHERNET_Type) SetTSV1_TBC(value uint32) {
	volatile.StoreUint32(&o.TSV1.Reg, volatile.LoadUint32(&o.TSV1.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetTSV1_TBC() uint32 {
	return volatile.LoadUint32(&o.TSV1.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetTSV1_TCC(value uint32) {
	volatile.StoreUint32(&o.TSV1.Reg, volatile.LoadUint32(&o.TSV1.Reg)&^(0xf0000)|value<<16)
}
func (o *ETHERNET_Type) GetTSV1_TCC() uint32 {
	return (volatile.LoadUint32(&o.TSV1.Reg) & 0xf0000) >> 16
}
func (o *ETHERNET_Type) SetTSV1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TSV1.Reg, volatile.LoadUint32(&o.TSV1.Reg)&^(0xfff00000)|value<<20)
}
func (o *ETHERNET_Type) GetTSV1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TSV1.Reg) & 0xfff00000) >> 20
}

// ETHERNET.RSV: Receive status vector register.
func (o *ETHERNET_Type) SetRSV_RBC(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetRSV_RBC() uint32 {
	return volatile.LoadUint32(&o.RSV.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetRSV_PPI(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x10000)|value<<16)
}
func (o *ETHERNET_Type) GetRSV_PPI() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x10000) >> 16
}
func (o *ETHERNET_Type) SetRSV_RXDVSEEN(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x20000)|value<<17)
}
func (o *ETHERNET_Type) GetRSV_RXDVSEEN() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x20000) >> 17
}
func (o *ETHERNET_Type) SetRSV_CESEEN(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x40000)|value<<18)
}
func (o *ETHERNET_Type) GetRSV_CESEEN() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x40000) >> 18
}
func (o *ETHERNET_Type) SetRSV_RCV(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x80000)|value<<19)
}
func (o *ETHERNET_Type) GetRSV_RCV() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x80000) >> 19
}
func (o *ETHERNET_Type) SetRSV_CRCERR(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x100000)|value<<20)
}
func (o *ETHERNET_Type) GetRSV_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x100000) >> 20
}
func (o *ETHERNET_Type) SetRSV_LCERR(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x200000)|value<<21)
}
func (o *ETHERNET_Type) GetRSV_LCERR() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x200000) >> 21
}
func (o *ETHERNET_Type) SetRSV_LOR(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x400000)|value<<22)
}
func (o *ETHERNET_Type) GetRSV_LOR() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x400000) >> 22
}
func (o *ETHERNET_Type) SetRSV_ROK(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x800000)|value<<23)
}
func (o *ETHERNET_Type) GetRSV_ROK() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x800000) >> 23
}
func (o *ETHERNET_Type) SetRSV_MULTICAST(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x1000000)|value<<24)
}
func (o *ETHERNET_Type) GetRSV_MULTICAST() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x1000000) >> 24
}
func (o *ETHERNET_Type) SetRSV_BROADCAST(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x2000000)|value<<25)
}
func (o *ETHERNET_Type) GetRSV_BROADCAST() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x2000000) >> 25
}
func (o *ETHERNET_Type) SetRSV_DRIBBLENIBBLE(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x4000000)|value<<26)
}
func (o *ETHERNET_Type) GetRSV_DRIBBLENIBBLE() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x4000000) >> 26
}
func (o *ETHERNET_Type) SetRSV_CONTROLFRAME(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x8000000)|value<<27)
}
func (o *ETHERNET_Type) GetRSV_CONTROLFRAME() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x8000000) >> 27
}
func (o *ETHERNET_Type) SetRSV_PAUSE(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x10000000)|value<<28)
}
func (o *ETHERNET_Type) GetRSV_PAUSE() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x10000000) >> 28
}
func (o *ETHERNET_Type) SetRSV_UO(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x20000000)|value<<29)
}
func (o *ETHERNET_Type) GetRSV_UO() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x20000000) >> 29
}
func (o *ETHERNET_Type) SetRSV_VLAN(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x40000000)|value<<30)
}
func (o *ETHERNET_Type) GetRSV_VLAN() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x40000000) >> 30
}
func (o *ETHERNET_Type) SetRSV_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RSV.Reg, volatile.LoadUint32(&o.RSV.Reg)&^(0x80000000)|value<<31)
}
func (o *ETHERNET_Type) GetRSV_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RSV.Reg) & 0x80000000) >> 31
}

// ETHERNET.FLOWCONTROLCOUNTER: Flow control counter register.
func (o *ETHERNET_Type) SetFLOWCONTROLCOUNTER_MC(value uint32) {
	volatile.StoreUint32(&o.FLOWCONTROLCOUNTER.Reg, volatile.LoadUint32(&o.FLOWCONTROLCOUNTER.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetFLOWCONTROLCOUNTER_MC() uint32 {
	return volatile.LoadUint32(&o.FLOWCONTROLCOUNTER.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetFLOWCONTROLCOUNTER_PT(value uint32) {
	volatile.StoreUint32(&o.FLOWCONTROLCOUNTER.Reg, volatile.LoadUint32(&o.FLOWCONTROLCOUNTER.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetFLOWCONTROLCOUNTER_PT() uint32 {
	return (volatile.LoadUint32(&o.FLOWCONTROLCOUNTER.Reg) & 0xffff0000) >> 16
}

// ETHERNET.FLOWCONTROLSTATUS: Flow control status register.
func (o *ETHERNET_Type) SetFLOWCONTROLSTATUS_MCC(value uint32) {
	volatile.StoreUint32(&o.FLOWCONTROLSTATUS.Reg, volatile.LoadUint32(&o.FLOWCONTROLSTATUS.Reg)&^(0xffff)|value)
}
func (o *ETHERNET_Type) GetFLOWCONTROLSTATUS_MCC() uint32 {
	return volatile.LoadUint32(&o.FLOWCONTROLSTATUS.Reg) & 0xffff
}
func (o *ETHERNET_Type) SetFLOWCONTROLSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.FLOWCONTROLSTATUS.Reg, volatile.LoadUint32(&o.FLOWCONTROLSTATUS.Reg)&^(0xffff0000)|value<<16)
}
func (o *ETHERNET_Type) GetFLOWCONTROLSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.FLOWCONTROLSTATUS.Reg) & 0xffff0000) >> 16
}

// ETHERNET.RXFILTERCTRL: Receive filter control register.
func (o *ETHERNET_Type) SetRXFILTERCTRL_AUE(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_AUE() uint32 {
	return volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x1
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_ABE(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_ABE() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_AME(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_AME() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_AUHE(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_AUHE() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_AMHE(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_AMHE() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_APE(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_APE() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0xfc0)|value<<6)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0xfc0) >> 6
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_MPEW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_MPEW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_RFEW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_RFEW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetRXFILTERCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXFILTERCTRL.Reg, volatile.LoadUint32(&o.RXFILTERCTRL.Reg)&^(0xffffc000)|value<<14)
}
func (o *ETHERNET_Type) GetRXFILTERCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERCTRL.Reg) & 0xffffc000) >> 14
}

// ETHERNET.RXFILTERWOLSTATUS: Receive filter WoL status register.
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_AUW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_AUW() uint32 {
	return volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x1
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_ABW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_ABW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_AMW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_AMW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_AUHW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_AUHW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_AMHW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_AMHW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_APW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_APW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_RFW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_RFW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_MPW(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_MPW() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetRXFILTERWOLSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLSTATUS.Reg, volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg)&^(0xfffffe00)|value<<9)
}
func (o *ETHERNET_Type) GetRXFILTERWOLSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLSTATUS.Reg) & 0xfffffe00) >> 9
}

// ETHERNET.RXFILTERWOLCLEAR: Receive filter WoL clear register.
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_AUWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_AUWCLR() uint32 {
	return volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x1
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_ABWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_ABWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_AMWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_AMWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_AUHWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_AUHWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_AMHWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_AMHWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_APWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_APWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_RFWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_RFWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_MPWCLR(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0x100)|value<<8)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_MPWCLR() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0x100) >> 8
}
func (o *ETHERNET_Type) SetRXFILTERWOLCLEAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXFILTERWOLCLEAR.Reg, volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg)&^(0xfffffe00)|value<<9)
}
func (o *ETHERNET_Type) GetRXFILTERWOLCLEAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXFILTERWOLCLEAR.Reg) & 0xfffffe00) >> 9
}

// ETHERNET.HASHFILTERL: Hash filter table LSBs register.
func (o *ETHERNET_Type) SetHASHFILTERL(value uint32) {
	volatile.StoreUint32(&o.HASHFILTERL.Reg, value)
}
func (o *ETHERNET_Type) GetHASHFILTERL() uint32 {
	return volatile.LoadUint32(&o.HASHFILTERL.Reg)
}

// ETHERNET.HASHFILTERH: Hash filter table MSBs register.
func (o *ETHERNET_Type) SetHASHFILTERH(value uint32) {
	volatile.StoreUint32(&o.HASHFILTERH.Reg, value)
}
func (o *ETHERNET_Type) GetHASHFILTERH() uint32 {
	return volatile.LoadUint32(&o.HASHFILTERH.Reg)
}

// ETHERNET.INTSTATUS: Interrupt status register.
func (o *ETHERNET_Type) SetINTSTATUS_RXOVERRUNINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetINTSTATUS_RXOVERRUNINT() uint32 {
	return volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x1
}
func (o *ETHERNET_Type) SetINTSTATUS_RXERRORINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetINTSTATUS_RXERRORINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetINTSTATUS_RXFINISHEDINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetINTSTATUS_RXFINISHEDINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetINTSTATUS_RXDONEINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetINTSTATUS_RXDONEINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetINTSTATUS_TXUNDERRUNINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetINTSTATUS_TXUNDERRUNINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetINTSTATUS_TXERRORINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetINTSTATUS_TXERRORINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetINTSTATUS_TXFINISHEDINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetINTSTATUS_TXFINISHEDINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetINTSTATUS_TXDONEINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetINTSTATUS_TXDONEINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetINTSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0xf00)|value<<8)
}
func (o *ETHERNET_Type) GetINTSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0xf00) >> 8
}
func (o *ETHERNET_Type) SetINTSTATUS_SOFTINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetINTSTATUS_SOFTINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetINTSTATUS_WAKEUPINT(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetINTSTATUS_WAKEUPINT() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetINTSTATUS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0xffffc000)|value<<14)
}
func (o *ETHERNET_Type) GetINTSTATUS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0xffffc000) >> 14
}

// ETHERNET.INTENABLE: Interrupt enable register.
func (o *ETHERNET_Type) SetINTENABLE_RXOVERRUNINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetINTENABLE_RXOVERRUNINTEN() uint32 {
	return volatile.LoadUint32(&o.INTENABLE.Reg) & 0x1
}
func (o *ETHERNET_Type) SetINTENABLE_RXERRORINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetINTENABLE_RXERRORINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetINTENABLE_RXFINISHEDINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetINTENABLE_RXFINISHEDINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetINTENABLE_RXDONEINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetINTENABLE_RXDONEINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetINTENABLE_TXUNDERRUNINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetINTENABLE_TXUNDERRUNINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetINTENABLE_TXERRORINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetINTENABLE_TXERRORINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetINTENABLE_TXFINISHEDINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetINTENABLE_TXFINISHEDINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetINTENABLE_TXDONEINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetINTENABLE_TXDONEINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetINTENABLE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0xf00)|value<<8)
}
func (o *ETHERNET_Type) GetINTENABLE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0xf00) >> 8
}
func (o *ETHERNET_Type) SetINTENABLE_SOFTINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetINTENABLE_SOFTINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetINTENABLE_WAKEUPINTEN(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetINTENABLE_WAKEUPINTEN() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetINTENABLE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTENABLE.Reg, volatile.LoadUint32(&o.INTENABLE.Reg)&^(0xffffc000)|value<<14)
}
func (o *ETHERNET_Type) GetINTENABLE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTENABLE.Reg) & 0xffffc000) >> 14
}

// ETHERNET.INTCLEAR: Interrupt clear register.
func (o *ETHERNET_Type) SetINTCLEAR_RXOVERRUNINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetINTCLEAR_RXOVERRUNINTCLR() uint32 {
	return volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x1
}
func (o *ETHERNET_Type) SetINTCLEAR_RXERRORINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetINTCLEAR_RXERRORINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetINTCLEAR_RXFINISHEDINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetINTCLEAR_RXFINISHEDINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetINTCLEAR_RXDONEINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetINTCLEAR_RXDONEINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetINTCLEAR_TXUNDERRUNINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetINTCLEAR_TXUNDERRUNINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetINTCLEAR_TXERRORINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetINTCLEAR_TXERRORINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetINTCLEAR_TXFINISHEDINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetINTCLEAR_TXFINISHEDINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetINTCLEAR_TXDONEINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetINTCLEAR_TXDONEINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetINTCLEAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0xf00)|value<<8)
}
func (o *ETHERNET_Type) GetINTCLEAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0xf00) >> 8
}
func (o *ETHERNET_Type) SetINTCLEAR_SOFTINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetINTCLEAR_SOFTINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetINTCLEAR_WAKEUPINTCLR(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetINTCLEAR_WAKEUPINTCLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetINTCLEAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTCLEAR.Reg, volatile.LoadUint32(&o.INTCLEAR.Reg)&^(0xffffc000)|value<<14)
}
func (o *ETHERNET_Type) GetINTCLEAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTCLEAR.Reg) & 0xffffc000) >> 14
}

// ETHERNET.INTSET: Interrupt set register.
func (o *ETHERNET_Type) SetINTSET_RXOVERRUNINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x1)|value)
}
func (o *ETHERNET_Type) GetINTSET_RXOVERRUNINTSET() uint32 {
	return volatile.LoadUint32(&o.INTSET.Reg) & 0x1
}
func (o *ETHERNET_Type) SetINTSET_RXERRORINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x2)|value<<1)
}
func (o *ETHERNET_Type) GetINTSET_RXERRORINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x2) >> 1
}
func (o *ETHERNET_Type) SetINTSET_RXFINISHEDINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x4)|value<<2)
}
func (o *ETHERNET_Type) GetINTSET_RXFINISHEDINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x4) >> 2
}
func (o *ETHERNET_Type) SetINTSET_RXDONEINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x8)|value<<3)
}
func (o *ETHERNET_Type) GetINTSET_RXDONEINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x8) >> 3
}
func (o *ETHERNET_Type) SetINTSET_TXUNDERRUNINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x10)|value<<4)
}
func (o *ETHERNET_Type) GetINTSET_TXUNDERRUNINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x10) >> 4
}
func (o *ETHERNET_Type) SetINTSET_TXERRORINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x20)|value<<5)
}
func (o *ETHERNET_Type) GetINTSET_TXERRORINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x20) >> 5
}
func (o *ETHERNET_Type) SetINTSET_TXFINISHEDINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x40)|value<<6)
}
func (o *ETHERNET_Type) GetINTSET_TXFINISHEDINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x40) >> 6
}
func (o *ETHERNET_Type) SetINTSET_TXDONEINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x80)|value<<7)
}
func (o *ETHERNET_Type) GetINTSET_TXDONEINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x80) >> 7
}
func (o *ETHERNET_Type) SetINTSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0xf00)|value<<8)
}
func (o *ETHERNET_Type) GetINTSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0xf00) >> 8
}
func (o *ETHERNET_Type) SetINTSET_SOFTINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x1000)|value<<12)
}
func (o *ETHERNET_Type) GetINTSET_SOFTINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x1000) >> 12
}
func (o *ETHERNET_Type) SetINTSET_WAKEUPINTSET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x2000)|value<<13)
}
func (o *ETHERNET_Type) GetINTSET_WAKEUPINTSET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x2000) >> 13
}
func (o *ETHERNET_Type) SetINTSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0xffffc000)|value<<14)
}
func (o *ETHERNET_Type) GetINTSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0xffffc000) >> 14
}

// ETHERNET.POWERDOWN: Power-down register.
func (o *ETHERNET_Type) SetPOWERDOWN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.POWERDOWN.Reg, volatile.LoadUint32(&o.POWERDOWN.Reg)&^(0x7fffffff)|value)
}
func (o *ETHERNET_Type) GetPOWERDOWN_RESERVED() uint32 {
	return volatile.LoadUint32(&o.POWERDOWN.Reg) & 0x7fffffff
}
func (o *ETHERNET_Type) SetPOWERDOWN_PD(value uint32) {
	volatile.StoreUint32(&o.POWERDOWN.Reg, volatile.LoadUint32(&o.POWERDOWN.Reg)&^(0x80000000)|value<<31)
}
func (o *ETHERNET_Type) GetPOWERDOWN_PD() uint32 {
	return (volatile.LoadUint32(&o.POWERDOWN.Reg) & 0x80000000) >> 31
}

// General purpose DMA controller
type GPDMA_Type struct {
	INTSTAT       volatile.Register32 // 0x0
	INTTCSTAT     volatile.Register32 // 0x4
	INTTCCLEAR    volatile.Register32 // 0x8
	INTERRSTAT    volatile.Register32 // 0xC
	INTERRCLR     volatile.Register32 // 0x10
	RAWINTTCSTAT  volatile.Register32 // 0x14
	RAWINTERRSTAT volatile.Register32 // 0x18
	ENBLDCHNS     volatile.Register32 // 0x1C
	SOFTBREQ      volatile.Register32 // 0x20
	SOFTSREQ      volatile.Register32 // 0x24
	SOFTLBREQ     volatile.Register32 // 0x28
	SOFTLSREQ     volatile.Register32 // 0x2C
	CONFIG        volatile.Register32 // 0x30
	SYNC          volatile.Register32 // 0x34
	_             [200]byte
	SRCADDR0      volatile.Register32 // 0x100
	DESTADDR0     volatile.Register32 // 0x104
	LLI0          volatile.Register32 // 0x108
	CONTROL0      volatile.Register32 // 0x10C
	CONFIG0       volatile.Register32 // 0x110
	_             [12]byte
	SRCADDR1      volatile.Register32 // 0x120
	DESTADDR1     volatile.Register32 // 0x124
	LLI1          volatile.Register32 // 0x128
	CONTROL1      volatile.Register32 // 0x12C
	CONFIG1       volatile.Register32 // 0x130
	_             [12]byte
	SRCADDR2      volatile.Register32 // 0x140
	DESTADDR2     volatile.Register32 // 0x144
	LLI2          volatile.Register32 // 0x148
	CONTROL2      volatile.Register32 // 0x14C
	CONFIG2       volatile.Register32 // 0x150
	_             [12]byte
	SRCADDR3      volatile.Register32 // 0x160
	DESTADDR3     volatile.Register32 // 0x164
	LLI3          volatile.Register32 // 0x168
	CONTROL3      volatile.Register32 // 0x16C
	CONFIG3       volatile.Register32 // 0x170
	_             [12]byte
	SRCADDR4      volatile.Register32 // 0x180
	DESTADDR4     volatile.Register32 // 0x184
	LLI4          volatile.Register32 // 0x188
	CONTROL4      volatile.Register32 // 0x18C
	CONFIG4       volatile.Register32 // 0x190
	_             [12]byte
	SRCADDR5      volatile.Register32 // 0x1A0
	DESTADDR5     volatile.Register32 // 0x1A4
	LLI5          volatile.Register32 // 0x1A8
	CONTROL5      volatile.Register32 // 0x1AC
	CONFIG5       volatile.Register32 // 0x1B0
	_             [12]byte
	SRCADDR6      volatile.Register32 // 0x1C0
	DESTADDR6     volatile.Register32 // 0x1C4
	LLI6          volatile.Register32 // 0x1C8
	CONTROL6      volatile.Register32 // 0x1CC
	CONFIG6       volatile.Register32 // 0x1D0
	_             [12]byte
	SRCADDR7      volatile.Register32 // 0x1E0
	DESTADDR7     volatile.Register32 // 0x1E4
	LLI7          volatile.Register32 // 0x1E8
	CONTROL7      volatile.Register32 // 0x1EC
	CONFIG7       volatile.Register32 // 0x1F0
}

// GPDMA.INTSTAT: DMA Interrupt Status Register
func (o *GPDMA_Type) SetINTSTAT_INTSTAT0(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT0() uint32 {
	return volatile.LoadUint32(&o.INTSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT1(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT1() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT2(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT2() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT3(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT3() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT4(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT4() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT5(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT5() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT6(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT6() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTSTAT_INTSTAT7(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTSTAT_INTSTAT7() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSTAT.Reg, volatile.LoadUint32(&o.INTSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.INTTCSTAT: DMA Interrupt Terminal Count Request Status Register
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT0(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT0() uint32 {
	return volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT1(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT1() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT2(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT2() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT3(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT3() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT4(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT4() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT5(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT5() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT6(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT6() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTTCSTAT_INTTCSTAT7(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTTCSTAT_INTTCSTAT7() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTTCSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTTCSTAT.Reg, volatile.LoadUint32(&o.INTTCSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTTCSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTTCSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.INTTCCLEAR: DMA Interrupt Terminal Count Request Clear Register
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR0(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR0() uint32 {
	return volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR1(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR1() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR2(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR2() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR3(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR3() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR4(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR4() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR5(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR5() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR6(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR6() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTTCCLEAR_INTTCCLEAR7(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTTCCLEAR_INTTCCLEAR7() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTTCCLEAR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTTCCLEAR.Reg, volatile.LoadUint32(&o.INTTCCLEAR.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTTCCLEAR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTTCCLEAR.Reg) & 0xffffff00) >> 8
}

// GPDMA.INTERRSTAT: DMA Interrupt Error Status Register
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT0(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT0() uint32 {
	return volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT1(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT1() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT2(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT2() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT3(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT3() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT4(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT4() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT5(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT5() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT6(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT6() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTERRSTAT_INTERRSTAT7(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTERRSTAT_INTERRSTAT7() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTERRSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTERRSTAT.Reg, volatile.LoadUint32(&o.INTERRSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTERRSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTERRSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.INTERRCLR: DMA Interrupt Error Clear Register
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR0(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR0() uint32 {
	return volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x1
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR1(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR1() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR2(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR2() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR3(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR3() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR4(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR4() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR5(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR5() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR6(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR6() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetINTERRCLR_INTERRCLR7(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetINTERRCLR_INTERRCLR7() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetINTERRCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTERRCLR.Reg, volatile.LoadUint32(&o.INTERRCLR.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetINTERRCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTERRCLR.Reg) & 0xffffff00) >> 8
}

// GPDMA.RAWINTTCSTAT: DMA Raw Interrupt Terminal Count Status Register
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT0(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT0() uint32 {
	return volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT1(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT1() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT2(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT2() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT3(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT3() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT4(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT4() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT5(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT5() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT6(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT6() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RAWINTTCSTAT7(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RAWINTTCSTAT7() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetRAWINTTCSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RAWINTTCSTAT.Reg, volatile.LoadUint32(&o.RAWINTTCSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetRAWINTTCSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RAWINTTCSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.RAWINTERRSTAT: DMA Raw Error Interrupt Status Register
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT0(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT0() uint32 {
	return volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x1
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT1(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT1() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT2(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT2() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT3(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT3() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT4(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT4() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT5(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT5() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT6(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT6() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RAWINTERRSTAT7(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RAWINTERRSTAT7() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetRAWINTERRSTAT_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RAWINTERRSTAT.Reg, volatile.LoadUint32(&o.RAWINTERRSTAT.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetRAWINTERRSTAT_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RAWINTERRSTAT.Reg) & 0xffffff00) >> 8
}

// GPDMA.ENBLDCHNS: DMA Enabled Channel Register
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS0(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS0() uint32 {
	return volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x1
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS1(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS1() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS2(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS2() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS3(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS3() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS4(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS4() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS5(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS5() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS6(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS6() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetENBLDCHNS_ENABLEDCHANNELS7(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetENBLDCHNS_ENABLEDCHANNELS7() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetENBLDCHNS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.ENBLDCHNS.Reg, volatile.LoadUint32(&o.ENBLDCHNS.Reg)&^(0xffffff00)|value<<8)
}
func (o *GPDMA_Type) GetENBLDCHNS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.ENBLDCHNS.Reg) & 0xffffff00) >> 8
}

// GPDMA.SOFTBREQ: DMA Software Burst Request Register
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ0(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ0() uint32 {
	return volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x1
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ1(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ1() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ2(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ2() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ3(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ3() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ4(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ4() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ5(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ5() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ6(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ6() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ7(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ7() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ8(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ8() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ9(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ9() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ10(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ10() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ11(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ11() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ12(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ12() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ13(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ13() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ14(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ14() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSOFTBREQ_SOFTBREQ15(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSOFTBREQ_SOFTBREQ15() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSOFTBREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SOFTBREQ.Reg, volatile.LoadUint32(&o.SOFTBREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSOFTBREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SOFTBREQ.Reg) & 0xffff0000) >> 16
}

// GPDMA.SOFTSREQ: DMA Software Single Request Register
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ0(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ0() uint32 {
	return volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x1
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ1(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ2(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ3(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ4(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ5(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ6(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ6() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ7(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ7() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ8(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ8() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ9(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ9() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ10(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ10() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ11(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ11() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ12(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ12() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ13(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ13() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ14(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ14() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSOFTSREQ_SOFTSREQ15(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSOFTSREQ_SOFTSREQ15() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSOFTSREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SOFTSREQ.Reg, volatile.LoadUint32(&o.SOFTSREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSOFTSREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SOFTSREQ.Reg) & 0xffff0000) >> 16
}

// GPDMA.SOFTLBREQ: DMA Software Last Burst Request Register
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ0(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ0() uint32 {
	return volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x1
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ1(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ1() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ2(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ2() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ3(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ3() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ4(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ4() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ5(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ5() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ6(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ6() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ7(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ7() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ8(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ8() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ9(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ9() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ10(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ10() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ11(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ11() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ12(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ12() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ13(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ13() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ14(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ14() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSOFTLBREQ_SOFTLBREQ15(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSOFTLBREQ_SOFTLBREQ15() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSOFTLBREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SOFTLBREQ.Reg, volatile.LoadUint32(&o.SOFTLBREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSOFTLBREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SOFTLBREQ.Reg) & 0xffff0000) >> 16
}

// GPDMA.SOFTLSREQ: DMA Software Last Single Request Register
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ0(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ0() uint32 {
	return volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x1
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ1(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ1() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ2(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ2() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ3(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ3() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ4(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ4() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ5(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ5() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ6(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ6() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ7(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ7() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ8(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ8() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ9(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ9() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ10(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ10() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ11(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ11() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ12(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ12() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ13(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ13() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ14(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ14() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSOFTLSREQ_SOFTLSREQ15(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSOFTLSREQ_SOFTLSREQ15() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSOFTLSREQ_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SOFTLSREQ.Reg, volatile.LoadUint32(&o.SOFTLSREQ.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSOFTLSREQ_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SOFTLSREQ.Reg) & 0xffff0000) >> 16
}

// GPDMA.CONFIG: DMA Configuration Register
func (o *GPDMA_Type) SetCONFIG_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG_M(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG_M() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetCONFIG_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetCONFIG_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xfffffffc) >> 2
}

// GPDMA.SYNC: DMA Synchronization Register
func (o *GPDMA_Type) SetSYNC_DMACSYNC0(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC0() uint32 {
	return volatile.LoadUint32(&o.SYNC.Reg) & 0x1
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC1(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x2)|value<<1)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC1() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x2) >> 1
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC2(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x4)|value<<2)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC2() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x4) >> 2
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC3(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x8)|value<<3)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC3() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x8) >> 3
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC4(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x10)|value<<4)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC4() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x10) >> 4
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC5(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x20)|value<<5)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC5() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x20) >> 5
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC6(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x40)|value<<6)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC6() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x40) >> 6
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC7(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x80)|value<<7)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC7() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x80) >> 7
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC8(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x100)|value<<8)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC8() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x100) >> 8
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC9(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x200)|value<<9)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC9() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x200) >> 9
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC10(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x400)|value<<10)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC10() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x400) >> 10
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC11(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x800)|value<<11)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC11() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x800) >> 11
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC12(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x1000)|value<<12)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC12() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x1000) >> 12
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC13(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x2000)|value<<13)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC13() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x2000) >> 13
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC14(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC14() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetSYNC_DMACSYNC15(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetSYNC_DMACSYNC15() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetSYNC_RESERVED(value uint32) {
	volatile.StoreUint32(&o.SYNC.Reg, volatile.LoadUint32(&o.SYNC.Reg)&^(0xffff0000)|value<<16)
}
func (o *GPDMA_Type) GetSYNC_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.SYNC.Reg) & 0xffff0000) >> 16
}

// GPDMA.SRCADDR0: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR0(value uint32) {
	volatile.StoreUint32(&o.SRCADDR0.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR0() uint32 {
	return volatile.LoadUint32(&o.SRCADDR0.Reg)
}

// GPDMA.DESTADDR0: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR0(value uint32) {
	volatile.StoreUint32(&o.DESTADDR0.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR0() uint32 {
	return volatile.LoadUint32(&o.DESTADDR0.Reg)
}

// GPDMA.LLI0: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI0.Reg, volatile.LoadUint32(&o.LLI0.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI0_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI0.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI0_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI0.Reg, volatile.LoadUint32(&o.LLI0.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI0_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI0.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL0: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL0_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL0_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL0.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL0_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL0_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL0_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL0_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL0_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL0_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL0_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL0_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL0_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL0_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL0_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL0_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL0_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL0_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL0_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL0_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL0_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL0_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL0_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL0.Reg, volatile.LoadUint32(&o.CONTROL0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL0_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL0.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG0: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG0_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG0_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG0.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG0_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG0_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG0_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG0_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG0_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG0_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG0_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG0_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG0_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG0_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG0_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG0_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG0_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG0_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG0_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG0_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG0_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG0_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR1: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR1(value uint32) {
	volatile.StoreUint32(&o.SRCADDR1.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR1() uint32 {
	return volatile.LoadUint32(&o.SRCADDR1.Reg)
}

// GPDMA.DESTADDR1: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR1(value uint32) {
	volatile.StoreUint32(&o.DESTADDR1.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR1() uint32 {
	return volatile.LoadUint32(&o.DESTADDR1.Reg)
}

// GPDMA.LLI1: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI1.Reg, volatile.LoadUint32(&o.LLI1.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI1_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI1.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI1_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI1.Reg, volatile.LoadUint32(&o.LLI1.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI1_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI1.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL1: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL1_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL1_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL1.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL1_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL1_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL1_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL1_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL1_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL1_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL1_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL1_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL1_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL1_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL1_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL1_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL1_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL1_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL1_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL1_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL1_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL1_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL1_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL1.Reg, volatile.LoadUint32(&o.CONTROL1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL1_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL1.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG1: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG1_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG1_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG1.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG1_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG1_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG1_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG1_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG1_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG1_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG1_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG1_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG1_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG1_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG1_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG1_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG1_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG1_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG1_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG1_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG1_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG1_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR2: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR2(value uint32) {
	volatile.StoreUint32(&o.SRCADDR2.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR2() uint32 {
	return volatile.LoadUint32(&o.SRCADDR2.Reg)
}

// GPDMA.DESTADDR2: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR2(value uint32) {
	volatile.StoreUint32(&o.DESTADDR2.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR2() uint32 {
	return volatile.LoadUint32(&o.DESTADDR2.Reg)
}

// GPDMA.LLI2: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI2.Reg, volatile.LoadUint32(&o.LLI2.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI2_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI2.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI2_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI2.Reg, volatile.LoadUint32(&o.LLI2.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI2_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI2.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL2: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL2_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL2_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL2.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL2_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL2_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL2_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL2_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL2_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL2_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL2_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL2_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL2_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL2_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL2_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL2_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL2_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL2_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL2_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL2_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL2_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL2_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL2_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL2.Reg, volatile.LoadUint32(&o.CONTROL2.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL2_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL2.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG2: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG2_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG2_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG2.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG2_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG2_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG2_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG2_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG2_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG2_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG2_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG2_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG2_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG2_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG2_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG2_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG2_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG2_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG2_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG2_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG2_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG2.Reg, volatile.LoadUint32(&o.CONFIG2.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG2_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG2.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR3: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR3(value uint32) {
	volatile.StoreUint32(&o.SRCADDR3.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR3() uint32 {
	return volatile.LoadUint32(&o.SRCADDR3.Reg)
}

// GPDMA.DESTADDR3: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR3(value uint32) {
	volatile.StoreUint32(&o.DESTADDR3.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR3() uint32 {
	return volatile.LoadUint32(&o.DESTADDR3.Reg)
}

// GPDMA.LLI3: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI3.Reg, volatile.LoadUint32(&o.LLI3.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI3_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI3.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI3_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI3.Reg, volatile.LoadUint32(&o.LLI3.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI3_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI3.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL3: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL3_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL3_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL3.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL3_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL3_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL3_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL3_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL3_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL3_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL3_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL3_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL3_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL3_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL3_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL3_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL3_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL3_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL3_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL3_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL3_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL3_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL3_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL3.Reg, volatile.LoadUint32(&o.CONTROL3.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL3_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL3.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG3: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG3_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG3_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG3.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG3_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG3_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG3_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG3_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG3_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG3_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG3_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG3_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG3_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG3_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG3_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG3_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG3_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG3_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG3_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG3_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG3_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG3.Reg, volatile.LoadUint32(&o.CONFIG3.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG3_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG3.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR4: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR4(value uint32) {
	volatile.StoreUint32(&o.SRCADDR4.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR4() uint32 {
	return volatile.LoadUint32(&o.SRCADDR4.Reg)
}

// GPDMA.DESTADDR4: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR4(value uint32) {
	volatile.StoreUint32(&o.DESTADDR4.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR4() uint32 {
	return volatile.LoadUint32(&o.DESTADDR4.Reg)
}

// GPDMA.LLI4: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI4.Reg, volatile.LoadUint32(&o.LLI4.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI4_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI4.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI4_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI4.Reg, volatile.LoadUint32(&o.LLI4.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI4_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI4.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL4: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL4_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL4_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL4.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL4_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL4_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL4_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL4_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL4_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL4_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL4_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL4_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL4_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL4_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL4_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL4_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL4_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL4_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL4_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL4_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL4_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL4_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL4_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL4.Reg, volatile.LoadUint32(&o.CONTROL4.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL4_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL4.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG4: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG4_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG4_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG4.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG4_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG4_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG4_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG4_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG4_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG4_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG4_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG4_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG4_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG4_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG4_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG4_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG4_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG4_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG4_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG4_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG4_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG4.Reg, volatile.LoadUint32(&o.CONFIG4.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG4_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG4.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR5: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR5(value uint32) {
	volatile.StoreUint32(&o.SRCADDR5.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR5() uint32 {
	return volatile.LoadUint32(&o.SRCADDR5.Reg)
}

// GPDMA.DESTADDR5: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR5(value uint32) {
	volatile.StoreUint32(&o.DESTADDR5.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR5() uint32 {
	return volatile.LoadUint32(&o.DESTADDR5.Reg)
}

// GPDMA.LLI5: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI5.Reg, volatile.LoadUint32(&o.LLI5.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI5_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI5.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI5_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI5.Reg, volatile.LoadUint32(&o.LLI5.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI5_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI5.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL5: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL5_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL5_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL5.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL5_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL5_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL5_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL5_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL5_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL5_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL5_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL5_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL5_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL5_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL5_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL5_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL5_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL5_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL5_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL5_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL5_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL5_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL5_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL5.Reg, volatile.LoadUint32(&o.CONTROL5.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL5_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL5.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG5: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG5_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG5_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG5.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG5_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG5_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG5_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG5_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG5_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG5_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG5_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG5_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG5_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG5_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG5_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG5_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG5_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG5_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG5_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG5_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG5_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG5.Reg, volatile.LoadUint32(&o.CONFIG5.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG5_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG5.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR6: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR6(value uint32) {
	volatile.StoreUint32(&o.SRCADDR6.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR6() uint32 {
	return volatile.LoadUint32(&o.SRCADDR6.Reg)
}

// GPDMA.DESTADDR6: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR6(value uint32) {
	volatile.StoreUint32(&o.DESTADDR6.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR6() uint32 {
	return volatile.LoadUint32(&o.DESTADDR6.Reg)
}

// GPDMA.LLI6: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI6.Reg, volatile.LoadUint32(&o.LLI6.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI6_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI6.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI6_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI6.Reg, volatile.LoadUint32(&o.LLI6.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI6_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI6.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL6: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL6_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL6_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL6.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL6_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL6_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL6_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL6_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL6_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL6_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL6_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL6_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL6_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL6_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL6_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL6_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL6_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL6_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL6_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL6_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL6_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL6_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL6_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL6.Reg, volatile.LoadUint32(&o.CONTROL6.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL6_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL6.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG6: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG6_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG6_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG6.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG6_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG6_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG6_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG6_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG6_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG6_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG6_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG6_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG6_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG6_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG6_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG6_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG6_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG6_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG6_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG6_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG6_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG6.Reg, volatile.LoadUint32(&o.CONFIG6.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG6_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG6.Reg) & 0xfff80000) >> 19
}

// GPDMA.SRCADDR7: DMA Channel 0 Source Address Register
func (o *GPDMA_Type) SetSRCADDR7(value uint32) {
	volatile.StoreUint32(&o.SRCADDR7.Reg, value)
}
func (o *GPDMA_Type) GetSRCADDR7() uint32 {
	return volatile.LoadUint32(&o.SRCADDR7.Reg)
}

// GPDMA.DESTADDR7: DMA Channel 0 Destination Address Register
func (o *GPDMA_Type) SetDESTADDR7(value uint32) {
	volatile.StoreUint32(&o.DESTADDR7.Reg, value)
}
func (o *GPDMA_Type) GetDESTADDR7() uint32 {
	return volatile.LoadUint32(&o.DESTADDR7.Reg)
}

// GPDMA.LLI7: DMA Channel 0 Linked List Item Register
func (o *GPDMA_Type) SetLLI7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.LLI7.Reg, volatile.LoadUint32(&o.LLI7.Reg)&^(0x3)|value)
}
func (o *GPDMA_Type) GetLLI7_RESERVED() uint32 {
	return volatile.LoadUint32(&o.LLI7.Reg) & 0x3
}
func (o *GPDMA_Type) SetLLI7_LLI(value uint32) {
	volatile.StoreUint32(&o.LLI7.Reg, volatile.LoadUint32(&o.LLI7.Reg)&^(0xfffffffc)|value<<2)
}
func (o *GPDMA_Type) GetLLI7_LLI() uint32 {
	return (volatile.LoadUint32(&o.LLI7.Reg) & 0xfffffffc) >> 2
}

// GPDMA.CONTROL7: DMA Channel 0 Control Register
func (o *GPDMA_Type) SetCONTROL7_TRANSFERSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0xfff)|value)
}
func (o *GPDMA_Type) GetCONTROL7_TRANSFERSIZE() uint32 {
	return volatile.LoadUint32(&o.CONTROL7.Reg) & 0xfff
}
func (o *GPDMA_Type) SetCONTROL7_SBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x7000)|value<<12)
}
func (o *GPDMA_Type) GetCONTROL7_SBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x7000) >> 12
}
func (o *GPDMA_Type) SetCONTROL7_DBSIZE(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x38000)|value<<15)
}
func (o *GPDMA_Type) GetCONTROL7_DBSIZE() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x38000) >> 15
}
func (o *GPDMA_Type) SetCONTROL7_SWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x1c0000)|value<<18)
}
func (o *GPDMA_Type) GetCONTROL7_SWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x1c0000) >> 18
}
func (o *GPDMA_Type) SetCONTROL7_DWIDTH(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0xe00000)|value<<21)
}
func (o *GPDMA_Type) GetCONTROL7_DWIDTH() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0xe00000) >> 21
}
func (o *GPDMA_Type) SetCONTROL7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x3000000)|value<<24)
}
func (o *GPDMA_Type) GetCONTROL7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x3000000) >> 24
}
func (o *GPDMA_Type) SetCONTROL7_SI(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x4000000)|value<<26)
}
func (o *GPDMA_Type) GetCONTROL7_SI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x4000000) >> 26
}
func (o *GPDMA_Type) SetCONTROL7_DI(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x8000000)|value<<27)
}
func (o *GPDMA_Type) GetCONTROL7_DI() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x8000000) >> 27
}
func (o *GPDMA_Type) SetCONTROL7_PROT1(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x10000000)|value<<28)
}
func (o *GPDMA_Type) GetCONTROL7_PROT1() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x10000000) >> 28
}
func (o *GPDMA_Type) SetCONTROL7_PROT2(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x20000000)|value<<29)
}
func (o *GPDMA_Type) GetCONTROL7_PROT2() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x20000000) >> 29
}
func (o *GPDMA_Type) SetCONTROL7_PROT3(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x40000000)|value<<30)
}
func (o *GPDMA_Type) GetCONTROL7_PROT3() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x40000000) >> 30
}
func (o *GPDMA_Type) SetCONTROL7_I(value uint32) {
	volatile.StoreUint32(&o.CONTROL7.Reg, volatile.LoadUint32(&o.CONTROL7.Reg)&^(0x80000000)|value<<31)
}
func (o *GPDMA_Type) GetCONTROL7_I() uint32 {
	return (volatile.LoadUint32(&o.CONTROL7.Reg) & 0x80000000) >> 31
}

// GPDMA.CONFIG7: DMA Channel 0 Configuration Register[1]
func (o *GPDMA_Type) SetCONFIG7_E(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x1)|value)
}
func (o *GPDMA_Type) GetCONFIG7_E() uint32 {
	return volatile.LoadUint32(&o.CONFIG7.Reg) & 0x1
}
func (o *GPDMA_Type) SetCONFIG7_SRCPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x3e)|value<<1)
}
func (o *GPDMA_Type) GetCONFIG7_SRCPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x3e) >> 1
}
func (o *GPDMA_Type) SetCONFIG7_DESTPERIPHERAL(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x7c0)|value<<6)
}
func (o *GPDMA_Type) GetCONFIG7_DESTPERIPHERAL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x7c0) >> 6
}
func (o *GPDMA_Type) SetCONFIG7_TRANSFERTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x3800)|value<<11)
}
func (o *GPDMA_Type) GetCONFIG7_TRANSFERTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x3800) >> 11
}
func (o *GPDMA_Type) SetCONFIG7_IE(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x4000)|value<<14)
}
func (o *GPDMA_Type) GetCONFIG7_IE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x4000) >> 14
}
func (o *GPDMA_Type) SetCONFIG7_ITC(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x8000)|value<<15)
}
func (o *GPDMA_Type) GetCONFIG7_ITC() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x8000) >> 15
}
func (o *GPDMA_Type) SetCONFIG7_L(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x10000)|value<<16)
}
func (o *GPDMA_Type) GetCONFIG7_L() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x10000) >> 16
}
func (o *GPDMA_Type) SetCONFIG7_A(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x20000)|value<<17)
}
func (o *GPDMA_Type) GetCONFIG7_A() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x20000) >> 17
}
func (o *GPDMA_Type) SetCONFIG7_H(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0x40000)|value<<18)
}
func (o *GPDMA_Type) GetCONFIG7_H() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0x40000) >> 18
}
func (o *GPDMA_Type) SetCONFIG7_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CONFIG7.Reg, volatile.LoadUint32(&o.CONFIG7.Reg)&^(0xfff80000)|value<<19)
}
func (o *GPDMA_Type) GetCONFIG7_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CONFIG7.Reg) & 0xfff80000) >> 19
}

// USB device/host/OTG controller
type USB_Type struct {
	_            [220]byte
	RXPLEN       volatile.Register32 // 0xDC
	_            [32]byte
	INTST        volatile.Register32 // 0x100
	INTEN        volatile.Register32 // 0x104
	INTSET       volatile.Register32 // 0x108
	INTCLR       volatile.Register32 // 0x10C
	STCTRL       volatile.Register32 // 0x110
	TMR          volatile.Register32 // 0x114
	_            [232]byte
	DEVINTST     volatile.Register32 // 0x200
	DEVINTEN     volatile.Register32 // 0x204
	DEVINTCLR    volatile.Register32 // 0x208
	DEVINTSET    volatile.Register32 // 0x20C
	CMDCODE      volatile.Register32 // 0x210
	CMDDATA      volatile.Register32 // 0x214
	RXDATA       volatile.Register32 // 0x218
	TXDATA       volatile.Register32 // 0x21C
	_            [4]byte
	TXPLEN       volatile.Register32 // 0x224
	CTRL         volatile.Register32 // 0x228
	DEVINTPRI    volatile.Register32 // 0x22C
	EPINTST      volatile.Register32 // 0x230
	EPINTEN      volatile.Register32 // 0x234
	EPINTCLR     volatile.Register32 // 0x238
	EPINTSET     volatile.Register32 // 0x23C
	EPINTPRI     volatile.Register32 // 0x240
	REEP         volatile.Register32 // 0x244
	EPIND        volatile.Register32 // 0x248
	MAXPSIZE     volatile.Register32 // 0x24C
	DMARST       volatile.Register32 // 0x250
	DMARCLR      volatile.Register32 // 0x254
	DMARSET      volatile.Register32 // 0x258
	_            [36]byte
	UDCAH        volatile.Register32 // 0x280
	EPDMAST      volatile.Register32 // 0x284
	EPDMAEN      volatile.Register32 // 0x288
	EPDMADIS     volatile.Register32 // 0x28C
	DMAINTST     volatile.Register32 // 0x290
	DMAINTEN     volatile.Register32 // 0x294
	_            [8]byte
	EOTINTST     volatile.Register32 // 0x2A0
	EOTINTCLR    volatile.Register32 // 0x2A4
	EOTINTSET    volatile.Register32 // 0x2A8
	NDDRINTST    volatile.Register32 // 0x2AC
	NDDRINTCLR   volatile.Register32 // 0x2B0
	NDDRINTSET   volatile.Register32 // 0x2B4
	SYSERRINTST  volatile.Register32 // 0x2B8
	SYSERRINTCLR volatile.Register32 // 0x2BC
	SYSERRINTSET volatile.Register32 // 0x2C0
	_            [60]byte
	I2C_RX       volatile.Register32 // 0x300
	I2C_STS      volatile.Register32 // 0x304
	I2C_CTL      volatile.Register32 // 0x308
	I2C_CLKHI    volatile.Register32 // 0x30C
	I2C_CLKLO    volatile.Register32 // 0x310
	_            [3296]byte
	USBCLKCTRL   volatile.Register32 // 0xFF4
	USBCLKST     volatile.Register32 // 0xFF8
}

// USB.RXPLEN: USB Receive Packet Length
func (o *USB_Type) SetRXPLEN_PKT_LNGTH(value uint32) {
	volatile.StoreUint32(&o.RXPLEN.Reg, volatile.LoadUint32(&o.RXPLEN.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetRXPLEN_PKT_LNGTH() uint32 {
	return volatile.LoadUint32(&o.RXPLEN.Reg) & 0x3ff
}
func (o *USB_Type) SetRXPLEN_DV(value uint32) {
	volatile.StoreUint32(&o.RXPLEN.Reg, volatile.LoadUint32(&o.RXPLEN.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetRXPLEN_DV() uint32 {
	return (volatile.LoadUint32(&o.RXPLEN.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetRXPLEN_PKT_RDY(value uint32) {
	volatile.StoreUint32(&o.RXPLEN.Reg, volatile.LoadUint32(&o.RXPLEN.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetRXPLEN_PKT_RDY() uint32 {
	return (volatile.LoadUint32(&o.RXPLEN.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetRXPLEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.RXPLEN.Reg, volatile.LoadUint32(&o.RXPLEN.Reg)&^(0xfffff000)|value<<12)
}
func (o *USB_Type) GetRXPLEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.RXPLEN.Reg) & 0xfffff000) >> 12
}

// USB.INTST: OTG Interrupt Status
func (o *USB_Type) SetINTST_TMR(value uint32) {
	volatile.StoreUint32(&o.INTST.Reg, volatile.LoadUint32(&o.INTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetINTST_TMR() uint32 {
	return volatile.LoadUint32(&o.INTST.Reg) & 0x1
}
func (o *USB_Type) SetINTST_REMOVE_PU(value uint32) {
	volatile.StoreUint32(&o.INTST.Reg, volatile.LoadUint32(&o.INTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetINTST_REMOVE_PU() uint32 {
	return (volatile.LoadUint32(&o.INTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetINTST_HNP_FAILURE(value uint32) {
	volatile.StoreUint32(&o.INTST.Reg, volatile.LoadUint32(&o.INTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetINTST_HNP_FAILURE() uint32 {
	return (volatile.LoadUint32(&o.INTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetINTST_HNP_SUCCESS(value uint32) {
	volatile.StoreUint32(&o.INTST.Reg, volatile.LoadUint32(&o.INTST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetINTST_HNP_SUCCESS() uint32 {
	return (volatile.LoadUint32(&o.INTST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetINTST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTST.Reg, volatile.LoadUint32(&o.INTST.Reg)&^(0xfffffff0)|value<<4)
}
func (o *USB_Type) GetINTST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTST.Reg) & 0xfffffff0) >> 4
}

// USB.INTEN: OTG Interrupt Enable
func (o *USB_Type) SetINTEN_TMR_EN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetINTEN_TMR_EN() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *USB_Type) SetINTEN_REMOVE_PU_EN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetINTEN_REMOVE_PU_EN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetINTEN_HNP_FAILURE_EN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetINTEN_HNP_FAILURE_EN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetINTEN_HNP_SUCCES_EN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetINTEN_HNP_SUCCES_EN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0xfffffff0)|value<<4)
}
func (o *USB_Type) GetINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0xfffffff0) >> 4
}

// USB.INTSET: OTG Interrupt Set
func (o *USB_Type) SetINTSET_TMR_SET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetINTSET_TMR_SET() uint32 {
	return volatile.LoadUint32(&o.INTSET.Reg) & 0x1
}
func (o *USB_Type) SetINTSET_REMOVE_PU_SET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetINTSET_REMOVE_PU_SET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetINTSET_HNP_FAILURE_SET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetINTSET_HNP_FAILURE_SET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetINTSET_HNP_SUCCES_SET(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetINTSET_HNP_SUCCES_SET() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetINTSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTSET.Reg, volatile.LoadUint32(&o.INTSET.Reg)&^(0xfffffff0)|value<<4)
}
func (o *USB_Type) GetINTSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTSET.Reg) & 0xfffffff0) >> 4
}

// USB.INTCLR: OTG Interrupt Clear
func (o *USB_Type) SetINTCLR_TMR_CLR(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetINTCLR_TMR_CLR() uint32 {
	return volatile.LoadUint32(&o.INTCLR.Reg) & 0x1
}
func (o *USB_Type) SetINTCLR_REMOVE_PU_CLR(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetINTCLR_REMOVE_PU_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetINTCLR_HNP_FAILURE_CLR(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetINTCLR_HNP_FAILURE_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetINTCLR_HNP_SUCCES_CLR(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetINTCLR_HNP_SUCCES_CLR() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetINTCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.INTCLR.Reg, volatile.LoadUint32(&o.INTCLR.Reg)&^(0xfffffff0)|value<<4)
}
func (o *USB_Type) GetINTCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.INTCLR.Reg) & 0xfffffff0) >> 4
}

// USB.STCTRL: OTG Status and Control and USB port select
func (o *USB_Type) SetSTCTRL_PORT_FUNC(value uint32) {
	volatile.StoreUint32(&o.STCTRL.Reg, volatile.LoadUint32(&o.STCTRL.Reg)&^(0x3)|value)
}
func (o *USB_Type) GetSTCTRL_PORT_FUNC() uint32 {
	return volatile.LoadUint32(&o.STCTRL.Reg) & 0x3
}
func (o *USB_Type) SetSTCTRL_TMR_SCALE(value uint32) {
	volatile.StoreUint32(&o.STCTRL.Reg, volatile.LoadUint32(&o.STCTRL.Reg)&^(0xc)|value<<2)
}
func (o *USB_Type) GetSTCTRL_TMR_SCALE() uint32 {
	return (volatile.LoadUint32(&o.STCTRL.Reg) & 0xc) >> 2
}
func (o *USB_Type) SetSTCTRL_TMR_MODE(value uint32) {
	volatile.StoreUint32(&o.STCTRL.Reg, volatile.LoadUint32(&o.STCTRL.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetSTCTRL_TMR_MODE() uint32 {
	return (volatile.LoadUint32(&o.STCTRL.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetSTCTRL_TMR_EN(value uint32) {
	volatile.StoreUint32(&o.STCTRL.Reg, volatile.LoadUint32(&o.STCTRL.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetSTCTRL_TMR_EN() uint32 {
	return (volatile.LoadUint32(&o.STCTRL.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetSTCTRL_TMR_RST(value uint32) {
	volatile.StoreUint32(&o.STCTRL.Reg, volatile.LoadUint32(&o.STCTRL.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetSTCTRL_TMR_RST() uint32 {
	return (volatile.LoadUint32(&o.STCTRL.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetSTCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STCTRL.Reg, volatile.LoadUint32(&o.STCTRL.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetSTCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STCTRL.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetSTCTRL_B_HNP_TRACK(value uint32) {
	volatile.StoreUint32(&o.STCTRL.Reg, volatile.LoadUint32(&o.STCTRL.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetSTCTRL_B_HNP_TRACK() uint32 {
	return (volatile.LoadUint32(&o.STCTRL.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetSTCTRL_A_HNP_TRACK(value uint32) {
	volatile.StoreUint32(&o.STCTRL.Reg, volatile.LoadUint32(&o.STCTRL.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetSTCTRL_A_HNP_TRACK() uint32 {
	return (volatile.LoadUint32(&o.STCTRL.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetSTCTRL_PU_REMOVED(value uint32) {
	volatile.StoreUint32(&o.STCTRL.Reg, volatile.LoadUint32(&o.STCTRL.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetSTCTRL_PU_REMOVED() uint32 {
	return (volatile.LoadUint32(&o.STCTRL.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetSTCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.STCTRL.Reg, volatile.LoadUint32(&o.STCTRL.Reg)&^(0xf800)|value<<11)
}
func (o *USB_Type) GetSTCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.STCTRL.Reg) & 0xf800) >> 11
}
func (o *USB_Type) SetSTCTRL_TMR_CNT(value uint32) {
	volatile.StoreUint32(&o.STCTRL.Reg, volatile.LoadUint32(&o.STCTRL.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_Type) GetSTCTRL_TMR_CNT() uint32 {
	return (volatile.LoadUint32(&o.STCTRL.Reg) & 0xffff0000) >> 16
}

// USB.TMR: OTG Timer
func (o *USB_Type) SetTMR_TIMEOUT_CNT(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0xffff)|value)
}
func (o *USB_Type) GetTMR_TIMEOUT_CNT() uint32 {
	return volatile.LoadUint32(&o.TMR.Reg) & 0xffff
}
func (o *USB_Type) SetTMR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TMR.Reg, volatile.LoadUint32(&o.TMR.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_Type) GetTMR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TMR.Reg) & 0xffff0000) >> 16
}

// USB.DEVINTST: USB Device Interrupt Status
func (o *USB_Type) SetDEVINTST_FRAME(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDEVINTST_FRAME() uint32 {
	return volatile.LoadUint32(&o.DEVINTST.Reg) & 0x1
}
func (o *USB_Type) SetDEVINTST_EP_FAST(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDEVINTST_EP_FAST() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDEVINTST_EP_SLOW(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDEVINTST_EP_SLOW() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDEVINTST_DEV_STAT(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDEVINTST_DEV_STAT() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDEVINTST_CCEMPTY(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDEVINTST_CCEMPTY() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDEVINTST_CDFULL(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDEVINTST_CDFULL() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDEVINTST_RxENDPKT(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDEVINTST_RxENDPKT() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDEVINTST_TxENDPKT(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDEVINTST_TxENDPKT() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDEVINTST_EP_RLZED(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDEVINTST_EP_RLZED() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDEVINTST_ERR_INT(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDEVINTST_ERR_INT() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDEVINTST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVINTST.Reg, volatile.LoadUint32(&o.DEVINTST.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetDEVINTST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVINTST.Reg) & 0xfffffc00) >> 10
}

// USB.DEVINTEN: USB Device Interrupt Enable
func (o *USB_Type) SetDEVINTEN_FRAMEEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDEVINTEN_FRAMEEN() uint32 {
	return volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x1
}
func (o *USB_Type) SetDEVINTEN_EP_FASTEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDEVINTEN_EP_FASTEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDEVINTEN_EP_SLOWEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDEVINTEN_EP_SLOWEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDEVINTEN_DEV_STATEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDEVINTEN_DEV_STATEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDEVINTEN_CCEMPTYEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDEVINTEN_CCEMPTYEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDEVINTEN_CDFULLEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDEVINTEN_CDFULLEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDEVINTEN_RxENDPKTEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDEVINTEN_RxENDPKTEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDEVINTEN_TxENDPKTEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDEVINTEN_TxENDPKTEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDEVINTEN_EP_RLZEDEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDEVINTEN_EP_RLZEDEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDEVINTEN_ERR_INTEN(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDEVINTEN_ERR_INTEN() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDEVINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVINTEN.Reg, volatile.LoadUint32(&o.DEVINTEN.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetDEVINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVINTEN.Reg) & 0xfffffc00) >> 10
}

// USB.DEVINTCLR: USB Device Interrupt Clear
func (o *USB_Type) SetDEVINTCLR_FRAMECLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDEVINTCLR_FRAMECLR() uint32 {
	return volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x1
}
func (o *USB_Type) SetDEVINTCLR_EP_FASTCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDEVINTCLR_EP_FASTCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDEVINTCLR_EP_SLOWCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDEVINTCLR_EP_SLOWCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDEVINTCLR_DEV_STATCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDEVINTCLR_DEV_STATCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDEVINTCLR_CCEMPTYCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDEVINTCLR_CCEMPTYCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDEVINTCLR_CDFULLCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDEVINTCLR_CDFULLCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDEVINTCLR_RxENDPKTCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDEVINTCLR_RxENDPKTCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDEVINTCLR_TxENDPKTCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDEVINTCLR_TxENDPKTCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDEVINTCLR_EP_RLZEDCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDEVINTCLR_EP_RLZEDCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDEVINTCLR_ERR_INTCLR(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDEVINTCLR_ERR_INTCLR() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDEVINTCLR_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVINTCLR.Reg, volatile.LoadUint32(&o.DEVINTCLR.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetDEVINTCLR_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVINTCLR.Reg) & 0xfffffc00) >> 10
}

// USB.DEVINTSET: USB Device Interrupt Set
func (o *USB_Type) SetDEVINTSET_FRAMESET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDEVINTSET_FRAMESET() uint32 {
	return volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x1
}
func (o *USB_Type) SetDEVINTSET_EP_FASTSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDEVINTSET_EP_FASTSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDEVINTSET_EP_SLOWSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDEVINTSET_EP_SLOWSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDEVINTSET_DEV_STATSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDEVINTSET_DEV_STATSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDEVINTSET_CCEMPTYSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDEVINTSET_CCEMPTYSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDEVINTSET_CDFULLSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDEVINTSET_CDFULLSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDEVINTSET_RxENDPKTSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDEVINTSET_RxENDPKTSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDEVINTSET_TxENDPKTSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDEVINTSET_TxENDPKTSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDEVINTSET_EP_RLZEDSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDEVINTSET_EP_RLZEDSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDEVINTSET_ERR_INTSET(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDEVINTSET_ERR_INTSET() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDEVINTSET_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVINTSET.Reg, volatile.LoadUint32(&o.DEVINTSET.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetDEVINTSET_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVINTSET.Reg) & 0xfffffc00) >> 10
}

// USB.CMDCODE: USB Command Code
func (o *USB_Type) SetCMDCODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMDCODE.Reg, volatile.LoadUint32(&o.CMDCODE.Reg)&^(0xff)|value)
}
func (o *USB_Type) GetCMDCODE_RESERVED() uint32 {
	return volatile.LoadUint32(&o.CMDCODE.Reg) & 0xff
}
func (o *USB_Type) SetCMDCODE_CMD_PHASE(value uint32) {
	volatile.StoreUint32(&o.CMDCODE.Reg, volatile.LoadUint32(&o.CMDCODE.Reg)&^(0xff00)|value<<8)
}
func (o *USB_Type) GetCMDCODE_CMD_PHASE() uint32 {
	return (volatile.LoadUint32(&o.CMDCODE.Reg) & 0xff00) >> 8
}
func (o *USB_Type) SetCMDCODE_CMD_CODE_WDATA(value uint32) {
	volatile.StoreUint32(&o.CMDCODE.Reg, volatile.LoadUint32(&o.CMDCODE.Reg)&^(0xff0000)|value<<16)
}
func (o *USB_Type) GetCMDCODE_CMD_CODE_WDATA() uint32 {
	return (volatile.LoadUint32(&o.CMDCODE.Reg) & 0xff0000) >> 16
}
func (o *USB_Type) SetCMDCODE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMDCODE.Reg, volatile.LoadUint32(&o.CMDCODE.Reg)&^(0xff000000)|value<<24)
}
func (o *USB_Type) GetCMDCODE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMDCODE.Reg) & 0xff000000) >> 24
}

// USB.CMDDATA: USB Command Data
func (o *USB_Type) SetCMDDATA_CMD_RDATA(value uint32) {
	volatile.StoreUint32(&o.CMDDATA.Reg, volatile.LoadUint32(&o.CMDDATA.Reg)&^(0xff)|value)
}
func (o *USB_Type) GetCMDDATA_CMD_RDATA() uint32 {
	return volatile.LoadUint32(&o.CMDDATA.Reg) & 0xff
}
func (o *USB_Type) SetCMDDATA_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CMDDATA.Reg, volatile.LoadUint32(&o.CMDDATA.Reg)&^(0xffffff00)|value<<8)
}
func (o *USB_Type) GetCMDDATA_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CMDDATA.Reg) & 0xffffff00) >> 8
}

// USB.RXDATA: USB Receive Data
func (o *USB_Type) SetRXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDATA.Reg, value)
}
func (o *USB_Type) GetRXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDATA.Reg)
}

// USB.TXDATA: USB Transmit Data
func (o *USB_Type) SetTXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDATA.Reg, value)
}
func (o *USB_Type) GetTXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDATA.Reg)
}

// USB.TXPLEN: USB Transmit Packet Length
func (o *USB_Type) SetTXPLEN_PKT_LNGTH(value uint32) {
	volatile.StoreUint32(&o.TXPLEN.Reg, volatile.LoadUint32(&o.TXPLEN.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetTXPLEN_PKT_LNGTH() uint32 {
	return volatile.LoadUint32(&o.TXPLEN.Reg) & 0x3ff
}
func (o *USB_Type) SetTXPLEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.TXPLEN.Reg, volatile.LoadUint32(&o.TXPLEN.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetTXPLEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.TXPLEN.Reg) & 0xfffffc00) >> 10
}

// USB.CTRL: USB Control
func (o *USB_Type) SetCTRL_RD_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetCTRL_RD_EN() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *USB_Type) SetCTRL_WR_EN(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetCTRL_WR_EN() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetCTRL_LOG_ENDPOINT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x3c)|value<<2)
}
func (o *USB_Type) GetCTRL_LOG_ENDPOINT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x3c) >> 2
}
func (o *USB_Type) SetCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0xffffffc0)|value<<6)
}
func (o *USB_Type) GetCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0xffffffc0) >> 6
}

// USB.DEVINTPRI: USB Device Interrupt Priority
func (o *USB_Type) SetDEVINTPRI_FRAME(value uint32) {
	volatile.StoreUint32(&o.DEVINTPRI.Reg, volatile.LoadUint32(&o.DEVINTPRI.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDEVINTPRI_FRAME() uint32 {
	return volatile.LoadUint32(&o.DEVINTPRI.Reg) & 0x1
}
func (o *USB_Type) SetDEVINTPRI_EP_FAST(value uint32) {
	volatile.StoreUint32(&o.DEVINTPRI.Reg, volatile.LoadUint32(&o.DEVINTPRI.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDEVINTPRI_EP_FAST() uint32 {
	return (volatile.LoadUint32(&o.DEVINTPRI.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDEVINTPRI_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DEVINTPRI.Reg, volatile.LoadUint32(&o.DEVINTPRI.Reg)&^(0xfffffffc)|value<<2)
}
func (o *USB_Type) GetDEVINTPRI_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DEVINTPRI.Reg) & 0xfffffffc) >> 2
}

// USB.EPINTST: USB Endpoint Interrupt Status
func (o *USB_Type) SetEPINTST_EPST0(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPINTST_EPST0() uint32 {
	return volatile.LoadUint32(&o.EPINTST.Reg) & 0x1
}
func (o *USB_Type) SetEPINTST_EPST1(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPINTST_EPST1() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPINTST_EPST2(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPINTST_EPST2() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPINTST_EPST3(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPINTST_EPST3() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPINTST_EPST4(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPINTST_EPST4() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPINTST_EPST5(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPINTST_EPST5() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPINTST_EPST6(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPINTST_EPST6() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPINTST_EPST7(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPINTST_EPST7() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPINTST_EPST8(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPINTST_EPST8() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPINTST_EPST9(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPINTST_EPST9() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPINTST_EPST10(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPINTST_EPST10() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPINTST_EPST11(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPINTST_EPST11() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPINTST_EPST12(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPINTST_EPST12() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPINTST_EPST13(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPINTST_EPST13() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPINTST_EPST14(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPINTST_EPST14() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPINTST_EPST15(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPINTST_EPST15() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPINTST_EPST16(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPINTST_EPST16() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPINTST_EPST17(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPINTST_EPST17() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPINTST_EPST18(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPINTST_EPST18() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPINTST_EPST19(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPINTST_EPST19() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPINTST_EPST20(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPINTST_EPST20() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPINTST_EPST21(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPINTST_EPST21() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPINTST_EPST22(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPINTST_EPST22() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPINTST_EPST23(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPINTST_EPST23() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPINTST_EPST24(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPINTST_EPST24() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPINTST_EPST25(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPINTST_EPST25() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPINTST_EPST26(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPINTST_EPST26() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPINTST_EPST27(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPINTST_EPST27() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPINTST_EPST28(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPINTST_EPST28() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPINTST_EPST29(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPINTST_EPST29() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPINTST_EPST30(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPINTST_EPST30() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPINTST_EPST31(value uint32) {
	volatile.StoreUint32(&o.EPINTST.Reg, volatile.LoadUint32(&o.EPINTST.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPINTST_EPST31() uint32 {
	return (volatile.LoadUint32(&o.EPINTST.Reg) & 0x80000000) >> 31
}

// USB.EPINTEN: USB Endpoint Interrupt Enable
func (o *USB_Type) SetEPINTEN_EPEN0(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPINTEN_EPEN0() uint32 {
	return volatile.LoadUint32(&o.EPINTEN.Reg) & 0x1
}
func (o *USB_Type) SetEPINTEN_EPEN1(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPINTEN_EPEN1() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPINTEN_EPEN2(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPINTEN_EPEN2() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPINTEN_EPEN3(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPINTEN_EPEN3() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPINTEN_EPEN4(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPINTEN_EPEN4() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPINTEN_EPEN5(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPINTEN_EPEN5() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPINTEN_EPEN6(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPINTEN_EPEN6() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPINTEN_EPEN7(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPINTEN_EPEN7() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPINTEN_EPEN8(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPINTEN_EPEN8() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPINTEN_EPEN9(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPINTEN_EPEN9() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPINTEN_EPEN10(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPINTEN_EPEN10() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPINTEN_EPEN11(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPINTEN_EPEN11() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPINTEN_EPEN12(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPINTEN_EPEN12() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPINTEN_EPEN13(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPINTEN_EPEN13() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPINTEN_EPEN14(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPINTEN_EPEN14() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPINTEN_EPEN15(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPINTEN_EPEN15() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPINTEN_EPEN16(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPINTEN_EPEN16() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPINTEN_EPEN17(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPINTEN_EPEN17() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPINTEN_EPEN18(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPINTEN_EPEN18() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPINTEN_EPEN19(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPINTEN_EPEN19() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPINTEN_EPEN20(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPINTEN_EPEN20() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPINTEN_EPEN21(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPINTEN_EPEN21() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPINTEN_EPEN22(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPINTEN_EPEN22() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPINTEN_EPEN23(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPINTEN_EPEN23() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPINTEN_EPEN24(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPINTEN_EPEN24() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPINTEN_EPEN25(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPINTEN_EPEN25() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPINTEN_EPEN26(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPINTEN_EPEN26() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPINTEN_EPEN27(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPINTEN_EPEN27() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPINTEN_EPEN28(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPINTEN_EPEN28() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPINTEN_EPEN29(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPINTEN_EPEN29() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPINTEN_EPEN30(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPINTEN_EPEN30() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPINTEN_EPEN31(value uint32) {
	volatile.StoreUint32(&o.EPINTEN.Reg, volatile.LoadUint32(&o.EPINTEN.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPINTEN_EPEN31() uint32 {
	return (volatile.LoadUint32(&o.EPINTEN.Reg) & 0x80000000) >> 31
}

// USB.EPINTCLR: USB Endpoint Interrupt Clear
func (o *USB_Type) SetEPINTCLR_EPCLR0(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPINTCLR_EPCLR0() uint32 {
	return volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x1
}
func (o *USB_Type) SetEPINTCLR_EPCLR1(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPINTCLR_EPCLR1() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPINTCLR_EPCLR2(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPINTCLR_EPCLR2() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPINTCLR_EPCLR3(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPINTCLR_EPCLR3() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPINTCLR_EPCLR4(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPINTCLR_EPCLR4() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPINTCLR_EPCLR5(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPINTCLR_EPCLR5() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPINTCLR_EPCLR6(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPINTCLR_EPCLR6() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPINTCLR_EPCLR7(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPINTCLR_EPCLR7() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPINTCLR_EPCLR8(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPINTCLR_EPCLR8() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPINTCLR_EPCLR9(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPINTCLR_EPCLR9() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPINTCLR_EPCLR10(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPINTCLR_EPCLR10() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPINTCLR_EPCLR11(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPINTCLR_EPCLR11() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPINTCLR_EPCLR12(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPINTCLR_EPCLR12() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPINTCLR_EPCLR13(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPINTCLR_EPCLR13() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPINTCLR_EPCLR14(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPINTCLR_EPCLR14() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPINTCLR_EPCLR15(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPINTCLR_EPCLR15() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPINTCLR_EPCLR16(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPINTCLR_EPCLR16() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPINTCLR_EPCLR17(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPINTCLR_EPCLR17() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPINTCLR_EPCLR18(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPINTCLR_EPCLR18() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPINTCLR_EPCLR19(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPINTCLR_EPCLR19() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPINTCLR_EPCLR20(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPINTCLR_EPCLR20() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPINTCLR_EPCLR21(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPINTCLR_EPCLR21() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPINTCLR_EPCLR22(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPINTCLR_EPCLR22() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPINTCLR_EPCLR23(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPINTCLR_EPCLR23() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPINTCLR_EPCLR24(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPINTCLR_EPCLR24() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPINTCLR_EPCLR25(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPINTCLR_EPCLR25() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPINTCLR_EPCLR26(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPINTCLR_EPCLR26() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPINTCLR_EPCLR27(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPINTCLR_EPCLR27() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPINTCLR_EPCLR28(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPINTCLR_EPCLR28() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPINTCLR_EPCLR29(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPINTCLR_EPCLR29() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPINTCLR_EPCLR30(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPINTCLR_EPCLR30() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPINTCLR_EPCLR31(value uint32) {
	volatile.StoreUint32(&o.EPINTCLR.Reg, volatile.LoadUint32(&o.EPINTCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPINTCLR_EPCLR31() uint32 {
	return (volatile.LoadUint32(&o.EPINTCLR.Reg) & 0x80000000) >> 31
}

// USB.EPINTSET: USB Endpoint Interrupt Set
func (o *USB_Type) SetEPINTSET_EPSET0(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPINTSET_EPSET0() uint32 {
	return volatile.LoadUint32(&o.EPINTSET.Reg) & 0x1
}
func (o *USB_Type) SetEPINTSET_EPSET1(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPINTSET_EPSET1() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPINTSET_EPSET2(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPINTSET_EPSET2() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPINTSET_EPSET3(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPINTSET_EPSET3() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPINTSET_EPSET4(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPINTSET_EPSET4() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPINTSET_EPSET5(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPINTSET_EPSET5() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPINTSET_EPSET6(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPINTSET_EPSET6() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPINTSET_EPSET7(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPINTSET_EPSET7() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPINTSET_EPSET8(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPINTSET_EPSET8() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPINTSET_EPSET9(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPINTSET_EPSET9() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPINTSET_EPSET10(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPINTSET_EPSET10() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPINTSET_EPSET11(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPINTSET_EPSET11() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPINTSET_EPSET12(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPINTSET_EPSET12() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPINTSET_EPSET13(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPINTSET_EPSET13() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPINTSET_EPSET14(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPINTSET_EPSET14() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPINTSET_EPSET15(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPINTSET_EPSET15() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPINTSET_EPSET16(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPINTSET_EPSET16() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPINTSET_EPSET17(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPINTSET_EPSET17() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPINTSET_EPSET18(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPINTSET_EPSET18() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPINTSET_EPSET19(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPINTSET_EPSET19() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPINTSET_EPSET20(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPINTSET_EPSET20() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPINTSET_EPSET21(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPINTSET_EPSET21() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPINTSET_EPSET22(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPINTSET_EPSET22() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPINTSET_EPSET23(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPINTSET_EPSET23() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPINTSET_EPSET24(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPINTSET_EPSET24() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPINTSET_EPSET25(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPINTSET_EPSET25() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPINTSET_EPSET26(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPINTSET_EPSET26() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPINTSET_EPSET27(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPINTSET_EPSET27() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPINTSET_EPSET28(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPINTSET_EPSET28() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPINTSET_EPSET29(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPINTSET_EPSET29() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPINTSET_EPSET30(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPINTSET_EPSET30() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPINTSET_EPSET31(value uint32) {
	volatile.StoreUint32(&o.EPINTSET.Reg, volatile.LoadUint32(&o.EPINTSET.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPINTSET_EPSET31() uint32 {
	return (volatile.LoadUint32(&o.EPINTSET.Reg) & 0x80000000) >> 31
}

// USB.EPINTPRI: USB Endpoint Priority
func (o *USB_Type) SetEPINTPRI_EPPRI0(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPINTPRI_EPPRI0() uint32 {
	return volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x1
}
func (o *USB_Type) SetEPINTPRI_EPPRI1(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPINTPRI_EPPRI1() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPINTPRI_EPPRI2(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPINTPRI_EPPRI2() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPINTPRI_EPPRI3(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPINTPRI_EPPRI3() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPINTPRI_EPPRI4(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPINTPRI_EPPRI4() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPINTPRI_EPPRI5(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPINTPRI_EPPRI5() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPINTPRI_EPPRI6(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPINTPRI_EPPRI6() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPINTPRI_EPPRI7(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPINTPRI_EPPRI7() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPINTPRI_EPPRI8(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPINTPRI_EPPRI8() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPINTPRI_EPPRI9(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPINTPRI_EPPRI9() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPINTPRI_EPPRI10(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPINTPRI_EPPRI10() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPINTPRI_EPPRI11(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPINTPRI_EPPRI11() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPINTPRI_EPPRI12(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPINTPRI_EPPRI12() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPINTPRI_EPPRI13(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPINTPRI_EPPRI13() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPINTPRI_EPPRI14(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPINTPRI_EPPRI14() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPINTPRI_EPPRI15(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPINTPRI_EPPRI15() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPINTPRI_EPPRI16(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPINTPRI_EPPRI16() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPINTPRI_EPPRI17(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPINTPRI_EPPRI17() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPINTPRI_EPPRI18(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPINTPRI_EPPRI18() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPINTPRI_EPPRI19(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPINTPRI_EPPRI19() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPINTPRI_EPPRI20(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPINTPRI_EPPRI20() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPINTPRI_EPPRI21(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPINTPRI_EPPRI21() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPINTPRI_EPPRI22(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPINTPRI_EPPRI22() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPINTPRI_EPPRI23(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPINTPRI_EPPRI23() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPINTPRI_EPPRI24(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPINTPRI_EPPRI24() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPINTPRI_EPPRI25(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPINTPRI_EPPRI25() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPINTPRI_EPPRI26(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPINTPRI_EPPRI26() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPINTPRI_EPPRI27(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPINTPRI_EPPRI27() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPINTPRI_EPPRI28(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPINTPRI_EPPRI28() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPINTPRI_EPPRI29(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPINTPRI_EPPRI29() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPINTPRI_EPPRI30(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPINTPRI_EPPRI30() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPINTPRI_EPPRI31(value uint32) {
	volatile.StoreUint32(&o.EPINTPRI.Reg, volatile.LoadUint32(&o.EPINTPRI.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPINTPRI_EPPRI31() uint32 {
	return (volatile.LoadUint32(&o.EPINTPRI.Reg) & 0x80000000) >> 31
}

// USB.REEP: USB Realize Endpoint
func (o *USB_Type) SetREEP_EPR0(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetREEP_EPR0() uint32 {
	return volatile.LoadUint32(&o.REEP.Reg) & 0x1
}
func (o *USB_Type) SetREEP_EPR1(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetREEP_EPR1() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetREEP_EPR2(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetREEP_EPR2() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetREEP_EPR3(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetREEP_EPR3() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetREEP_EPR4(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetREEP_EPR4() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetREEP_EPR5(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetREEP_EPR5() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetREEP_EPR6(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetREEP_EPR6() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetREEP_EPR7(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetREEP_EPR7() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetREEP_EPR8(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetREEP_EPR8() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetREEP_EPR9(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetREEP_EPR9() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetREEP_EPR10(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetREEP_EPR10() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetREEP_EPR11(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetREEP_EPR11() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetREEP_EPR12(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetREEP_EPR12() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetREEP_EPR13(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetREEP_EPR13() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetREEP_EPR14(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetREEP_EPR14() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetREEP_EPR15(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetREEP_EPR15() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetREEP_EPR16(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetREEP_EPR16() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetREEP_EPR17(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetREEP_EPR17() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetREEP_EPR18(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetREEP_EPR18() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetREEP_EPR19(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetREEP_EPR19() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetREEP_EPR20(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetREEP_EPR20() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetREEP_EPR21(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetREEP_EPR21() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetREEP_EPR22(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetREEP_EPR22() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetREEP_EPR23(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetREEP_EPR23() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetREEP_EPR24(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetREEP_EPR24() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetREEP_EPR25(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetREEP_EPR25() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetREEP_EPR26(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetREEP_EPR26() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetREEP_EPR27(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetREEP_EPR27() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetREEP_EPR28(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetREEP_EPR28() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetREEP_EPR29(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetREEP_EPR29() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetREEP_EPR30(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetREEP_EPR30() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetREEP_EPR31(value uint32) {
	volatile.StoreUint32(&o.REEP.Reg, volatile.LoadUint32(&o.REEP.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetREEP_EPR31() uint32 {
	return (volatile.LoadUint32(&o.REEP.Reg) & 0x80000000) >> 31
}

// USB.EPIND: USB Endpoint Index
func (o *USB_Type) SetEPIND_PHY_EP(value uint32) {
	volatile.StoreUint32(&o.EPIND.Reg, volatile.LoadUint32(&o.EPIND.Reg)&^(0x1f)|value)
}
func (o *USB_Type) GetEPIND_PHY_EP() uint32 {
	return volatile.LoadUint32(&o.EPIND.Reg) & 0x1f
}
func (o *USB_Type) SetEPIND_RESERVED(value uint32) {
	volatile.StoreUint32(&o.EPIND.Reg, volatile.LoadUint32(&o.EPIND.Reg)&^(0xffffffe0)|value<<5)
}
func (o *USB_Type) GetEPIND_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.EPIND.Reg) & 0xffffffe0) >> 5
}

// USB.MAXPSIZE: USB MaxPacketSize
func (o *USB_Type) SetMAXPSIZE_MPS(value uint32) {
	volatile.StoreUint32(&o.MAXPSIZE.Reg, volatile.LoadUint32(&o.MAXPSIZE.Reg)&^(0x3ff)|value)
}
func (o *USB_Type) GetMAXPSIZE_MPS() uint32 {
	return volatile.LoadUint32(&o.MAXPSIZE.Reg) & 0x3ff
}
func (o *USB_Type) SetMAXPSIZE_RESERVED(value uint32) {
	volatile.StoreUint32(&o.MAXPSIZE.Reg, volatile.LoadUint32(&o.MAXPSIZE.Reg)&^(0xfffffc00)|value<<10)
}
func (o *USB_Type) GetMAXPSIZE_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.MAXPSIZE.Reg) & 0xfffffc00) >> 10
}

// USB.DMARST: USB DMA Request Status
func (o *USB_Type) SetDMARST_EPRST0(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDMARST_EPRST0() uint32 {
	return volatile.LoadUint32(&o.DMARST.Reg) & 0x1
}
func (o *USB_Type) SetDMARST_EPRST1(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDMARST_EPRST1() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDMARST_EPRST2(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDMARST_EPRST2() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDMARST_EPRST3(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDMARST_EPRST3() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDMARST_EPRST4(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDMARST_EPRST4() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDMARST_EPRST5(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDMARST_EPRST5() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDMARST_EPRST6(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDMARST_EPRST6() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDMARST_EPRST7(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDMARST_EPRST7() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDMARST_EPRST8(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDMARST_EPRST8() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDMARST_EPRST9(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDMARST_EPRST9() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDMARST_EPRST10(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetDMARST_EPRST10() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetDMARST_EPRST11(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetDMARST_EPRST11() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetDMARST_EPRST12(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetDMARST_EPRST12() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetDMARST_EPRST13(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetDMARST_EPRST13() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetDMARST_EPRST14(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetDMARST_EPRST14() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetDMARST_EPRST15(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetDMARST_EPRST15() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetDMARST_EPRST16(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetDMARST_EPRST16() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetDMARST_EPRST17(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetDMARST_EPRST17() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetDMARST_EPRST18(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetDMARST_EPRST18() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetDMARST_EPRST19(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetDMARST_EPRST19() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetDMARST_EPRST20(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetDMARST_EPRST20() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetDMARST_EPRST21(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetDMARST_EPRST21() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetDMARST_EPRST22(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetDMARST_EPRST22() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetDMARST_EPRST23(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetDMARST_EPRST23() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetDMARST_EPRST24(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetDMARST_EPRST24() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetDMARST_EPRST25(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetDMARST_EPRST25() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetDMARST_EPRST26(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetDMARST_EPRST26() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetDMARST_EPRST27(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetDMARST_EPRST27() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetDMARST_EPRST28(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetDMARST_EPRST28() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetDMARST_EPRST29(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetDMARST_EPRST29() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetDMARST_EPRST30(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetDMARST_EPRST30() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetDMARST_EPRST31(value uint32) {
	volatile.StoreUint32(&o.DMARST.Reg, volatile.LoadUint32(&o.DMARST.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetDMARST_EPRST31() uint32 {
	return (volatile.LoadUint32(&o.DMARST.Reg) & 0x80000000) >> 31
}

// USB.DMARCLR: USB DMA Request Clear
func (o *USB_Type) SetDMARCLR_EPRCLR0(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDMARCLR_EPRCLR0() uint32 {
	return volatile.LoadUint32(&o.DMARCLR.Reg) & 0x1
}
func (o *USB_Type) SetDMARCLR_EPRCLR1(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDMARCLR_EPRCLR1() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDMARCLR_EPRCLR2(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDMARCLR_EPRCLR2() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDMARCLR_EPRCLR3(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDMARCLR_EPRCLR3() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDMARCLR_EPRCLR4(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDMARCLR_EPRCLR4() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDMARCLR_EPRCLR5(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDMARCLR_EPRCLR5() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDMARCLR_EPRCLR6(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDMARCLR_EPRCLR6() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDMARCLR_EPRCLR7(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDMARCLR_EPRCLR7() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDMARCLR_EPRCLR8(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDMARCLR_EPRCLR8() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDMARCLR_EPRCLR9(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDMARCLR_EPRCLR9() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDMARCLR_EPRCLR10(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetDMARCLR_EPRCLR10() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetDMARCLR_EPRCLR11(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetDMARCLR_EPRCLR11() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetDMARCLR_EPRCLR12(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetDMARCLR_EPRCLR12() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetDMARCLR_EPRCLR13(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetDMARCLR_EPRCLR13() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetDMARCLR_EPRCLR14(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetDMARCLR_EPRCLR14() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetDMARCLR_EPRCLR15(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetDMARCLR_EPRCLR15() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetDMARCLR_EPRCLR16(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetDMARCLR_EPRCLR16() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetDMARCLR_EPRCLR17(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetDMARCLR_EPRCLR17() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetDMARCLR_EPRCLR18(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetDMARCLR_EPRCLR18() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetDMARCLR_EPRCLR19(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetDMARCLR_EPRCLR19() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetDMARCLR_EPRCLR20(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetDMARCLR_EPRCLR20() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetDMARCLR_EPRCLR21(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetDMARCLR_EPRCLR21() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetDMARCLR_EPRCLR22(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetDMARCLR_EPRCLR22() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetDMARCLR_EPRCLR23(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetDMARCLR_EPRCLR23() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetDMARCLR_EPRCLR24(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetDMARCLR_EPRCLR24() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetDMARCLR_EPRCLR25(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetDMARCLR_EPRCLR25() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetDMARCLR_EPRCLR26(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetDMARCLR_EPRCLR26() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetDMARCLR_EPRCLR27(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetDMARCLR_EPRCLR27() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetDMARCLR_EPRCLR28(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetDMARCLR_EPRCLR28() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetDMARCLR_EPRCLR29(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetDMARCLR_EPRCLR29() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetDMARCLR_EPRCLR30(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetDMARCLR_EPRCLR30() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetDMARCLR_EPRCLR31(value uint32) {
	volatile.StoreUint32(&o.DMARCLR.Reg, volatile.LoadUint32(&o.DMARCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetDMARCLR_EPRCLR31() uint32 {
	return (volatile.LoadUint32(&o.DMARCLR.Reg) & 0x80000000) >> 31
}

// USB.DMARSET: USB DMA Request Set
func (o *USB_Type) SetDMARSET_EPRSET0(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDMARSET_EPRSET0() uint32 {
	return volatile.LoadUint32(&o.DMARSET.Reg) & 0x1
}
func (o *USB_Type) SetDMARSET_EPRSET1(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDMARSET_EPRSET1() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDMARSET_EPRSET2(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDMARSET_EPRSET2() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDMARSET_EPRSET3(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDMARSET_EPRSET3() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDMARSET_EPRSET4(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDMARSET_EPRSET4() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDMARSET_EPRSET5(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDMARSET_EPRSET5() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDMARSET_EPRSET6(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDMARSET_EPRSET6() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDMARSET_EPRSET7(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDMARSET_EPRSET7() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetDMARSET_EPRSET8(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetDMARSET_EPRSET8() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetDMARSET_EPRSET9(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetDMARSET_EPRSET9() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetDMARSET_EPRSET10(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetDMARSET_EPRSET10() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetDMARSET_EPRSET11(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetDMARSET_EPRSET11() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetDMARSET_EPRSET12(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetDMARSET_EPRSET12() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetDMARSET_EPRSET13(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetDMARSET_EPRSET13() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetDMARSET_EPRSET14(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetDMARSET_EPRSET14() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetDMARSET_EPRSET15(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetDMARSET_EPRSET15() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetDMARSET_EPRSET16(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetDMARSET_EPRSET16() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetDMARSET_EPRSET17(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetDMARSET_EPRSET17() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetDMARSET_EPRSET18(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetDMARSET_EPRSET18() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetDMARSET_EPRSET19(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetDMARSET_EPRSET19() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetDMARSET_EPRSET20(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetDMARSET_EPRSET20() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetDMARSET_EPRSET21(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetDMARSET_EPRSET21() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetDMARSET_EPRSET22(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetDMARSET_EPRSET22() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetDMARSET_EPRSET23(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetDMARSET_EPRSET23() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetDMARSET_EPRSET24(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetDMARSET_EPRSET24() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetDMARSET_EPRSET25(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetDMARSET_EPRSET25() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetDMARSET_EPRSET26(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetDMARSET_EPRSET26() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetDMARSET_EPRSET27(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetDMARSET_EPRSET27() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetDMARSET_EPRSET28(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetDMARSET_EPRSET28() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetDMARSET_EPRSET29(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetDMARSET_EPRSET29() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetDMARSET_EPRSET30(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetDMARSET_EPRSET30() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetDMARSET_EPRSET31(value uint32) {
	volatile.StoreUint32(&o.DMARSET.Reg, volatile.LoadUint32(&o.DMARSET.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetDMARSET_EPRSET31() uint32 {
	return (volatile.LoadUint32(&o.DMARSET.Reg) & 0x80000000) >> 31
}

// USB.UDCAH: USB UDCA Head
func (o *USB_Type) SetUDCAH_RESERVED(value uint32) {
	volatile.StoreUint32(&o.UDCAH.Reg, volatile.LoadUint32(&o.UDCAH.Reg)&^(0x7f)|value)
}
func (o *USB_Type) GetUDCAH_RESERVED() uint32 {
	return volatile.LoadUint32(&o.UDCAH.Reg) & 0x7f
}
func (o *USB_Type) SetUDCAH_UDCA_ADDR(value uint32) {
	volatile.StoreUint32(&o.UDCAH.Reg, volatile.LoadUint32(&o.UDCAH.Reg)&^(0xffffff80)|value<<7)
}
func (o *USB_Type) GetUDCAH_UDCA_ADDR() uint32 {
	return (volatile.LoadUint32(&o.UDCAH.Reg) & 0xffffff80) >> 7
}

// USB.EPDMAST: USB Endpoint DMA Status
func (o *USB_Type) SetEPDMAST_EP_DMA_ST0(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST0() uint32 {
	return volatile.LoadUint32(&o.EPDMAST.Reg) & 0x1
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST1(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST1() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST2(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST2() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST3(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST3() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST4(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST4() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST5(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST5() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST6(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST6() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST7(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST7() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST8(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST8() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST9(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST9() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST10(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST10() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST11(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST11() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST12(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST12() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST13(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST13() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST14(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST14() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST15(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST15() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST16(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST16() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST17(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST17() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST18(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST18() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST19(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST19() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST20(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST20() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST21(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST21() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST22(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST22() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST23(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST23() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST24(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST24() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST25(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST25() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST26(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST26() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST27(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST27() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST28(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST28() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST29(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST29() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST30(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST30() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPDMAST_EP_DMA_ST31(value uint32) {
	volatile.StoreUint32(&o.EPDMAST.Reg, volatile.LoadUint32(&o.EPDMAST.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPDMAST_EP_DMA_ST31() uint32 {
	return (volatile.LoadUint32(&o.EPDMAST.Reg) & 0x80000000) >> 31
}

// USB.EPDMAEN: USB Endpoint DMA Enable
func (o *USB_Type) SetEPDMAEN_EP_DMA_EN0(value uint32) {
	volatile.StoreUint32(&o.EPDMAEN.Reg, volatile.LoadUint32(&o.EPDMAEN.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPDMAEN_EP_DMA_EN0() uint32 {
	return volatile.LoadUint32(&o.EPDMAEN.Reg) & 0x1
}
func (o *USB_Type) SetEPDMAEN_EP_DMA_EN1(value uint32) {
	volatile.StoreUint32(&o.EPDMAEN.Reg, volatile.LoadUint32(&o.EPDMAEN.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPDMAEN_EP_DMA_EN1() uint32 {
	return (volatile.LoadUint32(&o.EPDMAEN.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPDMAEN_EP_DMA_EN(value uint32) {
	volatile.StoreUint32(&o.EPDMAEN.Reg, volatile.LoadUint32(&o.EPDMAEN.Reg)&^(0xfffffffc)|value<<2)
}
func (o *USB_Type) GetEPDMAEN_EP_DMA_EN() uint32 {
	return (volatile.LoadUint32(&o.EPDMAEN.Reg) & 0xfffffffc) >> 2
}

// USB.EPDMADIS: USB Endpoint DMA Disable
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS0(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS0() uint32 {
	return volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x1
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS1(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS1() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS2(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS2() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS3(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS3() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS4(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS4() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS5(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS5() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS6(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS6() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS7(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS7() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS8(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS8() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS9(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS9() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS10(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS10() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS11(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS11() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS12(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS12() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS13(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS13() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS14(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS14() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS15(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS15() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS16(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS16() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS17(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS17() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS18(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS18() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS19(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS19() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS20(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS20() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS21(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS21() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS22(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS22() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS23(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS23() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS24(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS24() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS25(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS25() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS26(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS26() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS27(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS27() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS28(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS28() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS29(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS29() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS30(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS30() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEPDMADIS_EP_DMA_DIS31(value uint32) {
	volatile.StoreUint32(&o.EPDMADIS.Reg, volatile.LoadUint32(&o.EPDMADIS.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEPDMADIS_EP_DMA_DIS31() uint32 {
	return (volatile.LoadUint32(&o.EPDMADIS.Reg) & 0x80000000) >> 31
}

// USB.DMAINTST: USB DMA Interrupt Status
func (o *USB_Type) SetDMAINTST_EOT(value uint32) {
	volatile.StoreUint32(&o.DMAINTST.Reg, volatile.LoadUint32(&o.DMAINTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDMAINTST_EOT() uint32 {
	return volatile.LoadUint32(&o.DMAINTST.Reg) & 0x1
}
func (o *USB_Type) SetDMAINTST_NDDR(value uint32) {
	volatile.StoreUint32(&o.DMAINTST.Reg, volatile.LoadUint32(&o.DMAINTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDMAINTST_NDDR() uint32 {
	return (volatile.LoadUint32(&o.DMAINTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDMAINTST_ERR(value uint32) {
	volatile.StoreUint32(&o.DMAINTST.Reg, volatile.LoadUint32(&o.DMAINTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDMAINTST_ERR() uint32 {
	return (volatile.LoadUint32(&o.DMAINTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDMAINTST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMAINTST.Reg, volatile.LoadUint32(&o.DMAINTST.Reg)&^(0xfffffff8)|value<<3)
}
func (o *USB_Type) GetDMAINTST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMAINTST.Reg) & 0xfffffff8) >> 3
}

// USB.DMAINTEN: USB DMA Interrupt Enable
func (o *USB_Type) SetDMAINTEN_EOT(value uint32) {
	volatile.StoreUint32(&o.DMAINTEN.Reg, volatile.LoadUint32(&o.DMAINTEN.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDMAINTEN_EOT() uint32 {
	return volatile.LoadUint32(&o.DMAINTEN.Reg) & 0x1
}
func (o *USB_Type) SetDMAINTEN_NDDR(value uint32) {
	volatile.StoreUint32(&o.DMAINTEN.Reg, volatile.LoadUint32(&o.DMAINTEN.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDMAINTEN_NDDR() uint32 {
	return (volatile.LoadUint32(&o.DMAINTEN.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDMAINTEN_ERR(value uint32) {
	volatile.StoreUint32(&o.DMAINTEN.Reg, volatile.LoadUint32(&o.DMAINTEN.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDMAINTEN_ERR() uint32 {
	return (volatile.LoadUint32(&o.DMAINTEN.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDMAINTEN_RESERVED(value uint32) {
	volatile.StoreUint32(&o.DMAINTEN.Reg, volatile.LoadUint32(&o.DMAINTEN.Reg)&^(0xfffffff8)|value<<3)
}
func (o *USB_Type) GetDMAINTEN_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.DMAINTEN.Reg) & 0xfffffff8) >> 3
}

// USB.EOTINTST: USB End of Transfer Interrupt Status
func (o *USB_Type) SetEOTINTST_EPTXINTST0(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST0() uint32 {
	return volatile.LoadUint32(&o.EOTINTST.Reg) & 0x1
}
func (o *USB_Type) SetEOTINTST_EPTXINTST1(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST1() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEOTINTST_EPTXINTST2(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST2() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEOTINTST_EPTXINTST3(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST3() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEOTINTST_EPTXINTST4(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST4() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEOTINTST_EPTXINTST5(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST5() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEOTINTST_EPTXINTST6(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST6() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEOTINTST_EPTXINTST7(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST7() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEOTINTST_EPTXINTST8(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST8() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEOTINTST_EPTXINTST9(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST9() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEOTINTST_EPTXINTST10(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST10() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEOTINTST_EPTXINTST11(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST11() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEOTINTST_EPTXINTST12(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST12() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEOTINTST_EPTXINTST13(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST13() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEOTINTST_EPTXINTST14(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST14() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEOTINTST_EPTXINTST15(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST15() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEOTINTST_EPTXINTST16(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST16() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEOTINTST_EPTXINTST17(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST17() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEOTINTST_EPTXINTST18(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST18() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEOTINTST_EPTXINTST19(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST19() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEOTINTST_EPTXINTST20(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST20() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEOTINTST_EPTXINTST21(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST21() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEOTINTST_EPTXINTST22(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST22() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEOTINTST_EPTXINTST23(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST23() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEOTINTST_EPTXINTST24(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST24() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEOTINTST_EPTXINTST25(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST25() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEOTINTST_EPTXINTST26(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST26() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEOTINTST_EPTXINTST27(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST27() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEOTINTST_EPTXINTST28(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST28() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEOTINTST_EPTXINTST29(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST29() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEOTINTST_EPTXINTST30(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST30() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEOTINTST_EPTXINTST31(value uint32) {
	volatile.StoreUint32(&o.EOTINTST.Reg, volatile.LoadUint32(&o.EOTINTST.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEOTINTST_EPTXINTST31() uint32 {
	return (volatile.LoadUint32(&o.EOTINTST.Reg) & 0x80000000) >> 31
}

// USB.EOTINTCLR: USB End of Transfer Interrupt Clear
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR0(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR0() uint32 {
	return volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x1
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR1(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR1() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR2(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR2() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR3(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR3() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR4(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR4() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR5(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR5() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR6(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR6() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR7(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR7() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR8(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR8() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR9(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR9() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR10(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR10() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR11(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR11() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR12(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR12() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR13(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR13() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR14(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR14() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR15(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR15() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR16(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR16() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR17(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR17() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR18(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR18() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR19(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR19() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR20(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR20() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR21(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR21() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR22(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR22() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR23(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR23() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR24(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR24() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR25(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR25() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR26(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR26() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR27(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR27() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR28(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR28() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR29(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR29() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR30(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR30() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEOTINTCLR_EPTXINTCLR31(value uint32) {
	volatile.StoreUint32(&o.EOTINTCLR.Reg, volatile.LoadUint32(&o.EOTINTCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEOTINTCLR_EPTXINTCLR31() uint32 {
	return (volatile.LoadUint32(&o.EOTINTCLR.Reg) & 0x80000000) >> 31
}

// USB.EOTINTSET: USB End of Transfer Interrupt Set
func (o *USB_Type) SetEOTINTSET_EPTXINTSET0(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET0() uint32 {
	return volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x1
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET1(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET1() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET2(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET2() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET3(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET3() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET4(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET4() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET5(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET5() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET6(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET6() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET7(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET7() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET8(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET8() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET9(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET9() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET10(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET10() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET11(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET11() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET12(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET12() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET13(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET13() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET14(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET14() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET15(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET15() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET16(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET16() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET17(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET17() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET18(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET18() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET19(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET19() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET20(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET20() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET21(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET21() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET22(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET22() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET23(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET23() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET24(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET24() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET25(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET25() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET26(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET26() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET27(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET27() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET28(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET28() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET29(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET29() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET30(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET30() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetEOTINTSET_EPTXINTSET31(value uint32) {
	volatile.StoreUint32(&o.EOTINTSET.Reg, volatile.LoadUint32(&o.EOTINTSET.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetEOTINTSET_EPTXINTSET31() uint32 {
	return (volatile.LoadUint32(&o.EOTINTSET.Reg) & 0x80000000) >> 31
}

// USB.NDDRINTST: USB New DD Request Interrupt Status
func (o *USB_Type) SetNDDRINTST_EPNDDINTST0(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST0() uint32 {
	return volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x1
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST1(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST1() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST2(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST2() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST3(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST3() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST4(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST4() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST5(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST5() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST6(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST6() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST7(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST7() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST8(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST8() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST9(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST9() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST10(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST10() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST11(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST11() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST12(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST12() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST13(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST13() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST14(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST14() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST15(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST15() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST16(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST16() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST17(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST17() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST18(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST18() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST19(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST19() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST20(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST20() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST21(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST21() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST22(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST22() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST23(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST23() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST24(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST24() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST25(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST25() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST26(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST26() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST27(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST27() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST28(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST28() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST29(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST29() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST30(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST30() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetNDDRINTST_EPNDDINTST31(value uint32) {
	volatile.StoreUint32(&o.NDDRINTST.Reg, volatile.LoadUint32(&o.NDDRINTST.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetNDDRINTST_EPNDDINTST31() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTST.Reg) & 0x80000000) >> 31
}

// USB.NDDRINTCLR: USB New DD Request Interrupt Clear
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR0(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR0() uint32 {
	return volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x1
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR1(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR1() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR2(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR2() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR3(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR3() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR4(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR4() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR5(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR5() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR6(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR6() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR7(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR7() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR8(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR8() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR9(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR9() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR10(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR10() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR11(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR11() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR12(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR12() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR13(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR13() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR14(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR14() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR15(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR15() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR16(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR16() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR17(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR17() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR18(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR18() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR19(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR19() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR20(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR20() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR21(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR21() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR22(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR22() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR23(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR23() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR24(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR24() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR25(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR25() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR26(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR26() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR27(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR27() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR28(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR28() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR29(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR29() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR30(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR30() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetNDDRINTCLR_EPNDDINTCLR31(value uint32) {
	volatile.StoreUint32(&o.NDDRINTCLR.Reg, volatile.LoadUint32(&o.NDDRINTCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetNDDRINTCLR_EPNDDINTCLR31() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTCLR.Reg) & 0x80000000) >> 31
}

// USB.NDDRINTSET: USB New DD Request Interrupt Set
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET0(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET0() uint32 {
	return volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x1
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET1(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET1() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET2(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET2() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET3(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET3() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET4(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET4() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET5(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET5() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET6(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET6() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET7(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET7() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET8(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET8() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET9(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET9() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET10(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET10() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET11(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET11() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET12(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET12() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET13(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET13() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET14(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET14() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET15(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET15() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET16(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET16() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET17(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET17() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET18(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET18() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET19(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET19() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET20(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET20() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET21(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET21() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET22(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET22() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET23(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET23() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET24(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET24() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET25(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET25() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET26(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET26() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET27(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET27() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET28(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET28() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET29(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET29() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET30(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET30() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetNDDRINTSET_EPNDDINTSET31(value uint32) {
	volatile.StoreUint32(&o.NDDRINTSET.Reg, volatile.LoadUint32(&o.NDDRINTSET.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetNDDRINTSET_EPNDDINTSET31() uint32 {
	return (volatile.LoadUint32(&o.NDDRINTSET.Reg) & 0x80000000) >> 31
}

// USB.SYSERRINTST: USB System Error Interrupt Status
func (o *USB_Type) SetSYSERRINTST_EPERRINTST0(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST0() uint32 {
	return volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x1
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST1(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST1() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST2(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST2() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST3(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST3() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST4(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST4() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST5(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST5() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST6(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST6() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST7(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST7() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST8(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST8() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST9(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST9() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST10(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST10() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST11(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST11() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST12(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST12() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST13(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST13() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST14(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST14() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST15(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST15() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST16(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST16() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST17(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST17() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST18(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST18() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST19(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST19() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST20(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST20() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST21(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST21() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST22(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST22() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST23(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST23() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST24(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST24() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST25(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST25() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST26(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST26() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST27(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST27() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST28(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST28() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST29(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST29() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST30(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST30() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetSYSERRINTST_EPERRINTST31(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTST.Reg, volatile.LoadUint32(&o.SYSERRINTST.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetSYSERRINTST_EPERRINTST31() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTST.Reg) & 0x80000000) >> 31
}

// USB.SYSERRINTCLR: USB System Error Interrupt Clear
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR0(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR0() uint32 {
	return volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x1
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR1(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR1() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR2(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR2() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR3(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR3() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR4(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR4() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR5(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR5() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR6(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR6() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR7(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR7() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR8(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR8() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR9(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR9() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR10(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR10() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR11(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR11() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR12(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR12() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR13(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR13() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR14(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR14() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR15(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR15() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR16(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR16() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR17(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR17() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR18(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR18() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR19(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR19() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR20(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR20() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR21(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR21() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR22(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR22() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR23(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR23() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR24(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR24() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR25(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR25() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR26(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR26() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR27(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR27() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR28(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR28() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR29(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR29() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR30(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR30() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetSYSERRINTCLR_EPERRINTCLR31(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTCLR.Reg, volatile.LoadUint32(&o.SYSERRINTCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetSYSERRINTCLR_EPERRINTCLR31() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTCLR.Reg) & 0x80000000) >> 31
}

// USB.SYSERRINTSET: USB System Error Interrupt Set
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET0(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET0() uint32 {
	return volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x1
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET1(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET1() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET2(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET2() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET3(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET3() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET4(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET4() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET5(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET5() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET6(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET6() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET7(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET7() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET8(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET8() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET9(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET9() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET10(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET10() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET11(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET11() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET12(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET12() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET13(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET13() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET14(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET14() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET15(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET15() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x8000) >> 15
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET16(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x10000)|value<<16)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET16() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x10000) >> 16
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET17(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x20000)|value<<17)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET17() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x20000) >> 17
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET18(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x40000)|value<<18)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET18() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x40000) >> 18
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET19(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x80000)|value<<19)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET19() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x80000) >> 19
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET20(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x100000)|value<<20)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET20() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x100000) >> 20
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET21(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x200000)|value<<21)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET21() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x200000) >> 21
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET22(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x400000)|value<<22)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET22() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x400000) >> 22
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET23(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x800000)|value<<23)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET23() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x800000) >> 23
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET24(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET24() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x1000000) >> 24
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET25(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET25() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x2000000) >> 25
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET26(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET26() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x4000000) >> 26
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET27(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET27() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x8000000) >> 27
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET28(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET28() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x10000000) >> 28
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET29(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET29() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x20000000) >> 29
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET30(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET30() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x40000000) >> 30
}
func (o *USB_Type) SetSYSERRINTSET_EPERRINTSET31(value uint32) {
	volatile.StoreUint32(&o.SYSERRINTSET.Reg, volatile.LoadUint32(&o.SYSERRINTSET.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_Type) GetSYSERRINTSET_EPERRINTSET31() uint32 {
	return (volatile.LoadUint32(&o.SYSERRINTSET.Reg) & 0x80000000) >> 31
}

// USB.I2C_RX: I2C Receive
func (o *USB_Type) SetI2C_RX_RXDATA(value uint32) {
	volatile.StoreUint32(&o.I2C_RX.Reg, volatile.LoadUint32(&o.I2C_RX.Reg)&^(0xff)|value)
}
func (o *USB_Type) GetI2C_RX_RXDATA() uint32 {
	return volatile.LoadUint32(&o.I2C_RX.Reg) & 0xff
}

// USB.I2C_STS: I2C Status
func (o *USB_Type) SetI2C_STS_TDI(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetI2C_STS_TDI() uint32 {
	return volatile.LoadUint32(&o.I2C_STS.Reg) & 0x1
}
func (o *USB_Type) SetI2C_STS_AFI(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetI2C_STS_AFI() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetI2C_STS_NAI(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetI2C_STS_NAI() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetI2C_STS_DRMI(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetI2C_STS_DRMI() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetI2C_STS_DRSI(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetI2C_STS_DRSI() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetI2C_STS_Active(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetI2C_STS_Active() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetI2C_STS_SCL(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetI2C_STS_SCL() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetI2C_STS_SDA(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetI2C_STS_SDA() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetI2C_STS_RFF(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetI2C_STS_RFF() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetI2C_STS_RFE(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetI2C_STS_RFE() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetI2C_STS_TFF(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetI2C_STS_TFF() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetI2C_STS_TFE(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetI2C_STS_TFE() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetI2C_STS_RESERVED(value uint32) {
	volatile.StoreUint32(&o.I2C_STS.Reg, volatile.LoadUint32(&o.I2C_STS.Reg)&^(0xfffff000)|value<<12)
}
func (o *USB_Type) GetI2C_STS_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.I2C_STS.Reg) & 0xfffff000) >> 12
}

// USB.I2C_CTL: I2C Control
func (o *USB_Type) SetI2C_CTL_TDIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetI2C_CTL_TDIE() uint32 {
	return volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x1
}
func (o *USB_Type) SetI2C_CTL_AFIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetI2C_CTL_AFIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetI2C_CTL_NAIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetI2C_CTL_NAIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetI2C_CTL_DRMIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetI2C_CTL_DRMIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetI2C_CTL_DRSIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetI2C_CTL_DRSIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetI2C_CTL_REFIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetI2C_CTL_REFIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetI2C_CTL_RFDAIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetI2C_CTL_RFDAIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetI2C_CTL_TFFIE(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetI2C_CTL_TFFIE() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetI2C_CTL_SRST(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetI2C_CTL_SRST() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetI2C_CTL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.I2C_CTL.Reg, volatile.LoadUint32(&o.I2C_CTL.Reg)&^(0xfffffe00)|value<<9)
}
func (o *USB_Type) GetI2C_CTL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.I2C_CTL.Reg) & 0xfffffe00) >> 9
}

// USB.I2C_CLKHI: I2C Clock High
func (o *USB_Type) SetI2C_CLKHI_CDHI(value uint32) {
	volatile.StoreUint32(&o.I2C_CLKHI.Reg, volatile.LoadUint32(&o.I2C_CLKHI.Reg)&^(0xff)|value)
}
func (o *USB_Type) GetI2C_CLKHI_CDHI() uint32 {
	return volatile.LoadUint32(&o.I2C_CLKHI.Reg) & 0xff
}
func (o *USB_Type) SetI2C_CLKHI_RESERVED(value uint32) {
	volatile.StoreUint32(&o.I2C_CLKHI.Reg, volatile.LoadUint32(&o.I2C_CLKHI.Reg)&^(0xffffff00)|value<<8)
}
func (o *USB_Type) GetI2C_CLKHI_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.I2C_CLKHI.Reg) & 0xffffff00) >> 8
}

// USB.I2C_CLKLO: I2C Clock Low
func (o *USB_Type) SetI2C_CLKLO_CDLO(value uint32) {
	volatile.StoreUint32(&o.I2C_CLKLO.Reg, volatile.LoadUint32(&o.I2C_CLKLO.Reg)&^(0xff)|value)
}
func (o *USB_Type) GetI2C_CLKLO_CDLO() uint32 {
	return volatile.LoadUint32(&o.I2C_CLKLO.Reg) & 0xff
}
func (o *USB_Type) SetI2C_CLKLO_RESERVED(value uint32) {
	volatile.StoreUint32(&o.I2C_CLKLO.Reg, volatile.LoadUint32(&o.I2C_CLKLO.Reg)&^(0xffffff00)|value<<8)
}
func (o *USB_Type) GetI2C_CLKLO_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.I2C_CLKLO.Reg) & 0xffffff00) >> 8
}

// USB.USBCLKCTRL: USB Clock Control
func (o *USB_Type) SetUSBCLKCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCLKCTRL.Reg, volatile.LoadUint32(&o.USBCLKCTRL.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetUSBCLKCTRL_RESERVED() uint32 {
	return volatile.LoadUint32(&o.USBCLKCTRL.Reg) & 0x1
}
func (o *USB_Type) SetUSBCLKCTRL_DEV_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.USBCLKCTRL.Reg, volatile.LoadUint32(&o.USBCLKCTRL.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetUSBCLKCTRL_DEV_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.USBCLKCTRL.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetUSBCLKCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCLKCTRL.Reg, volatile.LoadUint32(&o.USBCLKCTRL.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetUSBCLKCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCLKCTRL.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetUSBCLKCTRL_PORTSEL_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.USBCLKCTRL.Reg, volatile.LoadUint32(&o.USBCLKCTRL.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetUSBCLKCTRL_PORTSEL_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.USBCLKCTRL.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetUSBCLKCTRL_AHB_CLK_EN(value uint32) {
	volatile.StoreUint32(&o.USBCLKCTRL.Reg, volatile.LoadUint32(&o.USBCLKCTRL.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetUSBCLKCTRL_AHB_CLK_EN() uint32 {
	return (volatile.LoadUint32(&o.USBCLKCTRL.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetUSBCLKCTRL_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCLKCTRL.Reg, volatile.LoadUint32(&o.USBCLKCTRL.Reg)&^(0xffffffe0)|value<<5)
}
func (o *USB_Type) GetUSBCLKCTRL_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCLKCTRL.Reg) & 0xffffffe0) >> 5
}

// USB.USBCLKST: USB Clock Status
func (o *USB_Type) SetUSBCLKST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCLKST.Reg, volatile.LoadUint32(&o.USBCLKST.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetUSBCLKST_RESERVED() uint32 {
	return volatile.LoadUint32(&o.USBCLKST.Reg) & 0x1
}
func (o *USB_Type) SetUSBCLKST_DEV_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.USBCLKST.Reg, volatile.LoadUint32(&o.USBCLKST.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetUSBCLKST_DEV_CLK_ON() uint32 {
	return (volatile.LoadUint32(&o.USBCLKST.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetUSBCLKST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCLKST.Reg, volatile.LoadUint32(&o.USBCLKST.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetUSBCLKST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCLKST.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetUSBCLKST_PORTSEL_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.USBCLKST.Reg, volatile.LoadUint32(&o.USBCLKST.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetUSBCLKST_PORTSEL_CLK_ON() uint32 {
	return (volatile.LoadUint32(&o.USBCLKST.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetUSBCLKST_AHB_CLK_ON(value uint32) {
	volatile.StoreUint32(&o.USBCLKST.Reg, volatile.LoadUint32(&o.USBCLKST.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetUSBCLKST_AHB_CLK_ON() uint32 {
	return (volatile.LoadUint32(&o.USBCLKST.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetUSBCLKST_RESERVED(value uint32) {
	volatile.StoreUint32(&o.USBCLKST.Reg, volatile.LoadUint32(&o.USBCLKST.Reg)&^(0xffffffe0)|value<<5)
}
func (o *USB_Type) GetUSBCLKST_RESERVED() uint32 {
	return (volatile.LoadUint32(&o.USBCLKST.Reg) & 0xffffffe0) >> 5
}

// General Purpose I/O
type GPIO_Type struct {
	DIR0  volatile.Register32 // 0x0
	_     [12]byte
	MASK0 volatile.Register32 // 0x10
	PIN0  volatile.Register32 // 0x14
	SET0  volatile.Register32 // 0x18
	CLR0  volatile.Register32 // 0x1C
	DIR1  volatile.Register32 // 0x20
	_     [12]byte
	MASK1 volatile.Register32 // 0x30
	PIN1  volatile.Register32 // 0x34
	SET1  volatile.Register32 // 0x38
	CLR1  volatile.Register32 // 0x3C
	DIR2  volatile.Register32 // 0x40
	_     [12]byte
	MASK2 volatile.Register32 // 0x50
	PIN2  volatile.Register32 // 0x54
	SET2  volatile.Register32 // 0x58
	CLR2  volatile.Register32 // 0x5C
	DIR3  volatile.Register32 // 0x60
	_     [12]byte
	MASK3 volatile.Register32 // 0x70
	PIN3  volatile.Register32 // 0x74
	SET3  volatile.Register32 // 0x78
	CLR3  volatile.Register32 // 0x7C
	DIR4  volatile.Register32 // 0x80
	_     [12]byte
	MASK4 volatile.Register32 // 0x90
	PIN4  volatile.Register32 // 0x94
	SET4  volatile.Register32 // 0x98
	CLR4  volatile.Register32 // 0x9C
}

// GPIO.DIR0: GPIO Port Direction control register.
func (o *GPIO_Type) SetDIR0_PINDIR0(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR0_PINDIR0() uint32 {
	return volatile.LoadUint32(&o.DIR0.Reg) & 0x1
}
func (o *GPIO_Type) SetDIR0_PINDIR1(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR0_PINDIR1() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR0_PINDIR2(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR0_PINDIR2() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR0_PINDIR3(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR0_PINDIR3() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR0_PINDIR4(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR0_PINDIR4() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR0_PINDIR5(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR0_PINDIR5() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR0_PINDIR6(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR0_PINDIR6() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR0_PINDIR7(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR0_PINDIR7() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR0_PINDIR8(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR0_PINDIR8() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR0_PINDIR9(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR0_PINDIR9() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR0_PINDIR10(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR0_PINDIR10() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR0_PINDIR11(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR0_PINDIR11() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR0_PINDIR12(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR0_PINDIR12() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR0_PINDIR13(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR0_PINDIR13() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR0_PINDIR14(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR0_PINDIR14() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR0_PINDIR15(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR0_PINDIR15() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR0_PINDIR16(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR0_PINDIR16() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR0_PINDIR17(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR0_PINDIR17() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR0_PINDIR18(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR0_PINDIR18() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR0_PINDIR19(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR0_PINDIR19() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR0_PINDIR20(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR0_PINDIR20() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR0_PINDIR21(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR0_PINDIR21() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR0_PINDIR22(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR0_PINDIR22() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR0_PINDIR23(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR0_PINDIR23() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR0_PINDIR24(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR0_PINDIR24() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR0_PINDIR25(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR0_PINDIR25() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR0_PINDIR26(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR0_PINDIR26() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR0_PINDIR27(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR0_PINDIR27() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR0_PINDIR28(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR0_PINDIR28() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR0_PINDIR29(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR0_PINDIR29() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR0_PINDIR30(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR0_PINDIR30() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR0_PINDIR31(value uint32) {
	volatile.StoreUint32(&o.DIR0.Reg, volatile.LoadUint32(&o.DIR0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR0_PINDIR31() uint32 {
	return (volatile.LoadUint32(&o.DIR0.Reg) & 0x80000000) >> 31
}

// GPIO.MASK0: Mask register for Port.
func (o *GPIO_Type) SetMASK0_PINMASK0(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetMASK0_PINMASK0() uint32 {
	return volatile.LoadUint32(&o.MASK0.Reg) & 0x1
}
func (o *GPIO_Type) SetMASK0_PINMASK1(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetMASK0_PINMASK1() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetMASK0_PINMASK2(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetMASK0_PINMASK2() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetMASK0_PINMASK3(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetMASK0_PINMASK3() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetMASK0_PINMASK4(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetMASK0_PINMASK4() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetMASK0_PINMASK5(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetMASK0_PINMASK5() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetMASK0_PINMASK6(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetMASK0_PINMASK6() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetMASK0_PINMASK7(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetMASK0_PINMASK7() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetMASK0_PINMASK8(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetMASK0_PINMASK8() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetMASK0_PINMASK9(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetMASK0_PINMASK9() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetMASK0_PINMASK10(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetMASK0_PINMASK10() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetMASK0_PINMASK11(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetMASK0_PINMASK11() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetMASK0_PINMASK12(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetMASK0_PINMASK12() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetMASK0_PINMASK13(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetMASK0_PINMASK13() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetMASK0_PINMASK14(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetMASK0_PINMASK14() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetMASK0_PINMASK15(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetMASK0_PINMASK15() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetMASK0_PINMASK16(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetMASK0_PINMASK16() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetMASK0_PINMASK17(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetMASK0_PINMASK17() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetMASK0_PINMASK18(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetMASK0_PINMASK18() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetMASK0_PINMASK19(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetMASK0_PINMASK19() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetMASK0_PINMASK20(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetMASK0_PINMASK20() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetMASK0_PINMASK21(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetMASK0_PINMASK21() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetMASK0_PINMASK22(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetMASK0_PINMASK22() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetMASK0_PINMASK23(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetMASK0_PINMASK23() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetMASK0_PINMASK24(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetMASK0_PINMASK24() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetMASK0_PINMASK25(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetMASK0_PINMASK25() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetMASK0_PINMASK26(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetMASK0_PINMASK26() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetMASK0_PINMASK27(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetMASK0_PINMASK27() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetMASK0_PINMASK28(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetMASK0_PINMASK28() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetMASK0_PINMASK29(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetMASK0_PINMASK29() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetMASK0_PINMASK30(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetMASK0_PINMASK30() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetMASK0_PINMASK31(value uint32) {
	volatile.StoreUint32(&o.MASK0.Reg, volatile.LoadUint32(&o.MASK0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetMASK0_PINMASK31() uint32 {
	return (volatile.LoadUint32(&o.MASK0.Reg) & 0x80000000) >> 31
}

// GPIO.PIN0: Port Pin value register using FIOMASK.
func (o *GPIO_Type) SetPIN0_PINVAL0(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN0_PINVAL0() uint32 {
	return volatile.LoadUint32(&o.PIN0.Reg) & 0x1
}
func (o *GPIO_Type) SetPIN0_PINVAL1(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN0_PINVAL1() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN0_PINVAL2(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN0_PINVAL2() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN0_PINVAL3(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetPIN0_PINVAL3() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetPIN0_PINVAL4(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetPIN0_PINVAL4() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetPIN0_PINVAL5(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetPIN0_PINVAL5() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetPIN0_PINVAL6(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetPIN0_PINVAL6() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetPIN0_PINVAL7(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetPIN0_PINVAL7() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetPIN0_PINVAL8(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetPIN0_PINVAL8() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetPIN0_PINVAL9(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetPIN0_PINVAL9() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetPIN0_PINVAL10(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN0_PINVAL10() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN0_PINVAL11(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetPIN0_PINVAL11() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetPIN0_PINVAL12(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetPIN0_PINVAL12() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetPIN0_PINVAL13(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetPIN0_PINVAL13() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetPIN0_PINVAL14(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetPIN0_PINVAL14() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetPIN0_PINVAL15(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetPIN0_PINVAL15() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetPIN0_PINVAL16(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetPIN0_PINVAL16() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetPIN0_PINVAL17(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetPIN0_PINVAL17() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetPIN0_PINVAL18(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetPIN0_PINVAL18() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetPIN0_PINVAL19(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetPIN0_PINVAL19() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetPIN0_PINVAL20(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetPIN0_PINVAL20() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetPIN0_PINVAL21(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetPIN0_PINVAL21() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetPIN0_PINVAL22(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetPIN0_PINVAL22() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetPIN0_PINVAL23(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetPIN0_PINVAL23() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetPIN0_PINVAL24(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetPIN0_PINVAL24() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetPIN0_PINVAL25(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetPIN0_PINVAL25() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetPIN0_PINVAL26(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetPIN0_PINVAL26() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetPIN0_PINVAL27(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetPIN0_PINVAL27() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetPIN0_PINVAL28(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetPIN0_PINVAL28() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetPIN0_PINVAL29(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetPIN0_PINVAL29() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetPIN0_PINVAL30(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetPIN0_PINVAL30() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetPIN0_PINVAL31(value uint32) {
	volatile.StoreUint32(&o.PIN0.Reg, volatile.LoadUint32(&o.PIN0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetPIN0_PINVAL31() uint32 {
	return (volatile.LoadUint32(&o.PIN0.Reg) & 0x80000000) >> 31
}

// GPIO.SET0: Port Output Set register using FIOMASK.
func (o *GPIO_Type) SetSET0_PINSET0(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetSET0_PINSET0() uint32 {
	return volatile.LoadUint32(&o.SET0.Reg) & 0x1
}
func (o *GPIO_Type) SetSET0_PINSET1(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetSET0_PINSET1() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetSET0_PINSET2(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetSET0_PINSET2() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetSET0_PINSET3(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetSET0_PINSET3() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetSET0_PINSET4(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetSET0_PINSET4() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetSET0_PINSET5(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetSET0_PINSET5() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetSET0_PINSET6(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetSET0_PINSET6() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetSET0_PINSET7(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetSET0_PINSET7() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetSET0_PINSET8(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetSET0_PINSET8() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetSET0_PINSET9(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetSET0_PINSET9() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetSET0_PINSET10(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetSET0_PINSET10() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetSET0_PINSET11(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetSET0_PINSET11() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetSET0_PINSET12(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetSET0_PINSET12() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetSET0_PINSET13(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetSET0_PINSET13() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetSET0_PINSET14(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetSET0_PINSET14() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetSET0_PINSET15(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetSET0_PINSET15() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetSET0_PINSET16(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetSET0_PINSET16() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetSET0_PINSET17(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetSET0_PINSET17() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetSET0_PINSET18(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetSET0_PINSET18() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetSET0_PINSET19(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetSET0_PINSET19() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetSET0_PINSET20(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetSET0_PINSET20() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetSET0_PINSET21(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetSET0_PINSET21() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetSET0_PINSET22(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetSET0_PINSET22() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetSET0_PINSET23(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetSET0_PINSET23() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetSET0_PINSET24(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetSET0_PINSET24() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetSET0_PINSET25(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetSET0_PINSET25() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetSET0_PINSET26(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetSET0_PINSET26() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetSET0_PINSET27(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetSET0_PINSET27() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetSET0_PINSET28(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetSET0_PINSET28() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetSET0_PINSET29(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetSET0_PINSET29() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetSET0_PINSET30(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetSET0_PINSET30() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetSET0_PINSET31(value uint32) {
	volatile.StoreUint32(&o.SET0.Reg, volatile.LoadUint32(&o.SET0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetSET0_PINSET31() uint32 {
	return (volatile.LoadUint32(&o.SET0.Reg) & 0x80000000) >> 31
}

// GPIO.CLR0: Port Output Clear register using FIOMASK.
func (o *GPIO_Type) SetCLR0_PINCLR0(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLR0_PINCLR0() uint32 {
	return volatile.LoadUint32(&o.CLR0.Reg) & 0x1
}
func (o *GPIO_Type) SetCLR0_PINCLR1(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetCLR0_PINCLR1() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetCLR0_PINCLR2(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetCLR0_PINCLR2() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetCLR0_PINCLR3(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetCLR0_PINCLR3() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetCLR0_PINCLR4(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetCLR0_PINCLR4() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetCLR0_PINCLR5(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetCLR0_PINCLR5() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetCLR0_PINCLR6(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetCLR0_PINCLR6() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetCLR0_PINCLR7(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetCLR0_PINCLR7() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetCLR0_PINCLR8(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetCLR0_PINCLR8() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetCLR0_PINCLR9(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetCLR0_PINCLR9() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetCLR0_PINCLR10(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetCLR0_PINCLR10() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetCLR0_PINCLR11(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetCLR0_PINCLR11() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetCLR0_PINCLR12(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetCLR0_PINCLR12() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetCLR0_PINCLR13(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetCLR0_PINCLR13() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetCLR0_PINCLR14(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetCLR0_PINCLR14() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetCLR0_PINCLR15(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetCLR0_PINCLR15() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetCLR0_PINCLR16(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetCLR0_PINCLR16() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetCLR0_PINCLR17(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetCLR0_PINCLR17() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetCLR0_PINCLR18(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetCLR0_PINCLR18() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetCLR0_PINCLR19(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetCLR0_PINCLR19() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetCLR0_PINCLR20(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetCLR0_PINCLR20() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetCLR0_PINCLR21(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetCLR0_PINCLR21() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetCLR0_PINCLR22(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetCLR0_PINCLR22() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetCLR0_PINCLR23(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetCLR0_PINCLR23() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetCLR0_PINCLR24(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetCLR0_PINCLR24() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetCLR0_PINCLR25(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetCLR0_PINCLR25() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetCLR0_PINCLR26(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetCLR0_PINCLR26() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetCLR0_PINCLR27(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetCLR0_PINCLR27() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetCLR0_PINCLR28(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetCLR0_PINCLR28() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetCLR0_PINCLR29(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetCLR0_PINCLR29() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetCLR0_PINCLR30(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetCLR0_PINCLR30() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetCLR0_PINCLR31(value uint32) {
	volatile.StoreUint32(&o.CLR0.Reg, volatile.LoadUint32(&o.CLR0.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetCLR0_PINCLR31() uint32 {
	return (volatile.LoadUint32(&o.CLR0.Reg) & 0x80000000) >> 31
}

// GPIO.DIR1: GPIO Port Direction control register.
func (o *GPIO_Type) SetDIR1_PINDIR0(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR1_PINDIR0() uint32 {
	return volatile.LoadUint32(&o.DIR1.Reg) & 0x1
}
func (o *GPIO_Type) SetDIR1_PINDIR1(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR1_PINDIR1() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR1_PINDIR2(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR1_PINDIR2() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR1_PINDIR3(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR1_PINDIR3() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR1_PINDIR4(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR1_PINDIR4() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR1_PINDIR5(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR1_PINDIR5() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR1_PINDIR6(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR1_PINDIR6() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR1_PINDIR7(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR1_PINDIR7() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR1_PINDIR8(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR1_PINDIR8() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR1_PINDIR9(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR1_PINDIR9() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR1_PINDIR10(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR1_PINDIR10() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR1_PINDIR11(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR1_PINDIR11() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR1_PINDIR12(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR1_PINDIR12() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR1_PINDIR13(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR1_PINDIR13() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR1_PINDIR14(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR1_PINDIR14() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR1_PINDIR15(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR1_PINDIR15() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR1_PINDIR16(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR1_PINDIR16() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR1_PINDIR17(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR1_PINDIR17() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR1_PINDIR18(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR1_PINDIR18() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR1_PINDIR19(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR1_PINDIR19() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR1_PINDIR20(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR1_PINDIR20() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR1_PINDIR21(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR1_PINDIR21() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR1_PINDIR22(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR1_PINDIR22() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR1_PINDIR23(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR1_PINDIR23() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR1_PINDIR24(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR1_PINDIR24() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR1_PINDIR25(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR1_PINDIR25() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR1_PINDIR26(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR1_PINDIR26() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR1_PINDIR27(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR1_PINDIR27() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR1_PINDIR28(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR1_PINDIR28() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR1_PINDIR29(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR1_PINDIR29() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR1_PINDIR30(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR1_PINDIR30() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR1_PINDIR31(value uint32) {
	volatile.StoreUint32(&o.DIR1.Reg, volatile.LoadUint32(&o.DIR1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR1_PINDIR31() uint32 {
	return (volatile.LoadUint32(&o.DIR1.Reg) & 0x80000000) >> 31
}

// GPIO.MASK1: Mask register for Port.
func (o *GPIO_Type) SetMASK1_PINMASK0(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetMASK1_PINMASK0() uint32 {
	return volatile.LoadUint32(&o.MASK1.Reg) & 0x1
}
func (o *GPIO_Type) SetMASK1_PINMASK1(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetMASK1_PINMASK1() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetMASK1_PINMASK2(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetMASK1_PINMASK2() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetMASK1_PINMASK3(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetMASK1_PINMASK3() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetMASK1_PINMASK4(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetMASK1_PINMASK4() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetMASK1_PINMASK5(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetMASK1_PINMASK5() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetMASK1_PINMASK6(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetMASK1_PINMASK6() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetMASK1_PINMASK7(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetMASK1_PINMASK7() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetMASK1_PINMASK8(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetMASK1_PINMASK8() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetMASK1_PINMASK9(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetMASK1_PINMASK9() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetMASK1_PINMASK10(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetMASK1_PINMASK10() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetMASK1_PINMASK11(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetMASK1_PINMASK11() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetMASK1_PINMASK12(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetMASK1_PINMASK12() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetMASK1_PINMASK13(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetMASK1_PINMASK13() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetMASK1_PINMASK14(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetMASK1_PINMASK14() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetMASK1_PINMASK15(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetMASK1_PINMASK15() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetMASK1_PINMASK16(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetMASK1_PINMASK16() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetMASK1_PINMASK17(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetMASK1_PINMASK17() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetMASK1_PINMASK18(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetMASK1_PINMASK18() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetMASK1_PINMASK19(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetMASK1_PINMASK19() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetMASK1_PINMASK20(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetMASK1_PINMASK20() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetMASK1_PINMASK21(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetMASK1_PINMASK21() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetMASK1_PINMASK22(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetMASK1_PINMASK22() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetMASK1_PINMASK23(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetMASK1_PINMASK23() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetMASK1_PINMASK24(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetMASK1_PINMASK24() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetMASK1_PINMASK25(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetMASK1_PINMASK25() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetMASK1_PINMASK26(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetMASK1_PINMASK26() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetMASK1_PINMASK27(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetMASK1_PINMASK27() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetMASK1_PINMASK28(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetMASK1_PINMASK28() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetMASK1_PINMASK29(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetMASK1_PINMASK29() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetMASK1_PINMASK30(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetMASK1_PINMASK30() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetMASK1_PINMASK31(value uint32) {
	volatile.StoreUint32(&o.MASK1.Reg, volatile.LoadUint32(&o.MASK1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetMASK1_PINMASK31() uint32 {
	return (volatile.LoadUint32(&o.MASK1.Reg) & 0x80000000) >> 31
}

// GPIO.PIN1: Port Pin value register using FIOMASK.
func (o *GPIO_Type) SetPIN1_PINVAL0(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN1_PINVAL0() uint32 {
	return volatile.LoadUint32(&o.PIN1.Reg) & 0x1
}
func (o *GPIO_Type) SetPIN1_PINVAL1(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN1_PINVAL1() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN1_PINVAL2(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetPIN1_PINVAL2() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetPIN1_PINVAL3(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetPIN1_PINVAL3() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetPIN1_PINVAL4(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetPIN1_PINVAL4() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetPIN1_PINVAL5(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetPIN1_PINVAL5() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetPIN1_PINVAL6(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetPIN1_PINVAL6() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetPIN1_PINVAL7(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetPIN1_PINVAL7() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetPIN1_PINVAL8(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetPIN1_PINVAL8() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetPIN1_PINVAL9(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetPIN1_PINVAL9() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetPIN1_PINVAL10(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetPIN1_PINVAL10() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetPIN1_PINVAL11(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetPIN1_PINVAL11() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetPIN1_PINVAL12(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetPIN1_PINVAL12() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetPIN1_PINVAL13(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetPIN1_PINVAL13() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetPIN1_PINVAL14(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetPIN1_PINVAL14() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetPIN1_PINVAL15(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetPIN1_PINVAL15() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetPIN1_PINVAL16(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetPIN1_PINVAL16() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetPIN1_PINVAL17(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetPIN1_PINVAL17() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetPIN1_PINVAL18(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetPIN1_PINVAL18() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetPIN1_PINVAL19(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetPIN1_PINVAL19() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetPIN1_PINVAL20(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetPIN1_PINVAL20() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetPIN1_PINVAL21(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetPIN1_PINVAL21() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetPIN1_PINVAL22(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetPIN1_PINVAL22() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetPIN1_PINVAL23(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetPIN1_PINVAL23() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetPIN1_PINVAL24(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetPIN1_PINVAL24() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetPIN1_PINVAL25(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetPIN1_PINVAL25() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetPIN1_PINVAL26(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetPIN1_PINVAL26() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetPIN1_PINVAL27(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetPIN1_PINVAL27() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetPIN1_PINVAL28(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetPIN1_PINVAL28() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetPIN1_PINVAL29(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetPIN1_PINVAL29() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetPIN1_PINVAL30(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetPIN1_PINVAL30() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetPIN1_PINVAL31(value uint32) {
	volatile.StoreUint32(&o.PIN1.Reg, volatile.LoadUint32(&o.PIN1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetPIN1_PINVAL31() uint32 {
	return (volatile.LoadUint32(&o.PIN1.Reg) & 0x80000000) >> 31
}

// GPIO.SET1: Port Output Set register using FIOMASK.
func (o *GPIO_Type) SetSET1_PINSET0(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetSET1_PINSET0() uint32 {
	return volatile.LoadUint32(&o.SET1.Reg) & 0x1
}
func (o *GPIO_Type) SetSET1_PINSET1(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetSET1_PINSET1() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetSET1_PINSET2(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetSET1_PINSET2() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetSET1_PINSET3(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetSET1_PINSET3() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetSET1_PINSET4(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetSET1_PINSET4() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetSET1_PINSET5(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetSET1_PINSET5() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetSET1_PINSET6(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetSET1_PINSET6() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetSET1_PINSET7(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetSET1_PINSET7() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetSET1_PINSET8(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetSET1_PINSET8() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetSET1_PINSET9(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetSET1_PINSET9() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetSET1_PINSET10(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetSET1_PINSET10() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetSET1_PINSET11(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetSET1_PINSET11() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetSET1_PINSET12(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetSET1_PINSET12() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetSET1_PINSET13(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetSET1_PINSET13() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetSET1_PINSET14(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetSET1_PINSET14() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetSET1_PINSET15(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetSET1_PINSET15() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetSET1_PINSET16(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetSET1_PINSET16() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetSET1_PINSET17(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetSET1_PINSET17() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetSET1_PINSET18(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetSET1_PINSET18() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetSET1_PINSET19(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetSET1_PINSET19() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetSET1_PINSET20(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetSET1_PINSET20() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetSET1_PINSET21(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetSET1_PINSET21() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetSET1_PINSET22(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetSET1_PINSET22() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetSET1_PINSET23(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetSET1_PINSET23() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetSET1_PINSET24(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetSET1_PINSET24() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetSET1_PINSET25(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetSET1_PINSET25() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetSET1_PINSET26(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetSET1_PINSET26() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetSET1_PINSET27(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetSET1_PINSET27() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetSET1_PINSET28(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetSET1_PINSET28() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetSET1_PINSET29(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetSET1_PINSET29() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetSET1_PINSET30(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetSET1_PINSET30() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetSET1_PINSET31(value uint32) {
	volatile.StoreUint32(&o.SET1.Reg, volatile.LoadUint32(&o.SET1.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetSET1_PINSET31() uint32 {
	return (volatile.LoadUint32(&o.SET1.Reg) & 0x80000000) >> 31
}

// GPIO.CLR1: Port Output Clear register using FIOMASK.
func (o *GPIO_Type) SetCLR1_PINCLR0(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetCLR1_PINCLR0() uint32 {
	return volatile.LoadUint32(&o.CLR1.Reg) & 0x1
}
func (o *GPIO_Type) SetCLR1_PINCLR1(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetCLR1_PINCLR1() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetCLR1_PINCLR2(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetCLR1_PINCLR2() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetCLR1_PINCLR3(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetCLR1_PINCLR3() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetCLR1_PINCLR4(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetCLR1_PINCLR4() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetCLR1_PINCLR5(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetCLR1_PINCLR5() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetCLR1_PINCLR6(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetCLR1_PINCLR6() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetCLR1_PINCLR7(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetCLR1_PINCLR7() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetCLR1_PINCLR8(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetCLR1_PINCLR8() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetCLR1_PINCLR9(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetCLR1_PINCLR9() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetCLR1_PINCLR10(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetCLR1_PINCLR10() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetCLR1_PINCLR11(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, volatile.LoadUint32(&o.CLR1.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetCLR1_PINCLR11() uint32 {
	return (volatile.LoadUint32(&o.CLR1.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetCLR1_PINCLR12(value uint32) {
	volatile.StoreUint32(&o.CLR1.Reg, 