// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32f301.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32f301
// +build stm32,stm32f301

// STM32F301
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32F301"
	CPU          = "CM4"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Window watchdog
	IRQ_WWDG_IRQ = 0

	// Power control
	IRQ_PVD = 1

	// External interrupt/event controller
	IRQ_TAMP_STAMP = 2

	// Real-time clock
	IRQ_RTC_WKUP_IRQ = 3

	// Flash
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2_TSC = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	// DMA controller 1
	IRQ_DMA1_CH1 = 11

	// DMA controller 1
	IRQ_DMA1_CH2 = 12

	// DMA controller 1
	IRQ_DMA1_CH3 = 13

	// DMA controller 1
	IRQ_DMA1_CH4 = 14

	// DMA controller 1
	IRQ_DMA1_CH5 = 15

	// DMA controller 1
	IRQ_DMA1_CH6 = 16

	// DMA controller 1
	IRQ_DMA1_CH7 = 17

	// Analog to digital converter
	IRQ_ADC1_IRQ = 18

	// Controller area network
	IRQ_CAN_TX_IRQ = 19

	// Controller area network
	IRQ_CAN_RXD_IRQ = 20

	// Controller area network
	IRQ_CAN_RXI_IRQ = 21

	// Controller area network
	IRQ_CAN_SCE_IRQ = 22

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// General purpose timers
	IRQ_TIM15_IRQ = 24

	// General-purpose-timers
	IRQ_TIM16_IRQ = 25

	IRQ_TIM17_IRQ = 26

	// Advanced timer
	IRQ_TIM1_CC = 27

	IRQ_TIM18_DAC3_IRQ = 27

	// General purpose timer
	IRQ_TIM2 = 28

	// Inter-integrated circuit
	IRQ_I2C1_EV_IRQ = 31

	// External interrupt/event controller
	IRQ_I2C1_EV_EXTI23 = 31

	// Inter-integrated circuit
	IRQ_I2C1_ER_IRQ = 32

	IRQ_I2C2_EV_IRQ = 33

	IRQ_I2C2_ER_IRQ = 34

	// Serial peripheral interface/Inter-IC sound
	IRQ_SPI1_IRQ = 35

	IRQ_SPI2_IRQ = 36

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1_IRQ = 37

	// External interrupt/event controller
	IRQ_USART1_EXTI25 = 37

	// External interrupt/event controller
	IRQ_USART2_EXTI26 = 38

	IRQ_USART2_IRQ = 38

	// External interrupt/event controller
	IRQ_USART3_EXTI28 = 39

	IRQ_USART3_IRQ = 39

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// Real-time clock
	IRQ_RTC_ALARM_IT_IRQ = 41

	// HDMI-CEC controller
	IRQ_CEC_IRQ = 42

	// General purpose timers
	IRQ_TIM12_IRQ = 43

	// General purpose timers
	IRQ_TIM13_IRQ = 44

	IRQ_TIM14_IRQ = 45

	IRQ_SPI3_IRQ = 51

	// Basic timers
	IRQ_TIM6_DAC1 = 54

	IRQ_TIM7_IRQ = 55

	// Sigma-delta analog-to-digital converter
	IRQ_ADC_SD1_IRQ = 61

	IRQ_ADC_SD2_IRQ = 62

	IRQ_ADC_SD3_IRQ = 63

	// General purpose comparators
	IRQ_COMP1_2_3 = 64

	// General purpose comparators
	IRQ_COMP4_5_6 = 65

	IRQ_I2C3_EV_IRQ = 72

	IRQ_I2C3_ER_IRQ = 73

	// Universal serial bus full-speed device interface
	IRQ_USB_HP_IRQ = 74

	// Universal serial bus full-speed device interface
	IRQ_USB_LP_IRQ = 75

	// Universal serial bus full-speed device interface
	IRQ_USB_WAKEUP_IRQ = 76

	// External interrupt/event controller
	IRQ_USB_WKUP_EXTI = 76

	// Floting point unit
	IRQ_FPU = 81

	// Highest interrupt number on this device.
	IRQ_max = 81
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQ_IRQHandler
func interruptWWDG_IRQ() {
	callHandlers(IRQ_WWDG_IRQ)
}

//export PVD_IRQHandler
func interruptPVD() {
	callHandlers(IRQ_PVD)
}

//export TAMP_STAMP_IRQHandler
func interruptTAMP_STAMP() {
	callHandlers(IRQ_TAMP_STAMP)
}

//export RTC_WKUP_IRQ_IRQHandler
func interruptRTC_WKUP_IRQ() {
	callHandlers(IRQ_RTC_WKUP_IRQ)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_TSC_IRQHandler
func interruptEXTI2_TSC() {
	callHandlers(IRQ_EXTI2_TSC)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA1_CH1_IRQHandler
func interruptDMA1_CH1() {
	callHandlers(IRQ_DMA1_CH1)
}

//export DMA1_CH2_IRQHandler
func interruptDMA1_CH2() {
	callHandlers(IRQ_DMA1_CH2)
}

//export DMA1_CH3_IRQHandler
func interruptDMA1_CH3() {
	callHandlers(IRQ_DMA1_CH3)
}

//export DMA1_CH4_IRQHandler
func interruptDMA1_CH4() {
	callHandlers(IRQ_DMA1_CH4)
}

//export DMA1_CH5_IRQHandler
func interruptDMA1_CH5() {
	callHandlers(IRQ_DMA1_CH5)
}

//export DMA1_CH6_IRQHandler
func interruptDMA1_CH6() {
	callHandlers(IRQ_DMA1_CH6)
}

//export DMA1_CH7_IRQHandler
func interruptDMA1_CH7() {
	callHandlers(IRQ_DMA1_CH7)
}

//export ADC1_IRQ_IRQHandler
func interruptADC1_IRQ() {
	callHandlers(IRQ_ADC1_IRQ)
}

//export CAN_TX_IRQ_IRQHandler
func interruptCAN_TX_IRQ() {
	callHandlers(IRQ_CAN_TX_IRQ)
}

//export CAN_RXD_IRQ_IRQHandler
func interruptCAN_RXD_IRQ() {
	callHandlers(IRQ_CAN_RXD_IRQ)
}

//export CAN_RXI_IRQ_IRQHandler
func interruptCAN_RXI_IRQ() {
	callHandlers(IRQ_CAN_RXI_IRQ)
}

//export CAN_SCE_IRQ_IRQHandler
func interruptCAN_SCE_IRQ() {
	callHandlers(IRQ_CAN_SCE_IRQ)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export TIM15_IRQ_IRQHandler
func interruptTIM15_IRQ() {
	callHandlers(IRQ_TIM15_IRQ)
}

//export TIM16_IRQ_IRQHandler
func interruptTIM16_IRQ() {
	callHandlers(IRQ_TIM16_IRQ)
}

//export TIM17_IRQ_IRQHandler
func interruptTIM17_IRQ() {
	callHandlers(IRQ_TIM17_IRQ)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM18_DAC3_IRQ_IRQHandler
func interruptTIM18_DAC3_IRQ() {
	callHandlers(IRQ_TIM18_DAC3_IRQ)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export I2C1_EV_IRQ_IRQHandler
func interruptI2C1_EV_IRQ() {
	callHandlers(IRQ_I2C1_EV_IRQ)
}

//export I2C1_EV_EXTI23_IRQHandler
func interruptI2C1_EV_EXTI23() {
	callHandlers(IRQ_I2C1_EV_EXTI23)
}

//export I2C1_ER_IRQ_IRQHandler
func interruptI2C1_ER_IRQ() {
	callHandlers(IRQ_I2C1_ER_IRQ)
}

//export I2C2_EV_IRQ_IRQHandler
func interruptI2C2_EV_IRQ() {
	callHandlers(IRQ_I2C2_EV_IRQ)
}

//export I2C2_ER_IRQ_IRQHandler
func interruptI2C2_ER_IRQ() {
	callHandlers(IRQ_I2C2_ER_IRQ)
}

//export SPI1_IRQ_IRQHandler
func interruptSPI1_IRQ() {
	callHandlers(IRQ_SPI1_IRQ)
}

//export SPI2_IRQ_IRQHandler
func interruptSPI2_IRQ() {
	callHandlers(IRQ_SPI2_IRQ)
}

//export USART1_IRQ_IRQHandler
func interruptUSART1_IRQ() {
	callHandlers(IRQ_USART1_IRQ)
}

//export USART1_EXTI25_IRQHandler
func interruptUSART1_EXTI25() {
	callHandlers(IRQ_USART1_EXTI25)
}

//export USART2_EXTI26_IRQHandler
func interruptUSART2_EXTI26() {
	callHandlers(IRQ_USART2_EXTI26)
}

//export USART2_IRQ_IRQHandler
func interruptUSART2_IRQ() {
	callHandlers(IRQ_USART2_IRQ)
}

//export USART3_EXTI28_IRQHandler
func interruptUSART3_EXTI28() {
	callHandlers(IRQ_USART3_EXTI28)
}

//export USART3_IRQ_IRQHandler
func interruptUSART3_IRQ() {
	callHandlers(IRQ_USART3_IRQ)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export RTC_ALARM_IT_IRQ_IRQHandler
func interruptRTC_ALARM_IT_IRQ() {
	callHandlers(IRQ_RTC_ALARM_IT_IRQ)
}

//export CEC_IRQ_IRQHandler
func interruptCEC_IRQ() {
	callHandlers(IRQ_CEC_IRQ)
}

//export TIM12_IRQ_IRQHandler
func interruptTIM12_IRQ() {
	callHandlers(IRQ_TIM12_IRQ)
}

//export TIM13_IRQ_IRQHandler
func interruptTIM13_IRQ() {
	callHandlers(IRQ_TIM13_IRQ)
}

//export TIM14_IRQ_IRQHandler
func interruptTIM14_IRQ() {
	callHandlers(IRQ_TIM14_IRQ)
}

//export SPI3_IRQ_IRQHandler
func interruptSPI3_IRQ() {
	callHandlers(IRQ_SPI3_IRQ)
}

//export TIM6_DAC1_IRQHandler
func interruptTIM6_DAC1() {
	callHandlers(IRQ_TIM6_DAC1)
}

//export TIM7_IRQ_IRQHandler
func interruptTIM7_IRQ() {
	callHandlers(IRQ_TIM7_IRQ)
}

//export ADC_SD1_IRQ_IRQHandler
func interruptADC_SD1_IRQ() {
	callHandlers(IRQ_ADC_SD1_IRQ)
}

//export ADC_SD2_IRQ_IRQHandler
func interruptADC_SD2_IRQ() {
	callHandlers(IRQ_ADC_SD2_IRQ)
}

//export ADC_SD3_IRQ_IRQHandler
func interruptADC_SD3_IRQ() {
	callHandlers(IRQ_ADC_SD3_IRQ)
}

//export COMP1_2_3_IRQHandler
func interruptCOMP1_2_3() {
	callHandlers(IRQ_COMP1_2_3)
}

//export COMP4_5_6_IRQHandler
func interruptCOMP4_5_6() {
	callHandlers(IRQ_COMP4_5_6)
}

//export I2C3_EV_IRQ_IRQHandler
func interruptI2C3_EV_IRQ() {
	callHandlers(IRQ_I2C3_EV_IRQ)
}

//export I2C3_ER_IRQ_IRQHandler
func interruptI2C3_ER_IRQ() {
	callHandlers(IRQ_I2C3_ER_IRQ)
}

//export USB_HP_IRQ_IRQHandler
func interruptUSB_HP_IRQ() {
	callHandlers(IRQ_USB_HP_IRQ)
}

//export USB_LP_IRQ_IRQHandler
func interruptUSB_LP_IRQ() {
	callHandlers(IRQ_USB_LP_IRQ)
}

//export USB_WAKEUP_IRQ_IRQHandler
func interruptUSB_WAKEUP_IRQ() {
	callHandlers(IRQ_USB_WAKEUP_IRQ)
}

//export USB_WKUP_EXTI_IRQHandler
func interruptUSB_WKUP_EXTI() {
	callHandlers(IRQ_USB_WKUP_EXTI)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

// Peripherals.
var (
	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000000)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000400)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000800)))

	// Touch sensing controller
	TSC = (*TSC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// cyclic redundancy check calculation unit
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Flash
	FLASH = (*Flash_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// DMA controller 1
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// General purpose timer
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General purpose timers
	TIM15 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General-purpose-timers
	TIM16 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Serial peripheral interface/Inter-IC sound
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Analog to digital converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// HDMI-CEC controller
	CEC = (*CEC_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Controller area network
	CAN = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))

	// Universal serial bus full-speed device interface
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Sigma-delta analog-to-digital converter
	SDADC1 = (*SDADC_Type)(unsafe.Pointer(uintptr(0x40016000)))

	// Digital-to-analog converter
	DAC2 = (*DAC2_Type)(unsafe.Pointer(uintptr(0x40009800)))

	// Basic timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// General purpose timers
	TIM13 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001c00)))

	// General purpose timers
	TIM12 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001800)))

	// Digital-to-analog converter
	DAC1 = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// Debug support
	DBGMCU = (*DBGMCU_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// ADC Common registers
	ADC1_2 = (*ADC_Type)(unsafe.Pointer(uintptr(0x50000300)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// Advanced timer
	TIM1 = (*TIMs_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Operational Amplifier
	OPAMP = (*OPAMP_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// General purpose comparators
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48000c00)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001000)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x48001400)))

	// DMA controller 1
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// General-purpose-timers
	TIM17 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Serial peripheral interface/Inter-IC sound
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface/Inter-IC sound
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Serial peripheral interface/Inter-IC sound
	I2S2ext = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003400)))

	// Serial peripheral interface/Inter-IC sound
	I2S3ext = (*SPI_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Sigma-delta analog-to-digital converter
	SDADC2 = (*SDADC_Type)(unsafe.Pointer(uintptr(0x40016400)))

	// Sigma-delta analog-to-digital converter
	SDADC3 = (*SDADC_Type)(unsafe.Pointer(uintptr(0x40016800)))

	// Basic timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Basic timers
	TIM18 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40009c00)))

	// General purpose timers
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40007800)))
)

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
	BRR     volatile.Register32 // 0x28
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: GPIO alternate function low register
func (o *GPIO_Type) SetAFRL_AFRL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFRL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFRL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFRL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFRL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFRL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFRL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFRL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFRL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFRL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFRL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFRL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFRL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFRL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFRL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFRL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFRH15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFRH15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFRH14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFRH14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFRH13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFRH13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFRH12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFRH12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFRH11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFRH11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFRH10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFRH10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFRH9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFRH9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFRH8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFRH8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// GPIO.BRR: Port bit reset register
func (o *GPIO_Type) SetBRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBRR_BR0() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0x1
}
func (o *GPIO_Type) SetBRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BRR.Reg) & 0x8000) >> 15
}

// Touch sensing controller
type TSC_Type struct {
	CR     volatile.Register32 // 0x0
	IER    volatile.Register32 // 0x4
	ICR    volatile.Register32 // 0x8
	ISR    volatile.Register32 // 0xC
	IOHCR  volatile.Register32 // 0x10
	_      [4]byte
	IOASCR volatile.Register32 // 0x18
	_      [4]byte
	IOSCR  volatile.Register32 // 0x20
	_      [4]byte
	IOCCR  volatile.Register32 // 0x28
	_      [4]byte
	IOGCSR volatile.Register32 // 0x30
	IOG1CR volatile.Register32 // 0x34
	IOG2CR volatile.Register32 // 0x38
	IOG3CR volatile.Register32 // 0x3C
	IOG4CR volatile.Register32 // 0x40
	IOG5CR volatile.Register32 // 0x44
	IOG6CR volatile.Register32 // 0x48
	IOG7CR volatile.Register32 // 0x4C
	IOG8CR volatile.Register32 // 0x50
}

// TSC.CR: control register
func (o *TSC_Type) SetCR_CTPH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf0000000)|value<<28)
}
func (o *TSC_Type) GetCR_CTPH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf0000000) >> 28
}
func (o *TSC_Type) SetCR_CTPL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *TSC_Type) GetCR_CTPL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *TSC_Type) SetCR_SSD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xfe0000)|value<<17)
}
func (o *TSC_Type) GetCR_SSD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xfe0000) >> 17
}
func (o *TSC_Type) SetCR_SSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetCR_SSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetCR_SSPSC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetCR_SSPSC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetCR_PGPSC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7000)|value<<12)
}
func (o *TSC_Type) GetCR_PGPSC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x7000) >> 12
}
func (o *TSC_Type) SetCR_MCV(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe0)|value<<5)
}
func (o *TSC_Type) GetCR_MCV() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe0) >> 5
}
func (o *TSC_Type) SetCR_IODEF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetCR_IODEF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetCR_SYNCPOL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetCR_SYNCPOL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetCR_AM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetCR_AM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetCR_TSCE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetCR_TSCE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// TSC.IER: interrupt enable register
func (o *TSC_Type) SetIER_MCEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIER_MCEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIER_EOAIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIER_EOAIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// TSC.ICR: interrupt clear register
func (o *TSC_Type) SetICR_MCEIC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetICR_MCEIC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetICR_EOAIC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetICR_EOAIC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// TSC.ISR: interrupt status register
func (o *TSC_Type) SetISR_MCEF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetISR_MCEF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetISR_EOAF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetISR_EOAF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// TSC.IOHCR: I/O hysteresis control register
func (o *TSC_Type) SetIOHCR_G1_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOHCR_G1_IO1() uint32 {
	return volatile.LoadUint32(&o.IOHCR.Reg) & 0x1
}
func (o *TSC_Type) SetIOHCR_G1_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOHCR_G1_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOHCR_G1_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOHCR_G1_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOHCR_G1_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOHCR_G1_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOHCR_G2_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOHCR_G2_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOHCR_G2_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOHCR_G2_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOHCR_G2_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOHCR_G2_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOHCR_G2_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOHCR_G2_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOHCR_G3_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x100)|value<<8)
}
func (o *TSC_Type) GetIOHCR_G3_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x100) >> 8
}
func (o *TSC_Type) SetIOHCR_G3_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x200)|value<<9)
}
func (o *TSC_Type) GetIOHCR_G3_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x200) >> 9
}
func (o *TSC_Type) SetIOHCR_G3_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x400)|value<<10)
}
func (o *TSC_Type) GetIOHCR_G3_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x400) >> 10
}
func (o *TSC_Type) SetIOHCR_G3_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x800)|value<<11)
}
func (o *TSC_Type) GetIOHCR_G3_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x800) >> 11
}
func (o *TSC_Type) SetIOHCR_G4_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x1000)|value<<12)
}
func (o *TSC_Type) GetIOHCR_G4_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x1000) >> 12
}
func (o *TSC_Type) SetIOHCR_G4_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x2000)|value<<13)
}
func (o *TSC_Type) GetIOHCR_G4_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x2000) >> 13
}
func (o *TSC_Type) SetIOHCR_G4_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x4000)|value<<14)
}
func (o *TSC_Type) GetIOHCR_G4_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x4000) >> 14
}
func (o *TSC_Type) SetIOHCR_G4_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetIOHCR_G4_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetIOHCR_G5_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOHCR_G5_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOHCR_G5_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOHCR_G5_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOHCR_G5_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOHCR_G5_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOHCR_G5_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOHCR_G5_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOHCR_G6_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOHCR_G6_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOHCR_G6_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOHCR_G6_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOHCR_G6_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOHCR_G6_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOHCR_G6_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOHCR_G6_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOHCR_G7_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSC_Type) GetIOHCR_G7_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x1000000) >> 24
}
func (o *TSC_Type) SetIOHCR_G7_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSC_Type) GetIOHCR_G7_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x2000000) >> 25
}
func (o *TSC_Type) SetIOHCR_G7_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSC_Type) GetIOHCR_G7_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x4000000) >> 26
}
func (o *TSC_Type) SetIOHCR_G7_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x8000000)|value<<27)
}
func (o *TSC_Type) GetIOHCR_G7_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x8000000) >> 27
}
func (o *TSC_Type) SetIOHCR_G8_IO1(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x10000000)|value<<28)
}
func (o *TSC_Type) GetIOHCR_G8_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x10000000) >> 28
}
func (o *TSC_Type) SetIOHCR_G8_IO2(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x20000000)|value<<29)
}
func (o *TSC_Type) GetIOHCR_G8_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x20000000) >> 29
}
func (o *TSC_Type) SetIOHCR_G8_IO3(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x40000000)|value<<30)
}
func (o *TSC_Type) GetIOHCR_G8_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x40000000) >> 30
}
func (o *TSC_Type) SetIOHCR_G8_IO4(value uint32) {
	volatile.StoreUint32(&o.IOHCR.Reg, volatile.LoadUint32(&o.IOHCR.Reg)&^(0x80000000)|value<<31)
}
func (o *TSC_Type) GetIOHCR_G8_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOHCR.Reg) & 0x80000000) >> 31
}

// TSC.IOASCR: I/O analog switch control register
func (o *TSC_Type) SetIOASCR_G1_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOASCR_G1_IO1() uint32 {
	return volatile.LoadUint32(&o.IOASCR.Reg) & 0x1
}
func (o *TSC_Type) SetIOASCR_G1_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOASCR_G1_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOASCR_G1_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOASCR_G1_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOASCR_G1_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOASCR_G1_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOASCR_G2_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOASCR_G2_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOASCR_G2_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOASCR_G2_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOASCR_G2_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOASCR_G2_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOASCR_G2_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOASCR_G2_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOASCR_G3_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x100)|value<<8)
}
func (o *TSC_Type) GetIOASCR_G3_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x100) >> 8
}
func (o *TSC_Type) SetIOASCR_G3_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x200)|value<<9)
}
func (o *TSC_Type) GetIOASCR_G3_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x200) >> 9
}
func (o *TSC_Type) SetIOASCR_G3_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x400)|value<<10)
}
func (o *TSC_Type) GetIOASCR_G3_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x400) >> 10
}
func (o *TSC_Type) SetIOASCR_G3_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x800)|value<<11)
}
func (o *TSC_Type) GetIOASCR_G3_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x800) >> 11
}
func (o *TSC_Type) SetIOASCR_G4_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x1000)|value<<12)
}
func (o *TSC_Type) GetIOASCR_G4_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x1000) >> 12
}
func (o *TSC_Type) SetIOASCR_G4_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x2000)|value<<13)
}
func (o *TSC_Type) GetIOASCR_G4_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x2000) >> 13
}
func (o *TSC_Type) SetIOASCR_G4_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x4000)|value<<14)
}
func (o *TSC_Type) GetIOASCR_G4_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x4000) >> 14
}
func (o *TSC_Type) SetIOASCR_G4_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetIOASCR_G4_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetIOASCR_G5_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOASCR_G5_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOASCR_G5_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOASCR_G5_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOASCR_G5_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOASCR_G5_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOASCR_G5_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOASCR_G5_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOASCR_G6_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOASCR_G6_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOASCR_G6_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOASCR_G6_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOASCR_G6_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOASCR_G6_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOASCR_G6_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOASCR_G6_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOASCR_G7_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSC_Type) GetIOASCR_G7_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x1000000) >> 24
}
func (o *TSC_Type) SetIOASCR_G7_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSC_Type) GetIOASCR_G7_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x2000000) >> 25
}
func (o *TSC_Type) SetIOASCR_G7_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSC_Type) GetIOASCR_G7_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x4000000) >> 26
}
func (o *TSC_Type) SetIOASCR_G7_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x8000000)|value<<27)
}
func (o *TSC_Type) GetIOASCR_G7_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x8000000) >> 27
}
func (o *TSC_Type) SetIOASCR_G8_IO1(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x10000000)|value<<28)
}
func (o *TSC_Type) GetIOASCR_G8_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x10000000) >> 28
}
func (o *TSC_Type) SetIOASCR_G8_IO2(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x20000000)|value<<29)
}
func (o *TSC_Type) GetIOASCR_G8_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x20000000) >> 29
}
func (o *TSC_Type) SetIOASCR_G8_IO3(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x40000000)|value<<30)
}
func (o *TSC_Type) GetIOASCR_G8_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x40000000) >> 30
}
func (o *TSC_Type) SetIOASCR_G8_IO4(value uint32) {
	volatile.StoreUint32(&o.IOASCR.Reg, volatile.LoadUint32(&o.IOASCR.Reg)&^(0x80000000)|value<<31)
}
func (o *TSC_Type) GetIOASCR_G8_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOASCR.Reg) & 0x80000000) >> 31
}

// TSC.IOSCR: I/O sampling control register
func (o *TSC_Type) SetIOSCR_G1_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOSCR_G1_IO1() uint32 {
	return volatile.LoadUint32(&o.IOSCR.Reg) & 0x1
}
func (o *TSC_Type) SetIOSCR_G1_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOSCR_G1_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOSCR_G1_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOSCR_G1_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOSCR_G1_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOSCR_G1_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOSCR_G2_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOSCR_G2_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOSCR_G2_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOSCR_G2_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOSCR_G2_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOSCR_G2_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOSCR_G2_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOSCR_G2_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOSCR_G3_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x100)|value<<8)
}
func (o *TSC_Type) GetIOSCR_G3_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x100) >> 8
}
func (o *TSC_Type) SetIOSCR_G3_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x200)|value<<9)
}
func (o *TSC_Type) GetIOSCR_G3_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x200) >> 9
}
func (o *TSC_Type) SetIOSCR_G3_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x400)|value<<10)
}
func (o *TSC_Type) GetIOSCR_G3_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x400) >> 10
}
func (o *TSC_Type) SetIOSCR_G3_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x800)|value<<11)
}
func (o *TSC_Type) GetIOSCR_G3_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x800) >> 11
}
func (o *TSC_Type) SetIOSCR_G4_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x1000)|value<<12)
}
func (o *TSC_Type) GetIOSCR_G4_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x1000) >> 12
}
func (o *TSC_Type) SetIOSCR_G4_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x2000)|value<<13)
}
func (o *TSC_Type) GetIOSCR_G4_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x2000) >> 13
}
func (o *TSC_Type) SetIOSCR_G4_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x4000)|value<<14)
}
func (o *TSC_Type) GetIOSCR_G4_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x4000) >> 14
}
func (o *TSC_Type) SetIOSCR_G4_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetIOSCR_G4_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetIOSCR_G5_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOSCR_G5_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOSCR_G5_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOSCR_G5_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOSCR_G5_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOSCR_G5_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOSCR_G5_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOSCR_G5_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOSCR_G6_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOSCR_G6_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOSCR_G6_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOSCR_G6_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOSCR_G6_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOSCR_G6_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOSCR_G6_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOSCR_G6_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOSCR_G7_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSC_Type) GetIOSCR_G7_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x1000000) >> 24
}
func (o *TSC_Type) SetIOSCR_G7_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSC_Type) GetIOSCR_G7_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x2000000) >> 25
}
func (o *TSC_Type) SetIOSCR_G7_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSC_Type) GetIOSCR_G7_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x4000000) >> 26
}
func (o *TSC_Type) SetIOSCR_G7_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x8000000)|value<<27)
}
func (o *TSC_Type) GetIOSCR_G7_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x8000000) >> 27
}
func (o *TSC_Type) SetIOSCR_G8_IO1(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x10000000)|value<<28)
}
func (o *TSC_Type) GetIOSCR_G8_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x10000000) >> 28
}
func (o *TSC_Type) SetIOSCR_G8_IO2(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x20000000)|value<<29)
}
func (o *TSC_Type) GetIOSCR_G8_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x20000000) >> 29
}
func (o *TSC_Type) SetIOSCR_G8_IO3(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x40000000)|value<<30)
}
func (o *TSC_Type) GetIOSCR_G8_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x40000000) >> 30
}
func (o *TSC_Type) SetIOSCR_G8_IO4(value uint32) {
	volatile.StoreUint32(&o.IOSCR.Reg, volatile.LoadUint32(&o.IOSCR.Reg)&^(0x80000000)|value<<31)
}
func (o *TSC_Type) GetIOSCR_G8_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOSCR.Reg) & 0x80000000) >> 31
}

// TSC.IOCCR: I/O channel control register
func (o *TSC_Type) SetIOCCR_G1_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOCCR_G1_IO1() uint32 {
	return volatile.LoadUint32(&o.IOCCR.Reg) & 0x1
}
func (o *TSC_Type) SetIOCCR_G1_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOCCR_G1_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOCCR_G1_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOCCR_G1_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOCCR_G1_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOCCR_G1_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOCCR_G2_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOCCR_G2_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOCCR_G2_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOCCR_G2_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOCCR_G2_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOCCR_G2_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOCCR_G2_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOCCR_G2_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOCCR_G3_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x100)|value<<8)
}
func (o *TSC_Type) GetIOCCR_G3_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x100) >> 8
}
func (o *TSC_Type) SetIOCCR_G3_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x200)|value<<9)
}
func (o *TSC_Type) GetIOCCR_G3_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x200) >> 9
}
func (o *TSC_Type) SetIOCCR_G3_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x400)|value<<10)
}
func (o *TSC_Type) GetIOCCR_G3_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x400) >> 10
}
func (o *TSC_Type) SetIOCCR_G3_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x800)|value<<11)
}
func (o *TSC_Type) GetIOCCR_G3_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x800) >> 11
}
func (o *TSC_Type) SetIOCCR_G4_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x1000)|value<<12)
}
func (o *TSC_Type) GetIOCCR_G4_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x1000) >> 12
}
func (o *TSC_Type) SetIOCCR_G4_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x2000)|value<<13)
}
func (o *TSC_Type) GetIOCCR_G4_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x2000) >> 13
}
func (o *TSC_Type) SetIOCCR_G4_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x4000)|value<<14)
}
func (o *TSC_Type) GetIOCCR_G4_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x4000) >> 14
}
func (o *TSC_Type) SetIOCCR_G4_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x8000)|value<<15)
}
func (o *TSC_Type) GetIOCCR_G4_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x8000) >> 15
}
func (o *TSC_Type) SetIOCCR_G5_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOCCR_G5_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOCCR_G5_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOCCR_G5_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOCCR_G5_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOCCR_G5_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOCCR_G5_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOCCR_G5_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOCCR_G6_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOCCR_G6_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOCCR_G6_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOCCR_G6_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOCCR_G6_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOCCR_G6_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOCCR_G6_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOCCR_G6_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOCCR_G7_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x1000000)|value<<24)
}
func (o *TSC_Type) GetIOCCR_G7_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x1000000) >> 24
}
func (o *TSC_Type) SetIOCCR_G7_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x2000000)|value<<25)
}
func (o *TSC_Type) GetIOCCR_G7_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x2000000) >> 25
}
func (o *TSC_Type) SetIOCCR_G7_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x4000000)|value<<26)
}
func (o *TSC_Type) GetIOCCR_G7_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x4000000) >> 26
}
func (o *TSC_Type) SetIOCCR_G7_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x8000000)|value<<27)
}
func (o *TSC_Type) GetIOCCR_G7_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x8000000) >> 27
}
func (o *TSC_Type) SetIOCCR_G8_IO1(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x10000000)|value<<28)
}
func (o *TSC_Type) GetIOCCR_G8_IO1() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x10000000) >> 28
}
func (o *TSC_Type) SetIOCCR_G8_IO2(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x20000000)|value<<29)
}
func (o *TSC_Type) GetIOCCR_G8_IO2() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x20000000) >> 29
}
func (o *TSC_Type) SetIOCCR_G8_IO3(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x40000000)|value<<30)
}
func (o *TSC_Type) GetIOCCR_G8_IO3() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x40000000) >> 30
}
func (o *TSC_Type) SetIOCCR_G8_IO4(value uint32) {
	volatile.StoreUint32(&o.IOCCR.Reg, volatile.LoadUint32(&o.IOCCR.Reg)&^(0x80000000)|value<<31)
}
func (o *TSC_Type) GetIOCCR_G8_IO4() uint32 {
	return (volatile.LoadUint32(&o.IOCCR.Reg) & 0x80000000) >> 31
}

// TSC.IOGCSR: I/O group control status register
func (o *TSC_Type) SetIOGCSR_G8S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x800000)|value<<23)
}
func (o *TSC_Type) GetIOGCSR_G8S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x800000) >> 23
}
func (o *TSC_Type) SetIOGCSR_G7S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x400000)|value<<22)
}
func (o *TSC_Type) GetIOGCSR_G7S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x400000) >> 22
}
func (o *TSC_Type) SetIOGCSR_G6S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x200000)|value<<21)
}
func (o *TSC_Type) GetIOGCSR_G6S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x200000) >> 21
}
func (o *TSC_Type) SetIOGCSR_G5S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x100000)|value<<20)
}
func (o *TSC_Type) GetIOGCSR_G5S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x100000) >> 20
}
func (o *TSC_Type) SetIOGCSR_G4S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x80000)|value<<19)
}
func (o *TSC_Type) GetIOGCSR_G4S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x80000) >> 19
}
func (o *TSC_Type) SetIOGCSR_G3S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x40000)|value<<18)
}
func (o *TSC_Type) GetIOGCSR_G3S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x40000) >> 18
}
func (o *TSC_Type) SetIOGCSR_G2S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x20000)|value<<17)
}
func (o *TSC_Type) GetIOGCSR_G2S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x20000) >> 17
}
func (o *TSC_Type) SetIOGCSR_G1S(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x10000)|value<<16)
}
func (o *TSC_Type) GetIOGCSR_G1S() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x10000) >> 16
}
func (o *TSC_Type) SetIOGCSR_G8E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x80)|value<<7)
}
func (o *TSC_Type) GetIOGCSR_G8E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x80) >> 7
}
func (o *TSC_Type) SetIOGCSR_G7E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x40)|value<<6)
}
func (o *TSC_Type) GetIOGCSR_G7E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x40) >> 6
}
func (o *TSC_Type) SetIOGCSR_G6E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x20)|value<<5)
}
func (o *TSC_Type) GetIOGCSR_G6E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x20) >> 5
}
func (o *TSC_Type) SetIOGCSR_G5E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x10)|value<<4)
}
func (o *TSC_Type) GetIOGCSR_G5E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x10) >> 4
}
func (o *TSC_Type) SetIOGCSR_G4E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x8)|value<<3)
}
func (o *TSC_Type) GetIOGCSR_G4E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x8) >> 3
}
func (o *TSC_Type) SetIOGCSR_G3E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x4)|value<<2)
}
func (o *TSC_Type) GetIOGCSR_G3E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x4) >> 2
}
func (o *TSC_Type) SetIOGCSR_G2E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x2)|value<<1)
}
func (o *TSC_Type) GetIOGCSR_G2E() uint32 {
	return (volatile.LoadUint32(&o.IOGCSR.Reg) & 0x2) >> 1
}
func (o *TSC_Type) SetIOGCSR_G1E(value uint32) {
	volatile.StoreUint32(&o.IOGCSR.Reg, volatile.LoadUint32(&o.IOGCSR.Reg)&^(0x1)|value)
}
func (o *TSC_Type) GetIOGCSR_G1E() uint32 {
	return volatile.LoadUint32(&o.IOGCSR.Reg) & 0x1
}

// TSC.IOG1CR: I/O group x counter register
func (o *TSC_Type) SetIOG1CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG1CR.Reg, volatile.LoadUint32(&o.IOG1CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG1CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG1CR.Reg) & 0x3fff
}

// TSC.IOG2CR: I/O group x counter register
func (o *TSC_Type) SetIOG2CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG2CR.Reg, volatile.LoadUint32(&o.IOG2CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG2CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG2CR.Reg) & 0x3fff
}

// TSC.IOG3CR: I/O group x counter register
func (o *TSC_Type) SetIOG3CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG3CR.Reg, volatile.LoadUint32(&o.IOG3CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG3CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG3CR.Reg) & 0x3fff
}

// TSC.IOG4CR: I/O group x counter register
func (o *TSC_Type) SetIOG4CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG4CR.Reg, volatile.LoadUint32(&o.IOG4CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG4CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG4CR.Reg) & 0x3fff
}

// TSC.IOG5CR: I/O group x counter register
func (o *TSC_Type) SetIOG5CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG5CR.Reg, volatile.LoadUint32(&o.IOG5CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG5CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG5CR.Reg) & 0x3fff
}

// TSC.IOG6CR: I/O group x counter register
func (o *TSC_Type) SetIOG6CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG6CR.Reg, volatile.LoadUint32(&o.IOG6CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG6CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG6CR.Reg) & 0x3fff
}

// TSC.IOG7CR: I/O group x counter register
func (o *TSC_Type) SetIOG7CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG7CR.Reg, volatile.LoadUint32(&o.IOG7CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG7CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG7CR.Reg) & 0x3fff
}

// TSC.IOG8CR: I/O group x counter register
func (o *TSC_Type) SetIOG8CR_CNT(value uint32) {
	volatile.StoreUint32(&o.IOG8CR.Reg, volatile.LoadUint32(&o.IOG8CR.Reg)&^(0x3fff)|value)
}
func (o *TSC_Type) GetIOG8CR_CNT() uint32 {
	return volatile.LoadUint32(&o.IOG8CR.Reg) & 0x3fff
}

// cyclic redundancy check calculation unit
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xff)|value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0xff
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *CRC_Type) SetCR_POLYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *CRC_Type) GetCR_POLYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *CRC_Type) SetCR_REV_IN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *CRC_Type) GetCR_REV_IN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *CRC_Type) SetCR_REV_OUT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCR_REV_OUT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// CRC.INIT: Initial CRC value
func (o *CRC_Type) SetINIT(value uint32) {
	volatile.StoreUint32(&o.INIT.Reg, value)
}
func (o *CRC_Type) GetINIT() uint32 {
	return volatile.LoadUint32(&o.INIT.Reg)
}

// CRC.POL: CRC polynomial
func (o *CRC_Type) SetPOL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, value)
}
func (o *CRC_Type) GetPOL() uint32 {
	return volatile.LoadUint32(&o.POL.Reg)
}

// Flash
type Flash_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	AR      volatile.Register32 // 0x14
	_       [4]byte
	OBR     volatile.Register32 // 0x1C
	WRPR    volatile.Register32 // 0x20
}

// Flash.ACR: Flash access control register
func (o *Flash_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x7)|value)
}
func (o *Flash_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0x7
}
func (o *Flash_Type) SetACR_PRFTBE(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetACR_PRFTBE() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x10) >> 4
}
func (o *Flash_Type) SetACR_PRFTBS(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x20)|value<<5)
}
func (o *Flash_Type) GetACR_PRFTBS() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x20) >> 5
}
func (o *Flash_Type) SetACR_HLFCYA(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x8)|value<<3)
}
func (o *Flash_Type) GetACR_HLFCYA() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x8) >> 3
}

// Flash.KEYR: Flash key register
func (o *Flash_Type) SetKEYR(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, value)
}
func (o *Flash_Type) GetKEYR() uint32 {
	return volatile.LoadUint32(&o.KEYR.Reg)
}

// Flash.OPTKEYR: Flash option key register
func (o *Flash_Type) SetOPTKEYR(value uint32) {
	volatile.StoreUint32(&o.OPTKEYR.Reg, value)
}
func (o *Flash_Type) GetOPTKEYR() uint32 {
	return volatile.LoadUint32(&o.OPTKEYR.Reg)
}

// Flash.SR: Flash status register
func (o *Flash_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *Flash_Type) GetSR_EOP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *Flash_Type) SetSR_WRPRTERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetSR_WRPRTERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *Flash_Type) SetSR_PGERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetSR_PGERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetSR_BSY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Flash.CR: Flash control register
func (o *Flash_Type) SetCR_OBL_LAUNCH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetCR_OBL_LAUNCH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetCR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetCR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *Flash_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *Flash_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *Flash_Type) SetCR_OPTWRE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetCR_OPTWRE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetCR_LOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *Flash_Type) GetCR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *Flash_Type) SetCR_STRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *Flash_Type) GetCR_STRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *Flash_Type) SetCR_OPTER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *Flash_Type) GetCR_OPTER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *Flash_Type) SetCR_OPTPG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *Flash_Type) GetCR_OPTPG() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *Flash_Type) SetCR_MER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *Flash_Type) GetCR_MER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *Flash_Type) SetCR_PER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *Flash_Type) GetCR_PER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *Flash_Type) SetCR_PG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetCR_PG() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// Flash.AR: Flash address register
func (o *Flash_Type) SetAR(value uint32) {
	volatile.StoreUint32(&o.AR.Reg, value)
}
func (o *Flash_Type) GetAR() uint32 {
	return volatile.LoadUint32(&o.AR.Reg)
}

// Flash.OBR: Option byte register
func (o *Flash_Type) SetOBR_OPTERR(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0x1)|value)
}
func (o *Flash_Type) GetOBR_OPTERR() uint32 {
	return volatile.LoadUint32(&o.OBR.Reg) & 0x1
}
func (o *Flash_Type) SetOBR_RDPRT(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0x6)|value<<1)
}
func (o *Flash_Type) GetOBR_RDPRT() uint32 {
	return (volatile.LoadUint32(&o.OBR.Reg) & 0x6) >> 1
}
func (o *Flash_Type) SetOBR_WDG_SW(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0x100)|value<<8)
}
func (o *Flash_Type) GetOBR_WDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OBR.Reg) & 0x100) >> 8
}
func (o *Flash_Type) SetOBR_NRST_STOP(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0x200)|value<<9)
}
func (o *Flash_Type) GetOBR_NRST_STOP() uint32 {
	return (volatile.LoadUint32(&o.OBR.Reg) & 0x200) >> 9
}
func (o *Flash_Type) SetOBR_NRST_STDBY(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0x400)|value<<10)
}
func (o *Flash_Type) GetOBR_NRST_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OBR.Reg) & 0x400) >> 10
}
func (o *Flash_Type) SetOBR_NBOOT1(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0x1000)|value<<12)
}
func (o *Flash_Type) GetOBR_NBOOT1() uint32 {
	return (volatile.LoadUint32(&o.OBR.Reg) & 0x1000) >> 12
}
func (o *Flash_Type) SetOBR_VDDA_MONITOR(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0x2000)|value<<13)
}
func (o *Flash_Type) GetOBR_VDDA_MONITOR() uint32 {
	return (volatile.LoadUint32(&o.OBR.Reg) & 0x2000) >> 13
}
func (o *Flash_Type) SetOBR_Data0(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0xff0000)|value<<16)
}
func (o *Flash_Type) GetOBR_Data0() uint32 {
	return (volatile.LoadUint32(&o.OBR.Reg) & 0xff0000) >> 16
}
func (o *Flash_Type) SetOBR_Data1(value uint32) {
	volatile.StoreUint32(&o.OBR.Reg, volatile.LoadUint32(&o.OBR.Reg)&^(0xff000000)|value<<24)
}
func (o *Flash_Type) GetOBR_Data1() uint32 {
	return (volatile.LoadUint32(&o.OBR.Reg) & 0xff000000) >> 24
}

// Flash.WRPR: Write protection register
func (o *Flash_Type) SetWRPR(value uint32) {
	volatile.StoreUint32(&o.WRPR.Reg, value)
}
func (o *Flash_Type) GetWRPR() uint32 {
	return volatile.LoadUint32(&o.WRPR.Reg)
}

// Reset and clock control
type RCC_Type struct {
	CR       volatile.Register32 // 0x0
	CFGR     volatile.Register32 // 0x4
	CIR      volatile.Register32 // 0x8
	APB2RSTR volatile.Register32 // 0xC
	APB1RSTR volatile.Register32 // 0x10
	AHBENR   volatile.Register32 // 0x14
	APB2ENR  volatile.Register32 // 0x18
	APB1ENR  volatile.Register32 // 0x1C
	BDCR     volatile.Register32 // 0x20
	CSR      volatile.Register32 // 0x24
	AHBRSTR  volatile.Register32 // 0x28
	CFGR2    volatile.Register32 // 0x2C
	CFGR3    volatile.Register32 // 0x30
}

// RCC.CR: Clock control register
func (o *RCC_Type) SetCR_HSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCR_HSION() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RCC_Type) SetCR_HSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCR_HSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCR_HSITRIM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf8)|value<<3)
}
func (o *RCC_Type) GetCR_HSITRIM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf8) >> 3
}
func (o *RCC_Type) SetCR_HSICAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff00)|value<<8)
}
func (o *RCC_Type) GetCR_HSICAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff00) >> 8
}
func (o *RCC_Type) SetCR_HSEON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCR_HSEON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCR_HSERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCR_HSERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCR_HSEBYP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCR_HSEBYP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCR_CSSON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCR_CSSON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCR_PLLON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCR_PLLON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCR_PLLRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCR_PLLRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}

// RCC.CFGR: Clock configuration register (RCC_CFGR)
func (o *RCC_Type) SetCFGR_SW(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCFGR_SW() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x3
}
func (o *RCC_Type) SetCFGR_SWS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCFGR_SWS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetCFGR_HPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCFGR_HPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCFGR_PPRE1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x700)|value<<8)
}
func (o *RCC_Type) GetCFGR_PPRE1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x700) >> 8
}
func (o *RCC_Type) SetCFGR_PPRE2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3800)|value<<11)
}
func (o *RCC_Type) GetCFGR_PPRE2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3800) >> 11
}
func (o *RCC_Type) SetCFGR_PLLSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCFGR_PLLSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCFGR_PLLXTPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCFGR_PLLXTPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCFGR_PLLMUL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3c0000)|value<<18)
}
func (o *RCC_Type) GetCFGR_PLLMUL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3c0000) >> 18
}
func (o *RCC_Type) SetCFGR_I2SSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCFGR_I2SSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCFGR_MCO(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000000)|value<<24)
}
func (o *RCC_Type) GetCFGR_MCO() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000000) >> 24
}
func (o *RCC_Type) SetCFGR_MCOPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetCFGR_MCOPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x70000000) >> 28
}
func (o *RCC_Type) SetCFGR_PLLNODIV(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCFGR_PLLNODIV() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000000) >> 31
}

// RCC.CIR: Clock interrupt register (RCC_CIR)
func (o *RCC_Type) SetCIR_LSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIR_LSIRDYF() uint32 {
	return volatile.LoadUint32(&o.CIR.Reg) & 0x1
}
func (o *RCC_Type) SetCIR_LSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIR_LSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIR_HSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIR_HSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIR_HSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIR_HSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIR_PLLRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIR_PLLRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIR_CSSF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCIR_CSSF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCIR_LSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIR_LSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIR_LSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIR_LSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIR_HSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIR_HSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCIR_HSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCIR_HSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCIR_PLLRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetCIR_PLLRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetCIR_LSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCIR_LSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCIR_LSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCIR_LSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCIR_HSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCIR_HSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCIR_HSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCIR_HSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCIR_PLLRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetCIR_PLLRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetCIR_CSSC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCIR_CSSC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800000) >> 23
}

// RCC.APB2RSTR: APB2 peripheral reset register (RCC_APB2RSTR)
func (o *RCC_Type) SetAPB2RSTR_SYSCFGRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2RSTR_SYSCFGRST() uint32 {
	return volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2RSTR_TIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2RSTR_TIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2RSTR_USART1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2RSTR_USART1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2RSTR_TIM15RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2RSTR_TIM15RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2RSTR_TIM16RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2RSTR_TIM16RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2RSTR_TIM17RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2RSTR_TIM17RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x40000) >> 18
}

// RCC.APB1RSTR: APB1 peripheral reset register (RCC_APB1RSTR)
func (o *RCC_Type) SetAPB1RSTR_TIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR_TIM2RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1RSTR_TIM6RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1RSTR_TIM6RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1RSTR_WWDGRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1RSTR_WWDGRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1RSTR_SPI2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1RSTR_SPI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1RSTR_SPI3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1RSTR_SPI3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1RSTR_USART2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1RSTR_USART2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1RSTR_USART3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1RSTR_USART3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1RSTR_I2C1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1RSTR_I2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1RSTR_I2C2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1RSTR_I2C2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1RSTR_PWRRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1RSTR_PWRRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1RSTR_DAC1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1RSTR_DAC1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1RSTR_I2C3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1RSTR_I2C3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40000000) >> 30
}

// RCC.AHBENR: AHB Peripheral Clock enable register (RCC_AHBENR)
func (o *RCC_Type) SetAHBENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHBENR_DMA1EN() uint32 {
	return volatile.LoadUint32(&o.AHBENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHBENR_SRAMEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHBENR_SRAMEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHBENR_FLITFEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHBENR_FLITFEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHBENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHBENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHBENR_IOPAEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHBENR_IOPAEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHBENR_IOPBEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHBENR_IOPBEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHBENR_IOPCEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHBENR_IOPCEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHBENR_IOPDEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAHBENR_IOPDEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAHBENR_IOPFEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHBENR_IOPFEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHBENR_TSCEN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAHBENR_TSCEN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAHBENR_ADC1EN(value uint32) {
	volatile.StoreUint32(&o.AHBENR.Reg, volatile.LoadUint32(&o.AHBENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAHBENR_ADC1EN() uint32 {
	return (volatile.LoadUint32(&o.AHBENR.Reg) & 0x10000000) >> 28
}

// RCC.APB2ENR: APB2 peripheral clock enable register (RCC_APB2ENR)
func (o *RCC_Type) SetAPB2ENR_SYSCFGEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2ENR_SYSCFGEN() uint32 {
	return volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2ENR_TIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2ENR_TIM15EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2ENR_TIM15EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2ENR_TIM16EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2ENR_TIM16EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2ENR_TIM17EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2ENR_TIM17EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x40000) >> 18
}

// RCC.APB1ENR: APB1 peripheral clock enable register (RCC_APB1ENR)
func (o *RCC_Type) SetAPB1ENR_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1ENR_TIM6EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1ENR_TIM6EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1ENR_WWDGEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1ENR_WWDGEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1ENR_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1ENR_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1ENR_SPI3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1ENR_SPI3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1ENR_USART2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1ENR_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1ENR_USART3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1ENR_USART3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1ENR_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1ENR_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1ENR_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1ENR_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1ENR_PWREN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1ENR_PWREN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1ENR_DAC1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1ENR_DAC1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1ENR_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1ENR_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40000000) >> 30
}

// RCC.BDCR: Backup domain control register (RCC_BDCR)
func (o *RCC_Type) SetBDCR_LSEON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetBDCR_LSEON() uint32 {
	return volatile.LoadUint32(&o.BDCR.Reg) & 0x1
}
func (o *RCC_Type) SetBDCR_LSERDY(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetBDCR_LSERDY() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetBDCR_LSEBYP(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetBDCR_LSEBYP() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetBDCR_LSEDRV(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x18)|value<<3)
}
func (o *RCC_Type) GetBDCR_LSEDRV() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x18) >> 3
}
func (o *RCC_Type) SetBDCR_RTCSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetBDCR_RTCSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetBDCR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetBDCR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetBDCR_BDRST(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetBDCR_BDRST() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x10000) >> 16
}

// RCC.CSR: Control/status register (RCC_CSR)
func (o *RCC_Type) SetCSR_LSION(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCSR_LSION() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *RCC_Type) SetCSR_LSIRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCSR_LSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCSR_OBLRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCSR_OBLRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCSR_PINRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCSR_PINRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCSR_PORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCSR_PORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCSR_IWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCSR_IWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCSR_WWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCSR_WWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCSR_LPWRRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCSR_LPWRRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetCSR_V18PWRRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCSR_V18PWRRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}

// RCC.AHBRSTR: AHB peripheral reset register
func (o *RCC_Type) SetAHBRSTR_IOPARST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHBRSTR_IOPARST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHBRSTR_IOPBRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHBRSTR_IOPBRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHBRSTR_IOPCRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHBRSTR_IOPCRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHBRSTR_IOPDRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAHBRSTR_IOPDRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAHBRSTR_IOPFRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHBRSTR_IOPFRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHBRSTR_TSCRST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetAHBRSTR_TSCRST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetAHBRSTR_ADC1RST(value uint32) {
	volatile.StoreUint32(&o.AHBRSTR.Reg, volatile.LoadUint32(&o.AHBRSTR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAHBRSTR_ADC1RST() uint32 {
	return (volatile.LoadUint32(&o.AHBRSTR.Reg) & 0x10000000) >> 28
}

// RCC.CFGR2: Clock configuration register 2
func (o *RCC_Type) SetCFGR2_PREDIV(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0xf)|value)
}
func (o *RCC_Type) GetCFGR2_PREDIV() uint32 {
	return volatile.LoadUint32(&o.CFGR2.Reg) & 0xf
}
func (o *RCC_Type) SetCFGR2_ADC1PRES(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x1f0)|value<<4)
}
func (o *RCC_Type) GetCFGR2_ADC1PRES() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x1f0) >> 4
}

// RCC.CFGR3: Clock configuration register 3
func (o *RCC_Type) SetCFGR3_USART1SW(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCFGR3_USART1SW() uint32 {
	return volatile.LoadUint32(&o.CFGR3.Reg) & 0x3
}
func (o *RCC_Type) SetCFGR3_I2C1SW(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCFGR3_I2C1SW() uint32 {
	return (volatile.LoadUint32(&o.CFGR3.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCFGR3_I2C2SW(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCFGR3_I2C2SW() uint32 {
	return (volatile.LoadUint32(&o.CFGR3.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCFGR3_TIM1SW(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCFGR3_TIM1SW() uint32 {
	return (volatile.LoadUint32(&o.CFGR3.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCFGR3_TIM15SW(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCFGR3_TIM15SW() uint32 {
	return (volatile.LoadUint32(&o.CFGR3.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCFGR3_TIM16SW(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCFGR3_TIM16SW() uint32 {
	return (volatile.LoadUint32(&o.CFGR3.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCFGR3_TIM17SW(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetCFGR3_TIM17SW() uint32 {
	return (volatile.LoadUint32(&o.CFGR3.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetCFGR3_I2C3SW(value uint32) {
	volatile.StoreUint32(&o.CFGR3.Reg, volatile.LoadUint32(&o.CFGR3.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCFGR3_I2C3SW() uint32 {
	return (volatile.LoadUint32(&o.CFGR3.Reg) & 0x40) >> 6
}

// DMA controller 1
type DMA_Type struct {
	ISR  volatile.Register32 // 0x0
	IFCR volatile.Register32 // 0x4
	CH   [7]DMA_CH_Type      // 0x8
}

// DMA.ISR: DMA interrupt status register (DMA_ISR)
func (o *DMA_Type) SetISR_GIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetISR_GIF1() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *DMA_Type) SetISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetISR_GIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetISR_GIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetISR_GIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetISR_GIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetISR_GIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetISR_GIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetISR_GIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetISR_GIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetISR_GIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetISR_GIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetISR_GIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetISR_GIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}

// DMA.IFCR: DMA interrupt flag clear register (DMA_IFCR)
func (o *DMA_Type) SetIFCR_CGIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetIFCR_CGIF1() uint32 {
	return volatile.LoadUint32(&o.IFCR.Reg) & 0x1
}
func (o *DMA_Type) SetIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_Type) GetIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2) >> 1
}
func (o *DMA_Type) SetIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetIFCR_CGIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetIFCR_CGIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_Type) GetIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80) >> 7
}
func (o *DMA_Type) SetIFCR_CGIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetIFCR_CGIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetIFCR_CGIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000)|value<<12)
}
func (o *DMA_Type) GetIFCR_CGIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000) >> 12
}
func (o *DMA_Type) SetIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000)|value<<13)
}
func (o *DMA_Type) GetIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000) >> 13
}
func (o *DMA_Type) SetIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_Type) GetIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000) >> 14
}
func (o *DMA_Type) SetIFCR_CTEIF4(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_Type) GetIFCR_CTEIF4() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000) >> 15
}
func (o *DMA_Type) SetIFCR_CGIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetIFCR_CGIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x20000)|value<<17)
}
func (o *DMA_Type) GetIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x20000) >> 17
}
func (o *DMA_Type) SetIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetIFCR_CGIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetIFCR_CGIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetIFCR_CTCIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetIFCR_CTCIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetIFCR_CHTIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetIFCR_CHTIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetIFCR_CTEIF6(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x800000)|value<<23)
}
func (o *DMA_Type) GetIFCR_CTEIF6() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x800000) >> 23
}
func (o *DMA_Type) SetIFCR_CGIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetIFCR_CGIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetIFCR_CTCIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetIFCR_CTCIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetIFCR_CHTIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetIFCR_CHTIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetIFCR_CTEIF7(value uint32) {
	volatile.StoreUint32(&o.IFCR.Reg, volatile.LoadUint32(&o.IFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetIFCR_CTEIF7() uint32 {
	return (volatile.LoadUint32(&o.IFCR.Reg) & 0x8000000) >> 27
}

type DMA_CH_Type struct {
	CR   volatile.Register32 // 0x8
	NDTR volatile.Register32 // 0xC
	PAR  volatile.Register32 // 0x10
	MAR  volatile.Register32 // 0x14
	_    [4]byte
}

// DMA_CH.CR: DMA channel configuration register (DMA_CCR)
func (o *DMA_CH_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA_CH_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DMA_CH_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_CH_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA_CH_Type) SetCR_HTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_CH_Type) GetCR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA_CH_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_CH_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DMA_CH_Type) SetCR_DIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_CH_Type) GetCR_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DMA_CH_Type) SetCR_CIRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_CH_Type) GetCR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DMA_CH_Type) SetCR_PINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_CH_Type) GetCR_PINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DMA_CH_Type) SetCR_MINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_CH_Type) GetCR_MINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DMA_CH_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *DMA_CH_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *DMA_CH_Type) SetCR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00)|value<<10)
}
func (o *DMA_CH_Type) GetCR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00) >> 10
}
func (o *DMA_CH_Type) SetCR_PL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x3000)|value<<12)
}
func (o *DMA_CH_Type) GetCR_PL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x3000) >> 12
}
func (o *DMA_CH_Type) SetCR_MEM2MEM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *DMA_CH_Type) GetCR_MEM2MEM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}

// DMA_CH.NDTR: DMA channel 1 number of data register
func (o *DMA_CH_Type) SetNDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.NDTR.Reg, volatile.LoadUint32(&o.NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_CH_Type) GetNDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.NDTR.Reg) & 0xffff
}

// DMA_CH.PAR: DMA channel 1 peripheral address register
func (o *DMA_CH_Type) SetPAR(value uint32) {
	volatile.StoreUint32(&o.PAR.Reg, value)
}
func (o *DMA_CH_Type) GetPAR() uint32 {
	return volatile.LoadUint32(&o.PAR.Reg)
}

// DMA_CH.MAR: DMA channel 1 memory address register
func (o *DMA_CH_Type) SetMAR(value uint32) {
	volatile.StoreUint32(&o.MAR.Reg, value)
}
func (o *DMA_CH_Type) GetMAR() uint32 {
	return volatile.LoadUint32(&o.MAR.Reg)
}

// General purpose timer
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	_            [4]byte
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	_            [4]byte
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
}

// TIM.CR1: control register 1
func (o *TIM_Type) SetCR1_UIFREMAP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1800)|value<<11)
}
func (o *TIM_Type) GetCR1_UIFREMAP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1800) >> 11
}
func (o *TIM_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR1_CMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x60)|value<<5)
}
func (o *TIM_Type) GetCR1_CMS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x60) >> 5
}
func (o *TIM_Type) SetCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// TIM.CR2: control register 2
func (o *TIM_Type) SetCR2_TI1S(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR2_TI1S() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCR2_CCDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR2_CCDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}

// TIM.SMCR: slave mode control register
func (o *TIM_Type) SetSMCR_SMS_3(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetSMCR_SMS_3() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetSMCR_ETP(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetSMCR_ETP() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetSMCR_ECE(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetSMCR_ECE() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetSMCR_ETPS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x3000)|value<<12)
}
func (o *TIM_Type) GetSMCR_ETPS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x3000) >> 12
}
func (o *TIM_Type) SetSMCR_ETF(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetSMCR_ETF() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetSMCR_MSM(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSMCR_MSM() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSMCR_TS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetSMCR_TS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetSMCR_OCCS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSMCR_OCCS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSMCR_SMS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x7)|value)
}
func (o *TIM_Type) GetSMCR_SMS() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0x7
}

// TIM.DIER: DMA/Interrupt enable register
func (o *TIM_Type) SetDIER_TDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetDIER_TDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetDIER_CC4DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetDIER_CC4DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetDIER_CC3DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetDIER_CC3DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetDIER_CC2DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetDIER_CC2DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetDIER_CC1DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetDIER_CC1DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetDIER_UDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetDIER_UDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetDIER_TIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetDIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetDIER_CC4IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetDIER_CC4IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetDIER_CC3IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetDIER_CC3IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetDIER_CC2IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetDIER_CC2IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}

// TIM.SR: status register
func (o *TIM_Type) SetSR_CC4OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetSR_CC4OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetSR_CC3OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetSR_CC3OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetSR_CC2OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetSR_CC2OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetSR_TIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetSR_CC4IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetSR_CC4IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetSR_CC3IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSR_CC3IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetSR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// TIM.EGR: event generation register
func (o *TIM_Type) SetEGR_TG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetEGR_TG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetEGR_CC4G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetEGR_CC4G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetEGR_CC3G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetEGR_CC3G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetEGR_CC2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetEGR_CC2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}

// TIM.CCMR1_Output: capture/compare mode register 1 (output mode)
func (o *TIM_Type) SetCCMR1_Output_OC2M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetCCMR1_Output_OC1M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR1_Output_OC2CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR1_Output_OC2CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR1_Output_OC2M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR1_Output_OC2PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR1_Output_OC2PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR1_Output_OC2FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR1_Output_OC2FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR1_Output_CC2S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR1_Output_CC2S() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR1_Output_OC1M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}

// TIM.CCMR2_Output: capture/compare mode register 2 (output mode)
func (o *TIM_Type) SetCCMR2_Output_OC4M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetCCMR2_Output_OC3M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR2_Output_OC4CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR2_Output_OC4CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR2_Output_OC4M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR2_Output_OC4PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR2_Output_OC4PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR2_Output_OC4FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR2_Output_OC4FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR2_Output_CC4S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR2_Output_CC4S() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR2_Output_OC3CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR2_Output_OC3CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR2_Output_OC3M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR2_Output_OC3PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR2_Output_OC3PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR2_Output_OC3FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR2_Output_OC3FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR2_Output_CC3S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR2_Output_CC3S() uint32 {
	return volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x3
}

// TIM.CCER: capture/compare enable register
func (o *TIM_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}
func (o *TIM_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCER_CC2E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCCER_CC2E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCCER_CC2P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetCCER_CC2P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetCCER_CC2NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCER_CC2NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCER_CC3E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCCER_CC3E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCCER_CC3P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCCER_CC3P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCCER_CC3NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCER_CC3NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCER_CC4E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCCER_CC4E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCCER_CC4P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCCER_CC4P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCCER_CC4NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCER_CC4NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8000) >> 15
}

// TIM.CNT: counter
func (o *TIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, value)
}
func (o *TIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg)
}

// TIM.PSC: prescaler
func (o *TIM_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIM.ARR: auto-reload register
func (o *TIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, value)
}
func (o *TIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg)
}

// TIM.CCR1: capture/compare register
func (o *TIM_Type) SetCCR1(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, value)
}
func (o *TIM_Type) GetCCR1() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg)
}

// TIM.CCR2: capture/compare register
func (o *TIM_Type) SetCCR2(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, value)
}
func (o *TIM_Type) GetCCR2() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg)
}

// TIM.CCR3: capture/compare register
func (o *TIM_Type) SetCCR3(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, value)
}
func (o *TIM_Type) GetCCR3() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg)
}

// TIM.CCR4: capture/compare register
func (o *TIM_Type) SetCCR4(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, value)
}
func (o *TIM_Type) GetCCR4() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg)
}

// TIM.DCR: DMA control register
func (o *TIM_Type) SetDCR_DBL(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f00)|value<<8)
}
func (o *TIM_Type) GetDCR_DBL() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f00) >> 8
}
func (o *TIM_Type) SetDCR_DBA(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f)|value)
}
func (o *TIM_Type) GetDCR_DBA() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1f
}

// TIM.DMAR: DMA address for full transfer
func (o *TIM_Type) SetDMAR_DMAB(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, volatile.LoadUint32(&o.DMAR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetDMAR_DMAB() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg) & 0xffff
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	CR3  volatile.Register32 // 0x8
	BRR  volatile.Register32 // 0xC
	GTPR volatile.Register32 // 0x10
	RTOR volatile.Register32 // 0x14
	RQR  volatile.Register32 // 0x18
	ISR  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
	RDR  volatile.Register32 // 0x24
	TDR  volatile.Register32 // 0x28
}

// USART.CR1: Control register 1
func (o *USART_Type) SetCR1_EOBIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000000)|value<<27)
}
func (o *USART_Type) GetCR1_EOBIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000000) >> 27
}
func (o *USART_Type) SetCR1_RTOIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000000)|value<<26)
}
func (o *USART_Type) GetCR1_RTOIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000000) >> 26
}
func (o *USART_Type) SetCR1_DEAT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3e00000)|value<<21)
}
func (o *USART_Type) GetCR1_DEAT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3e00000) >> 21
}
func (o *USART_Type) SetCR1_DEDT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1f0000)|value<<16)
}
func (o *USART_Type) GetCR1_DEDT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1f0000) >> 16
}
func (o *USART_Type) SetCR1_OVER8(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR1_OVER8() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR1_CMIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR1_CMIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR1_MME(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR1_MME() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR1_M(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR1_M() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR1_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR1_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR1_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR1_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR1_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR1_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR1_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR1_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR1_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR1_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR1_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR1_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR1_TE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR1_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR1_RE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR1_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR1_UESM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR1_UESM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR1_UE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR1_UE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// USART.CR2: Control register 2
func (o *USART_Type) SetCR2_RTOEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR2_RTOEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR2_ABRMOD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x600000)|value<<21)
}
func (o *USART_Type) GetCR2_ABRMOD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x600000) >> 21
}
func (o *USART_Type) SetCR2_ABREN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCR2_ABREN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCR2_MSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR2_MSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR2_DATAINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR2_DATAINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR2_TXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCR2_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCR2_RXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCR2_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCR2_SWAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR2_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR2_LINEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR2_LINEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR2_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR2_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR2_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR2_LBCL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR2_LBCL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR2_LBDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR2_LBDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR2_LBDL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR2_LBDL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR2_ADDM7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR2_ADDM7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetCR2_ADD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff000000) >> 24
}

// USART.CR3: Control register 3
func (o *USART_Type) SetCR3_WUFIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetCR3_WUFIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetCR3_WUS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x300000)|value<<20)
}
func (o *USART_Type) GetCR3_WUS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x300000) >> 20
}
func (o *USART_Type) SetCR3_SCARCNT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000)|value<<17)
}
func (o *USART_Type) GetCR3_SCARCNT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000) >> 17
}
func (o *USART_Type) SetCR3_DEP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR3_DEP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR3_DEM(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR3_DEM() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR3_DDRE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR3_DDRE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR3_OVRDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR3_OVRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR3_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR3_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR3_SCEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR3_SCEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR3_NACK(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR3_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR3_IRLP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR3_IRLP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR3_IREN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR3_IREN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}

// USART.BRR: Baud rate register
func (o *USART_Type) SetBRR(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRR() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xffff
}

// USART.GTPR: Guard time and prescaler register
func (o *USART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}

// USART.RTOR: Receiver timeout register
func (o *USART_Type) SetRTOR_BLEN(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetRTOR_BLEN() uint32 {
	return (volatile.LoadUint32(&o.RTOR.Reg) & 0xff000000) >> 24
}
func (o *USART_Type) SetRTOR_RTO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffffff)|value)
}
func (o *USART_Type) GetRTOR_RTO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffffff
}

// USART.RQR: Request register
func (o *USART_Type) SetRQR_TXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetRQR_TXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetRQR_RXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetRQR_RXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetRQR_MMRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetRQR_MMRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetRQR_SBKRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetRQR_SBKRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetRQR_ABRRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetRQR_ABRRQ() uint32 {
	return volatile.LoadUint32(&o.RQR.Reg) & 0x1
}

// USART.ISR: Interrupt & status register
func (o *USART_Type) SetISR_REACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *USART_Type) GetISR_REACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *USART_Type) SetISR_TEACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetISR_TEACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetISR_WUF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetISR_WUF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetISR_RWU(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetISR_RWU() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetISR_SBKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetISR_SBKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetISR_CMF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetISR_CMF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetISR_ABRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetISR_ABRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetISR_ABRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetISR_ABRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetISR_EOBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetISR_EOBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetISR_RTOF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetISR_RTOF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetISR_CTS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetISR_CTS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetISR_CTSIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetISR_CTSIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetISR_LBDF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetISR_LBDF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetISR_TXE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetISR_IDLE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetISR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetISR_ORE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetISR_ORE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetISR_NF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetISR_NF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetISR_FE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetISR_FE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetISR_PE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetISR_PE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// USART.ICR: Interrupt flag clear register
func (o *USART_Type) SetICR_WUCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetICR_WUCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetICR_CMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetICR_CMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetICR_EOBCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetICR_EOBCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetICR_RTOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetICR_RTOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetICR_CTSCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetICR_CTSCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetICR_LBDCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetICR_LBDCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetICR_TCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetICR_TCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetICR_IDLECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetICR_IDLECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetICR_ORECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetICR_ORECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetICR_NCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetICR_NCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetICR_FECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetICR_FECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetICR_PECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetICR_PECF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// USART.RDR: Receive data register
func (o *USART_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0x1ff
}

// USART.TDR: Transmit data register
func (o *USART_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0x1ff
}

// Serial peripheral interface/Inter-IC sound
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// SPI.CR1: control register 1
func (o *SPI_Type) SetCR1_BIDIMODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCR1_BIDIMODE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCR1_BIDIOE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR1_BIDIOE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCR1_CRCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR1_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR1_CRCNEXT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR1_CRCNEXT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR1_CRCL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetCR1_CRCL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetCR1_RXONLY(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetCR1_RXONLY() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetCR1_SSM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetCR1_SSM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetCR1_SSI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCR1_SSI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR1_SPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR1_SPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR1_BR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x38)|value<<3)
}
func (o *SPI_Type) GetCR1_BR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x38) >> 3
}
func (o *SPI_Type) SetCR1_MSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR1_MSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR1_CPHA() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// SPI.CR2: control register 2
func (o *SPI_Type) SetCR2_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR2_RXDMAEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *SPI_Type) SetCR2_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR2_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR2_SSOE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR2_SSOE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR2_NSSP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCR2_NSSP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCR2_FRF(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCR2_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCR2_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCR2_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCR2_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR2_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR2_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR2_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR2_DS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCR2_DS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCR2_FRXTH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR2_FRXTH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR2_LDMA_RX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR2_LDMA_RX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR2_LDMA_TX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR2_LDMA_TX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}

// SPI.SR: status register
func (o *SPI_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RXNE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_CHSIDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_CHSIDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_UDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_UDR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_CRCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_FRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_FRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_FRLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x600)|value<<9)
}
func (o *SPI_Type) GetSR_FRLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x600) >> 9
}
func (o *SPI_Type) SetSR_FTLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1800)|value<<11)
}
func (o *SPI_Type) GetSR_FTLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1800) >> 11
}

// SPI.DR: data register
func (o *SPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// SPI.CRCPR: CRC polynomial register
func (o *SPI_Type) SetCRCPR_CRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPR.Reg, volatile.LoadUint32(&o.CRCPR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetCRCPR_CRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPR.Reg) & 0xffff
}

// SPI.RXCRCR: RX CRC register
func (o *SPI_Type) SetRXCRCR_RxCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRCR.Reg, volatile.LoadUint32(&o.RXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRXCRCR_RxCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRCR.Reg) & 0xffff
}

// SPI.TXCRCR: TX CRC register
func (o *SPI_Type) SetTXCRCR_TxCRC(value uint32) {
	volatile.StoreUint32(&o.TXCRCR.Reg, volatile.LoadUint32(&o.TXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXCRCR_TxCRC() uint32 {
	return volatile.LoadUint32(&o.TXCRCR.Reg) & 0xffff
}

// SPI.I2SCFGR: I2S configuration register
func (o *SPI_Type) SetI2SCFGR_I2SMOD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetI2SCFGR_I2SMOD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetI2SCFGR_I2SE(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetI2SCFGR_I2SE() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetI2SCFGR_I2SCFG(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetI2SCFGR_I2SCFG() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetI2SCFGR_PCMSYNC(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetI2SCFGR_PCMSYNC() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetI2SCFGR_I2SSTD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x30)|value<<4)
}
func (o *SPI_Type) GetI2SCFGR_I2SSTD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x30) >> 4
}
func (o *SPI_Type) SetI2SCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetI2SCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetI2SCFGR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x6)|value<<1)
}
func (o *SPI_Type) GetI2SCFGR_DATLEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x6) >> 1
}
func (o *SPI_Type) SetI2SCFGR_CHLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetI2SCFGR_CHLEN() uint32 {
	return volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1
}

// SPI.I2SPR: I2S prescaler register
func (o *SPI_Type) SetI2SPR_MCKOE(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetI2SPR_MCKOE() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetI2SPR_ODD(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetI2SPR_ODD() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetI2SPR_I2SDIV(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetI2SPR_I2SDIV() uint32 {
	return volatile.LoadUint32(&o.I2SPR.Reg) & 0xff
}

// Analog to digital converter
type ADC_Type struct {
	ISR     volatile.Register32 // 0x0
	IER     volatile.Register32 // 0x4
	CR      volatile.Register32 // 0x8
	CFGR    volatile.Register32 // 0xC
	_       [4]byte
	SMPR1   volatile.Register32 // 0x14
	SMPR2   volatile.Register32 // 0x18
	_       [4]byte
	TR1     volatile.Register32 // 0x20
	TR2     volatile.Register32 // 0x24
	TR3     volatile.Register32 // 0x28
	_       [4]byte
	SQR1    volatile.Register32 // 0x30
	SQR2    volatile.Register32 // 0x34
	SQR3    volatile.Register32 // 0x38
	SQR4    volatile.Register32 // 0x3C
	DR      volatile.Register32 // 0x40
	_       [8]byte
	JSQR    volatile.Register32 // 0x4C
	_       [16]byte
	OFR1    volatile.Register32 // 0x60
	OFR2    volatile.Register32 // 0x64
	OFR3    volatile.Register32 // 0x68
	OFR4    volatile.Register32 // 0x6C
	_       [16]byte
	JDR1    volatile.Register32 // 0x80
	JDR2    volatile.Register32 // 0x84
	JDR3    volatile.Register32 // 0x88
	JDR4    volatile.Register32 // 0x8C
	_       [16]byte
	AWD2CR  volatile.Register32 // 0xA0
	AWD3CR  volatile.Register32 // 0xA4
	_       [8]byte
	DIFSEL  volatile.Register32 // 0xB0
	CALFACT volatile.Register32 // 0xB4
}

// ADC.ISR: ADC interrupt and status register
func (o *ADC_Type) SetISR_JQOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetISR_JQOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetISR_AWD3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_AWD3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_AWD2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_AWD2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_AWD1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_AWD1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_JEOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetISR_JEOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetISR_JEOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetISR_JEOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_EOS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_EOC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOSMP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOSMP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_ADRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_ADRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// ADC.IER: ADC interrupt enable register
func (o *ADC_Type) SetIER_JQOVFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIER_JQOVFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIER_AWD3IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_AWD3IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_AWD2IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_AWD2IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_AWD1IE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_AWD1IE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_JEOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIER_JEOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIER_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIER_JEOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIER_OVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_EOSIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOSIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_EOCIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOSMPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOSMPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_ADRDYIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_ADRDYIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// ADC.CR: ADC control register
func (o *ADC_Type) SetCR_ADCAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetCR_ADCAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetCR_ADCALDIF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCR_ADCALDIF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCR_ADVREGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000000)|value<<28)
}
func (o *ADC_Type) GetCR_ADVREGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000000) >> 28
}
func (o *ADC_Type) SetCR_JADST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCR_JADST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCR_ADSTP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCR_ADSTP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCR_JADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCR_JADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCR_ADSTART(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCR_ADSTART() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCR_ADDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_ADDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR_ADEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_ADEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// ADC.CFGR: ADC configuration register
func (o *ADC_Type) SetCFGR_AWD1CH(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetCFGR_AWD1CH() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetCFGR_JAUTO(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetCFGR_JAUTO() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetCFGR_JAWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetCFGR_JAWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetCFGR_AWD1EN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCFGR_AWD1EN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCFGR_AWD1SGL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCFGR_AWD1SGL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCFGR_JQM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *ADC_Type) GetCFGR_JQM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *ADC_Type) SetCFGR_JDISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *ADC_Type) GetCFGR_JDISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *ADC_Type) SetCFGR_DISCNUM(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe0000)|value<<17)
}
func (o *ADC_Type) GetCFGR_DISCNUM() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe0000) >> 17
}
func (o *ADC_Type) SetCFGR_DISCEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetCFGR_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetCFGR_AUTDLY(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCFGR_AUTDLY() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCFGR_CONT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCFGR_CONT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCFGR_OVRMOD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCFGR_OVRMOD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCFGR_EXTEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc00)|value<<10)
}
func (o *ADC_Type) GetCFGR_EXTEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc00) >> 10
}
func (o *ADC_Type) SetCFGR_EXTSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3c0)|value<<6)
}
func (o *ADC_Type) GetCFGR_EXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x3c0) >> 6
}
func (o *ADC_Type) SetCFGR_ALIGN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCFGR_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCFGR_RES(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *ADC_Type) GetCFGR_RES() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *ADC_Type) SetCFGR_DMACFG(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCFGR_DMACFG() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCFGR_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCFGR_DMAEN() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// ADC.SMPR1: ADC sample time register 1
func (o *ADC_Type) SetSMPR1_SMP1(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR1_SMP1() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR1_SMP2(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR1_SMP2() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR1_SMP3(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR1_SMP3() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR1_SMP4(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR1_SMP4() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR1_SMP5(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR1_SMP5() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR1_SMP6(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR1_SMP6() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR1_SMP7(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR1_SMP7() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR1_SMP8(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR1_SMP8() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR1_SMP9(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000000)|value<<27)
}
func (o *ADC_Type) GetSMPR1_SMP9() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000000) >> 27
}

// ADC.SMPR2: ADC sample time register 2
func (o *ADC_Type) SetSMPR2_SMP10(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR2_SMP10() uint32 {
	return volatile.LoadUint32(&o.SMPR2.Reg) & 0x7
}
func (o *ADC_Type) SetSMPR2_SMP11(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR2_SMP11() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR2_SMP12(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR2_SMP12() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR2_SMP13(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR2_SMP13() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR2_SMP14(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR2_SMP14() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR2_SMP15(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR2_SMP15() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR2_SMP16(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR2_SMP16() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR2_SMP17(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR2_SMP17() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR2_SMP18(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR2_SMP18() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000000) >> 24
}

// ADC.TR1: ADC watchdog threshold register 1
func (o *ADC_Type) SetTR1_HT1(value uint32) {
	volatile.StoreUint32(&o.TR1.Reg, volatile.LoadUint32(&o.TR1.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetTR1_HT1() uint32 {
	return (volatile.LoadUint32(&o.TR1.Reg) & 0xfff0000) >> 16
}
func (o *ADC_Type) SetTR1_LT1(value uint32) {
	volatile.StoreUint32(&o.TR1.Reg, volatile.LoadUint32(&o.TR1.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetTR1_LT1() uint32 {
	return volatile.LoadUint32(&o.TR1.Reg) & 0xfff
}

// ADC.TR2: ADC watchdog threshold register 2
func (o *ADC_Type) SetTR2_HT2(value uint32) {
	volatile.StoreUint32(&o.TR2.Reg, volatile.LoadUint32(&o.TR2.Reg)&^(0xff0000)|value<<16)
}
func (o *ADC_Type) GetTR2_HT2() uint32 {
	return (volatile.LoadUint32(&o.TR2.Reg) & 0xff0000) >> 16
}
func (o *ADC_Type) SetTR2_LT2(value uint32) {
	volatile.StoreUint32(&o.TR2.Reg, volatile.LoadUint32(&o.TR2.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetTR2_LT2() uint32 {
	return volatile.LoadUint32(&o.TR2.Reg) & 0xff
}

// ADC.TR3: read-write
func (o *ADC_Type) SetTR3_HT3(value uint32) {
	volatile.StoreUint32(&o.TR3.Reg, volatile.LoadUint32(&o.TR3.Reg)&^(0xff0000)|value<<16)
}
func (o *ADC_Type) GetTR3_HT3() uint32 {
	return (volatile.LoadUint32(&o.TR3.Reg) & 0xff0000) >> 16
}
func (o *ADC_Type) SetTR3_LT3(value uint32) {
	volatile.StoreUint32(&o.TR3.Reg, volatile.LoadUint32(&o.TR3.Reg)&^(0xff)|value)
}
func (o *ADC_Type) GetTR3_LT3() uint32 {
	return volatile.LoadUint32(&o.TR3.Reg) & 0xff
}

// ADC.SQR1: ADC regular sequence register 1
func (o *ADC_Type) SetSQR1_SQ4(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR1_SQ4() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR1_SQ3(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR1_SQ3() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR1_SQ2(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR1_SQ2() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR1_SQ1(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR1_SQ1() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR1_L(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSQR1_L() uint32 {
	return volatile.LoadUint32(&o.SQR1.Reg) & 0xf
}

// ADC.SQR2: ADC regular sequence register 2
func (o *ADC_Type) SetSQR2_SQ9(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR2_SQ9() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR2_SQ8(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR2_SQ8() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR2_SQ7(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR2_SQ7() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR2_SQ6(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR2_SQ6() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR2_SQ5(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR2_SQ5() uint32 {
	return volatile.LoadUint32(&o.SQR2.Reg) & 0x1f
}

// ADC.SQR3: ADC regular sequence register 3
func (o *ADC_Type) SetSQR3_SQ14(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f000000)|value<<24)
}
func (o *ADC_Type) GetSQR3_SQ14() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f000000) >> 24
}
func (o *ADC_Type) SetSQR3_SQ13(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c0000)|value<<18)
}
func (o *ADC_Type) GetSQR3_SQ13() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c0000) >> 18
}
func (o *ADC_Type) SetSQR3_SQ12(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f000)|value<<12)
}
func (o *ADC_Type) GetSQR3_SQ12() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f000) >> 12
}
func (o *ADC_Type) SetSQR3_SQ11(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR3_SQ11() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR3_SQ10(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR3_SQ10() uint32 {
	return volatile.LoadUint32(&o.SQR3.Reg) & 0x1f
}

// ADC.SQR4: ADC regular sequence register 4
func (o *ADC_Type) SetSQR4_SQ16(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x7c0)|value<<6)
}
func (o *ADC_Type) GetSQR4_SQ16() uint32 {
	return (volatile.LoadUint32(&o.SQR4.Reg) & 0x7c0) >> 6
}
func (o *ADC_Type) SetSQR4_SQ15(value uint32) {
	volatile.StoreUint32(&o.SQR4.Reg, volatile.LoadUint32(&o.SQR4.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR4_SQ15() uint32 {
	return volatile.LoadUint32(&o.SQR4.Reg) & 0x1f
}

// ADC.DR: ADC regular Data Register
func (o *ADC_Type) SetDR_RDATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetDR_RDATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// ADC.JSQR: ADC injected sequence register
func (o *ADC_Type) SetJSQR_JSQ4(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetJSQR_JSQ4() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetJSQR_JSQ3(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetJSQR_JSQ3() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetJSQR_JSQ2(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c000)|value<<14)
}
func (o *ADC_Type) GetJSQR_JSQ2() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c000) >> 14
}
func (o *ADC_Type) SetJSQR_JSQ1(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x1f00)|value<<8)
}
func (o *ADC_Type) GetJSQR_JSQ1() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x1f00) >> 8
}
func (o *ADC_Type) SetJSQR_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xc0)|value<<6)
}
func (o *ADC_Type) GetJSQR_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xc0) >> 6
}
func (o *ADC_Type) SetJSQR_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3c)|value<<2)
}
func (o *ADC_Type) GetJSQR_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3c) >> 2
}
func (o *ADC_Type) SetJSQR_JL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetJSQR_JL() uint32 {
	return volatile.LoadUint32(&o.JSQR.Reg) & 0x3
}

// ADC.OFR1: ADC offset register1
func (o *ADC_Type) SetOFR1_OFFSET1_EN(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR1_OFFSET1_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR1_OFFSET1_CH(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR1_OFFSET1_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR1.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR1_OFFSET1(value uint32) {
	volatile.StoreUint32(&o.OFR1.Reg, volatile.LoadUint32(&o.OFR1.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR1_OFFSET1() uint32 {
	return volatile.LoadUint32(&o.OFR1.Reg) & 0xfff
}

// ADC.OFR2: ADC offset register2
func (o *ADC_Type) SetOFR2_OFFSET2_EN(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR2_OFFSET2_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR2_OFFSET2_CH(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR2_OFFSET2_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR2.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR2_OFFSET2(value uint32) {
	volatile.StoreUint32(&o.OFR2.Reg, volatile.LoadUint32(&o.OFR2.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR2_OFFSET2() uint32 {
	return volatile.LoadUint32(&o.OFR2.Reg) & 0xfff
}

// ADC.OFR3: ADC offset register3
func (o *ADC_Type) SetOFR3_OFFSET3_EN(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR3_OFFSET3_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR3_OFFSET3_CH(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR3_OFFSET3_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR3.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR3_OFFSET3(value uint32) {
	volatile.StoreUint32(&o.OFR3.Reg, volatile.LoadUint32(&o.OFR3.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR3_OFFSET3() uint32 {
	return volatile.LoadUint32(&o.OFR3.Reg) & 0xfff
}

// ADC.OFR4: ADC offset register4
func (o *ADC_Type) SetOFR4_OFFSET4_EN(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetOFR4_OFFSET4_EN() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x80000000) >> 31
}
func (o *ADC_Type) SetOFR4_OFFSET4_CH(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0x7c000000)|value<<26)
}
func (o *ADC_Type) GetOFR4_OFFSET4_CH() uint32 {
	return (volatile.LoadUint32(&o.OFR4.Reg) & 0x7c000000) >> 26
}
func (o *ADC_Type) SetOFR4_OFFSET4(value uint32) {
	volatile.StoreUint32(&o.OFR4.Reg, volatile.LoadUint32(&o.OFR4.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFR4_OFFSET4() uint32 {
	return volatile.LoadUint32(&o.OFR4.Reg) & 0xfff
}

// ADC.JDR1: ADC offset register1
func (o *ADC_Type) SetJDR1_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR1.Reg, volatile.LoadUint32(&o.JDR1.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR1_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR1.Reg) & 0xffff
}

// ADC.JDR2: ADC offset register2
func (o *ADC_Type) SetJDR2_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR2.Reg, volatile.LoadUint32(&o.JDR2.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR2_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR2.Reg) & 0xffff
}

// ADC.JDR3: ADC offset register3
func (o *ADC_Type) SetJDR3_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR3.Reg, volatile.LoadUint32(&o.JDR3.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR3_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR3.Reg) & 0xffff
}

// ADC.JDR4: ADC offset register4
func (o *ADC_Type) SetJDR4_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR4.Reg, volatile.LoadUint32(&o.JDR4.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR4_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR4.Reg) & 0xffff
}

// ADC.AWD2CR: ADC Analog Watchdog 2 Configuration Register
func (o *ADC_Type) SetAWD2CR_AWD2CH0(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH0() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetAWD2CR_AWD2CH1(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH1() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetAWD2CR_AWD2CH2(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH2() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetAWD2CR_AWD2CH3(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH3() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetAWD2CR_AWD2CH4(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH4() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetAWD2CR_AWD2CH5(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH5() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetAWD2CR_AWD2CH6(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH6() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetAWD2CR_AWD2CH7(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH7() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetAWD2CR_AWD2CH8(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH8() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetAWD2CR_AWD2CH9(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH9() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetAWD2CR_AWD2CH10(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH10() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetAWD2CR_AWD2CH11(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH11() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetAWD2CR_AWD2CH12(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH12() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetAWD2CR_AWD2CH13(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH13() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetAWD2CR_AWD2CH14(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH14() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetAWD2CR_AWD2CH15(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH15() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetAWD2CR_AWD2CH16(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH16() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetAWD2CR_AWD2CH17(value uint32) {
	volatile.StoreUint32(&o.AWD2CR.Reg, volatile.LoadUint32(&o.AWD2CR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetAWD2CR_AWD2CH17() uint32 {
	return (volatile.LoadUint32(&o.AWD2CR.Reg) & 0x40000) >> 18
}

// ADC.AWD3CR: ADC Analog Watchdog 3 Configuration Register
func (o *ADC_Type) SetAWD3CR_AWD3CH0(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH0() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetAWD3CR_AWD3CH1(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH1() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetAWD3CR_AWD3CH2(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH2() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetAWD3CR_AWD3CH3(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH3() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetAWD3CR_AWD3CH4(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH4() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetAWD3CR_AWD3CH5(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH5() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetAWD3CR_AWD3CH6(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH6() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetAWD3CR_AWD3CH7(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH7() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetAWD3CR_AWD3CH8(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH8() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetAWD3CR_AWD3CH9(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH9() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetAWD3CR_AWD3CH10(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH10() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetAWD3CR_AWD3CH11(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH11() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetAWD3CR_AWD3CH12(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH12() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetAWD3CR_AWD3CH13(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH13() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetAWD3CR_AWD3CH14(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH14() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetAWD3CR_AWD3CH15(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH15() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetAWD3CR_AWD3CH16(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH16() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetAWD3CR_AWD3CH17(value uint32) {
	volatile.StoreUint32(&o.AWD3CR.Reg, volatile.LoadUint32(&o.AWD3CR.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetAWD3CR_AWD3CH17() uint32 {
	return (volatile.LoadUint32(&o.AWD3CR.Reg) & 0x40000) >> 18
}

// ADC.DIFSEL: ADC Differential Mode Selection Register
func (o *ADC_Type) SetDIFSEL_DIFSEL0(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL0() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetDIFSEL_DIFSEL1(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL1() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetDIFSEL_DIFSEL2(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL2() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetDIFSEL_DIFSEL3(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL3() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetDIFSEL_DIFSEL4(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL4() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetDIFSEL_DIFSEL5(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL5() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetDIFSEL_DIFSEL6(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL6() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetDIFSEL_DIFSEL7(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL7() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetDIFSEL_DIFSEL8(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL8() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetDIFSEL_DIFSEL9(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL9() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetDIFSEL_DIFSEL10(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL10() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetDIFSEL_DIFSEL11(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL11() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetDIFSEL_DIFSEL12(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL12() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetDIFSEL_DIFSEL13(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL13() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetDIFSEL_DIFSEL14(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL14() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetDIFSEL_DIFSEL15(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x10000)|value<<16)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL15() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x10000) >> 16
}
func (o *ADC_Type) SetDIFSEL_DIFSEL16(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x20000)|value<<17)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL16() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x20000) >> 17
}
func (o *ADC_Type) SetDIFSEL_DIFSEL17(value uint32) {
	volatile.StoreUint32(&o.DIFSEL.Reg, volatile.LoadUint32(&o.DIFSEL.Reg)&^(0x40000)|value<<18)
}
func (o *ADC_Type) GetDIFSEL_DIFSEL17() uint32 {
	return (volatile.LoadUint32(&o.DIFSEL.Reg) & 0x40000) >> 18
}

// ADC.CALFACT: ADC Calibration Factors
func (o *ADC_Type) SetCALFACT_CALFACT_D(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7f0000)|value<<16)
}
func (o *ADC_Type) GetCALFACT_CALFACT_D() uint32 {
	return (volatile.LoadUint32(&o.CALFACT.Reg) & 0x7f0000) >> 16
}
func (o *ADC_Type) SetCALFACT_CALFACT_S(value uint32) {
	volatile.StoreUint32(&o.CALFACT.Reg, volatile.LoadUint32(&o.CALFACT.Reg)&^(0x7f)|value)
}
func (o *ADC_Type) GetCALFACT_CALFACT_S() uint32 {
	return volatile.LoadUint32(&o.CALFACT.Reg) & 0x7f
}

// HDMI-CEC controller
type CEC_Type struct {
	CR   volatile.Register32 // 0x0
	CFGR volatile.Register32 // 0x4
	TXDR volatile.Register32 // 0x8
	RXDR volatile.Register32 // 0xC
	ISR  volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
}

// CEC.CR: control register
func (o *CEC_Type) SetCR_TXEOM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetCR_TXEOM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *CEC_Type) SetCR_TXSOM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetCR_TXSOM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetCR_CECEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetCR_CECEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// CEC.CFGR: configuration register
func (o *CEC_Type) SetCFGR_LBPEGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800)|value<<11)
}
func (o *CEC_Type) GetCFGR_LBPEGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800) >> 11
}
func (o *CEC_Type) SetCFGR_BREGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400)|value<<10)
}
func (o *CEC_Type) GetCFGR_BREGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400) >> 10
}
func (o *CEC_Type) SetCFGR_BRESTP(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200)|value<<9)
}
func (o *CEC_Type) GetCFGR_BRESTP() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200) >> 9
}
func (o *CEC_Type) SetCFGR_RXTOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetCFGR_RXTOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetCFGR_SFT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe0)|value<<5)
}
func (o *CEC_Type) GetCFGR_SFT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe0) >> 5
}
func (o *CEC_Type) SetCFGR_LSTN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetCFGR_LSTN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetCFGR_OAR(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf)|value)
}
func (o *CEC_Type) GetCFGR_OAR() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0xf
}

// CEC.TXDR: Tx data register
func (o *CEC_Type) SetTXDR_TXD(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *CEC_Type) GetTXDR_TXD() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// CEC.RXDR: Rx Data Register
func (o *CEC_Type) SetRXDR(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *CEC_Type) GetRXDR() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// CEC.ISR: Interrupt and Status Register
func (o *CEC_Type) SetISR_TXACKE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *CEC_Type) GetISR_TXACKE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *CEC_Type) SetISR_TXERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *CEC_Type) GetISR_TXERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *CEC_Type) SetISR_TXUDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *CEC_Type) GetISR_TXUDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *CEC_Type) SetISR_TXEND(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *CEC_Type) GetISR_TXEND() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *CEC_Type) SetISR_TXBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetISR_TXBR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetISR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetISR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetISR_RXACKE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetISR_RXACKE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetISR_LBPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetISR_LBPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetISR_SBPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetISR_SBPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetISR_BRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetISR_BRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetISR_RXOVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetISR_RXOVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *CEC_Type) SetISR_RXEND(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetISR_RXEND() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetISR_RXBR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetISR_RXBR() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// CEC.IER: interrupt enable register
func (o *CEC_Type) SetIER_TXACKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *CEC_Type) GetIER_TXACKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *CEC_Type) SetIER_TXERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *CEC_Type) GetIER_TXERRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *CEC_Type) SetIER_TXUDRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *CEC_Type) GetIER_TXUDRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *CEC_Type) SetIER_TXENDIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *CEC_Type) GetIER_TXENDIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *CEC_Type) SetIER_TXBRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *CEC_Type) GetIER_TXBRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *CEC_Type) SetIER_ARBLSTIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *CEC_Type) GetIER_ARBLSTIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *CEC_Type) SetIER_RXACKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *CEC_Type) GetIER_RXACKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *CEC_Type) SetIER_LBPEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *CEC_Type) GetIER_LBPEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *CEC_Type) SetIER_SBPEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *CEC_Type) GetIER_SBPEIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *CEC_Type) SetIER_BREIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *CEC_Type) GetIER_BREIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *CEC_Type) SetIER_RXOVRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *CEC_Type) GetIER_RXOVRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *CEC_Type) SetIER_RXENDIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *CEC_Type) GetIER_RXENDIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *CEC_Type) SetIER_RXBRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *CEC_Type) GetIER_RXBRIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// Power control
type PWR_Type struct {
	CR  volatile.Register32 // 0x0
	CSR volatile.Register32 // 0x4
}

// PWR.CR: power control register
func (o *PWR_Type) SetCR_LPDS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR_LPDS() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *PWR_Type) SetCR_PDDS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR_PDDS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR_CWUF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR_CWUF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR_CSBF(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR_CSBF() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR_PVDE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR_PLS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe0)|value<<5)
}
func (o *PWR_Type) GetCR_PLS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe0) >> 5
}
func (o *PWR_Type) SetCR_DBP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR_ENSD1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR_ENSD1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR_ENSD2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR_ENSD2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR_ENSD3(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetCR_ENSD3() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}

// PWR.CSR: power control/status register
func (o *PWR_Type) SetCSR_WUF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCSR_WUF() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *PWR_Type) SetCSR_SBF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCSR_SBF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCSR_PVDO(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCSR_PVDO() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCSR_EWUP1(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCSR_EWUP1() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCSR_EWUP2(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCSR_EWUP2() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCSR_EWUP3(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCSR_EWUP3() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}

// Controller area network
type CAN_Type struct {
	MCR   volatile.Register32 // 0x0
	MSR   volatile.Register32 // 0x4
	TSR   volatile.Register32 // 0x8
	RF0R  volatile.Register32 // 0xC
	RF1R  volatile.Register32 // 0x10
	IER   volatile.Register32 // 0x14
	ESR   volatile.Register32 // 0x18
	BTR   volatile.Register32 // 0x1C
	_     [352]byte
	TX    [3]CAN_TX_Type // 0x180
	RX    [2]CAN_RX_Type // 0x1B0
	_     [48]byte
	FMR   volatile.Register32 // 0x200
	FM1R  volatile.Register32 // 0x204
	_     [4]byte
	FS1R  volatile.Register32 // 0x20C
	_     [4]byte
	FFA1R volatile.Register32 // 0x214
	_     [4]byte
	FA1R  volatile.Register32 // 0x21C
	_     [32]byte
	FB    [28]CAN_FB_Type // 0x240
}

// CAN.MCR: master control register
func (o *CAN_Type) SetMCR_DBF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetMCR_DBF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetMCR_RESET(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetMCR_RESET() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetMCR_TTCM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetMCR_TTCM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetMCR_ABOM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetMCR_ABOM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetMCR_AWUM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetMCR_AWUM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetMCR_NART(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMCR_NART() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMCR_RFLM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMCR_RFLM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMCR_TXFP(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMCR_TXFP() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMCR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMCR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMCR_INRQ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMCR_INRQ() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}

// CAN.MSR: master status register
func (o *CAN_Type) SetMSR_RX(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetMSR_RX() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetMSR_SAMP(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetMSR_SAMP() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetMSR_RXM(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetMSR_RXM() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetMSR_TXM(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetMSR_TXM() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetMSR_SLAKI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMSR_SLAKI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMSR_WKUI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMSR_WKUI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMSR_ERRI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMSR_ERRI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMSR_SLAK(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMSR_SLAK() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMSR_INAK(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMSR_INAK() uint32 {
	return volatile.LoadUint32(&o.MSR.Reg) & 0x1
}

// CAN.TSR: transmit status register
func (o *CAN_Type) SetTSR_LOW2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetTSR_LOW2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80000000) >> 31
}
func (o *CAN_Type) SetTSR_LOW1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetTSR_LOW1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetTSR_LOW0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetTSR_LOW0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20000000) >> 29
}
func (o *CAN_Type) SetTSR_TME2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_Type) GetTSR_TME2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10000000) >> 28
}
func (o *CAN_Type) SetTSR_TME1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetTSR_TME1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8000000) >> 27
}
func (o *CAN_Type) SetTSR_TME0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetTSR_TME0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetTSR_CODE(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x3000000)|value<<24)
}
func (o *CAN_Type) GetTSR_CODE() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x3000000) >> 24
}
func (o *CAN_Type) SetTSR_ABRQ2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetTSR_ABRQ2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetTSR_TERR2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetTSR_TERR2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetTSR_ALST2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetTSR_ALST2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetTSR_TXOK2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetTSR_TXOK2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetTSR_RQCP2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetTSR_RQCP2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetTSR_ABRQ1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetTSR_ABRQ1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetTSR_TERR1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetTSR_TERR1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetTSR_ALST1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetTSR_ALST1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetTSR_TXOK1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetTSR_TXOK1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetTSR_RQCP1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetTSR_RQCP1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetTSR_ABRQ0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetTSR_ABRQ0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetTSR_TERR0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetTSR_TERR0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetTSR_ALST0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetTSR_ALST0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetTSR_TXOK0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetTSR_TXOK0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetTSR_RQCP0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetTSR_RQCP0() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg) & 0x1
}

// CAN.RF0R: receive FIFO %s register
func (o *CAN_Type) SetRF0R_RFOM(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetRF0R_RFOM() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetRF0R_FOVR(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetRF0R_FOVR() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetRF0R_FULL(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetRF0R_FULL() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetRF0R_FMP(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x3)|value)
}
func (o *CAN_Type) GetRF0R_FMP() uint32 {
	return volatile.LoadUint32(&o.RF0R.Reg) & 0x3
}

// CAN.RF1R: receive FIFO %s register
func (o *CAN_Type) SetRF1R_RFOM(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetRF1R_RFOM() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetRF1R_FOVR(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetRF1R_FOVR() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetRF1R_FULL(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetRF1R_FULL() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetRF1R_FMP(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x3)|value)
}
func (o *CAN_Type) GetRF1R_FMP() uint32 {
	return volatile.LoadUint32(&o.RF1R.Reg) & 0x3
}

// CAN.IER: interrupt enable register
func (o *CAN_Type) SetIER_SLKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetIER_SLKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetIER_WKUIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetIER_WKUIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetIER_ERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetIER_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetIER_LECIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetIER_LECIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetIER_BOFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetIER_BOFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetIER_EPVIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetIER_EPVIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetIER_EWGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetIER_EWGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetIER_FOVIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetIER_FOVIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetIER_FFIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetIER_FFIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetIER_FMPIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetIER_FMPIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetIER_FOVIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetIER_FOVIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetIER_FFIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetIER_FFIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetIER_FMPIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetIER_FMPIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetIER_TMEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetIER_TMEIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// CAN.ESR: error status register
func (o *CAN_Type) SetESR_REC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetESR_REC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0xff000000) >> 24
}
func (o *CAN_Type) SetESR_TEC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetESR_TEC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetESR_LEC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x70)|value<<4)
}
func (o *CAN_Type) GetESR_LEC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x70) >> 4
}
func (o *CAN_Type) SetESR_BOFF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetESR_BOFF() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetESR_EPVF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetESR_EPVF() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetESR_EWGF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetESR_EWGF() uint32 {
	return volatile.LoadUint32(&o.ESR.Reg) & 0x1
}

// CAN.BTR: bit timing register
func (o *CAN_Type) SetBTR_SILM(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetBTR_SILM() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x80000000) >> 31
}
func (o *CAN_Type) SetBTR_LBKM(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetBTR_LBKM() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetBTR_SJW(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3000000)|value<<24)
}
func (o *CAN_Type) GetBTR_SJW() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x3000000) >> 24
}
func (o *CAN_Type) SetBTR_TS2(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x700000)|value<<20)
}
func (o *CAN_Type) GetBTR_TS2() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x700000) >> 20
}
func (o *CAN_Type) SetBTR_TS1(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetBTR_TS1() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetBTR_BRP(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3ff)|value)
}
func (o *CAN_Type) GetBTR_BRP() uint32 {
	return volatile.LoadUint32(&o.BTR.Reg) & 0x3ff
}

// CAN.FMR: filter master register
func (o *CAN_Type) SetFMR_CAN2SB(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x3f00)|value<<8)
}
func (o *CAN_Type) GetFMR_CAN2SB() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x3f00) >> 8
}
func (o *CAN_Type) SetFMR_FINIT(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFMR_FINIT() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0x1
}

// CAN.FM1R: filter mode register
func (o *CAN_Type) SetFM1R_FBM0(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFM1R_FBM0() uint32 {
	return volatile.LoadUint32(&o.FM1R.Reg) & 0x1
}
func (o *CAN_Type) SetFM1R_FBM1(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFM1R_FBM1() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFM1R_FBM2(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFM1R_FBM2() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFM1R_FBM3(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFM1R_FBM3() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFM1R_FBM4(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFM1R_FBM4() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFM1R_FBM5(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFM1R_FBM5() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFM1R_FBM6(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFM1R_FBM6() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFM1R_FBM7(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFM1R_FBM7() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFM1R_FBM8(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFM1R_FBM8() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFM1R_FBM9(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFM1R_FBM9() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFM1R_FBM10(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFM1R_FBM10() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFM1R_FBM11(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFM1R_FBM11() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFM1R_FBM12(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFM1R_FBM12() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFM1R_FBM13(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFM1R_FBM13() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFM1R_FBM14(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFM1R_FBM14() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFM1R_FBM15(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFM1R_FBM15() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFM1R_FBM16(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFM1R_FBM16() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFM1R_FBM17(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFM1R_FBM17() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFM1R_FBM18(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFM1R_FBM18() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFM1R_FBM19(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFM1R_FBM19() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFM1R_FBM20(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFM1R_FBM20() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFM1R_FBM21(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFM1R_FBM21() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFM1R_FBM22(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFM1R_FBM22() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFM1R_FBM23(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFM1R_FBM23() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFM1R_FBM24(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFM1R_FBM24() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFM1R_FBM25(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFM1R_FBM25() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFM1R_FBM26(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFM1R_FBM26() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFM1R_FBM27(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFM1R_FBM27() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8000000) >> 27
}

// CAN.FS1R: filter scale register
func (o *CAN_Type) SetFS1R_FSC0(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFS1R_FSC0() uint32 {
	return volatile.LoadUint32(&o.FS1R.Reg) & 0x1
}
func (o *CAN_Type) SetFS1R_FSC1(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFS1R_FSC1() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFS1R_FSC2(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFS1R_FSC2() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFS1R_FSC3(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFS1R_FSC3() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFS1R_FSC4(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFS1R_FSC4() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFS1R_FSC5(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFS1R_FSC5() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFS1R_FSC6(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFS1R_FSC6() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFS1R_FSC7(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFS1R_FSC7() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFS1R_FSC8(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFS1R_FSC8() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFS1R_FSC9(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFS1R_FSC9() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFS1R_FSC10(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFS1R_FSC10() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFS1R_FSC11(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFS1R_FSC11() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFS1R_FSC12(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFS1R_FSC12() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFS1R_FSC13(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFS1R_FSC13() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFS1R_FSC14(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFS1R_FSC14() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFS1R_FSC15(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFS1R_FSC15() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFS1R_FSC16(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFS1R_FSC16() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFS1R_FSC17(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFS1R_FSC17() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFS1R_FSC18(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFS1R_FSC18() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFS1R_FSC19(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFS1R_FSC19() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFS1R_FSC20(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFS1R_FSC20() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFS1R_FSC21(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFS1R_FSC21() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFS1R_FSC22(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFS1R_FSC22() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFS1R_FSC23(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFS1R_FSC23() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFS1R_FSC24(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFS1R_FSC24() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFS1R_FSC25(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFS1R_FSC25() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFS1R_FSC26(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFS1R_FSC26() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFS1R_FSC27(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFS1R_FSC27() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8000000) >> 27
}

// CAN.FFA1R: filter FIFO assignment register
func (o *CAN_Type) SetFFA1R_FFA0(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFFA1R_FFA0() uint32 {
	return volatile.LoadUint32(&o.FFA1R.Reg) & 0x1
}
func (o *CAN_Type) SetFFA1R_FFA1(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFFA1R_FFA1() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFFA1R_FFA2(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFFA1R_FFA2() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFFA1R_FFA3(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFFA1R_FFA3() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFFA1R_FFA4(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFFA1R_FFA4() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFFA1R_FFA5(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFFA1R_FFA5() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFFA1R_FFA6(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFFA1R_FFA6() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFFA1R_FFA7(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFFA1R_FFA7() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFFA1R_FFA8(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFFA1R_FFA8() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFFA1R_FFA9(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFFA1R_FFA9() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFFA1R_FFA10(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFFA1R_FFA10() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFFA1R_FFA11(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFFA1R_FFA11() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFFA1R_FFA12(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFFA1R_FFA12() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFFA1R_FFA13(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFFA1R_FFA13() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFFA1R_FFA14(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFFA1R_FFA14() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFFA1R_FFA15(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFFA1R_FFA15() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFFA1R_FFA16(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFFA1R_FFA16() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFFA1R_FFA17(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFFA1R_FFA17() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFFA1R_FFA18(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFFA1R_FFA18() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFFA1R_FFA19(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFFA1R_FFA19() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFFA1R_FFA20(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFFA1R_FFA20() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFFA1R_FFA21(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFFA1R_FFA21() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFFA1R_FFA22(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFFA1R_FFA22() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFFA1R_FFA23(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFFA1R_FFA23() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFFA1R_FFA24(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFFA1R_FFA24() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFFA1R_FFA25(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFFA1R_FFA25() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFFA1R_FFA26(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFFA1R_FFA26() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFFA1R_FFA27(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFFA1R_FFA27() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8000000) >> 27
}

// CAN.FA1R: CAN filter activation register
func (o *CAN_Type) SetFA1R_FACT0(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFA1R_FACT0() uint32 {
	return volatile.LoadUint32(&o.FA1R.Reg) & 0x1
}
func (o *CAN_Type) SetFA1R_FACT1(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFA1R_FACT1() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFA1R_FACT2(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFA1R_FACT2() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFA1R_FACT3(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFA1R_FACT3() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFA1R_FACT4(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFA1R_FACT4() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFA1R_FACT5(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFA1R_FACT5() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFA1R_FACT6(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFA1R_FACT6() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFA1R_FACT7(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFA1R_FACT7() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFA1R_FACT8(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFA1R_FACT8() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFA1R_FACT9(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFA1R_FACT9() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFA1R_FACT10(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFA1R_FACT10() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFA1R_FACT11(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFA1R_FACT11() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFA1R_FACT12(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFA1R_FACT12() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFA1R_FACT13(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFA1R_FACT13() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2000) >> 13
}
func (o *CAN_Type) SetFA1R_FACT14(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_Type) GetFA1R_FACT14() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4000) >> 14
}
func (o *CAN_Type) SetFA1R_FACT15(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetFA1R_FACT15() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetFA1R_FACT16(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetFA1R_FACT16() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetFA1R_FACT17(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetFA1R_FACT17() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetFA1R_FACT18(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetFA1R_FACT18() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetFA1R_FACT19(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetFA1R_FACT19() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetFA1R_FACT20(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_Type) GetFA1R_FACT20() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x100000) >> 20
}
func (o *CAN_Type) SetFA1R_FACT21(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_Type) GetFA1R_FACT21() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x200000) >> 21
}
func (o *CAN_Type) SetFA1R_FACT22(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_Type) GetFA1R_FACT22() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x400000) >> 22
}
func (o *CAN_Type) SetFA1R_FACT23(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetFA1R_FACT23() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetFA1R_FACT24(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_Type) GetFA1R_FACT24() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x1000000) >> 24
}
func (o *CAN_Type) SetFA1R_FACT25(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_Type) GetFA1R_FACT25() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2000000) >> 25
}
func (o *CAN_Type) SetFA1R_FACT26(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetFA1R_FACT26() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetFA1R_FACT27(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetFA1R_FACT27() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8000000) >> 27
}

type CAN_TX_Type struct {
	TIR  volatile.Register32 // 0x180
	TDTR volatile.Register32 // 0x184
	TDLR volatile.Register32 // 0x188
	TDHR volatile.Register32 // 0x18C
}

// CAN_TX.TIR: TX mailbox identifier register
func (o *CAN_TX_Type) SetTIR_STID(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0xffe00000)|value<<21)
}
func (o *CAN_TX_Type) GetTIR_STID() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0xffe00000) >> 21
}
func (o *CAN_TX_Type) SetTIR_EXID(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x1ffff8)|value<<3)
}
func (o *CAN_TX_Type) GetTIR_EXID() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x1ffff8) >> 3
}
func (o *CAN_TX_Type) SetTIR_IDE(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_TX_Type) GetTIR_IDE() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x4) >> 2
}
func (o *CAN_TX_Type) SetTIR_RTR(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_TX_Type) GetTIR_RTR() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x2) >> 1
}
func (o *CAN_TX_Type) SetTIR_TXRQ(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x1)|value)
}
func (o *CAN_TX_Type) GetTIR_TXRQ() uint32 {
	return volatile.LoadUint32(&o.TIR.Reg) & 0x1
}

// CAN_TX.TDTR: mailbox data length control and time stamp register
func (o *CAN_TX_Type) SetTDTR_TIME(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDTR_TIME() uint32 {
	return (volatile.LoadUint32(&o.TDTR.Reg) & 0xffff0000) >> 16
}
func (o *CAN_TX_Type) SetTDTR_TGT(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_TX_Type) GetTDTR_TGT() uint32 {
	return (volatile.LoadUint32(&o.TDTR.Reg) & 0x100) >> 8
}
func (o *CAN_TX_Type) SetTDTR_DLC(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0xf)|value)
}
func (o *CAN_TX_Type) GetTDTR_DLC() uint32 {
	return volatile.LoadUint32(&o.TDTR.Reg) & 0xf
}

// CAN_TX.TDLR: mailbox data low register
func (o *CAN_TX_Type) SetTDLR_DATA3(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_TX_Type) GetTDLR_DATA3() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff000000) >> 24
}
func (o *CAN_TX_Type) SetTDLR_DATA2(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDLR_DATA2() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff0000) >> 16
}
func (o *CAN_TX_Type) SetTDLR_DATA1(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_TX_Type) GetTDLR_DATA1() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff00) >> 8
}
func (o *CAN_TX_Type) SetTDLR_DATA0(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff)|value)
}
func (o *CAN_TX_Type) GetTDLR_DATA0() uint32 {
	return volatile.LoadUint32(&o.TDLR.Reg) & 0xff
}

// CAN_TX.TDHR: mailbox data high register
func (o *CAN_TX_Type) SetTDHR_DATA7(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_TX_Type) GetTDHR_DATA7() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff000000) >> 24
}
func (o *CAN_TX_Type) SetTDHR_DATA6(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDHR_DATA6() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff0000) >> 16
}
func (o *CAN_TX_Type) SetTDHR_DATA5(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_TX_Type) GetTDHR_DATA5() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff00) >> 8
}
func (o *CAN_TX_Type) SetTDHR_DATA4(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff)|value)
}
func (o *CAN_TX_Type) GetTDHR_DATA4() uint32 {
	return volatile.LoadUint32(&o.TDHR.Reg) & 0xff
}

type CAN_RX_Type struct {
	RIR  volatile.Register32 // 0x1B0
	RDTR volatile.Register32 // 0x1B4
	RDLR volatile.Register32 // 0x1B8
	RDHR volatile.Register32 // 0x1BC
}

// CAN_RX.RIR: receive FIFO mailbox identifier register
func (o *CAN_RX_Type) SetRIR_STID(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0xffe00000)|value<<21)
}
func (o *CAN_RX_Type) GetRIR_STID() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0xffe00000) >> 21
}
func (o *CAN_RX_Type) SetRIR_EXID(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x1ffff8)|value<<3)
}
func (o *CAN_RX_Type) GetRIR_EXID() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x1ffff8) >> 3
}
func (o *CAN_RX_Type) SetRIR_IDE(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_RX_Type) GetRIR_IDE() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x4) >> 2
}
func (o *CAN_RX_Type) SetRIR_RTR(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_RX_Type) GetRIR_RTR() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x2) >> 1
}

// CAN_RX.RDTR: receive FIFO mailbox data length control and time stamp register
func (o *CAN_RX_Type) SetRDTR_TIME(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDTR_TIME() uint32 {
	return (volatile.LoadUint32(&o.RDTR.Reg) & 0xffff0000) >> 16
}
func (o *CAN_RX_Type) SetRDTR_FMI(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDTR_FMI() uint32 {
	return (volatile.LoadUint32(&o.RDTR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDTR_DLC(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xf)|value)
}
func (o *CAN_RX_Type) GetRDTR_DLC() uint32 {
	return volatile.LoadUint32(&o.RDTR.Reg) & 0xf
}

// CAN_RX.RDLR: receive FIFO mailbox data low register
func (o *CAN_RX_Type) SetRDLR_DATA3(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_RX_Type) GetRDLR_DATA3() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff000000) >> 24
}
func (o *CAN_RX_Type) SetRDLR_DATA2(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDLR_DATA2() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff0000) >> 16
}
func (o *CAN_RX_Type) SetRDLR_DATA1(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDLR_DATA1() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDLR_DATA0(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff)|value)
}
func (o *CAN_RX_Type) GetRDLR_DATA0() uint32 {
	return volatile.LoadUint32(&o.RDLR.Reg) & 0xff
}

// CAN_RX.RDHR: receive FIFO mailbox data high register
func (o *CAN_RX_Type) SetRDHR_DATA7(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_RX_Type) GetRDHR_DATA7() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff000000) >> 24
}
func (o *CAN_RX_Type) SetRDHR_DATA6(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDHR_DATA6() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff0000) >> 16
}
func (o *CAN_RX_Type) SetRDHR_DATA5(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDHR_DATA5() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDHR_DATA4(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff)|value)
}
func (o *CAN_RX_Type) GetRDHR_DATA4() uint32 {
	return volatile.LoadUint32(&o.RDHR.Reg) & 0xff
}

type CAN_FB_Type struct {
	FR1 volatile.Register32 // 0x240
	FR2 volatile.Register32 // 0x244
}

// CAN_FB.FR1: Filter bank 0 register 1
func (o *CAN_FB_Type) SetFR1_FB0(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x1)|value)
}
func (o *CAN_FB_Type) GetFR1_FB0() uint32 {
	return volatile.LoadUint32(&o.FR1.Reg) & 0x1
}
func (o *CAN_FB_Type) SetFR1_FB1(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x2)|value<<1)
}
func (o *CAN_FB_Type) GetFR1_FB1() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x2) >> 1
}
func (o *CAN_FB_Type) SetFR1_FB2(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x4)|value<<2)
}
func (o *CAN_FB_Type) GetFR1_FB2() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x4) >> 2
}
func (o *CAN_FB_Type) SetFR1_FB3(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x8)|value<<3)
}
func (o *CAN_FB_Type) GetFR1_FB3() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x8) >> 3
}
func (o *CAN_FB_Type) SetFR1_FB4(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x10)|value<<4)
}
func (o *CAN_FB_Type) GetFR1_FB4() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x10) >> 4
}
func (o *CAN_FB_Type) SetFR1_FB5(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x20)|value<<5)
}
func (o *CAN_FB_Type) GetFR1_FB5() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x20) >> 5
}
func (o *CAN_FB_Type) SetFR1_FB6(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x40)|value<<6)
}
func (o *CAN_FB_Type) GetFR1_FB6() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x40) >> 6
}
func (o *CAN_FB_Type) SetFR1_FB7(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x80)|value<<7)
}
func (o *CAN_FB_Type) GetFR1_FB7() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x80) >> 7
}
func (o *CAN_FB_Type) SetFR1_FB8(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x100)|value<<8)
}
func (o *CAN_FB_Type) GetFR1_FB8() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x100) >> 8
}
func (o *CAN_FB_Type) SetFR1_FB9(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x200)|value<<9)
}
func (o *CAN_FB_Type) GetFR1_FB9() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x200) >> 9
}
func (o *CAN_FB_Type) SetFR1_FB10(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x400)|value<<10)
}
func (o *CAN_FB_Type) GetFR1_FB10() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x400) >> 10
}
func (o *CAN_FB_Type) SetFR1_FB11(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x800)|value<<11)
}
func (o *CAN_FB_Type) GetFR1_FB11() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x800) >> 11
}
func (o *CAN_FB_Type) SetFR1_FB12(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_FB_Type) GetFR1_FB12() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x1000) >> 12
}
func (o *CAN_FB_Type) SetFR1_FB13(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_FB_Type) GetFR1_FB13() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x2000) >> 13
}
func (o *CAN_FB_Type) SetFR1_FB14(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_FB_Type) GetFR1_FB14() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x4000) >> 14
}
func (o *CAN_FB_Type) SetFR1_FB15(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_FB_Type) GetFR1_FB15() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x8000) >> 15
}
func (o *CAN_FB_Type) SetFR1_FB16(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_FB_Type) GetFR1_FB16() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x10000) >> 16
}
func (o *CAN_FB_Type) SetFR1_FB17(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_FB_Type) GetFR1_FB17() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x20000) >> 17
}
func (o *CAN_FB_Type) SetFR1_FB18(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_FB_Type) GetFR1_FB18() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x40000) >> 18
}
func (o *CAN_FB_Type) SetFR1_FB19(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_FB_Type) GetFR1_FB19() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x80000) >> 19
}
func (o *CAN_FB_Type) SetFR1_FB20(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_FB_Type) GetFR1_FB20() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x100000) >> 20
}
func (o *CAN_FB_Type) SetFR1_FB21(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_FB_Type) GetFR1_FB21() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x200000) >> 21
}
func (o *CAN_FB_Type) SetFR1_FB22(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_FB_Type) GetFR1_FB22() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x400000) >> 22
}
func (o *CAN_FB_Type) SetFR1_FB23(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_FB_Type) GetFR1_FB23() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x800000) >> 23
}
func (o *CAN_FB_Type) SetFR1_FB24(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_FB_Type) GetFR1_FB24() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x1000000) >> 24
}
func (o *CAN_FB_Type) SetFR1_FB25(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_FB_Type) GetFR1_FB25() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x2000000) >> 25
}
func (o *CAN_FB_Type) SetFR1_FB26(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_FB_Type) GetFR1_FB26() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x4000000) >> 26
}
func (o *CAN_FB_Type) SetFR1_FB27(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_FB_Type) GetFR1_FB27() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x8000000) >> 27
}
func (o *CAN_FB_Type) SetFR1_FB28(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_FB_Type) GetFR1_FB28() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x10000000) >> 28
}
func (o *CAN_FB_Type) SetFR1_FB29(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_FB_Type) GetFR1_FB29() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x20000000) >> 29
}
func (o *CAN_FB_Type) SetFR1_FB30(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_FB_Type) GetFR1_FB30() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x40000000) >> 30
}
func (o *CAN_FB_Type) SetFR1_FB31(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_FB_Type) GetFR1_FB31() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x80000000) >> 31
}

// CAN_FB.FR2: Filter bank 0 register 2
func (o *CAN_FB_Type) SetFR2_FB0(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x1)|value)
}
func (o *CAN_FB_Type) GetFR2_FB0() uint32 {
	return volatile.LoadUint32(&o.FR2.Reg) & 0x1
}
func (o *CAN_FB_Type) SetFR2_FB1(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x2)|value<<1)
}
func (o *CAN_FB_Type) GetFR2_FB1() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x2) >> 1
}
func (o *CAN_FB_Type) SetFR2_FB2(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x4)|value<<2)
}
func (o *CAN_FB_Type) GetFR2_FB2() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x4) >> 2
}
func (o *CAN_FB_Type) SetFR2_FB3(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x8)|value<<3)
}
func (o *CAN_FB_Type) GetFR2_FB3() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x8) >> 3
}
func (o *CAN_FB_Type) SetFR2_FB4(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x10)|value<<4)
}
func (o *CAN_FB_Type) GetFR2_FB4() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x10) >> 4
}
func (o *CAN_FB_Type) SetFR2_FB5(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x20)|value<<5)
}
func (o *CAN_FB_Type) GetFR2_FB5() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x20) >> 5
}
func (o *CAN_FB_Type) SetFR2_FB6(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x40)|value<<6)
}
func (o *CAN_FB_Type) GetFR2_FB6() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x40) >> 6
}
func (o *CAN_FB_Type) SetFR2_FB7(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x80)|value<<7)
}
func (o *CAN_FB_Type) GetFR2_FB7() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x80) >> 7
}
func (o *CAN_FB_Type) SetFR2_FB8(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x100)|value<<8)
}
func (o *CAN_FB_Type) GetFR2_FB8() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x100) >> 8
}
func (o *CAN_FB_Type) SetFR2_FB9(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x200)|value<<9)
}
func (o *CAN_FB_Type) GetFR2_FB9() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x200) >> 9
}
func (o *CAN_FB_Type) SetFR2_FB10(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x400)|value<<10)
}
func (o *CAN_FB_Type) GetFR2_FB10() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x400) >> 10
}
func (o *CAN_FB_Type) SetFR2_FB11(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x800)|value<<11)
}
func (o *CAN_FB_Type) GetFR2_FB11() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x800) >> 11
}
func (o *CAN_FB_Type) SetFR2_FB12(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_FB_Type) GetFR2_FB12() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x1000) >> 12
}
func (o *CAN_FB_Type) SetFR2_FB13(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_FB_Type) GetFR2_FB13() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x2000) >> 13
}
func (o *CAN_FB_Type) SetFR2_FB14(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_FB_Type) GetFR2_FB14() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x4000) >> 14
}
func (o *CAN_FB_Type) SetFR2_FB15(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_FB_Type) GetFR2_FB15() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x8000) >> 15
}
func (o *CAN_FB_Type) SetFR2_FB16(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_FB_Type) GetFR2_FB16() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x10000) >> 16
}
func (o *CAN_FB_Type) SetFR2_FB17(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_FB_Type) GetFR2_FB17() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x20000) >> 17
}
func (o *CAN_FB_Type) SetFR2_FB18(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_FB_Type) GetFR2_FB18() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x40000) >> 18
}
func (o *CAN_FB_Type) SetFR2_FB19(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_FB_Type) GetFR2_FB19() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x80000) >> 19
}
func (o *CAN_FB_Type) SetFR2_FB20(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_FB_Type) GetFR2_FB20() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x100000) >> 20
}
func (o *CAN_FB_Type) SetFR2_FB21(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_FB_Type) GetFR2_FB21() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x200000) >> 21
}
func (o *CAN_FB_Type) SetFR2_FB22(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_FB_Type) GetFR2_FB22() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x400000) >> 22
}
func (o *CAN_FB_Type) SetFR2_FB23(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_FB_Type) GetFR2_FB23() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x800000) >> 23
}
func (o *CAN_FB_Type) SetFR2_FB24(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_FB_Type) GetFR2_FB24() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x1000000) >> 24
}
func (o *CAN_FB_Type) SetFR2_FB25(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_FB_Type) GetFR2_FB25() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x2000000) >> 25
}
func (o *CAN_FB_Type) SetFR2_FB26(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_FB_Type) GetFR2_FB26() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x4000000) >> 26
}
func (o *CAN_FB_Type) SetFR2_FB27(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_FB_Type) GetFR2_FB27() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x8000000) >> 27
}
func (o *CAN_FB_Type) SetFR2_FB28(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_FB_Type) GetFR2_FB28() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x10000000) >> 28
}
func (o *CAN_FB_Type) SetFR2_FB29(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_FB_Type) GetFR2_FB29() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x20000000) >> 29
}
func (o *CAN_FB_Type) SetFR2_FB30(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_FB_Type) GetFR2_FB30() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x40000000) >> 30
}
func (o *CAN_FB_Type) SetFR2_FB31(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_FB_Type) GetFR2_FB31() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x80000000) >> 31
}

// Universal serial bus full-speed device interface
type USB_Type struct {
	EP0R   volatile.Register32 // 0x0
	EP1R   volatile.Register32 // 0x4
	EP2R   volatile.Register32 // 0x8
	EP3R   volatile.Register32 // 0xC
	EP4R   volatile.Register32 // 0x10
	EP5R   volatile.Register32 // 0x14
	EP6R   volatile.Register32 // 0x18
	EP7R   volatile.Register32 // 0x1C
	_      [32]byte
	CNTR   volatile.Register32 // 0x40
	ISTR   volatile.Register32 // 0x44
	FNR    volatile.Register32 // 0x48
	DADDR  volatile.Register32 // 0x4C
	BTABLE volatile.Register32 // 0x50
}

// USB.EP0R: endpoint 0 register
func (o *USB_Type) SetEP0R_EA(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP0R_EA() uint32 {
	return volatile.LoadUint32(&o.EP0R.Reg) & 0xf
}
func (o *USB_Type) SetEP0R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP0R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP0R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP0R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP0R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP0R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP0R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP0R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP0R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP0R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP0R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP0R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP0R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP0R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP0R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP0R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP0R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP0R.Reg, volatile.LoadUint32(&o.EP0R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP0R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP0R.Reg) & 0x8000) >> 15
}

// USB.EP1R: endpoint 1 register
func (o *USB_Type) SetEP1R_EA(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP1R_EA() uint32 {
	return volatile.LoadUint32(&o.EP1R.Reg) & 0xf
}
func (o *USB_Type) SetEP1R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP1R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP1R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP1R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP1R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP1R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP1R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP1R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP1R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP1R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP1R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP1R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP1R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP1R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP1R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP1R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP1R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP1R.Reg, volatile.LoadUint32(&o.EP1R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP1R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP1R.Reg) & 0x8000) >> 15
}

// USB.EP2R: endpoint 2 register
func (o *USB_Type) SetEP2R_EA(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP2R_EA() uint32 {
	return volatile.LoadUint32(&o.EP2R.Reg) & 0xf
}
func (o *USB_Type) SetEP2R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP2R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP2R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP2R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP2R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP2R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP2R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP2R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP2R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP2R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP2R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP2R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP2R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP2R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP2R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP2R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP2R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP2R.Reg, volatile.LoadUint32(&o.EP2R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP2R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP2R.Reg) & 0x8000) >> 15
}

// USB.EP3R: endpoint 3 register
func (o *USB_Type) SetEP3R_EA(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP3R_EA() uint32 {
	return volatile.LoadUint32(&o.EP3R.Reg) & 0xf
}
func (o *USB_Type) SetEP3R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP3R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP3R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP3R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP3R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP3R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP3R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP3R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP3R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP3R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP3R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP3R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP3R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP3R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP3R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP3R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP3R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP3R.Reg, volatile.LoadUint32(&o.EP3R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP3R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP3R.Reg) & 0x8000) >> 15
}

// USB.EP4R: endpoint 4 register
func (o *USB_Type) SetEP4R_EA(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP4R_EA() uint32 {
	return volatile.LoadUint32(&o.EP4R.Reg) & 0xf
}
func (o *USB_Type) SetEP4R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP4R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP4R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP4R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP4R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP4R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP4R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP4R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP4R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP4R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP4R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP4R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP4R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP4R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP4R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP4R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP4R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP4R.Reg, volatile.LoadUint32(&o.EP4R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP4R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP4R.Reg) & 0x8000) >> 15
}

// USB.EP5R: endpoint 5 register
func (o *USB_Type) SetEP5R_EA(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP5R_EA() uint32 {
	return volatile.LoadUint32(&o.EP5R.Reg) & 0xf
}
func (o *USB_Type) SetEP5R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP5R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP5R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP5R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP5R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP5R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP5R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP5R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP5R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP5R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP5R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP5R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP5R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP5R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP5R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP5R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP5R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP5R.Reg, volatile.LoadUint32(&o.EP5R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP5R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP5R.Reg) & 0x8000) >> 15
}

// USB.EP6R: endpoint 6 register
func (o *USB_Type) SetEP6R_EA(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP6R_EA() uint32 {
	return volatile.LoadUint32(&o.EP6R.Reg) & 0xf
}
func (o *USB_Type) SetEP6R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP6R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP6R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP6R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP6R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP6R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP6R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP6R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP6R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP6R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP6R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP6R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP6R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP6R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP6R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP6R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP6R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP6R.Reg, volatile.LoadUint32(&o.EP6R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP6R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP6R.Reg) & 0x8000) >> 15
}

// USB.EP7R: endpoint 7 register
func (o *USB_Type) SetEP7R_EA(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetEP7R_EA() uint32 {
	return volatile.LoadUint32(&o.EP7R.Reg) & 0xf
}
func (o *USB_Type) SetEP7R_STAT_TX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x30)|value<<4)
}
func (o *USB_Type) GetEP7R_STAT_TX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x30) >> 4
}
func (o *USB_Type) SetEP7R_DTOG_TX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetEP7R_DTOG_TX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetEP7R_CTR_TX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetEP7R_CTR_TX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x80) >> 7
}
func (o *USB_Type) SetEP7R_EP_KIND(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetEP7R_EP_KIND() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetEP7R_EP_TYPE(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x600)|value<<9)
}
func (o *USB_Type) GetEP7R_EP_TYPE() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x600) >> 9
}
func (o *USB_Type) SetEP7R_SETUP(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetEP7R_SETUP() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetEP7R_STAT_RX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x3000)|value<<12)
}
func (o *USB_Type) GetEP7R_STAT_RX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x3000) >> 12
}
func (o *USB_Type) SetEP7R_DTOG_RX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetEP7R_DTOG_RX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetEP7R_CTR_RX(value uint32) {
	volatile.StoreUint32(&o.EP7R.Reg, volatile.LoadUint32(&o.EP7R.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetEP7R_CTR_RX() uint32 {
	return (volatile.LoadUint32(&o.EP7R.Reg) & 0x8000) >> 15
}

// USB.CNTR: control register
func (o *USB_Type) SetCNTR_FRES(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetCNTR_FRES() uint32 {
	return volatile.LoadUint32(&o.CNTR.Reg) & 0x1
}
func (o *USB_Type) SetCNTR_PDWN(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetCNTR_PDWN() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetCNTR_LPMODE(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetCNTR_LPMODE() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetCNTR_FSUSP(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetCNTR_FSUSP() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetCNTR_RESUME(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetCNTR_RESUME() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetCNTR_ESOFM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetCNTR_ESOFM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetCNTR_SOFM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetCNTR_SOFM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetCNTR_RESETM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetCNTR_RESETM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetCNTR_SUSPM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetCNTR_SUSPM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetCNTR_WKUPM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetCNTR_WKUPM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetCNTR_ERRM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetCNTR_ERRM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetCNTR_PMAOVRM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetCNTR_PMAOVRM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetCNTR_CTRM(value uint32) {
	volatile.StoreUint32(&o.CNTR.Reg, volatile.LoadUint32(&o.CNTR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetCNTR_CTRM() uint32 {
	return (volatile.LoadUint32(&o.CNTR.Reg) & 0x8000) >> 15
}

// USB.ISTR: interrupt status register
func (o *USB_Type) SetISTR_EP_ID(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0xf)|value)
}
func (o *USB_Type) GetISTR_EP_ID() uint32 {
	return volatile.LoadUint32(&o.ISTR.Reg) & 0xf
}
func (o *USB_Type) SetISTR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetISTR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetISTR_ESOF(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x100)|value<<8)
}
func (o *USB_Type) GetISTR_ESOF() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x100) >> 8
}
func (o *USB_Type) SetISTR_SOF(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x200)|value<<9)
}
func (o *USB_Type) GetISTR_SOF() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x200) >> 9
}
func (o *USB_Type) SetISTR_RESET(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x400)|value<<10)
}
func (o *USB_Type) GetISTR_RESET() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x400) >> 10
}
func (o *USB_Type) SetISTR_SUSP(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x800)|value<<11)
}
func (o *USB_Type) GetISTR_SUSP() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x800) >> 11
}
func (o *USB_Type) SetISTR_WKUP(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x1000)|value<<12)
}
func (o *USB_Type) GetISTR_WKUP() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x1000) >> 12
}
func (o *USB_Type) SetISTR_ERR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetISTR_ERR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetISTR_PMAOVR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetISTR_PMAOVR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetISTR_CTR(value uint32) {
	volatile.StoreUint32(&o.ISTR.Reg, volatile.LoadUint32(&o.ISTR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetISTR_CTR() uint32 {
	return (volatile.LoadUint32(&o.ISTR.Reg) & 0x8000) >> 15
}

// USB.FNR: frame number register
func (o *USB_Type) SetFNR_FN(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x7ff)|value)
}
func (o *USB_Type) GetFNR_FN() uint32 {
	return volatile.LoadUint32(&o.FNR.Reg) & 0x7ff
}
func (o *USB_Type) SetFNR_LSOF(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x1800)|value<<11)
}
func (o *USB_Type) GetFNR_LSOF() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x1800) >> 11
}
func (o *USB_Type) SetFNR_LCK(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x2000)|value<<13)
}
func (o *USB_Type) GetFNR_LCK() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x2000) >> 13
}
func (o *USB_Type) SetFNR_RXDM(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x4000)|value<<14)
}
func (o *USB_Type) GetFNR_RXDM() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x4000) >> 14
}
func (o *USB_Type) SetFNR_RXDP(value uint32) {
	volatile.StoreUint32(&o.FNR.Reg, volatile.LoadUint32(&o.FNR.Reg)&^(0x8000)|value<<15)
}
func (o *USB_Type) GetFNR_RXDP() uint32 {
	return (volatile.LoadUint32(&o.FNR.Reg) & 0x8000) >> 15
}

// USB.DADDR: device address
func (o *USB_Type) SetDADDR_ADD(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x1)|value)
}
func (o *USB_Type) GetDADDR_ADD() uint32 {
	return volatile.LoadUint32(&o.DADDR.Reg) & 0x1
}
func (o *USB_Type) SetDADDR_ADD1(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x2)|value<<1)
}
func (o *USB_Type) GetDADDR_ADD1() uint32 {
	return (volatile.LoadUint32(&o.DADDR.Reg) & 0x2) >> 1
}
func (o *USB_Type) SetDADDR_ADD2(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x4)|value<<2)
}
func (o *USB_Type) GetDADDR_ADD2() uint32 {
	return (volatile.LoadUint32(&o.DADDR.Reg) & 0x4) >> 2
}
func (o *USB_Type) SetDADDR_ADD3(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x8)|value<<3)
}
func (o *USB_Type) GetDADDR_ADD3() uint32 {
	return (volatile.LoadUint32(&o.DADDR.Reg) & 0x8) >> 3
}
func (o *USB_Type) SetDADDR_ADD4(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x10)|value<<4)
}
func (o *USB_Type) GetDADDR_ADD4() uint32 {
	return (volatile.LoadUint32(&o.DADDR.Reg) & 0x10) >> 4
}
func (o *USB_Type) SetDADDR_ADD5(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x20)|value<<5)
}
func (o *USB_Type) GetDADDR_ADD5() uint32 {
	return (volatile.LoadUint32(&o.DADDR.Reg) & 0x20) >> 5
}
func (o *USB_Type) SetDADDR_ADD6(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x40)|value<<6)
}
func (o *USB_Type) GetDADDR_ADD6() uint32 {
	return (volatile.LoadUint32(&o.DADDR.Reg) & 0x40) >> 6
}
func (o *USB_Type) SetDADDR_EF(value uint32) {
	volatile.StoreUint32(&o.DADDR.Reg, volatile.LoadUint32(&o.DADDR.Reg)&^(0x80)|value<<7)
}
func (o *USB_Type) GetDADDR_EF() uint32 {
	return (volatile.LoadUint32(&o.DADDR.Reg) & 0x80) >> 7
}

// USB.BTABLE: Buffer table address
func (o *USB_Type) SetBTABLE(value uint32) {
	volatile.StoreUint32(&o.BTABLE.Reg, volatile.LoadUint32(&o.BTABLE.Reg)&^(0xfff8)|value<<3)
}
func (o *USB_Type) GetBTABLE() uint32 {
	return (volatile.LoadUint32(&o.BTABLE.Reg) & 0xfff8) >> 3
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// I2C.CR1: Control register 1
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *I2C_Type) SetCR1_TXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_TXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_RXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCR1_RXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCR1_ADDRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_ADDRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_NACKIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_NACKIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_STOPIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_STOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_DNF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00)|value<<8)
}
func (o *I2C_Type) GetCR1_DNF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00) >> 8
}
func (o *I2C_Type) SetCR1_ANFOFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_ANFOFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR1_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_SBC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetCR1_SBC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetCR1_WUPEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40000)|value<<18)
}
func (o *I2C_Type) GetCR1_WUPEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40000) >> 18
}
func (o *I2C_Type) SetCR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetCR1_GCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetCR1_SMBHEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCR1_SMBHEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCR1_SMBDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCR1_SMBDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetCR1_ALERTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *I2C_Type) GetCR1_ALERTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *I2C_Type) SetCR1_PECEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *I2C_Type) GetCR1_PECEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// I2C.CR2: Control register 2
func (o *I2C_Type) SetCR2_PECBYTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetCR2_PECBYTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}
func (o *I2C_Type) SetCR2_AUTOEND(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetCR2_AUTOEND() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetCR2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetCR2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetCR2_NBYTES(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetCR2_NBYTES() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *I2C_Type) SetCR2_NACK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR2_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR2_START(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR2_START() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR2_HEAD10R(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_HEAD10R() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_ADD10(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_ADD10() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_RD_WRN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_RD_WRN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_SADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetCR2_SADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3ff
}

// I2C.OAR1: Own address register 1
func (o *I2C_Type) SetOAR1_OA1MODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetOAR1_OA1MODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetOAR1_OA1EN(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_OA1EN() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetOAR1_OA1(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_OA1() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}

// I2C.OAR2: Own address register 2
func (o *I2C_Type) SetOAR2_OA2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_OA2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_OA2MSK(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x700)|value<<8)
}
func (o *I2C_Type) GetOAR2_OA2MSK() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x700) >> 8
}
func (o *I2C_Type) SetOAR2_OA2EN(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR2_OA2EN() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x8000) >> 15
}

// I2C.TIMINGR: Timing register
func (o *I2C_Type) SetTIMINGR_SCLL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTIMINGR_SCLL() uint32 {
	return volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff
}
func (o *I2C_Type) SetTIMINGR_SCLH(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetTIMINGR_SCLH() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetTIMINGR_SDADEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2C_Type) GetTIMINGR_SDADEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000) >> 16
}
func (o *I2C_Type) SetTIMINGR_SCLDEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetTIMINGR_SCLDEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetTIMINGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *I2C_Type) GetTIMINGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000000) >> 28
}

// I2C.TIMEOUTR: Status register 1
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTA(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTA() uint32 {
	return volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff
}
func (o *I2C_Type) SetTIMEOUTR_TIDLE(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTIMEOUTR_TIDLE() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetTIMEOUTR_TIMOUTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetTIMEOUTR_TIMOUTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTB(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff0000)|value<<16)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTB() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff0000) >> 16
}
func (o *I2C_Type) SetTIMEOUTR_TEXTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetTIMEOUTR_TEXTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x80000000) >> 31
}

// I2C.ISR: Interrupt and Status register
func (o *I2C_Type) SetISR_ADDCODE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xfe0000)|value<<17)
}
func (o *I2C_Type) GetISR_ADDCODE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xfe0000) >> 17
}
func (o *I2C_Type) SetISR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetISR_ALERT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetISR_ALERT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetISR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetISR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetISR_PECERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetISR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetISR_ARLO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetISR_ARLO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetISR_BERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetISR_BERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetISR_TCR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetISR_TCR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetISR_STOPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetISR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetISR_NACKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetISR_NACKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetISR_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetISR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetISR_TXIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetISR_TXIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetISR_TXE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// I2C.ICR: Interrupt clear register
func (o *I2C_Type) SetICR_ALERTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetICR_ALERTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetICR_TIMOUTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetICR_TIMOUTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetICR_PECCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetICR_PECCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetICR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetICR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetICR_ARLOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetICR_ARLOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetICR_BERRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetICR_BERRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetICR_STOPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetICR_STOPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetICR_NACKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetICR_NACKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetICR_ADDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetICR_ADDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}

// I2C.PECR: PEC register
func (o *I2C_Type) SetPECR_PEC(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPECR_PEC() uint32 {
	return volatile.LoadUint32(&o.PECR.Reg) & 0xff
}

// I2C.RXDR: Receive data register
func (o *I2C_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// I2C.TXDR: Transmit data register
func (o *I2C_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_WVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *IWDG_Type) GetSR_WVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}

// IWDG.WINR: Window register
func (o *IWDG_Type) SetWINR_WIN(value uint32) {
	volatile.StoreUint32(&o.WINR.Reg, volatile.LoadUint32(&o.WINR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetWINR_WIN() uint32 {
	return volatile.LoadUint32(&o.WINR.Reg) & 0xfff
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x180)|value<<7)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x180) >> 7
}

// WWDG.SR: Status register
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAFCR    volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	_        [4]byte
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
	BKP20R   volatile.Register32 // 0xA0
	BKP21R   volatile.Register32 // 0xA4
	BKP22R   volatile.Register32 // 0xA8
	BKP23R   volatile.Register32 // 0xAC
	BKP24R   volatile.Register32 // 0xB0
	BKP25R   volatile.Register32 // 0xB4
	BKP26R   volatile.Register32 // 0xB8
	BKP27R   volatile.Register32 // 0xBC
	BKP28R   volatile.Register32 // 0xC0
	BKP29R   volatile.Register32 // 0xC4
	BKP30R   volatile.Register32 // 0xC8
	BKP31R   volatile.Register32 // 0xCC
}

// RTC.TR: time register
func (o *RTC_Type) SetTR_PM(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTR_HT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTR_HU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTR_ST(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTR_SU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTR_SU() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xf
}

// RTC.DR: date register
func (o *RTC_Type) SetDR_YT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_Type) GetDR_YT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00000) >> 20
}
func (o *RTC_Type) SetDR_YU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDR_YU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDR_WDU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetDR_MT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetDR_MT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetDR_MU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetDR_MU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetDR_DT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetDR_DT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetDR_DU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetDR_DU() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xf
}

// RTC.CR: control register
func (o *RTC_Type) SetCR_WUCKSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetCR_WUCKSEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7
}
func (o *RTC_Type) SetCR_TSEDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_TSEDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_REFCKON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_REFCKON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_BYPSHAD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCR_BYPSHAD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCR_FMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCR_FMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCR_ALRAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_ALRAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_ALRBE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_ALRBE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_WUTE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_WUTE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_TSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_TSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_ALRAIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_ALRAIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_ALRBIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_ALRBIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCR_WUTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCR_WUTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCR_TSIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCR_TSIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCR_ADD1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetCR_ADD1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetCR_SUB1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCR_SUB1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetCR_BKP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetCR_BKP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetCR_COSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetCR_COSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetCR_POL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetCR_POL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetCR_OSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *RTC_Type) GetCR_OSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *RTC_Type) SetCR_COE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCR_COE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}

// RTC.ISR: initialization and status register
func (o *RTC_Type) SetISR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetISR_TAMP1F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetISR_TSOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetISR_TSOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetISR_TSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetISR_TSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetISR_WUTF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetISR_WUTF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetISR_ALRBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetISR_ALRBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetISR_ALRAF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetISR_ALRAF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetISR_INIT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetISR_INIT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetISR_INITF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetISR_INITF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetISR_RSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetISR_RSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetISR_INITS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetISR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetISR_WUTWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetISR_WUTWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetISR_ALRBWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetISR_ALRBWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetISR_ALRAWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetISR_ALRAWF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *RTC_Type) SetISR_SHPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetISR_SHPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetISR_TAMP2F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetISR_TAMP2F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetISR_TAMP3F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetISR_TAMP3F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetISR_RECALPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetISR_RECALPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}

// RTC.PRER: prescaler register
func (o *RTC_Type) SetPRER_PREDIV_A(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7f0000)|value<<16)
}
func (o *RTC_Type) GetPRER_PREDIV_A() uint32 {
	return (volatile.LoadUint32(&o.PRER.Reg) & 0x7f0000) >> 16
}
func (o *RTC_Type) SetPRER_PREDIV_S(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetPRER_PREDIV_S() uint32 {
	return volatile.LoadUint32(&o.PRER.Reg) & 0x7fff
}

// RTC.WUTR: wakeup timer register
func (o *RTC_Type) SetWUTR_WUT(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWUTR_WUT() uint32 {
	return volatile.LoadUint32(&o.WUTR.Reg) & 0xffff
}

// RTC.ALRMAR: alarm A register
func (o *RTC_Type) SetALRMAR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMAR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMAR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMAR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMAR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMAR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMAR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMAR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMAR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMAR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMAR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMAR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMAR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMAR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMAR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMAR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMAR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMAR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMAR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMAR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMAR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMAR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMAR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMAR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMAR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMAR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMAR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMAR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf
}

// RTC.ALRMBR: alarm B register
func (o *RTC_Type) SetALRMBR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMBR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMBR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMBR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMBR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMBR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMBR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMBR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMBR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMBR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMBR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMBR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMBR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMBR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMBR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMBR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMBR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMBR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMBR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMBR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMBR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMBR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMBR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMBR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMBR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf
}

// RTC.WPR: write protection register
func (o *RTC_Type) SetWPR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPR.Reg, volatile.LoadUint32(&o.WPR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetWPR_KEY() uint32 {
	return volatile.LoadUint32(&o.WPR.Reg) & 0xff
}

// RTC.SSR: sub second register
func (o *RTC_Type) SetSSR_SS(value uint32) {
	volatile.StoreUint32(&o.SSR.Reg, volatile.LoadUint32(&o.SSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetSSR_SS() uint32 {
	return volatile.LoadUint32(&o.SSR.Reg) & 0xffff
}

// RTC.SHIFTR: shift control register
func (o *RTC_Type) SetSHIFTR_ADD1S(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSHIFTR_ADD1S() uint32 {
	return (volatile.LoadUint32(&o.SHIFTR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetSHIFTR_SUBFS(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetSHIFTR_SUBFS() uint32 {
	return volatile.LoadUint32(&o.SHIFTR.Reg) & 0x7fff
}

// RTC.TSTR: time stamp time register
func (o *RTC_Type) SetTSTR_SU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSTR_SU() uint32 {
	return volatile.LoadUint32(&o.TSTR.Reg) & 0xf
}
func (o *RTC_Type) SetTSTR_ST(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTSTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTSTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTSTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTSTR_HU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTSTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTSTR_HT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTSTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTSTR_PM(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTSTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x400000) >> 22
}

// RTC.TSDR: time stamp date register
func (o *RTC_Type) SetTSDR_WDU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetTSDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetTSDR_MT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetTSDR_MT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetTSDR_MU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSDR_MU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSDR_DT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetTSDR_DT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetTSDR_DU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSDR_DU() uint32 {
	return volatile.LoadUint32(&o.TSDR.Reg) & 0xf
}

// RTC.TSSSR: timestamp sub second register
func (o *RTC_Type) SetTSSSR_SS(value uint32) {
	volatile.StoreUint32(&o.TSSSR.Reg, volatile.LoadUint32(&o.TSSSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTSSSR_SS() uint32 {
	return volatile.LoadUint32(&o.TSSSR.Reg) & 0xffff
}

// RTC.CALR: calibration register
func (o *RTC_Type) SetCALR_CALP(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCALR_CALP() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCALR_CALW8(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCALR_CALW8() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCALR_CALW16(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCALR_CALW16() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCALR_CALM(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetCALR_CALM() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x1ff
}

// RTC.TAFCR: tamper and alternate function configuration register
func (o *RTC_Type) SetTAFCR_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTAFCR_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.TAFCR.Reg) & 0x1
}
func (o *RTC_Type) SetTAFCR_TAMP1TRG(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetTAFCR_TAMP1TRG() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetTAFCR_TAMPIE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetTAFCR_TAMPIE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetTAFCR_TAMP2E(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetTAFCR_TAMP2E() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetTAFCR_TAMP2TRG(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetTAFCR_TAMP2TRG() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetTAFCR_TAMPTS(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetTAFCR_TAMPTS() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetTAFCR_TAMPFREQ(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x700)|value<<8)
}
func (o *RTC_Type) GetTAFCR_TAMPFREQ() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x700) >> 8
}
func (o *RTC_Type) SetTAFCR_TAMPFLT(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x1800)|value<<11)
}
func (o *RTC_Type) GetTAFCR_TAMPFLT() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x1800) >> 11
}
func (o *RTC_Type) SetTAFCR_TAMPPRCH(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x6000)|value<<13)
}
func (o *RTC_Type) GetTAFCR_TAMPPRCH() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x6000) >> 13
}
func (o *RTC_Type) SetTAFCR_TAMPPUDIS(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetTAFCR_TAMPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetTAFCR_PC13VALUE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetTAFCR_PC13VALUE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetTAFCR_PC13MODE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetTAFCR_PC13MODE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetTAFCR_PC14VALUE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetTAFCR_PC14VALUE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetTAFCR_PC14MODE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_Type) GetTAFCR_PC14MODE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x200000) >> 21
}
func (o *RTC_Type) SetTAFCR_PC15VALUE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTAFCR_PC15VALUE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTAFCR_PC15MODE(value uint32) {
	volatile.StoreUint32(&o.TAFCR.Reg, volatile.LoadUint32(&o.TAFCR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetTAFCR_PC15MODE() uint32 {
	return (volatile.LoadUint32(&o.TAFCR.Reg) & 0x800000) >> 23
}

// RTC.ALRMASSR: alarm A sub second register
func (o *RTC_Type) SetALRMASSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMASSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMASSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMASSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMASSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x7fff
}

// RTC.ALRMBSSR: alarm B sub second register
func (o *RTC_Type) SetALRMBSSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBSSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBSSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMBSSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x7fff
}

// RTC.BKP0R: backup register
func (o *RTC_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *RTC_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// RTC.BKP1R: backup register
func (o *RTC_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *RTC_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// RTC.BKP2R: backup register
func (o *RTC_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *RTC_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// RTC.BKP3R: backup register
func (o *RTC_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *RTC_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// RTC.BKP4R: backup register
func (o *RTC_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *RTC_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// RTC.BKP5R: backup register
func (o *RTC_Type) SetBKP5R(value uint32) {
	volatile.StoreUint32(&o.BKP5R.Reg, value)
}
func (o *RTC_Type) GetBKP5R() uint32 {
	return volatile.LoadUint32(&o.BKP5R.Reg)
}

// RTC.BKP6R: backup register
func (o *RTC_Type) SetBKP6R(value uint32) {
	volatile.StoreUint32(&o.BKP6R.Reg, value)
}
func (o *RTC_Type) GetBKP6R() uint32 {
	return volatile.LoadUint32(&o.BKP6R.Reg)
}

// RTC.BKP7R: backup register
func (o *RTC_Type) SetBKP7R(value uint32) {
	volatile.StoreUint32(&o.BKP7R.Reg, value)
}
func (o *RTC_Type) GetBKP7R() uint32 {
	return volatile.LoadUint32(&o.BKP7R.Reg)
}

// RTC.BKP8R: backup register
func (o *RTC_Type) SetBKP8R(value uint32) {
	volatile.StoreUint32(&o.BKP8R.Reg, value)
}
func (o *RTC_Type) GetBKP8R() uint32 {
	return volatile.LoadUint32(&o.BKP8R.Reg)
}

// RTC.BKP9R: backup register
func (o *RTC_Type) SetBKP9R(value uint32) {
	volatile.StoreUint32(&o.BKP9R.Reg, value)
}
func (o *RTC_Type) GetBKP9R() uint32 {
	return volatile.LoadUint32(&o.BKP9R.Reg)
}

// RTC.BKP10R: backup register
func (o *RTC_Type) SetBKP10R(value uint32) {
	volatile.StoreUint32(&o.BKP10R.Reg, value)
}
func (o *RTC_Type) GetBKP10R() uint32 {
	return volatile.LoadUint32(&o.BKP10R.Reg)
}

// RTC.BKP11R: backup register
func (o *RTC_Type) SetBKP11R(value uint32) {
	volatile.StoreUint32(&o.BKP11R.Reg, value)
}
func (o *RTC_Type) GetBKP11R() uint32 {
	return volatile.LoadUint32(&o.BKP11R.Reg)
}

// RTC.BKP12R: backup register
func (o *RTC_Type) SetBKP12R(value uint32) {
	volatile.StoreUint32(&o.BKP12R.Reg, value)
}
func (o *RTC_Type) GetBKP12R() uint32 {
	return volatile.LoadUint32(&o.BKP12R.Reg)
}

// RTC.BKP13R: backup register
func (o *RTC_Type) SetBKP13R(value uint32) {
	volatile.StoreUint32(&o.BKP13R.Reg, value)
}
func (o *RTC_Type) GetBKP13R() uint32 {
	return volatile.LoadUint32(&o.BKP13R.Reg)
}

// RTC.BKP14R: backup register
func (o *RTC_Type) SetBKP14R(value uint32) {
	volatile.StoreUint32(&o.BKP14R.Reg, value)
}
func (o *RTC_Type) GetBKP14R() uint32 {
	return volatile.LoadUint32(&o.BKP14R.Reg)
}

// RTC.BKP15R: backup register
func (o *RTC_Type) SetBKP15R(value uint32) {
	volatile.StoreUint32(&o.BKP15R.Reg, value)
}
func (o *RTC_Type) GetBKP15R() uint32 {
	return volatile.LoadUint32(&o.BKP15R.Reg)
}

// RTC.BKP16R: backup register
func (o *RTC_Type) SetBKP16R(value uint32) {
	volatile.StoreUint32(&o.BKP16R.Reg, value)
}
func (o *RTC_Type) GetBKP16R() uint32 {
	return volatile.LoadUint32(&o.BKP16R.Reg)
}

// RTC.BKP17R: backup register
func (o *RTC_Type) SetBKP17R(value uint32) {
	volatile.StoreUint32(&o.BKP17R.Reg, value)
}
func (o *RTC_Type) GetBKP17R() uint32 {
	return volatile.LoadUint32(&o.BKP17R.Reg)
}

// RTC.BKP18R: backup register
func (o *RTC_Type) SetBKP18R(value uint32) {
	volatile.StoreUint32(&o.BKP18R.Reg, value)
}
func (o *RTC_Type) GetBKP18R() uint32 {
	return volatile.LoadUint32(&o.BKP18R.Reg)
}

// RTC.BKP19R: backup register
func (o *RTC_Type) SetBKP19R(value uint32) {
	volatile.StoreUint32(&o.BKP19R.Reg, value)
}
func (o *RTC_Type) GetBKP19R() uint32 {
	return volatile.LoadUint32(&o.BKP19R.Reg)
}

// RTC.BKP20R: backup register
func (o *RTC_Type) SetBKP20R(value uint32) {
	volatile.StoreUint32(&o.BKP20R.Reg, value)
}
func (o *RTC_Type) GetBKP20R() uint32 {
	return volatile.LoadUint32(&o.BKP20R.Reg)
}

// RTC.BKP21R: backup register
func (o *RTC_Type) SetBKP21R(value uint32) {
	volatile.StoreUint32(&o.BKP21R.Reg, value)
}
func (o *RTC_Type) GetBKP21R() uint32 {
	return volatile.LoadUint32(&o.BKP21R.Reg)
}

// RTC.BKP22R: backup register
func (o *RTC_Type) SetBKP22R(value uint32) {
	volatile.StoreUint32(&o.BKP22R.Reg, value)
}
func (o *RTC_Type) GetBKP22R() uint32 {
	return volatile.LoadUint32(&o.BKP22R.Reg)
}

// RTC.BKP23R: backup register
func (o *RTC_Type) SetBKP23R(value uint32) {
	volatile.StoreUint32(&o.BKP23R.Reg, value)
}
func (o *RTC_Type) GetBKP23R() uint32 {
	return volatile.LoadUint32(&o.BKP23R.Reg)
}

// RTC.BKP24R: backup register
func (o *RTC_Type) SetBKP24R(value uint32) {
	volatile.StoreUint32(&o.BKP24R.Reg, value)
}
func (o *RTC_Type) GetBKP24R() uint32 {
	return volatile.LoadUint32(&o.BKP24R.Reg)
}

// RTC.BKP25R: backup register
func (o *RTC_Type) SetBKP25R(value uint32) {
	volatile.StoreUint32(&o.BKP25R.Reg, value)
}
func (o *RTC_Type) GetBKP25R() uint32 {
	return volatile.LoadUint32(&o.BKP25R.Reg)
}

// RTC.BKP26R: backup register
func (o *RTC_Type) SetBKP26R(value uint32) {
	volatile.StoreUint32(&o.BKP26R.Reg, value)
}
func (o *RTC_Type) GetBKP26R() uint32 {
	return volatile.LoadUint32(&o.BKP26R.Reg)
}

// RTC.BKP27R: backup register
func (o *RTC_Type) SetBKP27R(value uint32) {
	volatile.StoreUint32(&o.BKP27R.Reg, value)
}
func (o *RTC_Type) GetBKP27R() uint32 {
	return volatile.LoadUint32(&o.BKP27R.Reg)
}

// RTC.BKP28R: backup register
func (o *RTC_Type) SetBKP28R(value uint32) {
	volatile.StoreUint32(&o.BKP28R.Reg, value)
}
func (o *RTC_Type) GetBKP28R() uint32 {
	return volatile.LoadUint32(&o.BKP28R.Reg)
}

// RTC.BKP29R: backup register
func (o *RTC_Type) SetBKP29R(value uint32) {
	volatile.StoreUint32(&o.BKP29R.Reg, value)
}
func (o *RTC_Type) GetBKP29R() uint32 {
	return volatile.LoadUint32(&o.BKP29R.Reg)
}

// RTC.BKP30R: backup register
func (o *RTC_Type) SetBKP30R(value uint32) {
	volatile.StoreUint32(&o.BKP30R.Reg, value)
}
func (o *RTC_Type) GetBKP30R() uint32 {
	return volatile.LoadUint32(&o.BKP30R.Reg)
}

// RTC.BKP31R: backup register
func (o *RTC_Type) SetBKP31R(value uint32) {
	volatile.StoreUint32(&o.BKP31R.Reg, value)
}
func (o *RTC_Type) GetBKP31R() uint32 {
	return volatile.LoadUint32(&o.BKP31R.Reg)
}

// Sigma-delta analog-to-digital converter
type SDADC_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	ISR      volatile.Register32 // 0x8
	CLRISR   volatile.Register32 // 0xC
	_        [4]byte
	JCHGR    volatile.Register32 // 0x14
	_        [8]byte
	CONF0R   volatile.Register32 // 0x20
	CONF1R   volatile.Register32 // 0x24
	CONF2R   volatile.Register32 // 0x28
	_        [20]byte
	CONFCHR1 volatile.Register32 // 0x40
	CONFCHR2 volatile.Register32 // 0x44
	_        [24]byte
	JDATAR   volatile.Register32 // 0x60
	RDATAR   volatile.Register32 // 0x64
	_        [8]byte
	JDATA12R volatile.Register32 // 0x70
	RDATA12R volatile.Register32 // 0x74
	JDATA13R volatile.Register32 // 0x78
	RDATA13R volatile.Register32 // 0x7C
}

// SDADC.CR1: control register 1
func (o *SDADC_Type) SetCR1_EOCALIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SDADC_Type) GetCR1_EOCALIE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *SDADC_Type) SetCR1_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SDADC_Type) GetCR1_JEOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SDADC_Type) SetCR1_JOVRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SDADC_Type) GetCR1_JOVRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SDADC_Type) SetCR1_REOCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *SDADC_Type) GetCR1_REOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *SDADC_Type) SetCR1_ROVRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *SDADC_Type) GetCR1_ROVRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *SDADC_Type) SetCR1_REFV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *SDADC_Type) GetCR1_REFV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *SDADC_Type) SetCR1_SLOWCK(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SDADC_Type) GetCR1_SLOWCK() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SDADC_Type) SetCR1_SBI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SDADC_Type) GetCR1_SBI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SDADC_Type) SetCR1_PDI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SDADC_Type) GetCR1_PDI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SDADC_Type) SetCR1_JSYNC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SDADC_Type) GetCR1_JSYNC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SDADC_Type) SetCR1_RSYNC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SDADC_Type) GetCR1_RSYNC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *SDADC_Type) SetCR1_JDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *SDADC_Type) GetCR1_JDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *SDADC_Type) SetCR1_RDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *SDADC_Type) GetCR1_RDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *SDADC_Type) SetCR1_INIT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000000)|value<<31)
}
func (o *SDADC_Type) GetCR1_INIT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000000) >> 31
}

// SDADC.CR2: control register 2
func (o *SDADC_Type) SetCR2_FAST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *SDADC_Type) GetCR2_FAST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *SDADC_Type) SetCR2_RSWSTART(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800000)|value<<23)
}
func (o *SDADC_Type) GetCR2_RSWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800000) >> 23
}
func (o *SDADC_Type) SetCR2_RCONT(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400000)|value<<22)
}
func (o *SDADC_Type) GetCR2_RCONT() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400000) >> 22
}
func (o *SDADC_Type) SetCR2_RCH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf0000)|value<<16)
}
func (o *SDADC_Type) GetCR2_RCH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf0000) >> 16
}
func (o *SDADC_Type) SetCR2_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *SDADC_Type) GetCR2_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *SDADC_Type) SetCR2_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x6000)|value<<13)
}
func (o *SDADC_Type) GetCR2_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x6000) >> 13
}
func (o *SDADC_Type) SetCR2_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00)|value<<8)
}
func (o *SDADC_Type) GetCR2_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00) >> 8
}
func (o *SDADC_Type) SetCR2_JDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SDADC_Type) GetCR2_JDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SDADC_Type) SetCR2_JCONT(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SDADC_Type) GetCR2_JCONT() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SDADC_Type) SetCR2_STARTCALIB(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SDADC_Type) GetCR2_STARTCALIB() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SDADC_Type) SetCR2_CALIBCNT(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x6)|value<<1)
}
func (o *SDADC_Type) GetCR2_CALIBCNT() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x6) >> 1
}
func (o *SDADC_Type) SetCR2_ADON(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *SDADC_Type) GetCR2_ADON() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// SDADC.ISR: interrupt and status register
func (o *SDADC_Type) SetISR_INITRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *SDADC_Type) GetISR_INITRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}
func (o *SDADC_Type) SetISR_STABIP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *SDADC_Type) GetISR_STABIP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *SDADC_Type) SetISR_RCIP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *SDADC_Type) GetISR_RCIP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *SDADC_Type) SetISR_JCIP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *SDADC_Type) GetISR_JCIP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *SDADC_Type) SetISR_CALIBIP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *SDADC_Type) GetISR_CALIBIP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *SDADC_Type) SetISR_ROVRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *SDADC_Type) GetISR_ROVRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *SDADC_Type) SetISR_REOCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *SDADC_Type) GetISR_REOCF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *SDADC_Type) SetISR_JOVRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *SDADC_Type) GetISR_JOVRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *SDADC_Type) SetISR_JEOCF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *SDADC_Type) GetISR_JEOCF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *SDADC_Type) SetISR_EOCALF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *SDADC_Type) GetISR_EOCALF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// SDADC.CLRISR: interrupt and status clear register
func (o *SDADC_Type) SetCLRISR_CLRROVRF(value uint32) {
	volatile.StoreUint32(&o.CLRISR.Reg, volatile.LoadUint32(&o.CLRISR.Reg)&^(0x10)|value<<4)
}
func (o *SDADC_Type) GetCLRISR_CLRROVRF() uint32 {
	return (volatile.LoadUint32(&o.CLRISR.Reg) & 0x10) >> 4
}
func (o *SDADC_Type) SetCLRISR_CLRJOVRF(value uint32) {
	volatile.StoreUint32(&o.CLRISR.Reg, volatile.LoadUint32(&o.CLRISR.Reg)&^(0x4)|value<<2)
}
func (o *SDADC_Type) GetCLRISR_CLRJOVRF() uint32 {
	return (volatile.LoadUint32(&o.CLRISR.Reg) & 0x4) >> 2
}
func (o *SDADC_Type) SetCLRISR_CLREOCALF(value uint32) {
	volatile.StoreUint32(&o.CLRISR.Reg, volatile.LoadUint32(&o.CLRISR.Reg)&^(0x1)|value)
}
func (o *SDADC_Type) GetCLRISR_CLREOCALF() uint32 {
	return volatile.LoadUint32(&o.CLRISR.Reg) & 0x1
}

// SDADC.JCHGR: injected channel group selection register
func (o *SDADC_Type) SetJCHGR_JCHG(value uint32) {
	volatile.StoreUint32(&o.JCHGR.Reg, volatile.LoadUint32(&o.JCHGR.Reg)&^(0x1ff)|value)
}
func (o *SDADC_Type) GetJCHGR_JCHG() uint32 {
	return volatile.LoadUint32(&o.JCHGR.Reg) & 0x1ff
}

// SDADC.CONF0R: configuration 0 register
func (o *SDADC_Type) SetCONF0R_COMMON0(value uint32) {
	volatile.StoreUint32(&o.CONF0R.Reg, volatile.LoadUint32(&o.CONF0R.Reg)&^(0xc0000000)|value<<30)
}
func (o *SDADC_Type) GetCONF0R_COMMON0() uint32 {
	return (volatile.LoadUint32(&o.CONF0R.Reg) & 0xc0000000) >> 30
}
func (o *SDADC_Type) SetCONF0R_SE0(value uint32) {
	volatile.StoreUint32(&o.CONF0R.Reg, volatile.LoadUint32(&o.CONF0R.Reg)&^(0xc000000)|value<<26)
}
func (o *SDADC_Type) GetCONF0R_SE0() uint32 {
	return (volatile.LoadUint32(&o.CONF0R.Reg) & 0xc000000) >> 26
}
func (o *SDADC_Type) SetCONF0R_GAIN0(value uint32) {
	volatile.StoreUint32(&o.CONF0R.Reg, volatile.LoadUint32(&o.CONF0R.Reg)&^(0x700000)|value<<20)
}
func (o *SDADC_Type) GetCONF0R_GAIN0() uint32 {
	return (volatile.LoadUint32(&o.CONF0R.Reg) & 0x700000) >> 20
}
func (o *SDADC_Type) SetCONF0R_OFFSET0(value uint32) {
	volatile.StoreUint32(&o.CONF0R.Reg, volatile.LoadUint32(&o.CONF0R.Reg)&^(0xfff)|value)
}
func (o *SDADC_Type) GetCONF0R_OFFSET0() uint32 {
	return volatile.LoadUint32(&o.CONF0R.Reg) & 0xfff
}

// SDADC.CONF1R: configuration 1 register
func (o *SDADC_Type) SetCONF1R_COMMON1(value uint32) {
	volatile.StoreUint32(&o.CONF1R.Reg, volatile.LoadUint32(&o.CONF1R.Reg)&^(0xc0000000)|value<<30)
}
func (o *SDADC_Type) GetCONF1R_COMMON1() uint32 {
	return (volatile.LoadUint32(&o.CONF1R.Reg) & 0xc0000000) >> 30
}
func (o *SDADC_Type) SetCONF1R_SE1(value uint32) {
	volatile.StoreUint32(&o.CONF1R.Reg, volatile.LoadUint32(&o.CONF1R.Reg)&^(0xc000000)|value<<26)
}
func (o *SDADC_Type) GetCONF1R_SE1() uint32 {
	return (volatile.LoadUint32(&o.CONF1R.Reg) & 0xc000000) >> 26
}
func (o *SDADC_Type) SetCONF1R_GAIN1(value uint32) {
	volatile.StoreUint32(&o.CONF1R.Reg, volatile.LoadUint32(&o.CONF1R.Reg)&^(0x700000)|value<<20)
}
func (o *SDADC_Type) GetCONF1R_GAIN1() uint32 {
	return (volatile.LoadUint32(&o.CONF1R.Reg) & 0x700000) >> 20
}
func (o *SDADC_Type) SetCONF1R_OFFSET1(value uint32) {
	volatile.StoreUint32(&o.CONF1R.Reg, volatile.LoadUint32(&o.CONF1R.Reg)&^(0xfff)|value)
}
func (o *SDADC_Type) GetCONF1R_OFFSET1() uint32 {
	return volatile.LoadUint32(&o.CONF1R.Reg) & 0xfff
}

// SDADC.CONF2R: configuration 2 register
func (o *SDADC_Type) SetCONF2R_COMMON2(value uint32) {
	volatile.StoreUint32(&o.CONF2R.Reg, volatile.LoadUint32(&o.CONF2R.Reg)&^(0xc0000000)|value<<30)
}
func (o *SDADC_Type) GetCONF2R_COMMON2() uint32 {
	return (volatile.LoadUint32(&o.CONF2R.Reg) & 0xc0000000) >> 30
}
func (o *SDADC_Type) SetCONF2R_SE2(value uint32) {
	volatile.StoreUint32(&o.CONF2R.Reg, volatile.LoadUint32(&o.CONF2R.Reg)&^(0xc000000)|value<<26)
}
func (o *SDADC_Type) GetCONF2R_SE2() uint32 {
	return (volatile.LoadUint32(&o.CONF2R.Reg) & 0xc000000) >> 26
}
func (o *SDADC_Type) SetCONF2R_GAIN2(value uint32) {
	volatile.StoreUint32(&o.CONF2R.Reg, volatile.LoadUint32(&o.CONF2R.Reg)&^(0x700000)|value<<20)
}
func (o *SDADC_Type) GetCONF2R_GAIN2() uint32 {
	return (volatile.LoadUint32(&o.CONF2R.Reg) & 0x700000) >> 20
}
func (o *SDADC_Type) SetCONF2R_OFFSET2(value uint32) {
	volatile.StoreUint32(&o.CONF2R.Reg, volatile.LoadUint32(&o.CONF2R.Reg)&^(0xfff)|value)
}
func (o *SDADC_Type) GetCONF2R_OFFSET2() uint32 {
	return volatile.LoadUint32(&o.CONF2R.Reg) & 0xfff
}

// SDADC.CONFCHR1: channel configuration register 1
func (o *SDADC_Type) SetCONFCHR1_CONFCH7(value uint32) {
	volatile.StoreUint32(&o.CONFCHR1.Reg, volatile.LoadUint32(&o.CONFCHR1.Reg)&^(0x30000000)|value<<28)
}
func (o *SDADC_Type) GetCONFCHR1_CONFCH7() uint32 {
	return (volatile.LoadUint32(&o.CONFCHR1.Reg) & 0x30000000) >> 28
}
func (o *SDADC_Type) SetCONFCHR1_CONFCH6(value uint32) {
	volatile.StoreUint32(&o.CONFCHR1.Reg, volatile.LoadUint32(&o.CONFCHR1.Reg)&^(0x3000000)|value<<24)
}
func (o *SDADC_Type) GetCONFCHR1_CONFCH6() uint32 {
	return (volatile.LoadUint32(&o.CONFCHR1.Reg) & 0x3000000) >> 24
}
func (o *SDADC_Type) SetCONFCHR1_CONFCH5(value uint32) {
	volatile.StoreUint32(&o.CONFCHR1.Reg, volatile.LoadUint32(&o.CONFCHR1.Reg)&^(0x300000)|value<<20)
}
func (o *SDADC_Type) GetCONFCHR1_CONFCH5() uint32 {
	return (volatile.LoadUint32(&o.CONFCHR1.Reg) & 0x300000) >> 20
}
func (o *SDADC_Type) SetCONFCHR1_CONFCH4(value uint32) {
	volatile.StoreUint32(&o.CONFCHR1.Reg, volatile.LoadUint32(&o.CONFCHR1.Reg)&^(0x30000)|value<<16)
}
func (o *SDADC_Type) GetCONFCHR1_CONFCH4() uint32 {
	return (volatile.LoadUint32(&o.CONFCHR1.Reg) & 0x30000) >> 16
}
func (o *SDADC_Type) SetCONFCHR1_CONFCH3(value uint32) {
	volatile.StoreUint32(&o.CONFCHR1.Reg, volatile.LoadUint32(&o.CONFCHR1.Reg)&^(0x3000)|value<<12)
}
func (o *SDADC_Type) GetCONFCHR1_CONFCH3() uint32 {
	return (volatile.LoadUint32(&o.CONFCHR1.Reg) & 0x3000) >> 12
}
func (o *SDADC_Type) SetCONFCHR1_CONFCH2(value uint32) {
	volatile.StoreUint32(&o.CONFCHR1.Reg, volatile.LoadUint32(&o.CONFCHR1.Reg)&^(0x300)|value<<8)
}
func (o *SDADC_Type) GetCONFCHR1_CONFCH2() uint32 {
	return (volatile.LoadUint32(&o.CONFCHR1.Reg) & 0x300) >> 8
}
func (o *SDADC_Type) SetCONFCHR1_CONFCH1(value uint32) {
	volatile.StoreUint32(&o.CONFCHR1.Reg, volatile.LoadUint32(&o.CONFCHR1.Reg)&^(0x30)|value<<4)
}
func (o *SDADC_Type) GetCONFCHR1_CONFCH1() uint32 {
	return (volatile.LoadUint32(&o.CONFCHR1.Reg) & 0x30) >> 4
}
func (o *SDADC_Type) SetCONFCHR1_CONFCH0(value uint32) {
	volatile.StoreUint32(&o.CONFCHR1.Reg, volatile.LoadUint32(&o.CONFCHR1.Reg)&^(0x3)|value)
}
func (o *SDADC_Type) GetCONFCHR1_CONFCH0() uint32 {
	return volatile.LoadUint32(&o.CONFCHR1.Reg) & 0x3
}

// SDADC.CONFCHR2: channel configuration register 2
func (o *SDADC_Type) SetCONFCHR2_CONFCH8(value uint32) {
	volatile.StoreUint32(&o.CONFCHR2.Reg, volatile.LoadUint32(&o.CONFCHR2.Reg)&^(0x3)|value)
}
func (o *SDADC_Type) GetCONFCHR2_CONFCH8() uint32 {
	return volatile.LoadUint32(&o.CONFCHR2.Reg) & 0x3
}

// SDADC.JDATAR: data register for injected group
func (o *SDADC_Type) SetJDATAR_JDATACH(value uint32) {
	volatile.StoreUint32(&o.JDATAR.Reg, volatile.LoadUint32(&o.JDATAR.Reg)&^(0x1e000000)|value<<25)
}
func (o *SDADC_Type) GetJDATAR_JDATACH() uint32 {
	return (volatile.LoadUint32(&o.JDATAR.Reg) & 0x1e000000) >> 25
}
func (o *SDADC_Type) SetJDATAR_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDATAR.Reg, volatile.LoadUint32(&o.JDATAR.Reg)&^(0xffff)|value)
}
func (o *SDADC_Type) GetJDATAR_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDATAR.Reg) & 0xffff
}

// SDADC.RDATAR: data register for the regular channel
func (o *SDADC_Type) SetRDATAR_RDATA(value uint32) {
	volatile.StoreUint32(&o.RDATAR.Reg, volatile.LoadUint32(&o.RDATAR.Reg)&^(0xffff)|value)
}
func (o *SDADC_Type) GetRDATAR_RDATA() uint32 {
	return volatile.LoadUint32(&o.RDATAR.Reg) & 0xffff
}

// SDADC.JDATA12R: SDADC1 and SDADC2 injected data register
func (o *SDADC_Type) SetJDATA12R_JDATA2(value uint32) {
	volatile.StoreUint32(&o.JDATA12R.Reg, volatile.LoadUint32(&o.JDATA12R.Reg)&^(0xffff0000)|value<<16)
}
func (o *SDADC_Type) GetJDATA12R_JDATA2() uint32 {
	return (volatile.LoadUint32(&o.JDATA12R.Reg) & 0xffff0000) >> 16
}
func (o *SDADC_Type) SetJDATA12R_JDATA1(value uint32) {
	volatile.StoreUint32(&o.JDATA12R.Reg, volatile.LoadUint32(&o.JDATA12R.Reg)&^(0xffff)|value)
}
func (o *SDADC_Type) GetJDATA12R_JDATA1() uint32 {
	return volatile.LoadUint32(&o.JDATA12R.Reg) & 0xffff
}

// SDADC.RDATA12R: SDADC1 and SDADC2 regular data register
func (o *SDADC_Type) SetRDATA12R_RDATA2(value uint32) {
	volatile.StoreUint32(&o.RDATA12R.Reg, volatile.LoadUint32(&o.RDATA12R.Reg)&^(0xffff0000)|value<<16)
}
func (o *SDADC_Type) GetRDATA12R_RDATA2() uint32 {
	return (volatile.LoadUint32(&o.RDATA12R.Reg) & 0xffff0000) >> 16
}
func (o *SDADC_Type) SetRDATA12R_RDATA1(value uint32) {
	volatile.StoreUint32(&o.RDATA12R.Reg, volatile.LoadUint32(&o.RDATA12R.Reg)&^(0xffff)|value)
}
func (o *SDADC_Type) GetRDATA12R_RDATA1() uint32 {
	return volatile.LoadUint32(&o.RDATA12R.Reg) & 0xffff
}

// SDADC.JDATA13R: SDADC1 and SDADC3 injected data register
func (o *SDADC_Type) SetJDATA13R_JDATA3(value uint32) {
	volatile.StoreUint32(&o.JDATA13R.Reg, volatile.LoadUint32(&o.JDATA13R.Reg)&^(0xffff0000)|value<<16)
}
func (o *SDADC_Type) GetJDATA13R_JDATA3() uint32 {
	return (volatile.LoadUint32(&o.JDATA13R.Reg) & 0xffff0000) >> 16
}
func (o *SDADC_Type) SetJDATA13R_JDATA1(value uint32) {
	volatile.StoreUint32(&o.JDATA13R.Reg, volatile.LoadUint32(&o.JDATA13R.Reg)&^(0xffff)|value)
}
func (o *SDADC_Type) GetJDATA13R_JDATA1() uint32 {
	return volatile.LoadUint32(&o.JDATA13R.Reg) & 0xffff
}

// SDADC.RDATA13R: SDADC1 and SDADC3 regular data register
func (o *SDADC_Type) SetRDATA13R_RDATA3(value uint32) {
	volatile.StoreUint32(&o.RDATA13R.Reg, volatile.LoadUint32(&o.RDATA13R.Reg)&^(0xffff0000)|value<<16)
}
func (o *SDADC_Type) GetRDATA13R_RDATA3() uint32 {
	return (volatile.LoadUint32(&o.RDATA13R.Reg) & 0xffff0000) >> 16
}
func (o *SDADC_Type) SetRDATA13R_RDATA1(value uint32) {
	volatile.StoreUint32(&o.RDATA13R.Reg, volatile.LoadUint32(&o.RDATA13R.Reg)&^(0xffff)|value)
}
func (o *SDADC_Type) GetRDATA13R_RDATA1() uint32 {
	return volatile.LoadUint32(&o.RDATA13R.Reg) & 0xffff
}

// Digital-to-analog converter
type DAC2_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	_       [24]byte
	DOR1    volatile.Register32 // 0x2C
	_       [4]byte
	SR      volatile.Register32 // 0x34
}

// DAC2.CR: control register
func (o *DAC2_Type) SetCR_DMAUDRIE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC2_Type) GetCR_DMAUDRIE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DAC2_Type) SetCR_DMAEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC2_Type) GetCR_DMAEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DAC2_Type) SetCR_MAMP13(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *DAC2_Type) GetCR_MAMP13() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *DAC2_Type) SetCR_MAMP12(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *DAC2_Type) GetCR_MAMP12() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *DAC2_Type) SetCR_MAMP11(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *DAC2_Type) GetCR_MAMP11() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *DAC2_Type) SetCR_MAMP10(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DAC2_Type) GetCR_MAMP10() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *DAC2_Type) SetCR_WAVE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *DAC2_Type) GetCR_WAVE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *DAC2_Type) SetCR_WAVE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *DAC2_Type) GetCR_WAVE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *DAC2_Type) SetCR_TSEL1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x38)|value<<3)
}
func (o *DAC2_Type) GetCR_TSEL1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x38) >> 3
}
func (o *DAC2_Type) SetCR_TEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DAC2_Type) GetCR_TEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DAC2_Type) SetCR_BOFF1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DAC2_Type) GetCR_BOFF1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DAC2_Type) SetCR_EN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DAC2_Type) GetCR_EN1() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DAC2.SWTRIGR: software trigger register
func (o *DAC2_Type) SetSWTRIGR_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x1)|value)
}
func (o *DAC2_Type) GetSWTRIGR_SWTRIG1() uint32 {
	return volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x1
}

// DAC2.DHR12R1: channel1 12-bit right-aligned data holding register
func (o *DAC2_Type) SetDHR12R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R1.Reg, volatile.LoadUint32(&o.DHR12R1.Reg)&^(0xfff)|value)
}
func (o *DAC2_Type) GetDHR12R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R1.Reg) & 0xfff
}

// DAC2.DHR12L1: DAC channel1 12-bit left aligned data holding register
func (o *DAC2_Type) SetDHR12L1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L1.Reg, volatile.LoadUint32(&o.DHR12L1.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC2_Type) GetDHR12L1_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L1.Reg) & 0xfff0) >> 4
}

// DAC2.DHR8R1: DAC channel1 8-bit right aligned data holding register
func (o *DAC2_Type) SetDHR8R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R1.Reg, volatile.LoadUint32(&o.DHR8R1.Reg)&^(0xff)|value)
}
func (o *DAC2_Type) GetDHR8R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R1.Reg) & 0xff
}

// DAC2.DOR1: DAC channel1 data output register
func (o *DAC2_Type) SetDOR1_DACC1DOR(value uint32) {
	volatile.StoreUint32(&o.DOR1.Reg, volatile.LoadUint32(&o.DOR1.Reg)&^(0xfff)|value)
}
func (o *DAC2_Type) GetDOR1_DACC1DOR() uint32 {
	return volatile.LoadUint32(&o.DOR1.Reg) & 0xfff
}

// DAC2.SR: DAC status register
func (o *DAC2_Type) SetSR_DMAUDR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC2_Type) GetSR_DMAUDR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// DAC.CR: control register
func (o *DAC_Type) SetCR_DMAUDRIE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetCR_DMAUDRIE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetCR_DMAEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *DAC_Type) GetCR_DMAEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *DAC_Type) SetCR_MAMP2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *DAC_Type) GetCR_MAMP2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *DAC_Type) SetCR_WAVE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00000)|value<<22)
}
func (o *DAC_Type) GetCR_WAVE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00000) >> 22
}
func (o *DAC_Type) SetCR_TSEL2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x380000)|value<<19)
}
func (o *DAC_Type) GetCR_TSEL2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x380000) >> 19
}
func (o *DAC_Type) SetCR_TEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DAC_Type) GetCR_TEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DAC_Type) SetCR_BOFF2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *DAC_Type) GetCR_BOFF2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *DAC_Type) SetCR_EN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetCR_EN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetCR_DMAUDRIE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetCR_DMAUDRIE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetCR_DMAEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetCR_DMAEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetCR_MAMP1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *DAC_Type) GetCR_MAMP1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *DAC_Type) SetCR_WAVE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetCR_WAVE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DAC_Type) SetCR_TSEL1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x38)|value<<3)
}
func (o *DAC_Type) GetCR_TSEL1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x38) >> 3
}
func (o *DAC_Type) SetCR_TEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetCR_TEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DAC_Type) SetCR_BOFF1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCR_BOFF1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCR_EN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCR_EN1() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DAC.SWTRIGR: software trigger register
func (o *DAC_Type) SetSWTRIGR_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetSWTRIGR_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG1() uint32 {
	return volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x1
}

// DAC.DHR12R1: channel1 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R1.Reg, volatile.LoadUint32(&o.DHR12R1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R1.Reg) & 0xfff
}

// DAC.DHR12L1: channel1 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L1.Reg, volatile.LoadUint32(&o.DHR12L1.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L1_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L1.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R1: channel1 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R1.Reg, volatile.LoadUint32(&o.DHR8R1.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R1.Reg) & 0xff
}

// DAC.DHR12R2: channel2 12-bit right aligned data holding register
func (o *DAC_Type) SetDHR12R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R2.Reg, volatile.LoadUint32(&o.DHR12R2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R2.Reg) & 0xfff
}

// DAC.DHR12L2: channel2 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L2.Reg, volatile.LoadUint32(&o.DHR12L2.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L2_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L2.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R2: channel2 8-bit right-aligned data holding register
func (o *DAC_Type) SetDHR8R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R2.Reg, volatile.LoadUint32(&o.DHR8R2.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R2.Reg) & 0xff
}

// DAC.DHR12RD: Dual DAC 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDHR12RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff0000) >> 16
}
func (o *DAC_Type) SetDHR12RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff
}

// DAC.DHR12LD: DUAL DAC 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12LD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff00000)|value<<20)
}
func (o *DAC_Type) GetDHR12LD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff00000) >> 20
}
func (o *DAC_Type) SetDHR12LD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12LD_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff0) >> 4
}

// DAC.DHR8RD: DUAL DAC 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff00)|value<<8)
}
func (o *DAC_Type) GetDHR8RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff00) >> 8
}
func (o *DAC_Type) SetDHR8RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff
}

// DAC.DOR1: channel1 data output register
func (o *DAC_Type) SetDOR1_DACC1DOR(value uint32) {
	volatile.StoreUint32(&o.DOR1.Reg, volatile.LoadUint32(&o.DOR1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR1_DACC1DOR() uint32 {
	return volatile.LoadUint32(&o.DOR1.Reg) & 0xfff
}

// DAC.DOR2: channel2 data output register
func (o *DAC_Type) SetDOR2_DACC2DOR(value uint32) {
	volatile.StoreUint32(&o.DOR2.Reg, volatile.LoadUint32(&o.DOR2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR2_DACC2DOR() uint32 {
	return volatile.LoadUint32(&o.DOR2.Reg) & 0xfff
}

// DAC.SR: status register
func (o *DAC_Type) SetSR_DMAUDR2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetSR_DMAUDR2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetSR_DMAUDR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetSR_DMAUDR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}

// Debug support
type DBGMCU_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB1_FZ volatile.Register32 // 0x8
	APB2FZ  volatile.Register32 // 0xC
}

// DBGMCU.IDCODE: MCU Device ID Code Register
func (o *DBGMCU_Type) SetIDCODE_DEV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xfff)|value)
}
func (o *DBGMCU_Type) GetIDCODE_DEV_ID() uint32 {
	return volatile.LoadUint32(&o.IDCODE.Reg) & 0xfff
}
func (o *DBGMCU_Type) SetIDCODE_REV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DBGMCU_Type) GetIDCODE_REV_ID() uint32 {
	return (volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff0000) >> 16
}

// DBGMCU.CR: Debug MCU Configuration Register
func (o *DBGMCU_Type) SetCR_DBG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetCR_DBG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DBGMCU_Type) SetCR_DBG_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetCR_DBG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetCR_DBG_STANDBY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetCR_DBG_STANDBY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetCR_TRACE_IOEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetCR_TRACE_IOEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBGMCU_Type) SetCR_TRACE_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DBGMCU_Type) GetCR_TRACE_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}

// DBGMCU.APB1_FZ: APB Low Freeze Register
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1)|value)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM2_STOP() uint32 {
	return volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x2)|value<<1)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x2) >> 1
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM4_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM4_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM5_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x8)|value<<3)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM5_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x8) >> 3
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM6_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x10)|value<<4)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM6_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x10) >> 4
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM7_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM7_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x20) >> 5
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM12_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x40)|value<<6)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM12_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x40) >> 6
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM13_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x80)|value<<7)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM13_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x80) >> 7
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIMER14_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x100)|value<<8)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIMER14_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x100) >> 8
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_TIM18_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x200)|value<<9)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_TIM18_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x200) >> 9
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_RTC_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x400)|value<<10)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_RTC_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x400) >> 10
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_WWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x800)|value<<11)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_WWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x800) >> 11
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1000)|value<<12)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1000) >> 12
}
func (o *DBGMCU_Type) SetAPB1_FZ_I2C1_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x200000)|value<<21)
}
func (o *DBGMCU_Type) GetAPB1_FZ_I2C1_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x200000) >> 21
}
func (o *DBGMCU_Type) SetAPB1_FZ_I2C2_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x400000)|value<<22)
}
func (o *DBGMCU_Type) GetAPB1_FZ_I2C2_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x400000) >> 22
}
func (o *DBGMCU_Type) SetAPB1_FZ_DBG_CAN_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x2000000)|value<<25)
}
func (o *DBGMCU_Type) GetAPB1_FZ_DBG_CAN_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x2000000) >> 25
}

// DBGMCU.APB2FZ: APB High Freeze Register
func (o *DBGMCU_Type) SetAPB2FZ_DBG_TIM15_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2FZ.Reg, volatile.LoadUint32(&o.APB2FZ.Reg)&^(0x4)|value<<2)
}
func (o *DBGMCU_Type) GetAPB2FZ_DBG_TIM15_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ.Reg) & 0x4) >> 2
}
func (o *DBGMCU_Type) SetAPB2FZ_DBG_TIM16_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2FZ.Reg, volatile.LoadUint32(&o.APB2FZ.Reg)&^(0x8)|value<<3)
}
func (o *DBGMCU_Type) GetAPB2FZ_DBG_TIM16_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ.Reg) & 0x8) >> 3
}
func (o *DBGMCU_Type) SetAPB2FZ_DBG_TIM17_STO(value uint32) {
	volatile.StoreUint32(&o.APB2FZ.Reg, volatile.LoadUint32(&o.APB2FZ.Reg)&^(0x10)|value<<4)
}
func (o *DBGMCU_Type) GetAPB2FZ_DBG_TIM17_STO() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ.Reg) & 0x10) >> 4
}
func (o *DBGMCU_Type) SetAPB2FZ_DBG_TIM19_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2FZ.Reg, volatile.LoadUint32(&o.APB2FZ.Reg)&^(0x20)|value<<5)
}
func (o *DBGMCU_Type) GetAPB2FZ_DBG_TIM19_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2FZ.Reg) & 0x20) >> 5
}

// System configuration controller
type SYSCFG_Type struct {
	CFGR1   volatile.Register32 // 0x0
	_       [4]byte
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	CFGR2   volatile.Register32 // 0x18
}

// SYSCFG.CFGR1: configuration register 1
func (o *SYSCFG_Type) SetCFGR1_MEM_MODE(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x3)|value)
}
func (o *SYSCFG_Type) GetCFGR1_MEM_MODE() uint32 {
	return volatile.LoadUint32(&o.CFGR1.Reg) & 0x3
}
func (o *SYSCFG_Type) SetCFGR1_TIM1_ITR3_RMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetCFGR1_TIM1_ITR3_RMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetCFGR1_TIM16_DMA_RMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x800)|value<<11)
}
func (o *SYSCFG_Type) GetCFGR1_TIM16_DMA_RMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x800) >> 11
}
func (o *SYSCFG_Type) SetCFGR1_TIM17_DMA_RMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x1000)|value<<12)
}
func (o *SYSCFG_Type) GetCFGR1_TIM17_DMA_RMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x1000) >> 12
}
func (o *SYSCFG_Type) SetCFGR1_TIM6_DAC1_DMA_RMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x2000)|value<<13)
}
func (o *SYSCFG_Type) GetCFGR1_TIM6_DAC1_DMA_RMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x2000) >> 13
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB6_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB6_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB7_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB7_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x20000) >> 17
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB8_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB8_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetCFGR1_I2C_PB9_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x80000)|value<<19)
}
func (o *SYSCFG_Type) GetCFGR1_I2C_PB9_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x80000) >> 19
}
func (o *SYSCFG_Type) SetCFGR1_I2C1_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x100000)|value<<20)
}
func (o *SYSCFG_Type) GetCFGR1_I2C1_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x100000) >> 20
}
func (o *SYSCFG_Type) SetCFGR1_I2C2_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x200000)|value<<21)
}
func (o *SYSCFG_Type) GetCFGR1_I2C2_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x200000) >> 21
}
func (o *SYSCFG_Type) SetCFGR1_ENCODER_MODE(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0xc00000)|value<<22)
}
func (o *SYSCFG_Type) GetCFGR1_ENCODER_MODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0xc00000) >> 22
}
func (o *SYSCFG_Type) SetCFGR1_FPU_IE5(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x80000000)|value<<31)
}
func (o *SYSCFG_Type) GetCFGR1_FPU_IE5() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x80000000) >> 31
}
func (o *SYSCFG_Type) SetCFGR1_FPU_IE4(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSCFG_Type) GetCFGR1_FPU_IE4() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x40000000) >> 30
}
func (o *SYSCFG_Type) SetCFGR1_FPU_IE3(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSCFG_Type) GetCFGR1_FPU_IE3() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x20000000) >> 29
}
func (o *SYSCFG_Type) SetCFGR1_FPU_IE2(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSCFG_Type) GetCFGR1_FPU_IE2() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x10000000) >> 28
}
func (o *SYSCFG_Type) SetCFGR1_FPU_IE1(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x8000000)|value<<27)
}
func (o *SYSCFG_Type) GetCFGR1_FPU_IE1() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x8000000) >> 27
}
func (o *SYSCFG_Type) SetCFGR1_FPU_IE0(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x4000000)|value<<26)
}
func (o *SYSCFG_Type) GetCFGR1_FPU_IE0() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x4000000) >> 26
}
func (o *SYSCFG_Type) SetCFGR1_I2C3_FMP(value uint32) {
	volatile.StoreUint32(&o.CFGR1.Reg, volatile.LoadUint32(&o.CFGR1.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSCFG_Type) GetCFGR1_I2C3_FMP() uint32 {
	return (volatile.LoadUint32(&o.CFGR1.Reg) & 0x1000000) >> 24
}

// SYSCFG.EXTICR1: external interrupt configuration register 1
func (o *SYSCFG_Type) SetEXTICR1_EXTI3(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI3() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI2(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI2() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI1(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI1() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI0(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI0() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf
}

// SYSCFG.EXTICR2: external interrupt configuration register 2
func (o *SYSCFG_Type) SetEXTICR2_EXTI7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI7() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI6(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI6() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI5(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI5() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI4(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI4() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf
}

// SYSCFG.EXTICR3: external interrupt configuration register 3
func (o *SYSCFG_Type) SetEXTICR3_EXTI11(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI11() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI10(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI10() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI9(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI9() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI8(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI8() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf
}

// SYSCFG.EXTICR4: external interrupt configuration register 4
func (o *SYSCFG_Type) SetEXTICR4_EXTI15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI14(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI14() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI13(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI13() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI12(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI12() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf
}

// SYSCFG.CFGR2: configuration register 2
func (o *SYSCFG_Type) SetCFGR2_PVD_LOCK(value uint32) {
	volatile.StoreUint32(&o.CFGR2.Reg, volatile.LoadUint32(&o.CFGR2.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetCFGR2_PVD_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CFGR2.Reg) & 0x4) >> 2
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
}

// NVIC.ISER0: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER0(value uint32) {
	volatile.StoreUint32(&o.ISER0.Reg, value)
}
func (o *NVIC_Type) GetISER0() uint32 {
	return volatile.LoadUint32(&o.ISER0.Reg)
}

// NVIC.ISER1: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER1(value uint32) {
	volatile.StoreUint32(&o.ISER1.Reg, value)
}
func (o *NVIC_Type) GetISER1() uint32 {
	return volatile.LoadUint32(&o.ISER1.Reg)
}

// NVIC.ISER2: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER2(value uint32) {
	volatile.StoreUint32(&o.ISER2.Reg, value)
}
func (o *NVIC_Type) GetISER2() uint32 {
	return volatile.LoadUint32(&o.ISER2.Reg)
}

// NVIC.ICER0: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER0(value uint32) {
	volatile.StoreUint32(&o.ICER0.Reg, value)
}
func (o *NVIC_Type) GetICER0() uint32 {
	return volatile.LoadUint32(&o.ICER0.Reg)
}

// NVIC.ICER1: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER1(value uint32) {
	volatile.StoreUint32(&o.ICER1.Reg, value)
}
func (o *NVIC_Type) GetICER1() uint32 {
	return volatile.LoadUint32(&o.ICER1.Reg)
}

// NVIC.ICER2: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER2(value uint32) {
	volatile.StoreUint32(&o.ICER2.Reg, value)
}
func (o *NVIC_Type) GetICER2() uint32 {
	return volatile.LoadUint32(&o.ICER2.Reg)
}

// NVIC.ISPR0: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR0(value uint32) {
	volatile.StoreUint32(&o.ISPR0.Reg, value)
}
func (o *NVIC_Type) GetISPR0() uint32 {
	return volatile.LoadUint32(&o.ISPR0.Reg)
}

// NVIC.ISPR1: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR1(value uint32) {
	volatile.StoreUint32(&o.ISPR1.Reg, value)
}
func (o *NVIC_Type) GetISPR1() uint32 {
	return volatile.LoadUint32(&o.ISPR1.Reg)
}

// NVIC.ISPR2: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR2(value uint32) {
	volatile.StoreUint32(&o.ISPR2.Reg, value)
}
func (o *NVIC_Type) GetISPR2() uint32 {
	return volatile.LoadUint32(&o.ISPR2.Reg)
}

// NVIC.ICPR0: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR0(value uint32) {
	volatile.StoreUint32(&o.ICPR0.Reg, value)
}
func (o *NVIC_Type) GetICPR0() uint32 {
	return volatile.LoadUint32(&o.ICPR0.Reg)
}

// NVIC.ICPR1: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR1(value uint32) {
	volatile.StoreUint32(&o.ICPR1.Reg, value)
}
func (o *NVIC_Type) GetICPR1() uint32 {
	return volatile.LoadUint32(&o.ICPR1.Reg)
}

// NVIC.ICPR2: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR2(value uint32) {
	volatile.StoreUint32(&o.ICPR2.Reg, value)
}
func (o *NVIC_Type) GetICPR2() uint32 {
	return volatile.LoadUint32(&o.ICPR2.Reg)
}

// NVIC.IABR0: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR0(value uint32) {
	volatile.StoreUint32(&o.IABR0.Reg, value)
}
func (o *NVIC_Type) GetIABR0() uint32 {
	return volatile.LoadUint32(&o.IABR0.Reg)
}

// NVIC.IABR1: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR1(value uint32) {
	volatile.StoreUint32(&o.IABR1.Reg, value)
}
func (o *NVIC_Type) GetIABR1() uint32 {
	return volatile.LoadUint32(&o.IABR1.Reg)
}

// NVIC.IABR2: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR2(value uint32) {
	volatile.StoreUint32(&o.IABR2.Reg, value)
}
func (o *NVIC_Type) GetIABR2() uint32 {
	return volatile.LoadUint32(&o.IABR2.Reg)
}

// NVIC.IPR0: Interrupt Priority Register
func (o *NVIC_Type) SetIPR0_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR0_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR0.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR0_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR0_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR0_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR0_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR0_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR0_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff000000) >> 24
}

// NVIC.IPR1: Interrupt Priority Register
func (o *NVIC_Type) SetIPR1_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR1_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR1.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR1_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR1_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR1_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR1_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR1_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR1_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff000000) >> 24
}

// NVIC.IPR2: Interrupt Priority Register
func (o *NVIC_Type) SetIPR2_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR2_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR2.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR2_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR2_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR2_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR2_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR2_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR2_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff000000) >> 24
}

// NVIC.IPR3: Interrupt Priority Register
func (o *NVIC_Type) SetIPR3_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR3_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR3.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR3_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR3_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR3_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR3_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR3_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR3_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff000000) >> 24
}

// NVIC.IPR4: Interrupt Priority Register
func (o *NVIC_Type) SetIPR4_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR4_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR4.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR4_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR4_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR4_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR4_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR4_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR4_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff000000) >> 24
}

// NVIC.IPR5: Interrupt Priority Register
func (o *NVIC_Type) SetIPR5_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR5_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR5.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR5_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR5_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR5_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR5_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR5_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR5_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff000000) >> 24
}

// NVIC.IPR6: Interrupt Priority Register
func (o *NVIC_Type) SetIPR6_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR6_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR6.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR6_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR6_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR6_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR6_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR6_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR6_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff000000) >> 24
}

// NVIC.IPR7: Interrupt Priority Register
func (o *NVIC_Type) SetIPR7_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR7_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR7.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR7_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR7_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR7_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR7_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR7_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR7_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff000000) >> 24
}

// NVIC.IPR8: Interrupt Priority Register
func (o *NVIC_Type) SetIPR8_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR8_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR8.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR8_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR8_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR8_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR8_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR8_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR8_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff000000) >> 24
}

// NVIC.IPR9: Interrupt Priority Register
func (o *NVIC_Type) SetIPR9_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR9_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR9.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR9_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR9_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR9_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR9_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR9_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR9_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff000000) >> 24
}

// NVIC.IPR10: Interrupt Priority Register
func (o *NVIC_Type) SetIPR10_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR10_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR10.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR10_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR10_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR10_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR10_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR10_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR10_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff000000) >> 24
}

// NVIC.IPR11: Interrupt Priority Register
func (o *NVIC_Type) SetIPR11_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR11_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR11.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR11_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR11_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR11_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR11_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR11_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR11_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff000000) >> 24
}

// NVIC.IPR12: Interrupt Priority Register
func (o *NVIC_Type) SetIPR12_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR12_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR12.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR12_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR12_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR12_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR12_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR12_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR12_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff000000) >> 24
}

// NVIC.IPR13: Interrupt Priority Register
func (o *NVIC_Type) SetIPR13_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR13_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR13.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR13_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR13_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR13_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR13_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR13_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR13_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff000000) >> 24
}

// NVIC.IPR14: Interrupt Priority Register
func (o *NVIC_Type) SetIPR14_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR14_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR14.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR14_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR14_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR14_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR14_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR14_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR14_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff000000) >> 24
}

// NVIC.IPR15: Interrupt Priority Register
func (o *NVIC_Type) SetIPR15_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR15_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR15.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR15_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR15_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR15_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR15_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR15_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR15_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff000000) >> 24
}

// NVIC.IPR16: Interrupt Priority Register
func (o *NVIC_Type) SetIPR16_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR16_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR16.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR16_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR16_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR16_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR16_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR16_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR16_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff000000) >> 24
}

// NVIC.IPR17: Interrupt Priority Register
func (o *NVIC_Type) SetIPR17_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR17_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR17.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR17_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR17_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR17_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR17_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR17_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR17_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff000000) >> 24
}

// NVIC.IPR18: Interrupt Priority Register
func (o *NVIC_Type) SetIPR18_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR18_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR18.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR18_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR18_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR18_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR18_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR18_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR18_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff000000) >> 24
}

// NVIC.IPR19: Interrupt Priority Register
func (o *NVIC_Type) SetIPR19_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR19_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR19.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR19_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR19_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR19_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR19_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR19_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR19_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff000000) >> 24
}

// NVIC.IPR20: Interrupt Priority Register
func (o *NVIC_Type) SetIPR20_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR20_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR20.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR20_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR20_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR20_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR20_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR20_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR20_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff000000) >> 24
}

// Floting point unit
type FPU_Type struct {
	FPCCR volatile.Register32 // 0x0
	FPCAR volatile.Register32 // 0x4
	FPSCR volatile.Register32 // 0x8
}

// FPU.FPCCR: Floating-point context control register
func (o *FPU_Type) SetFPCCR_LSPACT(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetFPCCR_LSPACT() uint32 {
	return volatile.LoadUint32(&o.FPCCR.Reg) & 0x1
}
func (o *FPU_Type) SetFPCCR_USER(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetFPCCR_USER() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetFPCCR_THREAD(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetFPCCR_THREAD() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetFPCCR_HFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetFPCCR_HFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetFPCCR_MMRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x20)|value<<5)
}
func (o *FPU_Type) GetFPCCR_MMRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x20) >> 5
}
func (o *FPU_Type) SetFPCCR_BFRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40)|value<<6)
}
func (o *FPU_Type) GetFPCCR_BFRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40) >> 6
}
func (o *FPU_Type) SetFPCCR_MONRDY(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x100)|value<<8)
}
func (o *FPU_Type) GetFPCCR_MONRDY() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x100) >> 8
}
func (o *FPU_Type) SetFPCCR_LSPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FPU_Type) GetFPCCR_LSPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x40000000) >> 30
}
func (o *FPU_Type) SetFPCCR_ASPEN(value uint32) {
	volatile.StoreUint32(&o.FPCCR.Reg, volatile.LoadUint32(&o.FPCCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FPU_Type) GetFPCCR_ASPEN() uint32 {
	return (volatile.LoadUint32(&o.FPCCR.Reg) & 0x80000000) >> 31
}

// FPU.FPCAR: Floating-point context address register
func (o *FPU_Type) SetFPCAR_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.FPCAR.Reg, volatile.LoadUint32(&o.FPCAR.Reg)&^(0xfffffff8)|value<<3)
}
func (o *FPU_Type) GetFPCAR_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.FPCAR.Reg) & 0xfffffff8) >> 3
}

// FPU.FPSCR: Floating-point status control register
func (o *FPU_Type) SetFPSCR_IOC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x1)|value)
}
func (o *FPU_Type) GetFPSCR_IOC() uint32 {
	return volatile.LoadUint32(&o.FPSCR.Reg) & 0x1
}
func (o *FPU_Type) SetFPSCR_DZC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x2)|value<<1)
}
func (o *FPU_Type) GetFPSCR_DZC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x2) >> 1
}
func (o *FPU_Type) SetFPSCR_OFC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x4)|value<<2)
}
func (o *FPU_Type) GetFPSCR_OFC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x4) >> 2
}
func (o *FPU_Type) SetFPSCR_UFC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x8)|value<<3)
}
func (o *FPU_Type) GetFPSCR_UFC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x8) >> 3
}
func (o *FPU_Type) SetFPSCR_IXC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x10)|value<<4)
}
func (o *FPU_Type) GetFPSCR_IXC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x10) >> 4
}
func (o *FPU_Type) SetFPSCR_IDC(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x80)|value<<7)
}
func (o *FPU_Type) GetFPSCR_IDC() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x80) >> 7
}
func (o *FPU_Type) SetFPSCR_RMode(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0xc00000)|value<<22)
}
func (o *FPU_Type) GetFPSCR_RMode() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0xc00000) >> 22
}
func (o *FPU_Type) SetFPSCR_FZ(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x1000000)|value<<24)
}
func (o *FPU_Type) GetFPSCR_FZ() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x1000000) >> 24
}
func (o *FPU_Type) SetFPSCR_DN(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x2000000)|value<<25)
}
func (o *FPU_Type) GetFPSCR_DN() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x2000000) >> 25
}
func (o *FPU_Type) SetFPSCR_AHP(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x4000000)|value<<26)
}
func (o *FPU_Type) GetFPSCR_AHP() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x4000000) >> 26
}
func (o *FPU_Type) SetFPSCR_V(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x10000000)|value<<28)
}
func (o *FPU_Type) GetFPSCR_V() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x10000000) >> 28
}
func (o *FPU_Type) SetFPSCR_C(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x20000000)|value<<29)
}
func (o *FPU_Type) GetFPSCR_C() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x20000000) >> 29
}
func (o *FPU_Type) SetFPSCR_Z(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FPU_Type) GetFPSCR_Z() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x40000000) >> 30
}
func (o *FPU_Type) SetFPSCR_N(value uint32) {
	volatile.StoreUint32(&o.FPSCR.Reg, volatile.LoadUint32(&o.FPSCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FPU_Type) GetFPSCR_N() uint32 {
	return (volatile.LoadUint32(&o.FPSCR.Reg) & 0x80000000) >> 31
}

// Memory protection unit
type MPU_Type struct {
	TYPER volatile.Register32 // 0x0
	CTRL  volatile.Register32 // 0x4
	RNR   volatile.Register32 // 0x8
	RBAR  volatile.Register32 // 0xC
	RASR  volatile.Register32 // 0x10
}

// MPU.TYPER: MPU type register
func (o *MPU_Type) SetTYPER_SEPARATE(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetTYPER_SEPARATE() uint32 {
	return volatile.LoadUint32(&o.TYPER.Reg) & 0x1
}
func (o *MPU_Type) SetTYPER_DREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetTYPER_DREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetTYPER_IREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff0000)|value<<16)
}
func (o *MPU_Type) GetTYPER_IREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff0000) >> 16
}

// MPU.CTRL: MPU control register
func (o *MPU_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *MPU_Type) SetCTRL_HFNMIENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *MPU_Type) GetCTRL_HFNMIENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *MPU_Type) SetCTRL_PRIVDEFENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *MPU_Type) GetCTRL_PRIVDEFENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}

// MPU.RNR: MPU region number register
func (o *MPU_Type) SetRNR_REGION(value uint32) {
	volatile.StoreUint32(&o.RNR.Reg, volatile.LoadUint32(&o.RNR.Reg)&^(0xff)|value)
}
func (o *MPU_Type) GetRNR_REGION() uint32 {
	return volatile.LoadUint32(&o.RNR.Reg) & 0xff
}

// MPU.RBAR: MPU region base address register
func (o *MPU_Type) SetRBAR_REGION(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xf)|value)
}
func (o *MPU_Type) GetRBAR_REGION() uint32 {
	return volatile.LoadUint32(&o.RBAR.Reg) & 0xf
}
func (o *MPU_Type) SetRBAR_VALID(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0x10)|value<<4)
}
func (o *MPU_Type) GetRBAR_VALID() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0x10) >> 4
}
func (o *MPU_Type) SetRBAR_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *MPU_Type) GetRBAR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0xffffffe0) >> 5
}

// MPU.RASR: MPU region attribute and size register
func (o *MPU_Type) SetRASR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetRASR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.RASR.Reg) & 0x1
}
func (o *MPU_Type) SetRASR_SIZE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x3e)|value<<1)
}
func (o *MPU_Type) GetRASR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x3e) >> 1
}
func (o *MPU_Type) SetRASR_SRD(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetRASR_SRD() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetRASR_B(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000)|value<<16)
}
func (o *MPU_Type) GetRASR_B() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000) >> 16
}
func (o *MPU_Type) SetRASR_C(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x20000)|value<<17)
}
func (o *MPU_Type) GetRASR_C() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x20000) >> 17
}
func (o *MPU_Type) SetRASR_S(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x40000)|value<<18)
}
func (o *MPU_Type) GetRASR_S() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x40000) >> 18
}
func (o *MPU_Type) SetRASR_TEX(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x380000)|value<<19)
}
func (o *MPU_Type) GetRASR_TEX() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x380000) >> 19
}
func (o *MPU_Type) SetRASR_AP(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x7000000)|value<<24)
}
func (o *MPU_Type) GetRASR_AP() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x7000000) >> 24
}
func (o *MPU_Type) SetRASR_XN(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000000)|value<<28)
}
func (o *MPU_Type) GetRASR_XN() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000000) >> 28
}

// SysTick timer
type STK_Type struct {
	CTRL  volatile.Register32 // 0x0
	LOAD  volatile.Register32 // 0x4
	VAL   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// STK.CTRL: SysTick control and status register
func (o *STK_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *STK_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *STK_Type) SetCTRL_TICKINT(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *STK_Type) GetCTRL_TICKINT() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *STK_Type) SetCTRL_CLKSOURCE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *STK_Type) GetCTRL_CLKSOURCE() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *STK_Type) SetCTRL_COUNTFLAG(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x10000)|value<<16)
}
func (o *STK_Type) GetCTRL_COUNTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x10000) >> 16
}

// STK.LOAD: SysTick reload value register
func (o *STK_Type) SetLOAD_RELOAD(value uint32) {
	volatile.StoreUint32(&o.LOAD.Reg, volatile.LoadUint32(&o.LOAD.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetLOAD_RELOAD() uint32 {
	return volatile.LoadUint32(&o.LOAD.Reg) & 0xffffff
}

// STK.VAL: SysTick current value register
func (o *STK_Type) SetVAL_CURRENT(value uint32) {
	volatile.StoreUint32(&o.VAL.Reg, volatile.LoadUint32(&o.VAL.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetVAL_CURRENT() uint32 {
	return volatile.LoadUint32(&o.VAL.Reg) & 0xffffff
}

// STK.CALIB: SysTick calibration value register
func (o *STK_Type) SetCALIB_TENMS(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetCALIB_TENMS() uint32 {
	return volatile.LoadUint32(&o.CALIB.Reg) & 0xffffff
}
func (o *STK_Type) SetCALIB_SKEW(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x40000000)|value<<30)
}
func (o *STK_Type) GetCALIB_SKEW() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x40000000) >> 30
}
func (o *STK_Type) SetCALIB_NOREF(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x80000000)|value<<31)
}
func (o *STK_Type) GetCALIB_NOREF() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x80000000) >> 31
}

// System control block
type SCB_Type struct {
	CPUID                volatile.Register32 // 0x0
	ICSR                 volatile.Register32 // 0x4
	VTOR                 volatile.Register32 // 0x8
	AIRCR                volatile.Register32 // 0xC
	SCR                  volatile.Register32 // 0x10
	CCR                  volatile.Register32 // 0x14
	SHPR1                volatile.Register32 // 0x18
	SHPR2                volatile.Register32 // 0x1C
	SHPR3                volatile.Register32 // 0x20
	SHCRS                volatile.Register32 // 0x24
	CFSR_UFSR_BFSR_MMFSR volatile.Register32 // 0x28
	HFSR                 volatile.Register32 // 0x2C
	_                    [4]byte
	MMFAR                volatile.Register32 // 0x34
	BFAR                 volatile.Register32 // 0x38
	AFSR                 volatile.Register32 // 0x3C
}

// SCB.CPUID: CPUID base register
func (o *SCB_Type) SetCPUID_Revision(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf)|value)
}
func (o *SCB_Type) GetCPUID_Revision() uint32 {
	return volatile.LoadUint32(&o.CPUID.Reg) & 0xf
}
func (o *SCB_Type) SetCPUID_PartNo(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xfff0)|value<<4)
}
func (o *SCB_Type) GetCPUID_PartNo() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xfff0) >> 4
}
func (o *SCB_Type) SetCPUID_Constant(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf0000)|value<<16)
}
func (o *SCB_Type) GetCPUID_Constant() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf0000) >> 16
}
func (o *SCB_Type) SetCPUID_Variant(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xf00000)|value<<20)
}
func (o *SCB_Type) GetCPUID_Variant() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xf00000) >> 20
}
func (o *SCB_Type) SetCPUID_Implementer(value uint32) {
	volatile.StoreUint32(&o.CPUID.Reg, volatile.LoadUint32(&o.CPUID.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetCPUID_Implementer() uint32 {
	return (volatile.LoadUint32(&o.CPUID.Reg) & 0xff000000) >> 24
}

// SCB.ICSR: Interrupt control and state register
func (o *SCB_Type) SetICSR_VECTACTIVE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x1ff)|value)
}
func (o *SCB_Type) GetICSR_VECTACTIVE() uint32 {
	return volatile.LoadUint32(&o.ICSR.Reg) & 0x1ff
}
func (o *SCB_Type) SetICSR_RETTOBASE(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetICSR_RETTOBASE() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetICSR_VECTPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x7f000)|value<<12)
}
func (o *SCB_Type) GetICSR_VECTPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x7f000) >> 12
}
func (o *SCB_Type) SetICSR_ISRPENDING(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x400000)|value<<22)
}
func (o *SCB_Type) GetICSR_ISRPENDING() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x400000) >> 22
}
func (o *SCB_Type) SetICSR_PENDSTCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SCB_Type) GetICSR_PENDSTCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x2000000) >> 25
}
func (o *SCB_Type) SetICSR_PENDSTSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x4000000)|value<<26)
}
func (o *SCB_Type) GetICSR_PENDSTSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x4000000) >> 26
}
func (o *SCB_Type) SetICSR_PENDSVCLR(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x8000000)|value<<27)
}
func (o *SCB_Type) GetICSR_PENDSVCLR() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x8000000) >> 27
}
func (o *SCB_Type) SetICSR_PENDSVSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x10000000)|value<<28)
}
func (o *SCB_Type) GetICSR_PENDSVSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x10000000) >> 28
}
func (o *SCB_Type) SetICSR_NMIPENDSET(value uint32) {
	volatile.StoreUint32(&o.ICSR.Reg, volatile.LoadUint32(&o.ICSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetICSR_NMIPENDSET() uint32 {
	return (volatile.LoadUint32(&o.ICSR.Reg) & 0x80000000) >> 31
}

// SCB.VTOR: Vector table offset register
func (o *SCB_Type) SetVTOR_TBLOFF(value uint32) {
	volatile.StoreUint32(&o.VTOR.Reg, volatile.LoadUint32(&o.VTOR.Reg)&^(0x3ffffe00)|value<<9)
}
func (o *SCB_Type) GetVTOR_TBLOFF() uint32 {
	return (volatile.LoadUint32(&o.VTOR.Reg) & 0x3ffffe00) >> 9
}

// SCB.AIRCR: Application interrupt and reset control register
func (o *SCB_Type) SetAIRCR_VECTRESET(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetAIRCR_VECTRESET() uint32 {
	return volatile.LoadUint32(&o.AIRCR.Reg) & 0x1
}
func (o *SCB_Type) SetAIRCR_VECTCLRACTIVE(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetAIRCR_VECTCLRACTIVE() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetAIRCR_SYSRESETREQ(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetAIRCR_SYSRESETREQ() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetAIRCR_PRIGROUP(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x700)|value<<8)
}
func (o *SCB_Type) GetAIRCR_PRIGROUP() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x700) >> 8
}
func (o *SCB_Type) SetAIRCR_ENDIANESS(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetAIRCR_ENDIANESS() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetAIRCR_VECTKEYSTAT(value uint32) {
	volatile.StoreUint32(&o.AIRCR.Reg, volatile.LoadUint32(&o.AIRCR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SCB_Type) GetAIRCR_VECTKEYSTAT() uint32 {
	return (volatile.LoadUint32(&o.AIRCR.Reg) & 0xffff0000) >> 16
}

// SCB.SCR: System control register
func (o *SCB_Type) SetSCR_SLEEPONEXIT(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetSCR_SLEEPONEXIT() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetSCR_SLEEPDEEP(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetSCR_SLEEPDEEP() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetSCR_SEVEONPEND(value uint32) {
	volatile.StoreUint32(&o.SCR.Reg, volatile.LoadUint32(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetSCR_SEVEONPEND() uint32 {
	return (volatile.LoadUint32(&o.SCR.Reg) & 0x10) >> 4
}

// SCB.CCR: Configuration and control register
func (o *SCB_Type) SetCCR_NONBASETHRDENA(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetCCR_NONBASETHRDENA() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0x1
}
func (o *SCB_Type) SetCCR_USERSETMPEND(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetCCR_USERSETMPEND() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetCCR_UNALIGN__TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetCCR_UNALIGN__TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetCCR_DIV_0_TRP(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetCCR_DIV_0_TRP() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10) >> 4
}
func (o *SCB_Type) SetCCR_BFHFNMIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetCCR_BFHFNMIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetCCR_STKALIGN(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x200)|value<<9)
}
func (o *SCB_Type) GetCCR_STKALIGN() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x200) >> 9
}

// SCB.SHPR1: System handler priority registers
func (o *SCB_Type) SetSHPR1_PRI_4(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff)|value)
}
func (o *SCB_Type) GetSHPR1_PRI_4() uint32 {
	return volatile.LoadUint32(&o.SHPR1.Reg) & 0xff
}
func (o *SCB_Type) SetSHPR1_PRI_5(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff00)|value<<8)
}
func (o *SCB_Type) GetSHPR1_PRI_5() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff00) >> 8
}
func (o *SCB_Type) SetSHPR1_PRI_6(value uint32) {
	volatile.StoreUint32(&o.SHPR1.Reg, volatile.LoadUint32(&o.SHPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *SCB_Type) GetSHPR1_PRI_6() uint32 {
	return (volatile.LoadUint32(&o.SHPR1.Reg) & 0xff0000) >> 16
}

// SCB.SHPR2: System handler priority registers
func (o *SCB_Type) SetSHPR2_PRI_11(value uint32) {
	volatile.StoreUint32(&o.SHPR2.Reg, volatile.LoadUint32(&o.SHPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR2_PRI_11() uint32 {
	return (volatile.LoadUint32(&o.SHPR2.Reg) & 0xff000000) >> 24
}

// SCB.SHPR3: System handler priority registers
func (o *SCB_Type) SetSHPR3_PRI_14(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *SCB_Type) GetSHPR3_PRI_14() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff0000) >> 16
}
func (o *SCB_Type) SetSHPR3_PRI_15(value uint32) {
	volatile.StoreUint32(&o.SHPR3.Reg, volatile.LoadUint32(&o.SHPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *SCB_Type) GetSHPR3_PRI_15() uint32 {
	return (volatile.LoadUint32(&o.SHPR3.Reg) & 0xff000000) >> 24
}

// SCB.SHCRS: System handler control and state register
func (o *SCB_Type) SetSHCRS_MEMFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x1)|value)
}
func (o *SCB_Type) GetSHCRS_MEMFAULTACT() uint32 {
	return volatile.LoadUint32(&o.SHCRS.Reg) & 0x1
}
func (o *SCB_Type) SetSHCRS_BUSFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetSHCRS_BUSFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetSHCRS_USGFAULTACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetSHCRS_USGFAULTACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetSHCRS_SVCALLACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x80)|value<<7)
}
func (o *SCB_Type) GetSHCRS_SVCALLACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x80) >> 7
}
func (o *SCB_Type) SetSHCRS_MONITORACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetSHCRS_MONITORACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetSHCRS_PENDSVACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetSHCRS_PENDSVACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetSHCRS_SYSTICKACT(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetSHCRS_SYSTICKACT() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetSHCRS_USGFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetSHCRS_USGFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x1000) >> 12
}
func (o *SCB_Type) SetSHCRS_MEMFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x2000)|value<<13)
}
func (o *SCB_Type) GetSHCRS_MEMFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x2000) >> 13
}
func (o *SCB_Type) SetSHCRS_BUSFAULTPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x4000)|value<<14)
}
func (o *SCB_Type) GetSHCRS_BUSFAULTPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x4000) >> 14
}
func (o *SCB_Type) SetSHCRS_SVCALLPENDED(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetSHCRS_SVCALLPENDED() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetSHCRS_MEMFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x10000)|value<<16)
}
func (o *SCB_Type) GetSHCRS_MEMFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x10000) >> 16
}
func (o *SCB_Type) SetSHCRS_BUSFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x20000)|value<<17)
}
func (o *SCB_Type) GetSHCRS_BUSFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x20000) >> 17
}
func (o *SCB_Type) SetSHCRS_USGFAULTENA(value uint32) {
	volatile.StoreUint32(&o.SHCRS.Reg, volatile.LoadUint32(&o.SHCRS.Reg)&^(0x40000)|value<<18)
}
func (o *SCB_Type) GetSHCRS_USGFAULTENA() uint32 {
	return (volatile.LoadUint32(&o.SHCRS.Reg) & 0x40000) >> 18
}

// SCB.CFSR_UFSR_BFSR_MMFSR: Configurable fault status register
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IACCVIOL(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IACCVIOL() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MUNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x8)|value<<3)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MUNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x8) >> 3
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x10)|value<<4)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x10) >> 4
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MLSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x20)|value<<5)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MLSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x20) >> 5
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_MMARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x80)|value<<7)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_MMARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x80) >> 7
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IBUSERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x100)|value<<8)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IBUSERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x100) >> 8
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_PRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x200)|value<<9)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_PRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x200) >> 9
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_IMPRECISERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_IMPRECISERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNSTKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNSTKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_STKERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_STKERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x1000) >> 12
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_LSPERR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2000)|value<<13)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_LSPERR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2000) >> 13
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_BFARVALID(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x8000)|value<<15)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_BFARVALID() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x8000) >> 15
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNDEFINSTR(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x10000)|value<<16)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNDEFINSTR() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x10000) >> 16
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_INVSTATE(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x20000)|value<<17)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_INVSTATE() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x20000) >> 17
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_INVPC(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x40000)|value<<18)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_INVPC() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x40000) >> 18
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_NOCP(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x80000)|value<<19)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_NOCP() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x80000) >> 19
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_UNALIGNED(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_UNALIGNED() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x1000000) >> 24
}
func (o *SCB_Type) SetCFSR_UFSR_BFSR_MMFSR_DIVBYZERO(value uint32) {
	volatile.StoreUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg, volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *SCB_Type) GetCFSR_UFSR_BFSR_MMFSR_DIVBYZERO() uint32 {
	return (volatile.LoadUint32(&o.CFSR_UFSR_BFSR_MMFSR.Reg) & 0x2000000) >> 25
}

// SCB.HFSR: Hard fault status register
func (o *SCB_Type) SetHFSR_VECTTBL(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x2)|value<<1)
}
func (o *SCB_Type) GetHFSR_VECTTBL() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x2) >> 1
}
func (o *SCB_Type) SetHFSR_FORCED(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *SCB_Type) GetHFSR_FORCED() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x40000000) >> 30
}
func (o *SCB_Type) SetHFSR_DEBUG_VT(value uint32) {
	volatile.StoreUint32(&o.HFSR.Reg, volatile.LoadUint32(&o.HFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *SCB_Type) GetHFSR_DEBUG_VT() uint32 {
	return (volatile.LoadUint32(&o.HFSR.Reg) & 0x80000000) >> 31
}

// SCB.MMFAR: Memory management fault address register
func (o *SCB_Type) SetMMFAR(value uint32) {
	volatile.StoreUint32(&o.MMFAR.Reg, value)
}
func (o *SCB_Type) GetMMFAR() uint32 {
	return volatile.LoadUint32(&o.MMFAR.Reg)
}

// SCB.BFAR: Bus fault address register
func (o *SCB_Type) SetBFAR(value uint32) {
	volatile.StoreUint32(&o.BFAR.Reg, value)
}
func (o *SCB_Type) GetBFAR() uint32 {
	return volatile.LoadUint32(&o.BFAR.Reg)
}

// SCB.AFSR: Auxiliary fault status register
func (o *SCB_Type) SetAFSR(value uint32) {
	volatile.StoreUint32(&o.AFSR.Reg, value)
}
func (o *SCB_Type) GetAFSR() uint32 {
	return volatile.LoadUint32(&o.AFSR.Reg)
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR1   volatile.Register32 // 0x0
	EMR1   volatile.Register32 // 0x4
	RTSR1  volatile.Register32 // 0x8
	FTSR1  volatile.Register32 // 0xC
	SWIER1 volatile.Register32 // 0x10
	PR1    volatile.Register32 // 0x14
	_      [8]byte
	IMR2   volatile.Register32 // 0x20
	EMR2   volatile.Register32 // 0x24
	RTSR2  volatile.Register32 // 0x28
	FTSR2  volatile.Register32 // 0x2C
	SWIER2 volatile.Register32 // 0x30
	PR2    volatile.Register32 // 0x34
}

// EXTI.IMR1: Interrupt mask register
func (o *EXTI_Type) SetIMR1_MR0(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR1_MR0() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR1_MR1(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR1_MR1() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR1_MR2(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR1_MR2() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR1_MR3(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR1_MR3() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR1_MR4(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR1_MR4() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR1_MR5(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR1_MR5() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR1_MR6(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR1_MR6() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR1_MR7(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR1_MR7() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetIMR1_MR8(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR1_MR8() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR1_MR9(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR1_MR9() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR1_MR10(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR1_MR10() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR1_MR11(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR1_MR11() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetIMR1_MR12(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetIMR1_MR12() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetIMR1_MR13(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetIMR1_MR13() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetIMR1_MR14(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetIMR1_MR14() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetIMR1_MR15(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetIMR1_MR15() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetIMR1_MR16(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetIMR1_MR16() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetIMR1_MR17(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetIMR1_MR17() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetIMR1_MR18(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetIMR1_MR18() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetIMR1_MR19(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetIMR1_MR19() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetIMR1_MR20(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetIMR1_MR20() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetIMR1_MR21(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetIMR1_MR21() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetIMR1_MR22(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetIMR1_MR22() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetIMR1_MR23(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetIMR1_MR23() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetIMR1_MR24(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetIMR1_MR24() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetIMR1_MR25(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetIMR1_MR25() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetIMR1_MR26(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetIMR1_MR26() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetIMR1_MR27(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetIMR1_MR27() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetIMR1_MR28(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetIMR1_MR28() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetIMR1_MR29(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetIMR1_MR29() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetIMR1_MR30(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetIMR1_MR30() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetIMR1_MR31(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetIMR1_MR31() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80000000) >> 31
}

// EXTI.EMR1: Event mask register
func (o *EXTI_Type) SetEMR1_MR0(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR1_MR0() uint32 {
	return volatile.LoadUint32(&o.EMR1.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR1_MR1(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR1_MR1() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR1_MR2(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR1_MR2() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR1_MR3(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR1_MR3() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR1_MR4(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR1_MR4() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR1_MR5(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR1_MR5() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR1_MR6(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetEMR1_MR6() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetEMR1_MR7(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetEMR1_MR7() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetEMR1_MR8(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetEMR1_MR8() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetEMR1_MR9(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetEMR1_MR9() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetEMR1_MR10(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetEMR1_MR10() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetEMR1_MR11(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetEMR1_MR11() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetEMR1_MR12(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetEMR1_MR12() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetEMR1_MR13(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetEMR1_MR13() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetEMR1_MR14(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetEMR1_MR14() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetEMR1_MR15(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetEMR1_MR15() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetEMR1_MR16(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetEMR1_MR16() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetEMR1_MR17(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetEMR1_MR17() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetEMR1_MR18(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetEMR1_MR18() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetEMR1_MR19(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetEMR1_MR19() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetEMR1_MR20(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetEMR1_MR20() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetEMR1_MR21(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetEMR1_MR21() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetEMR1_MR22(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetEMR1_MR22() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetEMR1_MR23(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetEMR1_MR23() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x800000) >> 23
}
func (o *EXTI_Type) SetEMR1_MR24(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x1000000)|value<<24)
}
func (o *EXTI_Type) GetEMR1_MR24() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x1000000) >> 24
}
func (o *EXTI_Type) SetEMR1_MR25(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x2000000)|value<<25)
}
func (o *EXTI_Type) GetEMR1_MR25() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x2000000) >> 25
}
func (o *EXTI_Type) SetEMR1_MR26(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x4000000)|value<<26)
}
func (o *EXTI_Type) GetEMR1_MR26() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x4000000) >> 26
}
func (o *EXTI_Type) SetEMR1_MR27(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x8000000)|value<<27)
}
func (o *EXTI_Type) GetEMR1_MR27() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x8000000) >> 27
}
func (o *EXTI_Type) SetEMR1_MR28(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x10000000)|value<<28)
}
func (o *EXTI_Type) GetEMR1_MR28() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x10000000) >> 28
}
func (o *EXTI_Type) SetEMR1_MR29(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetEMR1_MR29() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetEMR1_MR30(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetEMR1_MR30() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetEMR1_MR31(value uint32) {
	volatile.StoreUint32(&o.EMR1.Reg, volatile.LoadUint32(&o.EMR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetEMR1_MR31() uint32 {
	return (volatile.LoadUint32(&o.EMR1.Reg) & 0x80000000) >> 31
}

// EXTI.RTSR1: Rising Trigger selection register
func (o *EXTI_Type) SetRTSR1_TR0(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR1_TR0() uint32 {
	return volatile.LoadUint32(&o.RTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR1_TR1(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR1_TR1() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR1_TR2(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR1_TR2() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR1_TR3(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR1_TR3() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR1_TR4(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR1_TR4() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR1_TR5(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR1_TR5() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR1_TR6(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR1_TR6() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR1_TR7(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR1_TR7() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR1_TR8(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR1_TR8() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR1_TR9(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR1_TR9() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR1_TR10(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR1_TR10() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR1_TR11(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR1_TR11() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR1_TR12(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR1_TR12() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR1_TR13(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR1_TR13() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR1_TR14(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR1_TR14() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR1_TR15(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR1_TR15() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR1_TR16(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR1_TR16() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR1_TR17(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR1_TR17() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR1_TR18(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR1_TR18() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR1_TR19(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR1_TR19() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetRTSR1_TR20(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR1_TR20() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR1_TR21(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR1_TR21() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRTSR1_TR22(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRTSR1_TR22() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetRTSR1_TR29(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetRTSR1_TR29() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetRTSR1_TR30(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetRTSR1_TR30() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetRTSR1_TR31(value uint32) {
	volatile.StoreUint32(&o.RTSR1.Reg, volatile.LoadUint32(&o.RTSR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetRTSR1_TR31() uint32 {
	return (volatile.LoadUint32(&o.RTSR1.Reg) & 0x80000000) >> 31
}

// EXTI.FTSR1: Falling Trigger selection register
func (o *EXTI_Type) SetFTSR1_TR0(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR1_TR0() uint32 {
	return volatile.LoadUint32(&o.FTSR1.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR1_TR1(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR1_TR1() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR1_TR2(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR1_TR2() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR1_TR3(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR1_TR3() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR1_TR4(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR1_TR4() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR1_TR5(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR1_TR5() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR1_TR6(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR1_TR6() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR1_TR7(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR1_TR7() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR1_TR8(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR1_TR8() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR1_TR9(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR1_TR9() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR1_TR10(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR1_TR10() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR1_TR11(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR1_TR11() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR1_TR12(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR1_TR12() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR1_TR13(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR1_TR13() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR1_TR14(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR1_TR14() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR1_TR15(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR1_TR15() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR1_TR16(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR1_TR16() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR1_TR17(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR1_TR17() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR1_TR18(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR1_TR18() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR1_TR19(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR1_TR19() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetFTSR1_TR20(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR1_TR20() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR1_TR21(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR1_TR21() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFTSR1_TR22(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFTSR1_TR22() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetFTSR1_TR29(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetFTSR1_TR29() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetFTSR1_TR30(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetFTSR1_TR30() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetFTSR1_TR31(value uint32) {
	volatile.StoreUint32(&o.FTSR1.Reg, volatile.LoadUint32(&o.FTSR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetFTSR1_TR31() uint32 {
	return (volatile.LoadUint32(&o.FTSR1.Reg) & 0x80000000) >> 31
}

// EXTI.SWIER1: Software interrupt event register
func (o *EXTI_Type) SetSWIER1_SWIER0(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER1_SWIER0() uint32 {
	return volatile.LoadUint32(&o.SWIER1.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER1(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER1() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER1_SWIER2(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER1_SWIER2() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER1_SWIER3(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER1_SWIER3() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER1_SWIER4(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER1_SWIER4() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER1_SWIER5(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER1_SWIER5() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER1_SWIER6(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER1_SWIER6() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER1_SWIER7(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER1_SWIER7() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER1_SWIER8(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER1_SWIER8() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER1_SWIER9(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER1_SWIER9() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER1_SWIER10(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER1_SWIER10() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER1_SWIER11(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER1_SWIER11() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER1_SWIER12(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER1_SWIER12() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER1_SWIER13(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER1_SWIER13() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER1_SWIER14(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER1_SWIER14() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER1_SWIER15(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER1_SWIER15() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER1_SWIER16(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER1_SWIER16() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER1_SWIER17(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER1_SWIER17() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSWIER1_SWIER18(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER1_SWIER18() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER1_SWIER19(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER1_SWIER19() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetSWIER1_SWIER20(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER1_SWIER20() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER1_SWIER21(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER1_SWIER21() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSWIER1_SWIER22(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSWIER1_SWIER22() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetSWIER1_SWIER29(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetSWIER1_SWIER29() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetSWIER1_SWIER30(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetSWIER1_SWIER30() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetSWIER1_SWIER31(value uint32) {
	volatile.StoreUint32(&o.SWIER1.Reg, volatile.LoadUint32(&o.SWIER1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetSWIER1_SWIER31() uint32 {
	return (volatile.LoadUint32(&o.SWIER1.Reg) & 0x80000000) >> 31
}

// EXTI.PR1: Pending register
func (o *EXTI_Type) SetPR1_PR0(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPR1_PR0() uint32 {
	return volatile.LoadUint32(&o.PR1.Reg) & 0x1
}
func (o *EXTI_Type) SetPR1(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR1() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPR1_PR2(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPR1_PR2() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPR1_PR3(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPR1_PR3() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPR1_PR4(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPR1_PR4() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPR1_PR5(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPR1_PR5() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPR1_PR6(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPR1_PR6() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetPR1_PR7(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetPR1_PR7() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetPR1_PR8(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPR1_PR8() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPR1_PR9(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPR1_PR9() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPR1_PR10(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetPR1_PR10() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetPR1_PR11(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetPR1_PR11() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetPR1_PR12(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetPR1_PR12() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetPR1_PR13(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetPR1_PR13() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetPR1_PR14(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetPR1_PR14() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetPR1_PR15(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetPR1_PR15() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetPR1_PR16(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetPR1_PR16() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetPR1_PR17(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetPR1_PR17() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetPR1_PR18(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetPR1_PR18() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetPR1_PR19(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetPR1_PR19() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetPR1_PR20(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetPR1_PR20() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetPR1_PR21(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetPR1_PR21() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetPR1_PR22(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetPR1_PR22() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetPR1_PR29(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x20000000)|value<<29)
}
func (o *EXTI_Type) GetPR1_PR29() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x20000000) >> 29
}
func (o *EXTI_Type) SetPR1_PR30(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x40000000)|value<<30)
}
func (o *EXTI_Type) GetPR1_PR30() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x40000000) >> 30
}
func (o *EXTI_Type) SetPR1_PR31(value uint32) {
	volatile.StoreUint32(&o.PR1.Reg, volatile.LoadUint32(&o.PR1.Reg)&^(0x80000000)|value<<31)
}
func (o *EXTI_Type) GetPR1_PR31() uint32 {
	return (volatile.LoadUint32(&o.PR1.Reg) & 0x80000000) >> 31
}

// EXTI.IMR2: Interrupt mask register
func (o *EXTI_Type) SetIMR2_MR32(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR2_MR32() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR2_MR33(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR2_MR33() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR2_MR34(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR2_MR34() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR2_MR35(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR2_MR35() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}

// EXTI.EMR2: Event mask register
func (o *EXTI_Type) SetEMR2_MR32(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR2_MR32() uint32 {
	return volatile.LoadUint32(&o.EMR2.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR2_MR33(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR2_MR33() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR2_MR34(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR2_MR34() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR2_MR35(value uint32) {
	volatile.StoreUint32(&o.EMR2.Reg, volatile.LoadUint32(&o.EMR2.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR2_MR35() uint32 {
	return (volatile.LoadUint32(&o.EMR2.Reg) & 0x8) >> 3
}

// EXTI.RTSR2: Rising Trigger selection register
func (o *EXTI_Type) SetRTSR2_TR32(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR2_TR32() uint32 {
	return volatile.LoadUint32(&o.RTSR2.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR2_TR33(value uint32) {
	volatile.StoreUint32(&o.RTSR2.Reg, volatile.LoadUint32(&o.RTSR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR2_TR33() uint32 {
	return (volatile.LoadUint32(&o.RTSR2.Reg) & 0x2) >> 1
}

// EXTI.FTSR2: Falling Trigger selection register
func (o *EXTI_Type) SetFTSR2_TR32(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR2_TR32() uint32 {
	return volatile.LoadUint32(&o.FTSR2.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR2_TR33(value uint32) {
	volatile.StoreUint32(&o.FTSR2.Reg, volatile.LoadUint32(&o.FTSR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR2_TR33() uint32 {
	return (volatile.LoadUint32(&o.FTSR2.Reg) & 0x2) >> 1
}

// EXTI.SWIER2: Software interrupt event register
func (o *EXTI_Type) SetSWIER2_SWIER32(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER2_SWIER32() uint32 {
	return volatile.LoadUint32(&o.SWIER2.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER2_SWIER33(value uint32) {
	volatile.StoreUint32(&o.SWIER2.Reg, volatile.LoadUint32(&o.SWIER2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER2_SWIER33() uint32 {
	return (volatile.LoadUint32(&o.SWIER2.Reg) & 0x2) >> 1
}

// EXTI.PR2: Pending register
func (o *EXTI_Type) SetPR2_PR32(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPR2_PR32() uint32 {
	return volatile.LoadUint32(&o.PR2.Reg) & 0x1
}
func (o *EXTI_Type) SetPR2_PR33(value uint32) {
	volatile.StoreUint32(&o.PR2.Reg, volatile.LoadUint32(&o.PR2.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR2_PR33() uint32 {
	return (volatile.LoadUint32(&o.PR2.Reg) & 0x2) >> 1
}

// Advanced timer
type TIMs_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	_            [4]byte
	CCMR3_Output volatile.Register32 // 0x54
	CCR5         volatile.Register32 // 0x58
	CCR6         volatile.Register32 // 0x5C
	OR           volatile.Register32 // 0x60
}

// TIMs.CR1: control register 1
func (o *TIMs_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIMs_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *TIMs_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIMs_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIMs_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIMs_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIMs_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIMs_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIMs_Type) SetCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *TIMs_Type) GetCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *TIMs_Type) SetCR1_CMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x60)|value<<5)
}
func (o *TIMs_Type) GetCR1_CMS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x60) >> 5
}
func (o *TIMs_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIMs_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIMs_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIMs_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *TIMs_Type) SetCR1_UIFREMAP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *TIMs_Type) GetCR1_UIFREMAP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}

// TIMs.CR2: control register 2
func (o *TIMs_Type) SetCR2_CCPC(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TIMs_Type) GetCR2_CCPC() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *TIMs_Type) SetCR2_CCUS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *TIMs_Type) GetCR2_CCUS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *TIMs_Type) SetCR2_CCDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TIMs_Type) GetCR2_CCDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *TIMs_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIMs_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *TIMs_Type) SetCR2_TI1S(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TIMs_Type) GetCR2_TI1S() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TIMs_Type) SetCR2_OIS1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *TIMs_Type) GetCR2_OIS1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *TIMs_Type) SetCR2_OIS1N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *TIMs_Type) GetCR2_OIS1N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *TIMs_Type) SetCR2_OIS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *TIMs_Type) GetCR2_OIS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *TIMs_Type) SetCR2_OIS2N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *TIMs_Type) GetCR2_OIS2N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *TIMs_Type) SetCR2_OIS3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *TIMs_Type) GetCR2_OIS3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *TIMs_Type) SetCR2_OIS3N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *TIMs_Type) GetCR2_OIS3N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *TIMs_Type) SetCR2_OIS4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *TIMs_Type) GetCR2_OIS4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *TIMs_Type) SetCR2_OIS5(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *TIMs_Type) GetCR2_OIS5() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *TIMs_Type) SetCR2_OIS6(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *TIMs_Type) GetCR2_OIS6() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *TIMs_Type) SetCR2_MMS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00000)|value<<20)
}
func (o *TIMs_Type) GetCR2_MMS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00000) >> 20
}

// TIMs.SMCR: slave mode control register
func (o *TIMs_Type) SetSMCR_SMS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x7)|value)
}
func (o *TIMs_Type) GetSMCR_SMS() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0x7
}
func (o *TIMs_Type) SetSMCR_OCCS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8)|value<<3)
}
func (o *TIMs_Type) GetSMCR_OCCS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8) >> 3
}
func (o *TIMs_Type) SetSMCR_TS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x70)|value<<4)
}
func (o *TIMs_Type) GetSMCR_TS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x70) >> 4
}
func (o *TIMs_Type) SetSMCR_MSM(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80)|value<<7)
}
func (o *TIMs_Type) GetSMCR_MSM() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80) >> 7
}
func (o *TIMs_Type) SetSMCR_ETF(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xf00)|value<<8)
}
func (o *TIMs_Type) GetSMCR_ETF() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xf00) >> 8
}
func (o *TIMs_Type) SetSMCR_ETPS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x3000)|value<<12)
}
func (o *TIMs_Type) GetSMCR_ETPS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x3000) >> 12
}
func (o *TIMs_Type) SetSMCR_ECE(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x4000)|value<<14)
}
func (o *TIMs_Type) GetSMCR_ECE() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x4000) >> 14
}
func (o *TIMs_Type) SetSMCR_ETP(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8000)|value<<15)
}
func (o *TIMs_Type) GetSMCR_ETP() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8000) >> 15
}
func (o *TIMs_Type) SetSMCR_SMS3(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x10000)|value<<16)
}
func (o *TIMs_Type) GetSMCR_SMS3() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x10000) >> 16
}

// TIMs.DIER: DMA/Interrupt enable register
func (o *TIMs_Type) SetDIER_TDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4000)|value<<14)
}
func (o *TIMs_Type) GetDIER_TDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4000) >> 14
}
func (o *TIMs_Type) SetDIER_COMDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2000)|value<<13)
}
func (o *TIMs_Type) GetDIER_COMDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2000) >> 13
}
func (o *TIMs_Type) SetDIER_CC4DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1000)|value<<12)
}
func (o *TIMs_Type) GetDIER_CC4DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x1000) >> 12
}
func (o *TIMs_Type) SetDIER_CC3DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x800)|value<<11)
}
func (o *TIMs_Type) GetDIER_CC3DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x800) >> 11
}
func (o *TIMs_Type) SetDIER_CC2DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x400)|value<<10)
}
func (o *TIMs_Type) GetDIER_CC2DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x400) >> 10
}
func (o *TIMs_Type) SetDIER_CC1DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x200)|value<<9)
}
func (o *TIMs_Type) GetDIER_CC1DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x200) >> 9
}
func (o *TIMs_Type) SetDIER_UDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x100)|value<<8)
}
func (o *TIMs_Type) GetDIER_UDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x100) >> 8
}
func (o *TIMs_Type) SetDIER_BIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x80)|value<<7)
}
func (o *TIMs_Type) GetDIER_BIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x80) >> 7
}
func (o *TIMs_Type) SetDIER_TIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x40)|value<<6)
}
func (o *TIMs_Type) GetDIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x40) >> 6
}
func (o *TIMs_Type) SetDIER_COMIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x20)|value<<5)
}
func (o *TIMs_Type) GetDIER_COMIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x20) >> 5
}
func (o *TIMs_Type) SetDIER_CC4IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x10)|value<<4)
}
func (o *TIMs_Type) GetDIER_CC4IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x10) >> 4
}
func (o *TIMs_Type) SetDIER_CC3IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x8)|value<<3)
}
func (o *TIMs_Type) GetDIER_CC3IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x8) >> 3
}
func (o *TIMs_Type) SetDIER_CC2IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4)|value<<2)
}
func (o *TIMs_Type) GetDIER_CC2IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4) >> 2
}
func (o *TIMs_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIMs_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}
func (o *TIMs_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIMs_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}

// TIMs.SR: status register
func (o *TIMs_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIMs_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TIMs_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIMs_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIMs_Type) SetSR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TIMs_Type) GetSR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TIMs_Type) SetSR_CC3IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TIMs_Type) GetSR_CC3IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TIMs_Type) SetSR_CC4IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TIMs_Type) GetSR_CC4IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TIMs_Type) SetSR_COMIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TIMs_Type) GetSR_COMIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TIMs_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TIMs_Type) GetSR_TIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TIMs_Type) SetSR_BIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TIMs_Type) GetSR_BIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TIMs_Type) SetSR_B2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TIMs_Type) GetSR_B2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TIMs_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIMs_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TIMs_Type) SetSR_CC2OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TIMs_Type) GetSR_CC2OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TIMs_Type) SetSR_CC3OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TIMs_Type) GetSR_CC3OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TIMs_Type) SetSR_CC4OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TIMs_Type) GetSR_CC4OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TIMs_Type) SetSR_C5IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *TIMs_Type) GetSR_C5IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *TIMs_Type) SetSR_C6IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *TIMs_Type) GetSR_C6IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// TIMs.EGR: event generation register
func (o *TIMs_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIMs_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}
func (o *TIMs_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIMs_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}
func (o *TIMs_Type) SetEGR_CC2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x4)|value<<2)
}
func (o *TIMs_Type) GetEGR_CC2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x4) >> 2
}
func (o *TIMs_Type) SetEGR_CC3G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x8)|value<<3)
}
func (o *TIMs_Type) GetEGR_CC3G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x8) >> 3
}
func (o *TIMs_Type) SetEGR_CC4G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x10)|value<<4)
}
func (o *TIMs_Type) GetEGR_CC4G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x10) >> 4
}
func (o *TIMs_Type) SetEGR_COMG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x20)|value<<5)
}
func (o *TIMs_Type) GetEGR_COMG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x20) >> 5
}
func (o *TIMs_Type) SetEGR_TG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x40)|value<<6)
}
func (o *TIMs_Type) GetEGR_TG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x40) >> 6
}
func (o *TIMs_Type) SetEGR_BG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x80)|value<<7)
}
func (o *TIMs_Type) GetEGR_BG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x80) >> 7
}
func (o *TIMs_Type) SetEGR_B2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x100)|value<<8)
}
func (o *TIMs_Type) GetEGR_B2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x100) >> 8
}

// TIMs.CCMR1_Output: capture/compare mode register (output mode)
func (o *TIMs_Type) SetCCMR1_Output_OC2CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIMs_Type) GetCCMR1_Output_OC2CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8000) >> 15
}
func (o *TIMs_Type) SetCCMR1_Output_OC2M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIMs_Type) GetCCMR1_Output_OC2M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x7000) >> 12
}
func (o *TIMs_Type) SetCCMR1_Output_OC2PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIMs_Type) GetCCMR1_Output_OC2PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x800) >> 11
}
func (o *TIMs_Type) SetCCMR1_Output_OC2FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIMs_Type) GetCCMR1_Output_OC2FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x400) >> 10
}
func (o *TIMs_Type) SetCCMR1_Output_CC2S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIMs_Type) GetCCMR1_Output_CC2S() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x300) >> 8
}
func (o *TIMs_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIMs_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}
func (o *TIMs_Type) SetCCMR1_Output_OC1M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIMs_Type) GetCCMR1_Output_OC1M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIMs_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIMs_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIMs_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIMs_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIMs_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIMs_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}
func (o *TIMs_Type) SetCCMR1_Output_OC1M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIMs_Type) GetCCMR1_Output_OC1M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x10000) >> 16
}
func (o *TIMs_Type) SetCCMR1_Output_OC2M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIMs_Type) GetCCMR1_Output_OC2M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x1000000) >> 24
}

// TIMs.CCMR2_Output: capture/compare mode register (output mode)
func (o *TIMs_Type) SetCCMR2_Output_OC4CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIMs_Type) GetCCMR2_Output_OC4CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8000) >> 15
}
func (o *TIMs_Type) SetCCMR2_Output_OC4M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIMs_Type) GetCCMR2_Output_OC4M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x7000) >> 12
}
func (o *TIMs_Type) SetCCMR2_Output_OC4PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIMs_Type) GetCCMR2_Output_OC4PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x800) >> 11
}
func (o *TIMs_Type) SetCCMR2_Output_OC4FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIMs_Type) GetCCMR2_Output_OC4FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x400) >> 10
}
func (o *TIMs_Type) SetCCMR2_Output_CC4S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIMs_Type) GetCCMR2_Output_CC4S() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x300) >> 8
}
func (o *TIMs_Type) SetCCMR2_Output_OC3CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIMs_Type) GetCCMR2_Output_OC3CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x80) >> 7
}
func (o *TIMs_Type) SetCCMR2_Output_OC3M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIMs_Type) GetCCMR2_Output_OC3M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x70) >> 4
}
func (o *TIMs_Type) SetCCMR2_Output_OC3PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIMs_Type) GetCCMR2_Output_OC3PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8) >> 3
}
func (o *TIMs_Type) SetCCMR2_Output_OC3FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIMs_Type) GetCCMR2_Output_OC3FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x4) >> 2
}
func (o *TIMs_Type) SetCCMR2_Output_CC3S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x3)|value)
}
func (o *TIMs_Type) GetCCMR2_Output_CC3S() uint32 {
	return volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x3
}
func (o *TIMs_Type) SetCCMR2_Output_OC3M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIMs_Type) GetCCMR2_Output_OC3M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x10000) >> 16
}
func (o *TIMs_Type) SetCCMR2_Output_OC4M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIMs_Type) GetCCMR2_Output_OC4M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x1000000) >> 24
}

// TIMs.CCER: capture/compare enable register
func (o *TIMs_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIMs_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}
func (o *TIMs_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIMs_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIMs_Type) SetCCER_CC1NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x4)|value<<2)
}
func (o *TIMs_Type) GetCCER_CC1NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x4) >> 2
}
func (o *TIMs_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIMs_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIMs_Type) SetCCER_CC2E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10)|value<<4)
}
func (o *TIMs_Type) GetCCER_CC2E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10) >> 4
}
func (o *TIMs_Type) SetCCER_CC2P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20)|value<<5)
}
func (o *TIMs_Type) GetCCER_CC2P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20) >> 5
}
func (o *TIMs_Type) SetCCER_CC2NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x40)|value<<6)
}
func (o *TIMs_Type) GetCCER_CC2NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x40) >> 6
}
func (o *TIMs_Type) SetCCER_CC2NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x80)|value<<7)
}
func (o *TIMs_Type) GetCCER_CC2NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x80) >> 7
}
func (o *TIMs_Type) SetCCER_CC3E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100)|value<<8)
}
func (o *TIMs_Type) GetCCER_CC3E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100) >> 8
}
func (o *TIMs_Type) SetCCER_CC3P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200)|value<<9)
}
func (o *TIMs_Type) GetCCER_CC3P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200) >> 9
}
func (o *TIMs_Type) SetCCER_CC3NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x400)|value<<10)
}
func (o *TIMs_Type) GetCCER_CC3NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x400) >> 10
}
func (o *TIMs_Type) SetCCER_CC3NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x800)|value<<11)
}
func (o *TIMs_Type) GetCCER_CC3NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x800) >> 11
}
func (o *TIMs_Type) SetCCER_CC4E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1000)|value<<12)
}
func (o *TIMs_Type) GetCCER_CC4E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x1000) >> 12
}
func (o *TIMs_Type) SetCCER_CC4P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2000)|value<<13)
}
func (o *TIMs_Type) GetCCER_CC4P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2000) >> 13
}
func (o *TIMs_Type) SetCCER_CC4NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8000)|value<<15)
}
func (o *TIMs_Type) GetCCER_CC4NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8000) >> 15
}
func (o *TIMs_Type) SetCCER_CC5E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10000)|value<<16)
}
func (o *TIMs_Type) GetCCER_CC5E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10000) >> 16
}
func (o *TIMs_Type) SetCCER_CC5P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20000)|value<<17)
}
func (o *TIMs_Type) GetCCER_CC5P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20000) >> 17
}
func (o *TIMs_Type) SetCCER_CC6E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100000)|value<<20)
}
func (o *TIMs_Type) GetCCER_CC6E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100000) >> 20
}
func (o *TIMs_Type) SetCCER_CC6P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200000)|value<<21)
}
func (o *TIMs_Type) GetCCER_CC6P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200000) >> 21
}

// TIMs.CNT: counter
func (o *TIMs_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *TIMs_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}
func (o *TIMs_Type) SetCNT_UIFCPY(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMs_Type) GetCNT_UIFCPY() uint32 {
	return (volatile.LoadUint32(&o.CNT.Reg) & 0x80000000) >> 31
}

// TIMs.PSC: prescaler
func (o *TIMs_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIMs_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIMs.ARR: auto-reload register
func (o *TIMs_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *TIMs_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// TIMs.RCR: repetition counter register
func (o *TIMs_Type) SetRCR_REP(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *TIMs_Type) GetRCR_REP() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// TIMs.CCR1: capture/compare register
func (o *TIMs_Type) SetCCR1_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xffff)|value)
}
func (o *TIMs_Type) GetCCR1_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xffff
}

// TIMs.CCR2: capture/compare register
func (o *TIMs_Type) SetCCR2_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xffff)|value)
}
func (o *TIMs_Type) GetCCR2_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xffff
}

// TIMs.CCR3: capture/compare register
func (o *TIMs_Type) SetCCR3_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xffff)|value)
}
func (o *TIMs_Type) GetCCR3_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0xffff
}

// TIMs.CCR4: capture/compare register
func (o *TIMs_Type) SetCCR4_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xffff)|value)
}
func (o *TIMs_Type) GetCCR4_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0xffff
}

// TIMs.BDTR: break and dead-time register
func (o *TIMs_Type) SetBDTR_DTG(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xff)|value)
}
func (o *TIMs_Type) GetBDTR_DTG() uint32 {
	return volatile.LoadUint32(&o.BDTR.Reg) & 0xff
}
func (o *TIMs_Type) SetBDTR_LOCK(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x300)|value<<8)
}
func (o *TIMs_Type) GetBDTR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x300) >> 8
}
func (o *TIMs_Type) SetBDTR_OSSI(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x400)|value<<10)
}
func (o *TIMs_Type) GetBDTR_OSSI() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x400) >> 10
}
func (o *TIMs_Type) SetBDTR_OSSR(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x800)|value<<11)
}
func (o *TIMs_Type) GetBDTR_OSSR() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x800) >> 11
}
func (o *TIMs_Type) SetBDTR_BKE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000)|value<<12)
}
func (o *TIMs_Type) GetBDTR_BKE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000) >> 12
}
func (o *TIMs_Type) SetBDTR_BKP(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000)|value<<13)
}
func (o *TIMs_Type) GetBDTR_BKP() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000) >> 13
}
func (o *TIMs_Type) SetBDTR_AOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000)|value<<14)
}
func (o *TIMs_Type) GetBDTR_AOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000) >> 14
}
func (o *TIMs_Type) SetBDTR_MOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x8000)|value<<15)
}
func (o *TIMs_Type) GetBDTR_MOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x8000) >> 15
}
func (o *TIMs_Type) SetBDTR_BKF(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xf0000)|value<<16)
}
func (o *TIMs_Type) GetBDTR_BKF() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0xf0000) >> 16
}
func (o *TIMs_Type) SetBDTR_BK2F(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xf00000)|value<<20)
}
func (o *TIMs_Type) GetBDTR_BK2F() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0xf00000) >> 20
}
func (o *TIMs_Type) SetBDTR_BK2E(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000000)|value<<24)
}
func (o *TIMs_Type) GetBDTR_BK2E() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000000) >> 24
}
func (o *TIMs_Type) SetBDTR_BK2P(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000000)|value<<25)
}
func (o *TIMs_Type) GetBDTR_BK2P() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000000) >> 25
}

// TIMs.DCR: DMA control register
func (o *TIMs_Type) SetDCR_DBL(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f00)|value<<8)
}
func (o *TIMs_Type) GetDCR_DBL() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f00) >> 8
}
func (o *TIMs_Type) SetDCR_DBA(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f)|value)
}
func (o *TIMs_Type) GetDCR_DBA() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1f
}

// TIMs.DMAR: DMA address for full transfer
func (o *TIMs_Type) SetDMAR_DMAB(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, volatile.LoadUint32(&o.DMAR.Reg)&^(0xffff)|value)
}
func (o *TIMs_Type) GetDMAR_DMAB() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg) & 0xffff
}

// TIMs.CCMR3_Output: capture/compare mode register 3 (output mode)
func (o *TIMs_Type) SetCCMR3_Output_OC5FE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIMs_Type) GetCCMR3_Output_OC5FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x4) >> 2
}
func (o *TIMs_Type) SetCCMR3_Output_OC5PE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIMs_Type) GetCCMR3_Output_OC5PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x8) >> 3
}
func (o *TIMs_Type) SetCCMR3_Output_OC5M(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIMs_Type) GetCCMR3_Output_OC5M() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x70) >> 4
}
func (o *TIMs_Type) SetCCMR3_Output_OC5CE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIMs_Type) GetCCMR3_Output_OC5CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x80) >> 7
}
func (o *TIMs_Type) SetCCMR3_Output_OC6FE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIMs_Type) GetCCMR3_Output_OC6FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x400) >> 10
}
func (o *TIMs_Type) SetCCMR3_Output_OC6PE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIMs_Type) GetCCMR3_Output_OC6PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x800) >> 11
}
func (o *TIMs_Type) SetCCMR3_Output_OC6M(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIMs_Type) GetCCMR3_Output_OC6M() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x7000) >> 12
}
func (o *TIMs_Type) SetCCMR3_Output_OC6CE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIMs_Type) GetCCMR3_Output_OC6CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x8000) >> 15
}
func (o *TIMs_Type) SetCCMR3_Output_OC5M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIMs_Type) GetCCMR3_Output_OC5M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x10000) >> 16
}
func (o *TIMs_Type) SetCCMR3_Output_OC6M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIMs_Type) GetCCMR3_Output_OC6M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x1000000) >> 24
}

// TIMs.CCR5: capture/compare register
func (o *TIMs_Type) SetCCR5_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xffff)|value)
}
func (o *TIMs_Type) GetCCR5_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR5.Reg) & 0xffff
}
func (o *TIMs_Type) SetCCR5_GC5C1(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x20000000)|value<<29)
}
func (o *TIMs_Type) GetCCR5_GC5C1() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x20000000) >> 29
}
func (o *TIMs_Type) SetCCR5_GC5C2(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x40000000)|value<<30)
}
func (o *TIMs_Type) GetCCR5_GC5C2() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x40000000) >> 30
}
func (o *TIMs_Type) SetCCR5_GC5C3(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x80000000)|value<<31)
}
func (o *TIMs_Type) GetCCR5_GC5C3() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x80000000) >> 31
}

// TIMs.CCR6: capture/compare register
func (o *TIMs_Type) SetCCR6_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xffff)|value)
}
func (o *TIMs_Type) GetCCR6_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR6.Reg) & 0xffff
}

// TIMs.OR: option registers
func (o *TIMs_Type) SetOR_TIM1_ETR_ADC1_RMP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x3)|value)
}
func (o *TIMs_Type) GetOR_TIM1_ETR_ADC1_RMP() uint32 {
	return volatile.LoadUint32(&o.OR.Reg) & 0x3
}
func (o *TIMs_Type) SetOR_TIM1_ETR_ADC4_RMP(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0xc)|value<<2)
}
func (o *TIMs_Type) GetOR_TIM1_ETR_ADC4_RMP() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0xc) >> 2
}

// Operational Amplifier
type OPAMP_Type struct {
	_          [60]byte
	OPAMP2_CSR volatile.Register32 // 0x3C
}

// OPAMP.OPAMP2_CSR: OPAMP2 control register
func (o *OPAMP_Type) SetOPAMP2_CSR_OPAMP2EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x1)|value)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_OPAMP2EN() uint32 {
	return volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x1
}
func (o *OPAMP_Type) SetOPAMP2_CSR_FORCE_VP(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x2)|value<<1)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_FORCE_VP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x2) >> 1
}
func (o *OPAMP_Type) SetOPAMP2_CSR_VP_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0xc)|value<<2)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_VP_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0xc) >> 2
}
func (o *OPAMP_Type) SetOPAMP2_CSR_VM_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x60)|value<<5)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_VM_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x60) >> 5
}
func (o *OPAMP_Type) SetOPAMP2_CSR_TCM_EN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x80)|value<<7)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_TCM_EN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x80) >> 7
}
func (o *OPAMP_Type) SetOPAMP2_CSR_VMS_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x100)|value<<8)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_VMS_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x100) >> 8
}
func (o *OPAMP_Type) SetOPAMP2_CSR_VPS_SEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x600)|value<<9)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_VPS_SEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x600) >> 9
}
func (o *OPAMP_Type) SetOPAMP2_CSR_CALON(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x800)|value<<11)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_CALON() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x800) >> 11
}
func (o *OPAMP_Type) SetOPAMP2_CSR_CALSEL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x3000)|value<<12)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_CALSEL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x3000) >> 12
}
func (o *OPAMP_Type) SetOPAMP2_CSR_PGA_GAIN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x3c000)|value<<14)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_PGA_GAIN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x3c000) >> 14
}
func (o *OPAMP_Type) SetOPAMP2_CSR_USER_TRIM(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x40000)|value<<18)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_USER_TRIM() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x40000) >> 18
}
func (o *OPAMP_Type) SetOPAMP2_CSR_TRIMOFFSETP(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0xf80000)|value<<19)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_TRIMOFFSETP() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0xf80000) >> 19
}
func (o *OPAMP_Type) SetOPAMP2_CSR_TRIMOFFSETN(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x1f000000)|value<<24)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_TRIMOFFSETN() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x1f000000) >> 24
}
func (o *OPAMP_Type) SetOPAMP2_CSR_TSTREF(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_TSTREF() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x20000000) >> 29
}
func (o *OPAMP_Type) SetOPAMP2_CSR_OUTCAL(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_OUTCAL() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x40000000) >> 30
}
func (o *OPAMP_Type) SetOPAMP2_CSR_LOCK(value uint32) {
	volatile.StoreUint32(&o.OPAMP2_CSR.Reg, volatile.LoadUint32(&o.OPAMP2_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *OPAMP_Type) GetOPAMP2_CSR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.OPAMP2_CSR.Reg) & 0x80000000) >> 31
}

// General purpose comparators
type COMP_Type struct {
	_         [32]byte
	COMP2_CSR volatile.Register32 // 0x20
	_         [4]byte
	COMP4_CSR volatile.Register32 // 0x28
	_         [4]byte
	COMP6_CSR volatile.Register32 // 0x30
}

// COMP.COMP2_CSR: control and status register
func (o *COMP_Type) SetCOMP2_CSR_COMP2EN(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2EN() uint32 {
	return volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x1
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2INMSEL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x70)|value<<4)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2INMSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x70) >> 4
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2OUTSEL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x3c00)|value<<10)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x3c00) >> 10
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2POL(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2POL() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_BLANKING(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x1c0000)|value<<18)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_BLANKING() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x1c0000) >> 18
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2OUT(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2OUT() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2LOCK(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2LOCK() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x80000000) >> 31
}
func (o *COMP_Type) SetCOMP2_CSR_COMP2_INP_DAC(value uint32) {
	volatile.StoreUint32(&o.COMP2_CSR.Reg, volatile.LoadUint32(&o.COMP2_CSR.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetCOMP2_CSR_COMP2_INP_DAC() uint32 {
	return (volatile.LoadUint32(&o.COMP2_CSR.Reg) & 0x2) >> 1
}

// COMP.COMP4_CSR: control and status register
func (o *COMP_Type) SetCOMP4_CSR_COMP4EN(value uint32) {
	volatile.StoreUint32(&o.COMP4_CSR.Reg, volatile.LoadUint32(&o.COMP4_CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetCOMP4_CSR_COMP4EN() uint32 {
	return volatile.LoadUint32(&o.COMP4_CSR.Reg) & 0x1
}
func (o *COMP_Type) SetCOMP4_CSR_COMP4INMSEL(value uint32) {
	volatile.StoreUint32(&o.COMP4_CSR.Reg, volatile.LoadUint32(&o.COMP4_CSR.Reg)&^(0x70)|value<<4)
}
func (o *COMP_Type) GetCOMP4_CSR_COMP4INMSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP4_CSR.Reg) & 0x70) >> 4
}
func (o *COMP_Type) SetCOMP4_CSR_COMP4OUTSEL(value uint32) {
	volatile.StoreUint32(&o.COMP4_CSR.Reg, volatile.LoadUint32(&o.COMP4_CSR.Reg)&^(0x3c00)|value<<10)
}
func (o *COMP_Type) GetCOMP4_CSR_COMP4OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP4_CSR.Reg) & 0x3c00) >> 10
}
func (o *COMP_Type) SetCOMP4_CSR_COMP4POL(value uint32) {
	volatile.StoreUint32(&o.COMP4_CSR.Reg, volatile.LoadUint32(&o.COMP4_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetCOMP4_CSR_COMP4POL() uint32 {
	return (volatile.LoadUint32(&o.COMP4_CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetCOMP4_CSR_COMP4_BLANKING(value uint32) {
	volatile.StoreUint32(&o.COMP4_CSR.Reg, volatile.LoadUint32(&o.COMP4_CSR.Reg)&^(0x1c0000)|value<<18)
}
func (o *COMP_Type) GetCOMP4_CSR_COMP4_BLANKING() uint32 {
	return (volatile.LoadUint32(&o.COMP4_CSR.Reg) & 0x1c0000) >> 18
}
func (o *COMP_Type) SetCOMP4_CSR_COMP4OUT(value uint32) {
	volatile.StoreUint32(&o.COMP4_CSR.Reg, volatile.LoadUint32(&o.COMP4_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetCOMP4_CSR_COMP4OUT() uint32 {
	return (volatile.LoadUint32(&o.COMP4_CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetCOMP4_CSR_COMP4LOCK(value uint32) {
	volatile.StoreUint32(&o.COMP4_CSR.Reg, volatile.LoadUint32(&o.COMP4_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetCOMP4_CSR_COMP4LOCK() uint32 {
	return (volatile.LoadUint32(&o.COMP4_CSR.Reg) & 0x80000000) >> 31
}

// COMP.COMP6_CSR: control and status register
func (o *COMP_Type) SetCOMP6_CSR_COMP6EN(value uint32) {
	volatile.StoreUint32(&o.COMP6_CSR.Reg, volatile.LoadUint32(&o.COMP6_CSR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetCOMP6_CSR_COMP6EN() uint32 {
	return volatile.LoadUint32(&o.COMP6_CSR.Reg) & 0x1
}
func (o *COMP_Type) SetCOMP6_CSR_COMP6INMSEL(value uint32) {
	volatile.StoreUint32(&o.COMP6_CSR.Reg, volatile.LoadUint32(&o.COMP6_CSR.Reg)&^(0x70)|value<<4)
}
func (o *COMP_Type) GetCOMP6_CSR_COMP6INMSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP6_CSR.Reg) & 0x70) >> 4
}
func (o *COMP_Type) SetCOMP6_CSR_COMP6OUTSEL(value uint32) {
	volatile.StoreUint32(&o.COMP6_CSR.Reg, volatile.LoadUint32(&o.COMP6_CSR.Reg)&^(0x3c00)|value<<10)
}
func (o *COMP_Type) GetCOMP6_CSR_COMP6OUTSEL() uint32 {
	return (volatile.LoadUint32(&o.COMP6_CSR.Reg) & 0x3c00) >> 10
}
func (o *COMP_Type) SetCOMP6_CSR_COMP6POL(value uint32) {
	volatile.StoreUint32(&o.COMP6_CSR.Reg, volatile.LoadUint32(&o.COMP6_CSR.Reg)&^(0x8000)|value<<15)
}
func (o *COMP_Type) GetCOMP6_CSR_COMP6POL() uint32 {
	return (volatile.LoadUint32(&o.COMP6_CSR.Reg) & 0x8000) >> 15
}
func (o *COMP_Type) SetCOMP6_CSR_COMP6_BLANKING(value uint32) {
	volatile.StoreUint32(&o.COMP6_CSR.Reg, volatile.LoadUint32(&o.COMP6_CSR.Reg)&^(0x1c0000)|value<<18)
}
func (o *COMP_Type) GetCOMP6_CSR_COMP6_BLANKING() uint32 {
	return (volatile.LoadUint32(&o.COMP6_CSR.Reg) & 0x1c0000) >> 18
}
func (o *COMP_Type) SetCOMP6_CSR_COMP6OUT(value uint32) {
	volatile.StoreUint32(&o.COMP6_CSR.Reg, volatile.LoadUint32(&o.COMP6_CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *COMP_Type) GetCOMP6_CSR_COMP6OUT() uint32 {
	return (volatile.LoadUint32(&o.COMP6_CSR.Reg) & 0x40000000) >> 30
}
func (o *COMP_Type) SetCOMP6_CSR_COMP6LOCK(value uint32) {
	volatile.StoreUint32(&o.COMP6_CSR.Reg, volatile.LoadUint32(&o.COMP6_CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *COMP_Type) GetCOMP6_CSR_COMP6LOCK() uint32 {
	return (volatile.LoadUint32(&o.COMP6_CSR.Reg) & 0x80000000) >> 31
}

// Constants for GPIOA: General-purpose I/Os
const (
	// MODER: GPIO port mode register
	// Position of MODER15 field.
	GPIO_MODER_MODER15_Pos = 0x1e
	// Bit mask of MODER15 field.
	GPIO_MODER_MODER15_Msk = 0xc0000000
	// Input mode (reset state)
	GPIO_MODER_MODER15_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER15_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER15_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER15_Analog = 0x3
	// Position of MODER14 field.
	GPIO_MODER_MODER14_Pos = 0x1c
	// Bit mask of MODER14 field.
	GPIO_MODER_MODER14_Msk = 0x30000000
	// Input mode (reset state)
	GPIO_MODER_MODER14_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER14_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER14_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER14_Analog = 0x3
	// Position of MODER13 field.
	GPIO_MODER_MODER13_Pos = 0x1a
	// Bit mask of MODER13 field.
	GPIO_MODER_MODER13_Msk = 0xc000000
	// Input mode (reset state)
	GPIO_MODER_MODER13_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER13_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER13_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER13_Analog = 0x3
	// Position of MODER12 field.
	GPIO_MODER_MODER12_Pos = 0x18
	// Bit mask of MODER12 field.
	GPIO_MODER_MODER12_Msk = 0x3000000
	// Input mode (reset state)
	GPIO_MODER_MODER12_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER12_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER12_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER12_Analog = 0x3
	// Position of MODER11 field.
	GPIO_MODER_MODER11_Pos = 0x16
	// Bit mask of MODER11 field.
	GPIO_MODER_MODER11_Msk = 0xc00000
	// Input mode (reset state)
	GPIO_MODER_MODER11_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER11_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER11_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER11_Analog = 0x3
	// Position of MODER10 field.
	GPIO_MODER_MODER10_Pos = 0x14
	// Bit mask of MODER10 field.
	GPIO_MODER_MODER10_Msk = 0x300000
	// Input mode (reset state)
	GPIO_MODER_MODER10_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER10_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER10_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER10_Analog = 0x3
	// Position of MODER9 field.
	GPIO_MODER_MODER9_Pos = 0x12
	// Bit mask of MODER9 field.
	GPIO_MODER_MODER9_Msk = 0xc0000
	// Input mode (reset state)
	GPIO_MODER_MODER9_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER9_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER9_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER9_Analog = 0x3
	// Position of MODER8 field.
	GPIO_MODER_MODER8_Pos = 0x10
	// Bit mask of MODER8 field.
	GPIO_MODER_MODER8_Msk = 0x30000
	// Input mode (reset state)
	GPIO_MODER_MODER8_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER8_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER8_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER8_Analog = 0x3
	// Position of MODER7 field.
	GPIO_MODER_MODER7_Pos = 0xe
	// Bit mask of MODER7 field.
	GPIO_MODER_MODER7_Msk = 0xc000
	// Input mode (reset state)
	GPIO_MODER_MODER7_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER7_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER7_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER7_Analog = 0x3
	// Position of MODER6 field.
	GPIO_MODER_MODER6_Pos = 0xc
	// Bit mask of MODER6 field.
	GPIO_MODER_MODER6_Msk = 0x3000
	// Input mode (reset state)
	GPIO_MODER_MODER6_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER6_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER6_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER6_Analog = 0x3
	// Position of MODER5 field.
	GPIO_MODER_MODER5_Pos = 0xa
	// Bit mask of MODER5 field.
	GPIO_MODER_MODER5_Msk = 0xc00
	// Input mode (reset state)
	GPIO_MODER_MODER5_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER5_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER5_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER5_Analog = 0x3
	// Position of MODER4 field.
	GPIO_MODER_MODER4_Pos = 0x8
	// Bit mask of MODER4 field.
	GPIO_MODER_MODER4_Msk = 0x300
	// Input mode (reset state)
	GPIO_MODER_MODER4_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER4_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER4_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER4_Analog = 0x3
	// Position of MODER3 field.
	GPIO_MODER_MODER3_Pos = 0x6
	// Bit mask of MODER3 field.
	GPIO_MODER_MODER3_Msk = 0xc0
	// Input mode (reset state)
	GPIO_MODER_MODER3_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER3_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER3_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER3_Analog = 0x3
	// Position of MODER2 field.
	GPIO_MODER_MODER2_Pos = 0x4
	// Bit mask of MODER2 field.
	GPIO_MODER_MODER2_Msk = 0x30
	// Input mode (reset state)
	GPIO_MODER_MODER2_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER2_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER2_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER2_Analog = 0x3
	// Position of MODER1 field.
	GPIO_MODER_MODER1_Pos = 0x2
	// Bit mask of MODER1 field.
	GPIO_MODER_MODER1_Msk = 0xc
	// Input mode (reset state)
	GPIO_MODER_MODER1_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER1_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER1_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER1_Analog = 0x3
	// Position of MODER0 field.
	GPIO_MODER_MODER0_Pos = 0x0
	// Bit mask of MODER0 field.
	GPIO_MODER_MODER0_Msk = 0x3
	// Input mode (reset state)
	GPIO_MODER_MODER0_Input = 0x0
	// General purpose output mode
	GPIO_MODER_MODER0_Output = 0x1
	// Alternate function mode
	GPIO_MODER_MODER0_Alternate = 0x2
	// Analog mode
	GPIO_MODER_MODER0_Analog = 0x3

	// OTYPER: GPIO port output type register
	// Position of OT15 field.
	GPIO_OTYPER_OT15_Pos = 0xf
	// Bit mask of OT15 field.
	GPIO_OTYPER_OT15_Msk = 0x8000
	// Bit OT15.
	GPIO_OTYPER_OT15 = 0x8000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT15_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT15_OpenDrain = 0x1
	// Position of OT14 field.
	GPIO_OTYPER_OT14_Pos = 0xe
	// Bit mask of OT14 field.
	GPIO_OTYPER_OT14_Msk = 0x4000
	// Bit OT14.
	GPIO_OTYPER_OT14 = 0x4000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT14_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT14_OpenDrain = 0x1
	// Position of OT13 field.
	GPIO_OTYPER_OT13_Pos = 0xd
	// Bit mask of OT13 field.
	GPIO_OTYPER_OT13_Msk = 0x2000
	// Bit OT13.
	GPIO_OTYPER_OT13 = 0x2000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT13_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT13_OpenDrain = 0x1
	// Position of OT12 field.
	GPIO_OTYPER_OT12_Pos = 0xc
	// Bit mask of OT12 field.
	GPIO_OTYPER_OT12_Msk = 0x1000
	// Bit OT12.
	GPIO_OTYPER_OT12 = 0x1000
	// Output push-pull (reset state)
	GPIO_OTYPER_OT12_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT12_OpenDrain = 0x1
	// Position of OT11 field.
	GPIO_OTYPER_OT11_Pos = 0xb
	// Bit mask of OT11 field.
	GPIO_OTYPER_OT11_Msk = 0x800
	// Bit OT11.
	GPIO_OTYPER_OT11 = 0x800
	// Output push-pull (reset state)
	GPIO_OTYPER_OT11_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT11_OpenDrain = 0x1
	// Position of OT10 field.
	GPIO_OTYPER_OT10_Pos = 0xa
	// Bit mask of OT10 field.
	GPIO_OTYPER_OT10_Msk = 0x400
	// Bit OT10.
	GPIO_OTYPER_OT10 = 0x400
	// Output push-pull (reset state)
	GPIO_OTYPER_OT10_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT10_OpenDrain = 0x1
	// Position of OT9 field.
	GPIO_OTYPER_OT9_Pos = 0x9
	// Bit mask of OT9 field.
	GPIO_OTYPER_OT9_Msk = 0x200
	// Bit OT9.
	GPIO_OTYPER_OT9 = 0x200
	// Output push-pull (reset state)
	GPIO_OTYPER_OT9_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT9_OpenDrain = 0x1
	// Position of OT8 field.
	GPIO_OTYPER_OT8_Pos = 0x8
	// Bit mask of OT8 field.
	GPIO_OTYPER_OT8_Msk = 0x100
	// Bit OT8.
	GPIO_OTYPER_OT8 = 0x100
	// Output push-pull (reset state)
	GPIO_OTYPER_OT8_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT8_OpenDrain = 0x1
	// Position of OT7 field.
	GPIO_OTYPER_OT7_Pos = 0x7
	// Bit mask of OT7 field.
	GPIO_OTYPER_OT7_Msk = 0x80
	// Bit OT7.
	GPIO_OTYPER_OT7 = 0x80
	// Output push-pull (reset state)
	GPIO_OTYPER_OT7_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT7_OpenDrain = 0x1
	// Position of OT6 field.
	GPIO_OTYPER_OT6_Pos = 0x6
	// Bit mask of OT6 field.
	GPIO_OTYPER_OT6_Msk = 0x40
	// Bit OT6.
	GPIO_OTYPER_OT6 = 0x40
	// Output push-pull (reset state)
	GPIO_OTYPER_OT6_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT6_OpenDrain = 0x1
	// Position of OT5 field.
	GPIO_OTYPER_OT5_Pos = 0x5
	// Bit mask of OT5 field.
	GPIO_OTYPER_OT5_Msk = 0x20
	// Bit OT5.
	GPIO_OTYPER_OT5 = 0x20
	// Output push-pull (reset state)
	GPIO_OTYPER_OT5_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT5_OpenDrain = 0x1
	// Position of OT4 field.
	GPIO_OTYPER_OT4_Pos = 0x4
	// Bit mask of OT4 field.
	GPIO_OTYPER_OT4_Msk = 0x10
	// Bit OT4.
	GPIO_OTYPER_OT4 = 0x10
	// Output push-pull (reset state)
	GPIO_OTYPER_OT4_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT4_OpenDrain = 0x1
	// Position of OT3 field.
	GPIO_OTYPER_OT3_Pos = 0x3
	// Bit mask of OT3 field.
	GPIO_OTYPER_OT3_Msk = 0x8
	// Bit OT3.
	GPIO_OTYPER_OT3 = 0x8
	// Output push-pull (reset state)
	GPIO_OTYPER_OT3_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT3_OpenDrain = 0x1
	// Position of OT2 field.
	GPIO_OTYPER_OT2_Pos = 0x2
	// Bit mask of OT2 field.
	GPIO_OTYPER_OT2_Msk = 0x4
	// Bit OT2.
	GPIO_OTYPER_OT2 = 0x4
	// Output push-pull (reset state)
	GPIO_OTYPER_OT2_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT2_OpenDrain = 0x1
	// Position of OT1 field.
	GPIO_OTYPER_OT1_Pos = 0x1
	// Bit mask of OT1 field.
	GPIO_OTYPER_OT1_Msk = 0x2
	// Bit OT1.
	GPIO_OTYPER_OT1 = 0x2
	// Output push-pull (reset state)
	GPIO_OTYPER_OT1_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT1_OpenDrain = 0x1
	// Position of OT0 field.
	GPIO_OTYPER_OT0_Pos = 0x0
	// Bit mask of OT0 field.
	GPIO_OTYPER_OT0_Msk = 0x1
	// Bit OT0.
	GPIO_OTYPER_OT0 = 0x1
	// Output push-pull (reset state)
	GPIO_OTYPER_OT0_PushPull = 0x0
	// Output open-drain
	GPIO_OTYPER_OT0_OpenDrain = 0x1

	// OSPEEDR: GPIO port output speed register
	// Position of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Pos = 0x1e
	// Bit mask of OSPEEDR15 field.
	GPIO_OSPEEDR_OSPEEDR15_Msk = 0xc0000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR15_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR15_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR15_HighSpeed = 0x3
	// Position of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Pos = 0x1c
	// Bit mask of OSPEEDR14 field.
	GPIO_OSPEEDR_OSPEEDR14_Msk = 0x30000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR14_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR14_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR14_HighSpeed = 0x3
	// Position of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Pos = 0x1a
	// Bit mask of OSPEEDR13 field.
	GPIO_OSPEEDR_OSPEEDR13_Msk = 0xc000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR13_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR13_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR13_HighSpeed = 0x3
	// Position of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Pos = 0x18
	// Bit mask of OSPEEDR12 field.
	GPIO_OSPEEDR_OSPEEDR12_Msk = 0x3000000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR12_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR12_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR12_HighSpeed = 0x3
	// Position of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Pos = 0x16
	// Bit mask of OSPEEDR11 field.
	GPIO_OSPEEDR_OSPEEDR11_Msk = 0xc00000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR11_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR11_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR11_HighSpeed = 0x3
	// Position of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Pos = 0x14
	// Bit mask of OSPEEDR10 field.
	GPIO_OSPEEDR_OSPEEDR10_Msk = 0x300000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR10_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR10_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR10_HighSpeed = 0x3
	// Position of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Pos = 0x12
	// Bit mask of OSPEEDR9 field.
	GPIO_OSPEEDR_OSPEEDR9_Msk = 0xc0000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR9_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR9_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR9_HighSpeed = 0x3
	// Position of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Pos = 0x10
	// Bit mask of OSPEEDR8 field.
	GPIO_OSPEEDR_OSPEEDR8_Msk = 0x30000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR8_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR8_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR8_HighSpeed = 0x3
	// Position of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Pos = 0xe
	// Bit mask of OSPEEDR7 field.
	GPIO_OSPEEDR_OSPEEDR7_Msk = 0xc000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR7_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR7_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR7_HighSpeed = 0x3
	// Position of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Pos = 0xc
	// Bit mask of OSPEEDR6 field.
	GPIO_OSPEEDR_OSPEEDR6_Msk = 0x3000
	// Low speed
	GPIO_OSPEEDR_OSPEEDR6_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR6_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR6_HighSpeed = 0x3
	// Position of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Pos = 0xa
	// Bit mask of OSPEEDR5 field.
	GPIO_OSPEEDR_OSPEEDR5_Msk = 0xc00
	// Low speed
	GPIO_OSPEEDR_OSPEEDR5_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR5_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR5_HighSpeed = 0x3
	// Position of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Pos = 0x8
	// Bit mask of OSPEEDR4 field.
	GPIO_OSPEEDR_OSPEEDR4_Msk = 0x300
	// Low speed
	GPIO_OSPEEDR_OSPEEDR4_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR4_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR4_HighSpeed = 0x3
	// Position of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Pos = 0x6
	// Bit mask of OSPEEDR3 field.
	GPIO_OSPEEDR_OSPEEDR3_Msk = 0xc0
	// Low speed
	GPIO_OSPEEDR_OSPEEDR3_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR3_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR3_HighSpeed = 0x3
	// Position of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Pos = 0x4
	// Bit mask of OSPEEDR2 field.
	GPIO_OSPEEDR_OSPEEDR2_Msk = 0x30
	// Low speed
	GPIO_OSPEEDR_OSPEEDR2_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR2_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR2_HighSpeed = 0x3
	// Position of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Pos = 0x2
	// Bit mask of OSPEEDR1 field.
	GPIO_OSPEEDR_OSPEEDR1_Msk = 0xc
	// Low speed
	GPIO_OSPEEDR_OSPEEDR1_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR1_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR1_HighSpeed = 0x3
	// Position of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Pos = 0x0
	// Bit mask of OSPEEDR0 field.
	GPIO_OSPEEDR_OSPEEDR0_Msk = 0x3
	// Low speed
	GPIO_OSPEEDR_OSPEEDR0_LowSpeed = 0x0
	// Medium speed
	GPIO_OSPEEDR_OSPEEDR0_MediumSpeed = 0x1
	// High speed
	GPIO_OSPEEDR_OSPEEDR0_HighSpeed = 0x3

	// PUPDR: GPIO port pull-up/pull-down register
	// Position of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Pos = 0x1e
	// Bit mask of PUPDR15 field.
	GPIO_PUPDR_PUPDR15_Msk = 0xc0000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR15_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR15_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR15_PullDown = 0x2
	// Position of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Pos = 0x1c
	// Bit mask of PUPDR14 field.
	GPIO_PUPDR_PUPDR14_Msk = 0x30000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR14_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR14_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR14_PullDown = 0x2
	// Position of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Pos = 0x1a
	// Bit mask of PUPDR13 field.
	GPIO_PUPDR_PUPDR13_Msk = 0xc000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR13_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR13_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR13_PullDown = 0x2
	// Position of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Pos = 0x18
	// Bit mask of PUPDR12 field.
	GPIO_PUPDR_PUPDR12_Msk = 0x3000000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR12_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR12_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR12_PullDown = 0x2
	// Position of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Pos = 0x16
	// Bit mask of PUPDR11 field.
	GPIO_PUPDR_PUPDR11_Msk = 0xc00000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR11_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR11_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR11_PullDown = 0x2
	// Position of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Pos = 0x14
	// Bit mask of PUPDR10 field.
	GPIO_PUPDR_PUPDR10_Msk = 0x300000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR10_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR10_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR10_PullDown = 0x2
	// Position of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Pos = 0x12
	// Bit mask of PUPDR9 field.
	GPIO_PUPDR_PUPDR9_Msk = 0xc0000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR9_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR9_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR9_PullDown = 0x2
	// Position of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Pos = 0x10
	// Bit mask of PUPDR8 field.
	GPIO_PUPDR_PUPDR8_Msk = 0x30000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR8_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR8_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR8_PullDown = 0x2
	// Position of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Pos = 0xe
	// Bit mask of PUPDR7 field.
	GPIO_PUPDR_PUPDR7_Msk = 0xc000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR7_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR7_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR7_PullDown = 0x2
	// Position of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Pos = 0xc
	// Bit mask of PUPDR6 field.
	GPIO_PUPDR_PUPDR6_Msk = 0x3000
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR6_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR6_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR6_PullDown = 0x2
	// Position of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Pos = 0xa
	// Bit mask of PUPDR5 field.
	GPIO_PUPDR_PUPDR5_Msk = 0xc00
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR5_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR5_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR5_PullDown = 0x2
	// Position of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Pos = 0x8
	// Bit mask of PUPDR4 field.
	GPIO_PUPDR_PUPDR4_Msk = 0x300
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR4_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR4_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR4_PullDown = 0x2
	// Position of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Pos = 0x6
	// Bit mask of PUPDR3 field.
	GPIO_PUPDR_PUPDR3_Msk = 0xc0
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR3_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR3_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR3_PullDown = 0x2
	// Position of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Pos = 0x4
	// Bit mask of PUPDR2 field.
	GPIO_PUPDR_PUPDR2_Msk = 0x30
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR2_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR2_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR2_PullDown = 0x2
	// Position of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Pos = 0x2
	// Bit mask of PUPDR1 field.
	GPIO_PUPDR_PUPDR1_Msk = 0xc
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR1_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR1_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR1_PullDown = 0x2
	// Position of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Pos = 0x0
	// Bit mask of PUPDR0 field.
	GPIO_PUPDR_PUPDR0_Msk = 0x3
	// No pull-up, pull-down
	GPIO_PUPDR_PUPDR0_Floating = 0x0
	// Pull-up
	GPIO_PUPDR_PUPDR0_PullUp = 0x1
	// Pull-down
	GPIO_PUPDR_PUPDR0_PullDown = 0x2

	// IDR: GPIO port input data register
	// Position of IDR15 field.
	GPIO_IDR_IDR15_Pos = 0xf
	// Bit mask of IDR15 field.
	GPIO_IDR_IDR15_Msk = 0x8000
	// Bit IDR15.
	GPIO_IDR_IDR15 = 0x8000
	// Input is logic high
	GPIO_IDR_IDR15_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR15_Low = 0x0
	// Position of IDR14 field.
	GPIO_IDR_IDR14_Pos = 0xe
	// Bit mask of IDR14 field.
	GPIO_IDR_IDR14_Msk = 0x4000
	// Bit IDR14.
	GPIO_IDR_IDR14 = 0x4000
	// Input is logic high
	GPIO_IDR_IDR14_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR14_Low = 0x0
	// Position of IDR13 field.
	GPIO_IDR_IDR13_Pos = 0xd
	// Bit mask of IDR13 field.
	GPIO_IDR_IDR13_Msk = 0x2000
	// Bit IDR13.
	GPIO_IDR_IDR13 = 0x2000
	// Input is logic high
	GPIO_IDR_IDR13_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR13_Low = 0x0
	// Position of IDR12 field.
	GPIO_IDR_IDR12_Pos = 0xc
	// Bit mask of IDR12 field.
	GPIO_IDR_IDR12_Msk = 0x1000
	// Bit IDR12.
	GPIO_IDR_IDR12 = 0x1000
	// Input is logic high
	GPIO_IDR_IDR12_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR12_Low = 0x0
	// Position of IDR11 field.
	GPIO_IDR_IDR11_Pos = 0xb
	// Bit mask of IDR11 field.
	GPIO_IDR_IDR11_Msk = 0x800
	// Bit IDR11.
	GPIO_IDR_IDR11 = 0x800
	// Input is logic high
	GPIO_IDR_IDR11_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR11_Low = 0x0
	// Position of IDR10 field.
	GPIO_IDR_IDR10_Pos = 0xa
	// Bit mask of IDR10 field.
	GPIO_IDR_IDR10_Msk = 0x400
	// Bit IDR10.
	GPIO_IDR_IDR10 = 0x400
	// Input is logic high
	GPIO_IDR_IDR10_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR10_Low = 0x0
	// Position of IDR9 field.
	GPIO_IDR_IDR9_Pos = 0x9
	// Bit mask of IDR9 field.
	GPIO_IDR_IDR9_Msk = 0x200
	// Bit IDR9.
	GPIO_IDR_IDR9 = 0x200
	// Input is logic high
	GPIO_IDR_IDR9_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR9_Low = 0x0
	// Position of IDR8 field.
	GPIO_IDR_IDR8_Pos = 0x8
	// Bit mask of IDR8 field.
	GPIO_IDR_IDR8_Msk = 0x100
	// Bit IDR8.
	GPIO_IDR_IDR8 = 0x100
	// Input is logic high
	GPIO_IDR_IDR8_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR8_Low = 0x0
	// Position of IDR7 field.
	GPIO_IDR_IDR7_Pos = 0x7
	// Bit mask of IDR7 field.
	GPIO_IDR_IDR7_Msk = 0x80
	// Bit IDR7.
	GPIO_IDR_IDR7 = 0x80
	// Input is logic high
	GPIO_IDR_IDR7_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR7_Low = 0x0
	// Position of IDR6 field.
	GPIO_IDR_IDR6_Pos = 0x6
	// Bit mask of IDR6 field.
	GPIO_IDR_IDR6_Msk = 0x40
	// Bit IDR6.
	GPIO_IDR_IDR6 = 0x40
	// Input is logic high
	GPIO_IDR_IDR6_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR6_Low = 0x0
	// Position of IDR5 field.
	GPIO_IDR_IDR5_Pos = 0x5
	// Bit mask of IDR5 field.
	GPIO_IDR_IDR5_Msk = 0x20
	// Bit IDR5.
	GPIO_IDR_IDR5 = 0x20
	// Input is logic high
	GPIO_IDR_IDR5_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR5_Low = 0x0
	// Position of IDR4 field.
	GPIO_IDR_IDR4_Pos = 0x4
	// Bit mask of IDR4 field.
	GPIO_IDR_IDR4_Msk = 0x10
	// Bit IDR4.
	GPIO_IDR_IDR4 = 0x10
	// Input is logic high
	GPIO_IDR_IDR4_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR4_Low = 0x0
	// Position of IDR3 field.
	GPIO_IDR_IDR3_Pos = 0x3
	// Bit mask of IDR3 field.
	GPIO_IDR_IDR3_Msk = 0x8
	// Bit IDR3.
	GPIO_IDR_IDR3 = 0x8
	// Input is logic high
	GPIO_IDR_IDR3_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR3_Low = 0x0
	// Position of IDR2 field.
	GPIO_IDR_IDR2_Pos = 0x2
	// Bit mask of IDR2 field.
	GPIO_IDR_IDR2_Msk = 0x4
	// Bit IDR2.
	GPIO_IDR_IDR2 = 0x4
	// Input is logic high
	GPIO_IDR_IDR2_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR2_Low = 0x0
	// Position of IDR1 field.
	GPIO_IDR_IDR1_Pos = 0x1
	// Bit mask of IDR1 field.
	GPIO_IDR_IDR1_Msk = 0x2
	// Bit IDR1.
	GPIO_IDR_IDR1 = 0x2
	// Input is logic high
	GPIO_IDR_IDR1_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR1_Low = 0x0
	// Position of IDR0 field.
	GPIO_IDR_IDR0_Pos = 0x0
	// Bit mask of IDR0 field.
	GPIO_IDR_IDR0_Msk = 0x1
	// Bit IDR0.
	GPIO_IDR_IDR0 = 0x1
	// Input is logic high
	GPIO_IDR_IDR0_High = 0x1
	// Input is logic low
	GPIO_IDR_IDR0_Low = 0x0

	// ODR: GPIO port output data register
	// Position of ODR15 field.
	GPIO_ODR_ODR15_Pos = 0xf
	// Bit mask of ODR15 field.
	GPIO_ODR_ODR15_Msk = 0x8000
	// Bit ODR15.
	GPIO_ODR_ODR15 = 0x8000
	// Set output to logic high
	GPIO_ODR_ODR15_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR15_Low = 0x0
	// Position of ODR14 field.
	GPIO_ODR_ODR14_Pos = 0xe
	// Bit mask of ODR14 field.
	GPIO_ODR_ODR14_Msk = 0x4000
	// Bit ODR14.
	GPIO_ODR_ODR14 = 0x4000
	// Set output to logic high
	GPIO_ODR_ODR14_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR14_Low = 0x0
	// Position of ODR13 field.
	GPIO_ODR_ODR13_Pos = 0xd
	// Bit mask of ODR13 field.
	GPIO_ODR_ODR13_Msk = 0x2000
	// Bit ODR13.
	GPIO_ODR_ODR13 = 0x2000
	// Set output to logic high
	GPIO_ODR_ODR13_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR13_Low = 0x0
	// Position of ODR12 field.
	GPIO_ODR_ODR12_Pos = 0xc
	// Bit mask of ODR12 field.
	GPIO_ODR_ODR12_Msk = 0x1000
	// Bit ODR12.
	GPIO_ODR_ODR12 = 0x1000
	// Set output to logic high
	GPIO_ODR_ODR12_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR12_Low = 0x0
	// Position of ODR11 field.
	GPIO_ODR_ODR11_Pos = 0xb
	// Bit mask of ODR11 field.
	GPIO_ODR_ODR11_Msk = 0x800
	// Bit ODR11.
	GPIO_ODR_ODR11 = 0x800
	// Set output to logic high
	GPIO_ODR_ODR11_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR11_Low = 0x0
	// Position of ODR10 field.
	GPIO_ODR_ODR10_Pos = 0xa
	// Bit mask of ODR10 field.
	GPIO_ODR_ODR10_Msk = 0x400
	// Bit ODR10.
	GPIO_ODR_ODR10 = 0x400
	// Set output to logic high
	GPIO_ODR_ODR10_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR10_Low = 0x0
	// Position of ODR9 field.
	GPIO_ODR_ODR9_Pos = 0x9
	// Bit mask of ODR9 field.
	GPIO_ODR_ODR9_Msk = 0x200
	// Bit ODR9.
	GPIO_ODR_ODR9 = 0x200
	// Set output to logic high
	GPIO_ODR_ODR9_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR9_Low = 0x0
	// Position of ODR8 field.
	GPIO_ODR_ODR8_Pos = 0x8
	// Bit mask of ODR8 field.
	GPIO_ODR_ODR8_Msk = 0x100
	// Bit ODR8.
	GPIO_ODR_ODR8 = 0x100
	// Set output to logic high
	GPIO_ODR_ODR8_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR8_Low = 0x0
	// Position of ODR7 field.
	GPIO_ODR_ODR7_Pos = 0x7
	// Bit mask of ODR7 field.
	GPIO_ODR_ODR7_Msk = 0x80
	// Bit ODR7.
	GPIO_ODR_ODR7 = 0x80
	// Set output to logic high
	GPIO_ODR_ODR7_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR7_Low = 0x0
	// Position of ODR6 field.
	GPIO_ODR_ODR6_Pos = 0x6
	// Bit mask of ODR6 field.
	GPIO_ODR_ODR6_Msk = 0x40
	// Bit ODR6.
	GPIO_ODR_ODR6 = 0x40
	// Set output to logic high
	GPIO_ODR_ODR6_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR6_Low = 0x0
	// Position of ODR5 field.
	GPIO_ODR_ODR5_Pos = 0x5
	// Bit mask of ODR5 field.
	GPIO_ODR_ODR5_Msk = 0x20
	// Bit ODR5.
	GPIO_ODR_ODR5 = 0x20
	// Set output to logic high
	GPIO_ODR_ODR5_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR5_Low = 0x0
	// Position of ODR4 field.
	GPIO_ODR_ODR4_Pos = 0x4
	// Bit mask of ODR4 field.
	GPIO_ODR_ODR4_Msk = 0x10
	// Bit ODR4.
	GPIO_ODR_ODR4 = 0x10
	// Set output to logic high
	GPIO_ODR_ODR4_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR4_Low = 0x0
	// Position of ODR3 field.
	GPIO_ODR_ODR3_Pos = 0x3
	// Bit mask of ODR3 field.
	GPIO_ODR_ODR3_Msk = 0x8
	// Bit ODR3.
	GPIO_ODR_ODR3 = 0x8
	// Set output to logic high
	GPIO_ODR_ODR3_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR3_Low = 0x0
	// Position of ODR2 field.
	GPIO_ODR_ODR2_Pos = 0x2
	// Bit mask of ODR2 field.
	GPIO_ODR_ODR2_Msk = 0x4
	// Bit ODR2.
	GPIO_ODR_ODR2 = 0x4
	// Set output to logic high
	GPIO_ODR_ODR2_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR2_Low = 0x0
	// Position of ODR1 field.
	GPIO_ODR_ODR1_Pos = 0x1
	// Bit mask of ODR1 field.
	GPIO_ODR_ODR1_Msk = 0x2
	// Bit ODR1.
	GPIO_ODR_ODR1 = 0x2
	// Set output to logic high
	GPIO_ODR_ODR1_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR1_Low = 0x0
	// Position of ODR0 field.
	GPIO_ODR_ODR0_Pos = 0x0
	// Bit mask of ODR0 field.
	GPIO_ODR_ODR0_Msk = 0x1
	// Bit ODR0.
	GPIO_ODR_ODR0 = 0x1
	// Set output to logic high
	GPIO_ODR_ODR0_High = 0x1
	// Set output to logic low
	GPIO_ODR_ODR0_Low = 0x0

	// BSRR: GPIO port bit set/reset register
	// Position of BR15 field.
	GPIO_BSRR_BR15_Pos = 0x1f
	// Bit mask of BR15 field.
	GPIO_BSRR_BR15_Msk = 0x80000000
	// Bit BR15.
	GPIO_BSRR_BR15 = 0x80000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR15_Reset = 0x1
	// Position of BR14 field.
	GPIO_BSRR_BR14_Pos = 0x1e
	// Bit mask of BR14 field.
	GPIO_BSRR_BR14_Msk = 0x40000000
	// Bit BR14.
	GPIO_BSRR_BR14 = 0x40000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR14_Reset = 0x1
	// Position of BR13 field.
	GPIO_BSRR_BR13_Pos = 0x1d
	// Bit mask of BR13 field.
	GPIO_BSRR_BR13_Msk = 0x20000000
	// Bit BR13.
	GPIO_BSRR_BR13 = 0x20000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR13_Reset = 0x1
	// Position of BR12 field.
	GPIO_BSRR_BR12_Pos = 0x1c
	// Bit mask of BR12 field.
	GPIO_BSRR_BR12_Msk = 0x10000000
	// Bit BR12.
	GPIO_BSRR_BR12 = 0x10000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR12_Reset = 0x1
	// Position of BR11 field.
	GPIO_BSRR_BR11_Pos = 0x1b
	// Bit mask of BR11 field.
	GPIO_BSRR_BR11_Msk = 0x8000000
	// Bit BR11.
	GPIO_BSRR_BR11 = 0x8000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR11_Reset = 0x1
	// Position of BR10 field.
	GPIO_BSRR_BR10_Pos = 0x1a
	// Bit mask of BR10 field.
	GPIO_BSRR_BR10_Msk = 0x4000000
	// Bit BR10.
	GPIO_BSRR_BR10 = 0x4000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR10_Reset = 0x1
	// Position of BR9 field.
	GPIO_BSRR_BR9_Pos = 0x19
	// Bit mask of BR9 field.
	GPIO_BSRR_BR9_Msk = 0x2000000
	// Bit BR9.
	GPIO_BSRR_BR9 = 0x2000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR9_Reset = 0x1
	// Position of BR8 field.
	GPIO_BSRR_BR8_Pos = 0x18
	// Bit mask of BR8 field.
	GPIO_BSRR_BR8_Msk = 0x1000000
	// Bit BR8.
	GPIO_BSRR_BR8 = 0x1000000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR8_Reset = 0x1
	// Position of BR7 field.
	GPIO_BSRR_BR7_Pos = 0x17
	// Bit mask of BR7 field.
	GPIO_BSRR_BR7_Msk = 0x800000
	// Bit BR7.
	GPIO_BSRR_BR7 = 0x800000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR7_Reset = 0x1
	// Position of BR6 field.
	GPIO_BSRR_BR6_Pos = 0x16
	// Bit mask of BR6 field.
	GPIO_BSRR_BR6_Msk = 0x400000
	// Bit BR6.
	GPIO_BSRR_BR6 = 0x400000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR6_Reset = 0x1
	// Position of BR5 field.
	GPIO_BSRR_BR5_Pos = 0x15
	// Bit mask of BR5 field.
	GPIO_BSRR_BR5_Msk = 0x200000
	// Bit BR5.
	GPIO_BSRR_BR5 = 0x200000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR5_Reset = 0x1
	// Position of BR4 field.
	GPIO_BSRR_BR4_Pos = 0x14
	// Bit mask of BR4 field.
	GPIO_BSRR_BR4_Msk = 0x100000
	// Bit BR4.
	GPIO_BSRR_BR4 = 0x100000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR4_Reset = 0x1
	// Position of BR3 field.
	GPIO_BSRR_BR3_Pos = 0x13
	// Bit mask of BR3 field.
	GPIO_BSRR_BR3_Msk = 0x80000
	// Bit BR3.
	GPIO_BSRR_BR3 = 0x80000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR3_Reset = 0x1
	// Position of BR2 field.
	GPIO_BSRR_BR2_Pos = 0x12
	// Bit mask of BR2 field.
	GPIO_BSRR_BR2_Msk = 0x40000
	// Bit BR2.
	GPIO_BSRR_BR2 = 0x40000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR2_Reset = 0x1
	// Position of BR1 field.
	GPIO_BSRR_BR1_Pos = 0x11
	// Bit mask of BR1 field.
	GPIO_BSRR_BR1_Msk = 0x20000
	// Bit BR1.
	GPIO_BSRR_BR1 = 0x20000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR1_Reset = 0x1
	// Position of BR0 field.
	GPIO_BSRR_BR0_Pos = 0x10
	// Bit mask of BR0 field.
	GPIO_BSRR_BR0_Msk = 0x10000
	// Bit BR0.
	GPIO_BSRR_BR0 = 0x10000
	// Resets the corresponding ODRx bit
	GPIO_BSRR_BR0_Reset = 0x1
	// Position of BS15 field.
	GPIO_BSRR_BS15_Pos = 0xf
	// Bit mask of BS15 field.
	GPIO_BSRR_BS15_Msk = 0x8000
	// Bit BS15.
	GPIO_BSRR_BS15 = 0x8000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS15_Set = 0x1
	// Position of BS14 field.
	GPIO_BSRR_BS14_Pos = 0xe
	// Bit mask of BS14 field.
	GPIO_BSRR_BS14_Msk = 0x4000
	// Bit BS14.
	GPIO_BSRR_BS14 = 0x4000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS14_Set = 0x1
	// Position of BS13 field.
	GPIO_BSRR_BS13_Pos = 0xd
	// Bit mask of BS13 field.
	GPIO_BSRR_BS13_Msk = 0x2000
	// Bit BS13.
	GPIO_BSRR_BS13 = 0x2000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS13_Set = 0x1
	// Position of BS12 field.
	GPIO_BSRR_BS12_Pos = 0xc
	// Bit mask of BS12 field.
	GPIO_BSRR_BS12_Msk = 0x1000
	// Bit BS12.
	GPIO_BSRR_BS12 = 0x1000
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS12_Set = 0x1
	// Position of BS11 field.
	GPIO_BSRR_BS11_Pos = 0xb
	// Bit mask of BS11 field.
	GPIO_BSRR_BS11_Msk = 0x800
	// Bit BS11.
	GPIO_BSRR_BS11 = 0x800
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS11_Set = 0x1
	// Position of BS10 field.
	GPIO_BSRR_BS10_Pos = 0xa
	// Bit mask of BS10 field.
	GPIO_BSRR_BS10_Msk = 0x400
	// Bit BS10.
	GPIO_BSRR_BS10 = 0x400
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS10_Set = 0x1
	// Position of BS9 field.
	GPIO_BSRR_BS9_Pos = 0x9
	// Bit mask of BS9 field.
	GPIO_BSRR_BS9_Msk = 0x200
	// Bit BS9.
	GPIO_BSRR_BS9 = 0x200
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS9_Set = 0x1
	// Position of BS8 field.
	GPIO_BSRR_BS8_Pos = 0x8
	// Bit mask of BS8 field.
	GPIO_BSRR_BS8_Msk = 0x100
	// Bit BS8.
	GPIO_BSRR_BS8 = 0x100
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS8_Set = 0x1
	// Position of BS7 field.
	GPIO_BSRR_BS7_Pos = 0x7
	// Bit mask of BS7 field.
	GPIO_BSRR_BS7_Msk = 0x80
	// Bit BS7.
	GPIO_BSRR_BS7 = 0x80
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS7_Set = 0x1
	// Position of BS6 field.
	GPIO_BSRR_BS6_Pos = 0x6
	// Bit mask of BS6 field.
	GPIO_BSRR_BS6_Msk = 0x40
	// Bit BS6.
	GPIO_BSRR_BS6 = 0x40
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS6_Set = 0x1
	// Position of BS5 field.
	GPIO_BSRR_BS5_Pos = 0x5
	// Bit mask of BS5 field.
	GPIO_BSRR_BS5_Msk = 0x20
	// Bit BS5.
	GPIO_BSRR_BS5 = 0x20
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS5_Set = 0x1
	// Position of BS4 field.
	GPIO_BSRR_BS4_Pos = 0x4
	// Bit mask of BS4 field.
	GPIO_BSRR_BS4_Msk = 0x10
	// Bit BS4.
	GPIO_BSRR_BS4 = 0x10
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS4_Set = 0x1
	// Position of BS3 field.
	GPIO_BSRR_BS3_Pos = 0x3
	// Bit mask of BS3 field.
	GPIO_BSRR_BS3_Msk = 0x8
	// Bit BS3.
	GPIO_BSRR_BS3 = 0x8
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS3_Set = 0x1
	// Position of BS2 field.
	GPIO_BSRR_BS2_Pos = 0x2
	// Bit mask of BS2 field.
	GPIO_BSRR_BS2_Msk = 0x4
	// Bit BS2.
	GPIO_BSRR_BS2 = 0x4
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS2_Set = 0x1
	// Position of BS1 field.
	GPIO_BSRR_BS1_Pos = 0x1
	// Bit mask of BS1 field.
	GPIO_BSRR_BS1_Msk = 0x2
	// Bit BS1.
	GPIO_BSRR_BS1 = 0x2
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS1_Set = 0x1
	// Position of BS0 field.
	GPIO_BSRR_BS0_Pos = 0x0
	// Bit mask of BS0 field.
	GPIO_BSRR_BS0_Msk = 0x1
	// Bit BS0.
	GPIO_BSRR_BS0 = 0x1
	// Sets the corresponding ODRx bit
	GPIO_BSRR_BS0_Set = 0x1

	// LCKR: GPIO port configuration lock register
	// Position of LCKK field.
	GPIO_LCKR_LCKK_Pos = 0x10
	// Bit mask of LCKK field.
	GPIO_LCKR_LCKK_Msk = 0x10000
	// Bit LCKK.
	GPIO_LCKR_LCKK = 0x10000
	// Port configuration lock key not active
	GPIO_LCKR_LCKK_NotActive = 0x0
	// Port configuration lock key active
	GPIO_LCKR_LCKK_Active = 0x1
	// Position of LCK15 field.
	GPIO_LCKR_LCK15_Pos = 0xf
	// Bit mask of LCK15 field.
	GPIO_LCKR_LCK15_Msk = 0x8000
	// Bit LCK15.
	GPIO_LCKR_LCK15 = 0x8000
	// Port configuration not locked
	GPIO_LCKR_LCK15_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK15_Locked = 0x1
	// Position of LCK14 field.
	GPIO_LCKR_LCK14_Pos = 0xe
	// Bit mask of LCK14 field.
	GPIO_LCKR_LCK14_Msk = 0x4000
	// Bit LCK14.
	GPIO_LCKR_LCK14 = 0x4000
	// Port configuration not locked
	GPIO_LCKR_LCK14_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK14_Locked = 0x1
	// Position of LCK13 field.
	GPIO_LCKR_LCK13_Pos = 0xd
	// Bit mask of LCK13 field.
	GPIO_LCKR_LCK13_Msk = 0x2000
	// Bit LCK13.
	GPIO_LCKR_LCK13 = 0x2000
	// Port configuration not locked
	GPIO_LCKR_LCK13_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK13_Locked = 0x1
	// Position of LCK12 field.
	GPIO_LCKR_LCK12_Pos = 0xc
	// Bit mask of LCK12 field.
	GPIO_LCKR_LCK12_Msk = 0x1000
	// Bit LCK12.
	GPIO_LCKR_LCK12 = 0x1000
	// Port configuration not locked
	GPIO_LCKR_LCK12_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK12_Locked = 0x1
	// Position of LCK11 field.
	GPIO_LCKR_LCK11_Pos = 0xb
	// Bit mask of LCK11 field.
	GPIO_LCKR_LCK11_Msk = 0x800
	// Bit LCK11.
	GPIO_LCKR_LCK11 = 0x800
	// Port configuration not locked
	GPIO_LCKR_LCK11_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK11_Locked = 0x1
	// Position of LCK10 field.
	GPIO_LCKR_LCK10_Pos = 0xa
	// Bit mask of LCK10 field.
	GPIO_LCKR_LCK10_Msk = 0x400
	// Bit LCK10.
	GPIO_LCKR_LCK10 = 0x400
	// Port configuration not locked
	GPIO_LCKR_LCK10_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK10_Locked = 0x1
	// Position of LCK9 field.
	GPIO_LCKR_LCK9_Pos = 0x9
	// Bit mask of LCK9 field.
	GPIO_LCKR_LCK9_Msk = 0x200
	// Bit LCK9.
	GPIO_LCKR_LCK9 = 0x200
	// Port configuration not locked
	GPIO_LCKR_LCK9_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK9_Locked = 0x1
	// Position of LCK8 field.
	GPIO_LCKR_LCK8_Pos = 0x8
	// Bit mask of LCK8 field.
	GPIO_LCKR_LCK8_Msk = 0x100
	// Bit LCK8.
	GPIO_LCKR_LCK8 = 0x100
	// Port configuration not locked
	GPIO_LCKR_LCK8_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK8_Locked = 0x1
	// Position of LCK7 field.
	GPIO_LCKR_LCK7_Pos = 0x7
	// Bit mask of LCK7 field.
	GPIO_LCKR_LCK7_Msk = 0x80
	// Bit LCK7.
	GPIO_LCKR_LCK7 = 0x80
	// Port configuration not locked
	GPIO_LCKR_LCK7_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK7_Locked = 0x1
	// Position of LCK6 field.
	GPIO_LCKR_LCK6_Pos = 0x6
	// Bit mask of LCK6 field.
	GPIO_LCKR_LCK6_Msk = 0x40
	// Bit LCK6.
	GPIO_LCKR_LCK6 = 0x40
	// Port configuration not locked
	GPIO_LCKR_LCK6_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK6_Locked = 0x1
	// Position of LCK5 field.
	GPIO_LCKR_LCK5_Pos = 0x5
	// Bit mask of LCK5 field.
	GPIO_LCKR_LCK5_Msk = 0x20
	// Bit LCK5.
	GPIO_LCKR_LCK5 = 0x20
	// Port configuration not locked
	GPIO_LCKR_LCK5_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK5_Locked = 0x1
	// Position of LCK4 field.
	GPIO_LCKR_LCK4_Pos = 0x4
	// Bit mask of LCK4 field.
	GPIO_LCKR_LCK4_Msk = 0x10
	// Bit LCK4.
	GPIO_LCKR_LCK4 = 0x10
	// Port configuration not locked
	GPIO_LCKR_LCK4_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK4_Locked = 0x1
	// Position of LCK3 field.
	GPIO_LCKR_LCK3_Pos = 0x3
	// Bit mask of LCK3 field.
	GPIO_LCKR_LCK3_Msk = 0x8
	// Bit LCK3.
	GPIO_LCKR_LCK3 = 0x8
	// Port configuration not locked
	GPIO_LCKR_LCK3_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK3_Locked = 0x1
	// Position of LCK2 field.
	GPIO_LCKR_LCK2_Pos = 0x2
	// Bit mask of LCK2 field.
	GPIO_LCKR_LCK2_Msk = 0x4
	// Bit LCK2.
	GPIO_LCKR_LCK2 = 0x4
	// Port configuration not locked
	GPIO_LCKR_LCK2_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK2_Locked = 0x1
	// Position of LCK1 field.
	GPIO_LCKR_LCK1_Pos = 0x1
	// Bit mask of LCK1 field.
	GPIO_LCKR_LCK1_Msk = 0x2
	// Bit LCK1.
	GPIO_LCKR_LCK1 = 0x2
	// Port configuration not locked
	GPIO_LCKR_LCK1_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK1_Locked = 0x1
	// Position of LCK0 field.
	GPIO_LCKR_LCK0_Pos = 0x0
	// Bit mask of LCK0 field.
	GPIO_LCKR_LCK0_Msk = 0x1
	// Bit LCK0.
	GPIO_LCKR_LCK0 = 0x1
	// Port configuration not locked
	GPIO_LCKR_LCK0_Unlocked = 0x0
	// Port configuration locked
	GPIO_LCKR_LCK0_Locked = 0x1

	// AFRL: GPIO alternate function low register
	// Position of AFRL7 field.
	GPIO_AFRL_AFRL7_Pos = 0x1c
	// Bit mask of AFRL7 field.
	GPIO_AFRL_AFRL7_Msk = 0xf0000000
	// AF0
	GPIO_AFRL_AFRL7_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL7_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL7_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL7_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL7_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL7_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL7_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL7_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL7_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL7_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL7_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL7_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL7_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL7_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL7_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL7_AF15 = 0xf
	// Position of AFRL6 field.
	GPIO_AFRL_AFRL6_Pos = 0x18
	// Bit mask of AFRL6 field.
	GPIO_AFRL_AFRL6_Msk = 0xf000000
	// AF0
	GPIO_AFRL_AFRL6_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL6_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL6_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL6_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL6_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL6_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL6_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL6_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL6_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL6_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL6_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL6_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL6_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL6_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL6_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL6_AF15 = 0xf
	// Position of AFRL5 field.
	GPIO_AFRL_AFRL5_Pos = 0x14
	// Bit mask of AFRL5 field.
	GPIO_AFRL_AFRL5_Msk = 0xf00000
	// AF0
	GPIO_AFRL_AFRL5_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL5_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL5_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL5_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL5_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL5_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL5_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL5_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL5_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL5_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL5_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL5_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL5_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL5_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL5_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL5_AF15 = 0xf
	// Position of AFRL4 field.
	GPIO_AFRL_AFRL4_Pos = 0x10
	// Bit mask of AFRL4 field.
	GPIO_AFRL_AFRL4_Msk = 0xf0000
	// AF0
	GPIO_AFRL_AFRL4_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL4_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL4_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL4_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL4_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL4_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL4_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL4_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL4_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL4_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL4_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL4_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL4_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL4_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL4_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL4_AF15 = 0xf
	// Position of AFRL3 field.
	GPIO_AFRL_AFRL3_Pos = 0xc
	// Bit mask of AFRL3 field.
	GPIO_AFRL_AFRL3_Msk = 0xf000
	// AF0
	GPIO_AFRL_AFRL3_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL3_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL3_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL3_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL3_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL3_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL3_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL3_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL3_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL3_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL3_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL3_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL3_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL3_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL3_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL3_AF15 = 0xf
	// Position of AFRL2 field.
	GPIO_AFRL_AFRL2_Pos = 0x8
	// Bit mask of AFRL2 field.
	GPIO_AFRL_AFRL2_Msk = 0xf00
	// AF0
	GPIO_AFRL_AFRL2_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL2_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL2_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL2_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL2_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL2_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL2_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL2_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL2_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL2_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL2_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL2_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL2_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL2_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL2_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL2_AF15 = 0xf
	// Position of AFRL1 field.
	GPIO_AFRL_AFRL1_Pos = 0x4
	// Bit mask of AFRL1 field.
	GPIO_AFRL_AFRL1_Msk = 0xf0
	// AF0
	GPIO_AFRL_AFRL1_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL1_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL1_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL1_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL1_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL1_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL1_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL1_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL1_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL1_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL1_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL1_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL1_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL1_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL1_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL1_AF15 = 0xf
	// Position of AFRL0 field.
	GPIO_AFRL_AFRL0_Pos = 0x0
	// Bit mask of AFRL0 field.
	GPIO_AFRL_AFRL0_Msk = 0xf
	// AF0
	GPIO_AFRL_AFRL0_AF0 = 0x0
	// AF1
	GPIO_AFRL_AFRL0_AF1 = 0x1
	// AF2
	GPIO_AFRL_AFRL0_AF2 = 0x2
	// AF3
	GPIO_AFRL_AFRL0_AF3 = 0x3
	// AF4
	GPIO_AFRL_AFRL0_AF4 = 0x4
	// AF5
	GPIO_AFRL_AFRL0_AF5 = 0x5
	// AF6
	GPIO_AFRL_AFRL0_AF6 = 0x6
	// AF7
	GPIO_AFRL_AFRL0_AF7 = 0x7
	// AF8
	GPIO_AFRL_AFRL0_AF8 = 0x8
	// AF9
	GPIO_AFRL_AFRL0_AF9 = 0x9
	// AF10
	GPIO_AFRL_AFRL0_AF10 = 0xa
	// AF11
	GPIO_AFRL_AFRL0_AF11 = 0xb
	// AF12
	GPIO_AFRL_AFRL0_AF12 = 0xc
	// AF13
	GPIO_AFRL_AFRL0_AF13 = 0xd
	// AF14
	GPIO_AFRL_AFRL0_AF14 = 0xe
	// AF15
	GPIO_AFRL_AFRL0_AF15 = 0xf

	// AFRH: GPIO alternate function high register
	// Position of AFRH15 field.
	GPIO_AFRH_AFRH15_Pos = 0x1c
	// Bit mask of AFRH15 field.
	GPIO_AFRH_AFRH15_Msk = 0xf0000000
	// AF0
	GPIO_AFRH_AFRH15_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH15_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH15_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH15_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH15_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH15_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH15_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH15_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH15_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH15_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH15_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH15_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH15_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH15_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH15_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH15_AF15 = 0xf
	// Position of AFRH14 field.
	GPIO_AFRH_AFRH14_Pos = 0x18
	// Bit mask of AFRH14 field.
	GPIO_AFRH_AFRH14_Msk = 0xf000000
	// AF0
	GPIO_AFRH_AFRH14_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH14_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH14_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH14_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH14_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH14_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH14_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH14_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH14_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH14_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH14_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH14_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH14_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH14_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH14_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH14_AF15 = 0xf
	// Position of AFRH13 field.
	GPIO_AFRH_AFRH13_Pos = 0x14
	// Bit mask of AFRH13 field.
	GPIO_AFRH_AFRH13_Msk = 0xf00000
	// AF0
	GPIO_AFRH_AFRH13_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH13_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH13_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH13_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH13_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH13_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH13_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH13_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH13_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH13_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH13_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH13_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH13_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH13_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH13_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH13_AF15 = 0xf
	// Position of AFRH12 field.
	GPIO_AFRH_AFRH12_Pos = 0x10
	// Bit mask of AFRH12 field.
	GPIO_AFRH_AFRH12_Msk = 0xf0000
	// AF0
	GPIO_AFRH_AFRH12_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH12_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH12_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH12_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH12_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH12_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH12_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH12_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH12_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH12_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH12_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH12_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH12_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH12_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH12_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH12_AF15 = 0xf
	// Position of AFRH11 field.
	GPIO_AFRH_AFRH11_Pos = 0xc
	// Bit mask of AFRH11 field.
	GPIO_AFRH_AFRH11_Msk = 0xf000
	// AF0
	GPIO_AFRH_AFRH11_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH11_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH11_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH11_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH11_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH11_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH11_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH11_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH11_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH11_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH11_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH11_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH11_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH11_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH11_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH11_AF15 = 0xf
	// Position of AFRH10 field.
	GPIO_AFRH_AFRH10_Pos = 0x8
	// Bit mask of AFRH10 field.
	GPIO_AFRH_AFRH10_Msk = 0xf00
	// AF0
	GPIO_AFRH_AFRH10_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH10_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH10_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH10_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH10_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH10_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH10_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH10_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH10_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH10_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH10_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH10_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH10_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH10_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH10_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH10_AF15 = 0xf
	// Position of AFRH9 field.
	GPIO_AFRH_AFRH9_Pos = 0x4
	// Bit mask of AFRH9 field.
	GPIO_AFRH_AFRH9_Msk = 0xf0
	// AF0
	GPIO_AFRH_AFRH9_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH9_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH9_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH9_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH9_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH9_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH9_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH9_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH9_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH9_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH9_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH9_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH9_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH9_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH9_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH9_AF15 = 0xf
	// Position of AFRH8 field.
	GPIO_AFRH_AFRH8_Pos = 0x0
	// Bit mask of AFRH8 field.
	GPIO_AFRH_AFRH8_Msk = 0xf
	// AF0
	GPIO_AFRH_AFRH8_AF0 = 0x0
	// AF1
	GPIO_AFRH_AFRH8_AF1 = 0x1
	// AF2
	GPIO_AFRH_AFRH8_AF2 = 0x2
	// AF3
	GPIO_AFRH_AFRH8_AF3 = 0x3
	// AF4
	GPIO_AFRH_AFRH8_AF4 = 0x4
	// AF5
	GPIO_AFRH_AFRH8_AF5 = 0x5
	// AF6
	GPIO_AFRH_AFRH8_AF6 = 0x6
	// AF7
	GPIO_AFRH_AFRH8_AF7 = 0x7
	// AF8
	GPIO_AFRH_AFRH8_AF8 = 0x8
	// AF9
	GPIO_AFRH_AFRH8_AF9 = 0x9
	// AF10
	GPIO_AFRH_AFRH8_AF10 = 0xa
	// AF11
	GPIO_AFRH_AFRH8_AF11 = 0xb
	// AF12
	GPIO_AFRH_AFRH8_AF12 = 0xc
	// AF13
	GPIO_AFRH_AFRH8_AF13 = 0xd
	// AF14
	GPIO_AFRH_AFRH8_AF14 = 0xe
	// AF15
	GPIO_AFRH_AFRH8_AF15 = 0xf

	// BRR: Port bit reset register
	// Position of BR0 field.
	GPIO_BRR_BR0_Pos = 0x0
	// Bit mask of BR0 field.
	GPIO_BRR_BR0_Msk = 0x1
	// Bit BR0.
	GPIO_BRR_BR0 = 0x1
	// No action on the corresponding ODx bit
	GPIO_BRR_BR0_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR0_Reset = 0x1
	// Position of BR1 field.
	GPIO_BRR_BR1_Pos = 0x1
	// Bit mask of BR1 field.
	GPIO_BRR_BR1_Msk = 0x2
	// Bit BR1.
	GPIO_BRR_BR1 = 0x2
	// No action on the corresponding ODx bit
	GPIO_BRR_BR1_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR1_Reset = 0x1
	// Position of BR2 field.
	GPIO_BRR_BR2_Pos = 0x2
	// Bit mask of BR2 field.
	GPIO_BRR_BR2_Msk = 0x4
	// Bit BR2.
	GPIO_BRR_BR2 = 0x4
	// No action on the corresponding ODx bit
	GPIO_BRR_BR2_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR2_Reset = 0x1
	// Position of BR3 field.
	GPIO_BRR_BR3_Pos = 0x3
	// Bit mask of BR3 field.
	GPIO_BRR_BR3_Msk = 0x8
	// Bit BR3.
	GPIO_BRR_BR3 = 0x8
	// No action on the corresponding ODx bit
	GPIO_BRR_BR3_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR3_Reset = 0x1
	// Position of BR4 field.
	GPIO_BRR_BR4_Pos = 0x4
	// Bit mask of BR4 field.
	GPIO_BRR_BR4_Msk = 0x10
	// Bit BR4.
	GPIO_BRR_BR4 = 0x10
	// No action on the corresponding ODx bit
	GPIO_BRR_BR4_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR4_Reset = 0x1
	// Position of BR5 field.
	GPIO_BRR_BR5_Pos = 0x5
	// Bit mask of BR5 field.
	GPIO_BRR_BR5_Msk = 0x20
	// Bit BR5.
	GPIO_BRR_BR5 = 0x20
	// No action on the corresponding ODx bit
	GPIO_BRR_BR5_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR5_Reset = 0x1
	// Position of BR6 field.
	GPIO_BRR_BR6_Pos = 0x6
	// Bit mask of BR6 field.
	GPIO_BRR_BR6_Msk = 0x40
	// Bit BR6.
	GPIO_BRR_BR6 = 0x40
	// No action on the corresponding ODx bit
	GPIO_BRR_BR6_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR6_Reset = 0x1
	// Position of BR7 field.
	GPIO_BRR_BR7_Pos = 0x7
	// Bit mask of BR7 field.
	GPIO_BRR_BR7_Msk = 0x80
	// Bit BR7.
	GPIO_BRR_BR7 = 0x80
	// No action on the corresponding ODx bit
	GPIO_BRR_BR7_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR7_Reset = 0x1
	// Position of BR8 field.
	GPIO_BRR_BR8_Pos = 0x8
	// Bit mask of BR8 field.
	GPIO_BRR_BR8_Msk = 0x100
	// Bit BR8.
	GPIO_BRR_BR8 = 0x100
	// No action on the corresponding ODx bit
	GPIO_BRR_BR8_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR8_Reset = 0x1
	// Position of BR9 field.
	GPIO_BRR_BR9_Pos = 0x9
	// Bit mask of BR9 field.
	GPIO_BRR_BR9_Msk = 0x200
	// Bit BR9.
	GPIO_BRR_BR9 = 0x200
	// No action on the corresponding ODx bit
	GPIO_BRR_BR9_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR9_Reset = 0x1
	// Position of BR10 field.
	GPIO_BRR_BR10_Pos = 0xa
	// Bit mask of BR10 field.
	GPIO_BRR_BR10_Msk = 0x400
	// Bit BR10.
	GPIO_BRR_BR10 = 0x400
	// No action on the corresponding ODx bit
	GPIO_BRR_BR10_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR10_Reset = 0x1
	// Position of BR11 field.
	GPIO_BRR_BR11_Pos = 0xb
	// Bit mask of BR11 field.
	GPIO_BRR_BR11_Msk = 0x800
	// Bit BR11.
	GPIO_BRR_BR11 = 0x800
	// No action on the corresponding ODx bit
	GPIO_BRR_BR11_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR11_Reset = 0x1
	// Position of BR12 field.
	GPIO_BRR_BR12_Pos = 0xc
	// Bit mask of BR12 field.
	GPIO_BRR_BR12_Msk = 0x1000
	// Bit BR12.
	GPIO_BRR_BR12 = 0x1000
	// No action on the corresponding ODx bit
	GPIO_BRR_BR12_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR12_Reset = 0x1
	// Position of BR13 field.
	GPIO_BRR_BR13_Pos = 0xd
	// Bit mask of BR13 field.
	GPIO_BRR_BR13_Msk = 0x2000
	// Bit BR13.
	GPIO_BRR_BR13 = 0x2000
	// No action on the corresponding ODx bit
	GPIO_BRR_BR13_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR13_Reset = 0x1
	// Position of BR14 field.
	GPIO_BRR_BR14_Pos = 0xe
	// Bit mask of BR14 field.
	GPIO_BRR_BR14_Msk = 0x4000
	// Bit BR14.
	GPIO_BRR_BR14 = 0x4000
	// No action on the corresponding ODx bit
	GPIO_BRR_BR14_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR14_Reset = 0x1
	// Position of BR15 field.
	GPIO_BRR_BR15_Pos = 0xf
	// Bit mask of BR15 field.
	GPIO_BRR_BR15_Msk = 0x8000
	// Bit BR15.
	GPIO_BRR_BR15 = 0x8000
	// No action on the corresponding ODx bit
	GPIO_BRR_BR15_NoAction = 0x0
	// Reset the ODx bit
	GPIO_BRR_BR15_Reset = 0x1
)

// Constants for TSC: Touch sensing controller
const (
	// CR: control register
	// Position of CTPH field.
	TSC_CR_CTPH_Pos = 0x1c
	// Bit mask of CTPH field.
	TSC_CR_CTPH_Msk = 0xf0000000
	// Position of CTPL field.
	TSC_CR_CTPL_Pos = 0x18
	// Bit mask of CTPL field.
	TSC_CR_CTPL_Msk = 0xf000000
	// Position of SSD field.
	TSC_CR_SSD_Pos = 0x11
	// Bit mask of SSD field.
	TSC_CR_SSD_Msk = 0xfe0000
	// Position of SSE field.
	TSC_CR_SSE_Pos = 0x10
	// Bit mask of SSE field.
	TSC_CR_SSE_Msk = 0x10000
	// Bit SSE.
	TSC_CR_SSE = 0x10000
	// Position of SSPSC field.
	TSC_CR_SSPSC_Pos = 0xf
	// Bit mask of SSPSC field.
	TSC_CR_SSPSC_Msk = 0x8000
	// Bit SSPSC.
	TSC_CR_SSPSC = 0x8000
	// Position of PGPSC field.
	TSC_CR_PGPSC_Pos = 0xc
	// Bit mask of PGPSC field.
	TSC_CR_PGPSC_Msk = 0x7000
	// Position of MCV field.
	TSC_CR_MCV_Pos = 0x5
	// Bit mask of MCV field.
	TSC_CR_MCV_Msk = 0xe0
	// Position of IODEF field.
	TSC_CR_IODEF_Pos = 0x4
	// Bit mask of IODEF field.
	TSC_CR_IODEF_Msk = 0x10
	// Bit IODEF.
	TSC_CR_IODEF = 0x10
	// Position of SYNCPOL field.
	TSC_CR_SYNCPOL_Pos = 0x3
	// Bit mask of SYNCPOL field.
	TSC_CR_SYNCPOL_Msk = 0x8
	// Bit SYNCPOL.
	TSC_CR_SYNCPOL = 0x8
	// Position of AM field.
	TSC_CR_AM_Pos = 0x2
	// Bit mask of AM field.
	TSC_CR_AM_Msk = 0x4
	// Bit AM.
	TSC_CR_AM = 0x4
	// Position of START field.
	TSC_CR_START_Pos = 0x1
	// Bit mask of START field.
	TSC_CR_START_Msk = 0x2
	// Bit START.
	TSC_CR_START = 0x2
	// Position of TSCE field.
	TSC_CR_TSCE_Pos = 0x0
	// Bit mask of TSCE field.
	TSC_CR_TSCE_Msk = 0x1
	// Bit TSCE.
	TSC_CR_TSCE = 0x1

	// IER: interrupt enable register
	// Position of MCEIE field.
	TSC_IER_MCEIE_Pos = 0x1
	// Bit mask of MCEIE field.
	TSC_IER_MCEIE_Msk = 0x2
	// Bit MCEIE.
	TSC_IER_MCEIE = 0x2
	// Position of EOAIE field.
	TSC_IER_EOAIE_Pos = 0x0
	// Bit mask of EOAIE field.
	TSC_IER_EOAIE_Msk = 0x1
	// Bit EOAIE.
	TSC_IER_EOAIE = 0x1

	// ICR: interrupt clear register
	// Position of MCEIC field.
	TSC_ICR_MCEIC_Pos = 0x1
	// Bit mask of MCEIC field.
	TSC_ICR_MCEIC_Msk = 0x2
	// Bit MCEIC.
	TSC_ICR_MCEIC = 0x2
	// Position of EOAIC field.
	TSC_ICR_EOAIC_Pos = 0x0
	// Bit mask of EOAIC field.
	TSC_ICR_EOAIC_Msk = 0x1
	// Bit EOAIC.
	TSC_ICR_EOAIC = 0x1

	// ISR: interrupt status register
	// Position of MCEF field.
	TSC_ISR_MCEF_Pos = 0x1
	// Bit mask of MCEF field.
	TSC_ISR_MCEF_Msk = 0x2
	// Bit MCEF.
	TSC_ISR_MCEF = 0x2
	// Position of EOAF field.
	TSC_ISR_EOAF_Pos = 0x0
	// Bit mask of EOAF field.
	TSC_ISR_EOAF_Msk = 0x1
	// Bit EOAF.
	TSC_ISR_EOAF = 0x1

	// IOHCR: I/O hysteresis control register
	// Position of G1_IO1 field.
	TSC_IOHCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOHCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOHCR_G1_IO1 = 0x1
	// Position of G1_IO2 field.
	TSC_IOHCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOHCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOHCR_G1_IO2 = 0x2
	// Position of G1_IO3 field.
	TSC_IOHCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOHCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOHCR_G1_IO3 = 0x4
	// Position of G1_IO4 field.
	TSC_IOHCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOHCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOHCR_G1_IO4 = 0x8
	// Position of G2_IO1 field.
	TSC_IOHCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOHCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOHCR_G2_IO1 = 0x10
	// Position of G2_IO2 field.
	TSC_IOHCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOHCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOHCR_G2_IO2 = 0x20
	// Position of G2_IO3 field.
	TSC_IOHCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOHCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOHCR_G2_IO3 = 0x40
	// Position of G2_IO4 field.
	TSC_IOHCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOHCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOHCR_G2_IO4 = 0x80
	// Position of G3_IO1 field.
	TSC_IOHCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOHCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOHCR_G3_IO1 = 0x100
	// Position of G3_IO2 field.
	TSC_IOHCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOHCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOHCR_G3_IO2 = 0x200
	// Position of G3_IO3 field.
	TSC_IOHCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOHCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOHCR_G3_IO3 = 0x400
	// Position of G3_IO4 field.
	TSC_IOHCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOHCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOHCR_G3_IO4 = 0x800
	// Position of G4_IO1 field.
	TSC_IOHCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOHCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOHCR_G4_IO1 = 0x1000
	// Position of G4_IO2 field.
	TSC_IOHCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOHCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOHCR_G4_IO2 = 0x2000
	// Position of G4_IO3 field.
	TSC_IOHCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOHCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOHCR_G4_IO3 = 0x4000
	// Position of G4_IO4 field.
	TSC_IOHCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOHCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOHCR_G4_IO4 = 0x8000
	// Position of G5_IO1 field.
	TSC_IOHCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOHCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOHCR_G5_IO1 = 0x10000
	// Position of G5_IO2 field.
	TSC_IOHCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOHCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOHCR_G5_IO2 = 0x20000
	// Position of G5_IO3 field.
	TSC_IOHCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOHCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOHCR_G5_IO3 = 0x40000
	// Position of G5_IO4 field.
	TSC_IOHCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOHCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOHCR_G5_IO4 = 0x80000
	// Position of G6_IO1 field.
	TSC_IOHCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOHCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOHCR_G6_IO1 = 0x100000
	// Position of G6_IO2 field.
	TSC_IOHCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOHCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOHCR_G6_IO2 = 0x200000
	// Position of G6_IO3 field.
	TSC_IOHCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOHCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOHCR_G6_IO3 = 0x400000
	// Position of G6_IO4 field.
	TSC_IOHCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOHCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOHCR_G6_IO4 = 0x800000
	// Position of G7_IO1 field.
	TSC_IOHCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOHCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOHCR_G7_IO1 = 0x1000000
	// Position of G7_IO2 field.
	TSC_IOHCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOHCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOHCR_G7_IO2 = 0x2000000
	// Position of G7_IO3 field.
	TSC_IOHCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOHCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOHCR_G7_IO3 = 0x4000000
	// Position of G7_IO4 field.
	TSC_IOHCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOHCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOHCR_G7_IO4 = 0x8000000
	// Position of G8_IO1 field.
	TSC_IOHCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOHCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOHCR_G8_IO1 = 0x10000000
	// Position of G8_IO2 field.
	TSC_IOHCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOHCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOHCR_G8_IO2 = 0x20000000
	// Position of G8_IO3 field.
	TSC_IOHCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOHCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOHCR_G8_IO3 = 0x40000000
	// Position of G8_IO4 field.
	TSC_IOHCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOHCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOHCR_G8_IO4 = 0x80000000

	// IOASCR: I/O analog switch control register
	// Position of G1_IO1 field.
	TSC_IOASCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOASCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOASCR_G1_IO1 = 0x1
	// Position of G1_IO2 field.
	TSC_IOASCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOASCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOASCR_G1_IO2 = 0x2
	// Position of G1_IO3 field.
	TSC_IOASCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOASCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOASCR_G1_IO3 = 0x4
	// Position of G1_IO4 field.
	TSC_IOASCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOASCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOASCR_G1_IO4 = 0x8
	// Position of G2_IO1 field.
	TSC_IOASCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOASCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOASCR_G2_IO1 = 0x10
	// Position of G2_IO2 field.
	TSC_IOASCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOASCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOASCR_G2_IO2 = 0x20
	// Position of G2_IO3 field.
	TSC_IOASCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOASCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOASCR_G2_IO3 = 0x40
	// Position of G2_IO4 field.
	TSC_IOASCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOASCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOASCR_G2_IO4 = 0x80
	// Position of G3_IO1 field.
	TSC_IOASCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOASCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOASCR_G3_IO1 = 0x100
	// Position of G3_IO2 field.
	TSC_IOASCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOASCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOASCR_G3_IO2 = 0x200
	// Position of G3_IO3 field.
	TSC_IOASCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOASCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOASCR_G3_IO3 = 0x400
	// Position of G3_IO4 field.
	TSC_IOASCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOASCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOASCR_G3_IO4 = 0x800
	// Position of G4_IO1 field.
	TSC_IOASCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOASCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOASCR_G4_IO1 = 0x1000
	// Position of G4_IO2 field.
	TSC_IOASCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOASCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOASCR_G4_IO2 = 0x2000
	// Position of G4_IO3 field.
	TSC_IOASCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOASCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOASCR_G4_IO3 = 0x4000
	// Position of G4_IO4 field.
	TSC_IOASCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOASCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOASCR_G4_IO4 = 0x8000
	// Position of G5_IO1 field.
	TSC_IOASCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOASCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOASCR_G5_IO1 = 0x10000
	// Position of G5_IO2 field.
	TSC_IOASCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOASCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOASCR_G5_IO2 = 0x20000
	// Position of G5_IO3 field.
	TSC_IOASCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOASCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOASCR_G5_IO3 = 0x40000
	// Position of G5_IO4 field.
	TSC_IOASCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOASCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOASCR_G5_IO4 = 0x80000
	// Position of G6_IO1 field.
	TSC_IOASCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOASCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOASCR_G6_IO1 = 0x100000
	// Position of G6_IO2 field.
	TSC_IOASCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOASCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOASCR_G6_IO2 = 0x200000
	// Position of G6_IO3 field.
	TSC_IOASCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOASCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOASCR_G6_IO3 = 0x400000
	// Position of G6_IO4 field.
	TSC_IOASCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOASCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOASCR_G6_IO4 = 0x800000
	// Position of G7_IO1 field.
	TSC_IOASCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOASCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOASCR_G7_IO1 = 0x1000000
	// Position of G7_IO2 field.
	TSC_IOASCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOASCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOASCR_G7_IO2 = 0x2000000
	// Position of G7_IO3 field.
	TSC_IOASCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOASCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOASCR_G7_IO3 = 0x4000000
	// Position of G7_IO4 field.
	TSC_IOASCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOASCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOASCR_G7_IO4 = 0x8000000
	// Position of G8_IO1 field.
	TSC_IOASCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOASCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOASCR_G8_IO1 = 0x10000000
	// Position of G8_IO2 field.
	TSC_IOASCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOASCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOASCR_G8_IO2 = 0x20000000
	// Position of G8_IO3 field.
	TSC_IOASCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOASCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOASCR_G8_IO3 = 0x40000000
	// Position of G8_IO4 field.
	TSC_IOASCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOASCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOASCR_G8_IO4 = 0x80000000

	// IOSCR: I/O sampling control register
	// Position of G1_IO1 field.
	TSC_IOSCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOSCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOSCR_G1_IO1 = 0x1
	// Position of G1_IO2 field.
	TSC_IOSCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOSCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOSCR_G1_IO2 = 0x2
	// Position of G1_IO3 field.
	TSC_IOSCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOSCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOSCR_G1_IO3 = 0x4
	// Position of G1_IO4 field.
	TSC_IOSCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOSCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOSCR_G1_IO4 = 0x8
	// Position of G2_IO1 field.
	TSC_IOSCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOSCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOSCR_G2_IO1 = 0x10
	// Position of G2_IO2 field.
	TSC_IOSCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOSCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOSCR_G2_IO2 = 0x20
	// Position of G2_IO3 field.
	TSC_IOSCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOSCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOSCR_G2_IO3 = 0x40
	// Position of G2_IO4 field.
	TSC_IOSCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOSCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOSCR_G2_IO4 = 0x80
	// Position of G3_IO1 field.
	TSC_IOSCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOSCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOSCR_G3_IO1 = 0x100
	// Position of G3_IO2 field.
	TSC_IOSCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOSCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOSCR_G3_IO2 = 0x200
	// Position of G3_IO3 field.
	TSC_IOSCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOSCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOSCR_G3_IO3 = 0x400
	// Position of G3_IO4 field.
	TSC_IOSCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOSCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOSCR_G3_IO4 = 0x800
	// Position of G4_IO1 field.
	TSC_IOSCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOSCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOSCR_G4_IO1 = 0x1000
	// Position of G4_IO2 field.
	TSC_IOSCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOSCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOSCR_G4_IO2 = 0x2000
	// Position of G4_IO3 field.
	TSC_IOSCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOSCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOSCR_G4_IO3 = 0x4000
	// Position of G4_IO4 field.
	TSC_IOSCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOSCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOSCR_G4_IO4 = 0x8000
	// Position of G5_IO1 field.
	TSC_IOSCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOSCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOSCR_G5_IO1 = 0x10000
	// Position of G5_IO2 field.
	TSC_IOSCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOSCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOSCR_G5_IO2 = 0x20000
	// Position of G5_IO3 field.
	TSC_IOSCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOSCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOSCR_G5_IO3 = 0x40000
	// Position of G5_IO4 field.
	TSC_IOSCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOSCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOSCR_G5_IO4 = 0x80000
	// Position of G6_IO1 field.
	TSC_IOSCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOSCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOSCR_G6_IO1 = 0x100000
	// Position of G6_IO2 field.
	TSC_IOSCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOSCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOSCR_G6_IO2 = 0x200000
	// Position of G6_IO3 field.
	TSC_IOSCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOSCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOSCR_G6_IO3 = 0x400000
	// Position of G6_IO4 field.
	TSC_IOSCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOSCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOSCR_G6_IO4 = 0x800000
	// Position of G7_IO1 field.
	TSC_IOSCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOSCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOSCR_G7_IO1 = 0x1000000
	// Position of G7_IO2 field.
	TSC_IOSCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOSCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOSCR_G7_IO2 = 0x2000000
	// Position of G7_IO3 field.
	TSC_IOSCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOSCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOSCR_G7_IO3 = 0x4000000
	// Position of G7_IO4 field.
	TSC_IOSCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOSCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOSCR_G7_IO4 = 0x8000000
	// Position of G8_IO1 field.
	TSC_IOSCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOSCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOSCR_G8_IO1 = 0x10000000
	// Position of G8_IO2 field.
	TSC_IOSCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOSCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOSCR_G8_IO2 = 0x20000000
	// Position of G8_IO3 field.
	TSC_IOSCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOSCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOSCR_G8_IO3 = 0x40000000
	// Position of G8_IO4 field.
	TSC_IOSCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOSCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOSCR_G8_IO4 = 0x80000000

	// IOCCR: I/O channel control register
	// Position of G1_IO1 field.
	TSC_IOCCR_G1_IO1_Pos = 0x0
	// Bit mask of G1_IO1 field.
	TSC_IOCCR_G1_IO1_Msk = 0x1
	// Bit G1_IO1.
	TSC_IOCCR_G1_IO1 = 0x1
	// Position of G1_IO2 field.
	TSC_IOCCR_G1_IO2_Pos = 0x1
	// Bit mask of G1_IO2 field.
	TSC_IOCCR_G1_IO2_Msk = 0x2
	// Bit G1_IO2.
	TSC_IOCCR_G1_IO2 = 0x2
	// Position of G1_IO3 field.
	TSC_IOCCR_G1_IO3_Pos = 0x2
	// Bit mask of G1_IO3 field.
	TSC_IOCCR_G1_IO3_Msk = 0x4
	// Bit G1_IO3.
	TSC_IOCCR_G1_IO3 = 0x4
	// Position of G1_IO4 field.
	TSC_IOCCR_G1_IO4_Pos = 0x3
	// Bit mask of G1_IO4 field.
	TSC_IOCCR_G1_IO4_Msk = 0x8
	// Bit G1_IO4.
	TSC_IOCCR_G1_IO4 = 0x8
	// Position of G2_IO1 field.
	TSC_IOCCR_G2_IO1_Pos = 0x4
	// Bit mask of G2_IO1 field.
	TSC_IOCCR_G2_IO1_Msk = 0x10
	// Bit G2_IO1.
	TSC_IOCCR_G2_IO1 = 0x10
	// Position of G2_IO2 field.
	TSC_IOCCR_G2_IO2_Pos = 0x5
	// Bit mask of G2_IO2 field.
	TSC_IOCCR_G2_IO2_Msk = 0x20
	// Bit G2_IO2.
	TSC_IOCCR_G2_IO2 = 0x20
	// Position of G2_IO3 field.
	TSC_IOCCR_G2_IO3_Pos = 0x6
	// Bit mask of G2_IO3 field.
	TSC_IOCCR_G2_IO3_Msk = 0x40
	// Bit G2_IO3.
	TSC_IOCCR_G2_IO3 = 0x40
	// Position of G2_IO4 field.
	TSC_IOCCR_G2_IO4_Pos = 0x7
	// Bit mask of G2_IO4 field.
	TSC_IOCCR_G2_IO4_Msk = 0x80
	// Bit G2_IO4.
	TSC_IOCCR_G2_IO4 = 0x80
	// Position of G3_IO1 field.
	TSC_IOCCR_G3_IO1_Pos = 0x8
	// Bit mask of G3_IO1 field.
	TSC_IOCCR_G3_IO1_Msk = 0x100
	// Bit G3_IO1.
	TSC_IOCCR_G3_IO1 = 0x100
	// Position of G3_IO2 field.
	TSC_IOCCR_G3_IO2_Pos = 0x9
	// Bit mask of G3_IO2 field.
	TSC_IOCCR_G3_IO2_Msk = 0x200
	// Bit G3_IO2.
	TSC_IOCCR_G3_IO2 = 0x200
	// Position of G3_IO3 field.
	TSC_IOCCR_G3_IO3_Pos = 0xa
	// Bit mask of G3_IO3 field.
	TSC_IOCCR_G3_IO3_Msk = 0x400
	// Bit G3_IO3.
	TSC_IOCCR_G3_IO3 = 0x400
	// Position of G3_IO4 field.
	TSC_IOCCR_G3_IO4_Pos = 0xb
	// Bit mask of G3_IO4 field.
	TSC_IOCCR_G3_IO4_Msk = 0x800
	// Bit G3_IO4.
	TSC_IOCCR_G3_IO4 = 0x800
	// Position of G4_IO1 field.
	TSC_IOCCR_G4_IO1_Pos = 0xc
	// Bit mask of G4_IO1 field.
	TSC_IOCCR_G4_IO1_Msk = 0x1000
	// Bit G4_IO1.
	TSC_IOCCR_G4_IO1 = 0x1000
	// Position of G4_IO2 field.
	TSC_IOCCR_G4_IO2_Pos = 0xd
	// Bit mask of G4_IO2 field.
	TSC_IOCCR_G4_IO2_Msk = 0x2000
	// Bit G4_IO2.
	TSC_IOCCR_G4_IO2 = 0x2000
	// Position of G4_IO3 field.
	TSC_IOCCR_G4_IO3_Pos = 0xe
	// Bit mask of G4_IO3 field.
	TSC_IOCCR_G4_IO3_Msk = 0x4000
	// Bit G4_IO3.
	TSC_IOCCR_G4_IO3 = 0x4000
	// Position of G4_IO4 field.
	TSC_IOCCR_G4_IO4_Pos = 0xf
	// Bit mask of G4_IO4 field.
	TSC_IOCCR_G4_IO4_Msk = 0x8000
	// Bit G4_IO4.
	TSC_IOCCR_G4_IO4 = 0x8000
	// Position of G5_IO1 field.
	TSC_IOCCR_G5_IO1_Pos = 0x10
	// Bit mask of G5_IO1 field.
	TSC_IOCCR_G5_IO1_Msk = 0x10000
	// Bit G5_IO1.
	TSC_IOCCR_G5_IO1 = 0x10000
	// Position of G5_IO2 field.
	TSC_IOCCR_G5_IO2_Pos = 0x11
	// Bit mask of G5_IO2 field.
	TSC_IOCCR_G5_IO2_Msk = 0x20000
	// Bit G5_IO2.
	TSC_IOCCR_G5_IO2 = 0x20000
	// Position of G5_IO3 field.
	TSC_IOCCR_G5_IO3_Pos = 0x12
	// Bit mask of G5_IO3 field.
	TSC_IOCCR_G5_IO3_Msk = 0x40000
	// Bit G5_IO3.
	TSC_IOCCR_G5_IO3 = 0x40000
	// Position of G5_IO4 field.
	TSC_IOCCR_G5_IO4_Pos = 0x13
	// Bit mask of G5_IO4 field.
	TSC_IOCCR_G5_IO4_Msk = 0x80000
	// Bit G5_IO4.
	TSC_IOCCR_G5_IO4 = 0x80000
	// Position of G6_IO1 field.
	TSC_IOCCR_G6_IO1_Pos = 0x14
	// Bit mask of G6_IO1 field.
	TSC_IOCCR_G6_IO1_Msk = 0x100000
	// Bit G6_IO1.
	TSC_IOCCR_G6_IO1 = 0x100000
	// Position of G6_IO2 field.
	TSC_IOCCR_G6_IO2_Pos = 0x15
	// Bit mask of G6_IO2 field.
	TSC_IOCCR_G6_IO2_Msk = 0x200000
	// Bit G6_IO2.
	TSC_IOCCR_G6_IO2 = 0x200000
	// Position of G6_IO3 field.
	TSC_IOCCR_G6_IO3_Pos = 0x16
	// Bit mask of G6_IO3 field.
	TSC_IOCCR_G6_IO3_Msk = 0x400000
	// Bit G6_IO3.
	TSC_IOCCR_G6_IO3 = 0x400000
	// Position of G6_IO4 field.
	TSC_IOCCR_G6_IO4_Pos = 0x17
	// Bit mask of G6_IO4 field.
	TSC_IOCCR_G6_IO4_Msk = 0x800000
	// Bit G6_IO4.
	TSC_IOCCR_G6_IO4 = 0x800000
	// Position of G7_IO1 field.
	TSC_IOCCR_G7_IO1_Pos = 0x18
	// Bit mask of G7_IO1 field.
	TSC_IOCCR_G7_IO1_Msk = 0x1000000
	// Bit G7_IO1.
	TSC_IOCCR_G7_IO1 = 0x1000000
	// Position of G7_IO2 field.
	TSC_IOCCR_G7_IO2_Pos = 0x19
	// Bit mask of G7_IO2 field.
	TSC_IOCCR_G7_IO2_Msk = 0x2000000
	// Bit G7_IO2.
	TSC_IOCCR_G7_IO2 = 0x2000000
	// Position of G7_IO3 field.
	TSC_IOCCR_G7_IO3_Pos = 0x1a
	// Bit mask of G7_IO3 field.
	TSC_IOCCR_G7_IO3_Msk = 0x4000000
	// Bit G7_IO3.
	TSC_IOCCR_G7_IO3 = 0x4000000
	// Position of G7_IO4 field.
	TSC_IOCCR_G7_IO4_Pos = 0x1b
	// Bit mask of G7_IO4 field.
	TSC_IOCCR_G7_IO4_Msk = 0x8000000
	// Bit G7_IO4.
	TSC_IOCCR_G7_IO4 = 0x8000000
	// Position of G8_IO1 field.
	TSC_IOCCR_G8_IO1_Pos = 0x1c
	// Bit mask of G8_IO1 field.
	TSC_IOCCR_G8_IO1_Msk = 0x10000000
	// Bit G8_IO1.
	TSC_IOCCR_G8_IO1 = 0x10000000
	// Position of G8_IO2 field.
	TSC_IOCCR_G8_IO2_Pos = 0x1d
	// Bit mask of G8_IO2 field.
	TSC_IOCCR_G8_IO2_Msk = 0x20000000
	// Bit G8_IO2.
	TSC_IOCCR_G8_IO2 = 0x20000000
	// Position of G8_IO3 field.
	TSC_IOCCR_G8_IO3_Pos = 0x1e
	// Bit mask of G8_IO3 field.
	TSC_IOCCR_G8_IO3_Msk = 0x40000000
	// Bit G8_IO3.
	TSC_IOCCR_G8_IO3 = 0x40000000
	// Position of G8_IO4 field.
	TSC_IOCCR_G8_IO4_Pos = 0x1f
	// Bit mask of G8_IO4 field.
	TSC_IOCCR_G8_IO4_Msk = 0x80000000
	// Bit G8_IO4.
	TSC_IOCCR_G8_IO4 = 0x80000000

	// IOGCSR: I/O group control status register
	// Position of G8S field.
	TSC_IOGCSR_G8S_Pos = 0x17
	// Bit mask of G8S field.
	TSC_IOGCSR_G8S_Msk = 0x800000
	// Bit G8S.
	TSC_IOGCSR_G8S = 0x800000
	// Position of G7S field.
	TSC_IOGCSR_G7S_Pos = 0x16
	// Bit mask of G7S field.
	TSC_IOGCSR_G7S_Msk = 0x400000
	// Bit G7S.
	TSC_IOGCSR_G7S = 0x400000
	// Position of G6S field.
	TSC_IOGCSR_G6S_Pos = 0x15
	// Bit mask of G6S field.
	TSC_IOGCSR_G6S_Msk = 0x200000
	// Bit G6S.
	TSC_IOGCSR_G6S = 0x200000
	// Position of G5S field.
	TSC_IOGCSR_G5S_Pos = 0x14
	// Bit mask of G5S field.
	TSC_IOGCSR_G5S_Msk = 0x100000
	// Bit G5S.
	TSC_IOGCSR_G5S = 0x100000
	// Position of G4S field.
	TSC_IOGCSR_G4S_Pos = 0x13
	// Bit mask of G4S field.
	TSC_IOGCSR_G4S_Msk = 0x80000
	// Bit G4S.
	TSC_IOGCSR_G4S = 0x80000
	// Position of G3S field.
	TSC_IOGCSR_G3S_Pos = 0x12
	// Bit mask of G3S field.
	TSC_IOGCSR_G3S_Msk = 0x40000
	// Bit G3S.
	TSC_IOGCSR_G3S = 0x40000
	// Position of G2S field.
	TSC_IOGCSR_G2S_Pos = 0x11
	// Bit mask of G2S field.
	TSC_IOGCSR_G2S_Msk = 0x20000
	// Bit G2S.
	TSC_IOGCSR_G2S = 0x20000
	// Position of G1S field.
	TSC_IOGCSR_G1S_Pos = 0x10
	// Bit mask of G1S field.
	TSC_IOGCSR_G1S_Msk = 0x10000
	// Bit G1S.
	TSC_IOGCSR_G1S = 0x10000
	// Position of G8E field.
	TSC_IOGCSR_G8E_Pos = 0x7
	// Bit mask of G8E field.
	TSC_IOGCSR_G8E_Msk = 0x80
	// Bit G8E.
	TSC_IOGCSR_G8E = 0x80
	// Position of G7E field.
	TSC_IOGCSR_G7E_Pos = 0x6
	// Bit mask of G7E field.
	TSC_IOGCSR_G7E_Msk = 0x40
	// Bit G7E.
	TSC_IOGCSR_G7E = 0x40
	// Position of G6E field.
	TSC_IOGCSR_G6E_Pos = 0x5
	// Bit mask of G6E field.
	TSC_IOGCSR_G6E_Msk = 0x20
	// Bit G6E.
	TSC_IOGCSR_G6E = 0x20
	// Position of G5E field.
	TSC_IOGCSR_G5E_Pos = 0x4
	// Bit mask of G5E field.
	TSC_IOGCSR_G5E_Msk = 0x10
	// Bit G5E.
	TSC_IOGCSR_G5E = 0x10
	// Position of G4E field.
	TSC_IOGCSR_G4E_Pos = 0x3
	// Bit mask of G4E field.
	TSC_IOGCSR_G4E_Msk = 0x8
	// Bit G4E.
	TSC_IOGCSR_G4E = 0x8
	// Position of G3E field.
	TSC_IOGCSR_G3E_Pos = 0x2
	// Bit mask of G3E field.
	TSC_IOGCSR_G3E_Msk = 0x4
	// Bit G3E.
	TSC_IOGCSR_G3E = 0x4
	// Position of G2E field.
	TSC_IOGCSR_G2E_Pos = 0x1
	// Bit mask of G2E field.
	TSC_IOGCSR_G2E_Msk = 0x2
	// Bit G2E.
	TSC_IOGCSR_G2E = 0x2
	// Position of G1E field.
	TSC_IOGCSR_G1E_Pos = 0x0
	// Bit mask of G1E field.
	TSC_IOGCSR_G1E_Msk = 0x1
	// Bit G1E.
	TSC_IOGCSR_G1E = 0x1

	// IOG1CR: I/O group x counter register
	// Position of CNT field.
	TSC_IOGCR_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TSC_IOGCR_CNT_Msk = 0x3fff
)

// Constants for CRC: cyclic redundancy check calculation unit
const (
	// DR: Data register
	// Position of DR field.
	CRC_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	CRC_DR_DR_Msk = 0xffffffff

	// DR8: Data register - byte sized
	// Position of DR8 field.
	CRC_DR8_DR8_Pos = 0x0
	// Bit mask of DR8 field.
	CRC_DR8_DR8_Msk = 0xff

	// DR16: Data register - half-word sized
	// Position of DR16 field.
	CRC_DR16_DR16_Pos = 0x0
	// Bit mask of DR16 field.
	CRC_DR16_DR16_Msk = 0xffff

	// IDR: Independent data register
	// Position of IDR field.
	CRC_IDR_IDR_Pos = 0x0
	// Bit mask of IDR field.
	CRC_IDR_IDR_Msk = 0xff

	// CR: Control register
	// Position of RESET field.
	CRC_CR_RESET_Pos = 0x0
	// Bit mask of RESET field.
	CRC_CR_RESET_Msk = 0x1
	// Bit RESET.
	CRC_CR_RESET = 0x1
	// Resets the CRC calculation unit and sets the data register to 0xFFFF FFFF
	CRC_CR_RESET_Reset = 0x1
	// Position of POLYSIZE field.
	CRC_CR_POLYSIZE_Pos = 0x3
	// Bit mask of POLYSIZE field.
	CRC_CR_POLYSIZE_Msk = 0x18
	// 32-bit polynomial
	CRC_CR_POLYSIZE_Polysize32 = 0x0
	// 16-bit polynomial
	CRC_CR_POLYSIZE_Polysize16 = 0x1
	// 8-bit polynomial
	CRC_CR_POLYSIZE_Polysize8 = 0x2
	// 7-bit polynomial
	CRC_CR_POLYSIZE_Polysize7 = 0x3
	// Position of REV_IN field.
	CRC_CR_REV_IN_Pos = 0x5
	// Bit mask of REV_IN field.
	CRC_CR_REV_IN_Msk = 0x60
	// Bit order not affected
	CRC_CR_REV_IN_Normal = 0x0
	// Bit reversal done by byte
	CRC_CR_REV_IN_Byte = 0x1
	// Bit reversal done by half-word
	CRC_CR_REV_IN_HalfWord = 0x2
	// Bit reversal done by word
	CRC_CR_REV_IN_Word = 0x3
	// Position of REV_OUT field.
	CRC_CR_REV_OUT_Pos = 0x7
	// Bit mask of REV_OUT field.
	CRC_CR_REV_OUT_Msk = 0x80
	// Bit REV_OUT.
	CRC_CR_REV_OUT = 0x80
	// Bit order not affected
	CRC_CR_REV_OUT_Normal = 0x0
	// Bit reversed output
	CRC_CR_REV_OUT_Reversed = 0x1

	// INIT: Initial CRC value
	// Position of INIT field.
	CRC_INIT_INIT_Pos = 0x0
	// Bit mask of INIT field.
	CRC_INIT_INIT_Msk = 0xffffffff

	// POL: CRC polynomial
	// Position of POL field.
	CRC_POL_POL_Pos = 0x0
	// Bit mask of POL field.
	CRC_POL_POL_Msk = 0xffffffff
)

// Constants for FLASH: Flash
const (
	// ACR: Flash access control register
	// Position of LATENCY field.
	Flash_ACR_LATENCY_Pos = 0x0
	// Bit mask of LATENCY field.
	Flash_ACR_LATENCY_Msk = 0x7
	// 0 wait states, if 0 < HCLK <= 24 MHz
	Flash_ACR_LATENCY_WS0 = 0x0
	// 1 wait state, if 24 < HCLK <= 48 MHz
	Flash_ACR_LATENCY_WS1 = 0x1
	// 2 wait states, if 48 < HCLK <= 72 MHz
	Flash_ACR_LATENCY_WS2 = 0x2
	// Position of PRFTBE field.
	Flash_ACR_PRFTBE_Pos = 0x4
	// Bit mask of PRFTBE field.
	Flash_ACR_PRFTBE_Msk = 0x10
	// Bit PRFTBE.
	Flash_ACR_PRFTBE = 0x10
	// Prefetch is disabled
	Flash_ACR_PRFTBE_Disabled = 0x0
	// Prefetch is enabled
	Flash_ACR_PRFTBE_Enabled = 0x1
	// Position of PRFTBS field.
	Flash_ACR_PRFTBS_Pos = 0x5
	// Bit mask of PRFTBS field.
	Flash_ACR_PRFTBS_Msk = 0x20
	// Bit PRFTBS.
	Flash_ACR_PRFTBS = 0x20
	// Prefetch buffer is disabled
	Flash_ACR_PRFTBS_Disabled = 0x0
	// Prefetch buffer is enabled
	Flash_ACR_PRFTBS_Enabled = 0x1
	// Position of HLFCYA field.
	Flash_ACR_HLFCYA_Pos = 0x3
	// Bit mask of HLFCYA field.
	Flash_ACR_HLFCYA_Msk = 0x8
	// Bit HLFCYA.
	Flash_ACR_HLFCYA = 0x8
	// Half cycle is disabled
	Flash_ACR_HLFCYA_Disabled = 0x0
	// Half cycle is enabled
	Flash_ACR_HLFCYA_Enabled = 0x1

	// KEYR: Flash key register
	// Position of FKEYR field.
	Flash_KEYR_FKEYR_Pos = 0x0
	// Bit mask of FKEYR field.
	Flash_KEYR_FKEYR_Msk = 0xffffffff

	// OPTKEYR: Flash option key register
	// Position of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Pos = 0x0
	// Bit mask of OPTKEYR field.
	Flash_OPTKEYR_OPTKEYR_Msk = 0xffffffff

	// SR: Flash status register
	// Position of EOP field.
	Flash_SR_EOP_Pos = 0x5
	// Bit mask of EOP field.
	Flash_SR_EOP_Msk = 0x20
	// Bit EOP.
	Flash_SR_EOP = 0x20
	// No EOP event occurred
	Flash_SR_EOP_NoEvent = 0x0
	// An EOP event occurred
	Flash_SR_EOP_Event = 0x1
	// Reset EOP event
	Flash_SR_EOP_Reset = 0x1
	// Position of WRPRTERR field.
	Flash_SR_WRPRTERR_Pos = 0x4
	// Bit mask of WRPRTERR field.
	Flash_SR_WRPRTERR_Msk = 0x10
	// Bit WRPRTERR.
	Flash_SR_WRPRTERR = 0x10
	// No write protection error occurred
	Flash_SR_WRPRTERR_NoError = 0x0
	// A write protection error occurred
	Flash_SR_WRPRTERR_Error = 0x1
	// Reset write protection error
	Flash_SR_WRPRTERR_Reset = 0x1
	// Position of PGERR field.
	Flash_SR_PGERR_Pos = 0x2
	// Bit mask of PGERR field.
	Flash_SR_PGERR_Msk = 0x4
	// Bit PGERR.
	Flash_SR_PGERR = 0x4
	// No programming error occurred
	Flash_SR_PGERR_NoError = 0x0
	// A programming error occurred
	Flash_SR_PGERR_Error = 0x1
	// Reset programming error
	Flash_SR_PGERR_Reset = 0x1
	// Position of BSY field.
	Flash_SR_BSY_Pos = 0x0
	// Bit mask of BSY field.
	Flash_SR_BSY_Msk = 0x1
	// Bit BSY.
	Flash_SR_BSY = 0x1
	// No write/erase operation is in progress
	Flash_SR_BSY_Inactive = 0x0
	// No write/erase operation is in progress
	Flash_SR_BSY_Active = 0x1

	// CR: Flash control register
	// Position of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Pos = 0xd
	// Bit mask of OBL_LAUNCH field.
	Flash_CR_OBL_LAUNCH_Msk = 0x2000
	// Bit OBL_LAUNCH.
	Flash_CR_OBL_LAUNCH = 0x2000
	// Force option byte loading inactive
	Flash_CR_OBL_LAUNCH_Inactive = 0x0
	// Force option byte loading active
	Flash_CR_OBL_LAUNCH_Active = 0x1
	// Position of EOPIE field.
	Flash_CR_EOPIE_Pos = 0xc
	// Bit mask of EOPIE field.
	Flash_CR_EOPIE_Msk = 0x1000
	// Bit EOPIE.
	Flash_CR_EOPIE = 0x1000
	// End of operation interrupt disabled
	Flash_CR_EOPIE_Disabled = 0x0
	// End of operation interrupt enabled
	Flash_CR_EOPIE_Enabled = 0x1
	// Position of ERRIE field.
	Flash_CR_ERRIE_Pos = 0xa
	// Bit mask of ERRIE field.
	Flash_CR_ERRIE_Msk = 0x400
	// Bit ERRIE.
	Flash_CR_ERRIE = 0x400
	// Error interrupt generation disabled
	Flash_CR_ERRIE_Disabled = 0x0
	// Error interrupt generation enabled
	Flash_CR_ERRIE_Enabled = 0x1
	// Position of OPTWRE field.
	Flash_CR_OPTWRE_Pos = 0x9
	// Bit mask of OPTWRE field.
	Flash_CR_OPTWRE_Msk = 0x200
	// Bit OPTWRE.
	Flash_CR_OPTWRE = 0x200
	// Option byte write enabled
	Flash_CR_OPTWRE_Disabled = 0x0
	// Option byte write disabled
	Flash_CR_OPTWRE_Enabled = 0x1
	// Position of LOCK field.
	Flash_CR_LOCK_Pos = 0x7
	// Bit mask of LOCK field.
	Flash_CR_LOCK_Msk = 0x80
	// Bit LOCK.
	Flash_CR_LOCK = 0x80
	// FLASH_CR register is unlocked
	Flash_CR_LOCK_Unlocked = 0x0
	// FLASH_CR register is locked
	Flash_CR_LOCK_Locked = 0x1
	// Lock the FLASH_CR register
	Flash_CR_LOCK_Lock = 0x1
	// Position of STRT field.
	Flash_CR_STRT_Pos = 0x6
	// Bit mask of STRT field.
	Flash_CR_STRT_Msk = 0x40
	// Bit STRT.
	Flash_CR_STRT = 0x40
	// Trigger an erase operation
	Flash_CR_STRT_Start = 0x1
	// Position of OPTER field.
	Flash_CR_OPTER_Pos = 0x5
	// Bit mask of OPTER field.
	Flash_CR_OPTER_Msk = 0x20
	// Bit OPTER.
	Flash_CR_OPTER = 0x20
	// Erase option byte activated
	Flash_CR_OPTER_OptionByteErase = 0x1
	// Position of OPTPG field.
	Flash_CR_OPTPG_Pos = 0x4
	// Bit mask of OPTPG field.
	Flash_CR_OPTPG_Msk = 0x10
	// Bit OPTPG.
	Flash_CR_OPTPG = 0x10
	// Program option byte activated
	Flash_CR_OPTPG_OptionByteProgramming = 0x1
	// Position of MER field.
	Flash_CR_MER_Pos = 0x2
	// Bit mask of MER field.
	Flash_CR_MER_Msk = 0x4
	// Bit MER.
	Flash_CR_MER = 0x4
	// Erase activated for all user sectors
	Flash_CR_MER_MassErase = 0x1
	// Position of PER field.
	Flash_CR_PER_Pos = 0x1
	// Bit mask of PER field.
	Flash_CR_PER_Msk = 0x2
	// Bit PER.
	Flash_CR_PER = 0x2
	// Erase activated for selected page
	Flash_CR_PER_PageErase = 0x1
	// Position of PG field.
	Flash_CR_PG_Pos = 0x0
	// Bit mask of PG field.
	Flash_CR_PG_Msk = 0x1
	// Bit PG.
	Flash_CR_PG = 0x1
	// Flash programming activated
	Flash_CR_PG_Program = 0x1

	// AR: Flash address register
	// Position of FAR field.
	Flash_AR_FAR_Pos = 0x0
	// Bit mask of FAR field.
	Flash_AR_FAR_Msk = 0xffffffff

	// OBR: Option byte register
	// Position of OPTERR field.
	Flash_OBR_OPTERR_Pos = 0x0
	// Bit mask of OPTERR field.
	Flash_OBR_OPTERR_Msk = 0x1
	// Bit OPTERR.
	Flash_OBR_OPTERR = 0x1
	// The loaded option byte and its complement do not match
	Flash_OBR_OPTERR_OptionByteError = 0x1
	// Position of RDPRT field.
	Flash_OBR_RDPRT_Pos = 0x1
	// Bit mask of RDPRT field.
	Flash_OBR_RDPRT_Msk = 0x6
	// Level 0
	Flash_OBR_RDPRT_Level0 = 0x0
	// Level 1
	Flash_OBR_RDPRT_Level1 = 0x1
	// Level 2
	Flash_OBR_RDPRT_Level2 = 0x3
	// Position of WDG_SW field.
	Flash_OBR_WDG_SW_Pos = 0x8
	// Bit mask of WDG_SW field.
	Flash_OBR_WDG_SW_Msk = 0x100
	// Bit WDG_SW.
	Flash_OBR_WDG_SW = 0x100
	// Hardware watchdog
	Flash_OBR_WDG_SW_Hardware = 0x0
	// Software watchdog
	Flash_OBR_WDG_SW_Software = 0x1
	// Position of NRST_STOP field.
	Flash_OBR_NRST_STOP_Pos = 0x9
	// Bit mask of NRST_STOP field.
	Flash_OBR_NRST_STOP_Msk = 0x200
	// Bit NRST_STOP.
	Flash_OBR_NRST_STOP = 0x200
	// Reset generated when entering Stop mode
	Flash_OBR_NRST_STOP_Reset = 0x0
	// No reset generated
	Flash_OBR_NRST_STOP_NoReset = 0x1
	// Position of NRST_STDBY field.
	Flash_OBR_NRST_STDBY_Pos = 0xa
	// Bit mask of NRST_STDBY field.
	Flash_OBR_NRST_STDBY_Msk = 0x400
	// Bit NRST_STDBY.
	Flash_OBR_NRST_STDBY = 0x400
	// Reset generated when entering Standby mode
	Flash_OBR_NRST_STDBY_Reset = 0x0
	// No reset generated
	Flash_OBR_NRST_STDBY_NoReset = 0x1
	// Position of NBOOT1 field.
	Flash_OBR_NBOOT1_Pos = 0xc
	// Bit mask of NBOOT1 field.
	Flash_OBR_NBOOT1_Msk = 0x1000
	// Bit NBOOT1.
	Flash_OBR_NBOOT1 = 0x1000
	// Together with BOOT0, select the device boot mode
	Flash_OBR_NBOOT1_Disabled = 0x0
	// Together with BOOT0, select the device boot mode
	Flash_OBR_NBOOT1_Enabled = 0x1
	// Position of VDDA_MONITOR field.
	Flash_OBR_VDDA_MONITOR_Pos = 0xd
	// Bit mask of VDDA_MONITOR field.
	Flash_OBR_VDDA_MONITOR_Msk = 0x2000
	// Bit VDDA_MONITOR.
	Flash_OBR_VDDA_MONITOR = 0x2000
	// VDDA power supply supervisor disabled
	Flash_OBR_VDDA_MONITOR_Disabled = 0x0
	// VDDA power supply supervisor enabled
	Flash_OBR_VDDA_MONITOR_Enabled = 0x1
	// Position of Data0 field.
	Flash_OBR_Data0_Pos = 0x10
	// Bit mask of Data0 field.
	Flash_OBR_Data0_Msk = 0xff0000
	// Position of Data1 field.
	Flash_OBR_Data1_Pos = 0x18
	// Bit mask of Data1 field.
	Flash_OBR_Data1_Msk = 0xff000000

	// WRPR: Write protection register
	// Position of WRP field.
	Flash_WRPR_WRP_Pos = 0x0
	// Bit mask of WRP field.
	Flash_WRPR_WRP_Msk = 0xffffffff
)

// Constants for RCC: Reset and clock control
const (
	// CR: Clock control register
	// Position of HSION field.
	RCC_CR_HSION_Pos = 0x0
	// Bit mask of HSION field.
	RCC_CR_HSION_Msk = 0x1
	// Bit HSION.
	RCC_CR_HSION = 0x1
	// Clock Off
	RCC_CR_HSION_Off = 0x0
	// Clock On
	RCC_CR_HSION_On = 0x1
	// Position of HSIRDY field.
	RCC_CR_HSIRDY_Pos = 0x1
	// Bit mask of HSIRDY field.
	RCC_CR_HSIRDY_Msk = 0x2
	// Bit HSIRDY.
	RCC_CR_HSIRDY = 0x2
	// Clock not ready
	RCC_CR_HSIRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSIRDY_Ready = 0x1
	// Position of HSITRIM field.
	RCC_CR_HSITRIM_Pos = 0x3
	// Bit mask of HSITRIM field.
	RCC_CR_HSITRIM_Msk = 0xf8
	// Position of HSICAL field.
	RCC_CR_HSICAL_Pos = 0x8
	// Bit mask of HSICAL field.
	RCC_CR_HSICAL_Msk = 0xff00
	// Position of HSEON field.
	RCC_CR_HSEON_Pos = 0x10
	// Bit mask of HSEON field.
	RCC_CR_HSEON_Msk = 0x10000
	// Bit HSEON.
	RCC_CR_HSEON = 0x10000
	// Clock Off
	RCC_CR_HSEON_Off = 0x0
	// Clock On
	RCC_CR_HSEON_On = 0x1
	// Position of HSERDY field.
	RCC_CR_HSERDY_Pos = 0x11
	// Bit mask of HSERDY field.
	RCC_CR_HSERDY_Msk = 0x20000
	// Bit HSERDY.
	RCC_CR_HSERDY = 0x20000
	// Clock not ready
	RCC_CR_HSERDY_NotReady = 0x0
	// Clock ready
	RCC_CR_HSERDY_Ready = 0x1
	// Position of HSEBYP field.
	RCC_CR_HSEBYP_Pos = 0x12
	// Bit mask of HSEBYP field.
	RCC_CR_HSEBYP_Msk = 0x40000
	// Bit HSEBYP.
	RCC_CR_HSEBYP = 0x40000
	// HSE crystal oscillator not bypassed
	RCC_CR_HSEBYP_NotBypassed = 0x0
	// HSE crystal oscillator bypassed with external clock
	RCC_CR_HSEBYP_Bypassed = 0x1
	// Position of CSSON field.
	RCC_CR_CSSON_Pos = 0x13
	// Bit mask of CSSON field.
	RCC_CR_CSSON_Msk = 0x80000
	// Bit CSSON.
	RCC_CR_CSSON = 0x80000
	// Clock security system disabled (clock detector OFF)
	RCC_CR_CSSON_Off = 0x0
	// Clock security system enable (clock detector ON if the HSE is ready, OFF if not)
	RCC_CR_CSSON_On = 0x1
	// Position of PLLON field.
	RCC_CR_PLLON_Pos = 0x18
	// Bit mask of PLLON field.
	RCC_CR_PLLON_Msk = 0x1000000
	// Bit PLLON.
	RCC_CR_PLLON = 0x1000000
	// Clock Off
	RCC_CR_PLLON_Off = 0x0
	// Clock On
	RCC_CR_PLLON_On = 0x1
	// Position of PLLRDY field.
	RCC_CR_PLLRDY_Pos = 0x19
	// Bit mask of PLLRDY field.
	RCC_CR_PLLRDY_Msk = 0x2000000
	// Bit PLLRDY.
	RCC_CR_PLLRDY = 0x2000000
	// Clock not ready
	RCC_CR_PLLRDY_NotReady = 0x0
	// Clock ready
	RCC_CR_PLLRDY_Ready = 0x1

	// CFGR: Clock configuration register (RCC_CFGR)
	// Position of SW field.
	RCC_CFGR_SW_Pos = 0x0
	// Bit mask of SW field.
	RCC_CFGR_SW_Msk = 0x3
	// HSI selected as system clock
	RCC_CFGR_SW_HSI = 0x0
	// HSE selected as system clock
	RCC_CFGR_SW_HSE = 0x1
	// PLL selected as system clock
	RCC_CFGR_SW_PLL = 0x2
	// Position of SWS field.
	RCC_CFGR_SWS_Pos = 0x2
	// Bit mask of SWS field.
	RCC_CFGR_SWS_Msk = 0xc
	// HSI oscillator used as system clock
	RCC_CFGR_SWS_HSI = 0x0
	// HSE oscillator used as system clock
	RCC_CFGR_SWS_HSE = 0x1
	// PLL used as system clock
	RCC_CFGR_SWS_PLL = 0x2
	// Position of HPRE field.
	RCC_CFGR_HPRE_Pos = 0x4
	// Bit mask of HPRE field.
	RCC_CFGR_HPRE_Msk = 0xf0
	// SYSCLK not divided
	RCC_CFGR_HPRE_Div1 = 0x0
	// SYSCLK divided by 2
	RCC_CFGR_HPRE_Div2 = 0x8
	// SYSCLK divided by 4
	RCC_CFGR_HPRE_Div4 = 0x9
	// SYSCLK divided by 8
	RCC_CFGR_HPRE_Div8 = 0xa
	// SYSCLK divided by 16
	RCC_CFGR_HPRE_Div16 = 0xb
	// SYSCLK divided by 64
	RCC_CFGR_HPRE_Div64 = 0xc
	// SYSCLK divided by 128
	RCC_CFGR_HPRE_Div128 = 0xd
	// SYSCLK divided by 256
	RCC_CFGR_HPRE_Div256 = 0xe
	// SYSCLK divided by 512
	RCC_CFGR_HPRE_Div512 = 0xf
	// Position of PPRE1 field.
	RCC_CFGR_PPRE1_Pos = 0x8
	// Bit mask of PPRE1 field.
	RCC_CFGR_PPRE1_Msk = 0x700
	// HCLK not divided
	RCC_CFGR_PPRE1_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE1_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE1_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE1_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE1_Div16 = 0x7
	// Position of PPRE2 field.
	RCC_CFGR_PPRE2_Pos = 0xb
	// Bit mask of PPRE2 field.
	RCC_CFGR_PPRE2_Msk = 0x3800
	// HCLK not divided
	RCC_CFGR_PPRE2_Div1 = 0x0
	// HCLK divided by 2
	RCC_CFGR_PPRE2_Div2 = 0x4
	// HCLK divided by 4
	RCC_CFGR_PPRE2_Div4 = 0x5
	// HCLK divided by 8
	RCC_CFGR_PPRE2_Div8 = 0x6
	// HCLK divided by 16
	RCC_CFGR_PPRE2_Div16 = 0x7
	// Position of PLLSRC field.
	RCC_CFGR_PLLSRC_Pos = 0x10
	// Bit mask of PLLSRC field.
	RCC_CFGR_PLLSRC_Msk = 0x10000
	// Bit PLLSRC.
	RCC_CFGR_PLLSRC = 0x10000
	// HSI divided by 2 selected as PLL input clock
	RCC_CFGR_PLLSRC_HSI_Div2 = 0x0
	// HSE divided by PREDIV selected as PLL input clock
	RCC_CFGR_PLLSRC_HSE_Div_PREDIV = 0x1
	// Position of PLLXTPRE field.
	RCC_CFGR_PLLXTPRE_Pos = 0x11
	// Bit mask of PLLXTPRE field.
	RCC_CFGR_PLLXTPRE_Msk = 0x20000
	// Bit PLLXTPRE.
	RCC_CFGR_PLLXTPRE = 0x20000
	// HSE clock not divided
	RCC_CFGR_PLLXTPRE_Div1 = 0x0
	// HSE clock divided by 2
	RCC_CFGR_PLLXTPRE_Div2 = 0x1
	// Position of PLLMUL field.
	RCC_CFGR_PLLMUL_Pos = 0x12
	// Bit mask of PLLMUL field.
	RCC_CFGR_PLLMUL_Msk = 0x3c0000
	// PLL input clock x2
	RCC_CFGR_PLLMUL_Mul2 = 0x0
	// PLL input clock x3
	RCC_CFGR_PLLMUL_Mul3 = 0x1
	// PLL input clock x4
	RCC_CFGR_PLLMUL_Mul4 = 0x2
	// PLL input clock x5
	RCC_CFGR_PLLMUL_Mul5 = 0x3
	// PLL input clock x6
	RCC_CFGR_PLLMUL_Mul6 = 0x4
	// PLL input clock x7
	RCC_CFGR_PLLMUL_Mul7 = 0x5
	// PLL input clock x8
	RCC_CFGR_PLLMUL_Mul8 = 0x6
	// PLL input clock x9
	RCC_CFGR_PLLMUL_Mul9 = 0x7
	// PLL input clock x10
	RCC_CFGR_PLLMUL_Mul10 = 0x8
	// PLL input clock x11
	RCC_CFGR_PLLMUL_Mul11 = 0x9
	// PLL input clock x12
	RCC_CFGR_PLLMUL_Mul12 = 0xa
	// PLL input clock x13
	RCC_CFGR_PLLMUL_Mul13 = 0xb
	// PLL input clock x14
	RCC_CFGR_PLLMUL_Mul14 = 0xc
	// PLL input clock x15
	RCC_CFGR_PLLMUL_Mul15 = 0xd
	// PLL input clock x16
	RCC_CFGR_PLLMUL_Mul16 = 0xe
	// PLL input clock x16
	RCC_CFGR_PLLMUL_Mul16x = 0xf
	// Position of I2SSRC field.
	RCC_CFGR_I2SSRC_Pos = 0x17
	// Bit mask of I2SSRC field.
	RCC_CFGR_I2SSRC_Msk = 0x800000
	// Bit I2SSRC.
	RCC_CFGR_I2SSRC = 0x800000
	// System clock used as I2S clock source
	RCC_CFGR_I2SSRC_SYSCLK = 0x0
	// External clock mapped on the I2S_CKIN pin used as I2S clock source
	RCC_CFGR_I2SSRC_CKIN = 0x1
	// Position of MCO field.
	RCC_CFGR_MCO_Pos = 0x18
	// Bit mask of MCO field.
	RCC_CFGR_MCO_Msk = 0x7000000
	// MCO output disabled, no clock on MCO
	RCC_CFGR_MCO_NoMCO = 0x0
	// Internal low speed (LSI) oscillator clock selected
	RCC_CFGR_MCO_LSI = 0x2
	// External low speed (LSE) oscillator clock selected
	RCC_CFGR_MCO_LSE = 0x3
	// System clock selected
	RCC_CFGR_MCO_SYSCLK = 0x4
	// Internal RC 8 MHz (HSI) oscillator clock selected
	RCC_CFGR_MCO_HSI = 0x5
	// External 4-32 MHz (HSE) oscillator clock selected
	RCC_CFGR_MCO_HSE = 0x6
	// PLL clock selected (divided by 1 or 2, depending en PLLNODIV)
	RCC_CFGR_MCO_PLL = 0x7
	// Position of MCOPRE field.
	RCC_CFGR_MCOPRE_Pos = 0x1c
	// Bit mask of MCOPRE field.
	RCC_CFGR_MCOPRE_Msk = 0x70000000
	// MCO is divided by 1
	RCC_CFGR_MCOPRE_Div1 = 0x0
	// MCO is divided by 2
	RCC_CFGR_MCOPRE_Div2 = 0x1
	// MCO is divided by 4
	RCC_CFGR_MCOPRE_Div4 = 0x2
	// MCO is divided by 8
	RCC_CFGR_MCOPRE_Div8 = 0x3
	// MCO is divided by 16
	RCC_CFGR_MCOPRE_Div16 = 0x4
	// MCO is divided by 32
	RCC_CFGR_MCOPRE_Div32 = 0x5
	// MCO is divided by 64
	RCC_CFGR_MCOPRE_Div64 = 0x6
	// MCO is divided by 128
	RCC_CFGR_MCOPRE_Div128 = 0x7
	// Position of PLLNODIV field.
	RCC_CFGR_PLLNODIV_Pos = 0x1f
	// Bit mask of PLLNODIV field.
	RCC_CFGR_PLLNODIV_Msk = 0x80000000
	// Bit PLLNODIV.
	RCC_CFGR_PLLNODIV = 0x80000000
	// PLL is divided by 2 for MCO
	RCC_CFGR_PLLNODIV_Div2 = 0x0
	// PLL is not divided for MCO
	RCC_CFGR_PLLNODIV_Div1 = 0x1

	// CIR: Clock interrupt register (RCC_CIR)
	// Position of LSIRDYF field.
	RCC_CIR_LSIRDYF_Pos = 0x0
	// Bit mask of LSIRDYF field.
	RCC_CIR_LSIRDYF_Msk = 0x1
	// Bit LSIRDYF.
	RCC_CIR_LSIRDYF = 0x1
	// No clock ready interrupt
	RCC_CIR_LSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSIRDYF_Interrupted = 0x1
	// Position of LSERDYF field.
	RCC_CIR_LSERDYF_Pos = 0x1
	// Bit mask of LSERDYF field.
	RCC_CIR_LSERDYF_Msk = 0x2
	// Bit LSERDYF.
	RCC_CIR_LSERDYF = 0x2
	// No clock ready interrupt
	RCC_CIR_LSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_LSERDYF_Interrupted = 0x1
	// Position of HSIRDYF field.
	RCC_CIR_HSIRDYF_Pos = 0x2
	// Bit mask of HSIRDYF field.
	RCC_CIR_HSIRDYF_Msk = 0x4
	// Bit HSIRDYF.
	RCC_CIR_HSIRDYF = 0x4
	// No clock ready interrupt
	RCC_CIR_HSIRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSIRDYF_Interrupted = 0x1
	// Position of HSERDYF field.
	RCC_CIR_HSERDYF_Pos = 0x3
	// Bit mask of HSERDYF field.
	RCC_CIR_HSERDYF_Msk = 0x8
	// Bit HSERDYF.
	RCC_CIR_HSERDYF = 0x8
	// No clock ready interrupt
	RCC_CIR_HSERDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_HSERDYF_Interrupted = 0x1
	// Position of PLLRDYF field.
	RCC_CIR_PLLRDYF_Pos = 0x4
	// Bit mask of PLLRDYF field.
	RCC_CIR_PLLRDYF_Msk = 0x10
	// Bit PLLRDYF.
	RCC_CIR_PLLRDYF = 0x10
	// No clock ready interrupt
	RCC_CIR_PLLRDYF_NotInterrupted = 0x0
	// Clock ready interrupt
	RCC_CIR_PLLRDYF_Interrupted = 0x1
	// Position of CSSF field.
	RCC_CIR_CSSF_Pos = 0x7
	// Bit mask of CSSF field.
	RCC_CIR_CSSF_Msk = 0x80
	// Bit CSSF.
	RCC_CIR_CSSF = 0x80
	// No clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_NotInterrupted = 0x0
	// Clock security interrupt caused by HSE clock failure
	RCC_CIR_CSSF_Interrupted = 0x1
	// Position of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Pos = 0x8
	// Bit mask of LSIRDYIE field.
	RCC_CIR_LSIRDYIE_Msk = 0x100
	// Bit LSIRDYIE.
	RCC_CIR_LSIRDYIE = 0x100
	// Interrupt disabled
	RCC_CIR_LSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSIRDYIE_Enabled = 0x1
	// Position of LSERDYIE field.
	RCC_CIR_LSERDYIE_Pos = 0x9
	// Bit mask of LSERDYIE field.
	RCC_CIR_LSERDYIE_Msk = 0x200
	// Bit LSERDYIE.
	RCC_CIR_LSERDYIE = 0x200
	// Interrupt disabled
	RCC_CIR_LSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_LSERDYIE_Enabled = 0x1
	// Position of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Pos = 0xa
	// Bit mask of HSIRDYIE field.
	RCC_CIR_HSIRDYIE_Msk = 0x400
	// Bit HSIRDYIE.
	RCC_CIR_HSIRDYIE = 0x400
	// Interrupt disabled
	RCC_CIR_HSIRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSIRDYIE_Enabled = 0x1
	// Position of HSERDYIE field.
	RCC_CIR_HSERDYIE_Pos = 0xb
	// Bit mask of HSERDYIE field.
	RCC_CIR_HSERDYIE_Msk = 0x800
	// Bit HSERDYIE.
	RCC_CIR_HSERDYIE = 0x800
	// Interrupt disabled
	RCC_CIR_HSERDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_HSERDYIE_Enabled = 0x1
	// Position of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Pos = 0xc
	// Bit mask of PLLRDYIE field.
	RCC_CIR_PLLRDYIE_Msk = 0x1000
	// Bit PLLRDYIE.
	RCC_CIR_PLLRDYIE = 0x1000
	// Interrupt disabled
	RCC_CIR_PLLRDYIE_Disabled = 0x0
	// Interrupt enabled
	RCC_CIR_PLLRDYIE_Enabled = 0x1
	// Position of LSIRDYC field.
	RCC_CIR_LSIRDYC_Pos = 0x10
	// Bit mask of LSIRDYC field.
	RCC_CIR_LSIRDYC_Msk = 0x10000
	// Bit LSIRDYC.
	RCC_CIR_LSIRDYC = 0x10000
	// Clear interrupt flag
	RCC_CIR_LSIRDYC_Clear = 0x1
	// Position of LSERDYC field.
	RCC_CIR_LSERDYC_Pos = 0x11
	// Bit mask of LSERDYC field.
	RCC_CIR_LSERDYC_Msk = 0x20000
	// Bit LSERDYC.
	RCC_CIR_LSERDYC = 0x20000
	// Clear interrupt flag
	RCC_CIR_LSERDYC_Clear = 0x1
	// Position of HSIRDYC field.
	RCC_CIR_HSIRDYC_Pos = 0x12
	// Bit mask of HSIRDYC field.
	RCC_CIR_HSIRDYC_Msk = 0x40000
	// Bit HSIRDYC.
	RCC_CIR_HSIRDYC = 0x40000
	// Clear interrupt flag
	RCC_CIR_HSIRDYC_Clear = 0x1
	// Position of HSERDYC field.
	RCC_CIR_HSERDYC_Pos = 0x13
	// Bit mask of HSERDYC field.
	RCC_CIR_HSERDYC_Msk = 0x80000
	// Bit HSERDYC.
	RCC_CIR_HSERDYC = 0x80000
	// Clear interrupt flag
	RCC_CIR_HSERDYC_Clear = 0x1
	// Position of PLLRDYC field.
	RCC_CIR_PLLRDYC_Pos = 0x14
	// Bit mask of PLLRDYC field.
	RCC_CIR_PLLRDYC_Msk = 0x100000
	// Bit PLLRDYC.
	RCC_CIR_PLLRDYC = 0x100000
	// Clear interrupt flag
	RCC_CIR_PLLRDYC_Clear = 0x1
	// Position of CSSC field.
	RCC_CIR_CSSC_Pos = 0x17
	// Bit mask of CSSC field.
	RCC_CIR_CSSC_Msk = 0x800000
	// Bit CSSC.
	RCC_CIR_CSSC = 0x800000
	// Clear CSSF flag
	RCC_CIR_CSSC_Clear = 0x1

	// APB2RSTR: APB2 peripheral reset register (RCC_APB2RSTR)
	// Position of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Pos = 0x0
	// Bit mask of SYSCFGRST field.
	RCC_APB2RSTR_SYSCFGRST_Msk = 0x1
	// Bit SYSCFGRST.
	RCC_APB2RSTR_SYSCFGRST = 0x1
	// Reset the selected module
	RCC_APB2RSTR_SYSCFGRST_Reset = 0x1
	// Position of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Pos = 0xb
	// Bit mask of TIM1RST field.
	RCC_APB2RSTR_TIM1RST_Msk = 0x800
	// Bit TIM1RST.
	RCC_APB2RSTR_TIM1RST = 0x800
	// Reset the selected module
	RCC_APB2RSTR_TIM1RST_Reset = 0x1
	// Position of USART1RST field.
	RCC_APB2RSTR_USART1RST_Pos = 0xe
	// Bit mask of USART1RST field.
	RCC_APB2RSTR_USART1RST_Msk = 0x4000
	// Bit USART1RST.
	RCC_APB2RSTR_USART1RST = 0x4000
	// Reset the selected module
	RCC_APB2RSTR_USART1RST_Reset = 0x1
	// Position of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Pos = 0x10
	// Bit mask of TIM15RST field.
	RCC_APB2RSTR_TIM15RST_Msk = 0x10000
	// Bit TIM15RST.
	RCC_APB2RSTR_TIM15RST = 0x10000
	// Reset the selected module
	RCC_APB2RSTR_TIM15RST_Reset = 0x1
	// Position of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Pos = 0x11
	// Bit mask of TIM16RST field.
	RCC_APB2RSTR_TIM16RST_Msk = 0x20000
	// Bit TIM16RST.
	RCC_APB2RSTR_TIM16RST = 0x20000
	// Reset the selected module
	RCC_APB2RSTR_TIM16RST_Reset = 0x1
	// Position of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Pos = 0x12
	// Bit mask of TIM17RST field.
	RCC_APB2RSTR_TIM17RST_Msk = 0x40000
	// Bit TIM17RST.
	RCC_APB2RSTR_TIM17RST = 0x40000
	// Reset the selected module
	RCC_APB2RSTR_TIM17RST_Reset = 0x1

	// APB1RSTR: APB1 peripheral reset register (RCC_APB1RSTR)
	// Position of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Pos = 0x0
	// Bit mask of TIM2RST field.
	RCC_APB1RSTR_TIM2RST_Msk = 0x1
	// Bit TIM2RST.
	RCC_APB1RSTR_TIM2RST = 0x1
	// Reset the selected module
	RCC_APB1RSTR_TIM2RST_Reset = 0x1
	// Position of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Pos = 0x4
	// Bit mask of TIM6RST field.
	RCC_APB1RSTR_TIM6RST_Msk = 0x10
	// Bit TIM6RST.
	RCC_APB1RSTR_TIM6RST = 0x10
	// Reset the selected module
	RCC_APB1RSTR_TIM6RST_Reset = 0x1
	// Position of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Pos = 0xb
	// Bit mask of WWDGRST field.
	RCC_APB1RSTR_WWDGRST_Msk = 0x800
	// Bit WWDGRST.
	RCC_APB1RSTR_WWDGRST = 0x800
	// Reset the selected module
	RCC_APB1RSTR_WWDGRST_Reset = 0x1
	// Position of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Pos = 0xe
	// Bit mask of SPI2RST field.
	RCC_APB1RSTR_SPI2RST_Msk = 0x4000
	// Bit SPI2RST.
	RCC_APB1RSTR_SPI2RST = 0x4000
	// Reset the selected module
	RCC_APB1RSTR_SPI2RST_Reset = 0x1
	// Position of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Pos = 0xf
	// Bit mask of SPI3RST field.
	RCC_APB1RSTR_SPI3RST_Msk = 0x8000
	// Bit SPI3RST.
	RCC_APB1RSTR_SPI3RST = 0x8000
	// Reset the selected module
	RCC_APB1RSTR_SPI3RST_Reset = 0x1
	// Position of USART2RST field.
	RCC_APB1RSTR_USART2RST_Pos = 0x11
	// Bit mask of USART2RST field.
	RCC_APB1RSTR_USART2RST_Msk = 0x20000
	// Bit USART2RST.
	RCC_APB1RSTR_USART2RST = 0x20000
	// Reset the selected module
	RCC_APB1RSTR_USART2RST_Reset = 0x1
	// Position of USART3RST field.
	RCC_APB1RSTR_USART3RST_Pos = 0x12
	// Bit mask of USART3RST field.
	RCC_APB1RSTR_USART3RST_Msk = 0x40000
	// Bit USART3RST.
	RCC_APB1RSTR_USART3RST = 0x40000
	// Reset the selected module
	RCC_APB1RSTR_USART3RST_Reset = 0x1
	// Position of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Pos = 0x15
	// Bit mask of I2C1RST field.
	RCC_APB1RSTR_I2C1RST_Msk = 0x200000
	// Bit I2C1RST.
	RCC_APB1RSTR_I2C1RST = 0x200000
	// Reset the selected module
	RCC_APB1RSTR_I2C1RST_Reset = 0x1
	// Position of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Pos = 0x16
	// Bit mask of I2C2RST field.
	RCC_APB1RSTR_I2C2RST_Msk = 0x400000
	// Bit I2C2RST.
	RCC_APB1RSTR_I2C2RST = 0x400000
	// Reset the selected module
	RCC_APB1RSTR_I2C2RST_Reset = 0x1
	// Position of PWRRST field.
	RCC_APB1RSTR_PWRRST_Pos = 0x1c
	// Bit mask of PWRRST field.
	RCC_APB1RSTR_PWRRST_Msk = 0x10000000
	// Bit PWRRST.
	RCC_APB1RSTR_PWRRST = 0x10000000
	// Reset the selected module
	RCC_APB1RSTR_PWRRST_Reset = 0x1
	// Position of DAC1RST field.
	RCC_APB1RSTR_DAC1RST_Pos = 0x1d
	// Bit mask of DAC1RST field.
	RCC_APB1RSTR_DAC1RST_Msk = 0x20000000
	// Bit DAC1RST.
	RCC_APB1RSTR_DAC1RST = 0x20000000
	// Reset the selected module
	RCC_APB1RSTR_DAC1RST_Reset = 0x1
	// Position of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Pos = 0x1e
	// Bit mask of I2C3RST field.
	RCC_APB1RSTR_I2C3RST_Msk = 0x40000000
	// Bit I2C3RST.
	RCC_APB1RSTR_I2C3RST = 0x40000000
	// Reset the selected module
	RCC_APB1RSTR_I2C3RST_Reset = 0x1

	// AHBENR: AHB Peripheral Clock enable register (RCC_AHBENR)
	// Position of DMA1EN field.
	RCC_AHBENR_DMA1EN_Pos = 0x0
	// Bit mask of DMA1EN field.
	RCC_AHBENR_DMA1EN_Msk = 0x1
	// Bit DMA1EN.
	RCC_AHBENR_DMA1EN = 0x1
	// The selected clock is disabled
	RCC_AHBENR_DMA1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_DMA1EN_Enabled = 0x1
	// Position of SRAMEN field.
	RCC_AHBENR_SRAMEN_Pos = 0x2
	// Bit mask of SRAMEN field.
	RCC_AHBENR_SRAMEN_Msk = 0x4
	// Bit SRAMEN.
	RCC_AHBENR_SRAMEN = 0x4
	// The selected clock is disabled
	RCC_AHBENR_SRAMEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_SRAMEN_Enabled = 0x1
	// Position of FLITFEN field.
	RCC_AHBENR_FLITFEN_Pos = 0x4
	// Bit mask of FLITFEN field.
	RCC_AHBENR_FLITFEN_Msk = 0x10
	// Bit FLITFEN.
	RCC_AHBENR_FLITFEN = 0x10
	// The selected clock is disabled
	RCC_AHBENR_FLITFEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_FLITFEN_Enabled = 0x1
	// Position of CRCEN field.
	RCC_AHBENR_CRCEN_Pos = 0x6
	// Bit mask of CRCEN field.
	RCC_AHBENR_CRCEN_Msk = 0x40
	// Bit CRCEN.
	RCC_AHBENR_CRCEN = 0x40
	// The selected clock is disabled
	RCC_AHBENR_CRCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_CRCEN_Enabled = 0x1
	// Position of IOPAEN field.
	RCC_AHBENR_IOPAEN_Pos = 0x11
	// Bit mask of IOPAEN field.
	RCC_AHBENR_IOPAEN_Msk = 0x20000
	// Bit IOPAEN.
	RCC_AHBENR_IOPAEN = 0x20000
	// The selected clock is disabled
	RCC_AHBENR_IOPAEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_IOPAEN_Enabled = 0x1
	// Position of IOPBEN field.
	RCC_AHBENR_IOPBEN_Pos = 0x12
	// Bit mask of IOPBEN field.
	RCC_AHBENR_IOPBEN_Msk = 0x40000
	// Bit IOPBEN.
	RCC_AHBENR_IOPBEN = 0x40000
	// The selected clock is disabled
	RCC_AHBENR_IOPBEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_IOPBEN_Enabled = 0x1
	// Position of IOPCEN field.
	RCC_AHBENR_IOPCEN_Pos = 0x13
	// Bit mask of IOPCEN field.
	RCC_AHBENR_IOPCEN_Msk = 0x80000
	// Bit IOPCEN.
	RCC_AHBENR_IOPCEN = 0x80000
	// The selected clock is disabled
	RCC_AHBENR_IOPCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_IOPCEN_Enabled = 0x1
	// Position of IOPDEN field.
	RCC_AHBENR_IOPDEN_Pos = 0x14
	// Bit mask of IOPDEN field.
	RCC_AHBENR_IOPDEN_Msk = 0x100000
	// Bit IOPDEN.
	RCC_AHBENR_IOPDEN = 0x100000
	// The selected clock is disabled
	RCC_AHBENR_IOPDEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_IOPDEN_Enabled = 0x1
	// Position of IOPFEN field.
	RCC_AHBENR_IOPFEN_Pos = 0x16
	// Bit mask of IOPFEN field.
	RCC_AHBENR_IOPFEN_Msk = 0x400000
	// Bit IOPFEN.
	RCC_AHBENR_IOPFEN = 0x400000
	// The selected clock is disabled
	RCC_AHBENR_IOPFEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_IOPFEN_Enabled = 0x1
	// Position of TSCEN field.
	RCC_AHBENR_TSCEN_Pos = 0x18
	// Bit mask of TSCEN field.
	RCC_AHBENR_TSCEN_Msk = 0x1000000
	// Bit TSCEN.
	RCC_AHBENR_TSCEN = 0x1000000
	// The selected clock is disabled
	RCC_AHBENR_TSCEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_TSCEN_Enabled = 0x1
	// Position of ADC1EN field.
	RCC_AHBENR_ADC1EN_Pos = 0x1c
	// Bit mask of ADC1EN field.
	RCC_AHBENR_ADC1EN_Msk = 0x10000000
	// Bit ADC1EN.
	RCC_AHBENR_ADC1EN = 0x10000000
	// The selected clock is disabled
	RCC_AHBENR_ADC1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_AHBENR_ADC1EN_Enabled = 0x1

	// APB2ENR: APB2 peripheral clock enable register (RCC_APB2ENR)
	// Position of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Pos = 0x0
	// Bit mask of SYSCFGEN field.
	RCC_APB2ENR_SYSCFGEN_Msk = 0x1
	// Bit SYSCFGEN.
	RCC_APB2ENR_SYSCFGEN = 0x1
	// The selected clock is disabled
	RCC_APB2ENR_SYSCFGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_SYSCFGEN_Enabled = 0x1
	// Position of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Pos = 0xb
	// Bit mask of TIM1EN field.
	RCC_APB2ENR_TIM1EN_Msk = 0x800
	// Bit TIM1EN.
	RCC_APB2ENR_TIM1EN = 0x800
	// The selected clock is disabled
	RCC_APB2ENR_TIM1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM1EN_Enabled = 0x1
	// Position of USART1EN field.
	RCC_APB2ENR_USART1EN_Pos = 0xe
	// Bit mask of USART1EN field.
	RCC_APB2ENR_USART1EN_Msk = 0x4000
	// Bit USART1EN.
	RCC_APB2ENR_USART1EN = 0x4000
	// The selected clock is disabled
	RCC_APB2ENR_USART1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_USART1EN_Enabled = 0x1
	// Position of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Pos = 0x10
	// Bit mask of TIM15EN field.
	RCC_APB2ENR_TIM15EN_Msk = 0x10000
	// Bit TIM15EN.
	RCC_APB2ENR_TIM15EN = 0x10000
	// The selected clock is disabled
	RCC_APB2ENR_TIM15EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM15EN_Enabled = 0x1
	// Position of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Pos = 0x11
	// Bit mask of TIM16EN field.
	RCC_APB2ENR_TIM16EN_Msk = 0x20000
	// Bit TIM16EN.
	RCC_APB2ENR_TIM16EN = 0x20000
	// The selected clock is disabled
	RCC_APB2ENR_TIM16EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM16EN_Enabled = 0x1
	// Position of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Pos = 0x12
	// Bit mask of TIM17EN field.
	RCC_APB2ENR_TIM17EN_Msk = 0x40000
	// Bit TIM17EN.
	RCC_APB2ENR_TIM17EN = 0x40000
	// The selected clock is disabled
	RCC_APB2ENR_TIM17EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB2ENR_TIM17EN_Enabled = 0x1

	// APB1ENR: APB1 peripheral clock enable register (RCC_APB1ENR)
	// Position of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Pos = 0x0
	// Bit mask of TIM2EN field.
	RCC_APB1ENR_TIM2EN_Msk = 0x1
	// Bit TIM2EN.
	RCC_APB1ENR_TIM2EN = 0x1
	// The selected clock is disabled
	RCC_APB1ENR_TIM2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM2EN_Enabled = 0x1
	// Position of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Pos = 0x4
	// Bit mask of TIM6EN field.
	RCC_APB1ENR_TIM6EN_Msk = 0x10
	// Bit TIM6EN.
	RCC_APB1ENR_TIM6EN = 0x10
	// The selected clock is disabled
	RCC_APB1ENR_TIM6EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_TIM6EN_Enabled = 0x1
	// Position of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Pos = 0xb
	// Bit mask of WWDGEN field.
	RCC_APB1ENR_WWDGEN_Msk = 0x800
	// Bit WWDGEN.
	RCC_APB1ENR_WWDGEN = 0x800
	// The selected clock is disabled
	RCC_APB1ENR_WWDGEN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_WWDGEN_Enabled = 0x1
	// Position of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Pos = 0xe
	// Bit mask of SPI2EN field.
	RCC_APB1ENR_SPI2EN_Msk = 0x4000
	// Bit SPI2EN.
	RCC_APB1ENR_SPI2EN = 0x4000
	// The selected clock is disabled
	RCC_APB1ENR_SPI2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI2EN_Enabled = 0x1
	// Position of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Pos = 0xf
	// Bit mask of SPI3EN field.
	RCC_APB1ENR_SPI3EN_Msk = 0x8000
	// Bit SPI3EN.
	RCC_APB1ENR_SPI3EN = 0x8000
	// The selected clock is disabled
	RCC_APB1ENR_SPI3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_SPI3EN_Enabled = 0x1
	// Position of USART2EN field.
	RCC_APB1ENR_USART2EN_Pos = 0x11
	// Bit mask of USART2EN field.
	RCC_APB1ENR_USART2EN_Msk = 0x20000
	// Bit USART2EN.
	RCC_APB1ENR_USART2EN = 0x20000
	// The selected clock is disabled
	RCC_APB1ENR_USART2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USART2EN_Enabled = 0x1
	// Position of USART3EN field.
	RCC_APB1ENR_USART3EN_Pos = 0x12
	// Bit mask of USART3EN field.
	RCC_APB1ENR_USART3EN_Msk = 0x40000
	// Bit USART3EN.
	RCC_APB1ENR_USART3EN = 0x40000
	// The selected clock is disabled
	RCC_APB1ENR_USART3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_USART3EN_Enabled = 0x1
	// Position of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Pos = 0x15
	// Bit mask of I2C1EN field.
	RCC_APB1ENR_I2C1EN_Msk = 0x200000
	// Bit I2C1EN.
	RCC_APB1ENR_I2C1EN = 0x200000
	// The selected clock is disabled
	RCC_APB1ENR_I2C1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C1EN_Enabled = 0x1
	// Position of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Pos = 0x16
	// Bit mask of I2C2EN field.
	RCC_APB1ENR_I2C2EN_Msk = 0x400000
	// Bit I2C2EN.
	RCC_APB1ENR_I2C2EN = 0x400000
	// The selected clock is disabled
	RCC_APB1ENR_I2C2EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C2EN_Enabled = 0x1
	// Position of PWREN field.
	RCC_APB1ENR_PWREN_Pos = 0x1c
	// Bit mask of PWREN field.
	RCC_APB1ENR_PWREN_Msk = 0x10000000
	// Bit PWREN.
	RCC_APB1ENR_PWREN = 0x10000000
	// The selected clock is disabled
	RCC_APB1ENR_PWREN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_PWREN_Enabled = 0x1
	// Position of DAC1EN field.
	RCC_APB1ENR_DAC1EN_Pos = 0x1d
	// Bit mask of DAC1EN field.
	RCC_APB1ENR_DAC1EN_Msk = 0x20000000
	// Bit DAC1EN.
	RCC_APB1ENR_DAC1EN = 0x20000000
	// The selected clock is disabled
	RCC_APB1ENR_DAC1EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_DAC1EN_Enabled = 0x1
	// Position of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Pos = 0x1e
	// Bit mask of I2C3EN field.
	RCC_APB1ENR_I2C3EN_Msk = 0x40000000
	// Bit I2C3EN.
	RCC_APB1ENR_I2C3EN = 0x40000000
	// The selected clock is disabled
	RCC_APB1ENR_I2C3EN_Disabled = 0x0
	// The selected clock is enabled
	RCC_APB1ENR_I2C3EN_Enabled = 0x1

	// BDCR: Backup domain control register (RCC_BDCR)
	// Position of LSEON field.
	RCC_BDCR_LSEON_Pos = 0x0
	// Bit mask of LSEON field.
	RCC_BDCR_LSEON_Msk = 0x1
	// Bit LSEON.
	RCC_BDCR_LSEON = 0x1
	// LSE oscillator Off
	RCC_BDCR_LSEON_Off = 0x0
	// LSE oscillator On
	RCC_BDCR_LSEON_On = 0x1
	// Position of LSERDY field.
	RCC_BDCR_LSERDY_Pos = 0x1
	// Bit mask of LSERDY field.
	RCC_BDCR_LSERDY_Msk = 0x2
	// Bit LSERDY.
	RCC_BDCR_LSERDY = 0x2
	// LSE oscillator not ready
	RCC_BDCR_LSERDY_NotReady = 0x0
	// LSE oscillator ready
	RCC_BDCR_LSERDY_Ready = 0x1
	// Position of LSEBYP field.
	RCC_BDCR_LSEBYP_Pos = 0x2
	// Bit mask of LSEBYP field.
	RCC_BDCR_LSEBYP_Msk = 0x4
	// Bit LSEBYP.
	RCC_BDCR_LSEBYP = 0x4
	// LSE crystal oscillator not bypassed
	RCC_BDCR_LSEBYP_NotBypassed = 0x0
	// LSE crystal oscillator bypassed with external clock
	RCC_BDCR_LSEBYP_Bypassed = 0x1
	// Position of LSEDRV field.
	RCC_BDCR_LSEDRV_Pos = 0x3
	// Bit mask of LSEDRV field.
	RCC_BDCR_LSEDRV_Msk = 0x18
	// Low drive capacity
	RCC_BDCR_LSEDRV_Low = 0x0
	// Medium-high drive capacity
	RCC_BDCR_LSEDRV_MediumHigh = 0x1
	// Medium-low drive capacity
	RCC_BDCR_LSEDRV_MediumLow = 0x2
	// High drive capacity
	RCC_BDCR_LSEDRV_High = 0x3
	// Position of RTCSEL field.
	RCC_BDCR_RTCSEL_Pos = 0x8
	// Bit mask of RTCSEL field.
	RCC_BDCR_RTCSEL_Msk = 0x300
	// No clock
	RCC_BDCR_RTCSEL_NoClock = 0x0
	// LSE oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSE = 0x1
	// LSI oscillator clock used as RTC clock
	RCC_BDCR_RTCSEL_LSI = 0x2
	// HSE oscillator clock divided by a prescaler used as RTC clock
	RCC_BDCR_RTCSEL_HSE = 0x3
	// Position of RTCEN field.
	RCC_BDCR_RTCEN_Pos = 0xf
	// Bit mask of RTCEN field.
	RCC_BDCR_RTCEN_Msk = 0x8000
	// Bit RTCEN.
	RCC_BDCR_RTCEN = 0x8000
	// RTC clock disabled
	RCC_BDCR_RTCEN_Disabled = 0x0
	// RTC clock enabled
	RCC_BDCR_RTCEN_Enabled = 0x1
	// Position of BDRST field.
	RCC_BDCR_BDRST_Pos = 0x10
	// Bit mask of BDRST field.
	RCC_BDCR_BDRST_Msk = 0x10000
	// Bit BDRST.
	RCC_BDCR_BDRST = 0x10000
	// Reset not activated
	RCC_BDCR_BDRST_Disabled = 0x0
	// Reset the entire RTC domain
	RCC_BDCR_BDRST_Enabled = 0x1

	// CSR: Control/status register (RCC_CSR)
	// Position of LSION field.
	RCC_CSR_LSION_Pos = 0x0
	// Bit mask of LSION field.
	RCC_CSR_LSION_Msk = 0x1
	// Bit LSION.
	RCC_CSR_LSION = 0x1
	// LSI oscillator Off
	RCC_CSR_LSION_Off = 0x0
	// LSI oscillator On
	RCC_CSR_LSION_On = 0x1
	// Position of LSIRDY field.
	RCC_CSR_LSIRDY_Pos = 0x1
	// Bit mask of LSIRDY field.
	RCC_CSR_LSIRDY_Msk = 0x2
	// Bit LSIRDY.
	RCC_CSR_LSIRDY = 0x2
	// LSI oscillator not ready
	RCC_CSR_LSIRDY_NotReady = 0x0
	// LSI oscillator ready
	RCC_CSR_LSIRDY_Ready = 0x1
	// Position of RMVF field.
	RCC_CSR_RMVF_Pos = 0x18
	// Bit mask of RMVF field.
	RCC_CSR_RMVF_Msk = 0x1000000
	// Bit RMVF.
	RCC_CSR_RMVF = 0x1000000
	// Clears the reset flag
	RCC_CSR_RMVF_Clear = 0x1
	// Position of OBLRSTF field.
	RCC_CSR_OBLRSTF_Pos = 0x19
	// Bit mask of OBLRSTF field.
	RCC_CSR_OBLRSTF_Msk = 0x2000000
	// Bit OBLRSTF.
	RCC_CSR_OBLRSTF = 0x2000000
	// No reset has occured
	RCC_CSR_OBLRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_OBLRSTF_Reset = 0x1
	// Position of PINRSTF field.
	RCC_CSR_PINRSTF_Pos = 0x1a
	// Bit mask of PINRSTF field.
	RCC_CSR_PINRSTF_Msk = 0x4000000
	// Bit PINRSTF.
	RCC_CSR_PINRSTF = 0x4000000
	// No reset has occured
	RCC_CSR_PINRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PINRSTF_Reset = 0x1
	// Position of PORRSTF field.
	RCC_CSR_PORRSTF_Pos = 0x1b
	// Bit mask of PORRSTF field.
	RCC_CSR_PORRSTF_Msk = 0x8000000
	// Bit PORRSTF.
	RCC_CSR_PORRSTF = 0x8000000
	// No reset has occured
	RCC_CSR_PORRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_PORRSTF_Reset = 0x1
	// Position of SFTRSTF field.
	RCC_CSR_SFTRSTF_Pos = 0x1c
	// Bit mask of SFTRSTF field.
	RCC_CSR_SFTRSTF_Msk = 0x10000000
	// Bit SFTRSTF.
	RCC_CSR_SFTRSTF = 0x10000000
	// No reset has occured
	RCC_CSR_SFTRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_SFTRSTF_Reset = 0x1
	// Position of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Pos = 0x1d
	// Bit mask of IWDGRSTF field.
	RCC_CSR_IWDGRSTF_Msk = 0x20000000
	// Bit IWDGRSTF.
	RCC_CSR_IWDGRSTF = 0x20000000
	// No reset has occured
	RCC_CSR_IWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_IWDGRSTF_Reset = 0x1
	// Position of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Pos = 0x1e
	// Bit mask of WWDGRSTF field.
	RCC_CSR_WWDGRSTF_Msk = 0x40000000
	// Bit WWDGRSTF.
	RCC_CSR_WWDGRSTF = 0x40000000
	// No reset has occured
	RCC_CSR_WWDGRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_WWDGRSTF_Reset = 0x1
	// Position of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Pos = 0x1f
	// Bit mask of LPWRRSTF field.
	RCC_CSR_LPWRRSTF_Msk = 0x80000000
	// Bit LPWRRSTF.
	RCC_CSR_LPWRRSTF = 0x80000000
	// No reset has occured
	RCC_CSR_LPWRRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_LPWRRSTF_Reset = 0x1
	// Position of V18PWRRSTF field.
	RCC_CSR_V18PWRRSTF_Pos = 0x17
	// Bit mask of V18PWRRSTF field.
	RCC_CSR_V18PWRRSTF_Msk = 0x800000
	// Bit V18PWRRSTF.
	RCC_CSR_V18PWRRSTF = 0x800000
	// No reset has occured
	RCC_CSR_V18PWRRSTF_NoReset = 0x0
	// A reset has occured
	RCC_CSR_V18PWRRSTF_Reset = 0x1

	// AHBRSTR: AHB peripheral reset register
	// Position of IOPARST field.
	RCC_AHBRSTR_IOPARST_Pos = 0x11
	// Bit mask of IOPARST field.
	RCC_AHBRSTR_IOPARST_Msk = 0x20000
	// Bit IOPARST.
	RCC_AHBRSTR_IOPARST = 0x20000
	// Reset the selected module
	RCC_AHBRSTR_IOPARST_Reset = 0x1
	// Position of IOPBRST field.
	RCC_AHBRSTR_IOPBRST_Pos = 0x12
	// Bit mask of IOPBRST field.
	RCC_AHBRSTR_IOPBRST_Msk = 0x40000
	// Bit IOPBRST.
	RCC_AHBRSTR_IOPBRST = 0x40000
	// Reset the selected module
	RCC_AHBRSTR_IOPBRST_Reset = 0x1
	// Position of IOPCRST field.
	RCC_AHBRSTR_IOPCRST_Pos = 0x13
	// Bit mask of IOPCRST field.
	RCC_AHBRSTR_IOPCRST_Msk = 0x80000
	// Bit IOPCRST.
	RCC_AHBRSTR_IOPCRST = 0x80000
	// Reset the selected module
	RCC_AHBRSTR_IOPCRST_Reset = 0x1
	// Position of IOPDRST field.
	RCC_AHBRSTR_IOPDRST_Pos = 0x14
	// Bit mask of IOPDRST field.
	RCC_AHBRSTR_IOPDRST_Msk = 0x100000
	// Bit IOPDRST.
	RCC_AHBRSTR_IOPDRST = 0x100000
	// Reset the selected module
	RCC_AHBRSTR_IOPDRST_Reset = 0x1
	// Position of IOPFRST field.
	RCC_AHBRSTR_IOPFRST_Pos = 0x16
	// Bit mask of IOPFRST field.
	RCC_AHBRSTR_IOPFRST_Msk = 0x400000
	// Bit IOPFRST.
	RCC_AHBRSTR_IOPFRST = 0x400000
	// Reset the selected module
	RCC_AHBRSTR_IOPFRST_Reset = 0x1
	// Position of TSCRST field.
	RCC_AHBRSTR_TSCRST_Pos = 0x18
	// Bit mask of TSCRST field.
	RCC_AHBRSTR_TSCRST_Msk = 0x1000000
	// Bit TSCRST.
	RCC_AHBRSTR_TSCRST = 0x1000000
	// Reset the selected module
	RCC_AHBRSTR_TSCRST_Reset = 0x1
	// Position of ADC1RST field.
	RCC_AHBRSTR_ADC1RST_Pos = 0x1c
	// Bit mask of ADC1RST field.
	RCC_AHBRSTR_ADC1RST_Msk = 0x10000000
	// Bit ADC1RST.
	RCC_AHBRSTR_ADC1RST = 0x10000000
	// Reset the selected module
	RCC_AHBRSTR_ADC1RST_Reset = 0x1

	// CFGR2: Clock configuration register 2
	// Position of PREDIV field.
	RCC_CFGR2_PREDIV_Pos = 0x0
	// Bit mask of PREDIV field.
	RCC_CFGR2_PREDIV_Msk = 0xf
	// PREDIV input clock not divided
	RCC_CFGR2_PREDIV_Div1 = 0x0
	// PREDIV input clock divided by 2
	RCC_CFGR2_PREDIV_Div2 = 0x1
	// PREDIV input clock divided by 3
	RCC_CFGR2_PREDIV_Div3 = 0x2
	// PREDIV input clock divided by 4
	RCC_CFGR2_PREDIV_Div4 = 0x3
	// PREDIV input clock divided by 5
	RCC_CFGR2_PREDIV_Div5 = 0x4
	// PREDIV input clock divided by 6
	RCC_CFGR2_PREDIV_Div6 = 0x5
	// PREDIV input clock divided by 7
	RCC_CFGR2_PREDIV_Div7 = 0x6
	// PREDIV input clock divided by 8
	RCC_CFGR2_PREDIV_Div8 = 0x7
	// PREDIV input clock divided by 9
	RCC_CFGR2_PREDIV_Div9 = 0x8
	// PREDIV input clock divided by 10
	RCC_CFGR2_PREDIV_Div10 = 0x9
	// PREDIV input clock divided by 11
	RCC_CFGR2_PREDIV_Div11 = 0xa
	// PREDIV input clock divided by 12
	RCC_CFGR2_PREDIV_Div12 = 0xb
	// PREDIV input clock divided by 13
	RCC_CFGR2_PREDIV_Div13 = 0xc
	// PREDIV input clock divided by 14
	RCC_CFGR2_PREDIV_Div14 = 0xd
	// PREDIV input clock divided by 15
	RCC_CFGR2_PREDIV_Div15 = 0xe
	// PREDIV input clock divided by 16
	RCC_CFGR2_PREDIV_Div16 = 0xf
	// Position of ADC1PRES field.
	RCC_CFGR2_ADC1PRES_Pos = 0x4
	// Bit mask of ADC1PRES field.
	RCC_CFGR2_ADC1PRES_Msk = 0x1f0
	// No clock
	RCC_CFGR2_ADC1PRES_NoClock = 0x0
	// PLL clock not divided
	RCC_CFGR2_ADC1PRES_Div1 = 0x10
	// PLL clock divided by 2
	RCC_CFGR2_ADC1PRES_Div2 = 0x11
	// PLL clock divided by 4
	RCC_CFGR2_ADC1PRES_Div4 = 0x12
	// PLL clock divided by 6
	RCC_CFGR2_ADC1PRES_Div6 = 0x13
	// PLL clock divided by 8
	RCC_CFGR2_ADC1PRES_Div8 = 0x14
	// PLL clock divided by 10
	RCC_CFGR2_ADC1PRES_Div10 = 0x15
	// PLL clock divided by 12
	RCC_CFGR2_ADC1PRES_Div12 = 0x16
	// PLL clock divided by 16
	RCC_CFGR2_ADC1PRES_Div16 = 0x17
	// PLL clock divided by 32
	RCC_CFGR2_ADC1PRES_Div32 = 0x18
	// PLL clock divided by 64
	RCC_CFGR2_ADC1PRES_Div64 = 0x19
	// PLL clock divided by 128
	RCC_CFGR2_ADC1PRES_Div128 = 0x1a
	// PLL clock divided by 256
	RCC_CFGR2_ADC1PRES_Div256 = 0x1b

	// CFGR3: Clock configuration register 3
	// Position of USART1SW field.
	RCC_CFGR3_USART1SW_Pos = 0x0
	// Bit mask of USART1SW field.
	RCC_CFGR3_USART1SW_Msk = 0x3
	// PCLK selected as USART clock source
	RCC_CFGR3_USART1SW_PCLK = 0x0
	// SYSCLK selected as USART clock source
	RCC_CFGR3_USART1SW_SYSCLK = 0x1
	// LSE selected as USART clock source
	RCC_CFGR3_USART1SW_LSE = 0x2
	// HSI selected as USART clock source
	RCC_CFGR3_USART1SW_HSI = 0x3
	// Position of I2C1SW field.
	RCC_CFGR3_I2C1SW_Pos = 0x4
	// Bit mask of I2C1SW field.
	RCC_CFGR3_I2C1SW_Msk = 0x10
	// Bit I2C1SW.
	RCC_CFGR3_I2C1SW = 0x10
	// HSI clock selected as I2C clock source
	RCC_CFGR3_I2C1SW_HSI = 0x0
	// SYSCLK clock selected as I2C clock source
	RCC_CFGR3_I2C1SW_SYSCLK = 0x1
	// Position of I2C2SW field.
	RCC_CFGR3_I2C2SW_Pos = 0x5
	// Bit mask of I2C2SW field.
	RCC_CFGR3_I2C2SW_Msk = 0x20
	// Bit I2C2SW.
	RCC_CFGR3_I2C2SW = 0x20
	// HSI clock selected as I2C clock source
	RCC_CFGR3_I2C2SW_HSI = 0x0
	// SYSCLK clock selected as I2C clock source
	RCC_CFGR3_I2C2SW_SYSCLK = 0x1
	// Position of TIM1SW field.
	RCC_CFGR3_TIM1SW_Pos = 0x8
	// Bit mask of TIM1SW field.
	RCC_CFGR3_TIM1SW_Msk = 0x100
	// Bit TIM1SW.
	RCC_CFGR3_TIM1SW = 0x100
	// PCLK2 clock (doubled frequency when prescaled)
	RCC_CFGR3_TIM1SW_PCLK2 = 0x0
	// PLL vco output (running up to 144 MHz)
	RCC_CFGR3_TIM1SW_PLL = 0x1
	// Position of TIM15SW field.
	RCC_CFGR3_TIM15SW_Pos = 0xa
	// Bit mask of TIM15SW field.
	RCC_CFGR3_TIM15SW_Msk = 0x400
	// Bit TIM15SW.
	RCC_CFGR3_TIM15SW = 0x400
	// PCLK2 clock (doubled frequency when prescaled)
	RCC_CFGR3_TIM15SW_PCLK2 = 0x0
	// PLL vco output (running up to 144 MHz)
	RCC_CFGR3_TIM15SW_PLL = 0x1
	// Position of TIM16SW field.
	RCC_CFGR3_TIM16SW_Pos = 0xb
	// Bit mask of TIM16SW field.
	RCC_CFGR3_TIM16SW_Msk = 0x800
	// Bit TIM16SW.
	RCC_CFGR3_TIM16SW = 0x800
	// PCLK2 clock (doubled frequency when prescaled)
	RCC_CFGR3_TIM16SW_PCLK2 = 0x0
	// PLL vco output (running up to 144 MHz)
	RCC_CFGR3_TIM16SW_PLL = 0x1
	// Position of TIM17SW field.
	RCC_CFGR3_TIM17SW_Pos = 0xd
	// Bit mask of TIM17SW field.
	RCC_CFGR3_TIM17SW_Msk = 0x2000
	// Bit TIM17SW.
	RCC_CFGR3_TIM17SW = 0x2000
	// PCLK2 clock (doubled frequency when prescaled)
	RCC_CFGR3_TIM17SW_PCLK2 = 0x0
	// PLL vco output (running up to 144 MHz)
	RCC_CFGR3_TIM17SW_PLL = 0x1
	// Position of I2C3SW field.
	RCC_CFGR3_I2C3SW_Pos = 0x6
	// Bit mask of I2C3SW field.
	RCC_CFGR3_I2C3SW_Msk = 0x40
	// Bit I2C3SW.
	RCC_CFGR3_I2C3SW = 0x40
	// HSI clock selected as I2C clock source
	RCC_CFGR3_I2C3SW_HSI = 0x0
	// SYSCLK clock selected as I2C clock source
	RCC_CFGR3_I2C3SW_SYSCLK = 0x1
)

// Constants for DMA1: DMA controller 1
const (
	// ISR: DMA interrupt status register (DMA_ISR)
	// Position of GIF1 field.
	DMA_ISR_GIF1_Pos = 0x0
	// Bit mask of GIF1 field.
	DMA_ISR_GIF1_Msk = 0x1
	// Bit GIF1.
	DMA_ISR_GIF1 = 0x1
	// No transfer error, half event, complete event
	DMA_ISR_GIF1_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF1_Event = 0x1
	// Position of TCIF1 field.
	DMA_ISR_TCIF1_Pos = 0x1
	// Bit mask of TCIF1 field.
	DMA_ISR_TCIF1_Msk = 0x2
	// Bit TCIF1.
	DMA_ISR_TCIF1 = 0x2
	// No transfer complete event
	DMA_ISR_TCIF1_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF1_Complete = 0x1
	// Position of HTIF1 field.
	DMA_ISR_HTIF1_Pos = 0x2
	// Bit mask of HTIF1 field.
	DMA_ISR_HTIF1_Msk = 0x4
	// Bit HTIF1.
	DMA_ISR_HTIF1 = 0x4
	// No half transfer event
	DMA_ISR_HTIF1_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF1_Half = 0x1
	// Position of TEIF1 field.
	DMA_ISR_TEIF1_Pos = 0x3
	// Bit mask of TEIF1 field.
	DMA_ISR_TEIF1_Msk = 0x8
	// Bit TEIF1.
	DMA_ISR_TEIF1 = 0x8
	// No transfer error
	DMA_ISR_TEIF1_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF1_Error = 0x1
	// Position of GIF2 field.
	DMA_ISR_GIF2_Pos = 0x4
	// Bit mask of GIF2 field.
	DMA_ISR_GIF2_Msk = 0x10
	// Bit GIF2.
	DMA_ISR_GIF2 = 0x10
	// No transfer error, half event, complete event
	DMA_ISR_GIF2_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF2_Event = 0x1
	// Position of TCIF2 field.
	DMA_ISR_TCIF2_Pos = 0x5
	// Bit mask of TCIF2 field.
	DMA_ISR_TCIF2_Msk = 0x20
	// Bit TCIF2.
	DMA_ISR_TCIF2 = 0x20
	// No transfer complete event
	DMA_ISR_TCIF2_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF2_Complete = 0x1
	// Position of HTIF2 field.
	DMA_ISR_HTIF2_Pos = 0x6
	// Bit mask of HTIF2 field.
	DMA_ISR_HTIF2_Msk = 0x40
	// Bit HTIF2.
	DMA_ISR_HTIF2 = 0x40
	// No half transfer event
	DMA_ISR_HTIF2_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF2_Half = 0x1
	// Position of TEIF2 field.
	DMA_ISR_TEIF2_Pos = 0x7
	// Bit mask of TEIF2 field.
	DMA_ISR_TEIF2_Msk = 0x80
	// Bit TEIF2.
	DMA_ISR_TEIF2 = 0x80
	// No transfer error
	DMA_ISR_TEIF2_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF2_Error = 0x1
	// Position of GIF3 field.
	DMA_ISR_GIF3_Pos = 0x8
	// Bit mask of GIF3 field.
	DMA_ISR_GIF3_Msk = 0x100
	// Bit GIF3.
	DMA_ISR_GIF3 = 0x100
	// No transfer error, half event, complete event
	DMA_ISR_GIF3_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF3_Event = 0x1
	// Position of TCIF3 field.
	DMA_ISR_TCIF3_Pos = 0x9
	// Bit mask of TCIF3 field.
	DMA_ISR_TCIF3_Msk = 0x200
	// Bit TCIF3.
	DMA_ISR_TCIF3 = 0x200
	// No transfer complete event
	DMA_ISR_TCIF3_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF3_Complete = 0x1
	// Position of HTIF3 field.
	DMA_ISR_HTIF3_Pos = 0xa
	// Bit mask of HTIF3 field.
	DMA_ISR_HTIF3_Msk = 0x400
	// Bit HTIF3.
	DMA_ISR_HTIF3 = 0x400
	// No half transfer event
	DMA_ISR_HTIF3_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF3_Half = 0x1
	// Position of TEIF3 field.
	DMA_ISR_TEIF3_Pos = 0xb
	// Bit mask of TEIF3 field.
	DMA_ISR_TEIF3_Msk = 0x800
	// Bit TEIF3.
	DMA_ISR_TEIF3 = 0x800
	// No transfer error
	DMA_ISR_TEIF3_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF3_Error = 0x1
	// Position of GIF4 field.
	DMA_ISR_GIF4_Pos = 0xc
	// Bit mask of GIF4 field.
	DMA_ISR_GIF4_Msk = 0x1000
	// Bit GIF4.
	DMA_ISR_GIF4 = 0x1000
	// No transfer error, half event, complete event
	DMA_ISR_GIF4_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF4_Event = 0x1
	// Position of TCIF4 field.
	DMA_ISR_TCIF4_Pos = 0xd
	// Bit mask of TCIF4 field.
	DMA_ISR_TCIF4_Msk = 0x2000
	// Bit TCIF4.
	DMA_ISR_TCIF4 = 0x2000
	// No transfer complete event
	DMA_ISR_TCIF4_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF4_Complete = 0x1
	// Position of HTIF4 field.
	DMA_ISR_HTIF4_Pos = 0xe
	// Bit mask of HTIF4 field.
	DMA_ISR_HTIF4_Msk = 0x4000
	// Bit HTIF4.
	DMA_ISR_HTIF4 = 0x4000
	// No half transfer event
	DMA_ISR_HTIF4_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF4_Half = 0x1
	// Position of TEIF4 field.
	DMA_ISR_TEIF4_Pos = 0xf
	// Bit mask of TEIF4 field.
	DMA_ISR_TEIF4_Msk = 0x8000
	// Bit TEIF4.
	DMA_ISR_TEIF4 = 0x8000
	// No transfer error
	DMA_ISR_TEIF4_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF4_Error = 0x1
	// Position of GIF5 field.
	DMA_ISR_GIF5_Pos = 0x10
	// Bit mask of GIF5 field.
	DMA_ISR_GIF5_Msk = 0x10000
	// Bit GIF5.
	DMA_ISR_GIF5 = 0x10000
	// No transfer error, half event, complete event
	DMA_ISR_GIF5_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF5_Event = 0x1
	// Position of TCIF5 field.
	DMA_ISR_TCIF5_Pos = 0x11
	// Bit mask of TCIF5 field.
	DMA_ISR_TCIF5_Msk = 0x20000
	// Bit TCIF5.
	DMA_ISR_TCIF5 = 0x20000
	// No transfer complete event
	DMA_ISR_TCIF5_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF5_Complete = 0x1
	// Position of HTIF5 field.
	DMA_ISR_HTIF5_Pos = 0x12
	// Bit mask of HTIF5 field.
	DMA_ISR_HTIF5_Msk = 0x40000
	// Bit HTIF5.
	DMA_ISR_HTIF5 = 0x40000
	// No half transfer event
	DMA_ISR_HTIF5_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF5_Half = 0x1
	// Position of TEIF5 field.
	DMA_ISR_TEIF5_Pos = 0x13
	// Bit mask of TEIF5 field.
	DMA_ISR_TEIF5_Msk = 0x80000
	// Bit TEIF5.
	DMA_ISR_TEIF5 = 0x80000
	// No transfer error
	DMA_ISR_TEIF5_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF5_Error = 0x1
	// Position of GIF6 field.
	DMA_ISR_GIF6_Pos = 0x14
	// Bit mask of GIF6 field.
	DMA_ISR_GIF6_Msk = 0x100000
	// Bit GIF6.
	DMA_ISR_GIF6 = 0x100000
	// No transfer error, half event, complete event
	DMA_ISR_GIF6_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF6_Event = 0x1
	// Position of TCIF6 field.
	DMA_ISR_TCIF6_Pos = 0x15
	// Bit mask of TCIF6 field.
	DMA_ISR_TCIF6_Msk = 0x200000
	// Bit TCIF6.
	DMA_ISR_TCIF6 = 0x200000
	// No transfer complete event
	DMA_ISR_TCIF6_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF6_Complete = 0x1
	// Position of HTIF6 field.
	DMA_ISR_HTIF6_Pos = 0x16
	// Bit mask of HTIF6 field.
	DMA_ISR_HTIF6_Msk = 0x400000
	// Bit HTIF6.
	DMA_ISR_HTIF6 = 0x400000
	// No half transfer event
	DMA_ISR_HTIF6_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF6_Half = 0x1
	// Position of TEIF6 field.
	DMA_ISR_TEIF6_Pos = 0x17
	// Bit mask of TEIF6 field.
	DMA_ISR_TEIF6_Msk = 0x800000
	// Bit TEIF6.
	DMA_ISR_TEIF6 = 0x800000
	// No transfer error
	DMA_ISR_TEIF6_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF6_Error = 0x1
	// Position of GIF7 field.
	DMA_ISR_GIF7_Pos = 0x18
	// Bit mask of GIF7 field.
	DMA_ISR_GIF7_Msk = 0x1000000
	// Bit GIF7.
	DMA_ISR_GIF7 = 0x1000000
	// No transfer error, half event, complete event
	DMA_ISR_GIF7_NoEvent = 0x0
	// A transfer error, half event or complete event has occured
	DMA_ISR_GIF7_Event = 0x1
	// Position of TCIF7 field.
	DMA_ISR_TCIF7_Pos = 0x19
	// Bit mask of TCIF7 field.
	DMA_ISR_TCIF7_Msk = 0x2000000
	// Bit TCIF7.
	DMA_ISR_TCIF7 = 0x2000000
	// No transfer complete event
	DMA_ISR_TCIF7_NotComplete = 0x0
	// A transfer complete event has occured
	DMA_ISR_TCIF7_Complete = 0x1
	// Position of HTIF7 field.
	DMA_ISR_HTIF7_Pos = 0x1a
	// Bit mask of HTIF7 field.
	DMA_ISR_HTIF7_Msk = 0x4000000
	// Bit HTIF7.
	DMA_ISR_HTIF7 = 0x4000000
	// No half transfer event
	DMA_ISR_HTIF7_NotHalf = 0x0
	// A half transfer event has occured
	DMA_ISR_HTIF7_Half = 0x1
	// Position of TEIF7 field.
	DMA_ISR_TEIF7_Pos = 0x1b
	// Bit mask of TEIF7 field.
	DMA_ISR_TEIF7_Msk = 0x8000000
	// Bit TEIF7.
	DMA_ISR_TEIF7 = 0x8000000
	// No transfer error
	DMA_ISR_TEIF7_NoError = 0x0
	// A transfer error has occured
	DMA_ISR_TEIF7_Error = 0x1

	// IFCR: DMA interrupt flag clear register (DMA_IFCR)
	// Position of CGIF1 field.
	DMA_IFCR_CGIF1_Pos = 0x0
	// Bit mask of CGIF1 field.
	DMA_IFCR_CGIF1_Msk = 0x1
	// Bit CGIF1.
	DMA_IFCR_CGIF1 = 0x1
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF1_Clear = 0x1
	// Position of CTCIF1 field.
	DMA_IFCR_CTCIF1_Pos = 0x1
	// Bit mask of CTCIF1 field.
	DMA_IFCR_CTCIF1_Msk = 0x2
	// Bit CTCIF1.
	DMA_IFCR_CTCIF1 = 0x2
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF1_Clear = 0x1
	// Position of CHTIF1 field.
	DMA_IFCR_CHTIF1_Pos = 0x2
	// Bit mask of CHTIF1 field.
	DMA_IFCR_CHTIF1_Msk = 0x4
	// Bit CHTIF1.
	DMA_IFCR_CHTIF1 = 0x4
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF1_Clear = 0x1
	// Position of CTEIF1 field.
	DMA_IFCR_CTEIF1_Pos = 0x3
	// Bit mask of CTEIF1 field.
	DMA_IFCR_CTEIF1_Msk = 0x8
	// Bit CTEIF1.
	DMA_IFCR_CTEIF1 = 0x8
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF1_Clear = 0x1
	// Position of CGIF2 field.
	DMA_IFCR_CGIF2_Pos = 0x4
	// Bit mask of CGIF2 field.
	DMA_IFCR_CGIF2_Msk = 0x10
	// Bit CGIF2.
	DMA_IFCR_CGIF2 = 0x10
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF2_Clear = 0x1
	// Position of CTCIF2 field.
	DMA_IFCR_CTCIF2_Pos = 0x5
	// Bit mask of CTCIF2 field.
	DMA_IFCR_CTCIF2_Msk = 0x20
	// Bit CTCIF2.
	DMA_IFCR_CTCIF2 = 0x20
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF2_Clear = 0x1
	// Position of CHTIF2 field.
	DMA_IFCR_CHTIF2_Pos = 0x6
	// Bit mask of CHTIF2 field.
	DMA_IFCR_CHTIF2_Msk = 0x40
	// Bit CHTIF2.
	DMA_IFCR_CHTIF2 = 0x40
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF2_Clear = 0x1
	// Position of CTEIF2 field.
	DMA_IFCR_CTEIF2_Pos = 0x7
	// Bit mask of CTEIF2 field.
	DMA_IFCR_CTEIF2_Msk = 0x80
	// Bit CTEIF2.
	DMA_IFCR_CTEIF2 = 0x80
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF2_Clear = 0x1
	// Position of CGIF3 field.
	DMA_IFCR_CGIF3_Pos = 0x8
	// Bit mask of CGIF3 field.
	DMA_IFCR_CGIF3_Msk = 0x100
	// Bit CGIF3.
	DMA_IFCR_CGIF3 = 0x100
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF3_Clear = 0x1
	// Position of CTCIF3 field.
	DMA_IFCR_CTCIF3_Pos = 0x9
	// Bit mask of CTCIF3 field.
	DMA_IFCR_CTCIF3_Msk = 0x200
	// Bit CTCIF3.
	DMA_IFCR_CTCIF3 = 0x200
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF3_Clear = 0x1
	// Position of CHTIF3 field.
	DMA_IFCR_CHTIF3_Pos = 0xa
	// Bit mask of CHTIF3 field.
	DMA_IFCR_CHTIF3_Msk = 0x400
	// Bit CHTIF3.
	DMA_IFCR_CHTIF3 = 0x400
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF3_Clear = 0x1
	// Position of CTEIF3 field.
	DMA_IFCR_CTEIF3_Pos = 0xb
	// Bit mask of CTEIF3 field.
	DMA_IFCR_CTEIF3_Msk = 0x800
	// Bit CTEIF3.
	DMA_IFCR_CTEIF3 = 0x800
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF3_Clear = 0x1
	// Position of CGIF4 field.
	DMA_IFCR_CGIF4_Pos = 0xc
	// Bit mask of CGIF4 field.
	DMA_IFCR_CGIF4_Msk = 0x1000
	// Bit CGIF4.
	DMA_IFCR_CGIF4 = 0x1000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF4_Clear = 0x1
	// Position of CTCIF4 field.
	DMA_IFCR_CTCIF4_Pos = 0xd
	// Bit mask of CTCIF4 field.
	DMA_IFCR_CTCIF4_Msk = 0x2000
	// Bit CTCIF4.
	DMA_IFCR_CTCIF4 = 0x2000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF4_Clear = 0x1
	// Position of CHTIF4 field.
	DMA_IFCR_CHTIF4_Pos = 0xe
	// Bit mask of CHTIF4 field.
	DMA_IFCR_CHTIF4_Msk = 0x4000
	// Bit CHTIF4.
	DMA_IFCR_CHTIF4 = 0x4000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF4_Clear = 0x1
	// Position of CTEIF4 field.
	DMA_IFCR_CTEIF4_Pos = 0xf
	// Bit mask of CTEIF4 field.
	DMA_IFCR_CTEIF4_Msk = 0x8000
	// Bit CTEIF4.
	DMA_IFCR_CTEIF4 = 0x8000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF4_Clear = 0x1
	// Position of CGIF5 field.
	DMA_IFCR_CGIF5_Pos = 0x10
	// Bit mask of CGIF5 field.
	DMA_IFCR_CGIF5_Msk = 0x10000
	// Bit CGIF5.
	DMA_IFCR_CGIF5 = 0x10000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF5_Clear = 0x1
	// Position of CTCIF5 field.
	DMA_IFCR_CTCIF5_Pos = 0x11
	// Bit mask of CTCIF5 field.
	DMA_IFCR_CTCIF5_Msk = 0x20000
	// Bit CTCIF5.
	DMA_IFCR_CTCIF5 = 0x20000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF5_Clear = 0x1
	// Position of CHTIF5 field.
	DMA_IFCR_CHTIF5_Pos = 0x12
	// Bit mask of CHTIF5 field.
	DMA_IFCR_CHTIF5_Msk = 0x40000
	// Bit CHTIF5.
	DMA_IFCR_CHTIF5 = 0x40000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF5_Clear = 0x1
	// Position of CTEIF5 field.
	DMA_IFCR_CTEIF5_Pos = 0x13
	// Bit mask of CTEIF5 field.
	DMA_IFCR_CTEIF5_Msk = 0x80000
	// Bit CTEIF5.
	DMA_IFCR_CTEIF5 = 0x80000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF5_Clear = 0x1
	// Position of CGIF6 field.
	DMA_IFCR_CGIF6_Pos = 0x14
	// Bit mask of CGIF6 field.
	DMA_IFCR_CGIF6_Msk = 0x100000
	// Bit CGIF6.
	DMA_IFCR_CGIF6 = 0x100000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF6_Clear = 0x1
	// Position of CTCIF6 field.
	DMA_IFCR_CTCIF6_Pos = 0x15
	// Bit mask of CTCIF6 field.
	DMA_IFCR_CTCIF6_Msk = 0x200000
	// Bit CTCIF6.
	DMA_IFCR_CTCIF6 = 0x200000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF6_Clear = 0x1
	// Position of CHTIF6 field.
	DMA_IFCR_CHTIF6_Pos = 0x16
	// Bit mask of CHTIF6 field.
	DMA_IFCR_CHTIF6_Msk = 0x400000
	// Bit CHTIF6.
	DMA_IFCR_CHTIF6 = 0x400000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF6_Clear = 0x1
	// Position of CTEIF6 field.
	DMA_IFCR_CTEIF6_Pos = 0x17
	// Bit mask of CTEIF6 field.
	DMA_IFCR_CTEIF6_Msk = 0x800000
	// Bit CTEIF6.
	DMA_IFCR_CTEIF6 = 0x800000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF6_Clear = 0x1
	// Position of CGIF7 field.
	DMA_IFCR_CGIF7_Pos = 0x18
	// Bit mask of CGIF7 field.
	DMA_IFCR_CGIF7_Msk = 0x1000000
	// Bit CGIF7.
	DMA_IFCR_CGIF7 = 0x1000000
	// Clears the GIF, TEIF, HTIF, TCIF flags in the ISR register
	DMA_IFCR_CGIF7_Clear = 0x1
	// Position of CTCIF7 field.
	DMA_IFCR_CTCIF7_Pos = 0x19
	// Bit mask of CTCIF7 field.
	DMA_IFCR_CTCIF7_Msk = 0x2000000
	// Bit CTCIF7.
	DMA_IFCR_CTCIF7 = 0x2000000
	// Clears the TCIF flag in the ISR register
	DMA_IFCR_CTCIF7_Clear = 0x1
	// Position of CHTIF7 field.
	DMA_IFCR_CHTIF7_Pos = 0x1a
	// Bit mask of CHTIF7 field.
	DMA_IFCR_CHTIF7_Msk = 0x4000000
	// Bit CHTIF7.
	DMA_IFCR_CHTIF7 = 0x4000000
	// Clears the HTIF flag in the ISR register
	DMA_IFCR_CHTIF7_Clear = 0x1
	// Position of CTEIF7 field.
	DMA_IFCR_CTEIF7_Pos = 0x1b
	// Bit mask of CTEIF7 field.
	DMA_IFCR_CTEIF7_Msk = 0x8000000
	// Bit CTEIF7.
	DMA_IFCR_CTEIF7 = 0x8000000
	// Clears the TEIF flag in the ISR register
	DMA_IFCR_CTEIF7_Clear = 0x1

	// CH.CR: DMA channel configuration register (DMA_CCR)
	// Position of EN field.
	DMA_CH_CR_EN_Pos = 0x0
	// Bit mask of EN field.
	DMA_CH_CR_EN_Msk = 0x1
	// Bit EN.
	DMA_CH_CR_EN = 0x1
	// Channel disabled
	DMA_CH_CR_EN_Disabled = 0x0
	// Channel enabled
	DMA_CH_CR_EN_Enabled = 0x1
	// Position of TCIE field.
	DMA_CH_CR_TCIE_Pos = 0x1
	// Bit mask of TCIE field.
	DMA_CH_CR_TCIE_Msk = 0x2
	// Bit TCIE.
	DMA_CH_CR_TCIE = 0x2
	// Transfer Complete interrupt disabled
	DMA_CH_CR_TCIE_Disabled = 0x0
	// Transfer Complete interrupt enabled
	DMA_CH_CR_TCIE_Enabled = 0x1
	// Position of HTIE field.
	DMA_CH_CR_HTIE_Pos = 0x2
	// Bit mask of HTIE field.
	DMA_CH_CR_HTIE_Msk = 0x4
	// Bit HTIE.
	DMA_CH_CR_HTIE = 0x4
	// Half Transfer interrupt disabled
	DMA_CH_CR_HTIE_Disabled = 0x0
	// Half Transfer interrupt enabled
	DMA_CH_CR_HTIE_Enabled = 0x1
	// Position of TEIE field.
	DMA_CH_CR_TEIE_Pos = 0x3
	// Bit mask of TEIE field.
	DMA_CH_CR_TEIE_Msk = 0x8
	// Bit TEIE.
	DMA_CH_CR_TEIE = 0x8
	// Transfer Error interrupt disabled
	DMA_CH_CR_TEIE_Disabled = 0x0
	// Transfer Error interrupt enabled
	DMA_CH_CR_TEIE_Enabled = 0x1
	// Position of DIR field.
	DMA_CH_CR_DIR_Pos = 0x4
	// Bit mask of DIR field.
	DMA_CH_CR_DIR_Msk = 0x10
	// Bit DIR.
	DMA_CH_CR_DIR = 0x10
	// Read from peripheral
	DMA_CH_CR_DIR_FromPeripheral = 0x0
	// Read from memory
	DMA_CH_CR_DIR_FromMemory = 0x1
	// Position of CIRC field.
	DMA_CH_CR_CIRC_Pos = 0x5
	// Bit mask of CIRC field.
	DMA_CH_CR_CIRC_Msk = 0x20
	// Bit CIRC.
	DMA_CH_CR_CIRC = 0x20
	// Circular buffer disabled
	DMA_CH_CR_CIRC_Disabled = 0x0
	// Circular buffer enabled
	DMA_CH_CR_CIRC_Enabled = 0x1
	// Position of PINC field.
	DMA_CH_CR_PINC_Pos = 0x6
	// Bit mask of PINC field.
	DMA_CH_CR_PINC_Msk = 0x40
	// Bit PINC.
	DMA_CH_CR_PINC = 0x40
	// Increment mode disabled
	DMA_CH_CR_PINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CH_CR_PINC_Enabled = 0x1
	// Position of MINC field.
	DMA_CH_CR_MINC_Pos = 0x7
	// Bit mask of MINC field.
	DMA_CH_CR_MINC_Msk = 0x80
	// Bit MINC.
	DMA_CH_CR_MINC = 0x80
	// Increment mode disabled
	DMA_CH_CR_MINC_Disabled = 0x0
	// Increment mode enabled
	DMA_CH_CR_MINC_Enabled = 0x1
	// Position of PSIZE field.
	DMA_CH_CR_PSIZE_Pos = 0x8
	// Bit mask of PSIZE field.
	DMA_CH_CR_PSIZE_Msk = 0x300
	// 8-bit size
	DMA_CH_CR_PSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CH_CR_PSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CH_CR_PSIZE_Bits32 = 0x2
	// Position of MSIZE field.
	DMA_CH_CR_MSIZE_Pos = 0xa
	// Bit mask of MSIZE field.
	DMA_CH_CR_MSIZE_Msk = 0xc00
	// 8-bit size
	DMA_CH_CR_MSIZE_Bits8 = 0x0
	// 16-bit size
	DMA_CH_CR_MSIZE_Bits16 = 0x1
	// 32-bit size
	DMA_CH_CR_MSIZE_Bits32 = 0x2
	// Position of PL field.
	DMA_CH_CR_PL_Pos = 0xc
	// Bit mask of PL field.
	DMA_CH_CR_PL_Msk = 0x3000
	// Low priority
	DMA_CH_CR_PL_Low = 0x0
	// Medium priority
	DMA_CH_CR_PL_Medium = 0x1
	// High priority
	DMA_CH_CR_PL_High = 0x2
	// Very high priority
	DMA_CH_CR_PL_VeryHigh = 0x3
	// Position of MEM2MEM field.
	DMA_CH_CR_MEM2MEM_Pos = 0xe
	// Bit mask of MEM2MEM field.
	DMA_CH_CR_MEM2MEM_Msk = 0x4000
	// Bit MEM2MEM.
	DMA_CH_CR_MEM2MEM = 0x4000
	// Memory to memory mode disabled
	DMA_CH_CR_MEM2MEM_Disabled = 0x0
	// Memory to memory mode enabled
	DMA_CH_CR_MEM2MEM_Enabled = 0x1

	// CH.NDTR: DMA channel 1 number of data register
	// Position of NDT field.
	DMA_CH_NDTR_NDT_Pos = 0x0
	// Bit mask of NDT field.
	DMA_CH_NDTR_NDT_Msk = 0xffff

	// CH.PAR: DMA channel 1 peripheral address register
	// Position of PA field.
	DMA_CH_PAR_PA_Pos = 0x0
	// Bit mask of PA field.
	DMA_CH_PAR_PA_Msk = 0xffffffff

	// CH.MAR: DMA channel 1 memory address register
	// Position of MA field.
	DMA_CH_MAR_MA_Pos = 0x0
	// Bit mask of MA field.
	DMA_CH_MAR_MA_Msk = 0xffffffff
)

// Constants for TIM2: General purpose timer
const (
	// CR1: control register 1
	// Position of UIFREMAP field.
	TIM_CR1_UIFREMAP_Pos = 0xb
	// Bit mask of UIFREMAP field.
	TIM_CR1_UIFREMAP_Msk = 0x1800
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// t_DTS = t_CK_INT
	TIM_CR1_CKD_Div1 = 0x0
	// t_DTS = 2 × t_CK_INT
	TIM_CR1_CKD_Div2 = 0x1
	// t_DTS = 4 × t_CK_INT
	TIM_CR1_CKD_Div4 = 0x2
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// TIMx_APRR register is not buffered
	TIM_CR1_ARPE_Disabled = 0x0
	// TIMx_APRR register is buffered
	TIM_CR1_ARPE_Enabled = 0x1
	// Position of CMS field.
	TIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIM_CR1_CMS_Msk = 0x60
	// The counter counts up or down depending on the direction bit
	TIM_CR1_CMS_EdgeAligned = 0x0
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting down.
	TIM_CR1_CMS_CenterAligned1 = 0x1
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting up.
	TIM_CR1_CMS_CenterAligned2 = 0x2
	// The counter counts up and down alternatively. Output compare interrupt flags are set both when the counter is counting up or down.
	TIM_CR1_CMS_CenterAligned3 = 0x3
	// Position of DIR field.
	TIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIM_CR1_DIR = 0x10
	// Counter used as upcounter
	TIM_CR1_DIR_Up = 0x0
	// Counter used as downcounter
	TIM_CR1_DIR_Down = 0x1
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Counter is not stopped at update event
	TIM_CR1_OPM_Disabled = 0x0
	// Counter stops counting at the next update event (clearing the CEN bit)
	TIM_CR1_OPM_Enabled = 0x1
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Any of counter overflow/underflow, setting UG, or update through slave mode, generates an update interrupt or DMA request
	TIM_CR1_URS_AnyEvent = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request
	TIM_CR1_URS_CounterOnly = 0x1
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// Update event enabled
	TIM_CR1_UDIS_Enabled = 0x0
	// Update event disabled
	TIM_CR1_UDIS_Disabled = 0x1
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1
	// Counter disabled
	TIM_CR1_CEN_Disabled = 0x0
	// Counter enabled
	TIM_CR1_CEN_Enabled = 0x1

	// CR2: control register 2
	// Position of TI1S field.
	TIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIM_CR2_TI1S = 0x80
	// The TIMx_CH1 pin is connected to TI1 input
	TIM_CR2_TI1S_Normal = 0x0
	// The TIMx_CH1, CH2, CH3 pins are connected to TI1 input
	TIM_CR2_TI1S_XOR = 0x1
	// Position of MMS field.
	TIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_CR2_MMS_Msk = 0x70
	// The UG bit from the TIMx_EGR register is used as trigger output
	TIM_CR2_MMS_Reset = 0x0
	// The counter enable signal, CNT_EN, is used as trigger output
	TIM_CR2_MMS_Enable = 0x1
	// The update event is selected as trigger output
	TIM_CR2_MMS_Update = 0x2
	// The trigger output send a positive pulse when the CC1IF flag it to be set, as soon as a capture or a compare match occurred
	TIM_CR2_MMS_ComparePulse = 0x3
	// OC1REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC1 = 0x4
	// OC2REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC2 = 0x5
	// OC3REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC3 = 0x6
	// OC4REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC4 = 0x7
	// Position of CCDS field.
	TIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_CR2_CCDS = 0x8
	// CCx DMA request sent when CCx event occurs
	TIM_CR2_CCDS_OnCompare = 0x0
	// CCx DMA request sent when update event occurs
	TIM_CR2_CCDS_OnUpdate = 0x1

	// SMCR: slave mode control register
	// Position of SMS_3 field.
	TIM_SMCR_SMS_3_Pos = 0x10
	// Bit mask of SMS_3 field.
	TIM_SMCR_SMS_3_Msk = 0x10000
	// Bit SMS_3.
	TIM_SMCR_SMS_3 = 0x10000
	// Position of ETP field.
	TIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_SMCR_ETP = 0x8000
	// ETR is noninverted, active at high level or rising edge
	TIM_SMCR_ETP_NotInverted = 0x0
	// ETR is inverted, active at low level or falling edge
	TIM_SMCR_ETP_Inverted = 0x1
	// Position of ECE field.
	TIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_SMCR_ECE = 0x4000
	// External clock mode 2 disabled
	TIM_SMCR_ECE_Disabled = 0x0
	// External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal.
	TIM_SMCR_ECE_Enabled = 0x1
	// Position of ETPS field.
	TIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000
	// Prescaler OFF
	TIM_SMCR_ETPS_Div1 = 0x0
	// ETRP frequency divided by 2
	TIM_SMCR_ETPS_Div2 = 0x1
	// ETRP frequency divided by 4
	TIM_SMCR_ETPS_Div4 = 0x2
	// ETRP frequency divided by 8
	TIM_SMCR_ETPS_Div8 = 0x3
	// Position of ETF field.
	TIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_SMCR_ETF_Msk = 0xf00
	// No filter, sampling is done at fDTS
	TIM_SMCR_ETF_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_SMCR_ETF_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_SMCR_ETF_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_SMCR_ETF_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_SMCR_ETF_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_SMCR_ETF_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_SMCR_ETF_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_SMCR_ETF_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_SMCR_ETF_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_SMCR_ETF_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_SMCR_ETF_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_SMCR_ETF_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_SMCR_ETF_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_SMCR_ETF_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_SMCR_ETF_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_SMCR_ETF_FDTS_Div32_N8 = 0xf
	// Position of MSM field.
	TIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIM_SMCR_MSM = 0x80
	// No action
	TIM_SMCR_MSM_NoSync = 0x0
	// The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event.
	TIM_SMCR_MSM_Sync = 0x1
	// Position of TS field.
	TIM_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	TIM_SMCR_TS_Msk = 0x70
	// Internal Trigger 0 (ITR0)
	TIM_SMCR_TS_ITR0 = 0x0
	// Internal Trigger 1 (ITR1)
	TIM_SMCR_TS_ITR1 = 0x1
	// Internal Trigger 2 (ITR2)
	TIM_SMCR_TS_ITR2 = 0x2
	// TI1 Edge Detector (TI1F_ED)
	TIM_SMCR_TS_TI1F_ED = 0x4
	// Filtered Timer Input 1 (TI1FP1)
	TIM_SMCR_TS_TI1FP1 = 0x5
	// Filtered Timer Input 2 (TI2FP2)
	TIM_SMCR_TS_TI2FP2 = 0x6
	// External Trigger input (ETRF)
	TIM_SMCR_TS_ETRF = 0x7
	// Position of OCCS field.
	TIM_SMCR_OCCS_Pos = 0x3
	// Bit mask of OCCS field.
	TIM_SMCR_OCCS_Msk = 0x8
	// Bit OCCS.
	TIM_SMCR_OCCS = 0x8
	// Position of SMS field.
	TIM_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	TIM_SMCR_SMS_Msk = 0x7
	// Slave mode disabled - if CEN = ‘1 then the prescaler is clocked directly by the internal clock.
	TIM_SMCR_SMS_Disabled = 0x0
	// Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2 level.
	TIM_SMCR_SMS_Encoder_Mode_1 = 0x1
	// Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1 level.
	TIM_SMCR_SMS_Encoder_Mode_2 = 0x2
	// Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input.
	TIM_SMCR_SMS_Encoder_Mode_3 = 0x3
	// Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers.
	TIM_SMCR_SMS_Reset_Mode = 0x4
	// Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled.
	TIM_SMCR_SMS_Gated_Mode = 0x5
	// Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled.
	TIM_SMCR_SMS_Trigger_Mode = 0x6
	// External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
	TIM_SMCR_SMS_Ext_Clock_Mode = 0x7

	// DIER: DMA/Interrupt enable register
	// Position of TDE field.
	TIM_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	TIM_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	TIM_DIER_TDE = 0x4000
	// Trigger DMA request disabled
	TIM_DIER_TDE_Disabled = 0x0
	// Trigger DMA request enabled
	TIM_DIER_TDE_Enabled = 0x1
	// Position of CC4DE field.
	TIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIM_DIER_CC4DE = 0x1000
	// CCx DMA request disabled
	TIM_DIER_CC4DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC4DE_Enabled = 0x1
	// Position of CC3DE field.
	TIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIM_DIER_CC3DE = 0x800
	// CCx DMA request disabled
	TIM_DIER_CC3DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC3DE_Enabled = 0x1
	// Position of CC2DE field.
	TIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIM_DIER_CC2DE = 0x400
	// CCx DMA request disabled
	TIM_DIER_CC2DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC2DE_Enabled = 0x1
	// Position of CC1DE field.
	TIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_DIER_CC1DE = 0x200
	// CCx DMA request disabled
	TIM_DIER_CC1DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC1DE_Enabled = 0x1
	// Position of UDE field.
	TIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_DIER_UDE = 0x100
	// Update DMA request disabled
	TIM_DIER_UDE_Disabled = 0x0
	// Update DMA request enabled
	TIM_DIER_UDE_Enabled = 0x1
	// Position of TIE field.
	TIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIM_DIER_TIE = 0x40
	// Trigger interrupt disabled
	TIM_DIER_TIE_Disabled = 0x0
	// Trigger interrupt enabled
	TIM_DIER_TIE_Enabled = 0x1
	// Position of CC4IE field.
	TIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIM_DIER_CC4IE = 0x10
	// CCx interrupt disabled
	TIM_DIER_CC4IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC4IE_Enabled = 0x1
	// Position of CC3IE field.
	TIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIM_DIER_CC3IE = 0x8
	// CCx interrupt disabled
	TIM_DIER_CC3IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC3IE_Enabled = 0x1
	// Position of CC2IE field.
	TIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIM_DIER_CC2IE = 0x4
	// CCx interrupt disabled
	TIM_DIER_CC2IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC2IE_Enabled = 0x1
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2
	// CCx interrupt disabled
	TIM_DIER_CC1IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC1IE_Enabled = 0x1
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1
	// Update interrupt disabled
	TIM_DIER_UIE_Disabled = 0x0
	// Update interrupt enabled
	TIM_DIER_UIE_Enabled = 0x1

	// SR: status register
	// Position of CC4OF field.
	TIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIM_SR_CC4OF = 0x1000
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC4OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC4OF_Clear = 0x0
	// Position of CC3OF field.
	TIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIM_SR_CC3OF = 0x800
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC3OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC3OF_Clear = 0x0
	// Position of CC2OF field.
	TIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIM_SR_CC2OF = 0x400
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC2OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC2OF_Clear = 0x0
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC1OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC1OF_Clear = 0x0
	// Position of TIF field.
	TIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIM_SR_TIF = 0x40
	// No trigger event occurred
	TIM_SR_TIF_NoTrigger = 0x0
	// Trigger interrupt pending
	TIM_SR_TIF_Trigger = 0x1
	// Clear flag
	TIM_SR_TIF_Clear = 0x0
	// Position of CC4IF field.
	TIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIM_SR_CC4IF = 0x10
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC4IF_Match = 0x1
	// Clear flag
	TIM_SR_CC4IF_Clear = 0x0
	// Position of CC3IF field.
	TIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIM_SR_CC3IF = 0x8
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC3IF_Match = 0x1
	// Clear flag
	TIM_SR_CC3IF_Clear = 0x0
	// Position of CC2IF field.
	TIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIM_SR_CC2IF = 0x4
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC2IF_Match = 0x1
	// Clear flag
	TIM_SR_CC2IF_Clear = 0x0
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC1IF_Match = 0x1
	// Clear flag
	TIM_SR_CC1IF_Clear = 0x0
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1
	// No update occurred
	TIM_SR_UIF_Clear = 0x0
	// Update interrupt pending.
	TIM_SR_UIF_UpdatePending = 0x1

	// EGR: event generation register
	// Position of TG field.
	TIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIM_EGR_TG_Msk = 0x40
	// Bit TG.
	TIM_EGR_TG = 0x40
	// The TIF flag is set in TIMx_SR register. Related interrupt or DMA transfer can occur if enabled.
	TIM_EGR_TG_Trigger = 0x1
	// Position of CC4G field.
	TIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIM_EGR_CC4G = 0x10
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC4G_Trigger = 0x1
	// Position of CC3G field.
	TIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIM_EGR_CC3G = 0x8
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC3G_Trigger = 0x1
	// Position of CC2G field.
	TIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIM_EGR_CC2G = 0x4
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC2G_Trigger = 0x1
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC1G_Trigger = 0x1
	// Position of UG field.
	TIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_EGR_UG = 0x1
	// Re-initializes the timer counter and generates an update of the registers.
	TIM_EGR_UG_Update = 0x1

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of OC2M_3 field.
	TIM_CCMR1_Output_OC2M_3_Pos = 0x18
	// Bit mask of OC2M_3 field.
	TIM_CCMR1_Output_OC2M_3_Msk = 0x1000000
	// Bit OC2M_3.
	TIM_CCMR1_Output_OC2M_3 = 0x1000000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR1_Output_OC2M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR1_Output_OC2M_3_Extended = 0x1
	// Position of OC1M_3 field.
	TIM_CCMR1_Output_OC1M_3_Pos = 0x10
	// Bit mask of OC1M_3 field.
	TIM_CCMR1_Output_OC1M_3_Msk = 0x10000
	// Bit OC1M_3.
	TIM_CCMR1_Output_OC1M_3 = 0x10000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR1_Output_OC1M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR1_Output_OC1M_3_Extended = 0x1
	// Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	TIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR1_Output_OC2M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR1_Output_OC2M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR1_Output_OC2M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR1_Output_OC2M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR1_Output_OC2M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR1_Output_OC2M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR1_Output_OC2M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR1_Output_OC2M_PwmMode2 = 0x7
	// Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	TIM_CCMR1_Output_OC2PE = 0x800
	// Preload register on CCR2 disabled. New values written to CCR2 are taken into account immediately
	TIM_CCMR1_Output_OC2PE_Disabled = 0x0
	// Preload register on CCR2 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC2PE_Enabled = 0x1
	// Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	TIM_CCMR1_Output_OC2FE = 0x400
	// Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIM_CCMR1_Output_CC2S_Output = 0x0
	// Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIM_CCMR1_Output_OC1CE = 0x80
	// Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR1_Output_OC1M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR1_Output_OC1M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR1_Output_OC1M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR1_Output_OC1M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR1_Output_OC1M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR1_Output_OC1M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR1_Output_OC1M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR1_Output_OC1M_PwmMode2 = 0x7
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Preload register on CCR1 disabled. New values written to CCR1 are taken into account immediately
	TIM_CCMR1_Output_OC1PE_Disabled = 0x0
	// Preload register on CCR1 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC1PE_Enabled = 0x1
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIM_CCMR1_Output_CC1S_Output = 0x0

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk = 0xf000
	// Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk = 0x300
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIM_CCMR1_Input_CC2S_TI2 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIM_CCMR1_Input_CC2S_TI1 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC
	TIM_CCMR1_Input_CC2S_TRC = 0x3
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0
	// No filter, sampling is done at fDTS
	TIM_CCMR1_Input_IC1F_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_CCMR1_Input_IC1F_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_CCMR1_Input_IC1F_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_CCMR1_Input_IC1F_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N8 = 0xf
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIM_CCMR1_Input_CC1S_TI1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIM_CCMR1_Input_CC1S_TI2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC
	TIM_CCMR1_Input_CC1S_TRC = 0x3

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of OC4M_3 field.
	TIM_CCMR2_Output_OC4M_3_Pos = 0x18
	// Bit mask of OC4M_3 field.
	TIM_CCMR2_Output_OC4M_3_Msk = 0x1000000
	// Bit OC4M_3.
	TIM_CCMR2_Output_OC4M_3 = 0x1000000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR2_Output_OC4M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR2_Output_OC4M_3_Extended = 0x1
	// Position of OC3M_3 field.
	TIM_CCMR2_Output_OC3M_3_Pos = 0x10
	// Bit mask of OC3M_3 field.
	TIM_CCMR2_Output_OC3M_3_Msk = 0x10000
	// Bit OC3M_3.
	TIM_CCMR2_Output_OC3M_3 = 0x10000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR2_Output_OC3M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR2_Output_OC3M_3_Extended = 0x1
	// Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	TIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR2_Output_OC4M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR2_Output_OC4M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR2_Output_OC4M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR2_Output_OC4M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR2_Output_OC4M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR2_Output_OC4M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC4M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR2_Output_OC4M_PwmMode2 = 0x7
	// Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	TIM_CCMR2_Output_OC4PE = 0x800
	// Preload register on CCR4 disabled. New values written to CCR4 are taken into account immediately
	TIM_CCMR2_Output_OC4PE_Disabled = 0x0
	// Preload register on CCR4 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC4PE_Enabled = 0x1
	// Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	TIM_CCMR2_Output_OC4FE = 0x400
	// Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIM_CCMR2_Output_CC4S_Output = 0x0
	// Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	TIM_CCMR2_Output_OC3CE = 0x80
	// Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR2_Output_OC3M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR2_Output_OC3M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR2_Output_OC3M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR2_Output_OC3M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR2_Output_OC3M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR2_Output_OC3M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC3M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR2_Output_OC3M_PwmMode2 = 0x7
	// Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	TIM_CCMR2_Output_OC3PE = 0x8
	// Preload register on CCR3 disabled. New values written to CCR3 are taken into account immediately
	TIM_CCMR2_Output_OC3PE_Disabled = 0x0
	// Preload register on CCR3 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC3PE_Enabled = 0x1
	// Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	TIM_CCMR2_Output_OC3FE = 0x4
	// Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIM_CCMR2_Output_CC3S_Output = 0x0

	// CCMR2_Input: capture/compare mode register 2 (input mode)
	// Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk = 0xf000
	// Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk = 0x300
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIM_CCMR2_Input_CC4S_TI4 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIM_CCMR2_Input_CC4S_TI3 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC
	TIM_CCMR2_Input_CC4S_TRC = 0x3
	// Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk = 0x3
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIM_CCMR2_Input_CC3S_TI3 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIM_CCMR2_Input_CC3S_TI4 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC
	TIM_CCMR2_Input_CC3S_TRC = 0x3

	// CCER: capture/compare enable register
	// Position of CC1E field.
	TIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_CCER_CC1E = 0x1
	// Position of CC1P field.
	TIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_CCER_CC1P = 0x2
	// Position of CC1NP field.
	TIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_CCER_CC1NP = 0x8
	// Position of CC2E field.
	TIM_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	TIM_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	TIM_CCER_CC2E = 0x10
	// Position of CC2P field.
	TIM_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	TIM_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	TIM_CCER_CC2P = 0x20
	// Position of CC2NP field.
	TIM_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	TIM_CCER_CC2NP = 0x80
	// Position of CC3E field.
	TIM_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	TIM_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	TIM_CCER_CC3E = 0x100
	// Position of CC3P field.
	TIM_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	TIM_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	TIM_CCER_CC3P = 0x200
	// Position of CC3NP field.
	TIM_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	TIM_CCER_CC3NP = 0x800
	// Position of CC4E field.
	TIM_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	TIM_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	TIM_CCER_CC4E = 0x1000
	// Position of CC4P field.
	TIM_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	TIM_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	TIM_CCER_CC4P = 0x2000
	// Position of CC4NP field.
	TIM_CCER_CC4NP_Pos = 0xf
	// Bit mask of CC4NP field.
	TIM_CCER_CC4NP_Msk = 0x8000
	// Bit CC4NP.
	TIM_CCER_CC4NP = 0x8000

	// CNT: counter
	// Position of CNT field.
	TIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIM_CNT_CNT_Msk = 0xffffffff

	// PSC: prescaler
	// Position of PSC field.
	TIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR field.
	TIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIM_ARR_ARR_Msk = 0xffffffff

	// CCR1: capture/compare register
	// Position of CCR field.
	TIM_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIM_CCR_CCR_Msk = 0xffffffff

	// DCR: DMA control register
	// Position of DBL field.
	TIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	TIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIM_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffff
)

// Constants for USART1: Universal synchronous asynchronous receiver transmitter
const (
	// CR1: Control register 1
	// Position of EOBIE field.
	USART_CR1_EOBIE_Pos = 0x1b
	// Bit mask of EOBIE field.
	USART_CR1_EOBIE_Msk = 0x8000000
	// Bit EOBIE.
	USART_CR1_EOBIE = 0x8000000
	// Interrupt is inhibited
	USART_CR1_EOBIE_Disabled = 0x0
	// A USART interrupt is generated when the EOBF flag is set in the ISR register
	USART_CR1_EOBIE_Enabled = 0x1
	// Position of RTOIE field.
	USART_CR1_RTOIE_Pos = 0x1a
	// Bit mask of RTOIE field.
	USART_CR1_RTOIE_Msk = 0x4000000
	// Bit RTOIE.
	USART_CR1_RTOIE = 0x4000000
	// Interrupt is inhibited
	USART_CR1_RTOIE_Disabled = 0x0
	// An USART interrupt is generated when the RTOF bit is set in the ISR register
	USART_CR1_RTOIE_Enabled = 0x1
	// Position of DEAT field.
	USART_CR1_DEAT_Pos = 0x15
	// Bit mask of DEAT field.
	USART_CR1_DEAT_Msk = 0x3e00000
	// Position of DEDT field.
	USART_CR1_DEDT_Pos = 0x10
	// Bit mask of DEDT field.
	USART_CR1_DEDT_Msk = 0x1f0000
	// Position of OVER8 field.
	USART_CR1_OVER8_Pos = 0xf
	// Bit mask of OVER8 field.
	USART_CR1_OVER8_Msk = 0x8000
	// Bit OVER8.
	USART_CR1_OVER8 = 0x8000
	// Oversampling by 16
	USART_CR1_OVER8_Oversampling16 = 0x0
	// Oversampling by 8
	USART_CR1_OVER8_Oversampling8 = 0x1
	// Position of CMIE field.
	USART_CR1_CMIE_Pos = 0xe
	// Bit mask of CMIE field.
	USART_CR1_CMIE_Msk = 0x4000
	// Bit CMIE.
	USART_CR1_CMIE = 0x4000
	// Interrupt is disabled
	USART_CR1_CMIE_Disabled = 0x0
	// Interrupt is generated when the CMF bit is set in the ISR register
	USART_CR1_CMIE_Enabled = 0x1
	// Position of MME field.
	USART_CR1_MME_Pos = 0xd
	// Bit mask of MME field.
	USART_CR1_MME_Msk = 0x2000
	// Bit MME.
	USART_CR1_MME = 0x2000
	// Receiver in active mode permanently
	USART_CR1_MME_Disabled = 0x0
	// Receiver can switch between mute mode and active mode
	USART_CR1_MME_Enabled = 0x1
	// Position of M field.
	USART_CR1_M_Pos = 0xc
	// Bit mask of M field.
	USART_CR1_M_Msk = 0x1000
	// Bit M.
	USART_CR1_M = 0x1000
	// 1 start bit, 8 data bits, n stop bits
	USART_CR1_M_Bit8 = 0x0
	// 1 start bit, 9 data bits, n stop bits
	USART_CR1_M_Bit9 = 0x1
	// Position of WAKE field.
	USART_CR1_WAKE_Pos = 0xb
	// Bit mask of WAKE field.
	USART_CR1_WAKE_Msk = 0x800
	// Bit WAKE.
	USART_CR1_WAKE = 0x800
	// Idle line
	USART_CR1_WAKE_Idle = 0x0
	// Address mask
	USART_CR1_WAKE_Address = 0x1
	// Position of PCE field.
	USART_CR1_PCE_Pos = 0xa
	// Bit mask of PCE field.
	USART_CR1_PCE_Msk = 0x400
	// Bit PCE.
	USART_CR1_PCE = 0x400
	// Parity control disabled
	USART_CR1_PCE_Disabled = 0x0
	// Parity control enabled
	USART_CR1_PCE_Enabled = 0x1
	// Position of PS field.
	USART_CR1_PS_Pos = 0x9
	// Bit mask of PS field.
	USART_CR1_PS_Msk = 0x200
	// Bit PS.
	USART_CR1_PS = 0x200
	// Even parity
	USART_CR1_PS_Even = 0x0
	// Odd parity
	USART_CR1_PS_Odd = 0x1
	// Position of PEIE field.
	USART_CR1_PEIE_Pos = 0x8
	// Bit mask of PEIE field.
	USART_CR1_PEIE_Msk = 0x100
	// Bit PEIE.
	USART_CR1_PEIE = 0x100
	// Interrupt is disabled
	USART_CR1_PEIE_Disabled = 0x0
	// Interrupt is generated whenever PE=1 in the ISR register
	USART_CR1_PEIE_Enabled = 0x1
	// Position of TXEIE field.
	USART_CR1_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	USART_CR1_TXEIE_Msk = 0x80
	// Bit TXEIE.
	USART_CR1_TXEIE = 0x80
	// Interrupt is disabled
	USART_CR1_TXEIE_Disabled = 0x0
	// Interrupt is generated whenever TXE=1 in the ISR register
	USART_CR1_TXEIE_Enabled = 0x1
	// Position of TCIE field.
	USART_CR1_TCIE_Pos = 0x6
	// Bit mask of TCIE field.
	USART_CR1_TCIE_Msk = 0x40
	// Bit TCIE.
	USART_CR1_TCIE = 0x40
	// Interrupt is disabled
	USART_CR1_TCIE_Disabled = 0x0
	// Interrupt is generated whenever TC=1 in the ISR register
	USART_CR1_TCIE_Enabled = 0x1
	// Position of RXNEIE field.
	USART_CR1_RXNEIE_Pos = 0x5
	// Bit mask of RXNEIE field.
	USART_CR1_RXNEIE_Msk = 0x20
	// Bit RXNEIE.
	USART_CR1_RXNEIE = 0x20
	// Interrupt is disabled
	USART_CR1_RXNEIE_Disabled = 0x0
	// Interrupt is generated whenever ORE=1 or RXNE=1 in the ISR register
	USART_CR1_RXNEIE_Enabled = 0x1
	// Position of IDLEIE field.
	USART_CR1_IDLEIE_Pos = 0x4
	// Bit mask of IDLEIE field.
	USART_CR1_IDLEIE_Msk = 0x10
	// Bit IDLEIE.
	USART_CR1_IDLEIE = 0x10
	// Interrupt is disabled
	USART_CR1_IDLEIE_Disabled = 0x0
	// Interrupt is generated whenever IDLE=1 in the ISR register
	USART_CR1_IDLEIE_Enabled = 0x1
	// Position of TE field.
	USART_CR1_TE_Pos = 0x3
	// Bit mask of TE field.
	USART_CR1_TE_Msk = 0x8
	// Bit TE.
	USART_CR1_TE = 0x8
	// Transmitter is disabled
	USART_CR1_TE_Disabled = 0x0
	// Transmitter is enabled
	USART_CR1_TE_Enabled = 0x1
	// Position of RE field.
	USART_CR1_RE_Pos = 0x2
	// Bit mask of RE field.
	USART_CR1_RE_Msk = 0x4
	// Bit RE.
	USART_CR1_RE = 0x4
	// Receiver is disabled
	USART_CR1_RE_Disabled = 0x0
	// Receiver is enabled
	USART_CR1_RE_Enabled = 0x1
	// Position of UESM field.
	USART_CR1_UESM_Pos = 0x1
	// Bit mask of UESM field.
	USART_CR1_UESM_Msk = 0x2
	// Bit UESM.
	USART_CR1_UESM = 0x2
	// USART not able to wake up the MCU from Stop mode
	USART_CR1_UESM_Disabled = 0x0
	// USART able to wake up the MCU from Stop mode
	USART_CR1_UESM_Enabled = 0x1
	// Position of UE field.
	USART_CR1_UE_Pos = 0x0
	// Bit mask of UE field.
	USART_CR1_UE_Msk = 0x1
	// Bit UE.
	USART_CR1_UE = 0x1
	// UART is disabled
	USART_CR1_UE_Disabled = 0x0
	// UART is enabled
	USART_CR1_UE_Enabled = 0x1

	// CR2: Control register 2
	// Position of RTOEN field.
	USART_CR2_RTOEN_Pos = 0x17
	// Bit mask of RTOEN field.
	USART_CR2_RTOEN_Msk = 0x800000
	// Bit RTOEN.
	USART_CR2_RTOEN = 0x800000
	// Receiver timeout feature disabled
	USART_CR2_RTOEN_Disabled = 0x0
	// Receiver timeout feature enabled
	USART_CR2_RTOEN_Enabled = 0x1
	// Position of ABRMOD field.
	USART_CR2_ABRMOD_Pos = 0x15
	// Bit mask of ABRMOD field.
	USART_CR2_ABRMOD_Msk = 0x600000
	// Measurement of the start bit is used to detect the baud rate
	USART_CR2_ABRMOD_Start = 0x0
	// Falling edge to falling edge measurement
	USART_CR2_ABRMOD_Edge = 0x1
	// 0x7F frame detection
	USART_CR2_ABRMOD_Frame7F = 0x2
	// 0x55 frame detection
	USART_CR2_ABRMOD_Frame55 = 0x3
	// Position of ABREN field.
	USART_CR2_ABREN_Pos = 0x14
	// Bit mask of ABREN field.
	USART_CR2_ABREN_Msk = 0x100000
	// Bit ABREN.
	USART_CR2_ABREN = 0x100000
	// Auto baud rate detection is disabled
	USART_CR2_ABREN_Disabled = 0x0
	// Auto baud rate detection is enabled
	USART_CR2_ABREN_Enabled = 0x1
	// Position of MSBFIRST field.
	USART_CR2_MSBFIRST_Pos = 0x13
	// Bit mask of MSBFIRST field.
	USART_CR2_MSBFIRST_Msk = 0x80000
	// Bit MSBFIRST.
	USART_CR2_MSBFIRST = 0x80000
	// data is transmitted/received with data bit 0 first, following the start bit
	USART_CR2_MSBFIRST_LSB = 0x0
	// data is transmitted/received with MSB (bit 7/8/9) first, following the start bit
	USART_CR2_MSBFIRST_MSB = 0x1
	// Position of DATAINV field.
	USART_CR2_DATAINV_Pos = 0x12
	// Bit mask of DATAINV field.
	USART_CR2_DATAINV_Msk = 0x40000
	// Bit DATAINV.
	USART_CR2_DATAINV = 0x40000
	// Logical data from the data register are send/received in positive/direct logic
	USART_CR2_DATAINV_Positive = 0x0
	// Logical data from the data register are send/received in negative/inverse logic
	USART_CR2_DATAINV_Negative = 0x1
	// Position of TXINV field.
	USART_CR2_TXINV_Pos = 0x11
	// Bit mask of TXINV field.
	USART_CR2_TXINV_Msk = 0x20000
	// Bit TXINV.
	USART_CR2_TXINV = 0x20000
	// TX pin signal works using the standard logic levels
	USART_CR2_TXINV_Standard = 0x0
	// TX pin signal values are inverted
	USART_CR2_TXINV_Inverted = 0x1
	// Position of RXINV field.
	USART_CR2_RXINV_Pos = 0x10
	// Bit mask of RXINV field.
	USART_CR2_RXINV_Msk = 0x10000
	// Bit RXINV.
	USART_CR2_RXINV = 0x10000
	// RX pin signal works using the standard logic levels
	USART_CR2_RXINV_Standard = 0x0
	// RX pin signal values are inverted
	USART_CR2_RXINV_Inverted = 0x1
	// Position of SWAP field.
	USART_CR2_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	USART_CR2_SWAP_Msk = 0x8000
	// Bit SWAP.
	USART_CR2_SWAP = 0x8000
	// TX/RX pins are used as defined in standard pinout
	USART_CR2_SWAP_Standard = 0x0
	// The TX and RX pins functions are swapped
	USART_CR2_SWAP_Swapped = 0x1
	// Position of LINEN field.
	USART_CR2_LINEN_Pos = 0xe
	// Bit mask of LINEN field.
	USART_CR2_LINEN_Msk = 0x4000
	// Bit LINEN.
	USART_CR2_LINEN = 0x4000
	// LIN mode disabled
	USART_CR2_LINEN_Disabled = 0x0
	// LIN mode enabled
	USART_CR2_LINEN_Enabled = 0x1
	// Position of STOP field.
	USART_CR2_STOP_Pos = 0xc
	// Bit mask of STOP field.
	USART_CR2_STOP_Msk = 0x3000
	// 1 stop bit
	USART_CR2_STOP_Stop1 = 0x0
	// 0.5 stop bit
	USART_CR2_STOP_Stop0p5 = 0x1
	// 2 stop bit
	USART_CR2_STOP_Stop2 = 0x2
	// 1.5 stop bit
	USART_CR2_STOP_Stop1p5 = 0x3
	// Position of CLKEN field.
	USART_CR2_CLKEN_Pos = 0xb
	// Bit mask of CLKEN field.
	USART_CR2_CLKEN_Msk = 0x800
	// Bit CLKEN.
	USART_CR2_CLKEN = 0x800
	// CK pin disabled
	USART_CR2_CLKEN_Disabled = 0x0
	// CK pin enabled
	USART_CR2_CLKEN_Enabled = 0x1
	// Position of CPOL field.
	USART_CR2_CPOL_Pos = 0xa
	// Bit mask of CPOL field.
	USART_CR2_CPOL_Msk = 0x400
	// Bit CPOL.
	USART_CR2_CPOL = 0x400
	// Steady low value on CK pin outside transmission window
	USART_CR2_CPOL_Low = 0x0
	// Steady high value on CK pin outside transmission window
	USART_CR2_CPOL_High = 0x1
	// Position of CPHA field.
	USART_CR2_CPHA_Pos = 0x9
	// Bit mask of CPHA field.
	USART_CR2_CPHA_Msk = 0x200
	// Bit CPHA.
	USART_CR2_CPHA = 0x200
	// The first clock transition is the first data capture edge
	USART_CR2_CPHA_First = 0x0
	// The second clock transition is the first data capture edge
	USART_CR2_CPHA_Second = 0x1
	// Position of LBCL field.
	USART_CR2_LBCL_Pos = 0x8
	// Bit mask of LBCL field.
	USART_CR2_LBCL_Msk = 0x100
	// Bit LBCL.
	USART_CR2_LBCL = 0x100
	// The clock pulse of the last data bit is not output to the CK pin
	USART_CR2_LBCL_NotOutput = 0x0
	// The clock pulse of the last data bit is output to the CK pin
	USART_CR2_LBCL_Output = 0x1
	// Position of LBDIE field.
	USART_CR2_LBDIE_Pos = 0x6
	// Bit mask of LBDIE field.
	USART_CR2_LBDIE_Msk = 0x40
	// Bit LBDIE.
	USART_CR2_LBDIE = 0x40
	// Interrupt is inhibited
	USART_CR2_LBDIE_Disabled = 0x0
	// An interrupt is generated whenever LBDF=1 in the ISR register
	USART_CR2_LBDIE_Enabled = 0x1
	// Position of LBDL field.
	USART_CR2_LBDL_Pos = 0x5
	// Bit mask of LBDL field.
	USART_CR2_LBDL_Msk = 0x20
	// Bit LBDL.
	USART_CR2_LBDL = 0x20
	// 10-bit break detection
	USART_CR2_LBDL_Bit10 = 0x0
	// 11-bit break detection
	USART_CR2_LBDL_Bit11 = 0x1
	// Position of ADDM7 field.
	USART_CR2_ADDM7_Pos = 0x4
	// Bit mask of ADDM7 field.
	USART_CR2_ADDM7_Msk = 0x10
	// Bit ADDM7.
	USART_CR2_ADDM7 = 0x10
	// 4-bit address detection
	USART_CR2_ADDM7_Bit4 = 0x0
	// 7-bit address detection
	USART_CR2_ADDM7_Bit7 = 0x1
	// Position of ADD field.
	USART_CR2_ADD_Pos = 0x18
	// Bit mask of ADD field.
	USART_CR2_ADD_Msk = 0xff000000

	// CR3: Control register 3
	// Position of WUFIE field.
	USART_CR3_WUFIE_Pos = 0x16
	// Bit mask of WUFIE field.
	USART_CR3_WUFIE_Msk = 0x400000
	// Bit WUFIE.
	USART_CR3_WUFIE = 0x400000
	// Interrupt is inhibited
	USART_CR3_WUFIE_Disabled = 0x0
	// An USART interrupt is generated whenever WUF=1 in the ISR register
	USART_CR3_WUFIE_Enabled = 0x1
	// Position of WUS field.
	USART_CR3_WUS_Pos = 0x14
	// Bit mask of WUS field.
	USART_CR3_WUS_Msk = 0x300000
	// WUF active on address match
	USART_CR3_WUS_Address = 0x0
	// WuF active on Start bit detection
	USART_CR3_WUS_Start = 0x2
	// WUF active on RXNE
	USART_CR3_WUS_RXNE = 0x3
	// Position of SCARCNT field.
	USART_CR3_SCARCNT_Pos = 0x11
	// Bit mask of SCARCNT field.
	USART_CR3_SCARCNT_Msk = 0xe0000
	// Position of DEP field.
	USART_CR3_DEP_Pos = 0xf
	// Bit mask of DEP field.
	USART_CR3_DEP_Msk = 0x8000
	// Bit DEP.
	USART_CR3_DEP = 0x8000
	// DE signal is active high
	USART_CR3_DEP_High = 0x0
	// DE signal is active low
	USART_CR3_DEP_Low = 0x1
	// Position of DEM field.
	USART_CR3_DEM_Pos = 0xe
	// Bit mask of DEM field.
	USART_CR3_DEM_Msk = 0x4000
	// Bit DEM.
	USART_CR3_DEM = 0x4000
	// DE function is disabled
	USART_CR3_DEM_Disabled = 0x0
	// The DE signal is output on the RTS pin
	USART_CR3_DEM_Enabled = 0x1
	// Position of DDRE field.
	USART_CR3_DDRE_Pos = 0xd
	// Bit mask of DDRE field.
	USART_CR3_DDRE_Msk = 0x2000
	// Bit DDRE.
	USART_CR3_DDRE = 0x2000
	// DMA is not disabled in case of reception error
	USART_CR3_DDRE_NotDisabled = 0x0
	// DMA is disabled following a reception error
	USART_CR3_DDRE_Disabled = 0x1
	// Position of OVRDIS field.
	USART_CR3_OVRDIS_Pos = 0xc
	// Bit mask of OVRDIS field.
	USART_CR3_OVRDIS_Msk = 0x1000
	// Bit OVRDIS.
	USART_CR3_OVRDIS = 0x1000
	// Overrun Error Flag, ORE, is set when received data is not read before receiving new data
	USART_CR3_OVRDIS_Enabled = 0x0
	// Overrun functionality is disabled. If new data is received while the RXNE flag is still set the ORE flag is not set and the new received data overwrites the previous content of the RDR register
	USART_CR3_OVRDIS_Disabled = 0x1
	// Position of ONEBIT field.
	USART_CR3_ONEBIT_Pos = 0xb
	// Bit mask of ONEBIT field.
	USART_CR3_ONEBIT_Msk = 0x800
	// Bit ONEBIT.
	USART_CR3_ONEBIT = 0x800
	// Three sample bit method
	USART_CR3_ONEBIT_Sample3 = 0x0
	// One sample bit method
	USART_CR3_ONEBIT_Sample1 = 0x1
	// Position of CTSIE field.
	USART_CR3_CTSIE_Pos = 0xa
	// Bit mask of CTSIE field.
	USART_CR3_CTSIE_Msk = 0x400
	// Bit CTSIE.
	USART_CR3_CTSIE = 0x400
	// Interrupt is inhibited
	USART_CR3_CTSIE_Disabled = 0x0
	// An interrupt is generated whenever CTSIF=1 in the ISR register
	USART_CR3_CTSIE_Enabled = 0x1
	// Position of CTSE field.
	USART_CR3_CTSE_Pos = 0x9
	// Bit mask of CTSE field.
	USART_CR3_CTSE_Msk = 0x200
	// Bit CTSE.
	USART_CR3_CTSE = 0x200
	// CTS hardware flow control disabled
	USART_CR3_CTSE_Disabled = 0x0
	// CTS mode enabled, data is only transmitted when the CTS input is asserted
	USART_CR3_CTSE_Enabled = 0x1
	// Position of RTSE field.
	USART_CR3_RTSE_Pos = 0x8
	// Bit mask of RTSE field.
	USART_CR3_RTSE_Msk = 0x100
	// Bit RTSE.
	USART_CR3_RTSE = 0x100
	// RTS hardware flow control disabled
	USART_CR3_RTSE_Disabled = 0x0
	// RTS output enabled, data is only requested when there is space in the receive buffer
	USART_CR3_RTSE_Enabled = 0x1
	// Position of DMAT field.
	USART_CR3_DMAT_Pos = 0x7
	// Bit mask of DMAT field.
	USART_CR3_DMAT_Msk = 0x80
	// Bit DMAT.
	USART_CR3_DMAT = 0x80
	// DMA mode is disabled for transmission
	USART_CR3_DMAT_Disabled = 0x0
	// DMA mode is enabled for transmission
	USART_CR3_DMAT_Enabled = 0x1
	// Position of DMAR field.
	USART_CR3_DMAR_Pos = 0x6
	// Bit mask of DMAR field.
	USART_CR3_DMAR_Msk = 0x40
	// Bit DMAR.
	USART_CR3_DMAR = 0x40
	// DMA mode is disabled for reception
	USART_CR3_DMAR_Disabled = 0x0
	// DMA mode is enabled for reception
	USART_CR3_DMAR_Enabled = 0x1
	// Position of SCEN field.
	USART_CR3_SCEN_Pos = 0x5
	// Bit mask of SCEN field.
	USART_CR3_SCEN_Msk = 0x20
	// Bit SCEN.
	USART_CR3_SCEN = 0x20
	// Smartcard Mode disabled
	USART_CR3_SCEN_Disabled = 0x0
	// Smartcard Mode enabled
	USART_CR3_SCEN_Enabled = 0x1
	// Position of NACK field.
	USART_CR3_NACK_Pos = 0x4
	// Bit mask of NACK field.
	USART_CR3_NACK_Msk = 0x10
	// Bit NACK.
	USART_CR3_NACK = 0x10
	// NACK transmission in case of parity error is disabled
	USART_CR3_NACK_Disabled = 0x0
	// NACK transmission during parity error is enabled
	USART_CR3_NACK_Enabled = 0x1
	// Position of HDSEL field.
	USART_CR3_HDSEL_Pos = 0x3
	// Bit mask of HDSEL field.
	USART_CR3_HDSEL_Msk = 0x8
	// Bit HDSEL.
	USART_CR3_HDSEL = 0x8
	// Half duplex mode is not selected
	USART_CR3_HDSEL_NotSelected = 0x0
	// Half duplex mode is selected
	USART_CR3_HDSEL_Selected = 0x1
	// Position of IRLP field.
	USART_CR3_IRLP_Pos = 0x2
	// Bit mask of IRLP field.
	USART_CR3_IRLP_Msk = 0x4
	// Bit IRLP.
	USART_CR3_IRLP = 0x4
	// Normal mode
	USART_CR3_IRLP_Normal = 0x0
	// Low-power mode
	USART_CR3_IRLP_LowPower = 0x1
	// Position of IREN field.
	USART_CR3_IREN_Pos = 0x1
	// Bit mask of IREN field.
	USART_CR3_IREN_Msk = 0x2
	// Bit IREN.
	USART_CR3_IREN = 0x2
	// IrDA disabled
	USART_CR3_IREN_Disabled = 0x0
	// IrDA enabled
	USART_CR3_IREN_Enabled = 0x1
	// Position of EIE field.
	USART_CR3_EIE_Pos = 0x0
	// Bit mask of EIE field.
	USART_CR3_EIE_Msk = 0x1
	// Bit EIE.
	USART_CR3_EIE = 0x1
	// Interrupt is inhibited
	USART_CR3_EIE_Disabled = 0x0
	// An interrupt is generated when FE=1 or ORE=1 or NF=1 in the ISR register
	USART_CR3_EIE_Enabled = 0x1

	// BRR: Baud rate register
	// Position of BRR field.
	USART_BRR_BRR_Pos = 0x0
	// Bit mask of BRR field.
	USART_BRR_BRR_Msk = 0xffff

	// GTPR: Guard time and prescaler register
	// Position of GT field.
	USART_GTPR_GT_Pos = 0x8
	// Bit mask of GT field.
	USART_GTPR_GT_Msk = 0xff00
	// Position of PSC field.
	USART_GTPR_PSC_Pos = 0x0
	// Bit mask of PSC field.
	USART_GTPR_PSC_Msk = 0xff

	// RTOR: Receiver timeout register
	// Position of BLEN field.
	USART_RTOR_BLEN_Pos = 0x18
	// Bit mask of BLEN field.
	USART_RTOR_BLEN_Msk = 0xff000000
	// Position of RTO field.
	USART_RTOR_RTO_Pos = 0x0
	// Bit mask of RTO field.
	USART_RTOR_RTO_Msk = 0xffffff

	// RQR: Request register
	// Position of TXFRQ field.
	USART_RQR_TXFRQ_Pos = 0x4
	// Bit mask of TXFRQ field.
	USART_RQR_TXFRQ_Msk = 0x10
	// Bit TXFRQ.
	USART_RQR_TXFRQ = 0x10
	// Set the TXE flags. This allows to discard the transmit data
	USART_RQR_TXFRQ_Discard = 0x1
	// Position of RXFRQ field.
	USART_RQR_RXFRQ_Pos = 0x3
	// Bit mask of RXFRQ field.
	USART_RQR_RXFRQ_Msk = 0x8
	// Bit RXFRQ.
	USART_RQR_RXFRQ = 0x8
	// clears the RXNE flag. This allows to discard the received data without reading it, and avoid an overrun condition
	USART_RQR_RXFRQ_Discard = 0x1
	// Position of MMRQ field.
	USART_RQR_MMRQ_Pos = 0x2
	// Bit mask of MMRQ field.
	USART_RQR_MMRQ_Msk = 0x4
	// Bit MMRQ.
	USART_RQR_MMRQ = 0x4
	// Puts the USART in mute mode and sets the RWU flag
	USART_RQR_MMRQ_Mute = 0x1
	// Position of SBKRQ field.
	USART_RQR_SBKRQ_Pos = 0x1
	// Bit mask of SBKRQ field.
	USART_RQR_SBKRQ_Msk = 0x2
	// Bit SBKRQ.
	USART_RQR_SBKRQ = 0x2
	// sets the SBKF flag and request to send a BREAK on the line, as soon as the transmit machine is available
	USART_RQR_SBKRQ_Break = 0x1
	// Position of ABRRQ field.
	USART_RQR_ABRRQ_Pos = 0x0
	// Bit mask of ABRRQ field.
	USART_RQR_ABRRQ_Msk = 0x1
	// Bit ABRRQ.
	USART_RQR_ABRRQ = 0x1
	// resets the ABRF flag in the USART_ISR and request an automatic baud rate measurement on the next received data frame
	USART_RQR_ABRRQ_Request = 0x1

	// ISR: Interrupt & status register
	// Position of REACK field.
	USART_ISR_REACK_Pos = 0x16
	// Bit mask of REACK field.
	USART_ISR_REACK_Msk = 0x400000
	// Bit REACK.
	USART_ISR_REACK = 0x400000
	// Position of TEACK field.
	USART_ISR_TEACK_Pos = 0x15
	// Bit mask of TEACK field.
	USART_ISR_TEACK_Msk = 0x200000
	// Bit TEACK.
	USART_ISR_TEACK = 0x200000
	// Position of WUF field.
	USART_ISR_WUF_Pos = 0x14
	// Bit mask of WUF field.
	USART_ISR_WUF_Msk = 0x100000
	// Bit WUF.
	USART_ISR_WUF = 0x100000
	// Position of RWU field.
	USART_ISR_RWU_Pos = 0x13
	// Bit mask of RWU field.
	USART_ISR_RWU_Msk = 0x80000
	// Bit RWU.
	USART_ISR_RWU = 0x80000
	// Position of SBKF field.
	USART_ISR_SBKF_Pos = 0x12
	// Bit mask of SBKF field.
	USART_ISR_SBKF_Msk = 0x40000
	// Bit SBKF.
	USART_ISR_SBKF = 0x40000
	// Position of CMF field.
	USART_ISR_CMF_Pos = 0x11
	// Bit mask of CMF field.
	USART_ISR_CMF_Msk = 0x20000
	// Bit CMF.
	USART_ISR_CMF = 0x20000
	// Position of BUSY field.
	USART_ISR_BUSY_Pos = 0x10
	// Bit mask of BUSY field.
	USART_ISR_BUSY_Msk = 0x10000
	// Bit BUSY.
	USART_ISR_BUSY = 0x10000
	// Position of ABRF field.
	USART_ISR_ABRF_Pos = 0xf
	// Bit mask of ABRF field.
	USART_ISR_ABRF_Msk = 0x8000
	// Bit ABRF.
	USART_ISR_ABRF = 0x8000
	// Position of ABRE field.
	USART_ISR_ABRE_Pos = 0xe
	// Bit mask of ABRE field.
	USART_ISR_ABRE_Msk = 0x4000
	// Bit ABRE.
	USART_ISR_ABRE = 0x4000
	// Position of EOBF field.
	USART_ISR_EOBF_Pos = 0xc
	// Bit mask of EOBF field.
	USART_ISR_EOBF_Msk = 0x1000
	// Bit EOBF.
	USART_ISR_EOBF = 0x1000
	// Position of RTOF field.
	USART_ISR_RTOF_Pos = 0xb
	// Bit mask of RTOF field.
	USART_ISR_RTOF_Msk = 0x800
	// Bit RTOF.
	USART_ISR_RTOF = 0x800
	// Position of CTS field.
	USART_ISR_CTS_Pos = 0xa
	// Bit mask of CTS field.
	USART_ISR_CTS_Msk = 0x400
	// Bit CTS.
	USART_ISR_CTS = 0x400
	// Position of CTSIF field.
	USART_ISR_CTSIF_Pos = 0x9
	// Bit mask of CTSIF field.
	USART_ISR_CTSIF_Msk = 0x200
	// Bit CTSIF.
	USART_ISR_CTSIF = 0x200
	// Position of LBDF field.
	USART_ISR_LBDF_Pos = 0x8
	// Bit mask of LBDF field.
	USART_ISR_LBDF_Msk = 0x100
	// Bit LBDF.
	USART_ISR_LBDF = 0x100
	// Position of TXE field.
	USART_ISR_TXE_Pos = 0x7
	// Bit mask of TXE field.
	USART_ISR_TXE_Msk = 0x80
	// Bit TXE.
	USART_ISR_TXE = 0x80
	// Position of TC field.
	USART_ISR_TC_Pos = 0x6
	// Bit mask of TC field.
	USART_ISR_TC_Msk = 0x40
	// Bit TC.
	USART_ISR_TC = 0x40
	// Position of RXNE field.
	USART_ISR_RXNE_Pos = 0x5
	// Bit mask of RXNE field.
	USART_ISR_RXNE_Msk = 0x20
	// Bit RXNE.
	USART_ISR_RXNE = 0x20
	// Position of IDLE field.
	USART_ISR_IDLE_Pos = 0x4
	// Bit mask of IDLE field.
	USART_ISR_IDLE_Msk = 0x10
	// Bit IDLE.
	USART_ISR_IDLE = 0x10
	// Position of ORE field.
	USART_ISR_ORE_Pos = 0x3
	// Bit mask of ORE field.
	USART_ISR_ORE_Msk = 0x8
	// Bit ORE.
	USART_ISR_ORE = 0x8
	// Position of NF field.
	USART_ISR_NF_Pos = 0x2
	// Bit mask of NF field.
	USART_ISR_NF_Msk = 0x4
	// Bit NF.
	USART_ISR_NF = 0x4
	// Position of FE field.
	USART_ISR_FE_Pos = 0x1
	// Bit mask of FE field.
	USART_ISR_FE_Msk = 0x2
	// Bit FE.
	USART_ISR_FE = 0x2
	// Position of PE field.
	USART_ISR_PE_Pos = 0x0
	// Bit mask of PE field.
	USART_ISR_PE_Msk = 0x1
	// Bit PE.
	USART_ISR_PE = 0x1

	// ICR: Interrupt flag clear register
	// Position of WUCF field.
	USART_ICR_WUCF_Pos = 0x14
	// Bit mask of WUCF field.
	USART_ICR_WUCF_Msk = 0x100000
	// Bit WUCF.
	USART_ICR_WUCF = 0x100000
	// Clears the WUF flag in the ISR register
	USART_ICR_WUCF_Clear = 0x1
	// Position of CMCF field.
	USART_ICR_CMCF_Pos = 0x11
	// Bit mask of CMCF field.
	USART_ICR_CMCF_Msk = 0x20000
	// Bit CMCF.
	USART_ICR_CMCF = 0x20000
	// Clears the CMF flag in the ISR register
	USART_ICR_CMCF_Clear = 0x1
	// Position of EOBCF field.
	USART_ICR_EOBCF_Pos = 0xc
	// Bit mask of EOBCF field.
	USART_ICR_EOBCF_Msk = 0x1000
	// Bit EOBCF.
	USART_ICR_EOBCF = 0x1000
	// Clears the EOBF flag in the ISR register
	USART_ICR_EOBCF_Clear = 0x1
	// Position of RTOCF field.
	USART_ICR_RTOCF_Pos = 0xb
	// Bit mask of RTOCF field.
	USART_ICR_RTOCF_Msk = 0x800
	// Bit RTOCF.
	USART_ICR_RTOCF = 0x800
	// Clears the RTOF flag in the ISR register
	USART_ICR_RTOCF_Clear = 0x1
	// Position of CTSCF field.
	USART_ICR_CTSCF_Pos = 0x9
	// Bit mask of CTSCF field.
	USART_ICR_CTSCF_Msk = 0x200
	// Bit CTSCF.
	USART_ICR_CTSCF = 0x200
	// Clears the CTSIF flag in the ISR register
	USART_ICR_CTSCF_Clear = 0x1
	// Position of LBDCF field.
	USART_ICR_LBDCF_Pos = 0x8
	// Bit mask of LBDCF field.
	USART_ICR_LBDCF_Msk = 0x100
	// Bit LBDCF.
	USART_ICR_LBDCF = 0x100
	// Clears the LBDF flag in the ISR register
	USART_ICR_LBDCF_Clear = 0x1
	// Position of TCCF field.
	USART_ICR_TCCF_Pos = 0x6
	// Bit mask of TCCF field.
	USART_ICR_TCCF_Msk = 0x40
	// Bit TCCF.
	USART_ICR_TCCF = 0x40
	// Clears the TC flag in the ISR register
	USART_ICR_TCCF_Clear = 0x1
	// Position of IDLECF field.
	USART_ICR_IDLECF_Pos = 0x4
	// Bit mask of IDLECF field.
	USART_ICR_IDLECF_Msk = 0x10
	// Bit IDLECF.
	USART_ICR_IDLECF = 0x10
	// Clears the IDLE flag in the ISR register
	USART_ICR_IDLECF_Clear = 0x1
	// Position of ORECF field.
	USART_ICR_ORECF_Pos = 0x3
	// Bit mask of ORECF field.
	USART_ICR_ORECF_Msk = 0x8
	// Bit ORECF.
	USART_ICR_ORECF = 0x8
	// Clears the ORE flag in the ISR register
	USART_ICR_ORECF_Clear = 0x1
	// Position of NCF field.
	USART_ICR_NCF_Pos = 0x2
	// Bit mask of NCF field.
	USART_ICR_NCF_Msk = 0x4
	// Bit NCF.
	USART_ICR_NCF = 0x4
	// Clears the NF flag in the ISR register
	USART_ICR_NCF_Clear = 0x1
	// Position of FECF field.
	USART_ICR_FECF_Pos = 0x1
	// Bit mask of FECF field.
	USART_ICR_FECF_Msk = 0x2
	// Bit FECF.
	USART_ICR_FECF = 0x2
	// Clears the FE flag in the ISR register
	USART_ICR_FECF_Clear = 0x1
	// Position of PECF field.
	USART_ICR_PECF_Pos = 0x0
	// Bit mask of PECF field.
	USART_ICR_PECF_Msk = 0x1
	// Bit PECF.
	USART_ICR_PECF = 0x1
	// Clears the PE flag in the ISR register
	USART_ICR_PECF_Clear = 0x1

	// RDR: Receive data register
	// Position of RDR field.
	USART_RDR_RDR_Pos = 0x0
	// Bit mask of RDR field.
	USART_RDR_RDR_Msk = 0x1ff

	// TDR: Transmit data register
	// Position of TDR field.
	USART_TDR_TDR_Pos = 0x0
	// Bit mask of TDR field.
	USART_TDR_TDR_Msk = 0x1ff
)

// Constants for SPI1: Serial peripheral interface/Inter-IC sound
const (
	// CR1: control register 1
	// Position of BIDIMODE field.
	SPI_CR1_BIDIMODE_Pos = 0xf
	// Bit mask of BIDIMODE field.
	SPI_CR1_BIDIMODE_Msk = 0x8000
	// Bit BIDIMODE.
	SPI_CR1_BIDIMODE = 0x8000
	// 2-line unidirectional data mode selected
	SPI_CR1_BIDIMODE_Unidirectional = 0x0
	// 1-line bidirectional data mode selected
	SPI_CR1_BIDIMODE_Bidirectional = 0x1
	// Position of BIDIOE field.
	SPI_CR1_BIDIOE_Pos = 0xe
	// Bit mask of BIDIOE field.
	SPI_CR1_BIDIOE_Msk = 0x4000
	// Bit BIDIOE.
	SPI_CR1_BIDIOE = 0x4000
	// Output disabled (receive-only mode)
	SPI_CR1_BIDIOE_OutputDisabled = 0x0
	// Output enabled (transmit-only mode)
	SPI_CR1_BIDIOE_OutputEnabled = 0x1
	// Position of CRCEN field.
	SPI_CR1_CRCEN_Pos = 0xd
	// Bit mask of CRCEN field.
	SPI_CR1_CRCEN_Msk = 0x2000
	// Bit CRCEN.
	SPI_CR1_CRCEN = 0x2000
	// CRC calculation disabled
	SPI_CR1_CRCEN_Disabled = 0x0
	// CRC calculation enabled
	SPI_CR1_CRCEN_Enabled = 0x1
	// Position of CRCNEXT field.
	SPI_CR1_CRCNEXT_Pos = 0xc
	// Bit mask of CRCNEXT field.
	SPI_CR1_CRCNEXT_Msk = 0x1000
	// Bit CRCNEXT.
	SPI_CR1_CRCNEXT = 0x1000
	// Next transmit value is from Tx buffer
	SPI_CR1_CRCNEXT_TxBuffer = 0x0
	// Next transmit value is from Tx CRC register
	SPI_CR1_CRCNEXT_CRC = 0x1
	// Position of CRCL field.
	SPI_CR1_CRCL_Pos = 0xb
	// Bit mask of CRCL field.
	SPI_CR1_CRCL_Msk = 0x800
	// Bit CRCL.
	SPI_CR1_CRCL = 0x800
	// 8-bit CRC length
	SPI_CR1_CRCL_EightBit = 0x0
	// 16-bit CRC length
	SPI_CR1_CRCL_SixteenBit = 0x1
	// Position of RXONLY field.
	SPI_CR1_RXONLY_Pos = 0xa
	// Bit mask of RXONLY field.
	SPI_CR1_RXONLY_Msk = 0x400
	// Bit RXONLY.
	SPI_CR1_RXONLY = 0x400
	// Full duplex (Transmit and receive)
	SPI_CR1_RXONLY_FullDuplex = 0x0
	// Output disabled (Receive-only mode)
	SPI_CR1_RXONLY_OutputDisabled = 0x1
	// Position of SSM field.
	SPI_CR1_SSM_Pos = 0x9
	// Bit mask of SSM field.
	SPI_CR1_SSM_Msk = 0x200
	// Bit SSM.
	SPI_CR1_SSM = 0x200
	// Software slave management disabled
	SPI_CR1_SSM_Disabled = 0x0
	// Software slave management enabled
	SPI_CR1_SSM_Enabled = 0x1
	// Position of SSI field.
	SPI_CR1_SSI_Pos = 0x8
	// Bit mask of SSI field.
	SPI_CR1_SSI_Msk = 0x100
	// Bit SSI.
	SPI_CR1_SSI = 0x100
	// 0 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveSelected = 0x0
	// 1 is forced onto the NSS pin and the I/O value of the NSS pin is ignored
	SPI_CR1_SSI_SlaveNotSelected = 0x1
	// Position of LSBFIRST field.
	SPI_CR1_LSBFIRST_Pos = 0x7
	// Bit mask of LSBFIRST field.
	SPI_CR1_LSBFIRST_Msk = 0x80
	// Bit LSBFIRST.
	SPI_CR1_LSBFIRST = 0x80
	// Data is transmitted/received with the MSB first
	SPI_CR1_LSBFIRST_MSBFirst = 0x0
	// Data is transmitted/received with the LSB first
	SPI_CR1_LSBFIRST_LSBFirst = 0x1
	// Position of SPE field.
	SPI_CR1_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI_CR1_SPE_Msk = 0x40
	// Bit SPE.
	SPI_CR1_SPE = 0x40
	// Peripheral disabled
	SPI_CR1_SPE_Disabled = 0x0
	// Peripheral enabled
	SPI_CR1_SPE_Enabled = 0x1
	// Position of BR field.
	SPI_CR1_BR_Pos = 0x3
	// Bit mask of BR field.
	SPI_CR1_BR_Msk = 0x38
	// f_PCLK / 2
	SPI_CR1_BR_Div2 = 0x0
	// f_PCLK / 4
	SPI_CR1_BR_Div4 = 0x1
	// f_PCLK / 8
	SPI_CR1_BR_Div8 = 0x2
	// f_PCLK / 16
	SPI_CR1_BR_Div16 = 0x3
	// f_PCLK / 32
	SPI_CR1_BR_Div32 = 0x4
	// f_PCLK / 64
	SPI_CR1_BR_Div64 = 0x5
	// f_PCLK / 128
	SPI_CR1_BR_Div128 = 0x6
	// f_PCLK / 256
	SPI_CR1_BR_Div256 = 0x7
	// Position of MSTR field.
	SPI_CR1_MSTR_Pos = 0x2
	// Bit mask of MSTR field.
	SPI_CR1_MSTR_Msk = 0x4
	// Bit MSTR.
	SPI_CR1_MSTR = 0x4
	// Slave configuration
	SPI_CR1_MSTR_Slave = 0x0
	// Master configuration
	SPI_CR1_MSTR_Master = 0x1
	// Position of CPOL field.
	SPI_CR1_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI_CR1_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI_CR1_CPOL = 0x2
	// CK to 0 when idle
	SPI_CR1_CPOL_IdleLow = 0x0
	// CK to 1 when idle
	SPI_CR1_CPOL_IdleHigh = 0x1
	// Position of CPHA field.
	SPI_CR1_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI_CR1_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI_CR1_CPHA = 0x1
	// The first clock transition is the first data capture edge
	SPI_CR1_CPHA_FirstEdge = 0x0
	// The second clock transition is the first data capture edge
	SPI_CR1_CPHA_SecondEdge = 0x1

	// CR2: control register 2
	// Position of RXDMAEN field.
	SPI_CR2_RXDMAEN_Pos = 0x0
	// Bit mask of RXDMAEN field.
	SPI_CR2_RXDMAEN_Msk = 0x1
	// Bit RXDMAEN.
	SPI_CR2_RXDMAEN = 0x1
	// Rx buffer DMA disabled
	SPI_CR2_RXDMAEN_Disabled = 0x0
	// Rx buffer DMA enabled
	SPI_CR2_RXDMAEN_Enabled = 0x1
	// Position of TXDMAEN field.
	SPI_CR2_TXDMAEN_Pos = 0x1
	// Bit mask of TXDMAEN field.
	SPI_CR2_TXDMAEN_Msk = 0x2
	// Bit TXDMAEN.
	SPI_CR2_TXDMAEN = 0x2
	// Tx buffer DMA disabled
	SPI_CR2_TXDMAEN_Disabled = 0x0
	// Tx buffer DMA enabled
	SPI_CR2_TXDMAEN_Enabled = 0x1
	// Position of SSOE field.
	SPI_CR2_SSOE_Pos = 0x2
	// Bit mask of SSOE field.
	SPI_CR2_SSOE_Msk = 0x4
	// Bit SSOE.
	SPI_CR2_SSOE = 0x4
	// SS output is disabled in master mode
	SPI_CR2_SSOE_Disabled = 0x0
	// SS output is enabled in master mode
	SPI_CR2_SSOE_Enabled = 0x1
	// Position of NSSP field.
	SPI_CR2_NSSP_Pos = 0x3
	// Bit mask of NSSP field.
	SPI_CR2_NSSP_Msk = 0x8
	// Bit NSSP.
	SPI_CR2_NSSP = 0x8
	// No NSS pulse
	SPI_CR2_NSSP_NoPulse = 0x0
	// NSS pulse generated
	SPI_CR2_NSSP_PulseGenerated = 0x1
	// Position of FRF field.
	SPI_CR2_FRF_Pos = 0x4
	// Bit mask of FRF field.
	SPI_CR2_FRF_Msk = 0x10
	// Bit FRF.
	SPI_CR2_FRF = 0x10
	// SPI Motorola mode
	SPI_CR2_FRF_Motorola = 0x0
	// SPI TI mode
	SPI_CR2_FRF_TI = 0x1
	// Position of ERRIE field.
	SPI_CR2_ERRIE_Pos = 0x5
	// Bit mask of ERRIE field.
	SPI_CR2_ERRIE_Msk = 0x20
	// Bit ERRIE.
	SPI_CR2_ERRIE = 0x20
	// Error interrupt masked
	SPI_CR2_ERRIE_Masked = 0x0
	// Error interrupt not masked
	SPI_CR2_ERRIE_NotMasked = 0x1
	// Position of RXNEIE field.
	SPI_CR2_RXNEIE_Pos = 0x6
	// Bit mask of RXNEIE field.
	SPI_CR2_RXNEIE_Msk = 0x40
	// Bit RXNEIE.
	SPI_CR2_RXNEIE = 0x40
	// RXE interrupt masked
	SPI_CR2_RXNEIE_Masked = 0x0
	// RXE interrupt not masked
	SPI_CR2_RXNEIE_NotMasked = 0x1
	// Position of TXEIE field.
	SPI_CR2_TXEIE_Pos = 0x7
	// Bit mask of TXEIE field.
	SPI_CR2_TXEIE_Msk = 0x80
	// Bit TXEIE.
	SPI_CR2_TXEIE = 0x80
	// TXE interrupt masked
	SPI_CR2_TXEIE_Masked = 0x0
	// TXE interrupt not masked
	SPI_CR2_TXEIE_NotMasked = 0x1
	// Position of DS field.
	SPI_CR2_DS_Pos = 0x8
	// Bit mask of DS field.
	SPI_CR2_DS_Msk = 0xf00
	// 4-bit
	SPI_CR2_DS_FourBit = 0x3
	// 5-bit
	SPI_CR2_DS_FiveBit = 0x4
	// 6-bit
	SPI_CR2_DS_SixBit = 0x5
	// 7-bit
	SPI_CR2_DS_SevenBit = 0x6
	// 8-bit
	SPI_CR2_DS_EightBit = 0x7
	// 9-bit
	SPI_CR2_DS_NineBit = 0x8
	// 10-bit
	SPI_CR2_DS_TenBit = 0x9
	// 11-bit
	SPI_CR2_DS_ElevenBit = 0xa
	// 12-bit
	SPI_CR2_DS_TwelveBit = 0xb
	// 13-bit
	SPI_CR2_DS_ThirteenBit = 0xc
	// 14-bit
	SPI_CR2_DS_FourteenBit = 0xd
	// 15-bit
	SPI_CR2_DS_FifteenBit = 0xe
	// 16-bit
	SPI_CR2_DS_SixteenBit = 0xf
	// Position of FRXTH field.
	SPI_CR2_FRXTH_Pos = 0xc
	// Bit mask of FRXTH field.
	SPI_CR2_FRXTH_Msk = 0x1000
	// Bit FRXTH.
	SPI_CR2_FRXTH = 0x1000
	// RXNE event is generated if the FIFO level is greater than or equal to 1/2 (16-bit)
	SPI_CR2_FRXTH_Half = 0x0
	// RXNE event is generated if the FIFO level is greater than or equal to 1/4 (8-bit)
	SPI_CR2_FRXTH_Quarter = 0x1
	// Position of LDMA_RX field.
	SPI_CR2_LDMA_RX_Pos = 0xd
	// Bit mask of LDMA_RX field.
	SPI_CR2_LDMA_RX_Msk = 0x2000
	// Bit LDMA_RX.
	SPI_CR2_LDMA_RX = 0x2000
	// Number of data to transfer for receive is even
	SPI_CR2_LDMA_RX_Even = 0x0
	// Number of data to transfer for receive is odd
	SPI_CR2_LDMA_RX_Odd = 0x1
	// Position of LDMA_TX field.
	SPI_CR2_LDMA_TX_Pos = 0xe
	// Bit mask of LDMA_TX field.
	SPI_CR2_LDMA_TX_Msk = 0x4000
	// Bit LDMA_TX.
	SPI_CR2_LDMA_TX = 0x4000
	// Number of data to transfer for transmit is even
	SPI_CR2_LDMA_TX_Even = 0x0
	// Number of data to transfer for transmit is odd
	SPI_CR2_LDMA_TX_Odd = 0x1

	// SR: status register
	// Position of RXNE field.
	SPI_SR_RXNE_Pos = 0x0
	// Bit mask of RXNE field.
	SPI_SR_RXNE_Msk = 0x1
	// Bit RXNE.
	SPI_SR_RXNE = 0x1
	// Rx buffer empty
	SPI_SR_RXNE_Empty = 0x0
	// Rx buffer not empty
	SPI_SR_RXNE_NotEmpty = 0x1
	// Position of TXE field.
	SPI_SR_TXE_Pos = 0x1
	// Bit mask of TXE field.
	SPI_SR_TXE_Msk = 0x2
	// Bit TXE.
	SPI_SR_TXE = 0x2
	// Tx buffer not empty
	SPI_SR_TXE_NotEmpty = 0x0
	// Tx buffer empty
	SPI_SR_TXE_Empty = 0x1
	// Position of CHSIDE field.
	SPI_SR_CHSIDE_Pos = 0x2
	// Bit mask of CHSIDE field.
	SPI_SR_CHSIDE_Msk = 0x4
	// Bit CHSIDE.
	SPI_SR_CHSIDE = 0x4
	// Channel left has to be transmitted or has been received
	SPI_SR_CHSIDE_Left = 0x0
	// Channel right has to be transmitted or has been received
	SPI_SR_CHSIDE_Right = 0x1
	// Position of UDR field.
	SPI_SR_UDR_Pos = 0x3
	// Bit mask of UDR field.
	SPI_SR_UDR_Msk = 0x8
	// Bit UDR.
	SPI_SR_UDR = 0x8
	// No underrun occurred
	SPI_SR_UDR_NoUnderrun = 0x0
	// Underrun occurred
	SPI_SR_UDR_Underrun = 0x1
	// Position of CRCERR field.
	SPI_SR_CRCERR_Pos = 0x4
	// Bit mask of CRCERR field.
	SPI_SR_CRCERR_Msk = 0x10
	// Bit CRCERR.
	SPI_SR_CRCERR = 0x10
	// CRC value received matches the SPIx_RXCRCR value
	SPI_SR_CRCERR_Match = 0x0
	// CRC value received does not match the SPIx_RXCRCR value
	SPI_SR_CRCERR_NoMatch = 0x1
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x5
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x20
	// Bit MODF.
	SPI_SR_MODF = 0x20
	// No mode fault occurred
	SPI_SR_MODF_NoFault = 0x0
	// Mode fault occurred
	SPI_SR_MODF_Fault = 0x1
	// Position of OVR field.
	SPI_SR_OVR_Pos = 0x6
	// Bit mask of OVR field.
	SPI_SR_OVR_Msk = 0x40
	// Bit OVR.
	SPI_SR_OVR = 0x40
	// No overrun occurred
	SPI_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	SPI_SR_OVR_Overrun = 0x1
	// Position of BSY field.
	SPI_SR_BSY_Pos = 0x7
	// Bit mask of BSY field.
	SPI_SR_BSY_Msk = 0x80
	// Bit BSY.
	SPI_SR_BSY = 0x80
	// SPI not busy
	SPI_SR_BSY_NotBusy = 0x0
	// SPI busy
	SPI_SR_BSY_Busy = 0x1
	// Position of FRE field.
	SPI_SR_FRE_Pos = 0x8
	// Bit mask of FRE field.
	SPI_SR_FRE_Msk = 0x100
	// Bit FRE.
	SPI_SR_FRE = 0x100
	// No frame format error
	SPI_SR_FRE_NoError = 0x0
	// A frame format error occurred
	SPI_SR_FRE_Error = 0x1
	// Position of FRLVL field.
	SPI_SR_FRLVL_Pos = 0x9
	// Bit mask of FRLVL field.
	SPI_SR_FRLVL_Msk = 0x600
	// Rx FIFO Empty
	SPI_SR_FRLVL_Empty = 0x0
	// Rx 1/4 FIFO
	SPI_SR_FRLVL_Quarter = 0x1
	// Rx 1/2 FIFO
	SPI_SR_FRLVL_Half = 0x2
	// Rx FIFO full
	SPI_SR_FRLVL_Full = 0x3
	// Position of FTLVL field.
	SPI_SR_FTLVL_Pos = 0xb
	// Bit mask of FTLVL field.
	SPI_SR_FTLVL_Msk = 0x1800
	// Tx FIFO Empty
	SPI_SR_FTLVL_Empty = 0x0
	// Tx 1/4 FIFO
	SPI_SR_FTLVL_Quarter = 0x1
	// Tx 1/2 FIFO
	SPI_SR_FTLVL_Half = 0x2
	// Tx FIFO full
	SPI_SR_FTLVL_Full = 0x3

	// DR: data register
	// Position of DR field.
	SPI_DR_DR_Pos = 0x0
	// Bit mask of DR field.
	SPI_DR_DR_Msk = 0xffff

	// CRCPR: CRC polynomial register
	// Position of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	SPI_CRCPR_CRCPOLY_Msk = 0xffff

	// RXCRCR: RX CRC register
	// Position of RxCRC field.
	SPI_RXCRCR_RxCRC_Pos = 0x0
	// Bit mask of RxCRC field.
	SPI_RXCRCR_RxCRC_Msk = 0xffff

	// TXCRCR: TX CRC register
	// Position of TxCRC field.
	SPI_TXCRCR_TxCRC_Pos = 0x0
	// Bit mask of TxCRC field.
	SPI_TXCRCR_TxCRC_Msk = 0xffff

	// I2SCFGR: I2S configuration register
	// Position of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Pos = 0xb
	// Bit mask of I2SMOD field.
	SPI_I2SCFGR_I2SMOD_Msk = 0x800
	// Bit I2SMOD.
	SPI_I2SCFGR_I2SMOD = 0x800
	// SPI mode is selected
	SPI_I2SCFGR_I2SMOD_SPIMode = 0x0
	// I2S mode is selected
	SPI_I2SCFGR_I2SMOD_I2SMode = 0x1
	// Position of I2SE field.
	SPI_I2SCFGR_I2SE_Pos = 0xa
	// Bit mask of I2SE field.
	SPI_I2SCFGR_I2SE_Msk = 0x400
	// Bit I2SE.
	SPI_I2SCFGR_I2SE = 0x400
	// I2S peripheral is disabled
	SPI_I2SCFGR_I2SE_Disabled = 0x0
	// I2S peripheral is enabled
	SPI_I2SCFGR_I2SE_Enabled = 0x1
	// Position of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Pos = 0x8
	// Bit mask of I2SCFG field.
	SPI_I2SCFGR_I2SCFG_Msk = 0x300
	// Slave - transmit
	SPI_I2SCFGR_I2SCFG_SlaveTx = 0x0
	// Slave - receive
	SPI_I2SCFGR_I2SCFG_SlaveRx = 0x1
	// Master - transmit
	SPI_I2SCFGR_I2SCFG_MasterTx = 0x2
	// Master - receive
	SPI_I2SCFGR_I2SCFG_MasterRx = 0x3
	// Position of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Pos = 0x7
	// Bit mask of PCMSYNC field.
	SPI_I2SCFGR_PCMSYNC_Msk = 0x80
	// Bit PCMSYNC.
	SPI_I2SCFGR_PCMSYNC = 0x80
	// Short frame synchronisation
	SPI_I2SCFGR_PCMSYNC_Short = 0x0
	// Long frame synchronisation
	SPI_I2SCFGR_PCMSYNC_Long = 0x1
	// Position of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Pos = 0x4
	// Bit mask of I2SSTD field.
	SPI_I2SCFGR_I2SSTD_Msk = 0x30
	// I2S Philips standard
	SPI_I2SCFGR_I2SSTD_Philips = 0x0
	// MSB justified standard
	SPI_I2SCFGR_I2SSTD_MSB = 0x1
	// LSB justified standard
	SPI_I2SCFGR_I2SSTD_LSB = 0x2
	// PCM standard
	SPI_I2SCFGR_I2SSTD_PCM = 0x3
	// Position of CKPOL field.
	SPI_I2SCFGR_CKPOL_Pos = 0x3
	// Bit mask of CKPOL field.
	SPI_I2SCFGR_CKPOL_Msk = 0x8
	// Bit CKPOL.
	SPI_I2SCFGR_CKPOL = 0x8
	// I2S clock inactive state is low level
	SPI_I2SCFGR_CKPOL_IdleLow = 0x0
	// I2S clock inactive state is high level
	SPI_I2SCFGR_CKPOL_IdleHigh = 0x1
	// Position of DATLEN field.
	SPI_I2SCFGR_DATLEN_Pos = 0x1
	// Bit mask of DATLEN field.
	SPI_I2SCFGR_DATLEN_Msk = 0x6
	// 16-bit data length
	SPI_I2SCFGR_DATLEN_SixteenBit = 0x0
	// 24-bit data length
	SPI_I2SCFGR_DATLEN_TwentyFourBit = 0x1
	// 32-bit data length
	SPI_I2SCFGR_DATLEN_ThirtyTwoBit = 0x2
	// Position of CHLEN field.
	SPI_I2SCFGR_CHLEN_Pos = 0x0
	// Bit mask of CHLEN field.
	SPI_I2SCFGR_CHLEN_Msk = 0x1
	// Bit CHLEN.
	SPI_I2SCFGR_CHLEN = 0x1
	// 16-bit wide
	SPI_I2SCFGR_CHLEN_SixteenBit = 0x0
	// 32-bit wide
	SPI_I2SCFGR_CHLEN_ThirtyTwoBit = 0x1

	// I2SPR: I2S prescaler register
	// Position of MCKOE field.
	SPI_I2SPR_MCKOE_Pos = 0x9
	// Bit mask of MCKOE field.
	SPI_I2SPR_MCKOE_Msk = 0x200
	// Bit MCKOE.
	SPI_I2SPR_MCKOE = 0x200
	// Master clock output is disabled
	SPI_I2SPR_MCKOE_Disabled = 0x0
	// Master clock output is enabled
	SPI_I2SPR_MCKOE_Enabled = 0x1
	// Position of ODD field.
	SPI_I2SPR_ODD_Pos = 0x8
	// Bit mask of ODD field.
	SPI_I2SPR_ODD_Msk = 0x100
	// Bit ODD.
	SPI_I2SPR_ODD = 0x100
	// Real divider value is I2SDIV * 2
	SPI_I2SPR_ODD_Even = 0x0
	// Real divider value is (I2SDIV * 2) + 1
	SPI_I2SPR_ODD_Odd = 0x1
	// Position of I2SDIV field.
	SPI_I2SPR_I2SDIV_Pos = 0x0
	// Bit mask of I2SDIV field.
	SPI_I2SPR_I2SDIV_Msk = 0xff
)

// Constants for ADC1: Analog to digital converter
const (
	// ISR: ADC interrupt and status register
	// Position of JQOVF field.
	ADC_ISR_JQOVF_Pos = 0xa
	// Bit mask of JQOVF field.
	ADC_ISR_JQOVF_Msk = 0x400
	// Bit JQOVF.
	ADC_ISR_JQOVF = 0x400
	// No injected context queue overflow has occurred
	ADC_ISR_JQOVF_NoOverflow = 0x0
	// Injected context queue overflow has occurred
	ADC_ISR_JQOVF_Overflow = 0x1
	// Clear injected context queue overflow flag
	ADC_ISR_JQOVF_Clear = 0x1
	// Position of AWD3 field.
	ADC_ISR_AWD3_Pos = 0x9
	// Bit mask of AWD3 field.
	ADC_ISR_AWD3_Msk = 0x200
	// Bit AWD3.
	ADC_ISR_AWD3 = 0x200
	// No analog watchdog event occurred
	ADC_ISR_AWD3_NoEvent = 0x0
	// Analog watchdog event occurred
	ADC_ISR_AWD3_Event = 0x1
	// Clear analog watchdog event occurred flag
	ADC_ISR_AWD3_Clear = 0x1
	// Position of AWD2 field.
	ADC_ISR_AWD2_Pos = 0x8
	// Bit mask of AWD2 field.
	ADC_ISR_AWD2_Msk = 0x100
	// Bit AWD2.
	ADC_ISR_AWD2 = 0x100
	// No analog watchdog event occurred
	ADC_ISR_AWD2_NoEvent = 0x0
	// Analog watchdog event occurred
	ADC_ISR_AWD2_Event = 0x1
	// Clear analog watchdog event occurred flag
	ADC_ISR_AWD2_Clear = 0x1
	// Position of AWD1 field.
	ADC_ISR_AWD1_Pos = 0x7
	// Bit mask of AWD1 field.
	ADC_ISR_AWD1_Msk = 0x80
	// Bit AWD1.
	ADC_ISR_AWD1 = 0x80
	// No analog watchdog event occurred
	ADC_ISR_AWD1_NoEvent = 0x0
	// Analog watchdog event occurred
	ADC_ISR_AWD1_Event = 0x1
	// Clear analog watchdog event occurred flag
	ADC_ISR_AWD1_Clear = 0x1
	// Position of JEOS field.
	ADC_ISR_JEOS_Pos = 0x6
	// Bit mask of JEOS field.
	ADC_ISR_JEOS_Msk = 0x40
	// Bit JEOS.
	ADC_ISR_JEOS = 0x40
	// Injected sequence is not complete
	ADC_ISR_JEOS_NotComplete = 0x0
	// Injected sequence complete
	ADC_ISR_JEOS_Complete = 0x1
	// Clear Injected sequence complete flag
	ADC_ISR_JEOS_Clear = 0x1
	// Position of JEOC field.
	ADC_ISR_JEOC_Pos = 0x5
	// Bit mask of JEOC field.
	ADC_ISR_JEOC_Msk = 0x20
	// Bit JEOC.
	ADC_ISR_JEOC = 0x20
	// Injected conversion is not complete
	ADC_ISR_JEOC_NotComplete = 0x0
	// Injected conversion complete
	ADC_ISR_JEOC_Complete = 0x1
	// Clear injected conversion complete flag
	ADC_ISR_JEOC_Clear = 0x1
	// Position of OVR field.
	ADC_ISR_OVR_Pos = 0x4
	// Bit mask of OVR field.
	ADC_ISR_OVR_Msk = 0x10
	// Bit OVR.
	ADC_ISR_OVR = 0x10
	// No overrun occurred
	ADC_ISR_OVR_NoOverrun = 0x0
	// Overrun occurred
	ADC_ISR_OVR_Overrun = 0x1
	// Clear overrun occurred flag
	ADC_ISR_OVR_Clear = 0x1
	// Position of EOS field.
	ADC_ISR_EOS_Pos = 0x3
	// Bit mask of EOS field.
	ADC_ISR_EOS_Msk = 0x8
	// Bit EOS.
	ADC_ISR_EOS = 0x8
	// Regular sequence is not complete
	ADC_ISR_EOS_NotComplete = 0x0
	// Regular sequence complete
	ADC_ISR_EOS_Complete = 0x1
	// Clear regular sequence complete flag
	ADC_ISR_EOS_Clear = 0x1
	// Position of EOC field.
	ADC_ISR_EOC_Pos = 0x2
	// Bit mask of EOC field.
	ADC_ISR_EOC_Msk = 0x4
	// Bit EOC.
	ADC_ISR_EOC = 0x4
	// Regular conversion is not complete
	ADC_ISR_EOC_NotComplete = 0x0
	// Regular conversion complete
	ADC_ISR_EOC_Complete = 0x1
	// Clear regular conversion complete flag
	ADC_ISR_EOC_Clear = 0x1
	// Position of EOSMP field.
	ADC_ISR_EOSMP_Pos = 0x1
	// Bit mask of EOSMP field.
	ADC_ISR_EOSMP_Msk = 0x2
	// Bit EOSMP.
	ADC_ISR_EOSMP = 0x2
	// End of sampling phase no yet reached
	ADC_ISR_EOSMP_NotEnded = 0x0
	// End of sampling phase reached
	ADC_ISR_EOSMP_Ended = 0x1
	// Clear end of sampling phase reached flag
	ADC_ISR_EOSMP_Clear = 0x1
	// Position of ADRDY field.
	ADC_ISR_ADRDY_Pos = 0x0
	// Bit mask of ADRDY field.
	ADC_ISR_ADRDY_Msk = 0x1
	// Bit ADRDY.
	ADC_ISR_ADRDY = 0x1
	// ADC is not ready to start conversion
	ADC_ISR_ADRDY_NotReady = 0x0
	// ADC is ready to start conversion
	ADC_ISR_ADRDY_Ready = 0x1
	// Clear ADC is ready to start conversion flag
	ADC_ISR_ADRDY_Clear = 0x1

	// IER: ADC interrupt enable register
	// Position of JQOVFIE field.
	ADC_IER_JQOVFIE_Pos = 0xa
	// Bit mask of JQOVFIE field.
	ADC_IER_JQOVFIE_Msk = 0x400
	// Bit JQOVFIE.
	ADC_IER_JQOVFIE = 0x400
	// Injected context queue overflow interrupt disabled
	ADC_IER_JQOVFIE_Disabled = 0x0
	// Injected context queue overflow interrupt enabled
	ADC_IER_JQOVFIE_Enabled = 0x1
	// Position of AWD3IE field.
	ADC_IER_AWD3IE_Pos = 0x9
	// Bit mask of AWD3IE field.
	ADC_IER_AWD3IE_Msk = 0x200
	// Bit AWD3IE.
	ADC_IER_AWD3IE = 0x200
	// Analog watchdog interrupt disabled
	ADC_IER_AWD3IE_Disabled = 0x0
	// Analog watchdog interrupt enabled
	ADC_IER_AWD3IE_Enabled = 0x1
	// Position of AWD2IE field.
	ADC_IER_AWD2IE_Pos = 0x8
	// Bit mask of AWD2IE field.
	ADC_IER_AWD2IE_Msk = 0x100
	// Bit AWD2IE.
	ADC_IER_AWD2IE = 0x100
	// Analog watchdog interrupt disabled
	ADC_IER_AWD2IE_Disabled = 0x0
	// Analog watchdog interrupt enabled
	ADC_IER_AWD2IE_Enabled = 0x1
	// Position of AWD1IE field.
	ADC_IER_AWD1IE_Pos = 0x7
	// Bit mask of AWD1IE field.
	ADC_IER_AWD1IE_Msk = 0x80
	// Bit AWD1IE.
	ADC_IER_AWD1IE = 0x80
	// Analog watchdog interrupt disabled
	ADC_IER_AWD1IE_Disabled = 0x0
	// Analog watchdog interrupt enabled
	ADC_IER_AWD1IE_Enabled = 0x1
	// Position of JEOSIE field.
	ADC_IER_JEOSIE_Pos = 0x6
	// Bit mask of JEOSIE field.
	ADC_IER_JEOSIE_Msk = 0x40
	// Bit JEOSIE.
	ADC_IER_JEOSIE = 0x40
	// End of injected sequence interrupt disabled
	ADC_IER_JEOSIE_Disabled = 0x0
	// End of injected sequence interrupt enabled
	ADC_IER_JEOSIE_Enabled = 0x1
	// Position of JEOCIE field.
	ADC_IER_JEOCIE_Pos = 0x5
	// Bit mask of JEOCIE field.
	ADC_IER_JEOCIE_Msk = 0x20
	// Bit JEOCIE.
	ADC_IER_JEOCIE = 0x20
	// End of injected conversion interrupt disabled
	ADC_IER_JEOCIE_Disabled = 0x0
	// End of injected conversion interrupt enabled
	ADC_IER_JEOCIE_Enabled = 0x1
	// Position of OVRIE field.
	ADC_IER_OVRIE_Pos = 0x4
	// Bit mask of OVRIE field.
	ADC_IER_OVRIE_Msk = 0x10
	// Bit OVRIE.
	ADC_IER_OVRIE = 0x10
	// Overrun interrupt disabled
	ADC_IER_OVRIE_Disabled = 0x0
	// Overrun interrupt enabled
	ADC_IER_OVRIE_Enabled = 0x1
	// Position of EOSIE field.
	ADC_IER_EOSIE_Pos = 0x3
	// Bit mask of EOSIE field.
	ADC_IER_EOSIE_Msk = 0x8
	// Bit EOSIE.
	ADC_IER_EOSIE = 0x8
	// End of regular sequence interrupt disabled
	ADC_IER_EOSIE_Disabled = 0x0
	// End of regular sequence interrupt enabled
	ADC_IER_EOSIE_Enabled = 0x1
	// Position of EOCIE field.
	ADC_IER_EOCIE_Pos = 0x2
	// Bit mask of EOCIE field.
	ADC_IER_EOCIE_Msk = 0x4
	// Bit EOCIE.
	ADC_IER_EOCIE = 0x4
	// End of regular conversion interrupt disabled
	ADC_IER_EOCIE_Disabled = 0x0
	// End of regular conversion interrupt enabled
	ADC_IER_EOCIE_Enabled = 0x1
	// Position of EOSMPIE field.
	ADC_IER_EOSMPIE_Pos = 0x1
	// Bit mask of EOSMPIE field.
	ADC_IER_EOSMPIE_Msk = 0x2
	// Bit EOSMPIE.
	ADC_IER_EOSMPIE = 0x2
	// End of regular conversion sampling phase interrupt disabled
	ADC_IER_EOSMPIE_Disabled = 0x0
	// End of regular conversion sampling phase interrupt enabled
	ADC_IER_EOSMPIE_Enabled = 0x1
	// Position of ADRDYIE field.
	ADC_IER_ADRDYIE_Pos = 0x0
	// Bit mask of ADRDYIE field.
	ADC_IER_ADRDYIE_Msk = 0x1
	// Bit ADRDYIE.
	ADC_IER_ADRDYIE = 0x1
	// ADC ready interrupt disabled
	ADC_IER_ADRDYIE_Disabled = 0x0
	// ADC ready interrupt enabled
	ADC_IER_ADRDYIE_Enabled = 0x1

	// CR: ADC control register
	// Position of ADCAL field.
	ADC_CR_ADCAL_Pos = 0x1f
	// Bit mask of ADCAL field.
	ADC_CR_ADCAL_Msk = 0x80000000
	// Bit ADCAL.
	ADC_CR_ADCAL = 0x80000000
	// Calibration complete
	ADC_CR_ADCAL_Complete = 0x0
	// Start the calibration of the ADC
	ADC_CR_ADCAL_Calibration = 0x1
	// Position of ADCALDIF field.
	ADC_CR_ADCALDIF_Pos = 0x1e
	// Bit mask of ADCALDIF field.
	ADC_CR_ADCALDIF_Msk = 0x40000000
	// Bit ADCALDIF.
	ADC_CR_ADCALDIF = 0x40000000
	// Calibration for single-ended mode
	ADC_CR_ADCALDIF_SingleEnded = 0x0
	// Calibration for differential mode
	ADC_CR_ADCALDIF_Differential = 0x1
	// Position of ADVREGEN field.
	ADC_CR_ADVREGEN_Pos = 0x1c
	// Bit mask of ADVREGEN field.
	ADC_CR_ADVREGEN_Msk = 0x30000000
	// Intermediate state required when moving the ADC voltage regulator between states
	ADC_CR_ADVREGEN_Intermediate = 0x0
	// ADC voltage regulator enabled
	ADC_CR_ADVREGEN_Enabled = 0x1
	// ADC voltage regulator disabled
	ADC_CR_ADVREGEN_Disabled = 0x2
	// Position of JADST field.
	ADC_CR_JADST_Pos = 0x5
	// Bit mask of JADST field.
	ADC_CR_JADST_Msk = 0x20
	// Bit JADST.
	ADC_CR_JADST = 0x20
	// Position of ADSTP field.
	ADC_CR_ADSTP_Pos = 0x4
	// Bit mask of ADSTP field.
	ADC_CR_ADSTP_Msk = 0x10
	// Bit ADSTP.
	ADC_CR_ADSTP = 0x10
	// Stop conversion of channel
	ADC_CR_ADSTP_Stop = 0x1
	// Position of JADSTART field.
	ADC_CR_JADSTART_Pos = 0x3
	// Bit mask of JADSTART field.
	ADC_CR_JADSTART_Msk = 0x8
	// Bit JADSTART.
	ADC_CR_JADSTART = 0x8
	// Starts conversion of channel
	ADC_CR_JADSTART_Start = 0x1
	// Position of ADSTART field.
	ADC_CR_ADSTART_Pos = 0x2
	// Bit mask of ADSTART field.
	ADC_CR_ADSTART_Msk = 0x4
	// Bit ADSTART.
	ADC_CR_ADSTART = 0x4
	// Starts conversion of channel
	ADC_CR_ADSTART_Start = 0x1
	// Position of ADDIS field.
	ADC_CR_ADDIS_Pos = 0x1
	// Bit mask of ADDIS field.
	ADC_CR_ADDIS_Msk = 0x2
	// Bit ADDIS.
	ADC_CR_ADDIS = 0x2
	// Disable ADC conversion and go to power down mode
	ADC_CR_ADDIS_Disable = 0x0
	// Position of ADEN field.
	ADC_CR_ADEN_Pos = 0x0
	// Bit mask of ADEN field.
	ADC_CR_ADEN_Msk = 0x1
	// Bit ADEN.
	ADC_CR_ADEN = 0x1
	// Enable ADC
	ADC_CR_ADEN_Enable = 0x1

	// CFGR: ADC configuration register
	// Position of AWD1CH field.
	ADC_CFGR_AWD1CH_Pos = 0x1a
	// Bit mask of AWD1CH field.
	ADC_CFGR_AWD1CH_Msk = 0x7c000000
	// Position of JAUTO field.
	ADC_CFGR_JAUTO_Pos = 0x19
	// Bit mask of JAUTO field.
	ADC_CFGR_JAUTO_Msk = 0x2000000
	// Bit JAUTO.
	ADC_CFGR_JAUTO = 0x2000000
	// Automatic injected group conversion disabled
	ADC_CFGR_JAUTO_Disabled = 0x0
	// Automatic injected group conversion enabled
	ADC_CFGR_JAUTO_Enabled = 0x1
	// Position of JAWD1EN field.
	ADC_CFGR_JAWD1EN_Pos = 0x18
	// Bit mask of JAWD1EN field.
	ADC_CFGR_JAWD1EN_Msk = 0x1000000
	// Bit JAWD1EN.
	ADC_CFGR_JAWD1EN = 0x1000000
	// Analog watchdog 1 disabled on injected channels
	ADC_CFGR_JAWD1EN_Disabled = 0x0
	// Analog watchdog 1 enabled on injected channels
	ADC_CFGR_JAWD1EN_Enabled = 0x1
	// Position of AWD1EN field.
	ADC_CFGR_AWD1EN_Pos = 0x17
	// Bit mask of AWD1EN field.
	ADC_CFGR_AWD1EN_Msk = 0x800000
	// Bit AWD1EN.
	ADC_CFGR_AWD1EN = 0x800000
	// Analog watchdog 1 disabled on regular channels
	ADC_CFGR_AWD1EN_Disabled = 0x0
	// Analog watchdog 1 enabled on regular channels
	ADC_CFGR_AWD1EN_Enabled = 0x1
	// Position of AWD1SGL field.
	ADC_CFGR_AWD1SGL_Pos = 0x16
	// Bit mask of AWD1SGL field.
	ADC_CFGR_AWD1SGL_Msk = 0x400000
	// Bit AWD1SGL.
	ADC_CFGR_AWD1SGL = 0x400000
	// Analog watchdog 1 enabled on all channels
	ADC_CFGR_AWD1SGL_All = 0x0
	// Analog watchdog 1 enabled on single channel selected in AWD1CH
	ADC_CFGR_AWD1SGL_Single = 0x1
	// Position of JQM field.
	ADC_CFGR_JQM_Pos = 0x15
	// Bit mask of JQM field.
	ADC_CFGR_JQM_Msk = 0x200000
	// Bit JQM.
	ADC_CFGR_JQM = 0x200000
	// JSQR Mode 0: Queue maintains the last written configuration into JSQR
	ADC_CFGR_JQM_Mode0 = 0x0
	// JSQR Mode 1: An empty queue disables software and hardware triggers of the injected sequence
	ADC_CFGR_JQM_Mode1 = 0x1
	// Position of JDISCEN field.
	ADC_CFGR_JDISCEN_Pos = 0x14
	// Bit mask of JDISCEN field.
	ADC_CFGR_JDISCEN_Msk = 0x100000
	// Bit JDISCEN.
	ADC_CFGR_JDISCEN = 0x100000
	// Discontinuous mode on injected channels disabled
	ADC_CFGR_JDISCEN_Disabled = 0x0
	// Discontinuous mode on injected channels enabled
	ADC_CFGR_JDISCEN_Enabled = 0x1
	// Position of DISCNUM field.
	ADC_CFGR_DISCNUM_Pos = 0x11
	// Bit mask of DISCNUM field.
	ADC_CFGR_DISCNUM_Msk = 0xe0000
	// Position of DISCEN field.
	ADC_CFGR_DISCEN_Pos = 0x10
	// Bit mask of DISCEN field.
	ADC_CFGR_DISCEN_Msk = 0x10000
	// Bit DISCEN.
	ADC_CFGR_DISCEN = 0x10000
	// Discontinuous mode on regular channels disabled
	ADC_CFGR_DISCEN_Disabled = 0x0
	// Discontinuous mode on regular channels enabled
	ADC_CFGR_DISCEN_Enabled = 0x1
	// Position of AUTDLY field.
	ADC_CFGR_AUTDLY_Pos = 0xe
	// Bit mask of AUTDLY field.
	ADC_CFGR_AUTDLY_Msk = 0x4000
	// Bit AUTDLY.
	ADC_CFGR_AUTDLY = 0x4000
	// Auto delayed conversion mode off
	ADC_CFGR_AUTDLY_Off = 0x0
	// Auto delayed conversion mode on
	ADC_CFGR_AUTDLY_On = 0x1
	// Position of CONT field.
	ADC_CFGR_CONT_Pos = 0xd
	// Bit mask of CONT field.
	ADC_CFGR_CONT_Msk = 0x2000
	// Bit CONT.
	ADC_CFGR_CONT = 0x2000
	// Single conversion mode
	ADC_CFGR_CONT_Single = 0x0
	// Continuous conversion mode
	ADC_CFGR_CONT_Continuous = 0x1
	// Position of OVRMOD field.
	ADC_CFGR_OVRMOD_Pos = 0xc
	// Bit mask of OVRMOD field.
	ADC_CFGR_OVRMOD_Msk = 0x1000
	// Bit OVRMOD.
	ADC_CFGR_OVRMOD = 0x1000
	// Preserve DR register when an overrun is detected
	ADC_CFGR_OVRMOD_Preserve = 0x0
	// Overwrite DR register when an overrun is detected
	ADC_CFGR_OVRMOD_Overwrite = 0x1
	// Position of EXTEN field.
	ADC_CFGR_EXTEN_Pos = 0xa
	// Bit mask of EXTEN field.
	ADC_CFGR_EXTEN_Msk = 0xc00
	// Trigger detection disabled
	ADC_CFGR_EXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_CFGR_EXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_CFGR_EXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_CFGR_EXTEN_BothEdges = 0x3
	// Position of EXTSEL field.
	ADC_CFGR_EXTSEL_Pos = 0x6
	// Bit mask of EXTSEL field.
	ADC_CFGR_EXTSEL_Msk = 0x3c0
	// HRTIM_ADCTRG1 event
	ADC_CFGR_EXTSEL_HRTIM_ADCTRG1 = 0x7
	// HRTIM_ADCTRG3 event
	ADC_CFGR_EXTSEL_HRTIM_ADCTRG3 = 0x8
	// Timer 1 CC1 event
	ADC_CFGR_EXTSEL_TIM1_CC1 = 0x0
	// Timer 1 CC2 event
	ADC_CFGR_EXTSEL_TIM1_CC2 = 0x1
	// Timer 1 CC3 event
	ADC_CFGR_EXTSEL_TIM1_CC3 = 0x2
	// Timer 2 CC2 event
	ADC_CFGR_EXTSEL_TIM2_CC2 = 0x3
	// Timer 3 TRGO event
	ADC_CFGR_EXTSEL_TIM3_TRGO = 0x4
	// EXTI line 11
	ADC_CFGR_EXTSEL_EXTI11 = 0x6
	// Timer 1 TRGO event
	ADC_CFGR_EXTSEL_TIM1_TRGO = 0x9
	// Timer 1 TRGO2 event
	ADC_CFGR_EXTSEL_TIM1_TRGO2 = 0xa
	// Timer 2 TRGO event
	ADC_CFGR_EXTSEL_TIM2_TRGO = 0xb
	// Timer 6 TRGO event
	ADC_CFGR_EXTSEL_TIM6_TRGO = 0xd
	// Timer 15 TRGO event
	ADC_CFGR_EXTSEL_TIM15_TRGO = 0xe
	// Timer 3 CC4 event
	ADC_CFGR_EXTSEL_TIM3_CC4 = 0xf
	// Position of ALIGN field.
	ADC_CFGR_ALIGN_Pos = 0x5
	// Bit mask of ALIGN field.
	ADC_CFGR_ALIGN_Msk = 0x20
	// Bit ALIGN.
	ADC_CFGR_ALIGN = 0x20
	// Right alignment
	ADC_CFGR_ALIGN_Right = 0x0
	// Left alignment
	ADC_CFGR_ALIGN_Left = 0x1
	// Position of RES field.
	ADC_CFGR_RES_Pos = 0x3
	// Bit mask of RES field.
	ADC_CFGR_RES_Msk = 0x18
	// 12-bit
	ADC_CFGR_RES_Bits12 = 0x0
	// 10-bit
	ADC_CFGR_RES_Bits10 = 0x1
	// 8-bit
	ADC_CFGR_RES_Bits8 = 0x2
	// 6-bit
	ADC_CFGR_RES_Bits6 = 0x3
	// Position of DMACFG field.
	ADC_CFGR_DMACFG_Pos = 0x1
	// Bit mask of DMACFG field.
	ADC_CFGR_DMACFG_Msk = 0x2
	// Bit DMACFG.
	ADC_CFGR_DMACFG = 0x2
	// DMA One Shot Mode selected
	ADC_CFGR_DMACFG_OneShot = 0x0
	// DMA circular mode selected
	ADC_CFGR_DMACFG_Circular = 0x1
	// Position of DMAEN field.
	ADC_CFGR_DMAEN_Pos = 0x0
	// Bit mask of DMAEN field.
	ADC_CFGR_DMAEN_Msk = 0x1
	// Bit DMAEN.
	ADC_CFGR_DMAEN = 0x1
	// DMA disabled
	ADC_CFGR_DMAEN_Disabled = 0x0
	// DMA enabled
	ADC_CFGR_DMAEN_Enabled = 0x1

	// SMPR1: ADC sample time register 1
	// Position of SMP1 field.
	ADC_SMPR1_SMP1_Pos = 0x3
	// Bit mask of SMP1 field.
	ADC_SMPR1_SMP1_Msk = 0x38
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP1_Cycles601_5 = 0x7
	// Position of SMP2 field.
	ADC_SMPR1_SMP2_Pos = 0x6
	// Bit mask of SMP2 field.
	ADC_SMPR1_SMP2_Msk = 0x1c0
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP2_Cycles601_5 = 0x7
	// Position of SMP3 field.
	ADC_SMPR1_SMP3_Pos = 0x9
	// Bit mask of SMP3 field.
	ADC_SMPR1_SMP3_Msk = 0xe00
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP3_Cycles601_5 = 0x7
	// Position of SMP4 field.
	ADC_SMPR1_SMP4_Pos = 0xc
	// Bit mask of SMP4 field.
	ADC_SMPR1_SMP4_Msk = 0x7000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP4_Cycles601_5 = 0x7
	// Position of SMP5 field.
	ADC_SMPR1_SMP5_Pos = 0xf
	// Bit mask of SMP5 field.
	ADC_SMPR1_SMP5_Msk = 0x38000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP5_Cycles601_5 = 0x7
	// Position of SMP6 field.
	ADC_SMPR1_SMP6_Pos = 0x12
	// Bit mask of SMP6 field.
	ADC_SMPR1_SMP6_Msk = 0x1c0000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP6_Cycles601_5 = 0x7
	// Position of SMP7 field.
	ADC_SMPR1_SMP7_Pos = 0x15
	// Bit mask of SMP7 field.
	ADC_SMPR1_SMP7_Msk = 0xe00000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP7_Cycles601_5 = 0x7
	// Position of SMP8 field.
	ADC_SMPR1_SMP8_Pos = 0x18
	// Bit mask of SMP8 field.
	ADC_SMPR1_SMP8_Msk = 0x7000000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP8_Cycles601_5 = 0x7
	// Position of SMP9 field.
	ADC_SMPR1_SMP9_Pos = 0x1b
	// Bit mask of SMP9 field.
	ADC_SMPR1_SMP9_Msk = 0x38000000
	// 1.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR1_SMP9_Cycles601_5 = 0x7

	// SMPR2: ADC sample time register 2
	// Position of SMP10 field.
	ADC_SMPR2_SMP10_Pos = 0x0
	// Bit mask of SMP10 field.
	ADC_SMPR2_SMP10_Msk = 0x7
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP10_Cycles601_5 = 0x7
	// Position of SMP11 field.
	ADC_SMPR2_SMP11_Pos = 0x3
	// Bit mask of SMP11 field.
	ADC_SMPR2_SMP11_Msk = 0x38
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP11_Cycles601_5 = 0x7
	// Position of SMP12 field.
	ADC_SMPR2_SMP12_Pos = 0x6
	// Bit mask of SMP12 field.
	ADC_SMPR2_SMP12_Msk = 0x1c0
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP12_Cycles601_5 = 0x7
	// Position of SMP13 field.
	ADC_SMPR2_SMP13_Pos = 0x9
	// Bit mask of SMP13 field.
	ADC_SMPR2_SMP13_Msk = 0xe00
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP13_Cycles601_5 = 0x7
	// Position of SMP14 field.
	ADC_SMPR2_SMP14_Pos = 0xc
	// Bit mask of SMP14 field.
	ADC_SMPR2_SMP14_Msk = 0x7000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP14_Cycles601_5 = 0x7
	// Position of SMP15 field.
	ADC_SMPR2_SMP15_Pos = 0xf
	// Bit mask of SMP15 field.
	ADC_SMPR2_SMP15_Msk = 0x38000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP15_Cycles601_5 = 0x7
	// Position of SMP16 field.
	ADC_SMPR2_SMP16_Pos = 0x12
	// Bit mask of SMP16 field.
	ADC_SMPR2_SMP16_Msk = 0x1c0000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP16_Cycles601_5 = 0x7
	// Position of SMP17 field.
	ADC_SMPR2_SMP17_Pos = 0x15
	// Bit mask of SMP17 field.
	ADC_SMPR2_SMP17_Msk = 0xe00000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP17_Cycles601_5 = 0x7
	// Position of SMP18 field.
	ADC_SMPR2_SMP18_Pos = 0x18
	// Bit mask of SMP18 field.
	ADC_SMPR2_SMP18_Msk = 0x7000000
	// 1.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles1_5 = 0x0
	// 2.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles2_5 = 0x1
	// 4.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles4_5 = 0x2
	// 7.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles7_5 = 0x3
	// 19.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles19_5 = 0x4
	// 61.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles61_5 = 0x5
	// 181.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles181_5 = 0x6
	// 601.5 ADC clock cycles
	ADC_SMPR2_SMP18_Cycles601_5 = 0x7

	// TR1: ADC watchdog threshold register 1
	// Position of HT1 field.
	ADC_TR1_HT1_Pos = 0x10
	// Bit mask of HT1 field.
	ADC_TR1_HT1_Msk = 0xfff0000
	// Position of LT1 field.
	ADC_TR1_LT1_Pos = 0x0
	// Bit mask of LT1 field.
	ADC_TR1_LT1_Msk = 0xfff

	// TR2: ADC watchdog threshold register 2
	// Position of HT2 field.
	ADC_TR2_HT2_Pos = 0x10
	// Bit mask of HT2 field.
	ADC_TR2_HT2_Msk = 0xff0000
	// Position of LT2 field.
	ADC_TR2_LT2_Pos = 0x0
	// Bit mask of LT2 field.
	ADC_TR2_LT2_Msk = 0xff

	// TR3: read-write
	// Position of HT3 field.
	ADC_TR3_HT3_Pos = 0x10
	// Bit mask of HT3 field.
	ADC_TR3_HT3_Msk = 0xff0000
	// Position of LT3 field.
	ADC_TR3_LT3_Pos = 0x0
	// Bit mask of LT3 field.
	ADC_TR3_LT3_Msk = 0xff

	// SQR1: ADC regular sequence register 1
	// Position of SQ4 field.
	ADC_SQR1_SQ4_Pos = 0x18
	// Bit mask of SQ4 field.
	ADC_SQR1_SQ4_Msk = 0x1f000000
	// Position of SQ3 field.
	ADC_SQR1_SQ3_Pos = 0x12
	// Bit mask of SQ3 field.
	ADC_SQR1_SQ3_Msk = 0x7c0000
	// Position of SQ2 field.
	ADC_SQR1_SQ2_Pos = 0xc
	// Bit mask of SQ2 field.
	ADC_SQR1_SQ2_Msk = 0x1f000
	// Position of SQ1 field.
	ADC_SQR1_SQ1_Pos = 0x6
	// Bit mask of SQ1 field.
	ADC_SQR1_SQ1_Msk = 0x7c0
	// Position of L field.
	ADC_SQR1_L_Pos = 0x0
	// Bit mask of L field.
	ADC_SQR1_L_Msk = 0xf

	// SQR2: ADC regular sequence register 2
	// Position of SQ9 field.
	ADC_SQR2_SQ9_Pos = 0x18
	// Bit mask of SQ9 field.
	ADC_SQR2_SQ9_Msk = 0x1f000000
	// Position of SQ8 field.
	ADC_SQR2_SQ8_Pos = 0x12
	// Bit mask of SQ8 field.
	ADC_SQR2_SQ8_Msk = 0x7c0000
	// Position of SQ7 field.
	ADC_SQR2_SQ7_Pos = 0xc
	// Bit mask of SQ7 field.
	ADC_SQR2_SQ7_Msk = 0x1f000
	// Position of SQ6 field.
	ADC_SQR2_SQ6_Pos = 0x6
	// Bit mask of SQ6 field.
	ADC_SQR2_SQ6_Msk = 0x7c0
	// Position of SQ5 field.
	ADC_SQR2_SQ5_Pos = 0x0
	// Bit mask of SQ5 field.
	ADC_SQR2_SQ5_Msk = 0x1f

	// SQR3: ADC regular sequence register 3
	// Position of SQ14 field.
	ADC_SQR3_SQ14_Pos = 0x18
	// Bit mask of SQ14 field.
	ADC_SQR3_SQ14_Msk = 0x1f000000
	// Position of SQ13 field.
	ADC_SQR3_SQ13_Pos = 0x12
	// Bit mask of SQ13 field.
	ADC_SQR3_SQ13_Msk = 0x7c0000
	// Position of SQ12 field.
	ADC_SQR3_SQ12_Pos = 0xc
	// Bit mask of SQ12 field.
	ADC_SQR3_SQ12_Msk = 0x1f000
	// Position of SQ11 field.
	ADC_SQR3_SQ11_Pos = 0x6
	// Bit mask of SQ11 field.
	ADC_SQR3_SQ11_Msk = 0x7c0
	// Position of SQ10 field.
	ADC_SQR3_SQ10_Pos = 0x0
	// Bit mask of SQ10 field.
	ADC_SQR3_SQ10_Msk = 0x1f

	// SQR4: ADC regular sequence register 4
	// Position of SQ16 field.
	ADC_SQR4_SQ16_Pos = 0x6
	// Bit mask of SQ16 field.
	ADC_SQR4_SQ16_Msk = 0x7c0
	// Position of SQ15 field.
	ADC_SQR4_SQ15_Pos = 0x0
	// Bit mask of SQ15 field.
	ADC_SQR4_SQ15_Msk = 0x1f

	// DR: ADC regular Data Register
	// Position of RDATA field.
	ADC_DR_RDATA_Pos = 0x0
	// Bit mask of RDATA field.
	ADC_DR_RDATA_Msk = 0xffff

	// JSQR: ADC injected sequence register
	// Position of JSQ4 field.
	ADC_JSQR_JSQ4_Pos = 0x1a
	// Bit mask of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0x7c000000
	// Position of JSQ3 field.
	ADC_JSQR_JSQ3_Pos = 0x14
	// Bit mask of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x1f00000
	// Position of JSQ2 field.
	ADC_JSQR_JSQ2_Pos = 0xe
	// Bit mask of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x7c000
	// Position of JSQ1 field.
	ADC_JSQR_JSQ1_Pos = 0x8
	// Bit mask of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f00
	// Position of JEXTEN field.
	ADC_JSQR_JEXTEN_Pos = 0x6
	// Bit mask of JEXTEN field.
	ADC_JSQR_JEXTEN_Msk = 0xc0
	// Trigger detection disabled
	ADC_JSQR_JEXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_JSQR_JEXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_JSQR_JEXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_JSQR_JEXTEN_BothEdges = 0x3
	// Position of JEXTSEL field.
	ADC_JSQR_JEXTSEL_Pos = 0x2
	// Bit mask of JEXTSEL field.
	ADC_JSQR_JEXTSEL_Msk = 0x3c
	// HRTIM_ADCTRG2 event
	ADC_JSQR_JEXTSEL_HRTIM_ADCTRG2 = 0x9
	// HRTIM_ADCTRG4 event
	ADC_JSQR_JEXTSEL_HRTIM_ADCTRG4 = 0xa
	// Timer 1 TRGO event
	ADC_JSQR_JEXTSEL_TIM1_TRGO = 0x0
	// Timer 1 CC4 event
	ADC_JSQR_JEXTSEL_TIM1_CC4 = 0x1
	// Timer 2 TRGO event
	ADC_JSQR_JEXTSEL_TIM2_TRGO = 0x2
	// Timer 2 CC1 event
	ADC_JSQR_JEXTSEL_TIM2_CC1 = 0x3
	// Timer 3 CC4 event
	ADC_JSQR_JEXTSEL_TIM3_CC4 = 0x4
	// EXTI line 15
	ADC_JSQR_JEXTSEL_EXTI15 = 0x6
	// Timer 1 TRGO2 event
	ADC_JSQR_JEXTSEL_TIM1_TRGO2 = 0x8
	// Timer 3 CC3 event
	ADC_JSQR_JEXTSEL_TIM3_CC3 = 0xb
	// Timer 3 TRGO event
	ADC_JSQR_JEXTSEL_TIM3_TRGO = 0xc
	// Timer 3 CC1 event
	ADC_JSQR_JEXTSEL_TIM3_CC1 = 0xd
	// Timer 6 TRGO event
	ADC_JSQR_JEXTSEL_TIM6_TRGO = 0xe
	// Timer 15 TRGO event
	ADC_JSQR_JEXTSEL_TIM15_TRGO = 0xf
	// Position of JL field.
	ADC_JSQR_JL_Pos = 0x0
	// Bit mask of JL field.
	ADC_JSQR_JL_Msk = 0x3

	// OFR1: ADC offset register1
	// Position of OFFSET1_EN field.
	ADC_OFR1_OFFSET1_EN_Pos = 0x1f
	// Bit mask of OFFSET1_EN field.
	ADC_OFR1_OFFSET1_EN_Msk = 0x80000000
	// Bit OFFSET1_EN.
	ADC_OFR1_OFFSET1_EN = 0x80000000
	// Offset disabled
	ADC_OFR1_OFFSET1_EN_Disabled = 0x0
	// Offset enabled
	ADC_OFR1_OFFSET1_EN_Enabled = 0x1
	// Position of OFFSET1_CH field.
	ADC_OFR1_OFFSET1_CH_Pos = 0x1a
	// Bit mask of OFFSET1_CH field.
	ADC_OFR1_OFFSET1_CH_Msk = 0x7c000000
	// Position of OFFSET1 field.
	ADC_OFR1_OFFSET1_Pos = 0x0
	// Bit mask of OFFSET1 field.
	ADC_OFR1_OFFSET1_Msk = 0xfff

	// OFR2: ADC offset register2
	// Position of OFFSET2_EN field.
	ADC_OFR2_OFFSET2_EN_Pos = 0x1f
	// Bit mask of OFFSET2_EN field.
	ADC_OFR2_OFFSET2_EN_Msk = 0x80000000
	// Bit OFFSET2_EN.
	ADC_OFR2_OFFSET2_EN = 0x80000000
	// Offset disabled
	ADC_OFR2_OFFSET2_EN_Disabled = 0x0
	// Offset enabled
	ADC_OFR2_OFFSET2_EN_Enabled = 0x1
	// Position of OFFSET2_CH field.
	ADC_OFR2_OFFSET2_CH_Pos = 0x1a
	// Bit mask of OFFSET2_CH field.
	ADC_OFR2_OFFSET2_CH_Msk = 0x7c000000
	// Position of OFFSET2 field.
	ADC_OFR2_OFFSET2_Pos = 0x0
	// Bit mask of OFFSET2 field.
	ADC_OFR2_OFFSET2_Msk = 0xfff

	// OFR3: ADC offset register3
	// Position of OFFSET3_EN field.
	ADC_OFR3_OFFSET3_EN_Pos = 0x1f
	// Bit mask of OFFSET3_EN field.
	ADC_OFR3_OFFSET3_EN_Msk = 0x80000000
	// Bit OFFSET3_EN.
	ADC_OFR3_OFFSET3_EN = 0x80000000
	// Offset disabled
	ADC_OFR3_OFFSET3_EN_Disabled = 0x0
	// Offset enabled
	ADC_OFR3_OFFSET3_EN_Enabled = 0x1
	// Position of OFFSET3_CH field.
	ADC_OFR3_OFFSET3_CH_Pos = 0x1a
	// Bit mask of OFFSET3_CH field.
	ADC_OFR3_OFFSET3_CH_Msk = 0x7c000000
	// Position of OFFSET3 field.
	ADC_OFR3_OFFSET3_Pos = 0x0
	// Bit mask of OFFSET3 field.
	ADC_OFR3_OFFSET3_Msk = 0xfff

	// OFR4: ADC offset register4
	// Position of OFFSET4_EN field.
	ADC_OFR4_OFFSET4_EN_Pos = 0x1f
	// Bit mask of OFFSET4_EN field.
	ADC_OFR4_OFFSET4_EN_Msk = 0x80000000
	// Bit OFFSET4_EN.
	ADC_OFR4_OFFSET4_EN = 0x80000000
	// Offset disabled
	ADC_OFR4_OFFSET4_EN_Disabled = 0x0
	// Offset enabled
	ADC_OFR4_OFFSET4_EN_Enabled = 0x1
	// Position of OFFSET4_CH field.
	ADC_OFR4_OFFSET4_CH_Pos = 0x1a
	// Bit mask of OFFSET4_CH field.
	ADC_OFR4_OFFSET4_CH_Msk = 0x7c000000
	// Position of OFFSET4 field.
	ADC_OFR4_OFFSET4_Pos = 0x0
	// Bit mask of OFFSET4 field.
	ADC_OFR4_OFFSET4_Msk = 0xfff

	// JDR1: ADC offset register1
	// Position of JDATA field.
	ADC_JDR1_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR1_JDATA_Msk = 0xffff

	// JDR2: ADC offset register2
	// Position of JDATA field.
	ADC_JDR2_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR2_JDATA_Msk = 0xffff

	// JDR3: ADC offset register3
	// Position of JDATA field.
	ADC_JDR3_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR3_JDATA_Msk = 0xffff

	// JDR4: ADC offset register4
	// Position of JDATA field.
	ADC_JDR4_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR4_JDATA_Msk = 0xffff

	// AWD2CR: ADC Analog Watchdog 2 Configuration Register
	// Position of AWD2CH0 field.
	ADC_AWD2CR_AWD2CH0_Pos = 0x1
	// Bit mask of AWD2CH0 field.
	ADC_AWD2CR_AWD2CH0_Msk = 0x2
	// Bit AWD2CH0.
	ADC_AWD2CR_AWD2CH0 = 0x2
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH0_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH0_Monitored = 0x1
	// Position of AWD2CH1 field.
	ADC_AWD2CR_AWD2CH1_Pos = 0x2
	// Bit mask of AWD2CH1 field.
	ADC_AWD2CR_AWD2CH1_Msk = 0x4
	// Bit AWD2CH1.
	ADC_AWD2CR_AWD2CH1 = 0x4
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH1_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH1_Monitored = 0x1
	// Position of AWD2CH2 field.
	ADC_AWD2CR_AWD2CH2_Pos = 0x3
	// Bit mask of AWD2CH2 field.
	ADC_AWD2CR_AWD2CH2_Msk = 0x8
	// Bit AWD2CH2.
	ADC_AWD2CR_AWD2CH2 = 0x8
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH2_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH2_Monitored = 0x1
	// Position of AWD2CH3 field.
	ADC_AWD2CR_AWD2CH3_Pos = 0x4
	// Bit mask of AWD2CH3 field.
	ADC_AWD2CR_AWD2CH3_Msk = 0x10
	// Bit AWD2CH3.
	ADC_AWD2CR_AWD2CH3 = 0x10
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH3_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH3_Monitored = 0x1
	// Position of AWD2CH4 field.
	ADC_AWD2CR_AWD2CH4_Pos = 0x5
	// Bit mask of AWD2CH4 field.
	ADC_AWD2CR_AWD2CH4_Msk = 0x20
	// Bit AWD2CH4.
	ADC_AWD2CR_AWD2CH4 = 0x20
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH4_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH4_Monitored = 0x1
	// Position of AWD2CH5 field.
	ADC_AWD2CR_AWD2CH5_Pos = 0x6
	// Bit mask of AWD2CH5 field.
	ADC_AWD2CR_AWD2CH5_Msk = 0x40
	// Bit AWD2CH5.
	ADC_AWD2CR_AWD2CH5 = 0x40
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH5_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH5_Monitored = 0x1
	// Position of AWD2CH6 field.
	ADC_AWD2CR_AWD2CH6_Pos = 0x7
	// Bit mask of AWD2CH6 field.
	ADC_AWD2CR_AWD2CH6_Msk = 0x80
	// Bit AWD2CH6.
	ADC_AWD2CR_AWD2CH6 = 0x80
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH6_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH6_Monitored = 0x1
	// Position of AWD2CH7 field.
	ADC_AWD2CR_AWD2CH7_Pos = 0x8
	// Bit mask of AWD2CH7 field.
	ADC_AWD2CR_AWD2CH7_Msk = 0x100
	// Bit AWD2CH7.
	ADC_AWD2CR_AWD2CH7 = 0x100
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH7_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH7_Monitored = 0x1
	// Position of AWD2CH8 field.
	ADC_AWD2CR_AWD2CH8_Pos = 0x9
	// Bit mask of AWD2CH8 field.
	ADC_AWD2CR_AWD2CH8_Msk = 0x200
	// Bit AWD2CH8.
	ADC_AWD2CR_AWD2CH8 = 0x200
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH8_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH8_Monitored = 0x1
	// Position of AWD2CH9 field.
	ADC_AWD2CR_AWD2CH9_Pos = 0xa
	// Bit mask of AWD2CH9 field.
	ADC_AWD2CR_AWD2CH9_Msk = 0x400
	// Bit AWD2CH9.
	ADC_AWD2CR_AWD2CH9 = 0x400
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH9_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH9_Monitored = 0x1
	// Position of AWD2CH10 field.
	ADC_AWD2CR_AWD2CH10_Pos = 0xb
	// Bit mask of AWD2CH10 field.
	ADC_AWD2CR_AWD2CH10_Msk = 0x800
	// Bit AWD2CH10.
	ADC_AWD2CR_AWD2CH10 = 0x800
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH10_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH10_Monitored = 0x1
	// Position of AWD2CH11 field.
	ADC_AWD2CR_AWD2CH11_Pos = 0xc
	// Bit mask of AWD2CH11 field.
	ADC_AWD2CR_AWD2CH11_Msk = 0x1000
	// Bit AWD2CH11.
	ADC_AWD2CR_AWD2CH11 = 0x1000
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH11_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH11_Monitored = 0x1
	// Position of AWD2CH12 field.
	ADC_AWD2CR_AWD2CH12_Pos = 0xd
	// Bit mask of AWD2CH12 field.
	ADC_AWD2CR_AWD2CH12_Msk = 0x2000
	// Bit AWD2CH12.
	ADC_AWD2CR_AWD2CH12 = 0x2000
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH12_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH12_Monitored = 0x1
	// Position of AWD2CH13 field.
	ADC_AWD2CR_AWD2CH13_Pos = 0xe
	// Bit mask of AWD2CH13 field.
	ADC_AWD2CR_AWD2CH13_Msk = 0x4000
	// Bit AWD2CH13.
	ADC_AWD2CR_AWD2CH13 = 0x4000
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH13_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH13_Monitored = 0x1
	// Position of AWD2CH14 field.
	ADC_AWD2CR_AWD2CH14_Pos = 0xf
	// Bit mask of AWD2CH14 field.
	ADC_AWD2CR_AWD2CH14_Msk = 0x8000
	// Bit AWD2CH14.
	ADC_AWD2CR_AWD2CH14 = 0x8000
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH14_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH14_Monitored = 0x1
	// Position of AWD2CH15 field.
	ADC_AWD2CR_AWD2CH15_Pos = 0x10
	// Bit mask of AWD2CH15 field.
	ADC_AWD2CR_AWD2CH15_Msk = 0x10000
	// Bit AWD2CH15.
	ADC_AWD2CR_AWD2CH15 = 0x10000
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH15_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH15_Monitored = 0x1
	// Position of AWD2CH16 field.
	ADC_AWD2CR_AWD2CH16_Pos = 0x11
	// Bit mask of AWD2CH16 field.
	ADC_AWD2CR_AWD2CH16_Msk = 0x20000
	// Bit AWD2CH16.
	ADC_AWD2CR_AWD2CH16 = 0x20000
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH16_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH16_Monitored = 0x1
	// Position of AWD2CH17 field.
	ADC_AWD2CR_AWD2CH17_Pos = 0x12
	// Bit mask of AWD2CH17 field.
	ADC_AWD2CR_AWD2CH17_Msk = 0x40000
	// Bit AWD2CH17.
	ADC_AWD2CR_AWD2CH17 = 0x40000
	// Input channel not monitored by AWDx
	ADC_AWD2CR_AWD2CH17_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD2CR_AWD2CH17_Monitored = 0x1

	// AWD3CR: ADC Analog Watchdog 3 Configuration Register
	// Position of AWD3CH0 field.
	ADC_AWD3CR_AWD3CH0_Pos = 0x1
	// Bit mask of AWD3CH0 field.
	ADC_AWD3CR_AWD3CH0_Msk = 0x2
	// Bit AWD3CH0.
	ADC_AWD3CR_AWD3CH0 = 0x2
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH0_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH0_Monitored = 0x1
	// Position of AWD3CH1 field.
	ADC_AWD3CR_AWD3CH1_Pos = 0x2
	// Bit mask of AWD3CH1 field.
	ADC_AWD3CR_AWD3CH1_Msk = 0x4
	// Bit AWD3CH1.
	ADC_AWD3CR_AWD3CH1 = 0x4
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH1_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH1_Monitored = 0x1
	// Position of AWD3CH2 field.
	ADC_AWD3CR_AWD3CH2_Pos = 0x3
	// Bit mask of AWD3CH2 field.
	ADC_AWD3CR_AWD3CH2_Msk = 0x8
	// Bit AWD3CH2.
	ADC_AWD3CR_AWD3CH2 = 0x8
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH2_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH2_Monitored = 0x1
	// Position of AWD3CH3 field.
	ADC_AWD3CR_AWD3CH3_Pos = 0x4
	// Bit mask of AWD3CH3 field.
	ADC_AWD3CR_AWD3CH3_Msk = 0x10
	// Bit AWD3CH3.
	ADC_AWD3CR_AWD3CH3 = 0x10
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH3_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH3_Monitored = 0x1
	// Position of AWD3CH4 field.
	ADC_AWD3CR_AWD3CH4_Pos = 0x5
	// Bit mask of AWD3CH4 field.
	ADC_AWD3CR_AWD3CH4_Msk = 0x20
	// Bit AWD3CH4.
	ADC_AWD3CR_AWD3CH4 = 0x20
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH4_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH4_Monitored = 0x1
	// Position of AWD3CH5 field.
	ADC_AWD3CR_AWD3CH5_Pos = 0x6
	// Bit mask of AWD3CH5 field.
	ADC_AWD3CR_AWD3CH5_Msk = 0x40
	// Bit AWD3CH5.
	ADC_AWD3CR_AWD3CH5 = 0x40
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH5_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH5_Monitored = 0x1
	// Position of AWD3CH6 field.
	ADC_AWD3CR_AWD3CH6_Pos = 0x7
	// Bit mask of AWD3CH6 field.
	ADC_AWD3CR_AWD3CH6_Msk = 0x80
	// Bit AWD3CH6.
	ADC_AWD3CR_AWD3CH6 = 0x80
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH6_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH6_Monitored = 0x1
	// Position of AWD3CH7 field.
	ADC_AWD3CR_AWD3CH7_Pos = 0x8
	// Bit mask of AWD3CH7 field.
	ADC_AWD3CR_AWD3CH7_Msk = 0x100
	// Bit AWD3CH7.
	ADC_AWD3CR_AWD3CH7 = 0x100
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH7_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH7_Monitored = 0x1
	// Position of AWD3CH8 field.
	ADC_AWD3CR_AWD3CH8_Pos = 0x9
	// Bit mask of AWD3CH8 field.
	ADC_AWD3CR_AWD3CH8_Msk = 0x200
	// Bit AWD3CH8.
	ADC_AWD3CR_AWD3CH8 = 0x200
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH8_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH8_Monitored = 0x1
	// Position of AWD3CH9 field.
	ADC_AWD3CR_AWD3CH9_Pos = 0xa
	// Bit mask of AWD3CH9 field.
	ADC_AWD3CR_AWD3CH9_Msk = 0x400
	// Bit AWD3CH9.
	ADC_AWD3CR_AWD3CH9 = 0x400
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH9_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH9_Monitored = 0x1
	// Position of AWD3CH10 field.
	ADC_AWD3CR_AWD3CH10_Pos = 0xb
	// Bit mask of AWD3CH10 field.
	ADC_AWD3CR_AWD3CH10_Msk = 0x800
	// Bit AWD3CH10.
	ADC_AWD3CR_AWD3CH10 = 0x800
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH10_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH10_Monitored = 0x1
	// Position of AWD3CH11 field.
	ADC_AWD3CR_AWD3CH11_Pos = 0xc
	// Bit mask of AWD3CH11 field.
	ADC_AWD3CR_AWD3CH11_Msk = 0x1000
	// Bit AWD3CH11.
	ADC_AWD3CR_AWD3CH11 = 0x1000
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH11_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH11_Monitored = 0x1
	// Position of AWD3CH12 field.
	ADC_AWD3CR_AWD3CH12_Pos = 0xd
	// Bit mask of AWD3CH12 field.
	ADC_AWD3CR_AWD3CH12_Msk = 0x2000
	// Bit AWD3CH12.
	ADC_AWD3CR_AWD3CH12 = 0x2000
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH12_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH12_Monitored = 0x1
	// Position of AWD3CH13 field.
	ADC_AWD3CR_AWD3CH13_Pos = 0xe
	// Bit mask of AWD3CH13 field.
	ADC_AWD3CR_AWD3CH13_Msk = 0x4000
	// Bit AWD3CH13.
	ADC_AWD3CR_AWD3CH13 = 0x4000
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH13_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH13_Monitored = 0x1
	// Position of AWD3CH14 field.
	ADC_AWD3CR_AWD3CH14_Pos = 0xf
	// Bit mask of AWD3CH14 field.
	ADC_AWD3CR_AWD3CH14_Msk = 0x8000
	// Bit AWD3CH14.
	ADC_AWD3CR_AWD3CH14 = 0x8000
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH14_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH14_Monitored = 0x1
	// Position of AWD3CH15 field.
	ADC_AWD3CR_AWD3CH15_Pos = 0x10
	// Bit mask of AWD3CH15 field.
	ADC_AWD3CR_AWD3CH15_Msk = 0x10000
	// Bit AWD3CH15.
	ADC_AWD3CR_AWD3CH15 = 0x10000
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH15_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH15_Monitored = 0x1
	// Position of AWD3CH16 field.
	ADC_AWD3CR_AWD3CH16_Pos = 0x11
	// Bit mask of AWD3CH16 field.
	ADC_AWD3CR_AWD3CH16_Msk = 0x20000
	// Bit AWD3CH16.
	ADC_AWD3CR_AWD3CH16 = 0x20000
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH16_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH16_Monitored = 0x1
	// Position of AWD3CH17 field.
	ADC_AWD3CR_AWD3CH17_Pos = 0x12
	// Bit mask of AWD3CH17 field.
	ADC_AWD3CR_AWD3CH17_Msk = 0x40000
	// Bit AWD3CH17.
	ADC_AWD3CR_AWD3CH17 = 0x40000
	// Input channel not monitored by AWDx
	ADC_AWD3CR_AWD3CH17_NotMonitored = 0x0
	// Input channel monitored by AWDx
	ADC_AWD3CR_AWD3CH17_Monitored = 0x1

	// DIFSEL: ADC Differential Mode Selection Register
	// Position of DIFSEL0 field.
	ADC_DIFSEL_DIFSEL0_Pos = 0x1
	// Bit mask of DIFSEL0 field.
	ADC_DIFSEL_DIFSEL0_Msk = 0x2
	// Bit DIFSEL0.
	ADC_DIFSEL_DIFSEL0 = 0x2
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL0_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL0_Differential = 0x1
	// Position of DIFSEL1 field.
	ADC_DIFSEL_DIFSEL1_Pos = 0x2
	// Bit mask of DIFSEL1 field.
	ADC_DIFSEL_DIFSEL1_Msk = 0x4
	// Bit DIFSEL1.
	ADC_DIFSEL_DIFSEL1 = 0x4
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL1_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL1_Differential = 0x1
	// Position of DIFSEL2 field.
	ADC_DIFSEL_DIFSEL2_Pos = 0x3
	// Bit mask of DIFSEL2 field.
	ADC_DIFSEL_DIFSEL2_Msk = 0x8
	// Bit DIFSEL2.
	ADC_DIFSEL_DIFSEL2 = 0x8
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL2_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL2_Differential = 0x1
	// Position of DIFSEL3 field.
	ADC_DIFSEL_DIFSEL3_Pos = 0x4
	// Bit mask of DIFSEL3 field.
	ADC_DIFSEL_DIFSEL3_Msk = 0x10
	// Bit DIFSEL3.
	ADC_DIFSEL_DIFSEL3 = 0x10
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL3_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL3_Differential = 0x1
	// Position of DIFSEL4 field.
	ADC_DIFSEL_DIFSEL4_Pos = 0x5
	// Bit mask of DIFSEL4 field.
	ADC_DIFSEL_DIFSEL4_Msk = 0x20
	// Bit DIFSEL4.
	ADC_DIFSEL_DIFSEL4 = 0x20
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL4_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL4_Differential = 0x1
	// Position of DIFSEL5 field.
	ADC_DIFSEL_DIFSEL5_Pos = 0x6
	// Bit mask of DIFSEL5 field.
	ADC_DIFSEL_DIFSEL5_Msk = 0x40
	// Bit DIFSEL5.
	ADC_DIFSEL_DIFSEL5 = 0x40
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL5_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL5_Differential = 0x1
	// Position of DIFSEL6 field.
	ADC_DIFSEL_DIFSEL6_Pos = 0x7
	// Bit mask of DIFSEL6 field.
	ADC_DIFSEL_DIFSEL6_Msk = 0x80
	// Bit DIFSEL6.
	ADC_DIFSEL_DIFSEL6 = 0x80
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL6_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL6_Differential = 0x1
	// Position of DIFSEL7 field.
	ADC_DIFSEL_DIFSEL7_Pos = 0x8
	// Bit mask of DIFSEL7 field.
	ADC_DIFSEL_DIFSEL7_Msk = 0x100
	// Bit DIFSEL7.
	ADC_DIFSEL_DIFSEL7 = 0x100
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL7_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL7_Differential = 0x1
	// Position of DIFSEL8 field.
	ADC_DIFSEL_DIFSEL8_Pos = 0x9
	// Bit mask of DIFSEL8 field.
	ADC_DIFSEL_DIFSEL8_Msk = 0x200
	// Bit DIFSEL8.
	ADC_DIFSEL_DIFSEL8 = 0x200
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL8_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL8_Differential = 0x1
	// Position of DIFSEL9 field.
	ADC_DIFSEL_DIFSEL9_Pos = 0xa
	// Bit mask of DIFSEL9 field.
	ADC_DIFSEL_DIFSEL9_Msk = 0x400
	// Bit DIFSEL9.
	ADC_DIFSEL_DIFSEL9 = 0x400
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL9_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL9_Differential = 0x1
	// Position of DIFSEL10 field.
	ADC_DIFSEL_DIFSEL10_Pos = 0xb
	// Bit mask of DIFSEL10 field.
	ADC_DIFSEL_DIFSEL10_Msk = 0x800
	// Bit DIFSEL10.
	ADC_DIFSEL_DIFSEL10 = 0x800
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL10_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL10_Differential = 0x1
	// Position of DIFSEL11 field.
	ADC_DIFSEL_DIFSEL11_Pos = 0xc
	// Bit mask of DIFSEL11 field.
	ADC_DIFSEL_DIFSEL11_Msk = 0x1000
	// Bit DIFSEL11.
	ADC_DIFSEL_DIFSEL11 = 0x1000
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL11_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL11_Differential = 0x1
	// Position of DIFSEL12 field.
	ADC_DIFSEL_DIFSEL12_Pos = 0xd
	// Bit mask of DIFSEL12 field.
	ADC_DIFSEL_DIFSEL12_Msk = 0x2000
	// Bit DIFSEL12.
	ADC_DIFSEL_DIFSEL12 = 0x2000
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL12_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL12_Differential = 0x1
	// Position of DIFSEL13 field.
	ADC_DIFSEL_DIFSEL13_Pos = 0xe
	// Bit mask of DIFSEL13 field.
	ADC_DIFSEL_DIFSEL13_Msk = 0x4000
	// Bit DIFSEL13.
	ADC_DIFSEL_DIFSEL13 = 0x4000
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL13_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL13_Differential = 0x1
	// Position of DIFSEL14 field.
	ADC_DIFSEL_DIFSEL14_Pos = 0xf
	// Bit mask of DIFSEL14 field.
	ADC_DIFSEL_DIFSEL14_Msk = 0x8000
	// Bit DIFSEL14.
	ADC_DIFSEL_DIFSEL14 = 0x8000
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL14_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL14_Differential = 0x1
	// Position of DIFSEL15 field.
	ADC_DIFSEL_DIFSEL15_Pos = 0x10
	// Bit mask of DIFSEL15 field.
	ADC_DIFSEL_DIFSEL15_Msk = 0x10000
	// Bit DIFSEL15.
	ADC_DIFSEL_DIFSEL15 = 0x10000
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL15_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL15_Differential = 0x1
	// Position of DIFSEL16 field.
	ADC_DIFSEL_DIFSEL16_Pos = 0x11
	// Bit mask of DIFSEL16 field.
	ADC_DIFSEL_DIFSEL16_Msk = 0x20000
	// Bit DIFSEL16.
	ADC_DIFSEL_DIFSEL16 = 0x20000
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL16_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL16_Differential = 0x1
	// Position of DIFSEL17 field.
	ADC_DIFSEL_DIFSEL17_Pos = 0x12
	// Bit mask of DIFSEL17 field.
	ADC_DIFSEL_DIFSEL17_Msk = 0x40000
	// Bit DIFSEL17.
	ADC_DIFSEL_DIFSEL17 = 0x40000
	// Input channel is configured in single-ended mode
	ADC_DIFSEL_DIFSEL17_SingleEnded = 0x0
	// Input channel is configured in differential mode
	ADC_DIFSEL_DIFSEL17_Differential = 0x1

	// CALFACT: ADC Calibration Factors
	// Position of CALFACT_D field.
	ADC_CALFACT_CALFACT_D_Pos = 0x10
	// Bit mask of CALFACT_D field.
	ADC_CALFACT_CALFACT_D_Msk = 0x7f0000
	// Position of CALFACT_S field.
	ADC_CALFACT_CALFACT_S_Pos = 0x0
	// Bit mask of CALFACT_S field.
	ADC_CALFACT_CALFACT_S_Msk = 0x7f
)

// Constants for CEC: HDMI-CEC controller
const (
	// CR: control register
	// Position of TXEOM field.
	CEC_CR_TXEOM_Pos = 0x2
	// Bit mask of TXEOM field.
	CEC_CR_TXEOM_Msk = 0x4
	// Bit TXEOM.
	CEC_CR_TXEOM = 0x4
	// Position of TXSOM field.
	CEC_CR_TXSOM_Pos = 0x1
	// Bit mask of TXSOM field.
	CEC_CR_TXSOM_Msk = 0x2
	// Bit TXSOM.
	CEC_CR_TXSOM = 0x2
	// Position of CECEN field.
	CEC_CR_CECEN_Pos = 0x0
	// Bit mask of CECEN field.
	CEC_CR_CECEN_Msk = 0x1
	// Bit CECEN.
	CEC_CR_CECEN = 0x1

	// CFGR: configuration register
	// Position of LBPEGEN field.
	CEC_CFGR_LBPEGEN_Pos = 0xb
	// Bit mask of LBPEGEN field.
	CEC_CFGR_LBPEGEN_Msk = 0x800
	// Bit LBPEGEN.
	CEC_CFGR_LBPEGEN = 0x800
	// Position of BREGEN field.
	CEC_CFGR_BREGEN_Pos = 0xa
	// Bit mask of BREGEN field.
	CEC_CFGR_BREGEN_Msk = 0x400
	// Bit BREGEN.
	CEC_CFGR_BREGEN = 0x400
	// Position of BRESTP field.
	CEC_CFGR_BRESTP_Pos = 0x9
	// Bit mask of BRESTP field.
	CEC_CFGR_BRESTP_Msk = 0x200
	// Bit BRESTP.
	CEC_CFGR_BRESTP = 0x200
	// Position of RXTOL field.
	CEC_CFGR_RXTOL_Pos = 0x8
	// Bit mask of RXTOL field.
	CEC_CFGR_RXTOL_Msk = 0x100
	// Bit RXTOL.
	CEC_CFGR_RXTOL = 0x100
	// Position of SFT field.
	CEC_CFGR_SFT_Pos = 0x5
	// Bit mask of SFT field.
	CEC_CFGR_SFT_Msk = 0xe0
	// Position of LSTN field.
	CEC_CFGR_LSTN_Pos = 0x4
	// Bit mask of LSTN field.
	CEC_CFGR_LSTN_Msk = 0x10
	// Bit LSTN.
	CEC_CFGR_LSTN = 0x10
	// Position of OAR field.
	CEC_CFGR_OAR_Pos = 0x0
	// Bit mask of OAR field.
	CEC_CFGR_OAR_Msk = 0xf

	// TXDR: Tx data register
	// Position of TXD field.
	CEC_TXDR_TXD_Pos = 0x0
	// Bit mask of TXD field.
	CEC_TXDR_TXD_Msk = 0xff

	// RXDR: Rx Data Register
	// Position of RXDR field.
	CEC_RXDR_RXDR_Pos = 0x0
	// Bit mask of RXDR field.
	CEC_RXDR_RXDR_Msk = 0xff

	// ISR: Interrupt and Status Register
	// Position of TXACKE field.
	CEC_ISR_TXACKE_Pos = 0xc
	// Bit mask of TXACKE field.
	CEC_ISR_TXACKE_Msk = 0x1000
	// Bit TXACKE.
	CEC_ISR_TXACKE = 0x1000
	// Position of TXERR field.
	CEC_ISR_TXERR_Pos = 0xb
	// Bit mask of TXERR field.
	CEC_ISR_TXERR_Msk = 0x800
	// Bit TXERR.
	CEC_ISR_TXERR = 0x800
	// Position of TXUDR field.
	CEC_ISR_TXUDR_Pos = 0xa
	// Bit mask of TXUDR field.
	CEC_ISR_TXUDR_Msk = 0x400
	// Bit TXUDR.
	CEC_ISR_TXUDR = 0x400
	// Position of TXEND field.
	CEC_ISR_TXEND_Pos = 0x9
	// Bit mask of TXEND field.
	CEC_ISR_TXEND_Msk = 0x200
	// Bit TXEND.
	CEC_ISR_TXEND = 0x200
	// Position of TXBR field.
	CEC_ISR_TXBR_Pos = 0x8
	// Bit mask of TXBR field.
	CEC_ISR_TXBR_Msk = 0x100
	// Bit TXBR.
	CEC_ISR_TXBR = 0x100
	// Position of ARBLST field.
	CEC_ISR_ARBLST_Pos = 0x7
	// Bit mask of ARBLST field.
	CEC_ISR_ARBLST_Msk = 0x80
	// Bit ARBLST.
	CEC_ISR_ARBLST = 0x80
	// Position of RXACKE field.
	CEC_ISR_RXACKE_Pos = 0x6
	// Bit mask of RXACKE field.
	CEC_ISR_RXACKE_Msk = 0x40
	// Bit RXACKE.
	CEC_ISR_RXACKE = 0x40
	// Position of LBPE field.
	CEC_ISR_LBPE_Pos = 0x5
	// Bit mask of LBPE field.
	CEC_ISR_LBPE_Msk = 0x20
	// Bit LBPE.
	CEC_ISR_LBPE = 0x20
	// Position of SBPE field.
	CEC_ISR_SBPE_Pos = 0x4
	// Bit mask of SBPE field.
	CEC_ISR_SBPE_Msk = 0x10
	// Bit SBPE.
	CEC_ISR_SBPE = 0x10
	// Position of BRE field.
	CEC_ISR_BRE_Pos = 0x3
	// Bit mask of BRE field.
	CEC_ISR_BRE_Msk = 0x8
	// Bit BRE.
	CEC_ISR_BRE = 0x8
	// Position of RXOVR field.
	CEC_ISR_RXOVR_Pos = 0x2
	// Bit mask of RXOVR field.
	CEC_ISR_RXOVR_Msk = 0x4
	// Bit RXOVR.
	CEC_ISR_RXOVR = 0x4
	// Position of RXEND field.
	CEC_ISR_RXEND_Pos = 0x1
	// Bit mask of RXEND field.
	CEC_ISR_RXEND_Msk = 0x2
	// Bit RXEND.
	CEC_ISR_RXEND = 0x2
	// Position of RXBR field.
	CEC_ISR_RXBR_Pos = 0x0
	// Bit mask of RXBR field.
	CEC_ISR_RXBR_Msk = 0x1
	// Bit RXBR.
	CEC_ISR_RXBR = 0x1

	// IER: interrupt enable register
	// Position of TXACKIE field.
	CEC_IER_TXACKIE_Pos = 0xc
	// Bit mask of TXACKIE field.
	CEC_IER_TXACKIE_Msk = 0x1000
	// Bit TXACKIE.
	CEC_IER_TXACKIE = 0x1000
	// Position of TXERRIE field.
	CEC_IER_TXERRIE_Pos = 0xb
	// Bit mask of TXERRIE field.
	CEC_IER_TXERRIE_Msk = 0x800
	// Bit TXERRIE.
	CEC_IER_TXERRIE = 0x800
	// Position of TXUDRIE field.
	CEC_IER_TXUDRIE_Pos = 0xa
	// Bit mask of TXUDRIE field.
	CEC_IER_TXUDRIE_Msk = 0x400
	// Bit TXUDRIE.
	CEC_IER_TXUDRIE = 0x400
	// Position of TXENDIE field.
	CEC_IER_TXENDIE_Pos = 0x9
	// Bit mask of TXENDIE field.
	CEC_IER_TXENDIE_Msk = 0x200
	// Bit TXENDIE.
	CEC_IER_TXENDIE = 0x200
	// Position of TXBRIE field.
	CEC_IER_TXBRIE_Pos = 0x8
	// Bit mask of TXBRIE field.
	CEC_IER_TXBRIE_Msk = 0x100
	// Bit TXBRIE.
	CEC_IER_TXBRIE = 0x100
	// Position of ARBLSTIE field.
	CEC_IER_ARBLSTIE_Pos = 0x7
	// Bit mask of ARBLSTIE field.
	CEC_IER_ARBLSTIE_Msk = 0x80
	// Bit ARBLSTIE.
	CEC_IER_ARBLSTIE = 0x80
	// Position of RXACKIE field.
	CEC_IER_RXACKIE_Pos = 0x6
	// Bit mask of RXACKIE field.
	CEC_IER_RXACKIE_Msk = 0x40
	// Bit RXACKIE.
	CEC_IER_RXACKIE = 0x40
	// Position of LBPEIE field.
	CEC_IER_LBPEIE_Pos = 0x5
	// Bit mask of LBPEIE field.
	CEC_IER_LBPEIE_Msk = 0x20
	// Bit LBPEIE.
	CEC_IER_LBPEIE = 0x20
	// Position of SBPEIE field.
	CEC_IER_SBPEIE_Pos = 0x4
	// Bit mask of SBPEIE field.
	CEC_IER_SBPEIE_Msk = 0x10
	// Bit SBPEIE.
	CEC_IER_SBPEIE = 0x10
	// Position of BREIE field.
	CEC_IER_BREIE_Pos = 0x3
	// Bit mask of BREIE field.
	CEC_IER_BREIE_Msk = 0x8
	// Bit BREIE.
	CEC_IER_BREIE = 0x8
	// Position of RXOVRIE field.
	CEC_IER_RXOVRIE_Pos = 0x2
	// Bit mask of RXOVRIE field.
	CEC_IER_RXOVRIE_Msk = 0x4
	// Bit RXOVRIE.
	CEC_IER_RXOVRIE = 0x4
	// Position of RXENDIE field.
	CEC_IER_RXENDIE_Pos = 0x1
	// Bit mask of RXENDIE field.
	CEC_IER_RXENDIE_Msk = 0x2
	// Bit RXENDIE.
	CEC_IER_RXENDIE = 0x2
	// Position of RXBRIE field.
	CEC_IER_RXBRIE_Pos = 0x0
	// Bit mask of RXBRIE field.
	CEC_IER_RXBRIE_Msk = 0x1
	// Bit RXBRIE.
	CEC_IER_RXBRIE = 0x1
)

// Constants for PWR: Power control
const (
	// CR: power control register
	// Position of LPDS field.
	PWR_CR_LPDS_Pos = 0x0
	// Bit mask of LPDS field.
	PWR_CR_LPDS_Msk = 0x1
	// Bit LPDS.
	PWR_CR_LPDS = 0x1
	// Position of PDDS field.
	PWR_CR_PDDS_Pos = 0x1
	// Bit mask of PDDS field.
	PWR_CR_PDDS_Msk = 0x2
	// Bit PDDS.
	PWR_CR_PDDS = 0x2
	// Position of CWUF field.
	PWR_CR_CWUF_Pos = 0x2
	// Bit mask of CWUF field.
	PWR_CR_CWUF_Msk = 0x4
	// Bit CWUF.
	PWR_CR_CWUF = 0x4
	// Position of CSBF field.
	PWR_CR_CSBF_Pos = 0x3
	// Bit mask of CSBF field.
	PWR_CR_CSBF_Msk = 0x8
	// Bit CSBF.
	PWR_CR_CSBF = 0x8
	// Position of PVDE field.
	PWR_CR_PVDE_Pos = 0x4
	// Bit mask of PVDE field.
	PWR_CR_PVDE_Msk = 0x10
	// Bit PVDE.
	PWR_CR_PVDE = 0x10
	// Position of PLS field.
	PWR_CR_PLS_Pos = 0x5
	// Bit mask of PLS field.
	PWR_CR_PLS_Msk = 0xe0
	// Position of DBP field.
	PWR_CR_DBP_Pos = 0x8
	// Bit mask of DBP field.
	PWR_CR_DBP_Msk = 0x100
	// Bit DBP.
	PWR_CR_DBP = 0x100
	// Position of ENSD1 field.
	PWR_CR_ENSD1_Pos = 0x9
	// Bit mask of ENSD1 field.
	PWR_CR_ENSD1_Msk = 0x200
	// Bit ENSD1.
	PWR_CR_ENSD1 = 0x200
	// Position of ENSD2 field.
	PWR_CR_ENSD2_Pos = 0xa
	// Bit mask of ENSD2 field.
	PWR_CR_ENSD2_Msk = 0x400
	// Bit ENSD2.
	PWR_CR_ENSD2 = 0x400
	// Position of ENSD3 field.
	PWR_CR_ENSD3_Pos = 0xb
	// Bit mask of ENSD3 field.
	PWR_CR_ENSD3_Msk = 0x800
	// Bit ENSD3.
	PWR_CR_ENSD3 = 0x800

	// CSR: power control/status register
	// Position of WUF field.
	PWR_CSR_WUF_Pos = 0x0
	// Bit mask of WUF field.
	PWR_CSR_WUF_Msk = 0x1
	// Bit WUF.
	PWR_CSR_WUF = 0x1
	// Position of SBF field.
	PWR_CSR_SBF_Pos = 0x1
	// Bit mask of SBF field.
	PWR_CSR_SBF_Msk = 0x2
	// Bit SBF.
	PWR_CSR_SBF = 0x2
	// Position of PVDO field.
	PWR_CSR_PVDO_Pos = 0x2
	// Bit mask of PVDO field.
	PWR_CSR_PVDO_Msk = 0x4
	// Bit PVDO.
	PWR_CSR_PVDO = 0x4
	// Position of EWUP1 field.
	PWR_CSR_EWUP1_Pos = 0x8
	// Bit mask of EWUP1 field.
	PWR_CSR_EWUP1_Msk = 0x100
	// Bit EWUP1.
	PWR_CSR_EWUP1 = 0x100
	// Position of EWUP2 field.
	PWR_CSR_EWUP2_Pos = 0x9
	// Bit mask of EWUP2 field.
	PWR_CSR_EWUP2_Msk = 0x200
	// Bit EWUP2.
	PWR_CSR_EWUP2 = 0x200
	// Position of EWUP3 field.
	PWR_CSR_EWUP3_Pos = 0xa
	// Bit mask of EWUP3 field.
	PWR_CSR_EWUP3_Msk = 0x400
	// Bit EWUP3.
	PWR_CSR_EWUP3 = 0x400
)

// Constants for CAN: Controller area network
const (
	// MCR: master control register
	// Position of DBF field.
	CAN_MCR_DBF_Pos = 0x10
	// Bit mask of DBF field.
	CAN_MCR_DBF_Msk = 0x10000
	// Bit DBF.
	CAN_MCR_DBF = 0x10000
	// Position of RESET field.
	CAN_MCR_RESET_Pos = 0xf
	// Bit mask of RESET field.
	CAN_MCR_RESET_Msk = 0x8000
	// Bit RESET.
	CAN_MCR_RESET = 0x8000
	// Position of TTCM field.
	CAN_MCR_TTCM_Pos = 0x7
	// Bit mask of TTCM field.
	CAN_MCR_TTCM_Msk = 0x80
	// Bit TTCM.
	CAN_MCR_TTCM = 0x80
	// Position of ABOM field.
	CAN_MCR_ABOM_Pos = 0x6
	// Bit mask of ABOM field.
	CAN_MCR_ABOM_Msk = 0x40
	// Bit ABOM.
	CAN_MCR_ABOM = 0x40
	// Position of AWUM field.
	CAN_MCR_AWUM_Pos = 0x5
	// Bit mask of AWUM field.
	CAN_MCR_AWUM_Msk = 0x20
	// Bit AWUM.
	CAN_MCR_AWUM = 0x20
	// Position of NART field.
	CAN_MCR_NART_Pos = 0x4
	// Bit mask of NART field.
	CAN_MCR_NART_Msk = 0x10
	// Bit NART.
	CAN_MCR_NART = 0x10
	// Position of RFLM field.
	CAN_MCR_RFLM_Pos = 0x3
	// Bit mask of RFLM field.
	CAN_MCR_RFLM_Msk = 0x8
	// Bit RFLM.
	CAN_MCR_RFLM = 0x8
	// Position of TXFP field.
	CAN_MCR_TXFP_Pos = 0x2
	// Bit mask of TXFP field.
	CAN_MCR_TXFP_Msk = 0x4
	// Bit TXFP.
	CAN_MCR_TXFP = 0x4
	// Position of SLEEP field.
	CAN_MCR_SLEEP_Pos = 0x1
	// Bit mask of SLEEP field.
	CAN_MCR_SLEEP_Msk = 0x2
	// Bit SLEEP.
	CAN_MCR_SLEEP = 0x2
	// Position of INRQ field.
	CAN_MCR_INRQ_Pos = 0x0
	// Bit mask of INRQ field.
	CAN_MCR_INRQ_Msk = 0x1
	// Bit INRQ.
	CAN_MCR_INRQ = 0x1

	// MSR: master status register
	// Position of RX field.
	CAN_MSR_RX_Pos = 0xb
	// Bit mask of RX field.
	CAN_MSR_RX_Msk = 0x800
	// Bit RX.
	CAN_MSR_RX = 0x800
	// Position of SAMP field.
	CAN_MSR_SAMP_Pos = 0xa
	// Bit mask of SAMP field.
	CAN_MSR_SAMP_Msk = 0x400
	// Bit SAMP.
	CAN_MSR_SAMP = 0x400
	// Position of RXM field.
	CAN_MSR_RXM_Pos = 0x9
	// Bit mask of RXM field.
	CAN_MSR_RXM_Msk = 0x200
	// Bit RXM.
	CAN_MSR_RXM = 0x200
	// Position of TXM field.
	CAN_MSR_TXM_Pos = 0x8
	// Bit mask of TXM field.
	CAN_MSR_TXM_Msk = 0x100
	// Bit TXM.
	CAN_MSR_TXM = 0x100
	// Position of SLAKI field.
	CAN_MSR_SLAKI_Pos = 0x4
	// Bit mask of SLAKI field.
	CAN_MSR_SLAKI_Msk = 0x10
	// Bit SLAKI.
	CAN_MSR_SLAKI = 0x10
	// Position of WKUI field.
	CAN_MSR_WKUI_Pos = 0x3
	// Bit mask of WKUI field.
	CAN_MSR_WKUI_Msk = 0x8
	// Bit WKUI.
	CAN_MSR_WKUI = 0x8
	// Position of ERRI field.
	CAN_MSR_ERRI_Pos = 0x2
	// Bit mask of ERRI field.
	CAN_MSR_ERRI_Msk = 0x4
	// Bit ERRI.
	CAN_MSR_ERRI = 0x4
	// Position of SLAK field.
	CAN_MSR_SLAK_Pos = 0x1
	// Bit mask of SLAK field.
	CAN_MSR_SLAK_Msk = 0x2
	// Bit SLAK.
	CAN_MSR_SLAK = 0x2
	// Position of INAK field.
	CAN_MSR_INAK_Pos = 0x0
	// Bit mask of INAK field.
	CAN_MSR_INAK_Msk = 0x1
	// Bit INAK.
	CAN_MSR_INAK = 0x1

	// TSR: transmit status register
	// Position of LOW2 field.
	CAN_TSR_LOW2_Pos = 0x1f
	// Bit mask of LOW2 field.
	CAN_TSR_LOW2_Msk = 0x80000000
	// Bit LOW2.
	CAN_TSR_LOW2 = 0x80000000
	// Position of LOW1 field.
	CAN_TSR_LOW1_Pos = 0x1e
	// Bit mask of LOW1 field.
	CAN_TSR_LOW1_Msk = 0x40000000
	// Bit LOW1.
	CAN_TSR_LOW1 = 0x40000000
	// Position of LOW0 field.
	CAN_TSR_LOW0_Pos = 0x1d
	// Bit mask of LOW0 field.
	CAN_TSR_LOW0_Msk = 0x20000000
	// Bit LOW0.
	CAN_TSR_LOW0 = 0x20000000
	// Position of TME2 field.
	CAN_TSR_TME2_Pos = 0x1c
	// Bit mask of TME2 field.
	CAN_TSR_TME2_Msk = 0x10000000
	// Bit TME2.
	CAN_TSR_TME2 = 0x10000000
	// Position of TME1 field.
	CAN_TSR_TME1_Pos = 0x1b
	// Bit mask of TME1 field.
	CAN_TSR_TME1_Msk = 0x8000000
	// Bit TME1.
	CAN_TSR_TME1 = 0x8000000
	// Position of TME0 field.
	CAN_TSR_TME0_Pos = 0x1a
	// Bit mask of TME0 field.
	CAN_TSR_TME0_Msk = 0x4000000
	// Bit TME0.
	CAN_TSR_TME0 = 0x4000000
	// Position of CODE field.
	CAN_TSR_CODE_Pos = 0x18
	// Bit mask of CODE field.
	CAN_TSR_CODE_Msk = 0x3000000
	// Position of ABRQ2 field.
	CAN_TSR_ABRQ2_Pos = 0x17
	// Bit mask of ABRQ2 field.
	CAN_TSR_ABRQ2_Msk = 0x800000
	// Bit ABRQ2.
	CAN_TSR_ABRQ2 = 0x800000
	// Position of TERR2 field.
	CAN_TSR_TERR2_Pos = 0x13
	// Bit mask of TERR2 field.
	CAN_TSR_TERR2_Msk = 0x80000
	// Bit TERR2.
	CAN_TSR_TERR2 = 0x80000
	// Position of ALST2 field.
	CAN_TSR_ALST2_Pos = 0x12
	// Bit mask of ALST2 field.
	CAN_TSR_ALST2_Msk = 0x40000
	// Bit ALST2.
	CAN_TSR_ALST2 = 0x40000
	// Position of TXOK2 field.
	CAN_TSR_TXOK2_Pos = 0x11
	// Bit mask of TXOK2 field.
	CAN_TSR_TXOK2_Msk = 0x20000
	// Bit TXOK2.
	CAN_TSR_TXOK2 = 0x20000
	// Position of RQCP2 field.
	CAN_TSR_RQCP2_Pos = 0x10
	// Bit mask of RQCP2 field.
	CAN_TSR_RQCP2_Msk = 0x10000
	// Bit RQCP2.
	CAN_TSR_RQCP2 = 0x10000
	// Position of ABRQ1 field.
	CAN_TSR_ABRQ1_Pos = 0xf
	// Bit mask of ABRQ1 field.
	CAN_TSR_ABRQ1_Msk = 0x8000
	// Bit ABRQ1.
	CAN_TSR_ABRQ1 = 0x8000
	// Position of TERR1 field.
	CAN_TSR_TERR1_Pos = 0xb
	// Bit mask of TERR1 field.
	CAN_TSR_TERR1_Msk = 0x800
	// Bit TERR1.
	CAN_TSR_TERR1 = 0x800
	// Position of ALST1 field.
	CAN_TSR_ALST1_Pos = 0xa
	// Bit mask of ALST1 field.
	CAN_TSR_ALST1_Msk = 0x400
	// Bit ALST1.
	CAN_TSR_ALST1 = 0x400
	// Position of TXOK1 field.
	CAN_TSR_TXOK1_Pos = 0x9
	// Bit mask of TXOK1 field.
	CAN_TSR_TXOK1_Msk = 0x200
	// Bit TXOK1.
	CAN_TSR_TXOK1 = 0x200
	// Position of RQCP1 field.
	CAN_TSR_RQCP1_Pos = 0x8
	// Bit mask of RQCP1 field.
	CAN_TSR_RQCP1_Msk = 0x100
	// Bit RQCP1.
	CAN_TSR_RQCP1 = 0x100
	// Position of ABRQ0 field.
	CAN_TSR_ABRQ0_Pos = 0x7
	// Bit mask of ABRQ0 field.
	CAN_TSR_ABRQ0_Msk = 0x80
	// Bit ABRQ0.
	CAN_TSR_ABRQ0 = 0x80
	// Position of TERR0 field.
	CAN_TSR_TERR0_Pos = 0x3
	// Bit mask of TERR0 field.
	CAN_TSR_TERR0_Msk = 0x8
	// Bit TERR0.
	CAN_TSR_TERR0 = 0x8
	// Position of ALST0 field.
	CAN_TSR_ALST0_Pos = 0x2
	// Bit mask of ALST0 field.
	CAN_TSR_ALST0_Msk = 0x4
	// Bit ALST0.
	CAN_TSR_ALST0 = 0x4
	// Position of TXOK0 field.
	CAN_TSR_TXOK0_Pos = 0x1
	// Bit mask of TXOK0 field.
	CAN_TSR_TXOK0_Msk = 0x2
	// Bit TXOK0.
	CAN_TSR_TXOK0 = 0x2
	// Position of RQCP0 field.
	CAN_TSR_RQCP0_Pos = 0x0
	// Bit mask of RQCP0 field.
	CAN_TSR_RQCP0_Msk = 0x1
	// Bit RQCP0.
	CAN_TSR_RQCP0 = 0x1

	// RF0R: receive FIFO %s register
	// Position of RFOM field.
	CAN_RFR_RFOM_Pos = 0x5
	// Bit mask of RFOM field.
	CAN_RFR_RFOM_Msk = 0x20
	// Bit RFOM.
	CAN_RFR_RFOM = 0x20
	// Set by software to release the output mailbox of the FIFO
	CAN_RFR_RFOM_Release = 0x1
	// Position of FOVR field.
	CAN_RFR_FOVR_Pos = 0x4
	// Bit mask of FOVR field.
	CAN_RFR_FOVR_Msk = 0x10
	// Bit FOVR.
	CAN_RFR_FOVR = 0x10
	// No FIFO x overrun
	CAN_RFR_FOVR_NoOverrun = 0x0
	// FIFO x overrun
	CAN_RFR_FOVR_Overrun = 0x1
	// Clear flag
	CAN_RFR_FOVR_Clear = 0x1
	// Position of FULL field.
	CAN_RFR_FULL_Pos = 0x3
	// Bit mask of FULL field.
	CAN_RFR_FULL_Msk = 0x8
	// Bit FULL.
	CAN_RFR_FULL = 0x8
	// FIFO x is not full
	CAN_RFR_FULL_NotFull = 0x0
	// FIFO x is full
	CAN_RFR_FULL_Full = 0x1
	// Clear flag
	CAN_RFR_FULL_Clear = 0x1
	// Position of FMP field.
	CAN_RFR_FMP_Pos = 0x0
	// Bit mask of FMP field.
	CAN_RFR_FMP_Msk = 0x3

	// IER: interrupt enable register
	// Position of SLKIE field.
	CAN_IER_SLKIE_Pos = 0x11
	// Bit mask of SLKIE field.
	CAN_IER_SLKIE_Msk = 0x20000
	// Bit SLKIE.
	CAN_IER_SLKIE = 0x20000
	// No interrupt when SLAKI bit is set
	CAN_IER_SLKIE_Disabled = 0x0
	// Interrupt generated when SLAKI bit is set
	CAN_IER_SLKIE_Enabled = 0x1
	// Position of WKUIE field.
	CAN_IER_WKUIE_Pos = 0x10
	// Bit mask of WKUIE field.
	CAN_IER_WKUIE_Msk = 0x10000
	// Bit WKUIE.
	CAN_IER_WKUIE = 0x10000
	// No interrupt when WKUI is set
	CAN_IER_WKUIE_Disabled = 0x0
	// Interrupt generated when WKUI bit is set
	CAN_IER_WKUIE_Enabled = 0x1
	// Position of ERRIE field.
	CAN_IER_ERRIE_Pos = 0xf
	// Bit mask of ERRIE field.
	CAN_IER_ERRIE_Msk = 0x8000
	// Bit ERRIE.
	CAN_IER_ERRIE = 0x8000
	// No interrupt will be generated when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Disabled = 0x0
	// An interrupt will be generation when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Enabled = 0x1
	// Position of LECIE field.
	CAN_IER_LECIE_Pos = 0xb
	// Bit mask of LECIE field.
	CAN_IER_LECIE_Msk = 0x800
	// Bit LECIE.
	CAN_IER_LECIE = 0x800
	// ERRI bit will not be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Disabled = 0x0
	// ERRI bit will be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Enabled = 0x1
	// Position of BOFIE field.
	CAN_IER_BOFIE_Pos = 0xa
	// Bit mask of BOFIE field.
	CAN_IER_BOFIE_Msk = 0x400
	// Bit BOFIE.
	CAN_IER_BOFIE = 0x400
	// ERRI bit will not be set when BOFF is set
	CAN_IER_BOFIE_Disabled = 0x0
	// ERRI bit will be set when BOFF is set
	CAN_IER_BOFIE_Enabled = 0x1
	// Position of EPVIE field.
	CAN_IER_EPVIE_Pos = 0x9
	// Bit mask of EPVIE field.
	CAN_IER_EPVIE_Msk = 0x200
	// Bit EPVIE.
	CAN_IER_EPVIE = 0x200
	// ERRI bit will not be set when EPVF is set
	CAN_IER_EPVIE_Disabled = 0x0
	// ERRI bit will be set when EPVF is set
	CAN_IER_EPVIE_Enabled = 0x1
	// Position of EWGIE field.
	CAN_IER_EWGIE_Pos = 0x8
	// Bit mask of EWGIE field.
	CAN_IER_EWGIE_Msk = 0x100
	// Bit EWGIE.
	CAN_IER_EWGIE = 0x100
	// ERRI bit will not be set when EWGF is set
	CAN_IER_EWGIE_Disabled = 0x0
	// ERRI bit will be set when EWGF is set
	CAN_IER_EWGIE_Enabled = 0x1
	// Position of FOVIE1 field.
	CAN_IER_FOVIE1_Pos = 0x6
	// Bit mask of FOVIE1 field.
	CAN_IER_FOVIE1_Msk = 0x40
	// Bit FOVIE1.
	CAN_IER_FOVIE1 = 0x40
	// No interrupt when FOVR is set
	CAN_IER_FOVIE1_Disabled = 0x0
	// Interrupt generation when FOVR is set
	CAN_IER_FOVIE1_Enabled = 0x1
	// Position of FFIE1 field.
	CAN_IER_FFIE1_Pos = 0x5
	// Bit mask of FFIE1 field.
	CAN_IER_FFIE1_Msk = 0x20
	// Bit FFIE1.
	CAN_IER_FFIE1 = 0x20
	// No interrupt when FULL bit is set
	CAN_IER_FFIE1_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE1_Enabled = 0x1
	// Position of FMPIE1 field.
	CAN_IER_FMPIE1_Pos = 0x4
	// Bit mask of FMPIE1 field.
	CAN_IER_FMPIE1_Msk = 0x10
	// Bit FMPIE1.
	CAN_IER_FMPIE1 = 0x10
	// No interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Enabled = 0x1
	// Position of FOVIE0 field.
	CAN_IER_FOVIE0_Pos = 0x3
	// Bit mask of FOVIE0 field.
	CAN_IER_FOVIE0_Msk = 0x8
	// Bit FOVIE0.
	CAN_IER_FOVIE0 = 0x8
	// No interrupt when FOVR bit is set
	CAN_IER_FOVIE0_Disabled = 0x0
	// Interrupt generated when FOVR bit is set
	CAN_IER_FOVIE0_Enabled = 0x1
	// Position of FFIE0 field.
	CAN_IER_FFIE0_Pos = 0x2
	// Bit mask of FFIE0 field.
	CAN_IER_FFIE0_Msk = 0x4
	// Bit FFIE0.
	CAN_IER_FFIE0 = 0x4
	// No interrupt when FULL bit is set
	CAN_IER_FFIE0_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE0_Enabled = 0x1
	// Position of FMPIE0 field.
	CAN_IER_FMPIE0_Pos = 0x1
	// Bit mask of FMPIE0 field.
	CAN_IER_FMPIE0_Msk = 0x2
	// Bit FMPIE0.
	CAN_IER_FMPIE0 = 0x2
	// No interrupt generated when state of FMP[1:0] bits are not 00
	CAN_IER_FMPIE0_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE0_Enabled = 0x1
	// Position of TMEIE field.
	CAN_IER_TMEIE_Pos = 0x0
	// Bit mask of TMEIE field.
	CAN_IER_TMEIE_Msk = 0x1
	// Bit TMEIE.
	CAN_IER_TMEIE = 0x1
	// No interrupt when RQCPx bit is set
	CAN_IER_TMEIE_Disabled = 0x0
	// Interrupt generated when RQCPx bit is set
	CAN_IER_TMEIE_Enabled = 0x1

	// ESR: error status register
	// Position of REC field.
	CAN_ESR_REC_Pos = 0x18
	// Bit mask of REC field.
	CAN_ESR_REC_Msk = 0xff000000
	// Position of TEC field.
	CAN_ESR_TEC_Pos = 0x10
	// Bit mask of TEC field.
	CAN_ESR_TEC_Msk = 0xff0000
	// Position of LEC field.
	CAN_ESR_LEC_Pos = 0x4
	// Bit mask of LEC field.
	CAN_ESR_LEC_Msk = 0x70
	// No Error
	CAN_ESR_LEC_NoError = 0x0
	// Stuff Error
	CAN_ESR_LEC_Stuff = 0x1
	// Form Error
	CAN_ESR_LEC_Form = 0x2
	// Acknowledgment Error
	CAN_ESR_LEC_Ack = 0x3
	// Bit recessive Error
	CAN_ESR_LEC_BitRecessive = 0x4
	// Bit dominant Error
	CAN_ESR_LEC_BitDominant = 0x5
	// CRC Error
	CAN_ESR_LEC_Crc = 0x6
	// Set by software
	CAN_ESR_LEC_Custom = 0x7
	// Position of BOFF field.
	CAN_ESR_BOFF_Pos = 0x2
	// Bit mask of BOFF field.
	CAN_ESR_BOFF_Msk = 0x4
	// Bit BOFF.
	CAN_ESR_BOFF = 0x4
	// Position of EPVF field.
	CAN_ESR_EPVF_Pos = 0x1
	// Bit mask of EPVF field.
	CAN_ESR_EPVF_Msk = 0x2
	// Bit EPVF.
	CAN_ESR_EPVF = 0x2
	// Position of EWGF field.
	CAN_ESR_EWGF_Pos = 0x0
	// Bit mask of EWGF field.
	CAN_ESR_EWGF_Msk = 0x1
	// Bit EWGF.
	CAN_ESR_EWGF = 0x1

	// BTR: bit timing register
	// Position of SILM field.
	CAN_BTR_SILM_Pos = 0x1f
	// Bit mask of SILM field.
	CAN_BTR_SILM_Msk = 0x80000000
	// Bit SILM.
	CAN_BTR_SILM = 0x80000000
	// Normal operation
	CAN_BTR_SILM_Normal = 0x0
	// Silent Mode
	CAN_BTR_SILM_Silent = 0x1
	// Position of LBKM field.
	CAN_BTR_LBKM_Pos = 0x1e
	// Bit mask of LBKM field.
	CAN_BTR_LBKM_Msk = 0x40000000
	// Bit LBKM.
	CAN_BTR_LBKM = 0x40000000
	// Loop Back Mode disabled
	CAN_BTR_LBKM_Disabled = 0x0
	// Loop Back Mode enabled
	CAN_BTR_LBKM_Enabled = 0x1
	// Position of SJW field.
	CAN_BTR_SJW_Pos = 0x18
	// Bit mask of SJW field.
	CAN_BTR_SJW_Msk = 0x3000000
	// Position of TS2 field.
	CAN_BTR_TS2_Pos = 0x14
	// Bit mask of TS2 field.
	CAN_BTR_TS2_Msk = 0x700000
	// Position of TS1 field.
	CAN_BTR_TS1_Pos = 0x10
	// Bit mask of TS1 field.
	CAN_BTR_TS1_Msk = 0xf0000
	// Position of BRP field.
	CAN_BTR_BRP_Pos = 0x0
	// Bit mask of BRP field.
	CAN_BTR_BRP_Msk = 0x3ff

	// TX.TIR: TX mailbox identifier register
	// Position of STID field.
	CAN_TX_TIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_TX_TIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_TX_TIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_TX_TIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_TX_TIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_TX_TIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_TX_TIR_IDE = 0x4
	// Standard identifier
	CAN_TX_TIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_TX_TIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_TX_TIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_TX_TIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_TX_TIR_RTR = 0x2
	// Data frame
	CAN_TX_TIR_RTR_Data = 0x0
	// Remote frame
	CAN_TX_TIR_RTR_Remote = 0x1
	// Position of TXRQ field.
	CAN_TX_TIR_TXRQ_Pos = 0x0
	// Bit mask of TXRQ field.
	CAN_TX_TIR_TXRQ_Msk = 0x1
	// Bit TXRQ.
	CAN_TX_TIR_TXRQ = 0x1

	// TX.TDTR: mailbox data length control and time stamp register
	// Position of TIME field.
	CAN_TX_TDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_TX_TDTR_TIME_Msk = 0xffff0000
	// Position of TGT field.
	CAN_TX_TDTR_TGT_Pos = 0x8
	// Bit mask of TGT field.
	CAN_TX_TDTR_TGT_Msk = 0x100
	// Bit TGT.
	CAN_TX_TDTR_TGT = 0x100
	// Position of DLC field.
	CAN_TX_TDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_TX_TDTR_DLC_Msk = 0xf

	// TX.TDLR: mailbox data low register
	// Position of DATA3 field.
	CAN_TX_TDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_TX_TDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_TX_TDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_TX_TDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_TX_TDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_TX_TDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_TX_TDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_TX_TDLR_DATA0_Msk = 0xff

	// TX.TDHR: mailbox data high register
	// Position of DATA7 field.
	CAN_TX_TDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_TX_TDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_TX_TDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_TX_TDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_TX_TDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_TX_TDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_TX_TDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_TX_TDHR_DATA4_Msk = 0xff

	// RX.RIR: receive FIFO mailbox identifier register
	// Position of STID field.
	CAN_RX_RIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_RX_RIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_RX_RIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_RX_RIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_RX_RIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_RX_RIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_RX_RIR_IDE = 0x4
	// Standard identifier
	CAN_RX_RIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_RX_RIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_RX_RIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_RX_RIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_RX_RIR_RTR = 0x2
	// Data frame
	CAN_RX_RIR_RTR_Data = 0x0
	// Remote frame
	CAN_RX_RIR_RTR_Remote = 0x1

	// RX.RDTR: receive FIFO mailbox data length control and time stamp register
	// Position of TIME field.
	CAN_RX_RDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_RX_RDTR_TIME_Msk = 0xffff0000
	// Position of FMI field.
	CAN_RX_RDTR_FMI_Pos = 0x8
	// Bit mask of FMI field.
	CAN_RX_RDTR_FMI_Msk = 0xff00
	// Position of DLC field.
	CAN_RX_RDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_RX_RDTR_DLC_Msk = 0xf

	// RX.RDLR: receive FIFO mailbox data low register
	// Position of DATA3 field.
	CAN_RX_RDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_RX_RDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_RX_RDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_RX_RDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_RX_RDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_RX_RDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_RX_RDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_RX_RDLR_DATA0_Msk = 0xff

	// RX.RDHR: receive FIFO mailbox data high register
	// Position of DATA7 field.
	CAN_RX_RDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_RX_RDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_RX_RDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_RX_RDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_RX_RDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_RX_RDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_RX_RDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_RX_RDHR_DATA4_Msk = 0xff

	// FMR: filter master register
	// Position of CAN2SB field.
	CAN_FMR_CAN2SB_Pos = 0x8
	// Bit mask of CAN2SB field.
	CAN_FMR_CAN2SB_Msk = 0x3f00
	// Position of FINIT field.
	CAN_FMR_FINIT_Pos = 0x0
	// Bit mask of FINIT field.
	CAN_FMR_FINIT_Msk = 0x1
	// Bit FINIT.
	CAN_FMR_FINIT = 0x1

	// FM1R: filter mode register
	// Position of FBM0 field.
	CAN_FM1R_FBM0_Pos = 0x0
	// Bit mask of FBM0 field.
	CAN_FM1R_FBM0_Msk = 0x1
	// Bit FBM0.
	CAN_FM1R_FBM0 = 0x1
	// Position of FBM1 field.
	CAN_FM1R_FBM1_Pos = 0x1
	// Bit mask of FBM1 field.
	CAN_FM1R_FBM1_Msk = 0x2
	// Bit FBM1.
	CAN_FM1R_FBM1 = 0x2
	// Position of FBM2 field.
	CAN_FM1R_FBM2_Pos = 0x2
	// Bit mask of FBM2 field.
	CAN_FM1R_FBM2_Msk = 0x4
	// Bit FBM2.
	CAN_FM1R_FBM2 = 0x4
	// Position of FBM3 field.
	CAN_FM1R_FBM3_Pos = 0x3
	// Bit mask of FBM3 field.
	CAN_FM1R_FBM3_Msk = 0x8
	// Bit FBM3.
	CAN_FM1R_FBM3 = 0x8
	// Position of FBM4 field.
	CAN_FM1R_FBM4_Pos = 0x4
	// Bit mask of FBM4 field.
	CAN_FM1R_FBM4_Msk = 0x10
	// Bit FBM4.
	CAN_FM1R_FBM4 = 0x10
	// Position of FBM5 field.
	CAN_FM1R_FBM5_Pos = 0x5
	// Bit mask of FBM5 field.
	CAN_FM1R_FBM5_Msk = 0x20
	// Bit FBM5.
	CAN_FM1R_FBM5 = 0x20
	// Position of FBM6 field.
	CAN_FM1R_FBM6_Pos = 0x6
	// Bit mask of FBM6 field.
	CAN_FM1R_FBM6_Msk = 0x40
	// Bit FBM6.
	CAN_FM1R_FBM6 = 0x40
	// Position of FBM7 field.
	CAN_FM1R_FBM7_Pos = 0x7
	// Bit mask of FBM7 field.
	CAN_FM1R_FBM7_Msk = 0x80
	// Bit FBM7.
	CAN_FM1R_FBM7 = 0x80
	// Position of FBM8 field.
	CAN_FM1R_FBM8_Pos = 0x8
	// Bit mask of FBM8 field.
	CAN_FM1R_FBM8_Msk = 0x100
	// Bit FBM8.
	CAN_FM1R_FBM8 = 0x100
	// Position of FBM9 field.
	CAN_FM1R_FBM9_Pos = 0x9
	// Bit mask of FBM9 field.
	CAN_FM1R_FBM9_Msk = 0x200
	// Bit FBM9.
	CAN_FM1R_FBM9 = 0x200
	// Position of FBM10 field.
	CAN_FM1R_FBM10_Pos = 0xa
	// Bit mask of FBM10 field.
	CAN_FM1R_FBM10_Msk = 0x400
	// Bit FBM10.
	CAN_FM1R_FBM10 = 0x400
	// Position of FBM11 field.
	CAN_FM1R_FBM11_Pos = 0xb
	// Bit mask of FBM11 field.
	CAN_FM1R_FBM11_Msk = 0x800
	// Bit FBM11.
	CAN_FM1R_FBM11 = 0x800
	// Position of FBM12 field.
	CAN_FM1R_FBM12_Pos = 0xc
	// Bit mask of FBM12 field.
	CAN_FM1R_FBM12_Msk = 0x1000
	// Bit FBM12.
	CAN_FM1R_FBM12 = 0x1000
	// Position of FBM13 field.
	CAN_FM1R_FBM13_Pos = 0xd
	// Bit mask of FBM13 field.
	CAN_FM1R_FBM13_Msk = 0x2000
	// Bit FBM13.
	CAN_FM1R_FBM13 = 0x2000
	// Position of FBM14 field.
	CAN_FM1R_FBM14_Pos = 0xe
	// Bit mask of FBM14 field.
	CAN_FM1R_FBM14_Msk = 0x4000
	// Bit FBM14.
	CAN_FM1R_FBM14 = 0x4000
	// Position of FBM15 field.
	CAN_FM1R_FBM15_Pos = 0xf
	// Bit mask of FBM15 field.
	CAN_FM1R_FBM15_Msk = 0x8000
	// Bit FBM15.
	CAN_FM1R_FBM15 = 0x8000
	// Position of FBM16 field.
	CAN_FM1R_FBM16_Pos = 0x10
	// Bit mask of FBM16 field.
	CAN_FM1R_FBM16_Msk = 0x10000
	// Bit FBM16.
	CAN_FM1R_FBM16 = 0x10000
	// Position of FBM17 field.
	CAN_FM1R_FBM17_Pos = 0x11
	// Bit mask of FBM17 field.
	CAN_FM1R_FBM17_Msk = 0x20000
	// Bit FBM17.
	CAN_FM1R_FBM17 = 0x20000
	// Position of FBM18 field.
	CAN_FM1R_FBM18_Pos = 0x12
	// Bit mask of FBM18 field.
	CAN_FM1R_FBM18_Msk = 0x40000
	// Bit FBM18.
	CAN_FM1R_FBM18 = 0x40000
	// Position of FBM19 field.
	CAN_FM1R_FBM19_Pos = 0x13
	// Bit mask of FBM19 field.
	CAN_FM1R_FBM19_Msk = 0x80000
	// Bit FBM19.
	CAN_FM1R_FBM19 = 0x80000
	// Position of FBM20 field.
	CAN_FM1R_FBM20_Pos = 0x14
	// Bit mask of FBM20 field.
	CAN_FM1R_FBM20_Msk = 0x100000
	// Bit FBM20.
	CAN_FM1R_FBM20 = 0x100000
	// Position of FBM21 field.
	CAN_FM1R_FBM21_Pos = 0x15
	// Bit mask of FBM21 field.
	CAN_FM1R_FBM21_Msk = 0x200000
	// Bit FBM21.
	CAN_FM1R_FBM21 = 0x200000
	// Position of FBM22 field.
	CAN_FM1R_FBM22_Pos = 0x16
	// Bit mask of FBM22 field.
	CAN_FM1R_FBM22_Msk = 0x400000
	// Bit FBM22.
	CAN_FM1R_FBM22 = 0x400000
	// Position of FBM23 field.
	CAN_FM1R_FBM23_Pos = 0x17
	// Bit mask of FBM23 field.
	CAN_FM1R_FBM23_Msk = 0x800000
	// Bit FBM23.
	CAN_FM1R_FBM23 = 0x800000
	// Position of FBM24 field.
	CAN_FM1R_FBM24_Pos = 0x18
	// Bit mask of FBM24 field.
	CAN_FM1R_FBM24_Msk = 0x1000000
	// Bit FBM24.
	CAN_FM1R_FBM24 = 0x1000000
	// Position of FBM25 field.
	CAN_FM1R_FBM25_Pos = 0x19
	// Bit mask of FBM25 field.
	CAN_FM1R_FBM25_Msk = 0x2000000
	// Bit FBM25.
	CAN_FM1R_FBM25 = 0x2000000
	// Position of FBM26 field.
	CAN_FM1R_FBM26_Pos = 0x1a
	// Bit mask of FBM26 field.
	CAN_FM1R_FBM26_Msk = 0x4000000
	// Bit FBM26.
	CAN_FM1R_FBM26 = 0x4000000
	// Position of FBM27 field.
	CAN_FM1R_FBM27_Pos = 0x1b
	// Bit mask of FBM27 field.
	CAN_FM1R_FBM27_Msk = 0x8000000
	// Bit FBM27.
	CAN_FM1R_FBM27 = 0x8000000

	// FS1R: filter scale register
	// Position of FSC0 field.
	CAN_FS1R_FSC0_Pos = 0x0
	// Bit mask of FSC0 field.
	CAN_FS1R_FSC0_Msk = 0x1
	// Bit FSC0.
	CAN_FS1R_FSC0 = 0x1
	// Position of FSC1 field.
	CAN_FS1R_FSC1_Pos = 0x1
	// Bit mask of FSC1 field.
	CAN_FS1R_FSC1_Msk = 0x2
	// Bit FSC1.
	CAN_FS1R_FSC1 = 0x2
	// Position of FSC2 field.
	CAN_FS1R_FSC2_Pos = 0x2
	// Bit mask of FSC2 field.
	CAN_FS1R_FSC2_Msk = 0x4
	// Bit FSC2.
	CAN_FS1R_FSC2 = 0x4
	// Position of FSC3 field.
	CAN_FS1R_FSC3_Pos = 0x3
	// Bit mask of FSC3 field.
	CAN_FS1R_FSC3_Msk = 0x8
	// Bit FSC3.
	CAN_FS1R_FSC3 = 0x8
	// Position of FSC4 field.
	CAN_FS1R_FSC4_Pos = 0x4
	// Bit mask of FSC4 field.
	CAN_FS1R_FSC4_Msk = 0x10
	// Bit FSC4.
	CAN_FS1R_FSC4 = 0x10
	// Position of FSC5 field.
	CAN_FS1R_FSC5_Pos = 0x5
	// Bit mask of FSC5 field.
	CAN_FS1R_FSC5_Msk = 0x20
	// Bit FSC5.
	CAN_FS1R_FSC5 = 0x20
	// Position of FSC6 field.
	CAN_FS1R_FSC6_Pos = 0x6
	// Bit mask of FSC6 field.
	CAN_FS1R_FSC6_Msk = 0x40
	// Bit FSC6.
	CAN_FS1R_FSC6 = 0x40
	// Position of FSC7 field.
	CAN_FS1R_FSC7_Pos = 0x7
	// Bit mask of FSC7 field.
	CAN_FS1R_FSC7_Msk = 0x80
	// Bit FSC7.
	CAN_FS1R_FSC7 = 0x80
	// Position of FSC8 field.
	CAN_FS1R_FSC8_Pos = 0x8
	// Bit mask of FSC8 field.
	CAN_FS1R_FSC8_Msk = 0x100
	// Bit FSC8.
	CAN_FS1R_FSC8 = 0x100
	// Position of FSC9 field.
	CAN_FS1R_FSC9_Pos = 0x9
	// Bit mask of FSC9 field.
	CAN_FS1R_FSC9_Msk = 0x200
	// Bit FSC9.
	CAN_FS1R_FSC9 = 0x200
	// Position of FSC10 field.
	CAN_FS1R_FSC10_Pos = 0xa
	// Bit mask of FSC10 field.
	CAN_FS1R_FSC10_Msk = 0x400
	// Bit FSC10.
	CAN_FS1R_FSC10 = 0x400
	// Position of FSC11 field.
	CAN_FS1R_FSC11_Pos = 0xb
	// Bit mask of FSC11 field.
	CAN_FS1R_FSC11_Msk = 0x800
	// Bit FSC11.
	CAN_FS1R_FSC11 = 0x800
	// Position of FSC12 field.
	CAN_FS1R_FSC12_Pos = 0xc
	// Bit mask of FSC12 field.
	CAN_FS1R_FSC12_Msk = 0x1000
	// Bit FSC12.
	CAN_FS1R_FSC12 = 0x1000
	// Position of FSC13 field.
	CAN_FS1R_FSC13_Pos = 0xd
	// Bit mask of FSC13 field.
	CAN_FS1R_FSC13_Msk = 0x2000
	// Bit FSC13.
	CAN_FS1R_FSC13 = 0x2000
	// Position of FSC14 field.
	CAN_FS1R_FSC14_Pos = 0xe
	// Bit mask of FSC14 field.
	CAN_FS1R_FSC14_Msk = 0x4000
	// Bit FSC14.
	CAN_FS1R_FSC14 = 0x4000
	// Position of FSC15 field.
	CAN_FS1R_FSC15_Pos = 0xf
	// Bit mask of FSC15 field.
	CAN_FS1R_FSC15_Msk = 0x8000
	// Bit FSC15.
	CAN_FS1R_FSC15 = 0x8000
	// Position of FSC16 field.
	CAN_FS1R_FSC16_Pos = 0x10
	// Bit mask of FSC16 field.
	CAN_FS1R_FSC16_Msk = 0x10000
	// Bit FSC16.
	CAN_FS1R_FSC16 = 0x10000
	// Position of FSC17 field.
	CAN_FS1R_FSC17_Pos = 0x11
	// Bit mask of FSC17 field.
	CAN_FS1R_FSC17_Msk = 0x20000
	// Bit FSC17.
	CAN_FS1R_FSC17 = 0x20000
	// Position of FSC18 field.
	CAN_FS1R_FSC18_Pos = 0x12
	// Bit mask of FSC18 field.
	CAN_FS1R_FSC18_Msk = 0x40000
	// Bit FSC18.
	CAN_FS1R_FSC18 = 0x40000
	// Position of FSC19 field.
	CAN_FS1R_FSC19_Pos = 0x13
	// Bit mask of FSC19 field.
	CAN_FS1R_FSC19_Msk = 0x80000
	// Bit FSC19.
	CAN_FS1R_FSC19 = 0x80000
	// Position of FSC20 field.
	CAN_FS1R_FSC20_Pos = 0x14
	// Bit mask of FSC20 field.
	CAN_FS1R_FSC20_Msk = 0x100000
	// Bit FSC20.
	CAN_FS1R_FSC20 = 0x100000
	// Position of FSC21 field.
	CAN_FS1R_FSC21_Pos = 0x15
	// Bit mask of FSC21 field.
	CAN_FS1R_FSC21_Msk = 0x200000
	// Bit FSC21.
	CAN_FS1R_FSC21 = 0x200000
	// Position of FSC22 field.
	CAN_FS1R_FSC22_Pos = 0x16
	// Bit mask of FSC22 field.
	CAN_FS1R_FSC22_Msk = 0x400000
	// Bit FSC22.
	CAN_FS1R_FSC22 = 0x400000
	// Position of FSC23 field.
	CAN_FS1R_FSC23_Pos = 0x17
	// Bit mask of FSC23 field.
	CAN_FS1R_FSC23_Msk = 0x800000
	// Bit FSC23.
	CAN_FS1R_FSC23 = 0x800000
	// Position of FSC24 field.
	CAN_FS1R_FSC24_Pos = 0x18
	// Bit mask of FSC24 field.
	CAN_FS1R_FSC24_Msk = 0x1000000
	// Bit FSC24.
	CAN_FS1R_FSC24 = 0x1000000
	// Position of FSC25 field.
	CAN_FS1R_FSC25_Pos = 0x19
	// Bit mask of FSC25 field.
	CAN_FS1R_FSC25_Msk = 0x2000000
	// Bit FSC25.
	CAN_FS1R_FSC25 = 0x2000000
	// Position of FSC26 field.
	CAN_FS1R_FSC26_Pos = 0x1a
	// Bit mask of FSC26 field.
	CAN_FS1R_FSC26_Msk = 0x4000000
	// Bit FSC26.
	CAN_FS1R_FSC26 = 0x4000000
	// Position of FSC27 field.
	CAN_FS1R_FSC27_Pos = 0x1b
	// Bit mask of FSC27 field.
	CAN_FS1R_FSC27_Msk = 0x8000000
	// Bit FSC27.
	CAN_FS1R_FSC27 = 0x8000000

	// FFA1R: filter FIFO assignment register
	// Position of FFA0 field.
	CAN_FFA1R_FFA0_Pos = 0x0
	// Bit mask of FFA0 field.
	CAN_FFA1R_FFA0_Msk = 0x1
	// Bit FFA0.
	CAN_FFA1R_FFA0 = 0x1
	// Position of FFA1 field.
	CAN_FFA1R_FFA1_Pos = 0x1
	// Bit mask of FFA1 field.
	CAN_FFA1R_FFA1_Msk = 0x2
	// Bit FFA1.
	CAN_FFA1R_FFA1 = 0x2
	// Position of FFA2 field.
	CAN_FFA1R_FFA2_Pos = 0x2
	// Bit mask of FFA2 field.
	CAN_FFA1R_FFA2_Msk = 0x4
	// Bit FFA2.
	CAN_FFA1R_FFA2 = 0x4
	// Position of FFA3 field.
	CAN_FFA1R_FFA3_Pos = 0x3
	// Bit mask of FFA3 field.
	CAN_FFA1R_FFA3_Msk = 0x8
	// Bit FFA3.
	CAN_FFA1R_FFA3 = 0x8
	// Position of FFA4 field.
	CAN_FFA1R_FFA4_Pos = 0x4
	// Bit mask of FFA4 field.
	CAN_FFA1R_FFA4_Msk = 0x10
	// Bit FFA4.
	CAN_FFA1R_FFA4 = 0x10
	// Position of FFA5 field.
	CAN_FFA1R_FFA5_Pos = 0x5
	// Bit mask of FFA5 field.
	CAN_FFA1R_FFA5_Msk = 0x20
	// Bit FFA5.
	CAN_FFA1R_FFA5 = 0x20
	// Position of FFA6 field.
	CAN_FFA1R_FFA6_Pos = 0x6
	// Bit mask of FFA6 field.
	CAN_FFA1R_FFA6_Msk = 0x40
	// Bit FFA6.
	CAN_FFA1R_FFA6 = 0x40
	// Position of FFA7 field.
	CAN_FFA1R_FFA7_Pos = 0x7
	// Bit mask of FFA7 field.
	CAN_FFA1R_FFA7_Msk = 0x80
	// Bit FFA7.
	CAN_FFA1R_FFA7 = 0x80
	// Position of FFA8 field.
	CAN_FFA1R_FFA8_Pos = 0x8
	// Bit mask of FFA8 field.
	CAN_FFA1R_FFA8_Msk = 0x100
	// Bit FFA8.
	CAN_FFA1R_FFA8 = 0x100
	// Position of FFA9 field.
	CAN_FFA1R_FFA9_Pos = 0x9
	// Bit mask of FFA9 field.
	CAN_FFA1R_FFA9_Msk = 0x200
	// Bit FFA9.
	CAN_FFA1R_FFA9 = 0x200
	// Position of FFA10 field.
	CAN_FFA1R_FFA10_Pos = 0xa
	// Bit mask of FFA10 field.
	CAN_FFA1R_FFA10_Msk = 0x400
	// Bit FFA10.
	CAN_FFA1R_FFA10 = 0x400
	// Position of FFA11 field.
	CAN_FFA1R_FFA11_Pos = 0xb
	// Bit mask of FFA11 field.
	CAN_FFA1R_FFA11_Msk = 0x800
	// Bit FFA11.
	CAN_FFA1R_FFA11 = 0x800
	// Position of FFA12 field.
	CAN_FFA1R_FFA12_Pos = 0xc
	// Bit mask of FFA12 field.
	CAN_FFA1R_FFA12_Msk = 0x1000
	// Bit FFA12.
	CAN_FFA1R_FFA12 = 0x1000
	// Position of FFA13 field.
	CAN_FFA1R_FFA13_Pos = 0xd
	// Bit mask of FFA13 field.
	CAN_FFA1R_FFA13_Msk = 0x2000
	// Bit FFA13.
	CAN_FFA1R_FFA13 = 0x2000
	// Position of FFA14 field.
	CAN_FFA1R_FFA14_Pos = 0xe
	// Bit mask of FFA14 field.
	CAN_FFA1R_FFA14_Msk = 0x4000
	// Bit FFA14.
	CAN_FFA1R_FFA14 = 0x4000
	// Position of FFA15 field.
	CAN_FFA1R_FFA15_Pos = 0xf
	// Bit mask of FFA15 field.
	CAN_FFA1R_FFA15_Msk = 0x8000
	// Bit FFA15.
	CAN_FFA1R_FFA15 = 0x8000
	// Position of FFA16 field.
	CAN_FFA1R_FFA16_Pos = 0x10
	// Bit mask of FFA16 field.
	CAN_FFA1R_FFA16_Msk = 0x10000
	// Bit FFA16.
	CAN_FFA1R_FFA16 = 0x10000
	// Position of FFA17 field.
	CAN_FFA1R_FFA17_Pos = 0x11
	// Bit mask of FFA17 field.
	CAN_FFA1R_FFA17_Msk = 0x20000
	// Bit FFA17.
	CAN_FFA1R_FFA17 = 0x20000
	// Position of FFA18 field.
	CAN_FFA1R_FFA18_Pos = 0x12
	// Bit mask of FFA18 field.
	CAN_FFA1R_FFA18_Msk = 0x40000
	// Bit FFA18.
	CAN_FFA1R_FFA18 = 0x40000
	// Position of FFA19 field.
	CAN_FFA1R_FFA19_Pos = 0x13
	// Bit mask of FFA19 field.
	CAN_FFA1R_FFA19_Msk = 0x80000
	// Bit FFA19.
	CAN_FFA1R_FFA19 = 0x80000
	// Position of FFA20 field.
	CAN_FFA1R_FFA20_Pos = 0x14
	// Bit mask of FFA20 field.
	CAN_FFA1R_FFA20_Msk = 0x100000
	// Bit FFA20.
	CAN_FFA1R_FFA20 = 0x100000
	// Position of FFA21 field.
	CAN_FFA1R_FFA21_Pos = 0x15
	// Bit mask of FFA21 field.
	CAN_FFA1R_FFA21_Msk = 0x200000
	// Bit FFA21.
	CAN_FFA1R_FFA21 = 0x200000
	// Position of FFA22 field.
	CAN_FFA1R_FFA22_Pos = 0x16
	// Bit mask of FFA22 field.
	CAN_FFA1R_FFA22_Msk = 0x400000
	// Bit FFA22.
	CAN_FFA1R_FFA22 = 0x400000
	// Position of FFA23 field.
	CAN_FFA1R_FFA23_Pos = 0x17
	// Bit mask of FFA23 field.
	CAN_FFA1R_FFA23_Msk = 0x800000
	// Bit FFA23.
	CAN_FFA1R_FFA23 = 0x800000
	// Position of FFA24 field.
	CAN_FFA1R_FFA24_Pos = 0x18
	// Bit mask of FFA24 field.
	CAN_FFA1R_FFA24_Msk = 0x1000000
	// Bit FFA24.
	CAN_FFA1R_FFA24 = 0x1000000
	// Position of FFA25 field.
	CAN_FFA1R_FFA25_Pos = 0x19
	// Bit mask of FFA25 field.
	CAN_FFA1R_FFA25_Msk = 0x2000000
	// Bit FFA25.
	CAN_FFA1R_FFA25 = 0x2000000
	// Position of FFA26 field.
	CAN_FFA1R_FFA26_Pos = 0x1a
	// Bit mask of FFA26 field.
	CAN_FFA1R_FFA26_Msk = 0x4000000
	// Bit FFA26.
	CAN_FFA1R_FFA26 = 0x4000000
	// Position of FFA27 field.
	CAN_FFA1R_FFA27_Pos = 0x1b
	// Bit mask of FFA27 field.
	CAN_FFA1R_FFA27_Msk = 0x8000000
	// Bit FFA27.
	CAN_FFA1R_FFA27 = 0x8000000

	// FA1R: CAN filter activation register
	// Position of FACT0 field.
	CAN_FA1R_FACT0_Pos = 0x0
	// Bit mask of FACT0 field.
	CAN_FA1R_FACT0_Msk = 0x1
	// Bit FACT0.
	CAN_FA1R_FACT0 = 0x1
	// Position of FACT1 field.
	CAN_FA1R_FACT1_Pos = 0x1
	// Bit mask of FACT1 field.
	CAN_FA1R_FACT1_Msk = 0x2
	// Bit FACT1.
	CAN_FA1R_FACT1 = 0x2
	// Position of FACT2 field.
	CAN_FA1R_FACT2_Pos = 0x2
	// Bit mask of FACT2 field.
	CAN_FA1R_FACT2_Msk = 0x4
	// Bit FACT2.
	CAN_FA1R_FACT2 = 0x4
	// Position of FACT3 field.
	CAN_FA1R_FACT3_Pos = 0x3
	// Bit mask of FACT3 field.
	CAN_FA1R_FACT3_Msk = 0x8
	// Bit FACT3.
	CAN_FA1R_FACT3 = 0x8
	// Position of FACT4 field.
	CAN_FA1R_FACT4_Pos = 0x4
	// Bit mask of FACT4 field.
	CAN_FA1R_FACT4_Msk = 0x10
	// Bit FACT4.
	CAN_FA1R_FACT4 = 0x10
	// Position of FACT5 field.
	CAN_FA1R_FACT5_Pos = 0x5
	// Bit mask of FACT5 field.
	CAN_FA1R_FACT5_Msk = 0x20
	// Bit FACT5.
	CAN_FA1R_FACT5 = 0x20
	// Position of FACT6 field.
	CAN_FA1R_FACT6_Pos = 0x6
	// Bit mask of FACT6 field.
	CAN_FA1R_FACT6_Msk = 0x40
	// Bit FACT6.
	CAN_FA1R_FACT6 = 0x40
	// Position of FACT7 field.
	CAN_FA1R_FACT7_Pos = 0x7
	// Bit mask of FACT7 field.
	CAN_FA1R_FACT7_Msk = 0x80
	// Bit FACT7.
	CAN_FA1R_FACT7 = 0x80
	// Position of FACT8 field.
	CAN_FA1R_FACT8_Pos = 0x8
	// Bit mask of FACT8 field.
	CAN_FA1R_FACT8_Msk = 0x100
	// Bit FACT8.
	CAN_FA1R_FACT8 = 0x100
	// Position of FACT9 field.
	CAN_FA1R_FACT9_Pos = 0x9
	// Bit mask of FACT9 field.
	CAN_FA1R_FACT9_Msk = 0x200
	// Bit FACT9.
	CAN_FA1R_FACT9 = 0x200
	// Position of FACT10 field.
	CAN_FA1R_FACT10_Pos = 0xa
	// Bit mask of FACT10 field.
	CAN_FA1R_FACT10_Msk = 0x400
	// Bit FACT10.
	CAN_FA1R_FACT10 = 0x400
	// Position of FACT11 field.
	CAN_FA1R_FACT11_Pos = 0xb
	// Bit mask of FACT11 field.
	CAN_FA1R_FACT11_Msk = 0x800
	// Bit FACT11.
	CAN_FA1R_FACT11 = 0x800
	// Position of FACT12 field.
	CAN_FA1R_FACT12_Pos = 0xc
	// Bit mask of FACT12 field.
	CAN_FA1R_FACT12_Msk = 0x1000
	// Bit FACT12.
	CAN_FA1R_FACT12 = 0x1000
	// Position of FACT13 field.
	CAN_FA1R_FACT13_Pos = 0xd
	// Bit mask of FACT13 field.
	CAN_FA1R_FACT13_Msk = 0x2000
	// Bit FACT13.
	CAN_FA1R_FACT13 = 0x2000
	// Position of FACT14 field.
	CAN_FA1R_FACT14_Pos = 0xe
	// Bit mask of FACT14 field.
	CAN_FA1R_FACT14_Msk = 0x4000
	// Bit FACT14.
	CAN_FA1R_FACT14 = 0x4000
	// Position of FACT15 field.
	CAN_FA1R_FACT15_Pos = 0xf
	// Bit mask of FACT15 field.
	CAN_FA1R_FACT15_Msk = 0x8000
	// Bit FACT15.
	CAN_FA1R_FACT15 = 0x8000
	// Position of FACT16 field.
	CAN_FA1R_FACT16_Pos = 0x10
	// Bit mask of FACT16 field.
	CAN_FA1R_FACT16_Msk = 0x10000
	// Bit FACT16.
	CAN_FA1R_FACT16 = 0x10000
	// Position of FACT17 field.
	CAN_FA1R_FACT17_Pos = 0x11
	// Bit mask of FACT17 field.
	CAN_FA1R_FACT17_Msk = 0x20000
	// Bit FACT17.
	CAN_FA1R_FACT17 = 0x20000
	// Position of FACT18 field.
	CAN_FA1R_FACT18_Pos = 0x12
	// Bit mask of FACT18 field.
	CAN_FA1R_FACT18_Msk = 0x40000
	// Bit FACT18.
	CAN_FA1R_FACT18 = 0x40000
	// Position of FACT19 field.
	CAN_FA1R_FACT19_Pos = 0x13
	// Bit mask of FACT19 field.
	CAN_FA1R_FACT19_Msk = 0x80000
	// Bit FACT19.
	CAN_FA1R_FACT19 = 0x80000
	// Position of FACT20 field.
	CAN_FA1R_FACT20_Pos = 0x14
	// Bit mask of FACT20 field.
	CAN_FA1R_FACT20_Msk = 0x100000
	// Bit FACT20.
	CAN_FA1R_FACT20 = 0x100000
	// Position of FACT21 field.
	CAN_FA1R_FACT21_Pos = 0x15
	// Bit mask of FACT21 field.
	CAN_FA1R_FACT21_Msk = 0x200000
	// Bit FACT21.
	CAN_FA1R_FACT21 = 0x200000
	// Position of FACT22 field.
	CAN_FA1R_FACT22_Pos = 0x16
	// Bit mask of FACT22 field.
	CAN_FA1R_FACT22_Msk = 0x400000
	// Bit FACT22.
	CAN_FA1R_FACT22 = 0x400000
	// Position of FACT23 field.
	CAN_FA1R_FACT23_Pos = 0x17
	// Bit mask of FACT23 field.
	CAN_FA1R_FACT23_Msk = 0x800000
	// Bit FACT23.
	CAN_FA1R_FACT23 = 0x800000
	// Position of FACT24 field.
	CAN_FA1R_FACT24_Pos = 0x18
	// Bit mask of FACT24 field.
	CAN_FA1R_FACT24_Msk = 0x1000000
	// Bit FACT24.
	CAN_FA1R_FACT24 = 0x1000000
	// Position of FACT25 field.
	CAN_FA1R_FACT25_Pos = 0x19
	// Bit mask of FACT25 field.
	CAN_FA1R_FACT25_Msk = 0x2000000
	// Bit FACT25.
	CAN_FA1R_FACT25 = 0x2000000
	// Position of FACT26 field.
	CAN_FA1R_FACT26_Pos = 0x1a
	// Bit mask of FACT26 field.
	CAN_FA1R_FACT26_Msk = 0x4000000
	// Bit FACT26.
	CAN_FA1R_FACT26 = 0x4000000
	// Position of FACT27 field.
	CAN_FA1R_FACT27_Pos = 0x1b
	// Bit mask of FACT27 field.
	CAN_FA1R_FACT27_Msk = 0x8000000
	// Bit FACT27.
	CAN_FA1R_FACT27 = 0x8000000

	// FB.FR1: Filter bank 0 register 1
	// Position of FB0 field.
	CAN_FB_FR1_FB0_Pos = 0x0
	// Bit mask of FB0 field.
	CAN_FB_FR1_FB0_Msk = 0x1
	// Bit FB0.
	CAN_FB_FR1_FB0 = 0x1
	// Position of FB1 field.
	CAN_FB_FR1_FB1_Pos = 0x1
	// Bit mask of FB1 field.
	CAN_FB_FR1_FB1_Msk = 0x2
	// Bit FB1.
	CAN_FB_FR1_FB1 = 0x2
	// Position of FB2 field.
	CAN_FB_FR1_FB2_Pos = 0x2
	// Bit mask of FB2 field.
	CAN_FB_FR1_FB2_Msk = 0x4
	// Bit FB2.
	CAN_FB_FR1_FB2 = 0x4
	// Position of FB3 field.
	CAN_FB_FR1_FB3_Pos = 0x3
	// Bit mask of FB3 field.
	CAN_FB_FR1_FB3_Msk = 0x8
	// Bit FB3.
	CAN_FB_FR1_FB3 = 0x8
	// Position of FB4 field.
	CAN_FB_FR1_FB4_Pos = 0x4
	// Bit mask of FB4 field.
	CAN_FB_FR1_FB4_Msk = 0x10
	// Bit FB4.
	CAN_FB_FR1_FB4 = 0x10
	// Position of FB5 field.
	CAN_FB_FR1_FB5_Pos = 0x5
	// Bit mask of FB5 field.
	CAN_FB_FR1_FB5_Msk = 0x20
	// Bit FB5.
	CAN_FB_FR1_FB5 = 0x20
	// Position of FB6 field.
	CAN_FB_FR1_FB6_Pos = 0x6
	// Bit mask of FB6 field.
	CAN_FB_FR1_FB6_Msk = 0x40
	// Bit FB6.
	CAN_FB_FR1_FB6 = 0x40
	// Position of FB7 field.
	CAN_FB_FR1_FB7_Pos = 0x7
	// Bit mask of FB7 field.
	CAN_FB_FR1_FB7_Msk = 0x80
	// Bit FB7.
	CAN_FB_FR1_FB7 = 0x80
	// Position of FB8 field.
	CAN_FB_FR1_FB8_Pos = 0x8
	// Bit mask of FB8 field.
	CAN_FB_FR1_FB8_Msk = 0x100
	// Bit FB8.
	CAN_FB_FR1_FB8 = 0x100
	// Position of FB9 field.
	CAN_FB_FR1_FB9_Pos = 0x9
	// Bit mask of FB9 field.
	CAN_FB_FR1_FB9_Msk = 0x200
	// Bit FB9.
	CAN_FB_FR1_FB9 = 0x200
	// Position of FB10 field.
	CAN_FB_FR1_FB10_Pos = 0xa
	// Bit mask of FB10 field.
	CAN_FB_FR1_FB10_Msk = 0x400
	// Bit FB10.
	CAN_FB_FR1_FB10 = 0x400
	// Position of FB11 field.
	CAN_FB_FR1_FB11_Pos = 0xb
	// Bit mask of FB11 field.
	CAN_FB_FR1_FB11_Msk = 0x800
	// Bit FB11.
	CAN_FB_FR1_FB11 = 0x800
	// Position of FB12 field.
	CAN_FB_FR1_FB12_Pos = 0xc
	// Bit mask of FB12 field.
	CAN_FB_FR1_FB12_Msk = 0x1000
	// Bit FB12.
	CAN_FB_FR1_FB12 = 0x1000
	// Position of FB13 field.
	CAN_FB_FR1_FB13_Pos = 0xd
	// Bit mask of FB13 field.
	CAN_FB_FR1_FB13_Msk = 0x2000
	// Bit FB13.
	CAN_FB_FR1_FB13 = 0x2000
	// Position of FB14 field.
	CAN_FB_FR1_FB14_Pos = 0xe
	// Bit mask of FB14 field.
	CAN_FB_FR1_FB14_Msk = 0x4000
	// Bit FB14.
	CAN_FB_FR1_FB14 = 0x4000
	// Position of FB15 field.
	CAN_FB_FR1_FB15_Pos = 0xf
	// Bit mask of FB15 field.
	CAN_FB_FR1_FB15_Msk = 0x8000
	// Bit FB15.
	CAN_FB_FR1_FB15 = 0x8000
	// Position of FB16 field.
	CAN_FB_FR1_FB16_Pos = 0x10
	// Bit mask of FB16 field.
	CAN_FB_FR1_FB16_Msk = 0x10000
	// Bit FB16.
	CAN_FB_FR1_FB16 = 0x10000
	// Position of FB17 field.
	CAN_FB_FR1_FB17_Pos = 0x11
	// Bit mask of FB17 field.
	CAN_FB_FR1_FB17_Msk = 0x20000
	// Bit FB17.
	CAN_FB_FR1_FB17 = 0x20000
	// Position of FB18 field.
	CAN_FB_FR1_FB18_Pos = 0x12
	// Bit mask of FB18 field.
	CAN_FB_FR1_FB18_Msk = 0x40000
	// Bit FB18.
	CAN_FB_FR1_FB18 = 0x40000
	// Position of FB19 field.
	CAN_FB_FR1_FB19_Pos = 0x13
	// Bit mask of FB19 field.
	CAN_FB_FR1_FB19_Msk = 0x80000
	// Bit FB19.
	CAN_FB_FR1_FB19 = 0x80000
	// Position of FB20 field.
	CAN_FB_FR1_FB20_Pos = 0x14
	// Bit mask of FB20 field.
	CAN_FB_FR1_FB20_Msk = 0x100000
	// Bit FB20.
	CAN_FB_FR1_FB20 = 0x100000
	// Position of FB21 field.
	CAN_FB_FR1_FB21_Pos = 0x15
	// Bit mask of FB21 field.
	CAN_FB_FR1_FB21_Msk = 0x200000
	// Bit FB21.
	CAN_FB_FR1_FB21 = 0x200000
	// Position of FB22 field.
	CAN_FB_FR1_FB22_Pos = 0x16
	// Bit mask of FB22 field.
	CAN_FB_FR1_FB22_Msk = 0x400000
	// Bit FB22.
	CAN_FB_FR1_FB22 = 0x400000
	// Position of FB23 field.
	CAN_FB_FR1_FB23_Pos = 0x17
	// Bit mask of FB23 field.
	CAN_FB_FR1_FB23_Msk = 0x800000
	// Bit FB23.
	CAN_FB_FR1_FB23 = 0x800000
	// Position of FB24 field.
	CAN_FB_FR1_FB24_Pos = 0x18
	// Bit mask of FB24 field.
	CAN_FB_FR1_FB24_Msk = 0x1000000
	// Bit FB24.
	CAN_FB_FR1_FB24 = 0x1000000
	// Position of FB25 field.
	CAN_FB_FR1_FB25_Pos = 0x19
	// Bit mask of FB25 field.
	CAN_FB_FR1_FB25_Msk = 0x2000000
	// Bit FB25.
	CAN_FB_FR1_FB25 = 0x2000000
	// Position of FB26 field.
	CAN_FB_FR1_FB26_Pos = 0x1a
	// Bit mask of FB26 field.
	CAN_FB_FR1_FB26_Msk = 0x4000000
	// Bit FB26.
	CAN_FB_FR1_FB26 = 0x4000000
	// Position of FB27 field.
	CAN_FB_FR1_FB27_Pos = 0x1b
	// Bit mask of FB27 field.
	CAN_FB_FR1_FB27_Msk = 0x8000000
	// Bit FB27.
	CAN_FB_FR1_FB27 = 0x8000000
	// Position of FB28 field.
	CAN_FB_FR1_FB28_Pos = 0x1c
	// Bit mask of FB28 field.
	CAN_FB_FR1_FB28_Msk = 0x10000000
	// Bit FB28.
	CAN_FB_FR1_FB28 = 0x10000000
	// Position of FB29 field.
	CAN_FB_FR1_FB29_Pos = 0x1d
	// Bit mask of FB29 field.
	CAN_FB_FR1_FB29_Msk = 0x20000000
	// Bit FB29.
	CAN_FB_FR1_FB29 = 0x20000000
	// Position of FB30 field.
	CAN_FB_FR1_FB30_Pos = 0x1e
	// Bit mask of FB30 field.
	CAN_FB_FR1_FB30_Msk = 0x40000000
	// Bit FB30.
	CAN_FB_FR1_FB30 = 0x40000000
	// Position of FB31 field.
	CAN_FB_FR1_FB31_Pos = 0x1f
	// Bit mask of FB31 field.
	CAN_FB_FR1_FB31_Msk = 0x80000000
	// Bit FB31.
	CAN_FB_FR1_FB31 = 0x80000000

	// FB.FR2: Filter bank 0 register 2
	// Position of FB0 field.
	CAN_FB_FR2_FB0_Pos = 0x0
	// Bit mask of FB0 field.
	CAN_FB_FR2_FB0_Msk = 0x1
	// Bit FB0.
	CAN_FB_FR2_FB0 = 0x1
	// Position of FB1 field.
	CAN_FB_FR2_FB1_Pos = 0x1
	// Bit mask of FB1 field.
	CAN_FB_FR2_FB1_Msk = 0x2
	// Bit FB1.
	CAN_FB_FR2_FB1 = 0x2
	// Position of FB2 field.
	CAN_FB_FR2_FB2_Pos = 0x2
	// Bit mask of FB2 field.
	CAN_FB_FR2_FB2_Msk = 0x4
	// Bit FB2.
	CAN_FB_FR2_FB2 = 0x4
	// Position of FB3 field.
	CAN_FB_FR2_FB3_Pos = 0x3
	// Bit mask of FB3 field.
	CAN_FB_FR2_FB3_Msk = 0x8
	// Bit FB3.
	CAN_FB_FR2_FB3 = 0x8
	// Position of FB4 field.
	CAN_FB_FR2_FB4_Pos = 0x4
	// Bit mask of FB4 field.
	CAN_FB_FR2_FB4_Msk = 0x10
	// Bit FB4.
	CAN_FB_FR2_FB4 = 0x10
	// Position of FB5 field.
	CAN_FB_FR2_FB5_Pos = 0x5
	// Bit mask of FB5 field.
	CAN_FB_FR2_FB5_Msk = 0x20
	// Bit FB5.
	CAN_FB_FR2_FB5 = 0x20
	// Position of FB6 field.
	CAN_FB_FR2_FB6_Pos = 0x6
	// Bit mask of FB6 field.
	CAN_FB_FR2_FB6_Msk = 0x40
	// Bit FB6.
	CAN_FB_FR2_FB6 = 0x40
	// Position of FB7 field.
	CAN_FB_FR2_FB7_Pos = 0x7
	// Bit mask of FB7 field.
	CAN_FB_FR2_FB7_Msk = 0x80
	// Bit FB7.
	CAN_FB_FR2_FB7 = 0x80
	// Position of FB8 field.
	CAN_FB_FR2_FB8_Pos = 0x8
	// Bit mask of FB8 field.
	CAN_FB_FR2_FB8_Msk = 0x100
	// Bit FB8.
	CAN_FB_FR2_FB8 = 0x100
	// Position of FB9 field.
	CAN_FB_FR2_FB9_Pos = 0x9
	// Bit mask of FB9 field.
	CAN_FB_FR2_FB9_Msk = 0x200
	// Bit FB9.
	CAN_FB_FR2_FB9 = 0x200
	// Position of FB10 field.
	CAN_FB_FR2_FB10_Pos = 0xa
	// Bit mask of FB10 field.
	CAN_FB_FR2_FB10_Msk = 0x400
	// Bit FB10.
	CAN_FB_FR2_FB10 = 0x400
	// Position of FB11 field.
	CAN_FB_FR2_FB11_Pos = 0xb
	// Bit mask of FB11 field.
	CAN_FB_FR2_FB11_Msk = 0x800
	// Bit FB11.
	CAN_FB_FR2_FB11 = 0x800
	// Position of FB12 field.
	CAN_FB_FR2_FB12_Pos = 0xc
	// Bit mask of FB12 field.
	CAN_FB_FR2_FB12_Msk = 0x1000
	// Bit FB12.
	CAN_FB_FR2_FB12 = 0x1000
	// Position of FB13 field.
	CAN_FB_FR2_FB13_Pos = 0xd
	// Bit mask of FB13 field.
	CAN_FB_FR2_FB13_Msk = 0x2000
	// Bit FB13.
	CAN_FB_FR2_FB13 = 0x2000
	// Position of FB14 field.
	CAN_FB_FR2_FB14_Pos = 0xe
	// Bit mask of FB14 field.
	CAN_FB_FR2_FB14_Msk = 0x4000
	// Bit FB14.
	CAN_FB_FR2_FB14 = 0x4000
	// Position of FB15 field.
	CAN_FB_FR2_FB15_Pos = 0xf
	// Bit mask of FB15 field.
	CAN_FB_FR2_FB15_Msk = 0x8000
	// Bit FB15.
	CAN_FB_FR2_FB15 = 0x8000
	// Position of FB16 field.
	CAN_FB_FR2_FB16_Pos = 0x10
	// Bit mask of FB16 field.
	CAN_FB_FR2_FB16_Msk = 0x10000
	// Bit FB16.
	CAN_FB_FR2_FB16 = 0x10000
	// Position of FB17 field.
	CAN_FB_FR2_FB17_Pos = 0x11
	// Bit mask of FB17 field.
	CAN_FB_FR2_FB17_Msk = 0x20000
	// Bit FB17.
	CAN_FB_FR2_FB17 = 0x20000
	// Position of FB18 field.
	CAN_FB_FR2_FB18_Pos = 0x12
	// Bit mask of FB18 field.
	CAN_FB_FR2_FB18_Msk = 0x40000
	// Bit FB18.
	CAN_FB_FR2_FB18 = 0x40000
	// Position of FB19 field.
	CAN_FB_FR2_FB19_Pos = 0x13
	// Bit mask of FB19 field.
	CAN_FB_FR2_FB19_Msk = 0x80000
	// Bit FB19.
	CAN_FB_FR2_FB19 = 0x80000
	// Position of FB20 field.
	CAN_FB_FR2_FB20_Pos = 0x14
	// Bit mask of FB20 field.
	CAN_FB_FR2_FB20_Msk = 0x100000
	// Bit FB20.
	CAN_FB_FR2_FB20 = 0x100000
	// Position of FB21 field.
	CAN_FB_FR2_FB21_Pos = 0x15
	// Bit mask of FB21 field.
	CAN_FB_FR2_FB21_Msk = 0x200000
	// Bit FB21.
	CAN_FB_FR2_FB21 = 0x200000
	// Position of FB22 field.
	CAN_FB_FR2_FB22_Pos = 0x16
	// Bit mask of FB22 field.
	CAN_FB_FR2_FB22_Msk = 0x400000
	// Bit FB22.
	CAN_FB_FR2_FB22 = 0x400000
	// Position of FB23 field.
	CAN_FB_FR2_FB23_Pos = 0x17
	// Bit mask of FB23 field.
	CAN_FB_FR2_FB23_Msk = 0x800000
	// Bit FB23.
	CAN_FB_FR2_FB23 = 0x800000
	// Position of FB24 field.
	CAN_FB_FR2_FB24_Pos = 0x18
	// Bit mask of FB24 field.
	CAN_FB_FR2_FB24_Msk = 0x1000000
	// Bit FB24.
	CAN_FB_FR2_FB24 = 0x1000000
	// Position of FB25 field.
	CAN_FB_FR2_FB25_Pos = 0x19
	// Bit mask of FB25 field.
	CAN_FB_FR2_FB25_Msk = 0x2000000
	// Bit FB25.
	CAN_FB_FR2_FB25 = 0x2000000
	// Position of FB26 field.
	CAN_FB_FR2_FB26_Pos = 0x1a
	// Bit mask of FB26 field.
	CAN_FB_FR2_FB26_Msk = 0x4000000
	// Bit FB26.
	CAN_FB_FR2_FB26 = 0x4000000
	// Position of FB27 field.
	CAN_FB_FR2_FB27_Pos = 0x1b
	// Bit mask of FB27 field.
	CAN_FB_FR2_FB27_Msk = 0x8000000
	// Bit FB27.
	CAN_FB_FR2_FB27 = 0x8000000
	// Position of FB28 field.
	CAN_FB_FR2_FB28_Pos = 0x1c
	// Bit mask of FB28 field.
	CAN_FB_FR2_FB28_Msk = 0x10000000
	// Bit FB28.
	CAN_FB_FR2_FB28 = 0x10000000
	// Position of FB29 field.
	CAN_FB_FR2_FB29_Pos = 0x1d
	// Bit mask of FB29 field.
	CAN_FB_FR2_FB29_Msk = 0x20000000
	// Bit FB29.
	CAN_FB_FR2_FB29 = 0x20000000
	// Position of FB30 field.
	CAN_FB_FR2_FB30_Pos = 0x1e
	// Bit mask of FB30 field.
	CAN_FB_FR2_FB30_Msk = 0x40000000
	// Bit FB30.
	CAN_FB_FR2_FB30 = 0x40000000
	// Position of FB31 field.
	CAN_FB_FR2_FB31_Pos = 0x1f
	// Bit mask of FB31 field.
	CAN_FB_FR2_FB31_Msk = 0x80000000
	// Bit FB31.
	CAN_FB_FR2_FB31 = 0x80000000
)

// Constants for USB: Universal serial bus full-speed device interface
const (
	// EP0R: endpoint 0 register
	// Position of EA field.
	USB_EP0R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP0R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP0R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP0R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP0R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP0R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP0R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP0R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP0R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP0R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP0R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP0R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP0R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP0R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP0R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP0R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP0R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP0R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP0R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP0R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP0R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP0R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP0R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP0R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP0R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP0R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP0R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP0R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP0R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP0R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP0R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP0R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP0R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP0R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP0R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP0R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP0R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP0R_CTR_RX = 0x8000

	// EP1R: endpoint 1 register
	// Position of EA field.
	USB_EP1R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP1R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP1R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP1R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP1R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP1R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP1R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP1R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP1R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP1R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP1R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP1R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP1R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP1R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP1R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP1R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP1R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP1R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP1R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP1R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP1R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP1R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP1R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP1R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP1R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP1R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP1R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP1R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP1R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP1R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP1R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP1R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP1R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP1R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP1R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP1R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP1R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP1R_CTR_RX = 0x8000

	// EP2R: endpoint 2 register
	// Position of EA field.
	USB_EP2R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP2R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP2R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP2R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP2R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP2R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP2R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP2R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP2R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP2R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP2R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP2R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP2R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP2R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP2R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP2R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP2R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP2R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP2R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP2R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP2R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP2R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP2R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP2R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP2R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP2R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP2R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP2R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP2R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP2R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP2R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP2R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP2R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP2R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP2R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP2R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP2R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP2R_CTR_RX = 0x8000

	// EP3R: endpoint 3 register
	// Position of EA field.
	USB_EP3R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP3R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP3R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP3R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP3R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP3R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP3R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP3R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP3R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP3R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP3R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP3R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP3R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP3R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP3R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP3R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP3R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP3R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP3R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP3R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP3R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP3R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP3R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP3R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP3R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP3R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP3R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP3R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP3R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP3R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP3R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP3R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP3R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP3R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP3R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP3R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP3R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP3R_CTR_RX = 0x8000

	// EP4R: endpoint 4 register
	// Position of EA field.
	USB_EP4R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP4R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP4R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP4R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP4R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP4R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP4R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP4R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP4R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP4R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP4R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP4R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP4R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP4R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP4R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP4R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP4R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP4R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP4R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP4R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP4R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP4R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP4R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP4R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP4R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP4R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP4R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP4R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP4R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP4R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP4R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP4R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP4R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP4R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP4R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP4R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP4R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP4R_CTR_RX = 0x8000

	// EP5R: endpoint 5 register
	// Position of EA field.
	USB_EP5R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP5R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP5R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP5R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP5R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP5R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP5R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP5R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP5R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP5R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP5R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP5R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP5R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP5R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP5R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP5R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP5R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_EP5R_EP_TYPE_Pos = 0x9
	// Bit mask of EP_TYPE field.
	USB_EP5R_EP_TYPE_Msk = 0x600
	// Bulk endpoint
	USB_EP5R_EP_TYPE_Bulk = 0x0
	// Control endpoint
	USB_EP5R_EP_TYPE_Control = 0x1
	// Iso endpoint
	USB_EP5R_EP_TYPE_Iso = 0x2
	// Interrupt endpoint
	USB_EP5R_EP_TYPE_Interrupt = 0x3
	// Position of SETUP field.
	USB_EP5R_SETUP_Pos = 0xb
	// Bit mask of SETUP field.
	USB_EP5R_SETUP_Msk = 0x800
	// Bit SETUP.
	USB_EP5R_SETUP = 0x800
	// Position of STAT_RX field.
	USB_EP5R_STAT_RX_Pos = 0xc
	// Bit mask of STAT_RX field.
	USB_EP5R_STAT_RX_Msk = 0x3000
	// all reception requests addressed to this endpoint are ignored
	USB_EP5R_STAT_RX_Disabled = 0x0
	// the endpoint is stalled and all reception requests result in a STALL handshake
	USB_EP5R_STAT_RX_Stall = 0x1
	// the endpoint is naked and all reception requests result in a NAK handshake
	USB_EP5R_STAT_RX_Nak = 0x2
	// this endpoint is enabled for reception
	USB_EP5R_STAT_RX_Valid = 0x3
	// Position of DTOG_RX field.
	USB_EP5R_DTOG_RX_Pos = 0xe
	// Bit mask of DTOG_RX field.
	USB_EP5R_DTOG_RX_Msk = 0x4000
	// Bit DTOG_RX.
	USB_EP5R_DTOG_RX = 0x4000
	// Position of CTR_RX field.
	USB_EP5R_CTR_RX_Pos = 0xf
	// Bit mask of CTR_RX field.
	USB_EP5R_CTR_RX_Msk = 0x8000
	// Bit CTR_RX.
	USB_EP5R_CTR_RX = 0x8000

	// EP6R: endpoint 6 register
	// Position of EA field.
	USB_EP6R_EA_Pos = 0x0
	// Bit mask of EA field.
	USB_EP6R_EA_Msk = 0xf
	// Position of STAT_TX field.
	USB_EP6R_STAT_TX_Pos = 0x4
	// Bit mask of STAT_TX field.
	USB_EP6R_STAT_TX_Msk = 0x30
	// all transmission requests addressed to this endpoint are ignored
	USB_EP6R_STAT_TX_Disabled = 0x0
	// the endpoint is stalled and all transmission requests result in a STALL handshake
	USB_EP6R_STAT_TX_Stall = 0x1
	// the endpoint is naked and all transmission requests result in a NAK handshake
	USB_EP6R_STAT_TX_Nak = 0x2
	// this endpoint is enabled for transmission
	USB_EP6R_STAT_TX_Valid = 0x3
	// Position of DTOG_TX field.
	USB_EP6R_DTOG_TX_Pos = 0x6
	// Bit mask of DTOG_TX field.
	USB_EP6R_DTOG_TX_Msk = 0x40
	// Bit DTOG_TX.
	USB_EP6R_DTOG_TX = 0x40
	// Position of CTR_TX field.
	USB_EP6R_CTR_TX_Pos = 0x7
	// Bit mask of CTR_TX field.
	USB_EP6R_CTR_TX_Msk = 0x80
	// Bit CTR_TX.
	USB_EP6R_CTR_TX = 0x80
	// Position of EP_KIND field.
	USB_EP6R_EP_KIND_Pos = 0x8
	// Bit mask of EP_KIND field.
	USB_EP6R_EP_KIND_Msk = 0x100
	// Bit EP_KIND.
	USB_EP6R_EP_KIND = 0x100
	// Position of EP_TYPE field.
	USB_E