// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from stm32f730.svd, see https://github.com/tinygo-org/stm32-svd

//go:build stm32 && stm32f730
// +build stm32,stm32f730

// STM32F730
//

package stm32

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "STM32F730"
	CPU          = "CM7"
	FPUPresent   = true
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Window watchdog
	IRQ_WWDG = 0

	// External interrupt/event controller
	IRQ_PVD = 1

	// External interrupt/event controller
	IRQ_TAMP_STAMP = 2

	// Real-time clock
	IRQ_RTC_WKUP = 3

	// FLASH
	IRQ_FLASH = 4

	// Reset and clock control
	IRQ_RCC = 5

	// External interrupt/event controller
	IRQ_EXTI0 = 6

	// External interrupt/event controller
	IRQ_EXTI1 = 7

	// External interrupt/event controller
	IRQ_EXTI2 = 8

	// External interrupt/event controller
	IRQ_EXTI3 = 9

	// External interrupt/event controller
	IRQ_EXTI4 = 10

	IRQ_DMA1_Stream0 = 11

	IRQ_DMA1_Stream1 = 12

	IRQ_DMA1_Stream2 = 13

	IRQ_DMA1_Stream3 = 14

	IRQ_DMA1_Stream4 = 15

	IRQ_DMA1_Stream5 = 16

	IRQ_DMA1_Stream6 = 17

	// Common ADC registers
	IRQ_ADC = 18

	// Controller area network
	IRQ_CAN1_TX = 19

	// Controller area network
	IRQ_CAN1_RX0 = 20

	// Controller area network
	IRQ_CAN1_RX1 = 21

	// Controller area network
	IRQ_CAN1_SCE = 22

	// External interrupt/event controller
	IRQ_EXTI9_5 = 23

	// Advanced-timers
	IRQ_TIM1_BRK_TIM9 = 24

	// Advanced-timers
	IRQ_TIM1_UP_TIM10 = 25

	// Advanced-timers
	IRQ_TIM1_TRG_COM_TIM11 = 26

	// Advanced-timers
	IRQ_TIM1_CC = 27

	// General purpose timers
	IRQ_TIM2 = 28

	// General purpose timers
	IRQ_TIM3 = 29

	IRQ_TIM4 = 30

	// Inter-integrated circuit
	IRQ_I2C1_EV = 31

	// Inter-integrated circuit
	IRQ_I2C1_ER = 32

	IRQ_I2C2_EV = 33

	IRQ_I2C2_ER = 34

	// Serial peripheral interface
	IRQ_SPI1 = 35

	IRQ_SPI2 = 36

	// Universal synchronous asynchronous receiver transmitter
	IRQ_USART1 = 37

	IRQ_USART2 = 38

	IRQ_USART3 = 39

	// External interrupt/event controller
	IRQ_EXTI15_10 = 40

	// Real-time clock
	IRQ_RTC_ALARM = 41

	// USB on the go full speed
	IRQ_OTG_FS_WKUP = 42

	IRQ_TIM8_BRK_TIM12 = 43

	IRQ_TIM8_UP_TIM13 = 44

	IRQ_TIM8_TRG_COM_TIM14 = 45

	IRQ_TIM8_CC = 46

	IRQ_DMA1_Stream7 = 47

	// Flexible memory controller
	IRQ_FSMC = 48

	// Secure digital input/output interface
	IRQ_SDMMC1 = 49

	// General purpose timers
	IRQ_TIM5 = 50

	IRQ_SPI3 = 51

	IRQ_UART4 = 52

	IRQ_UART5 = 53

	// Basic timers
	IRQ_TIM6_DAC = 54

	IRQ_TIM7 = 55

	// DMA controller
	IRQ_DMA2_Stream0 = 56

	// DMA controller
	IRQ_DMA2_Stream1 = 57

	// DMA controller
	IRQ_DMA2_Stream2 = 58

	// DMA controller
	IRQ_DMA2_Stream3 = 59

	// DMA controller
	IRQ_DMA2_Stream4 = 60

	// USB on the go full speed
	IRQ_OTG_FS = 67

	// DMA controller
	IRQ_DMA2_Stream5 = 68

	// DMA controller
	IRQ_DMA2_Stream6 = 69

	// DMA controller
	IRQ_DMA2_Stream7 = 70

	IRQ_USART6 = 71

	IRQ_I2C3_EV = 72

	IRQ_I2C3_ER = 73

	// USB on the go high speed
	IRQ_OTG_HS_EP1_OUT = 74

	// USB on the go high speed
	IRQ_OTG_HS_EP1_IN = 75

	// USB on the go high speed
	IRQ_OTG_HS_WKUP = 76

	// USB on the go high speed
	IRQ_OTG_HS = 77

	// Advanced encryption standard hardware accelerator 1
	IRQ_AES = 79

	// Random number generator
	IRQ_RNG = 80

	// Floting point unit
	IRQ_FPU = 81

	IRQ_UART7 = 82

	IRQ_UART8 = 83

	IRQ_SPI4 = 84

	IRQ_SPI5 = 85

	// Serial audio interface
	IRQ_SAI1 = 87

	IRQ_SAI2 = 91

	// QuadSPI interface
	IRQ_QuadSPI = 92

	// Low power timer
	IRQ_LP_Timer1 = 93

	IRQ_SDMMC2 = 103

	// Highest interrupt number on this device.
	IRQ_max = 103
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export WWDG_IRQHandler
func interruptWWDG() {
	callHandlers(IRQ_WWDG)
}

//export PVD_IRQHandler
func interruptPVD() {
	callHandlers(IRQ_PVD)
}

//export TAMP_STAMP_IRQHandler
func interruptTAMP_STAMP() {
	callHandlers(IRQ_TAMP_STAMP)
}

//export RTC_WKUP_IRQHandler
func interruptRTC_WKUP() {
	callHandlers(IRQ_RTC_WKUP)
}

//export FLASH_IRQHandler
func interruptFLASH() {
	callHandlers(IRQ_FLASH)
}

//export RCC_IRQHandler
func interruptRCC() {
	callHandlers(IRQ_RCC)
}

//export EXTI0_IRQHandler
func interruptEXTI0() {
	callHandlers(IRQ_EXTI0)
}

//export EXTI1_IRQHandler
func interruptEXTI1() {
	callHandlers(IRQ_EXTI1)
}

//export EXTI2_IRQHandler
func interruptEXTI2() {
	callHandlers(IRQ_EXTI2)
}

//export EXTI3_IRQHandler
func interruptEXTI3() {
	callHandlers(IRQ_EXTI3)
}

//export EXTI4_IRQHandler
func interruptEXTI4() {
	callHandlers(IRQ_EXTI4)
}

//export DMA1_Stream0_IRQHandler
func interruptDMA1_Stream0() {
	callHandlers(IRQ_DMA1_Stream0)
}

//export DMA1_Stream1_IRQHandler
func interruptDMA1_Stream1() {
	callHandlers(IRQ_DMA1_Stream1)
}

//export DMA1_Stream2_IRQHandler
func interruptDMA1_Stream2() {
	callHandlers(IRQ_DMA1_Stream2)
}

//export DMA1_Stream3_IRQHandler
func interruptDMA1_Stream3() {
	callHandlers(IRQ_DMA1_Stream3)
}

//export DMA1_Stream4_IRQHandler
func interruptDMA1_Stream4() {
	callHandlers(IRQ_DMA1_Stream4)
}

//export DMA1_Stream5_IRQHandler
func interruptDMA1_Stream5() {
	callHandlers(IRQ_DMA1_Stream5)
}

//export DMA1_Stream6_IRQHandler
func interruptDMA1_Stream6() {
	callHandlers(IRQ_DMA1_Stream6)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export CAN1_TX_IRQHandler
func interruptCAN1_TX() {
	callHandlers(IRQ_CAN1_TX)
}

//export CAN1_RX0_IRQHandler
func interruptCAN1_RX0() {
	callHandlers(IRQ_CAN1_RX0)
}

//export CAN1_RX1_IRQHandler
func interruptCAN1_RX1() {
	callHandlers(IRQ_CAN1_RX1)
}

//export CAN1_SCE_IRQHandler
func interruptCAN1_SCE() {
	callHandlers(IRQ_CAN1_SCE)
}

//export EXTI9_5_IRQHandler
func interruptEXTI9_5() {
	callHandlers(IRQ_EXTI9_5)
}

//export TIM1_BRK_TIM9_IRQHandler
func interruptTIM1_BRK_TIM9() {
	callHandlers(IRQ_TIM1_BRK_TIM9)
}

//export TIM1_UP_TIM10_IRQHandler
func interruptTIM1_UP_TIM10() {
	callHandlers(IRQ_TIM1_UP_TIM10)
}

//export TIM1_TRG_COM_TIM11_IRQHandler
func interruptTIM1_TRG_COM_TIM11() {
	callHandlers(IRQ_TIM1_TRG_COM_TIM11)
}

//export TIM1_CC_IRQHandler
func interruptTIM1_CC() {
	callHandlers(IRQ_TIM1_CC)
}

//export TIM2_IRQHandler
func interruptTIM2() {
	callHandlers(IRQ_TIM2)
}

//export TIM3_IRQHandler
func interruptTIM3() {
	callHandlers(IRQ_TIM3)
}

//export TIM4_IRQHandler
func interruptTIM4() {
	callHandlers(IRQ_TIM4)
}

//export I2C1_EV_IRQHandler
func interruptI2C1_EV() {
	callHandlers(IRQ_I2C1_EV)
}

//export I2C1_ER_IRQHandler
func interruptI2C1_ER() {
	callHandlers(IRQ_I2C1_ER)
}

//export I2C2_EV_IRQHandler
func interruptI2C2_EV() {
	callHandlers(IRQ_I2C2_EV)
}

//export I2C2_ER_IRQHandler
func interruptI2C2_ER() {
	callHandlers(IRQ_I2C2_ER)
}

//export SPI1_IRQHandler
func interruptSPI1() {
	callHandlers(IRQ_SPI1)
}

//export SPI2_IRQHandler
func interruptSPI2() {
	callHandlers(IRQ_SPI2)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export USART2_IRQHandler
func interruptUSART2() {
	callHandlers(IRQ_USART2)
}

//export USART3_IRQHandler
func interruptUSART3() {
	callHandlers(IRQ_USART3)
}

//export EXTI15_10_IRQHandler
func interruptEXTI15_10() {
	callHandlers(IRQ_EXTI15_10)
}

//export RTC_ALARM_IRQHandler
func interruptRTC_ALARM() {
	callHandlers(IRQ_RTC_ALARM)
}

//export OTG_FS_WKUP_IRQHandler
func interruptOTG_FS_WKUP() {
	callHandlers(IRQ_OTG_FS_WKUP)
}

//export TIM8_BRK_TIM12_IRQHandler
func interruptTIM8_BRK_TIM12() {
	callHandlers(IRQ_TIM8_BRK_TIM12)
}

//export TIM8_UP_TIM13_IRQHandler
func interruptTIM8_UP_TIM13() {
	callHandlers(IRQ_TIM8_UP_TIM13)
}

//export TIM8_TRG_COM_TIM14_IRQHandler
func interruptTIM8_TRG_COM_TIM14() {
	callHandlers(IRQ_TIM8_TRG_COM_TIM14)
}

//export TIM8_CC_IRQHandler
func interruptTIM8_CC() {
	callHandlers(IRQ_TIM8_CC)
}

//export DMA1_Stream7_IRQHandler
func interruptDMA1_Stream7() {
	callHandlers(IRQ_DMA1_Stream7)
}

//export FSMC_IRQHandler
func interruptFSMC() {
	callHandlers(IRQ_FSMC)
}

//export SDMMC1_IRQHandler
func interruptSDMMC1() {
	callHandlers(IRQ_SDMMC1)
}

//export TIM5_IRQHandler
func interruptTIM5() {
	callHandlers(IRQ_TIM5)
}

//export SPI3_IRQHandler
func interruptSPI3() {
	callHandlers(IRQ_SPI3)
}

//export UART4_IRQHandler
func interruptUART4() {
	callHandlers(IRQ_UART4)
}

//export UART5_IRQHandler
func interruptUART5() {
	callHandlers(IRQ_UART5)
}

//export TIM6_DAC_IRQHandler
func interruptTIM6_DAC() {
	callHandlers(IRQ_TIM6_DAC)
}

//export TIM7_IRQHandler
func interruptTIM7() {
	callHandlers(IRQ_TIM7)
}

//export DMA2_Stream0_IRQHandler
func interruptDMA2_Stream0() {
	callHandlers(IRQ_DMA2_Stream0)
}

//export DMA2_Stream1_IRQHandler
func interruptDMA2_Stream1() {
	callHandlers(IRQ_DMA2_Stream1)
}

//export DMA2_Stream2_IRQHandler
func interruptDMA2_Stream2() {
	callHandlers(IRQ_DMA2_Stream2)
}

//export DMA2_Stream3_IRQHandler
func interruptDMA2_Stream3() {
	callHandlers(IRQ_DMA2_Stream3)
}

//export DMA2_Stream4_IRQHandler
func interruptDMA2_Stream4() {
	callHandlers(IRQ_DMA2_Stream4)
}

//export OTG_FS_IRQHandler
func interruptOTG_FS() {
	callHandlers(IRQ_OTG_FS)
}

//export DMA2_Stream5_IRQHandler
func interruptDMA2_Stream5() {
	callHandlers(IRQ_DMA2_Stream5)
}

//export DMA2_Stream6_IRQHandler
func interruptDMA2_Stream6() {
	callHandlers(IRQ_DMA2_Stream6)
}

//export DMA2_Stream7_IRQHandler
func interruptDMA2_Stream7() {
	callHandlers(IRQ_DMA2_Stream7)
}

//export USART6_IRQHandler
func interruptUSART6() {
	callHandlers(IRQ_USART6)
}

//export I2C3_EV_IRQHandler
func interruptI2C3_EV() {
	callHandlers(IRQ_I2C3_EV)
}

//export I2C3_ER_IRQHandler
func interruptI2C3_ER() {
	callHandlers(IRQ_I2C3_ER)
}

//export OTG_HS_EP1_OUT_IRQHandler
func interruptOTG_HS_EP1_OUT() {
	callHandlers(IRQ_OTG_HS_EP1_OUT)
}

//export OTG_HS_EP1_IN_IRQHandler
func interruptOTG_HS_EP1_IN() {
	callHandlers(IRQ_OTG_HS_EP1_IN)
}

//export OTG_HS_WKUP_IRQHandler
func interruptOTG_HS_WKUP() {
	callHandlers(IRQ_OTG_HS_WKUP)
}

//export OTG_HS_IRQHandler
func interruptOTG_HS() {
	callHandlers(IRQ_OTG_HS)
}

//export AES_IRQHandler
func interruptAES() {
	callHandlers(IRQ_AES)
}

//export RNG_IRQHandler
func interruptRNG() {
	callHandlers(IRQ_RNG)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export UART7_IRQHandler
func interruptUART7() {
	callHandlers(IRQ_UART7)
}

//export UART8_IRQHandler
func interruptUART8() {
	callHandlers(IRQ_UART8)
}

//export SPI4_IRQHandler
func interruptSPI4() {
	callHandlers(IRQ_SPI4)
}

//export SPI5_IRQHandler
func interruptSPI5() {
	callHandlers(IRQ_SPI5)
}

//export SAI1_IRQHandler
func interruptSAI1() {
	callHandlers(IRQ_SAI1)
}

//export SAI2_IRQHandler
func interruptSAI2() {
	callHandlers(IRQ_SAI2)
}

//export QuadSPI_IRQHandler
func interruptQuadSPI() {
	callHandlers(IRQ_QuadSPI)
}

//export LP_Timer1_IRQHandler
func interruptLP_Timer1() {
	callHandlers(IRQ_LP_Timer1)
}

//export SDMMC2_IRQHandler
func interruptSDMMC2() {
	callHandlers(IRQ_SDMMC2)
}

// Peripherals.
var (
	// Advanced-timers
	TIM1 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Analog-to-digital converter
	ADC2 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012100)))

	// Basic timers
	TIM6 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Common ADC registers
	ADC_Common = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012300)))

	// Controller area network
	CAN1 = (*CAN_Type)(unsafe.Pointer(uintptr(0x40006400)))

	// Cryptographic processor
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Debug support
	DBGMCU = (*DBG_Type)(unsafe.Pointer(uintptr(0xe0042000)))

	// Digital-to-analog converter
	DAC = (*DAC_Type)(unsafe.Pointer(uintptr(0x40007400)))

	// DMA controller
	DMA2 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026400)))

	// External interrupt/event controller
	EXTI = (*EXTI_Type)(unsafe.Pointer(uintptr(0x40013c00)))

	// FLASH
	FLASH = (*FLASH_Type)(unsafe.Pointer(uintptr(0x40023c00)))

	// Flexible memory controller
	FMC = (*FSMC_Type)(unsafe.Pointer(uintptr(0xa0000000)))

	// General purpose timers
	TIM9 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// General purpose timers
	TIM2 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// General purpose timers
	TIM3 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// General purpose timers
	TIM5 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// General-purpose I/Os
	GPIOH = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021c00)))

	// General-purpose I/Os
	GPIOB = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020400)))

	// General-purpose I/Os
	GPIOA = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// General-purpose-timers
	TIM13 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001c00)))

	// Independent watchdog
	IWDG = (*IWDG_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Inter-integrated circuit
	I2C1 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// Low power timer
	LPTIM1 = (*LPTIM_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Power control
	PWR = (*PWR_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// QuadSPI interface
	QUADSPI = (*QUADSPI_Type)(unsafe.Pointer(uintptr(0xa0001000)))

	// Random number generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x50060800)))

	// Real-time clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Reset and clock control
	RCC = (*RCC_Type)(unsafe.Pointer(uintptr(0x40023800)))

	// Secure digital input/output interface
	SDMMC1 = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x40012c00)))

	// Serial audio interface
	SAI1 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015800)))

	// Serial peripheral interface
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// System configuration controller
	SYSCFG = (*SYSCFG_Type)(unsafe.Pointer(uintptr(0x40013800)))

	// Universal synchronous asynchronous receiver transmitter
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// USB on the go full speed
	OTG_FS_GLOBAL = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// USB on the go full speed
	OTG_FS_HOST = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000400)))

	// USB on the go full speed
	OTG_FS_DEVICE = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000800)))

	// USB on the go full speed
	OTG_FS_PWRCLK = (*USB_OTG_FS_Type)(unsafe.Pointer(uintptr(0x50000e00)))

	// USB on the go high speed
	OTG_HS_HOST = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040400)))

	// USB on the go high speed
	OTG_HS_GLOBAL = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// USB on the go high speed
	OTG_HS_PWRCLK = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040e00)))

	// USB on the go high speed
	OTG_HS_DEVICE = (*USB_OTG_HS_Type)(unsafe.Pointer(uintptr(0x40040800)))

	// Window watchdog
	WWDG = (*WWDG_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Nested Vectored Interrupt Controller
	NVIC = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000e100)))

	// Memory protection unit
	MPU = (*MPU_Type)(unsafe.Pointer(uintptr(0xe000ed90)))

	// SysTick timer
	STK = (*STK_Type)(unsafe.Pointer(uintptr(0xe000e010)))

	// Nested vectored interrupt controller
	NVIC_STIR = (*NVIC_Type)(unsafe.Pointer(uintptr(0xe000ef00)))

	// Floating point unit CPACR
	FPU_CPACR = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ed88)))

	// System control block ACTLR
	SCB_ACTRL = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000e008)))

	// Floting point unit
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0xe000ef34)))

	// System control block
	SCB = (*SCB_Type)(unsafe.Pointer(uintptr(0xe000ed00)))

	// Processor features
	PF = (*PF_Type)(unsafe.Pointer(uintptr(0xe000ed78)))

	// Access control
	AC = (*AC_Type)(unsafe.Pointer(uintptr(0xe000ef90)))

	// Advanced encryption standard hardware accelerator 1
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x50060000)))

	// USBPHYC register interface
	USBPHYC = (*USBPHYC_Type)(unsafe.Pointer(uintptr(0x40017c00)))

	// Advanced-timers
	TIM8 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40010400)))

	// Analog-to-digital converter
	ADC1 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012000)))

	// Analog-to-digital converter
	ADC3 = (*ADC_Type)(unsafe.Pointer(uintptr(0x40012200)))

	// Basic timers
	TIM7 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// DMA controller
	DMA1 = (*DMA_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// General purpose timers
	TIM12 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40001800)))

	// General purpose timers
	TIM4 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// General-purpose I/Os
	GPIOF = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021400)))

	// General-purpose I/Os
	GPIOG = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021800)))

	// General-purpose I/Os
	GPIOI = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// General-purpose I/Os
	GPIOE = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// General-purpose I/Os
	GPIOD = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020c00)))

	// General-purpose I/Os
	GPIOC = (*GPIO_Type)(unsafe.Pointer(uintptr(0x40020800)))

	// General-purpose-timers
	TIM14 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// General-purpose-timers
	TIM10 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014400)))

	// General-purpose-timers
	TIM11 = (*TIM_Type)(unsafe.Pointer(uintptr(0x40014800)))

	// Inter-integrated circuit
	I2C2 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005800)))

	// Inter-integrated circuit
	I2C3 = (*I2C_Type)(unsafe.Pointer(uintptr(0x40005c00)))

	// Secure digital input/output interface
	SDMMC2 = (*SDMMC_Type)(unsafe.Pointer(uintptr(0x40011c00)))

	// Serial audio interface
	SAI2 = (*SAI_Type)(unsafe.Pointer(uintptr(0x40015c00)))

	// Serial peripheral interface
	SPI5 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40015000)))

	// Serial peripheral interface
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003800)))

	// Serial peripheral interface
	SPI4 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40013400)))

	// Serial peripheral interface
	SPI3 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003c00)))

	// Universal synchronous asynchronous receiver transmitter
	USART3 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004800)))

	// Universal synchronous asynchronous receiver transmitter
	USART6 = (*USART_Type)(unsafe.Pointer(uintptr(0x40011400)))

	// Universal synchronous asynchronous receiver transmitter
	UART8 = (*USART_Type)(unsafe.Pointer(uintptr(0x40007c00)))

	// Universal synchronous asynchronous receiver transmitter
	USART2 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004400)))

	// Universal synchronous asynchronous receiver transmitter
	UART7 = (*USART_Type)(unsafe.Pointer(uintptr(0x40007800)))

	// Universal synchronous asynchronous receiver transmitter
	UART4 = (*USART_Type)(unsafe.Pointer(uintptr(0x40004c00)))

	// Universal synchronous asynchronous receiver transmitter
	UART5 = (*USART_Type)(unsafe.Pointer(uintptr(0x40005000)))
)

// Advanced-timers
type TIM_Type struct {
	CR1          volatile.Register32 // 0x0
	CR2          volatile.Register32 // 0x4
	SMCR         volatile.Register32 // 0x8
	DIER         volatile.Register32 // 0xC
	SR           volatile.Register32 // 0x10
	EGR          volatile.Register32 // 0x14
	CCMR1_Output volatile.Register32 // 0x18
	CCMR2_Output volatile.Register32 // 0x1C
	CCER         volatile.Register32 // 0x20
	CNT          volatile.Register32 // 0x24
	PSC          volatile.Register32 // 0x28
	ARR          volatile.Register32 // 0x2C
	RCR          volatile.Register32 // 0x30
	CCR1         volatile.Register32 // 0x34
	CCR2         volatile.Register32 // 0x38
	CCR3         volatile.Register32 // 0x3C
	CCR4         volatile.Register32 // 0x40
	BDTR         volatile.Register32 // 0x44
	DCR          volatile.Register32 // 0x48
	DMAR         volatile.Register32 // 0x4C
	_            [4]byte
	CCMR3_Output volatile.Register32 // 0x54
	CCR5         volatile.Register32 // 0x58
	CCR6         volatile.Register32 // 0x5C
}

// TIM.CR1: control register 1
func (o *TIM_Type) SetCR1_CKD(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCR1_CKD() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCR1_ARPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR1_ARPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR1_CMS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x60)|value<<5)
}
func (o *TIM_Type) GetCR1_CMS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x60) >> 5
}
func (o *TIM_Type) SetCR1_DIR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCR1_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCR1_OPM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR1_OPM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR1_URS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR1_URS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR1_UDIS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCR1_UDIS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCR1_CEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR1_CEN() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *TIM_Type) SetCR1_UIFREMAP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR1_UIFREMAP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}

// TIM.CR2: control register 2
func (o *TIM_Type) SetCR2_OIS4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetCR2_OIS4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetCR2_OIS3N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCR2_OIS3N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCR2_OIS3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCR2_OIS3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCR2_OIS2N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCR2_OIS2N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCR2_OIS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCR2_OIS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCR2_OIS1N(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCR2_OIS1N() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCR2_OIS1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCR2_OIS1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCR2_TI1S(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCR2_TI1S() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCR2_MMS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCR2_MMS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCR2_CCDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCR2_CCDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCR2_CCUS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCR2_CCUS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCR2_CCPC(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCR2_CCPC() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *TIM_Type) SetCR2_MMS2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00000)|value<<20)
}
func (o *TIM_Type) GetCR2_MMS2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00000) >> 20
}
func (o *TIM_Type) SetCR2_OIS6(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *TIM_Type) GetCR2_OIS6() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *TIM_Type) SetCR2_OIS5(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCR2_OIS5() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}

// TIM.SMCR: slave mode control register
func (o *TIM_Type) SetSMCR_SMS_3(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetSMCR_SMS_3() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetSMCR_ETP(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetSMCR_ETP() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetSMCR_ECE(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetSMCR_ECE() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetSMCR_ETPS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x3000)|value<<12)
}
func (o *TIM_Type) GetSMCR_ETPS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x3000) >> 12
}
func (o *TIM_Type) SetSMCR_ETF(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0xf00)|value<<8)
}
func (o *TIM_Type) GetSMCR_ETF() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0xf00) >> 8
}
func (o *TIM_Type) SetSMCR_MSM(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSMCR_MSM() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSMCR_TS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetSMCR_TS() uint32 {
	return (volatile.LoadUint32(&o.SMCR.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetSMCR_SMS(value uint32) {
	volatile.StoreUint32(&o.SMCR.Reg, volatile.LoadUint32(&o.SMCR.Reg)&^(0x7)|value)
}
func (o *TIM_Type) GetSMCR_SMS() uint32 {
	return volatile.LoadUint32(&o.SMCR.Reg) & 0x7
}

// TIM.DIER: DMA/Interrupt enable register
func (o *TIM_Type) SetDIER_TDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetDIER_TDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetDIER_COMDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetDIER_COMDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetDIER_CC4DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetDIER_CC4DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetDIER_CC3DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetDIER_CC3DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetDIER_CC2DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetDIER_CC2DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetDIER_CC1DE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetDIER_CC1DE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetDIER_UDE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetDIER_UDE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetDIER_TIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetDIER_TIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetDIER_CC4IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetDIER_CC4IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetDIER_CC3IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetDIER_CC3IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetDIER_CC2IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetDIER_CC2IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetDIER_CC1IE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetDIER_CC1IE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetDIER_UIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetDIER_UIE() uint32 {
	return volatile.LoadUint32(&o.DIER.Reg) & 0x1
}
func (o *TIM_Type) SetDIER_BIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetDIER_BIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetDIER_COMIE(value uint32) {
	volatile.StoreUint32(&o.DIER.Reg, volatile.LoadUint32(&o.DIER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetDIER_COMIE() uint32 {
	return (volatile.LoadUint32(&o.DIER.Reg) & 0x20) >> 5
}

// TIM.SR: status register
func (o *TIM_Type) SetSR_CC4OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetSR_CC4OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetSR_CC3OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetSR_CC3OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetSR_CC2OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetSR_CC2OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetSR_CC1OF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetSR_CC1OF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetSR_BIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetSR_BIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetSR_TIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetSR_TIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetSR_COMIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetSR_COMIF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetSR_CC4IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetSR_CC4IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetSR_CC3IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetSR_CC3IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetSR_CC2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetSR_CC2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetSR_CC1IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetSR_CC1IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetSR_UIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetSR_UIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TIM_Type) SetSR_B2IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetSR_B2IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetSR_CC5IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetSR_CC5IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetSR_CC6IF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *TIM_Type) GetSR_CC6IF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// TIM.EGR: event generation register
func (o *TIM_Type) SetEGR_BG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetEGR_BG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetEGR_TG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetEGR_TG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetEGR_COMG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetEGR_COMG() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetEGR_CC4G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetEGR_CC4G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetEGR_CC3G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetEGR_CC3G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetEGR_CC2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetEGR_CC2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetEGR_CC1G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetEGR_CC1G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetEGR_UG(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetEGR_UG() uint32 {
	return volatile.LoadUint32(&o.EGR.Reg) & 0x1
}
func (o *TIM_Type) SetEGR_B2G(value uint32) {
	volatile.StoreUint32(&o.EGR.Reg, volatile.LoadUint32(&o.EGR.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetEGR_B2G() uint32 {
	return (volatile.LoadUint32(&o.EGR.Reg) & 0x100) >> 8
}

// TIM.CCMR1_Output: capture/compare mode register 1 (output mode)
func (o *TIM_Type) SetCCMR1_Output_OC2CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR1_Output_OC2CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR1_Output_OC2M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR1_Output_OC2PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR1_Output_OC2PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR1_Output_OC2FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR1_Output_OC2FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR1_Output_CC2S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR1_Output_CC2S() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR1_Output_OC1CE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR1_Output_OC1CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR1_Output_OC1M(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR1_Output_OC1PE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR1_Output_OC1PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR1_Output_OC1FE(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR1_Output_OC1FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR1_Output_CC1S(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR1_Output_CC1S() uint32 {
	return volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x3
}
func (o *TIM_Type) SetCCMR1_Output_OC2M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR1_Output_OC2M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetCCMR1_Output_OC1M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR1_Output.Reg, volatile.LoadUint32(&o.CCMR1_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR1_Output_OC1M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR1_Output.Reg) & 0x10000) >> 16
}

// TIM.CCMR2_Output: capture/compare mode register 2 (output mode)
func (o *TIM_Type) SetCCMR2_Output_OC4CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR2_Output_OC4CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR2_Output_OC4M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR2_Output_OC4PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR2_Output_OC4PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR2_Output_OC4FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR2_Output_OC4FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR2_Output_CC4S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetCCMR2_Output_CC4S() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetCCMR2_Output_OC3CE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR2_Output_OC3CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR2_Output_OC3M(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR2_Output_OC3PE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR2_Output_OC3PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR2_Output_OC3FE(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR2_Output_OC3FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR2_Output_CC3S(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x3)|value)
}
func (o *TIM_Type) GetCCMR2_Output_CC3S() uint32 {
	return volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x3
}
func (o *TIM_Type) SetCCMR2_Output_OC4M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR2_Output_OC4M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetCCMR2_Output_OC3M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR2_Output.Reg, volatile.LoadUint32(&o.CCMR2_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR2_Output_OC3M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR2_Output.Reg) & 0x10000) >> 16
}

// TIM.CCER: capture/compare enable register
func (o *TIM_Type) SetCCER_CC4P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetCCER_CC4P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetCCER_CC4E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetCCER_CC4E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetCCER_CC3NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCER_CC3NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCER_CC3NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCER_CC3NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCER_CC3P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200)|value<<9)
}
func (o *TIM_Type) GetCCER_CC3P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200) >> 9
}
func (o *TIM_Type) SetCCER_CC3E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100)|value<<8)
}
func (o *TIM_Type) GetCCER_CC3E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100) >> 8
}
func (o *TIM_Type) SetCCER_CC2NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCER_CC2NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCER_CC2NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x40)|value<<6)
}
func (o *TIM_Type) GetCCER_CC2NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x40) >> 6
}
func (o *TIM_Type) SetCCER_CC2P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20)|value<<5)
}
func (o *TIM_Type) GetCCER_CC2P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20) >> 5
}
func (o *TIM_Type) SetCCER_CC2E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10)|value<<4)
}
func (o *TIM_Type) GetCCER_CC2E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10) >> 4
}
func (o *TIM_Type) SetCCER_CC1NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCER_CC1NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCER_CC1NE(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCER_CC1NE() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCER_CC1P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x2)|value<<1)
}
func (o *TIM_Type) GetCCER_CC1P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x2) >> 1
}
func (o *TIM_Type) SetCCER_CC1E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x1)|value)
}
func (o *TIM_Type) GetCCER_CC1E() uint32 {
	return volatile.LoadUint32(&o.CCER.Reg) & 0x1
}
func (o *TIM_Type) SetCCER_CC6P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x200000)|value<<21)
}
func (o *TIM_Type) GetCCER_CC6P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x200000) >> 21
}
func (o *TIM_Type) SetCCER_CC6E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x100000)|value<<20)
}
func (o *TIM_Type) GetCCER_CC6E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x100000) >> 20
}
func (o *TIM_Type) SetCCER_CC5P(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x20000)|value<<17)
}
func (o *TIM_Type) GetCCER_CC5P() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x20000) >> 17
}
func (o *TIM_Type) SetCCER_CC5E(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCER_CC5E() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCER_CC4NP(value uint32) {
	volatile.StoreUint32(&o.CCER.Reg, volatile.LoadUint32(&o.CCER.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCER_CC4NP() uint32 {
	return (volatile.LoadUint32(&o.CCER.Reg) & 0x8000) >> 15
}

// TIM.CNT: counter
func (o *TIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}
func (o *TIM_Type) SetCNT_UIFCPY(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0x80000000)|value<<31)
}
func (o *TIM_Type) GetCNT_UIFCPY() uint32 {
	return (volatile.LoadUint32(&o.CNT.Reg) & 0x80000000) >> 31
}

// TIM.PSC: prescaler
func (o *TIM_Type) SetPSC(value uint32) {
	volatile.StoreUint32(&o.PSC.Reg, volatile.LoadUint32(&o.PSC.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetPSC() uint32 {
	return volatile.LoadUint32(&o.PSC.Reg) & 0xffff
}

// TIM.ARR: auto-reload register
func (o *TIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// TIM.RCR: repetition counter register
func (o *TIM_Type) SetRCR_REP(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetRCR_REP() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xff
}

// TIM.CCR1: capture/compare register
func (o *TIM_Type) SetCCR1_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR1_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0xffff
}

// TIM.CCR2: capture/compare register
func (o *TIM_Type) SetCCR2_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR2_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0xffff
}

// TIM.CCR3: capture/compare register
func (o *TIM_Type) SetCCR3_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR3.Reg, volatile.LoadUint32(&o.CCR3.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR3_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR3.Reg) & 0xffff
}

// TIM.CCR4: capture/compare register
func (o *TIM_Type) SetCCR4_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR4.Reg, volatile.LoadUint32(&o.CCR4.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR4_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR4.Reg) & 0xffff
}

// TIM.BDTR: break and dead-time register
func (o *TIM_Type) SetBDTR_MOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetBDTR_MOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetBDTR_AOE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x4000)|value<<14)
}
func (o *TIM_Type) GetBDTR_AOE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x4000) >> 14
}
func (o *TIM_Type) SetBDTR_BKP(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000)|value<<13)
}
func (o *TIM_Type) GetBDTR_BKP() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000) >> 13
}
func (o *TIM_Type) SetBDTR_BKE(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000)|value<<12)
}
func (o *TIM_Type) GetBDTR_BKE() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000) >> 12
}
func (o *TIM_Type) SetBDTR_OSSR(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetBDTR_OSSR() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetBDTR_OSSI(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetBDTR_OSSI() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetBDTR_LOCK(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x300)|value<<8)
}
func (o *TIM_Type) GetBDTR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x300) >> 8
}
func (o *TIM_Type) SetBDTR_DTG(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xff)|value)
}
func (o *TIM_Type) GetBDTR_DTG() uint32 {
	return volatile.LoadUint32(&o.BDTR.Reg) & 0xff
}
func (o *TIM_Type) SetBDTR_BK2P(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x2000000)|value<<25)
}
func (o *TIM_Type) GetBDTR_BK2P() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x2000000) >> 25
}
func (o *TIM_Type) SetBDTR_BK2E(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetBDTR_BK2E() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0x1000000) >> 24
}
func (o *TIM_Type) SetBDTR_BK2F(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xf00000)|value<<20)
}
func (o *TIM_Type) GetBDTR_BK2F() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0xf00000) >> 20
}
func (o *TIM_Type) SetBDTR_BKF(value uint32) {
	volatile.StoreUint32(&o.BDTR.Reg, volatile.LoadUint32(&o.BDTR.Reg)&^(0xf0000)|value<<16)
}
func (o *TIM_Type) GetBDTR_BKF() uint32 {
	return (volatile.LoadUint32(&o.BDTR.Reg) & 0xf0000) >> 16
}

// TIM.DCR: DMA control register
func (o *TIM_Type) SetDCR_DBL(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f00)|value<<8)
}
func (o *TIM_Type) GetDCR_DBL() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f00) >> 8
}
func (o *TIM_Type) SetDCR_DBA(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f)|value)
}
func (o *TIM_Type) GetDCR_DBA() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1f
}

// TIM.DMAR: DMA address for full transfer
func (o *TIM_Type) SetDMAR(value uint32) {
	volatile.StoreUint32(&o.DMAR.Reg, value)
}
func (o *TIM_Type) GetDMAR() uint32 {
	return volatile.LoadUint32(&o.DMAR.Reg)
}

// TIM.CCMR3_Output: capture/compare mode register 3 (output mode)
func (o *TIM_Type) SetCCMR3_Output_OC5FE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x4)|value<<2)
}
func (o *TIM_Type) GetCCMR3_Output_OC5FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x4) >> 2
}
func (o *TIM_Type) SetCCMR3_Output_OC5PE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x8)|value<<3)
}
func (o *TIM_Type) GetCCMR3_Output_OC5PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x8) >> 3
}
func (o *TIM_Type) SetCCMR3_Output_OC5M(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x70)|value<<4)
}
func (o *TIM_Type) GetCCMR3_Output_OC5M() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x70) >> 4
}
func (o *TIM_Type) SetCCMR3_Output_OC5CE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x80)|value<<7)
}
func (o *TIM_Type) GetCCMR3_Output_OC5CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x80) >> 7
}
func (o *TIM_Type) SetCCMR3_Output_OC6FE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x400)|value<<10)
}
func (o *TIM_Type) GetCCMR3_Output_OC6FE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x400) >> 10
}
func (o *TIM_Type) SetCCMR3_Output_OC6PE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x800)|value<<11)
}
func (o *TIM_Type) GetCCMR3_Output_OC6PE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x800) >> 11
}
func (o *TIM_Type) SetCCMR3_Output_OC6M(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x7000)|value<<12)
}
func (o *TIM_Type) GetCCMR3_Output_OC6M() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x7000) >> 12
}
func (o *TIM_Type) SetCCMR3_Output_OC6CE(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x8000)|value<<15)
}
func (o *TIM_Type) GetCCMR3_Output_OC6CE() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x8000) >> 15
}
func (o *TIM_Type) SetCCMR3_Output_OC5M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x10000)|value<<16)
}
func (o *TIM_Type) GetCCMR3_Output_OC5M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x10000) >> 16
}
func (o *TIM_Type) SetCCMR3_Output_OC6M_3(value uint32) {
	volatile.StoreUint32(&o.CCMR3_Output.Reg, volatile.LoadUint32(&o.CCMR3_Output.Reg)&^(0x1000000)|value<<24)
}
func (o *TIM_Type) GetCCMR3_Output_OC6M_3() uint32 {
	return (volatile.LoadUint32(&o.CCMR3_Output.Reg) & 0x1000000) >> 24
}

// TIM.CCR5: capture/compare register
func (o *TIM_Type) SetCCR5_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR5_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR5.Reg) & 0xffff
}
func (o *TIM_Type) SetCCR5_GC5C1(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x20000000)|value<<29)
}
func (o *TIM_Type) GetCCR5_GC5C1() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x20000000) >> 29
}
func (o *TIM_Type) SetCCR5_GC5C2(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x40000000)|value<<30)
}
func (o *TIM_Type) GetCCR5_GC5C2() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x40000000) >> 30
}
func (o *TIM_Type) SetCCR5_GC5C3(value uint32) {
	volatile.StoreUint32(&o.CCR5.Reg, volatile.LoadUint32(&o.CCR5.Reg)&^(0x80000000)|value<<31)
}
func (o *TIM_Type) GetCCR5_GC5C3() uint32 {
	return (volatile.LoadUint32(&o.CCR5.Reg) & 0x80000000) >> 31
}

// TIM.CCR6: capture/compare register
func (o *TIM_Type) SetCCR6_CCR(value uint32) {
	volatile.StoreUint32(&o.CCR6.Reg, volatile.LoadUint32(&o.CCR6.Reg)&^(0xffff)|value)
}
func (o *TIM_Type) GetCCR6_CCR() uint32 {
	return volatile.LoadUint32(&o.CCR6.Reg) & 0xffff
}

// Analog-to-digital converter
type ADC_Type struct {
	SR    volatile.Register32 // 0x0
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	SMPR1 volatile.Register32 // 0xC
	SMPR2 volatile.Register32 // 0x10
	JOFR1 volatile.Register32 // 0x14
	JOFR2 volatile.Register32 // 0x18
	JOFR3 volatile.Register32 // 0x1C
	JOFR4 volatile.Register32 // 0x20
	HTR   volatile.Register32 // 0x24
	LTR   volatile.Register32 // 0x28
	SQR1  volatile.Register32 // 0x2C
	SQR2  volatile.Register32 // 0x30
	SQR3  volatile.Register32 // 0x34
	JSQR  volatile.Register32 // 0x38
	JDR1  volatile.Register32 // 0x3C
	JDR2  volatile.Register32 // 0x40
	JDR3  volatile.Register32 // 0x44
	JDR4  volatile.Register32 // 0x48
	DR    volatile.Register32 // 0x4C
}

// ADC.SR: status register
func (o *ADC_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSR_STRT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetSR_STRT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetSR_JSTRT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetSR_JSTRT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetSR_JEOC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetSR_JEOC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetSR_EOC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetSR_EOC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetSR_AWD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetSR_AWD() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// ADC.CR1: control register 1
func (o *ADC_Type) SetCR1_OVRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetCR1_OVRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetCR1_RES(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3000000)|value<<24)
}
func (o *ADC_Type) GetCR1_RES() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3000000) >> 24
}
func (o *ADC_Type) SetCR1_AWDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *ADC_Type) GetCR1_AWDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}
func (o *ADC_Type) SetCR1_JAWDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCR1_JAWDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCR1_DISCNUM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe000)|value<<13)
}
func (o *ADC_Type) GetCR1_DISCNUM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe000) >> 13
}
func (o *ADC_Type) SetCR1_JDISCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCR1_JDISCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCR1_DISCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCR1_DISCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCR1_JAUTO(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCR1_JAUTO() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCR1_AWDSGL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCR1_AWDSGL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCR1_SCAN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCR1_SCAN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCR1_JEOCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCR1_JEOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCR1_AWDIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCR1_AWDIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCR1_EOCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCR1_EOCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCR1_AWDCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetCR1_AWDCH() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1f
}

// ADC.CR2: control register 2
func (o *ADC_Type) SetCR2_SWSTART(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000000)|value<<30)
}
func (o *ADC_Type) GetCR2_SWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000000) >> 30
}
func (o *ADC_Type) SetCR2_EXTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x30000000)|value<<28)
}
func (o *ADC_Type) GetCR2_EXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x30000000) >> 28
}
func (o *ADC_Type) SetCR2_EXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetCR2_EXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetCR2_JSWSTART(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400000)|value<<22)
}
func (o *ADC_Type) GetCR2_JSWSTART() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400000) >> 22
}
func (o *ADC_Type) SetCR2_JEXTEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetCR2_JEXTEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetCR2_JEXTSEL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetCR2_JEXTSEL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetCR2_ALIGN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCR2_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCR2_EOCS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCR2_EOCS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCR2_DDS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCR2_DDS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCR2_DMA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCR2_DMA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCR2_CONT(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR2_CONT() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCR2_ADON(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR2_ADON() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}

// ADC.SMPR1: sample time register 1
func (o *ADC_Type) SetSMPR1_SMP18(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR1_SMP18() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR1_SMP17(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR1_SMP17() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR1_SMP16(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR1_SMP16() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR1_SMP15(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR1_SMP15() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR1_SMP14(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR1_SMP14() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR1_SMP13(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR1_SMP13() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR1_SMP12(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR1_SMP12() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR1_SMP11(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR1_SMP11() uint32 {
	return (volatile.LoadUint32(&o.SMPR1.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR1_SMP10(value uint32) {
	volatile.StoreUint32(&o.SMPR1.Reg, volatile.LoadUint32(&o.SMPR1.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR1_SMP10() uint32 {
	return volatile.LoadUint32(&o.SMPR1.Reg) & 0x7
}

// ADC.SMPR2: sample time register 2
func (o *ADC_Type) SetSMPR2_SMP9(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000000)|value<<27)
}
func (o *ADC_Type) GetSMPR2_SMP9() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000000) >> 27
}
func (o *ADC_Type) SetSMPR2_SMP8(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000000)|value<<24)
}
func (o *ADC_Type) GetSMPR2_SMP8() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000000) >> 24
}
func (o *ADC_Type) SetSMPR2_SMP7(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00000)|value<<21)
}
func (o *ADC_Type) GetSMPR2_SMP7() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00000) >> 21
}
func (o *ADC_Type) SetSMPR2_SMP6(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0000)|value<<18)
}
func (o *ADC_Type) GetSMPR2_SMP6() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0000) >> 18
}
func (o *ADC_Type) SetSMPR2_SMP5(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38000)|value<<15)
}
func (o *ADC_Type) GetSMPR2_SMP5() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38000) >> 15
}
func (o *ADC_Type) SetSMPR2_SMP4(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7000)|value<<12)
}
func (o *ADC_Type) GetSMPR2_SMP4() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x7000) >> 12
}
func (o *ADC_Type) SetSMPR2_SMP3(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0xe00)|value<<9)
}
func (o *ADC_Type) GetSMPR2_SMP3() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0xe00) >> 9
}
func (o *ADC_Type) SetSMPR2_SMP2(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x1c0)|value<<6)
}
func (o *ADC_Type) GetSMPR2_SMP2() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x1c0) >> 6
}
func (o *ADC_Type) SetSMPR2_SMP1(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x38)|value<<3)
}
func (o *ADC_Type) GetSMPR2_SMP1() uint32 {
	return (volatile.LoadUint32(&o.SMPR2.Reg) & 0x38) >> 3
}
func (o *ADC_Type) SetSMPR2_SMP0(value uint32) {
	volatile.StoreUint32(&o.SMPR2.Reg, volatile.LoadUint32(&o.SMPR2.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetSMPR2_SMP0() uint32 {
	return volatile.LoadUint32(&o.SMPR2.Reg) & 0x7
}

// ADC.JOFR1: injected channel data offset register x
func (o *ADC_Type) SetJOFR1_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR1.Reg, volatile.LoadUint32(&o.JOFR1.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR1_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR1.Reg) & 0xfff
}

// ADC.JOFR2: injected channel data offset register x
func (o *ADC_Type) SetJOFR2_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR2.Reg, volatile.LoadUint32(&o.JOFR2.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR2_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR2.Reg) & 0xfff
}

// ADC.JOFR3: injected channel data offset register x
func (o *ADC_Type) SetJOFR3_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR3.Reg, volatile.LoadUint32(&o.JOFR3.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR3_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR3.Reg) & 0xfff
}

// ADC.JOFR4: injected channel data offset register x
func (o *ADC_Type) SetJOFR4_JOFFSET(value uint32) {
	volatile.StoreUint32(&o.JOFR4.Reg, volatile.LoadUint32(&o.JOFR4.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetJOFR4_JOFFSET() uint32 {
	return volatile.LoadUint32(&o.JOFR4.Reg) & 0xfff
}

// ADC.HTR: watchdog higher threshold register
func (o *ADC_Type) SetHTR_HT(value uint32) {
	volatile.StoreUint32(&o.HTR.Reg, volatile.LoadUint32(&o.HTR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetHTR_HT() uint32 {
	return volatile.LoadUint32(&o.HTR.Reg) & 0xfff
}

// ADC.LTR: watchdog lower threshold register
func (o *ADC_Type) SetLTR_LT(value uint32) {
	volatile.StoreUint32(&o.LTR.Reg, volatile.LoadUint32(&o.LTR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetLTR_LT() uint32 {
	return volatile.LoadUint32(&o.LTR.Reg) & 0xfff
}

// ADC.SQR1: regular sequence register 1
func (o *ADC_Type) SetSQR1_L(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSQR1_L() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSQR1_SQ16(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR1_SQ16() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR1_SQ15(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR1_SQ15() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR1_SQ14(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR1_SQ14() uint32 {
	return (volatile.LoadUint32(&o.SQR1.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR1_SQ13(value uint32) {
	volatile.StoreUint32(&o.SQR1.Reg, volatile.LoadUint32(&o.SQR1.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR1_SQ13() uint32 {
	return volatile.LoadUint32(&o.SQR1.Reg) & 0x1f
}

// ADC.SQR2: regular sequence register 2
func (o *ADC_Type) SetSQR2_SQ12(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x3e000000)|value<<25)
}
func (o *ADC_Type) GetSQR2_SQ12() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x3e000000) >> 25
}
func (o *ADC_Type) SetSQR2_SQ11(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetSQR2_SQ11() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetSQR2_SQ10(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR2_SQ10() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR2_SQ9(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR2_SQ9() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR2_SQ8(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR2_SQ8() uint32 {
	return (volatile.LoadUint32(&o.SQR2.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR2_SQ7(value uint32) {
	volatile.StoreUint32(&o.SQR2.Reg, volatile.LoadUint32(&o.SQR2.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR2_SQ7() uint32 {
	return volatile.LoadUint32(&o.SQR2.Reg) & 0x1f
}

// ADC.SQR3: regular sequence register 3
func (o *ADC_Type) SetSQR3_SQ6(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x3e000000)|value<<25)
}
func (o *ADC_Type) GetSQR3_SQ6() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x3e000000) >> 25
}
func (o *ADC_Type) SetSQR3_SQ5(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f00000)|value<<20)
}
func (o *ADC_Type) GetSQR3_SQ5() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x1f00000) >> 20
}
func (o *ADC_Type) SetSQR3_SQ4(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetSQR3_SQ4() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetSQR3_SQ3(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetSQR3_SQ3() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetSQR3_SQ2(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetSQR3_SQ2() uint32 {
	return (volatile.LoadUint32(&o.SQR3.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetSQR3_SQ1(value uint32) {
	volatile.StoreUint32(&o.SQR3.Reg, volatile.LoadUint32(&o.SQR3.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSQR3_SQ1() uint32 {
	return volatile.LoadUint32(&o.SQR3.Reg) & 0x1f
}

// ADC.JSQR: injected sequence register
func (o *ADC_Type) SetJSQR_JL(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x300000)|value<<20)
}
func (o *ADC_Type) GetJSQR_JL() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x300000) >> 20
}
func (o *ADC_Type) SetJSQR_JSQ4(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0xf8000)|value<<15)
}
func (o *ADC_Type) GetJSQR_JSQ4() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0xf8000) >> 15
}
func (o *ADC_Type) SetJSQR_JSQ3(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x7c00)|value<<10)
}
func (o *ADC_Type) GetJSQR_JSQ3() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x7c00) >> 10
}
func (o *ADC_Type) SetJSQR_JSQ2(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x3e0)|value<<5)
}
func (o *ADC_Type) GetJSQR_JSQ2() uint32 {
	return (volatile.LoadUint32(&o.JSQR.Reg) & 0x3e0) >> 5
}
func (o *ADC_Type) SetJSQR_JSQ1(value uint32) {
	volatile.StoreUint32(&o.JSQR.Reg, volatile.LoadUint32(&o.JSQR.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetJSQR_JSQ1() uint32 {
	return volatile.LoadUint32(&o.JSQR.Reg) & 0x1f
}

// ADC.JDR1: injected data register x
func (o *ADC_Type) SetJDR1_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR1.Reg, volatile.LoadUint32(&o.JDR1.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR1_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR1.Reg) & 0xffff
}

// ADC.JDR2: injected data register x
func (o *ADC_Type) SetJDR2_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR2.Reg, volatile.LoadUint32(&o.JDR2.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR2_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR2.Reg) & 0xffff
}

// ADC.JDR3: injected data register x
func (o *ADC_Type) SetJDR3_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR3.Reg, volatile.LoadUint32(&o.JDR3.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR3_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR3.Reg) & 0xffff
}

// ADC.JDR4: injected data register x
func (o *ADC_Type) SetJDR4_JDATA(value uint32) {
	volatile.StoreUint32(&o.JDR4.Reg, volatile.LoadUint32(&o.JDR4.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetJDR4_JDATA() uint32 {
	return volatile.LoadUint32(&o.JDR4.Reg) & 0xffff
}

// ADC.DR: regular data register
func (o *ADC_Type) SetDR_DATA(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetDR_DATA() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// Controller area network
type CAN_Type struct {
	MCR   volatile.Register32 // 0x0
	MSR   volatile.Register32 // 0x4
	TSR   volatile.Register32 // 0x8
	RF0R  volatile.Register32 // 0xC
	RF1R  volatile.Register32 // 0x10
	IER   volatile.Register32 // 0x14
	ESR   volatile.Register32 // 0x18
	BTR   volatile.Register32 // 0x1C
	_     [352]byte
	TX    [3]CAN_TX_Type // 0x180
	RX    [2]CAN_RX_Type // 0x1B0
	_     [48]byte
	FMR   volatile.Register32 // 0x200
	FM1R  volatile.Register32 // 0x204
	_     [4]byte
	FS1R  volatile.Register32 // 0x20C
	_     [4]byte
	FFA1R volatile.Register32 // 0x214
	_     [4]byte
	FA1R  volatile.Register32 // 0x21C
	_     [32]byte
	FB    [28]CAN_FB_Type // 0x240
}

// CAN.MCR: master control register
func (o *CAN_Type) SetMCR_DBF(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetMCR_DBF() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetMCR_RESET(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetMCR_RESET() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetMCR_TTCM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetMCR_TTCM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetMCR_ABOM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetMCR_ABOM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetMCR_AWUM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetMCR_AWUM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetMCR_NART(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMCR_NART() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMCR_RFLM(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMCR_RFLM() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMCR_TXFP(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMCR_TXFP() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMCR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMCR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MCR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMCR_INRQ(value uint32) {
	volatile.StoreUint32(&o.MCR.Reg, volatile.LoadUint32(&o.MCR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMCR_INRQ() uint32 {
	return volatile.LoadUint32(&o.MCR.Reg) & 0x1
}

// CAN.MSR: master status register
func (o *CAN_Type) SetMSR_RX(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetMSR_RX() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetMSR_SAMP(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetMSR_SAMP() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetMSR_RXM(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetMSR_RXM() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetMSR_TXM(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetMSR_TXM() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetMSR_SLAKI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetMSR_SLAKI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetMSR_WKUI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetMSR_WKUI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetMSR_ERRI(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetMSR_ERRI() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetMSR_SLAK(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetMSR_SLAK() uint32 {
	return (volatile.LoadUint32(&o.MSR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetMSR_INAK(value uint32) {
	volatile.StoreUint32(&o.MSR.Reg, volatile.LoadUint32(&o.MSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetMSR_INAK() uint32 {
	return volatile.LoadUint32(&o.MSR.Reg) & 0x1
}

// CAN.TSR: transmit status register
func (o *CAN_Type) SetTSR_LOW2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetTSR_LOW2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80000000) >> 31
}
func (o *CAN_Type) SetTSR_LOW1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetTSR_LOW1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetTSR_LOW0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_Type) GetTSR_LOW0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20000000) >> 29
}
func (o *CAN_Type) SetTSR_TME2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_Type) GetTSR_TME2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10000000) >> 28
}
func (o *CAN_Type) SetTSR_TME1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_Type) GetTSR_TME1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8000000) >> 27
}
func (o *CAN_Type) SetTSR_TME0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_Type) GetTSR_TME0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4000000) >> 26
}
func (o *CAN_Type) SetTSR_CODE(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x3000000)|value<<24)
}
func (o *CAN_Type) GetTSR_CODE() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x3000000) >> 24
}
func (o *CAN_Type) SetTSR_ABRQ2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_Type) GetTSR_ABRQ2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x800000) >> 23
}
func (o *CAN_Type) SetTSR_TERR2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_Type) GetTSR_TERR2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80000) >> 19
}
func (o *CAN_Type) SetTSR_ALST2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_Type) GetTSR_ALST2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x40000) >> 18
}
func (o *CAN_Type) SetTSR_TXOK2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetTSR_TXOK2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetTSR_RQCP2(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetTSR_RQCP2() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetTSR_ABRQ1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetTSR_ABRQ1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetTSR_TERR1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetTSR_TERR1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetTSR_ALST1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetTSR_ALST1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetTSR_TXOK1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetTSR_TXOK1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetTSR_RQCP1(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetTSR_RQCP1() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetTSR_ABRQ0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetTSR_ABRQ0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetTSR_TERR0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetTSR_TERR0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetTSR_ALST0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetTSR_ALST0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetTSR_TXOK0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetTSR_TXOK0() uint32 {
	return (volatile.LoadUint32(&o.TSR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetTSR_RQCP0(value uint32) {
	volatile.StoreUint32(&o.TSR.Reg, volatile.LoadUint32(&o.TSR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetTSR_RQCP0() uint32 {
	return volatile.LoadUint32(&o.TSR.Reg) & 0x1
}

// CAN.RF0R: receive FIFO %s register
func (o *CAN_Type) SetRF0R_RFOM(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetRF0R_RFOM() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetRF0R_FOVR(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetRF0R_FOVR() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetRF0R_FULL(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetRF0R_FULL() uint32 {
	return (volatile.LoadUint32(&o.RF0R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetRF0R_FMP(value uint32) {
	volatile.StoreUint32(&o.RF0R.Reg, volatile.LoadUint32(&o.RF0R.Reg)&^(0x3)|value)
}
func (o *CAN_Type) GetRF0R_FMP() uint32 {
	return volatile.LoadUint32(&o.RF0R.Reg) & 0x3
}

// CAN.RF1R: receive FIFO %s register
func (o *CAN_Type) SetRF1R_RFOM(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetRF1R_RFOM() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetRF1R_FOVR(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetRF1R_FOVR() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetRF1R_FULL(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetRF1R_FULL() uint32 {
	return (volatile.LoadUint32(&o.RF1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetRF1R_FMP(value uint32) {
	volatile.StoreUint32(&o.RF1R.Reg, volatile.LoadUint32(&o.RF1R.Reg)&^(0x3)|value)
}
func (o *CAN_Type) GetRF1R_FMP() uint32 {
	return volatile.LoadUint32(&o.RF1R.Reg) & 0x3
}

// CAN.IER: interrupt enable register
func (o *CAN_Type) SetIER_SLKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_Type) GetIER_SLKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *CAN_Type) SetIER_WKUIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_Type) GetIER_WKUIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *CAN_Type) SetIER_ERRIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_Type) GetIER_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *CAN_Type) SetIER_LECIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetIER_LECIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetIER_BOFIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetIER_BOFIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetIER_EPVIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetIER_EPVIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetIER_EWGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetIER_EWGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetIER_FOVIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetIER_FOVIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetIER_FFIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetIER_FFIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetIER_FMPIE1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetIER_FMPIE1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetIER_FOVIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetIER_FOVIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetIER_FFIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetIER_FFIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetIER_FMPIE0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetIER_FMPIE0() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetIER_TMEIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetIER_TMEIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// CAN.ESR: interrupt enable register
func (o *CAN_Type) SetESR_REC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_Type) GetESR_REC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0xff000000) >> 24
}
func (o *CAN_Type) SetESR_TEC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_Type) GetESR_TEC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0xff0000) >> 16
}
func (o *CAN_Type) SetESR_LEC(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x70)|value<<4)
}
func (o *CAN_Type) GetESR_LEC() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x70) >> 4
}
func (o *CAN_Type) SetESR_BOFF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetESR_BOFF() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetESR_EPVF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetESR_EPVF() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetESR_EWGF(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetESR_EWGF() uint32 {
	return volatile.LoadUint32(&o.ESR.Reg) & 0x1
}

// CAN.BTR: bit timing register
func (o *CAN_Type) SetBTR_SILM(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_Type) GetBTR_SILM() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x80000000) >> 31
}
func (o *CAN_Type) SetBTR_LBKM(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_Type) GetBTR_LBKM() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x40000000) >> 30
}
func (o *CAN_Type) SetBTR_SJW(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3000000)|value<<24)
}
func (o *CAN_Type) GetBTR_SJW() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x3000000) >> 24
}
func (o *CAN_Type) SetBTR_TS2(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x700000)|value<<20)
}
func (o *CAN_Type) GetBTR_TS2() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0x700000) >> 20
}
func (o *CAN_Type) SetBTR_TS1(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0xf0000)|value<<16)
}
func (o *CAN_Type) GetBTR_TS1() uint32 {
	return (volatile.LoadUint32(&o.BTR.Reg) & 0xf0000) >> 16
}
func (o *CAN_Type) SetBTR_BRP(value uint32) {
	volatile.StoreUint32(&o.BTR.Reg, volatile.LoadUint32(&o.BTR.Reg)&^(0x3ff)|value)
}
func (o *CAN_Type) GetBTR_BRP() uint32 {
	return volatile.LoadUint32(&o.BTR.Reg) & 0x3ff
}

// CAN.FMR: filter master register
func (o *CAN_Type) SetFMR_FINIT(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFMR_FINIT() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0x1
}

// CAN.FM1R: filter mode register
func (o *CAN_Type) SetFM1R_FBM0(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFM1R_FBM0() uint32 {
	return volatile.LoadUint32(&o.FM1R.Reg) & 0x1
}
func (o *CAN_Type) SetFM1R_FBM1(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFM1R_FBM1() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFM1R_FBM2(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFM1R_FBM2() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFM1R_FBM3(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFM1R_FBM3() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFM1R_FBM4(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFM1R_FBM4() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFM1R_FBM5(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFM1R_FBM5() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFM1R_FBM6(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFM1R_FBM6() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFM1R_FBM7(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFM1R_FBM7() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFM1R_FBM8(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFM1R_FBM8() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFM1R_FBM9(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFM1R_FBM9() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFM1R_FBM10(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFM1R_FBM10() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFM1R_FBM11(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFM1R_FBM11() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFM1R_FBM12(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFM1R_FBM12() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFM1R_FBM13(value uint32) {
	volatile.StoreUint32(&o.FM1R.Reg, volatile.LoadUint32(&o.FM1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFM1R_FBM13() uint32 {
	return (volatile.LoadUint32(&o.FM1R.Reg) & 0x2000) >> 13
}

// CAN.FS1R: filter scale register
func (o *CAN_Type) SetFS1R_FSC0(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFS1R_FSC0() uint32 {
	return volatile.LoadUint32(&o.FS1R.Reg) & 0x1
}
func (o *CAN_Type) SetFS1R_FSC1(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFS1R_FSC1() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFS1R_FSC2(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFS1R_FSC2() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFS1R_FSC3(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFS1R_FSC3() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFS1R_FSC4(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFS1R_FSC4() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFS1R_FSC5(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFS1R_FSC5() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFS1R_FSC6(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFS1R_FSC6() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFS1R_FSC7(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFS1R_FSC7() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFS1R_FSC8(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFS1R_FSC8() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFS1R_FSC9(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFS1R_FSC9() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFS1R_FSC10(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFS1R_FSC10() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFS1R_FSC11(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFS1R_FSC11() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFS1R_FSC12(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFS1R_FSC12() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFS1R_FSC13(value uint32) {
	volatile.StoreUint32(&o.FS1R.Reg, volatile.LoadUint32(&o.FS1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFS1R_FSC13() uint32 {
	return (volatile.LoadUint32(&o.FS1R.Reg) & 0x2000) >> 13
}

// CAN.FFA1R: filter FIFO assignment register
func (o *CAN_Type) SetFFA1R_FFA0(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFFA1R_FFA0() uint32 {
	return volatile.LoadUint32(&o.FFA1R.Reg) & 0x1
}
func (o *CAN_Type) SetFFA1R_FFA1(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFFA1R_FFA1() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFFA1R_FFA2(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFFA1R_FFA2() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFFA1R_FFA3(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFFA1R_FFA3() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFFA1R_FFA4(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFFA1R_FFA4() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFFA1R_FFA5(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFFA1R_FFA5() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFFA1R_FFA6(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFFA1R_FFA6() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFFA1R_FFA7(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFFA1R_FFA7() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFFA1R_FFA8(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFFA1R_FFA8() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFFA1R_FFA9(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFFA1R_FFA9() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFFA1R_FFA10(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFFA1R_FFA10() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFFA1R_FFA11(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFFA1R_FFA11() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFFA1R_FFA12(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFFA1R_FFA12() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFFA1R_FFA13(value uint32) {
	volatile.StoreUint32(&o.FFA1R.Reg, volatile.LoadUint32(&o.FFA1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFFA1R_FFA13() uint32 {
	return (volatile.LoadUint32(&o.FFA1R.Reg) & 0x2000) >> 13
}

// CAN.FA1R: filter activation register
func (o *CAN_Type) SetFA1R_FACT0(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1)|value)
}
func (o *CAN_Type) GetFA1R_FACT0() uint32 {
	return volatile.LoadUint32(&o.FA1R.Reg) & 0x1
}
func (o *CAN_Type) SetFA1R_FACT1(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2)|value<<1)
}
func (o *CAN_Type) GetFA1R_FACT1() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2) >> 1
}
func (o *CAN_Type) SetFA1R_FACT2(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x4)|value<<2)
}
func (o *CAN_Type) GetFA1R_FACT2() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x4) >> 2
}
func (o *CAN_Type) SetFA1R_FACT3(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x8)|value<<3)
}
func (o *CAN_Type) GetFA1R_FACT3() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x8) >> 3
}
func (o *CAN_Type) SetFA1R_FACT4(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x10)|value<<4)
}
func (o *CAN_Type) GetFA1R_FACT4() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x10) >> 4
}
func (o *CAN_Type) SetFA1R_FACT5(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x20)|value<<5)
}
func (o *CAN_Type) GetFA1R_FACT5() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x20) >> 5
}
func (o *CAN_Type) SetFA1R_FACT6(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x40)|value<<6)
}
func (o *CAN_Type) GetFA1R_FACT6() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x40) >> 6
}
func (o *CAN_Type) SetFA1R_FACT7(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x80)|value<<7)
}
func (o *CAN_Type) GetFA1R_FACT7() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x80) >> 7
}
func (o *CAN_Type) SetFA1R_FACT8(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x100)|value<<8)
}
func (o *CAN_Type) GetFA1R_FACT8() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x100) >> 8
}
func (o *CAN_Type) SetFA1R_FACT9(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x200)|value<<9)
}
func (o *CAN_Type) GetFA1R_FACT9() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x200) >> 9
}
func (o *CAN_Type) SetFA1R_FACT10(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x400)|value<<10)
}
func (o *CAN_Type) GetFA1R_FACT10() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x400) >> 10
}
func (o *CAN_Type) SetFA1R_FACT11(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x800)|value<<11)
}
func (o *CAN_Type) GetFA1R_FACT11() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x800) >> 11
}
func (o *CAN_Type) SetFA1R_FACT12(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_Type) GetFA1R_FACT12() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x1000) >> 12
}
func (o *CAN_Type) SetFA1R_FACT13(value uint32) {
	volatile.StoreUint32(&o.FA1R.Reg, volatile.LoadUint32(&o.FA1R.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_Type) GetFA1R_FACT13() uint32 {
	return (volatile.LoadUint32(&o.FA1R.Reg) & 0x2000) >> 13
}

type CAN_TX_Type struct {
	TIR  volatile.Register32 // 0x180
	TDTR volatile.Register32 // 0x184
	TDLR volatile.Register32 // 0x188
	TDHR volatile.Register32 // 0x18C
}

// CAN_TX.TIR: TX mailbox identifier register
func (o *CAN_TX_Type) SetTIR_STID(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0xffe00000)|value<<21)
}
func (o *CAN_TX_Type) GetTIR_STID() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0xffe00000) >> 21
}
func (o *CAN_TX_Type) SetTIR_EXID(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x1ffff8)|value<<3)
}
func (o *CAN_TX_Type) GetTIR_EXID() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x1ffff8) >> 3
}
func (o *CAN_TX_Type) SetTIR_IDE(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_TX_Type) GetTIR_IDE() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x4) >> 2
}
func (o *CAN_TX_Type) SetTIR_RTR(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_TX_Type) GetTIR_RTR() uint32 {
	return (volatile.LoadUint32(&o.TIR.Reg) & 0x2) >> 1
}
func (o *CAN_TX_Type) SetTIR_TXRQ(value uint32) {
	volatile.StoreUint32(&o.TIR.Reg, volatile.LoadUint32(&o.TIR.Reg)&^(0x1)|value)
}
func (o *CAN_TX_Type) GetTIR_TXRQ() uint32 {
	return volatile.LoadUint32(&o.TIR.Reg) & 0x1
}

// CAN_TX.TDTR: mailbox data length control and time stamp register
func (o *CAN_TX_Type) SetTDTR_TIME(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDTR_TIME() uint32 {
	return (volatile.LoadUint32(&o.TDTR.Reg) & 0xffff0000) >> 16
}
func (o *CAN_TX_Type) SetTDTR_TGT(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0x100)|value<<8)
}
func (o *CAN_TX_Type) GetTDTR_TGT() uint32 {
	return (volatile.LoadUint32(&o.TDTR.Reg) & 0x100) >> 8
}
func (o *CAN_TX_Type) SetTDTR_DLC(value uint32) {
	volatile.StoreUint32(&o.TDTR.Reg, volatile.LoadUint32(&o.TDTR.Reg)&^(0xf)|value)
}
func (o *CAN_TX_Type) GetTDTR_DLC() uint32 {
	return volatile.LoadUint32(&o.TDTR.Reg) & 0xf
}

// CAN_TX.TDLR: mailbox data low register
func (o *CAN_TX_Type) SetTDLR_DATA3(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_TX_Type) GetTDLR_DATA3() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff000000) >> 24
}
func (o *CAN_TX_Type) SetTDLR_DATA2(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDLR_DATA2() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff0000) >> 16
}
func (o *CAN_TX_Type) SetTDLR_DATA1(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_TX_Type) GetTDLR_DATA1() uint32 {
	return (volatile.LoadUint32(&o.TDLR.Reg) & 0xff00) >> 8
}
func (o *CAN_TX_Type) SetTDLR_DATA0(value uint32) {
	volatile.StoreUint32(&o.TDLR.Reg, volatile.LoadUint32(&o.TDLR.Reg)&^(0xff)|value)
}
func (o *CAN_TX_Type) GetTDLR_DATA0() uint32 {
	return volatile.LoadUint32(&o.TDLR.Reg) & 0xff
}

// CAN_TX.TDHR: mailbox data high register
func (o *CAN_TX_Type) SetTDHR_DATA7(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_TX_Type) GetTDHR_DATA7() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff000000) >> 24
}
func (o *CAN_TX_Type) SetTDHR_DATA6(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_TX_Type) GetTDHR_DATA6() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff0000) >> 16
}
func (o *CAN_TX_Type) SetTDHR_DATA5(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_TX_Type) GetTDHR_DATA5() uint32 {
	return (volatile.LoadUint32(&o.TDHR.Reg) & 0xff00) >> 8
}
func (o *CAN_TX_Type) SetTDHR_DATA4(value uint32) {
	volatile.StoreUint32(&o.TDHR.Reg, volatile.LoadUint32(&o.TDHR.Reg)&^(0xff)|value)
}
func (o *CAN_TX_Type) GetTDHR_DATA4() uint32 {
	return volatile.LoadUint32(&o.TDHR.Reg) & 0xff
}

type CAN_RX_Type struct {
	RIR  volatile.Register32 // 0x1B0
	RDTR volatile.Register32 // 0x1B4
	RDLR volatile.Register32 // 0x1B8
	RDHR volatile.Register32 // 0x1BC
}

// CAN_RX.RIR: receive FIFO mailbox identifier register
func (o *CAN_RX_Type) SetRIR_STID(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0xffe00000)|value<<21)
}
func (o *CAN_RX_Type) GetRIR_STID() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0xffe00000) >> 21
}
func (o *CAN_RX_Type) SetRIR_EXID(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x1ffff8)|value<<3)
}
func (o *CAN_RX_Type) GetRIR_EXID() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x1ffff8) >> 3
}
func (o *CAN_RX_Type) SetRIR_IDE(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x4)|value<<2)
}
func (o *CAN_RX_Type) GetRIR_IDE() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x4) >> 2
}
func (o *CAN_RX_Type) SetRIR_RTR(value uint32) {
	volatile.StoreUint32(&o.RIR.Reg, volatile.LoadUint32(&o.RIR.Reg)&^(0x2)|value<<1)
}
func (o *CAN_RX_Type) GetRIR_RTR() uint32 {
	return (volatile.LoadUint32(&o.RIR.Reg) & 0x2) >> 1
}

// CAN_RX.RDTR: mailbox data high register
func (o *CAN_RX_Type) SetRDTR_TIME(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDTR_TIME() uint32 {
	return (volatile.LoadUint32(&o.RDTR.Reg) & 0xffff0000) >> 16
}
func (o *CAN_RX_Type) SetRDTR_FMI(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDTR_FMI() uint32 {
	return (volatile.LoadUint32(&o.RDTR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDTR_DLC(value uint32) {
	volatile.StoreUint32(&o.RDTR.Reg, volatile.LoadUint32(&o.RDTR.Reg)&^(0xf)|value)
}
func (o *CAN_RX_Type) GetRDTR_DLC() uint32 {
	return volatile.LoadUint32(&o.RDTR.Reg) & 0xf
}

// CAN_RX.RDLR: mailbox data high register
func (o *CAN_RX_Type) SetRDLR_DATA3(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_RX_Type) GetRDLR_DATA3() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff000000) >> 24
}
func (o *CAN_RX_Type) SetRDLR_DATA2(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDLR_DATA2() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff0000) >> 16
}
func (o *CAN_RX_Type) SetRDLR_DATA1(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDLR_DATA1() uint32 {
	return (volatile.LoadUint32(&o.RDLR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDLR_DATA0(value uint32) {
	volatile.StoreUint32(&o.RDLR.Reg, volatile.LoadUint32(&o.RDLR.Reg)&^(0xff)|value)
}
func (o *CAN_RX_Type) GetRDLR_DATA0() uint32 {
	return volatile.LoadUint32(&o.RDLR.Reg) & 0xff
}

// CAN_RX.RDHR: receive FIFO mailbox data high register
func (o *CAN_RX_Type) SetRDHR_DATA7(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff000000)|value<<24)
}
func (o *CAN_RX_Type) GetRDHR_DATA7() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff000000) >> 24
}
func (o *CAN_RX_Type) SetRDHR_DATA6(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff0000)|value<<16)
}
func (o *CAN_RX_Type) GetRDHR_DATA6() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff0000) >> 16
}
func (o *CAN_RX_Type) SetRDHR_DATA5(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff00)|value<<8)
}
func (o *CAN_RX_Type) GetRDHR_DATA5() uint32 {
	return (volatile.LoadUint32(&o.RDHR.Reg) & 0xff00) >> 8
}
func (o *CAN_RX_Type) SetRDHR_DATA4(value uint32) {
	volatile.StoreUint32(&o.RDHR.Reg, volatile.LoadUint32(&o.RDHR.Reg)&^(0xff)|value)
}
func (o *CAN_RX_Type) GetRDHR_DATA4() uint32 {
	return volatile.LoadUint32(&o.RDHR.Reg) & 0xff
}

type CAN_FB_Type struct {
	FR1 volatile.Register32 // 0x240
	FR2 volatile.Register32 // 0x244
}

// CAN_FB.FR1: Filter bank 0 register 1
func (o *CAN_FB_Type) SetFR1_FB0(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x1)|value)
}
func (o *CAN_FB_Type) GetFR1_FB0() uint32 {
	return volatile.LoadUint32(&o.FR1.Reg) & 0x1
}
func (o *CAN_FB_Type) SetFR1_FB1(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x2)|value<<1)
}
func (o *CAN_FB_Type) GetFR1_FB1() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x2) >> 1
}
func (o *CAN_FB_Type) SetFR1_FB2(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x4)|value<<2)
}
func (o *CAN_FB_Type) GetFR1_FB2() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x4) >> 2
}
func (o *CAN_FB_Type) SetFR1_FB3(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x8)|value<<3)
}
func (o *CAN_FB_Type) GetFR1_FB3() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x8) >> 3
}
func (o *CAN_FB_Type) SetFR1_FB4(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x10)|value<<4)
}
func (o *CAN_FB_Type) GetFR1_FB4() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x10) >> 4
}
func (o *CAN_FB_Type) SetFR1_FB5(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x20)|value<<5)
}
func (o *CAN_FB_Type) GetFR1_FB5() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x20) >> 5
}
func (o *CAN_FB_Type) SetFR1_FB6(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x40)|value<<6)
}
func (o *CAN_FB_Type) GetFR1_FB6() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x40) >> 6
}
func (o *CAN_FB_Type) SetFR1_FB7(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x80)|value<<7)
}
func (o *CAN_FB_Type) GetFR1_FB7() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x80) >> 7
}
func (o *CAN_FB_Type) SetFR1_FB8(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x100)|value<<8)
}
func (o *CAN_FB_Type) GetFR1_FB8() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x100) >> 8
}
func (o *CAN_FB_Type) SetFR1_FB9(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x200)|value<<9)
}
func (o *CAN_FB_Type) GetFR1_FB9() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x200) >> 9
}
func (o *CAN_FB_Type) SetFR1_FB10(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x400)|value<<10)
}
func (o *CAN_FB_Type) GetFR1_FB10() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x400) >> 10
}
func (o *CAN_FB_Type) SetFR1_FB11(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x800)|value<<11)
}
func (o *CAN_FB_Type) GetFR1_FB11() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x800) >> 11
}
func (o *CAN_FB_Type) SetFR1_FB12(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_FB_Type) GetFR1_FB12() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x1000) >> 12
}
func (o *CAN_FB_Type) SetFR1_FB13(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_FB_Type) GetFR1_FB13() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x2000) >> 13
}
func (o *CAN_FB_Type) SetFR1_FB14(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_FB_Type) GetFR1_FB14() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x4000) >> 14
}
func (o *CAN_FB_Type) SetFR1_FB15(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_FB_Type) GetFR1_FB15() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x8000) >> 15
}
func (o *CAN_FB_Type) SetFR1_FB16(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_FB_Type) GetFR1_FB16() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x10000) >> 16
}
func (o *CAN_FB_Type) SetFR1_FB17(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_FB_Type) GetFR1_FB17() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x20000) >> 17
}
func (o *CAN_FB_Type) SetFR1_FB18(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_FB_Type) GetFR1_FB18() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x40000) >> 18
}
func (o *CAN_FB_Type) SetFR1_FB19(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_FB_Type) GetFR1_FB19() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x80000) >> 19
}
func (o *CAN_FB_Type) SetFR1_FB20(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_FB_Type) GetFR1_FB20() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x100000) >> 20
}
func (o *CAN_FB_Type) SetFR1_FB21(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_FB_Type) GetFR1_FB21() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x200000) >> 21
}
func (o *CAN_FB_Type) SetFR1_FB22(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_FB_Type) GetFR1_FB22() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x400000) >> 22
}
func (o *CAN_FB_Type) SetFR1_FB23(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_FB_Type) GetFR1_FB23() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x800000) >> 23
}
func (o *CAN_FB_Type) SetFR1_FB24(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_FB_Type) GetFR1_FB24() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x1000000) >> 24
}
func (o *CAN_FB_Type) SetFR1_FB25(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_FB_Type) GetFR1_FB25() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x2000000) >> 25
}
func (o *CAN_FB_Type) SetFR1_FB26(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_FB_Type) GetFR1_FB26() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x4000000) >> 26
}
func (o *CAN_FB_Type) SetFR1_FB27(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_FB_Type) GetFR1_FB27() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x8000000) >> 27
}
func (o *CAN_FB_Type) SetFR1_FB28(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_FB_Type) GetFR1_FB28() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x10000000) >> 28
}
func (o *CAN_FB_Type) SetFR1_FB29(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_FB_Type) GetFR1_FB29() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x20000000) >> 29
}
func (o *CAN_FB_Type) SetFR1_FB30(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_FB_Type) GetFR1_FB30() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x40000000) >> 30
}
func (o *CAN_FB_Type) SetFR1_FB31(value uint32) {
	volatile.StoreUint32(&o.FR1.Reg, volatile.LoadUint32(&o.FR1.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_FB_Type) GetFR1_FB31() uint32 {
	return (volatile.LoadUint32(&o.FR1.Reg) & 0x80000000) >> 31
}

// CAN_FB.FR2: Filter bank 0 register 2
func (o *CAN_FB_Type) SetFR2_FB0(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x1)|value)
}
func (o *CAN_FB_Type) GetFR2_FB0() uint32 {
	return volatile.LoadUint32(&o.FR2.Reg) & 0x1
}
func (o *CAN_FB_Type) SetFR2_FB1(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x2)|value<<1)
}
func (o *CAN_FB_Type) GetFR2_FB1() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x2) >> 1
}
func (o *CAN_FB_Type) SetFR2_FB2(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x4)|value<<2)
}
func (o *CAN_FB_Type) GetFR2_FB2() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x4) >> 2
}
func (o *CAN_FB_Type) SetFR2_FB3(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x8)|value<<3)
}
func (o *CAN_FB_Type) GetFR2_FB3() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x8) >> 3
}
func (o *CAN_FB_Type) SetFR2_FB4(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x10)|value<<4)
}
func (o *CAN_FB_Type) GetFR2_FB4() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x10) >> 4
}
func (o *CAN_FB_Type) SetFR2_FB5(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x20)|value<<5)
}
func (o *CAN_FB_Type) GetFR2_FB5() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x20) >> 5
}
func (o *CAN_FB_Type) SetFR2_FB6(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x40)|value<<6)
}
func (o *CAN_FB_Type) GetFR2_FB6() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x40) >> 6
}
func (o *CAN_FB_Type) SetFR2_FB7(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x80)|value<<7)
}
func (o *CAN_FB_Type) GetFR2_FB7() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x80) >> 7
}
func (o *CAN_FB_Type) SetFR2_FB8(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x100)|value<<8)
}
func (o *CAN_FB_Type) GetFR2_FB8() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x100) >> 8
}
func (o *CAN_FB_Type) SetFR2_FB9(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x200)|value<<9)
}
func (o *CAN_FB_Type) GetFR2_FB9() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x200) >> 9
}
func (o *CAN_FB_Type) SetFR2_FB10(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x400)|value<<10)
}
func (o *CAN_FB_Type) GetFR2_FB10() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x400) >> 10
}
func (o *CAN_FB_Type) SetFR2_FB11(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x800)|value<<11)
}
func (o *CAN_FB_Type) GetFR2_FB11() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x800) >> 11
}
func (o *CAN_FB_Type) SetFR2_FB12(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x1000)|value<<12)
}
func (o *CAN_FB_Type) GetFR2_FB12() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x1000) >> 12
}
func (o *CAN_FB_Type) SetFR2_FB13(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x2000)|value<<13)
}
func (o *CAN_FB_Type) GetFR2_FB13() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x2000) >> 13
}
func (o *CAN_FB_Type) SetFR2_FB14(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x4000)|value<<14)
}
func (o *CAN_FB_Type) GetFR2_FB14() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x4000) >> 14
}
func (o *CAN_FB_Type) SetFR2_FB15(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x8000)|value<<15)
}
func (o *CAN_FB_Type) GetFR2_FB15() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x8000) >> 15
}
func (o *CAN_FB_Type) SetFR2_FB16(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x10000)|value<<16)
}
func (o *CAN_FB_Type) GetFR2_FB16() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x10000) >> 16
}
func (o *CAN_FB_Type) SetFR2_FB17(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x20000)|value<<17)
}
func (o *CAN_FB_Type) GetFR2_FB17() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x20000) >> 17
}
func (o *CAN_FB_Type) SetFR2_FB18(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x40000)|value<<18)
}
func (o *CAN_FB_Type) GetFR2_FB18() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x40000) >> 18
}
func (o *CAN_FB_Type) SetFR2_FB19(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x80000)|value<<19)
}
func (o *CAN_FB_Type) GetFR2_FB19() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x80000) >> 19
}
func (o *CAN_FB_Type) SetFR2_FB20(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x100000)|value<<20)
}
func (o *CAN_FB_Type) GetFR2_FB20() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x100000) >> 20
}
func (o *CAN_FB_Type) SetFR2_FB21(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x200000)|value<<21)
}
func (o *CAN_FB_Type) GetFR2_FB21() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x200000) >> 21
}
func (o *CAN_FB_Type) SetFR2_FB22(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x400000)|value<<22)
}
func (o *CAN_FB_Type) GetFR2_FB22() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x400000) >> 22
}
func (o *CAN_FB_Type) SetFR2_FB23(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x800000)|value<<23)
}
func (o *CAN_FB_Type) GetFR2_FB23() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x800000) >> 23
}
func (o *CAN_FB_Type) SetFR2_FB24(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x1000000)|value<<24)
}
func (o *CAN_FB_Type) GetFR2_FB24() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x1000000) >> 24
}
func (o *CAN_FB_Type) SetFR2_FB25(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x2000000)|value<<25)
}
func (o *CAN_FB_Type) GetFR2_FB25() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x2000000) >> 25
}
func (o *CAN_FB_Type) SetFR2_FB26(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x4000000)|value<<26)
}
func (o *CAN_FB_Type) GetFR2_FB26() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x4000000) >> 26
}
func (o *CAN_FB_Type) SetFR2_FB27(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x8000000)|value<<27)
}
func (o *CAN_FB_Type) GetFR2_FB27() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x8000000) >> 27
}
func (o *CAN_FB_Type) SetFR2_FB28(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x10000000)|value<<28)
}
func (o *CAN_FB_Type) GetFR2_FB28() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x10000000) >> 28
}
func (o *CAN_FB_Type) SetFR2_FB29(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x20000000)|value<<29)
}
func (o *CAN_FB_Type) GetFR2_FB29() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x20000000) >> 29
}
func (o *CAN_FB_Type) SetFR2_FB30(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x40000000)|value<<30)
}
func (o *CAN_FB_Type) GetFR2_FB30() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x40000000) >> 30
}
func (o *CAN_FB_Type) SetFR2_FB31(value uint32) {
	volatile.StoreUint32(&o.FR2.Reg, volatile.LoadUint32(&o.FR2.Reg)&^(0x80000000)|value<<31)
}
func (o *CAN_FB_Type) GetFR2_FB31() uint32 {
	return (volatile.LoadUint32(&o.FR2.Reg) & 0x80000000) >> 31
}

// Cryptographic processor
type CRC_Type struct {
	DR   volatile.Register32 // 0x0
	IDR  volatile.Register32 // 0x4
	CR   volatile.Register32 // 0x8
	_    [4]byte
	INIT volatile.Register32 // 0x10
	POL  volatile.Register32 // 0x14
}

// CRC.DR: Data register
func (o *CRC_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *CRC_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// CRC.IDR: Independent Data register
func (o *CRC_Type) SetIDR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0xff)|value)
}
func (o *CRC_Type) GetIDR() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0xff
}

// CRC.CR: Control register
func (o *CRC_Type) SetCR_RESET(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *CRC_Type) GetCR_RESET() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *CRC_Type) SetCR_POLYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *CRC_Type) GetCR_POLYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *CRC_Type) SetCR_REV_IN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *CRC_Type) GetCR_REV_IN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *CRC_Type) SetCR_REV_OUT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCR_REV_OUT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// CRC.INIT: Initial CRC value
func (o *CRC_Type) SetINIT(value uint32) {
	volatile.StoreUint32(&o.INIT.Reg, value)
}
func (o *CRC_Type) GetINIT() uint32 {
	return volatile.LoadUint32(&o.INIT.Reg)
}

// CRC.POL: CRC polynomial
func (o *CRC_Type) SetPOL(value uint32) {
	volatile.StoreUint32(&o.POL.Reg, value)
}
func (o *CRC_Type) GetPOL() uint32 {
	return volatile.LoadUint32(&o.POL.Reg)
}

// Debug support
type DBG_Type struct {
	IDCODE  volatile.Register32 // 0x0
	CR      volatile.Register32 // 0x4
	APB1_FZ volatile.Register32 // 0x8
	APB2_FZ volatile.Register32 // 0xC
}

// DBG.IDCODE: IDCODE
func (o *DBG_Type) SetIDCODE_DEV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xfff)|value)
}
func (o *DBG_Type) GetIDCODE_DEV_ID() uint32 {
	return volatile.LoadUint32(&o.IDCODE.Reg) & 0xfff
}
func (o *DBG_Type) SetIDCODE_REV_ID(value uint32) {
	volatile.StoreUint32(&o.IDCODE.Reg, volatile.LoadUint32(&o.IDCODE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DBG_Type) GetIDCODE_REV_ID() uint32 {
	return (volatile.LoadUint32(&o.IDCODE.Reg) & 0xffff0000) >> 16
}

// DBG.CR: Control Register
func (o *DBG_Type) SetCR_DBG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetCR_DBG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *DBG_Type) SetCR_DBG_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetCR_DBG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetCR_DBG_STANDBY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DBG_Type) GetCR_DBG_STANDBY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DBG_Type) SetCR_TRACE_IOEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DBG_Type) GetCR_TRACE_IOEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DBG_Type) SetCR_TRACE_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DBG_Type) GetCR_TRACE_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}

// DBG.APB1_FZ: Debug MCU APB1 Freeze registe
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM2_STOP() uint32 {
	return volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM3_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM3_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM4_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x4)|value<<2)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM4_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x4) >> 2
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM5_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x8)|value<<3)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM5_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x8) >> 3
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM6_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x10)|value<<4)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM6_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x10) >> 4
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM7_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x20)|value<<5)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM7_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x20) >> 5
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM12_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x40)|value<<6)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM12_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x40) >> 6
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM13_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x80)|value<<7)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM13_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x80) >> 7
}
func (o *DBG_Type) SetAPB1_FZ_DBG_TIM14_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x100)|value<<8)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_TIM14_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x100) >> 8
}
func (o *DBG_Type) SetAPB1_FZ_DBG_WWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x800)|value<<11)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_WWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x800) >> 11
}
func (o *DBG_Type) SetAPB1_FZ_DBG_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x1000)|value<<12)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x1000) >> 12
}
func (o *DBG_Type) SetAPB1_FZ_DBG_J2C1_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x200000)|value<<21)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_J2C1_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x200000) >> 21
}
func (o *DBG_Type) SetAPB1_FZ_DBG_J2C2_SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x400000)|value<<22)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_J2C2_SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x400000) >> 22
}
func (o *DBG_Type) SetAPB1_FZ_DBG_J2C3SMBUS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x800000)|value<<23)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_J2C3SMBUS_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x800000) >> 23
}
func (o *DBG_Type) SetAPB1_FZ_DBG_CAN1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x2000000)|value<<25)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_CAN1_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x2000000) >> 25
}
func (o *DBG_Type) SetAPB1_FZ_DBG_CAN2_STOP(value uint32) {
	volatile.StoreUint32(&o.APB1_FZ.Reg, volatile.LoadUint32(&o.APB1_FZ.Reg)&^(0x4000000)|value<<26)
}
func (o *DBG_Type) GetAPB1_FZ_DBG_CAN2_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB1_FZ.Reg) & 0x4000000) >> 26
}

// DBG.APB2_FZ: Debug MCU APB2 Freeze registe
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM1_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM1_STOP() uint32 {
	return volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x1
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM8_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM8_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM9_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x10000)|value<<16)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM9_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x10000) >> 16
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM10_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x20000)|value<<17)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM10_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x20000) >> 17
}
func (o *DBG_Type) SetAPB2_FZ_DBG_TIM11_STOP(value uint32) {
	volatile.StoreUint32(&o.APB2_FZ.Reg, volatile.LoadUint32(&o.APB2_FZ.Reg)&^(0x40000)|value<<18)
}
func (o *DBG_Type) GetAPB2_FZ_DBG_TIM11_STOP() uint32 {
	return (volatile.LoadUint32(&o.APB2_FZ.Reg) & 0x40000) >> 18
}

// Digital-to-analog converter
type DAC_Type struct {
	CR      volatile.Register32 // 0x0
	SWTRIGR volatile.Register32 // 0x4
	DHR12R1 volatile.Register32 // 0x8
	DHR12L1 volatile.Register32 // 0xC
	DHR8R1  volatile.Register32 // 0x10
	DHR12R2 volatile.Register32 // 0x14
	DHR12L2 volatile.Register32 // 0x18
	DHR8R2  volatile.Register32 // 0x1C
	DHR12RD volatile.Register32 // 0x20
	DHR12LD volatile.Register32 // 0x24
	DHR8RD  volatile.Register32 // 0x28
	DOR1    volatile.Register32 // 0x2C
	DOR2    volatile.Register32 // 0x30
	SR      volatile.Register32 // 0x34
}

// DAC.CR: control register
func (o *DAC_Type) SetCR_DMAUDRIE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetCR_DMAUDRIE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetCR_DMAEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *DAC_Type) GetCR_DMAEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}
func (o *DAC_Type) SetCR_MAMP2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf000000)|value<<24)
}
func (o *DAC_Type) GetCR_MAMP2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf000000) >> 24
}
func (o *DAC_Type) SetCR_WAVE2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc00000)|value<<22)
}
func (o *DAC_Type) GetCR_WAVE2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc00000) >> 22
}
func (o *DAC_Type) SetCR_TSEL2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x380000)|value<<19)
}
func (o *DAC_Type) GetCR_TSEL2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x380000) >> 19
}
func (o *DAC_Type) SetCR_TEN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DAC_Type) GetCR_TEN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DAC_Type) SetCR_BOFF2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *DAC_Type) GetCR_BOFF2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *DAC_Type) SetCR_EN2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *DAC_Type) GetCR_EN2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *DAC_Type) SetCR_DMAUDRIE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetCR_DMAUDRIE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *DAC_Type) SetCR_DMAEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *DAC_Type) GetCR_DMAEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *DAC_Type) SetCR_MAMP1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf00)|value<<8)
}
func (o *DAC_Type) GetCR_MAMP1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf00) >> 8
}
func (o *DAC_Type) SetCR_WAVE1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DAC_Type) GetCR_WAVE1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DAC_Type) SetCR_TSEL1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x38)|value<<3)
}
func (o *DAC_Type) GetCR_TSEL1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x38) >> 3
}
func (o *DAC_Type) SetCR_TEN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DAC_Type) GetCR_TEN1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DAC_Type) SetCR_BOFF1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetCR_BOFF1() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetCR_EN1(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetCR_EN1() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DAC.SWTRIGR: software trigger register
func (o *DAC_Type) SetSWTRIGR_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x2)|value<<1)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x2) >> 1
}
func (o *DAC_Type) SetSWTRIGR_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRIGR.Reg, volatile.LoadUint32(&o.SWTRIGR.Reg)&^(0x1)|value)
}
func (o *DAC_Type) GetSWTRIGR_SWTRIG1() uint32 {
	return volatile.LoadUint32(&o.SWTRIGR.Reg) & 0x1
}

// DAC.DHR12R1: channel1 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R1.Reg, volatile.LoadUint32(&o.DHR12R1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R1.Reg) & 0xfff
}

// DAC.DHR12L1: channel1 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L1.Reg, volatile.LoadUint32(&o.DHR12L1.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L1_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L1.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R1: channel1 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8R1_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R1.Reg, volatile.LoadUint32(&o.DHR8R1.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R1_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R1.Reg) & 0xff
}

// DAC.DHR12R2: channel2 12-bit right aligned data holding register
func (o *DAC_Type) SetDHR12R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12R2.Reg, volatile.LoadUint32(&o.DHR12R2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12R2.Reg) & 0xfff
}

// DAC.DHR12L2: channel2 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12L2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12L2.Reg, volatile.LoadUint32(&o.DHR12L2.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12L2_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12L2.Reg) & 0xfff0) >> 4
}

// DAC.DHR8R2: channel2 8-bit right-aligned data holding register
func (o *DAC_Type) SetDHR8R2_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8R2.Reg, volatile.LoadUint32(&o.DHR8R2.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8R2_DACC2DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8R2.Reg) & 0xff
}

// DAC.DHR12RD: Dual DAC 12-bit right-aligned data holding register
func (o *DAC_Type) SetDHR12RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff0000)|value<<16)
}
func (o *DAC_Type) GetDHR12RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff0000) >> 16
}
func (o *DAC_Type) SetDHR12RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12RD.Reg, volatile.LoadUint32(&o.DHR12RD.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDHR12RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR12RD.Reg) & 0xfff
}

// DAC.DHR12LD: DUAL DAC 12-bit left aligned data holding register
func (o *DAC_Type) SetDHR12LD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff00000)|value<<20)
}
func (o *DAC_Type) GetDHR12LD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff00000) >> 20
}
func (o *DAC_Type) SetDHR12LD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR12LD.Reg, volatile.LoadUint32(&o.DHR12LD.Reg)&^(0xfff0)|value<<4)
}
func (o *DAC_Type) GetDHR12LD_DACC1DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR12LD.Reg) & 0xfff0) >> 4
}

// DAC.DHR8RD: DUAL DAC 8-bit right aligned data holding register
func (o *DAC_Type) SetDHR8RD_DACC2DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff00)|value<<8)
}
func (o *DAC_Type) GetDHR8RD_DACC2DHR() uint32 {
	return (volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff00) >> 8
}
func (o *DAC_Type) SetDHR8RD_DACC1DHR(value uint32) {
	volatile.StoreUint32(&o.DHR8RD.Reg, volatile.LoadUint32(&o.DHR8RD.Reg)&^(0xff)|value)
}
func (o *DAC_Type) GetDHR8RD_DACC1DHR() uint32 {
	return volatile.LoadUint32(&o.DHR8RD.Reg) & 0xff
}

// DAC.DOR1: channel1 data output register
func (o *DAC_Type) SetDOR1_DACC1DOR(value uint32) {
	volatile.StoreUint32(&o.DOR1.Reg, volatile.LoadUint32(&o.DOR1.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR1_DACC1DOR() uint32 {
	return volatile.LoadUint32(&o.DOR1.Reg) & 0xfff
}

// DAC.DOR2: channel2 data output register
func (o *DAC_Type) SetDOR2_DACC2DOR(value uint32) {
	volatile.StoreUint32(&o.DOR2.Reg, volatile.LoadUint32(&o.DOR2.Reg)&^(0xfff)|value)
}
func (o *DAC_Type) GetDOR2_DACC2DOR() uint32 {
	return volatile.LoadUint32(&o.DOR2.Reg) & 0xfff
}

// DAC.SR: status register
func (o *DAC_Type) SetSR_DMAUDR2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000000)|value<<29)
}
func (o *DAC_Type) GetSR_DMAUDR2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000000) >> 29
}
func (o *DAC_Type) SetSR_DMAUDR1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *DAC_Type) GetSR_DMAUDR1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}

// DMA controller
type DMA_Type struct {
	LISR  volatile.Register32 // 0x0
	HISR  volatile.Register32 // 0x4
	LIFCR volatile.Register32 // 0x8
	HIFCR volatile.Register32 // 0xC
	ST    [8]DMA_ST_Type      // 0x10
}

// DMA.LISR: low interrupt status register
func (o *DMA_Type) SetLISR_TCIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetLISR_TCIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetLISR_HTIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetLISR_HTIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetLISR_TEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetLISR_TEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetLISR_DMEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetLISR_DMEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetLISR_FEIF3(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetLISR_FEIF3() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetLISR_TCIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetLISR_TCIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetLISR_HTIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetLISR_HTIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetLISR_TEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetLISR_TEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetLISR_DMEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetLISR_DMEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetLISR_FEIF2(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetLISR_FEIF2() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetLISR_TCIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetLISR_TCIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetLISR_HTIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetLISR_HTIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetLISR_TEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetLISR_TEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetLISR_DMEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetLISR_DMEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetLISR_FEIF1(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetLISR_FEIF1() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetLISR_TCIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetLISR_TCIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetLISR_HTIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetLISR_HTIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetLISR_TEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetLISR_TEIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetLISR_DMEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetLISR_DMEIF0() uint32 {
	return (volatile.LoadUint32(&o.LISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetLISR_FEIF0(value uint32) {
	volatile.StoreUint32(&o.LISR.Reg, volatile.LoadUint32(&o.LISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetLISR_FEIF0() uint32 {
	return volatile.LoadUint32(&o.LISR.Reg) & 0x1
}

// DMA.HISR: high interrupt status register
func (o *DMA_Type) SetHISR_TCIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetHISR_TCIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetHISR_HTIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetHISR_HTIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetHISR_TEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetHISR_TEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetHISR_DMEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetHISR_DMEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetHISR_FEIF7(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetHISR_FEIF7() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetHISR_TCIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetHISR_TCIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetHISR_HTIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetHISR_HTIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetHISR_TEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetHISR_TEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetHISR_DMEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetHISR_DMEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetHISR_FEIF6(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetHISR_FEIF6() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetHISR_TCIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHISR_TCIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHISR_HTIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHISR_HTIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHISR_TEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHISR_TEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHISR_DMEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHISR_DMEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHISR_FEIF5(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHISR_FEIF5() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHISR_TCIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHISR_TCIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHISR_HTIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHISR_HTIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHISR_TEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHISR_TEIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHISR_DMEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHISR_DMEIF4() uint32 {
	return (volatile.LoadUint32(&o.HISR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHISR_FEIF4(value uint32) {
	volatile.StoreUint32(&o.HISR.Reg, volatile.LoadUint32(&o.HISR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHISR_FEIF4() uint32 {
	return volatile.LoadUint32(&o.HISR.Reg) & 0x1
}

// DMA.LIFCR: low interrupt flag clear register
func (o *DMA_Type) SetLIFCR_CTCIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetLIFCR_CTCIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetLIFCR_CHTIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetLIFCR_CHTIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetLIFCR_CTEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetLIFCR_CTEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetLIFCR_CDMEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetLIFCR_CDMEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetLIFCR_CFEIF3(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetLIFCR_CFEIF3() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetLIFCR_CTCIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetLIFCR_CTCIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetLIFCR_CHTIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetLIFCR_CHTIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetLIFCR_CTEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetLIFCR_CTEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetLIFCR_CDMEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetLIFCR_CDMEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetLIFCR_CFEIF2(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetLIFCR_CFEIF2() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetLIFCR_CTCIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetLIFCR_CTCIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetLIFCR_CHTIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetLIFCR_CHTIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetLIFCR_CTEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetLIFCR_CTEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetLIFCR_CDMEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetLIFCR_CDMEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetLIFCR_CFEIF1(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetLIFCR_CFEIF1() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetLIFCR_CTCIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetLIFCR_CTCIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetLIFCR_CHTIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetLIFCR_CHTIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetLIFCR_CTEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetLIFCR_CTEIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetLIFCR_CDMEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetLIFCR_CDMEIF0() uint32 {
	return (volatile.LoadUint32(&o.LIFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetLIFCR_CFEIF0(value uint32) {
	volatile.StoreUint32(&o.LIFCR.Reg, volatile.LoadUint32(&o.LIFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetLIFCR_CFEIF0() uint32 {
	return volatile.LoadUint32(&o.LIFCR.Reg) & 0x1
}

// DMA.HIFCR: high interrupt flag clear register
func (o *DMA_Type) SetHIFCR_CTCIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x8000000)|value<<27)
}
func (o *DMA_Type) GetHIFCR_CTCIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x8000000) >> 27
}
func (o *DMA_Type) SetHIFCR_CHTIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x4000000)|value<<26)
}
func (o *DMA_Type) GetHIFCR_CHTIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x4000000) >> 26
}
func (o *DMA_Type) SetHIFCR_CTEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x2000000)|value<<25)
}
func (o *DMA_Type) GetHIFCR_CTEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x2000000) >> 25
}
func (o *DMA_Type) SetHIFCR_CDMEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DMA_Type) GetHIFCR_CDMEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x1000000) >> 24
}
func (o *DMA_Type) SetHIFCR_CFEIF7(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x400000)|value<<22)
}
func (o *DMA_Type) GetHIFCR_CFEIF7() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x400000) >> 22
}
func (o *DMA_Type) SetHIFCR_CTCIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x200000)|value<<21)
}
func (o *DMA_Type) GetHIFCR_CTCIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x200000) >> 21
}
func (o *DMA_Type) SetHIFCR_CHTIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x100000)|value<<20)
}
func (o *DMA_Type) GetHIFCR_CHTIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x100000) >> 20
}
func (o *DMA_Type) SetHIFCR_CTEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_Type) GetHIFCR_CTEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x80000) >> 19
}
func (o *DMA_Type) SetHIFCR_CDMEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_Type) GetHIFCR_CDMEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x40000) >> 18
}
func (o *DMA_Type) SetHIFCR_CFEIF6(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x10000)|value<<16)
}
func (o *DMA_Type) GetHIFCR_CFEIF6() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x10000) >> 16
}
func (o *DMA_Type) SetHIFCR_CTCIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x800)|value<<11)
}
func (o *DMA_Type) GetHIFCR_CTCIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x800) >> 11
}
func (o *DMA_Type) SetHIFCR_CHTIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_Type) GetHIFCR_CHTIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x400) >> 10
}
func (o *DMA_Type) SetHIFCR_CTEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_Type) GetHIFCR_CTEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x200) >> 9
}
func (o *DMA_Type) SetHIFCR_CDMEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_Type) GetHIFCR_CDMEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x100) >> 8
}
func (o *DMA_Type) SetHIFCR_CFEIF5(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x40)|value<<6)
}
func (o *DMA_Type) GetHIFCR_CFEIF5() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x40) >> 6
}
func (o *DMA_Type) SetHIFCR_CTCIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_Type) GetHIFCR_CTCIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x20) >> 5
}
func (o *DMA_Type) SetHIFCR_CHTIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_Type) GetHIFCR_CHTIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x10) >> 4
}
func (o *DMA_Type) SetHIFCR_CTEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_Type) GetHIFCR_CTEIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x8) >> 3
}
func (o *DMA_Type) SetHIFCR_CDMEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_Type) GetHIFCR_CDMEIF4() uint32 {
	return (volatile.LoadUint32(&o.HIFCR.Reg) & 0x4) >> 2
}
func (o *DMA_Type) SetHIFCR_CFEIF4(value uint32) {
	volatile.StoreUint32(&o.HIFCR.Reg, volatile.LoadUint32(&o.HIFCR.Reg)&^(0x1)|value)
}
func (o *DMA_Type) GetHIFCR_CFEIF4() uint32 {
	return volatile.LoadUint32(&o.HIFCR.Reg) & 0x1
}

type DMA_ST_Type struct {
	CR   volatile.Register32 // 0x10
	NDTR volatile.Register32 // 0x14
	PAR  volatile.Register32 // 0x18
	M0AR volatile.Register32 // 0x1C
	M1AR volatile.Register32 // 0x20
	FCR  volatile.Register32 // 0x24
}

// DMA_ST.CR: stream x configuration register
func (o *DMA_ST_Type) SetCR_CHSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xe000000)|value<<25)
}
func (o *DMA_ST_Type) GetCR_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xe000000) >> 25
}
func (o *DMA_ST_Type) SetCR_MBURST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1800000)|value<<23)
}
func (o *DMA_ST_Type) GetCR_MBURST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1800000) >> 23
}
func (o *DMA_ST_Type) SetCR_PBURST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *DMA_ST_Type) GetCR_PBURST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *DMA_ST_Type) SetCR_CT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *DMA_ST_Type) GetCR_CT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *DMA_ST_Type) SetCR_DBM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *DMA_ST_Type) GetCR_DBM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *DMA_ST_Type) SetCR_PL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x30000)|value<<16)
}
func (o *DMA_ST_Type) GetCR_PL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x30000) >> 16
}
func (o *DMA_ST_Type) SetCR_PINCOS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *DMA_ST_Type) GetCR_PINCOS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *DMA_ST_Type) SetCR_MSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6000)|value<<13)
}
func (o *DMA_ST_Type) GetCR_MSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6000) >> 13
}
func (o *DMA_ST_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1800)|value<<11)
}
func (o *DMA_ST_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1800) >> 11
}
func (o *DMA_ST_Type) SetCR_MINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *DMA_ST_Type) GetCR_MINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *DMA_ST_Type) SetCR_PINC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *DMA_ST_Type) GetCR_PINC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *DMA_ST_Type) SetCR_CIRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *DMA_ST_Type) GetCR_CIRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *DMA_ST_Type) SetCR_DIR(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xc0)|value<<6)
}
func (o *DMA_ST_Type) GetCR_DIR() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xc0) >> 6
}
func (o *DMA_ST_Type) SetCR_PFCTRL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *DMA_ST_Type) GetCR_PFCTRL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *DMA_ST_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *DMA_ST_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *DMA_ST_Type) SetCR_HTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *DMA_ST_Type) GetCR_HTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *DMA_ST_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_ST_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *DMA_ST_Type) SetCR_DMEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *DMA_ST_Type) GetCR_DMEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *DMA_ST_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DMA_ST_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DMA_ST.NDTR: stream x number of data register
func (o *DMA_ST_Type) SetNDTR_NDT(value uint32) {
	volatile.StoreUint32(&o.NDTR.Reg, volatile.LoadUint32(&o.NDTR.Reg)&^(0xffff)|value)
}
func (o *DMA_ST_Type) GetNDTR_NDT() uint32 {
	return volatile.LoadUint32(&o.NDTR.Reg) & 0xffff
}

// DMA_ST.PAR: stream x peripheral address register
func (o *DMA_ST_Type) SetPAR(value uint32) {
	volatile.StoreUint32(&o.PAR.Reg, value)
}
func (o *DMA_ST_Type) GetPAR() uint32 {
	return volatile.LoadUint32(&o.PAR.Reg)
}

// DMA_ST.M0AR: stream x memory 0 address register
func (o *DMA_ST_Type) SetM0AR(value uint32) {
	volatile.StoreUint32(&o.M0AR.Reg, value)
}
func (o *DMA_ST_Type) GetM0AR() uint32 {
	return volatile.LoadUint32(&o.M0AR.Reg)
}

// DMA_ST.M1AR: stream x memory 1 address register
func (o *DMA_ST_Type) SetM1AR(value uint32) {
	volatile.StoreUint32(&o.M1AR.Reg, value)
}
func (o *DMA_ST_Type) GetM1AR() uint32 {
	return volatile.LoadUint32(&o.M1AR.Reg)
}

// DMA_ST.FCR: stream x FIFO control register
func (o *DMA_ST_Type) SetFCR_FEIE(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x80)|value<<7)
}
func (o *DMA_ST_Type) GetFCR_FEIE() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x80) >> 7
}
func (o *DMA_ST_Type) SetFCR_FS(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x38)|value<<3)
}
func (o *DMA_ST_Type) GetFCR_FS() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x38) >> 3
}
func (o *DMA_ST_Type) SetFCR_DMDIS(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x4)|value<<2)
}
func (o *DMA_ST_Type) GetFCR_DMDIS() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x4) >> 2
}
func (o *DMA_ST_Type) SetFCR_FTH(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x3)|value)
}
func (o *DMA_ST_Type) GetFCR_FTH() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x3
}

// External interrupt/event controller
type EXTI_Type struct {
	IMR   volatile.Register32 // 0x0
	EMR   volatile.Register32 // 0x4
	RTSR  volatile.Register32 // 0x8
	FTSR  volatile.Register32 // 0xC
	SWIER volatile.Register32 // 0x10
	PR    volatile.Register32 // 0x14
}

// EXTI.IMR: Interrupt mask register (EXTI_IMR)
func (o *EXTI_Type) SetIMR_IM0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetIMR_IM0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *EXTI_Type) SetIMR_IM1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetIMR_IM1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetIMR_IM2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetIMR_IM2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetIMR_IM3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetIMR_IM3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetIMR_IM4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetIMR_IM4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetIMR_IM5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetIMR_IM5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetIMR_IM6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetIMR_IM6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetIMR_IM7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetIMR_IM7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetIMR_IM8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetIMR_IM8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetIMR_MI9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetIMR_MI9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetIMR_IM10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetIMR_IM10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetIMR_IM11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetIMR_IM11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetIMR_IM12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetIMR_IM12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetIMR_IM13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetIMR_IM13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetIMR_IM14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetIMR_IM14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetIMR_IM15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetIMR_IM15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetIMR_IM16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetIMR_IM16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetIMR_IM17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetIMR_IM17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetIMR_IM18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetIMR_IM18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetIMR_IM19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetIMR_IM19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetIMR_IM20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetIMR_IM20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetIMR_IM21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetIMR_IM21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetIMR_IM22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetIMR_IM22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetIMR_IM23(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetIMR_IM23() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}

// EXTI.EMR: Event mask register (EXTI_EMR)
func (o *EXTI_Type) SetEMR_EM0(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetEMR_EM0() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x1
}
func (o *EXTI_Type) SetEMR_EM1(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetEMR_EM1() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetEMR_EM2(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetEMR_EM2() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetEMR_EM3(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetEMR_EM3() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetEMR_EM4(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetEMR_EM4() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetEMR_EM5(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetEMR_EM5() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetEMR_EM6(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetEMR_EM6() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetEMR_EM7(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetEMR_EM7() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetEMR_EM8(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetEMR_EM8() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetEMR_EM9(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetEMR_EM9() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetEMR_EM10(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetEMR_EM10() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetEMR_EM11(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetEMR_EM11() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetEMR_EM12(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetEMR_EM12() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetEMR_EM13(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetEMR_EM13() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetEMR_EM14(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetEMR_EM14() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetEMR_EM15(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetEMR_EM15() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetEMR_EM16(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetEMR_EM16() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetEMR_EM17(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetEMR_EM17() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetEMR_EM18(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetEMR_EM18() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetEMR_EM19(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetEMR_EM19() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetEMR_EM20(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetEMR_EM20() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetEMR_EM21(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetEMR_EM21() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetEMR_EM22(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetEMR_EM22() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetEMR_EM23(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetEMR_EM23() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x800000) >> 23
}

// EXTI.RTSR: Rising Trigger selection register (EXTI_RTSR)
func (o *EXTI_Type) SetRTSR_TR0(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetRTSR_TR0() uint32 {
	return volatile.LoadUint32(&o.RTSR.Reg) & 0x1
}
func (o *EXTI_Type) SetRTSR_TR1(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetRTSR_TR1() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetRTSR_TR2(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetRTSR_TR2() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetRTSR_TR3(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetRTSR_TR3() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetRTSR_TR4(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetRTSR_TR4() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetRTSR_TR5(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetRTSR_TR5() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetRTSR_TR6(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetRTSR_TR6() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetRTSR_TR7(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetRTSR_TR7() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetRTSR_TR8(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetRTSR_TR8() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetRTSR_TR9(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetRTSR_TR9() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetRTSR_TR10(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetRTSR_TR10() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetRTSR_TR11(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetRTSR_TR11() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetRTSR_TR12(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetRTSR_TR12() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetRTSR_TR13(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetRTSR_TR13() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetRTSR_TR14(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetRTSR_TR14() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetRTSR_TR15(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetRTSR_TR15() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetRTSR_TR16(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetRTSR_TR16() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetRTSR_TR17(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetRTSR_TR17() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetRTSR_TR18(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetRTSR_TR18() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetRTSR_TR19(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetRTSR_TR19() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetRTSR_TR20(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetRTSR_TR20() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetRTSR_TR21(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetRTSR_TR21() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetRTSR_TR22(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetRTSR_TR22() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetRTSR_TR23(value uint32) {
	volatile.StoreUint32(&o.RTSR.Reg, volatile.LoadUint32(&o.RTSR.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetRTSR_TR23() uint32 {
	return (volatile.LoadUint32(&o.RTSR.Reg) & 0x800000) >> 23
}

// EXTI.FTSR: Falling Trigger selection register (EXTI_FTSR)
func (o *EXTI_Type) SetFTSR_TR0(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetFTSR_TR0() uint32 {
	return volatile.LoadUint32(&o.FTSR.Reg) & 0x1
}
func (o *EXTI_Type) SetFTSR_TR1(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetFTSR_TR1() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetFTSR_TR2(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetFTSR_TR2() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetFTSR_TR3(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetFTSR_TR3() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetFTSR_TR4(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetFTSR_TR4() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetFTSR_TR5(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetFTSR_TR5() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetFTSR_TR6(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetFTSR_TR6() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetFTSR_TR7(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetFTSR_TR7() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetFTSR_TR8(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetFTSR_TR8() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetFTSR_TR9(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetFTSR_TR9() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetFTSR_TR10(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetFTSR_TR10() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetFTSR_TR11(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetFTSR_TR11() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetFTSR_TR12(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetFTSR_TR12() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetFTSR_TR13(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetFTSR_TR13() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetFTSR_TR14(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetFTSR_TR14() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetFTSR_TR15(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetFTSR_TR15() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetFTSR_TR16(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetFTSR_TR16() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetFTSR_TR17(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetFTSR_TR17() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetFTSR_TR18(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetFTSR_TR18() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetFTSR_TR19(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetFTSR_TR19() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetFTSR_TR20(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetFTSR_TR20() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetFTSR_TR21(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetFTSR_TR21() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetFTSR_TR22(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetFTSR_TR22() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetFTSR_TR23(value uint32) {
	volatile.StoreUint32(&o.FTSR.Reg, volatile.LoadUint32(&o.FTSR.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetFTSR_TR23() uint32 {
	return (volatile.LoadUint32(&o.FTSR.Reg) & 0x800000) >> 23
}

// EXTI.SWIER: Software interrupt event register (EXTI_SWIER)
func (o *EXTI_Type) SetSWIER_SWIER0(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetSWIER_SWIER0() uint32 {
	return volatile.LoadUint32(&o.SWIER.Reg) & 0x1
}
func (o *EXTI_Type) SetSWIER_SWIER1(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetSWIER_SWIER1() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetSWIER_SWIER2(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetSWIER_SWIER2() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetSWIER_SWIER3(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetSWIER_SWIER3() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetSWIER_SWIER4(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetSWIER_SWIER4() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetSWIER_SWIER5(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetSWIER_SWIER5() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetSWIER_SWIER6(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetSWIER_SWIER6() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetSWIER_SWIER7(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetSWIER_SWIER7() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetSWIER_SWIER8(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetSWIER_SWIER8() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetSWIER_SWIER9(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetSWIER_SWIER9() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetSWIER_SWIER10(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetSWIER_SWIER10() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetSWIER_SWIER11(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetSWIER_SWIER11() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetSWIER_SWIER12(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetSWIER_SWIER12() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetSWIER_SWIER13(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetSWIER_SWIER13() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetSWIER_SWIER14(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetSWIER_SWIER14() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetSWIER_SWIER15(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetSWIER_SWIER15() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetSWIER_SWIER16(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetSWIER_SWIER16() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetSWIER_SWIER17(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetSWIER_SWIER17() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetSWIER_SWIER18(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetSWIER_SWIER18() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetSWIER_SWIER19(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetSWIER_SWIER19() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetSWIER_SWIER20(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetSWIER_SWIER20() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetSWIER_SWIER21(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetSWIER_SWIER21() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetSWIER_SWIER22(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetSWIER_SWIER22() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetSWIER_SWIER23(value uint32) {
	volatile.StoreUint32(&o.SWIER.Reg, volatile.LoadUint32(&o.SWIER.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetSWIER_SWIER23() uint32 {
	return (volatile.LoadUint32(&o.SWIER.Reg) & 0x800000) >> 23
}

// EXTI.PR: Pending register (EXTI_PR)
func (o *EXTI_Type) SetPR_PR0(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x1)|value)
}
func (o *EXTI_Type) GetPR_PR0() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x1
}
func (o *EXTI_Type) SetPR_PR1(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x2)|value<<1)
}
func (o *EXTI_Type) GetPR_PR1() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x2) >> 1
}
func (o *EXTI_Type) SetPR_PR2(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x4)|value<<2)
}
func (o *EXTI_Type) GetPR_PR2() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x4) >> 2
}
func (o *EXTI_Type) SetPR_PR3(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x8)|value<<3)
}
func (o *EXTI_Type) GetPR_PR3() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x8) >> 3
}
func (o *EXTI_Type) SetPR_PR4(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x10)|value<<4)
}
func (o *EXTI_Type) GetPR_PR4() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x10) >> 4
}
func (o *EXTI_Type) SetPR_PR5(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x20)|value<<5)
}
func (o *EXTI_Type) GetPR_PR5() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x20) >> 5
}
func (o *EXTI_Type) SetPR_PR6(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x40)|value<<6)
}
func (o *EXTI_Type) GetPR_PR6() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x40) >> 6
}
func (o *EXTI_Type) SetPR_PR7(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x80)|value<<7)
}
func (o *EXTI_Type) GetPR_PR7() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x80) >> 7
}
func (o *EXTI_Type) SetPR_PR8(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x100)|value<<8)
}
func (o *EXTI_Type) GetPR_PR8() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x100) >> 8
}
func (o *EXTI_Type) SetPR_PR9(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x200)|value<<9)
}
func (o *EXTI_Type) GetPR_PR9() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x200) >> 9
}
func (o *EXTI_Type) SetPR_PR10(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x400)|value<<10)
}
func (o *EXTI_Type) GetPR_PR10() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x400) >> 10
}
func (o *EXTI_Type) SetPR_PR11(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x800)|value<<11)
}
func (o *EXTI_Type) GetPR_PR11() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x800) >> 11
}
func (o *EXTI_Type) SetPR_PR12(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x1000)|value<<12)
}
func (o *EXTI_Type) GetPR_PR12() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x1000) >> 12
}
func (o *EXTI_Type) SetPR_PR13(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x2000)|value<<13)
}
func (o *EXTI_Type) GetPR_PR13() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x2000) >> 13
}
func (o *EXTI_Type) SetPR_PR14(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x4000)|value<<14)
}
func (o *EXTI_Type) GetPR_PR14() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x4000) >> 14
}
func (o *EXTI_Type) SetPR_PR15(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x8000)|value<<15)
}
func (o *EXTI_Type) GetPR_PR15() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x8000) >> 15
}
func (o *EXTI_Type) SetPR_PR16(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x10000)|value<<16)
}
func (o *EXTI_Type) GetPR_PR16() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x10000) >> 16
}
func (o *EXTI_Type) SetPR_PR17(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x20000)|value<<17)
}
func (o *EXTI_Type) GetPR_PR17() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x20000) >> 17
}
func (o *EXTI_Type) SetPR_PR18(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x40000)|value<<18)
}
func (o *EXTI_Type) GetPR_PR18() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x40000) >> 18
}
func (o *EXTI_Type) SetPR_PR19(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x80000)|value<<19)
}
func (o *EXTI_Type) GetPR_PR19() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x80000) >> 19
}
func (o *EXTI_Type) SetPR_PR20(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x100000)|value<<20)
}
func (o *EXTI_Type) GetPR_PR20() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x100000) >> 20
}
func (o *EXTI_Type) SetPR_PR21(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x200000)|value<<21)
}
func (o *EXTI_Type) GetPR_PR21() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x200000) >> 21
}
func (o *EXTI_Type) SetPR_PR22(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x400000)|value<<22)
}
func (o *EXTI_Type) GetPR_PR22() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x400000) >> 22
}
func (o *EXTI_Type) SetPR_PR23(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x800000)|value<<23)
}
func (o *EXTI_Type) GetPR_PR23() uint32 {
	return (volatile.LoadUint32(&o.PR.Reg) & 0x800000) >> 23
}

// FLASH
type FLASH_Type struct {
	ACR     volatile.Register32 // 0x0
	KEYR    volatile.Register32 // 0x4
	OPTKEYR volatile.Register32 // 0x8
	SR      volatile.Register32 // 0xC
	CR      volatile.Register32 // 0x10
	OPTCR   volatile.Register32 // 0x14
	OPTCR1  volatile.Register32 // 0x18
	OPTCR2  volatile.Register32 // 0x1C
}

// FLASH.ACR: Flash access control register
func (o *FLASH_Type) SetACR_LATENCY(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0xf)|value)
}
func (o *FLASH_Type) GetACR_LATENCY() uint32 {
	return volatile.LoadUint32(&o.ACR.Reg) & 0xf
}
func (o *FLASH_Type) SetACR_PRFTEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x100)|value<<8)
}
func (o *FLASH_Type) GetACR_PRFTEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x100) >> 8
}
func (o *FLASH_Type) SetACR_ARTEN(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x200)|value<<9)
}
func (o *FLASH_Type) GetACR_ARTEN() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x200) >> 9
}
func (o *FLASH_Type) SetACR_ARTRST(value uint32) {
	volatile.StoreUint32(&o.ACR.Reg, volatile.LoadUint32(&o.ACR.Reg)&^(0x800)|value<<11)
}
func (o *FLASH_Type) GetACR_ARTRST() uint32 {
	return (volatile.LoadUint32(&o.ACR.Reg) & 0x800) >> 11
}

// FLASH.KEYR: Flash key register
func (o *FLASH_Type) SetKEYR(value uint32) {
	volatile.StoreUint32(&o.KEYR.Reg, value)
}
func (o *FLASH_Type) GetKEYR() uint32 {
	return volatile.LoadUint32(&o.KEYR.Reg)
}

// FLASH.OPTKEYR: Flash option key register
func (o *FLASH_Type) SetOPTKEYR(value uint32) {
	volatile.StoreUint32(&o.OPTKEYR.Reg, value)
}
func (o *FLASH_Type) GetOPTKEYR() uint32 {
	return volatile.LoadUint32(&o.OPTKEYR.Reg)
}

// FLASH.SR: Status register
func (o *FLASH_Type) SetSR_EOP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetSR_EOP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *FLASH_Type) SetSR_OPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetSR_OPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetSR_WRPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *FLASH_Type) GetSR_WRPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *FLASH_Type) SetSR_PGAERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *FLASH_Type) GetSR_PGAERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *FLASH_Type) SetSR_PGPERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *FLASH_Type) GetSR_PGPERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *FLASH_Type) SetSR_ERSERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_Type) GetSR_ERSERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *FLASH_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *FLASH_Type) SetSR_RDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *FLASH_Type) GetSR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}

// FLASH.CR: Control register
func (o *FLASH_Type) SetCR_PG(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetCR_PG() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *FLASH_Type) SetCR_SER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetCR_SER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetCR_MER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *FLASH_Type) GetCR_MER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *FLASH_Type) SetCR_SNB(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x78)|value<<3)
}
func (o *FLASH_Type) GetCR_SNB() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x78) >> 3
}
func (o *FLASH_Type) SetCR_PSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x300)|value<<8)
}
func (o *FLASH_Type) GetCR_PSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x300) >> 8
}
func (o *FLASH_Type) SetCR_STRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *FLASH_Type) GetCR_STRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *FLASH_Type) SetCR_EOPIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *FLASH_Type) GetCR_EOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *FLASH_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *FLASH_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *FLASH_Type) SetCR_LOCK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_Type) GetCR_LOCK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000000) >> 31
}
func (o *FLASH_Type) SetCR_RDERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *FLASH_Type) GetCR_RDERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}

// FLASH.OPTCR: Flash option control register
func (o *FLASH_Type) SetOPTCR_OPTLOCK(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x1)|value)
}
func (o *FLASH_Type) GetOPTCR_OPTLOCK() uint32 {
	return volatile.LoadUint32(&o.OPTCR.Reg) & 0x1
}
func (o *FLASH_Type) SetOPTCR_OPTSTRT(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x2)|value<<1)
}
func (o *FLASH_Type) GetOPTCR_OPTSTRT() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x2) >> 1
}
func (o *FLASH_Type) SetOPTCR_BOR_LEV(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xc)|value<<2)
}
func (o *FLASH_Type) GetOPTCR_BOR_LEV() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xc) >> 2
}
func (o *FLASH_Type) SetOPTCR_IWDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x20)|value<<5)
}
func (o *FLASH_Type) GetOPTCR_IWDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x20) >> 5
}
func (o *FLASH_Type) SetOPTCR_NRST_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x40)|value<<6)
}
func (o *FLASH_Type) GetOPTCR_NRST_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x40) >> 6
}
func (o *FLASH_Type) SetOPTCR_NRST_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x80)|value<<7)
}
func (o *FLASH_Type) GetOPTCR_NRST_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x80) >> 7
}
func (o *FLASH_Type) SetOPTCR_RDP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xff00)|value<<8)
}
func (o *FLASH_Type) GetOPTCR_RDP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xff00) >> 8
}
func (o *FLASH_Type) SetOPTCR_NWRP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0xff0000)|value<<16)
}
func (o *FLASH_Type) GetOPTCR_NWRP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0xff0000) >> 16
}
func (o *FLASH_Type) SetOPTCR_WWDG_SW(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x10)|value<<4)
}
func (o *FLASH_Type) GetOPTCR_WWDG_SW() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x10) >> 4
}
func (o *FLASH_Type) SetOPTCR_IWDG_STOP(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_Type) GetOPTCR_IWDG_STOP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x80000000) >> 31
}
func (o *FLASH_Type) SetOPTCR_IWDG_STDBY(value uint32) {
	volatile.StoreUint32(&o.OPTCR.Reg, volatile.LoadUint32(&o.OPTCR.Reg)&^(0x40000000)|value<<30)
}
func (o *FLASH_Type) GetOPTCR_IWDG_STDBY() uint32 {
	return (volatile.LoadUint32(&o.OPTCR.Reg) & 0x40000000) >> 30
}

// FLASH.OPTCR1: Flash option control register 1
func (o *FLASH_Type) SetOPTCR1_BOOT_ADD1(value uint32) {
	volatile.StoreUint32(&o.OPTCR1.Reg, volatile.LoadUint32(&o.OPTCR1.Reg)&^(0xffff0000)|value<<16)
}
func (o *FLASH_Type) GetOPTCR1_BOOT_ADD1() uint32 {
	return (volatile.LoadUint32(&o.OPTCR1.Reg) & 0xffff0000) >> 16
}
func (o *FLASH_Type) SetOPTCR1_BOOT_ADD0(value uint32) {
	volatile.StoreUint32(&o.OPTCR1.Reg, volatile.LoadUint32(&o.OPTCR1.Reg)&^(0xffff)|value)
}
func (o *FLASH_Type) GetOPTCR1_BOOT_ADD0() uint32 {
	return volatile.LoadUint32(&o.OPTCR1.Reg) & 0xffff
}

// FLASH.OPTCR2: Flash option control register
func (o *FLASH_Type) SetOPTCR2_PCROP_RDP(value uint32) {
	volatile.StoreUint32(&o.OPTCR2.Reg, volatile.LoadUint32(&o.OPTCR2.Reg)&^(0x80000000)|value<<31)
}
func (o *FLASH_Type) GetOPTCR2_PCROP_RDP() uint32 {
	return (volatile.LoadUint32(&o.OPTCR2.Reg) & 0x80000000) >> 31
}
func (o *FLASH_Type) SetOPTCR2_PCROPi(value uint32) {
	volatile.StoreUint32(&o.OPTCR2.Reg, volatile.LoadUint32(&o.OPTCR2.Reg)&^(0xff)|value)
}
func (o *FLASH_Type) GetOPTCR2_PCROPi() uint32 {
	return volatile.LoadUint32(&o.OPTCR2.Reg) & 0xff
}

// Flexible memory controller
type FSMC_Type struct {
	BCR1  volatile.Register32 // 0x0
	BTR1  volatile.Register32 // 0x4
	BCR2  volatile.Register32 // 0x8
	BTR2  volatile.Register32 // 0xC
	BCR3  volatile.Register32 // 0x10
	BTR3  volatile.Register32 // 0x14
	BCR4  volatile.Register32 // 0x18
	BTR4  volatile.Register32 // 0x1C
	_     [96]byte
	PCR   volatile.Register32 // 0x80
	SR    volatile.Register32 // 0x84
	PMEM  volatile.Register32 // 0x88
	PATT  volatile.Register32 // 0x8C
	_     [4]byte
	ECCR  volatile.Register32 // 0x94
	_     [108]byte
	BWTR1 volatile.Register32 // 0x104
	_     [4]byte
	BWTR2 volatile.Register32 // 0x10C
	_     [4]byte
	BWTR3 volatile.Register32 // 0x114
	_     [4]byte
	BWTR4 volatile.Register32 // 0x11C
	_     [32]byte
	SDCR1 volatile.Register32 // 0x140
	SDCR2 volatile.Register32 // 0x144
	SDTR1 volatile.Register32 // 0x148
	SDTR2 volatile.Register32 // 0x14C
	SDCMR volatile.Register32 // 0x150
	SDRTR volatile.Register32 // 0x154
	SDSR  volatile.Register32 // 0x158
}

// FSMC.BCR1: SRAM/NOR-Flash chip-select control register 1
func (o *FSMC_Type) SetBCR1_CCLKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100000)|value<<20)
}
func (o *FSMC_Type) GetBCR1_CCLKEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100000) >> 20
}
func (o *FSMC_Type) SetBCR1_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR1_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR1_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR1_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR1_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR1_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR1_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR1_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR1_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR1_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR1_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR1_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR1_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR1_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR1_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR1_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR1_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR1_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR1_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR1_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR1_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR1_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR1_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR1_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR1_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR1_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR1.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR1_WFDIS(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x200000)|value<<21)
}
func (o *FSMC_Type) GetBCR1_WFDIS() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x200000) >> 21
}
func (o *FSMC_Type) SetBCR1_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR1.Reg, volatile.LoadUint32(&o.BCR1.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR1_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR1.Reg) & 0x70000) >> 16
}

// FSMC.BTR1: SRAM/NOR-Flash chip-select timing register 1
func (o *FSMC_Type) SetBTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR1_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR1_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR1_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR1_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR1.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR1.Reg, volatile.LoadUint32(&o.BTR1.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR1.Reg) & 0xf
}

// FSMC.BCR2: SRAM/NOR-Flash chip-select control register 2
func (o *FSMC_Type) SetBCR2_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR2_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR2_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR2_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR2_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR2_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR2_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR2_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR2_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR2_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR2_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR2_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR2_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR2_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR2_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR2_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR2_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR2_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR2_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR2_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR2_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR2_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR2_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR2_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR2_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR2_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR2.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR2_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR2.Reg, volatile.LoadUint32(&o.BCR2.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR2_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR2.Reg) & 0x70000) >> 16
}

// FSMC.BTR2: SRAM/NOR-Flash chip-select timing register 1
func (o *FSMC_Type) SetBTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR2_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR2_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR2_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR2_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR2.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR2.Reg, volatile.LoadUint32(&o.BTR2.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR2.Reg) & 0xf
}

// FSMC.BCR3: SRAM/NOR-Flash chip-select control register 2
func (o *FSMC_Type) SetBCR3_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR3_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR3_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR3_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR3_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR3_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR3_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR3_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR3_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR3_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR3_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR3_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR3_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR3_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR3_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR3_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR3_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR3_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR3_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR3_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR3_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR3_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR3_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR3_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR3_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR3_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR3.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR3_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR3.Reg, volatile.LoadUint32(&o.BCR3.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR3_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR3.Reg) & 0x70000) >> 16
}

// FSMC.BTR3: SRAM/NOR-Flash chip-select timing register 1
func (o *FSMC_Type) SetBTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR3_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR3_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR3_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR3_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR3.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR3.Reg, volatile.LoadUint32(&o.BTR3.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR3.Reg) & 0xf
}

// FSMC.BCR4: SRAM/NOR-Flash chip-select control register 2
func (o *FSMC_Type) SetBCR4_CBURSTRW(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x80000)|value<<19)
}
func (o *FSMC_Type) GetBCR4_CBURSTRW() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x80000) >> 19
}
func (o *FSMC_Type) SetBCR4_ASYNCWAIT(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x8000)|value<<15)
}
func (o *FSMC_Type) GetBCR4_ASYNCWAIT() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x8000) >> 15
}
func (o *FSMC_Type) SetBCR4_EXTMOD(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetBCR4_EXTMOD() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x4000) >> 14
}
func (o *FSMC_Type) SetBCR4_WAITEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2000)|value<<13)
}
func (o *FSMC_Type) GetBCR4_WAITEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2000) >> 13
}
func (o *FSMC_Type) SetBCR4_WREN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetBCR4_WREN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetBCR4_WAITCFG(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x800)|value<<11)
}
func (o *FSMC_Type) GetBCR4_WAITCFG() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x800) >> 11
}
func (o *FSMC_Type) SetBCR4_WAITPOL(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetBCR4_WAITPOL() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetBCR4_BURSTEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x100)|value<<8)
}
func (o *FSMC_Type) GetBCR4_BURSTEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x100) >> 8
}
func (o *FSMC_Type) SetBCR4_FACCEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetBCR4_FACCEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetBCR4_MWID(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetBCR4_MWID() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetBCR4_MTYP(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetBCR4_MTYP() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetBCR4_MUXEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetBCR4_MUXEN() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetBCR4_MBKEN(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetBCR4_MBKEN() uint32 {
	return volatile.LoadUint32(&o.BCR4.Reg) & 0x1
}
func (o *FSMC_Type) SetBCR4_CPSIZE(value uint32) {
	volatile.StoreUint32(&o.BCR4.Reg, volatile.LoadUint32(&o.BCR4.Reg)&^(0x70000)|value<<16)
}
func (o *FSMC_Type) GetBCR4_CPSIZE() uint32 {
	return (volatile.LoadUint32(&o.BCR4.Reg) & 0x70000) >> 16
}

// FSMC.BTR4: SRAM/NOR-Flash chip-select timing register 1
func (o *FSMC_Type) SetBTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBTR4_DATLAT(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetBTR4_DATLAT() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf000000) >> 24
}
func (o *FSMC_Type) SetBTR4_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetBTR4_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetBTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetBTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BTR4.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BTR4.Reg, volatile.LoadUint32(&o.BTR4.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BTR4.Reg) & 0xf
}

// FSMC.PCR: PC Card/NAND Flash control register
func (o *FSMC_Type) SetPCR_ECCPS(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0xe0000)|value<<17)
}
func (o *FSMC_Type) GetPCR_ECCPS() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0xe0000) >> 17
}
func (o *FSMC_Type) SetPCR_TAR(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1e000)|value<<13)
}
func (o *FSMC_Type) GetPCR_TAR() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1e000) >> 13
}
func (o *FSMC_Type) SetPCR_TCLR(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x1e00)|value<<9)
}
func (o *FSMC_Type) GetPCR_TCLR() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x1e00) >> 9
}
func (o *FSMC_Type) SetPCR_ECCEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetPCR_ECCEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetPCR_PWID(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetPCR_PWID() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetPCR_PTYP(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x8)|value<<3)
}
func (o *FSMC_Type) GetPCR_PTYP() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x8) >> 3
}
func (o *FSMC_Type) SetPCR_PBKEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x4)|value<<2)
}
func (o *FSMC_Type) GetPCR_PBKEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x4) >> 2
}
func (o *FSMC_Type) SetPCR_PWAITEN(value uint32) {
	volatile.StoreUint32(&o.PCR.Reg, volatile.LoadUint32(&o.PCR.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetPCR_PWAITEN() uint32 {
	return (volatile.LoadUint32(&o.PCR.Reg) & 0x2) >> 1
}

// FSMC.SR: FIFO status and interrupt register
func (o *FSMC_Type) SetSR_FEMPT(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetSR_FEMPT() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetSR_IFEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *FSMC_Type) GetSR_IFEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *FSMC_Type) SetSR_ILEN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *FSMC_Type) GetSR_ILEN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *FSMC_Type) SetSR_IREN(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *FSMC_Type) GetSR_IREN() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *FSMC_Type) SetSR_IFS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *FSMC_Type) GetSR_IFS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *FSMC_Type) SetSR_ILS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *FSMC_Type) GetSR_ILS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *FSMC_Type) SetSR_IRS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetSR_IRS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// FSMC.PMEM: Common memory space timing register
func (o *FSMC_Type) SetPMEM_MEMHIZ(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff000000)|value<<24)
}
func (o *FSMC_Type) GetPMEM_MEMHIZ() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff000000) >> 24
}
func (o *FSMC_Type) SetPMEM_MEMHOLD(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff0000)|value<<16)
}
func (o *FSMC_Type) GetPMEM_MEMHOLD() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff0000) >> 16
}
func (o *FSMC_Type) SetPMEM_MEMWAIT(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetPMEM_MEMWAIT() uint32 {
	return (volatile.LoadUint32(&o.PMEM.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetPMEM_MEMSET(value uint32) {
	volatile.StoreUint32(&o.PMEM.Reg, volatile.LoadUint32(&o.PMEM.Reg)&^(0xff)|value)
}
func (o *FSMC_Type) GetPMEM_MEMSET() uint32 {
	return volatile.LoadUint32(&o.PMEM.Reg) & 0xff
}

// FSMC.PATT: Attribute memory space timing register
func (o *FSMC_Type) SetPATT_ATTHIZ(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff000000)|value<<24)
}
func (o *FSMC_Type) GetPATT_ATTHIZ() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff000000) >> 24
}
func (o *FSMC_Type) SetPATT_ATTHOLD(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff0000)|value<<16)
}
func (o *FSMC_Type) GetPATT_ATTHOLD() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff0000) >> 16
}
func (o *FSMC_Type) SetPATT_ATTWAIT(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetPATT_ATTWAIT() uint32 {
	return (volatile.LoadUint32(&o.PATT.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetPATT_ATTSET(value uint32) {
	volatile.StoreUint32(&o.PATT.Reg, volatile.LoadUint32(&o.PATT.Reg)&^(0xff)|value)
}
func (o *FSMC_Type) GetPATT_ATTSET() uint32 {
	return volatile.LoadUint32(&o.PATT.Reg) & 0xff
}

// FSMC.ECCR: ECC result register
func (o *FSMC_Type) SetECCR(value uint32) {
	volatile.StoreUint32(&o.ECCR.Reg, value)
}
func (o *FSMC_Type) GetECCR() uint32 {
	return volatile.LoadUint32(&o.ECCR.Reg)
}

// FSMC.BWTR1: SRAM/NOR-Flash write timing registers 1
func (o *FSMC_Type) SetBWTR1_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR1_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR1_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR1_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR1_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR1_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR1_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR1_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR1.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR1_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR1.Reg, volatile.LoadUint32(&o.BWTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR1_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR1.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR2: SRAM/NOR-Flash write timing registers 1
func (o *FSMC_Type) SetBWTR2_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR2_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR2_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR2_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR2_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR2_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR2_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR2_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR2.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR2_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR2.Reg, volatile.LoadUint32(&o.BWTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR2_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR2.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR3: SRAM/NOR-Flash write timing registers 1
func (o *FSMC_Type) SetBWTR3_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR3_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR3_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR3_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR3_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR3_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR3_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR3_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR3.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR3_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR3.Reg, volatile.LoadUint32(&o.BWTR3.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR3_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR3.Reg) & 0xf0000) >> 16
}

// FSMC.BWTR4: SRAM/NOR-Flash write timing registers 1
func (o *FSMC_Type) SetBWTR4_ACCMOD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0x30000000)|value<<28)
}
func (o *FSMC_Type) GetBWTR4_ACCMOD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0x30000000) >> 28
}
func (o *FSMC_Type) SetBWTR4_DATAST(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xff00)|value<<8)
}
func (o *FSMC_Type) GetBWTR4_DATAST() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xff00) >> 8
}
func (o *FSMC_Type) SetBWTR4_ADDHLD(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetBWTR4_ADDHLD() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetBWTR4_ADDSET(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetBWTR4_ADDSET() uint32 {
	return volatile.LoadUint32(&o.BWTR4.Reg) & 0xf
}
func (o *FSMC_Type) SetBWTR4_BUSTURN(value uint32) {
	volatile.StoreUint32(&o.BWTR4.Reg, volatile.LoadUint32(&o.BWTR4.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetBWTR4_BUSTURN() uint32 {
	return (volatile.LoadUint32(&o.BWTR4.Reg) & 0xf0000) >> 16
}

// FSMC.SDCR1: SDRAM Control Register 1
func (o *FSMC_Type) SetSDCR1_NC(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x3)|value)
}
func (o *FSMC_Type) GetSDCR1_NC() uint32 {
	return volatile.LoadUint32(&o.SDCR1.Reg) & 0x3
}
func (o *FSMC_Type) SetSDCR1_NR(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetSDCR1_NR() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetSDCR1_MWID(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetSDCR1_MWID() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetSDCR1_NB(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetSDCR1_NB() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetSDCR1_CAS(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x180)|value<<7)
}
func (o *FSMC_Type) GetSDCR1_CAS() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0x180) >> 7
}
func (o *FSMC_Type) SetSDCR1_WP(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetSDCR1_WP() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetSDCR1_SDCLK(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0xc00)|value<<10)
}
func (o *FSMC_Type) GetSDCR1_SDCLK() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0xc00) >> 10
}
func (o *FSMC_Type) SetSDCR1_RBURST(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetSDCR1_RBURST() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetSDCR1_RPIPE(value uint32) {
	volatile.StoreUint32(&o.SDCR1.Reg, volatile.LoadUint32(&o.SDCR1.Reg)&^(0x6000)|value<<13)
}
func (o *FSMC_Type) GetSDCR1_RPIPE() uint32 {
	return (volatile.LoadUint32(&o.SDCR1.Reg) & 0x6000) >> 13
}

// FSMC.SDCR2: SDRAM Control Register 1
func (o *FSMC_Type) SetSDCR2_NC(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x3)|value)
}
func (o *FSMC_Type) GetSDCR2_NC() uint32 {
	return volatile.LoadUint32(&o.SDCR2.Reg) & 0x3
}
func (o *FSMC_Type) SetSDCR2_NR(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0xc)|value<<2)
}
func (o *FSMC_Type) GetSDCR2_NR() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0xc) >> 2
}
func (o *FSMC_Type) SetSDCR2_MWID(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x30)|value<<4)
}
func (o *FSMC_Type) GetSDCR2_MWID() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0x30) >> 4
}
func (o *FSMC_Type) SetSDCR2_NB(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x40)|value<<6)
}
func (o *FSMC_Type) GetSDCR2_NB() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0x40) >> 6
}
func (o *FSMC_Type) SetSDCR2_CAS(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x180)|value<<7)
}
func (o *FSMC_Type) GetSDCR2_CAS() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0x180) >> 7
}
func (o *FSMC_Type) SetSDCR2_WP(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x200)|value<<9)
}
func (o *FSMC_Type) GetSDCR2_WP() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0x200) >> 9
}
func (o *FSMC_Type) SetSDCR2_SDCLK(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0xc00)|value<<10)
}
func (o *FSMC_Type) GetSDCR2_SDCLK() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0xc00) >> 10
}
func (o *FSMC_Type) SetSDCR2_RBURST(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x1000)|value<<12)
}
func (o *FSMC_Type) GetSDCR2_RBURST() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0x1000) >> 12
}
func (o *FSMC_Type) SetSDCR2_RPIPE(value uint32) {
	volatile.StoreUint32(&o.SDCR2.Reg, volatile.LoadUint32(&o.SDCR2.Reg)&^(0x6000)|value<<13)
}
func (o *FSMC_Type) GetSDCR2_RPIPE() uint32 {
	return (volatile.LoadUint32(&o.SDCR2.Reg) & 0x6000) >> 13
}

// FSMC.SDTR1: SDRAM Timing register 1
func (o *FSMC_Type) SetSDTR1_TMRD(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetSDTR1_TMRD() uint32 {
	return volatile.LoadUint32(&o.SDTR1.Reg) & 0xf
}
func (o *FSMC_Type) SetSDTR1_TXSR(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetSDTR1_TXSR() uint32 {
	return (volatile.LoadUint32(&o.SDTR1.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetSDTR1_TRAS(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf00)|value<<8)
}
func (o *FSMC_Type) GetSDTR1_TRAS() uint32 {
	return (volatile.LoadUint32(&o.SDTR1.Reg) & 0xf00) >> 8
}
func (o *FSMC_Type) SetSDTR1_TRC(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf000)|value<<12)
}
func (o *FSMC_Type) GetSDTR1_TRC() uint32 {
	return (volatile.LoadUint32(&o.SDTR1.Reg) & 0xf000) >> 12
}
func (o *FSMC_Type) SetSDTR1_TWR(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetSDTR1_TWR() uint32 {
	return (volatile.LoadUint32(&o.SDTR1.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetSDTR1_TRP(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetSDTR1_TRP() uint32 {
	return (volatile.LoadUint32(&o.SDTR1.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetSDTR1_TRCD(value uint32) {
	volatile.StoreUint32(&o.SDTR1.Reg, volatile.LoadUint32(&o.SDTR1.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetSDTR1_TRCD() uint32 {
	return (volatile.LoadUint32(&o.SDTR1.Reg) & 0xf000000) >> 24
}

// FSMC.SDTR2: SDRAM Timing register 1
func (o *FSMC_Type) SetSDTR2_TMRD(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf)|value)
}
func (o *FSMC_Type) GetSDTR2_TMRD() uint32 {
	return volatile.LoadUint32(&o.SDTR2.Reg) & 0xf
}
func (o *FSMC_Type) SetSDTR2_TXSR(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf0)|value<<4)
}
func (o *FSMC_Type) GetSDTR2_TXSR() uint32 {
	return (volatile.LoadUint32(&o.SDTR2.Reg) & 0xf0) >> 4
}
func (o *FSMC_Type) SetSDTR2_TRAS(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf00)|value<<8)
}
func (o *FSMC_Type) GetSDTR2_TRAS() uint32 {
	return (volatile.LoadUint32(&o.SDTR2.Reg) & 0xf00) >> 8
}
func (o *FSMC_Type) SetSDTR2_TRC(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf000)|value<<12)
}
func (o *FSMC_Type) GetSDTR2_TRC() uint32 {
	return (volatile.LoadUint32(&o.SDTR2.Reg) & 0xf000) >> 12
}
func (o *FSMC_Type) SetSDTR2_TWR(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf0000)|value<<16)
}
func (o *FSMC_Type) GetSDTR2_TWR() uint32 {
	return (volatile.LoadUint32(&o.SDTR2.Reg) & 0xf0000) >> 16
}
func (o *FSMC_Type) SetSDTR2_TRP(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf00000)|value<<20)
}
func (o *FSMC_Type) GetSDTR2_TRP() uint32 {
	return (volatile.LoadUint32(&o.SDTR2.Reg) & 0xf00000) >> 20
}
func (o *FSMC_Type) SetSDTR2_TRCD(value uint32) {
	volatile.StoreUint32(&o.SDTR2.Reg, volatile.LoadUint32(&o.SDTR2.Reg)&^(0xf000000)|value<<24)
}
func (o *FSMC_Type) GetSDTR2_TRCD() uint32 {
	return (volatile.LoadUint32(&o.SDTR2.Reg) & 0xf000000) >> 24
}

// FSMC.SDCMR: SDRAM Command Mode register
func (o *FSMC_Type) SetSDCMR_MODE(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x7)|value)
}
func (o *FSMC_Type) GetSDCMR_MODE() uint32 {
	return volatile.LoadUint32(&o.SDCMR.Reg) & 0x7
}
func (o *FSMC_Type) SetSDCMR_CTB2(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x8)|value<<3)
}
func (o *FSMC_Type) GetSDCMR_CTB2() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x8) >> 3
}
func (o *FSMC_Type) SetSDCMR_CTB1(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x10)|value<<4)
}
func (o *FSMC_Type) GetSDCMR_CTB1() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x10) >> 4
}
func (o *FSMC_Type) SetSDCMR_NRFS(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x1e0)|value<<5)
}
func (o *FSMC_Type) GetSDCMR_NRFS() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x1e0) >> 5
}
func (o *FSMC_Type) SetSDCMR_MRD(value uint32) {
	volatile.StoreUint32(&o.SDCMR.Reg, volatile.LoadUint32(&o.SDCMR.Reg)&^(0x3ffe00)|value<<9)
}
func (o *FSMC_Type) GetSDCMR_MRD() uint32 {
	return (volatile.LoadUint32(&o.SDCMR.Reg) & 0x3ffe00) >> 9
}

// FSMC.SDRTR: SDRAM Refresh Timer register
func (o *FSMC_Type) SetSDRTR_CRE(value uint32) {
	volatile.StoreUint32(&o.SDRTR.Reg, volatile.LoadUint32(&o.SDRTR.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetSDRTR_CRE() uint32 {
	return volatile.LoadUint32(&o.SDRTR.Reg) & 0x1
}
func (o *FSMC_Type) SetSDRTR_COUNT(value uint32) {
	volatile.StoreUint32(&o.SDRTR.Reg, volatile.LoadUint32(&o.SDRTR.Reg)&^(0x3ffe)|value<<1)
}
func (o *FSMC_Type) GetSDRTR_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SDRTR.Reg) & 0x3ffe) >> 1
}
func (o *FSMC_Type) SetSDRTR_REIE(value uint32) {
	volatile.StoreUint32(&o.SDRTR.Reg, volatile.LoadUint32(&o.SDRTR.Reg)&^(0x4000)|value<<14)
}
func (o *FSMC_Type) GetSDRTR_REIE() uint32 {
	return (volatile.LoadUint32(&o.SDRTR.Reg) & 0x4000) >> 14
}

// FSMC.SDSR: SDRAM Status register
func (o *FSMC_Type) SetSDSR_MODES1(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x6)|value<<1)
}
func (o *FSMC_Type) GetSDSR_MODES1() uint32 {
	return (volatile.LoadUint32(&o.SDSR.Reg) & 0x6) >> 1
}
func (o *FSMC_Type) SetSDSR_MODES2(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x18)|value<<3)
}
func (o *FSMC_Type) GetSDSR_MODES2() uint32 {
	return (volatile.LoadUint32(&o.SDSR.Reg) & 0x18) >> 3
}
func (o *FSMC_Type) SetSDSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x20)|value<<5)
}
func (o *FSMC_Type) GetSDSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SDSR.Reg) & 0x20) >> 5
}
func (o *FSMC_Type) SetSDSR_RE(value uint32) {
	volatile.StoreUint32(&o.SDSR.Reg, volatile.LoadUint32(&o.SDSR.Reg)&^(0x1)|value)
}
func (o *FSMC_Type) GetSDSR_RE() uint32 {
	return volatile.LoadUint32(&o.SDSR.Reg) & 0x1
}

// General-purpose I/Os
type GPIO_Type struct {
	MODER   volatile.Register32 // 0x0
	OTYPER  volatile.Register32 // 0x4
	OSPEEDR volatile.Register32 // 0x8
	PUPDR   volatile.Register32 // 0xC
	IDR     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	BSRR    volatile.Register32 // 0x18
	LCKR    volatile.Register32 // 0x1C
	AFRL    volatile.Register32 // 0x20
	AFRH    volatile.Register32 // 0x24
}

// GPIO.MODER: GPIO port mode register
func (o *GPIO_Type) SetMODER_MODER15(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetMODER_MODER15() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetMODER_MODER14(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetMODER_MODER14() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetMODER_MODER13(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetMODER_MODER13() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetMODER_MODER12(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetMODER_MODER12() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetMODER_MODER11(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetMODER_MODER11() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetMODER_MODER10(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetMODER_MODER10() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetMODER_MODER9(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetMODER_MODER9() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetMODER_MODER8(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetMODER_MODER8() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetMODER_MODER7(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetMODER_MODER7() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetMODER_MODER6(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetMODER_MODER6() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetMODER_MODER5(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetMODER_MODER5() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetMODER_MODER4(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetMODER_MODER4() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetMODER_MODER3(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetMODER_MODER3() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetMODER_MODER2(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetMODER_MODER2() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetMODER_MODER1(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetMODER_MODER1() uint32 {
	return (volatile.LoadUint32(&o.MODER.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetMODER_MODER0(value uint32) {
	volatile.StoreUint32(&o.MODER.Reg, volatile.LoadUint32(&o.MODER.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetMODER_MODER0() uint32 {
	return volatile.LoadUint32(&o.MODER.Reg) & 0x3
}

// GPIO.OTYPER: GPIO port output type register
func (o *GPIO_Type) SetOTYPER_OT15(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOTYPER_OT15() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOTYPER_OT14(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOTYPER_OT14() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOTYPER_OT13(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOTYPER_OT13() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOTYPER_OT12(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOTYPER_OT12() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOTYPER_OT11(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOTYPER_OT11() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOTYPER_OT10(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOTYPER_OT10() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOTYPER_OT9(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOTYPER_OT9() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOTYPER_OT8(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOTYPER_OT8() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOTYPER_OT7(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOTYPER_OT7() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOTYPER_OT6(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOTYPER_OT6() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOTYPER_OT5(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOTYPER_OT5() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOTYPER_OT4(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOTYPER_OT4() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOTYPER_OT3(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOTYPER_OT3() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOTYPER_OT2(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOTYPER_OT2() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOTYPER_OT1(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOTYPER_OT1() uint32 {
	return (volatile.LoadUint32(&o.OTYPER.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOTYPER_OT0(value uint32) {
	volatile.StoreUint32(&o.OTYPER.Reg, volatile.LoadUint32(&o.OTYPER.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOTYPER_OT0() uint32 {
	return volatile.LoadUint32(&o.OTYPER.Reg) & 0x1
}

// GPIO.OSPEEDR: GPIO port output speed register
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR15(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR15() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR14(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR14() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR13(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR13() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR12(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR12() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR11(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR11() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR10(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR10() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR9(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR9() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR8(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR8() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR7(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR7() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR6(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR6() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR5(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR5() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR4(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR4() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR3(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR3() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR2(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR2() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR1(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR1() uint32 {
	return (volatile.LoadUint32(&o.OSPEEDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetOSPEEDR_OSPEEDR0(value uint32) {
	volatile.StoreUint32(&o.OSPEEDR.Reg, volatile.LoadUint32(&o.OSPEEDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetOSPEEDR_OSPEEDR0() uint32 {
	return volatile.LoadUint32(&o.OSPEEDR.Reg) & 0x3
}

// GPIO.PUPDR: GPIO port pull-up/pull-down register
func (o *GPIO_Type) SetPUPDR_PUPDR15(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPIO_Type) GetPUPDR_PUPDR15() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000000) >> 30
}
func (o *GPIO_Type) SetPUPDR_PUPDR14(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000000)|value<<28)
}
func (o *GPIO_Type) GetPUPDR_PUPDR14() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000000) >> 28
}
func (o *GPIO_Type) SetPUPDR_PUPDR13(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000000)|value<<26)
}
func (o *GPIO_Type) GetPUPDR_PUPDR13() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000000) >> 26
}
func (o *GPIO_Type) SetPUPDR_PUPDR12(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPIO_Type) GetPUPDR_PUPDR12() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000000) >> 24
}
func (o *GPIO_Type) SetPUPDR_PUPDR11(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00000)|value<<22)
}
func (o *GPIO_Type) GetPUPDR_PUPDR11() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00000) >> 22
}
func (o *GPIO_Type) SetPUPDR_PUPDR10(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300000)|value<<20)
}
func (o *GPIO_Type) GetPUPDR_PUPDR10() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300000) >> 20
}
func (o *GPIO_Type) SetPUPDR_PUPDR9(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0000)|value<<18)
}
func (o *GPIO_Type) GetPUPDR_PUPDR9() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0000) >> 18
}
func (o *GPIO_Type) SetPUPDR_PUPDR8(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPUPDR_PUPDR8() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30000) >> 16
}
func (o *GPIO_Type) SetPUPDR_PUPDR7(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc000)|value<<14)
}
func (o *GPIO_Type) GetPUPDR_PUPDR7() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc000) >> 14
}
func (o *GPIO_Type) SetPUPDR_PUPDR6(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3000)|value<<12)
}
func (o *GPIO_Type) GetPUPDR_PUPDR6() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x3000) >> 12
}
func (o *GPIO_Type) SetPUPDR_PUPDR5(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc00)|value<<10)
}
func (o *GPIO_Type) GetPUPDR_PUPDR5() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc00) >> 10
}
func (o *GPIO_Type) SetPUPDR_PUPDR4(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x300)|value<<8)
}
func (o *GPIO_Type) GetPUPDR_PUPDR4() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x300) >> 8
}
func (o *GPIO_Type) SetPUPDR_PUPDR3(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc0)|value<<6)
}
func (o *GPIO_Type) GetPUPDR_PUPDR3() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc0) >> 6
}
func (o *GPIO_Type) SetPUPDR_PUPDR2(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x30)|value<<4)
}
func (o *GPIO_Type) GetPUPDR_PUPDR2() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0x30) >> 4
}
func (o *GPIO_Type) SetPUPDR_PUPDR1(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPUPDR_PUPDR1() uint32 {
	return (volatile.LoadUint32(&o.PUPDR.Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPUPDR_PUPDR0(value uint32) {
	volatile.StoreUint32(&o.PUPDR.Reg, volatile.LoadUint32(&o.PUPDR.Reg)&^(0x3)|value)
}
func (o *GPIO_Type) GetPUPDR_PUPDR0() uint32 {
	return volatile.LoadUint32(&o.PUPDR.Reg) & 0x3
}

// GPIO.IDR: GPIO port input data register
func (o *GPIO_Type) SetIDR_IDR15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIDR_IDR15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIDR_IDR14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIDR_IDR14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIDR_IDR13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIDR_IDR13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIDR_IDR12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIDR_IDR12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIDR_IDR11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIDR_IDR11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIDR_IDR10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIDR_IDR10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIDR_IDR9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIDR_IDR9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIDR_IDR8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIDR_IDR8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIDR_IDR7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIDR_IDR7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIDR_IDR6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIDR_IDR6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIDR_IDR5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIDR_IDR5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIDR_IDR4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIDR_IDR4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIDR_IDR3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIDR_IDR3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIDR_IDR2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIDR_IDR2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIDR_IDR1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIDR_IDR1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIDR_IDR0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIDR_IDR0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}

// GPIO.ODR: GPIO port output data register
func (o *GPIO_Type) SetODR_ODR15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetODR_ODR15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetODR_ODR14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetODR_ODR14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetODR_ODR13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetODR_ODR13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetODR_ODR12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetODR_ODR12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetODR_ODR11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetODR_ODR11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetODR_ODR10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetODR_ODR10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetODR_ODR9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetODR_ODR9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetODR_ODR8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetODR_ODR8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetODR_ODR7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetODR_ODR7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetODR_ODR6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetODR_ODR6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetODR_ODR5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetODR_ODR5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetODR_ODR4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetODR_ODR4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetODR_ODR3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetODR_ODR3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetODR_ODR2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetODR_ODR2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetODR_ODR1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetODR_ODR1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetODR_ODR0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetODR_ODR0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}

// GPIO.BSRR: GPIO port bit set/reset register
func (o *GPIO_Type) SetBSRR_BR15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetBSRR_BR15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000000) >> 31
}
func (o *GPIO_Type) SetBSRR_BR14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetBSRR_BR14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetBSRR_BR13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetBSRR_BR13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetBSRR_BR12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetBSRR_BR12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetBSRR_BR11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetBSRR_BR11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetBSRR_BR10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetBSRR_BR10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetBSRR_BR9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetBSRR_BR9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetBSRR_BR8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetBSRR_BR8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetBSRR_BR7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetBSRR_BR7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetBSRR_BR6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetBSRR_BR6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetBSRR_BR5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetBSRR_BR5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetBSRR_BR4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetBSRR_BR4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetBSRR_BR3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetBSRR_BR3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetBSRR_BR2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetBSRR_BR2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetBSRR_BR1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetBSRR_BR1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetBSRR_BR0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetBSRR_BR0() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetBSRR_BS15(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetBSRR_BS15() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetBSRR_BS14(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetBSRR_BS14() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetBSRR_BS13(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetBSRR_BS13() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetBSRR_BS12(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetBSRR_BS12() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetBSRR_BS11(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetBSRR_BS11() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetBSRR_BS10(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetBSRR_BS10() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetBSRR_BS9(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetBSRR_BS9() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetBSRR_BS8(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetBSRR_BS8() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetBSRR_BS7(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetBSRR_BS7() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetBSRR_BS6(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetBSRR_BS6() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetBSRR_BS5(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetBSRR_BS5() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetBSRR_BS4(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetBSRR_BS4() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetBSRR_BS3(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetBSRR_BS3() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetBSRR_BS2(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetBSRR_BS2() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetBSRR_BS1(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetBSRR_BS1() uint32 {
	return (volatile.LoadUint32(&o.BSRR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetBSRR_BS0(value uint32) {
	volatile.StoreUint32(&o.BSRR.Reg, volatile.LoadUint32(&o.BSRR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetBSRR_BS0() uint32 {
	return volatile.LoadUint32(&o.BSRR.Reg) & 0x1
}

// GPIO.LCKR: GPIO port configuration lock register
func (o *GPIO_Type) SetLCKR_LCKK(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLCKR_LCKK() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLCKR_LCK15(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLCKR_LCK15() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLCKR_LCK14(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLCKR_LCK14() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLCKR_LCK13(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLCKR_LCK13() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLCKR_LCK12(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLCKR_LCK12() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLCKR_LCK11(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLCKR_LCK11() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLCKR_LCK10(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLCKR_LCK10() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLCKR_LCK9(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLCKR_LCK9() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLCKR_LCK8(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLCKR_LCK8() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLCKR_LCK7(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLCKR_LCK7() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLCKR_LCK6(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLCKR_LCK6() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLCKR_LCK5(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLCKR_LCK5() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLCKR_LCK4(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLCKR_LCK4() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLCKR_LCK3(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLCKR_LCK3() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLCKR_LCK2(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLCKR_LCK2() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLCKR_LCK1(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLCKR_LCK1() uint32 {
	return (volatile.LoadUint32(&o.LCKR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLCKR_LCK0(value uint32) {
	volatile.StoreUint32(&o.LCKR.Reg, volatile.LoadUint32(&o.LCKR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLCKR_LCK0() uint32 {
	return volatile.LoadUint32(&o.LCKR.Reg) & 0x1
}

// GPIO.AFRL: GPIO alternate function lowregister
func (o *GPIO_Type) SetAFRL_AFRL7(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRL_AFRL7() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRL_AFRL6(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRL_AFRL6() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRL_AFRL5(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRL_AFRL5() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRL_AFRL4(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRL_AFRL4() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRL_AFRL3(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRL_AFRL3() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRL_AFRL2(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRL_AFRL2() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRL_AFRL1(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRL_AFRL1() uint32 {
	return (volatile.LoadUint32(&o.AFRL.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRL_AFRL0(value uint32) {
	volatile.StoreUint32(&o.AFRL.Reg, volatile.LoadUint32(&o.AFRL.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRL_AFRL0() uint32 {
	return volatile.LoadUint32(&o.AFRL.Reg) & 0xf
}

// GPIO.AFRH: GPIO alternate function high register
func (o *GPIO_Type) SetAFRH_AFRH15(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000000)|value<<28)
}
func (o *GPIO_Type) GetAFRH_AFRH15() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000000) >> 28
}
func (o *GPIO_Type) SetAFRH_AFRH14(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000000)|value<<24)
}
func (o *GPIO_Type) GetAFRH_AFRH14() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000000) >> 24
}
func (o *GPIO_Type) SetAFRH_AFRH13(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00000)|value<<20)
}
func (o *GPIO_Type) GetAFRH_AFRH13() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00000) >> 20
}
func (o *GPIO_Type) SetAFRH_AFRH12(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0000)|value<<16)
}
func (o *GPIO_Type) GetAFRH_AFRH12() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0000) >> 16
}
func (o *GPIO_Type) SetAFRH_AFRH11(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf000)|value<<12)
}
func (o *GPIO_Type) GetAFRH_AFRH11() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf000) >> 12
}
func (o *GPIO_Type) SetAFRH_AFRH10(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf00)|value<<8)
}
func (o *GPIO_Type) GetAFRH_AFRH10() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf00) >> 8
}
func (o *GPIO_Type) SetAFRH_AFRH9(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf0)|value<<4)
}
func (o *GPIO_Type) GetAFRH_AFRH9() uint32 {
	return (volatile.LoadUint32(&o.AFRH.Reg) & 0xf0) >> 4
}
func (o *GPIO_Type) SetAFRH_AFRH8(value uint32) {
	volatile.StoreUint32(&o.AFRH.Reg, volatile.LoadUint32(&o.AFRH.Reg)&^(0xf)|value)
}
func (o *GPIO_Type) GetAFRH_AFRH8() uint32 {
	return volatile.LoadUint32(&o.AFRH.Reg) & 0xf
}

// Independent watchdog
type IWDG_Type struct {
	KR   volatile.Register32 // 0x0
	PR   volatile.Register32 // 0x4
	RLR  volatile.Register32 // 0x8
	SR   volatile.Register32 // 0xC
	WINR volatile.Register32 // 0x10
}

// IWDG.KR: Key register
func (o *IWDG_Type) SetKR_KEY(value uint32) {
	volatile.StoreUint32(&o.KR.Reg, volatile.LoadUint32(&o.KR.Reg)&^(0xffff)|value)
}
func (o *IWDG_Type) GetKR_KEY() uint32 {
	return volatile.LoadUint32(&o.KR.Reg) & 0xffff
}

// IWDG.PR: Prescaler register
func (o *IWDG_Type) SetPR(value uint32) {
	volatile.StoreUint32(&o.PR.Reg, volatile.LoadUint32(&o.PR.Reg)&^(0x7)|value)
}
func (o *IWDG_Type) GetPR() uint32 {
	return volatile.LoadUint32(&o.PR.Reg) & 0x7
}

// IWDG.RLR: Reload register
func (o *IWDG_Type) SetRLR_RL(value uint32) {
	volatile.StoreUint32(&o.RLR.Reg, volatile.LoadUint32(&o.RLR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetRLR_RL() uint32 {
	return volatile.LoadUint32(&o.RLR.Reg) & 0xfff
}

// IWDG.SR: Status register
func (o *IWDG_Type) SetSR_RVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *IWDG_Type) GetSR_RVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *IWDG_Type) SetSR_PVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *IWDG_Type) GetSR_PVU() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *IWDG_Type) SetSR_WVU(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *IWDG_Type) GetSR_WVU() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}

// IWDG.WINR: Window register
func (o *IWDG_Type) SetWINR_WIN(value uint32) {
	volatile.StoreUint32(&o.WINR.Reg, volatile.LoadUint32(&o.WINR.Reg)&^(0xfff)|value)
}
func (o *IWDG_Type) GetWINR_WIN() uint32 {
	return volatile.LoadUint32(&o.WINR.Reg) & 0xfff
}

// Inter-integrated circuit
type I2C_Type struct {
	CR1      volatile.Register32 // 0x0
	CR2      volatile.Register32 // 0x4
	OAR1     volatile.Register32 // 0x8
	OAR2     volatile.Register32 // 0xC
	TIMINGR  volatile.Register32 // 0x10
	TIMEOUTR volatile.Register32 // 0x14
	ISR      volatile.Register32 // 0x18
	ICR      volatile.Register32 // 0x1C
	PECR     volatile.Register32 // 0x20
	RXDR     volatile.Register32 // 0x24
	TXDR     volatile.Register32 // 0x28
}

// I2C.CR1: Control register 1
func (o *I2C_Type) SetCR1_PE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetCR1_PE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *I2C_Type) SetCR1_TXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetCR1_TXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetCR1_RXIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetCR1_RXIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetCR1_ADDRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetCR1_ADDRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetCR1_NACKIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetCR1_NACKIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetCR1_STOPIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetCR1_STOPIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetCR1_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetCR1_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetCR1_DNF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00)|value<<8)
}
func (o *I2C_Type) GetCR1_DNF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00) >> 8
}
func (o *I2C_Type) SetCR1_ANFOFF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR1_ANFOFF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR1_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR1_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR1_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR1_RXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR1_SBC(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetCR1_SBC() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetCR1_NOSTRETCH(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *I2C_Type) GetCR1_NOSTRETCH() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *I2C_Type) SetCR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *I2C_Type) GetCR1_GCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *I2C_Type) SetCR1_SMBHEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100000)|value<<20)
}
func (o *I2C_Type) GetCR1_SMBHEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100000) >> 20
}
func (o *I2C_Type) SetCR1_SMBDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200000)|value<<21)
}
func (o *I2C_Type) GetCR1_SMBDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200000) >> 21
}
func (o *I2C_Type) SetCR1_ALERTEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400000)|value<<22)
}
func (o *I2C_Type) GetCR1_ALERTEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400000) >> 22
}
func (o *I2C_Type) SetCR1_PECEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800000)|value<<23)
}
func (o *I2C_Type) GetCR1_PECEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800000) >> 23
}

// I2C.CR2: Control register 2
func (o *I2C_Type) SetCR2_PECBYTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000000)|value<<26)
}
func (o *I2C_Type) GetCR2_PECBYTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000000) >> 26
}
func (o *I2C_Type) SetCR2_AUTOEND(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000000)|value<<25)
}
func (o *I2C_Type) GetCR2_AUTOEND() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000000) >> 25
}
func (o *I2C_Type) SetCR2_RELOAD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000000)|value<<24)
}
func (o *I2C_Type) GetCR2_RELOAD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000000) >> 24
}
func (o *I2C_Type) SetCR2_NBYTES(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff0000)|value<<16)
}
func (o *I2C_Type) GetCR2_NBYTES() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff0000) >> 16
}
func (o *I2C_Type) SetCR2_NACK(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetCR2_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *I2C_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *I2C_Type) SetCR2_START(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetCR2_START() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetCR2_HEAD10R(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetCR2_HEAD10R() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetCR2_ADD10(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetCR2_ADD10() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetCR2_RD_WRN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetCR2_RD_WRN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetCR2_SADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetCR2_SADD() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x3ff
}

// I2C.OAR1: Own address register 1
func (o *I2C_Type) SetOAR1_OA1(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x3ff)|value)
}
func (o *I2C_Type) GetOAR1_OA1() uint32 {
	return volatile.LoadUint32(&o.OAR1.Reg) & 0x3ff
}
func (o *I2C_Type) SetOAR1_OA1MODE(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetOAR1_OA1MODE() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetOAR1_OA1EN(value uint32) {
	volatile.StoreUint32(&o.OAR1.Reg, volatile.LoadUint32(&o.OAR1.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR1_OA1EN() uint32 {
	return (volatile.LoadUint32(&o.OAR1.Reg) & 0x8000) >> 15
}

// I2C.OAR2: Own address register 2
func (o *I2C_Type) SetOAR2_OA2(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0xfe)|value<<1)
}
func (o *I2C_Type) GetOAR2_OA2() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0xfe) >> 1
}
func (o *I2C_Type) SetOAR2_OA2MSK(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x700)|value<<8)
}
func (o *I2C_Type) GetOAR2_OA2MSK() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x700) >> 8
}
func (o *I2C_Type) SetOAR2_OA2EN(value uint32) {
	volatile.StoreUint32(&o.OAR2.Reg, volatile.LoadUint32(&o.OAR2.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetOAR2_OA2EN() uint32 {
	return (volatile.LoadUint32(&o.OAR2.Reg) & 0x8000) >> 15
}

// I2C.TIMINGR: Timing register
func (o *I2C_Type) SetTIMINGR_SCLL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTIMINGR_SCLL() uint32 {
	return volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff
}
func (o *I2C_Type) SetTIMINGR_SCLH(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xff00)|value<<8)
}
func (o *I2C_Type) GetTIMINGR_SCLH() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xff00) >> 8
}
func (o *I2C_Type) SetTIMINGR_SDADEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000)|value<<16)
}
func (o *I2C_Type) GetTIMINGR_SDADEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000) >> 16
}
func (o *I2C_Type) SetTIMINGR_SCLDEL(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf00000)|value<<20)
}
func (o *I2C_Type) GetTIMINGR_SCLDEL() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf00000) >> 20
}
func (o *I2C_Type) SetTIMINGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.TIMINGR.Reg, volatile.LoadUint32(&o.TIMINGR.Reg)&^(0xf0000000)|value<<28)
}
func (o *I2C_Type) GetTIMINGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.TIMINGR.Reg) & 0xf0000000) >> 28
}

// I2C.TIMEOUTR: Status register 1
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTA(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff)|value)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTA() uint32 {
	return volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff
}
func (o *I2C_Type) SetTIMEOUTR_TIDLE(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetTIMEOUTR_TIDLE() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetTIMEOUTR_TIMOUTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetTIMEOUTR_TIMOUTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetTIMEOUTR_TIMEOUTB(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0xfff0000)|value<<16)
}
func (o *I2C_Type) GetTIMEOUTR_TIMEOUTB() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0xfff0000) >> 16
}
func (o *I2C_Type) SetTIMEOUTR_TEXTEN(value uint32) {
	volatile.StoreUint32(&o.TIMEOUTR.Reg, volatile.LoadUint32(&o.TIMEOUTR.Reg)&^(0x80000000)|value<<31)
}
func (o *I2C_Type) GetTIMEOUTR_TEXTEN() uint32 {
	return (volatile.LoadUint32(&o.TIMEOUTR.Reg) & 0x80000000) >> 31
}

// I2C.ISR: Interrupt and Status register
func (o *I2C_Type) SetISR_ADDCODE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0xfe0000)|value<<17)
}
func (o *I2C_Type) GetISR_ADDCODE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0xfe0000) >> 17
}
func (o *I2C_Type) SetISR_DIR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *I2C_Type) GetISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *I2C_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *I2C_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *I2C_Type) SetISR_ALERT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetISR_ALERT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetISR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetISR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetISR_PECERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetISR_PECERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetISR_OVR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetISR_OVR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetISR_ARLO(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetISR_ARLO() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetISR_BERR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetISR_BERR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetISR_TCR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *I2C_Type) GetISR_TCR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *I2C_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *I2C_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *I2C_Type) SetISR_STOPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetISR_STOPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetISR_NACKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetISR_NACKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetISR_ADDR(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetISR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *I2C_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *I2C_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *I2C_Type) SetISR_TXIS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *I2C_Type) GetISR_TXIS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *I2C_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *I2C_Type) GetISR_TXE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// I2C.ICR: Interrupt clear register
func (o *I2C_Type) SetICR_ALERTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2000)|value<<13)
}
func (o *I2C_Type) GetICR_ALERTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2000) >> 13
}
func (o *I2C_Type) SetICR_TIMOUTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *I2C_Type) GetICR_TIMOUTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *I2C_Type) SetICR_PECCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *I2C_Type) GetICR_PECCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *I2C_Type) SetICR_OVRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *I2C_Type) GetICR_OVRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *I2C_Type) SetICR_ARLOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *I2C_Type) GetICR_ARLOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *I2C_Type) SetICR_BERRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *I2C_Type) GetICR_BERRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *I2C_Type) SetICR_STOPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *I2C_Type) GetICR_STOPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *I2C_Type) SetICR_NACKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *I2C_Type) GetICR_NACKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *I2C_Type) SetICR_ADDRCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *I2C_Type) GetICR_ADDRCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}

// I2C.PECR: PEC register
func (o *I2C_Type) SetPECR_PEC(value uint32) {
	volatile.StoreUint32(&o.PECR.Reg, volatile.LoadUint32(&o.PECR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetPECR_PEC() uint32 {
	return volatile.LoadUint32(&o.PECR.Reg) & 0xff
}

// I2C.RXDR: Receive data register
func (o *I2C_Type) SetRXDR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RXDR.Reg, volatile.LoadUint32(&o.RXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetRXDR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RXDR.Reg) & 0xff
}

// I2C.TXDR: Transmit data register
func (o *I2C_Type) SetTXDR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.TXDR.Reg, volatile.LoadUint32(&o.TXDR.Reg)&^(0xff)|value)
}
func (o *I2C_Type) GetTXDR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.TXDR.Reg) & 0xff
}

// Low power timer
type LPTIM_Type struct {
	ISR  volatile.Register32 // 0x0
	ICR  volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	CFGR volatile.Register32 // 0xC
	CR   volatile.Register32 // 0x10
	CMP  volatile.Register32 // 0x14
	ARR  volatile.Register32 // 0x18
	CNT  volatile.Register32 // 0x1C
}

// LPTIM.ISR: Interrupt and Status Register
func (o *LPTIM_Type) SetISR_DOWN(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetISR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetISR_UP(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetISR_UP() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetISR_ARROK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetISR_ARROK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetISR_CMPOK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetISR_CMPOK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetISR_EXTTRIG(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetISR_EXTTRIG() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetISR_ARRM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetISR_ARRM() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetISR_CMPM(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetISR_CMPM() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}

// LPTIM.ICR: Interrupt Clear Register
func (o *LPTIM_Type) SetICR_DOWNCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetICR_DOWNCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetICR_UPCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetICR_UPCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetICR_ARROKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetICR_ARROKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetICR_CMPOKCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetICR_CMPOKCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetICR_EXTTRIGCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetICR_EXTTRIGCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetICR_ARRMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetICR_ARRMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetICR_CMPMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetICR_CMPMCF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// LPTIM.IER: Interrupt Enable Register
func (o *LPTIM_Type) SetIER_DOWNIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *LPTIM_Type) GetIER_DOWNIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *LPTIM_Type) SetIER_UPIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *LPTIM_Type) GetIER_UPIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *LPTIM_Type) SetIER_ARROKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *LPTIM_Type) GetIER_ARROKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *LPTIM_Type) SetIER_CMPOKIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *LPTIM_Type) GetIER_CMPOKIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *LPTIM_Type) SetIER_EXTTRIGIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetIER_EXTTRIGIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetIER_ARRMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetIER_ARRMIE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetIER_CMPMIE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetIER_CMPMIE() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}

// LPTIM.CFGR: Configuration Register
func (o *LPTIM_Type) SetCFGR_ENC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1000000)|value<<24)
}
func (o *LPTIM_Type) GetCFGR_ENC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1000000) >> 24
}
func (o *LPTIM_Type) SetCFGR_COUNTMODE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *LPTIM_Type) GetCFGR_COUNTMODE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *LPTIM_Type) SetCFGR_PRELOAD(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x400000)|value<<22)
}
func (o *LPTIM_Type) GetCFGR_PRELOAD() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x400000) >> 22
}
func (o *LPTIM_Type) SetCFGR_WAVPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x200000)|value<<21)
}
func (o *LPTIM_Type) GetCFGR_WAVPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x200000) >> 21
}
func (o *LPTIM_Type) SetCFGR_WAVE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x100000)|value<<20)
}
func (o *LPTIM_Type) GetCFGR_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x100000) >> 20
}
func (o *LPTIM_Type) SetCFGR_TIMOUT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x80000)|value<<19)
}
func (o *LPTIM_Type) GetCFGR_TIMOUT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x80000) >> 19
}
func (o *LPTIM_Type) SetCFGR_TRIGEN(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x60000)|value<<17)
}
func (o *LPTIM_Type) GetCFGR_TRIGEN() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x60000) >> 17
}
func (o *LPTIM_Type) SetCFGR_TRIGSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *LPTIM_Type) GetCFGR_TRIGSEL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *LPTIM_Type) SetCFGR_PRESC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe00)|value<<9)
}
func (o *LPTIM_Type) GetCFGR_PRESC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe00) >> 9
}
func (o *LPTIM_Type) SetCFGR_TRGFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0)|value<<6)
}
func (o *LPTIM_Type) GetCFGR_TRGFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0) >> 6
}
func (o *LPTIM_Type) SetCFGR_CKFLT(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x18)|value<<3)
}
func (o *LPTIM_Type) GetCFGR_CKFLT() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x18) >> 3
}
func (o *LPTIM_Type) SetCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x6)|value<<1)
}
func (o *LPTIM_Type) GetCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x6) >> 1
}
func (o *LPTIM_Type) SetCFGR_CKSEL(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCFGR_CKSEL() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x1
}

// LPTIM.CR: Control Register
func (o *LPTIM_Type) SetCR_CNTSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *LPTIM_Type) GetCR_CNTSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *LPTIM_Type) SetCR_SNGSTRT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *LPTIM_Type) GetCR_SNGSTRT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *LPTIM_Type) SetCR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *LPTIM_Type) GetCR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// LPTIM.CMP: Compare Register
func (o *LPTIM_Type) SetCMP(value uint32) {
	volatile.StoreUint32(&o.CMP.Reg, volatile.LoadUint32(&o.CMP.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCMP() uint32 {
	return volatile.LoadUint32(&o.CMP.Reg) & 0xffff
}

// LPTIM.ARR: Autoreload Register
func (o *LPTIM_Type) SetARR(value uint32) {
	volatile.StoreUint32(&o.ARR.Reg, volatile.LoadUint32(&o.ARR.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetARR() uint32 {
	return volatile.LoadUint32(&o.ARR.Reg) & 0xffff
}

// LPTIM.CNT: Counter Register
func (o *LPTIM_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0xffff)|value)
}
func (o *LPTIM_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0xffff
}

// Power control
type PWR_Type struct {
	CR1  volatile.Register32 // 0x0
	CSR1 volatile.Register32 // 0x4
	CR2  volatile.Register32 // 0x8
	CSR2 volatile.Register32 // 0xC
}

// PWR.CR1: power control register
func (o *PWR_Type) SetCR1_LPDS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR1_LPDS() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *PWR_Type) SetCR1_PDDS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR1_PDDS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR1_CSBF(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR1_CSBF() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR1_PVDE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR1_PVDE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR1_PLS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe0)|value<<5)
}
func (o *PWR_Type) GetCR1_PLS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe0) >> 5
}
func (o *PWR_Type) SetCR1_DBP(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR1_DBP() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR1_FPDS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR1_FPDS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR1_LPUDS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR1_LPUDS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR1_MRUDS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetCR1_MRUDS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetCR1_ADCDC1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCR1_ADCDC1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *PWR_Type) SetCR1_VOS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc000)|value<<14)
}
func (o *PWR_Type) GetCR1_VOS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc000) >> 14
}
func (o *PWR_Type) SetCR1_ODEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWR_Type) GetCR1_ODEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *PWR_Type) SetCR1_ODSWEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWR_Type) GetCR1_ODSWEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *PWR_Type) SetCR1_UDEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc0000)|value<<18)
}
func (o *PWR_Type) GetCR1_UDEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc0000) >> 18
}

// PWR.CSR1: power control/status register
func (o *PWR_Type) SetCSR1_WUIF(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCSR1_WUIF() uint32 {
	return volatile.LoadUint32(&o.CSR1.Reg) & 0x1
}
func (o *PWR_Type) SetCSR1_SBF(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCSR1_SBF() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCSR1_PVDO(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCSR1_PVDO() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCSR1_BRR(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCSR1_BRR() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCSR1_BRE(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCSR1_BRE() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCSR1_VOSRDY(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x4000)|value<<14)
}
func (o *PWR_Type) GetCSR1_VOSRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x4000) >> 14
}
func (o *PWR_Type) SetCSR1_ODRDY(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x10000)|value<<16)
}
func (o *PWR_Type) GetCSR1_ODRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x10000) >> 16
}
func (o *PWR_Type) SetCSR1_ODSWRDY(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x20000)|value<<17)
}
func (o *PWR_Type) GetCSR1_ODSWRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x20000) >> 17
}
func (o *PWR_Type) SetCSR1_UDRDY(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0xc0000)|value<<18)
}
func (o *PWR_Type) GetCSR1_UDRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0xc0000) >> 18
}
func (o *PWR_Type) SetCSR1_EIWUP(value uint32) {
	volatile.StoreUint32(&o.CSR1.Reg, volatile.LoadUint32(&o.CSR1.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCSR1_EIWUP() uint32 {
	return (volatile.LoadUint32(&o.CSR1.Reg) & 0x100) >> 8
}

// PWR.CR2: power control register
func (o *PWR_Type) SetCR2_CWUPF1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCR2_CWUPF1() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *PWR_Type) SetCR2_CWUPF2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCR2_CWUPF2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCR2_CWUPF3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCR2_CWUPF3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCR2_CWUPF4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCR2_CWUPF4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCR2_CWUPF5(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCR2_CWUPF5() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCR2_CWUPF6(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCR2_CWUPF6() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCR2_WUPP1(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCR2_WUPP1() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCR2_WUPP2(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCR2_WUPP2() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCR2_WUPP3(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCR2_WUPP3() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCR2_WUPP4(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetCR2_WUPP4() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetCR2_WUPP5(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetCR2_WUPP5() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetCR2_WUPP6(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCR2_WUPP6() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}

// PWR.CSR2: power control/status register
func (o *PWR_Type) SetCSR2_WUPF1(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x1)|value)
}
func (o *PWR_Type) GetCSR2_WUPF1() uint32 {
	return volatile.LoadUint32(&o.CSR2.Reg) & 0x1
}
func (o *PWR_Type) SetCSR2_WUPF2(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x2)|value<<1)
}
func (o *PWR_Type) GetCSR2_WUPF2() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x2) >> 1
}
func (o *PWR_Type) SetCSR2_WUPF3(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x4)|value<<2)
}
func (o *PWR_Type) GetCSR2_WUPF3() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x4) >> 2
}
func (o *PWR_Type) SetCSR2_WUPF4(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x8)|value<<3)
}
func (o *PWR_Type) GetCSR2_WUPF4() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x8) >> 3
}
func (o *PWR_Type) SetCSR2_WUPF5(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x10)|value<<4)
}
func (o *PWR_Type) GetCSR2_WUPF5() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x10) >> 4
}
func (o *PWR_Type) SetCSR2_WUPF6(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x20)|value<<5)
}
func (o *PWR_Type) GetCSR2_WUPF6() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x20) >> 5
}
func (o *PWR_Type) SetCSR2_EWUP1(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x100)|value<<8)
}
func (o *PWR_Type) GetCSR2_EWUP1() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x100) >> 8
}
func (o *PWR_Type) SetCSR2_EWUP2(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x200)|value<<9)
}
func (o *PWR_Type) GetCSR2_EWUP2() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x200) >> 9
}
func (o *PWR_Type) SetCSR2_EWUP3(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x400)|value<<10)
}
func (o *PWR_Type) GetCSR2_EWUP3() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x400) >> 10
}
func (o *PWR_Type) SetCSR2_EWUP4(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x800)|value<<11)
}
func (o *PWR_Type) GetCSR2_EWUP4() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x800) >> 11
}
func (o *PWR_Type) SetCSR2_EWUP5(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x1000)|value<<12)
}
func (o *PWR_Type) GetCSR2_EWUP5() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x1000) >> 12
}
func (o *PWR_Type) SetCSR2_EWUP6(value uint32) {
	volatile.StoreUint32(&o.CSR2.Reg, volatile.LoadUint32(&o.CSR2.Reg)&^(0x2000)|value<<13)
}
func (o *PWR_Type) GetCSR2_EWUP6() uint32 {
	return (volatile.LoadUint32(&o.CSR2.Reg) & 0x2000) >> 13
}

// QuadSPI interface
type QUADSPI_Type struct {
	CR    volatile.Register32 // 0x0
	DCR   volatile.Register32 // 0x4
	SR    volatile.Register32 // 0x8
	FCR   volatile.Register32 // 0xC
	DLR   volatile.Register32 // 0x10
	CCR   volatile.Register32 // 0x14
	AR    volatile.Register32 // 0x18
	ABR   volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
	PSMKR volatile.Register32 // 0x24
	PSMAR volatile.Register32 // 0x28
	PIR   volatile.Register32 // 0x2C
	LPTR  volatile.Register32 // 0x30
}

// QUADSPI.CR: control register
func (o *QUADSPI_Type) SetCR_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *QUADSPI_Type) GetCR_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}
func (o *QUADSPI_Type) SetCR_PMM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *QUADSPI_Type) GetCR_PMM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *QUADSPI_Type) SetCR_APMS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400000)|value<<22)
}
func (o *QUADSPI_Type) GetCR_APMS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400000) >> 22
}
func (o *QUADSPI_Type) SetCR_TOIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *QUADSPI_Type) GetCR_TOIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *QUADSPI_Type) SetCR_SMIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *QUADSPI_Type) GetCR_SMIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *QUADSPI_Type) SetCR_FTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *QUADSPI_Type) GetCR_FTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *QUADSPI_Type) SetCR_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *QUADSPI_Type) GetCR_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *QUADSPI_Type) SetCR_TEIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *QUADSPI_Type) GetCR_TEIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *QUADSPI_Type) SetCR_FTHRES(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1f00)|value<<8)
}
func (o *QUADSPI_Type) GetCR_FTHRES() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1f00) >> 8
}
func (o *QUADSPI_Type) SetCR_FSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *QUADSPI_Type) GetCR_FSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *QUADSPI_Type) SetCR_DFM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *QUADSPI_Type) GetCR_DFM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *QUADSPI_Type) SetCR_SSHIFT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetCR_SSHIFT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetCR_TCEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetCR_TCEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetCR_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *QUADSPI_Type) GetCR_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *QUADSPI_Type) SetCR_ABORT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetCR_ABORT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// QUADSPI.DCR: device configuration register
func (o *QUADSPI_Type) SetDCR_FSIZE(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1f0000)|value<<16)
}
func (o *QUADSPI_Type) GetDCR_FSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x1f0000) >> 16
}
func (o *QUADSPI_Type) SetDCR_CSHT(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x700)|value<<8)
}
func (o *QUADSPI_Type) GetDCR_CSHT() uint32 {
	return (volatile.LoadUint32(&o.DCR.Reg) & 0x700) >> 8
}
func (o *QUADSPI_Type) SetDCR_CKMODE(value uint32) {
	volatile.StoreUint32(&o.DCR.Reg, volatile.LoadUint32(&o.DCR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetDCR_CKMODE() uint32 {
	return volatile.LoadUint32(&o.DCR.Reg) & 0x1
}

// QUADSPI.SR: status register
func (o *QUADSPI_Type) SetSR_FLEVEL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x7f00)|value<<8)
}
func (o *QUADSPI_Type) GetSR_FLEVEL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x7f00) >> 8
}
func (o *QUADSPI_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *QUADSPI_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *QUADSPI_Type) SetSR_TOF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetSR_TOF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetSR_SMF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetSR_SMF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetSR_FTF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *QUADSPI_Type) GetSR_FTF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *QUADSPI_Type) SetSR_TCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetSR_TCF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetSR_TEF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetSR_TEF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// QUADSPI.FCR: flag clear register
func (o *QUADSPI_Type) SetFCR_CTOF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x10)|value<<4)
}
func (o *QUADSPI_Type) GetFCR_CTOF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x10) >> 4
}
func (o *QUADSPI_Type) SetFCR_CSMF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x8)|value<<3)
}
func (o *QUADSPI_Type) GetFCR_CSMF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x8) >> 3
}
func (o *QUADSPI_Type) SetFCR_CTCF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x2)|value<<1)
}
func (o *QUADSPI_Type) GetFCR_CTCF() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0x2) >> 1
}
func (o *QUADSPI_Type) SetFCR_CTEF(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0x1)|value)
}
func (o *QUADSPI_Type) GetFCR_CTEF() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0x1
}

// QUADSPI.DLR: data length register
func (o *QUADSPI_Type) SetDLR(value uint32) {
	volatile.StoreUint32(&o.DLR.Reg, value)
}
func (o *QUADSPI_Type) GetDLR() uint32 {
	return volatile.LoadUint32(&o.DLR.Reg)
}

// QUADSPI.CCR: communication configuration register
func (o *QUADSPI_Type) SetCCR_DDRM(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x80000000)|value<<31)
}
func (o *QUADSPI_Type) GetCCR_DDRM() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x80000000) >> 31
}
func (o *QUADSPI_Type) SetCCR_DHHC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x40000000)|value<<30)
}
func (o *QUADSPI_Type) GetCCR_DHHC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x40000000) >> 30
}
func (o *QUADSPI_Type) SetCCR_SIOO(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x10000000)|value<<28)
}
func (o *QUADSPI_Type) GetCCR_SIOO() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x10000000) >> 28
}
func (o *QUADSPI_Type) SetCCR_FMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc000000)|value<<26)
}
func (o *QUADSPI_Type) GetCCR_FMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc000000) >> 26
}
func (o *QUADSPI_Type) SetCCR_DMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3000000)|value<<24)
}
func (o *QUADSPI_Type) GetCCR_DMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3000000) >> 24
}
func (o *QUADSPI_Type) SetCCR_DCYC(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x7c0000)|value<<18)
}
func (o *QUADSPI_Type) GetCCR_DCYC() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x7c0000) >> 18
}
func (o *QUADSPI_Type) SetCCR_ABSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x30000)|value<<16)
}
func (o *QUADSPI_Type) GetCCR_ABSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x30000) >> 16
}
func (o *QUADSPI_Type) SetCCR_ABMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc000)|value<<14)
}
func (o *QUADSPI_Type) GetCCR_ABMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc000) >> 14
}
func (o *QUADSPI_Type) SetCCR_ADSIZE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x3000)|value<<12)
}
func (o *QUADSPI_Type) GetCCR_ADSIZE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x3000) >> 12
}
func (o *QUADSPI_Type) SetCCR_ADMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xc00)|value<<10)
}
func (o *QUADSPI_Type) GetCCR_ADMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0xc00) >> 10
}
func (o *QUADSPI_Type) SetCCR_IMODE(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0x300)|value<<8)
}
func (o *QUADSPI_Type) GetCCR_IMODE() uint32 {
	return (volatile.LoadUint32(&o.CCR.Reg) & 0x300) >> 8
}
func (o *QUADSPI_Type) SetCCR_INSTRUCTION(value uint32) {
	volatile.StoreUint32(&o.CCR.Reg, volatile.LoadUint32(&o.CCR.Reg)&^(0xff)|value)
}
func (o *QUADSPI_Type) GetCCR_INSTRUCTION() uint32 {
	return volatile.LoadUint32(&o.CCR.Reg) & 0xff
}

// QUADSPI.AR: address register
func (o *QUADSPI_Type) SetAR(value uint32) {
	volatile.StoreUint32(&o.AR.Reg, value)
}
func (o *QUADSPI_Type) GetAR() uint32 {
	return volatile.LoadUint32(&o.AR.Reg)
}

// QUADSPI.ABR: ABR
func (o *QUADSPI_Type) SetABR(value uint32) {
	volatile.StoreUint32(&o.ABR.Reg, value)
}
func (o *QUADSPI_Type) GetABR() uint32 {
	return volatile.LoadUint32(&o.ABR.Reg)
}

// QUADSPI.DR: data register
func (o *QUADSPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *QUADSPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// QUADSPI.PSMKR: polling status mask register
func (o *QUADSPI_Type) SetPSMKR(value uint32) {
	volatile.StoreUint32(&o.PSMKR.Reg, value)
}
func (o *QUADSPI_Type) GetPSMKR() uint32 {
	return volatile.LoadUint32(&o.PSMKR.Reg)
}

// QUADSPI.PSMAR: polling status match register
func (o *QUADSPI_Type) SetPSMAR(value uint32) {
	volatile.StoreUint32(&o.PSMAR.Reg, value)
}
func (o *QUADSPI_Type) GetPSMAR() uint32 {
	return volatile.LoadUint32(&o.PSMAR.Reg)
}

// QUADSPI.PIR: polling interval register
func (o *QUADSPI_Type) SetPIR_INTERVAL(value uint32) {
	volatile.StoreUint32(&o.PIR.Reg, volatile.LoadUint32(&o.PIR.Reg)&^(0xffff)|value)
}
func (o *QUADSPI_Type) GetPIR_INTERVAL() uint32 {
	return volatile.LoadUint32(&o.PIR.Reg) & 0xffff
}

// QUADSPI.LPTR: low-power timeout register
func (o *QUADSPI_Type) SetLPTR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.LPTR.Reg, volatile.LoadUint32(&o.LPTR.Reg)&^(0xffff)|value)
}
func (o *QUADSPI_Type) GetLPTR_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.LPTR.Reg) & 0xffff
}

// Random number generator
type RNG_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	DR volatile.Register32 // 0x8
}

// RNG.CR: control register
func (o *RNG_Type) SetCR_IE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RNG_Type) GetCR_IE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RNG_Type) SetCR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetCR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}

// RNG.SR: status register
func (o *RNG_Type) SetSR_SEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *RNG_Type) GetSR_SEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *RNG_Type) SetSR_CEIS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *RNG_Type) GetSR_CEIS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *RNG_Type) SetSR_SECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *RNG_Type) GetSR_SECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *RNG_Type) SetSR_CECS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *RNG_Type) GetSR_CECS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *RNG_Type) SetSR_DRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSR_DRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// RNG.DR: data register
func (o *RNG_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *RNG_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// Real-time clock
type RTC_Type struct {
	TR       volatile.Register32 // 0x0
	DR       volatile.Register32 // 0x4
	CR       volatile.Register32 // 0x8
	ISR      volatile.Register32 // 0xC
	PRER     volatile.Register32 // 0x10
	WUTR     volatile.Register32 // 0x14
	_        [4]byte
	ALRMAR   volatile.Register32 // 0x1C
	ALRMBR   volatile.Register32 // 0x20
	WPR      volatile.Register32 // 0x24
	SSR      volatile.Register32 // 0x28
	SHIFTR   volatile.Register32 // 0x2C
	TSTR     volatile.Register32 // 0x30
	TSDR     volatile.Register32 // 0x34
	TSSSR    volatile.Register32 // 0x38
	CALR     volatile.Register32 // 0x3C
	TAMPCR   volatile.Register32 // 0x40
	ALRMASSR volatile.Register32 // 0x44
	ALRMBSSR volatile.Register32 // 0x48
	OR       volatile.Register32 // 0x4C
	BKP0R    volatile.Register32 // 0x50
	BKP1R    volatile.Register32 // 0x54
	BKP2R    volatile.Register32 // 0x58
	BKP3R    volatile.Register32 // 0x5C
	BKP4R    volatile.Register32 // 0x60
	BKP5R    volatile.Register32 // 0x64
	BKP6R    volatile.Register32 // 0x68
	BKP7R    volatile.Register32 // 0x6C
	BKP8R    volatile.Register32 // 0x70
	BKP9R    volatile.Register32 // 0x74
	BKP10R   volatile.Register32 // 0x78
	BKP11R   volatile.Register32 // 0x7C
	BKP12R   volatile.Register32 // 0x80
	BKP13R   volatile.Register32 // 0x84
	BKP14R   volatile.Register32 // 0x88
	BKP15R   volatile.Register32 // 0x8C
	BKP16R   volatile.Register32 // 0x90
	BKP17R   volatile.Register32 // 0x94
	BKP18R   volatile.Register32 // 0x98
	BKP19R   volatile.Register32 // 0x9C
	BKP20R   volatile.Register32 // 0xA0
	BKP21R   volatile.Register32 // 0xA4
	BKP22R   volatile.Register32 // 0xA8
	BKP23R   volatile.Register32 // 0xAC
	BKP24R   volatile.Register32 // 0xB0
	BKP25R   volatile.Register32 // 0xB4
	BKP26R   volatile.Register32 // 0xB8
	BKP27R   volatile.Register32 // 0xBC
	BKP28R   volatile.Register32 // 0xC0
	BKP29R   volatile.Register32 // 0xC4
	BKP30R   volatile.Register32 // 0xC8
	BKP31R   volatile.Register32 // 0xCC
}

// RTC.TR: time register
func (o *RTC_Type) SetTR_PM(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTR_HT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTR_HU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTR_ST(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTR_SU(value uint32) {
	volatile.StoreUint32(&o.TR.Reg, volatile.LoadUint32(&o.TR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTR_SU() uint32 {
	return volatile.LoadUint32(&o.TR.Reg) & 0xf
}

// RTC.DR: date register
func (o *RTC_Type) SetDR_YT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00000)|value<<20)
}
func (o *RTC_Type) GetDR_YT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00000) >> 20
}
func (o *RTC_Type) SetDR_YU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetDR_YU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetDR_WDU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetDR_MT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetDR_MT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetDR_MU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetDR_MU() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetDR_DT(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetDR_DT() uint32 {
	return (volatile.LoadUint32(&o.DR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetDR_DU(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetDR_DU() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xf
}

// RTC.CR: control register
func (o *RTC_Type) SetCR_WUCKSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7)|value)
}
func (o *RTC_Type) GetCR_WUCKSEL() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7
}
func (o *RTC_Type) SetCR_TSEDGE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetCR_TSEDGE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetCR_REFCKON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetCR_REFCKON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetCR_BYPSHAD(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetCR_BYPSHAD() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetCR_FMT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetCR_FMT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetCR_ALRAE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetCR_ALRAE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetCR_ALRBE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetCR_ALRBE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetCR_WUTE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetCR_WUTE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetCR_TSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetCR_TSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetCR_ALRAIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetCR_ALRAIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetCR_ALRBIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCR_ALRBIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCR_WUTIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCR_WUTIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCR_TSIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCR_TSIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCR_ADD1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetCR_ADD1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetCR_SUB1H(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetCR_SUB1H() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetCR_BKP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetCR_BKP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetCR_COSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetCR_COSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetCR_POL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetCR_POL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetCR_OSEL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x600000)|value<<21)
}
func (o *RTC_Type) GetCR_OSEL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x600000) >> 21
}
func (o *RTC_Type) SetCR_COE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetCR_COE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetCR_ITSE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_Type) GetCR_ITSE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// RTC.ISR: initialization and status register
func (o *RTC_Type) SetISR_ALRAWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetISR_ALRAWF() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *RTC_Type) SetISR_ALRBWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetISR_ALRBWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetISR_WUTWF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetISR_WUTWF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetISR_SHPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetISR_SHPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetISR_INITS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetISR_INITS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetISR_RSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetISR_RSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetISR_INITF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetISR_INITF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetISR_INIT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetISR_INIT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetISR_ALRAF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_Type) GetISR_ALRAF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *RTC_Type) SetISR_ALRBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_Type) GetISR_ALRBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *RTC_Type) SetISR_WUTF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *RTC_Type) GetISR_WUTF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *RTC_Type) SetISR_TSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *RTC_Type) GetISR_TSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *RTC_Type) SetISR_TSOVF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetISR_TSOVF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetISR_TAMP1F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetISR_TAMP1F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetISR_TAMP2F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetISR_TAMP2F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetISR_TAMP3F(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetISR_TAMP3F() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetISR_RECALPF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetISR_RECALPF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetISR_ITSF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetISR_ITSF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}

// RTC.PRER: prescaler register
func (o *RTC_Type) SetPRER_PREDIV_A(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7f0000)|value<<16)
}
func (o *RTC_Type) GetPRER_PREDIV_A() uint32 {
	return (volatile.LoadUint32(&o.PRER.Reg) & 0x7f0000) >> 16
}
func (o *RTC_Type) SetPRER_PREDIV_S(value uint32) {
	volatile.StoreUint32(&o.PRER.Reg, volatile.LoadUint32(&o.PRER.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetPRER_PREDIV_S() uint32 {
	return volatile.LoadUint32(&o.PRER.Reg) & 0x7fff
}

// RTC.WUTR: wakeup timer register
func (o *RTC_Type) SetWUTR_WUT(value uint32) {
	volatile.StoreUint32(&o.WUTR.Reg, volatile.LoadUint32(&o.WUTR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetWUTR_WUT() uint32 {
	return volatile.LoadUint32(&o.WUTR.Reg) & 0xffff
}

// RTC.ALRMAR: alarm A register
func (o *RTC_Type) SetALRMAR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMAR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMAR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMAR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMAR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMAR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMAR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMAR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMAR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMAR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMAR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMAR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMAR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMAR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMAR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMAR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMAR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMAR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMAR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMAR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMAR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMAR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMAR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMAR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMAR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMAR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMAR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMAR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMAR.Reg, volatile.LoadUint32(&o.ALRMAR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMAR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMAR.Reg) & 0xf
}

// RTC.ALRMBR: alarm B register
func (o *RTC_Type) SetALRMBR_MSK4(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetALRMBR_MSK4() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetALRMBR_WDSEL(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x40000000)|value<<30)
}
func (o *RTC_Type) GetALRMBR_WDSEL() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x40000000) >> 30
}
func (o *RTC_Type) SetALRMBR_DT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x30000000)|value<<28)
}
func (o *RTC_Type) GetALRMBR_DT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x30000000) >> 28
}
func (o *RTC_Type) SetALRMBR_DU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBR_DU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBR_MSK3(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetALRMBR_MSK3() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetALRMBR_PM(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetALRMBR_PM() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetALRMBR_HT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetALRMBR_HT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetALRMBR_HU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetALRMBR_HU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetALRMBR_MSK2(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetALRMBR_MSK2() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetALRMBR_MNT(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetALRMBR_MNT() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetALRMBR_MNU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetALRMBR_MNU() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetALRMBR_MSK1(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetALRMBR_MSK1() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetALRMBR_ST(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetALRMBR_ST() uint32 {
	return (volatile.LoadUint32(&o.ALRMBR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetALRMBR_SU(value uint32) {
	volatile.StoreUint32(&o.ALRMBR.Reg, volatile.LoadUint32(&o.ALRMBR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetALRMBR_SU() uint32 {
	return volatile.LoadUint32(&o.ALRMBR.Reg) & 0xf
}

// RTC.WPR: write protection register
func (o *RTC_Type) SetWPR_KEY(value uint32) {
	volatile.StoreUint32(&o.WPR.Reg, volatile.LoadUint32(&o.WPR.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetWPR_KEY() uint32 {
	return volatile.LoadUint32(&o.WPR.Reg) & 0xff
}

// RTC.SSR: sub second register
func (o *RTC_Type) SetSSR_SS(value uint32) {
	volatile.StoreUint32(&o.SSR.Reg, volatile.LoadUint32(&o.SSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetSSR_SS() uint32 {
	return volatile.LoadUint32(&o.SSR.Reg) & 0xffff
}

// RTC.SHIFTR: shift control register
func (o *RTC_Type) SetSHIFTR_ADD1S(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_Type) GetSHIFTR_ADD1S() uint32 {
	return (volatile.LoadUint32(&o.SHIFTR.Reg) & 0x80000000) >> 31
}
func (o *RTC_Type) SetSHIFTR_SUBFS(value uint32) {
	volatile.StoreUint32(&o.SHIFTR.Reg, volatile.LoadUint32(&o.SHIFTR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetSHIFTR_SUBFS() uint32 {
	return volatile.LoadUint32(&o.SHIFTR.Reg) & 0x7fff
}

// RTC.TSTR: time stamp time register
func (o *RTC_Type) SetTSTR_SU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSTR_SU() uint32 {
	return volatile.LoadUint32(&o.TSTR.Reg) & 0xf
}
func (o *RTC_Type) SetTSTR_ST(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x70)|value<<4)
}
func (o *RTC_Type) GetTSTR_ST() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x70) >> 4
}
func (o *RTC_Type) SetTSTR_MNU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSTR_MNU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSTR_MNT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_Type) GetTSTR_MNT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x7000) >> 12
}
func (o *RTC_Type) SetTSTR_HU(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0xf0000)|value<<16)
}
func (o *RTC_Type) GetTSTR_HU() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0xf0000) >> 16
}
func (o *RTC_Type) SetTSTR_HT(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x300000)|value<<20)
}
func (o *RTC_Type) GetTSTR_HT() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x300000) >> 20
}
func (o *RTC_Type) SetTSTR_PM(value uint32) {
	volatile.StoreUint32(&o.TSTR.Reg, volatile.LoadUint32(&o.TSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTSTR_PM() uint32 {
	return (volatile.LoadUint32(&o.TSTR.Reg) & 0x400000) >> 22
}

// RTC.TSDR: time stamp date register
func (o *RTC_Type) SetTSDR_WDU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xe000)|value<<13)
}
func (o *RTC_Type) GetTSDR_WDU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xe000) >> 13
}
func (o *RTC_Type) SetTSDR_MT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x1000)|value<<12)
}
func (o *RTC_Type) GetTSDR_MT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x1000) >> 12
}
func (o *RTC_Type) SetTSDR_MU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_Type) GetTSDR_MU() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0xf00) >> 8
}
func (o *RTC_Type) SetTSDR_DT(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetTSDR_DT() uint32 {
	return (volatile.LoadUint32(&o.TSDR.Reg) & 0x30) >> 4
}
func (o *RTC_Type) SetTSDR_DU(value uint32) {
	volatile.StoreUint32(&o.TSDR.Reg, volatile.LoadUint32(&o.TSDR.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetTSDR_DU() uint32 {
	return volatile.LoadUint32(&o.TSDR.Reg) & 0xf
}

// RTC.TSSSR: timestamp sub second register
func (o *RTC_Type) SetTSSSR_SS(value uint32) {
	volatile.StoreUint32(&o.TSSSR.Reg, volatile.LoadUint32(&o.TSSSR.Reg)&^(0xffff)|value)
}
func (o *RTC_Type) GetTSSSR_SS() uint32 {
	return volatile.LoadUint32(&o.TSSSR.Reg) & 0xffff
}

// RTC.CALR: calibration register
func (o *RTC_Type) SetCALR_CALP(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetCALR_CALP() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetCALR_CALW8(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_Type) GetCALR_CALW8() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x4000) >> 14
}
func (o *RTC_Type) SetCALR_CALW16(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_Type) GetCALR_CALW16() uint32 {
	return (volatile.LoadUint32(&o.CALR.Reg) & 0x2000) >> 13
}
func (o *RTC_Type) SetCALR_CALM(value uint32) {
	volatile.StoreUint32(&o.CALR.Reg, volatile.LoadUint32(&o.CALR.Reg)&^(0x1ff)|value)
}
func (o *RTC_Type) GetCALR_CALM() uint32 {
	return volatile.LoadUint32(&o.CALR.Reg) & 0x1ff
}

// RTC.TAMPCR: tamper configuration register
func (o *RTC_Type) SetTAMPCR_TAMP1E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTAMPCR_TAMP1E() uint32 {
	return volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1
}
func (o *RTC_Type) SetTAMPCR_TAMP1TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetTAMPCR_TAMP1TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetTAMPCR_TAMPIE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetTAMPCR_TAMPIE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetTAMPCR_TAMP2E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetTAMPCR_TAMP2E() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetTAMPCR_TAMP2TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetTAMPCR_TAMP2TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetTAMPCR_TAMP3E(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetTAMPCR_TAMP3E() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetTAMPCR_TAMP3TRG(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetTAMPCR_TAMP3TRG() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetTAMPCR_TAMPTS(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetTAMPCR_TAMPTS() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x80) >> 7
}
func (o *RTC_Type) SetTAMPCR_TAMPFREQ(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x700)|value<<8)
}
func (o *RTC_Type) GetTAMPCR_TAMPFREQ() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x700) >> 8
}
func (o *RTC_Type) SetTAMPCR_TAMPFLT(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1800)|value<<11)
}
func (o *RTC_Type) GetTAMPCR_TAMPFLT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1800) >> 11
}
func (o *RTC_Type) SetTAMPCR_TAMPPRCH(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x6000)|value<<13)
}
func (o *RTC_Type) GetTAMPCR_TAMPPRCH() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x6000) >> 13
}
func (o *RTC_Type) SetTAMPCR_TAMPPUDIS(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_Type) GetTAMPCR_TAMPPUDIS() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x8000) >> 15
}
func (o *RTC_Type) SetTAMPCR_TAMP1IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetTAMPCR_TAMP1IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetTAMPCR_TAMP1NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetTAMPCR_TAMP1NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetTAMPCR_TAMP1MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetTAMPCR_TAMP1MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetTAMPCR_TAMP2IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetTAMPCR_TAMP2IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x80000) >> 19
}
func (o *RTC_Type) SetTAMPCR_TAMP2NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_Type) GetTAMPCR_TAMP2NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x100000) >> 20
}
func (o *RTC_Type) SetTAMPCR_TAMP2MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x200000)|value<<21)
}
func (o *RTC_Type) GetTAMPCR_TAMP2MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x200000) >> 21
}
func (o *RTC_Type) SetTAMPCR_TAMP3IE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x400000)|value<<22)
}
func (o *RTC_Type) GetTAMPCR_TAMP3IE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x400000) >> 22
}
func (o *RTC_Type) SetTAMPCR_TAMP3NOERASE(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x800000)|value<<23)
}
func (o *RTC_Type) GetTAMPCR_TAMP3NOERASE() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x800000) >> 23
}
func (o *RTC_Type) SetTAMPCR_TAMP3MF(value uint32) {
	volatile.StoreUint32(&o.TAMPCR.Reg, volatile.LoadUint32(&o.TAMPCR.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_Type) GetTAMPCR_TAMP3MF() uint32 {
	return (volatile.LoadUint32(&o.TAMPCR.Reg) & 0x1000000) >> 24
}

// RTC.ALRMASSR: alarm A sub second register
func (o *RTC_Type) SetALRMASSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMASSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMASSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMASSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMASSR.Reg, volatile.LoadUint32(&o.ALRMASSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMASSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMASSR.Reg) & 0x7fff
}

// RTC.ALRMBSSR: alarm B sub second register
func (o *RTC_Type) SetALRMBSSR_MASKSS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0xf000000)|value<<24)
}
func (o *RTC_Type) GetALRMBSSR_MASKSS() uint32 {
	return (volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0xf000000) >> 24
}
func (o *RTC_Type) SetALRMBSSR_SS(value uint32) {
	volatile.StoreUint32(&o.ALRMBSSR.Reg, volatile.LoadUint32(&o.ALRMBSSR.Reg)&^(0x7fff)|value)
}
func (o *RTC_Type) GetALRMBSSR_SS() uint32 {
	return volatile.LoadUint32(&o.ALRMBSSR.Reg) & 0x7fff
}

// RTC.OR: option register
func (o *RTC_Type) SetOR_RTC_ALARM_TYPE(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetOR_RTC_ALARM_TYPE() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetOR_TSINSEL(value uint32) {
	volatile.StoreUint32(&o.OR.Reg, volatile.LoadUint32(&o.OR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetOR_TSINSEL() uint32 {
	return (volatile.LoadUint32(&o.OR.Reg) & 0x2) >> 1
}

// RTC.BKP0R: backup register
func (o *RTC_Type) SetBKP0R(value uint32) {
	volatile.StoreUint32(&o.BKP0R.Reg, value)
}
func (o *RTC_Type) GetBKP0R() uint32 {
	return volatile.LoadUint32(&o.BKP0R.Reg)
}

// RTC.BKP1R: backup register
func (o *RTC_Type) SetBKP1R(value uint32) {
	volatile.StoreUint32(&o.BKP1R.Reg, value)
}
func (o *RTC_Type) GetBKP1R() uint32 {
	return volatile.LoadUint32(&o.BKP1R.Reg)
}

// RTC.BKP2R: backup register
func (o *RTC_Type) SetBKP2R(value uint32) {
	volatile.StoreUint32(&o.BKP2R.Reg, value)
}
func (o *RTC_Type) GetBKP2R() uint32 {
	return volatile.LoadUint32(&o.BKP2R.Reg)
}

// RTC.BKP3R: backup register
func (o *RTC_Type) SetBKP3R(value uint32) {
	volatile.StoreUint32(&o.BKP3R.Reg, value)
}
func (o *RTC_Type) GetBKP3R() uint32 {
	return volatile.LoadUint32(&o.BKP3R.Reg)
}

// RTC.BKP4R: backup register
func (o *RTC_Type) SetBKP4R(value uint32) {
	volatile.StoreUint32(&o.BKP4R.Reg, value)
}
func (o *RTC_Type) GetBKP4R() uint32 {
	return volatile.LoadUint32(&o.BKP4R.Reg)
}

// RTC.BKP5R: backup register
func (o *RTC_Type) SetBKP5R(value uint32) {
	volatile.StoreUint32(&o.BKP5R.Reg, value)
}
func (o *RTC_Type) GetBKP5R() uint32 {
	return volatile.LoadUint32(&o.BKP5R.Reg)
}

// RTC.BKP6R: backup register
func (o *RTC_Type) SetBKP6R(value uint32) {
	volatile.StoreUint32(&o.BKP6R.Reg, value)
}
func (o *RTC_Type) GetBKP6R() uint32 {
	return volatile.LoadUint32(&o.BKP6R.Reg)
}

// RTC.BKP7R: backup register
func (o *RTC_Type) SetBKP7R(value uint32) {
	volatile.StoreUint32(&o.BKP7R.Reg, value)
}
func (o *RTC_Type) GetBKP7R() uint32 {
	return volatile.LoadUint32(&o.BKP7R.Reg)
}

// RTC.BKP8R: backup register
func (o *RTC_Type) SetBKP8R(value uint32) {
	volatile.StoreUint32(&o.BKP8R.Reg, value)
}
func (o *RTC_Type) GetBKP8R() uint32 {
	return volatile.LoadUint32(&o.BKP8R.Reg)
}

// RTC.BKP9R: backup register
func (o *RTC_Type) SetBKP9R(value uint32) {
	volatile.StoreUint32(&o.BKP9R.Reg, value)
}
func (o *RTC_Type) GetBKP9R() uint32 {
	return volatile.LoadUint32(&o.BKP9R.Reg)
}

// RTC.BKP10R: backup register
func (o *RTC_Type) SetBKP10R(value uint32) {
	volatile.StoreUint32(&o.BKP10R.Reg, value)
}
func (o *RTC_Type) GetBKP10R() uint32 {
	return volatile.LoadUint32(&o.BKP10R.Reg)
}

// RTC.BKP11R: backup register
func (o *RTC_Type) SetBKP11R(value uint32) {
	volatile.StoreUint32(&o.BKP11R.Reg, value)
}
func (o *RTC_Type) GetBKP11R() uint32 {
	return volatile.LoadUint32(&o.BKP11R.Reg)
}

// RTC.BKP12R: backup register
func (o *RTC_Type) SetBKP12R(value uint32) {
	volatile.StoreUint32(&o.BKP12R.Reg, value)
}
func (o *RTC_Type) GetBKP12R() uint32 {
	return volatile.LoadUint32(&o.BKP12R.Reg)
}

// RTC.BKP13R: backup register
func (o *RTC_Type) SetBKP13R(value uint32) {
	volatile.StoreUint32(&o.BKP13R.Reg, value)
}
func (o *RTC_Type) GetBKP13R() uint32 {
	return volatile.LoadUint32(&o.BKP13R.Reg)
}

// RTC.BKP14R: backup register
func (o *RTC_Type) SetBKP14R(value uint32) {
	volatile.StoreUint32(&o.BKP14R.Reg, value)
}
func (o *RTC_Type) GetBKP14R() uint32 {
	return volatile.LoadUint32(&o.BKP14R.Reg)
}

// RTC.BKP15R: backup register
func (o *RTC_Type) SetBKP15R(value uint32) {
	volatile.StoreUint32(&o.BKP15R.Reg, value)
}
func (o *RTC_Type) GetBKP15R() uint32 {
	return volatile.LoadUint32(&o.BKP15R.Reg)
}

// RTC.BKP16R: backup register
func (o *RTC_Type) SetBKP16R(value uint32) {
	volatile.StoreUint32(&o.BKP16R.Reg, value)
}
func (o *RTC_Type) GetBKP16R() uint32 {
	return volatile.LoadUint32(&o.BKP16R.Reg)
}

// RTC.BKP17R: backup register
func (o *RTC_Type) SetBKP17R(value uint32) {
	volatile.StoreUint32(&o.BKP17R.Reg, value)
}
func (o *RTC_Type) GetBKP17R() uint32 {
	return volatile.LoadUint32(&o.BKP17R.Reg)
}

// RTC.BKP18R: backup register
func (o *RTC_Type) SetBKP18R(value uint32) {
	volatile.StoreUint32(&o.BKP18R.Reg, value)
}
func (o *RTC_Type) GetBKP18R() uint32 {
	return volatile.LoadUint32(&o.BKP18R.Reg)
}

// RTC.BKP19R: backup register
func (o *RTC_Type) SetBKP19R(value uint32) {
	volatile.StoreUint32(&o.BKP19R.Reg, value)
}
func (o *RTC_Type) GetBKP19R() uint32 {
	return volatile.LoadUint32(&o.BKP19R.Reg)
}

// RTC.BKP20R: backup register
func (o *RTC_Type) SetBKP20R(value uint32) {
	volatile.StoreUint32(&o.BKP20R.Reg, value)
}
func (o *RTC_Type) GetBKP20R() uint32 {
	return volatile.LoadUint32(&o.BKP20R.Reg)
}

// RTC.BKP21R: backup register
func (o *RTC_Type) SetBKP21R(value uint32) {
	volatile.StoreUint32(&o.BKP21R.Reg, value)
}
func (o *RTC_Type) GetBKP21R() uint32 {
	return volatile.LoadUint32(&o.BKP21R.Reg)
}

// RTC.BKP22R: backup register
func (o *RTC_Type) SetBKP22R(value uint32) {
	volatile.StoreUint32(&o.BKP22R.Reg, value)
}
func (o *RTC_Type) GetBKP22R() uint32 {
	return volatile.LoadUint32(&o.BKP22R.Reg)
}

// RTC.BKP23R: backup register
func (o *RTC_Type) SetBKP23R(value uint32) {
	volatile.StoreUint32(&o.BKP23R.Reg, value)
}
func (o *RTC_Type) GetBKP23R() uint32 {
	return volatile.LoadUint32(&o.BKP23R.Reg)
}

// RTC.BKP24R: backup register
func (o *RTC_Type) SetBKP24R(value uint32) {
	volatile.StoreUint32(&o.BKP24R.Reg, value)
}
func (o *RTC_Type) GetBKP24R() uint32 {
	return volatile.LoadUint32(&o.BKP24R.Reg)
}

// RTC.BKP25R: backup register
func (o *RTC_Type) SetBKP25R(value uint32) {
	volatile.StoreUint32(&o.BKP25R.Reg, value)
}
func (o *RTC_Type) GetBKP25R() uint32 {
	return volatile.LoadUint32(&o.BKP25R.Reg)
}

// RTC.BKP26R: backup register
func (o *RTC_Type) SetBKP26R(value uint32) {
	volatile.StoreUint32(&o.BKP26R.Reg, value)
}
func (o *RTC_Type) GetBKP26R() uint32 {
	return volatile.LoadUint32(&o.BKP26R.Reg)
}

// RTC.BKP27R: backup register
func (o *RTC_Type) SetBKP27R(value uint32) {
	volatile.StoreUint32(&o.BKP27R.Reg, value)
}
func (o *RTC_Type) GetBKP27R() uint32 {
	return volatile.LoadUint32(&o.BKP27R.Reg)
}

// RTC.BKP28R: backup register
func (o *RTC_Type) SetBKP28R(value uint32) {
	volatile.StoreUint32(&o.BKP28R.Reg, value)
}
func (o *RTC_Type) GetBKP28R() uint32 {
	return volatile.LoadUint32(&o.BKP28R.Reg)
}

// RTC.BKP29R: backup register
func (o *RTC_Type) SetBKP29R(value uint32) {
	volatile.StoreUint32(&o.BKP29R.Reg, value)
}
func (o *RTC_Type) GetBKP29R() uint32 {
	return volatile.LoadUint32(&o.BKP29R.Reg)
}

// RTC.BKP30R: backup register
func (o *RTC_Type) SetBKP30R(value uint32) {
	volatile.StoreUint32(&o.BKP30R.Reg, value)
}
func (o *RTC_Type) GetBKP30R() uint32 {
	return volatile.LoadUint32(&o.BKP30R.Reg)
}

// RTC.BKP31R: backup register
func (o *RTC_Type) SetBKP31R(value uint32) {
	volatile.StoreUint32(&o.BKP31R.Reg, value)
}
func (o *RTC_Type) GetBKP31R() uint32 {
	return volatile.LoadUint32(&o.BKP31R.Reg)
}

// Reset and clock control
type RCC_Type struct {
	CR         volatile.Register32 // 0x0
	PLLCFGR    volatile.Register32 // 0x4
	CFGR       volatile.Register32 // 0x8
	CIR        volatile.Register32 // 0xC
	AHB1RSTR   volatile.Register32 // 0x10
	AHB2RSTR   volatile.Register32 // 0x14
	AHB3RSTR   volatile.Register32 // 0x18
	_          [4]byte
	APB1RSTR   volatile.Register32 // 0x20
	APB2RSTR   volatile.Register32 // 0x24
	_          [8]byte
	AHB1ENR    volatile.Register32 // 0x30
	AHB2ENR    volatile.Register32 // 0x34
	AHB3ENR    volatile.Register32 // 0x38
	_          [4]byte
	APB1ENR    volatile.Register32 // 0x40
	APB2ENR    volatile.Register32 // 0x44
	_          [8]byte
	AHB1LPENR  volatile.Register32 // 0x50
	AHB2LPENR  volatile.Register32 // 0x54
	AHB3LPENR  volatile.Register32 // 0x58
	_          [4]byte
	APB1LPENR  volatile.Register32 // 0x60
	APB2LPENR  volatile.Register32 // 0x64
	_          [8]byte
	BDCR       volatile.Register32 // 0x70
	CSR        volatile.Register32 // 0x74
	_          [8]byte
	SSCGR      volatile.Register32 // 0x80
	PLLI2SCFGR volatile.Register32 // 0x84
	PLLSAICFGR volatile.Register32 // 0x88
	DCKCFGR1   volatile.Register32 // 0x8C
	DCKCFGR2   volatile.Register32 // 0x90
}

// RCC.CR: clock control register
func (o *RCC_Type) SetCR_PLLI2SRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCR_PLLI2SRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCR_PLLI2SON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCR_PLLI2SON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCR_PLLRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCR_PLLRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCR_PLLON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCR_PLLON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCR_CSSON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCR_CSSON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCR_HSEBYP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCR_HSEBYP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCR_HSERDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCR_HSERDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCR_HSEON(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCR_HSEON() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCR_HSICAL(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff00)|value<<8)
}
func (o *RCC_Type) GetCR_HSICAL() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff00) >> 8
}
func (o *RCC_Type) SetCR_HSITRIM(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xf8)|value<<3)
}
func (o *RCC_Type) GetCR_HSITRIM() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xf8) >> 3
}
func (o *RCC_Type) SetCR_HSIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCR_HSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCR_HSION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCR_HSION() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *RCC_Type) SetCR_PLLSAIRDY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCR_PLLSAIRDY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCR_PLLSAION(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCR_PLLSAION() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000000) >> 28
}

// RCC.PLLCFGR: PLL configuration register
func (o *RCC_Type) SetPLLCFGR_PLLSRC(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetPLLCFGR_PLLSRC() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetPLLCFGR_PLLM(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x3f)|value)
}
func (o *RCC_Type) GetPLLCFGR_PLLM() uint32 {
	return volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x3f
}
func (o *RCC_Type) SetPLLCFGR_PLLN(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x7fc0)|value<<6)
}
func (o *RCC_Type) GetPLLCFGR_PLLN() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x7fc0) >> 6
}
func (o *RCC_Type) SetPLLCFGR_PLLP(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetPLLCFGR_PLLP() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetPLLCFGR_PLLQ(value uint32) {
	volatile.StoreUint32(&o.PLLCFGR.Reg, volatile.LoadUint32(&o.PLLCFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetPLLCFGR_PLLQ() uint32 {
	return (volatile.LoadUint32(&o.PLLCFGR.Reg) & 0xf000000) >> 24
}

// RCC.CFGR: clock configuration register
func (o *RCC_Type) SetCFGR_MCO2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc0000000)|value<<30)
}
func (o *RCC_Type) GetCFGR_MCO2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc0000000) >> 30
}
func (o *RCC_Type) SetCFGR_MCO2PRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x38000000)|value<<27)
}
func (o *RCC_Type) GetCFGR_MCO2PRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x38000000) >> 27
}
func (o *RCC_Type) SetCFGR_MCO1PRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x7000000)|value<<24)
}
func (o *RCC_Type) GetCFGR_MCO1PRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x7000000) >> 24
}
func (o *RCC_Type) SetCFGR_I2SSRC(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCFGR_I2SSRC() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCFGR_MCO1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x600000)|value<<21)
}
func (o *RCC_Type) GetCFGR_MCO1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x600000) >> 21
}
func (o *RCC_Type) SetCFGR_RTCPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1f0000)|value<<16)
}
func (o *RCC_Type) GetCFGR_RTCPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1f0000) >> 16
}
func (o *RCC_Type) SetCFGR_PPRE2(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xe000)|value<<13)
}
func (o *RCC_Type) GetCFGR_PPRE2() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xe000) >> 13
}
func (o *RCC_Type) SetCFGR_PPRE1(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x1c00)|value<<10)
}
func (o *RCC_Type) GetCFGR_PPRE1() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0x1c00) >> 10
}
func (o *RCC_Type) SetCFGR_HPRE(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xf0)|value<<4)
}
func (o *RCC_Type) GetCFGR_HPRE() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xf0) >> 4
}
func (o *RCC_Type) SetCFGR_SW(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetCFGR_SW() uint32 {
	return volatile.LoadUint32(&o.CFGR.Reg) & 0x3
}
func (o *RCC_Type) SetCFGR_SWS(value uint32) {
	volatile.StoreUint32(&o.CFGR.Reg, volatile.LoadUint32(&o.CFGR.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetCFGR_SWS() uint32 {
	return (volatile.LoadUint32(&o.CFGR.Reg) & 0xc) >> 2
}

// RCC.CIR: clock interrupt register
func (o *RCC_Type) SetCIR_CSSC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetCIR_CSSC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetCIR_PLLSAIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetCIR_PLLSAIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetCIR_PLLI2SRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetCIR_PLLRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetCIR_PLLRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetCIR_HSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetCIR_HSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetCIR_HSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetCIR_HSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetCIR_LSERDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetCIR_LSERDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetCIR_LSIRDYC(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetCIR_LSIRDYC() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetCIR_PLLSAIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetCIR_PLLSAIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetCIR_PLLI2SRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetCIR_PLLRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetCIR_PLLRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetCIR_HSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetCIR_HSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetCIR_HSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetCIR_HSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetCIR_LSERDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetCIR_LSERDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetCIR_LSIRDYIE(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetCIR_LSIRDYIE() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetCIR_CSSF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetCIR_CSSF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetCIR_PLLSAIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetCIR_PLLSAIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetCIR_PLLI2SRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetCIR_PLLI2SRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetCIR_PLLRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetCIR_PLLRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetCIR_HSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetCIR_HSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetCIR_HSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetCIR_HSIRDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetCIR_LSERDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCIR_LSERDYF() uint32 {
	return (volatile.LoadUint32(&o.CIR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCIR_LSIRDYF(value uint32) {
	volatile.StoreUint32(&o.CIR.Reg, volatile.LoadUint32(&o.CIR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCIR_LSIRDYF() uint32 {
	return volatile.LoadUint32(&o.CIR.Reg) & 0x1
}

// RCC.AHB1RSTR: AHB1 peripheral reset register
func (o *RCC_Type) SetAHB1RSTR_OTGHSRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAHB1RSTR_OTGHSRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAHB1RSTR_DMA2RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1RSTR_DMA2RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHB1RSTR_DMA1RST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1RSTR_DMA1RST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1RSTR_CRCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1RSTR_CRCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1RSTR_GPIOIRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOIRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1RSTR_GPIOHRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOHRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1RSTR_GPIOGRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB1RSTR_GPIOFRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOFRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1RSTR_GPIOERST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOERST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1RSTR_GPIODRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1RSTR_GPIODRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1RSTR_GPIOCRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOCRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1RSTR_GPIOBRST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOBRST() uint32 {
	return (volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1RSTR_GPIOARST(value uint32) {
	volatile.StoreUint32(&o.AHB1RSTR.Reg, volatile.LoadUint32(&o.AHB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1RSTR_GPIOARST() uint32 {
	return volatile.LoadUint32(&o.AHB1RSTR.Reg) & 0x1
}

// RCC.AHB2RSTR: AHB2 peripheral reset register
func (o *RCC_Type) SetAHB2RSTR_OTGFSRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2RSTR_OTGFSRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2RSTR_RNGRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2RSTR_RNGRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2RSTR_AESRST(value uint32) {
	volatile.StoreUint32(&o.AHB2RSTR.Reg, volatile.LoadUint32(&o.AHB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2RSTR_AESRST() uint32 {
	return (volatile.LoadUint32(&o.AHB2RSTR.Reg) & 0x10) >> 4
}

// RCC.AHB3RSTR: AHB3 peripheral reset register
func (o *RCC_Type) SetAHB3RSTR_FMCRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3RSTR_FMCRST() uint32 {
	return volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3RSTR_QSPIRST(value uint32) {
	volatile.StoreUint32(&o.AHB3RSTR.Reg, volatile.LoadUint32(&o.AHB3RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB3RSTR_QSPIRST() uint32 {
	return (volatile.LoadUint32(&o.AHB3RSTR.Reg) & 0x2) >> 1
}

// RCC.APB1RSTR: APB1 peripheral reset register
func (o *RCC_Type) SetAPB1RSTR_TIM2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1RSTR_TIM2RST() uint32 {
	return volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1RSTR_TIM3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1RSTR_TIM3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1RSTR_TIM4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1RSTR_TIM4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1RSTR_TIM5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1RSTR_TIM5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1RSTR_TIM6RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1RSTR_TIM6RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1RSTR_TIM7RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1RSTR_TIM7RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1RSTR_TIM12RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1RSTR_TIM12RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1RSTR_TIM13RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1RSTR_TIM13RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1RSTR_TIM14RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1RSTR_TIM14RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1RSTR_WWDGRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1RSTR_WWDGRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1RSTR_SPI2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1RSTR_SPI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1RSTR_SPI3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1RSTR_SPI3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1RSTR_USART2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1RSTR_USART2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1RSTR_USART3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1RSTR_USART3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1RSTR_UART4RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1RSTR_UART4RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1RSTR_UART5RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1RSTR_UART5RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1RSTR_I2C1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1RSTR_I2C1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1RSTR_I2C2RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1RSTR_I2C2RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1RSTR_I2C3RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1RSTR_I2C3RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1RSTR_CAN1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1RSTR_CAN1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1RSTR_PWRRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1RSTR_PWRRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1RSTR_DACRST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1RSTR_DACRST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1RSTR_UART7RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1RSTR_UART7RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1RSTR_UART8RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1RSTR_UART8RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1RSTR_LPTIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB1RSTR.Reg, volatile.LoadUint32(&o.APB1RSTR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1RSTR_LPTIM1RST() uint32 {
	return (volatile.LoadUint32(&o.APB1RSTR.Reg) & 0x200) >> 9
}

// RCC.APB2RSTR: APB2 peripheral reset register
func (o *RCC_Type) SetAPB2RSTR_TIM1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2RSTR_TIM1RST() uint32 {
	return volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2RSTR_TIM8RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2RSTR_TIM8RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2RSTR_USART1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2RSTR_USART1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2RSTR_USART6RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2RSTR_USART6RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2RSTR_ADCRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2RSTR_ADCRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2RSTR_SPI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2RSTR_SPI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2RSTR_SPI4RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2RSTR_SPI4RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2RSTR_SYSCFGRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2RSTR_SYSCFGRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2RSTR_TIM9RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2RSTR_TIM9RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2RSTR_TIM10RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2RSTR_TIM10RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2RSTR_TIM11RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2RSTR_TIM11RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2RSTR_SPI5RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2RSTR_SPI5RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2RSTR_SAI1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2RSTR_SAI1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2RSTR_SAI2RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB2RSTR_SAI2RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB2RSTR_SDMMC1RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2RSTR_SDMMC1RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2RSTR_SDMMC2RST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB2RSTR_SDMMC2RST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB2RSTR_USBPHYCRST(value uint32) {
	volatile.StoreUint32(&o.APB2RSTR.Reg, volatile.LoadUint32(&o.APB2RSTR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB2RSTR_USBPHYCRST() uint32 {
	return (volatile.LoadUint32(&o.APB2RSTR.Reg) & 0x80000000) >> 31
}

// RCC.AHB1ENR: AHB1 peripheral clock register
func (o *RCC_Type) SetAHB1ENR_OTGHSULPIEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAHB1ENR_OTGHSULPIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAHB1ENR_OTGHSEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAHB1ENR_OTGHSEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAHB1ENR_DMA2EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1ENR_DMA2EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHB1ENR_DMA1EN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1ENR_DMA1EN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1ENR_DTCMRAMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAHB1ENR_DTCMRAMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAHB1ENR_BKPSRAMEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB1ENR_BKPSRAMEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB1ENR_CRCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1ENR_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1ENR_GPIOIEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1ENR_GPIOIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1ENR_GPIOHEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1ENR_GPIOHEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1ENR_GPIOGEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB1ENR_GPIOGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB1ENR_GPIOFEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1ENR_GPIOFEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1ENR_GPIOEEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1ENR_GPIOEEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1ENR_GPIODEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1ENR_GPIODEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1ENR_GPIOCEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1ENR_GPIOCEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1ENR_GPIOBEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1ENR_GPIOBEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1ENR_GPIOAEN(value uint32) {
	volatile.StoreUint32(&o.AHB1ENR.Reg, volatile.LoadUint32(&o.AHB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1ENR_GPIOAEN() uint32 {
	return volatile.LoadUint32(&o.AHB1ENR.Reg) & 0x1
}

// RCC.AHB2ENR: AHB2 peripheral clock enable register
func (o *RCC_Type) SetAHB2ENR_OTGFSEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2ENR_OTGFSEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2ENR_RNGEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2ENR_RNGEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2ENR_AESEN(value uint32) {
	volatile.StoreUint32(&o.AHB2ENR.Reg, volatile.LoadUint32(&o.AHB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2ENR_AESEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2ENR.Reg) & 0x10) >> 4
}

// RCC.AHB3ENR: AHB3 peripheral clock enable register
func (o *RCC_Type) SetAHB3ENR_FMCEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3ENR_FMCEN() uint32 {
	return volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3ENR_QSPIEN(value uint32) {
	volatile.StoreUint32(&o.AHB3ENR.Reg, volatile.LoadUint32(&o.AHB3ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB3ENR_QSPIEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3ENR.Reg) & 0x2) >> 1
}

// RCC.APB1ENR: APB1 peripheral clock enable register
func (o *RCC_Type) SetAPB1ENR_TIM2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1ENR_TIM2EN() uint32 {
	return volatile.LoadUint32(&o.APB1ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1ENR_TIM3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1ENR_TIM3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1ENR_TIM4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1ENR_TIM4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1ENR_TIM5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1ENR_TIM5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1ENR_TIM6EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1ENR_TIM6EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1ENR_TIM7EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1ENR_TIM7EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1ENR_TIM12EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1ENR_TIM12EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1ENR_TIM13EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1ENR_TIM13EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1ENR_TIM14EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1ENR_TIM14EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1ENR_WWDGEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1ENR_WWDGEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1ENR_SPI2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1ENR_SPI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1ENR_SPI3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1ENR_SPI3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1ENR_USART2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1ENR_USART2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1ENR_USART3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1ENR_USART3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1ENR_UART4EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1ENR_UART4EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1ENR_UART5EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1ENR_UART5EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1ENR_I2C1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1ENR_I2C1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1ENR_I2C2EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1ENR_I2C2EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1ENR_I2C3EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1ENR_I2C3EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1ENR_CAN1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1ENR_CAN1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1ENR_PWREN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1ENR_PWREN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1ENR_DACEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1ENR_DACEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1ENR_UART7EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1ENR_UART7EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1ENR_UART8EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1ENR_UART8EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1ENR_LPTIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1ENR_LPTIM1EN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1ENR_RTCAPBEN(value uint32) {
	volatile.StoreUint32(&o.APB1ENR.Reg, volatile.LoadUint32(&o.APB1ENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB1ENR_RTCAPBEN() uint32 {
	return (volatile.LoadUint32(&o.APB1ENR.Reg) & 0x400) >> 10
}

// RCC.APB2ENR: APB2 peripheral clock enable register
func (o *RCC_Type) SetAPB2ENR_TIM1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2ENR_TIM1EN() uint32 {
	return volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2ENR_TIM8EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2ENR_TIM8EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2ENR_USART1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2ENR_USART1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2ENR_USART6EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2ENR_USART6EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2ENR_ADC1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2ENR_ADC1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2ENR_ADC2EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB2ENR_ADC2EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB2ENR_ADC3EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB2ENR_ADC3EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB2ENR_SPI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2ENR_SPI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2ENR_SPI4EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2ENR_SPI4EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2ENR_SYSCFGEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2ENR_SYSCFGEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2ENR_TIM9EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2ENR_TIM9EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2ENR_TIM10EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2ENR_TIM10EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2ENR_TIM11EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2ENR_TIM11EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2ENR_SPI5EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2ENR_SPI5EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2ENR_SAI1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2ENR_SAI1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2ENR_SAI2EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB2ENR_SAI2EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB2ENR_SDMMC1EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2ENR_SDMMC1EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2ENR_SDMMC2EN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB2ENR_SDMMC2EN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB2ENR_USBPHYCEN(value uint32) {
	volatile.StoreUint32(&o.APB2ENR.Reg, volatile.LoadUint32(&o.APB2ENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB2ENR_USBPHYCEN() uint32 {
	return (volatile.LoadUint32(&o.APB2ENR.Reg) & 0x80000000) >> 31
}

// RCC.AHB1LPENR: AHB1 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB1LPENR_GPIOALPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOALPEN() uint32 {
	return volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB1LPENR_GPIOBLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOBLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAHB1LPENR_GPIOCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAHB1LPENR_GPIODLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAHB1LPENR_GPIODLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAHB1LPENR_GPIOELPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOELPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAHB1LPENR_GPIOFLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOFLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAHB1LPENR_GPIOGLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOGLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB1LPENR_GPIOHLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOHLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB1LPENR_GPIOILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAHB1LPENR_GPIOILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAHB1LPENR_CRCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAHB1LPENR_CRCLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAHB1LPENR_FLITFLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAHB1LPENR_FLITFLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAHB1LPENR_SRAM1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAHB1LPENR_SRAM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAHB1LPENR_SRAM2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAHB1LPENR_SRAM2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAHB1LPENR_BKPSRAMLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAHB1LPENR_BKPSRAMLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAHB1LPENR_SRAM3LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAHB1LPENR_SRAM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAHB1LPENR_DMA1LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAHB1LPENR_DMA1LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAHB1LPENR_DMA2LPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAHB1LPENR_DMA2LPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAHB1LPENR_OTGHSLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAHB1LPENR_OTGHSLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAHB1LPENR_OTGHSULPILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAHB1LPENR_OTGHSULPILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAHB1LPENR_AXILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAHB1LPENR_AXILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAHB1LPENR_DTCMLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB1LPENR.Reg, volatile.LoadUint32(&o.AHB1LPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAHB1LPENR_DTCMLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB1LPENR.Reg) & 0x100000) >> 20
}

// RCC.AHB2LPENR: AHB2 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB2LPENR_OTGFSLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAHB2LPENR_OTGFSLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAHB2LPENR_RNGLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAHB2LPENR_RNGLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAHB2LPENR_AESLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB2LPENR.Reg, volatile.LoadUint32(&o.AHB2LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAHB2LPENR_AESLPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB2LPENR.Reg) & 0x10) >> 4
}

// RCC.AHB3LPENR: AHB3 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAHB3LPENR_FMCLPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAHB3LPENR_FMCLPEN() uint32 {
	return volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAHB3LPENR_QSPILPEN(value uint32) {
	volatile.StoreUint32(&o.AHB3LPENR.Reg, volatile.LoadUint32(&o.AHB3LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAHB3LPENR_QSPILPEN() uint32 {
	return (volatile.LoadUint32(&o.AHB3LPENR.Reg) & 0x2) >> 1
}

// RCC.APB1LPENR: APB1 peripheral clock enable in low power mode register
func (o *RCC_Type) SetAPB1LPENR_TIM2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB1LPENR_TIM2LPEN() uint32 {
	return volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB1LPENR_TIM3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB1LPENR_TIM3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB1LPENR_TIM4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetAPB1LPENR_TIM4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetAPB1LPENR_TIM5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x8)|value<<3)
}
func (o *RCC_Type) GetAPB1LPENR_TIM5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x8) >> 3
}
func (o *RCC_Type) SetAPB1LPENR_TIM6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB1LPENR_TIM6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB1LPENR_TIM7LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB1LPENR_TIM7LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB1LPENR_TIM12LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x40)|value<<6)
}
func (o *RCC_Type) GetAPB1LPENR_TIM12LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x40) >> 6
}
func (o *RCC_Type) SetAPB1LPENR_TIM13LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB1LPENR_TIM13LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x80) >> 7
}
func (o *RCC_Type) SetAPB1LPENR_TIM14LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB1LPENR_TIM14LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB1LPENR_WWDGLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB1LPENR_WWDGLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB1LPENR_SPI2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB1LPENR_SPI2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB1LPENR_SPI3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetAPB1LPENR_SPI3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetAPB1LPENR_USART2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB1LPENR_USART2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB1LPENR_USART3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB1LPENR_USART3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB1LPENR_UART4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x80000)|value<<19)
}
func (o *RCC_Type) GetAPB1LPENR_UART4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x80000) >> 19
}
func (o *RCC_Type) SetAPB1LPENR_UART5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB1LPENR_UART5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB1LPENR_I2C1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x200000)|value<<21)
}
func (o *RCC_Type) GetAPB1LPENR_I2C1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x200000) >> 21
}
func (o *RCC_Type) SetAPB1LPENR_I2C2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB1LPENR_I2C2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB1LPENR_I2C3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB1LPENR_I2C3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB1LPENR_CAN1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetAPB1LPENR_CAN1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetAPB1LPENR_PWRLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetAPB1LPENR_PWRLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetAPB1LPENR_DACLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetAPB1LPENR_DACLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetAPB1LPENR_UART7LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetAPB1LPENR_UART7LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetAPB1LPENR_UART8LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetAPB1LPENR_UART8LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetAPB1LPENR_LPTIM1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB1LPENR_LPTIM1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB1LPENR_RTCAPBLPEN(value uint32) {
	volatile.StoreUint32(&o.APB1LPENR.Reg, volatile.LoadUint32(&o.APB1LPENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB1LPENR_RTCAPBLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB1LPENR.Reg) & 0x400) >> 10
}

// RCC.APB2LPENR: APB2 peripheral clock enabled in low power mode register
func (o *RCC_Type) SetAPB2LPENR_TIM1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetAPB2LPENR_TIM1LPEN() uint32 {
	return volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1
}
func (o *RCC_Type) SetAPB2LPENR_TIM8LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetAPB2LPENR_TIM8LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetAPB2LPENR_USART1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10)|value<<4)
}
func (o *RCC_Type) GetAPB2LPENR_USART1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10) >> 4
}
func (o *RCC_Type) SetAPB2LPENR_USART6LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x20)|value<<5)
}
func (o *RCC_Type) GetAPB2LPENR_USART6LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x20) >> 5
}
func (o *RCC_Type) SetAPB2LPENR_ADC1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x100)|value<<8)
}
func (o *RCC_Type) GetAPB2LPENR_ADC1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x100) >> 8
}
func (o *RCC_Type) SetAPB2LPENR_ADC2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x200)|value<<9)
}
func (o *RCC_Type) GetAPB2LPENR_ADC2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x200) >> 9
}
func (o *RCC_Type) SetAPB2LPENR_ADC3LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x400)|value<<10)
}
func (o *RCC_Type) GetAPB2LPENR_ADC3LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x400) >> 10
}
func (o *RCC_Type) SetAPB2LPENR_SPI1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x1000)|value<<12)
}
func (o *RCC_Type) GetAPB2LPENR_SPI1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x1000) >> 12
}
func (o *RCC_Type) SetAPB2LPENR_SPI4LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x2000)|value<<13)
}
func (o *RCC_Type) GetAPB2LPENR_SPI4LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x2000) >> 13
}
func (o *RCC_Type) SetAPB2LPENR_SYSCFGLPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x4000)|value<<14)
}
func (o *RCC_Type) GetAPB2LPENR_SYSCFGLPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x4000) >> 14
}
func (o *RCC_Type) SetAPB2LPENR_TIM9LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetAPB2LPENR_TIM9LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetAPB2LPENR_TIM10LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x20000)|value<<17)
}
func (o *RCC_Type) GetAPB2LPENR_TIM10LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x20000) >> 17
}
func (o *RCC_Type) SetAPB2LPENR_TIM11LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x40000)|value<<18)
}
func (o *RCC_Type) GetAPB2LPENR_TIM11LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x40000) >> 18
}
func (o *RCC_Type) SetAPB2LPENR_SPI5LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x100000)|value<<20)
}
func (o *RCC_Type) GetAPB2LPENR_SPI5LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x100000) >> 20
}
func (o *RCC_Type) SetAPB2LPENR_SAI1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x400000)|value<<22)
}
func (o *RCC_Type) GetAPB2LPENR_SAI1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x400000) >> 22
}
func (o *RCC_Type) SetAPB2LPENR_SAI2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x800000)|value<<23)
}
func (o *RCC_Type) GetAPB2LPENR_SAI2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x800000) >> 23
}
func (o *RCC_Type) SetAPB2LPENR_SDMMC1LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x800)|value<<11)
}
func (o *RCC_Type) GetAPB2LPENR_SDMMC1LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x800) >> 11
}
func (o *RCC_Type) SetAPB2LPENR_SDMMC2LPEN(value uint32) {
	volatile.StoreUint32(&o.APB2LPENR.Reg, volatile.LoadUint32(&o.APB2LPENR.Reg)&^(0x80)|value<<7)
}
func (o *RCC_Type) GetAPB2LPENR_SDMMC2LPEN() uint32 {
	return (volatile.LoadUint32(&o.APB2LPENR.Reg) & 0x80) >> 7
}

// RCC.BDCR: Backup domain control register
func (o *RCC_Type) SetBDCR_BDRST(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x10000)|value<<16)
}
func (o *RCC_Type) GetBDCR_BDRST() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x10000) >> 16
}
func (o *RCC_Type) SetBDCR_RTCEN(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x8000)|value<<15)
}
func (o *RCC_Type) GetBDCR_RTCEN() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x8000) >> 15
}
func (o *RCC_Type) SetBDCR_LSEBYP(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x4)|value<<2)
}
func (o *RCC_Type) GetBDCR_LSEBYP() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x4) >> 2
}
func (o *RCC_Type) SetBDCR_LSERDY(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetBDCR_LSERDY() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetBDCR_LSEON(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetBDCR_LSEON() uint32 {
	return volatile.LoadUint32(&o.BDCR.Reg) & 0x1
}
func (o *RCC_Type) SetBDCR_LSEDRV(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x18)|value<<3)
}
func (o *RCC_Type) GetBDCR_LSEDRV() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x18) >> 3
}
func (o *RCC_Type) SetBDCR_RTCSEL(value uint32) {
	volatile.StoreUint32(&o.BDCR.Reg, volatile.LoadUint32(&o.BDCR.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetBDCR_RTCSEL() uint32 {
	return (volatile.LoadUint32(&o.BDCR.Reg) & 0x300) >> 8
}

// RCC.CSR: clock control & status register
func (o *RCC_Type) SetCSR_LPWRRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetCSR_LPWRRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetCSR_WWDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetCSR_WWDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetCSR_WDGRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetCSR_WDGRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20000000) >> 29
}
func (o *RCC_Type) SetCSR_SFTRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetCSR_SFTRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetCSR_PORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetCSR_PORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetCSR_PADRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4000000)|value<<26)
}
func (o *RCC_Type) GetCSR_PADRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4000000) >> 26
}
func (o *RCC_Type) SetCSR_BORRSTF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000000)|value<<25)
}
func (o *RCC_Type) GetCSR_BORRSTF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000000) >> 25
}
func (o *RCC_Type) SetCSR_RMVF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetCSR_RMVF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000000) >> 24
}
func (o *RCC_Type) SetCSR_LSIRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *RCC_Type) GetCSR_LSIRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *RCC_Type) SetCSR_LSION(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *RCC_Type) GetCSR_LSION() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}

// RCC.SSCGR: spread spectrum clock generation register
func (o *RCC_Type) SetSSCGR_SSCGEN(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x80000000)|value<<31)
}
func (o *RCC_Type) GetSSCGR_SSCGEN() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0x80000000) >> 31
}
func (o *RCC_Type) SetSSCGR_SPREADSEL(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x40000000)|value<<30)
}
func (o *RCC_Type) GetSSCGR_SPREADSEL() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0x40000000) >> 30
}
func (o *RCC_Type) SetSSCGR_INCSTEP(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0xfffe000)|value<<13)
}
func (o *RCC_Type) GetSSCGR_INCSTEP() uint32 {
	return (volatile.LoadUint32(&o.SSCGR.Reg) & 0xfffe000) >> 13
}
func (o *RCC_Type) SetSSCGR_MODPER(value uint32) {
	volatile.StoreUint32(&o.SSCGR.Reg, volatile.LoadUint32(&o.SSCGR.Reg)&^(0x1fff)|value)
}
func (o *RCC_Type) GetSSCGR_MODPER() uint32 {
	return volatile.LoadUint32(&o.SSCGR.Reg) & 0x1fff
}

// RCC.PLLI2SCFGR: PLLI2S configuration register
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SR(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x70000000)|value<<28)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SR() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x70000000) >> 28
}
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SQ(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SQ() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0xf000000) >> 24
}
func (o *RCC_Type) SetPLLI2SCFGR_PLLI2SN(value uint32) {
	volatile.StoreUint32(&o.PLLI2SCFGR.Reg, volatile.LoadUint32(&o.PLLI2SCFGR.Reg)&^(0x7fc0)|value<<6)
}
func (o *RCC_Type) GetPLLI2SCFGR_PLLI2SN() uint32 {
	return (volatile.LoadUint32(&o.PLLI2SCFGR.Reg) & 0x7fc0) >> 6
}

// RCC.PLLSAICFGR: PLL configuration register
func (o *RCC_Type) SetPLLSAICFGR_PLLSAIN(value uint32) {
	volatile.StoreUint32(&o.PLLSAICFGR.Reg, volatile.LoadUint32(&o.PLLSAICFGR.Reg)&^(0x7fc0)|value<<6)
}
func (o *RCC_Type) GetPLLSAICFGR_PLLSAIN() uint32 {
	return (volatile.LoadUint32(&o.PLLSAICFGR.Reg) & 0x7fc0) >> 6
}
func (o *RCC_Type) SetPLLSAICFGR_PLLSAIP(value uint32) {
	volatile.StoreUint32(&o.PLLSAICFGR.Reg, volatile.LoadUint32(&o.PLLSAICFGR.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetPLLSAICFGR_PLLSAIP() uint32 {
	return (volatile.LoadUint32(&o.PLLSAICFGR.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetPLLSAICFGR_PLLSAIQ(value uint32) {
	volatile.StoreUint32(&o.PLLSAICFGR.Reg, volatile.LoadUint32(&o.PLLSAICFGR.Reg)&^(0xf000000)|value<<24)
}
func (o *RCC_Type) GetPLLSAICFGR_PLLSAIQ() uint32 {
	return (volatile.LoadUint32(&o.PLLSAICFGR.Reg) & 0xf000000) >> 24
}

// RCC.DCKCFGR1: dedicated clocks configuration register
func (o *RCC_Type) SetDCKCFGR1_PLLI2SDIVQ(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR1.Reg, volatile.LoadUint32(&o.DCKCFGR1.Reg)&^(0x1f)|value)
}
func (o *RCC_Type) GetDCKCFGR1_PLLI2SDIVQ() uint32 {
	return volatile.LoadUint32(&o.DCKCFGR1.Reg) & 0x1f
}
func (o *RCC_Type) SetDCKCFGR1_PLLSAIDIVQ(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR1.Reg, volatile.LoadUint32(&o.DCKCFGR1.Reg)&^(0x1f00)|value<<8)
}
func (o *RCC_Type) GetDCKCFGR1_PLLSAIDIVQ() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR1.Reg) & 0x1f00) >> 8
}
func (o *RCC_Type) SetDCKCFGR1_SAI1SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR1.Reg, volatile.LoadUint32(&o.DCKCFGR1.Reg)&^(0x300000)|value<<20)
}
func (o *RCC_Type) GetDCKCFGR1_SAI1SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR1.Reg) & 0x300000) >> 20
}
func (o *RCC_Type) SetDCKCFGR1_SAI2SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR1.Reg, volatile.LoadUint32(&o.DCKCFGR1.Reg)&^(0xc00000)|value<<22)
}
func (o *RCC_Type) GetDCKCFGR1_SAI2SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR1.Reg) & 0xc00000) >> 22
}
func (o *RCC_Type) SetDCKCFGR1_TIMPRE(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR1.Reg, volatile.LoadUint32(&o.DCKCFGR1.Reg)&^(0x1000000)|value<<24)
}
func (o *RCC_Type) GetDCKCFGR1_TIMPRE() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR1.Reg) & 0x1000000) >> 24
}

// RCC.DCKCFGR2: dedicated clocks configuration register
func (o *RCC_Type) SetDCKCFGR2_USART1SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x3)|value)
}
func (o *RCC_Type) GetDCKCFGR2_USART1SEL() uint32 {
	return volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x3
}
func (o *RCC_Type) SetDCKCFGR2_USART2SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0xc)|value<<2)
}
func (o *RCC_Type) GetDCKCFGR2_USART2SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0xc) >> 2
}
func (o *RCC_Type) SetDCKCFGR2_USART3SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x30)|value<<4)
}
func (o *RCC_Type) GetDCKCFGR2_USART3SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x30) >> 4
}
func (o *RCC_Type) SetDCKCFGR2_UART4SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0xc0)|value<<6)
}
func (o *RCC_Type) GetDCKCFGR2_UART4SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0xc0) >> 6
}
func (o *RCC_Type) SetDCKCFGR2_UART5SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x300)|value<<8)
}
func (o *RCC_Type) GetDCKCFGR2_UART5SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x300) >> 8
}
func (o *RCC_Type) SetDCKCFGR2_USART6SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0xc00)|value<<10)
}
func (o *RCC_Type) GetDCKCFGR2_USART6SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0xc00) >> 10
}
func (o *RCC_Type) SetDCKCFGR2_UART7SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x3000)|value<<12)
}
func (o *RCC_Type) GetDCKCFGR2_UART7SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x3000) >> 12
}
func (o *RCC_Type) SetDCKCFGR2_UART8SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0xc000)|value<<14)
}
func (o *RCC_Type) GetDCKCFGR2_UART8SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0xc000) >> 14
}
func (o *RCC_Type) SetDCKCFGR2_I2C1SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x30000)|value<<16)
}
func (o *RCC_Type) GetDCKCFGR2_I2C1SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x30000) >> 16
}
func (o *RCC_Type) SetDCKCFGR2_I2C2SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0xc0000)|value<<18)
}
func (o *RCC_Type) GetDCKCFGR2_I2C2SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0xc0000) >> 18
}
func (o *RCC_Type) SetDCKCFGR2_I2C3SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x300000)|value<<20)
}
func (o *RCC_Type) GetDCKCFGR2_I2C3SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x300000) >> 20
}
func (o *RCC_Type) SetDCKCFGR2_LPTIM1SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x3000000)|value<<24)
}
func (o *RCC_Type) GetDCKCFGR2_LPTIM1SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x3000000) >> 24
}
func (o *RCC_Type) SetDCKCFGR2_CK48MSEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x8000000)|value<<27)
}
func (o *RCC_Type) GetDCKCFGR2_CK48MSEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x8000000) >> 27
}
func (o *RCC_Type) SetDCKCFGR2_SDMMC1SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x10000000)|value<<28)
}
func (o *RCC_Type) GetDCKCFGR2_SDMMC1SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x10000000) >> 28
}
func (o *RCC_Type) SetDCKCFGR2_SDMMC2SEL(value uint32) {
	volatile.StoreUint32(&o.DCKCFGR2.Reg, volatile.LoadUint32(&o.DCKCFGR2.Reg)&^(0x20000000)|value<<29)
}
func (o *RCC_Type) GetDCKCFGR2_SDMMC2SEL() uint32 {
	return (volatile.LoadUint32(&o.DCKCFGR2.Reg) & 0x20000000) >> 29
}

// Secure digital input/output interface
type SDMMC_Type struct {
	POWER   volatile.Register32 // 0x0
	CLKCR   volatile.Register32 // 0x4
	ARG     volatile.Register32 // 0x8
	CMD     volatile.Register32 // 0xC
	RESPCMD volatile.Register32 // 0x10
	RESP1   volatile.Register32 // 0x14
	RESP2   volatile.Register32 // 0x18
	RESP3   volatile.Register32 // 0x1C
	RESP4   volatile.Register32 // 0x20
	DTIMER  volatile.Register32 // 0x24
	DLEN    volatile.Register32 // 0x28
	DCTRL   volatile.Register32 // 0x2C
	DCOUNT  volatile.Register32 // 0x30
	STA     volatile.Register32 // 0x34
	ICR     volatile.Register32 // 0x38
	MASK    volatile.Register32 // 0x3C
	_       [8]byte
	FIFOCNT volatile.Register32 // 0x48
	_       [52]byte
	FIFO    volatile.Register32 // 0x80
}

// SDMMC.POWER: power control register
func (o *SDMMC_Type) SetPOWER_PWRCTRL(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x3)|value)
}
func (o *SDMMC_Type) GetPOWER_PWRCTRL() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x3
}

// SDMMC.CLKCR: SDI clock control register
func (o *SDMMC_Type) SetCLKCR_HWFC_EN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x4000)|value<<14)
}
func (o *SDMMC_Type) GetCLKCR_HWFC_EN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x4000) >> 14
}
func (o *SDMMC_Type) SetCLKCR_NEGEDGE(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x2000)|value<<13)
}
func (o *SDMMC_Type) GetCLKCR_NEGEDGE() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x2000) >> 13
}
func (o *SDMMC_Type) SetCLKCR_WIDBUS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x1800)|value<<11)
}
func (o *SDMMC_Type) GetCLKCR_WIDBUS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x1800) >> 11
}
func (o *SDMMC_Type) SetCLKCR_BYPASS(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetCLKCR_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetCLKCR_PWRSAV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetCLKCR_PWRSAV() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetCLKCR_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetCLKCR_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CLKCR.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetCLKCR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.CLKCR.Reg, volatile.LoadUint32(&o.CLKCR.Reg)&^(0xff)|value)
}
func (o *SDMMC_Type) GetCLKCR_CLKDIV() uint32 {
	return volatile.LoadUint32(&o.CLKCR.Reg) & 0xff
}

// SDMMC.ARG: argument register
func (o *SDMMC_Type) SetARG(value uint32) {
	volatile.StoreUint32(&o.ARG.Reg, value)
}
func (o *SDMMC_Type) GetARG() uint32 {
	return volatile.LoadUint32(&o.ARG.Reg)
}

// SDMMC.CMD: command register
func (o *SDMMC_Type) SetCMD_SDIOSuspend(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetCMD_SDIOSuspend() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetCMD_CPSMEN(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetCMD_CPSMEN() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetCMD_WAITPEND(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetCMD_WAITPEND() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetCMD_WAITINT(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetCMD_WAITINT() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetCMD_WAITRESP(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0xc0)|value<<6)
}
func (o *SDMMC_Type) GetCMD_WAITRESP() uint32 {
	return (volatile.LoadUint32(&o.CMD.Reg) & 0xc0) >> 6
}
func (o *SDMMC_Type) SetCMD_CMDINDEX(value uint32) {
	volatile.StoreUint32(&o.CMD.Reg, volatile.LoadUint32(&o.CMD.Reg)&^(0x3f)|value)
}
func (o *SDMMC_Type) GetCMD_CMDINDEX() uint32 {
	return volatile.LoadUint32(&o.CMD.Reg) & 0x3f
}

// SDMMC.RESPCMD: command response register
func (o *SDMMC_Type) SetRESPCMD(value uint32) {
	volatile.StoreUint32(&o.RESPCMD.Reg, volatile.LoadUint32(&o.RESPCMD.Reg)&^(0x3f)|value)
}
func (o *SDMMC_Type) GetRESPCMD() uint32 {
	return volatile.LoadUint32(&o.RESPCMD.Reg) & 0x3f
}

// SDMMC.RESP1: response 1..4 register
func (o *SDMMC_Type) SetRESP1(value uint32) {
	volatile.StoreUint32(&o.RESP1.Reg, value)
}
func (o *SDMMC_Type) GetRESP1() uint32 {
	return volatile.LoadUint32(&o.RESP1.Reg)
}

// SDMMC.RESP2: response 1..4 register
func (o *SDMMC_Type) SetRESP2(value uint32) {
	volatile.StoreUint32(&o.RESP2.Reg, value)
}
func (o *SDMMC_Type) GetRESP2() uint32 {
	return volatile.LoadUint32(&o.RESP2.Reg)
}

// SDMMC.RESP3: response 1..4 register
func (o *SDMMC_Type) SetRESP3(value uint32) {
	volatile.StoreUint32(&o.RESP3.Reg, value)
}
func (o *SDMMC_Type) GetRESP3() uint32 {
	return volatile.LoadUint32(&o.RESP3.Reg)
}

// SDMMC.RESP4: response 1..4 register
func (o *SDMMC_Type) SetRESP4(value uint32) {
	volatile.StoreUint32(&o.RESP4.Reg, value)
}
func (o *SDMMC_Type) GetRESP4() uint32 {
	return volatile.LoadUint32(&o.RESP4.Reg)
}

// SDMMC.DTIMER: data timer register
func (o *SDMMC_Type) SetDTIMER(value uint32) {
	volatile.StoreUint32(&o.DTIMER.Reg, value)
}
func (o *SDMMC_Type) GetDTIMER() uint32 {
	return volatile.LoadUint32(&o.DTIMER.Reg)
}

// SDMMC.DLEN: data length register
func (o *SDMMC_Type) SetDLEN_DATALENGTH(value uint32) {
	volatile.StoreUint32(&o.DLEN.Reg, volatile.LoadUint32(&o.DLEN.Reg)&^(0x1ffffff)|value)
}
func (o *SDMMC_Type) GetDLEN_DATALENGTH() uint32 {
	return volatile.LoadUint32(&o.DLEN.Reg) & 0x1ffffff
}

// SDMMC.DCTRL: data control register
func (o *SDMMC_Type) SetDCTRL_SDIOEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetDCTRL_SDIOEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetDCTRL_RWMOD(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetDCTRL_RWMOD() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetDCTRL_RWSTOP(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x200)|value<<9)
}
func (o *SDMMC_Type) GetDCTRL_RWSTOP() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x200) >> 9
}
func (o *SDMMC_Type) SetDCTRL_RWSTART(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetDCTRL_RWSTART() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetDCTRL_DBLOCKSIZE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0xf0)|value<<4)
}
func (o *SDMMC_Type) GetDCTRL_DBLOCKSIZE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0xf0) >> 4
}
func (o *SDMMC_Type) SetDCTRL_DMAEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetDCTRL_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetDCTRL_DTMODE(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetDCTRL_DTMODE() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetDCTRL_DTDIR(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetDCTRL_DTDIR() uint32 {
	return (volatile.LoadUint32(&o.DCTRL.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetDCTRL_DTEN(value uint32) {
	volatile.StoreUint32(&o.DCTRL.Reg, volatile.LoadUint32(&o.DCTRL.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetDCTRL_DTEN() uint32 {
	return volatile.LoadUint32(&o.DCTRL.Reg) & 0x1
}

// SDMMC.DCOUNT: data counter register
func (o *SDMMC_Type) SetDCOUNT_DATACOUNT(value uint32) {
	volatile.StoreUint32(&o.DCOUNT.Reg, volatile.LoadUint32(&o.DCOUNT.Reg)&^(0x1ffffff)|value)
}
func (o *SDMMC_Type) GetDCOUNT_DATACOUNT() uint32 {
	return volatile.LoadUint32(&o.DCOUNT.Reg) & 0x1ffffff
}

// SDMMC.STA: status register
func (o *SDMMC_Type) SetSTA_SDIOIT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400000)|value<<22)
}
func (o *SDMMC_Type) GetSTA_SDIOIT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400000) >> 22
}
func (o *SDMMC_Type) SetSTA_RXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x200000)|value<<21)
}
func (o *SDMMC_Type) GetSTA_RXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x200000) >> 21
}
func (o *SDMMC_Type) SetSTA_TXDAVL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100000)|value<<20)
}
func (o *SDMMC_Type) GetSTA_TXDAVL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100000) >> 20
}
func (o *SDMMC_Type) SetSTA_RXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80000)|value<<19)
}
func (o *SDMMC_Type) GetSTA_RXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80000) >> 19
}
func (o *SDMMC_Type) SetSTA_TXFIFOE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40000)|value<<18)
}
func (o *SDMMC_Type) GetSTA_TXFIFOE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40000) >> 18
}
func (o *SDMMC_Type) SetSTA_RXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20000)|value<<17)
}
func (o *SDMMC_Type) GetSTA_RXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20000) >> 17
}
func (o *SDMMC_Type) SetSTA_TXFIFOF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10000)|value<<16)
}
func (o *SDMMC_Type) GetSTA_TXFIFOF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10000) >> 16
}
func (o *SDMMC_Type) SetSTA_RXFIFOHF(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8000)|value<<15)
}
func (o *SDMMC_Type) GetSTA_RXFIFOHF() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8000) >> 15
}
func (o *SDMMC_Type) SetSTA_TXFIFOHE(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4000)|value<<14)
}
func (o *SDMMC_Type) GetSTA_TXFIFOHE() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4000) >> 14
}
func (o *SDMMC_Type) SetSTA_RXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2000)|value<<13)
}
func (o *SDMMC_Type) GetSTA_RXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2000) >> 13
}
func (o *SDMMC_Type) SetSTA_TXACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1000)|value<<12)
}
func (o *SDMMC_Type) GetSTA_TXACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x1000) >> 12
}
func (o *SDMMC_Type) SetSTA_CMDACT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetSTA_CMDACT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetSTA_DBCKEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetSTA_DBCKEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetSTA_DATAEND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetSTA_DATAEND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetSTA_CMDSENT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetSTA_CMDSENT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetSTA_CMDREND(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetSTA_CMDREND() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetSTA_RXOVERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetSTA_RXOVERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetSTA_TXUNDERR(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetSTA_TXUNDERR() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetSTA_DTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetSTA_DTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetSTA_CTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetSTA_CTIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetSTA_DCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetSTA_DCRCFAIL() uint32 {
	return (volatile.LoadUint32(&o.STA.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetSTA_CCRCFAIL(value uint32) {
	volatile.StoreUint32(&o.STA.Reg, volatile.LoadUint32(&o.STA.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetSTA_CCRCFAIL() uint32 {
	return volatile.LoadUint32(&o.STA.Reg) & 0x1
}

// SDMMC.ICR: interrupt clear register
func (o *SDMMC_Type) SetICR_SDIOITC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400000)|value<<22)
}
func (o *SDMMC_Type) GetICR_SDIOITC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400000) >> 22
}
func (o *SDMMC_Type) SetICR_DBCKENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetICR_DBCKENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetICR_DATAENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetICR_DATAENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetICR_CMDSENTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetICR_CMDSENTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetICR_CMDRENDC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetICR_CMDRENDC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetICR_RXOVERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetICR_RXOVERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetICR_TXUNDERRC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetICR_TXUNDERRC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetICR_DTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetICR_DTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetICR_CTIMEOUTC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetICR_CTIMEOUTC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetICR_DCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetICR_DCRCFAILC() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetICR_CCRCFAILC(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetICR_CCRCFAILC() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}

// SDMMC.MASK: mask register
func (o *SDMMC_Type) SetMASK_SDIOITIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400000)|value<<22)
}
func (o *SDMMC_Type) GetMASK_SDIOITIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400000) >> 22
}
func (o *SDMMC_Type) SetMASK_RXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x200000)|value<<21)
}
func (o *SDMMC_Type) GetMASK_RXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x200000) >> 21
}
func (o *SDMMC_Type) SetMASK_TXDAVLIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100000)|value<<20)
}
func (o *SDMMC_Type) GetMASK_TXDAVLIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100000) >> 20
}
func (o *SDMMC_Type) SetMASK_RXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80000)|value<<19)
}
func (o *SDMMC_Type) GetMASK_RXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80000) >> 19
}
func (o *SDMMC_Type) SetMASK_TXFIFOEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40000)|value<<18)
}
func (o *SDMMC_Type) GetMASK_TXFIFOEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40000) >> 18
}
func (o *SDMMC_Type) SetMASK_RXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20000)|value<<17)
}
func (o *SDMMC_Type) GetMASK_RXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20000) >> 17
}
func (o *SDMMC_Type) SetMASK_TXFIFOFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10000)|value<<16)
}
func (o *SDMMC_Type) GetMASK_TXFIFOFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10000) >> 16
}
func (o *SDMMC_Type) SetMASK_RXFIFOHFIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8000)|value<<15)
}
func (o *SDMMC_Type) GetMASK_RXFIFOHFIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8000) >> 15
}
func (o *SDMMC_Type) SetMASK_TXFIFOHEIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4000)|value<<14)
}
func (o *SDMMC_Type) GetMASK_TXFIFOHEIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4000) >> 14
}
func (o *SDMMC_Type) SetMASK_RXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2000)|value<<13)
}
func (o *SDMMC_Type) GetMASK_RXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2000) >> 13
}
func (o *SDMMC_Type) SetMASK_TXACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1000)|value<<12)
}
func (o *SDMMC_Type) GetMASK_TXACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x1000) >> 12
}
func (o *SDMMC_Type) SetMASK_CMDACTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x800)|value<<11)
}
func (o *SDMMC_Type) GetMASK_CMDACTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x800) >> 11
}
func (o *SDMMC_Type) SetMASK_DBCKENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x400)|value<<10)
}
func (o *SDMMC_Type) GetMASK_DBCKENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x400) >> 10
}
func (o *SDMMC_Type) SetMASK_DATAENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x100)|value<<8)
}
func (o *SDMMC_Type) GetMASK_DATAENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x100) >> 8
}
func (o *SDMMC_Type) SetMASK_CMDSENTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x80)|value<<7)
}
func (o *SDMMC_Type) GetMASK_CMDSENTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x80) >> 7
}
func (o *SDMMC_Type) SetMASK_CMDRENDIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x40)|value<<6)
}
func (o *SDMMC_Type) GetMASK_CMDRENDIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x40) >> 6
}
func (o *SDMMC_Type) SetMASK_RXOVERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x20)|value<<5)
}
func (o *SDMMC_Type) GetMASK_RXOVERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x20) >> 5
}
func (o *SDMMC_Type) SetMASK_TXUNDERRIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x10)|value<<4)
}
func (o *SDMMC_Type) GetMASK_TXUNDERRIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x10) >> 4
}
func (o *SDMMC_Type) SetMASK_DTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x8)|value<<3)
}
func (o *SDMMC_Type) GetMASK_DTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x8) >> 3
}
func (o *SDMMC_Type) SetMASK_CTIMEOUTIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x4)|value<<2)
}
func (o *SDMMC_Type) GetMASK_CTIMEOUTIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x4) >> 2
}
func (o *SDMMC_Type) SetMASK_DCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x2)|value<<1)
}
func (o *SDMMC_Type) GetMASK_DCRCFAILIE() uint32 {
	return (volatile.LoadUint32(&o.MASK.Reg) & 0x2) >> 1
}
func (o *SDMMC_Type) SetMASK_CCRCFAILIE(value uint32) {
	volatile.StoreUint32(&o.MASK.Reg, volatile.LoadUint32(&o.MASK.Reg)&^(0x1)|value)
}
func (o *SDMMC_Type) GetMASK_CCRCFAILIE() uint32 {
	return volatile.LoadUint32(&o.MASK.Reg) & 0x1
}

// SDMMC.FIFOCNT: FIFO counter register
func (o *SDMMC_Type) SetFIFOCNT_FIFOCOUNT(value uint32) {
	volatile.StoreUint32(&o.FIFOCNT.Reg, volatile.LoadUint32(&o.FIFOCNT.Reg)&^(0xffffff)|value)
}
func (o *SDMMC_Type) GetFIFOCNT_FIFOCOUNT() uint32 {
	return volatile.LoadUint32(&o.FIFOCNT.Reg) & 0xffffff
}

// SDMMC.FIFO: data FIFO register
func (o *SDMMC_Type) SetFIFO(value uint32) {
	volatile.StoreUint32(&o.FIFO.Reg, value)
}
func (o *SDMMC_Type) GetFIFO() uint32 {
	return volatile.LoadUint32(&o.FIFO.Reg)
}

// Serial audio interface
type SAI_Type struct {
	GCR volatile.Register32 // 0x0
	CH  [2]SAI_CH_Type      // 0x4
}

// SAI.GCR: Global configuration register
func (o *SAI_Type) SetGCR_SYNCIN(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x3)|value)
}
func (o *SAI_Type) GetGCR_SYNCIN() uint32 {
	return volatile.LoadUint32(&o.GCR.Reg) & 0x3
}
func (o *SAI_Type) SetGCR_SYNCOUT(value uint32) {
	volatile.StoreUint32(&o.GCR.Reg, volatile.LoadUint32(&o.GCR.Reg)&^(0x30)|value<<4)
}
func (o *SAI_Type) GetGCR_SYNCOUT() uint32 {
	return (volatile.LoadUint32(&o.GCR.Reg) & 0x30) >> 4
}

type SAI_CH_Type struct {
	CR1   volatile.Register32 // 0x4
	CR2   volatile.Register32 // 0x8
	FRCR  volatile.Register32 // 0xC
	SLOTR volatile.Register32 // 0x10
	IM    volatile.Register32 // 0x14
	SR    volatile.Register32 // 0x18
	CLRFR volatile.Register32 // 0x1C
	DR    volatile.Register32 // 0x20
}

// SAI_CH.CR1: AConfiguration register 1
func (o *SAI_CH_Type) SetCR1_MCKDIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xf00000)|value<<20)
}
func (o *SAI_CH_Type) GetCR1_MCKDIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xf00000) >> 20
}
func (o *SAI_CH_Type) SetCR1_NODIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80000)|value<<19)
}
func (o *SAI_CH_Type) GetCR1_NODIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80000) >> 19
}
func (o *SAI_CH_Type) SetCR1_DMAEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_CH_Type) GetCR1_DMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20000) >> 17
}
func (o *SAI_CH_Type) SetCR1_SAIEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_CH_Type) GetCR1_SAIEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000) >> 16
}
func (o *SAI_CH_Type) SetCR1_OUTDRIV(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_CH_Type) GetCR1_OUTDRIV() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SAI_CH_Type) SetCR1_MONO(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SAI_CH_Type) GetCR1_MONO() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SAI_CH_Type) SetCR1_SYNCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc00)|value<<10)
}
func (o *SAI_CH_Type) GetCR1_SYNCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc00) >> 10
}
func (o *SAI_CH_Type) SetCR1_CKSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SAI_CH_Type) GetCR1_CKSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SAI_CH_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SAI_CH_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SAI_CH_Type) SetCR1_DS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xe0)|value<<5)
}
func (o *SAI_CH_Type) GetCR1_DS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xe0) >> 5
}
func (o *SAI_CH_Type) SetCR1_PRTCFG(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0xc)|value<<2)
}
func (o *SAI_CH_Type) GetCR1_PRTCFG() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0xc) >> 2
}
func (o *SAI_CH_Type) SetCR1_MODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3)|value)
}
func (o *SAI_CH_Type) GetCR1_MODE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x3
}

// SAI_CH.CR2: AConfiguration register 2
func (o *SAI_CH_Type) SetCR2_COMP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xc000)|value<<14)
}
func (o *SAI_CH_Type) GetCR2_COMP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xc000) >> 14
}
func (o *SAI_CH_Type) SetCR2_CPL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SAI_CH_Type) GetCR2_CPL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SAI_CH_Type) SetCR2_MUTECN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1f80)|value<<7)
}
func (o *SAI_CH_Type) GetCR2_MUTECN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1f80) >> 7
}
func (o *SAI_CH_Type) SetCR2_MUTEVAL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetCR2_MUTEVAL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetCR2_MUTE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetCR2_MUTE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetCR2_TRIS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetCR2_TRIS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetCR2_FFLUSH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetCR2_FFLUSH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetCR2_FTH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x7)|value)
}
func (o *SAI_CH_Type) GetCR2_FTH() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x7
}

// SAI_CH.FRCR: AFRCR
func (o *SAI_CH_Type) SetFRCR_FSOFF(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x40000)|value<<18)
}
func (o *SAI_CH_Type) GetFRCR_FSOFF() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x40000) >> 18
}
func (o *SAI_CH_Type) SetFRCR_FSPOL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x20000)|value<<17)
}
func (o *SAI_CH_Type) GetFRCR_FSPOL() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x20000) >> 17
}
func (o *SAI_CH_Type) SetFRCR_FSDEF(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x10000)|value<<16)
}
func (o *SAI_CH_Type) GetFRCR_FSDEF() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x10000) >> 16
}
func (o *SAI_CH_Type) SetFRCR_FSALL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0x7f00)|value<<8)
}
func (o *SAI_CH_Type) GetFRCR_FSALL() uint32 {
	return (volatile.LoadUint32(&o.FRCR.Reg) & 0x7f00) >> 8
}
func (o *SAI_CH_Type) SetFRCR_FRL(value uint32) {
	volatile.StoreUint32(&o.FRCR.Reg, volatile.LoadUint32(&o.FRCR.Reg)&^(0xff)|value)
}
func (o *SAI_CH_Type) GetFRCR_FRL() uint32 {
	return volatile.LoadUint32(&o.FRCR.Reg) & 0xff
}

// SAI_CH.SLOTR: ASlot register
func (o *SAI_CH_Type) SetSLOTR_SLOTEN(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xffff0000)|value<<16)
}
func (o *SAI_CH_Type) GetSLOTR_SLOTEN() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xffff0000) >> 16
}
func (o *SAI_CH_Type) SetSLOTR_NBSLOT(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xf00)|value<<8)
}
func (o *SAI_CH_Type) GetSLOTR_NBSLOT() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xf00) >> 8
}
func (o *SAI_CH_Type) SetSLOTR_SLOTSZ(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0xc0)|value<<6)
}
func (o *SAI_CH_Type) GetSLOTR_SLOTSZ() uint32 {
	return (volatile.LoadUint32(&o.SLOTR.Reg) & 0xc0) >> 6
}
func (o *SAI_CH_Type) SetSLOTR_FBOFF(value uint32) {
	volatile.StoreUint32(&o.SLOTR.Reg, volatile.LoadUint32(&o.SLOTR.Reg)&^(0x1f)|value)
}
func (o *SAI_CH_Type) GetSLOTR_FBOFF() uint32 {
	return volatile.LoadUint32(&o.SLOTR.Reg) & 0x1f
}

// SAI_CH.IM: AInterrupt mask register2
func (o *SAI_CH_Type) SetIM_LFSDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetIM_LFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetIM_AFSDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetIM_AFSDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetIM_CNRDYIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetIM_CNRDYIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetIM_FREQIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetIM_FREQIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetIM_WCKCFGIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetIM_WCKCFGIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetIM_MUTEDETIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetIM_MUTEDETIE() uint32 {
	return (volatile.LoadUint32(&o.IM.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetIM_OVRUDRIE(value uint32) {
	volatile.StoreUint32(&o.IM.Reg, volatile.LoadUint32(&o.IM.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetIM_OVRUDRIE() uint32 {
	return volatile.LoadUint32(&o.IM.Reg) & 0x1
}

// SAI_CH.SR: AStatus register
func (o *SAI_CH_Type) SetSR_FLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x70000)|value<<16)
}
func (o *SAI_CH_Type) GetSR_FLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x70000) >> 16
}
func (o *SAI_CH_Type) SetSR_LFSDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetSR_LFSDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetSR_AFSDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetSR_AFSDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetSR_CNRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetSR_CNRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetSR_FREQ(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SAI_CH_Type) GetSR_FREQ() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SAI_CH_Type) SetSR_WCKCFG(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetSR_WCKCFG() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetSR_MUTEDET(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetSR_MUTEDET() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetSR_OVRUDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetSR_OVRUDR() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// SAI_CH.CLRFR: AClear flag register
func (o *SAI_CH_Type) SetCLRFR_CLFSDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x40)|value<<6)
}
func (o *SAI_CH_Type) GetCLRFR_CLFSDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x40) >> 6
}
func (o *SAI_CH_Type) SetCLRFR_CAFSDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x20)|value<<5)
}
func (o *SAI_CH_Type) GetCLRFR_CAFSDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x20) >> 5
}
func (o *SAI_CH_Type) SetCLRFR_CCNRDY(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x10)|value<<4)
}
func (o *SAI_CH_Type) GetCLRFR_CCNRDY() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x10) >> 4
}
func (o *SAI_CH_Type) SetCLRFR_CWCKCFG(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x4)|value<<2)
}
func (o *SAI_CH_Type) GetCLRFR_CWCKCFG() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x4) >> 2
}
func (o *SAI_CH_Type) SetCLRFR_CMUTEDET(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x2)|value<<1)
}
func (o *SAI_CH_Type) GetCLRFR_CMUTEDET() uint32 {
	return (volatile.LoadUint32(&o.CLRFR.Reg) & 0x2) >> 1
}
func (o *SAI_CH_Type) SetCLRFR_COVRUDR(value uint32) {
	volatile.StoreUint32(&o.CLRFR.Reg, volatile.LoadUint32(&o.CLRFR.Reg)&^(0x1)|value)
}
func (o *SAI_CH_Type) GetCLRFR_COVRUDR() uint32 {
	return volatile.LoadUint32(&o.CLRFR.Reg) & 0x1
}

// SAI_CH.DR: AData register
func (o *SAI_CH_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, value)
}
func (o *SAI_CH_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg)
}

// Serial peripheral interface
type SPI_Type struct {
	CR1     volatile.Register32 // 0x0
	CR2     volatile.Register32 // 0x4
	SR      volatile.Register32 // 0x8
	DR      volatile.Register32 // 0xC
	CRCPR   volatile.Register32 // 0x10
	RXCRCR  volatile.Register32 // 0x14
	TXCRCR  volatile.Register32 // 0x18
	I2SCFGR volatile.Register32 // 0x1C
	I2SPR   volatile.Register32 // 0x20
}

// SPI.CR1: control register 1
func (o *SPI_Type) SetCR1_BIDIMODE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *SPI_Type) GetCR1_BIDIMODE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *SPI_Type) SetCR1_BIDIOE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR1_BIDIOE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *SPI_Type) SetCR1_CRCEN(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR1_CRCEN() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR1_CRCNEXT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR1_CRCNEXT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR1_CRCL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetCR1_CRCL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetCR1_RXONLY(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetCR1_RXONLY() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetCR1_SSM(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetCR1_SSM() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetCR1_SSI(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetCR1_SSI() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetCR1_LSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR1_LSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR1_SPE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR1_SPE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR1_BR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x38)|value<<3)
}
func (o *SPI_Type) GetCR1_BR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x38) >> 3
}
func (o *SPI_Type) SetCR1_MSTR(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR1_MSTR() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR1_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR1_CPHA() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}

// SPI.CR2: control register 2
func (o *SPI_Type) SetCR2_RXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR2_RXDMAEN() uint32 {
	return volatile.LoadUint32(&o.CR2.Reg) & 0x1
}
func (o *SPI_Type) SetCR2_TXDMAEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR2_TXDMAEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR2_SSOE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCR2_SSOE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCR2_NSSP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCR2_NSSP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCR2_FRF(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetCR2_FRF() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetCR2_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetCR2_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetCR2_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetCR2_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetCR2_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR2_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR2_DS(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xf00)|value<<8)
}
func (o *SPI_Type) GetCR2_DS() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xf00) >> 8
}
func (o *SPI_Type) SetCR2_FRXTH(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetCR2_FRXTH() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x1000) >> 12
}
func (o *SPI_Type) SetCR2_LDMA_RX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x2000)|value<<13)
}
func (o *SPI_Type) GetCR2_LDMA_RX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x2000) >> 13
}
func (o *SPI_Type) SetCR2_LDMA_TX(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *SPI_Type) GetCR2_LDMA_TX() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}

// SPI.SR: status register
func (o *SPI_Type) SetSR_FRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_FRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_BSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetSR_BSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetSR_OVR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *SPI_Type) GetSR_OVR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetSR_CRCERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetSR_CRCERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetSR_UDR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_UDR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_CHSIDE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_CHSIDE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_TXE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TXE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_RXNE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RXNE() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_FRLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x600)|value<<9)
}
func (o *SPI_Type) GetSR_FRLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x600) >> 9
}
func (o *SPI_Type) SetSR_FTLVL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1800)|value<<11)
}
func (o *SPI_Type) GetSR_FTLVL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1800) >> 11
}

// SPI.DR: data register
func (o *SPI_Type) SetDR(value uint32) {
	volatile.StoreUint32(&o.DR.Reg, volatile.LoadUint32(&o.DR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetDR() uint32 {
	return volatile.LoadUint32(&o.DR.Reg) & 0xffff
}

// SPI.CRCPR: CRC polynomial register
func (o *SPI_Type) SetCRCPR_CRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPR.Reg, volatile.LoadUint32(&o.CRCPR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetCRCPR_CRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPR.Reg) & 0xffff
}

// SPI.RXCRCR: RX CRC register
func (o *SPI_Type) SetRXCRCR_RxCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRCR.Reg, volatile.LoadUint32(&o.RXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRXCRCR_RxCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRCR.Reg) & 0xffff
}

// SPI.TXCRCR: TX CRC register
func (o *SPI_Type) SetTXCRCR_TxCRC(value uint32) {
	volatile.StoreUint32(&o.TXCRCR.Reg, volatile.LoadUint32(&o.TXCRCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTXCRCR_TxCRC() uint32 {
	return volatile.LoadUint32(&o.TXCRCR.Reg) & 0xffff
}

// SPI.I2SCFGR: I2S configuration register
func (o *SPI_Type) SetI2SCFGR_I2SMOD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x800)|value<<11)
}
func (o *SPI_Type) GetI2SCFGR_I2SMOD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x800) >> 11
}
func (o *SPI_Type) SetI2SCFGR_I2SE(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetI2SCFGR_I2SE() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetI2SCFGR_I2SCFG(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x300)|value<<8)
}
func (o *SPI_Type) GetI2SCFGR_I2SCFG() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x300) >> 8
}
func (o *SPI_Type) SetI2SCFGR_PCMSYNC(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetI2SCFGR_PCMSYNC() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetI2SCFGR_I2SSTD(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x30)|value<<4)
}
func (o *SPI_Type) GetI2SCFGR_I2SSTD() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x30) >> 4
}
func (o *SPI_Type) SetI2SCFGR_CKPOL(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetI2SCFGR_CKPOL() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetI2SCFGR_DATLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x6)|value<<1)
}
func (o *SPI_Type) GetI2SCFGR_DATLEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x6) >> 1
}
func (o *SPI_Type) SetI2SCFGR_CHLEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetI2SCFGR_CHLEN() uint32 {
	return volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1
}
func (o *SPI_Type) SetI2SCFGR_ASTRTEN(value uint32) {
	volatile.StoreUint32(&o.I2SCFGR.Reg, volatile.LoadUint32(&o.I2SCFGR.Reg)&^(0x1000)|value<<12)
}
func (o *SPI_Type) GetI2SCFGR_ASTRTEN() uint32 {
	return (volatile.LoadUint32(&o.I2SCFGR.Reg) & 0x1000) >> 12
}

// SPI.I2SPR: I2S prescaler register
func (o *SPI_Type) SetI2SPR_MCKOE(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetI2SPR_MCKOE() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetI2SPR_ODD(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetI2SPR_ODD() uint32 {
	return (volatile.LoadUint32(&o.I2SPR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetI2SPR_I2SDIV(value uint32) {
	volatile.StoreUint32(&o.I2SPR.Reg, volatile.LoadUint32(&o.I2SPR.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetI2SPR_I2SDIV() uint32 {
	return volatile.LoadUint32(&o.I2SPR.Reg) & 0xff
}

// System configuration controller
type SYSCFG_Type struct {
	MEMRMP  volatile.Register32 // 0x0
	PMC     volatile.Register32 // 0x4
	EXTICR1 volatile.Register32 // 0x8
	EXTICR2 volatile.Register32 // 0xC
	EXTICR3 volatile.Register32 // 0x10
	EXTICR4 volatile.Register32 // 0x14
	_       [8]byte
	CMPCR   volatile.Register32 // 0x20
}

// SYSCFG.MEMRMP: memory remap register
func (o *SYSCFG_Type) SetMEMRMP_MEM_BOOT(value uint32) {
	volatile.StoreUint32(&o.MEMRMP.Reg, volatile.LoadUint32(&o.MEMRMP.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetMEMRMP_MEM_BOOT() uint32 {
	return volatile.LoadUint32(&o.MEMRMP.Reg) & 0x1
}
func (o *SYSCFG_Type) SetMEMRMP_SWP_FMC(value uint32) {
	volatile.StoreUint32(&o.MEMRMP.Reg, volatile.LoadUint32(&o.MEMRMP.Reg)&^(0xc00)|value<<10)
}
func (o *SYSCFG_Type) GetMEMRMP_SWP_FMC() uint32 {
	return (volatile.LoadUint32(&o.MEMRMP.Reg) & 0xc00) >> 10
}

// SYSCFG.PMC: peripheral mode configuration register
func (o *SYSCFG_Type) SetPMC_PB7_FMP(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x20)|value<<5)
}
func (o *SYSCFG_Type) GetPMC_PB7_FMP() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x20) >> 5
}
func (o *SYSCFG_Type) SetPMC_PB8_FMP(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x40)|value<<6)
}
func (o *SYSCFG_Type) GetPMC_PB8_FMP() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x40) >> 6
}
func (o *SYSCFG_Type) SetPMC_PB9_FMP(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x80)|value<<7)
}
func (o *SYSCFG_Type) GetPMC_PB9_FMP() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x80) >> 7
}
func (o *SYSCFG_Type) SetPMC_ADC1DC2(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x10000)|value<<16)
}
func (o *SYSCFG_Type) GetPMC_ADC1DC2() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x10000) >> 16
}
func (o *SYSCFG_Type) SetPMC_PB6_FMP(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x10)|value<<4)
}
func (o *SYSCFG_Type) GetPMC_PB6_FMP() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x10) >> 4
}
func (o *SYSCFG_Type) SetPMC_I2C3_FMP(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x4)|value<<2)
}
func (o *SYSCFG_Type) GetPMC_I2C3_FMP() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x4) >> 2
}
func (o *SYSCFG_Type) SetPMC_I2C2_FMP(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x2)|value<<1)
}
func (o *SYSCFG_Type) GetPMC_I2C2_FMP() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x2) >> 1
}
func (o *SYSCFG_Type) SetPMC_I2C1_FMP(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetPMC_I2C1_FMP() uint32 {
	return volatile.LoadUint32(&o.PMC.Reg) & 0x1
}
func (o *SYSCFG_Type) SetPMC_ADC3DC2(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x40000)|value<<18)
}
func (o *SYSCFG_Type) GetPMC_ADC3DC2() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x40000) >> 18
}
func (o *SYSCFG_Type) SetPMC_ADC2DC2(value uint32) {
	volatile.StoreUint32(&o.PMC.Reg, volatile.LoadUint32(&o.PMC.Reg)&^(0x20000)|value<<17)
}
func (o *SYSCFG_Type) GetPMC_ADC2DC2() uint32 {
	return (volatile.LoadUint32(&o.PMC.Reg) & 0x20000) >> 17
}

// SYSCFG.EXTICR1: external interrupt configuration register 1
func (o *SYSCFG_Type) SetEXTICR1_EXTI3(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI3() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI2(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI2() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI1(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI1() uint32 {
	return (volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR1_EXTI0(value uint32) {
	volatile.StoreUint32(&o.EXTICR1.Reg, volatile.LoadUint32(&o.EXTICR1.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR1_EXTI0() uint32 {
	return volatile.LoadUint32(&o.EXTICR1.Reg) & 0xf
}

// SYSCFG.EXTICR2: external interrupt configuration register 2
func (o *SYSCFG_Type) SetEXTICR2_EXTI7(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI7() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI6(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI6() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI5(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI5() uint32 {
	return (volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR2_EXTI4(value uint32) {
	volatile.StoreUint32(&o.EXTICR2.Reg, volatile.LoadUint32(&o.EXTICR2.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR2_EXTI4() uint32 {
	return volatile.LoadUint32(&o.EXTICR2.Reg) & 0xf
}

// SYSCFG.EXTICR3: external interrupt configuration register 3
func (o *SYSCFG_Type) SetEXTICR3_EXTI11(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI11() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI10(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI10() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI9(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI9() uint32 {
	return (volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR3_EXTI8(value uint32) {
	volatile.StoreUint32(&o.EXTICR3.Reg, volatile.LoadUint32(&o.EXTICR3.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR3_EXTI8() uint32 {
	return volatile.LoadUint32(&o.EXTICR3.Reg) & 0xf
}

// SYSCFG.EXTICR4: external interrupt configuration register 4
func (o *SYSCFG_Type) SetEXTICR4_EXTI15(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf000)|value<<12)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI15() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf000) >> 12
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI14(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf00)|value<<8)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI14() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf00) >> 8
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI13(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf0)|value<<4)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI13() uint32 {
	return (volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf0) >> 4
}
func (o *SYSCFG_Type) SetEXTICR4_EXTI12(value uint32) {
	volatile.StoreUint32(&o.EXTICR4.Reg, volatile.LoadUint32(&o.EXTICR4.Reg)&^(0xf)|value)
}
func (o *SYSCFG_Type) GetEXTICR4_EXTI12() uint32 {
	return volatile.LoadUint32(&o.EXTICR4.Reg) & 0xf
}

// SYSCFG.CMPCR: Compensation cell control register
func (o *SYSCFG_Type) SetCMPCR_READY(value uint32) {
	volatile.StoreUint32(&o.CMPCR.Reg, volatile.LoadUint32(&o.CMPCR.Reg)&^(0x100)|value<<8)
}
func (o *SYSCFG_Type) GetCMPCR_READY() uint32 {
	return (volatile.LoadUint32(&o.CMPCR.Reg) & 0x100) >> 8
}
func (o *SYSCFG_Type) SetCMPCR_CMP_PD(value uint32) {
	volatile.StoreUint32(&o.CMPCR.Reg, volatile.LoadUint32(&o.CMPCR.Reg)&^(0x1)|value)
}
func (o *SYSCFG_Type) GetCMPCR_CMP_PD() uint32 {
	return volatile.LoadUint32(&o.CMPCR.Reg) & 0x1
}

// Universal synchronous asynchronous receiver transmitter
type USART_Type struct {
	CR1  volatile.Register32 // 0x0
	CR2  volatile.Register32 // 0x4
	CR3  volatile.Register32 // 0x8
	BRR  volatile.Register32 // 0xC
	GTPR volatile.Register32 // 0x10
	RTOR volatile.Register32 // 0x14
	RQR  volatile.Register32 // 0x18
	ISR  volatile.Register32 // 0x1C
	ICR  volatile.Register32 // 0x20
	RDR  volatile.Register32 // 0x24
	TDR  volatile.Register32 // 0x28
}

// USART.CR1: Control register 1
func (o *USART_Type) SetCR1_M1(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetCR1_M1() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10000000) >> 28
}
func (o *USART_Type) SetCR1_EOBIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000000)|value<<27)
}
func (o *USART_Type) GetCR1_EOBIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000000) >> 27
}
func (o *USART_Type) SetCR1_RTOIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000000)|value<<26)
}
func (o *USART_Type) GetCR1_RTOIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000000) >> 26
}
func (o *USART_Type) SetCR1_OVER8(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR1_OVER8() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR1_CMIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR1_CMIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR1_MME(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR1_MME() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR1_M0(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR1_M0() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR1_WAKE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR1_WAKE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR1_PCE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR1_PCE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR1_PS(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR1_PS() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR1_PEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR1_PEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR1_TXEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR1_TXEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR1_TCIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR1_TCIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR1_RXNEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR1_RXNEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR1_IDLEIE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR1_IDLEIE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR1_TE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR1_TE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR1_RE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR1_RE() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR1_UE(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR1_UE() uint32 {
	return volatile.LoadUint32(&o.CR1.Reg) & 0x1
}
func (o *USART_Type) SetCR1_DEAT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x3e00000)|value<<21)
}
func (o *USART_Type) GetCR1_DEAT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x3e00000) >> 21
}
func (o *USART_Type) SetCR1_DEDT(value uint32) {
	volatile.StoreUint32(&o.CR1.Reg, volatile.LoadUint32(&o.CR1.Reg)&^(0x1f0000)|value<<16)
}
func (o *USART_Type) GetCR1_DEDT() uint32 {
	return (volatile.LoadUint32(&o.CR1.Reg) & 0x1f0000) >> 16
}

// USART.CR2: Control register 2
func (o *USART_Type) SetCR2_RTOEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCR2_RTOEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetCR2_ABREN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetCR2_ABREN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetCR2_MSBFIRST(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR2_MSBFIRST() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCR2_DATAINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR2_DATAINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR2_TXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetCR2_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetCR2_RXINV(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetCR2_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetCR2_SWAP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR2_SWAP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR2_LINEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR2_LINEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR2_STOP(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetCR2_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR2_CLKEN() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR2_CPHA(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR2_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR2_LBCL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR2_LBCL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR2_LBDIE(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR2_LBDIE() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR2_LBDL(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR2_LBDL() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR2_ADDM7(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR2_ADDM7() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR2_ADD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetCR2_ADD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0xff000000) >> 24
}
func (o *USART_Type) SetCR2_ABRMOD(value uint32) {
	volatile.StoreUint32(&o.CR2.Reg, volatile.LoadUint32(&o.CR2.Reg)&^(0x600000)|value<<21)
}
func (o *USART_Type) GetCR2_ABRMOD() uint32 {
	return (volatile.LoadUint32(&o.CR2.Reg) & 0x600000) >> 21
}

// USART.CR3: Control register 3
func (o *USART_Type) SetCR3_SCARCNT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0xe0000)|value<<17)
}
func (o *USART_Type) GetCR3_SCARCNT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0xe0000) >> 17
}
func (o *USART_Type) SetCR3_DEP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR3_DEP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR3_DEM(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR3_DEM() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR3_DDRE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR3_DDRE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR3_OVRDIS(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR3_OVRDIS() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR3_ONEBIT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR3_ONEBIT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR3_CTSIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR3_CTSIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR3_CTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR3_CTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR3_RTSE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR3_RTSE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR3_DMAT(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR3_DMAT() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR3_DMAR(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR3_DMAR() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR3_SCEN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR3_SCEN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR3_NACK(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR3_NACK() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR3_HDSEL(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR3_HDSEL() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR3_IRLP(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR3_IRLP() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR3_IREN(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCR3_IREN() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCR3_EIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCR3_EIE() uint32 {
	return volatile.LoadUint32(&o.CR3.Reg) & 0x1
}
func (o *USART_Type) SetCR3_TCBGTIE(value uint32) {
	volatile.StoreUint32(&o.CR3.Reg, volatile.LoadUint32(&o.CR3.Reg)&^(0x1000000)|value<<24)
}
func (o *USART_Type) GetCR3_TCBGTIE() uint32 {
	return (volatile.LoadUint32(&o.CR3.Reg) & 0x1000000) >> 24
}

// USART.BRR: Baud rate register
func (o *USART_Type) SetBRR(value uint32) {
	volatile.StoreUint32(&o.BRR.Reg, volatile.LoadUint32(&o.BRR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRR() uint32 {
	return volatile.LoadUint32(&o.BRR.Reg) & 0xffff
}

// USART.GTPR: Guard time and prescaler register
func (o *USART_Type) SetGTPR_GT(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff00)|value<<8)
}
func (o *USART_Type) GetGTPR_GT() uint32 {
	return (volatile.LoadUint32(&o.GTPR.Reg) & 0xff00) >> 8
}
func (o *USART_Type) SetGTPR_PSC(value uint32) {
	volatile.StoreUint32(&o.GTPR.Reg, volatile.LoadUint32(&o.GTPR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetGTPR_PSC() uint32 {
	return volatile.LoadUint32(&o.GTPR.Reg) & 0xff
}

// USART.RTOR: Receiver timeout register
func (o *USART_Type) SetRTOR_BLEN(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xff000000)|value<<24)
}
func (o *USART_Type) GetRTOR_BLEN() uint32 {
	return (volatile.LoadUint32(&o.RTOR.Reg) & 0xff000000) >> 24
}
func (o *USART_Type) SetRTOR_RTO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffffff)|value)
}
func (o *USART_Type) GetRTOR_RTO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffffff
}

// USART.RQR: Request register
func (o *USART_Type) SetRQR_TXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetRQR_TXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetRQR_RXFRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetRQR_RXFRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetRQR_MMRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetRQR_MMRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetRQR_SBKRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetRQR_SBKRQ() uint32 {
	return (volatile.LoadUint32(&o.RQR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetRQR_ABRRQ(value uint32) {
	volatile.StoreUint32(&o.RQR.Reg, volatile.LoadUint32(&o.RQR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetRQR_ABRRQ() uint32 {
	return volatile.LoadUint32(&o.RQR.Reg) & 0x1
}

// USART.ISR: Interrupt & status register
func (o *USART_Type) SetISR_TEACK(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetISR_TEACK() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetISR_SBKF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetISR_SBKF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetISR_CMF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetISR_CMF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetISR_BUSY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetISR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetISR_ABRF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetISR_ABRF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetISR_ABRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetISR_ABRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetISR_EOBF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetISR_EOBF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetISR_RTOF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetISR_RTOF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetISR_CTS(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetISR_CTS() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetISR_CTSIF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetISR_CTSIF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetISR_LBDF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetISR_LBDF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetISR_TXE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetISR_TXE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetISR_TC(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetISR_TC() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetISR_RXNE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetISR_RXNE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetISR_IDLE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetISR_IDLE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetISR_ORE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetISR_ORE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetISR_NF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetISR_NF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetISR_FE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetISR_FE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetISR_PE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetISR_PE() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *USART_Type) SetISR_TCBGT(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *USART_Type) GetISR_TCBGT() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}

// USART.ICR: Interrupt flag clear register
func (o *USART_Type) SetICR_CMCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetICR_CMCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetICR_EOBCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetICR_EOBCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetICR_RTOCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetICR_RTOCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetICR_CTSCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetICR_CTSCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetICR_LBDCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetICR_LBDCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetICR_TCCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetICR_TCCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetICR_IDLECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetICR_IDLECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetICR_ORECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetICR_ORECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetICR_NCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetICR_NCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetICR_FECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetICR_FECF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetICR_PECF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetICR_PECF() uint32 {
	return volatile.LoadUint32(&o.ICR.Reg) & 0x1
}
func (o *USART_Type) SetICR_TCBGTCF(value uint32) {
	volatile.StoreUint32(&o.ICR.Reg, volatile.LoadUint32(&o.ICR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetICR_TCBGTCF() uint32 {
	return (volatile.LoadUint32(&o.ICR.Reg) & 0x80) >> 7
}

// USART.RDR: Receive data register
func (o *USART_Type) SetRDR(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRDR() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0x1ff
}

// USART.TDR: Transmit data register
func (o *USART_Type) SetTDR(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTDR() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0x1ff
}

// USB on the go full speed
type USB_OTG_FS_Type struct {
	OTG_FS_GOTGCTL         volatile.Register32 // 0x0
	OTG_FS_GOTGINT         volatile.Register32 // 0x4
	OTG_FS_GAHBCFG         volatile.Register32 // 0x8
	OTG_FS_GUSBCFG         volatile.Register32 // 0xC
	OTG_FS_GRSTCTL         volatile.Register32 // 0x10
	OTG_FS_GINTSTS         volatile.Register32 // 0x14
	OTG_FS_GINTMSK         volatile.Register32 // 0x18
	OTG_FS_GRXSTSR_Device  volatile.Register32 // 0x1C
	OTG_FS_GRXSTSP_Device  volatile.Register32 // 0x20
	OTG_FS_GRXFSIZ         volatile.Register32 // 0x24
	OTG_FS_DIEPTXF0_Device volatile.Register32 // 0x28
	OTG_FS_HNPTXSTS        volatile.Register32 // 0x2C
	OTG_FS_GI2CCTL         volatile.Register32 // 0x30
	_                      [4]byte
	OTG_FS_GCCFG           volatile.Register32 // 0x38
	OTG_FS_CID             volatile.Register32 // 0x3C
	_                      [20]byte
	OTG_FS_GLPMCFG         volatile.Register32 // 0x54
	_                      [168]byte
	OTG_FS_HPTXFSIZ        volatile.Register32 // 0x100
	OTG_FS_DIEPTXF1        volatile.Register32 // 0x104
	OTG_FS_DIEPTXF2        volatile.Register32 // 0x108
	OTG_FS_DIEPTXF3        volatile.Register32 // 0x10C
	OTG_FS_DIEPTXF4        volatile.Register32 // 0x110
	OTG_FS_DIEPTXF5        volatile.Register32 // 0x114
}

// USB_OTG_FS.OTG_FS_GOTGCTL: OTG_FS control and status register (OTG_FS_GOTGCTL)
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_SRQSCS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_SRQSCS() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_SRQ(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_SRQ() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_HNGSCS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_HNGSCS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_HNPRQ(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_HNPRQ() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_HSHNPEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_HSHNPEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_DHNPEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_DHNPEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x800) >> 11
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_CIDSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_CIDSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_DBCT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_DBCT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_ASVLD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_ASVLD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_BSVLD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_BSVLD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_VBVALOEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_VBVALOEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_VBVALOVAL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_VBVALOVAL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_AVALOEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_AVALOEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_AVALOVAL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_AVALOVAL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_BVALOEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_BVALOEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_BVALOVAL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_BVALOVAL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_EHEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_EHEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGCTL_OTGVER(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGCTL_OTGVER() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGCTL.Reg) & 0x100000) >> 20
}

// USB_OTG_FS.OTG_FS_GOTGINT: OTG_FS interrupt register (OTG_FS_GOTGINT)
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_SEDET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_SEDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_SRSSCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_SRSSCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_HNSSCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_HNSSCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_HNGDET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_HNGDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_ADTOCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_ADTOCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_DBCDNE(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_DBCDNE() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GOTGINT_IDCHNG(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GOTGINT.Reg, volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GOTGINT_IDCHNG() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GOTGINT.Reg) & 0x100000) >> 20
}

// USB_OTG_FS.OTG_FS_GAHBCFG: OTG_FS AHB configuration register (OTG_FS_GAHBCFG)
func (o *USB_OTG_FS_Type) SetOTG_FS_GAHBCFG_GINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GAHBCFG.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GAHBCFG_GINT() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GAHBCFG.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GAHBCFG_TXFELVL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GAHBCFG.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GAHBCFG_TXFELVL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GAHBCFG.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GAHBCFG_PTXFELVL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GAHBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GAHBCFG.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GAHBCFG_PTXFELVL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GAHBCFG.Reg) & 0x100) >> 8
}

// USB_OTG_FS.OTG_FS_GUSBCFG: OTG_FS USB configuration register (OTG_FS_GUSBCFG)
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_TOCAL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x7)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_TOCAL() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x7
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_PHYSEL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_PHYSEL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_SRPCAP(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_SRPCAP() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x100) >> 8
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_HNPCAP(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_HNPCAP() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x200) >> 9
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_TRDT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x3c00)|value<<10)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_TRDT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x3c00) >> 10
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_FHMOD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_FHMOD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GUSBCFG_FDMOD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GUSBCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GUSBCFG_FDMOD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GUSBCFG.Reg) & 0x40000000) >> 30
}

// USB_OTG_FS.OTG_FS_GRSTCTL: OTG_FS reset register (OTG_FS_GRSTCTL)
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_CSRST(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_CSRST() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_HSRST(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_HSRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_FCRST(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_FCRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_RXFFLSH(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_RXFFLSH() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_TXFFLSH(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_TXFFLSH() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_TXFNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x7c0)|value<<6)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_TXFNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x7c0) >> 6
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRSTCTL_AHBIDL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRSTCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRSTCTL_AHBIDL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRSTCTL.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.OTG_FS_GINTSTS: OTG_FS core interrupt register (OTG_FS_GINTSTS)
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_CMOD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_CMOD() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_MMIS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_MMIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_OTGINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_OTGINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_SOF(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_SOF() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_RXFLVL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_RXFLVL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_NPTXFE(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_NPTXFE() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_GINAKEFF(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_GINAKEFF() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_GOUTNAKEFF(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_GOUTNAKEFF() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_ESUSP(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_ESUSP() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_USBSUSP(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_USBSUSP() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x800) >> 11
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_USBRST(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_USBRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_ENUMDNE(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_ENUMDNE() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x2000) >> 13
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_ISOODRP(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x4000)|value<<14)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_ISOODRP() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x4000) >> 14
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_EOPF(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_EOPF() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_IEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_IEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_OEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_IISOIXFR(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_IISOIXFR() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_IPXFR_INCOMPISOOUT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_IPXFR_INCOMPISOOUT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_HPRTINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_HPRTINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_HCINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_HCINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_PTXFE(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_PTXFE() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_CIDSCHG(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_CIDSCHG() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_DISCINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_DISCINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_SRQINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_SRQINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_WKUPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_WKUPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTSTS_RSTDET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTSTS.Reg, volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg)&^(0x800000)|value<<23)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTSTS_RSTDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTSTS.Reg) & 0x800000) >> 23
}

// USB_OTG_FS.OTG_FS_GINTMSK: OTG_FS interrupt mask register (OTG_FS_GINTMSK)
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_MMISM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_MMISM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_OTGINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_OTGINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_SOFM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_SOFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x8) >> 3
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_RXFLVLM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_RXFLVLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x10) >> 4
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_NPTXFEM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_NPTXFEM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x20) >> 5
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_GINAKEFFM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_GINAKEFFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_GONAKEFFM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_GONAKEFFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_ESUSPM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_ESUSPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x400) >> 10
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_USBSUSPM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x800)|value<<11)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_USBSUSPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x800) >> 11
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_USBRST(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_USBRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_ENUMDNEM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x2000)|value<<13)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_ENUMDNEM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x2000) >> 13
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_ISOODRPM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x4000)|value<<14)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_ISOODRPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x4000) >> 14
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_EOPFM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_EOPFM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_IEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_IEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_OEPINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_OEPINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_IISOIXFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_IISOIXFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_IPXFRM_IISOOXFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_IPXFRM_IISOOXFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_PRTIM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_PRTIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_HCIM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x2000000)|value<<25)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_HCIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x2000000) >> 25
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_PTXFEM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x4000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_PTXFEM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x4000000) >> 26
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_CIDSCHGM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_CIDSCHGM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_DISCINT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_DISCINT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_SRQIM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_SRQIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_WUIM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_WUIM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x80000000) >> 31
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_RSTDETM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x800000)|value<<23)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_RSTDETM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x800000) >> 23
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GINTMSK_LPMIN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GINTMSK.Reg, volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg)&^(0x8000000)|value<<27)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GINTMSK_LPMIN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GINTMSK.Reg) & 0x8000000) >> 27
}

// USB_OTG_FS.OTG_FS_GRXSTSR_Device: OTG_FS Receive status debug read(Device mode)
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSR_Device_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg)&^(0xf)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSR_Device_EPNUM() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg) & 0xf
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSR_Device_BCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg)&^(0x7ff0)|value<<4)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSR_Device_BCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg) & 0x7ff0) >> 4
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSR_Device_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg)&^(0x18000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSR_Device_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg) & 0x18000) >> 15
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSR_Device_PKTSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg)&^(0x1e0000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSR_Device_PKTSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg) & 0x1e0000) >> 17
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSR_Device_FRMNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSR_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg)&^(0x1e00000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSR_Device_FRMNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSR_Device.Reg) & 0x1e00000) >> 21
}

// USB_OTG_FS.OTG_FS_GRXSTSP_Device: OTG status read and pop register (Device mode)
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSP_Device_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSP_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg)&^(0xf)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSP_Device_EPNUM() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg) & 0xf
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSP_Device_BCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSP_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg)&^(0x7ff0)|value<<4)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSP_Device_BCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg) & 0x7ff0) >> 4
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSP_Device_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSP_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg)&^(0x18000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSP_Device_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg) & 0x18000) >> 15
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSP_Device_PKTSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSP_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg)&^(0x1e0000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSP_Device_PKTSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg) & 0x1e0000) >> 17
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXSTSP_Device_FRMNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXSTSP_Device.Reg, volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg)&^(0x1e00000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXSTSP_Device_FRMNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GRXSTSP_Device.Reg) & 0x1e00000) >> 21
}

// USB_OTG_FS.OTG_FS_GRXFSIZ: OTG_FS Receive FIFO size register (OTG_FS_GRXFSIZ)
func (o *USB_OTG_FS_Type) SetOTG_FS_GRXFSIZ_RXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GRXFSIZ.Reg, volatile.LoadUint32(&o.OTG_FS_GRXFSIZ.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GRXFSIZ_RXFD() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GRXFSIZ.Reg) & 0xffff
}

// USB_OTG_FS.OTG_FS_DIEPTXF0_Device: OTG_FS Endpoint 0 Transmit FIFO size
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF0_Device_TX0FSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF0_Device.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF0_Device.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF0_Device_TX0FSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_DIEPTXF0_Device.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF0_Device_TX0FD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF0_Device.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF0_Device.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF0_Device_TX0FD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_DIEPTXF0_Device.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.OTG_FS_HNPTXSTS: OTG_FS non-periodic transmit FIFO/queue status register (OTG_FS_GNPTXSTS)
func (o *USB_OTG_FS_Type) SetOTG_FS_HNPTXSTS_NPTXFSAV(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_HNPTXSTS.Reg, volatile.LoadUint32(&o.OTG_FS_HNPTXSTS.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_HNPTXSTS_NPTXFSAV() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_HNPTXSTS.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_HNPTXSTS_NPTQXSAV(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_HNPTXSTS.Reg, volatile.LoadUint32(&o.OTG_FS_HNPTXSTS.Reg)&^(0xff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_HNPTXSTS_NPTQXSAV() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_HNPTXSTS.Reg) & 0xff0000) >> 16
}
func (o *USB_OTG_FS_Type) SetOTG_FS_HNPTXSTS_NPTXQTOP(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_HNPTXSTS.Reg, volatile.LoadUint32(&o.OTG_FS_HNPTXSTS.Reg)&^(0x7f000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_HNPTXSTS_NPTXQTOP() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_HNPTXSTS.Reg) & 0x7f000000) >> 24
}

// USB_OTG_FS.OTG_FS_GI2CCTL: OTG I2C access register
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_RWDATA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0xff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_RWDATA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0xff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_REGADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0xff00)|value<<8)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_REGADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0xff00) >> 8
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_ADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0x7f0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_ADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0x7f0000) >> 16
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_I2CEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0x800000)|value<<23)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_I2CEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0x800000) >> 23
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_I2CDEVADR(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0xc000000)|value<<26)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_I2CDEVADR() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0xc000000) >> 26
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_I2CDATSE0(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_I2CDATSE0() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0x10000000) >> 28
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_RW(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_RW() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GI2CCTL_BSYDNE(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GI2CCTL.Reg, volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GI2CCTL_BSYDNE() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GI2CCTL.Reg) & 0x80000000) >> 31
}

// USB_OTG_FS.OTG_FS_GCCFG: OTG_FS general core configuration register (OTG_FS_GCCFG)
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_PWRDWN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_PWRDWN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_BCDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_BCDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_DCDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x40000)|value<<18)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_DCDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x40000) >> 18
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_PDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x80000)|value<<19)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_PDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x80000) >> 19
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_SDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x100000)|value<<20)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_SDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x100000) >> 20
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_VBDEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x200000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_VBDEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x200000) >> 21
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_DCDET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_DCDET() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_PDET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_PDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_SDET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_SDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x4) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GCCFG_PS2DET(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GCCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GCCFG_PS2DET() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GCCFG.Reg) & 0x8) >> 3
}

// USB_OTG_FS.OTG_FS_CID: core ID register
func (o *USB_OTG_FS_Type) SetOTG_FS_CID(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_CID.Reg, value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_CID() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_CID.Reg)
}

// USB_OTG_FS.OTG_FS_GLPMCFG: OTG core LPM configuration register
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_LPMEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x1)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_LPMEN() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_LPMACK(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_LPMACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x2) >> 1
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_BESL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x3c)|value<<2)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_BESL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x3c) >> 2
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_REMWAKE(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_REMWAKE() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x40) >> 6
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_L1SSEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_L1SSEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x80) >> 7
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_BESLTHRS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0xf00)|value<<8)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_BESLTHRS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0xf00) >> 8
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_L1DSEN(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_L1DSEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_LPMRST(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x6000)|value<<13)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_LPMRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x6000) >> 13
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_SLPSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_SLPSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_L1RSMOK(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_L1RSMOK() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_LPMCHIDX(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x1e0000)|value<<17)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_LPMCHIDX() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x1e0000) >> 17
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_LPMRCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0xe00000)|value<<21)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_LPMRCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0xe00000) >> 21
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_SNDLPM(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x1000000)|value<<24)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_SNDLPM() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x1000000) >> 24
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_LPMRCNTSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0xe000000)|value<<25)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_LPMRCNTSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0xe000000) >> 25
}
func (o *USB_OTG_FS_Type) SetOTG_FS_GLPMCFG_ENBESL(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_GLPMCFG.Reg, volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg)&^(0x10000000)|value<<28)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_GLPMCFG_ENBESL() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_GLPMCFG.Reg) & 0x10000000) >> 28
}

// USB_OTG_FS.OTG_FS_HPTXFSIZ: OTG_FS Host periodic transmit FIFO size register (OTG_FS_HPTXFSIZ)
func (o *USB_OTG_FS_Type) SetOTG_FS_HPTXFSIZ_PTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_HPTXFSIZ.Reg, volatile.LoadUint32(&o.OTG_FS_HPTXFSIZ.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_HPTXFSIZ_PTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_HPTXFSIZ.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_HPTXFSIZ_PTXFSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_HPTXFSIZ.Reg, volatile.LoadUint32(&o.OTG_FS_HPTXFSIZ.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_HPTXFSIZ_PTXFSIZ() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_HPTXFSIZ.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.OTG_FS_DIEPTXF1: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF1)
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF1_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF1.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF1.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF1_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_DIEPTXF1.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF1_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF1.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF1.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF1_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_DIEPTXF1.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.OTG_FS_DIEPTXF2: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF2)
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF2_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF2.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF2.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF2_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_DIEPTXF2.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF2_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF2.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF2.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF2_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_DIEPTXF2.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.OTG_FS_DIEPTXF3: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF3)
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF3_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF3.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF3.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF3_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_DIEPTXF3.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF3_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF3.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF3.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF3_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_DIEPTXF3.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.OTG_FS_DIEPTXF4: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF4)
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF4_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF4.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF4.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF4_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_DIEPTXF4.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF4_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF4.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF4.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF4_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_DIEPTXF4.Reg) & 0xffff0000) >> 16
}

// USB_OTG_FS.OTG_FS_DIEPTXF5: OTG_FS device IN endpoint transmit FIFO size register (OTG_FS_DIEPTXF5)
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF5_INEPTXSA(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF5.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF5.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF5_INEPTXSA() uint32 {
	return volatile.LoadUint32(&o.OTG_FS_DIEPTXF5.Reg) & 0xffff
}
func (o *USB_OTG_FS_Type) SetOTG_FS_DIEPTXF5_INEPTXFD(value uint32) {
	volatile.StoreUint32(&o.OTG_FS_DIEPTXF5.Reg, volatile.LoadUint32(&o.OTG_FS_DIEPTXF5.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_FS_Type) GetOTG_FS_DIEPTXF5_INEPTXFD() uint32 {
	return (volatile.LoadUint32(&o.OTG_FS_DIEPTXF5.Reg) & 0xffff0000) >> 16
}

// USB on the go high speed
type USB_OTG_HS_Type struct {
	OTG_HS_HCFG       volatile.Register32 // 0x0
	OTG_HS_HFIR       volatile.Register32 // 0x4
	OTG_HS_HFNUM      volatile.Register32 // 0x8
	_                 [4]byte
	OTG_HS_HPTXSTS    volatile.Register32 // 0x10
	OTG_HS_HAINT      volatile.Register32 // 0x14
	OTG_HS_HAINTMSK   volatile.Register32 // 0x18
	_                 [36]byte
	OTG_HS_HPRT       volatile.Register32 // 0x40
	_                 [188]byte
	OTG_HS_HCCHAR0    volatile.Register32 // 0x100
	OTG_HS_HCSPLT0    volatile.Register32 // 0x104
	OTG_HS_HCINT0     volatile.Register32 // 0x108
	OTG_HS_HCINTMSK0  volatile.Register32 // 0x10C
	OTG_HS_HCTSIZ0    volatile.Register32 // 0x110
	OTG_HS_HCDMA0     volatile.Register32 // 0x114
	_                 [8]byte
	OTG_HS_HCCHAR1    volatile.Register32 // 0x120
	OTG_HS_HCSPLT1    volatile.Register32 // 0x124
	OTG_HS_HCINT1     volatile.Register32 // 0x128
	OTG_HS_HCINTMSK1  volatile.Register32 // 0x12C
	OTG_HS_HCTSIZ1    volatile.Register32 // 0x130
	OTG_HS_HCDMA1     volatile.Register32 // 0x134
	_                 [8]byte
	OTG_HS_HCCHAR2    volatile.Register32 // 0x140
	OTG_HS_HCSPLT2    volatile.Register32 // 0x144
	OTG_HS_HCINT2     volatile.Register32 // 0x148
	OTG_HS_HCINTMSK2  volatile.Register32 // 0x14C
	OTG_HS_HCTSIZ2    volatile.Register32 // 0x150
	OTG_HS_HCDMA2     volatile.Register32 // 0x154
	_                 [8]byte
	OTG_HS_HCCHAR3    volatile.Register32 // 0x160
	OTG_HS_HCSPLT3    volatile.Register32 // 0x164
	OTG_HS_HCINT3     volatile.Register32 // 0x168
	OTG_HS_HCINTMSK3  volatile.Register32 // 0x16C
	OTG_HS_HCTSIZ3    volatile.Register32 // 0x170
	OTG_HS_HCDMA3     volatile.Register32 // 0x174
	_                 [8]byte
	OTG_HS_HCCHAR4    volatile.Register32 // 0x180
	OTG_HS_HCSPLT4    volatile.Register32 // 0x184
	OTG_HS_HCINT4     volatile.Register32 // 0x188
	OTG_HS_HCINTMSK4  volatile.Register32 // 0x18C
	OTG_HS_HCTSIZ4    volatile.Register32 // 0x190
	OTG_HS_HCDMA4     volatile.Register32 // 0x194
	_                 [8]byte
	OTG_HS_HCCHAR5    volatile.Register32 // 0x1A0
	OTG_HS_HCSPLT5    volatile.Register32 // 0x1A4
	OTG_HS_HCINT5     volatile.Register32 // 0x1A8
	OTG_HS_HCINTMSK5  volatile.Register32 // 0x1AC
	OTG_HS_HCTSIZ5    volatile.Register32 // 0x1B0
	OTG_HS_HCDMA5     volatile.Register32 // 0x1B4
	_                 [8]byte
	OTG_HS_HCCHAR6    volatile.Register32 // 0x1C0
	OTG_HS_HCSPLT6    volatile.Register32 // 0x1C4
	OTG_HS_HCINT6     volatile.Register32 // 0x1C8
	OTG_HS_HCINTMSK6  volatile.Register32 // 0x1CC
	OTG_HS_HCTSIZ6    volatile.Register32 // 0x1D0
	OTG_HS_HCDMA6     volatile.Register32 // 0x1D4
	_                 [8]byte
	OTG_HS_HCCHAR7    volatile.Register32 // 0x1E0
	OTG_HS_HCSPLT7    volatile.Register32 // 0x1E4
	OTG_HS_HCINT7     volatile.Register32 // 0x1E8
	OTG_HS_HCINTMSK7  volatile.Register32 // 0x1EC
	OTG_HS_HCTSIZ7    volatile.Register32 // 0x1F0
	OTG_HS_HCDMA7     volatile.Register32 // 0x1F4
	_                 [8]byte
	OTG_HS_HCCHAR8    volatile.Register32 // 0x200
	OTG_HS_HCSPLT8    volatile.Register32 // 0x204
	OTG_HS_HCINT8     volatile.Register32 // 0x208
	OTG_HS_HCINTMSK8  volatile.Register32 // 0x20C
	OTG_HS_HCTSIZ8    volatile.Register32 // 0x210
	OTG_HS_HCDMA8     volatile.Register32 // 0x214
	_                 [8]byte
	OTG_HS_HCCHAR9    volatile.Register32 // 0x220
	OTG_HS_HCSPLT9    volatile.Register32 // 0x224
	OTG_HS_HCINT9     volatile.Register32 // 0x228
	OTG_HS_HCINTMSK9  volatile.Register32 // 0x22C
	OTG_HS_HCTSIZ9    volatile.Register32 // 0x230
	OTG_HS_HCDMA9     volatile.Register32 // 0x234
	_                 [8]byte
	OTG_HS_HCCHAR10   volatile.Register32 // 0x240
	OTG_HS_HCSPLT10   volatile.Register32 // 0x244
	OTG_HS_HCINT10    volatile.Register32 // 0x248
	OTG_HS_HCINTMSK10 volatile.Register32 // 0x24C
	OTG_HS_HCTSIZ10   volatile.Register32 // 0x250
	OTG_HS_HCDMA10    volatile.Register32 // 0x254
	_                 [8]byte
	OTG_HS_HCCHAR11   volatile.Register32 // 0x260
	OTG_HS_HCSPLT11   volatile.Register32 // 0x264
	OTG_HS_HCINT11    volatile.Register32 // 0x268
	OTG_HS_HCINTMSK11 volatile.Register32 // 0x26C
	OTG_HS_HCTSIZ11   volatile.Register32 // 0x270
	OTG_HS_HCDMA11    volatile.Register32 // 0x274
	_                 [8]byte
	OTG_HS_HCCHAR12   volatile.Register32 // 0x280
	OTG_HS_HCSPLT12   volatile.Register32 // 0x284
	OTG_HS_HCINT12    volatile.Register32 // 0x288
	OTG_HS_HCINTMSK12 volatile.Register32 // 0x28C
	OTG_HS_HCTSIZ12   volatile.Register32 // 0x290
	OTG_HS_HCDMA12    volatile.Register32 // 0x294
	_                 [8]byte
	OTG_HS_HCCHAR13   volatile.Register32 // 0x2A0
	OTG_HS_HCSPLT13   volatile.Register32 // 0x2A4
	OTG_HS_HCINT13    volatile.Register32 // 0x2A8
	OTG_HS_HCINTMSK13 volatile.Register32 // 0x2AC
	OTG_HS_HCTSIZ13   volatile.Register32 // 0x2B0
	OTG_HS_HCDMA13    volatile.Register32 // 0x2B4
	_                 [8]byte
	OTG_HS_HCCHAR14   volatile.Register32 // 0x2C0
	OTG_HS_HCSPLT14   volatile.Register32 // 0x2C4
	OTG_HS_HCINT14    volatile.Register32 // 0x2C8
	OTG_HS_HCINTMSK14 volatile.Register32 // 0x2CC
	OTG_HS_HCTSIZ14   volatile.Register32 // 0x2D0
	OTG_HS_HCDMA14    volatile.Register32 // 0x2D4
	_                 [8]byte
	OTG_HS_HCCHAR15   volatile.Register32 // 0x2E0
	OTG_HS_HCSPLT15   volatile.Register32 // 0x2E4
	OTG_HS_HCINT15    volatile.Register32 // 0x2E8
	OTG_HS_HCINTMSK15 volatile.Register32 // 0x2EC
	OTG_HS_HCTSIZ15   volatile.Register32 // 0x2F0
	OTG_HS_HCDMA15    volatile.Register32 // 0x2F4
}

// USB_OTG_HS.OTG_HS_HCFG: OTG_HS host configuration register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCFG_FSLSPCS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCFG.Reg, volatile.LoadUint32(&o.OTG_HS_HCFG.Reg)&^(0x3)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCFG_FSLSPCS() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCFG.Reg) & 0x3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCFG_FSLSS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCFG.Reg, volatile.LoadUint32(&o.OTG_HS_HCFG.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCFG_FSLSS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCFG.Reg) & 0x4) >> 2
}

// USB_OTG_HS.OTG_HS_HFIR: OTG_HS Host frame interval register
func (o *USB_OTG_HS_Type) SetOTG_HS_HFIR_FRIVL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HFIR.Reg, volatile.LoadUint32(&o.OTG_HS_HFIR.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HFIR_FRIVL() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HFIR.Reg) & 0xffff
}

// USB_OTG_HS.OTG_HS_HFNUM: OTG_HS host frame number/frame time remaining register
func (o *USB_OTG_HS_Type) SetOTG_HS_HFNUM_FRNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HFNUM.Reg, volatile.LoadUint32(&o.OTG_HS_HFNUM.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HFNUM_FRNUM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HFNUM.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HFNUM_FTREM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HFNUM.Reg, volatile.LoadUint32(&o.OTG_HS_HFNUM.Reg)&^(0xffff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HFNUM_FTREM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HFNUM.Reg) & 0xffff0000) >> 16
}

// USB_OTG_HS.OTG_HS_HPTXSTS: OTG_HS_Host periodic transmit FIFO/queue status register
func (o *USB_OTG_HS_Type) SetOTG_HS_HPTXSTS_PTXFSAVL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPTXSTS.Reg, volatile.LoadUint32(&o.OTG_HS_HPTXSTS.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPTXSTS_PTXFSAVL() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HPTXSTS.Reg) & 0xffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPTXSTS_PTXQSAV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPTXSTS.Reg, volatile.LoadUint32(&o.OTG_HS_HPTXSTS.Reg)&^(0xff0000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPTXSTS_PTXQSAV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPTXSTS.Reg) & 0xff0000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPTXSTS_PTXQTOP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPTXSTS.Reg, volatile.LoadUint32(&o.OTG_HS_HPTXSTS.Reg)&^(0xff000000)|value<<24)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPTXSTS_PTXQTOP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPTXSTS.Reg) & 0xff000000) >> 24
}

// USB_OTG_HS.OTG_HS_HAINT: OTG_HS Host all channels interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HAINT_HAINT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HAINT.Reg, volatile.LoadUint32(&o.OTG_HS_HAINT.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HAINT_HAINT() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HAINT.Reg) & 0xffff
}

// USB_OTG_HS.OTG_HS_HAINTMSK: OTG_HS host all channels interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HAINTMSK_HAINTM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HAINTMSK.Reg, volatile.LoadUint32(&o.OTG_HS_HAINTMSK.Reg)&^(0xffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HAINTMSK_HAINTM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HAINTMSK.Reg) & 0xffff
}

// USB_OTG_HS.OTG_HS_HPRT: OTG_HS host port control and status register
func (o *USB_OTG_HS_Type) SetOTG_HS_HPRT_PCSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPRT.Reg, volatile.LoadUint32(&o.OTG_HS_HPRT.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPRT_PCSTS() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HPRT.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPRT_PCDET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPRT.Reg, volatile.LoadUint32(&o.OTG_HS_HPRT.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPRT_PCDET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPRT.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPRT_PENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPRT.Reg, volatile.LoadUint32(&o.OTG_HS_HPRT.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPRT_PENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPRT.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPRT_PENCHNG(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPRT.Reg, volatile.LoadUint32(&o.OTG_HS_HPRT.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPRT_PENCHNG() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPRT.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPRT_POCA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPRT.Reg, volatile.LoadUint32(&o.OTG_HS_HPRT.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPRT_POCA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPRT.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPRT_POCCHNG(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPRT.Reg, volatile.LoadUint32(&o.OTG_HS_HPRT.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPRT_POCCHNG() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPRT.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPRT_PRES(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPRT.Reg, volatile.LoadUint32(&o.OTG_HS_HPRT.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPRT_PRES() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPRT.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPRT_PSUSP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPRT.Reg, volatile.LoadUint32(&o.OTG_HS_HPRT.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPRT_PSUSP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPRT.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPRT_PRST(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPRT.Reg, volatile.LoadUint32(&o.OTG_HS_HPRT.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPRT_PRST() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPRT.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPRT_PLSTS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPRT.Reg, volatile.LoadUint32(&o.OTG_HS_HPRT.Reg)&^(0xc00)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPRT_PLSTS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPRT.Reg) & 0xc00) >> 10
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPRT_PPWR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPRT.Reg, volatile.LoadUint32(&o.OTG_HS_HPRT.Reg)&^(0x1000)|value<<12)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPRT_PPWR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPRT.Reg) & 0x1000) >> 12
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPRT_PTCTL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPRT.Reg, volatile.LoadUint32(&o.OTG_HS_HPRT.Reg)&^(0x1e000)|value<<13)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPRT_PTCTL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPRT.Reg) & 0x1e000) >> 13
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HPRT_PSPD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HPRT.Reg, volatile.LoadUint32(&o.OTG_HS_HPRT.Reg)&^(0x60000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HPRT_PSPD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HPRT.Reg) & 0x60000) >> 17
}

// USB_OTG_HS.OTG_HS_HCCHAR0: OTG_HS host channel-0 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR0_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR0.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR0_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR0_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR0.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR0_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR0_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR0.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR0_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR0_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR0.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR0_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR0_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR0.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR0_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR0_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR0.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR0_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR0_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR0.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR0_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR0_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR0.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR0_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR0_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR0.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR0_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR0_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR0.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR0_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR0.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT0: OTG_HS host channel-0 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT0_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT0.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT0_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT0.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT0_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT0.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT0_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT0.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT0_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT0.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT0_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT0.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT0_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT0.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT0_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT0.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT0_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT0.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT0_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT0.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT0: OTG_HS host channel-11 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT0_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT0_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT0_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT0_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT0_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT0_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT0_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT0_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT0_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT0_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT0_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT0_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT0_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT0_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT0_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT0_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT0_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT0_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT0_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT0_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT0_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT0_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT0.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK0: OTG_HS host channel-11 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK0_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK0_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK0_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK0_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK0_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK0_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK0_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK0_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK0_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK0_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK0_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK0_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK0_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK0_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK0_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK0_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK0_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK0_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK0_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK0_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK0_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK0.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK0_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK0.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ0: OTG_HS host channel-11 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ0_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ0.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ0.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ0_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ0.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ0_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ0.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ0.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ0_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ0.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ0_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ0.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ0.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ0_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ0.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA0: OTG_HS host channel-0 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA0(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA0.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA0() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA0.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR1: OTG_HS host channel-1 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR1_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR1.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR1_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR1_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR1.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR1_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR1_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR1.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR1_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR1_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR1.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR1_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR1_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR1.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR1_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR1_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR1.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR1_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR1_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR1.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR1_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR1_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR1.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR1_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR1_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR1.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR1_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR1_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR1.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR1_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR1.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT1: OTG_HS host channel-1 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT1_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT1.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT1_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT1.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT1_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT1.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT1_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT1.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT1_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT1.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT1_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT1.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT1_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT1.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT1_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT1.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT1_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT1.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT1_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT1.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT1: OTG_HS host channel-1 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT1_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT1_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT1_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT1_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT1_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT1_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT1_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT1_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT1_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT1_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT1_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT1_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT1_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT1_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT1_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT1_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT1_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT1_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT1_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT1_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT1_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT1_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT1.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK1: OTG_HS host channel-1 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK1_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK1_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK1_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK1_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK1_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK1_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK1_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK1_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK1_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK1_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK1_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK1_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK1_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK1_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK1_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK1_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK1_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK1_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK1_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK1_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK1_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK1.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK1_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK1.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ1: OTG_HS host channel-1 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ1_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ1.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ1.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ1_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ1.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ1_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ1.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ1.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ1_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ1.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ1_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ1.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ1.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ1_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ1.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA1: OTG_HS host channel-1 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA1(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA1.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA1() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA1.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR2: OTG_HS host channel-2 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR2_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR2.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR2_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR2_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR2.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR2_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR2_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR2.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR2_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR2_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR2.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR2_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR2_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR2.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR2_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR2_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR2.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR2_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR2_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR2.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR2_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR2_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR2.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR2_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR2_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR2.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR2_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR2_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR2.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR2_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR2.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT2: OTG_HS host channel-2 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT2_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT2.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT2_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT2.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT2_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT2.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT2_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT2.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT2_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT2.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT2_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT2.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT2_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT2.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT2_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT2.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT2_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT2.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT2_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT2.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT2: OTG_HS host channel-2 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT2_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT2_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT2_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT2_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT2_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT2_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT2_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT2_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT2_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT2_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT2_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT2_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT2_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT2_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT2_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT2_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT2_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT2_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT2_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT2_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT2_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT2_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT2.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK2: OTG_HS host channel-2 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK2_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK2_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK2_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK2_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK2_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK2_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK2_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK2_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK2_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK2_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK2_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK2_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK2_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK2_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK2_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK2_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK2_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK2_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK2_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK2_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK2_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK2.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK2_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK2.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ2: OTG_HS host channel-2 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ2_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ2.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ2.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ2_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ2.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ2_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ2.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ2.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ2_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ2.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ2_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ2.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ2.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ2_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ2.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA2: OTG_HS host channel-2 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA2(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA2.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA2() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA2.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR3: OTG_HS host channel-3 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR3_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR3.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR3_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR3_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR3.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR3_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR3_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR3.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR3_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR3_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR3.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR3_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR3_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR3.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR3_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR3_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR3.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR3_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR3_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR3.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR3_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR3_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR3.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR3_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR3_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR3.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR3_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR3_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR3.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR3_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR3.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT3: OTG_HS host channel-3 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT3_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT3.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT3_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT3.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT3_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT3.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT3_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT3.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT3_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT3.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT3_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT3.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT3_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT3.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT3_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT3.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT3_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT3.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT3_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT3.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT3: OTG_HS host channel-3 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT3_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT3_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT3_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT3_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT3_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT3_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT3_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT3_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT3_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT3_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT3_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT3_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT3_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT3_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT3_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT3_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT3_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT3_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT3_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT3_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT3_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT3_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT3.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK3: OTG_HS host channel-3 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK3_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK3_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK3_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK3_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK3_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK3_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK3_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK3_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK3_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK3_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK3_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK3_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK3_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK3_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK3_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK3_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK3_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK3_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK3_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK3_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK3_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK3.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK3_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK3.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ3: OTG_HS host channel-3 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ3_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ3.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ3.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ3_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ3.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ3_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ3.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ3.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ3_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ3.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ3_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ3.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ3.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ3_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ3.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA3: OTG_HS host channel-3 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA3(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA3.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA3() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA3.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR4: OTG_HS host channel-4 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR4_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR4.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR4_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR4_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR4.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR4_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR4_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR4.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR4_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR4_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR4.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR4_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR4_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR4.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR4_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR4_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR4.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR4_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR4_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR4.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR4_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR4_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR4.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR4_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR4_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR4.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR4_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR4_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR4.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR4_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR4.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT4: OTG_HS host channel-4 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT4_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT4.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT4_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT4.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT4_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT4.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT4_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT4.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT4_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT4.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT4_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT4.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT4_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT4.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT4_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT4.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT4_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT4.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT4_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT4.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT4: OTG_HS host channel-4 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT4_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT4_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT4_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT4_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT4_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT4_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT4_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT4_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT4_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT4_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT4_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT4_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT4_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT4_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT4_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT4_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT4_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT4_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT4_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT4_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT4_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT4_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT4.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK4: OTG_HS host channel-4 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK4_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK4_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK4_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK4_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK4_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK4_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK4_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK4_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK4_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK4_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK4_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK4_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK4_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK4_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK4_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK4_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK4_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK4_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK4_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK4_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK4_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK4.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK4_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK4.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ4: OTG_HS host channel-4 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ4_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ4.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ4.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ4_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ4.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ4_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ4.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ4.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ4_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ4.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ4_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ4.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ4.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ4_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ4.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA4: OTG_HS host channel-4 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA4(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA4.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA4() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA4.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR5: OTG_HS host channel-5 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR5_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR5.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR5_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR5_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR5.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR5_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR5_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR5.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR5_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR5_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR5.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR5_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR5_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR5.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR5_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR5_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR5.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR5_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR5_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR5.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR5_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR5_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR5.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR5_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR5_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR5.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR5_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR5_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR5.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR5_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR5.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT5: OTG_HS host channel-5 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT5_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT5.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT5_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT5.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT5_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT5.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT5_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT5.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT5_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT5.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT5_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT5.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT5_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT5.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT5_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT5.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT5_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT5.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT5_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT5.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT5: OTG_HS host channel-5 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT5_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT5_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT5_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT5_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT5_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT5_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT5_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT5_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT5_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT5_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT5_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT5_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT5_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT5_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT5_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT5_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT5_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT5_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT5_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT5_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT5_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT5_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT5.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK5: OTG_HS host channel-5 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK5_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK5_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK5_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK5_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK5_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK5_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK5_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK5_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK5_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK5_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK5_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK5_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK5_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK5_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK5_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK5_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK5_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK5_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK5_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK5_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK5_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK5.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK5_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK5.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ5: OTG_HS host channel-5 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ5_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ5.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ5.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ5_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ5.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ5_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ5.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ5.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ5_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ5.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ5_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ5.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ5.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ5_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ5.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA5: OTG_HS host channel-5 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA5(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA5.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA5() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA5.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR6: OTG_HS host channel-6 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR6_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR6.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR6_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR6_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR6.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR6_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR6_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR6.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR6_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR6_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR6.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR6_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR6_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR6.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR6_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR6_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR6.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR6_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR6_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR6.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR6_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR6_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR6.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR6_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR6_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR6.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR6_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR6_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR6.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR6_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR6.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT6: OTG_HS host channel-6 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT6_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT6.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT6_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT6.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT6_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT6.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT6_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT6.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT6_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT6.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT6_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT6.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT6_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT6.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT6_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT6.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT6_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT6.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT6_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT6.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT6: OTG_HS host channel-6 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT6_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT6_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT6_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT6_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT6_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT6_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT6_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT6_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT6_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT6_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT6_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT6_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT6_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT6_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT6_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT6_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT6_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT6_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT6_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT6_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT6_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT6_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT6.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK6: OTG_HS host channel-6 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK6_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK6_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK6_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK6_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK6_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK6_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK6_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK6_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK6_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK6_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK6_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK6_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK6_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK6_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK6_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK6_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK6_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK6_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK6_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK6_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK6_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK6.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK6_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK6.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ6: OTG_HS host channel-6 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ6_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ6.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ6.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ6_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ6.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ6_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ6.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ6.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ6_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ6.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ6_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ6.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ6.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ6_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ6.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA6: OTG_HS host channel-6 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA6(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA6.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA6() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA6.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR7: OTG_HS host channel-7 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR7_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR7.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR7_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR7_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR7.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR7_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR7_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR7.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR7_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR7_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR7.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR7_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR7_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR7.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR7_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR7_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR7.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR7_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR7_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR7.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR7_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR7_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR7.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR7_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR7_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR7.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR7_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR7_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR7.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR7_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR7.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT7: OTG_HS host channel-7 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT7_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT7.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT7_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT7.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT7_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT7.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT7_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT7.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT7_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT7.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT7_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT7.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT7_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT7.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT7_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT7.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT7_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT7.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT7_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT7.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT7: OTG_HS host channel-7 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT7_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT7_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT7_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT7_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT7_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT7_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT7_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT7_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT7_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT7_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT7_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT7_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT7_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT7_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT7_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT7_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT7_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT7_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT7_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT7_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT7_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT7_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT7.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK7: OTG_HS host channel-7 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK7_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK7_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK7_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK7_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK7_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK7_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK7_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK7_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK7_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK7_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK7_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK7_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK7_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK7_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK7_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK7_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK7_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK7_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK7_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK7_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK7_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK7.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK7_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK7.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ7: OTG_HS host channel-7 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ7_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ7.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ7.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ7_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ7.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ7_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ7.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ7.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ7_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ7.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ7_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ7.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ7.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ7_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ7.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA7: OTG_HS host channel-7 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA7(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA7.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA7() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA7.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR8: OTG_HS host channel-8 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR8_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR8.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR8_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR8_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR8.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR8_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR8_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR8.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR8_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR8_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR8.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR8_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR8_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR8.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR8_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR8_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR8.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR8_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR8_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR8.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR8_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR8_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR8.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR8_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR8_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR8.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR8_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR8_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR8.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR8_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR8.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT8: OTG_HS host channel-8 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT8_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT8.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT8_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT8.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT8_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT8.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT8_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT8.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT8_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT8.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT8_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT8.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT8_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT8.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT8_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT8.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT8_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT8.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT8_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT8.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT8: OTG_HS host channel-8 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT8_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT8_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT8_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT8_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT8_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT8_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT8_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT8_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT8_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT8_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT8_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT8_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT8_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT8_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT8_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT8_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT8_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT8_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT8_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT8_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT8_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT8_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT8.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK8: OTG_HS host channel-8 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK8_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK8_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK8_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK8_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK8_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK8_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK8_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK8_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK8_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK8_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK8_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK8_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK8_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK8_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK8_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK8_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK8_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK8_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK8_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK8_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK8_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK8.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK8_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK8.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ8: OTG_HS host channel-8 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ8_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ8.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ8.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ8_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ8.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ8_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ8.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ8.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ8_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ8.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ8_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ8.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ8.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ8_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ8.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA8: OTG_HS host channel-8 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA8(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA8.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA8() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA8.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR9: OTG_HS host channel-9 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR9_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR9.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR9_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR9_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR9.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR9_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR9_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR9.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR9_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR9_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR9.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR9_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR9_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR9.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR9_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR9_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR9.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR9_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR9_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR9.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR9_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR9_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR9.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR9_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR9_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR9.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR9_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR9_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR9.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR9_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR9.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT9: OTG_HS host channel-9 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT9_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT9.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT9_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT9.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT9_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT9.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT9_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT9.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT9_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT9.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT9_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT9.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT9_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT9.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT9_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT9.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT9_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT9.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT9_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT9.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT9: OTG_HS host channel-9 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT9_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT9_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT9_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT9_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT9_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT9_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT9_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT9_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT9_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT9_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT9_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT9_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT9_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT9_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT9_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT9_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT9_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT9_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT9_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT9_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT9_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT9_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT9.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK9: OTG_HS host channel-9 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK9_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK9_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK9_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK9_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK9_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK9_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK9_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK9_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK9_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK9_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK9_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK9_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK9_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK9_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK9_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK9_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK9_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK9_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK9_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK9_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK9_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK9.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK9_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK9.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ9: OTG_HS host channel-9 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ9_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ9.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ9.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ9_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ9.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ9_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ9.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ9.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ9_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ9.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ9_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ9.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ9.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ9_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ9.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA9: OTG_HS host channel-9 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA9(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA9.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA9() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA9.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR10: OTG_HS host channel-10 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR10_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR10.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR10_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR10_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR10.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR10_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR10_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR10.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR10_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR10_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR10.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR10_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR10_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR10.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR10_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR10_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR10.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR10_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR10_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR10.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR10_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR10_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR10.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR10_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR10_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR10.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR10_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR10_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR10.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR10_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR10.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT10: OTG_HS host channel-10 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT10_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT10.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT10_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT10.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT10_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT10.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT10_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT10.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT10_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT10.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT10_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT10.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT10_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT10.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT10_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT10.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT10_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT10.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT10_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT10.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT10: OTG_HS host channel-10 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT10_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT10_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT10_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT10_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT10_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT10_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT10_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT10_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT10_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT10_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT10_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT10_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT10_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT10_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT10_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT10_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT10_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT10_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT10_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT10_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT10_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT10_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT10.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK10: OTG_HS host channel-10 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK10_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK10_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK10_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK10_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK10_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK10_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK10_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK10_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK10_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK10_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK10_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK10_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK10_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK10_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK10_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK10_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK10_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK10_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK10_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK10_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK10_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK10.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK10_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK10.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ10: OTG_HS host channel-10 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ10_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ10.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ10.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ10_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ10.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ10_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ10.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ10.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ10_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ10.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ10_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ10.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ10.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ10_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ10.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA10: OTG_HS host channel-10 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA10(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA10.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA10() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA10.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR11: OTG_HS host channel-11 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR11_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR11.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR11_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR11_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR11.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR11_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR11_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR11.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR11_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR11_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR11.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR11_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR11_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR11.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR11_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR11_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR11.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR11_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR11_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR11.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR11_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR11_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR11.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR11_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR11_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR11.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR11_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR11_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR11.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR11_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR11.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT11: OTG_HS host channel-11 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT11_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT11.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT11_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT11.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT11_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT11.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT11_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT11.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT11_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT11.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT11_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT11.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT11_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT11.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT11_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT11.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT11_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT11.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT11_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT11.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT11: OTG_HS host channel-11 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT11_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT11_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT11_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT11_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT11_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT11_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT11_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT11_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT11_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT11_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT11_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT11_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT11_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT11_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT11_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT11_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT11_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT11_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT11_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT11_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT11_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT11_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT11.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK11: OTG_HS host channel-11 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK11_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK11_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK11_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK11_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK11_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK11_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK11_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK11_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK11_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK11_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK11_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK11_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK11_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK11_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK11_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK11_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK11_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK11_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK11_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK11_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK11_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK11.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK11_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK11.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ11: OTG_HS host channel-11 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ11_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ11.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ11.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ11_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ11.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ11_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ11.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ11.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ11_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ11.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ11_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ11.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ11.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ11_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ11.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA11: OTG_HS host channel-11 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA11(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA11.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA11() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA11.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR12: OTG_HS host channel-12 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR12_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR12.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR12_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR12_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR12.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR12_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR12_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR12.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR12_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR12_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR12.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR12_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR12_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR12.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR12_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR12_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR12.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR12_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR12_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR12.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR12_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR12_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR12.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR12_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR12_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR12.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR12_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR12_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR12.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR12_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR12.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT12: OTG_HS host channel-12 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT12_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT12.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT12_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT12.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT12_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT12.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT12_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT12.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT12_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT12.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT12_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT12.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT12_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT12.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT12_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT12.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT12_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT12.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT12_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT12.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT12: OTG_HS host channel-12 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT12_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT12_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT12_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT12_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT12_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT12_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT12_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT12_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT12_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT12_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT12_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT12_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT12_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT12_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT12_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT12_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT12_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT12_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT12_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT12_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT12_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT12_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT12.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK12: OTG_HS host channel-12 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK12_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK12_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK12_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK12_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK12_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK12_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK12_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK12_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK12_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK12_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK12_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK12_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK12_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK12_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK12_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK12_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK12_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK12_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK12_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK12_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK12_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK12.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK12_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK12.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ12: OTG_HS host channel-12 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ12_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ12.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ12.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ12_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ12.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ12_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ12.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ12.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ12_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ12.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ12_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ12.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ12.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ12_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ12.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA12: OTG_HS host channel-12 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA12(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA12.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA12() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA12.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR13: OTG_HS host channel-13 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR13_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR13.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR13_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR13_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR13.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR13_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR13_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR13.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR13_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR13_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR13.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR13_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR13_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR13.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR13_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR13_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR13.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR13_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR13_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR13.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR13_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR13_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR13.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR13_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR13_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR13.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR13_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR13_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR13.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR13_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR13.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT13: OTG_HS host channel-13 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT13_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT13.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT13_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT13.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT13_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT13.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT13_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT13.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT13_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT13.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT13_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT13.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT13_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT13.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT13_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT13.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT13_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT13.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT13_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT13.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT13: OTG_HS host channel-13 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT13_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT13_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT13_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT13_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT13_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT13_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT13_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT13_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT13_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT13_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT13_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT13_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT13_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT13_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT13_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT13_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT13_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT13_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT13_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT13_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT13_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT13_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT13.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK13: OTG_HS host channel-13 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK13_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK13_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK13_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK13_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK13_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK13_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK13_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK13_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK13_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK13_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK13_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK13_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK13_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK13_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK13_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK13_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK13_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK13_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK13_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK13_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK13_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK13.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK13_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK13.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ13: OTG_HS host channel-13 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ13_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ13.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ13.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ13_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ13.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ13_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ13.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ13.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ13_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ13.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ13_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ13.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ13.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ13_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ13.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA13: OTG_HS host channel-13 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA13(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA13.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA13() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA13.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR14: OTG_HS host channel-14 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR14_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR14.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR14_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR14_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR14.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR14_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR14_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR14.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR14_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR14_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR14.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR14_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR14_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR14.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR14_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR14_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR14.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR14_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR14_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR14.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR14_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR14_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR14.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR14_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR14_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR14.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR14_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR14_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR14.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR14_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR14.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT14: OTG_HS host channel-14 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT14_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT14.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT14_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT14.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT14_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT14.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT14_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT14.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT14_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT14.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT14_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT14.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT14_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT14.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT14_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT14.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT14_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT14.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT14_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT14.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT14: OTG_HS host channel-14 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT14_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT14_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT14_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT14_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT14_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT14_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT14_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT14_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT14_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT14_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT14_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT14_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT14_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT14_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT14_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT14_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT14_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT14_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT14_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT14_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT14_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT14_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT14.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK14: OTG_HS host channel-14 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK14_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK14_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK14_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK14_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK14_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK14_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK14_STALLM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK14_STALLM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK14_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK14_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK14_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK14_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK14_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK14_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK14_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK14_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK14_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK14_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK14_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK14_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK14_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK14.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK14_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK14.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ14: OTG_HS host channel-14 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ14_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ14.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ14.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ14_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ14.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ14_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ14.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ14.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ14_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ14.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ14_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ14.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ14.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ14_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ14.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA14: OTG_HS host channel-14 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA14(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA14.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA14() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA14.Reg)
}

// USB_OTG_HS.OTG_HS_HCCHAR15: OTG_HS host channel-15 characteristics register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR15_MPSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR15.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg)&^(0x7ff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR15_MPSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg) & 0x7ff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR15_EPNUM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR15.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg)&^(0x7800)|value<<11)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR15_EPNUM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg) & 0x7800) >> 11
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR15_EPDIR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR15.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg)&^(0x8000)|value<<15)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR15_EPDIR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg) & 0x8000) >> 15
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR15_LSDEV(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR15.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg)&^(0x20000)|value<<17)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR15_LSDEV() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg) & 0x20000) >> 17
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR15_EPTYP(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR15.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg)&^(0xc0000)|value<<18)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR15_EPTYP() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg) & 0xc0000) >> 18
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR15_MC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR15.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg)&^(0x300000)|value<<20)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR15_MC() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg) & 0x300000) >> 20
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR15_DAD(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR15.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg)&^(0x1fc00000)|value<<22)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR15_DAD() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg) & 0x1fc00000) >> 22
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR15_ODDFRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR15.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg)&^(0x20000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR15_ODDFRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg) & 0x20000000) >> 29
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR15_CHDIS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR15.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg)&^(0x40000000)|value<<30)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR15_CHDIS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg) & 0x40000000) >> 30
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCCHAR15_CHENA(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCCHAR15.Reg, volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCCHAR15_CHENA() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCCHAR15.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCSPLT15: OTG_HS host channel-15 split control register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT15_PRTADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT15.Reg)&^(0x7f)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT15_PRTADDR() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCSPLT15.Reg) & 0x7f
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT15_HUBADDR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT15.Reg)&^(0x3f80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT15_HUBADDR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT15.Reg) & 0x3f80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT15_XACTPOS(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT15.Reg)&^(0xc000)|value<<14)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT15_XACTPOS() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT15.Reg) & 0xc000) >> 14
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT15_COMPLSPLT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT15.Reg)&^(0x10000)|value<<16)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT15_COMPLSPLT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT15.Reg) & 0x10000) >> 16
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCSPLT15_SPLITEN(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCSPLT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCSPLT15.Reg)&^(0x80000000)|value<<31)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCSPLT15_SPLITEN() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCSPLT15.Reg) & 0x80000000) >> 31
}

// USB_OTG_HS.OTG_HS_HCINT15: OTG_HS host channel-15 interrupt register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT15_XFRC(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT15_XFRC() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT15_CHH(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT15_CHH() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT15_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT15_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT15_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT15_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT15_NAK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT15_NAK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT15_ACK(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT15_ACK() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT15_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT15_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT15_TXERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT15_TXERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT15_BBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT15_BBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT15_FRMOR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT15_FRMOR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINT15_DTERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINT15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINT15_DTERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINT15.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCINTMSK15: OTG_HS host channel-15 interrupt mask register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK15_XFRCM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg)&^(0x1)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK15_XFRCM() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg) & 0x1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK15_CHHM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg)&^(0x2)|value<<1)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK15_CHHM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg) & 0x2) >> 1
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK15_AHBERR(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg)&^(0x4)|value<<2)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK15_AHBERR() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg) & 0x4) >> 2
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK15_STALL(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg)&^(0x8)|value<<3)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK15_STALL() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg) & 0x8) >> 3
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK15_NAKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg)&^(0x10)|value<<4)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK15_NAKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg) & 0x10) >> 4
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK15_ACKM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg)&^(0x20)|value<<5)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK15_ACKM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg) & 0x20) >> 5
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK15_NYET(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg)&^(0x40)|value<<6)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK15_NYET() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg) & 0x40) >> 6
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK15_TXERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg)&^(0x80)|value<<7)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK15_TXERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg) & 0x80) >> 7
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK15_BBERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg)&^(0x100)|value<<8)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK15_BBERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg) & 0x100) >> 8
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK15_FRMORM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg)&^(0x200)|value<<9)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK15_FRMORM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg) & 0x200) >> 9
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCINTMSK15_DTERRM(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCINTMSK15.Reg, volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg)&^(0x400)|value<<10)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCINTMSK15_DTERRM() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCINTMSK15.Reg) & 0x400) >> 10
}

// USB_OTG_HS.OTG_HS_HCTSIZ15: OTG_HS host channel-15 transfer size register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ15_XFRSIZ(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ15.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ15.Reg)&^(0x7ffff)|value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ15_XFRSIZ() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCTSIZ15.Reg) & 0x7ffff
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ15_PKTCNT(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ15.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ15.Reg)&^(0x1ff80000)|value<<19)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ15_PKTCNT() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ15.Reg) & 0x1ff80000) >> 19
}
func (o *USB_OTG_HS_Type) SetOTG_HS_HCTSIZ15_DPID(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCTSIZ15.Reg, volatile.LoadUint32(&o.OTG_HS_HCTSIZ15.Reg)&^(0x60000000)|value<<29)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCTSIZ15_DPID() uint32 {
	return (volatile.LoadUint32(&o.OTG_HS_HCTSIZ15.Reg) & 0x60000000) >> 29
}

// USB_OTG_HS.OTG_HS_HCDMA15: OTG_HS host channel-15 DMA address register
func (o *USB_OTG_HS_Type) SetOTG_HS_HCDMA15(value uint32) {
	volatile.StoreUint32(&o.OTG_HS_HCDMA15.Reg, value)
}
func (o *USB_OTG_HS_Type) GetOTG_HS_HCDMA15() uint32 {
	return volatile.LoadUint32(&o.OTG_HS_HCDMA15.Reg)
}

// Window watchdog
type WWDG_Type struct {
	CR  volatile.Register32 // 0x0
	CFR volatile.Register32 // 0x4
	SR  volatile.Register32 // 0x8
}

// WWDG.CR: Control register
func (o *WWDG_Type) SetCR_WDGA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *WWDG_Type) GetCR_WDGA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *WWDG_Type) SetCR_T(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCR_T() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x7f
}

// WWDG.CFR: Configuration register
func (o *WWDG_Type) SetCFR_EWI(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x200)|value<<9)
}
func (o *WWDG_Type) GetCFR_EWI() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x200) >> 9
}
func (o *WWDG_Type) SetCFR_W(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x7f)|value)
}
func (o *WWDG_Type) GetCFR_W() uint32 {
	return volatile.LoadUint32(&o.CFR.Reg) & 0x7f
}
func (o *WWDG_Type) SetCFR_WDGTB(value uint32) {
	volatile.StoreUint32(&o.CFR.Reg, volatile.LoadUint32(&o.CFR.Reg)&^(0x180)|value<<7)
}
func (o *WWDG_Type) GetCFR_WDGTB() uint32 {
	return (volatile.LoadUint32(&o.CFR.Reg) & 0x180) >> 7
}

// WWDG.SR: Status register
func (o *WWDG_Type) SetSR_EWIF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *WWDG_Type) GetSR_EWIF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// Nested Vectored Interrupt Controller
type NVIC_Type struct {
	ISER0 volatile.Register32 // 0x0
	ISER1 volatile.Register32 // 0x4
	ISER2 volatile.Register32 // 0x8
	_     [116]byte
	ICER0 volatile.Register32 // 0x80
	ICER1 volatile.Register32 // 0x84
	ICER2 volatile.Register32 // 0x88
	_     [116]byte
	ISPR0 volatile.Register32 // 0x100
	ISPR1 volatile.Register32 // 0x104
	ISPR2 volatile.Register32 // 0x108
	_     [116]byte
	ICPR0 volatile.Register32 // 0x180
	ICPR1 volatile.Register32 // 0x184
	ICPR2 volatile.Register32 // 0x188
	_     [116]byte
	IABR0 volatile.Register32 // 0x200
	IABR1 volatile.Register32 // 0x204
	IABR2 volatile.Register32 // 0x208
	_     [244]byte
	IPR0  volatile.Register32 // 0x300
	IPR1  volatile.Register32 // 0x304
	IPR2  volatile.Register32 // 0x308
	IPR3  volatile.Register32 // 0x30C
	IPR4  volatile.Register32 // 0x310
	IPR5  volatile.Register32 // 0x314
	IPR6  volatile.Register32 // 0x318
	IPR7  volatile.Register32 // 0x31C
	IPR8  volatile.Register32 // 0x320
	IPR9  volatile.Register32 // 0x324
	IPR10 volatile.Register32 // 0x328
	IPR11 volatile.Register32 // 0x32C
	IPR12 volatile.Register32 // 0x330
	IPR13 volatile.Register32 // 0x334
	IPR14 volatile.Register32 // 0x338
	IPR15 volatile.Register32 // 0x33C
	IPR16 volatile.Register32 // 0x340
	IPR17 volatile.Register32 // 0x344
	IPR18 volatile.Register32 // 0x348
	IPR19 volatile.Register32 // 0x34C
	IPR20 volatile.Register32 // 0x350
	IPR21 volatile.Register32 // 0x354
	IPR22 volatile.Register32 // 0x358
	IPR23 volatile.Register32 // 0x35C
	IPR24 volatile.Register32 // 0x360
	IPR25 volatile.Register32 // 0x364
	IPR26 volatile.Register32 // 0x368
	IPR27 volatile.Register32 // 0x36C
}

// NVIC.ISER0: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER0(value uint32) {
	volatile.StoreUint32(&o.ISER0.Reg, value)
}
func (o *NVIC_Type) GetISER0() uint32 {
	return volatile.LoadUint32(&o.ISER0.Reg)
}

// NVIC.ISER1: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER1(value uint32) {
	volatile.StoreUint32(&o.ISER1.Reg, value)
}
func (o *NVIC_Type) GetISER1() uint32 {
	return volatile.LoadUint32(&o.ISER1.Reg)
}

// NVIC.ISER2: Interrupt Set-Enable Register
func (o *NVIC_Type) SetISER2(value uint32) {
	volatile.StoreUint32(&o.ISER2.Reg, value)
}
func (o *NVIC_Type) GetISER2() uint32 {
	return volatile.LoadUint32(&o.ISER2.Reg)
}

// NVIC.ICER0: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER0(value uint32) {
	volatile.StoreUint32(&o.ICER0.Reg, value)
}
func (o *NVIC_Type) GetICER0() uint32 {
	return volatile.LoadUint32(&o.ICER0.Reg)
}

// NVIC.ICER1: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER1(value uint32) {
	volatile.StoreUint32(&o.ICER1.Reg, value)
}
func (o *NVIC_Type) GetICER1() uint32 {
	return volatile.LoadUint32(&o.ICER1.Reg)
}

// NVIC.ICER2: Interrupt Clear-Enable Register
func (o *NVIC_Type) SetICER2(value uint32) {
	volatile.StoreUint32(&o.ICER2.Reg, value)
}
func (o *NVIC_Type) GetICER2() uint32 {
	return volatile.LoadUint32(&o.ICER2.Reg)
}

// NVIC.ISPR0: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR0(value uint32) {
	volatile.StoreUint32(&o.ISPR0.Reg, value)
}
func (o *NVIC_Type) GetISPR0() uint32 {
	return volatile.LoadUint32(&o.ISPR0.Reg)
}

// NVIC.ISPR1: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR1(value uint32) {
	volatile.StoreUint32(&o.ISPR1.Reg, value)
}
func (o *NVIC_Type) GetISPR1() uint32 {
	return volatile.LoadUint32(&o.ISPR1.Reg)
}

// NVIC.ISPR2: Interrupt Set-Pending Register
func (o *NVIC_Type) SetISPR2(value uint32) {
	volatile.StoreUint32(&o.ISPR2.Reg, value)
}
func (o *NVIC_Type) GetISPR2() uint32 {
	return volatile.LoadUint32(&o.ISPR2.Reg)
}

// NVIC.ICPR0: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR0(value uint32) {
	volatile.StoreUint32(&o.ICPR0.Reg, value)
}
func (o *NVIC_Type) GetICPR0() uint32 {
	return volatile.LoadUint32(&o.ICPR0.Reg)
}

// NVIC.ICPR1: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR1(value uint32) {
	volatile.StoreUint32(&o.ICPR1.Reg, value)
}
func (o *NVIC_Type) GetICPR1() uint32 {
	return volatile.LoadUint32(&o.ICPR1.Reg)
}

// NVIC.ICPR2: Interrupt Clear-Pending Register
func (o *NVIC_Type) SetICPR2(value uint32) {
	volatile.StoreUint32(&o.ICPR2.Reg, value)
}
func (o *NVIC_Type) GetICPR2() uint32 {
	return volatile.LoadUint32(&o.ICPR2.Reg)
}

// NVIC.IABR0: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR0(value uint32) {
	volatile.StoreUint32(&o.IABR0.Reg, value)
}
func (o *NVIC_Type) GetIABR0() uint32 {
	return volatile.LoadUint32(&o.IABR0.Reg)
}

// NVIC.IABR1: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR1(value uint32) {
	volatile.StoreUint32(&o.IABR1.Reg, value)
}
func (o *NVIC_Type) GetIABR1() uint32 {
	return volatile.LoadUint32(&o.IABR1.Reg)
}

// NVIC.IABR2: Interrupt Active Bit Register
func (o *NVIC_Type) SetIABR2(value uint32) {
	volatile.StoreUint32(&o.IABR2.Reg, value)
}
func (o *NVIC_Type) GetIABR2() uint32 {
	return volatile.LoadUint32(&o.IABR2.Reg)
}

// NVIC.IPR0: Interrupt Priority Register
func (o *NVIC_Type) SetIPR0_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR0_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR0.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR0_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR0_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR0_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR0_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR0_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR0.Reg, volatile.LoadUint32(&o.IPR0.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR0_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR0.Reg) & 0xff000000) >> 24
}

// NVIC.IPR1: Interrupt Priority Register
func (o *NVIC_Type) SetIPR1_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR1_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR1.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR1_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR1_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR1_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR1_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR1_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR1.Reg, volatile.LoadUint32(&o.IPR1.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR1_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR1.Reg) & 0xff000000) >> 24
}

// NVIC.IPR2: Interrupt Priority Register
func (o *NVIC_Type) SetIPR2_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR2_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR2.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR2_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR2_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR2_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR2_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR2_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR2.Reg, volatile.LoadUint32(&o.IPR2.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR2_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR2.Reg) & 0xff000000) >> 24
}

// NVIC.IPR3: Interrupt Priority Register
func (o *NVIC_Type) SetIPR3_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR3_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR3.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR3_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR3_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR3_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR3_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR3_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR3.Reg, volatile.LoadUint32(&o.IPR3.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR3_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR3.Reg) & 0xff000000) >> 24
}

// NVIC.IPR4: Interrupt Priority Register
func (o *NVIC_Type) SetIPR4_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR4_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR4.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR4_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR4_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR4_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR4_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR4_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR4.Reg, volatile.LoadUint32(&o.IPR4.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR4_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR4.Reg) & 0xff000000) >> 24
}

// NVIC.IPR5: Interrupt Priority Register
func (o *NVIC_Type) SetIPR5_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR5_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR5.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR5_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR5_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR5_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR5_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR5_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR5.Reg, volatile.LoadUint32(&o.IPR5.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR5_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR5.Reg) & 0xff000000) >> 24
}

// NVIC.IPR6: Interrupt Priority Register
func (o *NVIC_Type) SetIPR6_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR6_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR6.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR6_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR6_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR6_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR6_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR6_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR6.Reg, volatile.LoadUint32(&o.IPR6.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR6_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR6.Reg) & 0xff000000) >> 24
}

// NVIC.IPR7: Interrupt Priority Register
func (o *NVIC_Type) SetIPR7_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR7_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR7.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR7_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR7_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR7_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR7_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR7_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR7.Reg, volatile.LoadUint32(&o.IPR7.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR7_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR7.Reg) & 0xff000000) >> 24
}

// NVIC.IPR8: Interrupt Priority Register
func (o *NVIC_Type) SetIPR8_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR8_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR8.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR8_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR8_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR8_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR8_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR8_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR8.Reg, volatile.LoadUint32(&o.IPR8.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR8_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR8.Reg) & 0xff000000) >> 24
}

// NVIC.IPR9: Interrupt Priority Register
func (o *NVIC_Type) SetIPR9_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR9_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR9.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR9_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR9_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR9_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR9_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR9_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR9.Reg, volatile.LoadUint32(&o.IPR9.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR9_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR9.Reg) & 0xff000000) >> 24
}

// NVIC.IPR10: Interrupt Priority Register
func (o *NVIC_Type) SetIPR10_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR10_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR10.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR10_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR10_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR10_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR10_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR10_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR10.Reg, volatile.LoadUint32(&o.IPR10.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR10_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR10.Reg) & 0xff000000) >> 24
}

// NVIC.IPR11: Interrupt Priority Register
func (o *NVIC_Type) SetIPR11_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR11_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR11.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR11_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR11_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR11_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR11_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR11_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR11.Reg, volatile.LoadUint32(&o.IPR11.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR11_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR11.Reg) & 0xff000000) >> 24
}

// NVIC.IPR12: Interrupt Priority Register
func (o *NVIC_Type) SetIPR12_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR12_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR12.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR12_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR12_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR12_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR12_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR12_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR12.Reg, volatile.LoadUint32(&o.IPR12.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR12_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR12.Reg) & 0xff000000) >> 24
}

// NVIC.IPR13: Interrupt Priority Register
func (o *NVIC_Type) SetIPR13_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR13_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR13.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR13_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR13_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR13_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR13_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR13_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR13.Reg, volatile.LoadUint32(&o.IPR13.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR13_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR13.Reg) & 0xff000000) >> 24
}

// NVIC.IPR14: Interrupt Priority Register
func (o *NVIC_Type) SetIPR14_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR14_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR14.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR14_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR14_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR14_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR14_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR14_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR14.Reg, volatile.LoadUint32(&o.IPR14.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR14_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR14.Reg) & 0xff000000) >> 24
}

// NVIC.IPR15: Interrupt Priority Register
func (o *NVIC_Type) SetIPR15_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR15_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR15.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR15_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR15_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR15_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR15_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR15_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR15.Reg, volatile.LoadUint32(&o.IPR15.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR15_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR15.Reg) & 0xff000000) >> 24
}

// NVIC.IPR16: Interrupt Priority Register
func (o *NVIC_Type) SetIPR16_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR16_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR16.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR16_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR16_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR16_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR16_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR16_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR16.Reg, volatile.LoadUint32(&o.IPR16.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR16_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR16.Reg) & 0xff000000) >> 24
}

// NVIC.IPR17: Interrupt Priority Register
func (o *NVIC_Type) SetIPR17_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR17_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR17.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR17_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR17_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR17_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR17_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR17_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR17.Reg, volatile.LoadUint32(&o.IPR17.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR17_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR17.Reg) & 0xff000000) >> 24
}

// NVIC.IPR18: Interrupt Priority Register
func (o *NVIC_Type) SetIPR18_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR18_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR18.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR18_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR18_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR18_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR18_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR18_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR18.Reg, volatile.LoadUint32(&o.IPR18.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR18_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR18.Reg) & 0xff000000) >> 24
}

// NVIC.IPR19: Interrupt Priority Register
func (o *NVIC_Type) SetIPR19_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR19_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR19.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR19_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR19_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR19_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR19_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR19_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR19.Reg, volatile.LoadUint32(&o.IPR19.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR19_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR19.Reg) & 0xff000000) >> 24
}

// NVIC.IPR20: Interrupt Priority Register
func (o *NVIC_Type) SetIPR20_IPR_N0(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff)|value)
}
func (o *NVIC_Type) GetIPR20_IPR_N0() uint32 {
	return volatile.LoadUint32(&o.IPR20.Reg) & 0xff
}
func (o *NVIC_Type) SetIPR20_IPR_N1(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff00)|value<<8)
}
func (o *NVIC_Type) GetIPR20_IPR_N1() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff00) >> 8
}
func (o *NVIC_Type) SetIPR20_IPR_N2(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff0000)|value<<16)
}
func (o *NVIC_Type) GetIPR20_IPR_N2() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff0000) >> 16
}
func (o *NVIC_Type) SetIPR20_IPR_N3(value uint32) {
	volatile.StoreUint32(&o.IPR20.Reg, volatile.LoadUint32(&o.IPR20.Reg)&^(0xff000000)|value<<24)
}
func (o *NVIC_Type) GetIPR20_IPR_N3() uint32 {
	return (volatile.LoadUint32(&o.IPR20.Reg) & 0xff000000) >> 24
}

// Memory protection unit
type MPU_Type struct {
	TYPER volatile.Register32 // 0x0
	CTRL  volatile.Register32 // 0x4
	RNR   volatile.Register32 // 0x8
	RBAR  volatile.Register32 // 0xC
	RASR  volatile.Register32 // 0x10
}

// MPU.TYPER: MPU type register
func (o *MPU_Type) SetTYPER_SEPARATE(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetTYPER_SEPARATE() uint32 {
	return volatile.LoadUint32(&o.TYPER.Reg) & 0x1
}
func (o *MPU_Type) SetTYPER_DREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetTYPER_DREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetTYPER_IREGION(value uint32) {
	volatile.StoreUint32(&o.TYPER.Reg, volatile.LoadUint32(&o.TYPER.Reg)&^(0xff0000)|value<<16)
}
func (o *MPU_Type) GetTYPER_IREGION() uint32 {
	return (volatile.LoadUint32(&o.TYPER.Reg) & 0xff0000) >> 16
}

// MPU.CTRL: MPU control register
func (o *MPU_Type) SetCTRL_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetCTRL_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CTRL.Reg) & 0x1
}
func (o *MPU_Type) SetCTRL_HFNMIENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *MPU_Type) GetCTRL_HFNMIENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *MPU_Type) SetCTRL_PRIVDEFENA(value uint32) {
	volatile.StoreUint32(&o.CTRL.Reg, volatile.LoadUint32(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *MPU_Type) GetCTRL_PRIVDEFENA() uint32 {
	return (volatile.LoadUint32(&o.CTRL.Reg) & 0x4) >> 2
}

// MPU.RNR: MPU region number register
func (o *MPU_Type) SetRNR_REGION(value uint32) {
	volatile.StoreUint32(&o.RNR.Reg, volatile.LoadUint32(&o.RNR.Reg)&^(0xff)|value)
}
func (o *MPU_Type) GetRNR_REGION() uint32 {
	return volatile.LoadUint32(&o.RNR.Reg) & 0xff
}

// MPU.RBAR: MPU region base address register
func (o *MPU_Type) SetRBAR_REGION(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xf)|value)
}
func (o *MPU_Type) GetRBAR_REGION() uint32 {
	return volatile.LoadUint32(&o.RBAR.Reg) & 0xf
}
func (o *MPU_Type) SetRBAR_VALID(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0x10)|value<<4)
}
func (o *MPU_Type) GetRBAR_VALID() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0x10) >> 4
}
func (o *MPU_Type) SetRBAR_ADDR(value uint32) {
	volatile.StoreUint32(&o.RBAR.Reg, volatile.LoadUint32(&o.RBAR.Reg)&^(0xffffffe0)|value<<5)
}
func (o *MPU_Type) GetRBAR_ADDR() uint32 {
	return (volatile.LoadUint32(&o.RBAR.Reg) & 0xffffffe0) >> 5
}

// MPU.RASR: MPU region attribute and size register
func (o *MPU_Type) SetRASR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x1)|value)
}
func (o *MPU_Type) GetRASR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.RASR.Reg) & 0x1
}
func (o *MPU_Type) SetRASR_SIZE(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x3e)|value<<1)
}
func (o *MPU_Type) GetRASR_SIZE() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x3e) >> 1
}
func (o *MPU_Type) SetRASR_SRD(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0xff00)|value<<8)
}
func (o *MPU_Type) GetRASR_SRD() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0xff00) >> 8
}
func (o *MPU_Type) SetRASR_B(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000)|value<<16)
}
func (o *MPU_Type) GetRASR_B() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000) >> 16
}
func (o *MPU_Type) SetRASR_C(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x20000)|value<<17)
}
func (o *MPU_Type) GetRASR_C() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x20000) >> 17
}
func (o *MPU_Type) SetRASR_S(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x40000)|value<<18)
}
func (o *MPU_Type) GetRASR_S() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x40000) >> 18
}
func (o *MPU_Type) SetRASR_TEX(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x380000)|value<<19)
}
func (o *MPU_Type) GetRASR_TEX() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x380000) >> 19
}
func (o *MPU_Type) SetRASR_AP(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x7000000)|value<<24)
}
func (o *MPU_Type) GetRASR_AP() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x7000000) >> 24
}
func (o *MPU_Type) SetRASR_XN(value uint32) {
	volatile.StoreUint32(&o.RASR.Reg, volatile.LoadUint32(&o.RASR.Reg)&^(0x10000000)|value<<28)
}
func (o *MPU_Type) GetRASR_XN() uint32 {
	return (volatile.LoadUint32(&o.RASR.Reg) & 0x10000000) >> 28
}

// SysTick timer
type STK_Type struct {
	CSR   volatile.Register32 // 0x0
	RVR   volatile.Register32 // 0x4
	CVR   volatile.Register32 // 0x8
	CALIB volatile.Register32 // 0xC
}

// STK.CSR: SysTick control and status register
func (o *STK_Type) SetCSR_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *STK_Type) GetCSR_ENABLE() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *STK_Type) SetCSR_TICKINT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *STK_Type) GetCSR_TICKINT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *STK_Type) SetCSR_CLKSOURCE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *STK_Type) GetCSR_CLKSOURCE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *STK_Type) SetCSR_COUNTFLAG(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10000)|value<<16)
}
func (o *STK_Type) GetCSR_COUNTFLAG() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10000) >> 16
}

// STK.RVR: SysTick reload value register
func (o *STK_Type) SetRVR_RELOAD(value uint32) {
	volatile.StoreUint32(&o.RVR.Reg, volatile.LoadUint32(&o.RVR.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetRVR_RELOAD() uint32 {
	return volatile.LoadUint32(&o.RVR.Reg) & 0xffffff
}

// STK.CVR: SysTick current value register
func (o *STK_Type) SetCVR_CURRENT(value uint32) {
	volatile.StoreUint32(&o.CVR.Reg, volatile.LoadUint32(&o.CVR.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetCVR_CURRENT() uint32 {
	return volatile.LoadUint32(&o.CVR.Reg) & 0xffffff
}

// STK.CALIB: SysTick calibration value register
func (o *STK_Type) SetCALIB_TENMS(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0xffffff)|value)
}
func (o *STK_Type) GetCALIB_TENMS() uint32 {
	return volatile.LoadUint32(&o.CALIB.Reg) & 0xffffff
}
func (o *STK_Type) SetCALIB_SKEW(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x40000000)|value<<30)
}
func (o *STK_Type) GetCALIB_SKEW() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x40000000) >> 30
}
func (o *STK_Type) SetCALIB_NOREF(value uint32) {
	volatile.StoreUint32(&o.CALIB.Reg, volatile.LoadUint32(&o.CALIB.Reg)&^(0x80000000)|value<<31)
}
func (o *STK_Type) GetCALIB_NOREF() uint32 {
	return (volatile.LoadUint32(&o.CALIB.Reg) & 0x80000000) >> 31
}

// Floating point unit CPACR
type FPU_Type struct {
	CPACR volatile.Register32 // 0x0
}

// FPU.CPACR: Coprocessor access control register
func (o *FPU_Type) SetCPACR_CP(value uint32) {
	volatile.StoreUint32(&o.CPACR.Reg, volatile.LoadUint32(&o.CPACR.Reg)&^(0xf00000)|value<<20)
}
func (o *FPU_Type) GetCPACR_CP() uint32 {
	return (volatile.LoadUint32(&o.CPACR.Reg) & 0xf00000) >> 20
}

// System control block ACTLR
type SCB_Type struct {
	ACTRL volatile.Register32 // 0x0
}

// SCB.ACTRL: Auxiliary control register
func (o *SCB_Type) SetACTRL_DISFOLD(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x4)|value<<2)
}
func (o *SCB_Type) GetACTRL_DISFOLD() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x4) >> 2
}
func (o *SCB_Type) SetACTRL_FPEXCODIS(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x400)|value<<10)
}
func (o *SCB_Type) GetACTRL_FPEXCODIS() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x400) >> 10
}
func (o *SCB_Type) SetACTRL_DISRAMODE(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x800)|value<<11)
}
func (o *SCB_Type) GetACTRL_DISRAMODE() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x800) >> 11
}
func (o *SCB_Type) SetACTRL_DISITMATBFLUSH(value uint32) {
	volatile.StoreUint32(&o.ACTRL.Reg, volatile.LoadUint32(&o.ACTRL.Reg)&^(0x1000)|value<<12)
}
func (o *SCB_Type) GetACTRL_DISITMATBFLUSH() uint32 {
	return (volatile.LoadUint32(&o.ACTRL.Reg) & 0x1000) >> 12
}

// Processor features
type PF_Type struct {
	CLIDR  volatile.Register32 // 0x0
	CTR    volatile.Register32 // 0x4
	CCSIDR volatile.Register32 // 0x8
}

// PF.CLIDR: Cache Level ID register
func (o *PF_Type) SetCLIDR_CL1(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x7)|value)
}
func (o *PF_Type) GetCLIDR_CL1() uint32 {
	return volatile.LoadUint32(&o.CLIDR.Reg) & 0x7
}
func (o *PF_Type) SetCLIDR_CL2(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x38)|value<<3)
}
func (o *PF_Type) GetCLIDR_CL2() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x38) >> 3
}
func (o *PF_Type) SetCLIDR_CL3(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x1c0)|value<<6)
}
func (o *PF_Type) GetCLIDR_CL3() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x1c0) >> 6
}
func (o *PF_Type) SetCLIDR_CL4(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0xe00)|value<<9)
}
func (o *PF_Type) GetCLIDR_CL4() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0xe00) >> 9
}
func (o *PF_Type) SetCLIDR_CL5(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x7000)|value<<12)
}
func (o *PF_Type) GetCLIDR_CL5() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x7000) >> 12
}
func (o *PF_Type) SetCLIDR_CL6(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x38000)|value<<15)
}
func (o *PF_Type) GetCLIDR_CL6() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x38000) >> 15
}
func (o *PF_Type) SetCLIDR_CL7(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x1c0000)|value<<18)
}
func (o *PF_Type) GetCLIDR_CL7() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x1c0000) >> 18
}
func (o *PF_Type) SetCLIDR_LoUIS(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0xe00000)|value<<21)
}
func (o *PF_Type) GetCLIDR_LoUIS() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0xe00000) >> 21
}
func (o *PF_Type) SetCLIDR_LoC(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x7000000)|value<<24)
}
func (o *PF_Type) GetCLIDR_LoC() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x7000000) >> 24
}
func (o *PF_Type) SetCLIDR_LoU(value uint32) {
	volatile.StoreUint32(&o.CLIDR.Reg, volatile.LoadUint32(&o.CLIDR.Reg)&^(0x38000000)|value<<27)
}
func (o *PF_Type) GetCLIDR_LoU() uint32 {
	return (volatile.LoadUint32(&o.CLIDR.Reg) & 0x38000000) >> 27
}

// PF.CTR: Cache Type register
func (o *PF_Type) SetCTR__IMINLINE(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xf)|value)
}
func (o *PF_Type) GetCTR__IMINLINE() uint32 {
	return volatile.LoadUint32(&o.CTR.Reg) & 0xf
}
func (o *PF_Type) SetCTR_DMinLine(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xf0000)|value<<16)
}
func (o *PF_Type) GetCTR_DMinLine() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0xf0000) >> 16
}
func (o *PF_Type) SetCTR_ERG(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xf00000)|value<<20)
}
func (o *PF_Type) GetCTR_ERG() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0xf00000) >> 20
}
func (o *PF_Type) SetCTR_CWG(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xf000000)|value<<24)
}
func (o *PF_Type) GetCTR_CWG() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0xf000000) >> 24
}
func (o *PF_Type) SetCTR_Format(value uint32) {
	volatile.StoreUint32(&o.CTR.Reg, volatile.LoadUint32(&o.CTR.Reg)&^(0xe0000000)|value<<29)
}
func (o *PF_Type) GetCTR_Format() uint32 {
	return (volatile.LoadUint32(&o.CTR.Reg) & 0xe0000000) >> 29
}

// PF.CCSIDR: Cache Size ID register
func (o *PF_Type) SetCCSIDR_LineSize(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x7)|value)
}
func (o *PF_Type) GetCCSIDR_LineSize() uint32 {
	return volatile.LoadUint32(&o.CCSIDR.Reg) & 0x7
}
func (o *PF_Type) SetCCSIDR_Associativity(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x1ff8)|value<<3)
}
func (o *PF_Type) GetCCSIDR_Associativity() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x1ff8) >> 3
}
func (o *PF_Type) SetCCSIDR_NumSets(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0xfffe000)|value<<13)
}
func (o *PF_Type) GetCCSIDR_NumSets() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0xfffe000) >> 13
}
func (o *PF_Type) SetCCSIDR_WA(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PF_Type) GetCCSIDR_WA() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x10000000) >> 28
}
func (o *PF_Type) SetCCSIDR_RA(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PF_Type) GetCCSIDR_RA() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x20000000) >> 29
}
func (o *PF_Type) SetCCSIDR_WB(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PF_Type) GetCCSIDR_WB() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x40000000) >> 30
}
func (o *PF_Type) SetCCSIDR_WT(value uint32) {
	volatile.StoreUint32(&o.CCSIDR.Reg, volatile.LoadUint32(&o.CCSIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PF_Type) GetCCSIDR_WT() uint32 {
	return (volatile.LoadUint32(&o.CCSIDR.Reg) & 0x80000000) >> 31
}

// Access control
type AC_Type struct {
	ITCMCR volatile.Register32 // 0x0
	DTCMCR volatile.Register32 // 0x4
	AHBPCR volatile.Register32 // 0x8
	CACR   volatile.Register32 // 0xC
	AHBSCR volatile.Register32 // 0x10
	_      [4]byte
	ABFSR  volatile.Register32 // 0x18
}

// AC.ITCMCR: Instruction and Data Tightly-Coupled Memory Control Registers
func (o *AC_Type) SetITCMCR_EN(value uint32) {
	volatile.StoreUint32(&o.ITCMCR.Reg, volatile.LoadUint32(&o.ITCMCR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetITCMCR_EN() uint32 {
	return volatile.LoadUint32(&o.ITCMCR.Reg) & 0x1
}
func (o *AC_Type) SetITCMCR_RMW(value uint32) {
	volatile.StoreUint32(&o.ITCMCR.Reg, volatile.LoadUint32(&o.ITCMCR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetITCMCR_RMW() uint32 {
	return (volatile.LoadUint32(&o.ITCMCR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetITCMCR_RETEN(value uint32) {
	volatile.StoreUint32(&o.ITCMCR.Reg, volatile.LoadUint32(&o.ITCMCR.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetITCMCR_RETEN() uint32 {
	return (volatile.LoadUint32(&o.ITCMCR.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetITCMCR_SZ(value uint32) {
	volatile.StoreUint32(&o.ITCMCR.Reg, volatile.LoadUint32(&o.ITCMCR.Reg)&^(0x78)|value<<3)
}
func (o *AC_Type) GetITCMCR_SZ() uint32 {
	return (volatile.LoadUint32(&o.ITCMCR.Reg) & 0x78) >> 3
}

// AC.DTCMCR: Instruction and Data Tightly-Coupled Memory Control Registers
func (o *AC_Type) SetDTCMCR_EN(value uint32) {
	volatile.StoreUint32(&o.DTCMCR.Reg, volatile.LoadUint32(&o.DTCMCR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetDTCMCR_EN() uint32 {
	return volatile.LoadUint32(&o.DTCMCR.Reg) & 0x1
}
func (o *AC_Type) SetDTCMCR_RMW(value uint32) {
	volatile.StoreUint32(&o.DTCMCR.Reg, volatile.LoadUint32(&o.DTCMCR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetDTCMCR_RMW() uint32 {
	return (volatile.LoadUint32(&o.DTCMCR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetDTCMCR_RETEN(value uint32) {
	volatile.StoreUint32(&o.DTCMCR.Reg, volatile.LoadUint32(&o.DTCMCR.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetDTCMCR_RETEN() uint32 {
	return (volatile.LoadUint32(&o.DTCMCR.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetDTCMCR_SZ(value uint32) {
	volatile.StoreUint32(&o.DTCMCR.Reg, volatile.LoadUint32(&o.DTCMCR.Reg)&^(0x78)|value<<3)
}
func (o *AC_Type) GetDTCMCR_SZ() uint32 {
	return (volatile.LoadUint32(&o.DTCMCR.Reg) & 0x78) >> 3
}

// AC.AHBPCR: AHBP Control register
func (o *AC_Type) SetAHBPCR_EN(value uint32) {
	volatile.StoreUint32(&o.AHBPCR.Reg, volatile.LoadUint32(&o.AHBPCR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetAHBPCR_EN() uint32 {
	return volatile.LoadUint32(&o.AHBPCR.Reg) & 0x1
}
func (o *AC_Type) SetAHBPCR_SZ(value uint32) {
	volatile.StoreUint32(&o.AHBPCR.Reg, volatile.LoadUint32(&o.AHBPCR.Reg)&^(0xe)|value<<1)
}
func (o *AC_Type) GetAHBPCR_SZ() uint32 {
	return (volatile.LoadUint32(&o.AHBPCR.Reg) & 0xe) >> 1
}

// AC.CACR: Auxiliary Cache Control register
func (o *AC_Type) SetCACR_SIWT(value uint32) {
	volatile.StoreUint32(&o.CACR.Reg, volatile.LoadUint32(&o.CACR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetCACR_SIWT() uint32 {
	return volatile.LoadUint32(&o.CACR.Reg) & 0x1
}
func (o *AC_Type) SetCACR_ECCEN(value uint32) {
	volatile.StoreUint32(&o.CACR.Reg, volatile.LoadUint32(&o.CACR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCACR_ECCEN() uint32 {
	return (volatile.LoadUint32(&o.CACR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetCACR_FORCEWT(value uint32) {
	volatile.StoreUint32(&o.CACR.Reg, volatile.LoadUint32(&o.CACR.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetCACR_FORCEWT() uint32 {
	return (volatile.LoadUint32(&o.CACR.Reg) & 0x4) >> 2
}

// AC.AHBSCR: AHB Slave Control register
func (o *AC_Type) SetAHBSCR_CTL(value uint32) {
	volatile.StoreUint32(&o.AHBSCR.Reg, volatile.LoadUint32(&o.AHBSCR.Reg)&^(0x3)|value)
}
func (o *AC_Type) GetAHBSCR_CTL() uint32 {
	return volatile.LoadUint32(&o.AHBSCR.Reg) & 0x3
}
func (o *AC_Type) SetAHBSCR_TPRI(value uint32) {
	volatile.StoreUint32(&o.AHBSCR.Reg, volatile.LoadUint32(&o.AHBSCR.Reg)&^(0x7fc)|value<<2)
}
func (o *AC_Type) GetAHBSCR_TPRI() uint32 {
	return (volatile.LoadUint32(&o.AHBSCR.Reg) & 0x7fc) >> 2
}
func (o *AC_Type) SetAHBSCR_INITCOUNT(value uint32) {
	volatile.StoreUint32(&o.AHBSCR.Reg, volatile.LoadUint32(&o.AHBSCR.Reg)&^(0xf800)|value<<11)
}
func (o *AC_Type) GetAHBSCR_INITCOUNT() uint32 {
	return (volatile.LoadUint32(&o.AHBSCR.Reg) & 0xf800) >> 11
}

// AC.ABFSR: Auxiliary Bus Fault Status register
func (o *AC_Type) SetABFSR_ITCM(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetABFSR_ITCM() uint32 {
	return volatile.LoadUint32(&o.ABFSR.Reg) & 0x1
}
func (o *AC_Type) SetABFSR_DTCM(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetABFSR_DTCM() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetABFSR_AHBP(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetABFSR_AHBP() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetABFSR_AXIM(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x8)|value<<3)
}
func (o *AC_Type) GetABFSR_AXIM() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x8) >> 3
}
func (o *AC_Type) SetABFSR_EPPB(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetABFSR_EPPB() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x10) >> 4
}
func (o *AC_Type) SetABFSR_AXIMTYPE(value uint32) {
	volatile.StoreUint32(&o.ABFSR.Reg, volatile.LoadUint32(&o.ABFSR.Reg)&^(0x300)|value<<8)
}
func (o *AC_Type) GetABFSR_AXIMTYPE() uint32 {
	return (volatile.LoadUint32(&o.ABFSR.Reg) & 0x300) >> 8
}

// Advanced encryption standard hardware accelerator 1
type AES_Type struct {
	CR     volatile.Register32 // 0x0
	SR     volatile.Register32 // 0x4
	DINR   volatile.Register32 // 0x8
	DOUTR  volatile.Register32 // 0xC
	KEYR0  volatile.Register32 // 0x10
	KEYR1  volatile.Register32 // 0x14
	KEYR2  volatile.Register32 // 0x18
	KEYR3  volatile.Register32 // 0x1C
	IVR0   volatile.Register32 // 0x20
	IVR1   volatile.Register32 // 0x24
	IVR2   volatile.Register32 // 0x28
	IVR3   volatile.Register32 // 0x2C
	KEYR4  volatile.Register32 // 0x30
	KEYR5  volatile.Register32 // 0x34
	KEYR6  volatile.Register32 // 0x38
	KEYR7  volatile.Register32 // 0x3C
	SUSP0R volatile.Register32 // 0x40
	SUSP1R volatile.Register32 // 0x44
	SUSP2R volatile.Register32 // 0x48
	SUSP3R volatile.Register32 // 0x4C
	SUSP4R volatile.Register32 // 0x50
	SUSP5R volatile.Register32 // 0x54
	SUSP6R volatile.Register32 // 0x58
	SUSP7R volatile.Register32 // 0x5C
}

// AES.CR: control register
func (o *AES_Type) SetCR_KEYSIZE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *AES_Type) GetCR_KEYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *AES_Type) SetCR_CHMOD2(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10000)|value<<16)
}
func (o *AES_Type) GetCR_CHMOD2() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10000) >> 16
}
func (o *AES_Type) SetCR_GCMPH(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6000)|value<<13)
}
func (o *AES_Type) GetCR_GCMPH() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6000) >> 13
}
func (o *AES_Type) SetCR_DMAOUTEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *AES_Type) GetCR_DMAOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *AES_Type) SetCR_DMAINEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *AES_Type) GetCR_DMAINEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *AES_Type) SetCR_ERRIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *AES_Type) GetCR_ERRIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *AES_Type) SetCR_CCFIE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *AES_Type) GetCR_CCFIE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *AES_Type) SetCR_ERRC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *AES_Type) GetCR_ERRC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *AES_Type) SetCR_CCFC(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *AES_Type) GetCR_CCFC() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *AES_Type) SetCR_CHMOD10(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x60)|value<<5)
}
func (o *AES_Type) GetCR_CHMOD10() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x60) >> 5
}
func (o *AES_Type) SetCR_MODE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x18)|value<<3)
}
func (o *AES_Type) GetCR_MODE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x18) >> 3
}
func (o *AES_Type) SetCR_DATATYPE(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x6)|value<<1)
}
func (o *AES_Type) GetCR_DATATYPE() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x6) >> 1
}
func (o *AES_Type) SetCR_EN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCR_EN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// AES.SR: status register
func (o *AES_Type) SetSR_BUSY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *AES_Type) GetSR_BUSY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *AES_Type) SetSR_WRERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *AES_Type) GetSR_WRERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *AES_Type) SetSR_RDERR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetSR_RDERR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *AES_Type) SetSR_CCF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetSR_CCF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}

// AES.DINR: data input register
func (o *AES_Type) SetDINR(value uint32) {
	volatile.StoreUint32(&o.DINR.Reg, value)
}
func (o *AES_Type) GetDINR() uint32 {
	return volatile.LoadUint32(&o.DINR.Reg)
}

// AES.DOUTR: data output register
func (o *AES_Type) SetDOUTR(value uint32) {
	volatile.StoreUint32(&o.DOUTR.Reg, value)
}
func (o *AES_Type) GetDOUTR() uint32 {
	return volatile.LoadUint32(&o.DOUTR.Reg)
}

// AES.KEYR0: key register 0
func (o *AES_Type) SetKEYR0(value uint32) {
	volatile.StoreUint32(&o.KEYR0.Reg, value)
}
func (o *AES_Type) GetKEYR0() uint32 {
	return volatile.LoadUint32(&o.KEYR0.Reg)
}

// AES.KEYR1: key register 1
func (o *AES_Type) SetKEYR1(value uint32) {
	volatile.StoreUint32(&o.KEYR1.Reg, value)
}
func (o *AES_Type) GetKEYR1() uint32 {
	return volatile.LoadUint32(&o.KEYR1.Reg)
}

// AES.KEYR2: key register 2
func (o *AES_Type) SetKEYR2(value uint32) {
	volatile.StoreUint32(&o.KEYR2.Reg, value)
}
func (o *AES_Type) GetKEYR2() uint32 {
	return volatile.LoadUint32(&o.KEYR2.Reg)
}

// AES.KEYR3: key register 3
func (o *AES_Type) SetKEYR3(value uint32) {
	volatile.StoreUint32(&o.KEYR3.Reg, value)
}
func (o *AES_Type) GetKEYR3() uint32 {
	return volatile.LoadUint32(&o.KEYR3.Reg)
}

// AES.IVR0: initialization vector register 0
func (o *AES_Type) SetIVR0(value uint32) {
	volatile.StoreUint32(&o.IVR0.Reg, value)
}
func (o *AES_Type) GetIVR0() uint32 {
	return volatile.LoadUint32(&o.IVR0.Reg)
}

// AES.IVR1: initialization vector register 1
func (o *AES_Type) SetIVR1(value uint32) {
	volatile.StoreUint32(&o.IVR1.Reg, value)
}
func (o *AES_Type) GetIVR1() uint32 {
	return volatile.LoadUint32(&o.IVR1.Reg)
}

// AES.IVR2: initialization vector register 2
func (o *AES_Type) SetIVR2(value uint32) {
	volatile.StoreUint32(&o.IVR2.Reg, value)
}
func (o *AES_Type) GetIVR2() uint32 {
	return volatile.LoadUint32(&o.IVR2.Reg)
}

// AES.IVR3: initialization vector register 3
func (o *AES_Type) SetIVR3(value uint32) {
	volatile.StoreUint32(&o.IVR3.Reg, value)
}
func (o *AES_Type) GetIVR3() uint32 {
	return volatile.LoadUint32(&o.IVR3.Reg)
}

// AES.KEYR4: key register 4
func (o *AES_Type) SetKEYR4(value uint32) {
	volatile.StoreUint32(&o.KEYR4.Reg, value)
}
func (o *AES_Type) GetKEYR4() uint32 {
	return volatile.LoadUint32(&o.KEYR4.Reg)
}

// AES.KEYR5: key register 5
func (o *AES_Type) SetKEYR5(value uint32) {
	volatile.StoreUint32(&o.KEYR5.Reg, value)
}
func (o *AES_Type) GetKEYR5() uint32 {
	return volatile.LoadUint32(&o.KEYR5.Reg)
}

// AES.KEYR6: key register 6
func (o *AES_Type) SetKEYR6(value uint32) {
	volatile.StoreUint32(&o.KEYR6.Reg, value)
}
func (o *AES_Type) GetKEYR6() uint32 {
	return volatile.LoadUint32(&o.KEYR6.Reg)
}

// AES.KEYR7: key register 7
func (o *AES_Type) SetKEYR7(value uint32) {
	volatile.StoreUint32(&o.KEYR7.Reg, value)
}
func (o *AES_Type) GetKEYR7() uint32 {
	return volatile.LoadUint32(&o.KEYR7.Reg)
}

// AES.SUSP0R: AES suspend register 0
func (o *AES_Type) SetSUSP0R(value uint32) {
	volatile.StoreUint32(&o.SUSP0R.Reg, value)
}
func (o *AES_Type) GetSUSP0R() uint32 {
	return volatile.LoadUint32(&o.SUSP0R.Reg)
}

// AES.SUSP1R: AES suspend register 1
func (o *AES_Type) SetSUSP1R(value uint32) {
	volatile.StoreUint32(&o.SUSP1R.Reg, value)
}
func (o *AES_Type) GetSUSP1R() uint32 {
	return volatile.LoadUint32(&o.SUSP1R.Reg)
}

// AES.SUSP2R: AES suspend register 2
func (o *AES_Type) SetSUSP2R(value uint32) {
	volatile.StoreUint32(&o.SUSP2R.Reg, value)
}
func (o *AES_Type) GetSUSP2R() uint32 {
	return volatile.LoadUint32(&o.SUSP2R.Reg)
}

// AES.SUSP3R: AES suspend register 3
func (o *AES_Type) SetSUSP3R(value uint32) {
	volatile.StoreUint32(&o.SUSP3R.Reg, value)
}
func (o *AES_Type) GetSUSP3R() uint32 {
	return volatile.LoadUint32(&o.SUSP3R.Reg)
}

// AES.SUSP4R: AES suspend register 4
func (o *AES_Type) SetSUSP4R(value uint32) {
	volatile.StoreUint32(&o.SUSP4R.Reg, value)
}
func (o *AES_Type) GetSUSP4R() uint32 {
	return volatile.LoadUint32(&o.SUSP4R.Reg)
}

// AES.SUSP5R: AES suspend register 5
func (o *AES_Type) SetSUSP5R(value uint32) {
	volatile.StoreUint32(&o.SUSP5R.Reg, value)
}
func (o *AES_Type) GetSUSP5R() uint32 {
	return volatile.LoadUint32(&o.SUSP5R.Reg)
}

// AES.SUSP6R: AES suspend register 6
func (o *AES_Type) SetSUSP6R(value uint32) {
	volatile.StoreUint32(&o.SUSP6R.Reg, value)
}
func (o *AES_Type) GetSUSP6R() uint32 {
	return volatile.LoadUint32(&o.SUSP6R.Reg)
}

// AES.SUSP7R: AES suspend register 7
func (o *AES_Type) SetSUSP7R(value uint32) {
	volatile.StoreUint32(&o.SUSP7R.Reg, value)
}
func (o *AES_Type) GetSUSP7R() uint32 {
	return volatile.LoadUint32(&o.SUSP7R.Reg)
}

// USBPHYC register interface
type USBPHYC_Type struct {
	PLL1 volatile.Register32 // 0x0
	_    [8]byte
	TUNE volatile.Register32 // 0xC
	_    [8]byte
	LDO  volatile.Register32 // 0x18
}

// USBPHYC.PLL1: USBPHYC PLL1 control register
func (o *USBPHYC_Type) SetPLL1_PLL1EN(value uint32) {
	volatile.StoreUint32(&o.PLL1.Reg, volatile.LoadUint32(&o.PLL1.Reg)&^(0x1)|value)
}
func (o *USBPHYC_Type) GetPLL1_PLL1EN() uint32 {
	return volatile.LoadUint32(&o.PLL1.Reg) & 0x1
}
func (o *USBPHYC_Type) SetPLL1_PLL1SEL(value uint32) {
	volatile.StoreUint32(&o.PLL1.Reg, volatile.LoadUint32(&o.PLL1.Reg)&^(0xe)|value<<1)
}
func (o *USBPHYC_Type) GetPLL1_PLL1SEL() uint32 {
	return (volatile.LoadUint32(&o.PLL1.Reg) & 0xe) >> 1
}

// USBPHYC.TUNE: USBPHYC tuning control register
func (o *USBPHYC_Type) SetTUNE_INCURREN(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x1)|value)
}
func (o *USBPHYC_Type) GetTUNE_INCURREN() uint32 {
	return volatile.LoadUint32(&o.TUNE.Reg) & 0x1
}
func (o *USBPHYC_Type) SetTUNE_INCURRINT(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x2)|value<<1)
}
func (o *USBPHYC_Type) GetTUNE_INCURRINT() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x2) >> 1
}
func (o *USBPHYC_Type) SetTUNE_LFSCAPEN(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x4)|value<<2)
}
func (o *USBPHYC_Type) GetTUNE_LFSCAPEN() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x4) >> 2
}
func (o *USBPHYC_Type) SetTUNE_HSDRVSLEW(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x8)|value<<3)
}
func (o *USBPHYC_Type) GetTUNE_HSDRVSLEW() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x8) >> 3
}
func (o *USBPHYC_Type) SetTUNE_HSDRVDCCUR(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x10)|value<<4)
}
func (o *USBPHYC_Type) GetTUNE_HSDRVDCCUR() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x10) >> 4
}
func (o *USBPHYC_Type) SetTUNE_HSDRVDCLEV(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x20)|value<<5)
}
func (o *USBPHYC_Type) GetTUNE_HSDRVDCLEV() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x20) >> 5
}
func (o *USBPHYC_Type) SetTUNE_HSDRVCURINCR(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x40)|value<<6)
}
func (o *USBPHYC_Type) GetTUNE_HSDRVCURINCR() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x40) >> 6
}
func (o *USBPHYC_Type) SetTUNE_FSDRVRFADJ(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x80)|value<<7)
}
func (o *USBPHYC_Type) GetTUNE_FSDRVRFADJ() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x80) >> 7
}
func (o *USBPHYC_Type) SetTUNE_HSDRVRFRED(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x100)|value<<8)
}
func (o *USBPHYC_Type) GetTUNE_HSDRVRFRED() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x100) >> 8
}
func (o *USBPHYC_Type) SetTUNE_HSDRVCHKITRM(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x1e00)|value<<9)
}
func (o *USBPHYC_Type) GetTUNE_HSDRVCHKITRM() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x1e00) >> 9
}
func (o *USBPHYC_Type) SetTUNE_HSDRVCHKZTRM(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x6000)|value<<13)
}
func (o *USBPHYC_Type) GetTUNE_HSDRVCHKZTRM() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x6000) >> 13
}
func (o *USBPHYC_Type) SetTUNE_SQLCHCTL(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x18000)|value<<15)
}
func (o *USBPHYC_Type) GetTUNE_SQLCHCTL() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x18000) >> 15
}
func (o *USBPHYC_Type) SetTUNE_HDRXGNEQEN(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x20000)|value<<17)
}
func (o *USBPHYC_Type) GetTUNE_HDRXGNEQEN() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x20000) >> 17
}
func (o *USBPHYC_Type) SetTUNE_STAGSEL(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x40000)|value<<18)
}
func (o *USBPHYC_Type) GetTUNE_STAGSEL() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x40000) >> 18
}
func (o *USBPHYC_Type) SetTUNE_HSFALLPREEM(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x80000)|value<<19)
}
func (o *USBPHYC_Type) GetTUNE_HSFALLPREEM() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x80000) >> 19
}
func (o *USBPHYC_Type) SetTUNE_HSRXOFF(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x300000)|value<<20)
}
func (o *USBPHYC_Type) GetTUNE_HSRXOFF() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x300000) >> 20
}
func (o *USBPHYC_Type) SetTUNE_SHTCCTCTLPROT(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x400000)|value<<22)
}
func (o *USBPHYC_Type) GetTUNE_SHTCCTCTLPROT() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x400000) >> 22
}
func (o *USBPHYC_Type) SetTUNE_SQLBYP(value uint32) {
	volatile.StoreUint32(&o.TUNE.Reg, volatile.LoadUint32(&o.TUNE.Reg)&^(0x800000)|value<<23)
}
func (o *USBPHYC_Type) GetTUNE_SQLBYP() uint32 {
	return (volatile.LoadUint32(&o.TUNE.Reg) & 0x800000) >> 23
}

// USBPHYC.LDO: USBPHYC LDO control and status register
func (o *USBPHYC_Type) SetLDO_LDO_USED(value uint32) {
	volatile.StoreUint32(&o.LDO.Reg, volatile.LoadUint32(&o.LDO.Reg)&^(0x1)|value)
}
func (o *USBPHYC_Type) GetLDO_LDO_USED() uint32 {
	return volatile.LoadUint32(&o.LDO.Reg) & 0x1
}
func (o *USBPHYC_Type) SetLDO_LDO_STATUS(value uint32) {
	volatile.StoreUint32(&o.LDO.Reg, volatile.LoadUint32(&o.LDO.Reg)&^(0x2)|value<<1)
}
func (o *USBPHYC_Type) GetLDO_LDO_STATUS() uint32 {
	return (volatile.LoadUint32(&o.LDO.Reg) & 0x2) >> 1
}
func (o *USBPHYC_Type) SetLDO_LDO_DISABLE(value uint32) {
	volatile.StoreUint32(&o.LDO.Reg, volatile.LoadUint32(&o.LDO.Reg)&^(0x4)|value<<2)
}
func (o *USBPHYC_Type) GetLDO_LDO_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.LDO.Reg) & 0x4) >> 2
}

// Constants for TIM1: Advanced-timers
const (
	// CR1: control register 1
	// Position of CKD field.
	TIM_CR1_CKD_Pos = 0x8
	// Bit mask of CKD field.
	TIM_CR1_CKD_Msk = 0x300
	// t_DTS = t_CK_INT
	TIM_CR1_CKD_Div1 = 0x0
	// t_DTS = 2 × t_CK_INT
	TIM_CR1_CKD_Div2 = 0x1
	// t_DTS = 4 × t_CK_INT
	TIM_CR1_CKD_Div4 = 0x2
	// Position of ARPE field.
	TIM_CR1_ARPE_Pos = 0x7
	// Bit mask of ARPE field.
	TIM_CR1_ARPE_Msk = 0x80
	// Bit ARPE.
	TIM_CR1_ARPE = 0x80
	// TIMx_APRR register is not buffered
	TIM_CR1_ARPE_Disabled = 0x0
	// TIMx_APRR register is buffered
	TIM_CR1_ARPE_Enabled = 0x1
	// Position of CMS field.
	TIM_CR1_CMS_Pos = 0x5
	// Bit mask of CMS field.
	TIM_CR1_CMS_Msk = 0x60
	// The counter counts up or down depending on the direction bit
	TIM_CR1_CMS_EdgeAligned = 0x0
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting down.
	TIM_CR1_CMS_CenterAligned1 = 0x1
	// The counter counts up and down alternatively. Output compare interrupt flags are set only when the counter is counting up.
	TIM_CR1_CMS_CenterAligned2 = 0x2
	// The counter counts up and down alternatively. Output compare interrupt flags are set both when the counter is counting up or down.
	TIM_CR1_CMS_CenterAligned3 = 0x3
	// Position of DIR field.
	TIM_CR1_DIR_Pos = 0x4
	// Bit mask of DIR field.
	TIM_CR1_DIR_Msk = 0x10
	// Bit DIR.
	TIM_CR1_DIR = 0x10
	// Counter used as upcounter
	TIM_CR1_DIR_Up = 0x0
	// Counter used as downcounter
	TIM_CR1_DIR_Down = 0x1
	// Position of OPM field.
	TIM_CR1_OPM_Pos = 0x3
	// Bit mask of OPM field.
	TIM_CR1_OPM_Msk = 0x8
	// Bit OPM.
	TIM_CR1_OPM = 0x8
	// Counter is not stopped at update event
	TIM_CR1_OPM_Disabled = 0x0
	// Counter stops counting at the next update event (clearing the CEN bit)
	TIM_CR1_OPM_Enabled = 0x1
	// Position of URS field.
	TIM_CR1_URS_Pos = 0x2
	// Bit mask of URS field.
	TIM_CR1_URS_Msk = 0x4
	// Bit URS.
	TIM_CR1_URS = 0x4
	// Any of counter overflow/underflow, setting UG, or update through slave mode, generates an update interrupt or DMA request
	TIM_CR1_URS_AnyEvent = 0x0
	// Only counter overflow/underflow generates an update interrupt or DMA request
	TIM_CR1_URS_CounterOnly = 0x1
	// Position of UDIS field.
	TIM_CR1_UDIS_Pos = 0x1
	// Bit mask of UDIS field.
	TIM_CR1_UDIS_Msk = 0x2
	// Bit UDIS.
	TIM_CR1_UDIS = 0x2
	// Update event enabled
	TIM_CR1_UDIS_Enabled = 0x0
	// Update event disabled
	TIM_CR1_UDIS_Disabled = 0x1
	// Position of CEN field.
	TIM_CR1_CEN_Pos = 0x0
	// Bit mask of CEN field.
	TIM_CR1_CEN_Msk = 0x1
	// Bit CEN.
	TIM_CR1_CEN = 0x1
	// Counter disabled
	TIM_CR1_CEN_Disabled = 0x0
	// Counter enabled
	TIM_CR1_CEN_Enabled = 0x1
	// Position of UIFREMAP field.
	TIM_CR1_UIFREMAP_Pos = 0xb
	// Bit mask of UIFREMAP field.
	TIM_CR1_UIFREMAP_Msk = 0x800
	// Bit UIFREMAP.
	TIM_CR1_UIFREMAP = 0x800

	// CR2: control register 2
	// Position of OIS4 field.
	TIM_CR2_OIS4_Pos = 0xe
	// Bit mask of OIS4 field.
	TIM_CR2_OIS4_Msk = 0x4000
	// Bit OIS4.
	TIM_CR2_OIS4 = 0x4000
	// Position of OIS3N field.
	TIM_CR2_OIS3N_Pos = 0xd
	// Bit mask of OIS3N field.
	TIM_CR2_OIS3N_Msk = 0x2000
	// Bit OIS3N.
	TIM_CR2_OIS3N = 0x2000
	// Position of OIS3 field.
	TIM_CR2_OIS3_Pos = 0xc
	// Bit mask of OIS3 field.
	TIM_CR2_OIS3_Msk = 0x1000
	// Bit OIS3.
	TIM_CR2_OIS3 = 0x1000
	// Position of OIS2N field.
	TIM_CR2_OIS2N_Pos = 0xb
	// Bit mask of OIS2N field.
	TIM_CR2_OIS2N_Msk = 0x800
	// Bit OIS2N.
	TIM_CR2_OIS2N = 0x800
	// Position of OIS2 field.
	TIM_CR2_OIS2_Pos = 0xa
	// Bit mask of OIS2 field.
	TIM_CR2_OIS2_Msk = 0x400
	// Bit OIS2.
	TIM_CR2_OIS2 = 0x400
	// Position of OIS1N field.
	TIM_CR2_OIS1N_Pos = 0x9
	// Bit mask of OIS1N field.
	TIM_CR2_OIS1N_Msk = 0x200
	// Bit OIS1N.
	TIM_CR2_OIS1N = 0x200
	// Position of OIS1 field.
	TIM_CR2_OIS1_Pos = 0x8
	// Bit mask of OIS1 field.
	TIM_CR2_OIS1_Msk = 0x100
	// Bit OIS1.
	TIM_CR2_OIS1 = 0x100
	// Position of TI1S field.
	TIM_CR2_TI1S_Pos = 0x7
	// Bit mask of TI1S field.
	TIM_CR2_TI1S_Msk = 0x80
	// Bit TI1S.
	TIM_CR2_TI1S = 0x80
	// The TIMx_CH1 pin is connected to TI1 input
	TIM_CR2_TI1S_Normal = 0x0
	// The TIMx_CH1, CH2, CH3 pins are connected to TI1 input
	TIM_CR2_TI1S_XOR = 0x1
	// Position of MMS field.
	TIM_CR2_MMS_Pos = 0x4
	// Bit mask of MMS field.
	TIM_CR2_MMS_Msk = 0x70
	// The UG bit from the TIMx_EGR register is used as trigger output
	TIM_CR2_MMS_Reset = 0x0
	// The counter enable signal, CNT_EN, is used as trigger output
	TIM_CR2_MMS_Enable = 0x1
	// The update event is selected as trigger output
	TIM_CR2_MMS_Update = 0x2
	// The trigger output send a positive pulse when the CC1IF flag it to be set, as soon as a capture or a compare match occurred
	TIM_CR2_MMS_ComparePulse = 0x3
	// OC1REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC1 = 0x4
	// OC2REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC2 = 0x5
	// OC3REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC3 = 0x6
	// OC4REF signal is used as trigger output
	TIM_CR2_MMS_CompareOC4 = 0x7
	// Position of CCDS field.
	TIM_CR2_CCDS_Pos = 0x3
	// Bit mask of CCDS field.
	TIM_CR2_CCDS_Msk = 0x8
	// Bit CCDS.
	TIM_CR2_CCDS = 0x8
	// CCx DMA request sent when CCx event occurs
	TIM_CR2_CCDS_OnCompare = 0x0
	// CCx DMA request sent when update event occurs
	TIM_CR2_CCDS_OnUpdate = 0x1
	// Position of CCUS field.
	TIM_CR2_CCUS_Pos = 0x2
	// Bit mask of CCUS field.
	TIM_CR2_CCUS_Msk = 0x4
	// Bit CCUS.
	TIM_CR2_CCUS = 0x4
	// Position of CCPC field.
	TIM_CR2_CCPC_Pos = 0x0
	// Bit mask of CCPC field.
	TIM_CR2_CCPC_Msk = 0x1
	// Bit CCPC.
	TIM_CR2_CCPC = 0x1
	// Position of MMS2 field.
	TIM_CR2_MMS2_Pos = 0x14
	// Bit mask of MMS2 field.
	TIM_CR2_MMS2_Msk = 0xf00000
	// Position of OIS6 field.
	TIM_CR2_OIS6_Pos = 0x12
	// Bit mask of OIS6 field.
	TIM_CR2_OIS6_Msk = 0x40000
	// Bit OIS6.
	TIM_CR2_OIS6 = 0x40000
	// Position of OIS5 field.
	TIM_CR2_OIS5_Pos = 0x10
	// Bit mask of OIS5 field.
	TIM_CR2_OIS5_Msk = 0x10000
	// Bit OIS5.
	TIM_CR2_OIS5 = 0x10000

	// SMCR: slave mode control register
	// Position of SMS_3 field.
	TIM_SMCR_SMS_3_Pos = 0x10
	// Bit mask of SMS_3 field.
	TIM_SMCR_SMS_3_Msk = 0x10000
	// Bit SMS_3.
	TIM_SMCR_SMS_3 = 0x10000
	// Position of ETP field.
	TIM_SMCR_ETP_Pos = 0xf
	// Bit mask of ETP field.
	TIM_SMCR_ETP_Msk = 0x8000
	// Bit ETP.
	TIM_SMCR_ETP = 0x8000
	// ETR is noninverted, active at high level or rising edge
	TIM_SMCR_ETP_NotInverted = 0x0
	// ETR is inverted, active at low level or falling edge
	TIM_SMCR_ETP_Inverted = 0x1
	// Position of ECE field.
	TIM_SMCR_ECE_Pos = 0xe
	// Bit mask of ECE field.
	TIM_SMCR_ECE_Msk = 0x4000
	// Bit ECE.
	TIM_SMCR_ECE = 0x4000
	// External clock mode 2 disabled
	TIM_SMCR_ECE_Disabled = 0x0
	// External clock mode 2 enabled. The counter is clocked by any active edge on the ETRF signal.
	TIM_SMCR_ECE_Enabled = 0x1
	// Position of ETPS field.
	TIM_SMCR_ETPS_Pos = 0xc
	// Bit mask of ETPS field.
	TIM_SMCR_ETPS_Msk = 0x3000
	// Prescaler OFF
	TIM_SMCR_ETPS_Div1 = 0x0
	// ETRP frequency divided by 2
	TIM_SMCR_ETPS_Div2 = 0x1
	// ETRP frequency divided by 4
	TIM_SMCR_ETPS_Div4 = 0x2
	// ETRP frequency divided by 8
	TIM_SMCR_ETPS_Div8 = 0x3
	// Position of ETF field.
	TIM_SMCR_ETF_Pos = 0x8
	// Bit mask of ETF field.
	TIM_SMCR_ETF_Msk = 0xf00
	// No filter, sampling is done at fDTS
	TIM_SMCR_ETF_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_SMCR_ETF_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_SMCR_ETF_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_SMCR_ETF_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_SMCR_ETF_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_SMCR_ETF_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_SMCR_ETF_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_SMCR_ETF_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_SMCR_ETF_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_SMCR_ETF_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_SMCR_ETF_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_SMCR_ETF_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_SMCR_ETF_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_SMCR_ETF_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_SMCR_ETF_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_SMCR_ETF_FDTS_Div32_N8 = 0xf
	// Position of MSM field.
	TIM_SMCR_MSM_Pos = 0x7
	// Bit mask of MSM field.
	TIM_SMCR_MSM_Msk = 0x80
	// Bit MSM.
	TIM_SMCR_MSM = 0x80
	// No action
	TIM_SMCR_MSM_NoSync = 0x0
	// The effect of an event on the trigger input (TRGI) is delayed to allow a perfect synchronization between the current timer and its slaves (through TRGO). It is useful if we want to synchronize several timers on a single external event.
	TIM_SMCR_MSM_Sync = 0x1
	// Position of TS field.
	TIM_SMCR_TS_Pos = 0x4
	// Bit mask of TS field.
	TIM_SMCR_TS_Msk = 0x70
	// Internal Trigger 0 (ITR0)
	TIM_SMCR_TS_ITR0 = 0x0
	// Internal Trigger 1 (ITR1)
	TIM_SMCR_TS_ITR1 = 0x1
	// Internal Trigger 2 (ITR2)
	TIM_SMCR_TS_ITR2 = 0x2
	// TI1 Edge Detector (TI1F_ED)
	TIM_SMCR_TS_TI1F_ED = 0x4
	// Filtered Timer Input 1 (TI1FP1)
	TIM_SMCR_TS_TI1FP1 = 0x5
	// Filtered Timer Input 2 (TI2FP2)
	TIM_SMCR_TS_TI2FP2 = 0x6
	// External Trigger input (ETRF)
	TIM_SMCR_TS_ETRF = 0x7
	// Position of SMS field.
	TIM_SMCR_SMS_Pos = 0x0
	// Bit mask of SMS field.
	TIM_SMCR_SMS_Msk = 0x7
	// Slave mode disabled - if CEN = ‘1 then the prescaler is clocked directly by the internal clock.
	TIM_SMCR_SMS_Disabled = 0x0
	// Encoder mode 1 - Counter counts up/down on TI2FP1 edge depending on TI1FP2 level.
	TIM_SMCR_SMS_Encoder_Mode_1 = 0x1
	// Encoder mode 2 - Counter counts up/down on TI1FP2 edge depending on TI2FP1 level.
	TIM_SMCR_SMS_Encoder_Mode_2 = 0x2
	// Encoder mode 3 - Counter counts up/down on both TI1FP1 and TI2FP2 edges depending on the level of the other input.
	TIM_SMCR_SMS_Encoder_Mode_3 = 0x3
	// Reset Mode - Rising edge of the selected trigger input (TRGI) reinitializes the counter and generates an update of the registers.
	TIM_SMCR_SMS_Reset_Mode = 0x4
	// Gated Mode - The counter clock is enabled when the trigger input (TRGI) is high. The counter stops (but is not reset) as soon as the trigger becomes low. Both start and stop of the counter are controlled.
	TIM_SMCR_SMS_Gated_Mode = 0x5
	// Trigger Mode - The counter starts at a rising edge of the trigger TRGI (but it is not reset). Only the start of the counter is controlled.
	TIM_SMCR_SMS_Trigger_Mode = 0x6
	// External Clock Mode 1 - Rising edges of the selected trigger (TRGI) clock the counter.
	TIM_SMCR_SMS_Ext_Clock_Mode = 0x7

	// DIER: DMA/Interrupt enable register
	// Position of TDE field.
	TIM_DIER_TDE_Pos = 0xe
	// Bit mask of TDE field.
	TIM_DIER_TDE_Msk = 0x4000
	// Bit TDE.
	TIM_DIER_TDE = 0x4000
	// Trigger DMA request disabled
	TIM_DIER_TDE_Disabled = 0x0
	// Trigger DMA request enabled
	TIM_DIER_TDE_Enabled = 0x1
	// Position of COMDE field.
	TIM_DIER_COMDE_Pos = 0xd
	// Bit mask of COMDE field.
	TIM_DIER_COMDE_Msk = 0x2000
	// Bit COMDE.
	TIM_DIER_COMDE = 0x2000
	// Position of CC4DE field.
	TIM_DIER_CC4DE_Pos = 0xc
	// Bit mask of CC4DE field.
	TIM_DIER_CC4DE_Msk = 0x1000
	// Bit CC4DE.
	TIM_DIER_CC4DE = 0x1000
	// CCx DMA request disabled
	TIM_DIER_CC4DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC4DE_Enabled = 0x1
	// Position of CC3DE field.
	TIM_DIER_CC3DE_Pos = 0xb
	// Bit mask of CC3DE field.
	TIM_DIER_CC3DE_Msk = 0x800
	// Bit CC3DE.
	TIM_DIER_CC3DE = 0x800
	// CCx DMA request disabled
	TIM_DIER_CC3DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC3DE_Enabled = 0x1
	// Position of CC2DE field.
	TIM_DIER_CC2DE_Pos = 0xa
	// Bit mask of CC2DE field.
	TIM_DIER_CC2DE_Msk = 0x400
	// Bit CC2DE.
	TIM_DIER_CC2DE = 0x400
	// CCx DMA request disabled
	TIM_DIER_CC2DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC2DE_Enabled = 0x1
	// Position of CC1DE field.
	TIM_DIER_CC1DE_Pos = 0x9
	// Bit mask of CC1DE field.
	TIM_DIER_CC1DE_Msk = 0x200
	// Bit CC1DE.
	TIM_DIER_CC1DE = 0x200
	// CCx DMA request disabled
	TIM_DIER_CC1DE_Disabled = 0x0
	// CCx DMA request enabled
	TIM_DIER_CC1DE_Enabled = 0x1
	// Position of UDE field.
	TIM_DIER_UDE_Pos = 0x8
	// Bit mask of UDE field.
	TIM_DIER_UDE_Msk = 0x100
	// Bit UDE.
	TIM_DIER_UDE = 0x100
	// Update DMA request disabled
	TIM_DIER_UDE_Disabled = 0x0
	// Update DMA request enabled
	TIM_DIER_UDE_Enabled = 0x1
	// Position of TIE field.
	TIM_DIER_TIE_Pos = 0x6
	// Bit mask of TIE field.
	TIM_DIER_TIE_Msk = 0x40
	// Bit TIE.
	TIM_DIER_TIE = 0x40
	// Trigger interrupt disabled
	TIM_DIER_TIE_Disabled = 0x0
	// Trigger interrupt enabled
	TIM_DIER_TIE_Enabled = 0x1
	// Position of CC4IE field.
	TIM_DIER_CC4IE_Pos = 0x4
	// Bit mask of CC4IE field.
	TIM_DIER_CC4IE_Msk = 0x10
	// Bit CC4IE.
	TIM_DIER_CC4IE = 0x10
	// CCx interrupt disabled
	TIM_DIER_CC4IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC4IE_Enabled = 0x1
	// Position of CC3IE field.
	TIM_DIER_CC3IE_Pos = 0x3
	// Bit mask of CC3IE field.
	TIM_DIER_CC3IE_Msk = 0x8
	// Bit CC3IE.
	TIM_DIER_CC3IE = 0x8
	// CCx interrupt disabled
	TIM_DIER_CC3IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC3IE_Enabled = 0x1
	// Position of CC2IE field.
	TIM_DIER_CC2IE_Pos = 0x2
	// Bit mask of CC2IE field.
	TIM_DIER_CC2IE_Msk = 0x4
	// Bit CC2IE.
	TIM_DIER_CC2IE = 0x4
	// CCx interrupt disabled
	TIM_DIER_CC2IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC2IE_Enabled = 0x1
	// Position of CC1IE field.
	TIM_DIER_CC1IE_Pos = 0x1
	// Bit mask of CC1IE field.
	TIM_DIER_CC1IE_Msk = 0x2
	// Bit CC1IE.
	TIM_DIER_CC1IE = 0x2
	// CCx interrupt disabled
	TIM_DIER_CC1IE_Disabled = 0x0
	// CCx interrupt enabled
	TIM_DIER_CC1IE_Enabled = 0x1
	// Position of UIE field.
	TIM_DIER_UIE_Pos = 0x0
	// Bit mask of UIE field.
	TIM_DIER_UIE_Msk = 0x1
	// Bit UIE.
	TIM_DIER_UIE = 0x1
	// Update interrupt disabled
	TIM_DIER_UIE_Disabled = 0x0
	// Update interrupt enabled
	TIM_DIER_UIE_Enabled = 0x1
	// Position of BIE field.
	TIM_DIER_BIE_Pos = 0x7
	// Bit mask of BIE field.
	TIM_DIER_BIE_Msk = 0x80
	// Bit BIE.
	TIM_DIER_BIE = 0x80
	// Position of COMIE field.
	TIM_DIER_COMIE_Pos = 0x5
	// Bit mask of COMIE field.
	TIM_DIER_COMIE_Msk = 0x20
	// Bit COMIE.
	TIM_DIER_COMIE = 0x20

	// SR: status register
	// Position of CC4OF field.
	TIM_SR_CC4OF_Pos = 0xc
	// Bit mask of CC4OF field.
	TIM_SR_CC4OF_Msk = 0x1000
	// Bit CC4OF.
	TIM_SR_CC4OF = 0x1000
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC4OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC4OF_Clear = 0x0
	// Position of CC3OF field.
	TIM_SR_CC3OF_Pos = 0xb
	// Bit mask of CC3OF field.
	TIM_SR_CC3OF_Msk = 0x800
	// Bit CC3OF.
	TIM_SR_CC3OF = 0x800
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC3OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC3OF_Clear = 0x0
	// Position of CC2OF field.
	TIM_SR_CC2OF_Pos = 0xa
	// Bit mask of CC2OF field.
	TIM_SR_CC2OF_Msk = 0x400
	// Bit CC2OF.
	TIM_SR_CC2OF = 0x400
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC2OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC2OF_Clear = 0x0
	// Position of CC1OF field.
	TIM_SR_CC1OF_Pos = 0x9
	// Bit mask of CC1OF field.
	TIM_SR_CC1OF_Msk = 0x200
	// Bit CC1OF.
	TIM_SR_CC1OF = 0x200
	// The counter value has been captured in TIMx_CCRx register while CCxIF flag was already set
	TIM_SR_CC1OF_Overcapture = 0x1
	// Clear flag
	TIM_SR_CC1OF_Clear = 0x0
	// Position of BIF field.
	TIM_SR_BIF_Pos = 0x7
	// Bit mask of BIF field.
	TIM_SR_BIF_Msk = 0x80
	// Bit BIF.
	TIM_SR_BIF = 0x80
	// Position of TIF field.
	TIM_SR_TIF_Pos = 0x6
	// Bit mask of TIF field.
	TIM_SR_TIF_Msk = 0x40
	// Bit TIF.
	TIM_SR_TIF = 0x40
	// No trigger event occurred
	TIM_SR_TIF_NoTrigger = 0x0
	// Trigger interrupt pending
	TIM_SR_TIF_Trigger = 0x1
	// Clear flag
	TIM_SR_TIF_Clear = 0x0
	// Position of COMIF field.
	TIM_SR_COMIF_Pos = 0x5
	// Bit mask of COMIF field.
	TIM_SR_COMIF_Msk = 0x20
	// Bit COMIF.
	TIM_SR_COMIF = 0x20
	// Position of CC4IF field.
	TIM_SR_CC4IF_Pos = 0x4
	// Bit mask of CC4IF field.
	TIM_SR_CC4IF_Msk = 0x10
	// Bit CC4IF.
	TIM_SR_CC4IF = 0x10
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC4IF_Match = 0x1
	// Clear flag
	TIM_SR_CC4IF_Clear = 0x0
	// Position of CC3IF field.
	TIM_SR_CC3IF_Pos = 0x3
	// Bit mask of CC3IF field.
	TIM_SR_CC3IF_Msk = 0x8
	// Bit CC3IF.
	TIM_SR_CC3IF = 0x8
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC3IF_Match = 0x1
	// Clear flag
	TIM_SR_CC3IF_Clear = 0x0
	// Position of CC2IF field.
	TIM_SR_CC2IF_Pos = 0x2
	// Bit mask of CC2IF field.
	TIM_SR_CC2IF_Msk = 0x4
	// Bit CC2IF.
	TIM_SR_CC2IF = 0x4
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC2IF_Match = 0x1
	// Clear flag
	TIM_SR_CC2IF_Clear = 0x0
	// Position of CC1IF field.
	TIM_SR_CC1IF_Pos = 0x1
	// Bit mask of CC1IF field.
	TIM_SR_CC1IF_Msk = 0x2
	// Bit CC1IF.
	TIM_SR_CC1IF = 0x2
	// If CC1 is an output: The content of the counter TIMx_CNT matches the content of the TIMx_CCR1 register. If CC1 is an input: The counter value has been captured in TIMx_CCR1 register.
	TIM_SR_CC1IF_Match = 0x1
	// Clear flag
	TIM_SR_CC1IF_Clear = 0x0
	// Position of UIF field.
	TIM_SR_UIF_Pos = 0x0
	// Bit mask of UIF field.
	TIM_SR_UIF_Msk = 0x1
	// Bit UIF.
	TIM_SR_UIF = 0x1
	// No update occurred
	TIM_SR_UIF_Clear = 0x0
	// Update interrupt pending.
	TIM_SR_UIF_UpdatePending = 0x1
	// Position of B2IF field.
	TIM_SR_B2IF_Pos = 0x8
	// Bit mask of B2IF field.
	TIM_SR_B2IF_Msk = 0x100
	// Bit B2IF.
	TIM_SR_B2IF = 0x100
	// Position of CC5IF field.
	TIM_SR_CC5IF_Pos = 0x10
	// Bit mask of CC5IF field.
	TIM_SR_CC5IF_Msk = 0x10000
	// Bit CC5IF.
	TIM_SR_CC5IF = 0x10000
	// Position of CC6IF field.
	TIM_SR_CC6IF_Pos = 0x11
	// Bit mask of CC6IF field.
	TIM_SR_CC6IF_Msk = 0x20000
	// Bit CC6IF.
	TIM_SR_CC6IF = 0x20000

	// EGR: event generation register
	// Position of BG field.
	TIM_EGR_BG_Pos = 0x7
	// Bit mask of BG field.
	TIM_EGR_BG_Msk = 0x80
	// Bit BG.
	TIM_EGR_BG = 0x80
	// Position of TG field.
	TIM_EGR_TG_Pos = 0x6
	// Bit mask of TG field.
	TIM_EGR_TG_Msk = 0x40
	// Bit TG.
	TIM_EGR_TG = 0x40
	// The TIF flag is set in TIMx_SR register. Related interrupt or DMA transfer can occur if enabled.
	TIM_EGR_TG_Trigger = 0x1
	// Position of COMG field.
	TIM_EGR_COMG_Pos = 0x5
	// Bit mask of COMG field.
	TIM_EGR_COMG_Msk = 0x20
	// Bit COMG.
	TIM_EGR_COMG = 0x20
	// Position of CC4G field.
	TIM_EGR_CC4G_Pos = 0x4
	// Bit mask of CC4G field.
	TIM_EGR_CC4G_Msk = 0x10
	// Bit CC4G.
	TIM_EGR_CC4G = 0x10
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC4G_Trigger = 0x1
	// Position of CC3G field.
	TIM_EGR_CC3G_Pos = 0x3
	// Bit mask of CC3G field.
	TIM_EGR_CC3G_Msk = 0x8
	// Bit CC3G.
	TIM_EGR_CC3G = 0x8
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC3G_Trigger = 0x1
	// Position of CC2G field.
	TIM_EGR_CC2G_Pos = 0x2
	// Bit mask of CC2G field.
	TIM_EGR_CC2G_Msk = 0x4
	// Bit CC2G.
	TIM_EGR_CC2G = 0x4
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC2G_Trigger = 0x1
	// Position of CC1G field.
	TIM_EGR_CC1G_Pos = 0x1
	// Bit mask of CC1G field.
	TIM_EGR_CC1G_Msk = 0x2
	// Bit CC1G.
	TIM_EGR_CC1G = 0x2
	// If CC1 is an output: CC1IF flag is set, Corresponding interrupt or DMA request is sent if enabled. If CC1 is an input: The current value of the counter is captured in TIMx_CCR1 register.
	TIM_EGR_CC1G_Trigger = 0x1
	// Position of UG field.
	TIM_EGR_UG_Pos = 0x0
	// Bit mask of UG field.
	TIM_EGR_UG_Msk = 0x1
	// Bit UG.
	TIM_EGR_UG = 0x1
	// Re-initializes the timer counter and generates an update of the registers.
	TIM_EGR_UG_Update = 0x1
	// Position of B2G field.
	TIM_EGR_B2G_Pos = 0x8
	// Bit mask of B2G field.
	TIM_EGR_B2G_Msk = 0x100
	// Bit B2G.
	TIM_EGR_B2G = 0x100

	// CCMR1_Output: capture/compare mode register 1 (output mode)
	// Position of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Pos = 0xf
	// Bit mask of OC2CE field.
	TIM_CCMR1_Output_OC2CE_Msk = 0x8000
	// Bit OC2CE.
	TIM_CCMR1_Output_OC2CE = 0x8000
	// Position of OC2M field.
	TIM_CCMR1_Output_OC2M_Pos = 0xc
	// Bit mask of OC2M field.
	TIM_CCMR1_Output_OC2M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR1_Output_OC2M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR1_Output_OC2M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR1_Output_OC2M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR1_Output_OC2M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR1_Output_OC2M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR1_Output_OC2M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR1_Output_OC2M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR1_Output_OC2M_PwmMode2 = 0x7
	// Position of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Pos = 0xb
	// Bit mask of OC2PE field.
	TIM_CCMR1_Output_OC2PE_Msk = 0x800
	// Bit OC2PE.
	TIM_CCMR1_Output_OC2PE = 0x800
	// Preload register on CCR2 disabled. New values written to CCR2 are taken into account immediately
	TIM_CCMR1_Output_OC2PE_Disabled = 0x0
	// Preload register on CCR2 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC2PE_Enabled = 0x1
	// Position of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Pos = 0xa
	// Bit mask of OC2FE field.
	TIM_CCMR1_Output_OC2FE_Msk = 0x400
	// Bit OC2FE.
	TIM_CCMR1_Output_OC2FE = 0x400
	// Position of CC2S field.
	TIM_CCMR1_Output_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Output_CC2S_Msk = 0x300
	// CC2 channel is configured as output
	TIM_CCMR1_Output_CC2S_Output = 0x0
	// Position of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Pos = 0x7
	// Bit mask of OC1CE field.
	TIM_CCMR1_Output_OC1CE_Msk = 0x80
	// Bit OC1CE.
	TIM_CCMR1_Output_OC1CE = 0x80
	// Position of OC1M field.
	TIM_CCMR1_Output_OC1M_Pos = 0x4
	// Bit mask of OC1M field.
	TIM_CCMR1_Output_OC1M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR1_Output_OC1M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR1_Output_OC1M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR1_Output_OC1M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR1_Output_OC1M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR1_Output_OC1M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR1_Output_OC1M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR1_Output_OC1M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR1_Output_OC1M_PwmMode2 = 0x7
	// Position of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Pos = 0x3
	// Bit mask of OC1PE field.
	TIM_CCMR1_Output_OC1PE_Msk = 0x8
	// Bit OC1PE.
	TIM_CCMR1_Output_OC1PE = 0x8
	// Preload register on CCR1 disabled. New values written to CCR1 are taken into account immediately
	TIM_CCMR1_Output_OC1PE_Disabled = 0x0
	// Preload register on CCR1 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR1_Output_OC1PE_Enabled = 0x1
	// Position of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Pos = 0x2
	// Bit mask of OC1FE field.
	TIM_CCMR1_Output_OC1FE_Msk = 0x4
	// Bit OC1FE.
	TIM_CCMR1_Output_OC1FE = 0x4
	// Position of CC1S field.
	TIM_CCMR1_Output_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Output_CC1S_Msk = 0x3
	// CC1 channel is configured as output
	TIM_CCMR1_Output_CC1S_Output = 0x0
	// Position of OC2M_3 field.
	TIM_CCMR1_Output_OC2M_3_Pos = 0x18
	// Bit mask of OC2M_3 field.
	TIM_CCMR1_Output_OC2M_3_Msk = 0x1000000
	// Bit OC2M_3.
	TIM_CCMR1_Output_OC2M_3 = 0x1000000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR1_Output_OC2M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR1_Output_OC2M_3_Extended = 0x1
	// Position of OC1M_3 field.
	TIM_CCMR1_Output_OC1M_3_Pos = 0x10
	// Bit mask of OC1M_3 field.
	TIM_CCMR1_Output_OC1M_3_Msk = 0x10000
	// Bit OC1M_3.
	TIM_CCMR1_Output_OC1M_3 = 0x10000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR1_Output_OC1M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR1_Output_OC1M_3_Extended = 0x1

	// CCMR1_Input: capture/compare mode register 1 (input mode)
	// Position of IC2F field.
	TIM_CCMR1_Input_IC2F_Pos = 0xc
	// Bit mask of IC2F field.
	TIM_CCMR1_Input_IC2F_Msk = 0xf000
	// Position of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Pos = 0xa
	// Bit mask of IC2PSC field.
	TIM_CCMR1_Input_IC2PSC_Msk = 0xc00
	// Position of CC2S field.
	TIM_CCMR1_Input_CC2S_Pos = 0x8
	// Bit mask of CC2S field.
	TIM_CCMR1_Input_CC2S_Msk = 0x300
	// CC2 channel is configured as input, IC2 is mapped on TI2
	TIM_CCMR1_Input_CC2S_TI2 = 0x1
	// CC2 channel is configured as input, IC2 is mapped on TI1
	TIM_CCMR1_Input_CC2S_TI1 = 0x2
	// CC2 channel is configured as input, IC2 is mapped on TRC
	TIM_CCMR1_Input_CC2S_TRC = 0x3
	// Position of IC1F field.
	TIM_CCMR1_Input_IC1F_Pos = 0x4
	// Bit mask of IC1F field.
	TIM_CCMR1_Input_IC1F_Msk = 0xf0
	// No filter, sampling is done at fDTS
	TIM_CCMR1_Input_IC1F_NoFilter = 0x0
	// fSAMPLING=fCK_INT, N=2
	TIM_CCMR1_Input_IC1F_FCK_INT_N2 = 0x1
	// fSAMPLING=fCK_INT, N=4
	TIM_CCMR1_Input_IC1F_FCK_INT_N4 = 0x2
	// fSAMPLING=fCK_INT, N=8
	TIM_CCMR1_Input_IC1F_FCK_INT_N8 = 0x3
	// fSAMPLING=fDTS/2, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N6 = 0x4
	// fSAMPLING=fDTS/2, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div2_N8 = 0x5
	// fSAMPLING=fDTS/4, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N6 = 0x6
	// fSAMPLING=fDTS/4, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div4_N8 = 0x7
	// fSAMPLING=fDTS/8, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N6 = 0x8
	// fSAMPLING=fDTS/8, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div8_N8 = 0x9
	// fSAMPLING=fDTS/16, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N5 = 0xa
	// fSAMPLING=fDTS/16, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N6 = 0xb
	// fSAMPLING=fDTS/16, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div16_N8 = 0xc
	// fSAMPLING=fDTS/32, N=5
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N5 = 0xd
	// fSAMPLING=fDTS/32, N=6
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N6 = 0xe
	// fSAMPLING=fDTS/32, N=8
	TIM_CCMR1_Input_IC1F_FDTS_Div32_N8 = 0xf
	// Position of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Pos = 0x2
	// Bit mask of IC1PSC field.
	TIM_CCMR1_Input_IC1PSC_Msk = 0xc
	// Position of CC1S field.
	TIM_CCMR1_Input_CC1S_Pos = 0x0
	// Bit mask of CC1S field.
	TIM_CCMR1_Input_CC1S_Msk = 0x3
	// CC1 channel is configured as input, IC1 is mapped on TI1
	TIM_CCMR1_Input_CC1S_TI1 = 0x1
	// CC1 channel is configured as input, IC1 is mapped on TI2
	TIM_CCMR1_Input_CC1S_TI2 = 0x2
	// CC1 channel is configured as input, IC1 is mapped on TRC
	TIM_CCMR1_Input_CC1S_TRC = 0x3

	// CCMR2_Output: capture/compare mode register 2 (output mode)
	// Position of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Pos = 0xf
	// Bit mask of OC4CE field.
	TIM_CCMR2_Output_OC4CE_Msk = 0x8000
	// Bit OC4CE.
	TIM_CCMR2_Output_OC4CE = 0x8000
	// Position of OC4M field.
	TIM_CCMR2_Output_OC4M_Pos = 0xc
	// Bit mask of OC4M field.
	TIM_CCMR2_Output_OC4M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR2_Output_OC4M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR2_Output_OC4M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR2_Output_OC4M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR2_Output_OC4M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR2_Output_OC4M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR2_Output_OC4M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC4M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR2_Output_OC4M_PwmMode2 = 0x7
	// Position of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Pos = 0xb
	// Bit mask of OC4PE field.
	TIM_CCMR2_Output_OC4PE_Msk = 0x800
	// Bit OC4PE.
	TIM_CCMR2_Output_OC4PE = 0x800
	// Preload register on CCR4 disabled. New values written to CCR4 are taken into account immediately
	TIM_CCMR2_Output_OC4PE_Disabled = 0x0
	// Preload register on CCR4 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC4PE_Enabled = 0x1
	// Position of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Pos = 0xa
	// Bit mask of OC4FE field.
	TIM_CCMR2_Output_OC4FE_Msk = 0x400
	// Bit OC4FE.
	TIM_CCMR2_Output_OC4FE = 0x400
	// Position of CC4S field.
	TIM_CCMR2_Output_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Output_CC4S_Msk = 0x300
	// CC4 channel is configured as output
	TIM_CCMR2_Output_CC4S_Output = 0x0
	// Position of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Pos = 0x7
	// Bit mask of OC3CE field.
	TIM_CCMR2_Output_OC3CE_Msk = 0x80
	// Bit OC3CE.
	TIM_CCMR2_Output_OC3CE = 0x80
	// Position of OC3M field.
	TIM_CCMR2_Output_OC3M_Pos = 0x4
	// Bit mask of OC3M field.
	TIM_CCMR2_Output_OC3M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR2_Output_OC3M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR2_Output_OC3M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR2_Output_OC3M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR2_Output_OC3M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR2_Output_OC3M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR2_Output_OC3M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR2_Output_OC3M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR2_Output_OC3M_PwmMode2 = 0x7
	// Position of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Pos = 0x3
	// Bit mask of OC3PE field.
	TIM_CCMR2_Output_OC3PE_Msk = 0x8
	// Bit OC3PE.
	TIM_CCMR2_Output_OC3PE = 0x8
	// Preload register on CCR3 disabled. New values written to CCR3 are taken into account immediately
	TIM_CCMR2_Output_OC3PE_Disabled = 0x0
	// Preload register on CCR3 enabled. Preload value is loaded into active register on each update event
	TIM_CCMR2_Output_OC3PE_Enabled = 0x1
	// Position of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Pos = 0x2
	// Bit mask of OC3FE field.
	TIM_CCMR2_Output_OC3FE_Msk = 0x4
	// Bit OC3FE.
	TIM_CCMR2_Output_OC3FE = 0x4
	// Position of CC3S field.
	TIM_CCMR2_Output_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Output_CC3S_Msk = 0x3
	// CC3 channel is configured as output
	TIM_CCMR2_Output_CC3S_Output = 0x0
	// Position of OC4M_3 field.
	TIM_CCMR2_Output_OC4M_3_Pos = 0x18
	// Bit mask of OC4M_3 field.
	TIM_CCMR2_Output_OC4M_3_Msk = 0x1000000
	// Bit OC4M_3.
	TIM_CCMR2_Output_OC4M_3 = 0x1000000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR2_Output_OC4M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR2_Output_OC4M_3_Extended = 0x1
	// Position of OC3M_3 field.
	TIM_CCMR2_Output_OC3M_3_Pos = 0x10
	// Bit mask of OC3M_3 field.
	TIM_CCMR2_Output_OC3M_3_Msk = 0x10000
	// Bit OC3M_3.
	TIM_CCMR2_Output_OC3M_3 = 0x10000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR2_Output_OC3M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR2_Output_OC3M_3_Extended = 0x1

	// CCMR2_Input: capture/compare mode register 1 (input mode)
	// Position of IC4F field.
	TIM_CCMR2_Input_IC4F_Pos = 0xc
	// Bit mask of IC4F field.
	TIM_CCMR2_Input_IC4F_Msk = 0xf000
	// Position of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Pos = 0xa
	// Bit mask of IC4PSC field.
	TIM_CCMR2_Input_IC4PSC_Msk = 0xc00
	// Position of CC4S field.
	TIM_CCMR2_Input_CC4S_Pos = 0x8
	// Bit mask of CC4S field.
	TIM_CCMR2_Input_CC4S_Msk = 0x300
	// CC4 channel is configured as input, IC4 is mapped on TI4
	TIM_CCMR2_Input_CC4S_TI4 = 0x1
	// CC4 channel is configured as input, IC4 is mapped on TI3
	TIM_CCMR2_Input_CC4S_TI3 = 0x2
	// CC4 channel is configured as input, IC4 is mapped on TRC
	TIM_CCMR2_Input_CC4S_TRC = 0x3
	// Position of IC3F field.
	TIM_CCMR2_Input_IC3F_Pos = 0x4
	// Bit mask of IC3F field.
	TIM_CCMR2_Input_IC3F_Msk = 0xf0
	// Position of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Pos = 0x2
	// Bit mask of IC3PSC field.
	TIM_CCMR2_Input_IC3PSC_Msk = 0xc
	// Position of CC3S field.
	TIM_CCMR2_Input_CC3S_Pos = 0x0
	// Bit mask of CC3S field.
	TIM_CCMR2_Input_CC3S_Msk = 0x3
	// CC3 channel is configured as input, IC3 is mapped on TI3
	TIM_CCMR2_Input_CC3S_TI3 = 0x1
	// CC3 channel is configured as input, IC3 is mapped on TI4
	TIM_CCMR2_Input_CC3S_TI4 = 0x2
	// CC3 channel is configured as input, IC3 is mapped on TRC
	TIM_CCMR2_Input_CC3S_TRC = 0x3

	// CCER: capture/compare enable register
	// Position of CC4P field.
	TIM_CCER_CC4P_Pos = 0xd
	// Bit mask of CC4P field.
	TIM_CCER_CC4P_Msk = 0x2000
	// Bit CC4P.
	TIM_CCER_CC4P = 0x2000
	// Position of CC4E field.
	TIM_CCER_CC4E_Pos = 0xc
	// Bit mask of CC4E field.
	TIM_CCER_CC4E_Msk = 0x1000
	// Bit CC4E.
	TIM_CCER_CC4E = 0x1000
	// Position of CC3NP field.
	TIM_CCER_CC3NP_Pos = 0xb
	// Bit mask of CC3NP field.
	TIM_CCER_CC3NP_Msk = 0x800
	// Bit CC3NP.
	TIM_CCER_CC3NP = 0x800
	// Position of CC3NE field.
	TIM_CCER_CC3NE_Pos = 0xa
	// Bit mask of CC3NE field.
	TIM_CCER_CC3NE_Msk = 0x400
	// Bit CC3NE.
	TIM_CCER_CC3NE = 0x400
	// Position of CC3P field.
	TIM_CCER_CC3P_Pos = 0x9
	// Bit mask of CC3P field.
	TIM_CCER_CC3P_Msk = 0x200
	// Bit CC3P.
	TIM_CCER_CC3P = 0x200
	// Position of CC3E field.
	TIM_CCER_CC3E_Pos = 0x8
	// Bit mask of CC3E field.
	TIM_CCER_CC3E_Msk = 0x100
	// Bit CC3E.
	TIM_CCER_CC3E = 0x100
	// Position of CC2NP field.
	TIM_CCER_CC2NP_Pos = 0x7
	// Bit mask of CC2NP field.
	TIM_CCER_CC2NP_Msk = 0x80
	// Bit CC2NP.
	TIM_CCER_CC2NP = 0x80
	// Position of CC2NE field.
	TIM_CCER_CC2NE_Pos = 0x6
	// Bit mask of CC2NE field.
	TIM_CCER_CC2NE_Msk = 0x40
	// Bit CC2NE.
	TIM_CCER_CC2NE = 0x40
	// Position of CC2P field.
	TIM_CCER_CC2P_Pos = 0x5
	// Bit mask of CC2P field.
	TIM_CCER_CC2P_Msk = 0x20
	// Bit CC2P.
	TIM_CCER_CC2P = 0x20
	// Position of CC2E field.
	TIM_CCER_CC2E_Pos = 0x4
	// Bit mask of CC2E field.
	TIM_CCER_CC2E_Msk = 0x10
	// Bit CC2E.
	TIM_CCER_CC2E = 0x10
	// Position of CC1NP field.
	TIM_CCER_CC1NP_Pos = 0x3
	// Bit mask of CC1NP field.
	TIM_CCER_CC1NP_Msk = 0x8
	// Bit CC1NP.
	TIM_CCER_CC1NP = 0x8
	// Position of CC1NE field.
	TIM_CCER_CC1NE_Pos = 0x2
	// Bit mask of CC1NE field.
	TIM_CCER_CC1NE_Msk = 0x4
	// Bit CC1NE.
	TIM_CCER_CC1NE = 0x4
	// Position of CC1P field.
	TIM_CCER_CC1P_Pos = 0x1
	// Bit mask of CC1P field.
	TIM_CCER_CC1P_Msk = 0x2
	// Bit CC1P.
	TIM_CCER_CC1P = 0x2
	// Position of CC1E field.
	TIM_CCER_CC1E_Pos = 0x0
	// Bit mask of CC1E field.
	TIM_CCER_CC1E_Msk = 0x1
	// Bit CC1E.
	TIM_CCER_CC1E = 0x1
	// Position of CC6P field.
	TIM_CCER_CC6P_Pos = 0x15
	// Bit mask of CC6P field.
	TIM_CCER_CC6P_Msk = 0x200000
	// Bit CC6P.
	TIM_CCER_CC6P = 0x200000
	// Position of CC6E field.
	TIM_CCER_CC6E_Pos = 0x14
	// Bit mask of CC6E field.
	TIM_CCER_CC6E_Msk = 0x100000
	// Bit CC6E.
	TIM_CCER_CC6E = 0x100000
	// Position of CC5P field.
	TIM_CCER_CC5P_Pos = 0x11
	// Bit mask of CC5P field.
	TIM_CCER_CC5P_Msk = 0x20000
	// Bit CC5P.
	TIM_CCER_CC5P = 0x20000
	// Position of CC5E field.
	TIM_CCER_CC5E_Pos = 0x10
	// Bit mask of CC5E field.
	TIM_CCER_CC5E_Msk = 0x10000
	// Bit CC5E.
	TIM_CCER_CC5E = 0x10000
	// Position of CC4NP field.
	TIM_CCER_CC4NP_Pos = 0xf
	// Bit mask of CC4NP field.
	TIM_CCER_CC4NP_Msk = 0x8000
	// Bit CC4NP.
	TIM_CCER_CC4NP = 0x8000

	// CNT: counter
	// Position of CNT field.
	TIM_CNT_CNT_Pos = 0x0
	// Bit mask of CNT field.
	TIM_CNT_CNT_Msk = 0xffff
	// Position of UIFCPY field.
	TIM_CNT_UIFCPY_Pos = 0x1f
	// Bit mask of UIFCPY field.
	TIM_CNT_UIFCPY_Msk = 0x80000000
	// Bit UIFCPY.
	TIM_CNT_UIFCPY = 0x80000000

	// PSC: prescaler
	// Position of PSC field.
	TIM_PSC_PSC_Pos = 0x0
	// Bit mask of PSC field.
	TIM_PSC_PSC_Msk = 0xffff

	// ARR: auto-reload register
	// Position of ARR field.
	TIM_ARR_ARR_Pos = 0x0
	// Bit mask of ARR field.
	TIM_ARR_ARR_Msk = 0xffff

	// RCR: repetition counter register
	// Position of REP field.
	TIM_RCR_REP_Pos = 0x0
	// Bit mask of REP field.
	TIM_RCR_REP_Msk = 0xff

	// CCR1: capture/compare register
	// Position of CCR field.
	TIM_CCR_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIM_CCR_CCR_Msk = 0xffff

	// BDTR: break and dead-time register
	// Position of MOE field.
	TIM_BDTR_MOE_Pos = 0xf
	// Bit mask of MOE field.
	TIM_BDTR_MOE_Msk = 0x8000
	// Bit MOE.
	TIM_BDTR_MOE = 0x8000
	// OC/OCN are disabled or forced idle depending on OSSI
	TIM_BDTR_MOE_DisabledIdle = 0x0
	// OC/OCN are enabled if CCxE/CCxNE are set
	TIM_BDTR_MOE_Enabled = 0x1
	// Position of AOE field.
	TIM_BDTR_AOE_Pos = 0xe
	// Bit mask of AOE field.
	TIM_BDTR_AOE_Msk = 0x4000
	// Bit AOE.
	TIM_BDTR_AOE = 0x4000
	// Position of BKP field.
	TIM_BDTR_BKP_Pos = 0xd
	// Bit mask of BKP field.
	TIM_BDTR_BKP_Msk = 0x2000
	// Bit BKP.
	TIM_BDTR_BKP = 0x2000
	// Position of BKE field.
	TIM_BDTR_BKE_Pos = 0xc
	// Bit mask of BKE field.
	TIM_BDTR_BKE_Msk = 0x1000
	// Bit BKE.
	TIM_BDTR_BKE = 0x1000
	// Position of OSSR field.
	TIM_BDTR_OSSR_Pos = 0xb
	// Bit mask of OSSR field.
	TIM_BDTR_OSSR_Msk = 0x800
	// Bit OSSR.
	TIM_BDTR_OSSR = 0x800
	// When inactive, OC/OCN outputs are disabled
	TIM_BDTR_OSSR_Disabled = 0x0
	// When inactive, OC/OCN outputs are enabled with their inactive level
	TIM_BDTR_OSSR_IdleLevel = 0x1
	// Position of OSSI field.
	TIM_BDTR_OSSI_Pos = 0xa
	// Bit mask of OSSI field.
	TIM_BDTR_OSSI_Msk = 0x400
	// Bit OSSI.
	TIM_BDTR_OSSI = 0x400
	// When inactive, OC/OCN outputs are disabled
	TIM_BDTR_OSSI_Disabled = 0x0
	// When inactive, OC/OCN outputs are forced to idle level
	TIM_BDTR_OSSI_IdleLevel = 0x1
	// Position of LOCK field.
	TIM_BDTR_LOCK_Pos = 0x8
	// Bit mask of LOCK field.
	TIM_BDTR_LOCK_Msk = 0x300
	// Position of DTG field.
	TIM_BDTR_DTG_Pos = 0x0
	// Bit mask of DTG field.
	TIM_BDTR_DTG_Msk = 0xff
	// Position of BK2P field.
	TIM_BDTR_BK2P_Pos = 0x19
	// Bit mask of BK2P field.
	TIM_BDTR_BK2P_Msk = 0x2000000
	// Bit BK2P.
	TIM_BDTR_BK2P = 0x2000000
	// Position of BK2E field.
	TIM_BDTR_BK2E_Pos = 0x18
	// Bit mask of BK2E field.
	TIM_BDTR_BK2E_Msk = 0x1000000
	// Bit BK2E.
	TIM_BDTR_BK2E = 0x1000000
	// Position of BK2F field.
	TIM_BDTR_BK2F_Pos = 0x14
	// Bit mask of BK2F field.
	TIM_BDTR_BK2F_Msk = 0xf00000
	// Position of BKF field.
	TIM_BDTR_BKF_Pos = 0x10
	// Bit mask of BKF field.
	TIM_BDTR_BKF_Msk = 0xf0000

	// DCR: DMA control register
	// Position of DBL field.
	TIM_DCR_DBL_Pos = 0x8
	// Bit mask of DBL field.
	TIM_DCR_DBL_Msk = 0x1f00
	// Position of DBA field.
	TIM_DCR_DBA_Pos = 0x0
	// Bit mask of DBA field.
	TIM_DCR_DBA_Msk = 0x1f

	// DMAR: DMA address for full transfer
	// Position of DMAB field.
	TIM_DMAR_DMAB_Pos = 0x0
	// Bit mask of DMAB field.
	TIM_DMAR_DMAB_Msk = 0xffffffff

	// CCMR3_Output: capture/compare mode register 3 (output mode)
	// Position of OC5FE field.
	TIM_CCMR3_Output_OC5FE_Pos = 0x2
	// Bit mask of OC5FE field.
	TIM_CCMR3_Output_OC5FE_Msk = 0x4
	// Bit OC5FE.
	TIM_CCMR3_Output_OC5FE = 0x4
	// Position of OC5PE field.
	TIM_CCMR3_Output_OC5PE_Pos = 0x3
	// Bit mask of OC5PE field.
	TIM_CCMR3_Output_OC5PE_Msk = 0x8
	// Bit OC5PE.
	TIM_CCMR3_Output_OC5PE = 0x8
	// Position of OC5M field.
	TIM_CCMR3_Output_OC5M_Pos = 0x4
	// Bit mask of OC5M field.
	TIM_CCMR3_Output_OC5M_Msk = 0x70
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR3_Output_OC5M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR3_Output_OC5M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR3_Output_OC5M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR3_Output_OC5M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR3_Output_OC5M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR3_Output_OC5M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR3_Output_OC5M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR3_Output_OC5M_PwmMode2 = 0x7
	// Position of OC5CE field.
	TIM_CCMR3_Output_OC5CE_Pos = 0x7
	// Bit mask of OC5CE field.
	TIM_CCMR3_Output_OC5CE_Msk = 0x80
	// Bit OC5CE.
	TIM_CCMR3_Output_OC5CE = 0x80
	// Position of OC6FE field.
	TIM_CCMR3_Output_OC6FE_Pos = 0xa
	// Bit mask of OC6FE field.
	TIM_CCMR3_Output_OC6FE_Msk = 0x400
	// Bit OC6FE.
	TIM_CCMR3_Output_OC6FE = 0x400
	// Position of OC6PE field.
	TIM_CCMR3_Output_OC6PE_Pos = 0xb
	// Bit mask of OC6PE field.
	TIM_CCMR3_Output_OC6PE_Msk = 0x800
	// Bit OC6PE.
	TIM_CCMR3_Output_OC6PE = 0x800
	// Position of OC6M field.
	TIM_CCMR3_Output_OC6M_Pos = 0xc
	// Bit mask of OC6M field.
	TIM_CCMR3_Output_OC6M_Msk = 0x7000
	// The comparison between the output compare register TIMx_CCRy and the counter TIMx_CNT has no effect on the outputs / OpmMode1: Retriggerable OPM mode 1 - In up-counting mode, the channel is active until a trigger event is detected (on TRGI signal). In down-counting mode, the channel is inactive
	TIM_CCMR3_Output_OC6M_Frozen = 0x0
	// Set channel to active level on match. OCyREF signal is forced high when the counter matches the capture/compare register / OpmMode2: Inversely to OpmMode1
	TIM_CCMR3_Output_OC6M_ActiveOnMatch = 0x1
	// Set channel to inactive level on match. OCyREF signal is forced low when the counter matches the capture/compare register / Reserved
	TIM_CCMR3_Output_OC6M_InactiveOnMatch = 0x2
	// OCyREF toggles when TIMx_CNT=TIMx_CCRy / Reserved
	TIM_CCMR3_Output_OC6M_Toggle = 0x3
	// OCyREF is forced low / CombinedPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC is the logical OR between OC1REF and OC2REF
	TIM_CCMR3_Output_OC6M_ForceInactive = 0x4
	// OCyREF is forced high / CombinedPwmMode2: OCyREF has the same behavior as in PWM mode 2. OCyREFC is the logical AND between OC1REF and OC2REF
	TIM_CCMR3_Output_OC6M_ForceActive = 0x5
	// In upcounting, channel is active as long as TIMx_CNT<TIMx_CCRy else inactive. In downcounting, channel is inactive as long as TIMx_CNT>TIMx_CCRy else active / AsymmetricPwmMode1: OCyREF has the same behavior as in PWM mode 1. OCyREFC outputs OC1REF when the counter is counting up, OC2REF when it is counting down
	TIM_CCMR3_Output_OC6M_PwmMode1 = 0x6
	// Inversely to PwmMode1 / AsymmetricPwmMode2: Inversely to AsymmetricPwmMode1
	TIM_CCMR3_Output_OC6M_PwmMode2 = 0x7
	// Position of OC6CE field.
	TIM_CCMR3_Output_OC6CE_Pos = 0xf
	// Bit mask of OC6CE field.
	TIM_CCMR3_Output_OC6CE_Msk = 0x8000
	// Bit OC6CE.
	TIM_CCMR3_Output_OC6CE = 0x8000
	// Position of OC5M_3 field.
	TIM_CCMR3_Output_OC5M_3_Pos = 0x10
	// Bit mask of OC5M_3 field.
	TIM_CCMR3_Output_OC5M_3_Msk = 0x10000
	// Bit OC5M_3.
	TIM_CCMR3_Output_OC5M_3 = 0x10000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR3_Output_OC5M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR3_Output_OC5M_3_Extended = 0x1
	// Position of OC6M_3 field.
	TIM_CCMR3_Output_OC6M_3_Pos = 0x18
	// Bit mask of OC6M_3 field.
	TIM_CCMR3_Output_OC6M_3_Msk = 0x1000000
	// Bit OC6M_3.
	TIM_CCMR3_Output_OC6M_3 = 0x1000000
	// Normal output compare mode (modes 0-7)
	TIM_CCMR3_Output_OC6M_3_Normal = 0x0
	// Extended output compare mode (modes 7-15)
	TIM_CCMR3_Output_OC6M_3_Extended = 0x1

	// CCR5: capture/compare register
	// Position of CCR field.
	TIM_CCR5_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIM_CCR5_CCR_Msk = 0xffff
	// Position of GC5C1 field.
	TIM_CCR5_GC5C1_Pos = 0x1d
	// Bit mask of GC5C1 field.
	TIM_CCR5_GC5C1_Msk = 0x20000000
	// Bit GC5C1.
	TIM_CCR5_GC5C1 = 0x20000000
	// Position of GC5C2 field.
	TIM_CCR5_GC5C2_Pos = 0x1e
	// Bit mask of GC5C2 field.
	TIM_CCR5_GC5C2_Msk = 0x40000000
	// Bit GC5C2.
	TIM_CCR5_GC5C2 = 0x40000000
	// Position of GC5C3 field.
	TIM_CCR5_GC5C3_Pos = 0x1f
	// Bit mask of GC5C3 field.
	TIM_CCR5_GC5C3_Msk = 0x80000000
	// Bit GC5C3.
	TIM_CCR5_GC5C3 = 0x80000000

	// CCR6: capture/compare register
	// Position of CCR field.
	TIM_CCR6_CCR_Pos = 0x0
	// Bit mask of CCR field.
	TIM_CCR6_CCR_Msk = 0xffff
)

// Constants for ADC2: Analog-to-digital converter
const (
	// SR: status register
	// Position of OVR field.
	ADC_SR_OVR_Pos = 0x5
	// Bit mask of OVR field.
	ADC_SR_OVR_Msk = 0x20
	// Bit OVR.
	ADC_SR_OVR = 0x20
	// No overrun occurred
	ADC_SR_OVR_NoOverrun = 0x0
	// Overrun occurred
	ADC_SR_OVR_Overrun = 0x1
	// Position of STRT field.
	ADC_SR_STRT_Pos = 0x4
	// Bit mask of STRT field.
	ADC_SR_STRT_Msk = 0x10
	// Bit STRT.
	ADC_SR_STRT = 0x10
	// No regular channel conversion started
	ADC_SR_STRT_NotStarted = 0x0
	// Regular channel conversion has started
	ADC_SR_STRT_Started = 0x1
	// Position of JSTRT field.
	ADC_SR_JSTRT_Pos = 0x3
	// Bit mask of JSTRT field.
	ADC_SR_JSTRT_Msk = 0x8
	// Bit JSTRT.
	ADC_SR_JSTRT = 0x8
	// No injected channel conversion started
	ADC_SR_JSTRT_NotStarted = 0x0
	// Injected channel conversion has started
	ADC_SR_JSTRT_Started = 0x1
	// Position of JEOC field.
	ADC_SR_JEOC_Pos = 0x2
	// Bit mask of JEOC field.
	ADC_SR_JEOC_Msk = 0x4
	// Bit JEOC.
	ADC_SR_JEOC = 0x4
	// Conversion is not complete
	ADC_SR_JEOC_NotComplete = 0x0
	// Conversion complete
	ADC_SR_JEOC_Complete = 0x1
	// Position of EOC field.
	ADC_SR_EOC_Pos = 0x1
	// Bit mask of EOC field.
	ADC_SR_EOC_Msk = 0x2
	// Bit EOC.
	ADC_SR_EOC = 0x2
	// Conversion is not complete
	ADC_SR_EOC_NotComplete = 0x0
	// Conversion complete
	ADC_SR_EOC_Complete = 0x1
	// Position of AWD field.
	ADC_SR_AWD_Pos = 0x0
	// Bit mask of AWD field.
	ADC_SR_AWD_Msk = 0x1
	// Bit AWD.
	ADC_SR_AWD = 0x1
	// No analog watchdog event occurred
	ADC_SR_AWD_NoEvent = 0x0
	// Analog watchdog event occurred
	ADC_SR_AWD_Event = 0x1

	// CR1: control register 1
	// Position of OVRIE field.
	ADC_CR1_OVRIE_Pos = 0x1a
	// Bit mask of OVRIE field.
	ADC_CR1_OVRIE_Msk = 0x4000000
	// Bit OVRIE.
	ADC_CR1_OVRIE = 0x4000000
	// Overrun interrupt disabled
	ADC_CR1_OVRIE_Disabled = 0x0
	// Overrun interrupt enabled
	ADC_CR1_OVRIE_Enabled = 0x1
	// Position of RES field.
	ADC_CR1_RES_Pos = 0x18
	// Bit mask of RES field.
	ADC_CR1_RES_Msk = 0x3000000
	// 12-bit (15 ADCCLK cycles)
	ADC_CR1_RES_TwelveBit = 0x0
	// 10-bit (13 ADCCLK cycles)
	ADC_CR1_RES_TenBit = 0x1
	// 8-bit (11 ADCCLK cycles)
	ADC_CR1_RES_EightBit = 0x2
	// 6-bit (9 ADCCLK cycles)
	ADC_CR1_RES_SixBit = 0x3
	// Position of AWDEN field.
	ADC_CR1_AWDEN_Pos = 0x17
	// Bit mask of AWDEN field.
	ADC_CR1_AWDEN_Msk = 0x800000
	// Bit AWDEN.
	ADC_CR1_AWDEN = 0x800000
	// Analog watchdog disabled on regular channels
	ADC_CR1_AWDEN_Disabled = 0x0
	// Analog watchdog enabled on regular channels
	ADC_CR1_AWDEN_Enabled = 0x1
	// Position of JAWDEN field.
	ADC_CR1_JAWDEN_Pos = 0x16
	// Bit mask of JAWDEN field.
	ADC_CR1_JAWDEN_Msk = 0x400000
	// Bit JAWDEN.
	ADC_CR1_JAWDEN = 0x400000
	// Analog watchdog disabled on injected channels
	ADC_CR1_JAWDEN_Disabled = 0x0
	// Analog watchdog enabled on injected channels
	ADC_CR1_JAWDEN_Enabled = 0x1
	// Position of DISCNUM field.
	ADC_CR1_DISCNUM_Pos = 0xd
	// Bit mask of DISCNUM field.
	ADC_CR1_DISCNUM_Msk = 0xe000
	// Position of JDISCEN field.
	ADC_CR1_JDISCEN_Pos = 0xc
	// Bit mask of JDISCEN field.
	ADC_CR1_JDISCEN_Msk = 0x1000
	// Bit JDISCEN.
	ADC_CR1_JDISCEN = 0x1000
	// Discontinuous mode on injected channels disabled
	ADC_CR1_JDISCEN_Disabled = 0x0
	// Discontinuous mode on injected channels enabled
	ADC_CR1_JDISCEN_Enabled = 0x1
	// Position of DISCEN field.
	ADC_CR1_DISCEN_Pos = 0xb
	// Bit mask of DISCEN field.
	ADC_CR1_DISCEN_Msk = 0x800
	// Bit DISCEN.
	ADC_CR1_DISCEN = 0x800
	// Discontinuous mode on regular channels disabled
	ADC_CR1_DISCEN_Disabled = 0x0
	// Discontinuous mode on regular channels enabled
	ADC_CR1_DISCEN_Enabled = 0x1
	// Position of JAUTO field.
	ADC_CR1_JAUTO_Pos = 0xa
	// Bit mask of JAUTO field.
	ADC_CR1_JAUTO_Msk = 0x400
	// Bit JAUTO.
	ADC_CR1_JAUTO = 0x400
	// Automatic injected group conversion disabled
	ADC_CR1_JAUTO_Disabled = 0x0
	// Automatic injected group conversion enabled
	ADC_CR1_JAUTO_Enabled = 0x1
	// Position of AWDSGL field.
	ADC_CR1_AWDSGL_Pos = 0x9
	// Bit mask of AWDSGL field.
	ADC_CR1_AWDSGL_Msk = 0x200
	// Bit AWDSGL.
	ADC_CR1_AWDSGL = 0x200
	// Analog watchdog enabled on all channels
	ADC_CR1_AWDSGL_AllChannels = 0x0
	// Analog watchdog enabled on a single channel
	ADC_CR1_AWDSGL_SingleChannel = 0x1
	// Position of SCAN field.
	ADC_CR1_SCAN_Pos = 0x8
	// Bit mask of SCAN field.
	ADC_CR1_SCAN_Msk = 0x100
	// Bit SCAN.
	ADC_CR1_SCAN = 0x100
	// Scan mode disabled
	ADC_CR1_SCAN_Disabled = 0x0
	// Scan mode enabled
	ADC_CR1_SCAN_Enabled = 0x1
	// Position of JEOCIE field.
	ADC_CR1_JEOCIE_Pos = 0x7
	// Bit mask of JEOCIE field.
	ADC_CR1_JEOCIE_Msk = 0x80
	// Bit JEOCIE.
	ADC_CR1_JEOCIE = 0x80
	// JEOC interrupt disabled
	ADC_CR1_JEOCIE_Disabled = 0x0
	// JEOC interrupt enabled
	ADC_CR1_JEOCIE_Enabled = 0x1
	// Position of AWDIE field.
	ADC_CR1_AWDIE_Pos = 0x6
	// Bit mask of AWDIE field.
	ADC_CR1_AWDIE_Msk = 0x40
	// Bit AWDIE.
	ADC_CR1_AWDIE = 0x40
	// Analogue watchdog interrupt disabled
	ADC_CR1_AWDIE_Disabled = 0x0
	// Analogue watchdog interrupt enabled
	ADC_CR1_AWDIE_Enabled = 0x1
	// Position of EOCIE field.
	ADC_CR1_EOCIE_Pos = 0x5
	// Bit mask of EOCIE field.
	ADC_CR1_EOCIE_Msk = 0x20
	// Bit EOCIE.
	ADC_CR1_EOCIE = 0x20
	// EOC interrupt disabled
	ADC_CR1_EOCIE_Disabled = 0x0
	// EOC interrupt enabled
	ADC_CR1_EOCIE_Enabled = 0x1
	// Position of AWDCH field.
	ADC_CR1_AWDCH_Pos = 0x0
	// Bit mask of AWDCH field.
	ADC_CR1_AWDCH_Msk = 0x1f

	// CR2: control register 2
	// Position of SWSTART field.
	ADC_CR2_SWSTART_Pos = 0x1e
	// Bit mask of SWSTART field.
	ADC_CR2_SWSTART_Msk = 0x40000000
	// Bit SWSTART.
	ADC_CR2_SWSTART = 0x40000000
	// Starts conversion of regular channels
	ADC_CR2_SWSTART_Start = 0x1
	// Position of EXTEN field.
	ADC_CR2_EXTEN_Pos = 0x1c
	// Bit mask of EXTEN field.
	ADC_CR2_EXTEN_Msk = 0x30000000
	// Trigger detection disabled
	ADC_CR2_EXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_CR2_EXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_CR2_EXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_CR2_EXTEN_BothEdges = 0x3
	// Position of EXTSEL field.
	ADC_CR2_EXTSEL_Pos = 0x18
	// Bit mask of EXTSEL field.
	ADC_CR2_EXTSEL_Msk = 0xf000000
	// Timer 1 CC1 event
	ADC_CR2_EXTSEL_TIM1CC1 = 0x0
	// Timer 1 CC2 event
	ADC_CR2_EXTSEL_TIM1CC2 = 0x1
	// Timer 1 CC3 event
	ADC_CR2_EXTSEL_TIM1CC3 = 0x2
	// Timer 2 CC2 event
	ADC_CR2_EXTSEL_TIM2CC2 = 0x3
	// Timer 2 CC3 event
	ADC_CR2_EXTSEL_TIM2CC3 = 0x4
	// Timer 2 CC4 event
	ADC_CR2_EXTSEL_TIM2CC4 = 0x5
	// Timer 2 TRGO event
	ADC_CR2_EXTSEL_TIM2TRGO = 0x6
	// Position of JSWSTART field.
	ADC_CR2_JSWSTART_Pos = 0x16
	// Bit mask of JSWSTART field.
	ADC_CR2_JSWSTART_Msk = 0x400000
	// Bit JSWSTART.
	ADC_CR2_JSWSTART = 0x400000
	// Starts conversion of injected channels
	ADC_CR2_JSWSTART_Start = 0x1
	// Position of JEXTEN field.
	ADC_CR2_JEXTEN_Pos = 0x14
	// Bit mask of JEXTEN field.
	ADC_CR2_JEXTEN_Msk = 0x300000
	// Trigger detection disabled
	ADC_CR2_JEXTEN_Disabled = 0x0
	// Trigger detection on the rising edge
	ADC_CR2_JEXTEN_RisingEdge = 0x1
	// Trigger detection on the falling edge
	ADC_CR2_JEXTEN_FallingEdge = 0x2
	// Trigger detection on both the rising and falling edges
	ADC_CR2_JEXTEN_BothEdges = 0x3
	// Position of JEXTSEL field.
	ADC_CR2_JEXTSEL_Pos = 0x10
	// Bit mask of JEXTSEL field.
	ADC_CR2_JEXTSEL_Msk = 0xf0000
	// Timer 1 TRGO event
	ADC_CR2_JEXTSEL_TIM1TRGO = 0x0
	// Timer 1 CC4 event
	ADC_CR2_JEXTSEL_TIM1CC4 = 0x1
	// Timer 2 TRGO event
	ADC_CR2_JEXTSEL_TIM2TRGO = 0x2
	// Timer 2 CC1 event
	ADC_CR2_JEXTSEL_TIM2CC1 = 0x3
	// Timer 3 CC4 event
	ADC_CR2_JEXTSEL_TIM3CC4 = 0x4
	// Timer 4 TRGO event
	ADC_CR2_JEXTSEL_TIM4TRGO = 0x5
	// Timer 8 CC4 event
	ADC_CR2_JEXTSEL_TIM8CC4 = 0x7
	// Timer 1 TRGO(2) event
	ADC_CR2_JEXTSEL_TIM1TRGO2 = 0x8
	// Timer 8 TRGO event
	ADC_CR2_JEXTSEL_TIM8TRGO = 0x9
	// Timer 8 TRGO(2) event
	ADC_CR2_JEXTSEL_TIM8TRGO2 = 0xa
	// Timer 3 CC3 event
	ADC_CR2_JEXTSEL_TIM3CC3 = 0xb
	// Timer 5 TRGO event
	ADC_CR2_JEXTSEL_TIM5TRGO = 0xc
	// Timer 3 CC1 event
	ADC_CR2_JEXTSEL_TIM3CC1 = 0xd
	// Timer 6 TRGO event
	ADC_CR2_JEXTSEL_TIM6TRGO = 0xe
	// Position of ALIGN field.
	ADC_CR2_ALIGN_Pos = 0xb
	// Bit mask of ALIGN field.
	ADC_CR2_ALIGN_Msk = 0x800
	// Bit ALIGN.
	ADC_CR2_ALIGN = 0x800
	// Right alignment
	ADC_CR2_ALIGN_Right = 0x0
	// Left alignment
	ADC_CR2_ALIGN_Left = 0x1
	// Position of EOCS field.
	ADC_CR2_EOCS_Pos = 0xa
	// Bit mask of EOCS field.
	ADC_CR2_EOCS_Msk = 0x400
	// Bit EOCS.
	ADC_CR2_EOCS = 0x400
	// The EOC bit is set at the end of each sequence of regular conversions
	ADC_CR2_EOCS_EachSequence = 0x0
	// The EOC bit is set at the end of each regular conversion
	ADC_CR2_EOCS_EachConversion = 0x1
	// Position of DDS field.
	ADC_CR2_DDS_Pos = 0x9
	// Bit mask of DDS field.
	ADC_CR2_DDS_Msk = 0x200
	// Bit DDS.
	ADC_CR2_DDS = 0x200
	// No new DMA request is issued after the last transfer
	ADC_CR2_DDS_Single = 0x0
	// DMA requests are issued as long as data are converted and DMA=1
	ADC_CR2_DDS_Continuous = 0x1
	// Position of DMA field.
	ADC_CR2_DMA_Pos = 0x8
	// Bit mask of DMA field.
	ADC_CR2_DMA_Msk = 0x100
	// Bit DMA.
	ADC_CR2_DMA = 0x100
	// DMA mode disabled
	ADC_CR2_DMA_Disabled = 0x0
	// DMA mode enabled
	ADC_CR2_DMA_Enabled = 0x1
	// Position of CONT field.
	ADC_CR2_CONT_Pos = 0x1
	// Bit mask of CONT field.
	ADC_CR2_CONT_Msk = 0x2
	// Bit CONT.
	ADC_CR2_CONT = 0x2
	// Single conversion mode
	ADC_CR2_CONT_Single = 0x0
	// Continuous conversion mode
	ADC_CR2_CONT_Continuous = 0x1
	// Position of ADON field.
	ADC_CR2_ADON_Pos = 0x0
	// Bit mask of ADON field.
	ADC_CR2_ADON_Msk = 0x1
	// Bit ADON.
	ADC_CR2_ADON = 0x1
	// Disable ADC conversion and go to power down mode
	ADC_CR2_ADON_Disabled = 0x0
	// Enable ADC
	ADC_CR2_ADON_Enabled = 0x1

	// SMPR1: sample time register 1
	// Position of SMP18 field.
	ADC_SMPR1_SMP18_Pos = 0x18
	// Bit mask of SMP18 field.
	ADC_SMPR1_SMP18_Msk = 0x7000000
	// 3 cycles
	ADC_SMPR1_SMP18_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP18_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP18_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP18_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP18_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP18_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP18_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP18_Cycles480 = 0x7
	// Position of SMP17 field.
	ADC_SMPR1_SMP17_Pos = 0x15
	// Bit mask of SMP17 field.
	ADC_SMPR1_SMP17_Msk = 0xe00000
	// 3 cycles
	ADC_SMPR1_SMP17_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP17_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP17_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP17_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP17_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP17_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP17_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP17_Cycles480 = 0x7
	// Position of SMP16 field.
	ADC_SMPR1_SMP16_Pos = 0x12
	// Bit mask of SMP16 field.
	ADC_SMPR1_SMP16_Msk = 0x1c0000
	// 3 cycles
	ADC_SMPR1_SMP16_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP16_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP16_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP16_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP16_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP16_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP16_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP16_Cycles480 = 0x7
	// Position of SMP15 field.
	ADC_SMPR1_SMP15_Pos = 0xf
	// Bit mask of SMP15 field.
	ADC_SMPR1_SMP15_Msk = 0x38000
	// 3 cycles
	ADC_SMPR1_SMP15_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP15_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP15_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP15_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP15_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP15_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP15_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP15_Cycles480 = 0x7
	// Position of SMP14 field.
	ADC_SMPR1_SMP14_Pos = 0xc
	// Bit mask of SMP14 field.
	ADC_SMPR1_SMP14_Msk = 0x7000
	// 3 cycles
	ADC_SMPR1_SMP14_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP14_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP14_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP14_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP14_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP14_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP14_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP14_Cycles480 = 0x7
	// Position of SMP13 field.
	ADC_SMPR1_SMP13_Pos = 0x9
	// Bit mask of SMP13 field.
	ADC_SMPR1_SMP13_Msk = 0xe00
	// 3 cycles
	ADC_SMPR1_SMP13_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP13_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP13_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP13_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP13_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP13_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP13_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP13_Cycles480 = 0x7
	// Position of SMP12 field.
	ADC_SMPR1_SMP12_Pos = 0x6
	// Bit mask of SMP12 field.
	ADC_SMPR1_SMP12_Msk = 0x1c0
	// 3 cycles
	ADC_SMPR1_SMP12_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP12_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP12_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP12_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP12_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP12_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP12_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP12_Cycles480 = 0x7
	// Position of SMP11 field.
	ADC_SMPR1_SMP11_Pos = 0x3
	// Bit mask of SMP11 field.
	ADC_SMPR1_SMP11_Msk = 0x38
	// 3 cycles
	ADC_SMPR1_SMP11_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP11_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP11_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP11_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP11_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP11_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP11_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP11_Cycles480 = 0x7
	// Position of SMP10 field.
	ADC_SMPR1_SMP10_Pos = 0x0
	// Bit mask of SMP10 field.
	ADC_SMPR1_SMP10_Msk = 0x7
	// 3 cycles
	ADC_SMPR1_SMP10_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR1_SMP10_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR1_SMP10_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR1_SMP10_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR1_SMP10_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR1_SMP10_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR1_SMP10_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR1_SMP10_Cycles480 = 0x7

	// SMPR2: sample time register 2
	// Position of SMP9 field.
	ADC_SMPR2_SMP9_Pos = 0x1b
	// Bit mask of SMP9 field.
	ADC_SMPR2_SMP9_Msk = 0x38000000
	// 3 cycles
	ADC_SMPR2_SMP9_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP9_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP9_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP9_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP9_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP9_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP9_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP9_Cycles480 = 0x7
	// Position of SMP8 field.
	ADC_SMPR2_SMP8_Pos = 0x18
	// Bit mask of SMP8 field.
	ADC_SMPR2_SMP8_Msk = 0x7000000
	// 3 cycles
	ADC_SMPR2_SMP8_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP8_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP8_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP8_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP8_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP8_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP8_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP8_Cycles480 = 0x7
	// Position of SMP7 field.
	ADC_SMPR2_SMP7_Pos = 0x15
	// Bit mask of SMP7 field.
	ADC_SMPR2_SMP7_Msk = 0xe00000
	// 3 cycles
	ADC_SMPR2_SMP7_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP7_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP7_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP7_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP7_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP7_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP7_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP7_Cycles480 = 0x7
	// Position of SMP6 field.
	ADC_SMPR2_SMP6_Pos = 0x12
	// Bit mask of SMP6 field.
	ADC_SMPR2_SMP6_Msk = 0x1c0000
	// 3 cycles
	ADC_SMPR2_SMP6_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP6_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP6_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP6_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP6_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP6_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP6_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP6_Cycles480 = 0x7
	// Position of SMP5 field.
	ADC_SMPR2_SMP5_Pos = 0xf
	// Bit mask of SMP5 field.
	ADC_SMPR2_SMP5_Msk = 0x38000
	// 3 cycles
	ADC_SMPR2_SMP5_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP5_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP5_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP5_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP5_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP5_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP5_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP5_Cycles480 = 0x7
	// Position of SMP4 field.
	ADC_SMPR2_SMP4_Pos = 0xc
	// Bit mask of SMP4 field.
	ADC_SMPR2_SMP4_Msk = 0x7000
	// 3 cycles
	ADC_SMPR2_SMP4_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP4_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP4_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP4_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP4_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP4_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP4_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP4_Cycles480 = 0x7
	// Position of SMP3 field.
	ADC_SMPR2_SMP3_Pos = 0x9
	// Bit mask of SMP3 field.
	ADC_SMPR2_SMP3_Msk = 0xe00
	// 3 cycles
	ADC_SMPR2_SMP3_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP3_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP3_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP3_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP3_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP3_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP3_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP3_Cycles480 = 0x7
	// Position of SMP2 field.
	ADC_SMPR2_SMP2_Pos = 0x6
	// Bit mask of SMP2 field.
	ADC_SMPR2_SMP2_Msk = 0x1c0
	// 3 cycles
	ADC_SMPR2_SMP2_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP2_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP2_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP2_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP2_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP2_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP2_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP2_Cycles480 = 0x7
	// Position of SMP1 field.
	ADC_SMPR2_SMP1_Pos = 0x3
	// Bit mask of SMP1 field.
	ADC_SMPR2_SMP1_Msk = 0x38
	// 3 cycles
	ADC_SMPR2_SMP1_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP1_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP1_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP1_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP1_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP1_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP1_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP1_Cycles480 = 0x7
	// Position of SMP0 field.
	ADC_SMPR2_SMP0_Pos = 0x0
	// Bit mask of SMP0 field.
	ADC_SMPR2_SMP0_Msk = 0x7
	// 3 cycles
	ADC_SMPR2_SMP0_Cycles3 = 0x0
	// 15 cycles
	ADC_SMPR2_SMP0_Cycles15 = 0x1
	// 28 cycles
	ADC_SMPR2_SMP0_Cycles28 = 0x2
	// 56 cycles
	ADC_SMPR2_SMP0_Cycles56 = 0x3
	// 84 cycles
	ADC_SMPR2_SMP0_Cycles84 = 0x4
	// 112 cycles
	ADC_SMPR2_SMP0_Cycles112 = 0x5
	// 144 cycles
	ADC_SMPR2_SMP0_Cycles144 = 0x6
	// 480 cycles
	ADC_SMPR2_SMP0_Cycles480 = 0x7

	// JOFR1: injected channel data offset register x
	// Position of JOFFSET field.
	ADC_JOFR_JOFFSET_Pos = 0x0
	// Bit mask of JOFFSET field.
	ADC_JOFR_JOFFSET_Msk = 0xfff

	// HTR: watchdog higher threshold register
	// Position of HT field.
	ADC_HTR_HT_Pos = 0x0
	// Bit mask of HT field.
	ADC_HTR_HT_Msk = 0xfff

	// LTR: watchdog lower threshold register
	// Position of LT field.
	ADC_LTR_LT_Pos = 0x0
	// Bit mask of LT field.
	ADC_LTR_LT_Msk = 0xfff

	// SQR1: regular sequence register 1
	// Position of L field.
	ADC_SQR1_L_Pos = 0x14
	// Bit mask of L field.
	ADC_SQR1_L_Msk = 0xf00000
	// Position of SQ16 field.
	ADC_SQR1_SQ16_Pos = 0xf
	// Bit mask of SQ16 field.
	ADC_SQR1_SQ16_Msk = 0xf8000
	// Position of SQ15 field.
	ADC_SQR1_SQ15_Pos = 0xa
	// Bit mask of SQ15 field.
	ADC_SQR1_SQ15_Msk = 0x7c00
	// Position of SQ14 field.
	ADC_SQR1_SQ14_Pos = 0x5
	// Bit mask of SQ14 field.
	ADC_SQR1_SQ14_Msk = 0x3e0
	// Position of SQ13 field.
	ADC_SQR1_SQ13_Pos = 0x0
	// Bit mask of SQ13 field.
	ADC_SQR1_SQ13_Msk = 0x1f

	// SQR2: regular sequence register 2
	// Position of SQ12 field.
	ADC_SQR2_SQ12_Pos = 0x19
	// Bit mask of SQ12 field.
	ADC_SQR2_SQ12_Msk = 0x3e000000
	// Position of SQ11 field.
	ADC_SQR2_SQ11_Pos = 0x14
	// Bit mask of SQ11 field.
	ADC_SQR2_SQ11_Msk = 0x1f00000
	// Position of SQ10 field.
	ADC_SQR2_SQ10_Pos = 0xf
	// Bit mask of SQ10 field.
	ADC_SQR2_SQ10_Msk = 0xf8000
	// Position of SQ9 field.
	ADC_SQR2_SQ9_Pos = 0xa
	// Bit mask of SQ9 field.
	ADC_SQR2_SQ9_Msk = 0x7c00
	// Position of SQ8 field.
	ADC_SQR2_SQ8_Pos = 0x5
	// Bit mask of SQ8 field.
	ADC_SQR2_SQ8_Msk = 0x3e0
	// Position of SQ7 field.
	ADC_SQR2_SQ7_Pos = 0x0
	// Bit mask of SQ7 field.
	ADC_SQR2_SQ7_Msk = 0x1f

	// SQR3: regular sequence register 3
	// Position of SQ6 field.
	ADC_SQR3_SQ6_Pos = 0x19
	// Bit mask of SQ6 field.
	ADC_SQR3_SQ6_Msk = 0x3e000000
	// Position of SQ5 field.
	ADC_SQR3_SQ5_Pos = 0x14
	// Bit mask of SQ5 field.
	ADC_SQR3_SQ5_Msk = 0x1f00000
	// Position of SQ4 field.
	ADC_SQR3_SQ4_Pos = 0xf
	// Bit mask of SQ4 field.
	ADC_SQR3_SQ4_Msk = 0xf8000
	// Position of SQ3 field.
	ADC_SQR3_SQ3_Pos = 0xa
	// Bit mask of SQ3 field.
	ADC_SQR3_SQ3_Msk = 0x7c00
	// Position of SQ2 field.
	ADC_SQR3_SQ2_Pos = 0x5
	// Bit mask of SQ2 field.
	ADC_SQR3_SQ2_Msk = 0x3e0
	// Position of SQ1 field.
	ADC_SQR3_SQ1_Pos = 0x0
	// Bit mask of SQ1 field.
	ADC_SQR3_SQ1_Msk = 0x1f

	// JSQR: injected sequence register
	// Position of JL field.
	ADC_JSQR_JL_Pos = 0x14
	// Bit mask of JL field.
	ADC_JSQR_JL_Msk = 0x300000
	// Position of JSQ4 field.
	ADC_JSQR_JSQ4_Pos = 0xf
	// Bit mask of JSQ4 field.
	ADC_JSQR_JSQ4_Msk = 0xf8000
	// Position of JSQ3 field.
	ADC_JSQR_JSQ3_Pos = 0xa
	// Bit mask of JSQ3 field.
	ADC_JSQR_JSQ3_Msk = 0x7c00
	// Position of JSQ2 field.
	ADC_JSQR_JSQ2_Pos = 0x5
	// Bit mask of JSQ2 field.
	ADC_JSQR_JSQ2_Msk = 0x3e0
	// Position of JSQ1 field.
	ADC_JSQR_JSQ1_Pos = 0x0
	// Bit mask of JSQ1 field.
	ADC_JSQR_JSQ1_Msk = 0x1f

	// JDR1: injected data register x
	// Position of JDATA field.
	ADC_JDR_JDATA_Pos = 0x0
	// Bit mask of JDATA field.
	ADC_JDR_JDATA_Msk = 0xffff

	// DR: regular data register
	// Position of DATA field.
	ADC_DR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_DR_DATA_Msk = 0xffff
)

// Constants for CAN1: Controller area network
const (
	// MCR: master control register
	// Position of DBF field.
	CAN_MCR_DBF_Pos = 0x10
	// Bit mask of DBF field.
	CAN_MCR_DBF_Msk = 0x10000
	// Bit DBF.
	CAN_MCR_DBF = 0x10000
	// Position of RESET field.
	CAN_MCR_RESET_Pos = 0xf
	// Bit mask of RESET field.
	CAN_MCR_RESET_Msk = 0x8000
	// Bit RESET.
	CAN_MCR_RESET = 0x8000
	// Position of TTCM field.
	CAN_MCR_TTCM_Pos = 0x7
	// Bit mask of TTCM field.
	CAN_MCR_TTCM_Msk = 0x80
	// Bit TTCM.
	CAN_MCR_TTCM = 0x80
	// Position of ABOM field.
	CAN_MCR_ABOM_Pos = 0x6
	// Bit mask of ABOM field.
	CAN_MCR_ABOM_Msk = 0x40
	// Bit ABOM.
	CAN_MCR_ABOM = 0x40
	// Position of AWUM field.
	CAN_MCR_AWUM_Pos = 0x5
	// Bit mask of AWUM field.
	CAN_MCR_AWUM_Msk = 0x20
	// Bit AWUM.
	CAN_MCR_AWUM = 0x20
	// Position of NART field.
	CAN_MCR_NART_Pos = 0x4
	// Bit mask of NART field.
	CAN_MCR_NART_Msk = 0x10
	// Bit NART.
	CAN_MCR_NART = 0x10
	// Position of RFLM field.
	CAN_MCR_RFLM_Pos = 0x3
	// Bit mask of RFLM field.
	CAN_MCR_RFLM_Msk = 0x8
	// Bit RFLM.
	CAN_MCR_RFLM = 0x8
	// Position of TXFP field.
	CAN_MCR_TXFP_Pos = 0x2
	// Bit mask of TXFP field.
	CAN_MCR_TXFP_Msk = 0x4
	// Bit TXFP.
	CAN_MCR_TXFP = 0x4
	// Position of SLEEP field.
	CAN_MCR_SLEEP_Pos = 0x1
	// Bit mask of SLEEP field.
	CAN_MCR_SLEEP_Msk = 0x2
	// Bit SLEEP.
	CAN_MCR_SLEEP = 0x2
	// Position of INRQ field.
	CAN_MCR_INRQ_Pos = 0x0
	// Bit mask of INRQ field.
	CAN_MCR_INRQ_Msk = 0x1
	// Bit INRQ.
	CAN_MCR_INRQ = 0x1

	// MSR: master status register
	// Position of RX field.
	CAN_MSR_RX_Pos = 0xb
	// Bit mask of RX field.
	CAN_MSR_RX_Msk = 0x800
	// Bit RX.
	CAN_MSR_RX = 0x800
	// Position of SAMP field.
	CAN_MSR_SAMP_Pos = 0xa
	// Bit mask of SAMP field.
	CAN_MSR_SAMP_Msk = 0x400
	// Bit SAMP.
	CAN_MSR_SAMP = 0x400
	// Position of RXM field.
	CAN_MSR_RXM_Pos = 0x9
	// Bit mask of RXM field.
	CAN_MSR_RXM_Msk = 0x200
	// Bit RXM.
	CAN_MSR_RXM = 0x200
	// Position of TXM field.
	CAN_MSR_TXM_Pos = 0x8
	// Bit mask of TXM field.
	CAN_MSR_TXM_Msk = 0x100
	// Bit TXM.
	CAN_MSR_TXM = 0x100
	// Position of SLAKI field.
	CAN_MSR_SLAKI_Pos = 0x4
	// Bit mask of SLAKI field.
	CAN_MSR_SLAKI_Msk = 0x10
	// Bit SLAKI.
	CAN_MSR_SLAKI = 0x10
	// Position of WKUI field.
	CAN_MSR_WKUI_Pos = 0x3
	// Bit mask of WKUI field.
	CAN_MSR_WKUI_Msk = 0x8
	// Bit WKUI.
	CAN_MSR_WKUI = 0x8
	// Position of ERRI field.
	CAN_MSR_ERRI_Pos = 0x2
	// Bit mask of ERRI field.
	CAN_MSR_ERRI_Msk = 0x4
	// Bit ERRI.
	CAN_MSR_ERRI = 0x4
	// Position of SLAK field.
	CAN_MSR_SLAK_Pos = 0x1
	// Bit mask of SLAK field.
	CAN_MSR_SLAK_Msk = 0x2
	// Bit SLAK.
	CAN_MSR_SLAK = 0x2
	// Position of INAK field.
	CAN_MSR_INAK_Pos = 0x0
	// Bit mask of INAK field.
	CAN_MSR_INAK_Msk = 0x1
	// Bit INAK.
	CAN_MSR_INAK = 0x1

	// TSR: transmit status register
	// Position of LOW2 field.
	CAN_TSR_LOW2_Pos = 0x1f
	// Bit mask of LOW2 field.
	CAN_TSR_LOW2_Msk = 0x80000000
	// Bit LOW2.
	CAN_TSR_LOW2 = 0x80000000
	// Position of LOW1 field.
	CAN_TSR_LOW1_Pos = 0x1e
	// Bit mask of LOW1 field.
	CAN_TSR_LOW1_Msk = 0x40000000
	// Bit LOW1.
	CAN_TSR_LOW1 = 0x40000000
	// Position of LOW0 field.
	CAN_TSR_LOW0_Pos = 0x1d
	// Bit mask of LOW0 field.
	CAN_TSR_LOW0_Msk = 0x20000000
	// Bit LOW0.
	CAN_TSR_LOW0 = 0x20000000
	// Position of TME2 field.
	CAN_TSR_TME2_Pos = 0x1c
	// Bit mask of TME2 field.
	CAN_TSR_TME2_Msk = 0x10000000
	// Bit TME2.
	CAN_TSR_TME2 = 0x10000000
	// Position of TME1 field.
	CAN_TSR_TME1_Pos = 0x1b
	// Bit mask of TME1 field.
	CAN_TSR_TME1_Msk = 0x8000000
	// Bit TME1.
	CAN_TSR_TME1 = 0x8000000
	// Position of TME0 field.
	CAN_TSR_TME0_Pos = 0x1a
	// Bit mask of TME0 field.
	CAN_TSR_TME0_Msk = 0x4000000
	// Bit TME0.
	CAN_TSR_TME0 = 0x4000000
	// Position of CODE field.
	CAN_TSR_CODE_Pos = 0x18
	// Bit mask of CODE field.
	CAN_TSR_CODE_Msk = 0x3000000
	// Position of ABRQ2 field.
	CAN_TSR_ABRQ2_Pos = 0x17
	// Bit mask of ABRQ2 field.
	CAN_TSR_ABRQ2_Msk = 0x800000
	// Bit ABRQ2.
	CAN_TSR_ABRQ2 = 0x800000
	// Position of TERR2 field.
	CAN_TSR_TERR2_Pos = 0x13
	// Bit mask of TERR2 field.
	CAN_TSR_TERR2_Msk = 0x80000
	// Bit TERR2.
	CAN_TSR_TERR2 = 0x80000
	// Position of ALST2 field.
	CAN_TSR_ALST2_Pos = 0x12
	// Bit mask of ALST2 field.
	CAN_TSR_ALST2_Msk = 0x40000
	// Bit ALST2.
	CAN_TSR_ALST2 = 0x40000
	// Position of TXOK2 field.
	CAN_TSR_TXOK2_Pos = 0x11
	// Bit mask of TXOK2 field.
	CAN_TSR_TXOK2_Msk = 0x20000
	// Bit TXOK2.
	CAN_TSR_TXOK2 = 0x20000
	// Position of RQCP2 field.
	CAN_TSR_RQCP2_Pos = 0x10
	// Bit mask of RQCP2 field.
	CAN_TSR_RQCP2_Msk = 0x10000
	// Bit RQCP2.
	CAN_TSR_RQCP2 = 0x10000
	// Position of ABRQ1 field.
	CAN_TSR_ABRQ1_Pos = 0xf
	// Bit mask of ABRQ1 field.
	CAN_TSR_ABRQ1_Msk = 0x8000
	// Bit ABRQ1.
	CAN_TSR_ABRQ1 = 0x8000
	// Position of TERR1 field.
	CAN_TSR_TERR1_Pos = 0xb
	// Bit mask of TERR1 field.
	CAN_TSR_TERR1_Msk = 0x800
	// Bit TERR1.
	CAN_TSR_TERR1 = 0x800
	// Position of ALST1 field.
	CAN_TSR_ALST1_Pos = 0xa
	// Bit mask of ALST1 field.
	CAN_TSR_ALST1_Msk = 0x400
	// Bit ALST1.
	CAN_TSR_ALST1 = 0x400
	// Position of TXOK1 field.
	CAN_TSR_TXOK1_Pos = 0x9
	// Bit mask of TXOK1 field.
	CAN_TSR_TXOK1_Msk = 0x200
	// Bit TXOK1.
	CAN_TSR_TXOK1 = 0x200
	// Position of RQCP1 field.
	CAN_TSR_RQCP1_Pos = 0x8
	// Bit mask of RQCP1 field.
	CAN_TSR_RQCP1_Msk = 0x100
	// Bit RQCP1.
	CAN_TSR_RQCP1 = 0x100
	// Position of ABRQ0 field.
	CAN_TSR_ABRQ0_Pos = 0x7
	// Bit mask of ABRQ0 field.
	CAN_TSR_ABRQ0_Msk = 0x80
	// Bit ABRQ0.
	CAN_TSR_ABRQ0 = 0x80
	// Position of TERR0 field.
	CAN_TSR_TERR0_Pos = 0x3
	// Bit mask of TERR0 field.
	CAN_TSR_TERR0_Msk = 0x8
	// Bit TERR0.
	CAN_TSR_TERR0 = 0x8
	// Position of ALST0 field.
	CAN_TSR_ALST0_Pos = 0x2
	// Bit mask of ALST0 field.
	CAN_TSR_ALST0_Msk = 0x4
	// Bit ALST0.
	CAN_TSR_ALST0 = 0x4
	// Position of TXOK0 field.
	CAN_TSR_TXOK0_Pos = 0x1
	// Bit mask of TXOK0 field.
	CAN_TSR_TXOK0_Msk = 0x2
	// Bit TXOK0.
	CAN_TSR_TXOK0 = 0x2
	// Position of RQCP0 field.
	CAN_TSR_RQCP0_Pos = 0x0
	// Bit mask of RQCP0 field.
	CAN_TSR_RQCP0_Msk = 0x1
	// Bit RQCP0.
	CAN_TSR_RQCP0 = 0x1

	// RF0R: receive FIFO %s register
	// Position of RFOM field.
	CAN_RFR_RFOM_Pos = 0x5
	// Bit mask of RFOM field.
	CAN_RFR_RFOM_Msk = 0x20
	// Bit RFOM.
	CAN_RFR_RFOM = 0x20
	// Set by software to release the output mailbox of the FIFO
	CAN_RFR_RFOM_Release = 0x1
	// Position of FOVR field.
	CAN_RFR_FOVR_Pos = 0x4
	// Bit mask of FOVR field.
	CAN_RFR_FOVR_Msk = 0x10
	// Bit FOVR.
	CAN_RFR_FOVR = 0x10
	// No FIFO x overrun
	CAN_RFR_FOVR_NoOverrun = 0x0
	// FIFO x overrun
	CAN_RFR_FOVR_Overrun = 0x1
	// Clear flag
	CAN_RFR_FOVR_Clear = 0x1
	// Position of FULL field.
	CAN_RFR_FULL_Pos = 0x3
	// Bit mask of FULL field.
	CAN_RFR_FULL_Msk = 0x8
	// Bit FULL.
	CAN_RFR_FULL = 0x8
	// FIFO x is not full
	CAN_RFR_FULL_NotFull = 0x0
	// FIFO x is full
	CAN_RFR_FULL_Full = 0x1
	// Clear flag
	CAN_RFR_FULL_Clear = 0x1
	// Position of FMP field.
	CAN_RFR_FMP_Pos = 0x0
	// Bit mask of FMP field.
	CAN_RFR_FMP_Msk = 0x3

	// IER: interrupt enable register
	// Position of SLKIE field.
	CAN_IER_SLKIE_Pos = 0x11
	// Bit mask of SLKIE field.
	CAN_IER_SLKIE_Msk = 0x20000
	// Bit SLKIE.
	CAN_IER_SLKIE = 0x20000
	// No interrupt when SLAKI bit is set
	CAN_IER_SLKIE_Disabled = 0x0
	// Interrupt generated when SLAKI bit is set
	CAN_IER_SLKIE_Enabled = 0x1
	// Position of WKUIE field.
	CAN_IER_WKUIE_Pos = 0x10
	// Bit mask of WKUIE field.
	CAN_IER_WKUIE_Msk = 0x10000
	// Bit WKUIE.
	CAN_IER_WKUIE = 0x10000
	// No interrupt when WKUI is set
	CAN_IER_WKUIE_Disabled = 0x0
	// Interrupt generated when WKUI bit is set
	CAN_IER_WKUIE_Enabled = 0x1
	// Position of ERRIE field.
	CAN_IER_ERRIE_Pos = 0xf
	// Bit mask of ERRIE field.
	CAN_IER_ERRIE_Msk = 0x8000
	// Bit ERRIE.
	CAN_IER_ERRIE = 0x8000
	// No interrupt will be generated when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Disabled = 0x0
	// An interrupt will be generation when an error condition is pending in the CAN_ESR
	CAN_IER_ERRIE_Enabled = 0x1
	// Position of LECIE field.
	CAN_IER_LECIE_Pos = 0xb
	// Bit mask of LECIE field.
	CAN_IER_LECIE_Msk = 0x800
	// Bit LECIE.
	CAN_IER_LECIE = 0x800
	// ERRI bit will not be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Disabled = 0x0
	// ERRI bit will be set when the error code in LEC[2:0] is set by hardware on error detection
	CAN_IER_LECIE_Enabled = 0x1
	// Position of BOFIE field.
	CAN_IER_BOFIE_Pos = 0xa
	// Bit mask of BOFIE field.
	CAN_IER_BOFIE_Msk = 0x400
	// Bit BOFIE.
	CAN_IER_BOFIE = 0x400
	// ERRI bit will not be set when BOFF is set
	CAN_IER_BOFIE_Disabled = 0x0
	// ERRI bit will be set when BOFF is set
	CAN_IER_BOFIE_Enabled = 0x1
	// Position of EPVIE field.
	CAN_IER_EPVIE_Pos = 0x9
	// Bit mask of EPVIE field.
	CAN_IER_EPVIE_Msk = 0x200
	// Bit EPVIE.
	CAN_IER_EPVIE = 0x200
	// ERRI bit will not be set when EPVF is set
	CAN_IER_EPVIE_Disabled = 0x0
	// ERRI bit will be set when EPVF is set
	CAN_IER_EPVIE_Enabled = 0x1
	// Position of EWGIE field.
	CAN_IER_EWGIE_Pos = 0x8
	// Bit mask of EWGIE field.
	CAN_IER_EWGIE_Msk = 0x100
	// Bit EWGIE.
	CAN_IER_EWGIE = 0x100
	// ERRI bit will not be set when EWGF is set
	CAN_IER_EWGIE_Disabled = 0x0
	// ERRI bit will be set when EWGF is set
	CAN_IER_EWGIE_Enabled = 0x1
	// Position of FOVIE1 field.
	CAN_IER_FOVIE1_Pos = 0x6
	// Bit mask of FOVIE1 field.
	CAN_IER_FOVIE1_Msk = 0x40
	// Bit FOVIE1.
	CAN_IER_FOVIE1 = 0x40
	// No interrupt when FOVR is set
	CAN_IER_FOVIE1_Disabled = 0x0
	// Interrupt generation when FOVR is set
	CAN_IER_FOVIE1_Enabled = 0x1
	// Position of FFIE1 field.
	CAN_IER_FFIE1_Pos = 0x5
	// Bit mask of FFIE1 field.
	CAN_IER_FFIE1_Msk = 0x20
	// Bit FFIE1.
	CAN_IER_FFIE1 = 0x20
	// No interrupt when FULL bit is set
	CAN_IER_FFIE1_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE1_Enabled = 0x1
	// Position of FMPIE1 field.
	CAN_IER_FMPIE1_Pos = 0x4
	// Bit mask of FMPIE1 field.
	CAN_IER_FMPIE1_Msk = 0x10
	// Bit FMPIE1.
	CAN_IER_FMPIE1 = 0x10
	// No interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE1_Enabled = 0x1
	// Position of FOVIE0 field.
	CAN_IER_FOVIE0_Pos = 0x3
	// Bit mask of FOVIE0 field.
	CAN_IER_FOVIE0_Msk = 0x8
	// Bit FOVIE0.
	CAN_IER_FOVIE0 = 0x8
	// No interrupt when FOVR bit is set
	CAN_IER_FOVIE0_Disabled = 0x0
	// Interrupt generated when FOVR bit is set
	CAN_IER_FOVIE0_Enabled = 0x1
	// Position of FFIE0 field.
	CAN_IER_FFIE0_Pos = 0x2
	// Bit mask of FFIE0 field.
	CAN_IER_FFIE0_Msk = 0x4
	// Bit FFIE0.
	CAN_IER_FFIE0 = 0x4
	// No interrupt when FULL bit is set
	CAN_IER_FFIE0_Disabled = 0x0
	// Interrupt generated when FULL bit is set
	CAN_IER_FFIE0_Enabled = 0x1
	// Position of FMPIE0 field.
	CAN_IER_FMPIE0_Pos = 0x1
	// Bit mask of FMPIE0 field.
	CAN_IER_FMPIE0_Msk = 0x2
	// Bit FMPIE0.
	CAN_IER_FMPIE0 = 0x2
	// No interrupt generated when state of FMP[1:0] bits are not 00
	CAN_IER_FMPIE0_Disabled = 0x0
	// Interrupt generated when state of FMP[1:0] bits are not 00b
	CAN_IER_FMPIE0_Enabled = 0x1
	// Position of TMEIE field.
	CAN_IER_TMEIE_Pos = 0x0
	// Bit mask of TMEIE field.
	CAN_IER_TMEIE_Msk = 0x1
	// Bit TMEIE.
	CAN_IER_TMEIE = 0x1
	// No interrupt when RQCPx bit is set
	CAN_IER_TMEIE_Disabled = 0x0
	// Interrupt generated when RQCPx bit is set
	CAN_IER_TMEIE_Enabled = 0x1

	// ESR: interrupt enable register
	// Position of REC field.
	CAN_ESR_REC_Pos = 0x18
	// Bit mask of REC field.
	CAN_ESR_REC_Msk = 0xff000000
	// Position of TEC field.
	CAN_ESR_TEC_Pos = 0x10
	// Bit mask of TEC field.
	CAN_ESR_TEC_Msk = 0xff0000
	// Position of LEC field.
	CAN_ESR_LEC_Pos = 0x4
	// Bit mask of LEC field.
	CAN_ESR_LEC_Msk = 0x70
	// No Error
	CAN_ESR_LEC_NoError = 0x0
	// Stuff Error
	CAN_ESR_LEC_Stuff = 0x1
	// Form Error
	CAN_ESR_LEC_Form = 0x2
	// Acknowledgment Error
	CAN_ESR_LEC_Ack = 0x3
	// Bit recessive Error
	CAN_ESR_LEC_BitRecessive = 0x4
	// Bit dominant Error
	CAN_ESR_LEC_BitDominant = 0x5
	// CRC Error
	CAN_ESR_LEC_Crc = 0x6
	// Set by software
	CAN_ESR_LEC_Custom = 0x7
	// Position of BOFF field.
	CAN_ESR_BOFF_Pos = 0x2
	// Bit mask of BOFF field.
	CAN_ESR_BOFF_Msk = 0x4
	// Bit BOFF.
	CAN_ESR_BOFF = 0x4
	// Position of EPVF field.
	CAN_ESR_EPVF_Pos = 0x1
	// Bit mask of EPVF field.
	CAN_ESR_EPVF_Msk = 0x2
	// Bit EPVF.
	CAN_ESR_EPVF = 0x2
	// Position of EWGF field.
	CAN_ESR_EWGF_Pos = 0x0
	// Bit mask of EWGF field.
	CAN_ESR_EWGF_Msk = 0x1
	// Bit EWGF.
	CAN_ESR_EWGF = 0x1

	// BTR: bit timing register
	// Position of SILM field.
	CAN_BTR_SILM_Pos = 0x1f
	// Bit mask of SILM field.
	CAN_BTR_SILM_Msk = 0x80000000
	// Bit SILM.
	CAN_BTR_SILM = 0x80000000
	// Normal operation
	CAN_BTR_SILM_Normal = 0x0
	// Silent Mode
	CAN_BTR_SILM_Silent = 0x1
	// Position of LBKM field.
	CAN_BTR_LBKM_Pos = 0x1e
	// Bit mask of LBKM field.
	CAN_BTR_LBKM_Msk = 0x40000000
	// Bit LBKM.
	CAN_BTR_LBKM = 0x40000000
	// Loop Back Mode disabled
	CAN_BTR_LBKM_Disabled = 0x0
	// Loop Back Mode enabled
	CAN_BTR_LBKM_Enabled = 0x1
	// Position of SJW field.
	CAN_BTR_SJW_Pos = 0x18
	// Bit mask of SJW field.
	CAN_BTR_SJW_Msk = 0x3000000
	// Position of TS2 field.
	CAN_BTR_TS2_Pos = 0x14
	// Bit mask of TS2 field.
	CAN_BTR_TS2_Msk = 0x700000
	// Position of TS1 field.
	CAN_BTR_TS1_Pos = 0x10
	// Bit mask of TS1 field.
	CAN_BTR_TS1_Msk = 0xf0000
	// Position of BRP field.
	CAN_BTR_BRP_Pos = 0x0
	// Bit mask of BRP field.
	CAN_BTR_BRP_Msk = 0x3ff

	// TX.TIR: TX mailbox identifier register
	// Position of STID field.
	CAN_TX_TIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_TX_TIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_TX_TIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_TX_TIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_TX_TIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_TX_TIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_TX_TIR_IDE = 0x4
	// Standard identifier
	CAN_TX_TIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_TX_TIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_TX_TIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_TX_TIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_TX_TIR_RTR = 0x2
	// Data frame
	CAN_TX_TIR_RTR_Data = 0x0
	// Remote frame
	CAN_TX_TIR_RTR_Remote = 0x1
	// Position of TXRQ field.
	CAN_TX_TIR_TXRQ_Pos = 0x0
	// Bit mask of TXRQ field.
	CAN_TX_TIR_TXRQ_Msk = 0x1
	// Bit TXRQ.
	CAN_TX_TIR_TXRQ = 0x1

	// TX.TDTR: mailbox data length control and time stamp register
	// Position of TIME field.
	CAN_TX_TDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_TX_TDTR_TIME_Msk = 0xffff0000
	// Position of TGT field.
	CAN_TX_TDTR_TGT_Pos = 0x8
	// Bit mask of TGT field.
	CAN_TX_TDTR_TGT_Msk = 0x100
	// Bit TGT.
	CAN_TX_TDTR_TGT = 0x100
	// Position of DLC field.
	CAN_TX_TDTR_DLC_Pos = 0x0
	// Bit mask of DLC field.
	CAN_TX_TDTR_DLC_Msk = 0xf

	// TX.TDLR: mailbox data low register
	// Position of DATA3 field.
	CAN_TX_TDLR_DATA3_Pos = 0x18
	// Bit mask of DATA3 field.
	CAN_TX_TDLR_DATA3_Msk = 0xff000000
	// Position of DATA2 field.
	CAN_TX_TDLR_DATA2_Pos = 0x10
	// Bit mask of DATA2 field.
	CAN_TX_TDLR_DATA2_Msk = 0xff0000
	// Position of DATA1 field.
	CAN_TX_TDLR_DATA1_Pos = 0x8
	// Bit mask of DATA1 field.
	CAN_TX_TDLR_DATA1_Msk = 0xff00
	// Position of DATA0 field.
	CAN_TX_TDLR_DATA0_Pos = 0x0
	// Bit mask of DATA0 field.
	CAN_TX_TDLR_DATA0_Msk = 0xff

	// TX.TDHR: mailbox data high register
	// Position of DATA7 field.
	CAN_TX_TDHR_DATA7_Pos = 0x18
	// Bit mask of DATA7 field.
	CAN_TX_TDHR_DATA7_Msk = 0xff000000
	// Position of DATA6 field.
	CAN_TX_TDHR_DATA6_Pos = 0x10
	// Bit mask of DATA6 field.
	CAN_TX_TDHR_DATA6_Msk = 0xff0000
	// Position of DATA5 field.
	CAN_TX_TDHR_DATA5_Pos = 0x8
	// Bit mask of DATA5 field.
	CAN_TX_TDHR_DATA5_Msk = 0xff00
	// Position of DATA4 field.
	CAN_TX_TDHR_DATA4_Pos = 0x0
	// Bit mask of DATA4 field.
	CAN_TX_TDHR_DATA4_Msk = 0xff

	// RX.RIR: receive FIFO mailbox identifier register
	// Position of STID field.
	CAN_RX_RIR_STID_Pos = 0x15
	// Bit mask of STID field.
	CAN_RX_RIR_STID_Msk = 0xffe00000
	// Position of EXID field.
	CAN_RX_RIR_EXID_Pos = 0x3
	// Bit mask of EXID field.
	CAN_RX_RIR_EXID_Msk = 0x1ffff8
	// Position of IDE field.
	CAN_RX_RIR_IDE_Pos = 0x2
	// Bit mask of IDE field.
	CAN_RX_RIR_IDE_Msk = 0x4
	// Bit IDE.
	CAN_RX_RIR_IDE = 0x4
	// Standard identifier
	CAN_RX_RIR_IDE_Standard = 0x0
	// Extended identifier
	CAN_RX_RIR_IDE_Extended = 0x1
	// Position of RTR field.
	CAN_RX_RIR_RTR_Pos = 0x1
	// Bit mask of RTR field.
	CAN_RX_RIR_RTR_Msk = 0x2
	// Bit RTR.
	CAN_RX_RIR_RTR = 0x2
	// Data frame
	CAN_RX_RIR_RTR_Data = 0x0
	// Remote frame
	CAN_RX_RIR_RTR_Remote = 0x1

	// RX.RDTR: mailbox data high register
	// Position of TIME field.
	CAN_RX_RDTR_TIME_Pos = 0x10
	// Bit mask of TIME field.
	CAN_RX_RDTR_TIME_Msk = 0xffff0000
	// Position of FMI field.
	CAN_RX_RDTR_FMI_Pos = 0x8
	// Bit mask of FMI field.
	CAN_RX_