/* contacts-chunk.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-chunk.vala, do not modify */

/*
 * Copyright (C) 2022 Niels De Graef <nielsdegraef@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "contactscore.h"
#include <folks/folks.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

enum  {
	CONTACTS_CHUNK_0_PROPERTY,
	CONTACTS_CHUNK_PERSONA_PROPERTY,
	CONTACTS_CHUNK_PROPERTY_NAME_PROPERTY,
	CONTACTS_CHUNK_IS_EMPTY_PROPERTY,
	CONTACTS_CHUNK_CHANGED_PROPERTY,
	CONTACTS_CHUNK_NUM_PROPERTIES
};
static GParamSpec* contacts_chunk_properties[CONTACTS_CHUNK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsChunkPrivate {
	FolksPersona* _persona;
	gboolean _changed;
};

static gint ContactsChunk_private_offset;
static gpointer contacts_chunk_parent_class = NULL;

static GValue* contacts_chunk_real_to_value (ContactsChunk* self);
static void contacts_chunk_finalize (GObject * obj);
static GType contacts_chunk_get_type_once (void);
static void _vala_contacts_chunk_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_contacts_chunk_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
contacts_chunk_get_instance_private (ContactsChunk* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsChunk_private_offset);
}

/**
   * Converts this chunk into a GLib.Value, as expected by API like
   * {@link Folks.PersonaStore.add_persona_from_details}
   *
   * If the field is empty or non-existent, it should return null.
   */
static GValue*
contacts_chunk_real_to_value (ContactsChunk* self)
{
	g_critical ("Type `%s' does not implement abstract method `contacts_chunk_to_value'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GValue*
contacts_chunk_to_value (ContactsChunk* self)
{
	ContactsChunkClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONTACTS_CHUNK_GET_CLASS (self);
	if (_klass_->to_value) {
		return _klass_->to_value (self);
	}
	return NULL;
}

void
contacts_chunk_save_to_persona (ContactsChunk* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	ContactsChunkClass* _klass_;
	_tmp0_ = contacts_chunk_get_persona (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "this.persona != null", FALSE);
	_klass_ = CONTACTS_CHUNK_GET_CLASS (self);
	if (_klass_->save_to_persona) {
		_klass_->save_to_persona (self, _callback_, _user_data_);
	}
}

void
contacts_chunk_save_to_persona_finish (ContactsChunk* self,
                                       GAsyncResult* _res_,
                                       GError** error)
{
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	ContactsChunkClass* _klass_;
	_tmp0_ = contacts_chunk_get_persona (self);
	_tmp1_ = _tmp0_;
	_vala_return_val_if_fail (_tmp1_ != NULL, "this.persona != null", FALSE);
	_klass_ = CONTACTS_CHUNK_GET_CLASS (self);
	if (_klass_->save_to_persona_finish) {
		_klass_->save_to_persona_finish (self, _res_, error);
	}
}

ContactsChunk*
contacts_chunk_construct (GType object_type)
{
	ContactsChunk * self = NULL;
	self = (ContactsChunk*) g_object_new (object_type, NULL);
	return self;
}

FolksPersona*
contacts_chunk_get_persona (ContactsChunk* self)
{
	FolksPersona* result;
	FolksPersona* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_persona;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
contacts_chunk_set_persona (ContactsChunk* self,
                            FolksPersona* value)
{
	FolksPersona* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_chunk_get_persona (self);
	if (old_value != value) {
		FolksPersona* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_persona);
		self->priv->_persona = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_chunk_properties[CONTACTS_CHUNK_PERSONA_PROPERTY]);
	}
}

const gchar*
contacts_chunk_get_property_name (ContactsChunk* self)
{
	ContactsChunkClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = CONTACTS_CHUNK_GET_CLASS (self);
	if (_klass_->get_property_name) {
		return _klass_->get_property_name (self);
	}
	return NULL;
}

gboolean
contacts_chunk_get_is_empty (ContactsChunk* self)
{
	ContactsChunkClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = CONTACTS_CHUNK_GET_CLASS (self);
	if (_klass_->get_is_empty) {
		return _klass_->get_is_empty (self);
	}
	return FALSE;
}

gboolean
contacts_chunk_get_changed (ContactsChunk* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_changed;
	return result;
}

void
contacts_chunk_set_changed (ContactsChunk* self,
                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_chunk_get_changed (self);
	if (old_value != value) {
		self->priv->_changed = value;
		g_object_notify_by_pspec ((GObject *) self, contacts_chunk_properties[CONTACTS_CHUNK_CHANGED_PROPERTY]);
	}
}

static void
contacts_chunk_class_init (ContactsChunkClass * klass,
                           gpointer klass_data)
{
	contacts_chunk_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsChunk_private_offset);
	((ContactsChunkClass *) klass)->to_value = (GValue* (*) (ContactsChunk*)) contacts_chunk_real_to_value;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_chunk_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_chunk_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_chunk_finalize;
	/** The associated persona (or null if we're creating a new one) */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CHUNK_PERSONA_PROPERTY, contacts_chunk_properties[CONTACTS_CHUNK_PERSONA_PROPERTY] = g_param_spec_object ("persona", "persona", "persona", FOLKS_TYPE_PERSONA, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	/**
	   * The specific property of this chunk.
	   *
	   * Note that this should match with the string representation of a
	   * {@link Folks.PersonaDetail}.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CHUNK_PROPERTY_NAME_PROPERTY, contacts_chunk_properties[CONTACTS_CHUNK_PROPERTY_NAME_PROPERTY] = g_param_spec_string ("property-name", "property-name", "property-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * Whether this is empty. As an example, you can use to changes in this
	   * property to update any UI.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CHUNK_IS_EMPTY_PROPERTY, contacts_chunk_properties[CONTACTS_CHUNK_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	   * A separate field to keep track of whether something has changed.
	   * If it did, we know we'll have to (possibly) save the changes.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_CHUNK_CHANGED_PROPERTY, contacts_chunk_properties[CONTACTS_CHUNK_CHANGED_PROPERTY] = g_param_spec_boolean ("changed", "changed", "changed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
contacts_chunk_instance_init (ContactsChunk * self,
                              gpointer klass)
{
	self->priv = contacts_chunk_get_instance_private (self);
	self->priv->_persona = NULL;
	self->priv->_changed = FALSE;
}

static void
contacts_chunk_finalize (GObject * obj)
{
	ContactsChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_CHUNK, ContactsChunk);
	_g_object_unref0 (self->priv->_persona);
	G_OBJECT_CLASS (contacts_chunk_parent_class)->finalize (obj);
}

/**
 * A "chunk" is a piece of data that describes a specific property of a
 * {@link Contact}. Each chunk usually maps to a specific vCard property, or an
 * interface related to a property of a {@link Folks.Persona}.
 */
 G_GNUC_NO_INLINE static GType
contacts_chunk_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsChunkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_chunk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsChunk), 0, (GInstanceInitFunc) contacts_chunk_instance_init, NULL };
	GType contacts_chunk_type_id;
	contacts_chunk_type_id = g_type_register_static (G_TYPE_OBJECT, "ContactsChunk", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ContactsChunk_private_offset = g_type_add_instance_private (contacts_chunk_type_id, sizeof (ContactsChunkPrivate));
	return contacts_chunk_type_id;
}

GType
contacts_chunk_get_type (void)
{
	static volatile gsize contacts_chunk_type_id__once = 0;
	if (g_once_init_enter (&contacts_chunk_type_id__once)) {
		GType contacts_chunk_type_id;
		contacts_chunk_type_id = contacts_chunk_get_type_once ();
		g_once_init_leave (&contacts_chunk_type_id__once, contacts_chunk_type_id);
	}
	return contacts_chunk_type_id__once;
}

static void
_vala_contacts_chunk_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	ContactsChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CHUNK, ContactsChunk);
	switch (property_id) {
		case CONTACTS_CHUNK_PERSONA_PROPERTY:
		g_value_set_object (value, contacts_chunk_get_persona (self));
		break;
		case CONTACTS_CHUNK_CHANGED_PROPERTY:
		g_value_set_boolean (value, contacts_chunk_get_changed (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_chunk_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	ContactsChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_CHUNK, ContactsChunk);
	switch (property_id) {
		case CONTACTS_CHUNK_PERSONA_PROPERTY:
		contacts_chunk_set_persona (self, g_value_get_object (value));
		break;
		case CONTACTS_CHUNK_CHANGED_PROPERTY:
		contacts_chunk_set_changed (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

