/* contacts-esd-setup.c generated by valac 0.56.3, the Vala compiler
 * generated from contacts-esd-setup.vala, do not modify */

/*
 * This code is ported to Vala from evolution with this license:
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the program; if not, see <http://www.gnu.org/licenses/>
 *
 */

#include "contacts.h"
#include <glib.h>
#include <libedataserver/libedataserver.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtk/gtk.h>
#include <goa/goa.h>
#include <gio/gio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

ESourceRegistry* contacts_eds_source_registry = NULL;

static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);

gboolean
contacts_ensure_eds_accounts (gboolean allow_interaction)
{
	ESourceRegistry* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	_tmp0_ = contacts_eds_source_registry;
	if (_tmp0_ != NULL) {
		result = TRUE;
		return result;
	}
	{
		ESourceRegistry* _tmp1_ = NULL;
		ESourceRegistry* _tmp2_;
		ESourceRegistry* _tmp3_;
		_tmp2_ = e_source_registry_new_sync (NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (contacts_eds_source_registry);
		contacts_eds_source_registry = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("contacts-esd-setup.vala:34: Couldn't load EDS SourceRegistry: %s", _tmp5_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
	result = TRUE;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

gboolean
contacts_has_goa_account (void)
{
	ESourceRegistry* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	_tmp0_ = contacts_eds_source_registry;
	_tmp1_ = e_source_registry_list_sources (_tmp0_, E_SOURCE_EXTENSION_GOA);
	{
		GList* source_collection = NULL;
		GList* source_it = NULL;
		source_collection = _tmp1_;
		for (source_it = source_collection; source_it != NULL; source_it = source_it->next) {
			ESource* _tmp2_;
			ESource* source = NULL;
			_tmp2_ = _g_object_ref0 ((ESource*) source_it->data);
			source = _tmp2_;
			{
				ESource* _tmp3_;
				gboolean _tmp4_;
				gboolean _tmp5_;
				ESource* _tmp6_;
				ESource* _tmp7_;
				ESourceExtension* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				_tmp3_ = source;
				_tmp4_ = e_source_get_enabled (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					_g_object_unref0 (source);
					continue;
				}
				_tmp6_ = source;
				if (!e_source_has_extension (_tmp6_, E_SOURCE_EXTENSION_COLLECTION)) {
					_g_object_unref0 (source);
					continue;
				}
				_tmp7_ = source;
				_tmp8_ = e_source_get_extension (_tmp7_, E_SOURCE_EXTENSION_COLLECTION);
				_tmp9_ = e_source_collection_get_contacts_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, e_source_collection_get_type (), ESourceCollection));
				_tmp10_ = _tmp9_;
				if (_tmp10_) {
					result = TRUE;
					_g_object_unref0 (source);
					(source_collection == NULL) ? NULL : (source_collection = (_g_list_free__g_object_unref0_ (source_collection), NULL));
					return result;
				}
				_g_object_unref0 (source);
			}
		}
		(source_collection == NULL) ? NULL : (source_collection = (_g_list_free__g_object_unref0_ (source_collection), NULL));
	}
	result = FALSE;
	return result;
}

gboolean
contacts_esource_uid_is_google (const gchar* uid)
{
	ESource* source = NULL;
	ESourceRegistry* _tmp0_;
	ESource* _tmp1_;
	ESource* _tmp2_;
	ESource* _tmp3_;
	gboolean result;
	g_return_val_if_fail (uid != NULL, FALSE);
	_tmp0_ = contacts_eds_source_registry;
	_tmp1_ = e_source_registry_ref_source (_tmp0_, uid);
	source = _tmp1_;
	_tmp2_ = source;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (source);
		return result;
	}
	_tmp3_ = source;
	if (e_source_has_extension (_tmp3_, E_SOURCE_EXTENSION_ADDRESS_BOOK)) {
		ESourceExtension* extension = NULL;
		ESource* _tmp4_;
		ESourceExtension* _tmp5_;
		ESourceExtension* _tmp6_;
		ESourceExtension* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp4_ = source;
		_tmp5_ = e_source_get_extension (_tmp4_, E_SOURCE_EXTENSION_ADDRESS_BOOK);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		extension = _tmp6_;
		_tmp7_ = extension;
		_tmp8_ = e_source_backend_get_backend_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, e_source_backend_get_type (), ESourceBackend));
		_tmp9_ = _tmp8_;
		result = g_strcmp0 (_tmp9_, "google") == 0;
		_g_object_unref0 (extension);
		_g_object_unref0 (source);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (source);
	return result;
}

gchar*
contacts_lookup_esource_name_by_uid (const gchar* uid)
{
	ESource* source = NULL;
	ESourceRegistry* _tmp0_;
	ESource* _tmp1_;
	ESource* _tmp2_;
	ESource* builtin_address_book = NULL;
	ESourceRegistry* _tmp3_;
	ESource* _tmp4_;
	ESource* _tmp5_;
	ESource* _tmp6_;
	ESource* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (uid != NULL, NULL);
	_tmp0_ = contacts_eds_source_registry;
	_tmp1_ = e_source_registry_ref_source (_tmp0_, uid);
	source = _tmp1_;
	_tmp2_ = source;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (source);
		return result;
	}
	_tmp3_ = contacts_eds_source_registry;
	_tmp4_ = e_source_registry_ref_builtin_address_book (_tmp3_);
	builtin_address_book = _tmp4_;
	_tmp5_ = source;
	_tmp6_ = builtin_address_book;
	if (e_source_equal (_tmp5_, _tmp6_)) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (_ ("Local Address Book"));
		result = _tmp7_;
		_g_object_unref0 (builtin_address_book);
		_g_object_unref0 (source);
		return result;
	}
	if (contacts_esource_uid_is_google (uid)) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup (_ ("Google"));
		result = _tmp8_;
		_g_object_unref0 (builtin_address_book);
		_g_object_unref0 (source);
		return result;
	}
	_tmp9_ = source;
	_tmp10_ = e_source_get_display_name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup (_tmp11_);
	result = _tmp12_;
	_g_object_unref0 (builtin_address_book);
	_g_object_unref0 (source);
	return result;
}

const gchar*
contacts_lookup_esource_name_by_uid_for_contact (const gchar* uid)
{
	ESource* source = NULL;
	ESourceRegistry* _tmp0_;
	ESource* _tmp1_;
	ESource* _tmp2_;
	ESource* builtin_address_book = NULL;
	ESourceRegistry* _tmp3_;
	ESource* _tmp4_;
	ESource* _tmp5_;
	ESource* _tmp6_;
	ESource* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* result;
	g_return_val_if_fail (uid != NULL, NULL);
	_tmp0_ = contacts_eds_source_registry;
	_tmp1_ = e_source_registry_ref_source (_tmp0_, uid);
	source = _tmp1_;
	_tmp2_ = source;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (source);
		return result;
	}
	_tmp3_ = contacts_eds_source_registry;
	_tmp4_ = e_source_registry_ref_builtin_address_book (_tmp3_);
	builtin_address_book = _tmp4_;
	_tmp5_ = source;
	_tmp6_ = builtin_address_book;
	if (e_source_equal (_tmp5_, _tmp6_)) {
		result = _ ("Local Contact");
		_g_object_unref0 (builtin_address_book);
		_g_object_unref0 (source);
		return result;
	}
	if (contacts_esource_uid_is_google (uid)) {
		result = _ ("Google");
		_g_object_unref0 (builtin_address_book);
		_g_object_unref0 (source);
		return result;
	}
	_tmp7_ = source;
	_tmp8_ = e_source_get_display_name (_tmp7_);
	_tmp9_ = _tmp8_;
	result = _tmp9_;
	_g_object_unref0 (builtin_address_book);
	_g_object_unref0 (source);
	return result;
}

GtkImage*
contacts_get_icon_for_goa_account (const gchar* goa_id)
{
	GoaClient* client = NULL;
	GoaObject* goa_object = NULL;
	GoaClient* _tmp5_;
	GoaObject* _tmp6_;
	GIcon* provider_icon = NULL;
	GIcon* _tmp18_;
	GtkImage* _tmp19_;
	GError* _inner_error0_ = NULL;
	GtkImage* result;
	g_return_val_if_fail (goa_id != NULL, NULL);
	{
		GoaClient* _tmp0_ = NULL;
		GoaClient* _tmp1_;
		GoaClient* _tmp2_;
		_tmp1_ = goa_client_new_sync (NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (client);
		client = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("contacts-esd-setup.vala:180: Couldn't load GOA client \"%s\": %s", goa_id, _tmp4_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (client);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (client);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp5_ = client;
	_tmp6_ = goa_client_lookup_by_id (_tmp5_, goa_id);
	goa_object = _tmp6_;
	{
		GIcon* _tmp7_ = NULL;
		GoaObject* _tmp8_;
		GoaAccount* _tmp9_;
		GoaAccount* _tmp10_;
		GoaAccount* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GIcon* _tmp15_;
		GIcon* _tmp16_;
		GIcon* _tmp17_;
		_tmp8_ = goa_object;
		g_object_get (_tmp8_, "account", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = _tmp10_;
		g_object_get (_tmp11_, "provider-icon", &_tmp12_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp15_ = g_icon_new_for_string (_tmp14_, &_inner_error0_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_g_object_unref0 (_tmp11_);
		_tmp7_ = _tmp16_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp17_ = _tmp7_;
		_tmp7_ = NULL;
		_g_object_unref0 (provider_icon);
		provider_icon = _tmp17_;
		_g_object_unref0 (_tmp7_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_debug ("contacts-esd-setup.vala:190: Couldn't load icon for GOA provider \"%s\"", goa_id);
		result = NULL;
		_g_object_unref0 (provider_icon);
		_g_object_unref0 (goa_object);
		_g_object_unref0 (client);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (provider_icon);
		_g_object_unref0 (goa_object);
		_g_object_unref0 (client);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp18_ = provider_icon;
	_tmp19_ = (GtkImage*) gtk_image_new_from_gicon (_tmp18_);
	g_object_ref_sink (_tmp19_);
	result = _tmp19_;
	_g_object_unref0 (provider_icon);
	_g_object_unref0 (goa_object);
	_g_object_unref0 (client);
	return result;
}

