/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.bcel.classfile;

import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.ConstantPool;
import org.apache.tomcat.util.bcel.classfile.ElementValue;

public class ArrayElementValue
extends ElementValue {
    private final ElementValue[] elementValues;

    ArrayElementValue(int n, ElementValue[] elementValueArray, ConstantPool constantPool) {
        super(n, constantPool);
        if (n != 91) {
            throw new ClassFormatException("Only element values of type array can be built with this ctor - type specified: " + n);
        }
        this.elementValues = elementValueArray;
    }

    public ElementValue[] getElementValuesArray() {
        return this.elementValues;
    }

    @Override
    public String stringifyValue() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (int i = 0; i < this.elementValues.length; ++i) {
            stringBuilder.append(this.elementValues[i].stringifyValue());
            if (i + 1 >= this.elementValues.length) continue;
            stringBuilder.append(',');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

