import type { BufferLike, CreateWriteStreamOptions, WebDAVClientOptions } from "webdav";
import type { Readable, Writable } from "stream";
import { CallbackType, ExtCreateReadStreamOptions, FsStat, PathLike } from "./types";
export declare function createAdapter(webDAVEndpoint: string, options?: WebDAVClientOptions): {
    "@@fsType": string;
    createReadStream: (filePath: PathLike, options?: ExtCreateReadStreamOptions) => Readable;
    createWriteStream: (filePath: PathLike, options?: CreateWriteStreamOptions) => Writable;
    mkdir: (dirPath: PathLike, callback: CallbackType<void>) => void;
    readdir: (dirPath: PathLike, modeOrCallback: "node" | "stat" | CallbackType<Array<string | FsStat>>, callback?: CallbackType<Array<string | FsStat>>) => void;
    readFile: (filename: PathLike, encodingOrCallback: "utf8" | "text" | "binary" | CallbackType<string | BufferLike>, callback?: CallbackType<string | BufferLike>) => void;
    rename: (filePath: PathLike, targetPath: PathLike, callback: CallbackType<void>) => void;
    rmdir: (targetPath: PathLike, callback: CallbackType<void>) => void;
    stat: (remotePath: PathLike, callback: CallbackType<FsStat>) => void;
    unlink: (targetPath: PathLike, callback: CallbackType<void>) => void;
    writeFile: (filename: PathLike, data: BufferLike | string, encodingOrCallback?: "utf8" | "text" | "binary" | CallbackType<void>, callback?: CallbackType<void>) => void;
};
