/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.sdbcx.comp.hsqldb;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

final class NativeLibraries {
    public static void load() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            NativeLibraries.loadLibrary("msvcr71");
            NativeLibraries.loadLibrary("sal3");
            NativeLibraries.loadLibrary("dbtoolsmi");
        }
        NativeLibraries.loadLibrary("hsqldb");
    }

    private static void loadLibrary(String libname) {
        block5: {
            try {
                System.loadLibrary(libname);
            }
            catch (UnsatisfiedLinkError e) {
                URL url;
                ClassLoader cl = NativeLibraries.class.getClassLoader();
                if (!(cl instanceof URLClassLoader)) break block5;
                String sysname = System.mapLibraryName(libname);
                if (System.getProperty("os.name").startsWith("Mac") && sysname.endsWith(".dylib")) {
                    sysname = sysname.substring(0, sysname.length() - "dylib".length()) + "jnilib";
                }
                if ((url = ((URLClassLoader)cl).findResource(sysname)) == null) break block5;
                try {
                    System.load(new File(url.toURI()).getAbsolutePath());
                }
                catch (Throwable t) {
                    throw new UnsatisfiedLinkError(e.toString() + " - " + t.toString());
                }
            }
        }
    }

    private NativeLibraries() {
    }
}

