/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.tcp;

import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Manager;
import org.apache.catalina.Valve;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterDeployer;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.ClusterValve;
import org.apache.catalina.ha.session.ClusterSessionListener;
import org.apache.catalina.ha.session.DeltaManager;
import org.apache.catalina.ha.session.JvmRouteBinderValve;
import org.apache.catalina.ha.session.SessionMessage;
import org.apache.catalina.ha.tcp.ReplicationValve;
import org.apache.catalina.ha.tcp.SendMessageData;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.group.GroupChannel;
import org.apache.catalina.tribes.group.interceptors.MessageDispatchInterceptor;
import org.apache.catalina.tribes.group.interceptors.TcpFailureDetector;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class SimpleTcpCluster
extends LifecycleMBeanBase
implements CatalinaCluster,
MembershipListener,
ChannelListener {
    public static final Log log = LogFactory.getLog(SimpleTcpCluster.class);
    public static final String BEFORE_MEMBERREGISTER_EVENT = "before_member_register";
    public static final String AFTER_MEMBERREGISTER_EVENT = "after_member_register";
    public static final String BEFORE_MANAGERREGISTER_EVENT = "before_manager_register";
    public static final String AFTER_MANAGERREGISTER_EVENT = "after_manager_register";
    public static final String BEFORE_MANAGERUNREGISTER_EVENT = "before_manager_unregister";
    public static final String AFTER_MANAGERUNREGISTER_EVENT = "after_manager_unregister";
    public static final String BEFORE_MEMBERUNREGISTER_EVENT = "before_member_unregister";
    public static final String AFTER_MEMBERUNREGISTER_EVENT = "after_member_unregister";
    public static final String SEND_MESSAGE_FAILURE_EVENT = "send_message_failure";
    public static final String RECEIVE_MESSAGE_FAILURE_EVENT = "receive_message_failure";
    protected Channel channel = new GroupChannel();
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.ha.tcp");
    protected String clusterName;
    protected boolean heartbeatBackgroundEnabled = false;
    protected Container container = null;
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected final Map<String, ClusterManager> managers = new HashMap<String, ClusterManager>();
    protected ClusterManager managerTemplate = new DeltaManager();
    private final List<Valve> valves = new ArrayList<Valve>();
    private ClusterDeployer clusterDeployer;
    private ObjectName onameClusterDeployer;
    protected final List<ClusterListener> clusterListeners = new ArrayList<ClusterListener>();
    private boolean notifyLifecycleListenerOnFailure = false;
    private int channelSendOptions = 8;
    private int channelStartOptions = 15;
    private final Map<Member, ObjectName> memberOnameMap = new ConcurrentHashMap<Member, ObjectName>();
    protected boolean hasMembers = false;

    public boolean isHeartbeatBackgroundEnabled() {
        return this.heartbeatBackgroundEnabled;
    }

    public void setHeartbeatBackgroundEnabled(boolean bl) {
        this.heartbeatBackgroundEnabled = bl;
    }

    public void setClusterName(String string) {
        this.clusterName = string;
    }

    public String getClusterName() {
        if (this.clusterName == null && this.container != null) {
            return this.container.getName();
        }
        return this.clusterName;
    }

    public void setContainer(Container container) {
        Container container2 = this.container;
        this.container = container;
        this.support.firePropertyChange("container", container2, this.container);
    }

    public Container getContainer() {
        return this.container;
    }

    public boolean isNotifyLifecycleListenerOnFailure() {
        return this.notifyLifecycleListenerOnFailure;
    }

    public void setNotifyLifecycleListenerOnFailure(boolean bl) {
        boolean bl2 = this.notifyLifecycleListenerOnFailure;
        this.notifyLifecycleListenerOnFailure = bl;
        this.support.firePropertyChange("notifyLifecycleListenerOnFailure", bl2, this.notifyLifecycleListenerOnFailure);
    }

    @Override
    public void addValve(Valve valve) {
        if (valve instanceof ClusterValve && !this.valves.contains(valve)) {
            this.valves.add(valve);
        }
    }

    @Override
    public Valve[] getValves() {
        return this.valves.toArray(new Valve[0]);
    }

    public ClusterListener[] findClusterListeners() {
        return this.clusterListeners.toArray(new ClusterListener[0]);
    }

    @Override
    public void addClusterListener(ClusterListener clusterListener) {
        if (clusterListener != null && !this.clusterListeners.contains(clusterListener)) {
            this.clusterListeners.add(clusterListener);
            clusterListener.setCluster(this);
        }
    }

    @Override
    public void removeClusterListener(ClusterListener clusterListener) {
        if (clusterListener != null) {
            this.clusterListeners.remove(clusterListener);
            clusterListener.setCluster(null);
        }
    }

    @Override
    public ClusterDeployer getClusterDeployer() {
        return this.clusterDeployer;
    }

    @Override
    public void setClusterDeployer(ClusterDeployer clusterDeployer) {
        this.clusterDeployer = clusterDeployer;
    }

    @Override
    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setManagerTemplate(ClusterManager clusterManager) {
        this.managerTemplate = clusterManager;
    }

    public void setChannelSendOptions(int n) {
        this.channelSendOptions = n;
    }

    @Override
    public boolean hasMembers() {
        return this.hasMembers;
    }

    @Override
    public Member[] getMembers() {
        return this.channel.getMembers();
    }

    @Override
    public Member getLocalMember() {
        return this.channel.getLocalMember(true);
    }

    @Override
    public Map<String, ClusterManager> getManagers() {
        return this.managers;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    public ClusterManager getManagerTemplate() {
        return this.managerTemplate;
    }

    public int getChannelSendOptions() {
        return this.channelSendOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Manager createManager(String string) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating ClusterManager for context " + string + " using class " + this.getManagerTemplate().getClass().getName()));
        }
        ClusterManager clusterManager = null;
        try {
            clusterManager = this.managerTemplate.cloneFromTemplate();
            clusterManager.setName(string);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("simpleTcpCluster.clustermanager.cloneFailed"), (Throwable)exception);
            clusterManager = new DeltaManager();
        }
        finally {
            if (clusterManager != null) {
                clusterManager.setCluster(this);
            }
        }
        return clusterManager;
    }

    public void registerManager(Manager manager) {
        if (!(manager instanceof ClusterManager)) {
            log.warn((Object)sm.getString("simpleTcpCluster.clustermanager.notImplement", new Object[]{manager}));
            return;
        }
        ClusterManager clusterManager = (ClusterManager)manager;
        this.fireLifecycleEvent(BEFORE_MANAGERREGISTER_EVENT, manager);
        String string = this.getManagerName(clusterManager.getName(), manager);
        clusterManager.setName(string);
        clusterManager.setCluster(this);
        this.managers.put(string, clusterManager);
        this.fireLifecycleEvent(AFTER_MANAGERREGISTER_EVENT, manager);
    }

    public void removeManager(Manager manager) {
        if (manager instanceof ClusterManager) {
            ClusterManager clusterManager = (ClusterManager)manager;
            this.fireLifecycleEvent(BEFORE_MANAGERUNREGISTER_EVENT, manager);
            this.managers.remove(this.getManagerName(clusterManager.getName(), manager));
            clusterManager.setCluster(null);
            this.fireLifecycleEvent(AFTER_MANAGERUNREGISTER_EVENT, manager);
        }
    }

    @Override
    public String getManagerName(String string, Manager manager) {
        Context context;
        Container container;
        String string2 = string;
        if (string2 == null) {
            string2 = manager.getContext().getName();
        }
        if (this.getContainer() instanceof Engine && (container = (context = manager.getContext()).getParent()) instanceof Host && string2 != null && !string2.startsWith(container.getName() + "#")) {
            string2 = container.getName() + "#" + string2;
        }
        return string2;
    }

    @Override
    public Manager getManager(String string) {
        return this.managers.get(string);
    }

    public void backgroundProcess() {
        if (this.clusterDeployer != null) {
            this.clusterDeployer.backgroundProcess();
        }
        if (this.isHeartbeatBackgroundEnabled() && this.channel != null) {
            this.channel.heartbeat();
        }
        this.fireLifecycleEvent("periodic", null);
    }

    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.clusterDeployer != null) {
            StringBuilder stringBuilder = new StringBuilder("type=Cluster");
            Container container = this.getContainer();
            if (container != null) {
                stringBuilder.append(container.getMBeanKeyProperties());
            }
            stringBuilder.append(",component=Deployer");
            this.onameClusterDeployer = this.register(this.clusterDeployer, stringBuilder.toString());
        }
    }

    protected void startInternal() throws LifecycleException {
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("simpleTcpCluster.start"));
        }
        try {
            this.checkDefaults();
            this.registerClusterValve();
            this.channel.addMembershipListener((MembershipListener)this);
            this.channel.addChannelListener((ChannelListener)this);
            this.channel.setName(this.getClusterName() + "-Channel");
            this.channel.start(this.channelStartOptions);
            if (this.clusterDeployer != null) {
                this.clusterDeployer.start();
            }
            this.registerMember(this.channel.getLocalMember(false));
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("simpleTcpCluster.startUnable"), (Throwable)exception);
            throw new LifecycleException((Throwable)exception);
        }
        this.setState(LifecycleState.STARTING);
    }

    protected void checkDefaults() {
        if (this.clusterListeners.size() == 0 && this.managerTemplate instanceof DeltaManager) {
            this.addClusterListener(new ClusterSessionListener());
        }
        if (this.valves.size() == 0) {
            this.addValve(new JvmRouteBinderValve());
            this.addValve(new ReplicationValve());
        }
        if (this.clusterDeployer != null) {
            this.clusterDeployer.setCluster(this);
        }
        if (this.channel == null) {
            this.channel = new GroupChannel();
        }
        if (this.channel instanceof GroupChannel && !((GroupChannel)this.channel).getInterceptors().hasNext()) {
            this.channel.addInterceptor((ChannelInterceptor)new MessageDispatchInterceptor());
            this.channel.addInterceptor((ChannelInterceptor)new TcpFailureDetector());
        }
        if (this.heartbeatBackgroundEnabled) {
            this.channel.setHeartbeat(false);
        }
    }

    protected void registerClusterValve() {
        if (this.container != null) {
            for (ClusterValve clusterValve : this.valves) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Invoking addValve on " + this.getContainer() + " with class=" + clusterValve.getClass().getName()));
                }
                if (clusterValve == null) continue;
                this.container.getPipeline().addValve((Valve)clusterValve);
                clusterValve.setCluster(this);
            }
        }
    }

    protected void unregisterClusterValve() {
        for (ClusterValve clusterValve : this.valves) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invoking removeValve on " + this.getContainer() + " with class=" + clusterValve.getClass().getName()));
            }
            if (clusterValve == null) continue;
            this.container.getPipeline().removeValve((Valve)clusterValve);
            clusterValve.setCluster(null);
        }
    }

    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.unregisterMember(this.channel.getLocalMember(false));
        if (this.clusterDeployer != null) {
            this.clusterDeployer.stop();
        }
        this.managers.clear();
        try {
            if (this.clusterDeployer != null) {
                this.clusterDeployer.setCluster(null);
            }
            this.channel.stop(this.channelStartOptions);
            this.channel.removeChannelListener((ChannelListener)this);
            this.channel.removeMembershipListener((MembershipListener)this);
            this.unregisterClusterValve();
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("simpleTcpCluster.stopUnable"), (Throwable)exception);
        }
    }

    protected void destroyInternal() throws LifecycleException {
        if (this.onameClusterDeployer != null) {
            this.unregister(this.onameClusterDeployer);
            this.onameClusterDeployer = null;
        }
        super.destroyInternal();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append('[');
        if (this.container == null) {
            stringBuilder.append("Container is null");
        } else {
            stringBuilder.append(this.container.getName());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void send(ClusterMessage clusterMessage) {
        this.send(clusterMessage, null);
    }

    @Override
    public void send(ClusterMessage clusterMessage, Member member) {
        try {
            clusterMessage.setAddress(this.getLocalMember());
            int n = this.channelSendOptions;
            if (clusterMessage instanceof SessionMessage && ((SessionMessage)clusterMessage).getEventType() == 12) {
                n = 6;
            }
            if (member != null) {
                if (!this.getLocalMember().equals(member)) {
                    this.channel.send(new Member[]{member}, (Serializable)clusterMessage, n);
                } else {
                    log.error((Object)sm.getString("simpleTcpCluster.unableSend.localMember", new Object[]{clusterMessage}));
                }
            } else {
                Member[] memberArray = this.channel.getMembers();
                if (memberArray.length > 0) {
                    this.channel.send(memberArray, (Serializable)clusterMessage, n);
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("No members in cluster, ignoring message:" + clusterMessage));
                }
            }
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("simpleTcpCluster.sendFailed"), (Throwable)exception);
        }
    }

    public void memberAdded(Member member) {
        try {
            this.hasMembers = this.channel.hasMembers();
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("simpleTcpCluster.member.added", new Object[]{member}));
            }
            this.fireLifecycleEvent(BEFORE_MEMBERREGISTER_EVENT, member);
            this.registerMember(member);
            this.fireLifecycleEvent(AFTER_MEMBERREGISTER_EVENT, member);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("simpleTcpCluster.member.addFailed"), (Throwable)exception);
        }
    }

    public void memberDisappeared(Member member) {
        try {
            this.hasMembers = this.channel.hasMembers();
            if (log.isInfoEnabled()) {
                log.info((Object)sm.getString("simpleTcpCluster.member.disappeared", new Object[]{member}));
            }
            this.fireLifecycleEvent(BEFORE_MEMBERUNREGISTER_EVENT, member);
            this.unregisterMember(member);
            this.fireLifecycleEvent(AFTER_MEMBERUNREGISTER_EVENT, member);
        }
        catch (Exception exception) {
            log.error((Object)sm.getString("simpleTcpCluster.member.removeFailed"), (Throwable)exception);
        }
    }

    public boolean accept(Serializable serializable, Member member) {
        return serializable instanceof ClusterMessage;
    }

    public void messageReceived(Serializable serializable, Member member) {
        ClusterMessage clusterMessage = (ClusterMessage)serializable;
        clusterMessage.setAddress(member);
        this.messageReceived(clusterMessage);
    }

    public void messageReceived(ClusterMessage clusterMessage) {
        if (log.isDebugEnabled() && clusterMessage != null) {
            log.debug((Object)("Assuming clocks are synched: Replication for " + clusterMessage.getUniqueId() + " took=" + (System.currentTimeMillis() - clusterMessage.getTimestamp()) + " ms."));
        }
        boolean bl = false;
        if (clusterMessage != null) {
            for (ClusterListener clusterListener : this.clusterListeners) {
                if (!clusterListener.accept(clusterMessage)) continue;
                bl = true;
                clusterListener.messageReceived(clusterMessage);
            }
            if (!bl && this.notifyLifecycleListenerOnFailure) {
                Member member = clusterMessage.getAddress();
                this.fireLifecycleEvent(RECEIVE_MESSAGE_FAILURE_EVENT, new SendMessageData(clusterMessage, member, null));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Message " + clusterMessage.toString() + " from type " + clusterMessage.getClass().getName() + " transferred but no listener registered"));
                }
            }
        }
    }

    public int getChannelStartOptions() {
        return this.channelStartOptions;
    }

    public void setChannelStartOptions(int n) {
        this.channelStartOptions = n;
    }

    protected String getDomainInternal() {
        Container container = this.getContainer();
        if (container == null) {
            return null;
        }
        return container.getDomain();
    }

    protected String getObjectNameKeyProperties() {
        StringBuilder stringBuilder = new StringBuilder("type=Cluster");
        Container container = this.getContainer();
        if (container != null) {
            stringBuilder.append(container.getMBeanKeyProperties());
        }
        return stringBuilder.toString();
    }

    private void registerMember(Member member) {
        StringBuilder stringBuilder = new StringBuilder("type=Cluster");
        Container container = this.getContainer();
        if (container != null) {
            stringBuilder.append(container.getMBeanKeyProperties());
        }
        stringBuilder.append(",component=Member,name=");
        stringBuilder.append(ObjectName.quote(member.getName()));
        ObjectName objectName = this.register(member, stringBuilder.toString());
        this.memberOnameMap.put(member, objectName);
    }

    private void unregisterMember(Member member) {
        if (member == null) {
            return;
        }
        ObjectName objectName = this.memberOnameMap.remove(member);
        if (objectName != null) {
            this.unregister(objectName);
        }
    }
}

