/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.stacktrace.graph;

import java.util.Collection;
import java.util.LinkedList;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.flightrecorder.stacktrace.FrameSeparator;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.Edge;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.Node;
import org.openjdk.jmc.flightrecorder.stacktrace.graph.StacktraceGraphModel;

public final class GraphModelUtils {
    public static final FrameSeparator DEFAULT_FRAME_SEPARATOR = new FrameSeparator(FrameSeparator.FrameCategorization.METHOD, false);

    public static String printGraph(StacktraceGraphModel model) {
        StringBuilder builder = new StringBuilder();
        builder.append("=== Graph Printout ===\n");
        GraphModelUtils.printNodes(builder, model.getNodes());
        GraphModelUtils.printLinks(builder, model.getEdges());
        return builder.toString();
    }

    public static String getTypeNames(IItemCollection items) {
        LinkedList typeNames = new LinkedList();
        items.forEach(iterable -> typeNames.add(iterable.getType().getName()));
        return String.join((CharSequence)", ", typeNames);
    }

    private static void printLinks(StringBuilder builder, Collection<Edge> edges) {
        builder.append("Number of edges:");
        builder.append(edges.size());
        builder.append("\n");
    }

    private static void printNodes(StringBuilder builder, Collection<Node> nodes) {
        builder.append("Number of nodes:");
        builder.append(nodes.size());
        builder.append("\n");
    }
}

