/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.Autoscroll;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.UIResource;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.openide.awt.MouseUtils;
import org.openide.awt.QuickSearch;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.AutoscrollSupport;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.ExplorerDnDManager;
import org.openide.explorer.view.NodeRenderer;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.explorer.view.TreeViewDragSupport;
import org.openide.explorer.view.TreeViewDropSupport;
import org.openide.explorer.view.ViewTooltips;
import org.openide.explorer.view.ViewUtil;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerChildren;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class TreeView
extends JScrollPane {
    static final Logger LOG;
    static final long serialVersionUID = -1639001987693376168L;
    private static final int TIME_TO_COLLAPSE;
    private static final int MIN_TREEVIEW_WIDTH = 400;
    private static final int MIN_TREEVIEW_HEIGHT = 400;
    protected transient JTree tree;
    transient NodeTreeModel treeModel;
    transient ExplorerManager manager;
    transient PopupSupport defaultActionListener;
    transient boolean defaultActionEnabled;
    transient PopupAdapter popupListener;
    transient TreePropertyListener managerListener = null;
    transient PropertyChangeListener wlpc;
    transient VetoableChangeListener wlvc;
    private transient boolean dragActive = true;
    private transient boolean dropActive = true;
    transient TreeViewDragSupport dragSupport;
    transient TreeViewDropSupport dropSupport;
    transient boolean dropTargetPopupAllowed = true;
    private transient int allowedDragActions = 0x40000003;
    private transient int allowedDropActions = 0x40000003;
    private transient QuickSearch qs;
    private transient boolean autoWaitCursor = true;
    private final VisualizerHolder visHolder = new VisualizerHolder();
    private static Reference<TreeView> lastSearchField;
    private transient boolean removedNodeWasSelected = false;
    TreePath[] origSelectionPaths = null;
    private Component searchPanel = null;
    private final Object searchConstraints = new Object();

    public TreeView() {
        this(true, true);
    }

    public TreeView(boolean bl, boolean bl2) {
        this.setLayout(new ExplorerScrollPaneLayout());
        this.initializeTree();
        this.setDropTarget(DragDropUtilities.dragAndDropEnabled);
        this.setPopupAllowed(bl2);
        this.setDefaultActionAllowed(bl);
        Dimension dimension = null;
        try {
            dimension = this.getPreferredSize();
            if (dimension == null) {
                dimension = new Dimension(400, 400);
            }
        }
        catch (NullPointerException nullPointerException) {
            dimension = new Dimension(400, 400);
        }
        if (dimension.width < 400) {
            dimension.width = 400;
        }
        if (dimension.height < 400) {
            dimension.height = 400;
        }
        this.setPreferredSize(dimension);
    }

    @Override
    public void updateUI() {
        VisualizerHolder visualizerHolder = this.visHolder;
        if (visualizerHolder != null) {
            visualizerHolder.clear();
        }
        super.updateUI();
        this.setViewportBorder(BorderFactory.createEmptyBorder());
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    void initializeTree() {
        this.treeModel = this.createModel();
        this.treeModel.addView(this);
        this.tree = new ExplorerTree(this.treeModel);
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        NodeRenderer nodeRenderer = new NodeRenderer();
        this.tree.setCellRenderer(nodeRenderer);
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.setViewportView(this.tree);
        this.tree.setCellEditor(new TreeViewCellEditor(this.tree));
        this.tree.setEditable(true);
        this.tree.setInvokesStopCellEditing(true);
        int n = nodeRenderer.getTreeCellRendererComponent((JTree)this.tree, null, (boolean)false, (boolean)false, (boolean)false, (int)0, (boolean)true).getPreferredSize().height;
        this.tree.setRowHeight(n);
        this.tree.setLargeModel(true);
        this.setSelectionMode(4);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.managerListener = new TreePropertyListener();
        this.tree.addTreeExpansionListener(this.managerListener);
        this.tree.addTreeWillExpandListener(this.managerListener);
        this.setRequestFocusEnabled(false);
        this.defaultActionListener = new PopupSupport();
        this.getInputMap(0).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        this.getActionMap().put("org.openide.actions.PopupAction", this.defaultActionListener.popup);
        this.tree.addFocusListener(this.defaultActionListener);
        this.tree.addMouseListener(this.defaultActionListener);
    }

    public boolean isPopupAllowed() {
        return this.popupListener != null && this.isShowing() && this.isDisplayable();
    }

    public void setPopupAllowed(boolean bl) {
        if (this.popupListener == null && bl) {
            this.popupListener = new PopupAdapter();
            this.tree.addMouseListener((MouseListener)((Object)this.popupListener));
            return;
        }
        if (this.popupListener != null && !bl) {
            this.tree.removeMouseListener((MouseListener)((Object)this.popupListener));
            this.popupListener = null;
            return;
        }
    }

    void setDropTargetPopupAllowed(boolean bl) {
        this.dropTargetPopupAllowed = bl;
        if (this.dropSupport != null) {
            this.dropSupport.setDropTargetPopupAllowed(bl);
        }
    }

    boolean isDropTargetPopupAllowed() {
        return this.dropSupport != null ? this.dropSupport.isDropTargetPopupAllowed() : this.dropTargetPopupAllowed;
    }

    public boolean isDefaultActionEnabled() {
        return this.defaultActionEnabled;
    }

    @Override
    public void requestFocus() {
        this.tree.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.tree.requestFocusInWindow();
    }

    public void setDefaultActionAllowed(boolean bl) {
        this.defaultActionEnabled = bl;
        if (bl) {
            this.tree.registerKeyboardAction(this.defaultActionListener, KeyStroke.getKeyStroke(10, 0, false), 0);
        } else {
            this.tree.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        }
    }

    public boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    public void setRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
        this.tree.setShowsRootHandles(!bl);
    }

    public void setScrollsOnExpand(boolean bl) {
        this.tree.setScrollsOnExpand(bl);
    }

    public boolean getScrollsOnExpand() {
        return this.tree.getScrollsOnExpand();
    }

    public boolean isQuickSearchAllowed() {
        return this.qs.isEnabled();
    }

    public void setQuickSearchAllowed(boolean bl) {
        this.qs.setEnabled(bl);
    }

    @Deprecated
    public void setUseSubstringInQuickSearch(boolean bl) {
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean bl) {
        if (bl && this.dragSupport == null) {
            this.dragSupport = new TreeViewDragSupport(this, this.tree);
        }
        this.dragActive = bl;
        if (this.dragSupport != null && !GraphicsEnvironment.isHeadless()) {
            this.dragSupport.activate(this.dragActive);
        }
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean bl) {
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new TreeViewDropSupport(this, this.tree, this.dropTargetPopupAllowed);
        }
        this.dropActive = bl;
        if (this.dropSupport != null && !GraphicsEnvironment.isHeadless()) {
            this.dropSupport.activate(this.dropActive);
        }
    }

    public int getAllowedDragActions() {
        return this.allowedDragActions;
    }

    public void setAllowedDragActions(int n) {
        this.allowedDragActions = n;
    }

    public int getAllowedDropActions() {
        return this.allowedDropActions;
    }

    public void setAllowedDropActions(int n) {
        this.allowedDropActions = n;
    }

    public void collapseNode(final Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        VisualizerNode.runSafe(new Runnable(){

            @Override
            public void run() {
                TreePath treePath = TreeView.this.getTreePath(node);
                LOG.log(Level.FINE, "collapseNode: {0} {1}", new Object[]{node, treePath});
                TreeView.this.tree.collapsePath(treePath);
                LOG.fine("collapsePath done");
            }
        });
    }

    public void expandNode(final Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.lookupExplorerManager();
        final List list = node.getChildren().snapshot();
        VisualizerNode.runSafe(new Runnable(){

            @Override
            public void run() {
                LOG.log(Level.FINEST, "Just print the variable so it is not GCed: {0}", list);
                TreePath treePath = TreeView.this.getTreePath(node);
                LOG.log(Level.FINE, "expandNode: {0} {1}", new Object[]{node, treePath});
                TreeView.this.tree.expandPath(treePath);
                LOG.fine("expandPath done");
            }
        });
    }

    public boolean isExpanded(Node node) {
        return this.tree.isExpanded(this.getTreePath(node));
    }

    public void expandAll() {
        try {
            this.tree.setUI(null);
            TreeNode treeNode = (TreeNode)this.tree.getModel().getRoot();
            this.expandOrCollapseAll(new TreePath(treeNode), true);
        }
        finally {
            this.tree.updateUI();
        }
    }

    private void expandOrCollapseAll(TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() > 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandOrCollapseAll(treePath2, bl);
            }
        }
        if (bl) {
            this.tree.expandPath(treePath);
        } else {
            this.tree.collapsePath(treePath);
        }
    }

    @Override
    public void validate() {
        Children.MUTEX.readAccess(new Runnable(){

            @Override
            public void run() {
                TreeView.super.validate();
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.lookupExplorerManager();
    }

    private void lookupExplorerManager() {
        ExplorerManager explorerManager = ExplorerManager.find(this);
        if (explorerManager != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = explorerManager;
            this.wlvc = WeakListeners.vetoableChange((VetoableChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListeners.propertyChange((PropertyChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.synchronizeRootContext();
            this.synchronizeExploredContext();
            this.synchronizeSelectedNodes();
        }
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
        this.tree.getSelectionModel().addTreeSelectionListener(this.managerListener);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.tree.getSelectionModel().removeTreeSelectionListener(this.managerListener);
    }

    protected abstract NodeTreeModel createModel();

    protected abstract void selectionChanged(Node[] var1, ExplorerManager var2) throws PropertyVetoException;

    protected abstract boolean selectionAccept(Node[] var1);

    protected abstract void showPath(TreePath var1);

    protected abstract void showSelection(TreePath[] var1);

    protected boolean useExploredContextMenu() {
        return false;
    }

    private boolean isSelectionModeBroken(Node[] nodeArray) {
        if (nodeArray.length <= 1 || this.getSelectionMode() == 4) {
            return false;
        }
        if (this.getSelectionMode() == 1) {
            return true;
        }
        TreePath[] treePathArray = new TreePath[nodeArray.length];
        RowMapper rowMapper = this.tree.getSelectionModel().getRowMapper();
        if (rowMapper == null) {
            return false;
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(3);
        for (int i = 0; i < nodeArray.length; ++i) {
            arrayList.clear();
            Node node = nodeArray[i];
            while (node.getParentNode() != null) {
                if (!this.isExpanded(node)) {
                    arrayList.add(node);
                }
                node = node.getParentNode();
            }
            for (int j = arrayList.size() - 1; j >= 0; --j) {
                this.expandNode((Node)arrayList.get(j));
            }
            treePathArray[i] = this.getTreePath(nodeArray[i]);
        }
        int[] nArray = rowMapper.getRowsForPaths(treePathArray);
        Arrays.sort(nArray);
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == nArray[i - 1] + 1) continue;
            return true;
        }
        return false;
    }

    TreePath getTreePath(Node node) {
        return new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
    }

    final void callSelectionChanged(Node[] nodeArray) {
        this.manager.removePropertyChangeListener(this.wlpc);
        this.manager.removeVetoableChangeListener(this.wlvc);
        try {
            this.selectionChanged(nodeArray, this.manager);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.synchronizeSelectedNodes();
        }
        finally {
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
        }
    }

    final void synchronizeRootContext() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                TreeCellEditor treeCellEditor = TreeView.this.tree.getCellEditor();
                if (treeCellEditor instanceof TreeViewCellEditor) {
                    ((TreeViewCellEditor)treeCellEditor).abortTimer();
                }
                TreeView.this.tree.cancelEditing();
                Node node = TreeView.this.manager.getRootContext();
                LOG.log(Level.FINE, "synchronizeRootContext {0}", node);
                TreeView.this.treeModel.setNode(node, TreeView.this.visHolder);
            }
        });
    }

    final void synchronizeExploredContext() {
        final Node node = this.manager.getExploredContext();
        if (node == null) {
            return;
        }
        VisualizerNode.runSafe(new Runnable(){

            @Override
            public void run() {
                TreePath treePath = TreeView.this.getTreePath(node);
                LOG.log(Level.FINE, "synchronizeExploredContext {0} path {1}", new Object[]{node, treePath});
                TreeView.this.showPath(treePath);
            }
        });
    }

    public void setSelectionMode(int n) {
        this.tree.getSelectionModel().setSelectionMode(n);
    }

    public int getSelectionMode() {
        return this.tree.getSelectionModel().getSelectionMode();
    }

    public void setAutoWaitCursor(boolean bl) {
        this.autoWaitCursor = bl;
    }

    private void showWaitCursor(boolean bl) {
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            TreeView.doShowWaitCursor(jRootPane.getGlassPane(), bl);
        } else {
            SwingUtilities.invokeLater(new CursorR(jRootPane.getGlassPane(), bl));
        }
    }

    private static void doShowWaitCursor(Component component, boolean bl) {
        if (bl) {
            component.setCursor(Cursor.getPredefinedCursor(3));
            component.setVisible(true);
        } else {
            component.setVisible(false);
            component.setCursor(null);
        }
    }

    private void prepareWaitCursor(final Node node) {
        if (node == null || !this.autoWaitCursor) {
            return;
        }
        this.showWaitCursor(true);
        ViewUtil.uiProcessor().post(new Runnable(){

            @Override
            public void run() {
                try {
                    node.getChildren().getNodesCount(true);
                }
                catch (Exception exception) {
                    LOG.log(Level.WARNING, null, exception);
                }
                finally {
                    TreeView.this.showWaitCursor(false);
                }
            }
        });
    }

    final void synchronizeSelectedNodes() {
        VisualizerNode.runSafe(new Runnable(){

            @Override
            public void run() {
                Node[] nodeArray = TreeView.this.manager.getSelectedNodes();
                TreePath[] treePathArray = new TreePath[nodeArray.length];
                boolean bl = LOG.isLoggable(Level.FINE);
                if (bl) {
                    LOG.log(Level.FINE, "synchronizeSelectedNodes: {0}", nodeArray.length);
                }
                for (int i = 0; i < nodeArray.length; ++i) {
                    treePathArray[i] = TreeView.this.getTreePath(nodeArray[i]);
                    if (!bl) continue;
                    LOG.log(Level.FINE, "paths[{0}] = {1} node: {2}", new Object[]{i, treePathArray[i], nodeArray[i]});
                }
                TreeView.this.tree.getSelectionModel().removeTreeSelectionListener(TreeView.this.managerListener);
                TreeView.this.showSelection(treePathArray);
                TreeView.this.tree.getSelectionModel().addTreeSelectionListener(TreeView.this.managerListener);
                if (bl) {
                    LOG.fine("synchronizeSelectedNodes done");
                }
            }
        });
    }

    void scrollTreeToVisible(TreePath treePath, TreeNode treeNode) {
        Rectangle rectangle = this.tree.getVisibleRect();
        Rectangle rectangle2 = this.tree.getPathBounds(treePath);
        Rectangle rectangle3 = this.tree.getPathBounds(new TreePath(this.treeModel.getPathToRoot(treeNode)));
        if (rectangle != null && rectangle2 != null && rectangle3 != null) {
            this.tree.scrollRectToVisible(new Rectangle(rectangle.x, rectangle2.y, 1, rectangle3.y - rectangle2.y + rectangle3.height));
        }
    }

    private void createPopup(int n, int n2, JPopupMenu jPopupMenu) {
        if (jPopupMenu.getSubElements().length > 0) {
            jPopupMenu.show(this, n, n2);
        }
    }

    void createPopup(int n, int n2) {
        if (this.isPopupAllowed()) {
            JPopupMenu jPopupMenu;
            Node[] nodeArray = this.manager.getSelectedNodes();
            if (nodeArray.length > 0) {
                Action[] actionArray = NodeOp.findActions((Node[])nodeArray);
                if (actionArray.length > 0) {
                    this.createPopup(n, n2, Utilities.actionsToPopup((Action[])actionArray, (Component)this));
                }
            } else if (this.manager.getRootContext() != null && (jPopupMenu = this.manager.getRootContext().getContextMenu()) != null) {
                this.createPopup(n, n2, jPopupMenu);
            }
        }
    }

    void createExtendedPopup(int n, int n2, JMenu jMenu) {
        Node[] nodeArray = this.manager.getSelectedNodes();
        JPopupMenu jPopupMenu = null;
        if (nodeArray.length > 0) {
            Action[] actionArray = NodeOp.findActions((Node[])nodeArray);
            jPopupMenu = Utilities.actionsToPopup((Action[])actionArray, (Component)this);
        } else if (this.manager.getRootContext() != null) {
            jPopupMenu = this.manager.getRootContext().getContextMenu();
        }
        boolean bl = false;
        if (jPopupMenu == null) {
            jPopupMenu = SystemAction.createPopupMenu((SystemAction[])new SystemAction[0]);
        }
        jPopupMenu.add(jMenu);
        this.createPopup(n, n2, jPopupMenu);
    }

    Point getPositionForPopup() {
        int n = this.tree.getLeadSelectionRow();
        if (n < 0) {
            return null;
        }
        Rectangle rectangle = this.tree.getRowBounds(n);
        if (rectangle == null) {
            return null;
        }
        Point point = new Point(rectangle.x, rectangle.y);
        point = SwingUtilities.convertPoint(this.tree, point, this);
        return point;
    }

    static Action takeAction(Action action, Node ... nodeArray) {
        if (action instanceof ContextAwareAction) {
            Lookup lookup = TreeView.getLookupFor(nodeArray);
            Action action2 = ((ContextAwareAction)action).createContextAwareInstance(lookup);
            assert (action2 != action) : "Cannot be same. ContextAwareAction:  " + action + ", ContextAwareInstance: " + action2;
            action = action2;
        }
        return action;
    }

    private static Lookup getLookupFor(Node ... nodeArray) {
        if (nodeArray.length == 1) {
            Lookup lookup = nodeArray[0].getLookup();
            Object object = lookup.lookup(nodeArray[0].getClass());
            if (!nodeArray[0].equals(object)) {
                lookup = new ProxyLookup(new Lookup[]{Lookups.singleton((Object)nodeArray[0]), lookup});
            }
            return lookup;
        }
        Lookup[] lookupArray = new Lookup[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            lookupArray[i] = nodeArray[i].getLookup();
        }
        ProxyLookup proxyLookup = new ProxyLookup(lookupArray);
        HashSet<Node> hashSet = new HashSet<Node>(Arrays.asList(nodeArray));
        hashSet.removeAll(proxyLookup.lookupAll(Node.class));
        if (!hashSet.isEmpty()) {
            proxyLookup = new ProxyLookup(new Lookup[]{proxyLookup, Lookups.fixed((Object[])hashSet.toArray(new Node[hashSet.size()]))});
        }
        return proxyLookup;
    }

    static TreePath findSiblingTreePath(TreePath treePath, int[] nArray) {
        TreePath treePath2;
        if (nArray == null) {
            throw new IllegalArgumentException("Indexes of changed children are null.");
        }
        if (treePath == null) {
            throw new IllegalArgumentException("The tree path to parent is null.");
        }
        if (nArray.length == 0) {
            return null;
        }
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        Object[] objectArray = treePath.getPath();
        int n = treeNode.getChildCount();
        if (n > 0) {
            int n2 = objectArray.length + 1;
            Object[] objectArray2 = new Object[n2];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            int n3 = Math.min(nArray[0], n - 1);
            objectArray2[n2 - 1] = treeNode.getChildAt(n3);
            treePath2 = new TreePath(objectArray2);
        } else {
            treePath2 = new TreePath(objectArray);
        }
        return treePath2;
    }

    void removedNodes(List<VisualizerNode> list) {
        TreeSelectionModel treeSelectionModel = this.tree.getSelectionModel();
        TreePath[] treePathArray = treeSelectionModel != null ? treeSelectionModel.getSelectionPaths() : null;
        ArrayList<TreePath> arrayList = null;
        for (VisualizerNode visualizerNode : list) {
            this.visHolder.removeRecur(visualizerNode.getChildren(false));
            if (treePathArray == null) continue;
            TreePath treePath = new TreePath(visualizerNode.getPathToRoot());
            for (TreePath treePath2 : treePathArray) {
                if (!treePath.isDescendant(treePath2)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<TreePath>();
                }
                arrayList.add(treePath2);
            }
        }
        boolean bl = this.removedNodeWasSelected = arrayList != null;
        if (arrayList != null) {
            try {
                treeSelectionModel.removeSelectionPaths(arrayList.toArray(new TreePath[arrayList.size()]));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    Node getOriginalNode(Node node) {
        return node;
    }

    static void performPreferredActionOnNodes(Node[] node) {
        if (((Node[])node).length > 0) {
            Action action = node[0].getPreferredAction();
            if (action == null) {
                return;
            }
            for (int i = 1; i < ((Node[])node).length; ++i) {
                Action action2 = node[i].getPreferredAction();
                if (action2 != null && action2.equals(action)) continue;
                return;
            }
            if ((action = TreeView.takeAction(action, (Node[])node)) != null && action.isEnabled()) {
                action.actionPerformed(new ActionEvent(((Node[])node).length == 1 ? node[0] : node, 1001, ""));
            } else {
                Utilities.disabledActionBeep();
            }
        }
    }

    @Override
    public void add(Component component, Object object) {
        if (object == this.searchConstraints) {
            this.searchPanel = component;
            object = null;
        }
        super.add(component, object);
    }

    @Override
    public void remove(Component component) {
        if (component == this.searchPanel) {
            this.searchPanel = null;
        }
        super.remove(component);
    }

    @Override
    public Insets getInsets() {
        Insets insets = this.getInnerInsets();
        insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        if (null != this.searchPanel && this.searchPanel.isVisible()) {
            insets.bottom += this.searchPanel.getPreferredSize().height;
        }
        return insets;
    }

    private Insets getInnerInsets() {
        Insets insets = super.getInsets();
        if (null == insets) {
            insets = new Insets(0, 0, 0, 0);
        }
        return insets;
    }

    Component getSearchPanel() {
        return this.searchPanel;
    }

    static {
        UIManager.put("Tree.scrollsHorizontallyAndVertically", Boolean.TRUE);
        LOG = Logger.getLogger(TreeView.class.getName());
        TIME_TO_COLLAPSE = System.getProperty("netbeans.debug.heap") != null ? 0 : 15000;
        lastSearchField = new WeakReference<Object>(null);
    }

    static class VisualizerHolder
    extends HashSet<VisualizerChildren> {
        VisualizerHolder() {
        }

        void removeRecur(VisualizerChildren visualizerChildren) {
            Enumeration<VisualizerNode> enumeration = visualizerChildren.children(false);
            while (enumeration.hasMoreElements()) {
                VisualizerNode visualizerNode = enumeration.nextElement();
                if (visualizerNode == null) continue;
                this.removeRecur(visualizerNode.getChildren(false));
            }
            this.remove(visualizerChildren);
        }
    }

    private static class DummyTransferHandler
    extends TransferHandler {
        private DummyTransferHandler() {
        }

        @Override
        public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        }

        @Override
        public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) throws IllegalStateException {
        }

        @Override
        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return false;
        }

        @Override
        public boolean importData(JComponent jComponent, Transferable transferable) {
            return false;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 3;
        }
    }

    private final class ExplorerTree
    extends JTree
    implements Autoscroll,
    QuickSearch.Callback {
        AutoscrollSupport support;
        private String maxPrefix;
        int SEARCH_FIELD_SPACE;
        private boolean firstPaint;
        private List<TreePath> searchResults;
        private int currentSelectionIndex;
        private String lastSearchText;
        private boolean registered;

        ExplorerTree(TreeModel treeModel) {
            super(treeModel);
            this.SEARCH_FIELD_SPACE = 3;
            this.firstPaint = true;
            this.searchResults = new ArrayList<TreePath>();
            this.registered = false;
            this.toggleClickCount = 0;
            this.getInputMap().put(KeyStroke.getKeyStroke("control C"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("control V"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("control X"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("COPY"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("PASTE"), "none");
            this.getInputMap().put(KeyStroke.getKeyStroke("CUT"), "none");
            if (Utilities.isMac()) {
                this.getInputMap().put(KeyStroke.getKeyStroke(67, 4), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke(88, 4), "none");
                this.getInputMap().put(KeyStroke.getKeyStroke(86, 4), "none");
            }
            this.setupSearch();
            if (!GraphicsEnvironment.isHeadless()) {
                this.setDragEnabled(true);
            }
        }

        @Override
        public void addNotify() {
            super.addNotify();
            if (!this.registered) {
                ViewTooltips.register(this);
                this.registered = true;
            }
            ViewUtil.adjustBackground(this);
        }

        @Override
        public void removeNotify() {
            super.removeNotify();
            if (this.registered) {
                ViewTooltips.unregister(this);
                this.registered = false;
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.setBorder(BorderFactory.createEmptyBorder());
            if (this.getTransferHandler() != null && this.getTransferHandler() instanceof UIResource) {
                this.setTransferHandler(new DummyTransferHandler());
            }
        }

        private void calcRowHeight(Graphics graphics) {
            int n = Math.max(18, 2 + graphics.getFontMetrics(this.getFont()).getHeight());
            String string = System.getProperty("nb.cellrenderer.fixedheight");
            if (string != null) {
                try {
                    n = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.getRowHeight() != n) {
                this.setRowHeight(n);
            } else {
                this.revalidate();
                this.repaint();
            }
        }

        @Override
        public Rectangle getRowBounds(int n) {
            Rectangle rectangle = super.getRowBounds(n);
            if (rectangle == null) {
                LOG.log(Level.WARNING, "No bounds for row {0} in three view: {1}", new Object[]{n, this});
                return new Rectangle();
            }
            return rectangle;
        }

        @Override
        public void paint(Graphics graphics) {
            new GuardedActions(0, graphics);
        }

        @Override
        protected void validateTree() {
            new GuardedActions(1, null);
        }

        @Override
        public void doLayout() {
            new GuardedActions(2, null);
        }

        private void guardedPaint(Graphics graphics) {
            if (this.firstPaint) {
                this.firstPaint = false;
                this.calcRowHeight(graphics);
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                return;
            }
            try {
                ExplorerTree.super.paint(graphics);
            }
            catch (NullPointerException nullPointerException) {
                LOG.log(Level.INFO, "Problems while painting", nullPointerException);
            }
        }

        private void guardedValidateTree() {
            super.validateTree();
        }

        private void guardedDoLayout() {
            super.doLayout();
        }

        @Override
        public void setFont(Font font) {
            if (font != this.getFont()) {
                this.firstPaint = true;
                super.setFont(font);
            }
        }

        @Override
        protected void processFocusEvent(FocusEvent focusEvent) {
            new GuardedActions(3, focusEvent);
        }

        @Override
        protected void processKeyEvent(KeyEvent keyEvent) {
            TreeView.this.qs.processKeyEvent(keyEvent);
            if (!keyEvent.isConsumed()) {
                super.processKeyEvent(keyEvent);
            }
        }

        private void repaintSelection() {
            int n = this.getSelectionModel().getMinSelectionRow();
            int n2 = this.getSelectionModel().getMaxSelectionRow();
            if (n != -1) {
                if (n == n2) {
                    Rectangle rectangle = this.getRowBounds(n);
                    if (rectangle == null) {
                        this.repaint();
                        return;
                    }
                    this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                } else {
                    Rectangle rectangle = this.getRowBounds(n);
                    Rectangle rectangle2 = this.getRowBounds(n2);
                    if (rectangle == null || rectangle2 == null) {
                        this.repaint();
                        return;
                    }
                    Rectangle rectangle3 = new Rectangle();
                    rectangle3.x = Math.min(rectangle.x, rectangle2.x);
                    rectangle3.y = rectangle.y;
                    rectangle3.width = this.getWidth();
                    rectangle3.height = rectangle2.y + rectangle2.height - rectangle.y;
                    this.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                }
            }
        }

        private void setupSearch() {
            TreeView.this.qs = QuickSearch.attach((JComponent)TreeView.this, (Object)TreeView.this.searchConstraints, (QuickSearch.Callback)this);
        }

        public void quickSearchUpdate(String string) {
            this.lastSearchText = string;
            this.currentSelectionIndex = 0;
            this.searchResults.clear();
            this.maxPrefix = null;
            String string2 = string.toUpperCase();
            TreeView.this.origSelectionPaths = this.getSelectionPaths();
            if (TreeView.this.origSelectionPaths != null && TreeView.this.origSelectionPaths.length == 0) {
                TreeView.this.origSelectionPaths = null;
            }
            if (string2.length() > 0) {
                this.searchResults = this.doSearch(string2);
            }
            this.displaySearchResult();
        }

        public void showNextSelection(boolean bl) {
            this.currentSelectionIndex = bl ? ++this.currentSelectionIndex : --this.currentSelectionIndex;
            this.displaySearchResult();
        }

        public String findMaxPrefix(String string) {
            return this.maxPrefix;
        }

        public void quickSearchConfirmed() {
            TreePath treePath = this.getSelectionPath();
            if (treePath != null) {
                TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
                Node node = Visualizer.findNode(treeNode);
                TreeView.performPreferredActionOnNodes(new Node[]{node});
            }
            TreeView.this.origSelectionPaths = null;
            this.searchResults.clear();
            this.lastSearchText = null;
        }

        public void quickSearchCanceled() {
            TreeView.this.origSelectionPaths = null;
            this.searchResults.clear();
            this.lastSearchText = null;
        }

        private List<TreePath> doSearch(String string) {
            ArrayList<TreePath> arrayList = new ArrayList<TreePath>();
            HashSet<TreePath> hashSet = new HashSet<TreePath>();
            int n = 0;
            int n2 = TreeView.this.origSelectionPaths != null ? Math.max(0, this.getRowForPath(TreeView.this.origSelectionPaths[0])) : 0;
            int n3 = this.getRowCount();
            if (n3 == 0) {
                return arrayList;
            }
            while (true) {
                SubstringSearchResult substringSearchResult;
                TreePath treePath;
                TreePath treePath2 = treePath = (substringSearchResult = this.getNextSubstringMatch(string, n2 %= n3, true)) != null ? substringSearchResult.treePath : null;
                if (treePath == null || hashSet.contains(treePath)) break;
                n2 = TreeView.this.tree.getRowForPath(treePath);
                boolean bl = true;
                if (substringSearchResult.index == 0) {
                    arrayList.add(n++, treePath);
                } else {
                    bl = false;
                    arrayList.add(treePath);
                }
                hashSet.add(treePath);
                if (bl) {
                    String string2 = ((VisualizerNode)treePath.getLastPathComponent()).getDisplayName();
                    if (this.maxPrefix == null) {
                        this.maxPrefix = string2;
                    }
                    this.maxPrefix = QuickSearch.findMaxPrefix((String)this.maxPrefix, (String)string2, (boolean)true);
                }
                ++n2;
            }
            return arrayList;
        }

        private SubstringSearchResult getNextSubstringMatch(String string, int n, boolean bl) {
            int n2 = this.getRowCount();
            if (string == null) {
                throw new IllegalArgumentException("Substring is null");
            }
            if (n < 0 || n >= n2) {
                throw new IllegalArgumentException("startingRow = " + n + " rowCount = " + n2);
            }
            string = string.toUpperCase();
            int n3 = bl ? 1 : -1;
            int n4 = n;
            do {
                TreePath treePath;
                String string2;
                int n5;
                if ((n5 = (string2 = this.convertValueToText((treePath = this.getPathForRow(n4)).getLastPathComponent(), this.isRowSelected(n4), this.isExpanded(n4), true, n4, false)).toUpperCase().indexOf(string)) < 0) continue;
                return new SubstringSearchResult(treePath, n5);
            } while ((n4 = (n4 + n3 + n2) % n2) != n);
            return null;
        }

        private void displaySearchResult() {
            int n = this.searchResults.size();
            if (n > 0) {
                if (this.currentSelectionIndex < 0) {
                    this.currentSelectionIndex = n - 1;
                } else if (this.currentSelectionIndex >= n) {
                    this.currentSelectionIndex = 0;
                }
                TreePath treePath = this.searchResults.get(this.currentSelectionIndex);
                this.setSelectionPath(treePath);
                this.scrollPathToVisible(treePath);
            } else if (this.lastSearchText.isEmpty() && TreeView.this.origSelectionPaths != null) {
                this.setSelectionPaths(TreeView.this.origSelectionPaths);
                this.scrollPathToVisible(TreeView.this.origSelectionPaths[0]);
            } else {
                this.clearSelection();
            }
        }

        @Override
        public void autoscroll(Point point) {
            this.getSupport().autoscroll(point);
        }

        @Override
        public Insets getAutoscrollInsets() {
            return this.getSupport().getAutoscrollInsets();
        }

        AutoscrollSupport getSupport() {
            if (this.support == null) {
                this.support = new AutoscrollSupport(this, new Insets(15, 10, 15, 10));
            }
            return this.support;
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            if (mouseEvent != null) {
                Point point = mouseEvent.getPoint();
                int n = this.getRowForLocation(point.x, point.y);
                if (n != -1) {
                    TreePath treePath = this.getPathForRow(n);
                    VisualizerNode visualizerNode = (VisualizerNode)treePath.getLastPathComponent();
                    String string = visualizerNode.getShortDescription();
                    String string2 = visualizerNode.getDisplayName();
                    if (string != null && !string.equals(string2)) {
                        return string;
                    }
                }
            }
            return null;
        }

        @Override
        protected TreeModelListener createTreeModelListener() {
            return new ModelHandler();
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleExplorerTree();
            }
            return this.accessibleContext;
        }

        private class SubstringSearchResult {
            TreePath treePath;
            int index;

            public SubstringSearchResult(TreePath treePath, int n) {
                this.treePath = treePath;
                this.index = n;
            }
        }

        private class ModelHandler
        extends JTree.TreeModelHandler {
            ModelHandler() {
                super(ExplorerTree.this);
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                TreePath[] treePathArray = ExplorerTree.this.getSelectionPaths();
                Enumeration<TreePath> enumeration = ExplorerTree.this.getExpandedDescendants(treeModelEvent.getTreePath());
                super.treeStructureChanged(treeModelEvent);
                if (enumeration != null) {
                    while (enumeration.hasMoreElements()) {
                        ExplorerTree.this.expandPath(enumeration.nextElement());
                    }
                }
                if (treePathArray != null && treePathArray.length > 0) {
                    boolean bl = ExplorerTree.this.isPathSelected(treePathArray[0]);
                    ExplorerTree.this.setSelectionPaths(treePathArray);
                    if (!bl) {
                        ExplorerTree.this.scrollPathToVisible(treePathArray[0]);
                    }
                }
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                super.treeNodesRemoved(treeModelEvent);
                boolean bl = TreeView.this.removedNodeWasSelected;
                TreeView.this.removedNodeWasSelected = false;
                if (ExplorerDnDManager.getDefault().isDnDActive()) {
                    return;
                }
                if (bl && TreeView.this.tree.getSelectionCount() == 0) {
                    TreePath treePath = TreeView.findSiblingTreePath(treeModelEvent.getTreePath(), treeModelEvent.getChildIndices());
                    if (treePath == null || treeModelEvent.getChildIndices().length == 0) {
                        return;
                    }
                    if (treePath.getPathCount() > 0) {
                        TreeView.this.tree.setSelectionPath(treePath);
                    }
                }
            }
        }

        private class AccessibleExplorerTree
        extends JTree.AccessibleJTree {
            AccessibleExplorerTree() {
                super(ExplorerTree.this);
            }

            @Override
            public String getAccessibleName() {
                return TreeView.this.getAccessibleContext().getAccessibleName();
            }

            @Override
            public String getAccessibleDescription() {
                return TreeView.this.getAccessibleContext().getAccessibleDescription();
            }
        }

        private class GuardedActions
        implements Mutex.Action<Object> {
            private int type;
            private Object p1;
            final Object ret;

            public GuardedActions(int n, Object object) {
                this.type = n;
                this.p1 = object;
                this.ret = Children.MUTEX.isReadAccess() || Children.MUTEX.isWriteAccess() ? this.run() : Children.MUTEX.readAccess((Mutex.Action)this);
            }

            public Object run() {
                switch (this.type) {
                    case 0: {
                        ExplorerTree.this.guardedPaint((Graphics)this.p1);
                        break;
                    }
                    case 1: {
                        ExplorerTree.this.guardedValidateTree();
                        break;
                    }
                    case 2: {
                        ExplorerTree.this.guardedDoLayout();
                        break;
                    }
                    case 3: {
                        ExplorerTree.super.processFocusEvent((FocusEvent)this.p1);
                        ExplorerTree.this.repaintSelection();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("type: " + this.type);
                    }
                }
                return null;
            }
        }
    }

    private class ExplorerScrollPaneLayout
    extends ScrollPaneLayout {
        private ExplorerScrollPaneLayout() {
        }

        @Override
        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            if (null != TreeView.this.searchPanel && TreeView.this.searchPanel.isVisible()) {
                Insets insets = TreeView.this.getInnerInsets();
                Dimension dimension = TreeView.this.searchPanel.getPreferredSize();
                TreeView.this.searchPanel.setBounds(insets.left, container.getHeight() - insets.bottom - dimension.height, container.getWidth() - insets.left - insets.right, dimension.height);
            }
        }
    }

    final class PopupSupport
    extends MouseAdapter
    implements Runnable,
    FocusListener,
    ActionListener {
        public final Action popup = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(PopupSupport.this);
            }

            @Override
            public boolean isEnabled() {
                return TreeView.this.isFocusOwner() || TreeView.this.tree.isFocusOwner();
            }
        };

        PopupSupport() {
        }

        @Override
        public void run() {
            Point point = TreeView.this.getPositionForPopup();
            if (point == null) {
                point = new Point(0, 0);
            }
            TreeView.this.createPopup(point.x, point.y);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            focusEvent.getComponent().removeFocusListener(this);
            if (DragDropUtilities.dragAndDropEnabled && TreeView.this.dragActive) {
                TreeView.this.setDragSource(true);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TreeView.this.tree.stopEditing();
            int n = TreeView.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n != -1 && SwingUtilities.isLeftMouseButton(mouseEvent) && MouseUtils.isDoubleClick((MouseEvent)mouseEvent)) {
                TreePath treePath;
                Node node;
                Action action;
                if (TreeView.this.defaultActionEnabled && (action = TreeView.takeAction((node = Visualizer.findNode((treePath = TreeView.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())).getLastPathComponent())).getPreferredAction(), node)) != null) {
                    if (action.isEnabled()) {
                        action.actionPerformed(new ActionEvent(node, 1001, ""));
                    } else {
                        Utilities.disabledActionBeep();
                    }
                    mouseEvent.consume();
                    return;
                }
                if (TreeView.this.tree.isExpanded(n)) {
                    TreeView.this.tree.collapseRow(n);
                } else {
                    TreeView.this.tree.expandRow(n);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Node[] nodeArray = TreeView.this.manager.getSelectedNodes();
            TreeView.performPreferredActionOnNodes(nodeArray);
        }
    }

    class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            TreeView.this.tree.cancelEditing();
            int n = TreeView.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n == -1 && !TreeView.this.isRootVisible()) {
                try {
                    TreeView.this.manager.setSelectedNodes(new Node[0]);
                }
                catch (PropertyVetoException propertyVetoException) {
                    assert (false) : propertyVetoException;
                }
            } else if (!TreeView.this.tree.isRowSelected(n)) {
                TreeView.this.tree.setSelectionRow(n);
            }
            if (n != -1 || !TreeView.this.isRootVisible()) {
                Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), TreeView.this);
                TreeView.this.createPopup((int)point.getX(), (int)point.getY());
            }
        }
    }

    class TreePropertyListener
    implements VetoableChangeListener,
    PropertyChangeListener,
    TreeExpansionListener,
    TreeWillExpandListener,
    TreeSelectionListener,
    Runnable {
        private RequestProcessor.Task scheduled;
        private TreePath[] readAccessPaths;

        TreePropertyListener() {
        }

        @Override
        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                if (TreeView.this.isSelectionModeBroken(nodeArray)) {
                    throw new PropertyVetoException("selection mode " + TreeView.this.getSelectionMode() + " broken by " + Arrays.asList(nodeArray), propertyChangeEvent);
                }
                if (!TreeView.this.selectionAccept(nodeArray)) {
                    throw new PropertyVetoException("selection " + Arrays.asList(nodeArray) + " rejected", propertyChangeEvent);
                }
            }
        }

        @Override
        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (TreeView.this.manager == null) {
                return;
            }
            final String string = propertyChangeEvent.getPropertyName();
            if (!(string.equals("rootContext") || string.equals("exploredContext") || string.equals("selectedNodes"))) {
                return;
            }
            Children.MUTEX.readAccess(new Runnable(){

                @Override
                public void run() {
                    if (string.equals("rootContext")) {
                        TreeView.this.synchronizeRootContext();
                    }
                    if (string.equals("exploredContext")) {
                        TreeView.this.synchronizeExploredContext();
                    }
                    if (string.equals("selectedNodes")) {
                        TreeView.this.synchronizeSelectedNodes();
                    }
                }
            });
        }

        @Override
        public synchronized void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            VisualizerNode visualizerNode = (VisualizerNode)treeExpansionEvent.getPath().getLastPathComponent();
            TreeView.this.visHolder.add(visualizerNode.getChildren());
            if (!TreeView.this.tree.getScrollsOnExpand()) {
                return;
            }
            RequestProcessor.Task task = this.scheduled;
            if (task != null) {
                task.cancel();
            }
            class Request
            implements Runnable {
                private TreePath path;

                public Request(TreePath treePath) {
                    this.path = treePath;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    if (!Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess()) {
                        Children.MUTEX.readAccess((Runnable)this);
                        return;
                    }
                    try {
                        if (!TreeView.this.tree.isVisible(this.path)) {
                            return;
                        }
                        if (TreeView.this.treeModel == null) {
                            return;
                        }
                        TreeNode treeNode = (TreeNode)this.path.getLastPathComponent();
                        if (TreeView.this.treeModel.getPathToRoot(treeNode)[0] != TreeView.this.treeModel.getRoot()) {
                            return;
                        }
                        int n = treeNode.getChildCount() - 1;
                        if (n >= 0) {
                            TreeNode treeNode2 = treeNode.getChildAt(n);
                            Rectangle rectangle = TreeView.this.tree.getVisibleRect();
                            Rectangle rectangle2 = TreeView.this.tree.getPathBounds(this.path);
                            Rectangle rectangle3 = TreeView.this.tree.getPathBounds(new TreePath(TreeView.this.treeModel.getPathToRoot(treeNode2)));
                            if (rectangle != null && rectangle2 != null && rectangle3 != null) {
                                TreeView.this.tree.scrollRectToVisible(new Rectangle(rectangle.x, rectangle2.y, 1, rectangle3.y - rectangle2.y + rectangle3.height));
                            }
                        }
                    }
                    finally {
                        this.path = null;
                    }
                }
            }
            this.scheduled = ViewUtil.uiProcessor().post((Runnable)new Request(treeExpansionEvent.getPath()), 250);
        }

        @Override
        public synchronized void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            class Request
            implements Runnable {
                private TreePath path;

                public Request(TreePath treePath) {
                    this.path = treePath;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                        return;
                    }
                    boolean bl = true;
                    try {
                        bl = TreeView.this.tree.isExpanded(this.path);
                        if (bl) {
                            return;
                        }
                        if (!TreeView.this.tree.isVisible(this.path)) {
                            return;
                        }
                        if (TreeView.this.treeModel == null) {
                            return;
                        }
                        TreeNode treeNode = (TreeNode)this.path.getLastPathComponent();
                        if (TreeView.this.treeModel.getPathToRoot(treeNode)[0] != TreeView.this.treeModel.getRoot()) {
                            return;
                        }
                        TreeView.this.treeModel.nodeStructureChanged(treeNode);
                    }
                    finally {
                        if (!bl) {
                            VisualizerNode visualizerNode = (VisualizerNode)this.path.getLastPathComponent();
                            TreeView.this.visHolder.removeRecur(visualizerNode.getChildren(false));
                        }
                        this.path = null;
                    }
                }
            }
            ViewUtil.uiProcessor().post((Runnable)new Request(treeExpansionEvent.getPath()), TIME_TO_COLLAPSE);
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath[] treePathArray = TreeView.this.tree.getSelectionPaths();
            if (treePathArray == null) {
                if (ExplorerDnDManager.getDefault().isDnDActive()) {
                    return;
                }
                TreeView.this.callSelectionChanged(new Node[0]);
            } else {
                this.readAccessPaths = treePathArray;
                Children.MUTEX.postReadRequest((Runnable)this);
            }
        }

        @Override
        public void run() {
            if (this.readAccessPaths == null) {
                return;
            }
            TreePath[] treePathArray = this.readAccessPaths;
            this.readAccessPaths = null;
            ArrayList<Node> arrayList = new ArrayList<Node>(treePathArray.length);
            for (int i = 0; i < treePathArray.length; ++i) {
                Node node = Visualizer.findNode(treePathArray[i].getLastPathComponent());
                node = TreeView.this.getOriginalNode(node);
                if (!this.isUnderRoot(TreeView.this.manager.getRootContext(), node)) continue;
                arrayList.add(node);
            }
            TreeView.this.callSelectionChanged(arrayList.toArray(new Node[arrayList.size()]));
        }

        private boolean isUnderRoot(Node node, Node node2) {
            while (node2 != null) {
                if (node2.equals((Object)node)) {
                    return true;
                }
                node2 = node2.getParentNode();
            }
            return false;
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            TreePath treePath = treeExpansionEvent.getPath();
            TreeView.this.prepareWaitCursor(DragDropUtilities.secureFindNode(treePath.getLastPathComponent()));
        }
    }

    private static class CursorR
    implements Runnable {
        private Component glassPane;
        private boolean show;

        private CursorR(Component component, boolean bl) {
            this.glassPane = component;
            this.show = bl;
        }

        @Override
        public void run() {
            TreeView.doShowWaitCursor(this.glassPane, this.show);
        }
    }
}

