// generated by Fast Light User Interface Designer (fluid) version 1.0308

#include "PADnoteUI.h"
// PADNoteUI.cc
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2015-2021, Will Godfrey
// Copyright 2022, Ichthyostega

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is derivative of ZynAddSubFX original code


#include <FL/Fl_Box.H>
    #include <FL/Fl_Group.H>
    #include <FL/fl_draw.H>
    #include "Params/PADnoteParameters.h"
    #include "UI/MiscGui.h"
    #include "PresetsUI.h"
    #include "UI/WidgetPDial.h"
    #include "UI/WidgetCheckButton.h"
    #include "EnvelopeUI.h"
    #include "LFOUI.h"
    #include "FilterUI.h"
#include "MasterUI.h"
#include "Params/PADStatus.h"
#include "Misc/SynthHelper.h"
    using synth::getDetune;
#include "Misc/NumericFuncs.h"
    using func::decibel;
    using func::asDecibel;
    using func::power;
#include "Misc/TextMsgBuffer.h"

    namespace { // Implementation details...
        TextMsgBuffer& textMsgBuffer = TextMsgBuffer::instance();
    }

PADnoteHarmonicProfile::PADnoteHarmonicProfile(int x,int y, int w, int h, const char *label):Fl_Box(x,y,w,h,label) {
  pars=NULL;
}

void PADnoteHarmonicProfile::init(PADnoteParameters *pars) {
  this->pars=pars;
}

void PADnoteHarmonicProfile::draw() {
  //
          int ox = x(), oy = y(), lx =w (), ly = h() - 1;
          if (!visible()) return;
  
          std::vector<float> profile = pars->buildProfile(lx);
          float realbw = pars->calcProfileBandwith(profile);
  
          bool active = active_r();
  
          //draw the equivalent bandwidth
          if (active)
              fl_color(220,220,220);
          else
              fl_color(160,165,165);
          float scale =  lx / 430.0f;
          fl_line_style(0, int(1 * scale));
          int rbw = (int)(realbw * (lx - 1.0) / 2.0);
          for (int i = lx / 2 - rbw; i < (lx / 2 + rbw); i++)
              fl_line(ox+i, oy, ox+i, oy + ly - 1);
  
          if (active)
              fl_color(200, 200, 200);
          else
              fl_color(160, 160, 160);
          for (int i = 1; i < 10; i++)
          {
              int kx = (int)(lx / 10.0 * i);
              fl_line(ox + kx, oy, ox + kx, oy + ly - 1);
          }
          for (int i = 1; i < 5; i++)
          {
              int ky = (int)(ly / 5.0 * i);
              fl_line(ox, oy + ly - ky, ox + lx, oy + ly - ky - 1);
          }
  
          fl_color(120, 120, 120);
          fl_line(ox + lx / 2, oy, ox + lx / 2, oy + ly);
  
          //draw the graph
          int step = 2 * scale;
          fl_line_style(0, step);
  
          for (int i = 0; i < lx; i += step)
          {
               int val = int((ly - 2) * profile[i]);
                if (active)
                  fl_color(180, 210, 240);
              else
                  fl_color(150, 150, 155);
              if (val != 0)
                  fl_line(ox + i, oy + ly, ox + i, oy + ly - val);
  
          }
  
          int oi = 0;
          float ov = 0;
  
          for (int i = 0; i < lx; i++)
          {
              int ni = ox + i;
              float nv = (ly - 2) * profile[i];
  
              if (active)
                  fl_color(0, 0, 100);
              else
                  fl_color(150, 150, 150);
              if (i > 0)
                  fl_line(oi, oy + ly - ov, ni, oy + ly - nv);
              oi = ni;
              ov = nv;
          }
  
          if (active)
              fl_color(0, 100, 220);
          else
              fl_color(150, 160, 170);
          fl_line(ox + lx / 2 - rbw, oy, ox + lx / 2 - rbw, oy + ly - 1);
          fl_line(ox + lx / 2 + rbw, oy, ox + lx / 2 + rbw, oy + ly - 1);
          fl_line_style(0, 1);
}

PADnoteOvertonePosition::PADnoteOvertonePosition(int x,int y, int w, int h, const char *label):Fl_Box(x,y,w,h,label) {
  pars=NULL;
}

void PADnoteOvertonePosition::init(PADnoteParameters *pars) {
  synth = pars->getSynthEngine();
  this->pars=pars;
}

void PADnoteOvertonePosition::draw() {
  //
          if (!visible()) return;
          const int maxdb = 60;
          int ox = x(), oy = y(), lx = w(), ly = h();
          const int maxharmonic = 64;
          float scale = lx / 525;
          fl_line_style(0, 1 * scale);
          for (int i = 1; i < maxharmonic; i++)
          {
              fl_color(200, 200, 200);
              if (i % 10 == 0)
                  fl_color(160, 160, 160);
              int kx = (int)(lx / (float)maxharmonic * i);
              fl_line(ox + kx, oy, ox + kx, oy + ly);
          }
  
          int n = synth->halfoscilsize;
          float spc[n];
          for (int i = 0; i < n; i++)
              spc[i] = 0.0;
          pars->oscilgen->getOscilSpectrumIntensities(n, spc);
  
          //normalize
          float max = 0;
          for (int i = 0; i < n; i++)
          {
              float x = fabsf(spc[i]);
              if (max < x)
                  max=x;
          }
          if (max < 0.000001)
              max = 1.0;
          max = max * 1.05;
  
          float spectrum[lx];
          for (int i = 0; i < lx; i++)
              spectrum[i] = 0;
  
          for (int i = 0; i+1 < n; i++)
          {
              float nhr = pars->calcHarmonicPositionFactor(i);
              int kx = (int)(lx / (float)maxharmonic * nhr);
              if (kx < 0 || kx >= lx)
                  continue;
              spectrum[kx] = spc[i] / max + 1e-9;
          }
  
          fl_color(180, 0, 0);
  
          if (pars->Pmode == 2)
          {
              int old = 0;
              for (int i = 1; i < lx; i++)
              {
                  if ((spectrum[i] > 1e-10) || (i == (lx - 1)))
                  {
                      int delta = i - old;
                      float val1 = spectrum[old];
                      float val2 = spectrum[i];
                      float idelta = 1.0 / delta;
                      for (int j = 0; j < delta; j++)
                      {
                          float x = idelta * j;
                          spectrum[old + j] = val1 * (1.0 - x) + val2 * x;
                      }
                      old = i;
                  }
              }
          }
          fl_line_style(0, 2 * scale);
          for (int i = 0; i < lx; i++)
          {
              float x = spectrum[i];
              if (x > decibel(-maxdb))
                  x = asDecibel(x) / maxdb + 1;
              else
                  continue;
              int yy = (int)(x * ly);
              fl_line(ox+i,oy+ly-1-yy,ox+i,oy+ly-1);
          }
          fl_line_style(0, 1);
}

void PADnoteUI::cb_padnotewindow_i(Fl_Double_Window*, void*) {
  padClose->do_callback();
}
void PADnoteUI::cb_padnotewindow(Fl_Double_Window* o, void* v) {
  ((PADnoteUI*)(o->user_data()))->cb_padnotewindow_i(o,v);
}

void PADnoteUI::cb__i(Fl_Tabs* o, void*) {
  //
            if (o->value() != harmonicstructuregroup)
            {
                applybox->hide();
                applybutton->hide();
            }
            else
            {
                applybox->show();
                applybutton->show();};
}
void PADnoteUI::cb_(Fl_Tabs* o, void* v) {
  ((PADnoteUI*)(o->parent()->user_data()))->cb__i(o,v);
}

void PADnoteUI::cb_hpbasetype_i(Fl_Choice* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::baseType, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hpbasetype(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpbasetype_i(o,v);
}

void PADnoteUI::cb_hpbasepar1_i(WidgetPDial* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::baseWidth, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hpbasepar1(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpbasepar1_i(o,v);
}

void PADnoteUI::cb_hpfreqmult_i(WidgetPDial* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::frequencyMultiplier, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hpfreqmult(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpfreqmult_i(o,v);
}

void PADnoteUI::cb_hpmpar1_i(WidgetPDial* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::modulatorStretch, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hpmpar1(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpmpar1_i(o,v);
}

void PADnoteUI::cb_hpmfreq_i(WidgetPDial* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::modulatorFrequency, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hpmfreq(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpmfreq_i(o,v);
}

void PADnoteUI::cb_hpwidth_i(WidgetPDial* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::size, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hpwidth(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpwidth_i(o,v);
}

void PADnoteUI::cb_hponehalf_i(Fl_Choice* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::harmonicSidebands, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hponehalf(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hponehalf_i(o,v);
}

void PADnoteUI::cb_hpampmode_i(Fl_Choice* o, void*) {
  //
                send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::amplitudeMode, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hpampmode(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_hpampmode_i(o,v);
}

void PADnoteUI::cb_hpamppar1_i(WidgetPDial* o, void*) {
  //
                send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::spectralWidth, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hpamppar1(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_hpamppar1_i(o,v);
}

void PADnoteUI::cb_hpamppar2_i(WidgetPDial* o, void*) {
  //
                send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::spectralAmplitude, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hpamppar2(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->parent()->user_data()))->cb_hpamppar2_i(o,v);
}

void PADnoteUI::cb_hpamptype_i(Fl_Choice* o, void*) {
  //
                send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::amplitudeMultiplier, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hpamptype(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpamptype_i(o,v);
}

void PADnoteUI::cb_hpautoscale_i(Fl_Check_Button2* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::autoscale, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hpautoscale(Fl_Check_Button2* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hpautoscale_i(o,v);
}

void PADnoteUI::cb_cbwidget_i(Fl_Box*, void*) {
  //
            overtonepos->redraw();
}
void PADnoteUI::cb_cbwidget(Fl_Box* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_cbwidget_i(o,v);
}

void PADnoteUI::cb_resonance_i(Fl_Button*, void*) {
  //
            resui->resonancewindow->redraw();
            resui->Show();
            resui->applybox->show();
            resui->applybutton->show();
            if ((Fl::event_button() == 3))
                padnotewindow->hide();
}
void PADnoteUI::cb_resonance(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_resonance_i(o,v);
}

void PADnoteUI::cb_waveform_i(Fl_Button*, void*) {
  //
            if (oscui!=NULL)
                delete (oscui);
            lastWaveW = 0;
            bool forPAD = true;
            oscui = new OscilEditor(pars->POscil.get(), osc, cbwidget, applybutton, synth, npart, kititem, 2, forPAD);
            if ((Fl::event_button() == 3))
                padnotewindow->hide();
}
void PADnoteUI::cb_waveform(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_waveform_i(o,v);
}

void PADnoteUI::cb_bwdial_i(WidgetPDial* o, void*) {
  //
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::bandwidth, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_bwdial(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_bwdial_i(o,v);
}

void PADnoteUI::cb_bwscale_i(Fl_Choice* o, void*) {
  //
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::bandwidthScale, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_bwscale(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_bwscale_i(o,v);
}

void PADnoteUI::cb_spectrummode_i(Fl_Choice* o, void*) {
  //
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::spectrumMode, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_spectrummode(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_spectrummode_i(o,v);
}

void PADnoteUI::cb_hrpospar1_i(WidgetPDial* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::overtoneParameter1, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hrpospar1(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hrpospar1_i(o,v);
}

void PADnoteUI::cb_hrpospar2_i(WidgetPDial* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::overtoneParameter2, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hrpospar2(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hrpospar2_i(o,v);
}

void PADnoteUI::cb_hrpospar3_i(WidgetPDial* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::overtoneForceHarmonics, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hrpospar3(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hrpospar3_i(o,v);
}

void PADnoteUI::cb_hrpostype_i(Fl_Choice* o, void*) {
  //
                  send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::overtonePosition, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hrpostype(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_hrpostype_i(o,v);
}

void PADnoteUI::cb_qbasenote_i(Fl_Choice* o, void*) {
  //
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::harmonicBase, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_qbasenote(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_qbasenote_i(o,v);
}

void PADnoteUI::cb_qsmpoct_i(Fl_Choice* o, void*) {
  //
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::samplesPerOctave, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_qsmpoct(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_qsmpoct_i(o,v);
}

void PADnoteUI::cb_qoct_i(Fl_Choice* o, void*) {
  //
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::numberOfOctaves, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_qoct(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_qoct_i(o,v);
}

void PADnoteUI::cb_qsamplesize_i(Fl_Choice* o, void*) {
  //
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::sampleSize, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_qsamplesize(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_qsamplesize_i(o,v);
}

void PADnoteUI::cb_xFadeDial_i(WidgetPDial* o, void*) {
  //
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::xFadeUpdate, logDial2millisec(o->value()), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_xFadeDial(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_xFadeDial_i(o,v);
}

void PADnoteUI::cb_randWalkUI_i(Fl_Button*, void*) {
  //
              show_randWalk();
              if ((Fl::event_button() == 3))
                  padnotewindow->hide();
}
void PADnoteUI::cb_randWalkUI(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->user_data()))->cb_randWalkUI_i(o,v);
}

void PADnoteUI::cb_volume_i(WidgetPDial* o, void*) {
  //
              send_data(0, PADSYNTH::control::volume, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_volume(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_volume_i(o,v);
}

void PADnoteUI::cb_vsns_i(WidgetPDial* o, void*) {
  //
              send_data(0, PADSYNTH::control::velocitySense, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_vsns(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_vsns_i(o,v);
}

void PADnoteUI::cb_pan_i(WidgetPDial* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::panning, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_pan(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pan_i(o,v);
}

void PADnoteUI::cb_panwidth_i(WidgetPDial* o, void*) {
  //
    send_data(0, PADSYNTH::control::randomWidth, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_panwidth(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_panwidth_i(o,v);
}

void PADnoteUI::cb_randompan_i(Fl_Check_Button2* o, void*) {
  //
        int tmp = o->value();
        if (tmp == 0)
            panwidth->deactivate();
        else
            panwidth->activate();
        send_data(0, PADSYNTH::control::enableRandomPan, tmp, TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_randompan(Fl_Check_Button2* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_randompan_i(o,v);
}

void PADnoteUI::cb_stereo_i(Fl_Check_Button2* o, void*) {
  //
              pars->PStereo =(o->value()) ? true : false; hprofile->redraw();
              send_data(0, PADSYNTH::control::stereo, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_stereo(Fl_Check_Button2* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_stereo_i(o,v);
}

void PADnoteUI::cb_dpop_i(WidgetPDial* o, void*) {
  //
              send_data(0, PADSYNTH::control::dePop, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_dpop(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_dpop_i(o,v);
}

void PADnoteUI::cb_pstr_i(WidgetPDial* o, void*) {
  //
              send_data(0, PADSYNTH::control::punchStrength, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_pstr(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pstr_i(o,v);
}

void PADnoteUI::cb_pt_i(WidgetPDial* o, void*) {
  //
              send_data(0, PADSYNTH::control::punchDuration, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_pt(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pt_i(o,v);
}

void PADnoteUI::cb_pstc_i(WidgetPDial* o, void*) {
  //
              send_data(0, PADSYNTH::control::punchStretch, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_pstc(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pstc_i(o,v);
}

void PADnoteUI::cb_pvel_i(WidgetPDial* o, void*) {
  //
              send_data(0, PADSYNTH::control::punchVelocity, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_pvel(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_pvel_i(o,v);
}

void PADnoteUI::cb_bend_i(WidgetPDial* o, void*) {
  //
              send_data(0, PADSYNTH::control::pitchBendAdjustment, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_bend(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_bend_i(o,v);
}

void PADnoteUI::cb_offset_i(WidgetPDial* o, void*) {
  //
              send_data(0, PADSYNTH::control::pitchBendOffset, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_offset(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_offset_i(o,v);
}

void PADnoteUI::cb_hz440_i(Fl_Check_Button2* o, void*) {
  //
              int x = (int) o->value();
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::baseFrequencyAs440Hz, x, TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_hz440(Fl_Check_Button2* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_hz440_i(o,v);
}

void PADnoteUI::cb_fixedfreqetdial_i(WidgetPDial* o, void*) {
  //
              send_data(0, PADSYNTH::control::equalTemperVariation, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_fixedfreqetdial(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_fixedfreqetdial_i(o,v);
}

void PADnoteUI::cb_detune_i(mwheel_slider_rev* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::detuneFrequency, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_detune(mwheel_slider_rev* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_detune_i(o,v);
}

void PADnoteUI::cb_detunevalueoutput_i(Fl_Value_Output* o, void*) {
  o->value(getDetune(pars->PDetuneType,0,pars->PDetune));
}
void PADnoteUI::cb_detunevalueoutput(Fl_Value_Output* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_detunevalueoutput_i(o,v);
}

void PADnoteUI::cb_octave_i(Fl_Counter* o, void*) {
  //
              send_data(0, PADSYNTH::control::octave, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_octave(Fl_Counter* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_octave_i(o,v);
}

void PADnoteUI::cb_detunetype_i(Fl_Choice* o, void*) {
  //
              send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::detuneType, o->value() + 1, TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_detunetype(Fl_Choice* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_detunetype_i(o,v);
}

void PADnoteUI::cb_coarsedet_i(Fl_Counter* o, void*) {
  //
              send_data(0, PADSYNTH::control::coarseDetune, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_coarsedet(Fl_Counter* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_coarsedet_i(o,v);
}

void PADnoteUI::cb_padExport_i(Fl_Button*, void*) {
  //
        string filename = setfiler(synth,"", "PadSynth", true, TOPLEVEL::XML::PadSample);
        if (filename.empty())
            return;
        send_data(TOPLEVEL::action::forceUpdate, MAIN::control::exportPadSynthSamples, 0, TOPLEVEL::type::Integer, npart, textMsgBuffer.push(filename));
}
void PADnoteUI::cb_padExport(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->user_data()))->cb_padExport_i(o,v);
}

void PADnoteUI::cb_applybutton_i(Fl_Button*, void*) {
  //
        send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::applyChanges, 1, TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_applybutton(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->user_data()))->cb_applybutton_i(o,v);
}

void PADnoteUI::cb_padCopy_i(Fl_Button*, void*) {
  synth->getGuiMaster()->getPresetsUi()->copy(pars);
}
void PADnoteUI::cb_padCopy(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->user_data()))->cb_padCopy_i(o,v);
}

void PADnoteUI::cb_padPaste_i(Fl_Button*, void*) {
  synth->getGuiMaster()->getPresetsUi()->paste(pars,this);
}
void PADnoteUI::cb_padPaste(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->user_data()))->cb_padPaste_i(o,v);
}

void PADnoteUI::cb_padClose_i(Fl_Button*, void*) {
  //
        saveWin(synth, padnotewindow->w(), padnotewindow->h(), padnotewindow->x(), padnotewindow->y(), false, "PadSynth");
        padSeen = false;
        resui->resonancewindow->hide();
        if (randWalkWindow)
            randWalkWindow->hide();
        padnotewindow->hide();
        if ((Fl::event_button() == 3))
        {
            if (synth->getGuiMaster()->partui->partKitOn)
                synth->getGuiMaster()->partui->instrumentkitlist->show();
            else
                synth->getGuiMaster()->partui->instrumenteditwindow->show();
        };
}
void PADnoteUI::cb_padClose(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->user_data()))->cb_padClose_i(o,v);
}

void PADnoteUI::cb_rebuildTrigger_i(WidgetPDial* o, void*) {
  //
            int dialSetting = o->value();
            if (dialSetting >= 0)
                dialSetting += 2300;
            // remove a socket of 200ms from the dial setting, i.e. the editable time in the UI starts > 200ms
            // smaller values would be pointless and overload the system. (60sec = 4779, 200ms = 2300, thus max = 4779-2300 = 2479)
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::rebuildTrigger, logDial2millisec(dialSetting), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_rebuildTrigger(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->user_data()))->cb_rebuildTrigger_i(o,v);
}

void PADnoteUI::cb_randWalkDetune_i(WidgetPDial* o, void*) {
  //
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::randWalkDetune, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_randWalkDetune(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->user_data()))->cb_randWalkDetune_i(o,v);
}

void PADnoteUI::cb_randWalkFilterFreq_i(WidgetPDial* o, void*) {
  //
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::randWalkFilterFreq, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_randWalkFilterFreq(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->user_data()))->cb_randWalkFilterFreq_i(o,v);
}

void PADnoteUI::cb_randWalkBandwidth_i(WidgetPDial* o, void*) {
  //
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::randWalkBandwidth, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_randWalkBandwidth(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->user_data()))->cb_randWalkBandwidth_i(o,v);
}

void PADnoteUI::cb_randWalkProfileWidth_i(WidgetPDial* o, void*) {
  //
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::randWalkProfileWidth, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_randWalkProfileWidth(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->user_data()))->cb_randWalkProfileWidth_i(o,v);
}

void PADnoteUI::cb_randWalkProfileStretch_i(WidgetPDial* o, void*) {
  //
            send_data(TOPLEVEL::action::forceUpdate, PADSYNTH::control::randWalkProfileStretch, o->value(), TOPLEVEL::type::Integer);
}
void PADnoteUI::cb_randWalkProfileStretch(WidgetPDial* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->user_data()))->cb_randWalkProfileStretch_i(o,v);
}

void PADnoteUI::cb_randClose_i(Fl_Button*, void*) {
  //
              if (randSeen)
                  saveWin(synth, randWalkWindow->w(), randWalkWindow->h(), randWalkWindow->x(), randWalkWindow->y(), false, string("padRandWalk"));
              randWalkWindow->hide();
              randSeen = false;
              if ((Fl::event_button() == 3))
                  synth->getGuiMaster()->partui->padnoteui->padnotewindow->show();
}
void PADnoteUI::cb_randClose(Fl_Button* o, void* v) {
  ((PADnoteUI*)(o->parent()->parent()->user_data()))->cb_randClose_i(o,v);
}

Fl_Double_Window* PADnoteUI::make_window() {
// randompan MUST be after panwidth
  { Fl_Double_Window* o = padnotewindow = new Fl_Double_Window(580, 440, "PAD synth Parameters");
    padnotewindow->callback((Fl_Callback*)cb_padnotewindow, (void*)(this));
    { Fl_Tabs* o = new Fl_Tabs(0, 0, 580, 405);
      o->callback((Fl_Callback*)cb_);
      { harmonicstructuregroup = new Fl_Group(0, 20, 580, 385, "Harmonic Structure");
        harmonicstructuregroup->box(FL_ENGRAVED_FRAME);
        harmonicstructuregroup->labelsize(12);
        { Fl_Group* o = bwprofilegroup = new Fl_Group(5, 25, 90, 270);
          bwprofilegroup->box(FL_ENGRAVED_FRAME);
          { Fl_Choice* o = hpbasetype = new Fl_Choice(15, 42, 75, 15, "Base Type");
            hpbasetype->tooltip("Base shape used to widen and spread each harmonic.");
            hpbasetype->down_box(FL_BORDER_BOX);
            hpbasetype->labelsize(10);
            hpbasetype->textfont(1);
            hpbasetype->textsize(10);
            hpbasetype->callback((Fl_Callback*)cb_hpbasetype);
            hpbasetype->align(Fl_Align(FL_ALIGN_TOP));
            o->add("Gauss");o->add("Square");o->add("DoubleExp");
            o->value(pars->PProfile.base.type);
          } // Fl_Choice* hpbasetype
          { WidgetPDial* o = hpbasepar1 = new WidgetPDial(20, 72, 25, 25, "Width");
            hpbasepar1->tooltip("Spread of a single peak within the profile.");
            hpbasepar1->box(FL_ROUND_UP_BOX);
            hpbasepar1->color(FL_BACKGROUND_COLOR);
            hpbasepar1->selection_color(FL_INACTIVE_COLOR);
            hpbasepar1->labeltype(FL_NORMAL_LABEL);
            hpbasepar1->labelfont(0);
            hpbasepar1->labelsize(10);
            hpbasepar1->labelcolor(FL_FOREGROUND_COLOR);
            hpbasepar1->maximum(127);
            hpbasepar1->step(1);
            hpbasepar1->callback((Fl_Callback*)cb_hpbasepar1);
            hpbasepar1->align(Fl_Align(FL_ALIGN_TOP));
            hpbasepar1->when(FL_WHEN_CHANGED);
            o->value(pars->PProfile.base.pwidth);
          } // WidgetPDial* hpbasepar1
          { WidgetPDial* o = hpfreqmult = new WidgetPDial(55, 72, 25, 25, "Repeat");
            hpfreqmult->tooltip("Repeat the same base shape multiple times in the generated profile.");
            hpfreqmult->box(FL_ROUND_UP_BOX);
            hpfreqmult->color(FL_BACKGROUND_COLOR);
            hpfreqmult->selection_color(FL_INACTIVE_COLOR);
            hpfreqmult->labeltype(FL_NORMAL_LABEL);
            hpfreqmult->labelfont(0);
            hpfreqmult->labelsize(10);
            hpfreqmult->labelcolor(FL_FOREGROUND_COLOR);
            hpfreqmult->maximum(127);
            hpfreqmult->step(1);
            hpfreqmult->callback((Fl_Callback*)cb_hpfreqmult);
            hpfreqmult->align(Fl_Align(FL_ALIGN_TOP));
            hpfreqmult->when(FL_WHEN_CHANGED);
            o->value(pars->PProfile.freqmult);
          } // WidgetPDial* hpfreqmult
          { WidgetPDial* o = hpmpar1 = new WidgetPDial(15, 112, 20, 20, "Str");
            hpmpar1->tooltip("Modulate and spread the base shape");
            hpmpar1->box(FL_ROUND_UP_BOX);
            hpmpar1->color(FL_BACKGROUND_COLOR);
            hpmpar1->selection_color(FL_INACTIVE_COLOR);
            hpmpar1->labeltype(FL_NORMAL_LABEL);
            hpmpar1->labelfont(0);
            hpmpar1->labelsize(10);
            hpmpar1->labelcolor(FL_FOREGROUND_COLOR);
            hpmpar1->maximum(127);
            hpmpar1->step(1);
            hpmpar1->callback((Fl_Callback*)cb_hpmpar1);
            hpmpar1->align(Fl_Align(FL_ALIGN_TOP));
            hpmpar1->when(FL_WHEN_CHANGED);
            o->value(pars->PProfile.modulator.pstretch);
          } // WidgetPDial* hpmpar1
          { WidgetPDial* o = hpmfreq = new WidgetPDial(40, 112, 20, 20, "Freq");
            hpmfreq->tooltip("Frequency of peaks within modulation of base shape.");
            hpmfreq->box(FL_ROUND_UP_BOX);
            hpmfreq->color(FL_BACKGROUND_COLOR);
            hpmfreq->selection_color(FL_INACTIVE_COLOR);
            hpmfreq->labeltype(FL_NORMAL_LABEL);
            hpmfreq->labelfont(0);
            hpmfreq->labelsize(10);
            hpmfreq->labelcolor(FL_FOREGROUND_COLOR);
            hpmfreq->maximum(127);
            hpmfreq->step(1);
            hpmfreq->callback((Fl_Callback*)cb_hpmfreq);
            hpmfreq->align(Fl_Align(FL_ALIGN_TOP));
            hpmfreq->when(FL_WHEN_CHANGED);
            o->value(pars->PProfile.modulator.freq);
          } // WidgetPDial* hpmfreq
          { WidgetPDial* o = hpwidth = new WidgetPDial(65, 112, 20, 20, "Scale");
            hpwidth->tooltip("Squeeze or stretch the profile as a whole. Note: effective only when Autoscal\
e is off");
            hpwidth->box(FL_ROUND_UP_BOX);
            hpwidth->color(FL_BACKGROUND_COLOR);
            hpwidth->selection_color(FL_INACTIVE_COLOR);
            hpwidth->labeltype(FL_NORMAL_LABEL);
            hpwidth->labelfont(0);
            hpwidth->labelsize(10);
            hpwidth->labelcolor(FL_FOREGROUND_COLOR);
            hpwidth->maximum(127);
            hpwidth->step(1);
            hpwidth->callback((Fl_Callback*)cb_hpwidth);
            hpwidth->align(Fl_Align(FL_ALIGN_TOP));
            hpwidth->when(FL_WHEN_CHANGED);
            o->value(pars->PProfile.width);
          } // WidgetPDial* hpwidth
          { Fl_Choice* o = hponehalf = new Fl_Choice(10, 147, 80, 15, "Profile");
            hponehalf->tooltip("Which part of the profile to use: Full, or only the upper or lower half.");
            hponehalf->down_box(FL_BORDER_BOX);
            hponehalf->labelsize(10);
            hponehalf->textfont(1);
            hponehalf->textsize(10);
            hponehalf->callback((Fl_Callback*)cb_hponehalf);
            hponehalf->align(Fl_Align(FL_ALIGN_TOP));
            o->add("Full");o->add("Upper Half");o->add("Lower Half");
            o->value(pars->PProfile.onehalf);
          } // Fl_Choice* hponehalf
          { ampgroup = new Fl_Group(10, 164, 80, 105);
            ampgroup->box(FL_BORDER_BOX);
            { Fl_Choice* o = hpampmode = new Fl_Choice(15, 209, 70, 15, "AmpMode");
              hpampmode->tooltip("How to combine secondary modulation with the profile: Sum: XFade, Mult: Filte\
r, Div1: profile/modulator, Div2: modulator/profile");
              hpampmode->down_box(FL_BORDER_BOX);
              hpampmode->labelsize(10);
              hpampmode->textfont(1);
              hpampmode->textsize(10);
              hpampmode->callback((Fl_Callback*)cb_hpampmode);
              hpampmode->align(Fl_Align(FL_ALIGN_TOP));
              o->add("Sum");o->add("Mult");o->add("Div1");o->add("Div2");
              o->value(pars->PProfile.amp.mode);
            } // Fl_Choice* hpampmode
            { WidgetPDial* o = hpamppar1 = new WidgetPDial(15, 239, 25, 25, "Par1");
              hpamppar1->tooltip("Squeeze or spread the secondary modulating shape.");
              hpamppar1->box(FL_ROUND_UP_BOX);
              hpamppar1->color(FL_BACKGROUND_COLOR);
              hpamppar1->selection_color(FL_INACTIVE_COLOR);
              hpamppar1->labeltype(FL_NORMAL_LABEL);
              hpamppar1->labelfont(0);
              hpamppar1->labelsize(10);
              hpamppar1->labelcolor(FL_FOREGROUND_COLOR);
              hpamppar1->maximum(127);
              hpamppar1->step(1);
              hpamppar1->callback((Fl_Callback*)cb_hpamppar1);
              hpamppar1->align(Fl_Align(FL_ALIGN_TOP));
              hpamppar1->when(FL_WHEN_CHANGED);
              o->value(pars->PProfile.amp.par1);
            } // WidgetPDial* hpamppar1
            { WidgetPDial* o = hpamppar2 = new WidgetPDial(55, 239, 25, 25, "Par2");
              hpamppar2->tooltip("Degree to fade or combine secondary modulation with the harmonic profile.");
              hpamppar2->box(FL_ROUND_UP_BOX);
              hpamppar2->color(FL_BACKGROUND_COLOR);
              hpamppar2->selection_color(FL_INACTIVE_COLOR);
              hpamppar2->labeltype(FL_NORMAL_LABEL);
              hpamppar2->labelfont(0);
              hpamppar2->labelsize(10);
              hpamppar2->labelcolor(FL_FOREGROUND_COLOR);
              hpamppar2->maximum(127);
              hpamppar2->step(1);
              hpamppar2->callback((Fl_Callback*)cb_hpamppar2);
              hpamppar2->align(Fl_Align(FL_ALIGN_TOP));
              hpamppar2->when(FL_WHEN_CHANGED);
              o->value(pars->PProfile.amp.par2);
            } // WidgetPDial* hpamppar2
            ampgroup->end();
          } // Fl_Group* ampgroup
          { Fl_Choice* o = hpamptype = new Fl_Choice(15, 179, 70, 15, "AmpMultiplier");
            hpamptype->tooltip("Apply a secondary amplitude modulation on top of the profile built thus far.");
            hpamptype->down_box(FL_BORDER_BOX);
            hpamptype->labelsize(10);
            hpamptype->textfont(1);
            hpamptype->textsize(10);
            hpamptype->callback((Fl_Callback*)cb_hpamptype);
            hpamptype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->add("Off");o->add("Gauss");o->add("Sine");o->add("Flat");
            o->value(pars->PProfile.amp.type);
            if (_SYS_::F2B(o->value())) ampgroup->activate(); else ampgroup->deactivate();
          } // Fl_Choice* hpamptype
          { Fl_Check_Button2* o = hpautoscale = new Fl_Check_Button2(10, 274, 74, 15, "Autoscale");
            hpautoscale->tooltip("Automatically stretch the profile, so that all shapes yield the same perceptu\
al blurring effect.");
            hpautoscale->box(FL_NO_BOX);
            hpautoscale->down_box(FL_DOWN_BOX);
            hpautoscale->color(FL_BACKGROUND_COLOR);
            hpautoscale->selection_color(FL_FOREGROUND_COLOR);
            hpautoscale->labeltype(FL_NORMAL_LABEL);
            hpautoscale->labelfont(0);
            hpautoscale->labelsize(11);
            hpautoscale->labelcolor(FL_FOREGROUND_COLOR);
            hpautoscale->callback((Fl_Callback*)cb_hpautoscale);
            hpautoscale->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
            hpautoscale->when(FL_WHEN_RELEASE);
            o->value(pars->PProfile.autoscale);
          } // Fl_Check_Button2* hpautoscale
          if (pars->Pmode!=0) o->deactivate();
          bwprofilegroup->end();
        } // Fl_Group* bwprofilegroup
        { Fl_Group* o = new Fl_Group(100, 155, 315, 135);
          o->box(FL_THIN_DOWN_BOX);
          o->color(FL_GRAY0);
          o->selection_color((Fl_Color)71);
          o->labelcolor((Fl_Color)179);
          o->align(Fl_Align(FL_ALIGN_BOTTOM_LEFT));
          osc=new Oscilloscope(o->x(),o->y(),o->w(),o->h(), 130,"");
          osc->init(pars->oscilgen.get(), synth);
          o->end();
        } // Fl_Group* o
        { cbwidget = new Fl_Box(125, 135, 205, 20, "Harmonic Content");
          cbwidget->labelsize(12);
          cbwidget->callback((Fl_Callback*)cb_cbwidget);
          cbwidget->align(Fl_Align(FL_ALIGN_CENTER|FL_ALIGN_INSIDE));
        } // Fl_Box* cbwidget
        { resonance = new Fl_Button(451, 246, 85, 20, "Resonance");
          resonance->box(FL_THIN_UP_BOX);
          resonance->labelfont(1);
          resonance->labelsize(12);
          resonance->callback((Fl_Callback*)cb_resonance);
        } // Fl_Button* resonance
        { waveform = new Fl_Button(451, 272, 85, 20, "Waveform");
          waveform->tooltip("Right click: also close this");
          waveform->box(FL_THIN_UP_BOX);
          waveform->labelfont(1);
          waveform->labelsize(12);
          waveform->callback((Fl_Callback*)cb_waveform);
        } // Fl_Button* waveform
        { WidgetPDial* o = bwdial = new WidgetPDial(20, 307, 35, 35, "BandWidth");
          bwdial->tooltip("Effective Bandwidth of the harmonic profile in cents: Transition from the pre\
cise waveform to a sonic cloud.");
          bwdial->box(FL_ROUND_UP_BOX);
          bwdial->color(FL_BACKGROUND_COLOR);
          bwdial->selection_color(FL_INACTIVE_COLOR);
          bwdial->labeltype(FL_NORMAL_LABEL);
          bwdial->labelfont(0);
          bwdial->labelsize(10);
          bwdial->labelcolor(FL_FOREGROUND_COLOR);
          bwdial->maximum(1000);
          bwdial->step(1);
          bwdial->callback((Fl_Callback*)cb_bwdial);
          bwdial->align(Fl_Align(FL_ALIGN_TOP));
          bwdial->when(FL_WHEN_CHANGED);
          o->value(pars->Pbandwidth);
          if (pars->Pmode!=0) o->deactivate();
          o->setValueType(VC_BandWidth);
        } // WidgetPDial* bwdial
        { Fl_Value_Output* o = bwcents = new Fl_Value_Output(60, 320, 55, 15, "cents");
          bwcents->labelsize(10);
          bwcents->maximum(10000);
          bwcents->textsize(11);
          bwcents->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->step(0.1, 1);
          o->value(pars->getBandwithInCent());
          if (pars->Pmode!=0) o->deactivate();
        } // Fl_Value_Output* bwcents
        { Fl_Choice* o = bwscale = new Fl_Choice(125, 315, 80, 20, "Bandwidth Scale");
          bwscale->tooltip("Adjust Bandwidth with the increasing frequency of each harmonic. Normal: prop\
ortional, EqualHz: constant, InvHalf: reversed decreasing...");
          bwscale->down_box(FL_BORDER_BOX);
          bwscale->labelsize(10);
          bwscale->textfont(1);
          bwscale->textsize(11);
          bwscale->callback((Fl_Callback*)cb_bwscale);
          bwscale->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("Normal");o->add("EqualHz");o->add("Quarter");o->add("Half");o->add("75%");o->add("150%");o->add("Double");o->add("Inv.Half");
          o->value(pars->Pbwscale);
          if (pars->Pmode!=0) o->deactivate();
        } // Fl_Choice* bwscale
        { Fl_Choice* o = spectrummode = new Fl_Choice(265, 315, 90, 20, "Spectrum Mode");
          spectrummode->tooltip("How to generate the spectrum: Bandwidth: widen each harmonic by a profile, Di\
screte: no blurring, similar to AddSynth, Continuous: connect outline of all h\
armonics into a continuous noisy distribution.");
          spectrummode->down_box(FL_BORDER_BOX);
          spectrummode->labelsize(10);
          spectrummode->textfont(1);
          spectrummode->textsize(11);
          spectrummode->callback((Fl_Callback*)cb_spectrummode);
          spectrummode->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("Bandwidth");o->add("Discrete");o->add("Continuous");
          o->value(pars->Pmode);
        } // Fl_Choice* spectrummode
        { hrgroup = new Fl_Group(360, 296, 215, 50);
          hrgroup->box(FL_ENGRAVED_FRAME);
          { WidgetPDial* o = hrpospar1 = new WidgetPDial(470, 315, 25, 25, "Par1");
            hrpospar1->tooltip("Spread upper harmonics according to the \'OvertonesPosition\' type.");
            hrpospar1->box(FL_ROUND_UP_BOX);
            hrpospar1->color(FL_BACKGROUND_COLOR);
            hrpospar1->selection_color(FL_INACTIVE_COLOR);
            hrpospar1->labeltype(FL_NORMAL_LABEL);
            hrpospar1->labelfont(0);
            hrpospar1->labelsize(10);
            hrpospar1->labelcolor(FL_FOREGROUND_COLOR);
            hrpospar1->maximum(255);
            hrpospar1->step(1);
            hrpospar1->callback((Fl_Callback*)cb_hrpospar1);
            hrpospar1->align(Fl_Align(FL_ALIGN_TOP));
            hrpospar1->when(FL_WHEN_CHANGED);
            o->value(pars->Phrpos.par1);
          } // WidgetPDial* hrpospar1
          { WidgetPDial* o = hrpospar2 = new WidgetPDial(505, 315, 25, 25, "Par2");
            hrpospar2->tooltip("Further variation on the harmonics spread: threshold (ShiftU/L), exponent (Po\
wer), frequency (Sine).");
            hrpospar2->box(FL_ROUND_UP_BOX);
            hrpospar2->color(FL_BACKGROUND_COLOR);
            hrpospar2->selection_color(FL_INACTIVE_COLOR);
            hrpospar2->labeltype(FL_NORMAL_LABEL);
            hrpospar2->labelfont(0);
            hrpospar2->labelsize(10);
            hrpospar2->labelcolor(FL_FOREGROUND_COLOR);
            hrpospar2->maximum(255);
            hrpospar2->step(1);
            hrpospar2->callback((Fl_Callback*)cb_hrpospar2);
            hrpospar2->align(Fl_Align(FL_ALIGN_TOP));
            hrpospar2->when(FL_WHEN_CHANGED);
            o->value(pars->Phrpos.par2);
          } // WidgetPDial* hrpospar2
          { WidgetPDial* o = hrpospar3 = new WidgetPDial(540, 315, 25, 25, "ForceH");
            hrpospar3->tooltip("Increasingly force each partial towards the next regular harmonic position, r\
educe the noisiness.");
            hrpospar3->box(FL_ROUND_UP_BOX);
            hrpospar3->color(FL_BACKGROUND_COLOR);
            hrpospar3->selection_color(FL_INACTIVE_COLOR);
            hrpospar3->labeltype(FL_NORMAL_LABEL);
            hrpospar3->labelfont(0);
            hrpospar3->labelsize(10);
            hrpospar3->labelcolor(FL_FOREGROUND_COLOR);
            hrpospar3->maximum(255);
            hrpospar3->step(1);
            hrpospar3->callback((Fl_Callback*)cb_hrpospar3);
            hrpospar3->align(Fl_Align(FL_ALIGN_TOP));
            hrpospar3->when(FL_WHEN_CHANGED);
            o->value(pars->Phrpos.par3);
            o->setValueType(VC_percent255);
          } // WidgetPDial* hrpospar3
          hrgroup->end();
        } // Fl_Group* hrgroup
        { Fl_Choice* o = hrpostype = new Fl_Choice(370, 315, 85, 20, "OvertonesPosition");
          hrpostype->tooltip("Shift overtones to non-harmonic positions, to create metallic and noisy flavo\
urs.");
          hrpostype->down_box(FL_BORDER_BOX);
          hrpostype->labelsize(10);
          hrpostype->textfont(1);
          hrpostype->textsize(11);
          hrpostype->callback((Fl_Callback*)cb_hrpostype);
          hrpostype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("Harmonic");o->add("ShiftU");o->add("ShiftL");o->add("PowerU");o->add("PowerL");o->add("Sine");o->add("Power");o->add("Shift");
          o->value(pars->Phrpos.type);
          if (int(o->value()) > 0) {hrgroup->activate(); if (int(o->value() < 7)) hrpospar2->activate(); else hrpospar2->deactivate();} else hrgroup->deactivate();
        } // Fl_Choice* hrpostype
        { Fl_Group* o = overtonepos = new Fl_Group(5, 350, 570, 45);
          overtonepos->box(FL_FLAT_BOX);
          overtonepos->color(FL_LIGHT3);
          overtonepos->selection_color((Fl_Color)218);
          overtonepos->labelcolor(FL_GREEN);
          PADnoteOvertonePosition *opui=new PADnoteOvertonePosition(o->x(),o->y(),o->w(),o->h(),"");
          opui->init(pars);
          overtonepos->end();
        } // Fl_Group* overtonepos
        { Fl_Choice* o = qbasenote = new Fl_Choice(419, 155, 48, 20, "base");
          qbasenote->tooltip("Note value for the lowest wavetable generated.");
          qbasenote->down_box(FL_BORDER_BOX);
          qbasenote->labelsize(11);
          qbasenote->textfont(1);
          qbasenote->textsize(12);
          qbasenote->callback((Fl_Callback*)cb_qbasenote);
          qbasenote->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("C-2");o->add("G-2");o->add("C-3");o->add("G-3");o->add("C-4");o->add("G-4");o->add("C-5");o->add("G-5");o->add("G-6");
          o->value(pars->Pquality.basenote);
        } // Fl_Choice* qbasenote
        { Fl_Choice* o = qsmpoct = new Fl_Choice(472, 155, 48, 20, "smp/oct");
          qsmpoct->tooltip("Number of wavetables generated within each octave.");
          qsmpoct->down_box(FL_BORDER_BOX);
          qsmpoct->labelsize(11);
          qsmpoct->textfont(1);
          qsmpoct->textsize(12);
          qsmpoct->callback((Fl_Callback*)cb_qsmpoct);
          qsmpoct->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("0.5");o->add("1");o->add("2");o->add("3");o->add("4");o->add("6");o->add("12");
          o->value(pars->Pquality.smpoct);
        } // Fl_Choice* qsmpoct
        { Fl_Choice* o = qoct = new Fl_Choice(525, 155, 50, 20, "no.oct");
          qoct->tooltip("Number of octaves to cover with dedicated wavetables; other note values will \
sample up/down.");
          qoct->down_box(FL_BORDER_BOX);
          qoct->labelsize(11);
          qoct->textfont(1);
          qoct->textsize(12);
          qoct->callback((Fl_Callback*)cb_qoct);
          qoct->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("1");o->add("2");o->add("3");o->add("4");o->add("5");o->add("6");o->add("7");o->add("8");
          o->value(pars->Pquality.oct);
        } // Fl_Choice* qoct
        { sampleFrame = new Fl_Box(418, 178, 157, 64);
          sampleFrame->box(FL_EMBOSSED_FRAME);
        } // Fl_Box* sampleFrame
        { Fl_Choice* o = qsamplesize = new Fl_Choice(425, 193, 94, 20, "Sample Size");
          qsamplesize->tooltip("Size/Resolution of the generated wavetable(s). 128k -> 2.6sec, 1M -> 21sec un\
til repetition of patterns.");
          qsamplesize->down_box(FL_BORDER_BOX);
          qsamplesize->labelsize(10);
          qsamplesize->textfont(1);
          qsamplesize->textsize(11);
          qsamplesize->callback((Fl_Callback*)cb_qsamplesize);
          qsamplesize->align(Fl_Align(FL_ALIGN_TOP_LEFT));
          o->add("16k (Tiny)");o->add("32k");o->add("64k (Small)");o->add("128k");o->add("256k");o->add("512k");o->add("1M (Big)");
          o->value(pars->Pquality.samplesize);
        } // Fl_Choice* qsamplesize
        { WidgetPDial* o = xFadeDial = new WidgetPDial(530, 201, 32, 32, "Crossfade");
          xFadeDial->tooltip("cross fade after building new Wavetable");
          xFadeDial->box(FL_ROUND_UP_BOX);
          xFadeDial->color(FL_BACKGROUND_COLOR);
          xFadeDial->selection_color(FL_INACTIVE_COLOR);
          xFadeDial->labeltype(FL_NORMAL_LABEL);
          xFadeDial->labelfont(0);
          xFadeDial->labelsize(10);
          xFadeDial->labelcolor(FL_FOREGROUND_COLOR);
          xFadeDial->minimum(-1);
          xFadeDial->maximum(4301);
          xFadeDial->step(1);
          xFadeDial->callback((Fl_Callback*)cb_xFadeDial);
          xFadeDial->align(Fl_Align(FL_ALIGN_TOP));
          xFadeDial->when(FL_WHEN_CHANGED);
          int dialSetting = millisec2logDial(pars->PxFadeUpdate);
                   o->value(dialSetting);
          o->setValueType(VC_XFadeUpdate);
        } // WidgetPDial* xFadeDial
        { randWalkUI = new Fl_Button(425, 217, 94, 20, "Retrigger");
          randWalkUI->labelfont(1);
          randWalkUI->labelsize(12);
          randWalkUI->callback((Fl_Callback*)cb_randWalkUI);
        } // Fl_Button* randWalkUI
        { Fl_Group* o = hprofile = new Fl_Group(100, 45, 475, 90);
          hprofile->box(FL_FLAT_BOX);
          hprofile->color(FL_LIGHT3);
          hprofile->selection_color((Fl_Color)218);
          hprofile->labelcolor(FL_GREEN);
          PADnoteHarmonicProfile *hpui=new PADnoteHarmonicProfile(o->x(),o->y(),o->w(),o->h(),"");
          hpui->init(pars);
          if (pars->Pmode!=0) { o->deactivate(); o->color(48);};
          hprofile->end();
        } // Fl_Group* hprofile
        { harmonicprofile = new Fl_Box(160, 25, 315, 20, "Profile of One Harmonic (Frequency Distribution)");
          harmonicprofile->labelsize(12);
        } // Fl_Box* harmonicprofile
        harmonicstructuregroup->end();
      } // Fl_Group* harmonicstructuregroup
      { envelopes = new Fl_Group(0, 20, 580, 385, "Envelopes and &LFOs");
        envelopes->box(FL_ENGRAVED_BOX);
        envelopes->labelsize(12);
        envelopes->hide();
        { Fl_Box* o = new Fl_Box(10, 27, 275, 68);
          o->box(FL_PLASTIC_UP_BOX);
          o->color(FL_CYAN);
        } // Fl_Box* o
        { ampgrp = new Fl_Group(5, 27, 285, 250, "AMPLITUDE");
          ampgrp->box(FL_THIN_UP_FRAME);
          ampgrp->labelfont(1);
          ampgrp->labelsize(11);
          ampgrp->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          { WidgetPDial* o = volume = new WidgetPDial(30, 42, 34, 34, "Volume");
            volume->tooltip("Volume");
            volume->box(FL_ROUND_UP_BOX);
            volume->color(FL_BACKGROUND_COLOR);
            volume->selection_color(FL_INACTIVE_COLOR);
            volume->labeltype(FL_NORMAL_LABEL);
            volume->labelfont(0);
            volume->labelsize(10);
            volume->labelcolor(FL_FOREGROUND_COLOR);
            volume->maximum(127);
            volume->step(1);
            volume->callback((Fl_Callback*)cb_volume);
            volume->align(Fl_Align(FL_ALIGN_BOTTOM));
            volume->when(FL_WHEN_CHANGED);
            o->setValueType(VC_InstrumentVolume);
            o->value(pars->PVolume);
          } // WidgetPDial* volume
          { WidgetPDial* o = vsns = new WidgetPDial(85, 42, 34, 34, "Vel Sens");
            vsns->tooltip("Velocity Sensing Function (rightmost to disable)");
            vsns->box(FL_ROUND_UP_BOX);
            vsns->color(FL_BACKGROUND_COLOR);
            vsns->selection_color(FL_INACTIVE_COLOR);
            vsns->labeltype(FL_NORMAL_LABEL);
            vsns->labelfont(0);
            vsns->labelsize(10);
            vsns->labelcolor(FL_FOREGROUND_COLOR);
            vsns->maximum(127);
            vsns->step(1);
            vsns->callback((Fl_Callback*)cb_vsns);
            vsns->align(Fl_Align(FL_ALIGN_BOTTOM));
            vsns->when(FL_WHEN_CHANGED);
            o->value(pars->PAmpVelocityScaleFunction);
            o->setValueType(VC_AmpVelocitySense);
          } // WidgetPDial* vsns
          { WidgetPDial* o = pan = new WidgetPDial(155, 42, 34, 34, "Pan");
            pan->tooltip("Panning");
            pan->box(FL_ROUND_UP_BOX);
            pan->color(FL_BACKGROUND_COLOR);
            pan->selection_color(FL_INACTIVE_COLOR);
            pan->labeltype(FL_NORMAL_LABEL);
            pan->labelfont(0);
            pan->labelsize(10);
            pan->labelcolor(FL_FOREGROUND_COLOR);
            pan->maximum(127);
            pan->step(1);
            pan->callback((Fl_Callback*)cb_pan);
            pan->align(Fl_Align(FL_ALIGN_BOTTOM));
            pan->when(FL_WHEN_CHANGED);
            o->setValueType(VC_PanningStd);
            o->value(pars->PPanning);
          } // WidgetPDial* pan
          { WidgetPDial* o = panwidth = new WidgetPDial(235, 42, 35, 35, "Width");
            panwidth->tooltip("Random width");
            panwidth->box(FL_ROUND_UP_BOX);
            panwidth->color(FL_BACKGROUND_COLOR);
            panwidth->selection_color(FL_INACTIVE_COLOR);
            panwidth->labeltype(FL_NORMAL_LABEL);
            panwidth->labelfont(0);
            panwidth->labelsize(10);
            panwidth->labelcolor(FL_FOREGROUND_COLOR);
            panwidth->maximum(63);
            panwidth->step(1);
            panwidth->value(63);
            panwidth->callback((Fl_Callback*)cb_panwidth);
            panwidth->align(Fl_Align(FL_ALIGN_BOTTOM));
            panwidth->when(FL_WHEN_CHANGED);
            o->setValueType(VC_PanningRandom);
            o->value(pars->PWidth);
          } // WidgetPDial* panwidth
          { Fl_Check_Button2* o = randompan = new Fl_Check_Button2(205, 51, 15, 15, "Rand");
            randompan->tooltip("Enable random panning");
            randompan->box(FL_NO_BOX);
            randompan->down_box(FL_DOWN_BOX);
            randompan->color((Fl_Color)48);
            randompan->selection_color(FL_FOREGROUND_COLOR);
            randompan->labeltype(FL_NORMAL_LABEL);
            randompan->labelfont(0);
            randompan->labelsize(11);
            randompan->labelcolor(FL_FOREGROUND_COLOR);
            randompan->callback((Fl_Callback*)cb_randompan);
            randompan->align(Fl_Align(FL_ALIGN_TOP));
            randompan->when(FL_WHEN_RELEASE);
            o->value(pars->PRandom);
            if (o->value() == 0) panwidth->deactivate(); else panwidth->activate();
          } // Fl_Check_Button2* randompan
          { Fl_Box* o = new Fl_Box(14, 248, 18, 18);
            o->box(FL_THIN_UP_BOX);
            o->color((Fl_Color)237);
          } // Fl_Box* o
          { Fl_Check_Button2* o = stereo = new Fl_Check_Button2(16, 249, 61, 15, " Stereo");
            stereo->box(FL_NO_BOX);
            stereo->down_box(FL_DOWN_BOX);
            stereo->color((Fl_Color)237);
            stereo->selection_color(FL_FOREGROUND_COLOR);
            stereo->labeltype(FL_NORMAL_LABEL);
            stereo->labelfont(0);
            stereo->labelsize(11);
            stereo->labelcolor(FL_FOREGROUND_COLOR);
            stereo->callback((Fl_Callback*)cb_stereo);
            stereo->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
            stereo->when(FL_WHEN_RELEASE);
            o->value(pars->PStereo);
          } // Fl_Check_Button2* stereo
          { WidgetPDial* o = dpop = new WidgetPDial(130, 247, 25, 25, "D.Pop");
            dpop->tooltip("Pop Suppression");
            dpop->box(FL_ROUND_UP_BOX);
            dpop->color(FL_BACKGROUND_COLOR);
            dpop->selection_color(FL_INACTIVE_COLOR);
            dpop->labeltype(FL_NORMAL_LABEL);
            dpop->labelfont(0);
            dpop->labelsize(10);
            dpop->labelcolor(FL_FOREGROUND_COLOR);
            dpop->maximum(127);
            dpop->step(1);
            dpop->callback((Fl_Callback*)cb_dpop);
            dpop->align(Fl_Align(FL_ALIGN_TOP));
            dpop->when(FL_WHEN_CHANGED);
            o->value(pars->Fadein_adjustment);
          } // WidgetPDial* dpop
          { WidgetPDial* o = pstr = new WidgetPDial(170, 247, 25, 25, "P.Str.");
            pstr->tooltip("Punch Strength");
            pstr->box(FL_ROUND_UP_BOX);
            pstr->color(FL_BACKGROUND_COLOR);
            pstr->selection_color(FL_INACTIVE_COLOR);
            pstr->labeltype(FL_NORMAL_LABEL);
            pstr->labelfont(0);
            pstr->labelsize(10);
            pstr->labelcolor(FL_FOREGROUND_COLOR);
            pstr->maximum(127);
            pstr->step(1);
            pstr->callback((Fl_Callback*)cb_pstr);
            pstr->align(Fl_Align(FL_ALIGN_TOP));
            pstr->when(FL_WHEN_CHANGED);
            o->value(pars->PPunchStrength);
          } // WidgetPDial* pstr
          { WidgetPDial* o = pt = new WidgetPDial(200, 247, 25, 25, "P.t.");
            pt->tooltip("Punch Time (duration)");
            pt->box(FL_ROUND_UP_BOX);
            pt->color(FL_BACKGROUND_COLOR);
            pt->selection_color(FL_INACTIVE_COLOR);
            pt->labeltype(FL_NORMAL_LABEL);
            pt->labelfont(0);
            pt->labelsize(10);
            pt->labelcolor(FL_FOREGROUND_COLOR);
            pt->maximum(127);
            pt->step(1);
            pt->callback((Fl_Callback*)cb_pt);
            pt->align(Fl_Align(FL_ALIGN_TOP));
            pt->when(FL_WHEN_CHANGED);
            o->value(pars->PPunchTime);
          } // WidgetPDial* pt
          { WidgetPDial* o = pstc = new WidgetPDial(230, 247, 25, 25, "P.Stc.");
            pstc->tooltip("Punch Stretch");
            pstc->box(FL_ROUND_UP_BOX);
            pstc->color(FL_BACKGROUND_COLOR);
            pstc->selection_color(FL_INACTIVE_COLOR);
            pstc->labeltype(FL_NORMAL_LABEL);
            pstc->labelfont(0);
            pstc->labelsize(10);
            pstc->labelcolor(FL_FOREGROUND_COLOR);
            pstc->maximum(127);
            pstc->step(1);
            pstc->callback((Fl_Callback*)cb_pstc);
            pstc->align(Fl_Align(FL_ALIGN_TOP));
            pstc->when(FL_WHEN_CHANGED);
            o->value(pars->PPunchStretch);
          } // WidgetPDial* pstc
          { WidgetPDial* o = pvel = new WidgetPDial(260, 247, 25, 25, "P.Vel.");
            pvel->tooltip("Punch Velocity Sensing");
            pvel->box(FL_ROUND_UP_BOX);
            pvel->color(FL_BACKGROUND_COLOR);
            pvel->selection_color(FL_INACTIVE_COLOR);
            pvel->labeltype(FL_NORMAL_LABEL);
            pvel->labelfont(0);
            pvel->labelsize(10);
            pvel->labelcolor(FL_FOREGROUND_COLOR);
            pvel->maximum(127);
            pvel->step(1);
            pvel->callback((Fl_Callback*)cb_pvel);
            pvel->align(Fl_Align(FL_ALIGN_TOP));
            pvel->when(FL_WHEN_CHANGED);
            o->value(pars->PPunchVelocitySensing);
          } // WidgetPDial* pvel
          { EnvelopeUI* o = ampenv = new EnvelopeUI(10, 95, 250, 70, "PADSynth - Amplitude Envelope");
            ampenv->box(FL_FLAT_BOX);
            ampenv->color((Fl_Color)51);
            ampenv->selection_color(FL_BACKGROUND_COLOR);
            ampenv->labeltype(FL_NORMAL_LABEL);
            ampenv->labelfont(0);
            ampenv->labelsize(12);
            ampenv->labelcolor(FL_FOREGROUND_COLOR);
            ampenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            ampenv->when(FL_WHEN_RELEASE);
            o->init(pars->AmpEnvelope.get(), npart, kititem, 2, 0);
            ampenv->end();
          } // EnvelopeUI* ampenv
          { LFOUI* o = amplfo = new LFOUI(10, 165, 275, 70, "Amplitude LFO     ");
            amplfo->box(FL_FLAT_BOX);
            amplfo->color(FL_DARK1);
            amplfo->selection_color(FL_BACKGROUND_COLOR);
            amplfo->labeltype(FL_NORMAL_LABEL);
            amplfo->labelfont(1);
            amplfo->labelsize(12);
            amplfo->labelcolor(FL_FOREGROUND_COLOR);
            amplfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            amplfo->when(FL_WHEN_RELEASE);
            o->init(pars->AmpLfo.get(), npart, kititem, 2, 0);
            amplfo->end();
          } // LFOUI* amplfo
          { Fl_Box* o = new Fl_Box(135, 41, 4, 47);
            o->box(FL_THIN_DOWN_FRAME);
          } // Fl_Box* o
          ampgrp->end();
        } // Fl_Group* ampgrp
        { filtergrp = new Fl_Group(290, 25, 285, 250, "FILTER");
          filtergrp->box(FL_THIN_UP_BOX);
          filtergrp->labelfont(1);
          filtergrp->labelsize(11);
          filtergrp->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          { EnvelopeUI* o = filterenv = new EnvelopeUI(295, 130, 275, 70, "PADSynth - Filter Envelope");
            filterenv->box(FL_FLAT_BOX);
            filterenv->color((Fl_Color)51);
            filterenv->selection_color(FL_BACKGROUND_COLOR);
            filterenv->labeltype(FL_NORMAL_LABEL);
            filterenv->labelfont(0);
            filterenv->labelsize(12);
            filterenv->labelcolor(FL_FOREGROUND_COLOR);
            filterenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            filterenv->when(FL_WHEN_RELEASE);
            o->init(pars->FilterEnvelope.get(), npart, kititem, 2, 2);
            filterenv->end();
          } // EnvelopeUI* filterenv
          { LFOUI* o = filterlfo = new LFOUI(295, 200, 275, 70, "Filter LFO     ");
            filterlfo->box(FL_FLAT_BOX);
            filterlfo->color(FL_DARK1);
            filterlfo->selection_color(FL_BACKGROUND_COLOR);
            filterlfo->labeltype(FL_NORMAL_LABEL);
            filterlfo->labelfont(1);
            filterlfo->labelsize(12);
            filterlfo->labelcolor(FL_FOREGROUND_COLOR);
            filterlfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            filterlfo->when(FL_WHEN_RELEASE);
            o->init(pars->FilterLfo.get(), npart, kititem, 2, 2);
            filterlfo->end();
          } // LFOUI* filterlfo
          { FilterUI* o = filterui = new FilterUI(295, 55, 275, 75, "PADsynth - Filter");
            filterui->box(FL_FLAT_BOX);
            filterui->color(FL_LIGHT1);
            filterui->selection_color(FL_BACKGROUND_COLOR);
            filterui->labeltype(FL_NORMAL_LABEL);
            filterui->labelfont(0);
            filterui->labelsize(12);
            filterui->labelcolor(FL_FOREGROUND_COLOR);
            filterui->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            filterui->when(FL_WHEN_RELEASE);
            o->init(pars->GlobalFilter.get(), &pars->PFilterVelocityScale,&pars->PFilterVelocityScaleFunction, npart, kititem, 2);
            filterui->end();
          } // FilterUI* filterui
          filtergrp->end();
        } // Fl_Group* filtergrp
        { frequencygrp = new Fl_Group(5, 275, 570, 125, "FREQUENCY");
          frequencygrp->box(FL_THIN_UP_BOX);
          frequencygrp->labelfont(1);
          frequencygrp->labelsize(11);
          frequencygrp->align(Fl_Align(FL_ALIGN_TOP|FL_ALIGN_INSIDE));
          { EnvelopeUI* o = freqenv = new EnvelopeUI(10, 325, 205, 70, "PADSynth - Frequency Envelope");
            freqenv->box(FL_FLAT_BOX);
            freqenv->color((Fl_Color)51);
            freqenv->selection_color(FL_BACKGROUND_COLOR);
            freqenv->labeltype(FL_NORMAL_LABEL);
            freqenv->labelfont(0);
            freqenv->labelsize(12);
            freqenv->labelcolor(FL_FOREGROUND_COLOR);
            freqenv->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            freqenv->when(FL_WHEN_RELEASE);
            o->init(pars->FreqEnvelope.get(), npart, kititem, 2, 1);
            freqenv->end();
          } // EnvelopeUI* freqenv
          { LFOUI* o = freqlfo = new LFOUI(215, 325, 275, 70, "Frequency LFO     ");
            freqlfo->box(FL_FLAT_BOX);
            freqlfo->color(FL_DARK1);
            freqlfo->selection_color(FL_BACKGROUND_COLOR);
            freqlfo->labeltype(FL_NORMAL_LABEL);
            freqlfo->labelfont(0);
            freqlfo->labelsize(12);
            freqlfo->labelcolor(FL_FOREGROUND_COLOR);
            freqlfo->align(Fl_Align(FL_ALIGN_WRAP|FL_ALIGN_INSIDE));
            freqlfo->when(FL_WHEN_RELEASE);
            o->init(pars->FreqLfo.get(), npart, kititem, 2, 1);
            freqlfo->end();
          } // LFOUI* freqlfo
          { WidgetPDial* o = bend = new WidgetPDial(80, 280, 20, 20, "Bend");
            bend->tooltip("Pitch bend range scaling");
            bend->box(FL_ROUND_UP_BOX);
            bend->color(FL_BACKGROUND_COLOR);
            bend->selection_color(FL_INACTIVE_COLOR);
            bend->labeltype(FL_NORMAL_LABEL);
            bend->labelfont(0);
            bend->labelsize(10);
            bend->labelcolor(FL_FOREGROUND_COLOR);
            bend->maximum(127);
            bend->step(1);
            bend->callback((Fl_Callback*)cb_bend);
            bend->align(Fl_Align(FL_ALIGN_RIGHT));
            bend->when(FL_WHEN_CHANGED);
            o->value(pars->PBendAdjust);
            o->setValueType(VC_PitchBend);
          } // WidgetPDial* bend
          { WidgetPDial* o = offset = new WidgetPDial(140, 280, 20, 20, "Offset");
            offset->tooltip("Offset of the frequency in Hz.");
            offset->box(FL_ROUND_UP_BOX);
            offset->color(FL_BACKGROUND_COLOR);
            offset->selection_color(FL_INACTIVE_COLOR);
            offset->labeltype(FL_NORMAL_LABEL);
            offset->labelfont(0);
            offset->labelsize(10);
            offset->labelcolor(FL_FOREGROUND_COLOR);
            offset->maximum(127);
            offset->step(1);
            offset->callback((Fl_Callback*)cb_offset);
            offset->align(Fl_Align(FL_ALIGN_RIGHT));
            offset->when(FL_WHEN_CHANGED);
            o->value(pars->POffsetHz);
            o->setValueType(VC_FreqOffsetHz);
          } // WidgetPDial* offset
          { Fl_Check_Button2* o = hz440 = new Fl_Check_Button2(410, 284, 50, 15, "440Hz");
            hz440->tooltip("set the base frequency to 440Hz");
            hz440->box(FL_NO_BOX);
            hz440->down_box(FL_DOWN_BOX);
            hz440->color(FL_BACKGROUND_COLOR);
            hz440->selection_color(FL_FOREGROUND_COLOR);
            hz440->labeltype(FL_NORMAL_LABEL);
            hz440->labelfont(1);
            hz440->labelsize(10);
            hz440->labelcolor(FL_FOREGROUND_COLOR);
            hz440->callback((Fl_Callback*)cb_hz440);
            hz440->align(Fl_Align(FL_ALIGN_LEFT|FL_ALIGN_INSIDE));
            hz440->when(FL_WHEN_RELEASE);
            o->value(pars->Pfixedfreq);
          } // Fl_Check_Button2* hz440
          { WidgetPDial* o = fixedfreqetdial = new WidgetPDial(465, 280, 20, 20, "Eq.T.");
            fixedfreqetdial->tooltip("How the frequency varies according to the keyboard (leftmost for fixed freque\
ncy)");
            fixedfreqetdial->box(FL_ROUND_UP_BOX);
            fixedfreqetdial->color(FL_BACKGROUND_COLOR);
            fixedfreqetdial->selection_color(FL_INACTIVE_COLOR);
            fixedfreqetdial->labeltype(FL_NORMAL_LABEL);
            fixedfreqetdial->labelfont(0);
            fixedfreqetdial->labelsize(10);
            fixedfreqetdial->labelcolor(FL_FOREGROUND_COLOR);
            fixedfreqetdial->maximum(127);
            fixedfreqetdial->step(1);
            fixedfreqetdial->callback((Fl_Callback*)cb_fixedfreqetdial);
            fixedfreqetdial->align(Fl_Align(FL_ALIGN_RIGHT));
            fixedfreqetdial->when(FL_WHEN_CHANGED);
            o->value(pars->PfixedfreqET);
            if (pars->Pfixedfreq==0) o->deactivate();
            o->setValueType(VC_FixedFreqET);
          } // WidgetPDial* fixedfreqetdial
          { mwheel_slider_rev* o = detune = new mwheel_slider_rev(57, 305, 433, 15);
            detune->tooltip("Fine Detune (cents)");
            detune->type(5);
            detune->box(FL_THIN_DOWN_BOX);
            detune->color(FL_BACKGROUND_COLOR);
            detune->selection_color(FL_BACKGROUND_COLOR);
            detune->labeltype(FL_NORMAL_LABEL);
            detune->labelfont(0);
            detune->labelsize(14);
            detune->labelcolor(FL_FOREGROUND_COLOR);
            detune->minimum(-8192);
            detune->maximum(8191);
            detune->step(1);
            detune->callback((Fl_Callback*)cb_detune);
            detune->align(Fl_Align(FL_ALIGN_BOTTOM));
            detune->when(FL_WHEN_CHANGED);
            o->value(pars->PDetune-8192);
          } // mwheel_slider_rev* detune
          { Fl_Value_Output* o = detunevalueoutput = new Fl_Value_Output(12, 305, 45, 15, "Detune");
            detunevalueoutput->labelsize(10);
            detunevalueoutput->minimum(-5000);
            detunevalueoutput->maximum(5000);
            detunevalueoutput->textfont(1);
            detunevalueoutput->textsize(10);
            detunevalueoutput->callback((Fl_Callback*)cb_detunevalueoutput);
            detunevalueoutput->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->step(0.01, 1);
            o->value(getDetune(pars->PDetuneType,0,pars->PDetune));
          } // Fl_Value_Output* detunevalueoutput
          { Fl_Counter* o = octave = new Fl_Counter(510, 305, 45, 15, "Octave");
            octave->tooltip("Octave");
            octave->type(1);
            octave->color((Fl_Color)237);
            octave->selection_color(FL_FOREGROUND_COLOR);
            octave->labelsize(10);
            octave->minimum(-8);
            octave->maximum(7);
            octave->step(1);
            octave->textfont(1);
            octave->textsize(11);
            octave->callback((Fl_Callback*)cb_octave);
            octave->align(Fl_Align(FL_ALIGN_TOP));
            int k=pars->PCoarseDetune/1024;
            if (k>=8) k-=16;
            o->value(k);
          } // Fl_Counter* octave
          { Fl_Choice* o = detunetype = new Fl_Choice(495, 345, 75, 15, "Detune Type");
            detunetype->down_box(FL_BORDER_BOX);
            detunetype->labelsize(10);
            detunetype->textfont(1);
            detunetype->textsize(10);
            detunetype->callback((Fl_Callback*)cb_detunetype);
            detunetype->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            o->add("L35cents");o->add("L10cents");o->add("E100cents");o->add("E1200cents");
            o->value(pars->PDetuneType - 1);
          } // Fl_Choice* detunetype
          { Fl_Counter* o = coarsedet = new Fl_Counter(500, 375, 60, 20, "Coarse det.");
            coarsedet->tooltip("Coarse Detune");
            coarsedet->labelsize(10);
            coarsedet->minimum(-64);
            coarsedet->maximum(63);
            coarsedet->step(1);
            coarsedet->textfont(1);
            coarsedet->textsize(11);
            coarsedet->callback((Fl_Callback*)cb_coarsedet);
            coarsedet->align(Fl_Align(FL_ALIGN_TOP_LEFT));
            int k=pars->PCoarseDetune%1024;
            if (k>=512) k-=1024;
            o->value(k);
            o->lstep(10);
          } // Fl_Counter* coarsedet
          frequencygrp->end();
        } // Fl_Group* frequencygrp
        envelopes->end();
      } // Fl_Group* envelopes
      o->end();
    } // Fl_Tabs* o
    { padExport = new Fl_Button(15, 410, 123, 24, "Export");
      padExport->tooltip("Export samples as wav file");
      padExport->box(FL_THIN_UP_BOX);
      padExport->labelfont(1);
      padExport->labelsize(12);
      padExport->callback((Fl_Callback*)cb_padExport);
      padExport->align(Fl_Align(FL_ALIGN_WRAP));
    } // Fl_Button* padExport
    { applybox = new Fl_Box(236, 407, 139, 31);
      applybox->box(FL_THIN_UP_BOX);
      applybox->color((Fl_Color)237);
      applybox->selection_color((Fl_Color)29);
    } // Fl_Box* applybox
    { applybutton = new Fl_Button(242, 412, 128, 22, "Apply Changes");
      applybutton->tooltip("Rebuild wavetable to render the currently defined spectrum and line shape; al\
so re-randomise phases");
      applybutton->box(FL_THIN_UP_BOX);
      applybutton->labelfont(1);
      applybutton->labelsize(12);
      applybutton->callback((Fl_Callback*)cb_applybutton);
    } // Fl_Button* applybutton
    { padCopy = new Fl_Button(415, 414, 25, 15, "C");
      padCopy->box(FL_THIN_UP_BOX);
      padCopy->color((Fl_Color)179);
      padCopy->labelfont(1);
      padCopy->labelsize(11);
      padCopy->labelcolor(FL_BACKGROUND2_COLOR);
      padCopy->callback((Fl_Callback*)cb_padCopy);
    } // Fl_Button* padCopy
    { padPaste = new Fl_Button(449, 414, 25, 15, "P");
      padPaste->box(FL_THIN_UP_BOX);
      padPaste->color((Fl_Color)179);
      padPaste->labelfont(1);
      padPaste->labelsize(11);
      padPaste->labelcolor(FL_BACKGROUND2_COLOR);
      padPaste->callback((Fl_Callback*)cb_padPaste);
    } // Fl_Button* padPaste
    { padClose = new Fl_Button(505, 410, 61, 24, "Close");
      padClose->tooltip("Right click: also reopen previous");
      padClose->box(FL_THIN_UP_BOX);
      padClose->labelfont(1);
      padClose->labelsize(12);
      padClose->callback((Fl_Callback*)cb_padClose);
    } // Fl_Button* padClose
    o->copy_label(synth->getGuiMaster()->setPartWindowTitle("PadSynth").c_str());
    padDW = o->w(); padDH = o->h();
    padnotewindow->size_range(padDW, padDH, 0, 0, 0, 0, 1);
    padnotewindow->end();
    padnotewindow->resizable(padnotewindow);
  } // Fl_Double_Window* padnotewindow
  return padnotewindow;
}

Fl_Double_Window* PADnoteUI::make_randWalkWindow() {
  { Fl_Double_Window* o = randWalkWindow = new Fl_Double_Window(240, 155, "PadSynth - Random Walk");
    randWalkWindow->user_data((void*)(this));
    { randomProp = new Fl_Group(0, 0, 240, 154);
      { plinth = new Fl_Box(6, 6, 58, 58);
        plinth->box(FL_UP_BOX);
        plinth->color((Fl_Color)48);
      } // Fl_Box* plinth
      { WidgetPDial* o = rebuildTrigger = new WidgetPDial(20, 25, 30, 30, "Retrigger");
        rebuildTrigger->tooltip("Trigger rebuild of PAD Wavetable after generating this amount of sample time;\
 possibly randomise the other parameters on each rebuild. WARNING: expensive!");
        rebuildTrigger->box(FL_ROUND_UP_BOX);
        rebuildTrigger->color(FL_BACKGROUND_COLOR);
        rebuildTrigger->selection_color(FL_INACTIVE_COLOR);
        rebuildTrigger->labeltype(FL_NORMAL_LABEL);
        rebuildTrigger->labelfont(0);
        rebuildTrigger->labelsize(10);
        rebuildTrigger->labelcolor(FL_FOREGROUND_COLOR);
        rebuildTrigger->minimum(-1);
        rebuildTrigger->maximum(2479);
        rebuildTrigger->step(1);
        rebuildTrigger->callback((Fl_Callback*)cb_rebuildTrigger);
        rebuildTrigger->align(Fl_Align(FL_ALIGN_TOP));
        rebuildTrigger->when(FL_WHEN_CHANGED);
        //
            int dialSetting = millisec2logDial(pars->PrebuildTrigger);
            if (dialSetting >= 2300)
                 dialSetting -= 2300;
            else dialSetting = -1;
            o->value(dialSetting);
        o->setValueType(VC_Retrigger);
      } // WidgetPDial* rebuildTrigger
      { WidgetPDial* o = randWalkDetune = new WidgetPDial(100, 25, 30, 30, "Detune");
        randWalkDetune->tooltip("Let the voice detuning perform a random walk on each wavetable rebuild, withi\
n this spread..");
        randWalkDetune->box(FL_ROUND_UP_BOX);
        randWalkDetune->color(FL_BACKGROUND_COLOR);
        randWalkDetune->selection_color(FL_INACTIVE_COLOR);
        randWalkDetune->labeltype(FL_NORMAL_LABEL);
        randWalkDetune->labelfont(0);
        randWalkDetune->labelsize(10);
        randWalkDetune->labelcolor(FL_FOREGROUND_COLOR);
        randWalkDetune->maximum(127);
        randWalkDetune->step(1);
        randWalkDetune->callback((Fl_Callback*)cb_randWalkDetune);
        randWalkDetune->align(Fl_Align(FL_ALIGN_TOP));
        randWalkDetune->when(FL_WHEN_CHANGED);
        o->value(pars->PrandWalkDetune);
        o->setValueType(VC_RandWalkSpread);
      } // WidgetPDial* randWalkDetune
      { WidgetPDial* o = randWalkFilterFreq = new WidgetPDial(180, 25, 30, 30, "Filter Freq");
        randWalkFilterFreq->tooltip("Filter cutoff freq random walk on wavetable rebuild, within this spread..");
        randWalkFilterFreq->box(FL_ROUND_UP_BOX);
        randWalkFilterFreq->color(FL_BACKGROUND_COLOR);
        randWalkFilterFreq->selection_color(FL_INACTIVE_COLOR);
        randWalkFilterFreq->labeltype(FL_NORMAL_LABEL);
        randWalkFilterFreq->labelfont(0);
        randWalkFilterFreq->labelsize(10);
        randWalkFilterFreq->labelcolor(FL_FOREGROUND_COLOR);
        randWalkFilterFreq->maximum(127);
        randWalkFilterFreq->step(1);
        randWalkFilterFreq->callback((Fl_Callback*)cb_randWalkFilterFreq);
        randWalkFilterFreq->align(Fl_Align(FL_ALIGN_TOP));
        randWalkFilterFreq->when(FL_WHEN_CHANGED);
        o->value(pars->PrandWalkFilterFreq);
        o->setValueType(VC_RandWalkSpread);
      } // WidgetPDial* randWalkFilterFreq
      { WidgetPDial* o = randWalkBandwidth = new WidgetPDial(20, 85, 30, 30, "Bandwidth");
        randWalkBandwidth->tooltip("Bandwidth random walk on wavetable rebuild, within this spread..");
        randWalkBandwidth->box(FL_ROUND_UP_BOX);
        randWalkBandwidth->color(FL_BACKGROUND_COLOR);
        randWalkBandwidth->selection_color(FL_INACTIVE_COLOR);
        randWalkBandwidth->labeltype(FL_NORMAL_LABEL);
        randWalkBandwidth->labelfont(0);
        randWalkBandwidth->labelsize(10);
        randWalkBandwidth->labelcolor(FL_FOREGROUND_COLOR);
        randWalkBandwidth->maximum(127);
        randWalkBandwidth->step(1);
        randWalkBandwidth->callback((Fl_Callback*)cb_randWalkBandwidth);
        randWalkBandwidth->align(Fl_Align(FL_ALIGN_TOP));
        randWalkBandwidth->when(FL_WHEN_CHANGED);
        o->value(pars->PrandWalkBandwidth);
        o->setValueType(VC_RandWalkSpread);
      } // WidgetPDial* randWalkBandwidth
      { WidgetPDial* o = randWalkProfileWidth = new WidgetPDial(100, 85, 30, 30, "Line Width");
        randWalkProfileWidth->tooltip("Profile width parameter random walk on wavetable rebuild, within this spread.\
.");
        randWalkProfileWidth->box(FL_ROUND_UP_BOX);
        randWalkProfileWidth->color(FL_BACKGROUND_COLOR);
        randWalkProfileWidth->selection_color(FL_INACTIVE_COLOR);
        randWalkProfileWidth->labeltype(FL_NORMAL_LABEL);
        randWalkProfileWidth->labelfont(0);
        randWalkProfileWidth->labelsize(10);
        randWalkProfileWidth->labelcolor(FL_FOREGROUND_COLOR);
        randWalkProfileWidth->maximum(127);
        randWalkProfileWidth->step(1);
        randWalkProfileWidth->callback((Fl_Callback*)cb_randWalkProfileWidth);
        randWalkProfileWidth->align(Fl_Align(FL_ALIGN_TOP));
        randWalkProfileWidth->when(FL_WHEN_CHANGED);
        o->value(pars->PrandWalkProfileWidth);
        o->setValueType(VC_RandWalkSpread);
      } // WidgetPDial* randWalkProfileWidth
      { WidgetPDial* o = randWalkProfileStretch = new WidgetPDial(180, 85, 30, 30, "Profile Stretch");
        randWalkProfileStretch->tooltip("Profile stretch parameter random walk on wavetable rebuild, within this sprea\
d..");
        randWalkProfileStretch->box(FL_ROUND_UP_BOX);
        randWalkProfileStretch->color(FL_BACKGROUND_COLOR);
        randWalkProfileStretch->selection_color(FL_INACTIVE_COLOR);
        randWalkProfileStretch->labeltype(FL_NORMAL_LABEL);
        randWalkProfileStretch->labelfont(0);
        randWalkProfileStretch->labelsize(10);
        randWalkProfileStretch->labelcolor(FL_FOREGROUND_COLOR);
        randWalkProfileStretch->maximum(127);
        randWalkProfileStretch->step(1);
        randWalkProfileStretch->callback((Fl_Callback*)cb_randWalkProfileStretch);
        randWalkProfileStretch->align(Fl_Align(FL_ALIGN_TOP));
        randWalkProfileStretch->when(FL_WHEN_CHANGED);
        o->value(pars->PrandWalkProfileStretch);
        o->setValueType(VC_RandWalkSpread);
      } // WidgetPDial* randWalkProfileStretch
      { randClose = new Fl_Button(175, 124, 50, 20, "Close");
        randClose->box(FL_THIN_UP_BOX);
        randClose->labelsize(12);
        randClose->callback((Fl_Callback*)cb_randClose);
      } // Fl_Button* randClose
      randomProp->end();
    } // Fl_Group* randomProp
    randDW = o->w(); randDH = o->h();
    o->size_range(randDW, randDH, 0, 0, 0, 0, 1);
    randWalkWindow->end();
    randWalkWindow->resizable(randWalkWindow);
  } // Fl_Double_Window* randWalkWindow
  return randWalkWindow;
}

void PADnoteUI::show_randWalk() {
  //
        int fetchW, fetchH, fetchX, fetchY, fetchO;
        loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, string("padRandWalk"));
  
        if (fetchW < randDW || fetchH < randDH)
        {
            fetchW = randDW;
            fetchH = randDH;
        }
        checkSane(fetchX, fetchY, fetchW, fetchH, randDW, randDH);
  
        randWalkWindow->resize(fetchX, fetchY, fetchW, fetchH);
        randWalkWindow->show();
        randRtext();
        randSeen = true;
}

void PADnoteUI::randRtext() {
  //
            int w = randWalkWindow->w();
            int h = randWalkWindow->h();
            float dW = w / float(randDW);
            float dH = h / float(randDH);
            float dScale;
            if (dW < dH)
                dScale = dW;
            else
                dScale = dH;
            if (dScale < 0.2f)
                dScale = 0.2f;
  
            int size10 = int(10 * dScale);
  //        int size11 = int(11 * dScale);
            int size12 = int(12 * dScale);
  
            rebuildTrigger->labelsize(size10);
            randWalkDetune->labelsize(size10);
            randWalkBandwidth->labelsize(size10);
            randWalkFilterFreq->labelsize(size10);
            randWalkProfileWidth->labelsize(size10);
            randWalkProfileStretch->labelsize(size10);
            randClose->labelsize(size12);
}

void PADnoteUI::Showpad() {
  //
      int fetchW, fetchH, fetchX, fetchY, fetchO;
      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "PadSynth");
      if (fetchW < padDW || fetchH < padDH)
      {
          fetchW = padDW;
          fetchH = padDH;
      }
      checkSane(fetchX, fetchY, fetchW, fetchH, padDW, padDH);
  
      padnotewindow->resize(fetchX, fetchY, fetchW, fetchH);
      padnotewindow->show();
      lastpadW = 0;
      padSeen = true;
}

void PADnoteUI::padRtext() {
  //
      if (oscui)
      {
          if (oscui->osceditUI->visible() && lastWaveW != oscui->osceditUI->w())
          {
              lastWaveW = oscui->osceditUI->w();
              oscui->waveRtext();
          }
      }
  
      if (randWalkWindow->visible() && lastRandW != randWalkWindow->w())
      {
          randRtext();
          lastRandW = randWalkWindow->w();
      }
  
      if (resui->resonancewindow->visible() && lastResuiW != resui->resonancewindow->w())
      {
          resui->resonanceRtext();
          lastResuiW = resui->resonancewindow->w();
      }
  
      ampenv->wincheck();
      freqenv->wincheck();
      filterenv->wincheck();
  
      if (padnotewindow->w() == lastpadW)
          return;
  
      lastpadW = padnotewindow->w();
  
      float dScale = padnotewindow->w() / float(padDW);
      if (dScale < 0.2f)
          dScale = 0.2f;
  
      int size = int(10 * dScale);
      int size11 = int(11 * dScale);
      int size12 = int(12 * dScale);
  
      amplfo->lfoRtext(dScale);
      freqlfo->lfoRtext(dScale);
      filterlfo->lfoRtext(dScale);
  
      ampenv->envRtext(dScale);
      freqenv->envRtext(dScale);
      filterenv->envRtext(dScale);
  
      filterui->filterRtext(dScale);
  
      harmonicstructuregroup->labelsize(size12);
      harmonicprofile->labelsize(size12);
      hpbasetype->labelsize(size);
          hpbasetype->textsize(size);
      hpbasepar1->labelsize(size);
      hpfreqmult->labelsize(size);
      hpmpar1->labelsize(size);
      hpmfreq->labelsize(size);
      hpwidth->labelsize(size);
      hponehalf->labelsize(size);
          hponehalf->textsize(size);
  
      hpampmode->labelsize(size);
          hpampmode->textsize(size);
      hpamppar1->labelsize(size);
      hpamppar2->labelsize(size);
      hpamptype->labelsize(size);
          hpamptype->textsize(size);
      hpautoscale->labelsize(size11);
  
      bwdial->labelsize(size);
      bwcents->labelsize(size);
          bwcents->textsize(size11);
  
      bwscale->labelsize(size);
          bwscale->textsize(size);
  
      spectrummode->labelsize(size);
          spectrummode->textsize(size);
  
      hrpospar1->labelsize(size);
      hrpospar2->labelsize(size);
      hrpospar3->labelsize(size);
      hrpostype->labelsize(size);
          hrpostype->textsize(size11);
  
      qbasenote->labelsize(size11);
          qbasenote->textsize(size12);
      qsmpoct->labelsize(size11);
          qsmpoct->textsize(size12);
      qoct->labelsize(size11);
          qoct->textsize(size12);
  
      qsamplesize->labelsize(size);
          qsamplesize->textsize(size11);
      xFadeDial->labelsize(size);
      randWalkUI->labelsize(size12);
  
      resonance->labelsize(size12);
      waveform->labelsize(size12);
  
      filtergrp->labelsize(size11);
  
      envelopes->labelsize(size12);
      ampgrp->labelsize(size11);
      volume->labelsize(size);
      vsns->labelsize(size);
      pan->labelsize(size);
      panwidth->labelsize(size);
      randompan->labelsize(size11);
      stereo->labelsize(size11);
      dpop->labelsize(size);
      pstr->labelsize(size);
      pt->labelsize(size);
      pstc->labelsize(size);
      pvel->labelsize(size);
  
      frequencygrp->labelsize(size11);
      bend->labelsize(size);
      offset->labelsize(size);
      hz440->labelsize(size);
      fixedfreqetdial->labelsize(size);
      detune->labelsize(size);
          detunevalueoutput->labelsize(size);
              detunevalueoutput->textsize(size);
      octave->labelsize(size);
          octave->textsize(size11);
      detunetype->labelsize(size);
          detunetype->textsize(size);
      coarsedet->labelsize(size);
          coarsedet->textsize(size11);
  
      padExport->labelsize(size12);
      applybutton->labelsize(size12);
      padCopy->labelsize(size11);
      padPaste->labelsize(size11);
      padClose->labelsize(size12);
  
      padnotewindow->redraw();
}

void PADnoteUI::send_data(int action, int control, float value, int type, int insert , int miscmsg ) {
  //
      unsigned char partnum = npart;
      if (miscmsg != UNUSED)
      {
          partnum = TOPLEVEL::section::main;
          action = TOPLEVEL::action::lowPrio;
      }
      type |= TOPLEVEL::type::Write;
      collect_data(synth, value, action, type, control, partnum, kititem, 2, insert, UNUSED, UNUSED, miscmsg);
}

void PADnoteUI::returns_update(CommandBlock *getData) {
  //
      float value = getData->data.value;
      bool value_bool = _SYS_::F2B(value);
      bool wasFromHere = ((getData->data.source & TOPLEVEL::action::noAction) == TOPLEVEL::action::fromGUI);
      unsigned char control = getData->data.control;
      unsigned char miscmsg = getData->data.miscmsg;
      float result;
      string name;
  
      switch(control)
      {
          case PADSYNTH::control::volume:
              volume->value(value);
              break;
  
          case PADSYNTH::control::velocitySense:
              vsns->value(value);
              break;
  
          case PADSYNTH::control::panning:
              pan->value(value);
              break;
          case PADSYNTH::control::enableRandomPan:
              randompan->value(value_bool);
              if (value_bool)
                  panwidth->activate();
              else
                  panwidth->deactivate();
              break;
  
          case PADSYNTH::control::randomWidth:
              panwidth->value(value);
              break;
  
          case PADSYNTH::control::bandwidth:
              bwdial->value(value);
              result = powf(value / 1000.0f, 1.1f);
              result = power<10>(result * 4.0f) * 0.25f;
              bwcents->value(result);
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::bandwidthScale:
              bwscale->value(lrint(value));
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::spectrumMode:
              spectrummode->value(lrint(value));
              if (pars->Pmode == 0)
              {
                  bwprofilegroup->activate();
                  bwdial->activate();
                  bwcents->activate();
                  hprofile->activate();
                  hprofile->color(54);
                  bwscale->activate();
              }
              else
              {
                  bwprofilegroup->deactivate();
                  bwdial->deactivate();
                  bwcents->deactivate();
                  hprofile->deactivate();
                  hprofile->color(48);
                  bwscale->deactivate();
              }
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::xFadeUpdate:
              {
                  int dialSetting = millisec2logDial(value);
                  xFadeDial->value(dialSetting);
                  cbwidget->do_callback();
              }
              break;
  
          case PADSYNTH::control::rebuildTrigger:
              {
                  int dialSetting = millisec2logDial(value);
                  // remove a socket of 200ms from the dial setting, editable time in the UI starts > 200ms
                  if (dialSetting >= 2300) dialSetting -= 2300;
                  else dialSetting = -1;
                  rebuildTrigger->value(dialSetting);
                  cbwidget->do_callback();
              }
              break;
  
          case PADSYNTH::control::detuneFrequency:
              detune->value(lrint(value));
              detunevalueoutput->do_callback();
              break;
  
          case PADSYNTH::control::equalTemperVariation:
              fixedfreqetdial->value(lrint(value));
              break;
  
          case PADSYNTH::control::baseFrequencyAs440Hz:
              hz440->value(value_bool);
              if (value_bool)
                  fixedfreqetdial->activate();
              else
                  fixedfreqetdial->deactivate();
              break;
  
          case PADSYNTH::control::octave:
              octave->value(lrint(value));
              break;
  
          case PADSYNTH::control::detuneType:
              detunetype->value(lrint(value) - 1);
              break;
  
          case PADSYNTH::control::coarseDetune:
              coarsedet->value(lrint(value));
              break;
  
          case PADSYNTH::control::pitchBendAdjustment:
              bend->value(lrint(value));
              break;
  
          case PADSYNTH::control::pitchBendOffset:
              offset->value(lrint(value));
              break;
  
          case PADSYNTH::control::overtoneParameter1:
              hrpospar1->value(lrint(value));
              overtonepos->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::overtoneParameter2:
              hrpospar2->value(lrint(value));
              overtonepos->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::overtoneForceHarmonics:
              hrpospar3->value(lrint(value));
              overtonepos->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::overtonePosition:
              hrpostype->value(lrint(value));
              if (hrpostype->value() > 0)
              {
                  hrgroup->activate();
                  if (hrpostype->value() < 7)
                      hrpospar2->activate();
                  else
                      hrpospar2->deactivate();
              }
              else
                  hrgroup->deactivate();
              overtonepos->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::baseWidth:
              hpbasepar1->value(lrint(value));
              hprofile->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::frequencyMultiplier:
              hpfreqmult->value(lrint(value));
              hprofile->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::modulatorStretch:
              hpmpar1->value(lrint(value));
              hprofile->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::modulatorFrequency:
              hpmfreq->value(lrint(value));
              hprofile->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::size:
              hpwidth->value(lrint(value));
              hprofile->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::baseType:
              hpbasetype->value(lrint(value));
              hprofile->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::harmonicSidebands:
              hponehalf->value(lrint(value));
              hprofile->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::spectralWidth:
              hpamppar1->value(value);
              hprofile->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::spectralAmplitude:
              hpamppar2->value(value);
              hprofile->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::amplitudeMultiplier:
              hpamptype->value(lrint(value));
              if (value_bool)
                  ampgroup->activate();
              else
                  ampgroup->deactivate();
              hprofile->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::amplitudeMode:
              hpampmode->value(lrint(value));
              hprofile->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::autoscale:
              hpautoscale->value(lrint(value));
              hprofile->redraw();
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::harmonicBase:
              qbasenote->value(lrint(value));
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::samplesPerOctave:
              qsmpoct->value(lrint(value));
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::numberOfOctaves:
              qoct->value(lrint(value));
              cbwidget->do_callback();
              break;
  
          case PADSYNTH::control::sampleSize:
              qsamplesize->value(lrint(value));
              cbwidget->do_callback();
              break;
  
          case MAIN::control::exportPadSynthSamples:
              name = textMsgBuffer.fetch(miscmsg);
              if (name.find("FAILED") == 1)
              {
                  if (wasFromHere)
                      alert(synth, "Some samples have failed.");
              }
              padStatus->activateStage(PADStatus::CLEAN);
              break;
  
          case PADSYNTH::control::stereo:
              stereo->value(value_bool);
              break;
  
          case PADSYNTH::control::dePop:
              dpop->value(value);
              break;
  
          case PADSYNTH::control::punchStrength:
              pstr->value(value);
              break;
  
          case PADSYNTH::control::punchDuration:
              pt->value(value);
              break;
  
          case PADSYNTH::control::punchStretch:
              pstc->value(value);
              break;
  
          case PADSYNTH::control::punchVelocity:
              pvel->value(value);
              break;
  
          case PADSYNTH::control::randWalkDetune:
              randWalkDetune->value(value);
              break;
  
          case PADSYNTH::control::randWalkBandwidth:
              randWalkBandwidth->value(value);
              break;
  
          case PADSYNTH::control::randWalkFilterFreq:
              randWalkFilterFreq->value(value);
              break;
  
          case PADSYNTH::control::randWalkProfileWidth:
              randWalkProfileWidth->value(value);
              break;
  
          case PADSYNTH::control::randWalkProfileStretch:
              randWalkProfileStretch->value(value);
              break;
  
          case PADSYNTH::control::applyChanges:
              if (lrint(value) == 0 and getData->data.offset != UNUSED)
                  padStatus->handleStateMessage(*getData);
              break;
  
      }
}

void PADnoteUI::applyButton(Fl_Color colour, const char *const text) {
  //
      applybutton->color(colour);
      applybutton->label(text);
      applybutton->redraw();
      if (oscui)
      {
          oscui->applybutton->color(colour);
          // not changing text due to limited space
          oscui->applybutton->redraw();
      }
      if (resui)
      {
          resui->applybutton->color(colour);
          resui->applybutton->redraw();
      }
}

PADnoteUI::PADnoteUI(PADnoteParameters *parameters) {
  //
      synth = parameters->getSynthEngine();
      pars = parameters;
      npart = parameters->partID;
      kititem = parameters->kitID;
      padSeen = false;
      randSeen = false;
      lastWaveW = 0;
      lastRandW = 0;
      lastpadW = 0;
      oscui = NULL;
      lastResuiW = 0;
      resui = new ResonanceUI(pars->resonance.get(), npart, kititem, 2);
      make_randWalkWindow();
      make_window();
      padStatus.reset(new PADStatus(npart,kititem));
      // setup handler to indicate PADSynth wavetable build status
      padStatus->on(PADStatus::CLEAN,   [&]() { applyButton(FL_GRAY, "Rebuild Wave"); });
      padStatus->on(PADStatus::FADING,  [&]() { applyButton(FL_YELLOW, "fading..."); });
      padStatus->on(PADStatus::PENDING, [&]() { applyButton(fl_color_average(FL_CYAN, FL_DARK_BLUE, 0.8), "pending Wave"); });
      padStatus->on(PADStatus::BUILDING,[&]() { applyButton(fl_color_average(FL_RED, FL_DARK_MAGENTA, 0.6), "rebuilding..."); });
      padStatus->on(PADStatus::DIRTY,   [&]() { applyButton(FL_RED, "Apply Changes"); });
}

PADnoteUI::~PADnoteUI() {
  //
      if (oscui)
          delete(oscui);
      if (resui)
          delete(resui);
      if (randWalkWindow) {
          if (randSeen)
              saveWin(synth, randWalkWindow->w(), randWalkWindow->h(), randWalkWindow->x(), randWalkWindow->y(),randWalkWindow->visible(), string("padRandWalk"));
          randWalkWindow->hide();
          delete (randWalkWindow);
      }
      if (padSeen)
          saveWin(synth, padnotewindow->w(), padnotewindow->h(), padnotewindow->x(), padnotewindow->y(), padSeen, "PadSynth");
      padnotewindow->hide();
      delete(padnotewindow);
}
