/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiler;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.ui.actions.ActionUtils;
import org.graalvm.visualvm.core.ui.actions.SingleDataSourceAction;
import org.graalvm.visualvm.lib.profiler.LoadedSnapshot;
import org.graalvm.visualvm.lib.profiler.SnapshotsListener;
import org.graalvm.visualvm.lib.profiler.actions.TakeSnapshotAction;
import org.graalvm.visualvm.profiler.ProfilerSupport;
import org.graalvm.visualvm.profiling.snapshot.ProfilerSnapshotsSupport;
import org.openide.util.NbBundle;

final class ProfilerSnapshotAction
extends SingleDataSourceAction<Application> {
    private static final Logger LOGGER = Logger.getLogger(ProfilerSnapshotAction.class.getName());
    private static final String NB_PROFILER_SNAPSHOTS_STORAGE = "config" + File.separator + "NBProfiler" + File.separator + "Config" + File.separator + "Settings";
    private final TakeSnapshotAction originalAction = TakeSnapshotAction.getInstance();
    private boolean openNextSnapshot = true;
    private static ProfilerSnapshotAction instance;

    public static synchronized ProfilerSnapshotAction instance() {
        if (instance == null) {
            instance = new ProfilerSnapshotAction();
        }
        return instance;
    }

    protected void actionPerformed(Application dataSource, ActionEvent actionEvent) {
        this.openNextSnapshot = (actionEvent.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0;
        this.originalAction.performAction();
    }

    protected boolean isEnabled(Application application) {
        return ProfilerSupport.getInstance().getProfiledApplication() == application && this.originalAction.isEnabled();
    }

    protected void initialize() {
        if (ProfilerSupport.getInstance().isInitialized()) {
            super.initialize();
            this.originalAction.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("enabled".equals(evt.getPropertyName())) {
                        ProfilerSnapshotAction.this.updateState(ActionUtils.getSelectedDataSources(Application.class));
                    }
                }
            });
        } else {
            this.setEnabled(false);
        }
    }

    private ProfilerSnapshotAction() {
        super(Application.class);
        this.putValue("Name", NbBundle.getMessage(ProfilerSnapshotAction.class, (String)"MSG_Profiler_Snapshot"));
        this.putValue("ShortDescription", NbBundle.getMessage(ProfilerSnapshotAction.class, (String)"DESCR_Profiler_Snapshot"));
    }

    public static class SnapshotsListenerImpl
    implements SnapshotsListener {
        public void snapshotLoaded(LoadedSnapshot snapshot) {
        }

        public void snapshotRemoved(LoadedSnapshot snapshot) {
        }

        public void snapshotTaken(LoadedSnapshot snapshot) {
        }

        public void snapshotSaved(LoadedSnapshot snapshot) {
            try {
                Application profiledApplication = ProfilerSupport.getInstance().getProfiledApplication();
                File snapshotFile = snapshot.getFile();
                if (profiledApplication != null && snapshotFile.getCanonicalPath().contains(NB_PROFILER_SNAPSHOTS_STORAGE)) {
                    File newSnapshotFile = Utils.getUniqueFile((File)profiledApplication.getStorage().getDirectory(), (String)snapshotFile.getName());
                    if (!snapshotFile.renameTo(newSnapshotFile)) {
                        Utils.copyFile((File)snapshotFile, (File)newSnapshotFile);
                        snapshotFile.deleteOnExit();
                    }
                    snapshot.setFile(newSnapshotFile);
                    ProfilerSnapshotsSupport pss = ProfilerSnapshotsSupport.getInstance();
                    ProfilerSnapshotAction psa = ProfilerSnapshotAction.instance();
                    pss.createSnapshot(newSnapshotFile, profiledApplication, psa.openNextSnapshot);
                    psa.openNextSnapshot = true;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error handling saved profiler snapshot", e);
            }
        }
    }
}

