/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.graph.ElementTypesAreNonnullByDefault;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
class MapIteratorCache<K, V> {
    private final Map<K, V> backingMap;
    @CheckForNull
    private volatile transient Map.Entry<K, V> cacheEntry;

    MapIteratorCache(Map<K, V> backingMap) {
        this.backingMap = Preconditions.checkNotNull(backingMap);
    }

    @CheckForNull
    @CanIgnoreReturnValue
    final V put(K key2, V value) {
        Preconditions.checkNotNull(key2);
        Preconditions.checkNotNull(value);
        this.clearCache();
        return this.backingMap.put(key2, value);
    }

    @CheckForNull
    @CanIgnoreReturnValue
    final V remove(Object key2) {
        Preconditions.checkNotNull(key2);
        this.clearCache();
        return this.backingMap.remove(key2);
    }

    final void clear() {
        this.clearCache();
        this.backingMap.clear();
    }

    @CheckForNull
    V get(Object key2) {
        Preconditions.checkNotNull(key2);
        V value = this.getIfCached(key2);
        if (value == null) {
            return this.getWithoutCaching(key2);
        }
        return value;
    }

    @CheckForNull
    final V getWithoutCaching(Object key2) {
        Preconditions.checkNotNull(key2);
        return this.backingMap.get(key2);
    }

    final boolean containsKey(@CheckForNull Object key2) {
        return this.getIfCached(key2) != null || this.backingMap.containsKey(key2);
    }

    final Set<K> unmodifiableKeySet() {
        return new AbstractSet<K>(){

            @Override
            public UnmodifiableIterator<K> iterator() {
                final Iterator entryIterator = MapIteratorCache.this.backingMap.entrySet().iterator();
                return new UnmodifiableIterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return entryIterator.hasNext();
                    }

                    @Override
                    public K next() {
                        Map.Entry entry = (Map.Entry)entryIterator.next();
                        MapIteratorCache.this.cacheEntry = entry;
                        return entry.getKey();
                    }
                };
            }

            @Override
            public int size() {
                return MapIteratorCache.this.backingMap.size();
            }

            @Override
            public boolean contains(@CheckForNull Object key2) {
                return MapIteratorCache.this.containsKey(key2);
            }
        };
    }

    @CheckForNull
    V getIfCached(@CheckForNull Object key2) {
        Map.Entry<K, V> entry = this.cacheEntry;
        if (entry != null && entry.getKey() == key2) {
            return entry.getValue();
        }
        return null;
    }

    void clearCache() {
        this.cacheEntry = null;
    }
}

