# ----------------------------------------------------------------------------
#
#  Copyright (C) 2018-2022 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


import globdef as G
from PyQt5 import QtGui, QtCore, QtWidgets


# Base class for the input and output windows.
# These contain a gain control, mute and solo
# buttons, and a channel label.
# This class defines common functionality.
# The GUI layout is defined in the derived classes.


class Gmsbase (QtWidgets.QWidget):

    def __init__(self, parent, callb, index): 
        super (Gmsbase, self).__init__(parent)
        self.callb = callb
        self.index = index
        
    def value_event (self, args):
        self.redraw ()
        self.callb (self.index, G.ACT_GAIN, args.get_value (), 0)     

    def mute_event (self):
        s = self.bmute.get_state () ^ 2
        b = self.bmute.mousebutt
        self.bmute.set_state (s)
        self.callb (self.index, G.ACT_MUTE, s > 0, b)     
        
    def solo_event (self):
        s = self.bsolo.get_state () ^ 1
        b = self.bsolo.mousebutt
        self.bsolo.set_state (s)
        self.callb (self.index, G.ACT_SOLO, s > 0, b)     
        
    def redraw (self):
        gaindb = self.gainctl.get_value ()
        if (gaindb > -200):
            self.gaintxt.setText('%5.1f' % (gaindb,))    
            self.gainctl.set_state (1)
        else:
            self.gaintxt.setText('Off')    
            self.gainctl.set_state (0)    

    def get_state (self):
        m = bmute.get_state () > 0
        return self.gainctl.get_value (), m
    
    def set_state (self, gaindb, mute):
        self.gainctl.set_value (gaindb)
        self.bmute.set_state (2 if mute else 0)
        self.redraw ()

    def get_solo (self):
        return self.bsolo.get_state () > 0
        
    def solo_off (self):
        self.bsolo.set_state (0)
        
