/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.ast.PackageVisibilityStatement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredImport;
import org.eclipse.jdt.internal.compiler.parser.RecoveredModuleReference;
import org.eclipse.jdt.internal.compiler.parser.RecoveredModuleStatement;

public class RecoveredPackageVisibilityStatement
extends RecoveredModuleStatement {
    RecoveredImport pkgRef;
    RecoveredModuleReference[] targets;
    int targetCount = 0;

    public RecoveredPackageVisibilityStatement(PackageVisibilityStatement packageVisibilityStatement, RecoveredElement recoveredElement, int n) {
        super(packageVisibilityStatement, recoveredElement, n);
    }

    @Override
    public RecoveredElement add(ImportReference importReference, int n) {
        this.pkgRef = new RecoveredImport(importReference, this, n);
        return this;
    }

    public RecoveredElement add(ModuleReference moduleReference, int n) {
        if (this.targets == null) {
            this.targets = new RecoveredModuleReference[5];
            this.targetCount = 0;
        } else if (this.targetCount == this.targets.length) {
            this.targets = new RecoveredModuleReference[2 * this.targetCount];
            System.arraycopy(this.targets, 0, this.targets, 0, this.targetCount);
        }
        RecoveredModuleReference recoveredModuleReference = new RecoveredModuleReference(moduleReference, this, n);
        this.targets[this.targetCount++] = recoveredModuleReference;
        return this;
    }

    @Override
    public String toString(int n) {
        return super.toString();
    }

    public PackageVisibilityStatement updatedPackageVisibilityStatement() {
        PackageVisibilityStatement packageVisibilityStatement = (PackageVisibilityStatement)this.moduleStatement;
        if (this.pkgRef != null) {
            packageVisibilityStatement.pkgRef = this.pkgRef.updatedImportReference();
        }
        if (this.targetCount > 0) {
            int n = packageVisibilityStatement.targets != null ? packageVisibilityStatement.targets.length : 0;
            int n2 = 0;
            ModuleReference[] moduleReferenceArray = new ModuleReference[n + this.targetCount];
            if (n > 0) {
                System.arraycopy(packageVisibilityStatement.targets, 0, moduleReferenceArray, 0, n);
                n2 = n;
            }
            int n3 = this.targetCount;
            for (int i = 0; i < n3; ++i) {
                moduleReferenceArray[n2++] = this.targets[i].updatedModuleReference();
            }
            packageVisibilityStatement.targets = moduleReferenceArray;
        }
        return packageVisibilityStatement;
    }

    @Override
    public void updateParseTree() {
        this.updatedPackageVisibilityStatement();
    }
}

