/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import sun.security.spec.DSAGenParameterSpec;
import sun.security.util.SecurityProviderConstants;

public class DSAParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private int valueL = -1;
    private int valueN = -1;
    private int seedLen = -1;
    private SecureRandom random;
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    @Override
    protected void engineInit(int strength, SecureRandom random) {
        if (strength != 2048 && strength != 3072 && (strength < 512 || strength > 1024 || strength % 64 != 0)) {
            throw new InvalidParameterException("Unexpected strength (size of prime): " + strength + ". Prime size should be 512-1024, 2048, or 3072");
        }
        this.valueL = strength;
        this.seedLen = this.valueN = SecurityProviderConstants.getDefDSASubprimeSize(strength);
        this.random = random;
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec genParamSpec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(genParamSpec instanceof DSAGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Invalid parameter");
        }
        DSAGenParameterSpec dsaGenParams = (DSAGenParameterSpec)genParamSpec;
        this.valueL = dsaGenParams.getPrimePLength();
        this.valueN = dsaGenParams.getSubprimeQLength();
        this.seedLen = dsaGenParams.getSeedLength();
        this.random = random;
    }

    @Override
    protected AlgorithmParameters engineGenerateParameters() {
        AlgorithmParameters algParams = null;
        try {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            if (this.valueL == -1) {
                this.engineInit(SecurityProviderConstants.DEF_DSA_KEY_SIZE, this.random);
            }
            BigInteger[] pAndQ = DSAParameterGenerator.generatePandQ(this.random, this.valueL, this.valueN, this.seedLen);
            BigInteger paramP = pAndQ[0];
            BigInteger paramQ = pAndQ[1];
            BigInteger paramG = DSAParameterGenerator.generateG(paramP, paramQ);
            DSAParameterSpec dsaParamSpec = new DSAParameterSpec(paramP, paramQ, paramG);
            algParams = AlgorithmParameters.getInstance("DSA", "SUN");
            algParams.init(dsaParamSpec);
        }
        catch (InvalidParameterSpecException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e.getMessage());
        }
        return algParams;
    }

    /*
     * Unable to fully structure code
     */
    private static BigInteger[] generatePandQ(SecureRandom random, int valueL, int valueN, int seedLen) {
        hashAlg = null;
        if (valueN == 160) {
            hashAlg = "SHA";
        } else if (valueN == 224) {
            hashAlg = "SHA-224";
        } else if (valueN == 256) {
            hashAlg = "SHA-256";
        }
        hashObj = null;
        try {
            hashObj = MessageDigest.getInstance(hashAlg);
        }
        catch (NoSuchAlgorithmException nsae) {
            nsae.printStackTrace();
        }
        outLen = hashObj.getDigestLength() * 8;
        n = (valueL - 1) / outLen;
        b = (valueL - 1) % outLen;
        seedBytes = new byte[seedLen / 8];
        twoSl = DSAParameterGenerator.TWO.pow(seedLen);
        primeCertainty = -1;
        if (valueL <= 1024) {
            primeCertainty = 80;
        } else if (valueL == 2048) {
            primeCertainty = 112;
        } else if (valueL == 3072) {
            primeCertainty = 128;
        }
        if (primeCertainty < 0) {
            throw new ProviderException("Invalid valueL: " + valueL);
        }
        seed = null;
        block2: while (true) {
            random.nextBytes(seedBytes);
            seed = new BigInteger(1, seedBytes);
            U = new BigInteger(1, hashObj.digest(seedBytes)).mod(DSAParameterGenerator.TWO.pow(valueN - 1));
            resultQ = DSAParameterGenerator.TWO.pow(valueN - 1).add(U).add(BigInteger.ONE).subtract(U.mod(DSAParameterGenerator.TWO));
            if (!resultQ.isProbablePrime(primeCertainty)) continue;
            offset = BigInteger.ONE;
            counter = 0;
            while (true) {
                if (counter < 4 * valueL) ** break;
                continue block2;
                V = new BigInteger[n + 1];
                for (j = 0; j <= n; ++j) {
                    J = BigInteger.valueOf(j);
                    tmp = seed.add(offset).add(J).mod(twoSl);
                    vjBytes = hashObj.digest(DSAParameterGenerator.toByteArray(tmp));
                    V[j] = new BigInteger(1, vjBytes);
                }
                W = V[0];
                for (i = 1; i < n; ++i) {
                    W = W.add(V[i].multiply(DSAParameterGenerator.TWO.pow(i * outLen)));
                }
                X = (W = W.add(V[n].mod(DSAParameterGenerator.TWO.pow(b)).multiply(DSAParameterGenerator.TWO.pow(n * outLen)))).add(twoLm1 = DSAParameterGenerator.TWO.pow(valueL - 1));
                resultP = X.subtract((c = X.mod(resultQ.multiply(DSAParameterGenerator.TWO))).subtract(BigInteger.ONE));
                if (resultP.compareTo(twoLm1) > -1 && resultP.isProbablePrime(primeCertainty)) {
                    result = new BigInteger[]{resultP, resultQ, seed, BigInteger.valueOf(counter)};
                    return result;
                }
                offset = offset.add(BigInteger.valueOf(n)).add(BigInteger.ONE);
                ++counter;
            }
            break;
        }
    }

    private static BigInteger generateG(BigInteger p, BigInteger q) {
        BigInteger h = BigInteger.ONE;
        BigInteger pMinusOneOverQ = p.subtract(BigInteger.ONE).divide(q);
        BigInteger resultG = BigInteger.ONE;
        while (resultG.compareTo(TWO) < 0) {
            resultG = h.modPow(pMinusOneOverQ, p);
            h = h.add(BigInteger.ONE);
        }
        return resultG;
    }

    private static byte[] toByteArray(BigInteger bigInt) {
        byte[] result = bigInt.toByteArray();
        if (result[0] == 0) {
            byte[] tmp = new byte[result.length - 1];
            System.arraycopy(result, 1, tmp, 0, tmp.length);
            result = tmp;
        }
        return result;
    }
}

