/*
 * Copyright (c) 2012, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ur_IN extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "\u06af\u0631\u06cc\u0646 \u0648\u0686 \u0645\u06cc\u0646 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "\u062e\u0644\u06cc\u062c \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "\u0627\u06cc\u0631\u0627\u0646 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0627\u06cc\u0631\u0627\u0646 \u0688\u06d2 \u0644\u0627\u0626\u0679 \u0679\u0627\u0626\u0645",
               "",
               "\u0627\u06cc\u0631\u0627\u0646 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Peru = new String[] {
               "\u067e\u06cc\u0631\u0648 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u067e\u06cc\u0631\u0648 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u067e\u06cc\u0631\u0648 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Chile = new String[] {
               "\u0686\u0644\u06cc \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0686\u0644\u06cc \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u0686\u0644\u06cc \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] India = new String[] {
               "\u0627\u0646\u0688\u06cc\u0627 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "\u0646\u06cc\u067e\u0627\u0644 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "\u0627\u06cc\u0645\u06cc\u0632\u0648\u0646 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0627\u06cc\u0645\u06cc\u0632\u0648\u0646 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u0627\u06cc\u0645\u06cc\u0632\u0648\u0646 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Bhutan = new String[] {
               "\u0628\u06be\u0648\u0679\u0627\u0646 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "\u0627\u06cc\u0633\u0679\u0631 \u0622\u0626\u0644\u06cc\u0646\u0688 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0627\u06cc\u0633\u0679\u0631 \u0622\u0626\u0644\u06cc\u0646\u0688 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u0627\u06cc\u0633\u0679\u0631 \u0622\u0626\u0644\u06cc\u0646\u0688 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Guyana = new String[] {
               "\u06af\u06cc\u0627\u0646\u0627 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "\u0627\u0633\u0631\u0627\u0626\u06cc\u0644 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0627\u0633\u0631\u0627\u0626\u06cc\u0644 \u0688\u06d2 \u0644\u0627\u0626\u0679 \u0679\u0627\u0626\u0645",
               "",
               "\u0627\u0633\u0631\u0627\u0626\u06cc\u0644 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Vostok = new String[] {
               "\u0648\u0648\u0633\u0679\u0627\u06a9 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "\u0639\u0631\u0628 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0639\u0631\u0628 \u0688\u06d2 \u0644\u0627\u0626\u0679 \u0679\u0627\u0626\u0645",
               "",
               "\u0639\u0631\u0628 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Armenia = new String[] {
               "\u0622\u0631\u0645\u06cc\u0646\u06cc\u0627 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0622\u0631\u0645\u06cc\u0646\u06cc\u0627 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u0622\u0631\u0645\u06cc\u0646\u06cc\u0627 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Bolivia = new String[] {
               "\u0628\u0648\u0644\u06cc\u0648\u06cc\u0627 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "\u0627\u06cc\u06a9\u0648\u0627\u0688\u0648\u0631 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "\u062c\u0627\u0631\u062c\u06cc\u0627 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u062c\u0627\u0631\u062c\u06cc\u0627 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u062c\u0627\u0631\u062c\u06cc\u0627 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Noronha = new String[] {
               "\u0641\u0631\u0646\u0627\u0646\u0688\u0648 \u0688\u06cc \u0646\u0648\u0631\u0646\u06c1\u0627 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0641\u0631\u0646\u0627\u0646\u0688\u0648 \u0688\u06cc \u0646\u0648\u0631\u0648\u0646\u06c1\u0627 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u0641\u0631\u0646\u0627\u0646\u0688\u0648 \u0688\u06cc \u0646\u0648\u0631\u0646\u06c1\u0627 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Rothera = new String[] {
               "\u0631\u0648\u062a\u06be\u06cc\u0631\u0627 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "\u06cc\u0648\u0631\u0648\u06af\u0648\u0626\u06d2 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u06cc\u0648\u0631\u0648\u06af\u0648\u0626\u06d2 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u06cc\u0648\u0631\u0648\u06af\u0648\u0626\u06d2 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Brasilia = new String[] {
               "\u0628\u0631\u0627\u0632\u06cc\u0644\u06cc\u0627 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0628\u0631\u0627\u0632\u06cc\u0644\u06cc\u0627 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u0628\u0631\u0627\u0632\u06cc\u0644\u06cc\u0627 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Colombia = new String[] {
               "\u06a9\u0648\u0644\u0645\u0628\u06cc\u0627 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u06a9\u0648\u0644\u0645\u0628\u06cc\u0627 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u06a9\u0648\u0644\u0645\u0628\u06cc\u0627 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Falkland = new String[] {
               "\u0641\u0627\u06a9 \u0644\u06cc\u0646\u0688 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0641\u0627\u06a9 \u0644\u06cc\u0646\u0688 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u0641\u0627\u06a9 \u0644\u06cc\u0646\u0688 \u0622\u0626\u0644\u06cc\u0646\u0688\u0632 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Maldives = new String[] {
               "\u0645\u0627\u0644\u062f\u06cc\u067e \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pakistan = new String[] {
               "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Paraguay = new String[] {
               "\u067e\u06cc\u0631\u0627\u06af\u0648\u0626\u06d2 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u067e\u06cc\u0631\u0627\u06af\u0648\u0626\u06d2 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u067e\u06cc\u0631\u0627\u06af\u0648\u0626\u06d2 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Suriname = new String[] {
               "\u0633\u0648\u0631\u06cc\u0646\u0627\u0645 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "\u06af\u0627\u0644\u0627\u067e\u0627\u06af\u0648\u0632 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "\u06a9\u0631\u063a\u0633\u062a\u0627\u0646 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "\u0648\u06cc\u0646\u0632\u0648\u0626\u06cc\u0644\u0627 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "\u0622\u0630\u0631\u0628\u0627\u0626\u06cc\u062c\u0627\u0646 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0622\u0630\u0631\u0628\u0627\u0626\u06cc\u062c\u0627\u0646 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u0622\u0630\u0631\u0628\u0627\u0626\u06cc\u062c\u0627\u0646 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Bangladesh = new String[] {
               "\u0628\u0646\u06af\u0644\u06c1 \u062f\u06cc\u0634 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0628\u0646\u06af\u0644\u06c1 \u062f\u06cc\u0634 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u0628\u0646\u06af\u0644\u06c1 \u062f\u06cc\u0634 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "\u062a\u0627\u062c\u06a9\u0633\u062a\u0627\u0646 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "\u0627\u0632\u0628\u06a9\u0633\u062a\u0627\u0646 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0627\u0632\u0628\u06a9\u0633\u062a\u0627\u0646 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u0627\u0632\u0628\u06a9\u0633\u062a\u0627\u0646 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Afghanistan = new String[] {
               "\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Zealand = new String[] {
               "\u0646\u06cc\u0648\u0632\u06cc \u0644\u06cc\u0646\u0688 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u0646\u06cc\u0648\u0632\u06cc \u0644\u06cc\u0646\u0688 \u0688\u06d2 \u0644\u0627\u0626\u0679 \u0679\u0627\u0626\u0645",
               "",
               "\u0646\u06cc\u0648\u0632\u06cc \u0644\u06cc\u0646\u0688 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "\u062a\u0631\u06a9\u0645\u0627\u0646\u0633\u062a\u0627\u0646 \u0633\u0679\u06cc\u0646\u0688\u0631\u0688 \u0679\u0627\u0626\u0645",
               "",
               "\u062a\u0631\u06a9\u0645\u0627\u0646\u0633\u062a\u0627\u0646 \u0633\u0645\u0631 \u0679\u0627\u0626\u0645",
               "",
               "\u062a\u0631\u06a9\u0645\u0627\u0646\u0633\u062a\u0627\u0646 \u0679\u0627\u0626\u0645",
               "",
            };
        final String[] French_Guiana = new String[] {
               "\u0641\u0631\u06cc\u0646\u0686 \u06af\u06cc\u0627\u0646\u0627 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "\u0648\u0633\u0637\u06cc \u06cc\u0648\u0631\u067e \u06a9\u0627 \u0645\u0639\u06cc\u0627\u0631\u06cc \u0648\u0642\u062a",
               "",
               "\u0648\u0633\u0637\u06cc \u06cc\u0648\u0631\u067e \u06a9\u0627 \u0645\u0648\u0633\u0645 \u06af\u0631\u0645\u0627 \u06a9\u0627 \u0648\u0642\u062a",
               "",
               "\u0648\u0633\u0637\u06cc \u06cc\u0648\u0631\u067e \u06a9\u0627 \u0648\u0642\u062a",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0645\u0634\u0631\u0642\u06cc \u0642\u0632\u0627\u062e\u0633\u062a\u0627\u0646 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0645\u063a\u0631\u0628\u06cc \u0642\u0632\u0627\u062e\u0633\u062a\u0627\u0646 \u0679\u0627\u0626\u0645",
               "",
               "",
               "",
               "",
               "",
            };
        final Object[][] data = new Object[][] {
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "UTC", EMPTY_ZONE },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "ECT", Europe_Central },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "Etc/GMT", GMT },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Oral", Kazakhstan_Western },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Qatar", Arabian },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Kuwait", Arabian },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Tehran", Iran },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Rome", Europe_Central },
            { "Africa/Accra", GMT },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Tunis", Europe_Central },
            { "America/Lima", Peru },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Karachi", Pakistan },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Vaduz", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Katmandu", Nepal },
            { "Asia/Qostanay", Kazakhstan_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin", GMT },
            { "Europe/Jersey", GMT },
            { "Europe/London", GMT },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Bogota", Colombia },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Recife", Brasilia },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast", GMT },
            { "Europe/Vatican", Europe_Central },
            { "Pacific/Easter", Easter },
            { "Africa/Freetown", GMT },
            { "Africa/Monrovia", GMT },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Noronha", Noronha },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Guernsey", GMT },
            { "Europe/Sarajevo", Europe_Central },
            { "Indian/Maldives", Maldives },
            { "America/Asuncion", Paraguay },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "Antarctica/Troll", GMT },
            { "Atlantic/Stanley", Falkland },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Pacific/Auckland", New_Zealand },
            { "Africa/Nouakchott", GMT },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Fortaleza", Brasilia },
            { "America/Guayaquil", Ecuador },
            { "America/Sao_Paulo", Brasilia },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ouagadougou", GMT },
            { "America/Montevideo", Uruguay },
            { "America/Paramaribo", Suriname },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Isle_of_Man", GMT },
            { "America/Porto_Velho", Amazon },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Accra", "\u0627\u06a9\u0631\u0627" },
            { "timezone.excity.America/Thule", "\u062a\u06be\u0648\u0644\u06d2" },
            { "timezone.excity.Europe/Budapest", "\u0628\u0648\u0688\u0627\u067e\u06cc\u0633\u0679" },
            { "timezone.excity.America/Glace_Bay", "\u06af\u0644\u06cc\u0633 \u0628\u06d2" },
            { "timezone.excity.America/Goose_Bay", "\u06af\u0648\u0633 \u0628\u06d2" },
            { "timezone.excity.America/Grand_Turk", "\u06af\u0631\u06cc\u0646\u0688 \u062a\u0631\u06a9" },
            { "timezone.excity.America/Scoresbysund", "\u0627\u062a\u062a\u0648\u0642\u0642\u0648\u0631\u062a\u0648\u0631\u0645\u06cc\u062a" },
            { "timezone.excity.America/Cambridge_Bay", "\u06a9\u06cc\u0645\u0628\u0631\u062c \u0628\u06d2" },
        };
        return data;
    }
}
