'''OpenGL extension SGIX.scalebias_hint

This module customises the behaviour of the 
OpenGL.raw.GL.SGIX.scalebias_hint to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension adds an precision hint for scaling and biasing
	arithmetic. For large scale factors, hinting GL_NICEST produces the
	most accurate results. The hint only applies to Octane2 VPro
	graphics systems, to work around a hardware issue.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/SGIX/scalebias_hint.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.SGIX.scalebias_hint import *
from OpenGL.raw.GL.SGIX.scalebias_hint import _EXTENSION_NAME

def glInitScalebiasHintSGIX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION