/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.LogManager;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.security.SecurityConfig;
import org.apache.catalina.startup.AddPortOffsetRule;
import org.apache.catalina.startup.Bootstrap;
import org.apache.catalina.startup.CertificateCreateRule;
import org.apache.catalina.startup.ConnectorCreateRule;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.EngineRuleSet;
import org.apache.catalina.startup.HostRuleSet;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.SetAllPropertiesRule;
import org.apache.catalina.startup.SetParentClassLoaderRule;
import org.apache.juli.ClassLoaderLogManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.apache.tomcat.util.digester.RuleSet;
import org.apache.tomcat.util.log.SystemLogHandler;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class Catalina {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");
    protected boolean await = false;
    protected String configFile = "conf/server.xml";
    protected ClassLoader parentClassLoader = Catalina.class.getClassLoader();
    protected Server server = null;
    protected boolean useShutdownHook = true;
    protected Thread shutdownHook = null;
    protected boolean useNaming = true;
    protected boolean loaded = false;
    private static final Log log = LogFactory.getLog(Catalina.class);

    public Catalina() {
        this.setSecurityProtection();
        ExceptionUtils.preload();
    }

    public void setConfigFile(String string) {
        this.configFile = string;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setUseShutdownHook(boolean bl) {
        this.useShutdownHook = bl;
    }

    public boolean getUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setParentClassLoader(ClassLoader classLoader) {
        this.parentClassLoader = classLoader;
    }

    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        return ClassLoader.getSystemClassLoader();
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Server getServer() {
        return this.server;
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean bl) {
        this.useNaming = bl;
    }

    public void setAwait(boolean bl) {
        this.await = bl;
    }

    public boolean isAwait() {
        return this.await;
    }

    protected boolean arguments(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length < 1) {
            this.usage();
            return false;
        }
        for (String string : stringArray) {
            if (bl) {
                this.configFile = string;
                bl = false;
                continue;
            }
            if (string.equals("-config")) {
                bl = true;
                continue;
            }
            if (string.equals("-nonaming")) {
                this.setUseNaming(false);
                continue;
            }
            if (string.equals("-help")) {
                this.usage();
                return false;
            }
            if (string.equals("start") || string.equals("configtest") || string.equals("stop")) continue;
            this.usage();
            return false;
        }
        return true;
    }

    protected File configFile() {
        File file = new File(this.configFile);
        if (!file.isAbsolute()) {
            file = new File(Bootstrap.getCatalinaBase(), this.configFile);
        }
        return file;
    }

    protected Digester createStartDigester() {
        long l = System.currentTimeMillis();
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(true);
        HashMap hashMap = new HashMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("className");
        hashMap.put(Object.class, arrayList);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("source");
        hashMap.put(StandardContext.class, arrayList2);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("portOffset");
        hashMap.put(Connector.class, arrayList3);
        digester.setFakeAttributes(hashMap);
        digester.setUseContextClassLoader(true);
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        digester.addObjectCreate("Server/GlobalNamingResources", "org.apache.catalina.deploy.NamingResourcesImpl");
        digester.addSetProperties("Server/GlobalNamingResources");
        digester.addSetNext("Server/GlobalNamingResources", "setGlobalNamingResources", "org.apache.catalina.deploy.NamingResourcesImpl");
        digester.addObjectCreate("Server/Listener", null, "className");
        digester.addSetProperties("Server/Listener");
        digester.addSetNext("Server/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service", "org.apache.catalina.core.StandardService", "className");
        digester.addSetProperties("Server/Service");
        digester.addSetNext("Server/Service", "addService", "org.apache.catalina.Service");
        digester.addObjectCreate("Server/Service/Listener", null, "className");
        digester.addSetProperties("Server/Service/Listener");
        digester.addSetNext("Server/Service/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Executor", "org.apache.catalina.core.StandardThreadExecutor", "className");
        digester.addSetProperties("Server/Service/Executor");
        digester.addSetNext("Server/Service/Executor", "addExecutor", "org.apache.catalina.Executor");
        digester.addRule("Server/Service/Connector", (Rule)new ConnectorCreateRule());
        digester.addRule("Server/Service/Connector", (Rule)new SetAllPropertiesRule(new String[]{"executor", "sslImplementationName"}));
        digester.addSetNext("Server/Service/Connector", "addConnector", "org.apache.catalina.connector.Connector");
        digester.addRule("Server/Service/Connector", (Rule)new AddPortOffsetRule());
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig", "org.apache.tomcat.util.net.SSLHostConfig");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig", "addSslHostConfig", "org.apache.tomcat.util.net.SSLHostConfig");
        digester.addRule("Server/Service/Connector/SSLHostConfig/Certificate", (Rule)new CertificateCreateRule());
        digester.addRule("Server/Service/Connector/SSLHostConfig/Certificate", (Rule)new SetAllPropertiesRule(new String[]{"type"}));
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/Certificate", "addCertificate", "org.apache.tomcat.util.net.SSLHostConfigCertificate");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig/OpenSSLConf", "org.apache.tomcat.util.net.openssl.OpenSSLConf");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/OpenSSLConf");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/OpenSSLConf", "setOpenSslConf", "org.apache.tomcat.util.net.openssl.OpenSSLConf");
        digester.addObjectCreate("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd", "org.apache.tomcat.util.net.openssl.OpenSSLConfCmd");
        digester.addSetProperties("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd");
        digester.addSetNext("Server/Service/Connector/SSLHostConfig/OpenSSLConf/OpenSSLConfCmd", "addCmd", "org.apache.tomcat.util.net.openssl.OpenSSLConfCmd");
        digester.addObjectCreate("Server/Service/Connector/Listener", null, "className");
        digester.addSetProperties("Server/Service/Connector/Listener");
        digester.addSetNext("Server/Service/Connector/Listener", "addLifecycleListener", "org.apache.catalina.LifecycleListener");
        digester.addObjectCreate("Server/Service/Connector/UpgradeProtocol", null, "className");
        digester.addSetProperties("Server/Service/Connector/UpgradeProtocol");
        digester.addSetNext("Server/Service/Connector/UpgradeProtocol", "addUpgradeProtocol", "org.apache.coyote.UpgradeProtocol");
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/GlobalNamingResources/"));
        digester.addRuleSet((RuleSet)new EngineRuleSet("Server/Service/"));
        digester.addRuleSet((RuleSet)new HostRuleSet("Server/Service/Engine/"));
        digester.addRuleSet((RuleSet)new ContextRuleSet("Server/Service/Engine/Host/"));
        this.addClusterRuleSet(digester, "Server/Service/Engine/Host/Cluster/");
        digester.addRuleSet((RuleSet)new NamingRuleSet("Server/Service/Engine/Host/Context/"));
        digester.addRule("Server/Service/Engine", (Rule)new SetParentClassLoaderRule(this.parentClassLoader));
        this.addClusterRuleSet(digester, "Server/Service/Engine/Cluster/");
        long l2 = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Digester for server.xml created " + (l2 - l)));
        }
        return digester;
    }

    private void addClusterRuleSet(Digester digester, String string) {
        block3: {
            Class<?> clazz = null;
            Constructor<?> constructor = null;
            try {
                clazz = Class.forName("org.apache.catalina.ha.ClusterRuleSet");
                constructor = clazz.getConstructor(String.class);
                RuleSet ruleSet = (RuleSet)constructor.newInstance(string);
                digester.addRuleSet(ruleSet);
            }
            catch (Exception exception) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("catalina.noCluster", new Object[]{exception.getClass().getName() + ": " + exception.getMessage()}), (Throwable)exception);
                }
                if (!log.isInfoEnabled()) break block3;
                log.info((Object)sm.getString("catalina.noCluster", new Object[]{exception.getClass().getName() + ": " + exception.getMessage()}));
            }
        }
    }

    protected Digester createStopDigester() {
        Digester digester = new Digester();
        digester.setUseContextClassLoader(true);
        digester.addObjectCreate("Server", "org.apache.catalina.core.StandardServer", "className");
        digester.addSetProperties("Server");
        digester.addSetNext("Server", "setServer", "org.apache.catalina.Server");
        return digester;
    }

    public void stopServer() {
        this.stopServer(null);
    }

    public void stopServer(String[] stringArray) {
        Object object;
        Throwable throwable;
        Closeable closeable;
        Serializable serializable;
        Object object2;
        Server server;
        if (stringArray != null) {
            this.arguments(stringArray);
        }
        if ((server = this.getServer()) == null) {
            object2 = this.createStopDigester();
            serializable = this.configFile();
            try {
                closeable = new FileInputStream((File)serializable);
                throwable = null;
                try {
                    object = new InputSource(((File)serializable).toURI().toURL().toString());
                    ((InputSource)object).setByteStream((InputStream)closeable);
                    object2.push((Object)this);
                    object2.parse((InputSource)object);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (closeable != null) {
                        if (throwable != null) {
                            try {
                                ((FileInputStream)closeable).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((FileInputStream)closeable).close();
                        }
                    }
                }
            }
            catch (Exception exception) {
                log.error((Object)sm.getString("catalina.stopError"));
                System.exit(1);
            }
        } else {
            try {
                server.stop();
                server.destroy();
            }
            catch (LifecycleException lifecycleException) {
                log.error((Object)sm.getString("catalina.stopError"), (Throwable)lifecycleException);
            }
            return;
        }
        server = this.getServer();
        if (server.getPortWithOffset() > 0) {
            try {
                object2 = new Socket(server.getAddress(), server.getPortWithOffset());
                serializable = null;
                try {
                    closeable = ((Socket)object2).getOutputStream();
                    throwable = null;
                    try {
                        object = server.getShutdown();
                        for (int i = 0; i < ((String)object).length(); ++i) {
                            ((OutputStream)closeable).write(((String)object).charAt(i));
                        }
                        ((OutputStream)closeable).flush();
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (closeable != null) {
                            if (throwable != null) {
                                try {
                                    ((OutputStream)closeable).close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                ((OutputStream)closeable).close();
                            }
                        }
                    }
                }
                catch (Throwable throwable6) {
                    serializable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (object2 != null) {
                        if (serializable != null) {
                            try {
                                ((Socket)object2).close();
                            }
                            catch (Throwable throwable7) {
                                ((Throwable)serializable).addSuppressed(throwable7);
                            }
                        } else {
                            ((Socket)object2).close();
                        }
                    }
                }
            }
            catch (ConnectException connectException) {
                log.error((Object)sm.getString("catalina.stopServer.connectException", new Object[]{server.getAddress(), String.valueOf(server.getPortWithOffset()), String.valueOf(server.getPort()), String.valueOf(server.getPortOffset())}));
                log.error((Object)sm.getString("catalina.stopError"), (Throwable)connectException);
                System.exit(1);
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("catalina.stopError"), (Throwable)iOException);
                System.exit(1);
            }
        } else {
            log.error((Object)sm.getString("catalina.stopServer"));
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        long l = System.nanoTime();
        this.initDirs();
        this.initNaming();
        Digester digester = this.createStartDigester();
        InputSource inputSource = null;
        InputStream inputStream = null;
        File file = null;
        try {
            block39: {
                block38: {
                    block37: {
                        try {
                            file = this.configFile();
                            inputStream = new FileInputStream(file);
                            inputSource = new InputSource(file.toURI().toURL().toString());
                        }
                        catch (Exception exception) {
                            if (!log.isDebugEnabled()) break block37;
                            log.debug((Object)sm.getString("catalina.configFail", new Object[]{file}), (Throwable)exception);
                        }
                    }
                    if (inputStream == null) {
                        try {
                            inputStream = this.getClass().getClassLoader().getResourceAsStream(this.getConfigFile());
                            inputSource = new InputSource(this.getClass().getClassLoader().getResource(this.getConfigFile()).toString());
                        }
                        catch (Exception exception) {
                            if (!log.isDebugEnabled()) break block38;
                            log.debug((Object)sm.getString("catalina.configFail", new Object[]{this.getConfigFile()}), (Throwable)exception);
                        }
                    }
                }
                if (inputStream == null) {
                    try {
                        inputStream = this.getClass().getClassLoader().getResourceAsStream("server-embed.xml");
                        inputSource = new InputSource(this.getClass().getClassLoader().getResource("server-embed.xml").toString());
                    }
                    catch (Exception exception) {
                        if (!log.isDebugEnabled()) break block39;
                        log.debug((Object)sm.getString("catalina.configFail", new Object[]{"server-embed.xml"}), (Throwable)exception);
                    }
                }
            }
            if (inputStream == null || inputSource == null) {
                if (file == null) {
                    log.warn((Object)sm.getString("catalina.configFail", new Object[]{this.getConfigFile() + "] or [server-embed.xml]"}));
                } else {
                    log.warn((Object)sm.getString("catalina.configFail", new Object[]{file.getAbsolutePath()}));
                    if (file.exists() && !file.canRead()) {
                        log.warn((Object)"Permissions incorrect, read permission is not allowed on the file.");
                    }
                }
                return;
            }
            try {
                inputSource.setByteStream(inputStream);
                digester.push((Object)this);
                digester.parse(inputSource);
            }
            catch (SAXParseException sAXParseException) {
                log.warn((Object)("Catalina.start using " + this.getConfigFile() + ": " + sAXParseException.getMessage()));
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            catch (Exception exception) {
                block41: {
                    log.warn((Object)("Catalina.start using " + this.getConfigFile() + ": "), (Throwable)exception);
                    if (inputStream == null) break block41;
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.getServer().setCatalina(this);
        this.getServer().setCatalinaHome(Bootstrap.getCatalinaHomeFile());
        this.getServer().setCatalinaBase(Bootstrap.getCatalinaBaseFile());
        this.initStreams();
        try {
            this.getServer().init();
        }
        catch (LifecycleException lifecycleException) {
            if (Boolean.getBoolean("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE")) {
                throw new Error(lifecycleException);
            }
            log.error((Object)"Catalina.start", (Throwable)lifecycleException);
        }
        long l2 = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info((Object)("Initialization processed in " + (l2 - l) / 1000000L + " ms"));
        }
    }

    public void load(String[] stringArray) {
        try {
            if (this.arguments(stringArray)) {
                this.load();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void start() {
        if (this.getServer() == null) {
            this.load();
        }
        if (this.getServer() == null) {
            log.fatal((Object)"Cannot start server. Server instance is not configured.");
            return;
        }
        long l = System.nanoTime();
        try {
            this.getServer().start();
        }
        catch (LifecycleException lifecycleException) {
            log.fatal((Object)sm.getString("catalina.serverStartFail"), (Throwable)lifecycleException);
            try {
                this.getServer().destroy();
            }
            catch (LifecycleException lifecycleException2) {
                log.debug((Object)"destroy() failed for failed Server ", (Throwable)lifecycleException2);
            }
            return;
        }
        long l2 = System.nanoTime();
        if (log.isInfoEnabled()) {
            log.info((Object)("Server startup in " + (l2 - l) / 1000000L + " ms"));
        }
        if (this.useShutdownHook) {
            if (this.shutdownHook == null) {
                this.shutdownHook = new CatalinaShutdownHook();
            }
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            LogManager logManager = LogManager.getLogManager();
            if (logManager instanceof ClassLoaderLogManager) {
                ((ClassLoaderLogManager)logManager).setUseShutdownHook(false);
            }
        }
        if (this.await) {
            this.await();
            this.stop();
        }
    }

    public void stop() {
        Object object;
        try {
            if (this.useShutdownHook) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                object = LogManager.getLogManager();
                if (object instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)object).setUseShutdownHook(true);
                }
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        try {
            object = this.getServer();
            LifecycleState lifecycleState = object.getState();
            if (LifecycleState.STOPPING_PREP.compareTo(lifecycleState) > 0 || LifecycleState.DESTROYED.compareTo(lifecycleState) < 0) {
                object.stop();
                object.destroy();
            }
        }
        catch (LifecycleException lifecycleException) {
            log.error((Object)"Catalina.stop", (Throwable)lifecycleException);
        }
    }

    public void await() {
        this.getServer().await();
    }

    protected void usage() {
        System.out.println("usage: java org.apache.catalina.startup.Catalina [ -config {pathname} ] [ -nonaming ]  { -help | start | stop }");
    }

    @Deprecated
    protected void initDirs() {
    }

    protected void initStreams() {
        System.setOut((PrintStream)new SystemLogHandler(System.out));
        System.setErr((PrintStream)new SystemLogHandler(System.err));
    }

    protected void initNaming() {
        if (!this.useNaming) {
            log.info((Object)sm.getString("catalina.noNaming"));
            System.setProperty("catalina.useNaming", "false");
        } else {
            System.setProperty("catalina.useNaming", "true");
            String string = "org.apache.naming";
            String string2 = System.getProperty("java.naming.factory.url.pkgs");
            if (string2 != null) {
                string = string + ":" + string2;
            }
            System.setProperty("java.naming.factory.url.pkgs", string);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Setting naming prefix=" + string));
            }
            if ((string = System.getProperty("java.naming.factory.initial")) == null) {
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            } else {
                log.debug((Object)("INITIAL_CONTEXT_FACTORY already set " + string));
            }
        }
    }

    protected void setSecurityProtection() {
        SecurityConfig securityConfig = SecurityConfig.newInstance();
        securityConfig.setPackageDefinition();
        securityConfig.setPackageAccess();
    }

    protected class CatalinaShutdownHook
    extends Thread {
        protected CatalinaShutdownHook() {
        }

        @Override
        public void run() {
            try {
                if (Catalina.this.getServer() != null) {
                    Catalina.this.stop();
                }
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable((Throwable)throwable);
                log.error((Object)sm.getString("catalina.shutdownHookFail"), throwable);
            }
            finally {
                LogManager logManager = LogManager.getLogManager();
                if (logManager instanceof ClassLoaderLogManager) {
                    ((ClassLoaderLogManager)logManager).shutdown();
                }
            }
        }
    }
}

