/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.partition;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;
import org.gephi.appearance.api.AppearanceController;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.appearance.api.Partition;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.Range;
import org.gephi.filters.plugin.AbstractAttributeFilter;
import org.gephi.filters.plugin.AbstractAttributeFilterBuilder;
import org.gephi.filters.plugin.graph.RangeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.RangeFilter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PartitionCountBuilder
implements CategoryBuilder {
    private static final Category PARTITION_COUNT = new Category(NbBundle.getMessage(PartitionCountBuilder.class, (String)"PartitionCountBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    public Category getCategory() {
        return PARTITION_COUNT;
    }

    public FilterBuilder[] getBuilders(Workspace workspace) {
        PartitionCountFilterBuilder builder;
        Partition partition;
        ArrayList<PartitionCountFilterBuilder> builders = new ArrayList<PartitionCountFilterBuilder>();
        GraphModel gm = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel(workspace);
        AppearanceModel am = ((AppearanceController)Lookup.getDefault().lookup(AppearanceController.class)).getModel(workspace);
        am.getNodeFunctions();
        am.getEdgeFunctions();
        for (Column nodeCol : gm.getNodeTable()) {
            if (nodeCol.isProperty() || (partition = am.getNodePartition(nodeCol)) == null) continue;
            builder = new PartitionCountFilterBuilder(partition);
            builders.add(builder);
        }
        for (Column edgeCol : gm.getEdgeTable()) {
            if (edgeCol.isProperty() || (partition = am.getEdgePartition(edgeCol)) == null) continue;
            builder = new PartitionCountFilterBuilder(partition);
            builders.add(builder);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static abstract class PartitionCountFilter<K extends Element>
    extends AbstractAttributeFilter<K>
    implements RangeFilter {
        protected final AppearanceModel appearanceModel;
        protected Partition partition;
        private Range range;

        public PartitionCountFilter(AppearanceModel appearanceModel, Partition partition) {
            super(NbBundle.getMessage(PartitionCountBuilder.class, (String)"PartitionCountBuilder.name"), partition.getColumn());
            this.partition = partition;
            this.appearanceModel = appearanceModel;
            this.addProperty(Range.class, "range");
        }

        public boolean init(Graph graph) {
            return this.partition != null && this.partition.getColumn() != null;
        }

        public boolean evaluate(Graph graph, Element element) {
            Object p = this.partition.getValue(element, graph);
            int partCount = this.partition.count(p, graph);
            return this.range.isInRange((Number)partCount);
        }

        public void finish() {
        }

        public Number[] getValues(Graph graph) {
            if (this.init(graph)) {
                Collection vals = this.partition.getValues(graph);
                Number[] values = new Integer[vals.size()];
                int i = 0;
                for (Object v : vals) {
                    values[i++] = this.partition.count(v, graph);
                }
                return values;
            }
            return new Integer[0];
        }

        public FilterProperty getRangeProperty() {
            return this.getProperties()[1];
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
        }

        @Override
        public Column getColumn() {
            return this.partition.getColumn();
        }

        @Override
        public void setColumn(Column column) {
        }

        public static class Edge
        extends PartitionCountFilter<org.gephi.graph.api.Edge>
        implements EdgeFilter {
            public Edge(AppearanceModel appearanceModel, Partition partition) {
                super(appearanceModel, partition);
            }

            @Override
            public void setColumn(Column column) {
                if (this.partition == null || this.partition.getColumn() != column) {
                    this.appearanceModel.getEdgeFunctions();
                    this.partition = this.appearanceModel.getEdgePartition(column);
                }
            }
        }

        public static class Node
        extends PartitionCountFilter<org.gephi.graph.api.Node>
        implements NodeFilter {
            public Node(AppearanceModel appearanceModel, Partition partition) {
                super(appearanceModel, partition);
            }

            @Override
            public void setColumn(Column column) {
                if (this.partition == null || this.partition.getColumn() != column) {
                    this.appearanceModel.getNodeFunctions();
                    this.partition = this.appearanceModel.getNodePartition(column);
                }
            }
        }
    }

    private static class PartitionCountFilterBuilder
    extends AbstractAttributeFilterBuilder {
        private final Partition partition;

        public PartitionCountFilterBuilder(Partition partition) {
            super(partition.getColumn(), PARTITION_COUNT, NbBundle.getMessage(PartitionCountBuilder.class, (String)"PartitionCountBuilder.description"), null);
            this.partition = partition;
        }

        public PartitionCountFilter getFilter(Workspace workspace) {
            AppearanceModel am = ((AppearanceController)Lookup.getDefault().lookup(AppearanceController.class)).getModel(workspace);
            if (AttributeUtils.isNodeColumn((Column)this.column)) {
                return new PartitionCountFilter.Node(am, this.partition);
            }
            return new PartitionCountFilter.Edge(am, this.partition);
        }

        public JPanel getPanel(Filter filter) {
            RangeUI ui = (RangeUI)Lookup.getDefault().lookup(RangeUI.class);
            if (ui != null) {
                return ui.getPanel((PartitionCountFilter)filter);
            }
            return null;
        }
    }
}

