/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.utils.longtask.api;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.utils.longtask.api.LongTaskErrorHandler;
import org.gephi.utils.longtask.api.LongTaskListener;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.ProgressTicket;
import org.gephi.utils.progress.ProgressTicketProvider;
import org.openide.util.Lookup;

public final class LongTaskExecutor {
    private final boolean inBackground;
    private final long interruptDelay;
    private final String name;
    private boolean interruptCancel;
    private ThreadPoolExecutor executor;
    private RunningLongTask currentTask;
    private Timer cancelTimer;
    private LongTaskListener listener;
    private LongTaskErrorHandler defaultErrorHandler;

    public LongTaskExecutor(boolean doInBackground, String name, int interruptDelay) {
        this.inBackground = doInBackground;
        this.name = name;
        this.interruptCancel = true;
        this.interruptDelay = (long)interruptDelay * 1000L;
    }

    public LongTaskExecutor(boolean doInBackground, String name) {
        this(doInBackground, name, 0);
        this.interruptCancel = false;
    }

    public LongTaskExecutor(boolean doInBackground) {
        this(doInBackground, "LongTaskExecutor");
    }

    public synchronized void execute(LongTask task, Runnable runnable, String taskName, LongTaskErrorHandler errorHandler) {
        if (runnable == null || taskName == null) {
            throw new NullPointerException();
        }
        this.execute(new RunningLongTask(task, runnable, taskName, errorHandler));
    }

    public synchronized <V> Future<V> execute(LongTask task, Callable<V> callable, String taskName, LongTaskErrorHandler errorHandler) {
        if (callable == null || taskName == null) {
            throw new NullPointerException();
        }
        return this.execute(new RunningLongTask<V>(task, callable, taskName, errorHandler));
    }

    private <V> Future<V> execute(RunningLongTask<V> runningLongtask) {
        if (this.inBackground) {
            if (this.executor == null) {
                this.executor = new ThreadPoolExecutor(0, 1, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory());
            }
            Future<V> result = this.executor.submit(runningLongtask);
            runningLongtask.future = result;
            return result;
        }
        this.currentTask = runningLongtask;
        runningLongtask.call();
        return runningLongtask.future;
    }

    public synchronized void execute(LongTask task, Runnable runnable) {
        this.execute(task, runnable, "", null);
    }

    public synchronized <V> Future<V> execute(LongTask task, Callable<V> callable) {
        return this.execute(task, callable, "", null);
    }

    public synchronized void cancel() {
        if (this.inBackground) {
            RunningLongTask rlt;
            if (this.executor != null && (rlt = this.currentTask) != null) {
                boolean res = rlt.cancel();
                if (this.interruptCancel && !res) {
                    this.cancelTimer = new Timer(this.name + "_cancelTimer");
                    this.cancelTimer.schedule((TimerTask)new InterruptTimerTask(rlt), this.interruptDelay);
                }
            }
        } else {
            RunningLongTask rlt = this.currentTask;
            if (rlt != null) {
                boolean res = rlt.cancel();
                if (this.interruptCancel && !res) {
                    this.cancelTimer = new Timer(this.name + "_cancelTimer");
                    this.cancelTimer.schedule((TimerTask)new InterruptTimerTask(rlt), this.interruptDelay);
                }
            }
        }
    }

    public boolean isRunning() {
        return this.currentTask != null;
    }

    public void setLongTaskListener(LongTaskListener listener) {
        this.listener = listener;
    }

    public void setDefaultErrorHandler(LongTaskErrorHandler errorHandler) {
        if (errorHandler != null) {
            this.defaultErrorHandler = errorHandler;
        }
    }

    private synchronized void finished(RunningLongTask runningLongTask) {
        if (this.cancelTimer != null) {
            this.cancelTimer.cancel();
        }
        LongTask task = runningLongTask.task;
        this.currentTask = null;
        if (this.listener != null) {
            this.listener.taskFinished(task);
        }
    }

    private class InterruptTimerTask
    extends TimerTask {
        private final RunningLongTask task;

        public InterruptTimerTask(RunningLongTask runningLongTask) {
            this.task = runningLongTask;
        }

        @Override
        public void run() {
            if (this.task != null) {
                if (this.task.future != null) {
                    this.task.future.cancel(LongTaskExecutor.this.interruptCancel);
                }
                if (LongTaskExecutor.this.cancelTimer != null) {
                    LongTaskExecutor.this.cancelTimer.cancel();
                }
                LongTaskExecutor.this.cancelTimer = null;
                if (this.task.progress != null) {
                    this.task.progress.finish();
                }
                LongTaskExecutor.this.finished(this.task);
                if (!LongTaskExecutor.this.inBackground) {
                    Logger.getLogger("").warning("Task from " + LongTaskExecutor.this.name + " did not respond to cancellation request. Interrupting thread.");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private class NamedThreadFactory
    implements ThreadFactory {
        private NamedThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, LongTaskExecutor.this.name);
        }
    }

    protected class RunningLongTask<V>
    implements Callable<V> {
        private final LongTask task;
        private final Runnable runnable;
        private final Callable<V> callable;
        private final LongTaskErrorHandler errorHandler;
        private Future<V> future;
        private ProgressTicket progress;

        public RunningLongTask(LongTask task, Runnable runnable, String taskName, LongTaskErrorHandler errorHandler) {
            this.task = task;
            this.runnable = runnable;
            this.callable = null;
            this.errorHandler = errorHandler;
            this.init(taskName);
        }

        public RunningLongTask(LongTask task, Callable<V> callable, String taskName, LongTaskErrorHandler errorHandler) {
            this.task = task;
            this.runnable = null;
            this.callable = callable;
            this.errorHandler = errorHandler;
            this.init(taskName);
        }

        private void init(String taskName) {
            ProgressTicketProvider progressProvider = (ProgressTicketProvider)Lookup.getDefault().lookup(ProgressTicketProvider.class);
            if (progressProvider != null) {
                this.progress = progressProvider.createTicket(taskName, () -> {
                    LongTaskExecutor.this.cancel();
                    return true;
                });
                if (this.task != null) {
                    this.task.setProgressTicket(this.progress);
                }
            }
        }

        @Override
        public V call() {
            V result;
            block15: {
                if (this.task != null && this.progress != null) {
                    this.progress.start();
                }
                LongTaskExecutor.this.currentTask = this;
                result = null;
                try {
                    if (this.runnable != null) {
                        this.runnable.run();
                    } else if (this.callable != null) {
                        result = this.callable.call();
                        if (!LongTaskExecutor.this.inBackground) {
                            this.future = CompletableFuture.completedFuture(result);
                        }
                    }
                    LongTaskExecutor.this.currentTask = null;
                    LongTaskExecutor.this.finished(this);
                    if (this.progress != null) {
                        this.progress.finish();
                    }
                }
                catch (Throwable e) {
                    LongTaskErrorHandler err = this.errorHandler;
                    if (this.progress != null) {
                        this.progress.finish();
                    }
                    LongTaskExecutor.this.currentTask = null;
                    if (err != null) {
                        err.fatalError(e);
                    } else if (LongTaskExecutor.this.defaultErrorHandler != null) {
                        LongTaskExecutor.this.defaultErrorHandler.fatalError(e);
                    } else {
                        Logger.getLogger("").log(Level.SEVERE, "", e);
                    }
                    if (!LongTaskExecutor.this.inBackground) {
                        this.future = CompletableFuture.failedFuture(e);
                    }
                    if (this.callable == null) break block15;
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
            return result;
        }

        public boolean cancel() {
            if (this.task != null) {
                return this.task.cancel();
            }
            return false;
        }
    }
}

