/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public final class LanguageInfo {
    private LanguageInfo() {
    }

    public static String getWikiLanguagePrefix(LocaleType type) {
        return LanguageInfo.getWikiLanguagePrefix(Locale.getDefault(), type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getWikiLanguagePrefix(Locale locale, LocaleType type) {
        if (type == LocaleType.ENGLISH) {
            return "";
        }
        if (type == LocaleType.OSM_WIKI && Locale.ENGLISH.getLanguage().equals(locale.getLanguage())) {
            return "";
        }
        if (type == LocaleType.OSM_WIKI && Locale.SIMPLIFIED_CHINESE.equals(locale)) {
            return "Zh-hans:";
        }
        if (type == LocaleType.OSM_WIKI && Locale.TRADITIONAL_CHINESE.equals(locale)) {
            return "Zh-hant:";
        }
        String code = LanguageInfo.getJOSMLocaleCode(locale);
        if (type == LocaleType.OSM_WIKI) {
            if (code.matches("[^_@]+[_@][^_]+") && "en".equals(code = code.substring(0, 2))) {
                return "";
            }
            switch (code) {
                case "nb": {
                    return "No:";
                }
                case "sr@latin": {
                    return "Sr-latn:";
                }
                case "de": 
                case "es": 
                case "fr": 
                case "it": 
                case "nl": 
                case "ru": 
                case "ja": {
                    return code.toUpperCase(Locale.ENGLISH) + ":";
                }
            }
            return code.substring(0, 1).toUpperCase(Locale.ENGLISH) + code.substring(1) + ":";
        }
        if (type == LocaleType.BASELANGUAGE) {
            if (!code.matches("[^_]+_[^_]+")) return null;
            if (!"en".equals(code = code.substring(0, 2))) return code.substring(0, 1).toUpperCase(Locale.ENGLISH) + code.substring(1) + ':';
            return null;
        }
        if (type == LocaleType.DEFAULTNOTENGLISH && "en".equals(code)) {
            return null;
        }
        if (!code.matches(".+@.+")) return code.substring(0, 1).toUpperCase(Locale.ENGLISH) + code.substring(1) + ':';
        return code.substring(0, 1).toUpperCase(Locale.ENGLISH) + code.substring(1, 2) + '-' + code.substring(3, 4).toUpperCase(Locale.ENGLISH) + code.substring(4) + ':';
    }

    public static String getWikiLanguagePrefix() {
        return LanguageInfo.getWikiLanguagePrefix(LocaleType.DEFAULT);
    }

    public static String getJOSMLocaleCode() {
        return LanguageInfo.getJOSMLocaleCode(Locale.getDefault());
    }

    public static String getJOSMLocaleCode(Locale locale) {
        if (locale == null) {
            return "en";
        }
        for (String full : LanguageInfo.getLanguageCodes(locale)) {
            if ("iw_IL".equals(full)) {
                return "he";
            }
            if ("in".equals(full)) {
                return "id";
            }
            if (!I18n.hasCode(full)) continue;
            return full;
        }
        return locale.getLanguage();
    }

    public static String getJavaLocaleCode(String localeName) {
        if (localeName == null) {
            return "en";
        }
        switch (localeName) {
            case "ca@valencia": {
                return "ca__valencia";
            }
            case "sr@latin": {
                return "sr__latin";
            }
            case "he": {
                return "iw_IL";
            }
            case "id": {
                return "in";
            }
        }
        return localeName;
    }

    public static String getDisplayName(Locale locale) {
        String localeCountry;
        String currentCountry = Locale.getDefault().getCountry();
        if (currentCountry.equals(localeCountry = locale.getCountry()) && !I18n.hasCode(LanguageInfo.getLanguageCodes(locale).get(0))) {
            return new Locale(locale.getLanguage(), "", locale.getVariant()).getDisplayName();
        }
        return locale.getDisplayName();
    }

    public static Locale getLocale(String localeName) {
        return LanguageInfo.getLocale(localeName, false);
    }

    public static Locale getLocale(String localeName, boolean useDefaultCountry) {
        int encoding = localeName.indexOf(46);
        if (encoding > 0) {
            localeName = localeName.substring(0, encoding);
        }
        int country = localeName.indexOf(95);
        int variant = localeName.indexOf(64);
        if (variant < 0 && country >= 0) {
            variant = localeName.indexOf(95, country + 1);
        }
        Locale l = variant > 0 && country > 0 ? new Locale(localeName.substring(0, country), localeName.substring(country + 1, variant), localeName.substring(variant + 1)) : (variant > 0 ? new Locale(localeName.substring(0, variant), "", localeName.substring(variant + 1)) : (country > 0 ? new Locale(localeName.substring(0, country), localeName.substring(country + 1)) : new Locale(localeName, useDefaultCountry ? Locale.getDefault().getCountry() : "")));
        return l;
    }

    public static boolean isBetterLanguage(String oldLanguage, String newLanguage) {
        if (oldLanguage == null) {
            return true;
        }
        String want = LanguageInfo.getJOSMLocaleCode();
        return want.equals(newLanguage) || !want.equals(oldLanguage) && newLanguage.startsWith("en");
    }

    public static String getLanguageCodeXML() {
        String code = LanguageInfo.getJOSMLocaleCode();
        code = code.replace('@', '-');
        return code + '.';
    }

    public static String getLanguageCodeManifest() {
        String code = LanguageInfo.getJOSMLocaleCode();
        code = code.replace('@', '-');
        return code + '_';
    }

    public static List<String> getLanguageCodes(Locale l) {
        ArrayList<String> list = new ArrayList<String>(4);
        if (l == null) {
            l = Locale.getDefault();
        }
        String lang = l.getLanguage();
        String c = l.getCountry();
        String v = l.getVariant();
        if (c.isEmpty()) {
            c = null;
        }
        if (!Utils.isEmpty(v)) {
            if (c != null) {
                list.add(lang + '_' + c + '@' + v);
            }
            list.add(lang + '@' + v);
        }
        if (c != null) {
            list.add(lang + '_' + c);
        }
        list.add(lang);
        return list;
    }

    public static enum LocaleType {
        DEFAULT,
        DEFAULTNOTENGLISH,
        BASELANGUAGE,
        ENGLISH,
        OSM_WIKI;

    }
}

