/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.management;

import java.lang.ref.SoftReference;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.management.ConfigMBean;
import org.jruby.util.cli.OutputStrings;

public class Config
implements ConfigMBean {
    private final SoftReference<Ruby> ruby;

    public Config(Ruby ruby) {
        this.ruby = new SoftReference<Ruby>(ruby);
    }

    @Override
    public String getVersionString() {
        return OutputStrings.getVersionString();
    }

    @Override
    public String getCopyrightString() {
        return OutputStrings.getCopyrightString();
    }

    @Override
    public String getCompileMode() {
        return this.ruby.get().getInstanceConfig().getCompileMode().name();
    }

    @Override
    public boolean isJitLogging() {
        return this.ruby.get().getInstanceConfig().isJitLogging();
    }

    @Override
    public boolean isJitLoggingVerbose() {
        return this.ruby.get().getInstanceConfig().isJitLoggingVerbose();
    }

    @Override
    public int getJitLogEvery() {
        return this.ruby.get().getInstanceConfig().getJitLogEvery();
    }

    @Override
    public int getJitThreshold() {
        return this.ruby.get().getInstanceConfig().getJitThreshold();
    }

    @Override
    public void setJitThreshold(int threshold) {
        this.ruby.get().getInstanceConfig().setJitThreshold(threshold);
    }

    @Override
    public int getJitMax() {
        return this.ruby.get().getInstanceConfig().getJitMax();
    }

    @Override
    public void setJitMax(int max2) {
        this.ruby.get().getInstanceConfig().setJitMax(max2);
    }

    @Override
    public int getJitMaxSize() {
        return this.ruby.get().getInstanceConfig().getJitMaxSize();
    }

    @Override
    public void setJitMaxSize(int maxSize) {
        this.ruby.get().getInstanceConfig().setJitMaxSize(maxSize);
    }

    @Override
    public boolean isRunRubyInProcess() {
        return this.ruby.get().getInstanceConfig().isRunRubyInProcess();
    }

    @Override
    public String getCurrentDirectory() {
        return this.ruby.get().getInstanceConfig().getCurrentDirectory();
    }

    @Override
    public boolean isObjectSpaceEnabled() {
        return this.ruby.get().getInstanceConfig().isObjectSpaceEnabled();
    }

    @Override
    public String getEnvironment() {
        return this.ruby.get().getInstanceConfig().getEnvironment().toString();
    }

    @Override
    public String getArgv() {
        return Arrays.deepToString(this.ruby.get().getInstanceConfig().getArgv());
    }

    @Override
    public String getJRubyHome() {
        return this.ruby.get().getInstanceConfig().getJRubyHome();
    }

    @Override
    public String getRequiredLibraries() {
        return this.ruby.get().getInstanceConfig().getRequiredLibraries().toString();
    }

    @Override
    public String getLoadPaths() {
        return this.ruby.get().getInstanceConfig().getLoadPaths().toString();
    }

    @Override
    public String getDisplayedFileName() {
        return this.ruby.get().getInstanceConfig().displayedFileName();
    }

    @Override
    public String getScriptFileName() {
        return this.ruby.get().getInstanceConfig().getScriptFileName();
    }

    @Override
    public boolean isAssumeLoop() {
        return this.ruby.get().getInstanceConfig().isAssumeLoop();
    }

    @Override
    public boolean isAssumePrinting() {
        return this.ruby.get().getInstanceConfig().isAssumePrinting();
    }

    @Override
    public boolean isProcessLineEnds() {
        return this.ruby.get().getInstanceConfig().isProcessLineEnds();
    }

    @Override
    public boolean isSplit() {
        return this.ruby.get().getInstanceConfig().isSplit();
    }

    @Override
    public boolean isVerbose() {
        return this.ruby.get().getInstanceConfig().isVerbose();
    }

    @Override
    public boolean isDebug() {
        return this.ruby.get().getInstanceConfig().isDebug();
    }

    @Override
    public String getInputFieldSeparator() {
        return this.ruby.get().getInstanceConfig().getInputFieldSeparator();
    }

    @Override
    public String getKCode() {
        return this.ruby.get().getInstanceConfig().getKCode().name();
    }

    @Override
    public String getRecordSeparator() {
        return this.ruby.get().getInstanceConfig().getRecordSeparator();
    }

    @Override
    public int getSafeLevel() {
        return 0;
    }

    @Override
    public String getOptionGlobals() {
        return this.ruby.get().getInstanceConfig().getOptionGlobals().toString();
    }

    @Override
    public boolean isManagementEnabled() {
        return this.ruby.get().getInstanceConfig().isManagementEnabled();
    }

    @Override
    public boolean isFullTraceEnabled() {
        return RubyInstanceConfig.FULL_TRACE_ENABLED;
    }

    @Override
    public boolean isShowBytecode() {
        return this.ruby.get().getInstanceConfig().isShowBytecode();
    }

    @Override
    public String getExcludedMethods() {
        return this.ruby.get().getInstanceConfig().getExcludedMethods().toString();
    }
}

