/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.chart.ChartData;
import eu.hansolo.tilesfx.events.TileEvt;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import eu.hansolo.toolboxfx.GradientLookup;
import java.util.Locale;
import java.util.stream.Collectors;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Arc;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class RadialDistributionTileSkin
extends TileSkin {
    private double angleRange;
    private Arc barBackground;
    private Canvas canvas;
    private GraphicsContext ctx;
    private Text titleText;
    private Text text;
    private Text valueText;
    private Text unitText;
    private Text descriptionText;
    private TextFlow valueUnitFlow;
    private Text minValueText;
    private Text maxValueText;
    private double average;
    private double percentageTooLow;
    private double percentageTooHigh;
    private Color barBackgroundColor;
    private GradientLookup gradientLookup;

    public RadialDistributionTileSkin(Tile TILE) {
        super(TILE);
        this.handleCurrentValue(this.tile.getValue());
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.angleRange = this.tile.getAngleRange();
        this.angleStep = this.tile.getAngleStep();
        if (this.tile.isAutoScale()) {
            this.tile.calcAutoScale();
        }
        this.barBackgroundColor = this.tile.getBarBackgroundColor();
        this.gradientLookup = new GradientLookup(this.tile.getGradientStops());
        this.barBackground = new Arc(125.0, 174.0, 68.75, 68.75, this.angleRange * 0.5 + 90.0, -this.angleRange);
        this.barBackground.setType(ArcType.OPEN);
        this.barBackground.setStroke((Paint)this.barBackgroundColor);
        this.barBackground.setStrokeWidth(14.097745);
        this.barBackground.setStrokeLineCap(StrokeLineCap.ROUND);
        this.barBackground.setFill(null);
        this.canvas = new Canvas();
        this.ctx = this.canvas.getGraphicsContext2D();
        this.titleText = new Text(this.tile.getTitle());
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
        this.valueText = new Text(String.format(this.locale, this.formatString, this.tile.getCurrentValue()));
        this.valueText.setFill((Paint)this.tile.getValueColor());
        Helper.enableNode((Node)this.valueText, this.tile.isValueVisible() && !this.tile.isAlert());
        this.unitText = new Text(this.tile.getUnit());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.tile.getUnit().isEmpty());
        this.valueUnitFlow = new TextFlow(new Node[]{this.valueText, this.unitText});
        this.valueUnitFlow.setTextAlignment(TextAlignment.CENTER);
        this.descriptionText = new Text(this.tile.getDescription());
        this.descriptionText.setFill((Paint)this.tile.getDescriptionColor());
        this.minValueText = new Text(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", this.tile.getMinValue()));
        this.minValueText.setFill((Paint)this.tile.getTitleColor());
        this.minValueText.setTextOrigin(VPos.CENTER);
        this.maxValueText = new Text(String.format(this.locale, "%." + this.tile.getTickLabelDecimals() + "f", this.tile.getMaxValue()));
        this.maxValueText.setFill((Paint)this.tile.getTitleColor());
        this.maxValueText.setTextOrigin(VPos.CENTER);
        this.text = new Text(this.tile.getText());
        this.text.setTextOrigin(VPos.TOP);
        this.text.setFill((Paint)this.tile.getTextColor());
        this.getPane().getChildren().addAll((Object[])new Node[]{this.barBackground, this.canvas, this.titleText, this.descriptionText, this.valueUnitFlow, this.minValueText, this.maxValueText, this.text});
        this.updateValues();
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.tile.getChartData().addListener(c -> this.updateValues());
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (TileEvt.VISIBILITY.getName().equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode((Node)this.valueText, this.tile.isValueVisible());
            Helper.enableNode((Node)this.valueUnitFlow, !this.tile.getUnit().isEmpty());
            Helper.enableNode((Node)this.minValueText, this.tile.getMinValueVisible());
            Helper.enableNode((Node)this.maxValueText, this.tile.getMaxValueVisible());
            Helper.enableNode((Node)this.text, this.tile.isTextVisible());
        }
    }

    @Override
    protected void handleCurrentValue(double VALUE) {
        this.resizeDynamicText();
    }

    private void updateValues() {
        if (!this.tile.getChartData().isEmpty()) {
            double noOfEntriesInRange = this.tile.getChartData().stream().filter(entry -> entry.getValue() >= this.tile.getLowerThreshold() && entry.getValue() <= this.tile.getThreshold()).collect(Collectors.toList()).size();
            double noOfEntries = this.tile.getChartData().size();
            double percentageInRange = noOfEntriesInRange / noOfEntries * 100.0;
            this.valueText.setText(String.format(Locale.US, "%.0f", percentageInRange));
            this.average = this.tile.getChartData().stream().mapToDouble(ChartData::getValue).sum() / noOfEntries;
            double noOfEntriesTooLow = this.tile.getChartData().stream().filter(entry -> entry.getValue() < this.tile.getLowerThreshold()).collect(Collectors.toList()).size();
            double noOfEntriesTooHigh = this.tile.getChartData().stream().filter(entry -> entry.getValue() > this.tile.getThreshold()).collect(Collectors.toList()).size();
            this.percentageTooLow = noOfEntriesTooLow / noOfEntries * 100.0;
            this.percentageTooHigh = noOfEntriesTooHigh / noOfEntries * 100.0;
        }
        this.drawDots();
    }

    public void layoutChildren(double x, double y, double w, double h2) {
        super.layoutChildren(x, y, w, h2);
        this.resizeDynamicText();
        this.resizeStaticText();
    }

    @Override
    protected void resizeDynamicText() {
        double maxWidth = this.unitText.isManaged() ? this.width - this.size * 0.275 : this.width - this.size * 0.1;
        double fontSize = this.size * 0.24;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font((String)customFont.getFamily(), (double)fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        maxWidth = this.width - (this.width - this.size * 0.275);
        fontSize = this.size * 0.1;
        this.descriptionText.setFont(Fonts.latoLight(fontSize));
        if (this.descriptionText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.descriptionText, maxWidth, fontSize);
        }
        this.descriptionText.setX(this.width * 0.5 - this.descriptionText.getLayoutBounds().getWidth() * 0.5);
        this.descriptionText.setY(this.height * 0.44);
        fontSize = this.size * 0.12;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        fontSize = this.size * 0.04;
        this.minValueText.setFont(Fonts.latoRegular(fontSize));
        this.minValueText.setText(String.format(this.locale, "%.0f", this.tile.getMinValue()));
        this.minValueText.setX(this.width * 0.5 - this.barBackground.getRadiusX() * 0.9);
        this.minValueText.setY(this.text.isManaged() ? this.contentBounds.getCenterY() + this.size * 0.25 : this.contentBounds.getCenterY() + this.size * 0.325);
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        this.maxValueText.setText(String.format(this.locale, "%.0f", this.tile.getMaxValue()));
        this.maxValueText.setX(this.width * 0.5 + this.barBackground.getRadiusX() * 0.9 - this.maxValueText.getLayoutBounds().getWidth());
        this.maxValueText.setY(this.text.isManaged() ? this.contentBounds.getCenterY() + this.size * 0.25 : this.contentBounds.getCenterY() + this.size * 0.325);
        fontSize = this.size * 0.06;
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.1);
    }

    @Override
    protected void resize() {
        super.resize();
        double centerX = this.width * 0.5;
        double centerY = this.height * 0.5;
        double barRadius = this.size * 0.3;
        double barWidth = this.size * 0.07;
        this.barBackground.setCenterX(centerX);
        this.barBackground.setCenterY(centerY);
        this.barBackground.setRadiusX(barRadius);
        this.barBackground.setRadiusY(barRadius);
        this.barBackground.setStrokeWidth(barWidth);
        this.barBackground.setStartAngle(this.angleRange * 0.5 + 90.0);
        this.barBackground.setLength(-this.angleRange);
        this.canvas.setWidth(this.contentBounds.getWidth());
        this.canvas.setHeight(this.contentBounds.getHeight());
        this.canvas.relocate(this.contentBounds.getMinX(), this.contentBounds.getMinY());
        this.resizeStaticText();
        this.resizeDynamicText();
        this.valueUnitFlow.setPrefWidth(this.width - this.doubleInset);
        this.valueUnitFlow.relocate(this.inset, this.height * 0.5 - this.size * 0.07);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.angleRange = this.tile.getAngleRange();
        this.angleStep = this.tile.getAngleStep();
        this.titleText.setText(this.tile.getTitle());
        this.descriptionText.setText(this.tile.getDescription());
        this.text.setText(this.tile.getText());
        this.unitText.setText("%");
        this.minValueText.setText(String.format(this.locale, this.tickLabelFormatString, this.tile.getMinValue()));
        this.maxValueText.setText(String.format(this.locale, this.tickLabelFormatString, this.tile.getMaxValue()));
        this.resizeStaticText();
        this.barBackgroundColor = this.tile.getBarBackgroundColor();
        if (this.tile.isStrokeWithGradient()) {
            this.gradientLookup.setStops(this.tile.getGradientStops());
        }
        this.drawDots();
        this.barBackground.setStroke((Paint)this.tile.getBarBackgroundColor());
        this.barBackground.setVisible(false);
        this.titleText.setFill((Paint)this.tile.getTitleColor());
        this.descriptionText.setFill((Paint)this.tile.getDescriptionColor());
        this.text.setFill((Paint)this.tile.getTextColor());
        this.minValueText.setFill((Paint)this.tile.getTitleColor());
        this.maxValueText.setFill((Paint)this.tile.getTitleColor());
        this.valueText.setFill((Paint)this.tile.getValueColor());
        this.unitText.setFill((Paint)this.tile.getUnitColor());
    }

    private void drawDots() {
        double height;
        double width = this.canvas.getWidth();
        double size = width < (height = this.canvas.getHeight()) ? width : height;
        this.ctx.clearRect(0.0, 0.0, width, height);
        double centerX = width * 0.5;
        double centerY = height * 0.5;
        double radius = size * 0.375;
        double diameter = size * 0.08;
        double range = this.maxValue - this.minValue;
        double startAngle = this.tile.getStartAngle();
        double angleRange = this.tile.getAngleRange();
        double angleStep = angleRange / range;
        double dotDiameter = diameter * 0.95;
        double barBackgroundX = centerX - radius - diameter * 0.5;
        double barBackgroundY = centerY - radius - diameter * 0.5;
        double barBackgroundW = radius * 2.0 + diameter;
        double barBackgroundH = radius * 2.0 + diameter;
        double rangeLowerBound = this.tile.getLowerThreshold();
        double rangeUpperBound = this.tile.getThreshold();
        double targetStartAngle = startAngle + angleRange - rangeLowerBound * angleStep;
        double targetAngleRange = -(rangeUpperBound - rangeLowerBound) * angleStep;
        double offsetX = barBackgroundX + diameter * 1.05;
        double offsetY = barBackgroundY + diameter * 1.05;
        double angleOffset = startAngle - 45.0;
        boolean strokeWithGradient = this.tile.isStrokeWithGradient();
        this.ctx.setStroke((Paint)this.tile.getBarBackgroundColor());
        this.ctx.setLineWidth(diameter);
        this.ctx.setLineCap(StrokeLineCap.ROUND);
        this.ctx.strokeArc(barBackgroundX, barBackgroundY, barBackgroundW, barBackgroundH, startAngle, angleRange, ArcType.OPEN);
        this.ctx.setLineWidth(1.0);
        this.ctx.setStroke((Paint)Color.TRANSPARENT);
        if (!strokeWithGradient) {
            this.ctx.setFill((Paint)Helper.getColorWithOpacity(this.tile.getBarColor(), 0.1));
        }
        for (ChartData data : this.tile.getChartData()) {
            double angle = angleOffset + data.getValue() * angleStep;
            this.ctx.save();
            this.ctx.translate(centerX, centerY);
            this.ctx.rotate(angle);
            this.ctx.translate(-centerX, -centerY);
            if (strokeWithGradient) {
                this.ctx.setFill((Paint)this.gradientLookup.getColorAt(data.getValue() / range));
            }
            this.ctx.fillOval(offsetX, offsetY, dotDiameter, dotDiameter);
            this.ctx.restore();
        }
        this.ctx.save();
        double[] xy1 = Helper.rotatePointAroundRotationCenter(centerX - radius - diameter, centerY, centerX, centerY, -30.0 + rangeLowerBound * angleStep);
        double[] xyc1 = Helper.rotatePointAroundRotationCenter(centerX - radius - diameter, centerY, centerX, centerY, -30.0 + rangeUpperBound * angleStep + 8.0);
        double[] xyc2 = Helper.rotatePointAroundRotationCenter(centerX - radius, centerY, centerX, centerY, -30.0 + rangeUpperBound * angleStep + 8.0);
        double[] xy3 = Helper.rotatePointAroundRotationCenter(centerX - radius, centerY, centerX, centerY, -30.0 + rangeUpperBound * angleStep);
        double[] xyc3 = Helper.rotatePointAroundRotationCenter(centerX - radius, centerY, centerX, centerY, -30.0 + rangeLowerBound * angleStep - 8.0);
        double[] xyc4 = Helper.rotatePointAroundRotationCenter(centerX - radius - diameter, centerY, centerX, centerY, -30.0 + rangeLowerBound * angleStep - 8.0);
        this.ctx.beginPath();
        this.ctx.moveTo(xy1[0], xy1[1]);
        this.ctx.arc(centerX, centerY, radius + diameter, radius + diameter, targetStartAngle, targetAngleRange);
        this.ctx.bezierCurveTo(xyc1[0], xyc1[1], xyc2[0], xyc2[1], xy3[0], xy3[1]);
        this.ctx.arc(centerX, centerY, radius, radius, targetStartAngle + targetAngleRange, -targetAngleRange);
        this.ctx.bezierCurveTo(xyc3[0], xyc3[1], xyc4[0], xyc4[1], xy1[0], xy1[1]);
        this.ctx.closePath();
        this.ctx.setFill((Paint)Color.TRANSPARENT);
        this.ctx.setStroke((Paint)this.tile.getForegroundColor());
        this.ctx.stroke();
        this.ctx.restore();
        this.ctx.save();
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setFill((Paint)this.tile.getForegroundColor());
        this.ctx.setFont(Fonts.latoBold(size * 0.04));
        this.ctx.translate(centerX, centerY);
        this.ctx.rotate(-30.0 + this.average * angleStep);
        this.ctx.save();
        this.ctx.translate(-radius - diameter * 0.5, 0.0);
        this.ctx.rotate(-90.0);
        this.ctx.fillText(String.format(Locale.US, "%.0f", this.average), 0.0, 0.0);
        this.ctx.translate(radius + diameter * 0.5, 0.0);
        this.ctx.restore();
        this.ctx.translate(-centerX, -centerY);
        this.ctx.restore();
        this.ctx.setFill((Paint)this.tile.getForegroundColor());
        this.ctx.setTextAlign(TextAlignment.CENTER);
        this.ctx.setTextBaseline(VPos.CENTER);
        this.ctx.setFont(Fonts.latoRegular(size * 0.05));
        this.ctx.fillText(String.format(Locale.US, "%.0f", this.average), width * 0.25, height * 0.9);
        this.ctx.setFont(Fonts.latoLight(size * 0.05));
        this.ctx.fillText("AVG", width * 0.25, height * 0.95);
        this.ctx.setFont(Fonts.latoRegular(size * 0.05));
        this.ctx.fillText(String.format(Locale.US, "%.0f%%", this.percentageTooHigh), width * 0.5, height * 0.9);
        this.ctx.setFont(Fonts.latoLight(size * 0.05));
        this.ctx.fillText("HIGH", width * 0.5, height * 0.95);
        this.ctx.setFont(Fonts.latoRegular(size * 0.05));
        this.ctx.fillText(String.format(Locale.US, "%.0f%%", this.percentageTooLow), width * 0.75, height * 0.9);
        this.ctx.setFont(Fonts.latoLight(size * 0.05));
        this.ctx.fillText("LOW", width * 0.75, height * 0.95);
    }
}

