/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.toolboxfx.geom;

import eu.hansolo.toolboxfx.ValueObject;
import eu.hansolo.toolboxfx.geom.Poi;
import eu.hansolo.toolboxfx.geom.PoiSize;
import java.util.HashMap;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Dimension2D;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;

public class PoiBuilder<B extends PoiBuilder<B>> {
    private HashMap<String, Property> properties = new HashMap();

    protected PoiBuilder() {
    }

    public static final PoiBuilder create() {
        return new PoiBuilder();
    }

    public final B lat(double latitude) {
        this.properties.put("lat", (Property)new SimpleDoubleProperty(latitude));
        return (B)this;
    }

    public final B lon(double longitude) {
        this.properties.put("lon", (Property)new SimpleDoubleProperty(longitude));
        return (B)this;
    }

    public final B name(String name) {
        this.properties.put("name", (Property)new SimpleStringProperty(name));
        return (B)this;
    }

    public final B info(String info) {
        this.properties.put("info", (Property)new SimpleStringProperty(info));
        return (B)this;
    }

    public final B valueObject(ValueObject valueObject) {
        this.properties.put("valueObject", (Property)new SimpleObjectProperty((Object)valueObject));
        return (B)this;
    }

    public final B pointSize(PoiSize poiSize) {
        this.properties.put("poiSize", (Property)new SimpleObjectProperty((Object)poiSize));
        return (B)this;
    }

    public final B fill(Color fill) {
        this.properties.put("fill", (Property)new SimpleObjectProperty((Object)fill));
        return (B)this;
    }

    public final B stroke(Color stroke) {
        this.properties.put("stroke", (Property)new SimpleObjectProperty((Object)stroke));
        return (B)this;
    }

    public final B image(Image image) {
        this.properties.put("image", (Property)new SimpleObjectProperty((Object)image));
        return (B)this;
    }

    public final B svgPath(String svgPath) {
        this.properties.put("svgPath", (Property)new SimpleStringProperty(svgPath));
        return (B)this;
    }

    public final B svgPathDim(Dimension2D svgPathDim) {
        this.properties.put("svgPathDim", (Property)new SimpleObjectProperty((Object)svgPathDim));
        return (B)this;
    }

    public final Poi build() {
        Poi poi = new Poi();
        this.properties.forEach((key, property) -> {
            if ("lat".equals(key)) {
                poi.setLat(((DoubleProperty)this.properties.get(key)).get());
            } else if ("lon".equals(key)) {
                poi.setLon(((DoubleProperty)this.properties.get(key)).get());
            } else if ("name".equals(key)) {
                poi.setName((String)((StringProperty)this.properties.get(key)).get());
            } else if ("info".equals(key)) {
                poi.setInfo((String)((StringProperty)this.properties.get(key)).get());
            } else if ("valueObject".equals(key)) {
                poi.setValueObject((ValueObject)((ObjectProperty)this.properties.get(key)).get());
            } else if ("poiSize".equals(key)) {
                poi.setPoiSize((PoiSize)((Object)((Object)((ObjectProperty)this.properties.get(key)).get())));
            } else if ("fill".equals(key)) {
                poi.setFill((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("stroke".equals(key)) {
                poi.setStroke((Color)((ObjectProperty)this.properties.get(key)).get());
            } else if ("image".equals(key)) {
                poi.setImage((Image)((ObjectProperty)this.properties.get(key)).get());
            } else if ("svgPath".equals(key)) {
                poi.setSvgPath((String)((StringProperty)this.properties.get(key)).get());
            } else if ("svgPathDim".equals(key)) {
                poi.setSvgPathDim((Dimension2D)((ObjectProperty)this.properties.get(key)).get());
            }
        });
        return poi;
    }
}

