/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.dialog;

import impl.org.controlsfx.i18n.Localization;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import org.controlsfx.dialog.DialogUtils;

public class ProgressDialog
extends Dialog<Void> {
    public ProgressDialog(Worker<?> worker) {
        if (worker != null && (worker.getState() == Worker.State.CANCELLED || worker.getState() == Worker.State.FAILED || worker.getState() == Worker.State.SUCCEEDED)) {
            return;
        }
        this.setResultConverter(dialogButton -> null);
        DialogPane dialogPane = this.getDialogPane();
        this.setTitle(Localization.getString("progress.dlg.title"));
        dialogPane.setHeaderText(Localization.getString("progress.dlg.header"));
        dialogPane.getStyleClass().add((Object)"progress-dialog");
        dialogPane.getStylesheets().add((Object)ProgressDialog.class.getResource("dialogs.css").toExternalForm());
        Label progressMessage = new Label();
        progressMessage.textProperty().bind((ObservableValue)worker.messageProperty());
        WorkerProgressPane content = new WorkerProgressPane(this);
        content.setMaxWidth(Double.MAX_VALUE);
        content.setWorker(worker);
        VBox vbox = new VBox(10.0, new Node[]{progressMessage, content});
        vbox.setMaxWidth(Double.MAX_VALUE);
        vbox.setPrefSize(300.0, 100.0);
        Label contentText = new Label();
        contentText.setWrapText(true);
        vbox.getChildren().add(0, (Object)contentText);
        contentText.textProperty().bind((ObservableValue)dialogPane.contentTextProperty());
        dialogPane.setContent((Node)vbox);
    }

    private static class WorkerProgressPane
    extends Region {
        private Worker<?> worker;
        private boolean dialogVisible = false;
        private boolean cancelDialogShow = false;
        private ChangeListener<Worker.State> stateListener = new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observable2, Worker.State old, Worker.State value) {
                switch (value) {
                    case CANCELLED: 
                    case FAILED: 
                    case SUCCEEDED: {
                        if (!dialogVisible) {
                            cancelDialogShow = true;
                            this.end();
                            break;
                        }
                        if (old != Worker.State.SCHEDULED && old != Worker.State.RUNNING) break;
                        this.end();
                        break;
                    }
                    case SCHEDULED: {
                        this.begin();
                        break;
                    }
                }
            }
        };
        private final ProgressDialog dialog;
        private final ProgressBar progressBar;

        public final void setWorker(Worker<?> newWorker) {
            if (newWorker != this.worker) {
                if (this.worker != null) {
                    this.worker.stateProperty().removeListener(this.stateListener);
                    this.end();
                }
                this.worker = newWorker;
                if (newWorker != null) {
                    newWorker.stateProperty().addListener(this.stateListener);
                    if (newWorker.getState() == Worker.State.RUNNING || newWorker.getState() == Worker.State.SCHEDULED) {
                        this.begin();
                    }
                }
            }
        }

        public WorkerProgressPane(ProgressDialog dialog) {
            this.dialog = dialog;
            this.progressBar = new ProgressBar();
            this.progressBar.setMaxWidth(Double.MAX_VALUE);
            this.getChildren().add((Object)this.progressBar);
            if (this.worker != null) {
                this.progressBar.progressProperty().bind((ObservableValue)this.worker.progressProperty());
            }
        }

        private void begin() {
            this.cancelDialogShow = false;
            Platform.runLater(() -> {
                if (!this.cancelDialogShow) {
                    this.progressBar.progressProperty().bind((ObservableValue)this.worker.progressProperty());
                    this.dialogVisible = true;
                    this.dialog.show();
                }
            });
        }

        private void end() {
            this.progressBar.progressProperty().unbind();
            this.dialogVisible = false;
            DialogUtils.forcefullyHideDialog(this.dialog);
        }

        protected void layoutChildren() {
            if (this.progressBar != null) {
                Insets insets = this.getInsets();
                double w = this.getWidth() - insets.getLeft() - insets.getRight();
                double h2 = this.getHeight() - insets.getTop() - insets.getBottom();
                double prefH = this.progressBar.prefHeight(-1.0);
                double x = insets.getLeft() + (w - w) / 2.0;
                double y = insets.getTop() + (h2 - prefH) / 2.0;
                this.progressBar.resizeRelocate(x, y, w, prefH);
            }
        }
    }
}

