/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.reindex;

import java.io.IOException;
import org.opensearch.action.IndicesRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.reindex.AbstractBulkIndexByScrollRequest;
import org.opensearch.tasks.TaskId;

public class UpdateByQueryRequest
extends AbstractBulkIndexByScrollRequest<UpdateByQueryRequest>
implements IndicesRequest.Replaceable,
ToXContentObject {
    private String pipeline;

    public UpdateByQueryRequest() {
        this(new SearchRequest());
    }

    public UpdateByQueryRequest(String ... indices) {
        this(new SearchRequest(indices));
    }

    UpdateByQueryRequest(SearchRequest search) {
        this(search, true);
    }

    public UpdateByQueryRequest(StreamInput in) throws IOException {
        super(in);
        this.pipeline = in.readOptionalString();
    }

    private UpdateByQueryRequest(SearchRequest search, boolean setDefaults) {
        super(search, setDefaults);
    }

    public UpdateByQueryRequest setPipeline(String pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public UpdateByQueryRequest setQuery(QueryBuilder query) {
        if (query != null) {
            this.getSearchRequest().source().query(query);
        }
        return this;
    }

    public UpdateByQueryRequest setRouting(String routing) {
        if (routing != null) {
            this.getSearchRequest().routing(routing);
        }
        return this;
    }

    public UpdateByQueryRequest setBatchSize(int size) {
        this.getSearchRequest().source().size(size);
        return this;
    }

    public UpdateByQueryRequest setIndicesOptions(IndicesOptions indicesOptions) {
        this.getSearchRequest().indicesOptions(indicesOptions);
        return this;
    }

    public int getBatchSize() {
        return this.getSearchRequest().source().size();
    }

    public String getRouting() {
        return this.getSearchRequest().routing();
    }

    public String getPipeline() {
        return this.pipeline;
    }

    @Override
    protected UpdateByQueryRequest self() {
        return this;
    }

    @Override
    public UpdateByQueryRequest forSlice(TaskId slicingTask, SearchRequest slice, int totalSlices) {
        UpdateByQueryRequest request = this.doForSlice(new UpdateByQueryRequest(slice, false), slicingTask, totalSlices);
        request.setPipeline(this.pipeline);
        return request;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("update-by-query ");
        this.searchToString(b);
        return b.toString();
    }

    @Override
    public IndicesRequest indices(String ... indices) {
        assert (this.getSearchRequest() != null);
        this.getSearchRequest().indices(indices);
        return this;
    }

    @Override
    public String[] indices() {
        assert (this.getSearchRequest() != null);
        return this.getSearchRequest().indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        assert (this.getSearchRequest() != null);
        return this.getSearchRequest().indicesOptions();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.pipeline);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.getScript() != null) {
            builder.field("script");
            this.getScript().toXContent(builder, params);
        }
        this.getSearchRequest().source().innerToXContent(builder, params);
        builder.endObject();
        return builder;
    }
}

