/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.ad.NodeStateManager;
import org.opensearch.ad.ProfileUtil;
import org.opensearch.ad.common.exception.AnomalyDetectionException;
import org.opensearch.ad.common.exception.EndRunException;
import org.opensearch.ad.common.exception.ResourceNotFoundException;
import org.opensearch.ad.constant.CommonErrorMessages;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.AnomalyDetectionIndices;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyDetectorJob;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.model.DetectorProfileName;
import org.opensearch.ad.model.FeatureData;
import org.opensearch.ad.model.IntervalTimeConfiguration;
import org.opensearch.ad.task.ADTaskCacheManager;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.AnomalyResultResponse;
import org.opensearch.ad.transport.ProfileAction;
import org.opensearch.ad.transport.ProfileRequest;
import org.opensearch.ad.transport.RCFPollingAction;
import org.opensearch.ad.transport.RCFPollingRequest;
import org.opensearch.ad.transport.handler.AnomalyIndexHandler;
import org.opensearch.ad.util.DiscoveryNodeFilterer;
import org.opensearch.ad.util.ExceptionUtil;
import org.opensearch.client.Client;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.search.SearchHits;
import org.opensearch.threadpool.ThreadPool;

public class ExecuteADResultResponseRecorder {
    private static final Logger log = LogManager.getLogger(ExecuteADResultResponseRecorder.class);
    private AnomalyDetectionIndices anomalyDetectionIndices;
    private AnomalyIndexHandler<AnomalyResult> anomalyResultHandler;
    private ADTaskManager adTaskManager;
    private DiscoveryNodeFilterer nodeFilter;
    private ThreadPool threadPool;
    private Client client;
    private NodeStateManager nodeStateManager;
    private ADTaskCacheManager adTaskCacheManager;
    private int rcfMinSamples;

    public ExecuteADResultResponseRecorder(AnomalyDetectionIndices anomalyDetectionIndices, AnomalyIndexHandler<AnomalyResult> anomalyResultHandler, ADTaskManager adTaskManager, DiscoveryNodeFilterer nodeFilter, ThreadPool threadPool, Client client, NodeStateManager nodeStateManager, ADTaskCacheManager adTaskCacheManager, int rcfMinSamples) {
        this.anomalyDetectionIndices = anomalyDetectionIndices;
        this.anomalyResultHandler = anomalyResultHandler;
        this.adTaskManager = adTaskManager;
        this.nodeFilter = nodeFilter;
        this.threadPool = threadPool;
        this.client = client;
        this.nodeStateManager = nodeStateManager;
        this.adTaskCacheManager = adTaskCacheManager;
        this.rcfMinSamples = rcfMinSamples;
    }

    public void indexAnomalyResult(Instant detectionStartTime, Instant executionStartTime, AnomalyResultResponse response, AnomalyDetector detector) {
        String detectorId = detector.getDetectorId();
        try {
            if ((response.getAnomalyScore() <= 0.0 || Double.isNaN(response.getAnomalyScore())) && response.getError() == null) {
                this.updateRealtimeTask(response, detectorId);
                return;
            }
            IntervalTimeConfiguration windowDelay = (IntervalTimeConfiguration)detector.getWindowDelay();
            Instant dataStartTime = detectionStartTime.minus(windowDelay.getInterval(), windowDelay.getUnit());
            Instant dataEndTime = executionStartTime.minus(windowDelay.getInterval(), windowDelay.getUnit());
            User user = detector.getUser();
            if (response.getError() != null) {
                log.info("Anomaly result action run successfully for {} with error {}", (Object)detectorId, (Object)response.getError());
            }
            AnomalyResult anomalyResult = response.toAnomalyResult(detectorId, dataStartTime, dataEndTime, executionStartTime, Instant.now(), this.anomalyDetectionIndices.getSchemaVersion(ADIndex.RESULT), user, response.getError());
            String resultIndex = detector.getResultIndex();
            this.anomalyResultHandler.index(anomalyResult, detectorId, resultIndex);
            this.updateRealtimeTask(response, detectorId);
        }
        catch (EndRunException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Failed to index anomaly result for " + detectorId, (Throwable)e);
        }
    }

    private void updateRealtimeTask(AnomalyResultResponse response, String detectorId) {
        if (response.isHCDetector() != null && response.isHCDetector().booleanValue()) {
            if (this.adTaskManager.skipUpdateHCRealtimeTask(detectorId, response.getError())) {
                return;
            }
            DiscoveryNode[] dataNodes = this.nodeFilter.getEligibleDataNodes();
            HashSet<DetectorProfileName> profiles = new HashSet<DetectorProfileName>();
            profiles.add(DetectorProfileName.INIT_PROGRESS);
            ProfileRequest profileRequest = new ProfileRequest(detectorId, profiles, true, dataNodes);
            Runnable profileHCInitProgress = () -> this.client.execute((ActionType)ProfileAction.INSTANCE, (ActionRequest)profileRequest, ActionListener.wrap(r -> {
                log.debug("Update latest realtime task for HC detector {}, total updates: {}", (Object)detectorId, (Object)r.getTotalUpdates());
                this.updateLatestRealtimeTask(detectorId, null, r.getTotalUpdates(), response.getDetectorIntervalInMinutes(), response.getError());
            }, e -> log.error("Failed to update latest realtime task for " + detectorId, (Throwable)e)));
            if (!this.adTaskManager.isHCRealtimeTaskStartInitializing(detectorId)) {
                this.threadPool.schedule(profileHCInitProgress, new TimeValue(60L, TimeUnit.SECONDS), "ad-threadpool");
            } else {
                profileHCInitProgress.run();
            }
        } else {
            log.debug("Update latest realtime task for single stream detector {}, total updates: {}", (Object)detectorId, (Object)response.getRcfTotalUpdates());
            this.updateLatestRealtimeTask(detectorId, null, response.getRcfTotalUpdates(), response.getDetectorIntervalInMinutes(), response.getError());
        }
    }

    private void updateLatestRealtimeTask(String detectorId, String taskState, Long rcfTotalUpdates, Long detectorIntervalInMinutes, String error) {
        ActionListener listener = ActionListener.wrap(r -> {
            if (r != null) {
                log.debug("Updated latest realtime task successfully for detector {}, taskState: {}", (Object)detectorId, (Object)taskState);
            }
        }, e -> {
            if (e instanceof ResourceNotFoundException && e.getMessage().contains(CommonErrorMessages.CAN_NOT_FIND_LATEST_TASK)) {
                log.error("Can't find latest realtime task of detector " + detectorId);
                this.adTaskManager.removeRealtimeTaskCache(detectorId);
            } else {
                log.error("Failed to update latest realtime task for detector " + detectorId, (Throwable)e);
            }
        });
        if (!this.adTaskCacheManager.hasQueriedResultIndex(detectorId) && rcfTotalUpdates != null && rcfTotalUpdates < (long)this.rcfMinSamples) {
            this.confirmTotalRCFUpdatesFound(detectorId, taskState, rcfTotalUpdates, detectorIntervalInMinutes, error, (ActionListener<Long>)ActionListener.wrap(r -> this.adTaskManager.updateLatestRealtimeTaskOnCoordinatingNode(detectorId, taskState, (Long)r, detectorIntervalInMinutes, error, (ActionListener<UpdateResponse>)listener), e -> {
                log.error("Fail to confirm rcf update", (Throwable)e);
                this.adTaskManager.updateLatestRealtimeTaskOnCoordinatingNode(detectorId, taskState, rcfTotalUpdates, detectorIntervalInMinutes, error, (ActionListener<UpdateResponse>)listener);
            }));
        } else {
            this.adTaskManager.updateLatestRealtimeTaskOnCoordinatingNode(detectorId, taskState, rcfTotalUpdates, detectorIntervalInMinutes, error, (ActionListener<UpdateResponse>)listener);
        }
    }

    public void indexAnomalyResultException(Instant detectionStartTime, Instant executionStartTime, String errorMessage, String taskState, AnomalyDetector detector) {
        String detectorId = detector.getDetectorId();
        try {
            IntervalTimeConfiguration windowDelay = (IntervalTimeConfiguration)detector.getWindowDelay();
            Instant dataStartTime = detectionStartTime.minus(windowDelay.getInterval(), windowDelay.getUnit());
            Instant dataEndTime = executionStartTime.minus(windowDelay.getInterval(), windowDelay.getUnit());
            User user = detector.getUser();
            AnomalyResult anomalyResult = new AnomalyResult(detectorId, null, new ArrayList<FeatureData>(), dataStartTime, dataEndTime, executionStartTime, Instant.now(), errorMessage, null, user, this.anomalyDetectionIndices.getSchemaVersion(ADIndex.RESULT), null);
            String resultIndex = detector.getResultIndex();
            if (resultIndex != null && !this.anomalyDetectionIndices.doesIndexExist(resultIndex)) {
                this.anomalyResultHandler.index(anomalyResult, detectorId, null);
            } else {
                this.anomalyResultHandler.index(anomalyResult, detectorId, resultIndex);
            }
            if (errorMessage.contains("No checkpoints found for model id ") && !detector.isMultiCategoryDetector()) {
                this.threadPool.schedule(() -> {
                    RCFPollingRequest request = new RCFPollingRequest(detectorId);
                    this.client.execute((ActionType)RCFPollingAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(rcfPollResponse -> {
                        long totalUpdates = rcfPollResponse.getTotalUpdates();
                        this.updateLatestRealtimeTask(detectorId, taskState, totalUpdates, detector.getDetectorIntervalInMinutes(), totalUpdates > 0L ? "" : errorMessage);
                    }, e -> {
                        log.error("Fail to execute RCFRollingAction", (Throwable)e);
                        this.updateLatestRealtimeTask(detectorId, taskState, null, null, errorMessage);
                    }));
                }, new TimeValue(60L, TimeUnit.SECONDS), "ad-threadpool");
            } else {
                this.updateLatestRealtimeTask(detectorId, taskState, null, null, errorMessage);
            }
        }
        catch (Exception e) {
            log.error("Failed to index anomaly result for " + detectorId, (Throwable)e);
        }
    }

    private void confirmTotalRCFUpdatesFound(String detectorId, String taskState, Long rcfTotalUpdates, Long detectorIntervalInMinutes, String error, ActionListener<Long> listener) {
        this.nodeStateManager.getAnomalyDetector(detectorId, (ActionListener<Optional<AnomalyDetector>>)ActionListener.wrap(detectorOptional -> {
            if (!detectorOptional.isPresent()) {
                listener.onFailure((Exception)new AnomalyDetectionException(detectorId, "fail to get detector"));
                return;
            }
            this.nodeStateManager.getAnomalyDetectorJob(detectorId, (ActionListener<Optional<AnomalyDetectorJob>>)ActionListener.wrap(jobOptional -> {
                if (!jobOptional.isPresent()) {
                    listener.onFailure((Exception)new AnomalyDetectionException(detectorId, "fail to get job"));
                    return;
                }
                ProfileUtil.confirmDetectorRealtimeInitStatus((AnomalyDetector)detectorOptional.get(), ((AnomalyDetectorJob)jobOptional.get()).getEnabledTime().toEpochMilli(), this.client, (ActionListener<SearchResponse>)ActionListener.wrap(searchResponse -> ActionListener.completeWith((ActionListener)listener, () -> {
                    SearchHits hits = searchResponse.getHits();
                    Long correctedTotalUpdates = rcfTotalUpdates;
                    if (hits.getTotalHits().value > 0L) {
                        correctedTotalUpdates = this.rcfMinSamples;
                    }
                    this.adTaskCacheManager.markResultIndexQueried(detectorId);
                    return correctedTotalUpdates;
                }), exception -> {
                    if (ExceptionUtil.isIndexNotAvailable(exception)) {
                        this.adTaskCacheManager.markResultIndexQueried(detectorId);
                        listener.onResponse((Object)0L);
                    } else {
                        listener.onFailure(exception);
                    }
                }));
            }, e -> listener.onFailure((Exception)new AnomalyDetectionException(detectorId, "fail to get job"))));
        }, e -> listener.onFailure((Exception)new AnomalyDetectionException(detectorId, "fail to get detector"))));
    }
}

