/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.transport;

import java.net.ConnectException;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.Version;
import org.opensearch.action.ActionListener;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.ad.breaker.ADCircuitBreakerService;
import org.opensearch.ad.cluster.HashRing;
import org.opensearch.ad.common.exception.LimitExceededException;
import org.opensearch.ad.ml.ModelManager;
import org.opensearch.ad.ml.ThresholdingResult;
import org.opensearch.ad.stats.ADStats;
import org.opensearch.ad.stats.StatNames;
import org.opensearch.ad.transport.RCFResultAction;
import org.opensearch.ad.transport.RCFResultRequest;
import org.opensearch.ad.transport.RCFResultResponse;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.inject.Inject;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class RCFResultTransportAction
extends HandledTransportAction<RCFResultRequest, RCFResultResponse> {
    private static final Logger LOG = LogManager.getLogger(RCFResultTransportAction.class);
    private ModelManager manager;
    private ADCircuitBreakerService adCircuitBreakerService;
    private HashRing hashRing;
    private ADStats adStats;

    @Inject
    public RCFResultTransportAction(ActionFilters actionFilters, TransportService transportService, ModelManager manager, ADCircuitBreakerService adCircuitBreakerService, HashRing hashRing, ADStats adStats) {
        super(RCFResultAction.NAME, transportService, actionFilters, RCFResultRequest::new);
        this.manager = manager;
        this.adCircuitBreakerService = adCircuitBreakerService;
        this.hashRing = hashRing;
        this.adStats = adStats;
    }

    protected void doExecute(Task task, RCFResultRequest request, ActionListener<RCFResultResponse> listener) {
        if (this.adCircuitBreakerService.isOpen().booleanValue()) {
            listener.onFailure((Exception)new LimitExceededException(request.getAdID(), "AD memory circuit is broken."));
            return;
        }
        Optional<DiscoveryNode> remoteNode = this.hashRing.getNodeByAddress(request.remoteAddress());
        if (!remoteNode.isPresent()) {
            listener.onFailure((Exception)new ConnectException("Can't find remote node by address"));
            return;
        }
        String remoteNodeId = remoteNode.get().getId();
        Version remoteAdVersion = this.hashRing.getAdVersion(remoteNodeId);
        try {
            LOG.info("Serve rcf request for {}", (Object)request.getModelID());
            this.manager.getTRcfResult(request.getAdID(), request.getModelID(), request.getFeatures(), (ActionListener<ThresholdingResult>)ActionListener.wrap(result -> listener.onResponse((Object)new RCFResultResponse(result.getRcfScore(), result.getConfidence(), result.getForestSize(), result.getRelevantAttribution(), result.getTotalUpdates(), result.getGrade(), remoteAdVersion, result.getRelativeIndex(), result.getPastValues(), result.getExpectedValuesList(), result.getLikelihoodOfValues(), result.getThreshold())), exception -> {
                if (exception instanceof IllegalArgumentException) {
                    LOG.error((Message)new ParameterizedMessage("Likely model corruption for [{}]", (Object)request.getAdID()), (Throwable)exception);
                    this.adStats.getStat(StatNames.MODEL_CORRUTPION_COUNT.getName()).increment();
                    this.manager.clear(request.getAdID(), (ActionListener<Void>)ActionListener.wrap(r -> LOG.info("Deleted model for [{}] with response [{}] ", (Object)request.getAdID(), r), ex -> LOG.error("Fail to delete model for " + request.getAdID(), (Throwable)ex)));
                    listener.onFailure(exception);
                } else {
                    LOG.warn(exception);
                    listener.onFailure(exception);
                }
            }));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            listener.onFailure(e);
        }
    }
}

