/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.transport.action.getpolicy;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.search.TotalHits;
import org.jetbrains.annotations.NotNull;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.ActionListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.commons.authuser.User;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.Operator;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.indexmanagement.common.model.rest.SearchParams;
import org.opensearch.indexmanagement.indexstatemanagement.model.Policy;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.getpolicy.GetPoliciesRequest;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.getpolicy.GetPoliciesResponse;
import org.opensearch.indexmanagement.indexstatemanagement.transport.action.getpolicy.TransportGetPoliciesActionKt;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.settings.IndexManagementSettings;
import org.opensearch.indexmanagement.util.SecurityUtils;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B7\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00022\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#H\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/getpolicy/TransportGetPoliciesAction;", "Lorg/opensearch/action/support/HandledTransportAction;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/getpolicy/GetPoliciesRequest;", "Lorg/opensearch/indexmanagement/indexstatemanagement/transport/action/getpolicy/GetPoliciesResponse;", "transportService", "Lorg/opensearch/transport/TransportService;", "client", "Lorg/opensearch/client/Client;", "actionFilters", "Lorg/opensearch/action/support/ActionFilters;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "settings", "Lorg/opensearch/common/settings/Settings;", "xContentRegistry", "Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "(Lorg/opensearch/transport/TransportService;Lorg/opensearch/client/Client;Lorg/opensearch/action/support/ActionFilters;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/common/settings/Settings;Lorg/opensearch/common/xcontent/NamedXContentRegistry;)V", "getClient", "()Lorg/opensearch/client/Client;", "getClusterService", "()Lorg/opensearch/cluster/service/ClusterService;", "filterByEnabled", "", "kotlin.jvm.PlatformType", "Ljava/lang/Boolean;", "getSettings", "()Lorg/opensearch/common/settings/Settings;", "getXContentRegistry", "()Lorg/opensearch/common/xcontent/NamedXContentRegistry;", "doExecute", "", "task", "Lorg/opensearch/tasks/Task;", "getPoliciesRequest", "actionListener", "Lorg/opensearch/action/ActionListener;", "opensearch-index-management"})
public final class TransportGetPoliciesAction
extends HandledTransportAction<GetPoliciesRequest, GetPoliciesResponse> {
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final Settings settings;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    private volatile Boolean filterByEnabled;

    @Inject
    public TransportGetPoliciesAction(@NotNull TransportService transportService, @NotNull Client client, @NotNull ActionFilters actionFilters, @NotNull ClusterService clusterService, @NotNull Settings settings, @NotNull NamedXContentRegistry xContentRegistry) {
        Intrinsics.checkNotNullParameter((Object)transportService, (String)"transportService");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)actionFilters, (String)"actionFilters");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        super("cluster:admin/opendistro/ism/policy/search", transportService, actionFilters, GetPoliciesRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES().get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.Companion.getFILTER_BY_BACKEND_ROLES(), arg_0 -> TransportGetPoliciesAction._init_$lambda-0(this, arg_0));
    }

    @NotNull
    public final Client getClient() {
        return this.client;
    }

    @NotNull
    public final ClusterService getClusterService() {
        return this.clusterService;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settings;
    }

    @NotNull
    public final NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Task task, @NotNull GetPoliciesRequest getPoliciesRequest, @NotNull ActionListener<GetPoliciesResponse> actionListener) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)((Object)getPoliciesRequest), (String)"getPoliciesRequest");
        Intrinsics.checkNotNullParameter(actionListener, (String)"actionListener");
        TransportGetPoliciesActionKt.access$getLog$p().debug("User and roles string from thread context: " + this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        SearchParams params = getPoliciesRequest.getSearchParams();
        ThreadContext threadContext = this.client.threadPool().getThreadContext();
        Intrinsics.checkNotNullExpressionValue((Object)threadContext, (String)"client.threadPool().threadContext");
        User user = SecurityUtils.Companion.buildUser$default(SecurityUtils.Companion, threadContext, null, 2, null);
        FieldSortBuilder sortBuilder = params.getSortBuilder();
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"policy"));
        Intrinsics.checkNotNullExpressionValue((Object)queryBuilder, (String)"queryBuilder");
        Boolean bl = this.filterByEnabled;
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"filterByEnabled");
        SecurityUtils.Companion.addUserFilter(user, queryBuilder, bl, "policy.user");
        queryBuilder.must((QueryBuilder)QueryBuilders.queryStringQuery((String)params.getQueryString()).defaultOperator(Operator.AND).field("policy.policy_id.keyword"));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).sort((SortBuilder)sortBuilder).from(params.getFrom()).size(params.getSize()).seqNoAndPrimaryTerm(Boolean.valueOf(true));
        Object object = new String[]{".opendistro-ism-config"};
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(object);
        object = (AutoCloseable)this.client.threadPool().getThreadContext().stashContext();
        Throwable throwable = null;
        try {
            ThreadContext.StoredContext it = (ThreadContext.StoredContext)object;
            boolean bl2 = false;
            this.getClient().search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(this, actionListener){
                final /* synthetic */ TransportGetPoliciesAction this$0;
                final /* synthetic */ ActionListener<GetPoliciesResponse> $actionListener;
                {
                    this.this$0 = $receiver;
                    this.$actionListener = $actionListener;
                }

                public void onResponse(@NotNull SearchResponse response2) {
                    long l;
                    Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                    TotalHits totalHits = response2.getHits().getTotalHits();
                    long totalPolicies = totalHits == null ? 0L : (l = totalHits.value);
                    List<Policy> policies2 = OpenSearchExtensionsKt.parseFromSearchResponse(response2, this.this$0.getXContentRegistry(), (Function4)new Function4<XContentParser, String, Long, Long, Policy>((Object)Policy.Companion){

                        @NotNull
                        public final Policy invoke(@NotNull XContentParser p0, @NotNull String p1, long p2, long p3) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                            return ((Policy.Companion)this.receiver).parse(p0, p1, p2, p3);
                        }
                    });
                    this.$actionListener.onResponse((Object)((Object)new GetPoliciesResponse(policies2, (int)totalPolicies)));
                }

                public void onFailure(@NotNull Exception t) {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    if (t instanceof IndexNotFoundException) {
                        this.$actionListener.onResponse((Object)((Object)new GetPoliciesResponse(CollectionsKt.emptyList(), 0)));
                        return;
                    }
                    Throwable throwable = ExceptionsHelper.unwrapCause((Throwable)t);
                    if (throwable == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                    }
                    this.$actionListener.onFailure((Exception)throwable);
                }
            });
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
    }

    private static final void _init_$lambda-0(TransportGetPoliciesAction this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.filterByEnabled = it;
    }
}

