/* pkcs11-token.c generated by valac 0.56.3, the Vala compiler
 * generated from pkcs11-token.vala, do not modify */

/*
 * Seahorse
 *
 * Copyright (C) 2006 Stefan Walter
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2013 Red Hat, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "seahorse-pkcs11.h"
#include <gck/gck.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "seahorse-common.h"
#include <p11-kit/pkcs11.h>
#include <gcr/gcr-base.h>
#include "libseahorse/seahorse-util.h"
#include <glib/gi18n-lib.h>

enum  {
	SEAHORSE_PKCS11_TOKEN_0_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_UNLOCKABLE_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_LOCKABLE_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_INFO_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_SESSION_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_SLOT_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_LABEL_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_DESCRIPTION_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_URI_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_ICON_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_CATEGORY_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_ACTIONS_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_ACTION_PREFIX_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_MENU_MODEL_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_OBJECT_FLAGS_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_SHOW_IF_EMPTY_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_MECHANISMS_PROPERTY,
	SEAHORSE_PKCS11_TOKEN_NUM_PROPERTIES
};
static GParamSpec* seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GckTokenInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckTokenInfo_free (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _SeahorsePkcs11TokenLockData SeahorsePkcs11TokenLockData;
typedef struct _SeahorsePkcs11TokenUnlockData SeahorsePkcs11TokenUnlockData;
#define _gck_attributes_unref0(var) ((var == NULL) ? NULL : (var = (gck_attributes_unref (var), NULL)))
#define __vala_GckSessionInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckSessionInfo_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define __vala_GckAttribute_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckAttribute_free (var), NULL)))
#define __vala_GckBuilder_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckBuilder_free (var), NULL)))
typedef struct _SeahorsePkcs11TokenLoadData SeahorsePkcs11TokenLoadData;
#define __vala_GckUriData_free0(var) ((var == NULL) ? NULL : (var = (_vala_GckUriData_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SeahorsePkcs11TokenPrivate {
	GckSlot* _slot;
	gchar* _uri;
	GckTokenInfo* _info;
	GArray* _mechanisms;
	GckSession* _session;
	GHashTable* _object_for_handle;
	GHashTable* _objects_for_id;
	GHashTable* _id_for_object;
	GHashTable* _objects_visible;
};

struct _SeahorsePkcs11TokenLockData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorsePkcs11Token* self;
	GTlsInteraction* interaction;
	GCancellable* cancellable;
	gboolean result;
	GckSession* _tmp0_;
	GckSession* _tmp1_;
	gboolean _tmp2_;
	GError* _inner_error0_;
};

struct _SeahorsePkcs11TokenUnlockData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorsePkcs11Token* self;
	GTlsInteraction* interaction;
	GCancellable* cancellable;
	gboolean result;
	GckSession* _tmp0_;
	GckSession* _tmp1_;
	gboolean _tmp2_;
	GckSession* _tmp3_;
	GckSessionOptions options;
	GckSession* _tmp4_;
	GckSlot* _tmp5_;
	GckSession* _tmp6_;
	GckSession* _tmp7_;
	GError* _inner_error0_;
};

struct _SeahorsePkcs11TokenLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	SeahorsePkcs11Token* self;
	GCancellable* cancellable;
	gboolean result;
	GHashTable* checks;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GList* _tmp3_;
	GList* object_collection;
	GList* object_it;
	GObject* object;
	gulong handle;
	GObject* _tmp4_;
	gulong _tmp5_;
	gulong _tmp6_;
	GHashTable* _tmp7_;
	gulong* _tmp8_;
	GObject* _tmp9_;
	GObject* _tmp10_;
	GckSession* _tmp11_;
	GckSessionOptions options;
	GckSession* _tmp12_;
	GckSlot* _tmp13_;
	GckSession* _tmp14_;
	GckSession* _tmp15_;
	GckBuilder* builder;
	GckBuilder* _tmp16_;
	GckBuilder* _tmp17_;
	GckBuilder* _tmp18_;
	GckEnumerator* enumerator;
	GckSession* _tmp19_;
	GckBuilder* _tmp20_;
	GckAttributes* _tmp21_;
	GckEnumerator* _tmp22_;
	GckEnumerator* _tmp23_;
	GckBuilder* _tmp24_;
	GckBuilder* _tmp25_;
	GckBuilder* _tmp26_;
	GckEnumerator* chained;
	GckSession* _tmp27_;
	GckBuilder* _tmp28_;
	GckAttributes* _tmp29_;
	GckEnumerator* _tmp30_;
	GckEnumerator* _tmp31_;
	GckEnumerator* _tmp32_;
	GckEnumerator* _tmp33_;
	gboolean _tmp34_;
	GList* objects;
	GckEnumerator* _tmp35_;
	GList* _tmp36_;
	GList* _tmp37_;
	GHashTable* _tmp38_;
	GList* _tmp39_;
	GList* _tmp40_;
	GList* _tmp41_;
	GList* _tmp42_;
	GList* _vala1_object_collection;
	GList* _vala1_object_it;
	GckObject* _tmp43_;
	GckObject* _vala1_object;
	gulong _vala1_handle;
	GckObject* _tmp44_;
	gulong _tmp45_;
	gulong _tmp46_;
	GHashTable* _tmp47_;
	GError* _inner_error0_;
};

static gint SeahorsePkcs11Token_private_offset;
static gpointer seahorse_pkcs11_token_parent_class = NULL;
static GcrCollectionIface * seahorse_pkcs11_token_gcr_collection_parent_iface = NULL;
static SeahorsePlaceIface * seahorse_pkcs11_token_seahorse_place_parent_iface = NULL;
static SeahorseLockableIface * seahorse_pkcs11_token_seahorse_lockable_parent_iface = NULL;

static void _vala_GckTokenInfo_free (GckTokenInfo* self);
static void seahorse_pkcs11_token_real_dispose (GObject* base);
static void seahorse_pkcs11_token_real_lock_data_free (gpointer _data);
static void seahorse_pkcs11_token_real_lock (SeahorseLockable* base,
                                      GTlsInteraction* interaction,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean seahorse_pkcs11_token_real_lock_co (SeahorsePkcs11TokenLockData* _data_);
static gboolean seahorse_pkcs11_token_is_session_logged_in (GckSession* session);
static void seahorse_pkcs11_token_lock_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void seahorse_pkcs11_token_real_unlock_data_free (gpointer _data);
static void seahorse_pkcs11_token_real_unlock (SeahorseLockable* base,
                                        GTlsInteraction* interaction,
                                        GCancellable* cancellable,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static gboolean seahorse_pkcs11_token_real_unlock_co (SeahorsePkcs11TokenUnlockData* _data_);
static void seahorse_pkcs11_token_unlock_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static GckSessionOptions seahorse_pkcs11_token_calculate_session_options (SeahorsePkcs11Token* self);
static gboolean seahorse_pkcs11_token_real_contains (GcrCollection* base,
                                              GObject* object);
static guint seahorse_pkcs11_token_real_get_length (GcrCollection* base);
static GList* seahorse_pkcs11_token_real_get_objects (GcrCollection* base);
static GckTokenInfo* seahorse_pkcs11_token_ensure_token_info (SeahorsePkcs11Token* self);
static void seahorse_pkcs11_token_remove_objects (SeahorsePkcs11Token* self,
                                           GList* objects);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _vala_GckSessionInfo_free (GckSessionInfo* self);
static void seahorse_pkcs11_token_update_token_info (SeahorsePkcs11Token* self);
static GckTokenInfo* _vala_GckTokenInfo_copy (GckTokenInfo* self);
static void seahorse_pkcs11_token_update_id_map (SeahorsePkcs11Token* self,
                                          GObject* object,
                                          GckAttribute* id);
static GckAttribute* _vala_GckAttribute_copy (GckAttribute* self);
static void _vala_GckAttribute_free (GckAttribute* self);
static GObject* seahorse_pkcs11_token_lookup_id_map (SeahorsePkcs11Token* self,
                                              GType object_type,
                                              GckAttribute* id);
static void seahorse_pkcs11_token_update_visibility (SeahorsePkcs11Token* self,
                                              GList* objects,
                                              gboolean visible);
static gboolean seahorse_pkcs11_token_make_certificate_key_pair (SeahorsePkcs11Certificate* certificate,
                                                          SeahorsePkcs11PrivateKey* private_key);
static GObject* seahorse_pkcs11_token_break_certificate_key_pair (GObject* object);
static void seahorse_pkcs11_token_receive_objects (SeahorsePkcs11Token* self,
                                            GList* objects);
static gulong* _ulong_dup (gulong* self);
static void seahorse_pkcs11_token_real_load_data_free (gpointer _data);
static void seahorse_pkcs11_token_real_load (SeahorsePlace* base,
                                      GCancellable* cancellable,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean seahorse_pkcs11_token_real_load_co (SeahorsePkcs11TokenLoadData* _data_);
static void _g_free0_ (gpointer var);
static void seahorse_pkcs11_token_load_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_);
static void _vala_GckBuilder_free (GckBuilder* self);
static GObject * seahorse_pkcs11_token_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static guint _gck_attribute_hash_ghash_func (gconstpointer key);
static gboolean _gck_attribute_equal_gequal_func (gconstpointer a,
                                           gconstpointer b);
static void __vala_GckAttribute_free0_ (gpointer var);
static void _g_ptr_array_unref0_ (gpointer var);
static void _vala_GckUriData_free (GckUriData* self);
static void seahorse_pkcs11_token_finalize (GObject * obj);
static GType seahorse_pkcs11_token_get_type_once (void);
static void _vala_seahorse_pkcs11_token_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_seahorse_pkcs11_token_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
seahorse_pkcs11_token_get_instance_private (SeahorsePkcs11Token* self)
{
	return G_STRUCT_MEMBER_P (self, SeahorsePkcs11Token_private_offset);
}

static void
_vala_GckTokenInfo_free (GckTokenInfo* self)
{
	g_boxed_free (gck_token_info_get_type (), self);
}

SeahorsePkcs11Token*
seahorse_pkcs11_token_construct (GType object_type,
                                 GckSlot* slot)
{
	SeahorsePkcs11Token * self = NULL;
	g_return_val_if_fail (slot != NULL, NULL);
	self = (SeahorsePkcs11Token*) g_object_new (object_type, "slot", slot, NULL);
	return self;
}

SeahorsePkcs11Token*
seahorse_pkcs11_token_new (GckSlot* slot)
{
	return seahorse_pkcs11_token_construct (SEAHORSE_PKCS11_TYPE_TOKEN, slot);
}

static void
seahorse_pkcs11_token_real_dispose (GObject* base)
{
	SeahorsePkcs11Token * self;
	self = (SeahorsePkcs11Token*) base;
	_g_object_unref0 (self->priv->_slot);
	self->priv->_slot = NULL;
	_g_object_unref0 (self->priv->_session);
	self->priv->_session = NULL;
}

static void
seahorse_pkcs11_token_real_lock_data_free (gpointer _data)
{
	SeahorsePkcs11TokenLockData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->interaction);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorsePkcs11TokenLockData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
seahorse_pkcs11_token_real_lock (SeahorseLockable* base,
                                 GTlsInteraction* interaction,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SeahorsePkcs11Token * self;
	SeahorsePkcs11TokenLockData* _data_;
	SeahorsePkcs11Token* _tmp0_;
	GTlsInteraction* _tmp1_;
	GCancellable* _tmp2_;
	self = (SeahorsePkcs11Token*) base;
	_data_ = g_slice_new0 (SeahorsePkcs11TokenLockData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_pkcs11_token_real_lock_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (interaction);
	_g_object_unref0 (_data_->interaction);
	_data_->interaction = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	seahorse_pkcs11_token_real_lock_co (_data_);
}

static gboolean
seahorse_pkcs11_token_lock_finish (SeahorseLockable* base,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	gboolean result;
	SeahorsePkcs11TokenLockData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
seahorse_pkcs11_token_lock_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	SeahorsePkcs11TokenLockData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_pkcs11_token_real_lock_co (_data_);
}

static gboolean
seahorse_pkcs11_token_real_lock_co (SeahorsePkcs11TokenLockData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_session;
	if (!seahorse_pkcs11_token_is_session_logged_in (_data_->_tmp0_)) {
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->_session;
	_data_->_state_ = 1;
	gck_session_logout_async (_data_->_tmp1_, _data_->cancellable, seahorse_pkcs11_token_lock_ready, _data_);
	return FALSE;
	_state_1:
	gck_session_logout_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_state_ = 2;
	seahorse_place_load ((SeahorsePlace*) _data_->self, _data_->cancellable, seahorse_pkcs11_token_lock_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp2_ = seahorse_place_load_finish ((SeahorsePlace*) _data_->self, _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_tmp2_;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
seahorse_pkcs11_token_real_unlock_data_free (gpointer _data)
{
	SeahorsePkcs11TokenUnlockData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->interaction);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorsePkcs11TokenUnlockData, _data_);
}

static void
seahorse_pkcs11_token_real_unlock (SeahorseLockable* base,
                                   GTlsInteraction* interaction,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	SeahorsePkcs11Token * self;
	SeahorsePkcs11TokenUnlockData* _data_;
	SeahorsePkcs11Token* _tmp0_;
	GTlsInteraction* _tmp1_;
	GCancellable* _tmp2_;
	self = (SeahorsePkcs11Token*) base;
	_data_ = g_slice_new0 (SeahorsePkcs11TokenUnlockData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_pkcs11_token_real_unlock_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (interaction);
	_g_object_unref0 (_data_->interaction);
	_data_->interaction = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	seahorse_pkcs11_token_real_unlock_co (_data_);
}

static gboolean
seahorse_pkcs11_token_unlock_finish (SeahorseLockable* base,
                                     GAsyncResult* _res_,
                                     GError** error)
{
	gboolean result;
	SeahorsePkcs11TokenUnlockData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
seahorse_pkcs11_token_unlock_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	SeahorsePkcs11TokenUnlockData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_pkcs11_token_real_unlock_co (_data_);
}

static gboolean
seahorse_pkcs11_token_real_unlock_co (SeahorsePkcs11TokenUnlockData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_session;
	if (seahorse_pkcs11_token_is_session_logged_in (_data_->_tmp0_)) {
		_data_->result = TRUE;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp1_ = _data_->self->priv->_session;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp3_ = _data_->self->priv->_session;
		_data_->_state_ = 1;
		gck_session_login_interactive_async (_data_->_tmp3_, CKU_USER, _data_->interaction, _data_->cancellable, seahorse_pkcs11_token_unlock_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = gck_session_login_interactive_finish (_data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->result = _data_->_tmp2_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->options = seahorse_pkcs11_token_calculate_session_options (_data_->self);
		_data_->_tmp5_ = _data_->self->priv->_slot;
		_data_->_state_ = 2;
		gck_slot_open_session_async (_data_->_tmp5_, _data_->options | GCK_SESSION_LOGIN_USER, _data_->cancellable, seahorse_pkcs11_token_unlock_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp6_ = gck_slot_open_session_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp4_ = _data_->_tmp6_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp7_ = _data_->_tmp4_;
		_data_->_tmp4_ = NULL;
		_g_object_unref0 (_data_->self->priv->_session);
		_data_->self->priv->_session = _data_->_tmp7_;
		_data_->result = TRUE;
		_g_object_unref0 (_data_->_tmp4_);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static gboolean
seahorse_pkcs11_token_real_contains (GcrCollection* base,
                                     GObject* object)
{
	SeahorsePkcs11Token * self;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	gboolean result;
	self = (SeahorsePkcs11Token*) base;
	g_return_val_if_fail (object != NULL, FALSE);
	_tmp0_ = self->priv->_objects_visible;
	_tmp1_ = g_hash_table_lookup (_tmp0_, object);
	result = ((GObject*) _tmp1_) != NULL;
	return result;
}

static guint
seahorse_pkcs11_token_real_get_length (GcrCollection* base)
{
	SeahorsePkcs11Token * self;
	GHashTable* _tmp0_;
	guint result;
	self = (SeahorsePkcs11Token*) base;
	_tmp0_ = self->priv->_objects_visible;
	result = g_hash_table_size (_tmp0_);
	return result;
}

static GList*
seahorse_pkcs11_token_real_get_objects (GcrCollection* base)
{
	SeahorsePkcs11Token * self;
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GList* result;
	self = (SeahorsePkcs11Token*) base;
	_tmp0_ = self->priv->_objects_visible;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
seahorse_pkcs11_token_is_deletable (SeahorsePkcs11Token* self,
                                    GckObject* object)
{
	GckTokenInfo* _tmp0_;
	GckAttributes* attributes = NULL;
	GckAttributes* _tmp1_ = NULL;
	GckAttributes* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (object != NULL, FALSE);
	seahorse_pkcs11_token_ensure_token_info (self);
	_tmp0_ = self->priv->_info;
	if ((_tmp0_->flags & CKF_WRITE_PROTECTED) == CKF_WRITE_PROTECTED) {
		result = FALSE;
		return result;
	}
	g_object_get ((GObject*) object, "attributes", &_tmp1_, NULL);
	_gck_attributes_unref0 (attributes);
	attributes = _tmp1_;
	_tmp2_ = attributes;
	if (_tmp2_ != NULL) {
		gboolean ret = FALSE;
		GckAttributes* _tmp3_;
		gboolean _tmp4_ = FALSE;
		ret = TRUE;
		_tmp3_ = attributes;
		gck_attributes_find_boolean (_tmp3_, CKA_MODIFIABLE, &_tmp4_);
		ret = _tmp4_;
		result = ret;
		_gck_attributes_unref0 (attributes);
		return result;
	}
	result = FALSE;
	_gck_attributes_unref0 (attributes);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
seahorse_pkcs11_token_remove_object (SeahorsePkcs11Token* self,
                                     GckObject* object)
{
	GList* objects = NULL;
	GckObject* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	objects = NULL;
	_tmp0_ = _g_object_ref0 (object);
	objects = g_list_append (objects, _tmp0_);
	_tmp1_ = g_list_copy (objects);
	_tmp2_ = _tmp1_;
	seahorse_pkcs11_token_remove_objects (self, _tmp2_);
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	(objects == NULL) ? NULL : (objects = (_g_list_free__g_object_unref0_ (objects), NULL));
}

gboolean
seahorse_pkcs11_token_has_mechanism (SeahorsePkcs11Token* self,
                                     gulong mechanism)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = seahorse_pkcs11_token_get_mechanisms (self);
	_tmp1_ = _tmp0_;
	result = gck_mechanisms_check (_tmp1_, mechanism, GCK_INVALID, NULL);
	return result;
}

static void
_vala_GckSessionInfo_free (GckSessionInfo* self)
{
	g_boxed_free (gck_session_info_get_type (), self);
}

static gboolean
seahorse_pkcs11_token_is_session_logged_in (GckSession* session)
{
	GckSessionInfo* info = NULL;
	GckSessionInfo* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GckSessionInfo* _tmp2_;
	gboolean result;
	if (session == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = gck_session_get_info (session);
	info = _tmp0_;
	_tmp2_ = info;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		GckSessionInfo* _tmp5_;
		_tmp5_ = info;
		if (_tmp5_->state == CKS_RW_USER_FUNCTIONS) {
			_tmp4_ = TRUE;
		} else {
			GckSessionInfo* _tmp6_;
			_tmp6_ = info;
			_tmp4_ = _tmp6_->state == CKS_RO_USER_FUNCTIONS;
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			GckSessionInfo* _tmp7_;
			_tmp7_ = info;
			_tmp3_ = _tmp7_->state == CKS_RW_SO_FUNCTIONS;
		}
		_tmp1_ = _tmp3_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	__vala_GckSessionInfo_free0 (info);
	return result;
}

static GckTokenInfo*
seahorse_pkcs11_token_ensure_token_info (SeahorsePkcs11Token* self)
{
	GckTokenInfo* _tmp0_;
	GckTokenInfo* _tmp1_;
	GckTokenInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_info;
	if (_tmp0_ == NULL) {
		seahorse_pkcs11_token_update_token_info (self);
	}
	_tmp1_ = self->priv->_info;
	result = _tmp1_;
	return result;
}

static GckTokenInfo*
_vala_GckTokenInfo_copy (GckTokenInfo* self)
{
	return g_boxed_copy (gck_token_info_get_type (), self);
}

static gpointer
__vala_GckTokenInfo_copy0 (gpointer self)
{
	return self ? _vala_GckTokenInfo_copy (self) : NULL;
}

static void
seahorse_pkcs11_token_update_token_info (SeahorsePkcs11Token* self)
{
	GckTokenInfo* info = NULL;
	GckSlot* _tmp0_;
	GckTokenInfo* _tmp1_;
	GckTokenInfo* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_slot;
	_tmp1_ = gck_slot_get_token_info (_tmp0_);
	info = _tmp1_;
	_tmp2_ = info;
	if (_tmp2_ != NULL) {
		GckTokenInfo* _tmp3_;
		GckTokenInfo* _tmp4_;
		_tmp3_ = info;
		_tmp4_ = __vala_GckTokenInfo_copy0 (_tmp3_);
		__vala_GckTokenInfo_free0 (self->priv->_info);
		self->priv->_info = _tmp4_;
		g_object_notify ((GObject*) self, "info");
		g_object_notify ((GObject*) self, "lockable");
		g_object_notify ((GObject*) self, "unlockable");
	}
	__vala_GckTokenInfo_free0 (info);
}

static GckAttribute*
_vala_GckAttribute_copy (GckAttribute* self)
{
	return g_boxed_copy (gck_attribute_get_type (), self);
}

static gpointer
__vala_GckAttribute_copy0 (gpointer self)
{
	return self ? _vala_GckAttribute_copy (self) : NULL;
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static void
_vala_GckAttribute_free (GckAttribute* self)
{
	g_boxed_free (gck_attribute_get_type (), self);
}

static void
seahorse_pkcs11_token_update_id_map (SeahorsePkcs11Token* self,
                                     GObject* object,
                                     GckAttribute* id)
{
	gboolean add = FALSE;
	gboolean remove = FALSE;
	GckAttribute* pid = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GckAttribute* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	add = FALSE;
	remove = FALSE;
	_tmp0_ = self->priv->_id_for_object;
	_tmp1_ = g_hash_table_lookup (_tmp0_, object);
	_tmp2_ = __vala_GckAttribute_copy0 ((GckAttribute*) _tmp1_);
	pid = _tmp2_;
	if (id == NULL) {
		GckAttribute* _tmp3_;
		_tmp3_ = pid;
		if (_tmp3_ != NULL) {
			GckAttribute* _tmp4_;
			_tmp4_ = pid;
			id = _tmp4_;
			remove = TRUE;
		}
	} else {
		GckAttribute* _tmp5_;
		_tmp5_ = pid;
		if (_tmp5_ == NULL) {
			add = TRUE;
		} else {
			GckAttribute* _tmp6_;
			_tmp6_ = pid;
			if (!gck_attribute_equal (id, _tmp6_)) {
				remove = TRUE;
				add = TRUE;
			}
		}
	}
	if (add) {
		GPtrArray* objects = NULL;
		GHashTable* _tmp7_;
		gconstpointer _tmp8_;
		GPtrArray* _tmp9_;
		GPtrArray* _tmp16_;
		GObject* _tmp17_;
		GHashTable* _tmp18_;
		GObject* _tmp19_;
		_tmp7_ = self->priv->_objects_for_id;
		_tmp8_ = g_hash_table_lookup (_tmp7_, id);
		objects = (GPtrArray*) _tmp8_;
		_tmp9_ = objects;
		if (_tmp9_ == NULL) {
			GPtrArray* objs = NULL;
			GPtrArray* _tmp10_;
			GHashTable* _tmp11_;
			GckAttribute* _tmp12_;
			GPtrArray* _tmp13_;
			GPtrArray* _tmp14_;
			GPtrArray* _tmp15_;
			_tmp10_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
			objs = _tmp10_;
			_tmp11_ = self->priv->_objects_for_id;
			_tmp12_ = __vala_GckAttribute_copy0 (id);
			_tmp13_ = objs;
			_tmp14_ = _g_ptr_array_ref0 (_tmp13_);
			g_hash_table_insert (_tmp11_, _tmp12_, _tmp14_);
			_tmp15_ = objs;
			objects = _tmp15_;
			_g_ptr_array_unref0 (objs);
		}
		_tmp16_ = objects;
		_tmp17_ = _g_object_ref0 (object);
		g_ptr_array_add (_tmp16_, _tmp17_);
		_tmp18_ = self->priv->_id_for_object;
		_tmp19_ = _g_object_ref0 (object);
		g_hash_table_insert (_tmp18_, _tmp19_, id);
	}
	if (remove) {
		GHashTable* _tmp20_;
		GPtrArray* objects = NULL;
		GHashTable* _tmp21_;
		gconstpointer _tmp22_;
		GPtrArray* _tmp23_;
		GPtrArray* _tmp24_;
		GPtrArray* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		GPtrArray* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp20_ = self->priv->_id_for_object;
		if (!g_hash_table_remove (_tmp20_, object)) {
			g_assert_not_reached ();
		}
		_tmp21_ = self->priv->_objects_for_id;
		_tmp22_ = g_hash_table_lookup (_tmp21_, id);
		_tmp23_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp22_);
		objects = _tmp23_;
		_tmp24_ = objects;
		_vala_assert (_tmp24_ != NULL, "objects != null");
		_tmp25_ = objects;
		_tmp26_ = vala_g_ptr_array_get_length (_tmp25_);
		_tmp27_ = _tmp26_;
		_vala_assert (_tmp27_ > 0, "objects.length > 0");
		_tmp28_ = objects;
		_tmp29_ = vala_g_ptr_array_get_length (_tmp28_);
		_tmp30_ = _tmp29_;
		if (_tmp30_ == 1) {
			GHashTable* _tmp31_;
			_tmp31_ = self->priv->_objects_for_id;
			if (!g_hash_table_remove (_tmp31_, id)) {
				g_assert_not_reached ();
			}
		} else {
			GPtrArray* _tmp32_;
			_tmp32_ = objects;
			if (!g_ptr_array_remove (_tmp32_, object)) {
				g_assert_not_reached ();
			}
		}
		_g_ptr_array_unref0 (objects);
	}
	__vala_GckAttribute_free0 (pid);
}

static GObject*
seahorse_pkcs11_token_lookup_id_map (SeahorsePkcs11Token* self,
                                     GType object_type,
                                     GckAttribute* id)
{
	GPtrArray* objects = NULL;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GPtrArray* _tmp2_;
	GPtrArray* _tmp3_;
	GObject* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (id == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = self->priv->_objects_for_id;
	_tmp1_ = g_hash_table_lookup (_tmp0_, id);
	_tmp2_ = _g_ptr_array_ref0 ((GPtrArray*) _tmp1_);
	objects = _tmp2_;
	_tmp3_ = objects;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_ptr_array_unref0 (objects);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				GPtrArray* _tmp9_;
				gconstpointer _tmp10_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = objects;
				_tmp7_ = vala_g_ptr_array_get_length (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(i < _tmp8_)) {
					break;
				}
				_tmp9_ = objects;
				_tmp10_ = g_ptr_array_index (_tmp9_, (guint) i);
				if (g_type_is_a (G_TYPE_FROM_INSTANCE ((GObject*) _tmp10_), object_type)) {
					GPtrArray* _tmp11_;
					gconstpointer _tmp12_;
					GObject* _tmp13_;
					_tmp11_ = objects;
					_tmp12_ = g_ptr_array_index (_tmp11_, (guint) i);
					_tmp13_ = _g_object_ref0 ((GObject*) _tmp12_);
					result = _tmp13_;
					_g_ptr_array_unref0 (objects);
					return result;
				}
			}
		}
	}
	result = NULL;
	_g_ptr_array_unref0 (objects);
	return result;
}

static void
seahorse_pkcs11_token_update_visibility (SeahorsePkcs11Token* self,
                                         GList* objects,
                                         gboolean visible)
{
	g_return_if_fail (self != NULL);
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = objects;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp0_;
			GObject* object = NULL;
			_tmp0_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp0_;
			{
				gboolean have = FALSE;
				GHashTable* _tmp1_;
				GObject* _tmp2_;
				gconstpointer _tmp3_;
				gboolean _tmp4_ = FALSE;
				_tmp1_ = self->priv->_objects_visible;
				_tmp2_ = object;
				_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
				have = ((GObject*) _tmp3_) != NULL;
				if (!have) {
					_tmp4_ = visible;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					GHashTable* _tmp5_;
					GObject* _tmp6_;
					GObject* _tmp7_;
					GObject* _tmp8_;
					GObject* _tmp9_;
					GObject* _tmp10_;
					_tmp5_ = self->priv->_objects_visible;
					_tmp6_ = object;
					_tmp7_ = _g_object_ref0 (_tmp6_);
					_tmp8_ = object;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					g_hash_table_insert (_tmp5_, _tmp7_, _tmp9_);
					_tmp10_ = object;
					gcr_collection_emit_added ((GcrCollection*) self, _tmp10_);
				} else {
					gboolean _tmp11_ = FALSE;
					if (have) {
						_tmp11_ = !visible;
					} else {
						_tmp11_ = FALSE;
					}
					if (_tmp11_) {
						GHashTable* _tmp12_;
						GObject* _tmp13_;
						GObject* _tmp14_;
						_tmp12_ = self->priv->_objects_visible;
						_tmp13_ = object;
						if (!g_hash_table_remove (_tmp12_, _tmp13_)) {
							g_assert_not_reached ();
						}
						_tmp14_ = object;
						gcr_collection_emit_removed ((GcrCollection*) self, _tmp14_);
					}
				}
				_g_object_unref0 (object);
			}
		}
	}
}

static gboolean
seahorse_pkcs11_token_make_certificate_key_pair (SeahorsePkcs11Certificate* certificate,
                                                 SeahorsePkcs11PrivateKey* private_key)
{
	gboolean _tmp0_ = FALSE;
	SeahorsePkcs11PrivateKey* _tmp1_;
	SeahorsePkcs11PrivateKey* _tmp2_;
	SeahorsePkcs11PrivateKey* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (certificate != NULL, FALSE);
	g_return_val_if_fail (private_key != NULL, FALSE);
	_tmp1_ = seahorse_pkcs11_certificate_get_partner (certificate);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ != NULL;
	_g_object_unref0 (_tmp3_);
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		SeahorsePkcs11Certificate* _tmp5_;
		SeahorsePkcs11Certificate* _tmp6_;
		SeahorsePkcs11Certificate* _tmp7_;
		_tmp5_ = seahorse_pkcs11_private_key_get_partner (private_key);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp0_ = _tmp7_ != NULL;
		_g_object_unref0 (_tmp7_);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	seahorse_pkcs11_certificate_set_partner (certificate, private_key);
	seahorse_pkcs11_private_key_set_partner (private_key, certificate);
	result = TRUE;
	return result;
}

static GObject*
seahorse_pkcs11_token_break_certificate_key_pair (GObject* object)
{
	GObject* pair = NULL;
	GObject* result;
	g_return_val_if_fail (object != NULL, NULL);
	pair = NULL;
	if (SEAHORSE_PKCS11_IS_CERTIFICATE (object)) {
		SeahorsePkcs11Certificate* certificate = NULL;
		SeahorsePkcs11Certificate* _tmp0_;
		SeahorsePkcs11Certificate* _tmp1_;
		SeahorsePkcs11PrivateKey* _tmp2_;
		SeahorsePkcs11PrivateKey* _tmp3_;
		SeahorsePkcs11Certificate* _tmp4_;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate));
		certificate = _tmp0_;
		_tmp1_ = certificate;
		_tmp2_ = seahorse_pkcs11_certificate_get_partner (_tmp1_);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (pair);
		pair = (GObject*) _tmp3_;
		_tmp4_ = certificate;
		seahorse_pkcs11_certificate_set_partner (_tmp4_, NULL);
		_g_object_unref0 (certificate);
	} else {
		if (SEAHORSE_PKCS11_IS_PRIVATE_KEY (object)) {
			SeahorsePkcs11PrivateKey* private_key = NULL;
			SeahorsePkcs11PrivateKey* _tmp5_;
			SeahorsePkcs11PrivateKey* _tmp6_;
			SeahorsePkcs11Certificate* _tmp7_;
			SeahorsePkcs11Certificate* _tmp8_;
			SeahorsePkcs11PrivateKey* _tmp9_;
			_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, SeahorsePkcs11PrivateKey));
			private_key = _tmp5_;
			_tmp6_ = private_key;
			_tmp7_ = seahorse_pkcs11_private_key_get_partner (_tmp6_);
			_tmp8_ = _tmp7_;
			_g_object_unref0 (pair);
			pair = (GObject*) _tmp8_;
			_tmp9_ = private_key;
			seahorse_pkcs11_private_key_set_partner (_tmp9_, NULL);
			_g_object_unref0 (private_key);
		}
	}
	result = pair;
	return result;
}

static gulong*
_ulong_dup (gulong* self)
{
	gulong* dup;
	dup = g_new0 (gulong, 1);
	memcpy (dup, self, sizeof (gulong));
	return dup;
}

static gpointer
__ulong_dup0 (gpointer self)
{
	return self ? _ulong_dup (self) : NULL;
}

static void
seahorse_pkcs11_token_receive_objects (SeahorsePkcs11Token* self,
                                       GList* objects)
{
	GList* show = NULL;
	GList* hide = NULL;
	GList* _tmp54_;
	GList* _tmp55_;
	g_return_if_fail (self != NULL);
	show = NULL;
	hide = NULL;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = objects;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* _tmp0_;
			GObject* object = NULL;
			_tmp0_ = _g_object_ref0 ((GObject*) object_it->data);
			object = _tmp0_;
			{
				gboolean _tmp1_ = FALSE;
				GObject* _tmp2_;
				gulong handle = 0UL;
				GObject* _tmp4_;
				gulong _tmp5_;
				gulong _tmp6_;
				GckAttributes* attrs = NULL;
				GObject* _tmp7_;
				GckAttributes* _tmp8_;
				GckAttributes* _tmp9_;
				GObject* prev = NULL;
				GHashTable* _tmp10_;
				gconstpointer _tmp11_;
				GObject* _tmp12_;
				GObject* _tmp13_;
				GckAttribute* id = NULL;
				GckAttributes* _tmp25_;
				GObject* _tmp28_;
				GckAttribute* _tmp29_;
				GObject* _tmp30_;
				_tmp2_ = object;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gck_object_get_type ())) {
					GObject* _tmp3_;
					_tmp3_ = object;
					_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gck_object_cache_get_type ());
				} else {
					_tmp1_ = FALSE;
				}
				if (!_tmp1_) {
					_g_object_unref0 (object);
					continue;
				}
				_tmp4_ = object;
				_tmp5_ = gck_object_get_handle (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gck_object_get_type (), GckObject));
				_tmp6_ = _tmp5_;
				handle = _tmp6_;
				_tmp7_ = object;
				g_object_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gck_object_cache_get_type (), GckObjectCache), "attributes", &_tmp8_, NULL);
				_tmp9_ = _tmp8_;
				attrs = _tmp9_;
				_tmp10_ = self->priv->_object_for_handle;
				_tmp11_ = g_hash_table_lookup (_tmp10_, &handle);
				_tmp12_ = _g_object_ref0 ((GObject*) _tmp11_);
				prev = _tmp12_;
				_tmp13_ = prev;
				if (_tmp13_ == NULL) {
					GHashTable* _tmp14_;
					gulong* _tmp15_;
					GObject* _tmp16_;
					GObject* _tmp17_;
					GObject* _tmp18_;
					_tmp14_ = self->priv->_object_for_handle;
					_tmp15_ = __ulong_dup0 (&handle);
					_tmp16_ = object;
					_tmp17_ = _g_object_ref0 (_tmp16_);
					g_hash_table_insert (_tmp14_, _tmp15_, _tmp17_);
					_tmp18_ = object;
					g_object_set (_tmp18_, "place", self, NULL);
				} else {
					GObject* _tmp19_;
					GObject* _tmp20_;
					_tmp19_ = prev;
					_tmp20_ = object;
					if (_tmp19_ != _tmp20_) {
						GObject* _tmp21_;
						GckAttributes* _tmp22_;
						GObject* _tmp23_;
						GObject* _tmp24_;
						_tmp21_ = object;
						_tmp22_ = attrs;
						g_object_set (_tmp21_, "attributes", _tmp22_, NULL);
						_tmp23_ = prev;
						_tmp24_ = _g_object_ref0 (_tmp23_);
						_g_object_unref0 (object);
						object = _tmp24_;
					}
				}
				id = NULL;
				_tmp25_ = attrs;
				if (_tmp25_ != NULL) {
					GckAttributes* _tmp26_;
					GckAttribute* _tmp27_;
					_tmp26_ = attrs;
					_tmp27_ = gck_attributes_find (_tmp26_, CKA_ID);
					id = _tmp27_;
				}
				_tmp28_ = object;
				_tmp29_ = id;
				seahorse_pkcs11_token_update_id_map (self, _tmp28_, _tmp29_);
				_tmp30_ = object;
				if (SEAHORSE_PKCS11_IS_CERTIFICATE (_tmp30_)) {
					GObject* pair = NULL;
					GckAttribute* _tmp31_;
					GObject* _tmp32_;
					gboolean _tmp33_ = FALSE;
					GObject* _tmp34_;
					GObject* _tmp39_;
					GObject* _tmp40_;
					_tmp31_ = id;
					_tmp32_ = seahorse_pkcs11_token_lookup_id_map (self, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, _tmp31_);
					pair = _tmp32_;
					_tmp34_ = pair;
					if (_tmp34_ != NULL) {
						GObject* _tmp35_;
						GObject* _tmp36_;
						_tmp35_ = object;
						_tmp36_ = pair;
						_tmp33_ = seahorse_pkcs11_token_make_certificate_key_pair (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate), G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, SeahorsePkcs11PrivateKey));
					} else {
						_tmp33_ = FALSE;
					}
					if (_tmp33_) {
						GObject* _tmp37_;
						GObject* _tmp38_;
						_tmp37_ = pair;
						_tmp38_ = _g_object_ref0 (_tmp37_);
						hide = g_list_prepend (hide, _tmp38_);
					}
					_tmp39_ = object;
					_tmp40_ = _g_object_ref0 (_tmp39_);
					show = g_list_prepend (show, _tmp40_);
					_g_object_unref0 (pair);
				} else {
					GObject* _tmp41_;
					_tmp41_ = object;
					if (SEAHORSE_PKCS11_IS_PRIVATE_KEY (_tmp41_)) {
						GObject* pair = NULL;
						GckAttribute* _tmp42_;
						GObject* _tmp43_;
						gboolean _tmp44_ = FALSE;
						GObject* _tmp45_;
						_tmp42_ = id;
						_tmp43_ = seahorse_pkcs11_token_lookup_id_map (self, SEAHORSE_PKCS11_TYPE_CERTIFICATE, _tmp42_);
						pair = _tmp43_;
						_tmp45_ = pair;
						if (_tmp45_ != NULL) {
							GObject* _tmp46_;
							GObject* _tmp47_;
							_tmp46_ = pair;
							_tmp47_ = object;
							_tmp44_ = seahorse_pkcs11_token_make_certificate_key_pair (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, SEAHORSE_PKCS11_TYPE_CERTIFICATE, SeahorsePkcs11Certificate), G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, SeahorsePkcs11PrivateKey));
						} else {
							_tmp44_ = FALSE;
						}
						if (_tmp44_) {
							GObject* _tmp48_;
							GObject* _tmp49_;
							_tmp48_ = object;
							_tmp49_ = _g_object_ref0 (_tmp48_);
							hide = g_list_prepend (hide, _tmp49_);
						} else {
							GObject* _tmp50_;
							GObject* _tmp51_;
							_tmp50_ = object;
							_tmp51_ = _g_object_ref0 (_tmp50_);
							show = g_list_prepend (show, _tmp51_);
						}
						_g_object_unref0 (pair);
					} else {
						GObject* _tmp52_;
						GObject* _tmp53_;
						_tmp52_ = object;
						_tmp53_ = _g_object_ref0 (_tmp52_);
						show = g_list_prepend (show, _tmp53_);
					}
				}
				_g_object_unref0 (prev);
				_gck_attributes_unref0 (attrs);
				_g_object_unref0 (object);
			}
		}
	}
	_tmp54_ = hide;
	seahorse_pkcs11_token_update_visibility (self, _tmp54_, FALSE);
	_tmp55_ = show;
	seahorse_pkcs11_token_update_visibility (self, _tmp55_, TRUE);
	(hide == NULL) ? NULL : (hide = (_g_list_free__g_object_unref0_ (hide), NULL));
	(show == NULL) ? NULL : (show = (_g_list_free__g_object_unref0_ (show), NULL));
}

static void
seahorse_pkcs11_token_remove_objects (SeahorsePkcs11Token* self,
                                      GList* objects)
{
	GList* depaired = NULL;
	GList* hide = NULL;
	GList* _tmp13_;
	GList* _tmp14_;
	g_return_if_fail (self != NULL);
	depaired = NULL;
	hide = NULL;
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = objects;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* object = NULL;
			object = (GObject*) object_it->data;
			{
				GObject* pair = NULL;
				GObject* _tmp0_;
				GObject* _tmp1_;
				GObject* _tmp2_;
				GObject* _tmp5_;
				GObject* _tmp6_;
				GObject* _tmp7_;
				_tmp0_ = object;
				_tmp1_ = seahorse_pkcs11_token_break_certificate_key_pair (_tmp0_);
				pair = _tmp1_;
				_tmp2_ = pair;
				if (_tmp2_ != NULL) {
					GObject* _tmp3_;
					GObject* _tmp4_;
					_tmp3_ = pair;
					_tmp4_ = _g_object_ref0 (_tmp3_);
					depaired = g_list_prepend (depaired, _tmp4_);
				}
				_tmp5_ = object;
				seahorse_pkcs11_token_update_id_map (self, _tmp5_, NULL);
				_tmp6_ = object;
				_tmp7_ = _g_object_ref0 (_tmp6_);
				hide = g_list_prepend (hide, _tmp7_);
				_g_object_unref0 (pair);
			}
		}
	}
	{
		GList* object_collection = NULL;
		GList* object_it = NULL;
		object_collection = objects;
		for (object_it = object_collection; object_it != NULL; object_it = object_it->next) {
			GObject* object = NULL;
			object = (GObject*) object_it->data;
			{
				gulong handle = 0UL;
				GObject* _tmp8_;
				gulong _tmp9_;
				gulong _tmp10_;
				GObject* _tmp11_;
				GHashTable* _tmp12_;
				_tmp8_ = object;
				_tmp9_ = gck_object_get_handle (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gck_object_get_type (), GckObject));
				_tmp10_ = _tmp9_;
				handle = _tmp10_;
				_tmp11_ = object;
				g_object_set (_tmp11_, "place", NULL, NULL);
				_tmp12_ = self->priv->_object_for_handle;
				g_hash_table_remove (_tmp12_, &handle);
			}
		}
	}
	_tmp13_ = hide;
	seahorse_pkcs11_token_update_visibility (self, _tmp13_, FALSE);
	_tmp14_ = depaired;
	seahorse_pkcs11_token_receive_objects (self, _tmp14_);
	(hide == NULL) ? NULL : (hide = (_g_list_free__g_object_unref0_ (hide), NULL));
	(depaired == NULL) ? NULL : (depaired = (_g_list_free__g_object_unref0_ (depaired), NULL));
}

static GckSessionOptions
seahorse_pkcs11_token_calculate_session_options (SeahorsePkcs11Token* self)
{
	GckTokenInfo* _tmp0_;
	GckSessionOptions result;
	g_return_val_if_fail (self != NULL, 0U);
	seahorse_pkcs11_token_ensure_token_info (self);
	_tmp0_ = self->priv->_info;
	if ((_tmp0_->flags & CKF_WRITE_PROTECTED) == CKF_WRITE_PROTECTED) {
		result = GCK_SESSION_READ_ONLY;
		return result;
	} else {
		result = GCK_SESSION_READ_WRITE;
		return result;
	}
}

static void
seahorse_pkcs11_token_real_load_data_free (gpointer _data)
{
	SeahorsePkcs11TokenLoadData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (SeahorsePkcs11TokenLoadData, _data_);
}

static void
seahorse_pkcs11_token_real_load (SeahorsePlace* base,
                                 GCancellable* cancellable,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	SeahorsePkcs11Token * self;
	SeahorsePkcs11TokenLoadData* _data_;
	SeahorsePkcs11Token* _tmp0_;
	GCancellable* _tmp1_;
	self = (SeahorsePkcs11Token*) base;
	_data_ = g_slice_new0 (SeahorsePkcs11TokenLoadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, seahorse_pkcs11_token_real_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp1_;
	seahorse_pkcs11_token_real_load_co (_data_);
}

static gboolean
seahorse_pkcs11_token_load_finish (SeahorsePlace* base,
                                   GAsyncResult* _res_,
                                   GError** error)
{
	gboolean result;
	SeahorsePkcs11TokenLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		gboolean _tmp0_ = FALSE;
		return _tmp0_;
	}
	result = _data_->result;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

static void
seahorse_pkcs11_token_load_ready (GObject* source_object,
                                  GAsyncResult* _res_,
                                  gpointer _user_data_)
{
	SeahorsePkcs11TokenLoadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	seahorse_pkcs11_token_real_load_co (_data_);
}

static void
_vala_GckBuilder_free (GckBuilder* self)
{
	g_boxed_free (gck_builder_get_type (), self);
}

static gboolean
seahorse_pkcs11_token_real_load_co (SeahorsePkcs11TokenLoadData* _data_)
{
	static const gulong CERTIFICATE_ATTRS[6] = {CKA_VALUE, CKA_ID, CKA_LABEL, CKA_CLASS, CKA_CERTIFICATE_CATEGORY, CKA_MODIFIABLE};
	static const gulong KEY_ATTRS[6] = {CKA_MODULUS_BITS, CKA_ID, CKA_LABEL, CKA_CLASS, CKA_KEY_TYPE, CKA_MODIFIABLE};
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = seahorse_ulong_hash;
	_data_->_tmp1_ = seahorse_ulong_equal;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, _g_free0_, _g_object_unref0_);
	_data_->checks = _data_->_tmp2_;
	seahorse_pkcs11_token_update_token_info (_data_->self);
	_data_->_tmp3_ = gcr_collection_get_objects ((GcrCollection*) _data_->self);
	{
		_data_->object_collection = _data_->_tmp3_;
		for (_data_->object_it = _data_->object_collection; _data_->object_it != NULL; _data_->object_it = _data_->object_it->next) {
			_data_->object = (GObject*) _data_->object_it->data;
			{
				_data_->_tmp4_ = _data_->object;
				_data_->_tmp5_ = gck_object_get_handle (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp4_, gck_object_get_type (), GckObject));
				_data_->_tmp6_ = _data_->_tmp5_;
				_data_->handle = _data_->_tmp6_;
				_data_->_tmp7_ = _data_->checks;
				_data_->_tmp8_ = __ulong_dup0 (&_data_->handle);
				_data_->_tmp9_ = _data_->object;
				_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
				g_hash_table_insert (_data_->_tmp7_, _data_->_tmp8_, _data_->_tmp10_);
			}
		}
		(_data_->object_collection == NULL) ? NULL : (_data_->object_collection = (g_list_free (_data_->object_collection), NULL));
	}
	_data_->_tmp11_ = _data_->self->priv->_session;
	if (_data_->_tmp11_ == NULL) {
		_data_->options = seahorse_pkcs11_token_calculate_session_options (_data_->self);
		_data_->_tmp13_ = _data_->self->priv->_slot;
		_data_->_state_ = 1;
		gck_slot_open_session_async (_data_->_tmp13_, _data_->options, _data_->cancellable, seahorse_pkcs11_token_load_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp14_ = gck_slot_open_session_finish (_data_->_tmp13_, _data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp12_ = _data_->_tmp14_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_hash_table_unref0 (_data_->checks);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp15_ = _data_->_tmp12_;
		_data_->_tmp12_ = NULL;
		_g_object_unref0 (_data_->self->priv->_session);
		_data_->self->priv->_session = _data_->_tmp15_;
		_g_object_unref0 (_data_->_tmp12_);
	}
	_data_->_tmp16_ = gck_builder_new (GCK_BUILDER_NONE);
	_data_->builder = _data_->_tmp16_;
	_data_->_tmp17_ = _data_->builder;
	gck_builder_add_boolean (_data_->_tmp17_, CKA_TOKEN, TRUE);
	_data_->_tmp18_ = _data_->builder;
	gck_builder_add_ulong (_data_->_tmp18_, CKA_CLASS, CKO_CERTIFICATE);
	_data_->_tmp19_ = _data_->self->priv->_session;
	_data_->_tmp20_ = _data_->builder;
	_data_->_tmp21_ = gck_builder_end (_data_->_tmp20_);
	_data_->_tmp22_ = gck_session_enumerate_objects (_data_->_tmp19_, _data_->_tmp21_);
	_data_->enumerator = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->enumerator;
	gck_enumerator_set_object_type_full (_data_->_tmp23_, SEAHORSE_PKCS11_TYPE_CERTIFICATE, CERTIFICATE_ATTRS, (gint) G_N_ELEMENTS (CERTIFICATE_ATTRS));
	_data_->_tmp24_ = gck_builder_new (GCK_BUILDER_NONE);
	__vala_GckBuilder_free0 (_data_->builder);
	_data_->builder = _data_->_tmp24_;
	_data_->_tmp25_ = _data_->builder;
	gck_builder_add_boolean (_data_->_tmp25_, CKA_TOKEN, TRUE);
	_data_->_tmp26_ = _data_->builder;
	gck_builder_add_ulong (_data_->_tmp26_, CKA_CLASS, CKO_PRIVATE_KEY);
	_data_->_tmp27_ = _data_->self->priv->_session;
	_data_->_tmp28_ = _data_->builder;
	_data_->_tmp29_ = gck_builder_end (_data_->_tmp28_);
	_data_->_tmp30_ = gck_session_enumerate_objects (_data_->_tmp27_, _data_->_tmp29_);
	_data_->chained = _data_->_tmp30_;
	_data_->_tmp31_ = _data_->chained;
	gck_enumerator_set_object_type_full (_data_->_tmp31_, SEAHORSE_PKCS11_TYPE_PRIVATE_KEY, KEY_ATTRS, (gint) G_N_ELEMENTS (KEY_ATTRS));
	_data_->_tmp32_ = _data_->enumerator;
	_data_->_tmp33_ = _data_->chained;
	gck_enumerator_set_chained (_data_->_tmp32_, _data_->_tmp33_);
	{
		_data_->_tmp34_ = TRUE;
		while (TRUE) {
			if (!_data_->_tmp34_) {
			}
			_data_->_tmp34_ = FALSE;
			_data_->_tmp35_ = _data_->enumerator;
			_data_->_state_ = 2;
			gck_enumerator_next_async (_data_->_tmp35_, 16, _data_->cancellable, seahorse_pkcs11_token_load_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp36_ = gck_enumerator_next_finish (_data_->_tmp35_, _data_->_res_, &_data_->_inner_error0_);
			_data_->objects = _data_->_tmp36_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
				_g_object_unref0 (_data_->chained);
				_g_object_unref0 (_data_->enumerator);
				__vala_GckBuilder_free0 (_data_->builder);
				_g_hash_table_unref0 (_data_->checks);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp37_ = _data_->objects;
			if (_data_->_tmp37_ == NULL) {
				_data_->_tmp38_ = _data_->checks;
				_data_->_tmp39_ = g_hash_table_get_values (_data_->_tmp38_);
				_data_->_tmp40_ = _data_->_tmp39_;
				seahorse_pkcs11_token_remove_objects (_data_->self, _data_->_tmp40_);
				(_data_->_tmp40_ == NULL) ? NULL : (_data_->_tmp40_ = (g_list_free (_data_->_tmp40_), NULL));
				_data_->result = TRUE;
				(_data_->objects == NULL) ? NULL : (_data_->objects = (_g_list_free__g_object_unref0_ (_data_->objects), NULL));
				_g_object_unref0 (_data_->chained);
				_g_object_unref0 (_data_->enumerator);
				__vala_GckBuilder_free0 (_data_->builder);
				_g_hash_table_unref0 (_data_->checks);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp41_ = _data_->objects;
			seahorse_pkcs11_token_receive_objects (_data_->self, _data_->_tmp41_);
			_data_->_tmp42_ = _data_->objects;
			{
				_data_->_vala1_object_collection = _data_->_tmp42_;
				for (_data_->_vala1_object_it = _data_->_vala1_object_collection; _data_->_vala1_object_it != NULL; _data_->_vala1_object_it = _data_->_vala1_object_it->next) {
					_data_->_tmp43_ = _g_object_ref0 ((GckObject*) _data_->_vala1_object_it->data);
					_data_->_vala1_object = _data_->_tmp43_;
					{
						_data_->_tmp44_ = _data_->_vala1_object;
						_data_->_tmp45_ = gck_object_get_handle (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp44_, gck_object_get_type (), GckObject));
						_data_->_tmp46_ = _data_->_tmp45_;
						_data_->_vala1_handle = _data_->_tmp46_;
						_data_->_tmp47_ = _data_->checks;
						g_hash_table_remove (_data_->_tmp47_, &_data_->_vala1_handle);
						_g_object_unref0 (_data_->_vala1_object);
					}
				}
			}
			(_data_->objects == NULL) ? NULL : (_data_->objects = (_g_list_free__g_object_unref0_ (_data_->objects), NULL));
		}
	}
}

static gboolean
seahorse_pkcs11_token_real_get_unlockable (SeahorseLockable* base)
{
	gboolean result;
	SeahorsePkcs11Token* self;
	GckTokenInfo* _tmp0_;
	GckTokenInfo* _tmp1_;
	GckSession* _tmp2_;
	self = (SeahorsePkcs11Token*) base;
	seahorse_pkcs11_token_ensure_token_info (self);
	_tmp0_ = self->priv->_info;
	if ((_tmp0_->flags & CKF_LOGIN_REQUIRED) == ((gulong) 0)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_info;
	if ((_tmp1_->flags & CKF_USER_PIN_INITIALIZED) == ((gulong) 0)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_session;
	result = !seahorse_pkcs11_token_is_session_logged_in (_tmp2_);
	return result;
}

static gboolean
seahorse_pkcs11_token_real_get_lockable (SeahorseLockable* base)
{
	gboolean result;
	SeahorsePkcs11Token* self;
	GckTokenInfo* _tmp0_;
	GckTokenInfo* _tmp1_;
	GckSession* _tmp2_;
	self = (SeahorsePkcs11Token*) base;
	seahorse_pkcs11_token_ensure_token_info (self);
	_tmp0_ = self->priv->_info;
	if ((_tmp0_->flags & CKF_LOGIN_REQUIRED) == ((gulong) 0)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_info;
	if ((_tmp1_->flags & CKF_USER_PIN_INITIALIZED) == ((gulong) 0)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->_session;
	result = seahorse_pkcs11_token_is_session_logged_in (_tmp2_);
	return result;
}

GckTokenInfo*
seahorse_pkcs11_token_get_info (SeahorsePkcs11Token* self)
{
	GckTokenInfo* result;
	GckTokenInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = seahorse_pkcs11_token_ensure_token_info (self);
	result = _tmp0_;
	return result;
}

GckSession*
seahorse_pkcs11_token_get_session (SeahorsePkcs11Token* self)
{
	GckSession* result;
	GckSession* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_session;
	result = _tmp0_;
	return result;
}

void
seahorse_pkcs11_token_set_session (SeahorsePkcs11Token* self,
                                   GckSession* value)
{
	GckSession* _tmp0_;
	GckSession* _tmp1_;
	GckSession* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = seahorse_pkcs11_token_get_session (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_session);
	self->priv->_session = _tmp2_;
	g_object_notify ((GObject*) self, "session");
	g_object_notify ((GObject*) self, "lockable");
	g_object_notify ((GObject*) self, "unlockable");
	g_object_notify_by_pspec ((GObject *) self, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_SESSION_PROPERTY]);
}

GckSlot*
seahorse_pkcs11_token_get_slot (SeahorsePkcs11Token* self)
{
	GckSlot* result;
	GckSlot* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_slot;
	result = _tmp0_;
	return result;
}

static void
seahorse_pkcs11_token_set_slot (SeahorsePkcs11Token* self,
                                GckSlot* value)
{
	GckSlot* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_slot);
	self->priv->_slot = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_SLOT_PROPERTY]);
}

static gchar*
seahorse_pkcs11_token_real_get_label (SeahorsePlace* base)
{
	gchar* result;
	SeahorsePkcs11Token* self;
	GckTokenInfo* token = NULL;
	GckSlot* _tmp0_;
	GckTokenInfo* _tmp1_;
	GckTokenInfo* _tmp2_;
	GckTokenInfo* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	self = (SeahorsePkcs11Token*) base;
	_tmp0_ = self->priv->_slot;
	_tmp1_ = gck_slot_get_token_info (_tmp0_);
	token = _tmp1_;
	_tmp2_ = token;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (C_ ("Label", "Unknown"));
		result = _tmp3_;
		__vala_GckTokenInfo_free0 (token);
		return result;
	}
	_tmp4_ = token;
	_tmp5_ = _tmp4_->label;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	__vala_GckTokenInfo_free0 (token);
	return result;
}

static void
seahorse_pkcs11_token_real_set_label (SeahorsePlace* base,
                                      const gchar* value)
{
	SeahorsePkcs11Token* self;
	self = (SeahorsePkcs11Token*) base;
	g_object_notify_by_pspec ((GObject *) self, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_LABEL_PROPERTY]);
}

static gchar*
seahorse_pkcs11_token_real_get_description (SeahorsePlace* base)
{
	gchar* result;
	SeahorsePkcs11Token* self;
	GckTokenInfo* token = NULL;
	GckSlot* _tmp0_;
	GckTokenInfo* _tmp1_;
	GckTokenInfo* _tmp2_;
	GckTokenInfo* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	self = (SeahorsePkcs11Token*) base;
	_tmp0_ = self->priv->_slot;
	_tmp1_ = gck_slot_get_token_info (_tmp0_);
	token = _tmp1_;
	_tmp2_ = token;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		__vala_GckTokenInfo_free0 (token);
		return result;
	}
	_tmp4_ = token;
	_tmp5_ = _tmp4_->manufacturer_id;
	_tmp6_ = g_strdup (_tmp5_);
	result = _tmp6_;
	__vala_GckTokenInfo_free0 (token);
	return result;
}

static gchar*
seahorse_pkcs11_token_real_get_uri (SeahorsePlace* base)
{
	gchar* result;
	SeahorsePkcs11Token* self;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SeahorsePkcs11Token*) base;
	_tmp0_ = self->priv->_uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

static GIcon*
seahorse_pkcs11_token_real_get_icon (SeahorsePlace* base)
{
	GIcon* result;
	SeahorsePkcs11Token* self;
	GckTokenInfo* token = NULL;
	GckSlot* _tmp0_;
	GckTokenInfo* _tmp1_;
	GckTokenInfo* _tmp2_;
	GckTokenInfo* _tmp4_;
	GIcon* _tmp5_;
	self = (SeahorsePkcs11Token*) base;
	_tmp0_ = self->priv->_slot;
	_tmp1_ = gck_slot_get_token_info (_tmp0_);
	token = _tmp1_;
	_tmp2_ = token;
	if (_tmp2_ == NULL) {
		GThemedIcon* _tmp3_;
		_tmp3_ = (GThemedIcon*) g_themed_icon_new ("dialog-question");
		result = (GIcon*) _tmp3_;
		__vala_GckTokenInfo_free0 (token);
		return result;
	}
	_tmp4_ = token;
	_tmp5_ = gcr_icon_for_token (_tmp4_);
	result = _tmp5_;
	__vala_GckTokenInfo_free0 (token);
	return result;
}

static SeahorsePlaceCategory
seahorse_pkcs11_token_real_get_category (SeahorsePlace* base)
{
	SeahorsePlaceCategory result;
	SeahorsePkcs11Token* self;
	self = (SeahorsePkcs11Token*) base;
	result = SEAHORSE_PLACE_CATEGORY_CERTIFICATES;
	return result;
}

static GActionGroup*
seahorse_pkcs11_token_real_get_actions (SeahorsePlace* base)
{
	GActionGroup* result;
	SeahorsePkcs11Token* self;
	self = (SeahorsePkcs11Token*) base;
	result = NULL;
	return result;
}

static const gchar*
seahorse_pkcs11_token_real_get_action_prefix (SeahorsePlace* base)
{
	const gchar* result;
	SeahorsePkcs11Token* self;
	self = (SeahorsePkcs11Token*) base;
	result = NULL;
	return result;
}

static GMenuModel*
seahorse_pkcs11_token_real_get_menu_model (SeahorsePlace* base)
{
	GMenuModel* result;
	SeahorsePkcs11Token* self;
	self = (SeahorsePkcs11Token*) base;
	result = NULL;
	return result;
}

SeahorseFlags
seahorse_pkcs11_token_get_object_flags (SeahorsePkcs11Token* self)
{
	SeahorseFlags result;
	g_return_val_if_fail (self != NULL, 0U);
	result = 0;
	return result;
}

static gboolean
seahorse_pkcs11_token_real_get_show_if_empty (SeahorsePlace* base)
{
	gboolean result;
	SeahorsePkcs11Token* self;
	self = (SeahorsePkcs11Token*) base;
	result = FALSE;
	return result;
}

GArray*
seahorse_pkcs11_token_get_mechanisms (SeahorsePkcs11Token* self)
{
	GArray* result;
	GArray* _tmp0_;
	GArray* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mechanisms;
	if (_tmp0_ == NULL) {
		GckSlot* _tmp1_;
		GArray* _tmp2_;
		_tmp1_ = self->priv->_slot;
		_tmp2_ = gck_slot_get_mechanisms (_tmp1_);
		_g_array_unref0 (self->priv->_mechanisms);
		self->priv->_mechanisms = _tmp2_;
	}
	_tmp3_ = self->priv->_mechanisms;
	result = _tmp3_;
	return result;
}

static guint
_gck_attribute_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = gck_attribute_hash (key);
	return result;
}

static gboolean
_gck_attribute_equal_gequal_func (gconstpointer a,
                                  gconstpointer b)
{
	gboolean result;
	result = gck_attribute_equal (a, (GckAttribute*) b);
	return result;
}

static void
__vala_GckAttribute_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GckAttribute_free (var), NULL));
}

static void
_g_ptr_array_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL));
}

static void
_vala_GckUriData_free (GckUriData* self)
{
	g_boxed_free (gck_uri_data_get_type (), self);
}

static GObject *
seahorse_pkcs11_token_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SeahorsePkcs11Token * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	GckUriData* data = NULL;
	GckUriData* _tmp10_;
	GckUriData* _tmp11_;
	GckTokenInfo* _tmp12_;
	GckTokenInfo* _tmp13_;
	GckUriData* _tmp14_;
	gchar* _tmp15_;
	parent_class = G_OBJECT_CLASS (seahorse_pkcs11_token_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_TOKEN, SeahorsePkcs11Token);
	_tmp0_ = seahorse_ulong_hash;
	_tmp1_ = seahorse_ulong_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_object_for_handle);
	self->priv->_object_for_handle = _tmp2_;
	_tmp3_ = g_hash_table_new_full (_gck_attribute_hash_ghash_func, _gck_attribute_equal_gequal_func, __vala_GckAttribute_free0_, _g_ptr_array_unref0_);
	_g_hash_table_unref0 (self->priv->_objects_for_id);
	self->priv->_objects_for_id = _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_object_unref0_, NULL);
	_g_hash_table_unref0 (self->priv->_id_for_object);
	self->priv->_id_for_object = _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_objects_visible);
	self->priv->_objects_visible = _tmp9_;
	seahorse_place_load ((SeahorsePlace*) self, NULL, NULL, NULL);
	_tmp10_ = gck_uri_data_new ();
	data = _tmp10_;
	seahorse_pkcs11_token_ensure_token_info (self);
	_tmp11_ = data;
	_tmp12_ = self->priv->_info;
	_tmp13_ = __vala_GckTokenInfo_copy0 (_tmp12_);
	__vala_GckTokenInfo_free0 (_tmp11_->token_info);
	_tmp11_->token_info = _tmp13_;
	_tmp14_ = data;
	_tmp15_ = gck_uri_build (_tmp14_, GCK_URI_FOR_TOKEN);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp15_;
	__vala_GckUriData_free0 (data);
	return obj;
}

static void
seahorse_pkcs11_token_class_init (SeahorsePkcs11TokenClass * klass,
                                  gpointer klass_data)
{
	seahorse_pkcs11_token_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SeahorsePkcs11Token_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) seahorse_pkcs11_token_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_seahorse_pkcs11_token_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_seahorse_pkcs11_token_set_property;
	G_OBJECT_CLASS (klass)->constructor = seahorse_pkcs11_token_constructor;
	G_OBJECT_CLASS (klass)->finalize = seahorse_pkcs11_token_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_UNLOCKABLE_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_UNLOCKABLE_PROPERTY] = g_param_spec_boolean ("unlockable", "unlockable", "unlockable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_LOCKABLE_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_LOCKABLE_PROPERTY] = g_param_spec_boolean ("lockable", "lockable", "lockable", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_INFO_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_INFO_PROPERTY] = g_param_spec_boxed ("info", "info", "info", gck_token_info_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_SESSION_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_SESSION_PROPERTY] = g_param_spec_object ("session", "session", "session", gck_session_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_SLOT_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_SLOT_PROPERTY] = g_param_spec_object ("slot", "slot", "slot", gck_slot_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_LABEL_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_LABEL_PROPERTY] = g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_DESCRIPTION_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_DESCRIPTION_PROPERTY] = g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_URI_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_ICON_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_ICON_PROPERTY] = g_param_spec_object ("icon", "icon", "icon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_CATEGORY_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_CATEGORY_PROPERTY] = g_param_spec_enum ("category", "category", "category", SEAHORSE_PLACE_TYPE_CATEGORY, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_ACTIONS_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_ACTIONS_PROPERTY] = g_param_spec_object ("actions", "actions", "actions", g_action_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_ACTION_PREFIX_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_ACTION_PREFIX_PROPERTY] = g_param_spec_string ("action-prefix", "action-prefix", "action-prefix", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_MENU_MODEL_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_MENU_MODEL_PROPERTY] = g_param_spec_object ("menu-model", "menu-model", "menu-model", g_menu_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_OBJECT_FLAGS_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_OBJECT_FLAGS_PROPERTY] = g_param_spec_flags ("object-flags", "object-flags", "object-flags", SEAHORSE_TYPE_FLAGS, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_SHOW_IF_EMPTY_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_SHOW_IF_EMPTY_PROPERTY] = g_param_spec_boolean ("show-if-empty", "show-if-empty", "show-if-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SEAHORSE_PKCS11_TOKEN_MECHANISMS_PROPERTY, seahorse_pkcs11_token_properties[SEAHORSE_PKCS11_TOKEN_MECHANISMS_PROPERTY] = g_param_spec_boxed ("mechanisms", "mechanisms", "mechanisms", G_TYPE_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
seahorse_pkcs11_token_gcr_collection_interface_init (GcrCollectionIface * iface,
                                                     gpointer iface_data)
{
	seahorse_pkcs11_token_gcr_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->contains = (gboolean (*) (GcrCollection*, GObject*)) seahorse_pkcs11_token_real_contains;
	iface->get_length = (guint (*) (GcrCollection*)) seahorse_pkcs11_token_real_get_length;
	iface->get_objects = (GList* (*) (GcrCollection*)) seahorse_pkcs11_token_real_get_objects;
}

static void
seahorse_pkcs11_token_seahorse_place_interface_init (SeahorsePlaceIface * iface,
                                                     gpointer iface_data)
{
	seahorse_pkcs11_token_seahorse_place_parent_iface = g_type_interface_peek_parent (iface);
	iface->load = (void (*) (SeahorsePlace*, GCancellable*, GAsyncReadyCallback, gpointer)) seahorse_pkcs11_token_real_load;
	iface->load_finish = (gboolean (*) (SeahorsePlace*, GAsyncResult*, GError**)) seahorse_pkcs11_token_load_finish;
	iface->get_label = seahorse_pkcs11_token_real_get_label;
	iface->set_label = seahorse_pkcs11_token_real_set_label;
	iface->get_description = seahorse_pkcs11_token_real_get_description;
	iface->get_uri = seahorse_pkcs11_token_real_get_uri;
	iface->get_icon = seahorse_pkcs11_token_real_get_icon;
	iface->get_category = seahorse_pkcs11_token_real_get_category;
	iface->get_actions = seahorse_pkcs11_token_real_get_actions;
	iface->get_action_prefix = seahorse_pkcs11_token_real_get_action_prefix;
	iface->get_menu_model = seahorse_pkcs11_token_real_get_menu_model;
	iface->get_show_if_empty = seahorse_pkcs11_token_real_get_show_if_empty;
}

static void
seahorse_pkcs11_token_seahorse_lockable_interface_init (SeahorseLockableIface * iface,
                                                        gpointer iface_data)
{
	seahorse_pkcs11_token_seahorse_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->lock = (void (*) (SeahorseLockable*, GTlsInteraction*, GCancellable*, GAsyncReadyCallback, gpointer)) seahorse_pkcs11_token_real_lock;
	iface->lock_finish = (gboolean (*) (SeahorseLockable*, GAsyncResult*, GError**)) seahorse_pkcs11_token_lock_finish;
	iface->unlock = (void (*) (SeahorseLockable*, GTlsInteraction*, GCancellable*, GAsyncReadyCallback, gpointer)) seahorse_pkcs11_token_real_unlock;
	iface->unlock_finish = (gboolean (*) (SeahorseLockable*, GAsyncResult*, GError**)) seahorse_pkcs11_token_unlock_finish;
	iface->get_unlockable = seahorse_pkcs11_token_real_get_unlockable;
	iface->get_lockable = seahorse_pkcs11_token_real_get_lockable;
}

static void
seahorse_pkcs11_token_instance_init (SeahorsePkcs11Token * self,
                                     gpointer klass)
{
	self->priv = seahorse_pkcs11_token_get_instance_private (self);
}

static void
seahorse_pkcs11_token_finalize (GObject * obj)
{
	SeahorsePkcs11Token * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SEAHORSE_PKCS11_TYPE_TOKEN, SeahorsePkcs11Token);
	_g_object_unref0 (self->priv->_slot);
	_g_free0 (self->priv->_uri);
	__vala_GckTokenInfo_free0 (self->priv->_info);
	_g_array_unref0 (self->priv->_mechanisms);
	_g_object_unref0 (self->priv->_session);
	_g_hash_table_unref0 (self->priv->_object_for_handle);
	_g_hash_table_unref0 (self->priv->_objects_for_id);
	_g_hash_table_unref0 (self->priv->_id_for_object);
	_g_hash_table_unref0 (self->priv->_objects_visible);
	G_OBJECT_CLASS (seahorse_pkcs11_token_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
seahorse_pkcs11_token_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SeahorsePkcs11TokenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) seahorse_pkcs11_token_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SeahorsePkcs11Token), 0, (GInstanceInitFunc) seahorse_pkcs11_token_instance_init, NULL };
	static const GInterfaceInfo gcr_collection_info = { (GInterfaceInitFunc) seahorse_pkcs11_token_gcr_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_place_info = { (GInterfaceInitFunc) seahorse_pkcs11_token_seahorse_place_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo seahorse_lockable_info = { (GInterfaceInitFunc) seahorse_pkcs11_token_seahorse_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType seahorse_pkcs11_token_type_id;
	seahorse_pkcs11_token_type_id = g_type_register_static (G_TYPE_OBJECT, "SeahorsePkcs11Token", &g_define_type_info, 0);
	g_type_add_interface_static (seahorse_pkcs11_token_type_id, gcr_collection_get_type (), &gcr_collection_info);
	g_type_add_interface_static (seahorse_pkcs11_token_type_id, SEAHORSE_TYPE_PLACE, &seahorse_place_info);
	g_type_add_interface_static (seahorse_pkcs11_token_type_id, SEAHORSE_TYPE_LOCKABLE, &seahorse_lockable_info);
	SeahorsePkcs11Token_private_offset = g_type_add_instance_private (seahorse_pkcs11_token_type_id, sizeof (SeahorsePkcs11TokenPrivate));
	return seahorse_pkcs11_token_type_id;
}

GType
seahorse_pkcs11_token_get_type (void)
{
	static volatile gsize seahorse_pkcs11_token_type_id__once = 0;
	if (g_once_init_enter (&seahorse_pkcs11_token_type_id__once)) {
		GType seahorse_pkcs11_token_type_id;
		seahorse_pkcs11_token_type_id = seahorse_pkcs11_token_get_type_once ();
		g_once_init_leave (&seahorse_pkcs11_token_type_id__once, seahorse_pkcs11_token_type_id);
	}
	return seahorse_pkcs11_token_type_id__once;
}

static void
_vala_seahorse_pkcs11_token_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	SeahorsePkcs11Token * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_TOKEN, SeahorsePkcs11Token);
	switch (property_id) {
		case SEAHORSE_PKCS11_TOKEN_UNLOCKABLE_PROPERTY:
		g_value_set_boolean (value, seahorse_lockable_get_unlockable ((SeahorseLockable*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_LOCKABLE_PROPERTY:
		g_value_set_boolean (value, seahorse_lockable_get_lockable ((SeahorseLockable*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_INFO_PROPERTY:
		g_value_set_boxed (value, seahorse_pkcs11_token_get_info (self));
		break;
		case SEAHORSE_PKCS11_TOKEN_SESSION_PROPERTY:
		g_value_set_object (value, seahorse_pkcs11_token_get_session (self));
		break;
		case SEAHORSE_PKCS11_TOKEN_SLOT_PROPERTY:
		g_value_set_object (value, seahorse_pkcs11_token_get_slot (self));
		break;
		case SEAHORSE_PKCS11_TOKEN_LABEL_PROPERTY:
		g_value_take_string (value, seahorse_place_get_label ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_DESCRIPTION_PROPERTY:
		g_value_take_string (value, seahorse_place_get_description ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_URI_PROPERTY:
		g_value_take_string (value, seahorse_place_get_uri ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_ICON_PROPERTY:
		g_value_take_object (value, seahorse_place_get_icon ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_CATEGORY_PROPERTY:
		g_value_set_enum (value, seahorse_place_get_category ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_ACTIONS_PROPERTY:
		g_value_take_object (value, seahorse_place_get_actions ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_ACTION_PREFIX_PROPERTY:
		g_value_set_string (value, seahorse_place_get_action_prefix ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_MENU_MODEL_PROPERTY:
		g_value_take_object (value, seahorse_place_get_menu_model ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_OBJECT_FLAGS_PROPERTY:
		g_value_set_flags (value, seahorse_pkcs11_token_get_object_flags (self));
		break;
		case SEAHORSE_PKCS11_TOKEN_SHOW_IF_EMPTY_PROPERTY:
		g_value_set_boolean (value, seahorse_place_get_show_if_empty ((SeahorsePlace*) self));
		break;
		case SEAHORSE_PKCS11_TOKEN_MECHANISMS_PROPERTY:
		g_value_set_boxed (value, seahorse_pkcs11_token_get_mechanisms (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_seahorse_pkcs11_token_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	SeahorsePkcs11Token * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SEAHORSE_PKCS11_TYPE_TOKEN, SeahorsePkcs11Token);
	switch (property_id) {
		case SEAHORSE_PKCS11_TOKEN_SESSION_PROPERTY:
		seahorse_pkcs11_token_set_session (self, g_value_get_object (value));
		break;
		case SEAHORSE_PKCS11_TOKEN_SLOT_PROPERTY:
		seahorse_pkcs11_token_set_slot (self, g_value_get_object (value));
		break;
		case SEAHORSE_PKCS11_TOKEN_LABEL_PROPERTY:
		seahorse_place_set_label ((SeahorsePlace*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

